// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateChannelOutput {
    /// <p>Object specifying a channel.</p>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl UpdateChannelOutput {
    /// <p>Object specifying a channel.</p>
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
}
impl std::fmt::Debug for UpdateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
pub mod update_channel_output {
    /// A builder for [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p>Object specifying a channel.</p>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>Object specifying a channel.</p>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
        pub fn build(self) -> crate::output::UpdateChannelOutput {
            crate::output::UpdateChannelOutput {
                channel: self.channel,
            }
        }
    }
}
impl UpdateChannelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)
    pub fn builder() -> crate::output::update_channel_output::Builder {
        crate::output::update_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopStreamOutput {}
impl std::fmt::Debug for StopStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopStreamOutput");
        formatter.finish()
    }
}
/// See [`StopStreamOutput`](crate::output::StopStreamOutput)
pub mod stop_stream_output {
    /// A builder for [`StopStreamOutput`](crate::output::StopStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopStreamOutput`](crate::output::StopStreamOutput)
        pub fn build(self) -> crate::output::StopStreamOutput {
            crate::output::StopStreamOutput {}
        }
    }
}
impl StopStreamOutput {
    /// Creates a new builder-style object to manufacture [`StopStreamOutput`](crate::output::StopStreamOutput)
    pub fn builder() -> crate::output::stop_stream_output::Builder {
        crate::output::stop_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMetadataOutput {}
impl std::fmt::Debug for PutMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMetadataOutput");
        formatter.finish()
    }
}
/// See [`PutMetadataOutput`](crate::output::PutMetadataOutput)
pub mod put_metadata_output {
    /// A builder for [`PutMetadataOutput`](crate::output::PutMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutMetadataOutput`](crate::output::PutMetadataOutput)
        pub fn build(self) -> crate::output::PutMetadataOutput {
            crate::output::PutMetadataOutput {}
        }
    }
}
impl PutMetadataOutput {
    /// Creates a new builder-style object to manufacture [`PutMetadataOutput`](crate::output::PutMetadataOutput)
    pub fn builder() -> crate::output::put_metadata_output::Builder {
        crate::output::put_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p/>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p/>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p/>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p/>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamsOutput {
    /// <p>List of streams.</p>
    pub streams: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
    /// <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the
    /// request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStreamsOutput {
    /// <p>List of streams.</p>
    pub fn streams(&self) -> std::option::Option<&[crate::model::StreamSummary]> {
        self.streams.as_deref()
    }
    /// <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the
    /// request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStreamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamsOutput");
        formatter.field("streams", &self.streams);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStreamsOutput`](crate::output::ListStreamsOutput)
pub mod list_streams_output {
    /// A builder for [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streams: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `streams`.
        ///
        /// To override the contents of this collection use [`set_streams`](Self::set_streams).
        ///
        /// <p>List of streams.</p>
        pub fn streams(mut self, input: impl Into<crate::model::StreamSummary>) -> Self {
            let mut v = self.streams.unwrap_or_default();
            v.push(input.into());
            self.streams = Some(v);
            self
        }
        /// <p>List of streams.</p>
        pub fn set_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
        ) -> Self {
            self.streams = input;
            self
        }
        /// <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the
        /// request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the
        /// request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamsOutput`](crate::output::ListStreamsOutput)
        pub fn build(self) -> crate::output::ListStreamsOutput {
            crate::output::ListStreamsOutput {
                streams: self.streams,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStreamsOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    pub fn builder() -> crate::output::list_streams_output::Builder {
        crate::output::list_streams_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamKeysOutput {
    /// <p>List of stream keys.</p>
    pub stream_keys: std::option::Option<std::vec::Vec<crate::model::StreamKeySummary>>,
    /// <p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in
    /// the request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStreamKeysOutput {
    /// <p>List of stream keys.</p>
    pub fn stream_keys(&self) -> std::option::Option<&[crate::model::StreamKeySummary]> {
        self.stream_keys.as_deref()
    }
    /// <p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in
    /// the request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStreamKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamKeysOutput");
        formatter.field("stream_keys", &self.stream_keys);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStreamKeysOutput`](crate::output::ListStreamKeysOutput)
pub mod list_stream_keys_output {
    /// A builder for [`ListStreamKeysOutput`](crate::output::ListStreamKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_keys: std::option::Option<std::vec::Vec<crate::model::StreamKeySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `stream_keys`.
        ///
        /// To override the contents of this collection use [`set_stream_keys`](Self::set_stream_keys).
        ///
        /// <p>List of stream keys.</p>
        pub fn stream_keys(mut self, input: impl Into<crate::model::StreamKeySummary>) -> Self {
            let mut v = self.stream_keys.unwrap_or_default();
            v.push(input.into());
            self.stream_keys = Some(v);
            self
        }
        /// <p>List of stream keys.</p>
        pub fn set_stream_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamKeySummary>>,
        ) -> Self {
            self.stream_keys = input;
            self
        }
        /// <p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in
        /// the request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in
        /// the request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamKeysOutput`](crate::output::ListStreamKeysOutput)
        pub fn build(self) -> crate::output::ListStreamKeysOutput {
            crate::output::ListStreamKeysOutput {
                stream_keys: self.stream_keys,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStreamKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamKeysOutput`](crate::output::ListStreamKeysOutput)
    pub fn builder() -> crate::output::list_stream_keys_output::Builder {
        crate::output::list_stream_keys_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecordingConfigurationsOutput {
    /// <p>List of the matching recording configurations.</p>
    pub recording_configurations:
        std::option::Option<std::vec::Vec<crate::model::RecordingConfigurationSummary>>,
    /// <p>If there are more recording configurations than <code>maxResults</code>, use
    /// <code>nextToken</code> in the request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRecordingConfigurationsOutput {
    /// <p>List of the matching recording configurations.</p>
    pub fn recording_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::RecordingConfigurationSummary]> {
        self.recording_configurations.as_deref()
    }
    /// <p>If there are more recording configurations than <code>maxResults</code>, use
    /// <code>nextToken</code> in the request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecordingConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecordingConfigurationsOutput");
        formatter.field("recording_configurations", &self.recording_configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRecordingConfigurationsOutput`](crate::output::ListRecordingConfigurationsOutput)
pub mod list_recording_configurations_output {
    /// A builder for [`ListRecordingConfigurationsOutput`](crate::output::ListRecordingConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recording_configurations:
            std::option::Option<std::vec::Vec<crate::model::RecordingConfigurationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recording_configurations`.
        ///
        /// To override the contents of this collection use [`set_recording_configurations`](Self::set_recording_configurations).
        ///
        /// <p>List of the matching recording configurations.</p>
        pub fn recording_configurations(
            mut self,
            input: impl Into<crate::model::RecordingConfigurationSummary>,
        ) -> Self {
            let mut v = self.recording_configurations.unwrap_or_default();
            v.push(input.into());
            self.recording_configurations = Some(v);
            self
        }
        /// <p>List of the matching recording configurations.</p>
        pub fn set_recording_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecordingConfigurationSummary>>,
        ) -> Self {
            self.recording_configurations = input;
            self
        }
        /// <p>If there are more recording configurations than <code>maxResults</code>, use
        /// <code>nextToken</code> in the request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more recording configurations than <code>maxResults</code>, use
        /// <code>nextToken</code> in the request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecordingConfigurationsOutput`](crate::output::ListRecordingConfigurationsOutput)
        pub fn build(self) -> crate::output::ListRecordingConfigurationsOutput {
            crate::output::ListRecordingConfigurationsOutput {
                recording_configurations: self.recording_configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRecordingConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListRecordingConfigurationsOutput`](crate::output::ListRecordingConfigurationsOutput)
    pub fn builder() -> crate::output::list_recording_configurations_output::Builder {
        crate::output::list_recording_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlaybackKeyPairsOutput {
    /// <p>List of key pairs.</p>
    pub key_pairs: std::option::Option<std::vec::Vec<crate::model::PlaybackKeyPairSummary>>,
    /// <p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in
    /// the request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlaybackKeyPairsOutput {
    /// <p>List of key pairs.</p>
    pub fn key_pairs(&self) -> std::option::Option<&[crate::model::PlaybackKeyPairSummary]> {
        self.key_pairs.as_deref()
    }
    /// <p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in
    /// the request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlaybackKeyPairsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlaybackKeyPairsOutput");
        formatter.field("key_pairs", &self.key_pairs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPlaybackKeyPairsOutput`](crate::output::ListPlaybackKeyPairsOutput)
pub mod list_playback_key_pairs_output {
    /// A builder for [`ListPlaybackKeyPairsOutput`](crate::output::ListPlaybackKeyPairsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pairs:
            std::option::Option<std::vec::Vec<crate::model::PlaybackKeyPairSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `key_pairs`.
        ///
        /// To override the contents of this collection use [`set_key_pairs`](Self::set_key_pairs).
        ///
        /// <p>List of key pairs.</p>
        pub fn key_pairs(mut self, input: impl Into<crate::model::PlaybackKeyPairSummary>) -> Self {
            let mut v = self.key_pairs.unwrap_or_default();
            v.push(input.into());
            self.key_pairs = Some(v);
            self
        }
        /// <p>List of key pairs.</p>
        pub fn set_key_pairs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlaybackKeyPairSummary>>,
        ) -> Self {
            self.key_pairs = input;
            self
        }
        /// <p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in
        /// the request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in
        /// the request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlaybackKeyPairsOutput`](crate::output::ListPlaybackKeyPairsOutput)
        pub fn build(self) -> crate::output::ListPlaybackKeyPairsOutput {
            crate::output::ListPlaybackKeyPairsOutput {
                key_pairs: self.key_pairs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPlaybackKeyPairsOutput {
    /// Creates a new builder-style object to manufacture [`ListPlaybackKeyPairsOutput`](crate::output::ListPlaybackKeyPairsOutput)
    pub fn builder() -> crate::output::list_playback_key_pairs_output::Builder {
        crate::output::list_playback_key_pairs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChannelsOutput {
    /// <p>List of the matching channels.</p>
    pub channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
    /// <p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the
    /// request to get the next set.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChannelsOutput {
    /// <p>List of the matching channels.</p>
    pub fn channels(&self) -> std::option::Option<&[crate::model::ChannelSummary]> {
        self.channels.as_deref()
    }
    /// <p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the
    /// request to get the next set.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChannelsOutput");
        formatter.field("channels", &self.channels);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListChannelsOutput`](crate::output::ListChannelsOutput)
pub mod list_channels_output {
    /// A builder for [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p>List of the matching channels.</p>
        pub fn channels(mut self, input: impl Into<crate::model::ChannelSummary>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p>List of the matching channels.</p>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelSummary>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// <p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the
        /// request to get the next set.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the
        /// request to get the next set.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChannelsOutput`](crate::output::ListChannelsOutput)
        pub fn build(self) -> crate::output::ListChannelsOutput {
            crate::output::ListChannelsOutput {
                channels: self.channels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListChannelsOutput {
    /// Creates a new builder-style object to manufacture [`ListChannelsOutput`](crate::output::ListChannelsOutput)
    pub fn builder() -> crate::output::list_channels_output::Builder {
        crate::output::list_channels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportPlaybackKeyPairOutput {
    /// <p/>
    pub key_pair: std::option::Option<crate::model::PlaybackKeyPair>,
}
impl ImportPlaybackKeyPairOutput {
    /// <p/>
    pub fn key_pair(&self) -> std::option::Option<&crate::model::PlaybackKeyPair> {
        self.key_pair.as_ref()
    }
}
impl std::fmt::Debug for ImportPlaybackKeyPairOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportPlaybackKeyPairOutput");
        formatter.field("key_pair", &self.key_pair);
        formatter.finish()
    }
}
/// See [`ImportPlaybackKeyPairOutput`](crate::output::ImportPlaybackKeyPairOutput)
pub mod import_playback_key_pair_output {
    /// A builder for [`ImportPlaybackKeyPairOutput`](crate::output::ImportPlaybackKeyPairOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pair: std::option::Option<crate::model::PlaybackKeyPair>,
    }
    impl Builder {
        /// <p/>
        pub fn key_pair(mut self, input: crate::model::PlaybackKeyPair) -> Self {
            self.key_pair = Some(input);
            self
        }
        /// <p/>
        pub fn set_key_pair(
            mut self,
            input: std::option::Option<crate::model::PlaybackKeyPair>,
        ) -> Self {
            self.key_pair = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportPlaybackKeyPairOutput`](crate::output::ImportPlaybackKeyPairOutput)
        pub fn build(self) -> crate::output::ImportPlaybackKeyPairOutput {
            crate::output::ImportPlaybackKeyPairOutput {
                key_pair: self.key_pair,
            }
        }
    }
}
impl ImportPlaybackKeyPairOutput {
    /// Creates a new builder-style object to manufacture [`ImportPlaybackKeyPairOutput`](crate::output::ImportPlaybackKeyPairOutput)
    pub fn builder() -> crate::output::import_playback_key_pair_output::Builder {
        crate::output::import_playback_key_pair_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamKeyOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub stream_key: std::option::Option<crate::model::StreamKey>,
}
impl GetStreamKeyOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn stream_key(&self) -> std::option::Option<&crate::model::StreamKey> {
        self.stream_key.as_ref()
    }
}
impl std::fmt::Debug for GetStreamKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamKeyOutput");
        formatter.field("stream_key", &self.stream_key);
        formatter.finish()
    }
}
/// See [`GetStreamKeyOutput`](crate::output::GetStreamKeyOutput)
pub mod get_stream_key_output {
    /// A builder for [`GetStreamKeyOutput`](crate::output::GetStreamKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_key: std::option::Option<crate::model::StreamKey>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn stream_key(mut self, input: crate::model::StreamKey) -> Self {
            self.stream_key = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_stream_key(
            mut self,
            input: std::option::Option<crate::model::StreamKey>,
        ) -> Self {
            self.stream_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamKeyOutput`](crate::output::GetStreamKeyOutput)
        pub fn build(self) -> crate::output::GetStreamKeyOutput {
            crate::output::GetStreamKeyOutput {
                stream_key: self.stream_key,
            }
        }
    }
}
impl GetStreamKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetStreamKeyOutput`](crate::output::GetStreamKeyOutput)
    pub fn builder() -> crate::output::get_stream_key_output::Builder {
        crate::output::get_stream_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamOutput {
    /// <p/>
    pub stream: std::option::Option<crate::model::Stream>,
}
impl GetStreamOutput {
    /// <p/>
    pub fn stream(&self) -> std::option::Option<&crate::model::Stream> {
        self.stream.as_ref()
    }
}
impl std::fmt::Debug for GetStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamOutput");
        formatter.field("stream", &self.stream);
        formatter.finish()
    }
}
/// See [`GetStreamOutput`](crate::output::GetStreamOutput)
pub mod get_stream_output {
    /// A builder for [`GetStreamOutput`](crate::output::GetStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream: std::option::Option<crate::model::Stream>,
    }
    impl Builder {
        /// <p/>
        pub fn stream(mut self, input: crate::model::Stream) -> Self {
            self.stream = Some(input);
            self
        }
        /// <p/>
        pub fn set_stream(mut self, input: std::option::Option<crate::model::Stream>) -> Self {
            self.stream = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamOutput`](crate::output::GetStreamOutput)
        pub fn build(self) -> crate::output::GetStreamOutput {
            crate::output::GetStreamOutput {
                stream: self.stream,
            }
        }
    }
}
impl GetStreamOutput {
    /// Creates a new builder-style object to manufacture [`GetStreamOutput`](crate::output::GetStreamOutput)
    pub fn builder() -> crate::output::get_stream_output::Builder {
        crate::output::get_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecordingConfigurationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub recording_configuration: std::option::Option<crate::model::RecordingConfiguration>,
}
impl GetRecordingConfigurationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn recording_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RecordingConfiguration> {
        self.recording_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetRecordingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecordingConfigurationOutput");
        formatter.field("recording_configuration", &self.recording_configuration);
        formatter.finish()
    }
}
/// See [`GetRecordingConfigurationOutput`](crate::output::GetRecordingConfigurationOutput)
pub mod get_recording_configuration_output {
    /// A builder for [`GetRecordingConfigurationOutput`](crate::output::GetRecordingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recording_configuration:
            std::option::Option<crate::model::RecordingConfiguration>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn recording_configuration(
            mut self,
            input: crate::model::RecordingConfiguration,
        ) -> Self {
            self.recording_configuration = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_recording_configuration(
            mut self,
            input: std::option::Option<crate::model::RecordingConfiguration>,
        ) -> Self {
            self.recording_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecordingConfigurationOutput`](crate::output::GetRecordingConfigurationOutput)
        pub fn build(self) -> crate::output::GetRecordingConfigurationOutput {
            crate::output::GetRecordingConfigurationOutput {
                recording_configuration: self.recording_configuration,
            }
        }
    }
}
impl GetRecordingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetRecordingConfigurationOutput`](crate::output::GetRecordingConfigurationOutput)
    pub fn builder() -> crate::output::get_recording_configuration_output::Builder {
        crate::output::get_recording_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPlaybackKeyPairOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub key_pair: std::option::Option<crate::model::PlaybackKeyPair>,
}
impl GetPlaybackKeyPairOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn key_pair(&self) -> std::option::Option<&crate::model::PlaybackKeyPair> {
        self.key_pair.as_ref()
    }
}
impl std::fmt::Debug for GetPlaybackKeyPairOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPlaybackKeyPairOutput");
        formatter.field("key_pair", &self.key_pair);
        formatter.finish()
    }
}
/// See [`GetPlaybackKeyPairOutput`](crate::output::GetPlaybackKeyPairOutput)
pub mod get_playback_key_pair_output {
    /// A builder for [`GetPlaybackKeyPairOutput`](crate::output::GetPlaybackKeyPairOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pair: std::option::Option<crate::model::PlaybackKeyPair>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn key_pair(mut self, input: crate::model::PlaybackKeyPair) -> Self {
            self.key_pair = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_key_pair(
            mut self,
            input: std::option::Option<crate::model::PlaybackKeyPair>,
        ) -> Self {
            self.key_pair = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPlaybackKeyPairOutput`](crate::output::GetPlaybackKeyPairOutput)
        pub fn build(self) -> crate::output::GetPlaybackKeyPairOutput {
            crate::output::GetPlaybackKeyPairOutput {
                key_pair: self.key_pair,
            }
        }
    }
}
impl GetPlaybackKeyPairOutput {
    /// Creates a new builder-style object to manufacture [`GetPlaybackKeyPairOutput`](crate::output::GetPlaybackKeyPairOutput)
    pub fn builder() -> crate::output::get_playback_key_pair_output::Builder {
        crate::output::get_playback_key_pair_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChannelOutput {
    /// <p/>
    pub channel: std::option::Option<crate::model::Channel>,
}
impl GetChannelOutput {
    /// <p/>
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
}
impl std::fmt::Debug for GetChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.finish()
    }
}
/// See [`GetChannelOutput`](crate::output::GetChannelOutput)
pub mod get_channel_output {
    /// A builder for [`GetChannelOutput`](crate::output::GetChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
    }
    impl Builder {
        /// <p/>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p/>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChannelOutput`](crate::output::GetChannelOutput)
        pub fn build(self) -> crate::output::GetChannelOutput {
            crate::output::GetChannelOutput {
                channel: self.channel,
            }
        }
    }
}
impl GetChannelOutput {
    /// Creates a new builder-style object to manufacture [`GetChannelOutput`](crate::output::GetChannelOutput)
    pub fn builder() -> crate::output::get_channel_output::Builder {
        crate::output::get_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamKeyOutput {}
impl std::fmt::Debug for DeleteStreamKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamKeyOutput");
        formatter.finish()
    }
}
/// See [`DeleteStreamKeyOutput`](crate::output::DeleteStreamKeyOutput)
pub mod delete_stream_key_output {
    /// A builder for [`DeleteStreamKeyOutput`](crate::output::DeleteStreamKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStreamKeyOutput`](crate::output::DeleteStreamKeyOutput)
        pub fn build(self) -> crate::output::DeleteStreamKeyOutput {
            crate::output::DeleteStreamKeyOutput {}
        }
    }
}
impl DeleteStreamKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStreamKeyOutput`](crate::output::DeleteStreamKeyOutput)
    pub fn builder() -> crate::output::delete_stream_key_output::Builder {
        crate::output::delete_stream_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecordingConfigurationOutput {}
impl std::fmt::Debug for DeleteRecordingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecordingConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteRecordingConfigurationOutput`](crate::output::DeleteRecordingConfigurationOutput)
pub mod delete_recording_configuration_output {
    /// A builder for [`DeleteRecordingConfigurationOutput`](crate::output::DeleteRecordingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRecordingConfigurationOutput`](crate::output::DeleteRecordingConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteRecordingConfigurationOutput {
            crate::output::DeleteRecordingConfigurationOutput {}
        }
    }
}
impl DeleteRecordingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecordingConfigurationOutput`](crate::output::DeleteRecordingConfigurationOutput)
    pub fn builder() -> crate::output::delete_recording_configuration_output::Builder {
        crate::output::delete_recording_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlaybackKeyPairOutput {}
impl std::fmt::Debug for DeletePlaybackKeyPairOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlaybackKeyPairOutput");
        formatter.finish()
    }
}
/// See [`DeletePlaybackKeyPairOutput`](crate::output::DeletePlaybackKeyPairOutput)
pub mod delete_playback_key_pair_output {
    /// A builder for [`DeletePlaybackKeyPairOutput`](crate::output::DeletePlaybackKeyPairOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePlaybackKeyPairOutput`](crate::output::DeletePlaybackKeyPairOutput)
        pub fn build(self) -> crate::output::DeletePlaybackKeyPairOutput {
            crate::output::DeletePlaybackKeyPairOutput {}
        }
    }
}
impl DeletePlaybackKeyPairOutput {
    /// Creates a new builder-style object to manufacture [`DeletePlaybackKeyPairOutput`](crate::output::DeletePlaybackKeyPairOutput)
    pub fn builder() -> crate::output::delete_playback_key_pair_output::Builder {
        crate::output::delete_playback_key_pair_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteChannelOutput {}
impl std::fmt::Debug for DeleteChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteChannelOutput");
        formatter.finish()
    }
}
/// See [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
pub mod delete_channel_output {
    /// A builder for [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
        pub fn build(self) -> crate::output::DeleteChannelOutput {
            crate::output::DeleteChannelOutput {}
        }
    }
}
impl DeleteChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)
    pub fn builder() -> crate::output::delete_channel_output::Builder {
        crate::output::delete_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamKeyOutput {
    /// <p>Stream key used to authenticate an RTMPS stream for ingestion.</p>
    pub stream_key: std::option::Option<crate::model::StreamKey>,
}
impl CreateStreamKeyOutput {
    /// <p>Stream key used to authenticate an RTMPS stream for ingestion.</p>
    pub fn stream_key(&self) -> std::option::Option<&crate::model::StreamKey> {
        self.stream_key.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamKeyOutput");
        formatter.field("stream_key", &self.stream_key);
        formatter.finish()
    }
}
/// See [`CreateStreamKeyOutput`](crate::output::CreateStreamKeyOutput)
pub mod create_stream_key_output {
    /// A builder for [`CreateStreamKeyOutput`](crate::output::CreateStreamKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_key: std::option::Option<crate::model::StreamKey>,
    }
    impl Builder {
        /// <p>Stream key used to authenticate an RTMPS stream for ingestion.</p>
        pub fn stream_key(mut self, input: crate::model::StreamKey) -> Self {
            self.stream_key = Some(input);
            self
        }
        /// <p>Stream key used to authenticate an RTMPS stream for ingestion.</p>
        pub fn set_stream_key(
            mut self,
            input: std::option::Option<crate::model::StreamKey>,
        ) -> Self {
            self.stream_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamKeyOutput`](crate::output::CreateStreamKeyOutput)
        pub fn build(self) -> crate::output::CreateStreamKeyOutput {
            crate::output::CreateStreamKeyOutput {
                stream_key: self.stream_key,
            }
        }
    }
}
impl CreateStreamKeyOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamKeyOutput`](crate::output::CreateStreamKeyOutput)
    pub fn builder() -> crate::output::create_stream_key_output::Builder {
        crate::output::create_stream_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecordingConfigurationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub recording_configuration: std::option::Option<crate::model::RecordingConfiguration>,
}
impl CreateRecordingConfigurationOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn recording_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RecordingConfiguration> {
        self.recording_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateRecordingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecordingConfigurationOutput");
        formatter.field("recording_configuration", &self.recording_configuration);
        formatter.finish()
    }
}
/// See [`CreateRecordingConfigurationOutput`](crate::output::CreateRecordingConfigurationOutput)
pub mod create_recording_configuration_output {
    /// A builder for [`CreateRecordingConfigurationOutput`](crate::output::CreateRecordingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recording_configuration:
            std::option::Option<crate::model::RecordingConfiguration>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn recording_configuration(
            mut self,
            input: crate::model::RecordingConfiguration,
        ) -> Self {
            self.recording_configuration = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_recording_configuration(
            mut self,
            input: std::option::Option<crate::model::RecordingConfiguration>,
        ) -> Self {
            self.recording_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecordingConfigurationOutput`](crate::output::CreateRecordingConfigurationOutput)
        pub fn build(self) -> crate::output::CreateRecordingConfigurationOutput {
            crate::output::CreateRecordingConfigurationOutput {
                recording_configuration: self.recording_configuration,
            }
        }
    }
}
impl CreateRecordingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecordingConfigurationOutput`](crate::output::CreateRecordingConfigurationOutput)
    pub fn builder() -> crate::output::create_recording_configuration_output::Builder {
        crate::output::create_recording_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateChannelOutput {
    /// <p/>
    pub channel: std::option::Option<crate::model::Channel>,
    /// <p/>
    pub stream_key: std::option::Option<crate::model::StreamKey>,
}
impl CreateChannelOutput {
    /// <p/>
    pub fn channel(&self) -> std::option::Option<&crate::model::Channel> {
        self.channel.as_ref()
    }
    /// <p/>
    pub fn stream_key(&self) -> std::option::Option<&crate::model::StreamKey> {
        self.stream_key.as_ref()
    }
}
impl std::fmt::Debug for CreateChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateChannelOutput");
        formatter.field("channel", &self.channel);
        formatter.field("stream_key", &self.stream_key);
        formatter.finish()
    }
}
/// See [`CreateChannelOutput`](crate::output::CreateChannelOutput)
pub mod create_channel_output {
    /// A builder for [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::Channel>,
        pub(crate) stream_key: std::option::Option<crate::model::StreamKey>,
    }
    impl Builder {
        /// <p/>
        pub fn channel(mut self, input: crate::model::Channel) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p/>
        pub fn set_channel(mut self, input: std::option::Option<crate::model::Channel>) -> Self {
            self.channel = input;
            self
        }
        /// <p/>
        pub fn stream_key(mut self, input: crate::model::StreamKey) -> Self {
            self.stream_key = Some(input);
            self
        }
        /// <p/>
        pub fn set_stream_key(
            mut self,
            input: std::option::Option<crate::model::StreamKey>,
        ) -> Self {
            self.stream_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateChannelOutput`](crate::output::CreateChannelOutput)
        pub fn build(self) -> crate::output::CreateChannelOutput {
            crate::output::CreateChannelOutput {
                channel: self.channel,
                stream_key: self.stream_key,
            }
        }
    }
}
impl CreateChannelOutput {
    /// Creates a new builder-style object to manufacture [`CreateChannelOutput`](crate::output::CreateChannelOutput)
    pub fn builder() -> crate::output::create_channel_output::Builder {
        crate::output::create_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetStreamKeyOutput {
    /// <p/>
    pub stream_keys: std::option::Option<std::vec::Vec<crate::model::StreamKey>>,
    /// <p/>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
}
impl BatchGetStreamKeyOutput {
    /// <p/>
    pub fn stream_keys(&self) -> std::option::Option<&[crate::model::StreamKey]> {
        self.stream_keys.as_deref()
    }
    /// <p/>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchGetStreamKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetStreamKeyOutput");
        formatter.field("stream_keys", &self.stream_keys);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchGetStreamKeyOutput`](crate::output::BatchGetStreamKeyOutput)
pub mod batch_get_stream_key_output {
    /// A builder for [`BatchGetStreamKeyOutput`](crate::output::BatchGetStreamKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_keys: std::option::Option<std::vec::Vec<crate::model::StreamKey>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
    }
    impl Builder {
        /// Appends an item to `stream_keys`.
        ///
        /// To override the contents of this collection use [`set_stream_keys`](Self::set_stream_keys).
        ///
        /// <p/>
        pub fn stream_keys(mut self, input: impl Into<crate::model::StreamKey>) -> Self {
            let mut v = self.stream_keys.unwrap_or_default();
            v.push(input.into());
            self.stream_keys = Some(v);
            self
        }
        /// <p/>
        pub fn set_stream_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamKey>>,
        ) -> Self {
            self.stream_keys = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p/>
        pub fn errors(mut self, input: impl Into<crate::model::BatchError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p/>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetStreamKeyOutput`](crate::output::BatchGetStreamKeyOutput)
        pub fn build(self) -> crate::output::BatchGetStreamKeyOutput {
            crate::output::BatchGetStreamKeyOutput {
                stream_keys: self.stream_keys,
                errors: self.errors,
            }
        }
    }
}
impl BatchGetStreamKeyOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetStreamKeyOutput`](crate::output::BatchGetStreamKeyOutput)
    pub fn builder() -> crate::output::batch_get_stream_key_output::Builder {
        crate::output::batch_get_stream_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetChannelOutput {
    /// <p/>
    pub channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    /// <p>Each error object is related to a specific ARN in the request.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
}
impl BatchGetChannelOutput {
    /// <p/>
    pub fn channels(&self) -> std::option::Option<&[crate::model::Channel]> {
        self.channels.as_deref()
    }
    /// <p>Each error object is related to a specific ARN in the request.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchGetChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetChannelOutput");
        formatter.field("channels", &self.channels);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchGetChannelOutput`](crate::output::BatchGetChannelOutput)
pub mod batch_get_channel_output {
    /// A builder for [`BatchGetChannelOutput`](crate::output::BatchGetChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channels: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
    }
    impl Builder {
        /// Appends an item to `channels`.
        ///
        /// To override the contents of this collection use [`set_channels`](Self::set_channels).
        ///
        /// <p/>
        pub fn channels(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.channels.unwrap_or_default();
            v.push(input.into());
            self.channels = Some(v);
            self
        }
        /// <p/>
        pub fn set_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.channels = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Each error object is related to a specific ARN in the request.</p>
        pub fn errors(mut self, input: impl Into<crate::model::BatchError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Each error object is related to a specific ARN in the request.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetChannelOutput`](crate::output::BatchGetChannelOutput)
        pub fn build(self) -> crate::output::BatchGetChannelOutput {
            crate::output::BatchGetChannelOutput {
                channels: self.channels,
                errors: self.errors,
            }
        }
    }
}
impl BatchGetChannelOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetChannelOutput`](crate::output::BatchGetChannelOutput)
    pub fn builder() -> crate::output::batch_get_channel_output::Builder {
        crate::output::batch_get_channel_output::Builder::default()
    }
}
