// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Object specifying a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// <p>Channel ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Channel name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
    /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
    /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
    /// correspond to Ultra-low and Standard, respectively.)</p>
    pub latency_mode: std::option::Option<crate::model::ChannelLatencyMode>,
    /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
    /// exceed the allowable resolution or bitrate, the stream probably will disconnect
    /// immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
    /// automatically give viewers the best experience for their devices and network conditions.
    /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
    /// for renditions 360p and below; above that, audio is passed through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
    /// video-quality choice is limited to the original input. Resolution can be up to 480p and
    /// bitrate can be up to 1.5 Mbps.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
    /// is enabled. Default: "" (empty string, recording is disabled).</p>
    pub recording_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up
    /// streaming software.</p>
    pub ingest_endpoint: std::option::Option<std::string::String>,
    /// <p>Channel playback URL.</p>
    pub playback_url: std::option::Option<std::string::String>,
    /// <p>Whether the channel is private (enabled for playback authorization). Default:
    /// <code>false</code>.</p>
    pub authorized: bool,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("latency_mode", &self.latency_mode);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "recording_configuration_arn",
            &self.recording_configuration_arn,
        );
        formatter.field("ingest_endpoint", &self.ingest_endpoint);
        formatter.field("playback_url", &self.playback_url);
        formatter.field("authorized", &self.authorized);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) latency_mode: std::option::Option<crate::model::ChannelLatencyMode>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) recording_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) ingest_endpoint: std::option::Option<std::string::String>,
        pub(crate) playback_url: std::option::Option<std::string::String>,
        pub(crate) authorized: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Channel ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Channel ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
        /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
        /// correspond to Ultra-low and Standard, respectively.)</p>
        pub fn latency_mode(mut self, input: crate::model::ChannelLatencyMode) -> Self {
            self.latency_mode = Some(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
        /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
        /// correspond to Ultra-low and Standard, respectively.)</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.latency_mode = input;
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Channel type, which determines the allowable resolution and bitrate. <i>If you
        /// exceed the allowable resolution or bitrate, the stream probably will disconnect
        /// immediately.</i> Default: <code>STANDARD</code>. Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: Multiple qualities are generated from the original input, to
        /// automatically give viewers the best experience for their devices and network conditions.
        /// Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only
        /// for renditions 360p and below; above that, audio is passed through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s
        /// video-quality choice is limited to the original input. Resolution can be up to 480p and
        /// bitrate can be up to 1.5 Mbps.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
        /// is enabled. Default: "" (empty string, recording is disabled).</p>
        pub fn recording_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recording_configuration_arn = Some(input.into());
            self
        }
        /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
        /// is enabled. Default: "" (empty string, recording is disabled).</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recording_configuration_arn = input;
            self
        }
        /// <p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up
        /// streaming software.</p>
        pub fn ingest_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingest_endpoint = Some(input.into());
            self
        }
        /// <p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up
        /// streaming software.</p>
        pub fn set_ingest_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ingest_endpoint = input;
            self
        }
        /// <p>Channel playback URL.</p>
        pub fn playback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.playback_url = Some(input.into());
            self
        }
        /// <p>Channel playback URL.</p>
        pub fn set_playback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.playback_url = input;
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn authorized(mut self, input: bool) -> Self {
            self.authorized = Some(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.authorized = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                arn: self.arn,
                name: self.name,
                latency_mode: self.latency_mode,
                r#type: self.r#type,
                recording_configuration_arn: self.recording_configuration_arn,
                ingest_endpoint: self.ingest_endpoint,
                playback_url: self.playback_url,
                authorized: self.authorized.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelType {
    #[allow(missing_docs)] // documentation missing in model
    BasicChannelType,
    #[allow(missing_docs)] // documentation missing in model
    StandardChannelType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelType {
    fn from(s: &str) -> Self {
        match s {
            "BASIC" => ChannelType::BasicChannelType,
            "STANDARD" => ChannelType::StandardChannelType,
            other => ChannelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelType::from(s))
    }
}
impl ChannelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelType::BasicChannelType => "BASIC",
            ChannelType::StandardChannelType => "STANDARD",
            ChannelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BASIC", "STANDARD"]
    }
}
impl AsRef<str> for ChannelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelLatencyMode {
    #[allow(missing_docs)] // documentation missing in model
    LowLatency,
    #[allow(missing_docs)] // documentation missing in model
    NormalLatency,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelLatencyMode {
    fn from(s: &str) -> Self {
        match s {
            "LOW" => ChannelLatencyMode::LowLatency,
            "NORMAL" => ChannelLatencyMode::NormalLatency,
            other => ChannelLatencyMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelLatencyMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelLatencyMode::from(s))
    }
}
impl ChannelLatencyMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelLatencyMode::LowLatency => "LOW",
            ChannelLatencyMode::NormalLatency => "NORMAL",
            ChannelLatencyMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOW", "NORMAL"]
    }
}
impl AsRef<str> for ChannelLatencyMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamSummary {
    /// <p>Channel ARN for the stream.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The stream’s state.</p>
    pub state: std::option::Option<crate::model::StreamState>,
    /// <p>The stream’s health.</p>
    pub health: std::option::Option<crate::model::StreamHealth>,
    /// <p>A count of concurrent views of the stream. Typically, a new view appears in
    /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
    /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
    /// -1 indicates that the request timed out; in this case, retry.</p>
    pub viewer_count: i64,
    /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for StreamSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamSummary");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("state", &self.state);
        formatter.field("health", &self.health);
        formatter.field("viewer_count", &self.viewer_count);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`StreamSummary`](crate::model::StreamSummary)
pub mod stream_summary {
    /// A builder for [`StreamSummary`](crate::model::StreamSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StreamState>,
        pub(crate) health: std::option::Option<crate::model::StreamHealth>,
        pub(crate) viewer_count: std::option::Option<i64>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Channel ARN for the stream.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The stream’s state.</p>
        pub fn state(mut self, input: crate::model::StreamState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The stream’s state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StreamState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The stream’s health.</p>
        pub fn health(mut self, input: crate::model::StreamHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>The stream’s health.</p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::StreamHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>A count of concurrent views of the stream. Typically, a new view appears in
        /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
        /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
        /// -1 indicates that the request timed out; in this case, retry.</p>
        pub fn viewer_count(mut self, input: i64) -> Self {
            self.viewer_count = Some(input);
            self
        }
        /// <p>A count of concurrent views of the stream. Typically, a new view appears in
        /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
        /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
        /// -1 indicates that the request timed out; in this case, retry.</p>
        pub fn set_viewer_count(mut self, input: std::option::Option<i64>) -> Self {
            self.viewer_count = input;
            self
        }
        /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamSummary`](crate::model::StreamSummary)
        pub fn build(self) -> crate::model::StreamSummary {
            crate::model::StreamSummary {
                channel_arn: self.channel_arn,
                state: self.state,
                health: self.health,
                viewer_count: self.viewer_count.unwrap_or_default(),
                start_time: self.start_time,
            }
        }
    }
}
impl StreamSummary {
    /// Creates a new builder-style object to manufacture [`StreamSummary`](crate::model::StreamSummary)
    pub fn builder() -> crate::model::stream_summary::Builder {
        crate::model::stream_summary::Builder::default()
    }
}

/// _Note: `StreamHealth::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamHealth {
    #[allow(missing_docs)] // documentation missing in model
    StreamHealthy,
    #[allow(missing_docs)] // documentation missing in model
    Starving,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamHealth {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => StreamHealth::StreamHealthy,
            "STARVING" => StreamHealth::Starving,
            "UNKNOWN" => StreamHealth::UnknownValue,
            other => StreamHealth::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamHealth {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamHealth::from(s))
    }
}
impl StreamHealth {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamHealth::StreamHealthy => "HEALTHY",
            StreamHealth::Starving => "STARVING",
            StreamHealth::UnknownValue => "UNKNOWN",
            StreamHealth::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "STARVING", "UNKNOWN"]
    }
}
impl AsRef<str> for StreamHealth {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamState {
    #[allow(missing_docs)] // documentation missing in model
    StreamLive,
    #[allow(missing_docs)] // documentation missing in model
    StreamOffline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamState {
    fn from(s: &str) -> Self {
        match s {
            "LIVE" => StreamState::StreamLive,
            "OFFLINE" => StreamState::StreamOffline,
            other => StreamState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamState::from(s))
    }
}
impl StreamState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamState::StreamLive => "LIVE",
            StreamState::StreamOffline => "OFFLINE",
            StreamState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LIVE", "OFFLINE"]
    }
}
impl AsRef<str> for StreamState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a stream key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamKeySummary {
    /// <p>Stream-key ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Channel ARN for the stream.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StreamKeySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamKeySummary");
        formatter.field("arn", &self.arn);
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StreamKeySummary`](crate::model::StreamKeySummary)
pub mod stream_key_summary {
    /// A builder for [`StreamKeySummary`](crate::model::StreamKeySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Stream-key ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Stream-key ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamKeySummary`](crate::model::StreamKeySummary)
        pub fn build(self) -> crate::model::StreamKeySummary {
            crate::model::StreamKeySummary {
                arn: self.arn,
                channel_arn: self.channel_arn,
                tags: self.tags,
            }
        }
    }
}
impl StreamKeySummary {
    /// Creates a new builder-style object to manufacture [`StreamKeySummary`](crate::model::StreamKeySummary)
    pub fn builder() -> crate::model::stream_key_summary::Builder {
        crate::model::stream_key_summary::Builder::default()
    }
}

/// <p>Summary information about a RecordingConfiguration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordingConfigurationSummary {
    /// <p>Recording-configuration ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Recording-configuration name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about where recorded video will be stored.</p>
    pub destination_configuration: std::option::Option<crate::model::DestinationConfiguration>,
    /// <p>Indicates the current state of the recording configuration. When the state is
    /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
    pub state: std::option::Option<crate::model::RecordingConfigurationState>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RecordingConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordingConfigurationSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("destination_configuration", &self.destination_configuration);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RecordingConfigurationSummary`](crate::model::RecordingConfigurationSummary)
pub mod recording_configuration_summary {
    /// A builder for [`RecordingConfigurationSummary`](crate::model::RecordingConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_configuration:
            std::option::Option<crate::model::DestinationConfiguration>,
        pub(crate) state: std::option::Option<crate::model::RecordingConfigurationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Recording-configuration ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Recording-configuration ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A complex type that contains information about where recorded video will be stored.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::DestinationConfiguration,
        ) -> Self {
            self.destination_configuration = Some(input);
            self
        }
        /// <p>A complex type that contains information about where recorded video will be stored.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::DestinationConfiguration>,
        ) -> Self {
            self.destination_configuration = input;
            self
        }
        /// <p>Indicates the current state of the recording configuration. When the state is
        /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
        pub fn state(mut self, input: crate::model::RecordingConfigurationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates the current state of the recording configuration. When the state is
        /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RecordingConfigurationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordingConfigurationSummary`](crate::model::RecordingConfigurationSummary)
        pub fn build(self) -> crate::model::RecordingConfigurationSummary {
            crate::model::RecordingConfigurationSummary {
                arn: self.arn,
                name: self.name,
                destination_configuration: self.destination_configuration,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl RecordingConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`RecordingConfigurationSummary`](crate::model::RecordingConfigurationSummary)
    pub fn builder() -> crate::model::recording_configuration_summary::Builder {
        crate::model::recording_configuration_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordingConfigurationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordingConfigurationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RecordingConfigurationState::Active,
            "CREATE_FAILED" => RecordingConfigurationState::CreateFailed,
            "CREATING" => RecordingConfigurationState::Creating,
            other => RecordingConfigurationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordingConfigurationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordingConfigurationState::from(s))
    }
}
impl RecordingConfigurationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordingConfigurationState::Active => "ACTIVE",
            RecordingConfigurationState::CreateFailed => "CREATE_FAILED",
            RecordingConfigurationState::Creating => "CREATING",
            RecordingConfigurationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATE_FAILED", "CREATING"]
    }
}
impl AsRef<str> for RecordingConfigurationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that describes a location where recorded videos will be stored. Each member
/// represents a type of destination configuration. For recording, you define one and only one
/// type of destination configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationConfiguration {
    /// <p>An S3 destination configuration where recorded videos will be stored.</p>
    pub s3: std::option::Option<crate::model::S3DestinationConfiguration>,
}
impl std::fmt::Debug for DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationConfiguration");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`DestinationConfiguration`](crate::model::DestinationConfiguration)
pub mod destination_configuration {
    /// A builder for [`DestinationConfiguration`](crate::model::DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3DestinationConfiguration>,
    }
    impl Builder {
        /// <p>An S3 destination configuration where recorded videos will be stored.</p>
        pub fn s3(mut self, input: crate::model::S3DestinationConfiguration) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>An S3 destination configuration where recorded videos will be stored.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationConfiguration`](crate::model::DestinationConfiguration)
        pub fn build(self) -> crate::model::DestinationConfiguration {
            crate::model::DestinationConfiguration { s3: self.s3 }
        }
    }
}
impl DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`DestinationConfiguration`](crate::model::DestinationConfiguration)
    pub fn builder() -> crate::model::destination_configuration::Builder {
        crate::model::destination_configuration::Builder::default()
    }
}

/// <p>A complex type that describes an S3 location where recorded videos will be stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationConfiguration {
    /// <p>Location (S3 bucket name) where recorded videos will be stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationConfiguration");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
pub mod s3_destination_configuration {
    /// A builder for [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Location (S3 bucket name) where recorded videos will be stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>Location (S3 bucket name) where recorded videos will be stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
        pub fn build(self) -> crate::model::S3DestinationConfiguration {
            crate::model::S3DestinationConfiguration {
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl S3DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    pub fn builder() -> crate::model::s3_destination_configuration::Builder {
        crate::model::s3_destination_configuration::Builder::default()
    }
}

/// <p>Summary information about a playback key pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlaybackKeyPairSummary {
    /// <p>Key-pair ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Playback-key-pair name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PlaybackKeyPairSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlaybackKeyPairSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PlaybackKeyPairSummary`](crate::model::PlaybackKeyPairSummary)
pub mod playback_key_pair_summary {
    /// A builder for [`PlaybackKeyPairSummary`](crate::model::PlaybackKeyPairSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Key-pair ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Key-pair ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PlaybackKeyPairSummary`](crate::model::PlaybackKeyPairSummary)
        pub fn build(self) -> crate::model::PlaybackKeyPairSummary {
            crate::model::PlaybackKeyPairSummary {
                arn: self.arn,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl PlaybackKeyPairSummary {
    /// Creates a new builder-style object to manufacture [`PlaybackKeyPairSummary`](crate::model::PlaybackKeyPairSummary)
    pub fn builder() -> crate::model::playback_key_pair_summary::Builder {
        crate::model::playback_key_pair_summary::Builder::default()
    }
}

/// <p>Summary information about a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelSummary {
    /// <p>Channel ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Channel name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
    /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
    /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
    /// correspond to Ultra-low and Standard, respectively.)</p>
    pub latency_mode: std::option::Option<crate::model::ChannelLatencyMode>,
    /// <p>Whether the channel is private (enabled for playback authorization). Default:
    /// <code>false</code>.</p>
    pub authorized: bool,
    /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
    /// is enabled. Default: "" (empty string, recording is disabled).</p>
    pub recording_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ChannelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("latency_mode", &self.latency_mode);
        formatter.field("authorized", &self.authorized);
        formatter.field(
            "recording_configuration_arn",
            &self.recording_configuration_arn,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ChannelSummary`](crate::model::ChannelSummary)
pub mod channel_summary {
    /// A builder for [`ChannelSummary`](crate::model::ChannelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) latency_mode: std::option::Option<crate::model::ChannelLatencyMode>,
        pub(crate) authorized: std::option::Option<bool>,
        pub(crate) recording_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Channel ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Channel ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Channel name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Channel name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
        /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
        /// correspond to Ultra-low and Standard, respectively.)</p>
        pub fn latency_mode(mut self, input: crate::model::ChannelLatencyMode) -> Self {
            self.latency_mode = Some(input);
            self
        }
        /// <p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to
        /// Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default:
        /// <code>LOW</code>. (Note: In the Amazon IVS console, <code>LOW</code> and <code>NORMAL</code>
        /// correspond to Ultra-low and Standard, respectively.)</p>
        pub fn set_latency_mode(
            mut self,
            input: std::option::Option<crate::model::ChannelLatencyMode>,
        ) -> Self {
            self.latency_mode = input;
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn authorized(mut self, input: bool) -> Self {
            self.authorized = Some(input);
            self
        }
        /// <p>Whether the channel is private (enabled for playback authorization). Default:
        /// <code>false</code>.</p>
        pub fn set_authorized(mut self, input: std::option::Option<bool>) -> Self {
            self.authorized = input;
            self
        }
        /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
        /// is enabled. Default: "" (empty string, recording is disabled).</p>
        pub fn recording_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recording_configuration_arn = Some(input.into());
            self
        }
        /// <p>Recording-configuration ARN. A value other than an empty string indicates that recording
        /// is enabled. Default: "" (empty string, recording is disabled).</p>
        pub fn set_recording_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recording_configuration_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelSummary`](crate::model::ChannelSummary)
        pub fn build(self) -> crate::model::ChannelSummary {
            crate::model::ChannelSummary {
                arn: self.arn,
                name: self.name,
                latency_mode: self.latency_mode,
                authorized: self.authorized.unwrap_or_default(),
                recording_configuration_arn: self.recording_configuration_arn,
                tags: self.tags,
            }
        }
    }
}
impl ChannelSummary {
    /// Creates a new builder-style object to manufacture [`ChannelSummary`](crate::model::ChannelSummary)
    pub fn builder() -> crate::model::channel_summary::Builder {
        crate::model::channel_summary::Builder::default()
    }
}

/// <p>A key pair used to sign and validate a playback authorization token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlaybackKeyPair {
    /// <p>Key-pair ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Playback-key-pair name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Key-pair identifier.</p>
    pub fingerprint: std::option::Option<std::string::String>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PlaybackKeyPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlaybackKeyPair");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("fingerprint", &self.fingerprint);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PlaybackKeyPair`](crate::model::PlaybackKeyPair)
pub mod playback_key_pair {
    /// A builder for [`PlaybackKeyPair`](crate::model::PlaybackKeyPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fingerprint: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Key-pair ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Key-pair ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Playback-key-pair name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Key-pair identifier.</p>
        pub fn fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint = Some(input.into());
            self
        }
        /// <p>Key-pair identifier.</p>
        pub fn set_fingerprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fingerprint = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PlaybackKeyPair`](crate::model::PlaybackKeyPair)
        pub fn build(self) -> crate::model::PlaybackKeyPair {
            crate::model::PlaybackKeyPair {
                arn: self.arn,
                name: self.name,
                fingerprint: self.fingerprint,
                tags: self.tags,
            }
        }
    }
}
impl PlaybackKeyPair {
    /// Creates a new builder-style object to manufacture [`PlaybackKeyPair`](crate::model::PlaybackKeyPair)
    pub fn builder() -> crate::model::playback_key_pair::Builder {
        crate::model::playback_key_pair::Builder::default()
    }
}

/// <p>Object specifying a stream key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamKey {
    /// <p>Stream-key ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Stream-key value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Channel ARN for the stream.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StreamKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamKey");
        formatter.field("arn", &self.arn);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StreamKey`](crate::model::StreamKey)
pub mod stream_key {
    /// A builder for [`StreamKey`](crate::model::StreamKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Stream-key ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Stream-key ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Stream-key value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Stream-key value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamKey`](crate::model::StreamKey)
        pub fn build(self) -> crate::model::StreamKey {
            crate::model::StreamKey {
                arn: self.arn,
                value: self.value,
                channel_arn: self.channel_arn,
                tags: self.tags,
            }
        }
    }
}
impl StreamKey {
    /// Creates a new builder-style object to manufacture [`StreamKey`](crate::model::StreamKey)
    pub fn builder() -> crate::model::stream_key::Builder {
        crate::model::stream_key::Builder::default()
    }
}

/// <p>Specifies a live video stream that has been ingested and distributed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stream {
    /// <p>Channel ARN for the stream.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>URL of the master playlist, required by the video player to play the HLS stream.</p>
    pub playback_url: std::option::Option<std::string::String>,
    /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The stream’s state.</p>
    pub state: std::option::Option<crate::model::StreamState>,
    /// <p>The stream’s health.</p>
    pub health: std::option::Option<crate::model::StreamHealth>,
    /// <p>A count of concurrent views of the stream. Typically, a new view appears in
    /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
    /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
    /// -1 indicates that the request timed out; in this case, retry.</p>
    pub viewer_count: i64,
}
impl std::fmt::Debug for Stream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stream");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("playback_url", &self.playback_url);
        formatter.field("start_time", &self.start_time);
        formatter.field("state", &self.state);
        formatter.field("health", &self.health);
        formatter.field("viewer_count", &self.viewer_count);
        formatter.finish()
    }
}
/// See [`Stream`](crate::model::Stream)
pub mod stream {
    /// A builder for [`Stream`](crate::model::Stream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) playback_url: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::StreamState>,
        pub(crate) health: std::option::Option<crate::model::StreamHealth>,
        pub(crate) viewer_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Channel ARN for the stream.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>Channel ARN for the stream.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>URL of the master playlist, required by the video player to play the HLS stream.</p>
        pub fn playback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.playback_url = Some(input.into());
            self
        }
        /// <p>URL of the master playlist, required by the video player to play the HLS stream.</p>
        pub fn set_playback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.playback_url = input;
            self
        }
        /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The stream’s state.</p>
        pub fn state(mut self, input: crate::model::StreamState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The stream’s state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StreamState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The stream’s health.</p>
        pub fn health(mut self, input: crate::model::StreamHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>The stream’s health.</p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::StreamHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>A count of concurrent views of the stream. Typically, a new view appears in
        /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
        /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
        /// -1 indicates that the request timed out; in this case, retry.</p>
        pub fn viewer_count(mut self, input: i64) -> Self {
            self.viewer_count = Some(input);
            self
        }
        /// <p>A count of concurrent views of the stream. Typically, a new view appears in
        /// <code>viewerCount</code> within 15 seconds of when video playback starts and a view is
        /// removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of
        /// -1 indicates that the request timed out; in this case, retry.</p>
        pub fn set_viewer_count(mut self, input: std::option::Option<i64>) -> Self {
            self.viewer_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Stream`](crate::model::Stream)
        pub fn build(self) -> crate::model::Stream {
            crate::model::Stream {
                channel_arn: self.channel_arn,
                playback_url: self.playback_url,
                start_time: self.start_time,
                state: self.state,
                health: self.health,
                viewer_count: self.viewer_count.unwrap_or_default(),
            }
        }
    }
}
impl Stream {
    /// Creates a new builder-style object to manufacture [`Stream`](crate::model::Stream)
    pub fn builder() -> crate::model::stream::Builder {
        crate::model::stream::Builder::default()
    }
}

/// <p>An object representing a configuration to record a channel stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordingConfiguration {
    /// <p>Recording-configuration ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Recording-configuration name. The value does not need to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about where recorded video will be stored.</p>
    pub destination_configuration: std::option::Option<crate::model::DestinationConfiguration>,
    /// <p>Indicates the current state of the recording configuration. When the state is
    /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
    pub state: std::option::Option<crate::model::RecordingConfigurationState>,
    /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RecordingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordingConfiguration");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("destination_configuration", &self.destination_configuration);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RecordingConfiguration`](crate::model::RecordingConfiguration)
pub mod recording_configuration {
    /// A builder for [`RecordingConfiguration`](crate::model::RecordingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_configuration:
            std::option::Option<crate::model::DestinationConfiguration>,
        pub(crate) state: std::option::Option<crate::model::RecordingConfigurationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Recording-configuration ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Recording-configuration ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Recording-configuration name. The value does not need to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A complex type that contains information about where recorded video will be stored.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::DestinationConfiguration,
        ) -> Self {
            self.destination_configuration = Some(input);
            self
        }
        /// <p>A complex type that contains information about where recorded video will be stored.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::DestinationConfiguration>,
        ) -> Self {
            self.destination_configuration = input;
            self
        }
        /// <p>Indicates the current state of the recording configuration. When the state is
        /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
        pub fn state(mut self, input: crate::model::RecordingConfigurationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates the current state of the recording configuration. When the state is
        /// <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::RecordingConfigurationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordingConfiguration`](crate::model::RecordingConfiguration)
        pub fn build(self) -> crate::model::RecordingConfiguration {
            crate::model::RecordingConfiguration {
                arn: self.arn,
                name: self.name,
                destination_configuration: self.destination_configuration,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl RecordingConfiguration {
    /// Creates a new builder-style object to manufacture [`RecordingConfiguration`](crate::model::RecordingConfiguration)
    pub fn builder() -> crate::model::recording_configuration::Builder {
        crate::model::recording_configuration::Builder::default()
    }
}

/// <p>Error related to a specific channel, specified by its ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchError {
    /// <p>Channel ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Error message, determined by the application.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchError");
        formatter.field("arn", &self.arn);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchError`](crate::model::BatchError)
pub mod batch_error {
    /// A builder for [`BatchError`](crate::model::BatchError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Channel ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Channel ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>Error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Error message, determined by the application.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message, determined by the application.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchError`](crate::model::BatchError)
        pub fn build(self) -> crate::model::BatchError {
            crate::model::BatchError {
                arn: self.arn,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BatchError {
    /// Creates a new builder-style object to manufacture [`BatchError`](crate::model::BatchError)
    pub fn builder() -> crate::model::batch_error::Builder {
        crate::model::batch_error::Builder::default()
    }
}
