// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchGetChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetChannelError {
    /// Kind of error that occurred.
    pub kind: BatchGetChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetChannelErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetChannelError {
    fn code(&self) -> Option<&str> {
        BatchGetChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetChannelError {
    /// Creates a new `BatchGetChannelError`.
    pub fn new(kind: BatchGetChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for BatchGetChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetStreamKeyError {
    /// Kind of error that occurred.
    pub kind: BatchGetStreamKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetStreamKeyErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetStreamKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetStreamKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetStreamKeyError {
    fn code(&self) -> Option<&str> {
        BatchGetStreamKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetStreamKeyError {
    /// Creates a new `BatchGetStreamKeyError`.
    pub fn new(kind: BatchGetStreamKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetStreamKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetStreamKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetStreamKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetStreamKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for BatchGetStreamKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetStreamKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelError {
    /// Kind of error that occurred.
    pub kind: CreateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelError {
    fn code(&self) -> Option<&str> {
        CreateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelError {
    /// Creates a new `CreateChannelError`.
    pub fn new(kind: CreateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::PendingVerification(_))
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateChannelErrorKind::PendingVerification(_inner) => Some(_inner),
            CreateChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateChannelErrorKind::ValidationException(_inner) => Some(_inner),
            CreateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRecordingConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateRecordingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRecordingConfigurationErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRecordingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRecordingConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRecordingConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRecordingConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRecordingConfigurationErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            CreateRecordingConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateRecordingConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRecordingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRecordingConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateRecordingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRecordingConfigurationError {
    /// Creates a new `CreateRecordingConfigurationError`.
    pub fn new(kind: CreateRecordingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRecordingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRecordingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRecordingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRecordingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::PendingVerification(_)
        )
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateRecordingConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecordingConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRecordingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRecordingConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRecordingConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRecordingConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRecordingConfigurationErrorKind::PendingVerification(_inner) => Some(_inner),
            CreateRecordingConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateRecordingConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRecordingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamKeyError {
    /// Kind of error that occurred.
    pub kind: CreateStreamKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamKeyErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateStreamKeyErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            CreateStreamKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStreamKeyErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateStreamKeyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateStreamKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamKeyError {
    fn code(&self) -> Option<&str> {
        CreateStreamKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamKeyError {
    /// Creates a new `CreateStreamKeyError`.
    pub fn new(kind: CreateStreamKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateStreamKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamKeyErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(&self.kind, CreateStreamKeyErrorKind::PendingVerification(_))
    }
    /// Returns true if the error kind is `CreateStreamKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamKeyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamKeyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateStreamKeyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamKeyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateStreamKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateStreamKeyErrorKind::PendingVerification(_inner) => Some(_inner),
            CreateStreamKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStreamKeyErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateStreamKeyErrorKind::ValidationException(_inner) => Some(_inner),
            CreateStreamKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelError {
    fn code(&self) -> Option<&str> {
        DeleteChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelError {
    /// Creates a new `DeleteChannelError`.
    pub fn new(kind: DeleteChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::PendingVerification(_))
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteChannelErrorKind::PendingVerification(_inner) => Some(_inner),
            DeleteChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePlaybackKeyPairError {
    /// Kind of error that occurred.
    pub kind: DeletePlaybackKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePlaybackKeyPairErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePlaybackKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePlaybackKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePlaybackKeyPairErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            DeletePlaybackKeyPairErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePlaybackKeyPairErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePlaybackKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePlaybackKeyPairError {
    fn code(&self) -> Option<&str> {
        DeletePlaybackKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePlaybackKeyPairError {
    /// Creates a new `DeletePlaybackKeyPairError`.
    pub fn new(kind: DeletePlaybackKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePlaybackKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePlaybackKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePlaybackKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePlaybackKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePlaybackKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlaybackKeyPairErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlaybackKeyPairErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlaybackKeyPairErrorKind::PendingVerification(_)
        )
    }
    /// Returns true if the error kind is `DeletePlaybackKeyPairErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlaybackKeyPairErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlaybackKeyPairErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlaybackKeyPairErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePlaybackKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePlaybackKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePlaybackKeyPairErrorKind::PendingVerification(_inner) => Some(_inner),
            DeletePlaybackKeyPairErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePlaybackKeyPairErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePlaybackKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecordingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteRecordingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecordingConfigurationErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecordingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecordingConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRecordingConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRecordingConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRecordingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRecordingConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRecordingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecordingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteRecordingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecordingConfigurationError {
    /// Creates a new `DeleteRecordingConfigurationError`.
    pub fn new(kind: DeleteRecordingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecordingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecordingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecordingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecordingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteRecordingConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecordingConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRecordingConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecordingConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRecordingConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecordingConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRecordingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecordingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteRecordingConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecordingConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRecordingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecordingConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRecordingConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRecordingConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRecordingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteRecordingConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRecordingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamKeyErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteStreamKeyErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            DeleteStreamKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamKeyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteStreamKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamKeyError {
    fn code(&self) -> Option<&str> {
        DeleteStreamKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamKeyError {
    /// Creates a new `DeleteStreamKeyError`.
    pub fn new(kind: DeleteStreamKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteStreamKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamKeyErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(&self.kind, DeleteStreamKeyErrorKind::PendingVerification(_))
    }
    /// Returns true if the error kind is `DeleteStreamKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteStreamKeyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamKeyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteStreamKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteStreamKeyErrorKind::PendingVerification(_inner) => Some(_inner),
            DeleteStreamKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamKeyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteStreamKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChannelError {
    /// Kind of error that occurred.
    pub kind: GetChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChannelErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChannelError {
    fn code(&self) -> Option<&str> {
        GetChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChannelError {
    /// Creates a new `GetChannelError`.
    pub fn new(kind: GetChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetChannelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetChannelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetChannelErrorKind::ValidationException(_inner) => Some(_inner),
            GetChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPlaybackKeyPairError {
    /// Kind of error that occurred.
    pub kind: GetPlaybackKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPlaybackKeyPairErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPlaybackKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPlaybackKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPlaybackKeyPairErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPlaybackKeyPairErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPlaybackKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPlaybackKeyPairError {
    fn code(&self) -> Option<&str> {
        GetPlaybackKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPlaybackKeyPairError {
    /// Creates a new `GetPlaybackKeyPairError`.
    pub fn new(kind: GetPlaybackKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPlaybackKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPlaybackKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPlaybackKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPlaybackKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetPlaybackKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlaybackKeyPairErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetPlaybackKeyPairErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlaybackKeyPairErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetPlaybackKeyPairErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlaybackKeyPairErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPlaybackKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPlaybackKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPlaybackKeyPairErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPlaybackKeyPairErrorKind::ValidationException(_inner) => Some(_inner),
            GetPlaybackKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecordingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetRecordingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecordingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecordingConfigurationErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecordingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecordingConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRecordingConfigurationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRecordingConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRecordingConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRecordingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecordingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetRecordingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecordingConfigurationError {
    /// Creates a new `GetRecordingConfigurationError`.
    pub fn new(kind: GetRecordingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecordingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecordingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecordingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecordingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetRecordingConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordingConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetRecordingConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordingConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetRecordingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetRecordingConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecordingConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRecordingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecordingConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRecordingConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRecordingConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRecordingConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetRecordingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamError {
    /// Kind of error that occurred.
    pub kind: GetStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ChannelNotBroadcasting(crate::error::ChannelNotBroadcasting),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStreamErrorKind::ChannelNotBroadcasting(_inner) => _inner.fmt(f),
            GetStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStreamErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamError {
    fn code(&self) -> Option<&str> {
        GetStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamError {
    /// Creates a new `GetStreamError`.
    pub fn new(kind: GetStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStreamErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetStreamErrorKind::ChannelNotBroadcasting`.
    pub fn is_channel_not_broadcasting(&self) -> bool {
        matches!(&self.kind, GetStreamErrorKind::ChannelNotBroadcasting(_))
    }
    /// Returns true if the error kind is `GetStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStreamErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetStreamErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStreamErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStreamErrorKind::ChannelNotBroadcasting(_inner) => Some(_inner),
            GetStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStreamErrorKind::ValidationException(_inner) => Some(_inner),
            GetStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamKeyError {
    /// Kind of error that occurred.
    pub kind: GetStreamKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamKeyErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStreamKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStreamKeyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStreamKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamKeyError {
    fn code(&self) -> Option<&str> {
        GetStreamKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamKeyError {
    /// Creates a new `GetStreamKeyError`.
    pub fn new(kind: GetStreamKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetStreamKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStreamKeyErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetStreamKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetStreamKeyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetStreamKeyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetStreamKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStreamKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStreamKeyErrorKind::ValidationException(_inner) => Some(_inner),
            GetStreamKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportPlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportPlaybackKeyPairError {
    /// Kind of error that occurred.
    pub kind: ImportPlaybackKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportPlaybackKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportPlaybackKeyPairErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportPlaybackKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportPlaybackKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportPlaybackKeyPairErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ImportPlaybackKeyPairErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            ImportPlaybackKeyPairErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ImportPlaybackKeyPairErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ImportPlaybackKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportPlaybackKeyPairError {
    fn code(&self) -> Option<&str> {
        ImportPlaybackKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportPlaybackKeyPairError {
    /// Creates a new `ImportPlaybackKeyPairError`.
    pub fn new(kind: ImportPlaybackKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportPlaybackKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportPlaybackKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportPlaybackKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportPlaybackKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportPlaybackKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportPlaybackKeyPairErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ImportPlaybackKeyPairErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportPlaybackKeyPairErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ImportPlaybackKeyPairErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(
            &self.kind,
            ImportPlaybackKeyPairErrorKind::PendingVerification(_)
        )
    }
    /// Returns true if the error kind is `ImportPlaybackKeyPairErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportPlaybackKeyPairErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `ImportPlaybackKeyPairErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportPlaybackKeyPairErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ImportPlaybackKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportPlaybackKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportPlaybackKeyPairErrorKind::ConflictException(_inner) => Some(_inner),
            ImportPlaybackKeyPairErrorKind::PendingVerification(_inner) => Some(_inner),
            ImportPlaybackKeyPairErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ImportPlaybackKeyPairErrorKind::ValidationException(_inner) => Some(_inner),
            ImportPlaybackKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsError {
    /// Kind of error that occurred.
    pub kind: ListChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsError {
    fn code(&self) -> Option<&str> {
        ListChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsError {
    /// Creates a new `ListChannelsError`.
    pub fn new(kind: ListChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListChannelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListChannelsErrorKind::ConflictException(_inner) => Some(_inner),
            ListChannelsErrorKind::ValidationException(_inner) => Some(_inner),
            ListChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPlaybackKeyPairs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPlaybackKeyPairsError {
    /// Kind of error that occurred.
    pub kind: ListPlaybackKeyPairsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPlaybackKeyPairs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPlaybackKeyPairsErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPlaybackKeyPairsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPlaybackKeyPairsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPlaybackKeyPairsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPlaybackKeyPairsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPlaybackKeyPairsError {
    fn code(&self) -> Option<&str> {
        ListPlaybackKeyPairsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPlaybackKeyPairsError {
    /// Creates a new `ListPlaybackKeyPairsError`.
    pub fn new(kind: ListPlaybackKeyPairsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPlaybackKeyPairsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPlaybackKeyPairsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPlaybackKeyPairsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPlaybackKeyPairsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPlaybackKeyPairsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlaybackKeyPairsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListPlaybackKeyPairsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlaybackKeyPairsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPlaybackKeyPairsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPlaybackKeyPairsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPlaybackKeyPairsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPlaybackKeyPairsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecordingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecordingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListRecordingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecordingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecordingConfigurationsErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecordingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecordingConfigurationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRecordingConfigurationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRecordingConfigurationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRecordingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecordingConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListRecordingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecordingConfigurationsError {
    /// Creates a new `ListRecordingConfigurationsError`.
    pub fn new(kind: ListRecordingConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecordingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecordingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecordingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecordingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListRecordingConfigurationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecordingConfigurationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListRecordingConfigurationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecordingConfigurationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListRecordingConfigurationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecordingConfigurationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRecordingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecordingConfigurationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRecordingConfigurationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRecordingConfigurationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRecordingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreamKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamKeysError {
    /// Kind of error that occurred.
    pub kind: ListStreamKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreamKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamKeysErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamKeysErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStreamKeysErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListStreamKeysErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStreamKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamKeysError {
    fn code(&self) -> Option<&str> {
        ListStreamKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamKeysError {
    /// Creates a new `ListStreamKeysError`.
    pub fn new(kind: ListStreamKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStreamKeysErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamKeysErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamKeysErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamKeysErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListStreamKeysErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListStreamKeysErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListStreamKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamKeysErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStreamKeysErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListStreamKeysErrorKind::ValidationException(_inner) => Some(_inner),
            ListStreamKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamsError {
    /// Kind of error that occurred.
    pub kind: ListStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamsErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamsError {
    fn code(&self) -> Option<&str> {
        ListStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamsError {
    /// Creates a new `ListStreamsError`.
    pub fn new(kind: ListStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListStreamsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListStreamsErrorKind::AccessDeniedException(_))
    }
}
impl std::error::Error for ListStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetadataError {
    /// Kind of error that occurred.
    pub kind: PutMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetadataErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ChannelNotBroadcasting(crate::error::ChannelNotBroadcasting),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutMetadataErrorKind::ChannelNotBroadcasting(_inner) => _inner.fmt(f),
            PutMetadataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutMetadataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutMetadataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetadataError {
    fn code(&self) -> Option<&str> {
        PutMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetadataError {
    /// Creates a new `PutMetadataError`.
    pub fn new(kind: PutMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutMetadataErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `PutMetadataErrorKind::ChannelNotBroadcasting`.
    pub fn is_channel_not_broadcasting(&self) -> bool {
        matches!(&self.kind, PutMetadataErrorKind::ChannelNotBroadcasting(_))
    }
    /// Returns true if the error kind is `PutMetadataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetadataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutMetadataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutMetadataErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `PutMetadataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutMetadataErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutMetadataErrorKind::ChannelNotBroadcasting(_inner) => Some(_inner),
            PutMetadataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutMetadataErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutMetadataErrorKind::ValidationException(_inner) => Some(_inner),
            PutMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopStreamError {
    /// Kind of error that occurred.
    pub kind: StopStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopStreamErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ChannelNotBroadcasting(crate::error::ChannelNotBroadcasting),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    StreamUnavailable(crate::error::StreamUnavailable),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopStreamErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopStreamErrorKind::ChannelNotBroadcasting(_inner) => _inner.fmt(f),
            StopStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopStreamErrorKind::StreamUnavailable(_inner) => _inner.fmt(f),
            StopStreamErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopStreamError {
    fn code(&self) -> Option<&str> {
        StopStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopStreamError {
    /// Creates a new `StopStreamError`.
    pub fn new(kind: StopStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopStreamErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StopStreamErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `StopStreamErrorKind::ChannelNotBroadcasting`.
    pub fn is_channel_not_broadcasting(&self) -> bool {
        matches!(&self.kind, StopStreamErrorKind::ChannelNotBroadcasting(_))
    }
    /// Returns true if the error kind is `StopStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StopStreamErrorKind::StreamUnavailable`.
    pub fn is_stream_unavailable(&self) -> bool {
        matches!(&self.kind, StopStreamErrorKind::StreamUnavailable(_))
    }
    /// Returns true if the error kind is `StopStreamErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopStreamErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopStreamErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopStreamErrorKind::ChannelNotBroadcasting(_inner) => Some(_inner),
            StopStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopStreamErrorKind::StreamUnavailable(_inner) => Some(_inner),
            StopStreamErrorKind::ValidationException(_inner) => Some(_inner),
            StopStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p/>
    InternalServerException(crate::error::InternalServerException),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelErrorKind {
    /// <p/>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p/>
    ConflictException(crate::error::ConflictException),
    /// <p/>
    PendingVerification(crate::error::PendingVerification),
    /// <p/>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p/>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::PendingVerification(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelError {
    fn code(&self) -> Option<&str> {
        UpdateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelError {
    /// Creates a new `UpdateChannelError`.
    pub fn new(kind: UpdateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::PendingVerification`.
    pub fn is_pending_verification(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::PendingVerification(_))
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateChannelErrorKind::PendingVerification(_inner) => Some(_inner),
            UpdateChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Request references a resource which does not exist.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request references a resource which does not exist.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>Request references a resource which does not exist.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingVerification {
    /// <p> Your account is pending verification. </p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PendingVerification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingVerification");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PendingVerification {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PendingVerification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PendingVerification")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for PendingVerification {}
/// See [`PendingVerification`](crate::error::PendingVerification)
pub mod pending_verification {
    /// A builder for [`PendingVerification`](crate::error::PendingVerification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Your account is pending verification. </p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p> Your account is pending verification. </p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingVerification`](crate::error::PendingVerification)
        pub fn build(self) -> crate::error::PendingVerification {
            crate::error::PendingVerification {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl PendingVerification {
    /// Creates a new builder-style object to manufacture [`PendingVerification`](crate::error::PendingVerification)
    pub fn builder() -> crate::error::pending_verification::Builder {
        crate::error::pending_verification::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>User does not have sufficient access to perform this action.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>User does not have sufficient access to perform this action.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>User does not have sufficient access to perform this action.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>Unexpected error during processing of request.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unexpected error during processing of request.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>Unexpected error during processing of request.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamUnavailable {
    /// <p>The stream is temporarily unavailable.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StreamUnavailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamUnavailable");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StreamUnavailable {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StreamUnavailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StreamUnavailable")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for StreamUnavailable {}
/// See [`StreamUnavailable`](crate::error::StreamUnavailable)
pub mod stream_unavailable {
    /// A builder for [`StreamUnavailable`](crate::error::StreamUnavailable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stream is temporarily unavailable.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>The stream is temporarily unavailable.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamUnavailable`](crate::error::StreamUnavailable)
        pub fn build(self) -> crate::error::StreamUnavailable {
            crate::error::StreamUnavailable {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl StreamUnavailable {
    /// Creates a new builder-style object to manufacture [`StreamUnavailable`](crate::error::StreamUnavailable)
    pub fn builder() -> crate::error::stream_unavailable::Builder {
        crate::error::stream_unavailable::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelNotBroadcasting {
    /// <p>The stream is offline for the given channel ARN.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChannelNotBroadcasting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelNotBroadcasting");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ChannelNotBroadcasting {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ChannelNotBroadcasting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ChannelNotBroadcasting")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ChannelNotBroadcasting {}
/// See [`ChannelNotBroadcasting`](crate::error::ChannelNotBroadcasting)
pub mod channel_not_broadcasting {
    /// A builder for [`ChannelNotBroadcasting`](crate::error::ChannelNotBroadcasting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stream is offline for the given channel ARN.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>The stream is offline for the given channel ARN.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelNotBroadcasting`](crate::error::ChannelNotBroadcasting)
        pub fn build(self) -> crate::error::ChannelNotBroadcasting {
            crate::error::ChannelNotBroadcasting {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ChannelNotBroadcasting {
    /// Creates a new builder-style object to manufacture [`ChannelNotBroadcasting`](crate::error::ChannelNotBroadcasting)
    pub fn builder() -> crate::error::channel_not_broadcasting::Builder {
        crate::error::channel_not_broadcasting::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>Request was denied due to request throttling.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request was denied due to request throttling.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>Request was denied due to request throttling.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>Request would cause a service quota to be exceeded.</p>
    pub exception_message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("exception_message", &self.exception_message);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_message: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request would cause a service quota to be exceeded.</p>
        pub fn exception_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_message = Some(input.into());
            self
        }
        /// <p>Request would cause a service quota to be exceeded.</p>
        pub fn set_exception_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                exception_message: self.exception_message,
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
