// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateAwsAccountWithPartnerAccountInput`](crate::input::AssociateAwsAccountWithPartnerAccountInput)
pub mod associate_aws_account_with_partner_account_input {
    /// A builder for [`AssociateAwsAccountWithPartnerAccountInput`](crate::input::AssociateAwsAccountWithPartnerAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sidewalk: std::option::Option<crate::model::SidewalkAccountInfo>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkAccountInfo) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkAccountInfo>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAwsAccountWithPartnerAccountInput`](crate::input::AssociateAwsAccountWithPartnerAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAwsAccountWithPartnerAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAwsAccountWithPartnerAccountInput {
                sidewalk: self.sidewalk,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAwsAccountWithPartnerAccountInputOperationOutputAlias =
    crate::operation::AssociateAwsAccountWithPartnerAccount;
#[doc(hidden)]
pub type AssociateAwsAccountWithPartnerAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateAwsAccountWithPartnerAccountInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAwsAccountWithPartnerAccount`](crate::operation::AssociateAwsAccountWithPartnerAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAwsAccountWithPartnerAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateAwsAccountWithPartnerAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/partner-accounts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateAwsAccountWithPartnerAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateAwsAccountWithPartnerAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_aws_account_with_partner_account(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAwsAccountWithPartnerAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAwsAccountWithPartnerAccount",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateAwsAccountWithPartnerAccountInput`](crate::input::AssociateAwsAccountWithPartnerAccountInput)
    pub fn builder() -> crate::input::associate_aws_account_with_partner_account_input::Builder {
        crate::input::associate_aws_account_with_partner_account_input::Builder::default()
    }
}

/// See [`AssociateMulticastGroupWithFuotaTaskInput`](crate::input::AssociateMulticastGroupWithFuotaTaskInput)
pub mod associate_multicast_group_with_fuota_task_input {
    /// A builder for [`AssociateMulticastGroupWithFuotaTaskInput`](crate::input::AssociateMulticastGroupWithFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multicast_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multicast_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multicast_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateMulticastGroupWithFuotaTaskInput`](crate::input::AssociateMulticastGroupWithFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateMulticastGroupWithFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateMulticastGroupWithFuotaTaskInput {
                id: self.id,
                multicast_group_id: self.multicast_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateMulticastGroupWithFuotaTaskInputOperationOutputAlias =
    crate::operation::AssociateMulticastGroupWithFuotaTask;
#[doc(hidden)]
pub type AssociateMulticastGroupWithFuotaTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateMulticastGroupWithFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`AssociateMulticastGroupWithFuotaTask`](crate::operation::AssociateMulticastGroupWithFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateMulticastGroupWithFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateMulticastGroupWithFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_1, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}/multicast-group", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateMulticastGroupWithFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateMulticastGroupWithFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_multicast_group_with_fuota_task(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateMulticastGroupWithFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateMulticastGroupWithFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateMulticastGroupWithFuotaTaskInput`](crate::input::AssociateMulticastGroupWithFuotaTaskInput)
    pub fn builder() -> crate::input::associate_multicast_group_with_fuota_task_input::Builder {
        crate::input::associate_multicast_group_with_fuota_task_input::Builder::default()
    }
}

/// See [`AssociateWirelessDeviceWithFuotaTaskInput`](crate::input::AssociateWirelessDeviceWithFuotaTaskInput)
pub mod associate_wireless_device_with_fuota_task_input {
    /// A builder for [`AssociateWirelessDeviceWithFuotaTaskInput`](crate::input::AssociateWirelessDeviceWithFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateWirelessDeviceWithFuotaTaskInput`](crate::input::AssociateWirelessDeviceWithFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateWirelessDeviceWithFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateWirelessDeviceWithFuotaTaskInput {
                id: self.id,
                wireless_device_id: self.wireless_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateWirelessDeviceWithFuotaTaskInputOperationOutputAlias =
    crate::operation::AssociateWirelessDeviceWithFuotaTask;
#[doc(hidden)]
pub type AssociateWirelessDeviceWithFuotaTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateWirelessDeviceWithFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`AssociateWirelessDeviceWithFuotaTask`](crate::operation::AssociateWirelessDeviceWithFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateWirelessDeviceWithFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateWirelessDeviceWithFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_2, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}/wireless-device", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateWirelessDeviceWithFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateWirelessDeviceWithFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_wireless_device_with_fuota_task(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateWirelessDeviceWithFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateWirelessDeviceWithFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithFuotaTaskInput`](crate::input::AssociateWirelessDeviceWithFuotaTaskInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_fuota_task_input::Builder {
        crate::input::associate_wireless_device_with_fuota_task_input::Builder::default()
    }
}

/// See [`AssociateWirelessDeviceWithMulticastGroupInput`](crate::input::AssociateWirelessDeviceWithMulticastGroupInput)
pub mod associate_wireless_device_with_multicast_group_input {
    /// A builder for [`AssociateWirelessDeviceWithMulticastGroupInput`](crate::input::AssociateWirelessDeviceWithMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateWirelessDeviceWithMulticastGroupInput`](crate::input::AssociateWirelessDeviceWithMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateWirelessDeviceWithMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AssociateWirelessDeviceWithMulticastGroupInput {
                    id: self.id,
                    wireless_device_id: self.wireless_device_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AssociateWirelessDeviceWithMulticastGroupInputOperationOutputAlias =
    crate::operation::AssociateWirelessDeviceWithMulticastGroup;
#[doc(hidden)]
pub type AssociateWirelessDeviceWithMulticastGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateWirelessDeviceWithMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociateWirelessDeviceWithMulticastGroup`](crate::operation::AssociateWirelessDeviceWithMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateWirelessDeviceWithMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateWirelessDeviceWithMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_3, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/wireless-device", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateWirelessDeviceWithMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateWirelessDeviceWithMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_wireless_device_with_multicast_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateWirelessDeviceWithMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateWirelessDeviceWithMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithMulticastGroupInput`](crate::input::AssociateWirelessDeviceWithMulticastGroupInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_multicast_group_input::Builder
    {
        crate::input::associate_wireless_device_with_multicast_group_input::Builder::default()
    }
}

/// See [`AssociateWirelessDeviceWithThingInput`](crate::input::AssociateWirelessDeviceWithThingInput)
pub mod associate_wireless_device_with_thing_input {
    /// A builder for [`AssociateWirelessDeviceWithThingInput`](crate::input::AssociateWirelessDeviceWithThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateWirelessDeviceWithThingInput`](crate::input::AssociateWirelessDeviceWithThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateWirelessDeviceWithThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateWirelessDeviceWithThingInput {
                id: self.id,
                thing_arn: self.thing_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateWirelessDeviceWithThingInputOperationOutputAlias =
    crate::operation::AssociateWirelessDeviceWithThing;
#[doc(hidden)]
pub type AssociateWirelessDeviceWithThingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateWirelessDeviceWithThingInput {
    /// Consumes the builder and constructs an Operation<[`AssociateWirelessDeviceWithThing`](crate::operation::AssociateWirelessDeviceWithThing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateWirelessDeviceWithThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateWirelessDeviceWithThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_4, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/thing", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateWirelessDeviceWithThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateWirelessDeviceWithThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_wireless_device_with_thing(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateWirelessDeviceWithThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateWirelessDeviceWithThing",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithThingInput`](crate::input::AssociateWirelessDeviceWithThingInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_thing_input::Builder {
        crate::input::associate_wireless_device_with_thing_input::Builder::default()
    }
}

/// See [`AssociateWirelessGatewayWithCertificateInput`](crate::input::AssociateWirelessGatewayWithCertificateInput)
pub mod associate_wireless_gateway_with_certificate_input {
    /// A builder for [`AssociateWirelessGatewayWithCertificateInput`](crate::input::AssociateWirelessGatewayWithCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) iot_certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn iot_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn set_iot_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iot_certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateWirelessGatewayWithCertificateInput`](crate::input::AssociateWirelessGatewayWithCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateWirelessGatewayWithCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateWirelessGatewayWithCertificateInput {
                id: self.id,
                iot_certificate_id: self.iot_certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateWirelessGatewayWithCertificateInputOperationOutputAlias =
    crate::operation::AssociateWirelessGatewayWithCertificate;
#[doc(hidden)]
pub type AssociateWirelessGatewayWithCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateWirelessGatewayWithCertificateInput {
    /// Consumes the builder and constructs an Operation<[`AssociateWirelessGatewayWithCertificate`](crate::operation::AssociateWirelessGatewayWithCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateWirelessGatewayWithCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateWirelessGatewayWithCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_5, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/certificate", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateWirelessGatewayWithCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateWirelessGatewayWithCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_wireless_gateway_with_certificate(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateWirelessGatewayWithCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateWirelessGatewayWithCertificate",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateWirelessGatewayWithCertificateInput`](crate::input::AssociateWirelessGatewayWithCertificateInput)
    pub fn builder() -> crate::input::associate_wireless_gateway_with_certificate_input::Builder {
        crate::input::associate_wireless_gateway_with_certificate_input::Builder::default()
    }
}

/// See [`AssociateWirelessGatewayWithThingInput`](crate::input::AssociateWirelessGatewayWithThingInput)
pub mod associate_wireless_gateway_with_thing_input {
    /// A builder for [`AssociateWirelessGatewayWithThingInput`](crate::input::AssociateWirelessGatewayWithThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateWirelessGatewayWithThingInput`](crate::input::AssociateWirelessGatewayWithThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateWirelessGatewayWithThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateWirelessGatewayWithThingInput {
                id: self.id,
                thing_arn: self.thing_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateWirelessGatewayWithThingInputOperationOutputAlias =
    crate::operation::AssociateWirelessGatewayWithThing;
#[doc(hidden)]
pub type AssociateWirelessGatewayWithThingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateWirelessGatewayWithThingInput {
    /// Consumes the builder and constructs an Operation<[`AssociateWirelessGatewayWithThing`](crate::operation::AssociateWirelessGatewayWithThing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateWirelessGatewayWithThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateWirelessGatewayWithThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_6, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/thing", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateWirelessGatewayWithThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateWirelessGatewayWithThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_wireless_gateway_with_thing(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateWirelessGatewayWithThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateWirelessGatewayWithThing",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateWirelessGatewayWithThingInput`](crate::input::AssociateWirelessGatewayWithThingInput)
    pub fn builder() -> crate::input::associate_wireless_gateway_with_thing_input::Builder {
        crate::input::associate_wireless_gateway_with_thing_input::Builder::default()
    }
}

/// See [`CancelMulticastGroupSessionInput`](crate::input::CancelMulticastGroupSessionInput)
pub mod cancel_multicast_group_session_input {
    /// A builder for [`CancelMulticastGroupSessionInput`](crate::input::CancelMulticastGroupSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelMulticastGroupSessionInput`](crate::input::CancelMulticastGroupSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelMulticastGroupSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelMulticastGroupSessionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type CancelMulticastGroupSessionInputOperationOutputAlias =
    crate::operation::CancelMulticastGroupSession;
#[doc(hidden)]
pub type CancelMulticastGroupSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelMulticastGroupSessionInput {
    /// Consumes the builder and constructs an Operation<[`CancelMulticastGroupSession`](crate::operation::CancelMulticastGroupSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelMulticastGroupSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelMulticastGroupSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_7, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/session", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelMulticastGroupSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelMulticastGroupSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelMulticastGroupSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelMulticastGroupSession",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelMulticastGroupSessionInput`](crate::input::CancelMulticastGroupSessionInput)
    pub fn builder() -> crate::input::cancel_multicast_group_session_input::Builder {
        crate::input::cancel_multicast_group_session_input::Builder::default()
    }
}

/// See [`CreateDestinationInput`](crate::input::CreateDestinationInput)
pub mod create_destination_input {
    /// A builder for [`CreateDestinationInput`](crate::input::CreateDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) expression_type: std::option::Option<crate::model::ExpressionType>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.expression_type = Some(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.expression_type = input;
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDestinationInput`](crate::input::CreateDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDestinationInput {
                name: self.name,
                expression_type: self.expression_type,
                expression: self.expression,
                description: self.description,
                role_arn: self.role_arn,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDestinationInputOperationOutputAlias = crate::operation::CreateDestination;
#[doc(hidden)]
pub type CreateDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateDestination`](crate::operation::CreateDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/destinations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_destination(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDestination",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDestinationInput`](crate::input::CreateDestinationInput)
    pub fn builder() -> crate::input::create_destination_input::Builder {
        crate::input::create_destination_input::Builder::default()
    }
}

/// See [`CreateDeviceProfileInput`](crate::input::CreateDeviceProfileInput)
pub mod create_device_profile_input {
    /// A builder for [`CreateDeviceProfileInput`](crate::input::CreateDeviceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanDeviceProfile>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanDeviceProfile) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDeviceProfile>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceProfileInput`](crate::input::CreateDeviceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeviceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeviceProfileInput {
                name: self.name,
                lo_ra_wan: self.lo_ra_wan,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeviceProfileInputOperationOutputAlias = crate::operation::CreateDeviceProfile;
#[doc(hidden)]
pub type CreateDeviceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeviceProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeviceProfile`](crate::operation::CreateDeviceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeviceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeviceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/device-profiles").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeviceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeviceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_device_profile(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeviceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeviceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeviceProfileInput`](crate::input::CreateDeviceProfileInput)
    pub fn builder() -> crate::input::create_device_profile_input::Builder {
        crate::input::create_device_profile_input::Builder::default()
    }
}

/// See [`CreateFuotaTaskInput`](crate::input::CreateFuotaTaskInput)
pub mod create_fuota_task_input {
    /// A builder for [`CreateFuotaTaskInput`](crate::input::CreateFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanFuotaTask>,
        pub(crate) firmware_update_image: std::option::Option<std::string::String>,
        pub(crate) firmware_update_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of a FUOTA task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanFuotaTask) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanFuotaTask>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn firmware_update_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.firmware_update_image = Some(input.into());
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firmware_update_image = input;
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn firmware_update_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.firmware_update_role = Some(input.into());
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firmware_update_role = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFuotaTaskInput`](crate::input::CreateFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFuotaTaskInput {
                name: self.name,
                description: self.description,
                client_request_token: self.client_request_token,
                lo_ra_wan: self.lo_ra_wan,
                firmware_update_image: self.firmware_update_image,
                firmware_update_role: self.firmware_update_role,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFuotaTaskInputOperationOutputAlias = crate::operation::CreateFuotaTask;
#[doc(hidden)]
pub type CreateFuotaTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateFuotaTask`](crate::operation::CreateFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/fuota-tasks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fuota_task(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFuotaTaskInput`](crate::input::CreateFuotaTaskInput)
    pub fn builder() -> crate::input::create_fuota_task_input::Builder {
        crate::input::create_fuota_task_input::Builder::default()
    }
}

/// See [`CreateMulticastGroupInput`](crate::input::CreateMulticastGroupInput)
pub mod create_multicast_group_input {
    /// A builder for [`CreateMulticastGroupInput`](crate::input::CreateMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticast>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the multicast group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the multicast group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the multicast group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticast) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticast>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMulticastGroupInput`](crate::input::CreateMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMulticastGroupInput {
                name: self.name,
                description: self.description,
                client_request_token: self.client_request_token,
                lo_ra_wan: self.lo_ra_wan,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMulticastGroupInputOperationOutputAlias = crate::operation::CreateMulticastGroup;
#[doc(hidden)]
pub type CreateMulticastGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateMulticastGroup`](crate::operation::CreateMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/multicast-groups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_multicast_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMulticastGroupInput`](crate::input::CreateMulticastGroupInput)
    pub fn builder() -> crate::input::create_multicast_group_input::Builder {
        crate::input::create_multicast_group_input::Builder::default()
    }
}

/// See [`CreateServiceProfileInput`](crate::input::CreateServiceProfileInput)
pub mod create_service_profile_input {
    /// A builder for [`CreateServiceProfileInput`](crate::input::CreateServiceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanServiceProfile>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanServiceProfile) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanServiceProfile>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceProfileInput`](crate::input::CreateServiceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceProfileInput {
                name: self.name,
                lo_ra_wan: self.lo_ra_wan,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceProfileInputOperationOutputAlias = crate::operation::CreateServiceProfile;
#[doc(hidden)]
pub type CreateServiceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateServiceProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceProfile`](crate::operation::CreateServiceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/service-profiles").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_service_profile(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceProfileInput`](crate::input::CreateServiceProfileInput)
    pub fn builder() -> crate::input::create_service_profile_input::Builder {
        crate::input::create_service_profile_input::Builder::default()
    }
}

/// See [`CreateWirelessDeviceInput`](crate::input::CreateWirelessDeviceInput)
pub mod create_wireless_device_input {
    /// A builder for [`CreateWirelessDeviceInput`](crate::input::CreateWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WirelessDeviceType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanDevice>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The wireless device type.</p>
        pub fn r#type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The wireless device type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_name = Some(input.into());
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_name = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanDevice) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDevice>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWirelessDeviceInput`](crate::input::CreateWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWirelessDeviceInput {
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                destination_name: self.destination_name,
                client_request_token: self.client_request_token,
                lo_ra_wan: self.lo_ra_wan,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWirelessDeviceInputOperationOutputAlias = crate::operation::CreateWirelessDevice;
#[doc(hidden)]
pub type CreateWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`CreateWirelessDevice`](crate::operation::CreateWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-devices").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_wireless_device(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWirelessDeviceInput`](crate::input::CreateWirelessDeviceInput)
    pub fn builder() -> crate::input::create_wireless_device_input::Builder {
        crate::input::create_wireless_device_input::Builder::default()
    }
}

/// See [`CreateWirelessGatewayInput`](crate::input::CreateWirelessGatewayInput)
pub mod create_wireless_gateway_input {
    /// A builder for [`CreateWirelessGatewayInput`](crate::input::CreateWirelessGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanGateway>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanGateway) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGateway>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWirelessGatewayInput`](crate::input::CreateWirelessGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWirelessGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWirelessGatewayInput {
                name: self.name,
                description: self.description,
                lo_ra_wan: self.lo_ra_wan,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWirelessGatewayInputOperationOutputAlias = crate::operation::CreateWirelessGateway;
#[doc(hidden)]
pub type CreateWirelessGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWirelessGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateWirelessGateway`](crate::operation::CreateWirelessGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWirelessGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWirelessGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-gateways").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWirelessGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWirelessGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_wireless_gateway(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWirelessGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWirelessGateway",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayInput`](crate::input::CreateWirelessGatewayInput)
    pub fn builder() -> crate::input::create_wireless_gateway_input::Builder {
        crate::input::create_wireless_gateway_input::Builder::default()
    }
}

/// See [`CreateWirelessGatewayTaskInput`](crate::input::CreateWirelessGatewayTaskInput)
pub mod create_wireless_gateway_task_input {
    /// A builder for [`CreateWirelessGatewayTaskInput`](crate::input::CreateWirelessGatewayTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) wireless_gateway_task_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn wireless_gateway_task_definition_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.wireless_gateway_task_definition_id = Some(input.into());
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn set_wireless_gateway_task_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_gateway_task_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWirelessGatewayTaskInput`](crate::input::CreateWirelessGatewayTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWirelessGatewayTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWirelessGatewayTaskInput {
                id: self.id,
                wireless_gateway_task_definition_id: self.wireless_gateway_task_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWirelessGatewayTaskInputOperationOutputAlias =
    crate::operation::CreateWirelessGatewayTask;
#[doc(hidden)]
pub type CreateWirelessGatewayTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWirelessGatewayTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateWirelessGatewayTask`](crate::operation::CreateWirelessGatewayTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWirelessGatewayTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWirelessGatewayTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_8, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/tasks", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWirelessGatewayTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWirelessGatewayTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_wireless_gateway_task(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWirelessGatewayTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWirelessGatewayTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayTaskInput`](crate::input::CreateWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::create_wireless_gateway_task_input::Builder {
        crate::input::create_wireless_gateway_task_input::Builder::default()
    }
}

/// See [`CreateWirelessGatewayTaskDefinitionInput`](crate::input::CreateWirelessGatewayTaskDefinitionInput)
pub mod create_wireless_gateway_task_definition_input {
    /// A builder for [`CreateWirelessGatewayTaskDefinitionInput`](crate::input::CreateWirelessGatewayTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_create_tasks: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) update: std::option::Option<crate::model::UpdateWirelessGatewayTaskCreate>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn auto_create_tasks(mut self, input: bool) -> Self {
            self.auto_create_tasks = Some(input);
            self
        }
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn set_auto_create_tasks(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_create_tasks = input;
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn update(mut self, input: crate::model::UpdateWirelessGatewayTaskCreate) -> Self {
            self.update = Some(input);
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn set_update(
            mut self,
            input: std::option::Option<crate::model::UpdateWirelessGatewayTaskCreate>,
        ) -> Self {
            self.update = input;
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWirelessGatewayTaskDefinitionInput`](crate::input::CreateWirelessGatewayTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWirelessGatewayTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWirelessGatewayTaskDefinitionInput {
                auto_create_tasks: self.auto_create_tasks.unwrap_or_default(),
                name: self.name,
                update: self.update,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWirelessGatewayTaskDefinitionInputOperationOutputAlias =
    crate::operation::CreateWirelessGatewayTaskDefinition;
#[doc(hidden)]
pub type CreateWirelessGatewayTaskDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateWirelessGatewayTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateWirelessGatewayTaskDefinition`](crate::operation::CreateWirelessGatewayTaskDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWirelessGatewayTaskDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWirelessGatewayTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-gateway-task-definitions")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWirelessGatewayTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWirelessGatewayTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_wireless_gateway_task_definition(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWirelessGatewayTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWirelessGatewayTaskDefinition",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayTaskDefinitionInput`](crate::input::CreateWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::create_wireless_gateway_task_definition_input::Builder {
        crate::input::create_wireless_gateway_task_definition_input::Builder::default()
    }
}

/// See [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
pub mod delete_destination_input {
    /// A builder for [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDestinationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteDestinationInputOperationOutputAlias = crate::operation::DeleteDestination;
#[doc(hidden)]
pub type DeleteDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDestination`](crate::operation::DeleteDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_9, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/destinations/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDestination",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
    pub fn builder() -> crate::input::delete_destination_input::Builder {
        crate::input::delete_destination_input::Builder::default()
    }
}

/// See [`DeleteDeviceProfileInput`](crate::input::DeleteDeviceProfileInput)
pub mod delete_device_profile_input {
    /// A builder for [`DeleteDeviceProfileInput`](crate::input::DeleteDeviceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceProfileInput`](crate::input::DeleteDeviceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceProfileInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceProfileInputOperationOutputAlias = crate::operation::DeleteDeviceProfile;
#[doc(hidden)]
pub type DeleteDeviceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDeviceProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeviceProfile`](crate::operation::DeleteDeviceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeviceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_10, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/device-profiles/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeviceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeviceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceProfileInput`](crate::input::DeleteDeviceProfileInput)
    pub fn builder() -> crate::input::delete_device_profile_input::Builder {
        crate::input::delete_device_profile_input::Builder::default()
    }
}

/// See [`DeleteFuotaTaskInput`](crate::input::DeleteFuotaTaskInput)
pub mod delete_fuota_task_input {
    /// A builder for [`DeleteFuotaTaskInput`](crate::input::DeleteFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFuotaTaskInput`](crate::input::DeleteFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFuotaTaskInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteFuotaTaskInputOperationOutputAlias = crate::operation::DeleteFuotaTask;
#[doc(hidden)]
pub type DeleteFuotaTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFuotaTask`](crate::operation::DeleteFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_11, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFuotaTaskInput`](crate::input::DeleteFuotaTaskInput)
    pub fn builder() -> crate::input::delete_fuota_task_input::Builder {
        crate::input::delete_fuota_task_input::Builder::default()
    }
}

/// See [`DeleteMulticastGroupInput`](crate::input::DeleteMulticastGroupInput)
pub mod delete_multicast_group_input {
    /// A builder for [`DeleteMulticastGroupInput`](crate::input::DeleteMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMulticastGroupInput`](crate::input::DeleteMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMulticastGroupInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteMulticastGroupInputOperationOutputAlias = crate::operation::DeleteMulticastGroup;
#[doc(hidden)]
pub type DeleteMulticastGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMulticastGroup`](crate::operation::DeleteMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_12, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMulticastGroupInput`](crate::input::DeleteMulticastGroupInput)
    pub fn builder() -> crate::input::delete_multicast_group_input::Builder {
        crate::input::delete_multicast_group_input::Builder::default()
    }
}

/// See [`DeleteQueuedMessagesInput`](crate::input::DeleteQueuedMessagesInput)
pub mod delete_queued_messages_input {
    /// A builder for [`DeleteQueuedMessagesInput`](crate::input::DeleteQueuedMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
    }
    impl Builder {
        /// <p>Id of a given wireless device which messages will be deleted </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Id of a given wireless device which messages will be deleted </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.wireless_device_type = Some(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.wireless_device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQueuedMessagesInput`](crate::input::DeleteQueuedMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQueuedMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQueuedMessagesInput {
                id: self.id,
                message_id: self.message_id,
                wireless_device_type: self.wireless_device_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteQueuedMessagesInputOperationOutputAlias = crate::operation::DeleteQueuedMessages;
#[doc(hidden)]
pub type DeleteQueuedMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteQueuedMessagesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQueuedMessages`](crate::operation::DeleteQueuedMessages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQueuedMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQueuedMessagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_13, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/data", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteQueuedMessagesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.message_id {
                query.push_kv("messageId", &aws_smithy_http::query::fmt_string(&inner_14));
            }
            if let Some(inner_15) = &_input.wireless_device_type {
                query.push_kv(
                    "WirelessDeviceType",
                    &aws_smithy_http::query::fmt_string(&inner_15),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQueuedMessagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQueuedMessagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQueuedMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQueuedMessages",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQueuedMessagesInput`](crate::input::DeleteQueuedMessagesInput)
    pub fn builder() -> crate::input::delete_queued_messages_input::Builder {
        crate::input::delete_queued_messages_input::Builder::default()
    }
}

/// See [`DeleteServiceProfileInput`](crate::input::DeleteServiceProfileInput)
pub mod delete_service_profile_input {
    /// A builder for [`DeleteServiceProfileInput`](crate::input::DeleteServiceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceProfileInput`](crate::input::DeleteServiceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceProfileInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceProfileInputOperationOutputAlias = crate::operation::DeleteServiceProfile;
#[doc(hidden)]
pub type DeleteServiceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteServiceProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceProfile`](crate::operation::DeleteServiceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_16, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/service-profiles/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceProfileInput`](crate::input::DeleteServiceProfileInput)
    pub fn builder() -> crate::input::delete_service_profile_input::Builder {
        crate::input::delete_service_profile_input::Builder::default()
    }
}

/// See [`DeleteWirelessDeviceInput`](crate::input::DeleteWirelessDeviceInput)
pub mod delete_wireless_device_input {
    /// A builder for [`DeleteWirelessDeviceInput`](crate::input::DeleteWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWirelessDeviceInput`](crate::input::DeleteWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWirelessDeviceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteWirelessDeviceInputOperationOutputAlias = crate::operation::DeleteWirelessDevice;
#[doc(hidden)]
pub type DeleteWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWirelessDevice`](crate::operation::DeleteWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_17, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWirelessDeviceInput`](crate::input::DeleteWirelessDeviceInput)
    pub fn builder() -> crate::input::delete_wireless_device_input::Builder {
        crate::input::delete_wireless_device_input::Builder::default()
    }
}

/// See [`DeleteWirelessGatewayInput`](crate::input::DeleteWirelessGatewayInput)
pub mod delete_wireless_gateway_input {
    /// A builder for [`DeleteWirelessGatewayInput`](crate::input::DeleteWirelessGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWirelessGatewayInput`](crate::input::DeleteWirelessGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWirelessGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWirelessGatewayInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteWirelessGatewayInputOperationOutputAlias = crate::operation::DeleteWirelessGateway;
#[doc(hidden)]
pub type DeleteWirelessGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWirelessGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWirelessGateway`](crate::operation::DeleteWirelessGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWirelessGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWirelessGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_18, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWirelessGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWirelessGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWirelessGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWirelessGateway",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayInput`](crate::input::DeleteWirelessGatewayInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_input::Builder {
        crate::input::delete_wireless_gateway_input::Builder::default()
    }
}

/// See [`DeleteWirelessGatewayTaskInput`](crate::input::DeleteWirelessGatewayTaskInput)
pub mod delete_wireless_gateway_task_input {
    /// A builder for [`DeleteWirelessGatewayTaskInput`](crate::input::DeleteWirelessGatewayTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWirelessGatewayTaskInput`](crate::input::DeleteWirelessGatewayTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWirelessGatewayTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWirelessGatewayTaskInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteWirelessGatewayTaskInputOperationOutputAlias =
    crate::operation::DeleteWirelessGatewayTask;
#[doc(hidden)]
pub type DeleteWirelessGatewayTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWirelessGatewayTaskInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWirelessGatewayTask`](crate::operation::DeleteWirelessGatewayTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWirelessGatewayTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWirelessGatewayTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_19, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/tasks", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWirelessGatewayTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWirelessGatewayTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWirelessGatewayTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWirelessGatewayTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayTaskInput`](crate::input::DeleteWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_task_input::Builder {
        crate::input::delete_wireless_gateway_task_input::Builder::default()
    }
}

/// See [`DeleteWirelessGatewayTaskDefinitionInput`](crate::input::DeleteWirelessGatewayTaskDefinitionInput)
pub mod delete_wireless_gateway_task_definition_input {
    /// A builder for [`DeleteWirelessGatewayTaskDefinitionInput`](crate::input::DeleteWirelessGatewayTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWirelessGatewayTaskDefinitionInput`](crate::input::DeleteWirelessGatewayTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWirelessGatewayTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWirelessGatewayTaskDefinitionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteWirelessGatewayTaskDefinitionInputOperationOutputAlias =
    crate::operation::DeleteWirelessGatewayTaskDefinition;
#[doc(hidden)]
pub type DeleteWirelessGatewayTaskDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWirelessGatewayTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWirelessGatewayTaskDefinition`](crate::operation::DeleteWirelessGatewayTaskDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWirelessGatewayTaskDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWirelessGatewayTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_20, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateway-task-definitions/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWirelessGatewayTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWirelessGatewayTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWirelessGatewayTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWirelessGatewayTaskDefinition",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayTaskDefinitionInput`](crate::input::DeleteWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_task_definition_input::Builder {
        crate::input::delete_wireless_gateway_task_definition_input::Builder::default()
    }
}

/// See [`DisassociateAwsAccountFromPartnerAccountInput`](crate::input::DisassociateAwsAccountFromPartnerAccountInput)
pub mod disassociate_aws_account_from_partner_account_input {
    /// A builder for [`DisassociateAwsAccountFromPartnerAccountInput`](crate::input::DisassociateAwsAccountFromPartnerAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partner_account_id: std::option::Option<std::string::String>,
        pub(crate) partner_type: std::option::Option<crate::model::PartnerType>,
    }
    impl Builder {
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_account_id = Some(input.into());
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partner_account_id = input;
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.partner_type = Some(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.partner_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAwsAccountFromPartnerAccountInput`](crate::input::DisassociateAwsAccountFromPartnerAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateAwsAccountFromPartnerAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateAwsAccountFromPartnerAccountInput {
                    partner_account_id: self.partner_account_id,
                    partner_type: self.partner_type,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateAwsAccountFromPartnerAccountInputOperationOutputAlias =
    crate::operation::DisassociateAwsAccountFromPartnerAccount;
#[doc(hidden)]
pub type DisassociateAwsAccountFromPartnerAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateAwsAccountFromPartnerAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateAwsAccountFromPartnerAccount`](crate::operation::DisassociateAwsAccountFromPartnerAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateAwsAccountFromPartnerAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateAwsAccountFromPartnerAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.partner_account_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "partner_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let partner_account_id = aws_smithy_http::label::fmt_string(input_21, false);
            if partner_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "partner_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/partner-accounts/{PartnerAccountId}",
                PartnerAccountId = partner_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateAwsAccountFromPartnerAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_22) = &_input.partner_type {
                query.push_kv(
                    "partnerType",
                    &aws_smithy_http::query::fmt_string(&inner_22),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateAwsAccountFromPartnerAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateAwsAccountFromPartnerAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateAwsAccountFromPartnerAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateAwsAccountFromPartnerAccount",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateAwsAccountFromPartnerAccountInput`](crate::input::DisassociateAwsAccountFromPartnerAccountInput)
    pub fn builder() -> crate::input::disassociate_aws_account_from_partner_account_input::Builder {
        crate::input::disassociate_aws_account_from_partner_account_input::Builder::default()
    }
}

/// See [`DisassociateMulticastGroupFromFuotaTaskInput`](crate::input::DisassociateMulticastGroupFromFuotaTaskInput)
pub mod disassociate_multicast_group_from_fuota_task_input {
    /// A builder for [`DisassociateMulticastGroupFromFuotaTaskInput`](crate::input::DisassociateMulticastGroupFromFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multicast_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multicast_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multicast_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMulticastGroupFromFuotaTaskInput`](crate::input::DisassociateMulticastGroupFromFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMulticastGroupFromFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMulticastGroupFromFuotaTaskInput {
                id: self.id,
                multicast_group_id: self.multicast_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMulticastGroupFromFuotaTaskInputOperationOutputAlias =
    crate::operation::DisassociateMulticastGroupFromFuotaTask;
#[doc(hidden)]
pub type DisassociateMulticastGroupFromFuotaTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateMulticastGroupFromFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMulticastGroupFromFuotaTask`](crate::operation::DisassociateMulticastGroupFromFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMulticastGroupFromFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateMulticastGroupFromFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_23, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_24 = &_input.multicast_group_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "multicast_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let multicast_group_id = aws_smithy_http::label::fmt_string(input_24, false);
            if multicast_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "multicast_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/fuota-tasks/{Id}/multicast-groups/{MulticastGroupId}",
                Id = id,
                MulticastGroupId = multicast_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateMulticastGroupFromFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateMulticastGroupFromFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMulticastGroupFromFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMulticastGroupFromFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMulticastGroupFromFuotaTaskInput`](crate::input::DisassociateMulticastGroupFromFuotaTaskInput)
    pub fn builder() -> crate::input::disassociate_multicast_group_from_fuota_task_input::Builder {
        crate::input::disassociate_multicast_group_from_fuota_task_input::Builder::default()
    }
}

/// See [`DisassociateWirelessDeviceFromFuotaTaskInput`](crate::input::DisassociateWirelessDeviceFromFuotaTaskInput)
pub mod disassociate_wireless_device_from_fuota_task_input {
    /// A builder for [`DisassociateWirelessDeviceFromFuotaTaskInput`](crate::input::DisassociateWirelessDeviceFromFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateWirelessDeviceFromFuotaTaskInput`](crate::input::DisassociateWirelessDeviceFromFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateWirelessDeviceFromFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateWirelessDeviceFromFuotaTaskInput {
                id: self.id,
                wireless_device_id: self.wireless_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromFuotaTaskInputOperationOutputAlias =
    crate::operation::DisassociateWirelessDeviceFromFuotaTask;
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromFuotaTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateWirelessDeviceFromFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateWirelessDeviceFromFuotaTask`](crate::operation::DisassociateWirelessDeviceFromFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateWirelessDeviceFromFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateWirelessDeviceFromFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_25, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.wireless_device_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "wireless_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let wireless_device_id = aws_smithy_http::label::fmt_string(input_26, false);
            if wireless_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "wireless_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/fuota-tasks/{Id}/wireless-devices/{WirelessDeviceId}",
                Id = id,
                WirelessDeviceId = wireless_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateWirelessDeviceFromFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateWirelessDeviceFromFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateWirelessDeviceFromFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateWirelessDeviceFromFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromFuotaTaskInput`](crate::input::DisassociateWirelessDeviceFromFuotaTaskInput)
    pub fn builder() -> crate::input::disassociate_wireless_device_from_fuota_task_input::Builder {
        crate::input::disassociate_wireless_device_from_fuota_task_input::Builder::default()
    }
}

/// See [`DisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::DisassociateWirelessDeviceFromMulticastGroupInput)
pub mod disassociate_wireless_device_from_multicast_group_input {
    /// A builder for [`DisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::DisassociateWirelessDeviceFromMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::DisassociateWirelessDeviceFromMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateWirelessDeviceFromMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateWirelessDeviceFromMulticastGroupInput {
                    id: self.id,
                    wireless_device_id: self.wireless_device_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromMulticastGroupInputOperationOutputAlias =
    crate::operation::DisassociateWirelessDeviceFromMulticastGroup;
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromMulticastGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateWirelessDeviceFromMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateWirelessDeviceFromMulticastGroup`](crate::operation::DisassociateWirelessDeviceFromMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateWirelessDeviceFromMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateWirelessDeviceFromMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_27, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.wireless_device_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "wireless_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let wireless_device_id = aws_smithy_http::label::fmt_string(input_28, false);
            if wireless_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "wireless_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/multicast-groups/{Id}/wireless-devices/{WirelessDeviceId}",
                Id = id,
                WirelessDeviceId = wireless_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateWirelessDeviceFromMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateWirelessDeviceFromMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateWirelessDeviceFromMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateWirelessDeviceFromMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::DisassociateWirelessDeviceFromMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::disassociate_wireless_device_from_multicast_group_input::Builder {
        crate::input::disassociate_wireless_device_from_multicast_group_input::Builder::default()
    }
}

/// See [`DisassociateWirelessDeviceFromThingInput`](crate::input::DisassociateWirelessDeviceFromThingInput)
pub mod disassociate_wireless_device_from_thing_input {
    /// A builder for [`DisassociateWirelessDeviceFromThingInput`](crate::input::DisassociateWirelessDeviceFromThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateWirelessDeviceFromThingInput`](crate::input::DisassociateWirelessDeviceFromThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateWirelessDeviceFromThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateWirelessDeviceFromThingInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromThingInputOperationOutputAlias =
    crate::operation::DisassociateWirelessDeviceFromThing;
#[doc(hidden)]
pub type DisassociateWirelessDeviceFromThingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateWirelessDeviceFromThingInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateWirelessDeviceFromThing`](crate::operation::DisassociateWirelessDeviceFromThing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateWirelessDeviceFromThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateWirelessDeviceFromThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_29, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/thing", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateWirelessDeviceFromThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateWirelessDeviceFromThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateWirelessDeviceFromThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateWirelessDeviceFromThing",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromThingInput`](crate::input::DisassociateWirelessDeviceFromThingInput)
    pub fn builder() -> crate::input::disassociate_wireless_device_from_thing_input::Builder {
        crate::input::disassociate_wireless_device_from_thing_input::Builder::default()
    }
}

/// See [`DisassociateWirelessGatewayFromCertificateInput`](crate::input::DisassociateWirelessGatewayFromCertificateInput)
pub mod disassociate_wireless_gateway_from_certificate_input {
    /// A builder for [`DisassociateWirelessGatewayFromCertificateInput`](crate::input::DisassociateWirelessGatewayFromCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateWirelessGatewayFromCertificateInput`](crate::input::DisassociateWirelessGatewayFromCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateWirelessGatewayFromCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateWirelessGatewayFromCertificateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DisassociateWirelessGatewayFromCertificateInputOperationOutputAlias =
    crate::operation::DisassociateWirelessGatewayFromCertificate;
#[doc(hidden)]
pub type DisassociateWirelessGatewayFromCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateWirelessGatewayFromCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateWirelessGatewayFromCertificate`](crate::operation::DisassociateWirelessGatewayFromCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateWirelessGatewayFromCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateWirelessGatewayFromCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_30, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/certificate", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateWirelessGatewayFromCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateWirelessGatewayFromCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateWirelessGatewayFromCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateWirelessGatewayFromCertificate",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessGatewayFromCertificateInput`](crate::input::DisassociateWirelessGatewayFromCertificateInput)
    pub fn builder() -> crate::input::disassociate_wireless_gateway_from_certificate_input::Builder
    {
        crate::input::disassociate_wireless_gateway_from_certificate_input::Builder::default()
    }
}

/// See [`DisassociateWirelessGatewayFromThingInput`](crate::input::DisassociateWirelessGatewayFromThingInput)
pub mod disassociate_wireless_gateway_from_thing_input {
    /// A builder for [`DisassociateWirelessGatewayFromThingInput`](crate::input::DisassociateWirelessGatewayFromThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateWirelessGatewayFromThingInput`](crate::input::DisassociateWirelessGatewayFromThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateWirelessGatewayFromThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateWirelessGatewayFromThingInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DisassociateWirelessGatewayFromThingInputOperationOutputAlias =
    crate::operation::DisassociateWirelessGatewayFromThing;
#[doc(hidden)]
pub type DisassociateWirelessGatewayFromThingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateWirelessGatewayFromThingInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateWirelessGatewayFromThing`](crate::operation::DisassociateWirelessGatewayFromThing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateWirelessGatewayFromThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateWirelessGatewayFromThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_31, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/thing", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateWirelessGatewayFromThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateWirelessGatewayFromThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateWirelessGatewayFromThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateWirelessGatewayFromThing",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessGatewayFromThingInput`](crate::input::DisassociateWirelessGatewayFromThingInput)
    pub fn builder() -> crate::input::disassociate_wireless_gateway_from_thing_input::Builder {
        crate::input::disassociate_wireless_gateway_from_thing_input::Builder::default()
    }
}

/// See [`GetDestinationInput`](crate::input::GetDestinationInput)
pub mod get_destination_input {
    /// A builder for [`GetDestinationInput`](crate::input::GetDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDestinationInput`](crate::input::GetDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDestinationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetDestinationInputOperationOutputAlias = crate::operation::GetDestination;
#[doc(hidden)]
pub type GetDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDestinationInput {
    /// Consumes the builder and constructs an Operation<[`GetDestination`](crate::operation::GetDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.name;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_32, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/destinations/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDestination",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDestinationInput`](crate::input::GetDestinationInput)
    pub fn builder() -> crate::input::get_destination_input::Builder {
        crate::input::get_destination_input::Builder::default()
    }
}

/// See [`GetDeviceProfileInput`](crate::input::GetDeviceProfileInput)
pub mod get_device_profile_input {
    /// A builder for [`GetDeviceProfileInput`](crate::input::GetDeviceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceProfileInput`](crate::input::GetDeviceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeviceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeviceProfileInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceProfileInputOperationOutputAlias = crate::operation::GetDeviceProfile;
#[doc(hidden)]
pub type GetDeviceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeviceProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetDeviceProfile`](crate::operation::GetDeviceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeviceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_33, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/device-profiles/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeviceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeviceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceProfileInput`](crate::input::GetDeviceProfileInput)
    pub fn builder() -> crate::input::get_device_profile_input::Builder {
        crate::input::get_device_profile_input::Builder::default()
    }
}

/// See [`GetFuotaTaskInput`](crate::input::GetFuotaTaskInput)
pub mod get_fuota_task_input {
    /// A builder for [`GetFuotaTaskInput`](crate::input::GetFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFuotaTaskInput`](crate::input::GetFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFuotaTaskInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFuotaTaskInputOperationOutputAlias = crate::operation::GetFuotaTask;
#[doc(hidden)]
pub type GetFuotaTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetFuotaTask`](crate::operation::GetFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_34, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFuotaTaskInput`](crate::input::GetFuotaTaskInput)
    pub fn builder() -> crate::input::get_fuota_task_input::Builder {
        crate::input::get_fuota_task_input::Builder::default()
    }
}

/// See [`GetLogLevelsByResourceTypesInput`](crate::input::GetLogLevelsByResourceTypesInput)
pub mod get_log_levels_by_resource_types_input {
    /// A builder for [`GetLogLevelsByResourceTypesInput`](crate::input::GetLogLevelsByResourceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetLogLevelsByResourceTypesInput`](crate::input::GetLogLevelsByResourceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLogLevelsByResourceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLogLevelsByResourceTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type GetLogLevelsByResourceTypesInputOperationOutputAlias =
    crate::operation::GetLogLevelsByResourceTypes;
#[doc(hidden)]
pub type GetLogLevelsByResourceTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLogLevelsByResourceTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetLogLevelsByResourceTypes`](crate::operation::GetLogLevelsByResourceTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLogLevelsByResourceTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLogLevelsByResourceTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/log-levels").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLogLevelsByResourceTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLogLevelsByResourceTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLogLevelsByResourceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLogLevelsByResourceTypes",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLogLevelsByResourceTypesInput`](crate::input::GetLogLevelsByResourceTypesInput)
    pub fn builder() -> crate::input::get_log_levels_by_resource_types_input::Builder {
        crate::input::get_log_levels_by_resource_types_input::Builder::default()
    }
}

/// See [`GetMulticastGroupInput`](crate::input::GetMulticastGroupInput)
pub mod get_multicast_group_input {
    /// A builder for [`GetMulticastGroupInput`](crate::input::GetMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMulticastGroupInput`](crate::input::GetMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMulticastGroupInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetMulticastGroupInputOperationOutputAlias = crate::operation::GetMulticastGroup;
#[doc(hidden)]
pub type GetMulticastGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetMulticastGroup`](crate::operation::GetMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_35, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMulticastGroupInput`](crate::input::GetMulticastGroupInput)
    pub fn builder() -> crate::input::get_multicast_group_input::Builder {
        crate::input::get_multicast_group_input::Builder::default()
    }
}

/// See [`GetMulticastGroupSessionInput`](crate::input::GetMulticastGroupSessionInput)
pub mod get_multicast_group_session_input {
    /// A builder for [`GetMulticastGroupSessionInput`](crate::input::GetMulticastGroupSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMulticastGroupSessionInput`](crate::input::GetMulticastGroupSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMulticastGroupSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMulticastGroupSessionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetMulticastGroupSessionInputOperationOutputAlias =
    crate::operation::GetMulticastGroupSession;
#[doc(hidden)]
pub type GetMulticastGroupSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMulticastGroupSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetMulticastGroupSession`](crate::operation::GetMulticastGroupSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMulticastGroupSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMulticastGroupSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_36, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/session", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMulticastGroupSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMulticastGroupSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMulticastGroupSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMulticastGroupSession",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMulticastGroupSessionInput`](crate::input::GetMulticastGroupSessionInput)
    pub fn builder() -> crate::input::get_multicast_group_session_input::Builder {
        crate::input::get_multicast_group_session_input::Builder::default()
    }
}

/// See [`GetNetworkAnalyzerConfigurationInput`](crate::input::GetNetworkAnalyzerConfigurationInput)
pub mod get_network_analyzer_configuration_input {
    /// A builder for [`GetNetworkAnalyzerConfigurationInput`](crate::input::GetNetworkAnalyzerConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkAnalyzerConfigurationInput`](crate::input::GetNetworkAnalyzerConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNetworkAnalyzerConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNetworkAnalyzerConfigurationInput {
                configuration_name: self.configuration_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNetworkAnalyzerConfigurationInputOperationOutputAlias =
    crate::operation::GetNetworkAnalyzerConfiguration;
#[doc(hidden)]
pub type GetNetworkAnalyzerConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetNetworkAnalyzerConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetNetworkAnalyzerConfiguration`](crate::operation::GetNetworkAnalyzerConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNetworkAnalyzerConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNetworkAnalyzerConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.configuration_name;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_name = aws_smithy_http::label::fmt_string(input_37, false);
            if configuration_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/network-analyzer-configurations/{ConfigurationName}",
                ConfigurationName = configuration_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNetworkAnalyzerConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNetworkAnalyzerConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNetworkAnalyzerConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNetworkAnalyzerConfiguration",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNetworkAnalyzerConfigurationInput`](crate::input::GetNetworkAnalyzerConfigurationInput)
    pub fn builder() -> crate::input::get_network_analyzer_configuration_input::Builder {
        crate::input::get_network_analyzer_configuration_input::Builder::default()
    }
}

/// See [`GetPartnerAccountInput`](crate::input::GetPartnerAccountInput)
pub mod get_partner_account_input {
    /// A builder for [`GetPartnerAccountInput`](crate::input::GetPartnerAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partner_account_id: std::option::Option<std::string::String>,
        pub(crate) partner_type: std::option::Option<crate::model::PartnerType>,
    }
    impl Builder {
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_account_id = Some(input.into());
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partner_account_id = input;
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.partner_type = Some(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.partner_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPartnerAccountInput`](crate::input::GetPartnerAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPartnerAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPartnerAccountInput {
                partner_account_id: self.partner_account_id,
                partner_type: self.partner_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPartnerAccountInputOperationOutputAlias = crate::operation::GetPartnerAccount;
#[doc(hidden)]
pub type GetPartnerAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPartnerAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetPartnerAccount`](crate::operation::GetPartnerAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPartnerAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPartnerAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.partner_account_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "partner_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let partner_account_id = aws_smithy_http::label::fmt_string(input_38, false);
            if partner_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "partner_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/partner-accounts/{PartnerAccountId}",
                PartnerAccountId = partner_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetPartnerAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.partner_type {
                query.push_kv(
                    "partnerType",
                    &aws_smithy_http::query::fmt_string(&inner_39),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPartnerAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPartnerAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPartnerAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPartnerAccount",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPartnerAccountInput`](crate::input::GetPartnerAccountInput)
    pub fn builder() -> crate::input::get_partner_account_input::Builder {
        crate::input::get_partner_account_input::Builder::default()
    }
}

/// See [`GetResourceEventConfigurationInput`](crate::input::GetResourceEventConfigurationInput)
pub mod get_resource_event_configuration_input {
    /// A builder for [`GetResourceEventConfigurationInput`](crate::input::GetResourceEventConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) identifier_type: std::option::Option<crate::model::IdentifierType>,
        pub(crate) partner_type: std::option::Option<crate::model::EventNotificationPartnerType>,
    }
    impl Builder {
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn identifier_type(mut self, input: crate::model::IdentifierType) -> Self {
            self.identifier_type = Some(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::IdentifierType>,
        ) -> Self {
            self.identifier_type = input;
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
        pub fn partner_type(mut self, input: crate::model::EventNotificationPartnerType) -> Self {
            self.partner_type = Some(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::EventNotificationPartnerType>,
        ) -> Self {
            self.partner_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceEventConfigurationInput`](crate::input::GetResourceEventConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceEventConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceEventConfigurationInput {
                identifier: self.identifier,
                identifier_type: self.identifier_type,
                partner_type: self.partner_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceEventConfigurationInputOperationOutputAlias =
    crate::operation::GetResourceEventConfiguration;
#[doc(hidden)]
pub type GetResourceEventConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceEventConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceEventConfiguration`](crate::operation::GetResourceEventConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceEventConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceEventConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.identifier;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_40, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/event-configurations/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetResourceEventConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.identifier_type {
                query.push_kv(
                    "identifierType",
                    &aws_smithy_http::query::fmt_string(&inner_41),
                );
            }
            if let Some(inner_42) = &_input.partner_type {
                query.push_kv(
                    "partnerType",
                    &aws_smithy_http::query::fmt_string(&inner_42),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceEventConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceEventConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceEventConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceEventConfiguration",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceEventConfigurationInput`](crate::input::GetResourceEventConfigurationInput)
    pub fn builder() -> crate::input::get_resource_event_configuration_input::Builder {
        crate::input::get_resource_event_configuration_input::Builder::default()
    }
}

/// See [`GetResourceLogLevelInput`](crate::input::GetResourceLogLevelInput)
pub mod get_resource_log_level_input {
    /// A builder for [`GetResourceLogLevelInput`](crate::input::GetResourceLogLevelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceLogLevelInput`](crate::input::GetResourceLogLevelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceLogLevelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceLogLevelInput {
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceLogLevelInputOperationOutputAlias = crate::operation::GetResourceLogLevel;
#[doc(hidden)]
pub type GetResourceLogLevelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResourceLogLevelInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceLogLevel`](crate::operation::GetResourceLogLevel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceLogLevel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceLogLevelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.resource_identifier;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let resource_identifier = aws_smithy_http::label::fmt_string(input_43, false);
            if resource_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/log-levels/{ResourceIdentifier}",
                ResourceIdentifier = resource_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetResourceLogLevelInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_44) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_44),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceLogLevelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceLogLevelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceLogLevel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceLogLevel",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceLogLevelInput`](crate::input::GetResourceLogLevelInput)
    pub fn builder() -> crate::input::get_resource_log_level_input::Builder {
        crate::input::get_resource_log_level_input::Builder::default()
    }
}

/// See [`GetServiceEndpointInput`](crate::input::GetServiceEndpointInput)
pub mod get_service_endpoint_input {
    /// A builder for [`GetServiceEndpointInput`](crate::input::GetServiceEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<crate::model::WirelessGatewayServiceType>,
    }
    impl Builder {
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn service_type(mut self, input: crate::model::WirelessGatewayServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceEndpointInput`](crate::input::GetServiceEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceEndpointInput {
                service_type: self.service_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceEndpointInputOperationOutputAlias = crate::operation::GetServiceEndpoint;
#[doc(hidden)]
pub type GetServiceEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetServiceEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceEndpoint`](crate::operation::GetServiceEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/service-endpoint").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetServiceEndpointInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_45) = &_input.service_type {
                query.push_kv(
                    "serviceType",
                    &aws_smithy_http::query::fmt_string(&inner_45),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceEndpoint",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceEndpointInput`](crate::input::GetServiceEndpointInput)
    pub fn builder() -> crate::input::get_service_endpoint_input::Builder {
        crate::input::get_service_endpoint_input::Builder::default()
    }
}

/// See [`GetServiceProfileInput`](crate::input::GetServiceProfileInput)
pub mod get_service_profile_input {
    /// A builder for [`GetServiceProfileInput`](crate::input::GetServiceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceProfileInput`](crate::input::GetServiceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceProfileInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetServiceProfileInputOperationOutputAlias = crate::operation::GetServiceProfile;
#[doc(hidden)]
pub type GetServiceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetServiceProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceProfile`](crate::operation::GetServiceProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_46, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/service-profiles/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceProfile",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceProfileInput`](crate::input::GetServiceProfileInput)
    pub fn builder() -> crate::input::get_service_profile_input::Builder {
        crate::input::get_service_profile_input::Builder::default()
    }
}

/// See [`GetWirelessDeviceInput`](crate::input::GetWirelessDeviceInput)
pub mod get_wireless_device_input {
    /// A builder for [`GetWirelessDeviceInput`](crate::input::GetWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) identifier_type: std::option::Option<crate::model::WirelessDeviceIdType>,
    }
    impl Builder {
        /// <p>The identifier of the wireless device to get.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the wireless device to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, input: crate::model::WirelessDeviceIdType) -> Self {
            self.identifier_type = Some(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceIdType>,
        ) -> Self {
            self.identifier_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessDeviceInput`](crate::input::GetWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessDeviceInput {
                identifier: self.identifier,
                identifier_type: self.identifier_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessDeviceInputOperationOutputAlias = crate::operation::GetWirelessDevice;
#[doc(hidden)]
pub type GetWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessDevice`](crate::operation::GetWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.identifier;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_47, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/wireless-devices/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetWirelessDeviceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.identifier_type {
                query.push_kv(
                    "identifierType",
                    &aws_smithy_http::query::fmt_string(&inner_48),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessDeviceInput`](crate::input::GetWirelessDeviceInput)
    pub fn builder() -> crate::input::get_wireless_device_input::Builder {
        crate::input::get_wireless_device_input::Builder::default()
    }
}

/// See [`GetWirelessDeviceStatisticsInput`](crate::input::GetWirelessDeviceStatisticsInput)
pub mod get_wireless_device_statistics_input {
    /// A builder for [`GetWirelessDeviceStatisticsInput`](crate::input::GetWirelessDeviceStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wireless_device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessDeviceStatisticsInput`](crate::input::GetWirelessDeviceStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessDeviceStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessDeviceStatisticsInput {
                wireless_device_id: self.wireless_device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessDeviceStatisticsInputOperationOutputAlias =
    crate::operation::GetWirelessDeviceStatistics;
#[doc(hidden)]
pub type GetWirelessDeviceStatisticsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessDeviceStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessDeviceStatistics`](crate::operation::GetWirelessDeviceStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessDeviceStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessDeviceStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.wireless_device_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "wireless_device_id",
                        details: "cannot be empty or unset",
                    })?;
            let wireless_device_id = aws_smithy_http::label::fmt_string(input_49, false);
            if wireless_device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "wireless_device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/wireless-devices/{WirelessDeviceId}/statistics",
                WirelessDeviceId = wireless_device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessDeviceStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessDeviceStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessDeviceStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessDeviceStatistics",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessDeviceStatisticsInput`](crate::input::GetWirelessDeviceStatisticsInput)
    pub fn builder() -> crate::input::get_wireless_device_statistics_input::Builder {
        crate::input::get_wireless_device_statistics_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayInput`](crate::input::GetWirelessGatewayInput)
pub mod get_wireless_gateway_input {
    /// A builder for [`GetWirelessGatewayInput`](crate::input::GetWirelessGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) identifier_type: std::option::Option<crate::model::WirelessGatewayIdType>,
    }
    impl Builder {
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, input: crate::model::WirelessGatewayIdType) -> Self {
            self.identifier_type = Some(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayIdType>,
        ) -> Self {
            self.identifier_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayInput`](crate::input::GetWirelessGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayInput {
                identifier: self.identifier,
                identifier_type: self.identifier_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayInputOperationOutputAlias = crate::operation::GetWirelessGateway;
#[doc(hidden)]
pub type GetWirelessGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGateway`](crate::operation::GetWirelessGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.identifier;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_50, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/wireless-gateways/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetWirelessGatewayInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_51) = &_input.identifier_type {
                query.push_kv(
                    "identifierType",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGateway",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayInput`](crate::input::GetWirelessGatewayInput)
    pub fn builder() -> crate::input::get_wireless_gateway_input::Builder {
        crate::input::get_wireless_gateway_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayCertificateInput`](crate::input::GetWirelessGatewayCertificateInput)
pub mod get_wireless_gateway_certificate_input {
    /// A builder for [`GetWirelessGatewayCertificateInput`](crate::input::GetWirelessGatewayCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayCertificateInput`](crate::input::GetWirelessGatewayCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayCertificateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayCertificateInputOperationOutputAlias =
    crate::operation::GetWirelessGatewayCertificate;
#[doc(hidden)]
pub type GetWirelessGatewayCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGatewayCertificate`](crate::operation::GetWirelessGatewayCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGatewayCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_52, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/certificate", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGatewayCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGatewayCertificate",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayCertificateInput`](crate::input::GetWirelessGatewayCertificateInput)
    pub fn builder() -> crate::input::get_wireless_gateway_certificate_input::Builder {
        crate::input::get_wireless_gateway_certificate_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayFirmwareInformationInput`](crate::input::GetWirelessGatewayFirmwareInformationInput)
pub mod get_wireless_gateway_firmware_information_input {
    /// A builder for [`GetWirelessGatewayFirmwareInformationInput`](crate::input::GetWirelessGatewayFirmwareInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayFirmwareInformationInput`](crate::input::GetWirelessGatewayFirmwareInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayFirmwareInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayFirmwareInformationInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayFirmwareInformationInputOperationOutputAlias =
    crate::operation::GetWirelessGatewayFirmwareInformation;
#[doc(hidden)]
pub type GetWirelessGatewayFirmwareInformationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayFirmwareInformationInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGatewayFirmwareInformation`](crate::operation::GetWirelessGatewayFirmwareInformation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGatewayFirmwareInformation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayFirmwareInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_53, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/wireless-gateways/{Id}/firmware-information",
                Id = id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayFirmwareInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayFirmwareInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGatewayFirmwareInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGatewayFirmwareInformation",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayFirmwareInformationInput`](crate::input::GetWirelessGatewayFirmwareInformationInput)
    pub fn builder() -> crate::input::get_wireless_gateway_firmware_information_input::Builder {
        crate::input::get_wireless_gateway_firmware_information_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayStatisticsInput`](crate::input::GetWirelessGatewayStatisticsInput)
pub mod get_wireless_gateway_statistics_input {
    /// A builder for [`GetWirelessGatewayStatisticsInput`](crate::input::GetWirelessGatewayStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wireless_gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn wireless_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.wireless_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn set_wireless_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.wireless_gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayStatisticsInput`](crate::input::GetWirelessGatewayStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayStatisticsInput {
                wireless_gateway_id: self.wireless_gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayStatisticsInputOperationOutputAlias =
    crate::operation::GetWirelessGatewayStatistics;
#[doc(hidden)]
pub type GetWirelessGatewayStatisticsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGatewayStatistics`](crate::operation::GetWirelessGatewayStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGatewayStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.wireless_gateway_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "wireless_gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let wireless_gateway_id = aws_smithy_http::label::fmt_string(input_54, false);
            if wireless_gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "wireless_gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/wireless-gateways/{WirelessGatewayId}/statistics",
                WirelessGatewayId = wireless_gateway_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGatewayStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGatewayStatistics",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayStatisticsInput`](crate::input::GetWirelessGatewayStatisticsInput)
    pub fn builder() -> crate::input::get_wireless_gateway_statistics_input::Builder {
        crate::input::get_wireless_gateway_statistics_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayTaskInput`](crate::input::GetWirelessGatewayTaskInput)
pub mod get_wireless_gateway_task_input {
    /// A builder for [`GetWirelessGatewayTaskInput`](crate::input::GetWirelessGatewayTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayTaskInput`](crate::input::GetWirelessGatewayTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayTaskInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayTaskInputOperationOutputAlias = crate::operation::GetWirelessGatewayTask;
#[doc(hidden)]
pub type GetWirelessGatewayTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGatewayTask`](crate::operation::GetWirelessGatewayTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGatewayTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_55, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}/tasks", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGatewayTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGatewayTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayTaskInput`](crate::input::GetWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::get_wireless_gateway_task_input::Builder {
        crate::input::get_wireless_gateway_task_input::Builder::default()
    }
}

/// See [`GetWirelessGatewayTaskDefinitionInput`](crate::input::GetWirelessGatewayTaskDefinitionInput)
pub mod get_wireless_gateway_task_definition_input {
    /// A builder for [`GetWirelessGatewayTaskDefinitionInput`](crate::input::GetWirelessGatewayTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWirelessGatewayTaskDefinitionInput`](crate::input::GetWirelessGatewayTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWirelessGatewayTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWirelessGatewayTaskDefinitionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetWirelessGatewayTaskDefinitionInputOperationOutputAlias =
    crate::operation::GetWirelessGatewayTaskDefinition;
#[doc(hidden)]
pub type GetWirelessGatewayTaskDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetWirelessGatewayTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetWirelessGatewayTaskDefinition`](crate::operation::GetWirelessGatewayTaskDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWirelessGatewayTaskDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWirelessGatewayTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_56, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateway-task-definitions/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWirelessGatewayTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWirelessGatewayTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWirelessGatewayTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWirelessGatewayTaskDefinition",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayTaskDefinitionInput`](crate::input::GetWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::get_wireless_gateway_task_definition_input::Builder {
        crate::input::get_wireless_gateway_task_definition_input::Builder::default()
    }
}

/// See [`ListDestinationsInput`](crate::input::ListDestinationsInput)
pub mod list_destinations_input {
    /// A builder for [`ListDestinationsInput`](crate::input::ListDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDestinationsInput`](crate::input::ListDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDestinationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDestinationsInputOperationOutputAlias = crate::operation::ListDestinations;
#[doc(hidden)]
pub type ListDestinationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`ListDestinations`](crate::operation::ListDestinations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDestinations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDestinationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/destinations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDestinationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_57) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_57));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDestinationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDestinationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDestinations",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDestinationsInput`](crate::input::ListDestinationsInput)
    pub fn builder() -> crate::input::list_destinations_input::Builder {
        crate::input::list_destinations_input::Builder::default()
    }
}

/// See [`ListDeviceProfilesInput`](crate::input::ListDeviceProfilesInput)
pub mod list_device_profiles_input {
    /// A builder for [`ListDeviceProfilesInput`](crate::input::ListDeviceProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceProfilesInput`](crate::input::ListDeviceProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceProfilesInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceProfilesInputOperationOutputAlias = crate::operation::ListDeviceProfiles;
#[doc(hidden)]
pub type ListDeviceProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeviceProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceProfiles`](crate::operation::ListDeviceProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/device-profiles").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDeviceProfilesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_58) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_58));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceProfiles",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceProfilesInput`](crate::input::ListDeviceProfilesInput)
    pub fn builder() -> crate::input::list_device_profiles_input::Builder {
        crate::input::list_device_profiles_input::Builder::default()
    }
}

/// See [`ListFuotaTasksInput`](crate::input::ListFuotaTasksInput)
pub mod list_fuota_tasks_input {
    /// A builder for [`ListFuotaTasksInput`](crate::input::ListFuotaTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFuotaTasksInput`](crate::input::ListFuotaTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFuotaTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFuotaTasksInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListFuotaTasksInputOperationOutputAlias = crate::operation::ListFuotaTasks;
#[doc(hidden)]
pub type ListFuotaTasksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFuotaTasksInput {
    /// Consumes the builder and constructs an Operation<[`ListFuotaTasks`](crate::operation::ListFuotaTasks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFuotaTasks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFuotaTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/fuota-tasks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFuotaTasksInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_59));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFuotaTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFuotaTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFuotaTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFuotaTasks",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFuotaTasksInput`](crate::input::ListFuotaTasksInput)
    pub fn builder() -> crate::input::list_fuota_tasks_input::Builder {
        crate::input::list_fuota_tasks_input::Builder::default()
    }
}

/// See [`ListMulticastGroupsInput`](crate::input::ListMulticastGroupsInput)
pub mod list_multicast_groups_input {
    /// A builder for [`ListMulticastGroupsInput`](crate::input::ListMulticastGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMulticastGroupsInput`](crate::input::ListMulticastGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMulticastGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMulticastGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListMulticastGroupsInputOperationOutputAlias = crate::operation::ListMulticastGroups;
#[doc(hidden)]
pub type ListMulticastGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMulticastGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListMulticastGroups`](crate::operation::ListMulticastGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMulticastGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMulticastGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/multicast-groups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMulticastGroupsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_60) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_60));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMulticastGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMulticastGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMulticastGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMulticastGroups",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMulticastGroupsInput`](crate::input::ListMulticastGroupsInput)
    pub fn builder() -> crate::input::list_multicast_groups_input::Builder {
        crate::input::list_multicast_groups_input::Builder::default()
    }
}

/// See [`ListMulticastGroupsByFuotaTaskInput`](crate::input::ListMulticastGroupsByFuotaTaskInput)
pub mod list_multicast_groups_by_fuota_task_input {
    /// A builder for [`ListMulticastGroupsByFuotaTaskInput`](crate::input::ListMulticastGroupsByFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMulticastGroupsByFuotaTaskInput`](crate::input::ListMulticastGroupsByFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMulticastGroupsByFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMulticastGroupsByFuotaTaskInput {
                id: self.id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListMulticastGroupsByFuotaTaskInputOperationOutputAlias =
    crate::operation::ListMulticastGroupsByFuotaTask;
#[doc(hidden)]
pub type ListMulticastGroupsByFuotaTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListMulticastGroupsByFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`ListMulticastGroupsByFuotaTask`](crate::operation::ListMulticastGroupsByFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMulticastGroupsByFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMulticastGroupsByFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.id;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_61, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}/multicast-groups", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMulticastGroupsByFuotaTaskInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_62) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_62));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMulticastGroupsByFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMulticastGroupsByFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMulticastGroupsByFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMulticastGroupsByFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMulticastGroupsByFuotaTaskInput`](crate::input::ListMulticastGroupsByFuotaTaskInput)
    pub fn builder() -> crate::input::list_multicast_groups_by_fuota_task_input::Builder {
        crate::input::list_multicast_groups_by_fuota_task_input::Builder::default()
    }
}

/// See [`ListPartnerAccountsInput`](crate::input::ListPartnerAccountsInput)
pub mod list_partner_accounts_input {
    /// A builder for [`ListPartnerAccountsInput`](crate::input::ListPartnerAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartnerAccountsInput`](crate::input::ListPartnerAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPartnerAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPartnerAccountsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartnerAccountsInputOperationOutputAlias = crate::operation::ListPartnerAccounts;
#[doc(hidden)]
pub type ListPartnerAccountsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPartnerAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListPartnerAccounts`](crate::operation::ListPartnerAccounts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPartnerAccounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPartnerAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/partner-accounts").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPartnerAccountsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_63) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_63));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPartnerAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPartnerAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPartnerAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPartnerAccounts",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPartnerAccountsInput`](crate::input::ListPartnerAccountsInput)
    pub fn builder() -> crate::input::list_partner_accounts_input::Builder {
        crate::input::list_partner_accounts_input::Builder::default()
    }
}

/// See [`ListQueuedMessagesInput`](crate::input::ListQueuedMessagesInput)
pub mod list_queued_messages_input {
    /// A builder for [`ListQueuedMessagesInput`](crate::input::ListQueuedMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
    }
    impl Builder {
        /// <p>Id of a given wireless device which the downlink packets are targeted </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Id of a given wireless device which the downlink packets are targeted </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.wireless_device_type = Some(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.wireless_device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueuedMessagesInput`](crate::input::ListQueuedMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueuedMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueuedMessagesInput {
                id: self.id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                wireless_device_type: self.wireless_device_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueuedMessagesInputOperationOutputAlias = crate::operation::ListQueuedMessages;
#[doc(hidden)]
pub type ListQueuedMessagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListQueuedMessagesInput {
    /// Consumes the builder and constructs an Operation<[`ListQueuedMessages`](crate::operation::ListQueuedMessages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueuedMessages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQueuedMessagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_64 = &_input.id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_64, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/data", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListQueuedMessagesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_65) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_65));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_66) = &_input.wireless_device_type {
                query.push_kv(
                    "WirelessDeviceType",
                    &aws_smithy_http::query::fmt_string(&inner_66),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQueuedMessagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQueuedMessagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueuedMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueuedMessages",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQueuedMessagesInput`](crate::input::ListQueuedMessagesInput)
    pub fn builder() -> crate::input::list_queued_messages_input::Builder {
        crate::input::list_queued_messages_input::Builder::default()
    }
}

/// See [`ListServiceProfilesInput`](crate::input::ListServiceProfilesInput)
pub mod list_service_profiles_input {
    /// A builder for [`ListServiceProfilesInput`](crate::input::ListServiceProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceProfilesInput`](crate::input::ListServiceProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceProfilesInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceProfilesInputOperationOutputAlias = crate::operation::ListServiceProfiles;
#[doc(hidden)]
pub type ListServiceProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListServiceProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceProfiles`](crate::operation::ListServiceProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/service-profiles").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListServiceProfilesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_67) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceProfiles",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceProfilesInput`](crate::input::ListServiceProfilesInput)
    pub fn builder() -> crate::input::list_service_profiles_input::Builder {
        crate::input::list_service_profiles_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTagsForResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_68) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_68),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWirelessDevicesInput`](crate::input::ListWirelessDevicesInput)
pub mod list_wireless_devices_input {
    /// A builder for [`ListWirelessDevicesInput`](crate::input::ListWirelessDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) destination_name: std::option::Option<std::string::String>,
        pub(crate) device_profile_id: std::option::Option<std::string::String>,
        pub(crate) service_profile_id: std::option::Option<std::string::String>,
        pub(crate) wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
        pub(crate) fuota_task_id: std::option::Option<std::string::String>,
        pub(crate) multicast_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_name = Some(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_name = input;
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn device_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_profile_id = Some(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn set_device_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_profile_id = input;
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn service_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_profile_id = Some(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn set_service_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_profile_id = input;
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.wireless_device_type = Some(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.wireless_device_type = input;
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn fuota_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fuota_task_id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_fuota_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fuota_task_id = input;
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.multicast_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multicast_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWirelessDevicesInput`](crate::input::ListWirelessDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWirelessDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWirelessDevicesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                destination_name: self.destination_name,
                device_profile_id: self.device_profile_id,
                service_profile_id: self.service_profile_id,
                wireless_device_type: self.wireless_device_type,
                fuota_task_id: self.fuota_task_id,
                multicast_group_id: self.multicast_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWirelessDevicesInputOperationOutputAlias = crate::operation::ListWirelessDevices;
#[doc(hidden)]
pub type ListWirelessDevicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWirelessDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListWirelessDevices`](crate::operation::ListWirelessDevices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWirelessDevices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWirelessDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-devices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListWirelessDevicesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_69) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_69));
            }
            if let Some(inner_70) = &_input.destination_name {
                query.push_kv(
                    "destinationName",
                    &aws_smithy_http::query::fmt_string(&inner_70),
                );
            }
            if let Some(inner_71) = &_input.device_profile_id {
                query.push_kv(
                    "deviceProfileId",
                    &aws_smithy_http::query::fmt_string(&inner_71),
                );
            }
            if let Some(inner_72) = &_input.service_profile_id {
                query.push_kv(
                    "serviceProfileId",
                    &aws_smithy_http::query::fmt_string(&inner_72),
                );
            }
            if let Some(inner_73) = &_input.wireless_device_type {
                query.push_kv(
                    "wirelessDeviceType",
                    &aws_smithy_http::query::fmt_string(&inner_73),
                );
            }
            if let Some(inner_74) = &_input.fuota_task_id {
                query.push_kv(
                    "fuotaTaskId",
                    &aws_smithy_http::query::fmt_string(&inner_74),
                );
            }
            if let Some(inner_75) = &_input.multicast_group_id {
                query.push_kv(
                    "multicastGroupId",
                    &aws_smithy_http::query::fmt_string(&inner_75),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWirelessDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWirelessDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWirelessDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWirelessDevices",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWirelessDevicesInput`](crate::input::ListWirelessDevicesInput)
    pub fn builder() -> crate::input::list_wireless_devices_input::Builder {
        crate::input::list_wireless_devices_input::Builder::default()
    }
}

/// See [`ListWirelessGatewaysInput`](crate::input::ListWirelessGatewaysInput)
pub mod list_wireless_gateways_input {
    /// A builder for [`ListWirelessGatewaysInput`](crate::input::ListWirelessGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWirelessGatewaysInput`](crate::input::ListWirelessGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWirelessGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWirelessGatewaysInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListWirelessGatewaysInputOperationOutputAlias = crate::operation::ListWirelessGateways;
#[doc(hidden)]
pub type ListWirelessGatewaysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWirelessGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`ListWirelessGateways`](crate::operation::ListWirelessGateways)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWirelessGateways,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWirelessGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-gateways").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListWirelessGatewaysInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_76) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_76));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWirelessGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWirelessGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWirelessGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWirelessGateways",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWirelessGatewaysInput`](crate::input::ListWirelessGatewaysInput)
    pub fn builder() -> crate::input::list_wireless_gateways_input::Builder {
        crate::input::list_wireless_gateways_input::Builder::default()
    }
}

/// See [`ListWirelessGatewayTaskDefinitionsInput`](crate::input::ListWirelessGatewayTaskDefinitionsInput)
pub mod list_wireless_gateway_task_definitions_input {
    /// A builder for [`ListWirelessGatewayTaskDefinitionsInput`](crate::input::ListWirelessGatewayTaskDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) task_definition_type:
            std::option::Option<crate::model::WirelessGatewayTaskDefinitionType>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn task_definition_type(
            mut self,
            input: crate::model::WirelessGatewayTaskDefinitionType,
        ) -> Self {
            self.task_definition_type = Some(input);
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn set_task_definition_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayTaskDefinitionType>,
        ) -> Self {
            self.task_definition_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWirelessGatewayTaskDefinitionsInput`](crate::input::ListWirelessGatewayTaskDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWirelessGatewayTaskDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWirelessGatewayTaskDefinitionsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                task_definition_type: self.task_definition_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWirelessGatewayTaskDefinitionsInputOperationOutputAlias =
    crate::operation::ListWirelessGatewayTaskDefinitions;
#[doc(hidden)]
pub type ListWirelessGatewayTaskDefinitionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListWirelessGatewayTaskDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListWirelessGatewayTaskDefinitions`](crate::operation::ListWirelessGatewayTaskDefinitions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWirelessGatewayTaskDefinitions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWirelessGatewayTaskDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/wireless-gateway-task-definitions")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListWirelessGatewayTaskDefinitionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_77) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_77));
            }
            if let Some(inner_78) = &_input.task_definition_type {
                query.push_kv(
                    "taskDefinitionType",
                    &aws_smithy_http::query::fmt_string(&inner_78),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWirelessGatewayTaskDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWirelessGatewayTaskDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWirelessGatewayTaskDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWirelessGatewayTaskDefinitions",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWirelessGatewayTaskDefinitionsInput`](crate::input::ListWirelessGatewayTaskDefinitionsInput)
    pub fn builder() -> crate::input::list_wireless_gateway_task_definitions_input::Builder {
        crate::input::list_wireless_gateway_task_definitions_input::Builder::default()
    }
}

/// See [`PutResourceLogLevelInput`](crate::input::PutResourceLogLevelInput)
pub mod put_resource_log_level_input {
    /// A builder for [`PutResourceLogLevelInput`](crate::input::PutResourceLogLevelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourceLogLevelInput`](crate::input::PutResourceLogLevelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourceLogLevelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourceLogLevelInput {
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
                log_level: self.log_level,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourceLogLevelInputOperationOutputAlias = crate::operation::PutResourceLogLevel;
#[doc(hidden)]
pub type PutResourceLogLevelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutResourceLogLevelInput {
    /// Consumes the builder and constructs an Operation<[`PutResourceLogLevel`](crate::operation::PutResourceLogLevel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourceLogLevel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResourceLogLevelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.resource_identifier;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let resource_identifier = aws_smithy_http::label::fmt_string(input_79, false);
            if resource_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/log-levels/{ResourceIdentifier}",
                ResourceIdentifier = resource_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PutResourceLogLevelInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_80) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_80),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResourceLogLevelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResourceLogLevelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_resource_log_level(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourceLogLevel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourceLogLevel",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResourceLogLevelInput`](crate::input::PutResourceLogLevelInput)
    pub fn builder() -> crate::input::put_resource_log_level_input::Builder {
        crate::input::put_resource_log_level_input::Builder::default()
    }
}

/// See [`ResetAllResourceLogLevelsInput`](crate::input::ResetAllResourceLogLevelsInput)
pub mod reset_all_resource_log_levels_input {
    /// A builder for [`ResetAllResourceLogLevelsInput`](crate::input::ResetAllResourceLogLevelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ResetAllResourceLogLevelsInput`](crate::input::ResetAllResourceLogLevelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetAllResourceLogLevelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetAllResourceLogLevelsInput {})
        }
    }
}
#[doc(hidden)]
pub type ResetAllResourceLogLevelsInputOperationOutputAlias =
    crate::operation::ResetAllResourceLogLevels;
#[doc(hidden)]
pub type ResetAllResourceLogLevelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetAllResourceLogLevelsInput {
    /// Consumes the builder and constructs an Operation<[`ResetAllResourceLogLevels`](crate::operation::ResetAllResourceLogLevels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetAllResourceLogLevels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetAllResourceLogLevelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/log-levels").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetAllResourceLogLevelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetAllResourceLogLevelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetAllResourceLogLevels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetAllResourceLogLevels",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetAllResourceLogLevelsInput`](crate::input::ResetAllResourceLogLevelsInput)
    pub fn builder() -> crate::input::reset_all_resource_log_levels_input::Builder {
        crate::input::reset_all_resource_log_levels_input::Builder::default()
    }
}

/// See [`ResetResourceLogLevelInput`](crate::input::ResetResourceLogLevelInput)
pub mod reset_resource_log_level_input {
    /// A builder for [`ResetResourceLogLevelInput`](crate::input::ResetResourceLogLevelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetResourceLogLevelInput`](crate::input::ResetResourceLogLevelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetResourceLogLevelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetResourceLogLevelInput {
                resource_identifier: self.resource_identifier,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetResourceLogLevelInputOperationOutputAlias = crate::operation::ResetResourceLogLevel;
#[doc(hidden)]
pub type ResetResourceLogLevelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResetResourceLogLevelInput {
    /// Consumes the builder and constructs an Operation<[`ResetResourceLogLevel`](crate::operation::ResetResourceLogLevel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetResourceLogLevel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetResourceLogLevelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_81 = &_input.resource_identifier;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let resource_identifier = aws_smithy_http::label::fmt_string(input_81, false);
            if resource_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/log-levels/{ResourceIdentifier}",
                ResourceIdentifier = resource_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ResetResourceLogLevelInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_82) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_82),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetResourceLogLevelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetResourceLogLevelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetResourceLogLevel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetResourceLogLevel",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetResourceLogLevelInput`](crate::input::ResetResourceLogLevelInput)
    pub fn builder() -> crate::input::reset_resource_log_level_input::Builder {
        crate::input::reset_resource_log_level_input::Builder::default()
    }
}

/// See [`SendDataToMulticastGroupInput`](crate::input::SendDataToMulticastGroupInput)
pub mod send_data_to_multicast_group_input {
    /// A builder for [`SendDataToMulticastGroupInput`](crate::input::SendDataToMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) payload_data: std::option::Option<std::string::String>,
        pub(crate) wireless_metadata: std::option::Option<crate::model::MulticastWirelessMetadata>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn payload_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_data = Some(input.into());
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn set_payload_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.payload_data = input;
            self
        }
        /// <p>Wireless metadata that is to be sent to multicast group.</p>
        pub fn wireless_metadata(mut self, input: crate::model::MulticastWirelessMetadata) -> Self {
            self.wireless_metadata = Some(input);
            self
        }
        /// <p>Wireless metadata that is to be sent to multicast group.</p>
        pub fn set_wireless_metadata(
            mut self,
            input: std::option::Option<crate::model::MulticastWirelessMetadata>,
        ) -> Self {
            self.wireless_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`SendDataToMulticastGroupInput`](crate::input::SendDataToMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendDataToMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendDataToMulticastGroupInput {
                id: self.id,
                payload_data: self.payload_data,
                wireless_metadata: self.wireless_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type SendDataToMulticastGroupInputOperationOutputAlias =
    crate::operation::SendDataToMulticastGroup;
#[doc(hidden)]
pub type SendDataToMulticastGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendDataToMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`SendDataToMulticastGroup`](crate::operation::SendDataToMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendDataToMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendDataToMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_83, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/data", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendDataToMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendDataToMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_data_to_multicast_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendDataToMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendDataToMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendDataToMulticastGroupInput`](crate::input::SendDataToMulticastGroupInput)
    pub fn builder() -> crate::input::send_data_to_multicast_group_input::Builder {
        crate::input::send_data_to_multicast_group_input::Builder::default()
    }
}

/// See [`SendDataToWirelessDeviceInput`](crate::input::SendDataToWirelessDeviceInput)
pub mod send_data_to_wireless_device_input {
    /// A builder for [`SendDataToWirelessDeviceInput`](crate::input::SendDataToWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) transmit_mode: std::option::Option<i32>,
        pub(crate) payload_data: std::option::Option<std::string::String>,
        pub(crate) wireless_metadata: std::option::Option<crate::model::WirelessMetadata>,
    }
    impl Builder {
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn transmit_mode(mut self, input: i32) -> Self {
            self.transmit_mode = Some(input);
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn set_transmit_mode(mut self, input: std::option::Option<i32>) -> Self {
            self.transmit_mode = input;
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn payload_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_data = Some(input.into());
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn set_payload_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.payload_data = input;
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn wireless_metadata(mut self, input: crate::model::WirelessMetadata) -> Self {
            self.wireless_metadata = Some(input);
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn set_wireless_metadata(
            mut self,
            input: std::option::Option<crate::model::WirelessMetadata>,
        ) -> Self {
            self.wireless_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`SendDataToWirelessDeviceInput`](crate::input::SendDataToWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendDataToWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendDataToWirelessDeviceInput {
                id: self.id,
                transmit_mode: self.transmit_mode,
                payload_data: self.payload_data,
                wireless_metadata: self.wireless_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type SendDataToWirelessDeviceInputOperationOutputAlias =
    crate::operation::SendDataToWirelessDevice;
#[doc(hidden)]
pub type SendDataToWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendDataToWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`SendDataToWirelessDevice`](crate::operation::SendDataToWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendDataToWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendDataToWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_84 = &_input.id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_84, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/data", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendDataToWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendDataToWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_data_to_wireless_device(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendDataToWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendDataToWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendDataToWirelessDeviceInput`](crate::input::SendDataToWirelessDeviceInput)
    pub fn builder() -> crate::input::send_data_to_wireless_device_input::Builder {
        crate::input::send_data_to_wireless_device_input::Builder::default()
    }
}

/// See [`StartBulkAssociateWirelessDeviceWithMulticastGroupInput`](crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput)
pub mod start_bulk_associate_wireless_device_with_multicast_group_input {
    /// A builder for [`StartBulkAssociateWirelessDeviceWithMulticastGroupInput`](crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBulkAssociateWirelessDeviceWithMulticastGroupInput`](crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput {
                    id: self.id,
                    query_string: self.query_string,
                    tags: self.tags,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type StartBulkAssociateWirelessDeviceWithMulticastGroupInputOperationOutputAlias =
    crate::operation::StartBulkAssociateWirelessDeviceWithMulticastGroup;
#[doc(hidden)]
pub type StartBulkAssociateWirelessDeviceWithMulticastGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl StartBulkAssociateWirelessDeviceWithMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`StartBulkAssociateWirelessDeviceWithMulticastGroup`](crate::operation::StartBulkAssociateWirelessDeviceWithMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBulkAssociateWirelessDeviceWithMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_85, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/bulk", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_bulk_associate_wireless_device_with_multicast_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBulkAssociateWirelessDeviceWithMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBulkAssociateWirelessDeviceWithMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBulkAssociateWirelessDeviceWithMulticastGroupInput`](crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::start_bulk_associate_wireless_device_with_multicast_group_input::Builder
    {
        crate::input::start_bulk_associate_wireless_device_with_multicast_group_input::Builder::default()
    }
}

/// See [`StartBulkDisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput)
pub mod start_bulk_disassociate_wireless_device_from_multicast_group_input {
    /// A builder for [`StartBulkDisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBulkDisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput {
                    id: self.id,
                    query_string: self.query_string,
                    tags: self.tags,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type StartBulkDisassociateWirelessDeviceFromMulticastGroupInputOperationOutputAlias =
    crate::operation::StartBulkDisassociateWirelessDeviceFromMulticastGroup;
#[doc(hidden)]
pub type StartBulkDisassociateWirelessDeviceFromMulticastGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl StartBulkDisassociateWirelessDeviceFromMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`StartBulkDisassociateWirelessDeviceFromMulticastGroup`](crate::operation::StartBulkDisassociateWirelessDeviceFromMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBulkDisassociateWirelessDeviceFromMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_86, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/bulk", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_bulk_disassociate_wireless_device_from_multicast_group(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBulkDisassociateWirelessDeviceFromMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBulkDisassociateWirelessDeviceFromMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBulkDisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::start_bulk_disassociate_wireless_device_from_multicast_group_input::Builder
    {
        crate::input::start_bulk_disassociate_wireless_device_from_multicast_group_input::Builder::default()
    }
}

/// See [`StartFuotaTaskInput`](crate::input::StartFuotaTaskInput)
pub mod start_fuota_task_input {
    /// A builder for [`StartFuotaTaskInput`](crate::input::StartFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanStartFuotaTask>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The LoRaWAN information used to start a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanStartFuotaTask) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information used to start a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanStartFuotaTask>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFuotaTaskInput`](crate::input::StartFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFuotaTaskInput {
                id: self.id,
                lo_ra_wan: self.lo_ra_wan,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFuotaTaskInputOperationOutputAlias = crate::operation::StartFuotaTask;
#[doc(hidden)]
pub type StartFuotaTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`StartFuotaTask`](crate::operation::StartFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_87 = &_input.id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_87, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_fuota_task(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFuotaTaskInput`](crate::input::StartFuotaTaskInput)
    pub fn builder() -> crate::input::start_fuota_task_input::Builder {
        crate::input::start_fuota_task_input::Builder::default()
    }
}

/// See [`StartMulticastGroupSessionInput`](crate::input::StartMulticastGroupSessionInput)
pub mod start_multicast_group_session_input {
    /// A builder for [`StartMulticastGroupSessionInput`](crate::input::StartMulticastGroupSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticastSession>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The LoRaWAN information used with the multicast session.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticastSession) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information used with the multicast session.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticastSession>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMulticastGroupSessionInput`](crate::input::StartMulticastGroupSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMulticastGroupSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMulticastGroupSessionInput {
                id: self.id,
                lo_ra_wan: self.lo_ra_wan,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMulticastGroupSessionInputOperationOutputAlias =
    crate::operation::StartMulticastGroupSession;
#[doc(hidden)]
pub type StartMulticastGroupSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMulticastGroupSessionInput {
    /// Consumes the builder and constructs an Operation<[`StartMulticastGroupSession`](crate::operation::StartMulticastGroupSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMulticastGroupSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMulticastGroupSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_88, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}/session", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMulticastGroupSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMulticastGroupSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_multicast_group_session(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMulticastGroupSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMulticastGroupSession",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMulticastGroupSessionInput`](crate::input::StartMulticastGroupSessionInput)
    pub fn builder() -> crate::input::start_multicast_group_session_input::Builder {
        crate::input::start_multicast_group_session_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::TagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_89) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_89),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestWirelessDeviceInput`](crate::input::TestWirelessDeviceInput)
pub mod test_wireless_device_input {
    /// A builder for [`TestWirelessDeviceInput`](crate::input::TestWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the wireless device to test.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device to test.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`TestWirelessDeviceInput`](crate::input::TestWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestWirelessDeviceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type TestWirelessDeviceInputOperationOutputAlias = crate::operation::TestWirelessDevice;
#[doc(hidden)]
pub type TestWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TestWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`TestWirelessDevice`](crate::operation::TestWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_90 = &_input.id;
            let input_90 =
                input_90
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_90, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}/test", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestWirelessDeviceInput`](crate::input::TestWirelessDeviceInput)
    pub fn builder() -> crate::input::test_wireless_device_input::Builder {
        crate::input::test_wireless_device_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_91) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_91),
                );
            }
            if let Some(inner_92) = &_input.tag_keys {
                for inner_93 in inner_92 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_93));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
pub mod update_destination_input {
    /// A builder for [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) expression_type: std::option::Option<crate::model::ExpressionType>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.expression_type = Some(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.expression_type = input;
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDestinationInput {
                name: self.name,
                expression_type: self.expression_type,
                expression: self.expression,
                description: self.description,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDestinationInputOperationOutputAlias = crate::operation::UpdateDestination;
#[doc(hidden)]
pub type UpdateDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDestination`](crate::operation::UpdateDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_94 = &_input.name;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_94, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/destinations/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_destination(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDestination",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
    pub fn builder() -> crate::input::update_destination_input::Builder {
        crate::input::update_destination_input::Builder::default()
    }
}

/// See [`UpdateFuotaTaskInput`](crate::input::UpdateFuotaTaskInput)
pub mod update_fuota_task_input {
    /// A builder for [`UpdateFuotaTaskInput`](crate::input::UpdateFuotaTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanFuotaTask>,
        pub(crate) firmware_update_image: std::option::Option<std::string::String>,
        pub(crate) firmware_update_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanFuotaTask) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanFuotaTask>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn firmware_update_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.firmware_update_image = Some(input.into());
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firmware_update_image = input;
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn firmware_update_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.firmware_update_role = Some(input.into());
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firmware_update_role = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFuotaTaskInput`](crate::input::UpdateFuotaTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFuotaTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFuotaTaskInput {
                id: self.id,
                name: self.name,
                description: self.description,
                lo_ra_wan: self.lo_ra_wan,
                firmware_update_image: self.firmware_update_image,
                firmware_update_role: self.firmware_update_role,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFuotaTaskInputOperationOutputAlias = crate::operation::UpdateFuotaTask;
#[doc(hidden)]
pub type UpdateFuotaTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFuotaTaskInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFuotaTask`](crate::operation::UpdateFuotaTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFuotaTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFuotaTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_95 = &_input.id;
            let input_95 =
                input_95
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_95, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/fuota-tasks/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFuotaTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFuotaTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_fuota_task(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFuotaTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFuotaTask",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFuotaTaskInput`](crate::input::UpdateFuotaTaskInput)
    pub fn builder() -> crate::input::update_fuota_task_input::Builder {
        crate::input::update_fuota_task_input::Builder::default()
    }
}

/// See [`UpdateLogLevelsByResourceTypesInput`](crate::input::UpdateLogLevelsByResourceTypesInput)
pub mod update_log_levels_by_resource_types_input {
    /// A builder for [`UpdateLogLevelsByResourceTypesInput`](crate::input::UpdateLogLevelsByResourceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) wireless_device_log_options:
            std::option::Option<std::vec::Vec<crate::model::WirelessDeviceLogOption>>,
        pub(crate) wireless_gateway_log_options:
            std::option::Option<std::vec::Vec<crate::model::WirelessGatewayLogOption>>,
    }
    impl Builder {
        /// <p>The log level for a log message.</p>
        pub fn default_log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.default_log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_default_log_level(
            mut self,
            input: std::option::Option<crate::model::LogLevel>,
        ) -> Self {
            self.default_log_level = input;
            self
        }
        /// Appends an item to `wireless_device_log_options`.
        ///
        /// To override the contents of this collection use [`set_wireless_device_log_options`](Self::set_wireless_device_log_options).
        ///
        /// <p>The list of wireless device log options.</p>
        pub fn wireless_device_log_options(
            mut self,
            input: crate::model::WirelessDeviceLogOption,
        ) -> Self {
            let mut v = self.wireless_device_log_options.unwrap_or_default();
            v.push(input);
            self.wireless_device_log_options = Some(v);
            self
        }
        /// <p>The list of wireless device log options.</p>
        pub fn set_wireless_device_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessDeviceLogOption>>,
        ) -> Self {
            self.wireless_device_log_options = input;
            self
        }
        /// Appends an item to `wireless_gateway_log_options`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateway_log_options`](Self::set_wireless_gateway_log_options).
        ///
        /// <p>The list of wireless gateway log options.</p>
        pub fn wireless_gateway_log_options(
            mut self,
            input: crate::model::WirelessGatewayLogOption,
        ) -> Self {
            let mut v = self.wireless_gateway_log_options.unwrap_or_default();
            v.push(input);
            self.wireless_gateway_log_options = Some(v);
            self
        }
        /// <p>The list of wireless gateway log options.</p>
        pub fn set_wireless_gateway_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessGatewayLogOption>>,
        ) -> Self {
            self.wireless_gateway_log_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLogLevelsByResourceTypesInput`](crate::input::UpdateLogLevelsByResourceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLogLevelsByResourceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLogLevelsByResourceTypesInput {
                default_log_level: self.default_log_level,
                wireless_device_log_options: self.wireless_device_log_options,
                wireless_gateway_log_options: self.wireless_gateway_log_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLogLevelsByResourceTypesInputOperationOutputAlias =
    crate::operation::UpdateLogLevelsByResourceTypes;
#[doc(hidden)]
pub type UpdateLogLevelsByResourceTypesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLogLevelsByResourceTypesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLogLevelsByResourceTypes`](crate::operation::UpdateLogLevelsByResourceTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLogLevelsByResourceTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLogLevelsByResourceTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/log-levels").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLogLevelsByResourceTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLogLevelsByResourceTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_log_levels_by_resource_types(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLogLevelsByResourceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLogLevelsByResourceTypes",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLogLevelsByResourceTypesInput`](crate::input::UpdateLogLevelsByResourceTypesInput)
    pub fn builder() -> crate::input::update_log_levels_by_resource_types_input::Builder {
        crate::input::update_log_levels_by_resource_types_input::Builder::default()
    }
}

/// See [`UpdateMulticastGroupInput`](crate::input::UpdateMulticastGroupInput)
pub mod update_multicast_group_input {
    /// A builder for [`UpdateMulticastGroupInput`](crate::input::UpdateMulticastGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticast>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticast) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticast>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMulticastGroupInput`](crate::input::UpdateMulticastGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMulticastGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMulticastGroupInput {
                id: self.id,
                name: self.name,
                description: self.description,
                lo_ra_wan: self.lo_ra_wan,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMulticastGroupInputOperationOutputAlias = crate::operation::UpdateMulticastGroup;
#[doc(hidden)]
pub type UpdateMulticastGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMulticastGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMulticastGroup`](crate::operation::UpdateMulticastGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMulticastGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMulticastGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.id;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_96, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/multicast-groups/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMulticastGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMulticastGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_multicast_group(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMulticastGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMulticastGroup",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMulticastGroupInput`](crate::input::UpdateMulticastGroupInput)
    pub fn builder() -> crate::input::update_multicast_group_input::Builder {
        crate::input::update_multicast_group_input::Builder::default()
    }
}

/// See [`UpdateNetworkAnalyzerConfigurationInput`](crate::input::UpdateNetworkAnalyzerConfigurationInput)
pub mod update_network_analyzer_configuration_input {
    /// A builder for [`UpdateNetworkAnalyzerConfigurationInput`](crate::input::UpdateNetworkAnalyzerConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_name: std::option::Option<std::string::String>,
        pub(crate) trace_content: std::option::Option<crate::model::TraceContent>,
        pub(crate) wireless_devices_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) wireless_devices_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) wireless_gateways_to_add:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) wireless_gateways_to_remove:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_name = Some(input.into());
            self
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_name = input;
            self
        }
        /// <p>Trace Content for resources.</p>
        pub fn trace_content(mut self, input: crate::model::TraceContent) -> Self {
            self.trace_content = Some(input);
            self
        }
        /// <p>Trace Content for resources.</p>
        pub fn set_trace_content(
            mut self,
            input: std::option::Option<crate::model::TraceContent>,
        ) -> Self {
            self.trace_content = input;
            self
        }
        /// Appends an item to `wireless_devices_to_add`.
        ///
        /// To override the contents of this collection use [`set_wireless_devices_to_add`](Self::set_wireless_devices_to_add).
        ///
        /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
        pub fn wireless_devices_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.wireless_devices_to_add.unwrap_or_default();
            v.push(input.into());
            self.wireless_devices_to_add = Some(v);
            self
        }
        /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_devices_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.wireless_devices_to_add = input;
            self
        }
        /// Appends an item to `wireless_devices_to_remove`.
        ///
        /// To override the contents of this collection use [`set_wireless_devices_to_remove`](Self::set_wireless_devices_to_remove).
        ///
        /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
        pub fn wireless_devices_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.wireless_devices_to_remove.unwrap_or_default();
            v.push(input.into());
            self.wireless_devices_to_remove = Some(v);
            self
        }
        /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_devices_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.wireless_devices_to_remove = input;
            self
        }
        /// Appends an item to `wireless_gateways_to_add`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateways_to_add`](Self::set_wireless_gateways_to_add).
        ///
        /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
        pub fn wireless_gateways_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.wireless_gateways_to_add.unwrap_or_default();
            v.push(input.into());
            self.wireless_gateways_to_add = Some(v);
            self
        }
        /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_gateways_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.wireless_gateways_to_add = input;
            self
        }
        /// Appends an item to `wireless_gateways_to_remove`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateways_to_remove`](Self::set_wireless_gateways_to_remove).
        ///
        /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
        pub fn wireless_gateways_to_remove(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.wireless_gateways_to_remove.unwrap_or_default();
            v.push(input.into());
            self.wireless_gateways_to_remove = Some(v);
            self
        }
        /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_gateways_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.wireless_gateways_to_remove = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNetworkAnalyzerConfigurationInput`](crate::input::UpdateNetworkAnalyzerConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNetworkAnalyzerConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNetworkAnalyzerConfigurationInput {
                configuration_name: self.configuration_name,
                trace_content: self.trace_content,
                wireless_devices_to_add: self.wireless_devices_to_add,
                wireless_devices_to_remove: self.wireless_devices_to_remove,
                wireless_gateways_to_add: self.wireless_gateways_to_add,
                wireless_gateways_to_remove: self.wireless_gateways_to_remove,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNetworkAnalyzerConfigurationInputOperationOutputAlias =
    crate::operation::UpdateNetworkAnalyzerConfiguration;
#[doc(hidden)]
pub type UpdateNetworkAnalyzerConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateNetworkAnalyzerConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNetworkAnalyzerConfiguration`](crate::operation::UpdateNetworkAnalyzerConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNetworkAnalyzerConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateNetworkAnalyzerConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_97 = &_input.configuration_name;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_name",
                        details: "cannot be empty or unset",
                    })?;
            let configuration_name = aws_smithy_http::label::fmt_string(input_97, false);
            if configuration_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "configuration_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/network-analyzer-configurations/{ConfigurationName}",
                ConfigurationName = configuration_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateNetworkAnalyzerConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateNetworkAnalyzerConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_network_analyzer_configuration(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNetworkAnalyzerConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNetworkAnalyzerConfiguration",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateNetworkAnalyzerConfigurationInput`](crate::input::UpdateNetworkAnalyzerConfigurationInput)
    pub fn builder() -> crate::input::update_network_analyzer_configuration_input::Builder {
        crate::input::update_network_analyzer_configuration_input::Builder::default()
    }
}

/// See [`UpdatePartnerAccountInput`](crate::input::UpdatePartnerAccountInput)
pub mod update_partner_account_input {
    /// A builder for [`UpdatePartnerAccountInput`](crate::input::UpdatePartnerAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sidewalk: std::option::Option<crate::model::SidewalkUpdateAccount>,
        pub(crate) partner_account_id: std::option::Option<std::string::String>,
        pub(crate) partner_type: std::option::Option<crate::model::PartnerType>,
    }
    impl Builder {
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkUpdateAccount) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkUpdateAccount>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partner_account_id = input;
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.partner_type = Some(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.partner_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePartnerAccountInput`](crate::input::UpdatePartnerAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePartnerAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePartnerAccountInput {
                sidewalk: self.sidewalk,
                partner_account_id: self.partner_account_id,
                partner_type: self.partner_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePartnerAccountInputOperationOutputAlias = crate::operation::UpdatePartnerAccount;
#[doc(hidden)]
pub type UpdatePartnerAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePartnerAccountInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePartnerAccount`](crate::operation::UpdatePartnerAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePartnerAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePartnerAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_98 = &_input.partner_account_id;
            let input_98 =
                input_98
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "partner_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let partner_account_id = aws_smithy_http::label::fmt_string(input_98, false);
            if partner_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "partner_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/partner-accounts/{PartnerAccountId}",
                PartnerAccountId = partner_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdatePartnerAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_99) = &_input.partner_type {
                query.push_kv(
                    "partnerType",
                    &aws_smithy_http::query::fmt_string(&inner_99),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePartnerAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePartnerAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_partner_account(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePartnerAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePartnerAccount",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePartnerAccountInput`](crate::input::UpdatePartnerAccountInput)
    pub fn builder() -> crate::input::update_partner_account_input::Builder {
        crate::input::update_partner_account_input::Builder::default()
    }
}

/// See [`UpdateResourceEventConfigurationInput`](crate::input::UpdateResourceEventConfigurationInput)
pub mod update_resource_event_configuration_input {
    /// A builder for [`UpdateResourceEventConfigurationInput`](crate::input::UpdateResourceEventConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) identifier_type: std::option::Option<crate::model::IdentifierType>,
        pub(crate) partner_type: std::option::Option<crate::model::EventNotificationPartnerType>,
        pub(crate) device_registration_state:
            std::option::Option<crate::model::DeviceRegistrationStateEventConfiguration>,
        pub(crate) proximity: std::option::Option<crate::model::ProximityEventConfiguration>,
    }
    impl Builder {
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn identifier_type(mut self, input: crate::model::IdentifierType) -> Self {
            self.identifier_type = Some(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::IdentifierType>,
        ) -> Self {
            self.identifier_type = input;
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
        pub fn partner_type(mut self, input: crate::model::EventNotificationPartnerType) -> Self {
            self.partner_type = Some(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::EventNotificationPartnerType>,
        ) -> Self {
            self.partner_type = input;
            self
        }
        /// <p>Event configuration for the device registration state event</p>
        pub fn device_registration_state(
            mut self,
            input: crate::model::DeviceRegistrationStateEventConfiguration,
        ) -> Self {
            self.device_registration_state = Some(input);
            self
        }
        /// <p>Event configuration for the device registration state event</p>
        pub fn set_device_registration_state(
            mut self,
            input: std::option::Option<crate::model::DeviceRegistrationStateEventConfiguration>,
        ) -> Self {
            self.device_registration_state = input;
            self
        }
        /// <p>Event configuration for the Proximity event</p>
        pub fn proximity(mut self, input: crate::model::ProximityEventConfiguration) -> Self {
            self.proximity = Some(input);
            self
        }
        /// <p>Event configuration for the Proximity event</p>
        pub fn set_proximity(
            mut self,
            input: std::option::Option<crate::model::ProximityEventConfiguration>,
        ) -> Self {
            self.proximity = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceEventConfigurationInput`](crate::input::UpdateResourceEventConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceEventConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceEventConfigurationInput {
                identifier: self.identifier,
                identifier_type: self.identifier_type,
                partner_type: self.partner_type,
                device_registration_state: self.device_registration_state,
                proximity: self.proximity,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceEventConfigurationInputOperationOutputAlias =
    crate::operation::UpdateResourceEventConfiguration;
#[doc(hidden)]
pub type UpdateResourceEventConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourceEventConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceEventConfiguration`](crate::operation::UpdateResourceEventConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceEventConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceEventConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_100 = &_input.identifier;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "identifier",
                        details: "cannot be empty or unset",
                    })?;
            let identifier = aws_smithy_http::label::fmt_string(input_100, false);
            if identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/event-configurations/{Identifier}",
                Identifier = identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdateResourceEventConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_101) = &_input.identifier_type {
                query.push_kv(
                    "identifierType",
                    &aws_smithy_http::query::fmt_string(&inner_101),
                );
            }
            if let Some(inner_102) = &_input.partner_type {
                query.push_kv(
                    "partnerType",
                    &aws_smithy_http::query::fmt_string(&inner_102),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceEventConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceEventConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resource_event_configuration(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceEventConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceEventConfiguration",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceEventConfigurationInput`](crate::input::UpdateResourceEventConfigurationInput)
    pub fn builder() -> crate::input::update_resource_event_configuration_input::Builder {
        crate::input::update_resource_event_configuration_input::Builder::default()
    }
}

/// See [`UpdateWirelessDeviceInput`](crate::input::UpdateWirelessDeviceInput)
pub mod update_wireless_device_input {
    /// A builder for [`UpdateWirelessDeviceInput`](crate::input::UpdateWirelessDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) destination_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateDevice>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_name = Some(input.into());
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_name = input;
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanUpdateDevice) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanUpdateDevice>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWirelessDeviceInput`](crate::input::UpdateWirelessDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWirelessDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWirelessDeviceInput {
                id: self.id,
                destination_name: self.destination_name,
                name: self.name,
                description: self.description,
                lo_ra_wan: self.lo_ra_wan,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWirelessDeviceInputOperationOutputAlias = crate::operation::UpdateWirelessDevice;
#[doc(hidden)]
pub type UpdateWirelessDeviceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateWirelessDeviceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWirelessDevice`](crate::operation::UpdateWirelessDevice)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWirelessDevice,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWirelessDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_103 = &_input.id;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_103, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-devices/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWirelessDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWirelessDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_wireless_device(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWirelessDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWirelessDevice",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWirelessDeviceInput`](crate::input::UpdateWirelessDeviceInput)
    pub fn builder() -> crate::input::update_wireless_device_input::Builder {
        crate::input::update_wireless_device_input::Builder::default()
    }
}

/// See [`UpdateWirelessGatewayInput`](crate::input::UpdateWirelessGatewayInput)
pub mod update_wireless_gateway_input {
    /// A builder for [`UpdateWirelessGatewayInput`](crate::input::UpdateWirelessGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) join_eui_filters:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) net_id_filters: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `join_eui_filters`.
        ///
        /// To override the contents of this collection use [`set_join_eui_filters`](Self::set_join_eui_filters).
        ///
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn join_eui_filters(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            let mut v = self.join_eui_filters.unwrap_or_default();
            v.push(input);
            self.join_eui_filters = Some(v);
            self
        }
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn set_join_eui_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.join_eui_filters = input;
            self
        }
        /// Appends an item to `net_id_filters`.
        ///
        /// To override the contents of this collection use [`set_net_id_filters`](Self::set_net_id_filters).
        ///
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn net_id_filters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.net_id_filters.unwrap_or_default();
            v.push(input.into());
            self.net_id_filters = Some(v);
            self
        }
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn set_net_id_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.net_id_filters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWirelessGatewayInput`](crate::input::UpdateWirelessGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWirelessGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWirelessGatewayInput {
                id: self.id,
                name: self.name,
                description: self.description,
                join_eui_filters: self.join_eui_filters,
                net_id_filters: self.net_id_filters,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWirelessGatewayInputOperationOutputAlias = crate::operation::UpdateWirelessGateway;
#[doc(hidden)]
pub type UpdateWirelessGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateWirelessGatewayInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWirelessGateway`](crate::operation::UpdateWirelessGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWirelessGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWirelessGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_104 = &_input.id;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_104, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/wireless-gateways/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWirelessGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWirelessGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_wireless_gateway(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWirelessGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWirelessGateway",
            "iotwireless",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWirelessGatewayInput`](crate::input::UpdateWirelessGatewayInput)
    pub fn builder() -> crate::input::update_wireless_gateway_input::Builder {
        crate::input::update_wireless_gateway_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWirelessGatewayInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The new name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A new description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
    pub join_eui_filters: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
    pub net_id_filters: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateWirelessGatewayInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The new name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A new description of the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
    pub fn join_eui_filters(&self) -> std::option::Option<&[std::vec::Vec<std::string::String>]> {
        self.join_eui_filters.as_deref()
    }
    /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
    pub fn net_id_filters(&self) -> std::option::Option<&[std::string::String]> {
        self.net_id_filters.as_deref()
    }
}
impl std::fmt::Debug for UpdateWirelessGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWirelessGatewayInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("join_eui_filters", &self.join_eui_filters);
        formatter.field("net_id_filters", &self.net_id_filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWirelessDeviceInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the new destination for the device.</p>
    pub destination_name: std::option::Option<std::string::String>,
    /// <p>The new name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A new description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated wireless device's configuration.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateDevice>,
}
impl UpdateWirelessDeviceInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the new destination for the device.</p>
    pub fn destination_name(&self) -> std::option::Option<&str> {
        self.destination_name.as_deref()
    }
    /// <p>The new name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A new description of the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated wireless device's configuration.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanUpdateDevice> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for UpdateWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWirelessDeviceInput");
        formatter.field("id", &self.id);
        formatter.field("destination_name", &self.destination_name);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceEventConfigurationInput {
    /// <p>Resource identifier to opt in for event messaging.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Identifier type of the particular resource identifier for event configuration.</p>
    pub identifier_type: std::option::Option<crate::model::IdentifierType>,
    /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
    pub partner_type: std::option::Option<crate::model::EventNotificationPartnerType>,
    /// <p>Event configuration for the device registration state event</p>
    pub device_registration_state:
        std::option::Option<crate::model::DeviceRegistrationStateEventConfiguration>,
    /// <p>Event configuration for the Proximity event</p>
    pub proximity: std::option::Option<crate::model::ProximityEventConfiguration>,
}
impl UpdateResourceEventConfigurationInput {
    /// <p>Resource identifier to opt in for event messaging.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Identifier type of the particular resource identifier for event configuration.</p>
    pub fn identifier_type(&self) -> std::option::Option<&crate::model::IdentifierType> {
        self.identifier_type.as_ref()
    }
    /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
    pub fn partner_type(&self) -> std::option::Option<&crate::model::EventNotificationPartnerType> {
        self.partner_type.as_ref()
    }
    /// <p>Event configuration for the device registration state event</p>
    pub fn device_registration_state(
        &self,
    ) -> std::option::Option<&crate::model::DeviceRegistrationStateEventConfiguration> {
        self.device_registration_state.as_ref()
    }
    /// <p>Event configuration for the Proximity event</p>
    pub fn proximity(&self) -> std::option::Option<&crate::model::ProximityEventConfiguration> {
        self.proximity.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceEventConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceEventConfigurationInput");
        formatter.field("identifier", &self.identifier);
        formatter.field("identifier_type", &self.identifier_type);
        formatter.field("partner_type", &self.partner_type);
        formatter.field("device_registration_state", &self.device_registration_state);
        formatter.field("proximity", &self.proximity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePartnerAccountInput {
    /// <p>The Sidewalk account credentials.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkUpdateAccount>,
    /// <p>The ID of the partner account to update.</p>
    pub partner_account_id: std::option::Option<std::string::String>,
    /// <p>The partner type.</p>
    pub partner_type: std::option::Option<crate::model::PartnerType>,
}
impl UpdatePartnerAccountInput {
    /// <p>The Sidewalk account credentials.</p>
    pub fn sidewalk(&self) -> std::option::Option<&crate::model::SidewalkUpdateAccount> {
        self.sidewalk.as_ref()
    }
    /// <p>The ID of the partner account to update.</p>
    pub fn partner_account_id(&self) -> std::option::Option<&str> {
        self.partner_account_id.as_deref()
    }
    /// <p>The partner type.</p>
    pub fn partner_type(&self) -> std::option::Option<&crate::model::PartnerType> {
        self.partner_type.as_ref()
    }
}
impl std::fmt::Debug for UpdatePartnerAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePartnerAccountInput");
        formatter.field("sidewalk", &self.sidewalk);
        formatter.field("partner_account_id", &self.partner_account_id);
        formatter.field("partner_type", &self.partner_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNetworkAnalyzerConfigurationInput {
    /// <p>NetworkAnalyzer configuration name.</p>
    pub configuration_name: std::option::Option<std::string::String>,
    /// <p>Trace Content for resources.</p>
    pub trace_content: std::option::Option<crate::model::TraceContent>,
    /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
    pub wireless_devices_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
    pub wireless_devices_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
    pub wireless_gateways_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
    pub wireless_gateways_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateNetworkAnalyzerConfigurationInput {
    /// <p>NetworkAnalyzer configuration name.</p>
    pub fn configuration_name(&self) -> std::option::Option<&str> {
        self.configuration_name.as_deref()
    }
    /// <p>Trace Content for resources.</p>
    pub fn trace_content(&self) -> std::option::Option<&crate::model::TraceContent> {
        self.trace_content.as_ref()
    }
    /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
    pub fn wireless_devices_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.wireless_devices_to_add.as_deref()
    }
    /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
    pub fn wireless_devices_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.wireless_devices_to_remove.as_deref()
    }
    /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
    pub fn wireless_gateways_to_add(&self) -> std::option::Option<&[std::string::String]> {
        self.wireless_gateways_to_add.as_deref()
    }
    /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
    pub fn wireless_gateways_to_remove(&self) -> std::option::Option<&[std::string::String]> {
        self.wireless_gateways_to_remove.as_deref()
    }
}
impl std::fmt::Debug for UpdateNetworkAnalyzerConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNetworkAnalyzerConfigurationInput");
        formatter.field("configuration_name", &self.configuration_name);
        formatter.field("trace_content", &self.trace_content);
        formatter.field("wireless_devices_to_add", &self.wireless_devices_to_add);
        formatter.field(
            "wireless_devices_to_remove",
            &self.wireless_devices_to_remove,
        );
        formatter.field("wireless_gateways_to_add", &self.wireless_gateways_to_add);
        formatter.field(
            "wireless_gateways_to_remove",
            &self.wireless_gateways_to_remove,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the multicast group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticast>,
}
impl UpdateMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the multicast group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanMulticast> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for UpdateMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLogLevelsByResourceTypesInput {
    /// <p>The log level for a log message.</p>
    pub default_log_level: std::option::Option<crate::model::LogLevel>,
    /// <p>The list of wireless device log options.</p>
    pub wireless_device_log_options:
        std::option::Option<std::vec::Vec<crate::model::WirelessDeviceLogOption>>,
    /// <p>The list of wireless gateway log options.</p>
    pub wireless_gateway_log_options:
        std::option::Option<std::vec::Vec<crate::model::WirelessGatewayLogOption>>,
}
impl UpdateLogLevelsByResourceTypesInput {
    /// <p>The log level for a log message.</p>
    pub fn default_log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.default_log_level.as_ref()
    }
    /// <p>The list of wireless device log options.</p>
    pub fn wireless_device_log_options(
        &self,
    ) -> std::option::Option<&[crate::model::WirelessDeviceLogOption]> {
        self.wireless_device_log_options.as_deref()
    }
    /// <p>The list of wireless gateway log options.</p>
    pub fn wireless_gateway_log_options(
        &self,
    ) -> std::option::Option<&[crate::model::WirelessGatewayLogOption]> {
        self.wireless_gateway_log_options.as_deref()
    }
}
impl std::fmt::Debug for UpdateLogLevelsByResourceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLogLevelsByResourceTypesInput");
        formatter.field("default_log_level", &self.default_log_level);
        formatter.field(
            "wireless_device_log_options",
            &self.wireless_device_log_options,
        );
        formatter.field(
            "wireless_gateway_log_options",
            &self.wireless_gateway_log_options,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of a FUOTA task.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information used with a FUOTA task.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanFuotaTask>,
    /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    pub firmware_update_image: std::option::Option<std::string::String>,
    /// <p>The firmware update role that is to be used with a FUOTA task.</p>
    pub firmware_update_role: std::option::Option<std::string::String>,
}
impl UpdateFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of a FUOTA task.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The LoRaWAN information used with a FUOTA task.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanFuotaTask> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    pub fn firmware_update_image(&self) -> std::option::Option<&str> {
        self.firmware_update_image.as_deref()
    }
    /// <p>The firmware update role that is to be used with a FUOTA task.</p>
    pub fn firmware_update_role(&self) -> std::option::Option<&str> {
        self.firmware_update_role.as_deref()
    }
}
impl std::fmt::Debug for UpdateFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("firmware_update_image", &self.firmware_update_image);
        formatter.field("firmware_update_role", &self.firmware_update_role);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDestinationInput {
    /// <p>The new name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of value in <code>Expression</code>.</p>
    pub expression_type: std::option::Option<crate::model::ExpressionType>,
    /// <p>The new rule name or topic rule to send messages to.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>A new description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl UpdateDestinationInput {
    /// <p>The new name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of value in <code>Expression</code>.</p>
    pub fn expression_type(&self) -> std::option::Option<&crate::model::ExpressionType> {
        self.expression_type.as_ref()
    }
    /// <p>The new rule name or topic rule to send messages to.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>A new description of the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDestinationInput");
        formatter.field("name", &self.name);
        formatter.field("expression_type", &self.expression_type);
        formatter.field("expression", &self.expression);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource to remove tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys of the tags to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource to remove tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys of the tags to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestWirelessDeviceInput {
    /// <p>The ID of the wireless device to test.</p>
    pub id: std::option::Option<std::string::String>,
}
impl TestWirelessDeviceInput {
    /// <p>The ID of the wireless device to test.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for TestWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestWirelessDeviceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource to add tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource to add tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information used with the multicast session.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticastSession>,
}
impl StartMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The LoRaWAN information used with the multicast session.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanMulticastSession> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for StartMulticastGroupSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMulticastGroupSessionInput");
        formatter.field("id", &self.id);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information used to start a FUOTA task.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanStartFuotaTask>,
}
impl StartFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The LoRaWAN information used to start a FUOTA task.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanStartFuotaTask> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for StartFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBulkDisassociateWirelessDeviceFromMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl StartBulkDisassociateWirelessDeviceFromMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for StartBulkDisassociateWirelessDeviceFromMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("StartBulkDisassociateWirelessDeviceFromMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("query_string", &self.query_string);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBulkAssociateWirelessDeviceWithMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl StartBulkAssociateWirelessDeviceWithMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for StartBulkAssociateWirelessDeviceWithMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("StartBulkAssociateWirelessDeviceWithMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("query_string", &self.query_string);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendDataToWirelessDeviceInput {
    /// <p>The ID of the wireless device to receive the data.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
    pub transmit_mode: std::option::Option<i32>,
    /// <p>The binary to be sent to the end device, encoded in base64.</p>
    pub payload_data: std::option::Option<std::string::String>,
    /// <p>Metadata about the message request.</p>
    pub wireless_metadata: std::option::Option<crate::model::WirelessMetadata>,
}
impl SendDataToWirelessDeviceInput {
    /// <p>The ID of the wireless device to receive the data.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
    pub fn transmit_mode(&self) -> std::option::Option<i32> {
        self.transmit_mode
    }
    /// <p>The binary to be sent to the end device, encoded in base64.</p>
    pub fn payload_data(&self) -> std::option::Option<&str> {
        self.payload_data.as_deref()
    }
    /// <p>Metadata about the message request.</p>
    pub fn wireless_metadata(&self) -> std::option::Option<&crate::model::WirelessMetadata> {
        self.wireless_metadata.as_ref()
    }
}
impl std::fmt::Debug for SendDataToWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendDataToWirelessDeviceInput");
        formatter.field("id", &self.id);
        formatter.field("transmit_mode", &self.transmit_mode);
        formatter.field("payload_data", &self.payload_data);
        formatter.field("wireless_metadata", &self.wireless_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendDataToMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The binary to be sent to the end device, encoded in base64.</p>
    pub payload_data: std::option::Option<std::string::String>,
    /// <p>Wireless metadata that is to be sent to multicast group.</p>
    pub wireless_metadata: std::option::Option<crate::model::MulticastWirelessMetadata>,
}
impl SendDataToMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The binary to be sent to the end device, encoded in base64.</p>
    pub fn payload_data(&self) -> std::option::Option<&str> {
        self.payload_data.as_deref()
    }
    /// <p>Wireless metadata that is to be sent to multicast group.</p>
    pub fn wireless_metadata(
        &self,
    ) -> std::option::Option<&crate::model::MulticastWirelessMetadata> {
        self.wireless_metadata.as_ref()
    }
}
impl std::fmt::Debug for SendDataToMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendDataToMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("payload_data", &self.payload_data);
        formatter.field("wireless_metadata", &self.wireless_metadata);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResetResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResetResourceLogLevelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetResourceLogLevelInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetAllResourceLogLevelsInput {}
impl std::fmt::Debug for ResetAllResourceLogLevelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetAllResourceLogLevelsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl PutResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for PutResourceLogLevelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourceLogLevelInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWirelessGatewayTaskDefinitionsInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
    pub task_definition_type: std::option::Option<crate::model::WirelessGatewayTaskDefinitionType>,
}
impl ListWirelessGatewayTaskDefinitionsInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
    pub fn task_definition_type(
        &self,
    ) -> std::option::Option<&crate::model::WirelessGatewayTaskDefinitionType> {
        self.task_definition_type.as_ref()
    }
}
impl std::fmt::Debug for ListWirelessGatewayTaskDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWirelessGatewayTaskDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("task_definition_type", &self.task_definition_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWirelessGatewaysInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListWirelessGatewaysInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListWirelessGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWirelessGatewaysInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWirelessDevicesInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A filter to list only the wireless devices that use this destination.</p>
    pub destination_name: std::option::Option<std::string::String>,
    /// <p>A filter to list only the wireless devices that use this device profile.</p>
    pub device_profile_id: std::option::Option<std::string::String>,
    /// <p>A filter to list only the wireless devices that use this service profile.</p>
    pub service_profile_id: std::option::Option<std::string::String>,
    /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
    pub wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
    /// <p>The ID of a FUOTA task.</p>
    pub fuota_task_id: std::option::Option<std::string::String>,
    /// <p>The ID of the multicast group.</p>
    pub multicast_group_id: std::option::Option<std::string::String>,
}
impl ListWirelessDevicesInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A filter to list only the wireless devices that use this destination.</p>
    pub fn destination_name(&self) -> std::option::Option<&str> {
        self.destination_name.as_deref()
    }
    /// <p>A filter to list only the wireless devices that use this device profile.</p>
    pub fn device_profile_id(&self) -> std::option::Option<&str> {
        self.device_profile_id.as_deref()
    }
    /// <p>A filter to list only the wireless devices that use this service profile.</p>
    pub fn service_profile_id(&self) -> std::option::Option<&str> {
        self.service_profile_id.as_deref()
    }
    /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
    pub fn wireless_device_type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.wireless_device_type.as_ref()
    }
    /// <p>The ID of a FUOTA task.</p>
    pub fn fuota_task_id(&self) -> std::option::Option<&str> {
        self.fuota_task_id.as_deref()
    }
    /// <p>The ID of the multicast group.</p>
    pub fn multicast_group_id(&self) -> std::option::Option<&str> {
        self.multicast_group_id.as_deref()
    }
}
impl std::fmt::Debug for ListWirelessDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWirelessDevicesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("destination_name", &self.destination_name);
        formatter.field("device_profile_id", &self.device_profile_id);
        formatter.field("service_profile_id", &self.service_profile_id);
        formatter.field("wireless_device_type", &self.wireless_device_type);
        formatter.field("fuota_task_id", &self.fuota_task_id);
        formatter.field("multicast_group_id", &self.multicast_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource for which you want to list tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource for which you want to list tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceProfilesInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListServiceProfilesInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListServiceProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceProfilesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueuedMessagesInput {
    /// <p>Id of a given wireless device which the downlink packets are targeted </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
    /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
    pub wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
}
impl ListQueuedMessagesInput {
    /// <p>Id of a given wireless device which the downlink packets are targeted </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
    pub fn wireless_device_type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.wireless_device_type.as_ref()
    }
}
impl std::fmt::Debug for ListQueuedMessagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueuedMessagesInput");
        formatter.field("id", &self.id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("wireless_device_type", &self.wireless_device_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartnerAccountsInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListPartnerAccountsInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListPartnerAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartnerAccountsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMulticastGroupsByFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListMulticastGroupsByFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListMulticastGroupsByFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMulticastGroupsByFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMulticastGroupsInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListMulticastGroupsInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListMulticastGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMulticastGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFuotaTasksInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListFuotaTasksInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListFuotaTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFuotaTasksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceProfilesInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
}
impl ListDeviceProfilesInput {
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDeviceProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceProfilesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDestinationsInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub max_results: i32,
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDestinationsInput {
    /// <p>The maximum number of results to return in this operation.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDestinationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayTaskDefinitionInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetWirelessGatewayTaskDefinitionInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayTaskDefinitionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayTaskInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetWirelessGatewayTaskInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayTaskInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayStatisticsInput {
    /// <p>The ID of the wireless gateway for which to get the data.</p>
    pub wireless_gateway_id: std::option::Option<std::string::String>,
}
impl GetWirelessGatewayStatisticsInput {
    /// <p>The ID of the wireless gateway for which to get the data.</p>
    pub fn wireless_gateway_id(&self) -> std::option::Option<&str> {
        self.wireless_gateway_id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayStatisticsInput");
        formatter.field("wireless_gateway_id", &self.wireless_gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayFirmwareInformationInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetWirelessGatewayFirmwareInformationInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayFirmwareInformationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayFirmwareInformationInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayCertificateInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetWirelessGatewayCertificateInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayCertificateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessGatewayInput {
    /// <p>The identifier of the wireless gateway to get.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The type of identifier used in <code>identifier</code>.</p>
    pub identifier_type: std::option::Option<crate::model::WirelessGatewayIdType>,
}
impl GetWirelessGatewayInput {
    /// <p>The identifier of the wireless gateway to get.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The type of identifier used in <code>identifier</code>.</p>
    pub fn identifier_type(&self) -> std::option::Option<&crate::model::WirelessGatewayIdType> {
        self.identifier_type.as_ref()
    }
}
impl std::fmt::Debug for GetWirelessGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessGatewayInput");
        formatter.field("identifier", &self.identifier);
        formatter.field("identifier_type", &self.identifier_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessDeviceStatisticsInput {
    /// <p>The ID of the wireless device for which to get the data.</p>
    pub wireless_device_id: std::option::Option<std::string::String>,
}
impl GetWirelessDeviceStatisticsInput {
    /// <p>The ID of the wireless device for which to get the data.</p>
    pub fn wireless_device_id(&self) -> std::option::Option<&str> {
        self.wireless_device_id.as_deref()
    }
}
impl std::fmt::Debug for GetWirelessDeviceStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessDeviceStatisticsInput");
        formatter.field("wireless_device_id", &self.wireless_device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWirelessDeviceInput {
    /// <p>The identifier of the wireless device to get.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The type of identifier used in <code>identifier</code>.</p>
    pub identifier_type: std::option::Option<crate::model::WirelessDeviceIdType>,
}
impl GetWirelessDeviceInput {
    /// <p>The identifier of the wireless device to get.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The type of identifier used in <code>identifier</code>.</p>
    pub fn identifier_type(&self) -> std::option::Option<&crate::model::WirelessDeviceIdType> {
        self.identifier_type.as_ref()
    }
}
impl std::fmt::Debug for GetWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWirelessDeviceInput");
        formatter.field("identifier", &self.identifier);
        formatter.field("identifier_type", &self.identifier_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceProfileInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetServiceProfileInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetServiceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceProfileInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceEndpointInput {
    /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
    pub service_type: std::option::Option<crate::model::WirelessGatewayServiceType>,
}
impl GetServiceEndpointInput {
    /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::WirelessGatewayServiceType> {
        self.service_type.as_ref()
    }
}
impl std::fmt::Debug for GetServiceEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceEndpointInput");
        formatter.field("service_type", &self.service_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl GetResourceLogLevelInput {
    /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for GetResourceLogLevelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceLogLevelInput");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceEventConfigurationInput {
    /// <p>Resource identifier to opt in for event messaging.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Identifier type of the particular resource identifier for event configuration.</p>
    pub identifier_type: std::option::Option<crate::model::IdentifierType>,
    /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
    pub partner_type: std::option::Option<crate::model::EventNotificationPartnerType>,
}
impl GetResourceEventConfigurationInput {
    /// <p>Resource identifier to opt in for event messaging.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Identifier type of the particular resource identifier for event configuration.</p>
    pub fn identifier_type(&self) -> std::option::Option<&crate::model::IdentifierType> {
        self.identifier_type.as_ref()
    }
    /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
    pub fn partner_type(&self) -> std::option::Option<&crate::model::EventNotificationPartnerType> {
        self.partner_type.as_ref()
    }
}
impl std::fmt::Debug for GetResourceEventConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceEventConfigurationInput");
        formatter.field("identifier", &self.identifier);
        formatter.field("identifier_type", &self.identifier_type);
        formatter.field("partner_type", &self.partner_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPartnerAccountInput {
    /// <p>The partner account ID to disassociate from the AWS account.</p>
    pub partner_account_id: std::option::Option<std::string::String>,
    /// <p>The partner type.</p>
    pub partner_type: std::option::Option<crate::model::PartnerType>,
}
impl GetPartnerAccountInput {
    /// <p>The partner account ID to disassociate from the AWS account.</p>
    pub fn partner_account_id(&self) -> std::option::Option<&str> {
        self.partner_account_id.as_deref()
    }
    /// <p>The partner type.</p>
    pub fn partner_type(&self) -> std::option::Option<&crate::model::PartnerType> {
        self.partner_type.as_ref()
    }
}
impl std::fmt::Debug for GetPartnerAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPartnerAccountInput");
        formatter.field("partner_account_id", &self.partner_account_id);
        formatter.field("partner_type", &self.partner_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkAnalyzerConfigurationInput {
    /// <p>NetworkAnalyzer configuration name.</p>
    pub configuration_name: std::option::Option<std::string::String>,
}
impl GetNetworkAnalyzerConfigurationInput {
    /// <p>NetworkAnalyzer configuration name.</p>
    pub fn configuration_name(&self) -> std::option::Option<&str> {
        self.configuration_name.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkAnalyzerConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkAnalyzerConfigurationInput");
        formatter.field("configuration_name", &self.configuration_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetMulticastGroupSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMulticastGroupSessionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLogLevelsByResourceTypesInput {}
impl std::fmt::Debug for GetLogLevelsByResourceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLogLevelsByResourceTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceProfileInput {
    /// <p>The ID of the resource to get.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetDeviceProfileInput {
    /// <p>The ID of the resource to get.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetDeviceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceProfileInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDestinationInput {
    /// <p>The name of the resource to get.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetDestinationInput {
    /// <p>The name of the resource to get.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDestinationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateWirelessGatewayFromThingInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DisassociateWirelessGatewayFromThingInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateWirelessGatewayFromThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateWirelessGatewayFromThingInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateWirelessGatewayFromCertificateInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DisassociateWirelessGatewayFromCertificateInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateWirelessGatewayFromCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateWirelessGatewayFromCertificateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateWirelessDeviceFromThingInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DisassociateWirelessDeviceFromThingInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateWirelessDeviceFromThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateWirelessDeviceFromThingInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateWirelessDeviceFromMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless device.</p>
    pub wireless_device_id: std::option::Option<std::string::String>,
}
impl DisassociateWirelessDeviceFromMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the wireless device.</p>
    pub fn wireless_device_id(&self) -> std::option::Option<&str> {
        self.wireless_device_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateWirelessDeviceFromMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateWirelessDeviceFromMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("wireless_device_id", &self.wireless_device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateWirelessDeviceFromFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless device.</p>
    pub wireless_device_id: std::option::Option<std::string::String>,
}
impl DisassociateWirelessDeviceFromFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the wireless device.</p>
    pub fn wireless_device_id(&self) -> std::option::Option<&str> {
        self.wireless_device_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateWirelessDeviceFromFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateWirelessDeviceFromFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("wireless_device_id", &self.wireless_device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMulticastGroupFromFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the multicast group.</p>
    pub multicast_group_id: std::option::Option<std::string::String>,
}
impl DisassociateMulticastGroupFromFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the multicast group.</p>
    pub fn multicast_group_id(&self) -> std::option::Option<&str> {
        self.multicast_group_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMulticastGroupFromFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMulticastGroupFromFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("multicast_group_id", &self.multicast_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAwsAccountFromPartnerAccountInput {
    /// <p>The partner account ID to disassociate from the AWS account.</p>
    pub partner_account_id: std::option::Option<std::string::String>,
    /// <p>The partner type.</p>
    pub partner_type: std::option::Option<crate::model::PartnerType>,
}
impl DisassociateAwsAccountFromPartnerAccountInput {
    /// <p>The partner account ID to disassociate from the AWS account.</p>
    pub fn partner_account_id(&self) -> std::option::Option<&str> {
        self.partner_account_id.as_deref()
    }
    /// <p>The partner type.</p>
    pub fn partner_type(&self) -> std::option::Option<&crate::model::PartnerType> {
        self.partner_type.as_ref()
    }
}
impl std::fmt::Debug for DisassociateAwsAccountFromPartnerAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAwsAccountFromPartnerAccountInput");
        formatter.field("partner_account_id", &self.partner_account_id);
        formatter.field("partner_type", &self.partner_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWirelessGatewayTaskDefinitionInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteWirelessGatewayTaskDefinitionInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWirelessGatewayTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWirelessGatewayTaskDefinitionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWirelessGatewayTaskInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteWirelessGatewayTaskInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWirelessGatewayTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWirelessGatewayTaskInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWirelessGatewayInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteWirelessGatewayInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWirelessGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWirelessGatewayInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWirelessDeviceInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteWirelessDeviceInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWirelessDeviceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceProfileInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteServiceProfileInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteServiceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceProfileInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueuedMessagesInput {
    /// <p>Id of a given wireless device which messages will be deleted </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
    pub wireless_device_type: std::option::Option<crate::model::WirelessDeviceType>,
}
impl DeleteQueuedMessagesInput {
    /// <p>Id of a given wireless device which messages will be deleted </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
    pub fn wireless_device_type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.wireless_device_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteQueuedMessagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueuedMessagesInput");
        formatter.field("id", &self.id);
        formatter.field("message_id", &self.message_id);
        formatter.field("wireless_device_type", &self.wireless_device_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceProfileInput {
    /// <p>The ID of the resource to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteDeviceProfileInput {
    /// <p>The ID of the resource to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDeviceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceProfileInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDestinationInput {
    /// <p>The name of the resource to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDestinationInput {
    /// <p>The name of the resource to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDestinationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWirelessGatewayTaskDefinitionInput {
    /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
    pub auto_create_tasks: bool,
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Information about the gateways to update.</p>
    pub update: std::option::Option<crate::model::UpdateWirelessGatewayTaskCreate>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateWirelessGatewayTaskDefinitionInput {
    /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
    pub fn auto_create_tasks(&self) -> bool {
        self.auto_create_tasks
    }
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Information about the gateways to update.</p>
    pub fn update(&self) -> std::option::Option<&crate::model::UpdateWirelessGatewayTaskCreate> {
        self.update.as_ref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateWirelessGatewayTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWirelessGatewayTaskDefinitionInput");
        formatter.field("auto_create_tasks", &self.auto_create_tasks);
        formatter.field("name", &self.name);
        formatter.field("update", &self.update);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWirelessGatewayTaskInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
    pub wireless_gateway_task_definition_id: std::option::Option<std::string::String>,
}
impl CreateWirelessGatewayTaskInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
    pub fn wireless_gateway_task_definition_id(&self) -> std::option::Option<&str> {
        self.wireless_gateway_task_definition_id.as_deref()
    }
}
impl std::fmt::Debug for CreateWirelessGatewayTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWirelessGatewayTaskInput");
        formatter.field("id", &self.id);
        formatter.field(
            "wireless_gateway_task_definition_id",
            &self.wireless_gateway_task_definition_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWirelessGatewayInput {
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The gateway configuration information to use to create the wireless gateway.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanGateway>,
    /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateWirelessGatewayInput {
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The gateway configuration information to use to create the wireless gateway.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanGateway> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateWirelessGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWirelessGatewayInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("tags", &self.tags);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWirelessDeviceInput {
    /// <p>The wireless device type.</p>
    pub r#type: std::option::Option<crate::model::WirelessDeviceType>,
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the destination to assign to the new wireless device.</p>
    pub destination_name: std::option::Option<std::string::String>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The device configuration information to use to create the wireless device.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanDevice>,
    /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateWirelessDeviceInput {
    /// <p>The wireless device type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the destination to assign to the new wireless device.</p>
    pub fn destination_name(&self) -> std::option::Option<&str> {
        self.destination_name.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The device configuration information to use to create the wireless device.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanDevice> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateWirelessDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWirelessDeviceInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("destination_name", &self.destination_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceProfileInput {
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The service profile information to use to create the service profile.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanServiceProfile>,
    /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateServiceProfileInput {
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The service profile information to use to create the service profile.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanServiceProfile> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateServiceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceProfileInput");
        formatter.field("name", &self.name);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("tags", &self.tags);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMulticastGroupInput {
    /// <p>The name of the multicast group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the multicast group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticast>,
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateMulticastGroupInput {
    /// <p>The name of the multicast group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the multicast group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanMulticast> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMulticastGroupInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFuotaTaskInput {
    /// <p>The name of a FUOTA task.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The LoRaWAN information used with a FUOTA task.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanFuotaTask>,
    /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    pub firmware_update_image: std::option::Option<std::string::String>,
    /// <p>The firmware update role that is to be used with a FUOTA task.</p>
    pub firmware_update_role: std::option::Option<std::string::String>,
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFuotaTaskInput {
    /// <p>The name of a FUOTA task.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The LoRaWAN information used with a FUOTA task.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanFuotaTask> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    pub fn firmware_update_image(&self) -> std::option::Option<&str> {
        self.firmware_update_image.as_deref()
    }
    /// <p>The firmware update role that is to be used with a FUOTA task.</p>
    pub fn firmware_update_role(&self) -> std::option::Option<&str> {
        self.firmware_update_role.as_deref()
    }
    /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFuotaTaskInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("firmware_update_image", &self.firmware_update_image);
        formatter.field("firmware_update_role", &self.firmware_update_role);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceProfileInput {
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The device profile information to use to create the device profile.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanDeviceProfile>,
    /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateDeviceProfileInput {
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The device profile information to use to create the device profile.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanDeviceProfile> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateDeviceProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceProfileInput");
        formatter.field("name", &self.name);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("tags", &self.tags);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDestinationInput {
    /// <p>The name of the new resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of value in <code>Expression</code>.</p>
    pub expression_type: std::option::Option<crate::model::ExpressionType>,
    /// <p>The rule name or topic rule to send messages to.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The description of the new resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreateDestinationInput {
    /// <p>The name of the new resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of value in <code>Expression</code>.</p>
    pub fn expression_type(&self) -> std::option::Option<&crate::model::ExpressionType> {
        self.expression_type.as_ref()
    }
    /// <p>The rule name or topic rule to send messages to.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The description of the new resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreateDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDestinationInput");
        formatter.field("name", &self.name);
        formatter.field("expression_type", &self.expression_type);
        formatter.field("expression", &self.expression);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl CancelMulticastGroupSessionInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for CancelMulticastGroupSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelMulticastGroupSessionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateWirelessGatewayWithThingInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the thing to associate with the wireless gateway.</p>
    pub thing_arn: std::option::Option<std::string::String>,
}
impl AssociateWirelessGatewayWithThingInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the thing to associate with the wireless gateway.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateWirelessGatewayWithThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateWirelessGatewayWithThingInput");
        formatter.field("id", &self.id);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateWirelessGatewayWithCertificateInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the certificate to associate with the wireless gateway.</p>
    pub iot_certificate_id: std::option::Option<std::string::String>,
}
impl AssociateWirelessGatewayWithCertificateInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the certificate to associate with the wireless gateway.</p>
    pub fn iot_certificate_id(&self) -> std::option::Option<&str> {
        self.iot_certificate_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateWirelessGatewayWithCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateWirelessGatewayWithCertificateInput");
        formatter.field("id", &self.id);
        formatter.field("iot_certificate_id", &self.iot_certificate_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateWirelessDeviceWithThingInput {
    /// <p>The ID of the resource to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the thing to associate with the wireless device.</p>
    pub thing_arn: std::option::Option<std::string::String>,
}
impl AssociateWirelessDeviceWithThingInput {
    /// <p>The ID of the resource to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the thing to associate with the wireless device.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateWirelessDeviceWithThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateWirelessDeviceWithThingInput");
        formatter.field("id", &self.id);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateWirelessDeviceWithMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless device.</p>
    pub wireless_device_id: std::option::Option<std::string::String>,
}
impl AssociateWirelessDeviceWithMulticastGroupInput {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the wireless device.</p>
    pub fn wireless_device_id(&self) -> std::option::Option<&str> {
        self.wireless_device_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateWirelessDeviceWithMulticastGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateWirelessDeviceWithMulticastGroupInput");
        formatter.field("id", &self.id);
        formatter.field("wireless_device_id", &self.wireless_device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateWirelessDeviceWithFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless device.</p>
    pub wireless_device_id: std::option::Option<std::string::String>,
}
impl AssociateWirelessDeviceWithFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the wireless device.</p>
    pub fn wireless_device_id(&self) -> std::option::Option<&str> {
        self.wireless_device_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateWirelessDeviceWithFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateWirelessDeviceWithFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("wireless_device_id", &self.wireless_device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateMulticastGroupWithFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the multicast group.</p>
    pub multicast_group_id: std::option::Option<std::string::String>,
}
impl AssociateMulticastGroupWithFuotaTaskInput {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ID of the multicast group.</p>
    pub fn multicast_group_id(&self) -> std::option::Option<&str> {
        self.multicast_group_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateMulticastGroupWithFuotaTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateMulticastGroupWithFuotaTaskInput");
        formatter.field("id", &self.id);
        formatter.field("multicast_group_id", &self.multicast_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAwsAccountWithPartnerAccountInput {
    /// <p>The Sidewalk account credentials.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkAccountInfo>,
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AssociateAwsAccountWithPartnerAccountInput {
    /// <p>The Sidewalk account credentials.</p>
    pub fn sidewalk(&self) -> std::option::Option<&crate::model::SidewalkAccountInfo> {
        self.sidewalk.as_ref()
    }
    /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AssociateAwsAccountWithPartnerAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAwsAccountWithPartnerAccountInput");
        formatter.field("sidewalk", &self.sidewalk);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
