// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Wireless
///
/// Client for invoking operations on AWS IoT Wireless. Each operation on AWS IoT Wireless is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotwireless::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotwireless::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotwireless::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateAwsAccountWithPartnerAccount`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sidewalk(SidewalkAccountInfo)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::sidewalk) / [`set_sidewalk(Option<SidewalkAccountInfo>)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::set_sidewalk): <p>The Sidewalk account credentials.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount::set_tags): <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`AssociateAwsAccountWithPartnerAccountOutput`](crate::output::AssociateAwsAccountWithPartnerAccountOutput) with field(s):
    ///   - [`sidewalk(Option<SidewalkAccountInfo>)`](crate::output::AssociateAwsAccountWithPartnerAccountOutput::sidewalk): <p>The Sidewalk account credentials.</p>
    ///   - [`arn(Option<String>)`](crate::output::AssociateAwsAccountWithPartnerAccountOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    /// - On failure, responds with [`SdkError<AssociateAwsAccountWithPartnerAccountError>`](crate::error::AssociateAwsAccountWithPartnerAccountError)
    pub fn associate_aws_account_with_partner_account(
        &self,
    ) -> fluent_builders::AssociateAwsAccountWithPartnerAccount<C, M, R> {
        fluent_builders::AssociateAwsAccountWithPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateMulticastGroupWithFuotaTask`](crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`multicast_group_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask::multicast_group_id) / [`set_multicast_group_id(Option<String>)`](crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask::set_multicast_group_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`AssociateMulticastGroupWithFuotaTaskOutput`](crate::output::AssociateMulticastGroupWithFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<AssociateMulticastGroupWithFuotaTaskError>`](crate::error::AssociateMulticastGroupWithFuotaTaskError)
    pub fn associate_multicast_group_with_fuota_task(
        &self,
    ) -> fluent_builders::AssociateMulticastGroupWithFuotaTask<C, M, R> {
        fluent_builders::AssociateMulticastGroupWithFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWirelessDeviceWithFuotaTask`](crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`wireless_device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask::wireless_device_id) / [`set_wireless_device_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask::set_wireless_device_id): <p>The ID of the wireless device.</p>
    /// - On success, responds with [`AssociateWirelessDeviceWithFuotaTaskOutput`](crate::output::AssociateWirelessDeviceWithFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<AssociateWirelessDeviceWithFuotaTaskError>`](crate::error::AssociateWirelessDeviceWithFuotaTaskError)
    pub fn associate_wireless_device_with_fuota_task(
        &self,
    ) -> fluent_builders::AssociateWirelessDeviceWithFuotaTask<C, M, R> {
        fluent_builders::AssociateWirelessDeviceWithFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWirelessDeviceWithMulticastGroup`](crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`wireless_device_id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup::wireless_device_id) / [`set_wireless_device_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup::set_wireless_device_id): <p>The ID of the wireless device.</p>
    /// - On success, responds with [`AssociateWirelessDeviceWithMulticastGroupOutput`](crate::output::AssociateWirelessDeviceWithMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<AssociateWirelessDeviceWithMulticastGroupError>`](crate::error::AssociateWirelessDeviceWithMulticastGroupError)
    pub fn associate_wireless_device_with_multicast_group(
        &self,
    ) -> fluent_builders::AssociateWirelessDeviceWithMulticastGroup<C, M, R> {
        fluent_builders::AssociateWirelessDeviceWithMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWirelessDeviceWithThing`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing::set_id): <p>The ID of the resource to update.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing::set_thing_arn): <p>The ARN of the thing to associate with the wireless device.</p>
    /// - On success, responds with [`AssociateWirelessDeviceWithThingOutput`](crate::output::AssociateWirelessDeviceWithThingOutput)

    /// - On failure, responds with [`SdkError<AssociateWirelessDeviceWithThingError>`](crate::error::AssociateWirelessDeviceWithThingError)
    pub fn associate_wireless_device_with_thing(
        &self,
    ) -> fluent_builders::AssociateWirelessDeviceWithThing<C, M, R> {
        fluent_builders::AssociateWirelessDeviceWithThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWirelessGatewayWithCertificate`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate::set_id): <p>The ID of the resource to update.</p>
    ///   - [`iot_certificate_id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate::iot_certificate_id) / [`set_iot_certificate_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate::set_iot_certificate_id): <p>The ID of the certificate to associate with the wireless gateway.</p>
    /// - On success, responds with [`AssociateWirelessGatewayWithCertificateOutput`](crate::output::AssociateWirelessGatewayWithCertificateOutput) with field(s):
    ///   - [`iot_certificate_id(Option<String>)`](crate::output::AssociateWirelessGatewayWithCertificateOutput::iot_certificate_id): <p>The ID of the certificate associated with the wireless gateway.</p>
    /// - On failure, responds with [`SdkError<AssociateWirelessGatewayWithCertificateError>`](crate::error::AssociateWirelessGatewayWithCertificateError)
    pub fn associate_wireless_gateway_with_certificate(
        &self,
    ) -> fluent_builders::AssociateWirelessGatewayWithCertificate<C, M, R> {
        fluent_builders::AssociateWirelessGatewayWithCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateWirelessGatewayWithThing`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing::set_id): <p>The ID of the resource to update.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing::set_thing_arn): <p>The ARN of the thing to associate with the wireless gateway.</p>
    /// - On success, responds with [`AssociateWirelessGatewayWithThingOutput`](crate::output::AssociateWirelessGatewayWithThingOutput)

    /// - On failure, responds with [`SdkError<AssociateWirelessGatewayWithThingError>`](crate::error::AssociateWirelessGatewayWithThingError)
    pub fn associate_wireless_gateway_with_thing(
        &self,
    ) -> fluent_builders::AssociateWirelessGatewayWithThing<C, M, R> {
        fluent_builders::AssociateWirelessGatewayWithThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelMulticastGroupSession`](crate::client::fluent_builders::CancelMulticastGroupSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CancelMulticastGroupSession::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CancelMulticastGroupSession::set_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`CancelMulticastGroupSessionOutput`](crate::output::CancelMulticastGroupSessionOutput)

    /// - On failure, responds with [`SdkError<CancelMulticastGroupSessionError>`](crate::error::CancelMulticastGroupSessionError)
    pub fn cancel_multicast_group_session(
        &self,
    ) -> fluent_builders::CancelMulticastGroupSession<C, M, R> {
        fluent_builders::CancelMulticastGroupSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDestination`](crate::client::fluent_builders::CreateDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDestination::set_name): <p>The name of the new resource.</p>
    ///   - [`expression_type(ExpressionType)`](crate::client::fluent_builders::CreateDestination::expression_type) / [`set_expression_type(Option<ExpressionType>)`](crate::client::fluent_builders::CreateDestination::set_expression_type): <p>The type of value in <code>Expression</code>.</p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::CreateDestination::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::CreateDestination::set_expression): <p>The rule name or topic rule to send messages to.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDestination::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDestination::set_description): <p>The description of the new resource.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDestination::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDestination::set_role_arn): <p>The ARN of the IAM Role that authorizes the destination.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDestination::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDestination::set_tags): <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDestination::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDestination::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`CreateDestinationOutput`](crate::output::CreateDestinationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDestinationOutput::arn): <p>The Amazon Resource Name of the new resource.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateDestinationOutput::name): <p>The name of the new resource.</p>
    /// - On failure, responds with [`SdkError<CreateDestinationError>`](crate::error::CreateDestinationError)
    pub fn create_destination(&self) -> fluent_builders::CreateDestination<C, M, R> {
        fluent_builders::CreateDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeviceProfile`](crate::client::fluent_builders::CreateDeviceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDeviceProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDeviceProfile::set_name): <p>The name of the new resource.</p>
    ///   - [`lo_ra_wan(LoRaWanDeviceProfile)`](crate::client::fluent_builders::CreateDeviceProfile::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanDeviceProfile>)`](crate::client::fluent_builders::CreateDeviceProfile::set_lo_ra_wan): <p>The device profile information to use to create the device profile.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDeviceProfile::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDeviceProfile::set_tags): <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDeviceProfile::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDeviceProfile::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`CreateDeviceProfileOutput`](crate::output::CreateDeviceProfileOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDeviceProfileOutput::arn): <p>The Amazon Resource Name of the new resource.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateDeviceProfileOutput::id): <p>The ID of the new device profile.</p>
    /// - On failure, responds with [`SdkError<CreateDeviceProfileError>`](crate::error::CreateDeviceProfileError)
    pub fn create_device_profile(&self) -> fluent_builders::CreateDeviceProfile<C, M, R> {
        fluent_builders::CreateDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFuotaTask`](crate::client::fluent_builders::CreateFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFuotaTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFuotaTask::set_name): <p>The name of a FUOTA task.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFuotaTask::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFuotaTask::set_description): <p>The description of the new resource.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateFuotaTask::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateFuotaTask::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
    ///   - [`lo_ra_wan(LoRaWanFuotaTask)`](crate::client::fluent_builders::CreateFuotaTask::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanFuotaTask>)`](crate::client::fluent_builders::CreateFuotaTask::set_lo_ra_wan): <p>The LoRaWAN information used with a FUOTA task.</p>
    ///   - [`firmware_update_image(impl Into<String>)`](crate::client::fluent_builders::CreateFuotaTask::firmware_update_image) / [`set_firmware_update_image(Option<String>)`](crate::client::fluent_builders::CreateFuotaTask::set_firmware_update_image): <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    ///   - [`firmware_update_role(impl Into<String>)`](crate::client::fluent_builders::CreateFuotaTask::firmware_update_role) / [`set_firmware_update_role(Option<String>)`](crate::client::fluent_builders::CreateFuotaTask::set_firmware_update_role): <p>The firmware update role that is to be used with a FUOTA task.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFuotaTask::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFuotaTask::set_tags): <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`CreateFuotaTaskOutput`](crate::output::CreateFuotaTaskOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateFuotaTaskOutput::arn): <p>The arn of a FUOTA task.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateFuotaTaskOutput::id): <p>The ID of a FUOTA task.</p>
    /// - On failure, responds with [`SdkError<CreateFuotaTaskError>`](crate::error::CreateFuotaTaskError)
    pub fn create_fuota_task(&self) -> fluent_builders::CreateFuotaTask<C, M, R> {
        fluent_builders::CreateFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMulticastGroup`](crate::client::fluent_builders::CreateMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateMulticastGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateMulticastGroup::set_name): <p>The name of the multicast group.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateMulticastGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateMulticastGroup::set_description): <p>The description of the multicast group.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMulticastGroup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMulticastGroup::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    ///   - [`lo_ra_wan(LoRaWanMulticast)`](crate::client::fluent_builders::CreateMulticastGroup::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanMulticast>)`](crate::client::fluent_builders::CreateMulticastGroup::set_lo_ra_wan): <p>The LoRaWAN information that is to be used with the multicast group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMulticastGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMulticastGroup::set_tags): <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`CreateMulticastGroupOutput`](crate::output::CreateMulticastGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateMulticastGroupOutput::arn): <p>The arn of the multicast group.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateMulticastGroupOutput::id): <p>The ID of the multicast group.</p>
    /// - On failure, responds with [`SdkError<CreateMulticastGroupError>`](crate::error::CreateMulticastGroupError)
    pub fn create_multicast_group(&self) -> fluent_builders::CreateMulticastGroup<C, M, R> {
        fluent_builders::CreateMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateServiceProfile`](crate::client::fluent_builders::CreateServiceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateServiceProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateServiceProfile::set_name): <p>The name of the new resource.</p>
    ///   - [`lo_ra_wan(LoRaWanServiceProfile)`](crate::client::fluent_builders::CreateServiceProfile::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanServiceProfile>)`](crate::client::fluent_builders::CreateServiceProfile::set_lo_ra_wan): <p>The service profile information to use to create the service profile.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateServiceProfile::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateServiceProfile::set_tags): <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateServiceProfile::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateServiceProfile::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`CreateServiceProfileOutput`](crate::output::CreateServiceProfileOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateServiceProfileOutput::arn): <p>The Amazon Resource Name of the new resource.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateServiceProfileOutput::id): <p>The ID of the new service profile.</p>
    /// - On failure, responds with [`SdkError<CreateServiceProfileError>`](crate::error::CreateServiceProfileError)
    pub fn create_service_profile(&self) -> fluent_builders::CreateServiceProfile<C, M, R> {
        fluent_builders::CreateServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWirelessDevice`](crate::client::fluent_builders::CreateWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(WirelessDeviceType)`](crate::client::fluent_builders::CreateWirelessDevice::r#type) / [`set_type(Option<WirelessDeviceType>)`](crate::client::fluent_builders::CreateWirelessDevice::set_type): <p>The wireless device type.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessDevice::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWirelessDevice::set_name): <p>The name of the new resource.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessDevice::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWirelessDevice::set_description): <p>The description of the new resource.</p>
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessDevice::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::CreateWirelessDevice::set_destination_name): <p>The name of the destination to assign to the new wireless device.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessDevice::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateWirelessDevice::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    ///   - [`lo_ra_wan(LoRaWanDevice)`](crate::client::fluent_builders::CreateWirelessDevice::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanDevice>)`](crate::client::fluent_builders::CreateWirelessDevice::set_lo_ra_wan): <p>The device configuration information to use to create the wireless device.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWirelessDevice::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWirelessDevice::set_tags): <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`CreateWirelessDeviceOutput`](crate::output::CreateWirelessDeviceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateWirelessDeviceOutput::arn): <p>The Amazon Resource Name of the new resource.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateWirelessDeviceOutput::id): <p>The ID of the new wireless device.</p>
    /// - On failure, responds with [`SdkError<CreateWirelessDeviceError>`](crate::error::CreateWirelessDeviceError)
    pub fn create_wireless_device(&self) -> fluent_builders::CreateWirelessDevice<C, M, R> {
        fluent_builders::CreateWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWirelessGateway`](crate::client::fluent_builders::CreateWirelessGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGateway::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWirelessGateway::set_name): <p>The name of the new resource.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGateway::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWirelessGateway::set_description): <p>The description of the new resource.</p>
    ///   - [`lo_ra_wan(LoRaWanGateway)`](crate::client::fluent_builders::CreateWirelessGateway::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanGateway>)`](crate::client::fluent_builders::CreateWirelessGateway::set_lo_ra_wan): <p>The gateway configuration information to use to create the wireless gateway.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWirelessGateway::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWirelessGateway::set_tags): <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGateway::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateWirelessGateway::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`CreateWirelessGatewayOutput`](crate::output::CreateWirelessGatewayOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateWirelessGatewayOutput::arn): <p>The Amazon Resource Name of the new resource.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateWirelessGatewayOutput::id): <p>The ID of the new wireless gateway.</p>
    /// - On failure, responds with [`SdkError<CreateWirelessGatewayError>`](crate::error::CreateWirelessGatewayError)
    pub fn create_wireless_gateway(&self) -> fluent_builders::CreateWirelessGateway<C, M, R> {
        fluent_builders::CreateWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWirelessGatewayTask`](crate::client::fluent_builders::CreateWirelessGatewayTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTask::set_id): <p>The ID of the resource to update.</p>
    ///   - [`wireless_gateway_task_definition_id(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTask::wireless_gateway_task_definition_id) / [`set_wireless_gateway_task_definition_id(Option<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTask::set_wireless_gateway_task_definition_id): <p>The ID of the WirelessGatewayTaskDefinition.</p>
    /// - On success, responds with [`CreateWirelessGatewayTaskOutput`](crate::output::CreateWirelessGatewayTaskOutput) with field(s):
    ///   - [`wireless_gateway_task_definition_id(Option<String>)`](crate::output::CreateWirelessGatewayTaskOutput::wireless_gateway_task_definition_id): <p>The ID of the WirelessGatewayTaskDefinition.</p>
    ///   - [`status(Option<WirelessGatewayTaskStatus>)`](crate::output::CreateWirelessGatewayTaskOutput::status): <p>The status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateWirelessGatewayTaskError>`](crate::error::CreateWirelessGatewayTaskError)
    pub fn create_wireless_gateway_task(
        &self,
    ) -> fluent_builders::CreateWirelessGatewayTask<C, M, R> {
        fluent_builders::CreateWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWirelessGatewayTaskDefinition`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_create_tasks(bool)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::auto_create_tasks) / [`set_auto_create_tasks(bool)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::set_auto_create_tasks): <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::set_name): <p>The name of the new resource.</p>
    ///   - [`update(UpdateWirelessGatewayTaskCreate)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::update) / [`set_update(Option<UpdateWirelessGatewayTaskCreate>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::set_update): <p>Information about the gateways to update.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::set_client_request_token): <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition::set_tags): <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`CreateWirelessGatewayTaskDefinitionOutput`](crate::output::CreateWirelessGatewayTaskDefinitionOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateWirelessGatewayTaskDefinitionOutput::id): <p>The ID of the new wireless gateway task definition.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateWirelessGatewayTaskDefinitionOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    /// - On failure, responds with [`SdkError<CreateWirelessGatewayTaskDefinitionError>`](crate::error::CreateWirelessGatewayTaskDefinitionError)
    pub fn create_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::CreateWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::CreateWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDestination`](crate::client::fluent_builders::DeleteDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDestination::set_name): <p>The name of the resource to delete.</p>
    /// - On success, responds with [`DeleteDestinationOutput`](crate::output::DeleteDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteDestinationError>`](crate::error::DeleteDestinationError)
    pub fn delete_destination(&self) -> fluent_builders::DeleteDestination<C, M, R> {
        fluent_builders::DeleteDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDeviceProfile`](crate::client::fluent_builders::DeleteDeviceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteDeviceProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteDeviceProfile::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteDeviceProfileOutput`](crate::output::DeleteDeviceProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteDeviceProfileError>`](crate::error::DeleteDeviceProfileError)
    pub fn delete_device_profile(&self) -> fluent_builders::DeleteDeviceProfile<C, M, R> {
        fluent_builders::DeleteDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFuotaTask`](crate::client::fluent_builders::DeleteFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    /// - On success, responds with [`DeleteFuotaTaskOutput`](crate::output::DeleteFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<DeleteFuotaTaskError>`](crate::error::DeleteFuotaTaskError)
    pub fn delete_fuota_task(&self) -> fluent_builders::DeleteFuotaTask<C, M, R> {
        fluent_builders::DeleteFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMulticastGroup`](crate::client::fluent_builders::DeleteMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`DeleteMulticastGroupOutput`](crate::output::DeleteMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteMulticastGroupError>`](crate::error::DeleteMulticastGroupError)
    pub fn delete_multicast_group(&self) -> fluent_builders::DeleteMulticastGroup<C, M, R> {
        fluent_builders::DeleteMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQueuedMessages`](crate::client::fluent_builders::DeleteQueuedMessages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteQueuedMessages::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteQueuedMessages::set_id): <p>Id of a given wireless device which messages will be deleted </p>
    ///   - [`message_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQueuedMessages::message_id) / [`set_message_id(Option<String>)`](crate::client::fluent_builders::DeleteQueuedMessages::set_message_id): <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
    ///   - [`wireless_device_type(WirelessDeviceType)`](crate::client::fluent_builders::DeleteQueuedMessages::wireless_device_type) / [`set_wireless_device_type(Option<WirelessDeviceType>)`](crate::client::fluent_builders::DeleteQueuedMessages::set_wireless_device_type): <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
    /// - On success, responds with [`DeleteQueuedMessagesOutput`](crate::output::DeleteQueuedMessagesOutput)

    /// - On failure, responds with [`SdkError<DeleteQueuedMessagesError>`](crate::error::DeleteQueuedMessagesError)
    pub fn delete_queued_messages(&self) -> fluent_builders::DeleteQueuedMessages<C, M, R> {
        fluent_builders::DeleteQueuedMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteServiceProfile`](crate::client::fluent_builders::DeleteServiceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteServiceProfile::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteServiceProfileOutput`](crate::output::DeleteServiceProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteServiceProfileError>`](crate::error::DeleteServiceProfileError)
    pub fn delete_service_profile(&self) -> fluent_builders::DeleteServiceProfile<C, M, R> {
        fluent_builders::DeleteServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWirelessDevice`](crate::client::fluent_builders::DeleteWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteWirelessDevice::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteWirelessDevice::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteWirelessDeviceOutput`](crate::output::DeleteWirelessDeviceOutput)

    /// - On failure, responds with [`SdkError<DeleteWirelessDeviceError>`](crate::error::DeleteWirelessDeviceError)
    pub fn delete_wireless_device(&self) -> fluent_builders::DeleteWirelessDevice<C, M, R> {
        fluent_builders::DeleteWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWirelessGateway`](crate::client::fluent_builders::DeleteWirelessGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteWirelessGateway::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteWirelessGateway::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteWirelessGatewayOutput`](crate::output::DeleteWirelessGatewayOutput)

    /// - On failure, responds with [`SdkError<DeleteWirelessGatewayError>`](crate::error::DeleteWirelessGatewayError)
    pub fn delete_wireless_gateway(&self) -> fluent_builders::DeleteWirelessGateway<C, M, R> {
        fluent_builders::DeleteWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWirelessGatewayTask`](crate::client::fluent_builders::DeleteWirelessGatewayTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteWirelessGatewayTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteWirelessGatewayTask::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteWirelessGatewayTaskOutput`](crate::output::DeleteWirelessGatewayTaskOutput)

    /// - On failure, responds with [`SdkError<DeleteWirelessGatewayTaskError>`](crate::error::DeleteWirelessGatewayTaskError)
    pub fn delete_wireless_gateway_task(
        &self,
    ) -> fluent_builders::DeleteWirelessGatewayTask<C, M, R> {
        fluent_builders::DeleteWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWirelessGatewayTaskDefinition`](crate::client::fluent_builders::DeleteWirelessGatewayTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteWirelessGatewayTaskDefinition::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteWirelessGatewayTaskDefinition::set_id): <p>The ID of the resource to delete.</p>
    /// - On success, responds with [`DeleteWirelessGatewayTaskDefinitionOutput`](crate::output::DeleteWirelessGatewayTaskDefinitionOutput)

    /// - On failure, responds with [`SdkError<DeleteWirelessGatewayTaskDefinitionError>`](crate::error::DeleteWirelessGatewayTaskDefinitionError)
    pub fn delete_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::DeleteWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::DeleteWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAwsAccountFromPartnerAccount`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`partner_account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount::partner_account_id) / [`set_partner_account_id(Option<String>)`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount::set_partner_account_id): <p>The partner account ID to disassociate from the AWS account.</p>
    ///   - [`partner_type(PartnerType)`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount::partner_type) / [`set_partner_type(Option<PartnerType>)`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount::set_partner_type): <p>The partner type.</p>
    /// - On success, responds with [`DisassociateAwsAccountFromPartnerAccountOutput`](crate::output::DisassociateAwsAccountFromPartnerAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateAwsAccountFromPartnerAccountError>`](crate::error::DisassociateAwsAccountFromPartnerAccountError)
    pub fn disassociate_aws_account_from_partner_account(
        &self,
    ) -> fluent_builders::DisassociateAwsAccountFromPartnerAccount<C, M, R> {
        fluent_builders::DisassociateAwsAccountFromPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMulticastGroupFromFuotaTask`](crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`multicast_group_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask::multicast_group_id) / [`set_multicast_group_id(Option<String>)`](crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask::set_multicast_group_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`DisassociateMulticastGroupFromFuotaTaskOutput`](crate::output::DisassociateMulticastGroupFromFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<DisassociateMulticastGroupFromFuotaTaskError>`](crate::error::DisassociateMulticastGroupFromFuotaTaskError)
    pub fn disassociate_multicast_group_from_fuota_task(
        &self,
    ) -> fluent_builders::DisassociateMulticastGroupFromFuotaTask<C, M, R> {
        fluent_builders::DisassociateMulticastGroupFromFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWirelessDeviceFromFuotaTask`](crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`wireless_device_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask::wireless_device_id) / [`set_wireless_device_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask::set_wireless_device_id): <p>The ID of the wireless device.</p>
    /// - On success, responds with [`DisassociateWirelessDeviceFromFuotaTaskOutput`](crate::output::DisassociateWirelessDeviceFromFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<DisassociateWirelessDeviceFromFuotaTaskError>`](crate::error::DisassociateWirelessDeviceFromFuotaTaskError)
    pub fn disassociate_wireless_device_from_fuota_task(
        &self,
    ) -> fluent_builders::DisassociateWirelessDeviceFromFuotaTask<C, M, R> {
        fluent_builders::DisassociateWirelessDeviceFromFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWirelessDeviceFromMulticastGroup`](crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`wireless_device_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup::wireless_device_id) / [`set_wireless_device_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup::set_wireless_device_id): <p>The ID of the wireless device.</p>
    /// - On success, responds with [`DisassociateWirelessDeviceFromMulticastGroupOutput`](crate::output::DisassociateWirelessDeviceFromMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<DisassociateWirelessDeviceFromMulticastGroupError>`](crate::error::DisassociateWirelessDeviceFromMulticastGroupError)
    pub fn disassociate_wireless_device_from_multicast_group(
        &self,
    ) -> fluent_builders::DisassociateWirelessDeviceFromMulticastGroup<C, M, R> {
        fluent_builders::DisassociateWirelessDeviceFromMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWirelessDeviceFromThing`](crate::client::fluent_builders::DisassociateWirelessDeviceFromThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromThing::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessDeviceFromThing::set_id): <p>The ID of the resource to update.</p>
    /// - On success, responds with [`DisassociateWirelessDeviceFromThingOutput`](crate::output::DisassociateWirelessDeviceFromThingOutput)

    /// - On failure, responds with [`SdkError<DisassociateWirelessDeviceFromThingError>`](crate::error::DisassociateWirelessDeviceFromThingError)
    pub fn disassociate_wireless_device_from_thing(
        &self,
    ) -> fluent_builders::DisassociateWirelessDeviceFromThing<C, M, R> {
        fluent_builders::DisassociateWirelessDeviceFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWirelessGatewayFromCertificate`](crate::client::fluent_builders::DisassociateWirelessGatewayFromCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessGatewayFromCertificate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessGatewayFromCertificate::set_id): <p>The ID of the resource to update.</p>
    /// - On success, responds with [`DisassociateWirelessGatewayFromCertificateOutput`](crate::output::DisassociateWirelessGatewayFromCertificateOutput)

    /// - On failure, responds with [`SdkError<DisassociateWirelessGatewayFromCertificateError>`](crate::error::DisassociateWirelessGatewayFromCertificateError)
    pub fn disassociate_wireless_gateway_from_certificate(
        &self,
    ) -> fluent_builders::DisassociateWirelessGatewayFromCertificate<C, M, R> {
        fluent_builders::DisassociateWirelessGatewayFromCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWirelessGatewayFromThing`](crate::client::fluent_builders::DisassociateWirelessGatewayFromThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateWirelessGatewayFromThing::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateWirelessGatewayFromThing::set_id): <p>The ID of the resource to update.</p>
    /// - On success, responds with [`DisassociateWirelessGatewayFromThingOutput`](crate::output::DisassociateWirelessGatewayFromThingOutput)

    /// - On failure, responds with [`SdkError<DisassociateWirelessGatewayFromThingError>`](crate::error::DisassociateWirelessGatewayFromThingError)
    pub fn disassociate_wireless_gateway_from_thing(
        &self,
    ) -> fluent_builders::DisassociateWirelessGatewayFromThing<C, M, R> {
        fluent_builders::DisassociateWirelessGatewayFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDestination`](crate::client::fluent_builders::GetDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetDestination::set_name): <p>The name of the resource to get.</p>
    /// - On success, responds with [`GetDestinationOutput`](crate::output::GetDestinationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetDestinationOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDestinationOutput::name): <p>The name of the resource.</p>
    ///   - [`expression(Option<String>)`](crate::output::GetDestinationOutput::expression): <p>The rule name or topic rule to send messages to.</p>
    ///   - [`expression_type(Option<ExpressionType>)`](crate::output::GetDestinationOutput::expression_type): <p>The type of value in <code>Expression</code>.</p>
    ///   - [`description(Option<String>)`](crate::output::GetDestinationOutput::description): <p>The description of the resource.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::GetDestinationOutput::role_arn): <p>The ARN of the IAM Role that authorizes the destination.</p>
    /// - On failure, responds with [`SdkError<GetDestinationError>`](crate::error::GetDestinationError)
    pub fn get_destination(&self) -> fluent_builders::GetDestination<C, M, R> {
        fluent_builders::GetDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeviceProfile`](crate::client::fluent_builders::GetDeviceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetDeviceProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetDeviceProfile::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetDeviceProfileOutput`](crate::output::GetDeviceProfileOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetDeviceProfileOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDeviceProfileOutput::name): <p>The name of the resource.</p>
    ///   - [`id(Option<String>)`](crate::output::GetDeviceProfileOutput::id): <p>The ID of the device profile.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanDeviceProfile>)`](crate::output::GetDeviceProfileOutput::lo_ra_wan): <p>Information about the device profile.</p>
    /// - On failure, responds with [`SdkError<GetDeviceProfileError>`](crate::error::GetDeviceProfileError)
    pub fn get_device_profile(&self) -> fluent_builders::GetDeviceProfile<C, M, R> {
        fluent_builders::GetDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFuotaTask`](crate::client::fluent_builders::GetFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    /// - On success, responds with [`GetFuotaTaskOutput`](crate::output::GetFuotaTaskOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetFuotaTaskOutput::arn): <p>The arn of a FUOTA task.</p>
    ///   - [`id(Option<String>)`](crate::output::GetFuotaTaskOutput::id): <p>The ID of a FUOTA task.</p>
    ///   - [`status(Option<FuotaTaskStatus>)`](crate::output::GetFuotaTaskOutput::status): <p>The status of a FUOTA task.</p>
    ///   - [`name(Option<String>)`](crate::output::GetFuotaTaskOutput::name): <p>The name of a FUOTA task.</p>
    ///   - [`description(Option<String>)`](crate::output::GetFuotaTaskOutput::description): <p>The description of the new resource.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanFuotaTaskGetInfo>)`](crate::output::GetFuotaTaskOutput::lo_ra_wan): <p>The LoRaWAN information returned from getting a FUOTA task.</p>
    ///   - [`firmware_update_image(Option<String>)`](crate::output::GetFuotaTaskOutput::firmware_update_image): <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    ///   - [`firmware_update_role(Option<String>)`](crate::output::GetFuotaTaskOutput::firmware_update_role): <p>The firmware update role that is to be used with a FUOTA task.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetFuotaTaskOutput::created_at): <p>Created at timestamp for the resource.</p>
    /// - On failure, responds with [`SdkError<GetFuotaTaskError>`](crate::error::GetFuotaTaskError)
    pub fn get_fuota_task(&self) -> fluent_builders::GetFuotaTask<C, M, R> {
        fluent_builders::GetFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLogLevelsByResourceTypes`](crate::client::fluent_builders::GetLogLevelsByResourceTypes) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetLogLevelsByResourceTypes::send) it.

    /// - On success, responds with [`GetLogLevelsByResourceTypesOutput`](crate::output::GetLogLevelsByResourceTypesOutput) with field(s):
    ///   - [`default_log_level(Option<LogLevel>)`](crate::output::GetLogLevelsByResourceTypesOutput::default_log_level): <p>The log level for a log message.</p>
    ///   - [`wireless_gateway_log_options(Option<Vec<WirelessGatewayLogOption>>)`](crate::output::GetLogLevelsByResourceTypesOutput::wireless_gateway_log_options): <p>The list of wireless gateway log options.</p>
    ///   - [`wireless_device_log_options(Option<Vec<WirelessDeviceLogOption>>)`](crate::output::GetLogLevelsByResourceTypesOutput::wireless_device_log_options): <p>The list of wireless device log options.</p>
    /// - On failure, responds with [`SdkError<GetLogLevelsByResourceTypesError>`](crate::error::GetLogLevelsByResourceTypesError)
    pub fn get_log_levels_by_resource_types(
        &self,
    ) -> fluent_builders::GetLogLevelsByResourceTypes<C, M, R> {
        fluent_builders::GetLogLevelsByResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMulticastGroup`](crate::client::fluent_builders::GetMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`GetMulticastGroupOutput`](crate::output::GetMulticastGroupOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetMulticastGroupOutput::arn): <p>The arn of the multicast group.</p>
    ///   - [`id(Option<String>)`](crate::output::GetMulticastGroupOutput::id): <p>The ID of the multicast group.</p>
    ///   - [`name(Option<String>)`](crate::output::GetMulticastGroupOutput::name): <p>The name of the multicast group.</p>
    ///   - [`description(Option<String>)`](crate::output::GetMulticastGroupOutput::description): <p>The description of the new resource.</p>
    ///   - [`status(Option<String>)`](crate::output::GetMulticastGroupOutput::status): <p>The status of the multicast group.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanMulticastGet>)`](crate::output::GetMulticastGroupOutput::lo_ra_wan): <p>The LoRaWAN information that is to be returned from getting multicast group information.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetMulticastGroupOutput::created_at): <p>Created at timestamp for the resource.</p>
    /// - On failure, responds with [`SdkError<GetMulticastGroupError>`](crate::error::GetMulticastGroupError)
    pub fn get_multicast_group(&self) -> fluent_builders::GetMulticastGroup<C, M, R> {
        fluent_builders::GetMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMulticastGroupSession`](crate::client::fluent_builders::GetMulticastGroupSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetMulticastGroupSession::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetMulticastGroupSession::set_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`GetMulticastGroupSessionOutput`](crate::output::GetMulticastGroupSessionOutput) with field(s):
    ///   - [`lo_ra_wan(Option<LoRaWanMulticastSession>)`](crate::output::GetMulticastGroupSessionOutput::lo_ra_wan): <p>The LoRaWAN information used with the multicast session.</p>
    /// - On failure, responds with [`SdkError<GetMulticastGroupSessionError>`](crate::error::GetMulticastGroupSessionError)
    pub fn get_multicast_group_session(
        &self,
    ) -> fluent_builders::GetMulticastGroupSession<C, M, R> {
        fluent_builders::GetMulticastGroupSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetworkAnalyzerConfiguration`](crate::client::fluent_builders::GetNetworkAnalyzerConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_name(impl Into<String>)`](crate::client::fluent_builders::GetNetworkAnalyzerConfiguration::configuration_name) / [`set_configuration_name(Option<String>)`](crate::client::fluent_builders::GetNetworkAnalyzerConfiguration::set_configuration_name): <p>NetworkAnalyzer configuration name.</p>
    /// - On success, responds with [`GetNetworkAnalyzerConfigurationOutput`](crate::output::GetNetworkAnalyzerConfigurationOutput) with field(s):
    ///   - [`trace_content(Option<TraceContent>)`](crate::output::GetNetworkAnalyzerConfigurationOutput::trace_content): <p>Trace Content for resources.</p>
    ///   - [`wireless_devices(Option<Vec<String>>)`](crate::output::GetNetworkAnalyzerConfigurationOutput::wireless_devices): <p>List of WirelessDevices in the NetworkAnalyzerConfiguration.</p>
    ///   - [`wireless_gateways(Option<Vec<String>>)`](crate::output::GetNetworkAnalyzerConfigurationOutput::wireless_gateways): <p>List of WirelessGateways in the NetworkAnalyzerConfiguration.</p>
    /// - On failure, responds with [`SdkError<GetNetworkAnalyzerConfigurationError>`](crate::error::GetNetworkAnalyzerConfigurationError)
    pub fn get_network_analyzer_configuration(
        &self,
    ) -> fluent_builders::GetNetworkAnalyzerConfiguration<C, M, R> {
        fluent_builders::GetNetworkAnalyzerConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPartnerAccount`](crate::client::fluent_builders::GetPartnerAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`partner_account_id(impl Into<String>)`](crate::client::fluent_builders::GetPartnerAccount::partner_account_id) / [`set_partner_account_id(Option<String>)`](crate::client::fluent_builders::GetPartnerAccount::set_partner_account_id): <p>The partner account ID to disassociate from the AWS account.</p>
    ///   - [`partner_type(PartnerType)`](crate::client::fluent_builders::GetPartnerAccount::partner_type) / [`set_partner_type(Option<PartnerType>)`](crate::client::fluent_builders::GetPartnerAccount::set_partner_type): <p>The partner type.</p>
    /// - On success, responds with [`GetPartnerAccountOutput`](crate::output::GetPartnerAccountOutput) with field(s):
    ///   - [`sidewalk(Option<SidewalkAccountInfoWithFingerprint>)`](crate::output::GetPartnerAccountOutput::sidewalk): <p>The Sidewalk account credentials.</p>
    ///   - [`account_linked(bool)`](crate::output::GetPartnerAccountOutput::account_linked): <p>Whether the partner account is linked to the AWS account.</p>
    /// - On failure, responds with [`SdkError<GetPartnerAccountError>`](crate::error::GetPartnerAccountError)
    pub fn get_partner_account(&self) -> fluent_builders::GetPartnerAccount<C, M, R> {
        fluent_builders::GetPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceEventConfiguration`](crate::client::fluent_builders::GetResourceEventConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetResourceEventConfiguration::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetResourceEventConfiguration::set_identifier): <p>Resource identifier to opt in for event messaging.</p>
    ///   - [`identifier_type(IdentifierType)`](crate::client::fluent_builders::GetResourceEventConfiguration::identifier_type) / [`set_identifier_type(Option<IdentifierType>)`](crate::client::fluent_builders::GetResourceEventConfiguration::set_identifier_type): <p>Identifier type of the particular resource identifier for event configuration.</p>
    ///   - [`partner_type(EventNotificationPartnerType)`](crate::client::fluent_builders::GetResourceEventConfiguration::partner_type) / [`set_partner_type(Option<EventNotificationPartnerType>)`](crate::client::fluent_builders::GetResourceEventConfiguration::set_partner_type): <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
    /// - On success, responds with [`GetResourceEventConfigurationOutput`](crate::output::GetResourceEventConfigurationOutput) with field(s):
    ///   - [`device_registration_state(Option<DeviceRegistrationStateEventConfiguration>)`](crate::output::GetResourceEventConfigurationOutput::device_registration_state): <p>Event configuration for the device registration state event</p>
    ///   - [`proximity(Option<ProximityEventConfiguration>)`](crate::output::GetResourceEventConfigurationOutput::proximity): <p>Event configuration for the Proximity event</p>
    /// - On failure, responds with [`SdkError<GetResourceEventConfigurationError>`](crate::error::GetResourceEventConfigurationError)
    pub fn get_resource_event_configuration(
        &self,
    ) -> fluent_builders::GetResourceEventConfiguration<C, M, R> {
        fluent_builders::GetResourceEventConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceLogLevel`](crate::client::fluent_builders::GetResourceLogLevel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::GetResourceLogLevel::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::GetResourceLogLevel::set_resource_identifier): <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::GetResourceLogLevel::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::GetResourceLogLevel::set_resource_type): <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    /// - On success, responds with [`GetResourceLogLevelOutput`](crate::output::GetResourceLogLevelOutput) with field(s):
    ///   - [`log_level(Option<LogLevel>)`](crate::output::GetResourceLogLevelOutput::log_level): <p>The log level for a log message.</p>
    /// - On failure, responds with [`SdkError<GetResourceLogLevelError>`](crate::error::GetResourceLogLevelError)
    pub fn get_resource_log_level(&self) -> fluent_builders::GetResourceLogLevel<C, M, R> {
        fluent_builders::GetResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceEndpoint`](crate::client::fluent_builders::GetServiceEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_type(WirelessGatewayServiceType)`](crate::client::fluent_builders::GetServiceEndpoint::service_type) / [`set_service_type(Option<WirelessGatewayServiceType>)`](crate::client::fluent_builders::GetServiceEndpoint::set_service_type): <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
    /// - On success, responds with [`GetServiceEndpointOutput`](crate::output::GetServiceEndpointOutput) with field(s):
    ///   - [`service_type(Option<WirelessGatewayServiceType>)`](crate::output::GetServiceEndpointOutput::service_type): <p>The endpoint's service type.</p>
    ///   - [`service_endpoint(Option<String>)`](crate::output::GetServiceEndpointOutput::service_endpoint): <p>The service endpoint value.</p>
    ///   - [`server_trust(Option<String>)`](crate::output::GetServiceEndpointOutput::server_trust): <p>The Root CA of the server trust certificate.</p>
    /// - On failure, responds with [`SdkError<GetServiceEndpointError>`](crate::error::GetServiceEndpointError)
    pub fn get_service_endpoint(&self) -> fluent_builders::GetServiceEndpoint<C, M, R> {
        fluent_builders::GetServiceEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceProfile`](crate::client::fluent_builders::GetServiceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetServiceProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetServiceProfile::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetServiceProfileOutput`](crate::output::GetServiceProfileOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetServiceProfileOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    ///   - [`name(Option<String>)`](crate::output::GetServiceProfileOutput::name): <p>The name of the resource.</p>
    ///   - [`id(Option<String>)`](crate::output::GetServiceProfileOutput::id): <p>The ID of the service profile.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanGetServiceProfileInfo>)`](crate::output::GetServiceProfileOutput::lo_ra_wan): <p>Information about the service profile.</p>
    /// - On failure, responds with [`SdkError<GetServiceProfileError>`](crate::error::GetServiceProfileError)
    pub fn get_service_profile(&self) -> fluent_builders::GetServiceProfile<C, M, R> {
        fluent_builders::GetServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessDevice`](crate::client::fluent_builders::GetWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetWirelessDevice::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetWirelessDevice::set_identifier): <p>The identifier of the wireless device to get.</p>
    ///   - [`identifier_type(WirelessDeviceIdType)`](crate::client::fluent_builders::GetWirelessDevice::identifier_type) / [`set_identifier_type(Option<WirelessDeviceIdType>)`](crate::client::fluent_builders::GetWirelessDevice::set_identifier_type): <p>The type of identifier used in <code>identifier</code>.</p>
    /// - On success, responds with [`GetWirelessDeviceOutput`](crate::output::GetWirelessDeviceOutput) with field(s):
    ///   - [`r#type(Option<WirelessDeviceType>)`](crate::output::GetWirelessDeviceOutput::type): <p>The wireless device type.</p>
    ///   - [`name(Option<String>)`](crate::output::GetWirelessDeviceOutput::name): <p>The name of the resource.</p>
    ///   - [`description(Option<String>)`](crate::output::GetWirelessDeviceOutput::description): <p>The description of the resource.</p>
    ///   - [`destination_name(Option<String>)`](crate::output::GetWirelessDeviceOutput::destination_name): <p>The name of the destination to which the device is assigned.</p>
    ///   - [`id(Option<String>)`](crate::output::GetWirelessDeviceOutput::id): <p>The ID of the wireless device.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetWirelessDeviceOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    ///   - [`thing_name(Option<String>)`](crate::output::GetWirelessDeviceOutput::thing_name): <p>The name of the thing associated with the wireless device. The value is empty if a thing isn't associated with the device.</p>
    ///   - [`thing_arn(Option<String>)`](crate::output::GetWirelessDeviceOutput::thing_arn): <p>The ARN of the thing associated with the wireless device.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanDevice>)`](crate::output::GetWirelessDeviceOutput::lo_ra_wan): <p>Information about the wireless device.</p>
    ///   - [`sidewalk(Option<SidewalkDevice>)`](crate::output::GetWirelessDeviceOutput::sidewalk): <p>Sidewalk device object.</p>
    /// - On failure, responds with [`SdkError<GetWirelessDeviceError>`](crate::error::GetWirelessDeviceError)
    pub fn get_wireless_device(&self) -> fluent_builders::GetWirelessDevice<C, M, R> {
        fluent_builders::GetWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessDeviceStatistics`](crate::client::fluent_builders::GetWirelessDeviceStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`wireless_device_id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessDeviceStatistics::wireless_device_id) / [`set_wireless_device_id(Option<String>)`](crate::client::fluent_builders::GetWirelessDeviceStatistics::set_wireless_device_id): <p>The ID of the wireless device for which to get the data.</p>
    /// - On success, responds with [`GetWirelessDeviceStatisticsOutput`](crate::output::GetWirelessDeviceStatisticsOutput) with field(s):
    ///   - [`wireless_device_id(Option<String>)`](crate::output::GetWirelessDeviceStatisticsOutput::wireless_device_id): <p>The ID of the wireless device.</p>
    ///   - [`last_uplink_received_at(Option<String>)`](crate::output::GetWirelessDeviceStatisticsOutput::last_uplink_received_at): <p>The date and time when the most recent uplink was received.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanDeviceMetadata>)`](crate::output::GetWirelessDeviceStatisticsOutput::lo_ra_wan): <p>Information about the wireless device's operations.</p>
    ///   - [`sidewalk(Option<SidewalkDeviceMetadata>)`](crate::output::GetWirelessDeviceStatisticsOutput::sidewalk): <p>MetaData for Sidewalk device.</p>
    /// - On failure, responds with [`SdkError<GetWirelessDeviceStatisticsError>`](crate::error::GetWirelessDeviceStatisticsError)
    pub fn get_wireless_device_statistics(
        &self,
    ) -> fluent_builders::GetWirelessDeviceStatistics<C, M, R> {
        fluent_builders::GetWirelessDeviceStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGateway`](crate::client::fluent_builders::GetWirelessGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGateway::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::GetWirelessGateway::set_identifier): <p>The identifier of the wireless gateway to get.</p>
    ///   - [`identifier_type(WirelessGatewayIdType)`](crate::client::fluent_builders::GetWirelessGateway::identifier_type) / [`set_identifier_type(Option<WirelessGatewayIdType>)`](crate::client::fluent_builders::GetWirelessGateway::set_identifier_type): <p>The type of identifier used in <code>identifier</code>.</p>
    /// - On success, responds with [`GetWirelessGatewayOutput`](crate::output::GetWirelessGatewayOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetWirelessGatewayOutput::name): <p>The name of the resource.</p>
    ///   - [`id(Option<String>)`](crate::output::GetWirelessGatewayOutput::id): <p>The ID of the wireless gateway.</p>
    ///   - [`description(Option<String>)`](crate::output::GetWirelessGatewayOutput::description): <p>The description of the resource.</p>
    ///   - [`lo_ra_wan(Option<LoRaWanGateway>)`](crate::output::GetWirelessGatewayOutput::lo_ra_wan): <p>Information about the wireless gateway.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetWirelessGatewayOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    ///   - [`thing_name(Option<String>)`](crate::output::GetWirelessGatewayOutput::thing_name): <p>The name of the thing associated with the wireless gateway. The value is empty if a thing isn't associated with the gateway.</p>
    ///   - [`thing_arn(Option<String>)`](crate::output::GetWirelessGatewayOutput::thing_arn): <p>The ARN of the thing associated with the wireless gateway.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayError>`](crate::error::GetWirelessGatewayError)
    pub fn get_wireless_gateway(&self) -> fluent_builders::GetWirelessGateway<C, M, R> {
        fluent_builders::GetWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGatewayCertificate`](crate::client::fluent_builders::GetWirelessGatewayCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGatewayCertificate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetWirelessGatewayCertificate::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetWirelessGatewayCertificateOutput`](crate::output::GetWirelessGatewayCertificateOutput) with field(s):
    ///   - [`iot_certificate_id(Option<String>)`](crate::output::GetWirelessGatewayCertificateOutput::iot_certificate_id): <p>The ID of the certificate associated with the wireless gateway.</p>
    ///   - [`lo_ra_wan_network_server_certificate_id(Option<String>)`](crate::output::GetWirelessGatewayCertificateOutput::lo_ra_wan_network_server_certificate_id): <p>The ID of the certificate that is associated with the wireless gateway and used for the LoRaWANNetworkServer endpoint.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayCertificateError>`](crate::error::GetWirelessGatewayCertificateError)
    pub fn get_wireless_gateway_certificate(
        &self,
    ) -> fluent_builders::GetWirelessGatewayCertificate<C, M, R> {
        fluent_builders::GetWirelessGatewayCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGatewayFirmwareInformation`](crate::client::fluent_builders::GetWirelessGatewayFirmwareInformation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGatewayFirmwareInformation::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetWirelessGatewayFirmwareInformation::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetWirelessGatewayFirmwareInformationOutput`](crate::output::GetWirelessGatewayFirmwareInformationOutput) with field(s):
    ///   - [`lo_ra_wan(Option<LoRaWanGatewayCurrentVersion>)`](crate::output::GetWirelessGatewayFirmwareInformationOutput::lo_ra_wan): <p>Information about the wireless gateway's firmware.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayFirmwareInformationError>`](crate::error::GetWirelessGatewayFirmwareInformationError)
    pub fn get_wireless_gateway_firmware_information(
        &self,
    ) -> fluent_builders::GetWirelessGatewayFirmwareInformation<C, M, R> {
        fluent_builders::GetWirelessGatewayFirmwareInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGatewayStatistics`](crate::client::fluent_builders::GetWirelessGatewayStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`wireless_gateway_id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGatewayStatistics::wireless_gateway_id) / [`set_wireless_gateway_id(Option<String>)`](crate::client::fluent_builders::GetWirelessGatewayStatistics::set_wireless_gateway_id): <p>The ID of the wireless gateway for which to get the data.</p>
    /// - On success, responds with [`GetWirelessGatewayStatisticsOutput`](crate::output::GetWirelessGatewayStatisticsOutput) with field(s):
    ///   - [`wireless_gateway_id(Option<String>)`](crate::output::GetWirelessGatewayStatisticsOutput::wireless_gateway_id): <p>The ID of the wireless gateway.</p>
    ///   - [`last_uplink_received_at(Option<String>)`](crate::output::GetWirelessGatewayStatisticsOutput::last_uplink_received_at): <p>The date and time when the most recent uplink was received.</p>
    ///   - [`connection_status(Option<ConnectionStatus>)`](crate::output::GetWirelessGatewayStatisticsOutput::connection_status): <p>The connection status of the wireless gateway.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayStatisticsError>`](crate::error::GetWirelessGatewayStatisticsError)
    pub fn get_wireless_gateway_statistics(
        &self,
    ) -> fluent_builders::GetWirelessGatewayStatistics<C, M, R> {
        fluent_builders::GetWirelessGatewayStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGatewayTask`](crate::client::fluent_builders::GetWirelessGatewayTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGatewayTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetWirelessGatewayTask::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetWirelessGatewayTaskOutput`](crate::output::GetWirelessGatewayTaskOutput) with field(s):
    ///   - [`wireless_gateway_id(Option<String>)`](crate::output::GetWirelessGatewayTaskOutput::wireless_gateway_id): <p>The ID of the wireless gateway.</p>
    ///   - [`wireless_gateway_task_definition_id(Option<String>)`](crate::output::GetWirelessGatewayTaskOutput::wireless_gateway_task_definition_id): <p>The ID of the WirelessGatewayTask.</p>
    ///   - [`last_uplink_received_at(Option<String>)`](crate::output::GetWirelessGatewayTaskOutput::last_uplink_received_at): <p>The date and time when the most recent uplink was received.</p>
    ///   - [`task_created_at(Option<String>)`](crate::output::GetWirelessGatewayTaskOutput::task_created_at): <p>The date and time when the task was created.</p>
    ///   - [`status(Option<WirelessGatewayTaskStatus>)`](crate::output::GetWirelessGatewayTaskOutput::status): <p>The status of the request.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayTaskError>`](crate::error::GetWirelessGatewayTaskError)
    pub fn get_wireless_gateway_task(&self) -> fluent_builders::GetWirelessGatewayTask<C, M, R> {
        fluent_builders::GetWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWirelessGatewayTaskDefinition`](crate::client::fluent_builders::GetWirelessGatewayTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetWirelessGatewayTaskDefinition::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetWirelessGatewayTaskDefinition::set_id): <p>The ID of the resource to get.</p>
    /// - On success, responds with [`GetWirelessGatewayTaskDefinitionOutput`](crate::output::GetWirelessGatewayTaskDefinitionOutput) with field(s):
    ///   - [`auto_create_tasks(bool)`](crate::output::GetWirelessGatewayTaskDefinitionOutput::auto_create_tasks): <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::GetWirelessGatewayTaskDefinitionOutput::name): <p>The name of the resource.</p>
    ///   - [`update(Option<UpdateWirelessGatewayTaskCreate>)`](crate::output::GetWirelessGatewayTaskDefinitionOutput::update): <p>Information about the gateways to update.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetWirelessGatewayTaskDefinitionOutput::arn): <p>The Amazon Resource Name of the resource.</p>
    /// - On failure, responds with [`SdkError<GetWirelessGatewayTaskDefinitionError>`](crate::error::GetWirelessGatewayTaskDefinitionError)
    pub fn get_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::GetWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::GetWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDestinations`](crate::client::fluent_builders::ListDestinations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDestinations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDestinations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDestinations::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDestinations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDestinations::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    /// - On success, responds with [`ListDestinationsOutput`](crate::output::ListDestinationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListDestinationsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`destination_list(Option<Vec<Destinations>>)`](crate::output::ListDestinationsOutput::destination_list): <p>The list of destinations.</p>
    /// - On failure, responds with [`SdkError<ListDestinationsError>`](crate::error::ListDestinationsError)
    pub fn list_destinations(&self) -> fluent_builders::ListDestinations<C, M, R> {
        fluent_builders::ListDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeviceProfiles`](crate::client::fluent_builders::ListDeviceProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeviceProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeviceProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeviceProfiles::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDeviceProfiles::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDeviceProfiles::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListDeviceProfilesOutput`](crate::output::ListDeviceProfilesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListDeviceProfilesOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`device_profile_list(Option<Vec<DeviceProfile>>)`](crate::output::ListDeviceProfilesOutput::device_profile_list): <p>The list of device profiles.</p>
    /// - On failure, responds with [`SdkError<ListDeviceProfilesError>`](crate::error::ListDeviceProfilesError)
    pub fn list_device_profiles(&self) -> fluent_builders::ListDeviceProfiles<C, M, R> {
        fluent_builders::ListDeviceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFuotaTasks`](crate::client::fluent_builders::ListFuotaTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFuotaTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFuotaTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFuotaTasks::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFuotaTasks::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFuotaTasks::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListFuotaTasksOutput`](crate::output::ListFuotaTasksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFuotaTasksOutput::next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`fuota_task_list(Option<Vec<FuotaTask>>)`](crate::output::ListFuotaTasksOutput::fuota_task_list): <p>Lists the FUOTA tasks registered to your AWS account.</p>
    /// - On failure, responds with [`SdkError<ListFuotaTasksError>`](crate::error::ListFuotaTasksError)
    pub fn list_fuota_tasks(&self) -> fluent_builders::ListFuotaTasks<C, M, R> {
        fluent_builders::ListFuotaTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMulticastGroups`](crate::client::fluent_builders::ListMulticastGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMulticastGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMulticastGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMulticastGroups::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMulticastGroups::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMulticastGroups::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListMulticastGroupsOutput`](crate::output::ListMulticastGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListMulticastGroupsOutput::next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`multicast_group_list(Option<Vec<MulticastGroup>>)`](crate::output::ListMulticastGroupsOutput::multicast_group_list): <p>List of multicast groups.</p>
    /// - On failure, responds with [`SdkError<ListMulticastGroupsError>`](crate::error::ListMulticastGroupsError)
    pub fn list_multicast_groups(&self) -> fluent_builders::ListMulticastGroups<C, M, R> {
        fluent_builders::ListMulticastGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMulticastGroupsByFuotaTask`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMulticastGroupsByFuotaTask::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListMulticastGroupsByFuotaTaskOutput`](crate::output::ListMulticastGroupsByFuotaTaskOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListMulticastGroupsByFuotaTaskOutput::next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`multicast_group_list(Option<Vec<MulticastGroupByFuotaTask>>)`](crate::output::ListMulticastGroupsByFuotaTaskOutput::multicast_group_list): <p>List of multicast groups associated with a FUOTA task.</p>
    /// - On failure, responds with [`SdkError<ListMulticastGroupsByFuotaTaskError>`](crate::error::ListMulticastGroupsByFuotaTaskError)
    pub fn list_multicast_groups_by_fuota_task(
        &self,
    ) -> fluent_builders::ListMulticastGroupsByFuotaTask<C, M, R> {
        fluent_builders::ListMulticastGroupsByFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPartnerAccounts`](crate::client::fluent_builders::ListPartnerAccounts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPartnerAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPartnerAccounts::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPartnerAccounts::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPartnerAccounts::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListPartnerAccountsOutput`](crate::output::ListPartnerAccountsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPartnerAccountsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`sidewalk(Option<Vec<SidewalkAccountInfoWithFingerprint>>)`](crate::output::ListPartnerAccountsOutput::sidewalk): <p>The Sidewalk account credentials.</p>
    /// - On failure, responds with [`SdkError<ListPartnerAccountsError>`](crate::error::ListPartnerAccountsError)
    pub fn list_partner_accounts(&self) -> fluent_builders::ListPartnerAccounts<C, M, R> {
        fluent_builders::ListPartnerAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQueuedMessages`](crate::client::fluent_builders::ListQueuedMessages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQueuedMessages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ListQueuedMessages::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ListQueuedMessages::set_id): <p>Id of a given wireless device which the downlink packets are targeted </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQueuedMessages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQueuedMessages::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQueuedMessages::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListQueuedMessages::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`wireless_device_type(WirelessDeviceType)`](crate::client::fluent_builders::ListQueuedMessages::wireless_device_type) / [`set_wireless_device_type(Option<WirelessDeviceType>)`](crate::client::fluent_builders::ListQueuedMessages::set_wireless_device_type): <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
    /// - On success, responds with [`ListQueuedMessagesOutput`](crate::output::ListQueuedMessagesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListQueuedMessagesOutput::next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`downlink_queue_messages_list(Option<Vec<DownlinkQueueMessage>>)`](crate::output::ListQueuedMessagesOutput::downlink_queue_messages_list): <p>The messages in downlink queue.</p>
    /// - On failure, responds with [`SdkError<ListQueuedMessagesError>`](crate::error::ListQueuedMessagesError)
    pub fn list_queued_messages(&self) -> fluent_builders::ListQueuedMessages<C, M, R> {
        fluent_builders::ListQueuedMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServiceProfiles`](crate::client::fluent_builders::ListServiceProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServiceProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServiceProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServiceProfiles::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServiceProfiles::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListServiceProfiles::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListServiceProfilesOutput`](crate::output::ListServiceProfilesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListServiceProfilesOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`service_profile_list(Option<Vec<ServiceProfile>>)`](crate::output::ListServiceProfilesOutput::service_profile_list): <p>The list of service profiles.</p>
    /// - On failure, responds with [`SdkError<ListServiceProfilesError>`](crate::error::ListServiceProfilesError)
    pub fn list_service_profiles(&self) -> fluent_builders::ListServiceProfiles<C, M, R> {
        fluent_builders::ListServiceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource for which you want to list tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWirelessDevices`](crate::client::fluent_builders::ListWirelessDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWirelessDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWirelessDevices::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWirelessDevices::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_destination_name): <p>A filter to list only the wireless devices that use this destination.</p>
    ///   - [`device_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::device_profile_id) / [`set_device_profile_id(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_device_profile_id): <p>A filter to list only the wireless devices that use this device profile.</p>
    ///   - [`service_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::service_profile_id) / [`set_service_profile_id(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_service_profile_id): <p>A filter to list only the wireless devices that use this service profile.</p>
    ///   - [`wireless_device_type(WirelessDeviceType)`](crate::client::fluent_builders::ListWirelessDevices::wireless_device_type) / [`set_wireless_device_type(Option<WirelessDeviceType>)`](crate::client::fluent_builders::ListWirelessDevices::set_wireless_device_type): <p>A filter to list only the wireless devices that use this wireless device type.</p>
    ///   - [`fuota_task_id(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::fuota_task_id) / [`set_fuota_task_id(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_fuota_task_id): <p>The ID of a FUOTA task.</p>
    ///   - [`multicast_group_id(impl Into<String>)`](crate::client::fluent_builders::ListWirelessDevices::multicast_group_id) / [`set_multicast_group_id(Option<String>)`](crate::client::fluent_builders::ListWirelessDevices::set_multicast_group_id): <p>The ID of the multicast group.</p>
    /// - On success, responds with [`ListWirelessDevicesOutput`](crate::output::ListWirelessDevicesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWirelessDevicesOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`wireless_device_list(Option<Vec<WirelessDeviceStatistics>>)`](crate::output::ListWirelessDevicesOutput::wireless_device_list): <p>The ID of the wireless device.</p>
    /// - On failure, responds with [`SdkError<ListWirelessDevicesError>`](crate::error::ListWirelessDevicesError)
    pub fn list_wireless_devices(&self) -> fluent_builders::ListWirelessDevices<C, M, R> {
        fluent_builders::ListWirelessDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWirelessGateways`](crate::client::fluent_builders::ListWirelessGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWirelessGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWirelessGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWirelessGateways::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWirelessGateways::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWirelessGateways::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListWirelessGatewaysOutput`](crate::output::ListWirelessGatewaysOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWirelessGatewaysOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`wireless_gateway_list(Option<Vec<WirelessGatewayStatistics>>)`](crate::output::ListWirelessGatewaysOutput::wireless_gateway_list): <p>The ID of the wireless gateway.</p>
    /// - On failure, responds with [`SdkError<ListWirelessGatewaysError>`](crate::error::ListWirelessGatewaysError)
    pub fn list_wireless_gateways(&self) -> fluent_builders::ListWirelessGateways<C, M, R> {
        fluent_builders::ListWirelessGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWirelessGatewayTaskDefinitions`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`task_definition_type(WirelessGatewayTaskDefinitionType)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::task_definition_type) / [`set_task_definition_type(Option<WirelessGatewayTaskDefinitionType>)`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions::set_task_definition_type): <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
    /// - On success, responds with [`ListWirelessGatewayTaskDefinitionsOutput`](crate::output::ListWirelessGatewayTaskDefinitionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWirelessGatewayTaskDefinitionsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    ///   - [`task_definitions(Option<Vec<UpdateWirelessGatewayTaskEntry>>)`](crate::output::ListWirelessGatewayTaskDefinitionsOutput::task_definitions): <p>The list of task definitions.</p>
    /// - On failure, responds with [`SdkError<ListWirelessGatewayTaskDefinitionsError>`](crate::error::ListWirelessGatewayTaskDefinitionsError)
    pub fn list_wireless_gateway_task_definitions(
        &self,
    ) -> fluent_builders::ListWirelessGatewayTaskDefinitions<C, M, R> {
        fluent_builders::ListWirelessGatewayTaskDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourceLogLevel`](crate::client::fluent_builders::PutResourceLogLevel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::PutResourceLogLevel::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::PutResourceLogLevel::set_resource_identifier): <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::PutResourceLogLevel::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::PutResourceLogLevel::set_resource_type): <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    ///   - [`log_level(LogLevel)`](crate::client::fluent_builders::PutResourceLogLevel::log_level) / [`set_log_level(Option<LogLevel>)`](crate::client::fluent_builders::PutResourceLogLevel::set_log_level): <p>The log level for a log message.</p>
    /// - On success, responds with [`PutResourceLogLevelOutput`](crate::output::PutResourceLogLevelOutput)

    /// - On failure, responds with [`SdkError<PutResourceLogLevelError>`](crate::error::PutResourceLogLevelError)
    pub fn put_resource_log_level(&self) -> fluent_builders::PutResourceLogLevel<C, M, R> {
        fluent_builders::PutResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetAllResourceLogLevels`](crate::client::fluent_builders::ResetAllResourceLogLevels) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ResetAllResourceLogLevels::send) it.

    /// - On success, responds with [`ResetAllResourceLogLevelsOutput`](crate::output::ResetAllResourceLogLevelsOutput)

    /// - On failure, responds with [`SdkError<ResetAllResourceLogLevelsError>`](crate::error::ResetAllResourceLogLevelsError)
    pub fn reset_all_resource_log_levels(
        &self,
    ) -> fluent_builders::ResetAllResourceLogLevels<C, M, R> {
        fluent_builders::ResetAllResourceLogLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetResourceLogLevel`](crate::client::fluent_builders::ResetResourceLogLevel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::ResetResourceLogLevel::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::ResetResourceLogLevel::set_resource_identifier): <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ResetResourceLogLevel::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ResetResourceLogLevel::set_resource_type): <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
    /// - On success, responds with [`ResetResourceLogLevelOutput`](crate::output::ResetResourceLogLevelOutput)

    /// - On failure, responds with [`SdkError<ResetResourceLogLevelError>`](crate::error::ResetResourceLogLevelError)
    pub fn reset_resource_log_level(&self) -> fluent_builders::ResetResourceLogLevel<C, M, R> {
        fluent_builders::ResetResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendDataToMulticastGroup`](crate::client::fluent_builders::SendDataToMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::SendDataToMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::SendDataToMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`payload_data(impl Into<String>)`](crate::client::fluent_builders::SendDataToMulticastGroup::payload_data) / [`set_payload_data(Option<String>)`](crate::client::fluent_builders::SendDataToMulticastGroup::set_payload_data): <p>The binary to be sent to the end device, encoded in base64.</p>
    ///   - [`wireless_metadata(MulticastWirelessMetadata)`](crate::client::fluent_builders::SendDataToMulticastGroup::wireless_metadata) / [`set_wireless_metadata(Option<MulticastWirelessMetadata>)`](crate::client::fluent_builders::SendDataToMulticastGroup::set_wireless_metadata): <p>Wireless metadata that is to be sent to multicast group.</p>
    /// - On success, responds with [`SendDataToMulticastGroupOutput`](crate::output::SendDataToMulticastGroupOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendDataToMulticastGroupOutput::message_id): <p>ID of a multicast group message.</p>
    /// - On failure, responds with [`SdkError<SendDataToMulticastGroupError>`](crate::error::SendDataToMulticastGroupError)
    pub fn send_data_to_multicast_group(
        &self,
    ) -> fluent_builders::SendDataToMulticastGroup<C, M, R> {
        fluent_builders::SendDataToMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendDataToWirelessDevice`](crate::client::fluent_builders::SendDataToWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::SendDataToWirelessDevice::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::SendDataToWirelessDevice::set_id): <p>The ID of the wireless device to receive the data.</p>
    ///   - [`transmit_mode(i32)`](crate::client::fluent_builders::SendDataToWirelessDevice::transmit_mode) / [`set_transmit_mode(Option<i32>)`](crate::client::fluent_builders::SendDataToWirelessDevice::set_transmit_mode): <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
    ///   - [`payload_data(impl Into<String>)`](crate::client::fluent_builders::SendDataToWirelessDevice::payload_data) / [`set_payload_data(Option<String>)`](crate::client::fluent_builders::SendDataToWirelessDevice::set_payload_data): <p>The binary to be sent to the end device, encoded in base64.</p>
    ///   - [`wireless_metadata(WirelessMetadata)`](crate::client::fluent_builders::SendDataToWirelessDevice::wireless_metadata) / [`set_wireless_metadata(Option<WirelessMetadata>)`](crate::client::fluent_builders::SendDataToWirelessDevice::set_wireless_metadata): <p>Metadata about the message request.</p>
    /// - On success, responds with [`SendDataToWirelessDeviceOutput`](crate::output::SendDataToWirelessDeviceOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendDataToWirelessDeviceOutput::message_id): <p>The ID of the message sent to the wireless device.</p>
    /// - On failure, responds with [`SdkError<SendDataToWirelessDeviceError>`](crate::error::SendDataToWirelessDeviceError)
    pub fn send_data_to_wireless_device(
        &self,
    ) -> fluent_builders::SendDataToWirelessDevice<C, M, R> {
        fluent_builders::SendDataToWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartBulkAssociateWirelessDeviceWithMulticastGroup`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::set_query_string): <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::set_tags): <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`StartBulkAssociateWirelessDeviceWithMulticastGroupOutput`](crate::output::StartBulkAssociateWirelessDeviceWithMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<StartBulkAssociateWirelessDeviceWithMulticastGroupError>`](crate::error::StartBulkAssociateWirelessDeviceWithMulticastGroupError)
    pub fn start_bulk_associate_wireless_device_with_multicast_group(
        &self,
    ) -> fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup<C, M, R> {
        fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`StartBulkDisassociateWirelessDeviceFromMulticastGroup`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::set_query_string): <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::set_tags): <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`StartBulkDisassociateWirelessDeviceFromMulticastGroupOutput`](crate::output::StartBulkDisassociateWirelessDeviceFromMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<StartBulkDisassociateWirelessDeviceFromMulticastGroupError>`](crate::error::StartBulkDisassociateWirelessDeviceFromMulticastGroupError)
    pub fn start_bulk_disassociate_wireless_device_from_multicast_group(
        &self,
    ) -> fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup<C, M, R> {
        fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`StartFuotaTask`](crate::client::fluent_builders::StartFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StartFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StartFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`lo_ra_wan(LoRaWanStartFuotaTask)`](crate::client::fluent_builders::StartFuotaTask::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanStartFuotaTask>)`](crate::client::fluent_builders::StartFuotaTask::set_lo_ra_wan): <p>The LoRaWAN information used to start a FUOTA task.</p>
    /// - On success, responds with [`StartFuotaTaskOutput`](crate::output::StartFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<StartFuotaTaskError>`](crate::error::StartFuotaTaskError)
    pub fn start_fuota_task(&self) -> fluent_builders::StartFuotaTask<C, M, R> {
        fluent_builders::StartFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMulticastGroupSession`](crate::client::fluent_builders::StartMulticastGroupSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StartMulticastGroupSession::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StartMulticastGroupSession::set_id): <p>The ID of the multicast group.</p>
    ///   - [`lo_ra_wan(LoRaWanMulticastSession)`](crate::client::fluent_builders::StartMulticastGroupSession::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanMulticastSession>)`](crate::client::fluent_builders::StartMulticastGroupSession::set_lo_ra_wan): <p>The LoRaWAN information used with the multicast session.</p>
    /// - On success, responds with [`StartMulticastGroupSessionOutput`](crate::output::StartMulticastGroupSessionOutput)

    /// - On failure, responds with [`SdkError<StartMulticastGroupSessionError>`](crate::error::StartMulticastGroupSessionError)
    pub fn start_multicast_group_session(
        &self,
    ) -> fluent_builders::StartMulticastGroupSession<C, M, R> {
        fluent_builders::StartMulticastGroupSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource to add tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestWirelessDevice`](crate::client::fluent_builders::TestWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::TestWirelessDevice::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::TestWirelessDevice::set_id): <p>The ID of the wireless device to test.</p>
    /// - On success, responds with [`TestWirelessDeviceOutput`](crate::output::TestWirelessDeviceOutput) with field(s):
    ///   - [`result(Option<String>)`](crate::output::TestWirelessDeviceOutput::result): <p>The result returned by the test.</p>
    /// - On failure, responds with [`SdkError<TestWirelessDeviceError>`](crate::error::TestWirelessDeviceError)
    pub fn test_wireless_device(&self) -> fluent_builders::TestWirelessDevice<C, M, R> {
        fluent_builders::TestWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of the keys of the tags to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDestination`](crate::client::fluent_builders::UpdateDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_name): <p>The new name of the resource.</p>
    ///   - [`expression_type(ExpressionType)`](crate::client::fluent_builders::UpdateDestination::expression_type) / [`set_expression_type(Option<ExpressionType>)`](crate::client::fluent_builders::UpdateDestination::set_expression_type): <p>The type of value in <code>Expression</code>.</p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_expression): <p>The new rule name or topic rule to send messages to.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_description): <p>A new description of the resource.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDestination::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateDestination::set_role_arn): <p>The ARN of the IAM Role that authorizes the destination.</p>
    /// - On success, responds with [`UpdateDestinationOutput`](crate::output::UpdateDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateDestinationError>`](crate::error::UpdateDestinationError)
    pub fn update_destination(&self) -> fluent_builders::UpdateDestination<C, M, R> {
        fluent_builders::UpdateDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFuotaTask`](crate::client::fluent_builders::UpdateFuotaTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateFuotaTask::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateFuotaTask::set_id): <p>The ID of a FUOTA task.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFuotaTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFuotaTask::set_name): <p>The name of a FUOTA task.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFuotaTask::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFuotaTask::set_description): <p>The description of the new resource.</p>
    ///   - [`lo_ra_wan(LoRaWanFuotaTask)`](crate::client::fluent_builders::UpdateFuotaTask::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanFuotaTask>)`](crate::client::fluent_builders::UpdateFuotaTask::set_lo_ra_wan): <p>The LoRaWAN information used with a FUOTA task.</p>
    ///   - [`firmware_update_image(impl Into<String>)`](crate::client::fluent_builders::UpdateFuotaTask::firmware_update_image) / [`set_firmware_update_image(Option<String>)`](crate::client::fluent_builders::UpdateFuotaTask::set_firmware_update_image): <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
    ///   - [`firmware_update_role(impl Into<String>)`](crate::client::fluent_builders::UpdateFuotaTask::firmware_update_role) / [`set_firmware_update_role(Option<String>)`](crate::client::fluent_builders::UpdateFuotaTask::set_firmware_update_role): <p>The firmware update role that is to be used with a FUOTA task.</p>
    /// - On success, responds with [`UpdateFuotaTaskOutput`](crate::output::UpdateFuotaTaskOutput)

    /// - On failure, responds with [`SdkError<UpdateFuotaTaskError>`](crate::error::UpdateFuotaTaskError)
    pub fn update_fuota_task(&self) -> fluent_builders::UpdateFuotaTask<C, M, R> {
        fluent_builders::UpdateFuotaTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLogLevelsByResourceTypes`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`default_log_level(LogLevel)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::default_log_level) / [`set_default_log_level(Option<LogLevel>)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::set_default_log_level): <p>The log level for a log message.</p>
    ///   - [`wireless_device_log_options(Vec<WirelessDeviceLogOption>)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::wireless_device_log_options) / [`set_wireless_device_log_options(Option<Vec<WirelessDeviceLogOption>>)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::set_wireless_device_log_options): <p>The list of wireless device log options.</p>
    ///   - [`wireless_gateway_log_options(Vec<WirelessGatewayLogOption>)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::wireless_gateway_log_options) / [`set_wireless_gateway_log_options(Option<Vec<WirelessGatewayLogOption>>)`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes::set_wireless_gateway_log_options): <p>The list of wireless gateway log options.</p>
    /// - On success, responds with [`UpdateLogLevelsByResourceTypesOutput`](crate::output::UpdateLogLevelsByResourceTypesOutput)

    /// - On failure, responds with [`SdkError<UpdateLogLevelsByResourceTypesError>`](crate::error::UpdateLogLevelsByResourceTypesError)
    pub fn update_log_levels_by_resource_types(
        &self,
    ) -> fluent_builders::UpdateLogLevelsByResourceTypes<C, M, R> {
        fluent_builders::UpdateLogLevelsByResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMulticastGroup`](crate::client::fluent_builders::UpdateMulticastGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::set_id): <p>The ID of the multicast group.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::set_name): <p>The name of the multicast group.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMulticastGroup::set_description): <p>The description of the new resource.</p>
    ///   - [`lo_ra_wan(LoRaWanMulticast)`](crate::client::fluent_builders::UpdateMulticastGroup::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanMulticast>)`](crate::client::fluent_builders::UpdateMulticastGroup::set_lo_ra_wan): <p>The LoRaWAN information that is to be used with the multicast group.</p>
    /// - On success, responds with [`UpdateMulticastGroupOutput`](crate::output::UpdateMulticastGroupOutput)

    /// - On failure, responds with [`SdkError<UpdateMulticastGroupError>`](crate::error::UpdateMulticastGroupError)
    pub fn update_multicast_group(&self) -> fluent_builders::UpdateMulticastGroup<C, M, R> {
        fluent_builders::UpdateMulticastGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNetworkAnalyzerConfiguration`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::configuration_name) / [`set_configuration_name(Option<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_configuration_name): <p>NetworkAnalyzer configuration name.</p>
    ///   - [`trace_content(TraceContent)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::trace_content) / [`set_trace_content(Option<TraceContent>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_trace_content): <p>Trace Content for resources.</p>
    ///   - [`wireless_devices_to_add(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::wireless_devices_to_add) / [`set_wireless_devices_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_wireless_devices_to_add): <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
    ///   - [`wireless_devices_to_remove(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::wireless_devices_to_remove) / [`set_wireless_devices_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_wireless_devices_to_remove): <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
    ///   - [`wireless_gateways_to_add(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::wireless_gateways_to_add) / [`set_wireless_gateways_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_wireless_gateways_to_add): <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
    ///   - [`wireless_gateways_to_remove(Vec<String>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::wireless_gateways_to_remove) / [`set_wireless_gateways_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration::set_wireless_gateways_to_remove): <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
    /// - On success, responds with [`UpdateNetworkAnalyzerConfigurationOutput`](crate::output::UpdateNetworkAnalyzerConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateNetworkAnalyzerConfigurationError>`](crate::error::UpdateNetworkAnalyzerConfigurationError)
    pub fn update_network_analyzer_configuration(
        &self,
    ) -> fluent_builders::UpdateNetworkAnalyzerConfiguration<C, M, R> {
        fluent_builders::UpdateNetworkAnalyzerConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePartnerAccount`](crate::client::fluent_builders::UpdatePartnerAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sidewalk(SidewalkUpdateAccount)`](crate::client::fluent_builders::UpdatePartnerAccount::sidewalk) / [`set_sidewalk(Option<SidewalkUpdateAccount>)`](crate::client::fluent_builders::UpdatePartnerAccount::set_sidewalk): <p>The Sidewalk account credentials.</p>
    ///   - [`partner_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerAccount::partner_account_id) / [`set_partner_account_id(Option<String>)`](crate::client::fluent_builders::UpdatePartnerAccount::set_partner_account_id): <p>The ID of the partner account to update.</p>
    ///   - [`partner_type(PartnerType)`](crate::client::fluent_builders::UpdatePartnerAccount::partner_type) / [`set_partner_type(Option<PartnerType>)`](crate::client::fluent_builders::UpdatePartnerAccount::set_partner_type): <p>The partner type.</p>
    /// - On success, responds with [`UpdatePartnerAccountOutput`](crate::output::UpdatePartnerAccountOutput)

    /// - On failure, responds with [`SdkError<UpdatePartnerAccountError>`](crate::error::UpdatePartnerAccountError)
    pub fn update_partner_account(&self) -> fluent_builders::UpdatePartnerAccount<C, M, R> {
        fluent_builders::UpdatePartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceEventConfiguration`](crate::client::fluent_builders::UpdateResourceEventConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifier(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::identifier) / [`set_identifier(Option<String>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::set_identifier): <p>Resource identifier to opt in for event messaging.</p>
    ///   - [`identifier_type(IdentifierType)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::identifier_type) / [`set_identifier_type(Option<IdentifierType>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::set_identifier_type): <p>Identifier type of the particular resource identifier for event configuration.</p>
    ///   - [`partner_type(EventNotificationPartnerType)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::partner_type) / [`set_partner_type(Option<EventNotificationPartnerType>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::set_partner_type): <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
    ///   - [`device_registration_state(DeviceRegistrationStateEventConfiguration)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::device_registration_state) / [`set_device_registration_state(Option<DeviceRegistrationStateEventConfiguration>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::set_device_registration_state): <p>Event configuration for the device registration state event</p>
    ///   - [`proximity(ProximityEventConfiguration)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::proximity) / [`set_proximity(Option<ProximityEventConfiguration>)`](crate::client::fluent_builders::UpdateResourceEventConfiguration::set_proximity): <p>Event configuration for the Proximity event</p>
    /// - On success, responds with [`UpdateResourceEventConfigurationOutput`](crate::output::UpdateResourceEventConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateResourceEventConfigurationError>`](crate::error::UpdateResourceEventConfigurationError)
    pub fn update_resource_event_configuration(
        &self,
    ) -> fluent_builders::UpdateResourceEventConfiguration<C, M, R> {
        fluent_builders::UpdateResourceEventConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWirelessDevice`](crate::client::fluent_builders::UpdateWirelessDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::set_id): <p>The ID of the resource to update.</p>
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::set_destination_name): <p>The name of the new destination for the device.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::set_name): <p>The new name of the resource.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWirelessDevice::set_description): <p>A new description of the resource.</p>
    ///   - [`lo_ra_wan(LoRaWanUpdateDevice)`](crate::client::fluent_builders::UpdateWirelessDevice::lo_ra_wan) / [`set_lo_ra_wan(Option<LoRaWanUpdateDevice>)`](crate::client::fluent_builders::UpdateWirelessDevice::set_lo_ra_wan): <p>The updated wireless device's configuration.</p>
    /// - On success, responds with [`UpdateWirelessDeviceOutput`](crate::output::UpdateWirelessDeviceOutput)

    /// - On failure, responds with [`SdkError<UpdateWirelessDeviceError>`](crate::error::UpdateWirelessDeviceError)
    pub fn update_wireless_device(&self) -> fluent_builders::UpdateWirelessDevice<C, M, R> {
        fluent_builders::UpdateWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWirelessGateway`](crate::client::fluent_builders::UpdateWirelessGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::set_id): <p>The ID of the resource to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::set_name): <p>The new name of the resource.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::set_description): <p>A new description of the resource.</p>
    ///   - [`join_eui_filters(Vec<Vec<String>>)`](crate::client::fluent_builders::UpdateWirelessGateway::join_eui_filters) / [`set_join_eui_filters(Option<Vec<Vec<String>>>)`](crate::client::fluent_builders::UpdateWirelessGateway::set_join_eui_filters): <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
    ///   - [`net_id_filters(Vec<String>)`](crate::client::fluent_builders::UpdateWirelessGateway::net_id_filters) / [`set_net_id_filters(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWirelessGateway::set_net_id_filters): <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
    /// - On success, responds with [`UpdateWirelessGatewayOutput`](crate::output::UpdateWirelessGatewayOutput)

    /// - On failure, responds with [`SdkError<UpdateWirelessGatewayError>`](crate::error::UpdateWirelessGatewayError)
    pub fn update_wireless_gateway(&self) -> fluent_builders::UpdateWirelessGateway<C, M, R> {
        fluent_builders::UpdateWirelessGateway::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAwsAccountWithPartnerAccount`.
    ///
    /// <p>Associates a partner account with your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAwsAccountWithPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_aws_account_with_partner_account_input::Builder,
    }
    impl<C, M, R> AssociateAwsAccountWithPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAwsAccountWithPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAwsAccountWithPartnerAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateAwsAccountWithPartnerAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAwsAccountWithPartnerAccountInputOperationOutputAlias,
                crate::output::AssociateAwsAccountWithPartnerAccountOutput,
                crate::error::AssociateAwsAccountWithPartnerAccountError,
                crate::input::AssociateAwsAccountWithPartnerAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkAccountInfo) -> Self {
            self.inner = self.inner.sidewalk(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkAccountInfo>,
        ) -> Self {
            self.inner = self.inner.set_sidewalk(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateMulticastGroupWithFuotaTask`.
    ///
    /// <p>Associate a multicast group with a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMulticastGroupWithFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_multicast_group_with_fuota_task_input::Builder,
    }
    impl<C, M, R> AssociateMulticastGroupWithFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateMulticastGroupWithFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMulticastGroupWithFuotaTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateMulticastGroupWithFuotaTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateMulticastGroupWithFuotaTaskInputOperationOutputAlias,
                crate::output::AssociateMulticastGroupWithFuotaTaskOutput,
                crate::error::AssociateMulticastGroupWithFuotaTaskError,
                crate::input::AssociateMulticastGroupWithFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multicast_group_id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_multicast_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessDeviceWithFuotaTask`.
    ///
    /// <p>Associate a wireless device with a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWirelessDeviceWithFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_device_with_fuota_task_input::Builder,
    }
    impl<C, M, R> AssociateWirelessDeviceWithFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessDeviceWithFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessDeviceWithFuotaTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWirelessDeviceWithFuotaTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessDeviceWithFuotaTaskInputOperationOutputAlias,
                crate::output::AssociateWirelessDeviceWithFuotaTaskOutput,
                crate::error::AssociateWirelessDeviceWithFuotaTaskError,
                crate::input::AssociateWirelessDeviceWithFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessDeviceWithMulticastGroup`.
    ///
    /// <p>Associates a wireless device with a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWirelessDeviceWithMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_device_with_multicast_group_input::Builder,
    }
    impl<C, M, R> AssociateWirelessDeviceWithMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessDeviceWithMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessDeviceWithMulticastGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWirelessDeviceWithMulticastGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessDeviceWithMulticastGroupInputOperationOutputAlias,
                crate::output::AssociateWirelessDeviceWithMulticastGroupOutput,
                crate::error::AssociateWirelessDeviceWithMulticastGroupError,
                crate::input::AssociateWirelessDeviceWithMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessDeviceWithThing`.
    ///
    /// <p>Associates a wireless device with a thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWirelessDeviceWithThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_device_with_thing_input::Builder,
    }
    impl<C, M, R> AssociateWirelessDeviceWithThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessDeviceWithThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessDeviceWithThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWirelessDeviceWithThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessDeviceWithThingInputOperationOutputAlias,
                crate::output::AssociateWirelessDeviceWithThingOutput,
                crate::error::AssociateWirelessDeviceWithThingError,
                crate::input::AssociateWirelessDeviceWithThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessGatewayWithCertificate`.
    ///
    /// <p>Associates a wireless gateway with a certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWirelessGatewayWithCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_gateway_with_certificate_input::Builder,
    }
    impl<C, M, R> AssociateWirelessGatewayWithCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessGatewayWithCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessGatewayWithCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWirelessGatewayWithCertificateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessGatewayWithCertificateInputOperationOutputAlias,
                crate::output::AssociateWirelessGatewayWithCertificateOutput,
                crate::error::AssociateWirelessGatewayWithCertificateError,
                crate::input::AssociateWirelessGatewayWithCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn iot_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iot_certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn set_iot_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iot_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessGatewayWithThing`.
    ///
    /// <p>Associates a wireless gateway with a thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWirelessGatewayWithThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_gateway_with_thing_input::Builder,
    }
    impl<C, M, R> AssociateWirelessGatewayWithThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessGatewayWithThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessGatewayWithThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWirelessGatewayWithThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessGatewayWithThingInputOperationOutputAlias,
                crate::output::AssociateWirelessGatewayWithThingOutput,
                crate::error::AssociateWirelessGatewayWithThingError,
                crate::input::AssociateWirelessGatewayWithThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMulticastGroupSession`.
    ///
    /// <p>Cancels an existing multicast group session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelMulticastGroupSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_multicast_group_session_input::Builder,
    }
    impl<C, M, R> CancelMulticastGroupSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelMulticastGroupSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMulticastGroupSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMulticastGroupSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelMulticastGroupSessionInputOperationOutputAlias,
                crate::output::CancelMulticastGroupSessionOutput,
                crate::error::CancelMulticastGroupSessionError,
                crate::input::CancelMulticastGroupSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDestination`.
    ///
    /// <p>Creates a new destination that maps a device message to an AWS IoT rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_destination_input::Builder,
    }
    impl<C, M, R> CreateDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDestinationInputOperationOutputAlias,
                crate::output::CreateDestinationOutput,
                crate::error::CreateDestinationError,
                crate::input::CreateDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.inner = self.inner.expression_type(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.inner = self.inner.set_expression_type(input);
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeviceProfile`.
    ///
    /// <p>Creates a new device profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_profile_input::Builder,
    }
    impl<C, M, R> CreateDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceProfileInputOperationOutputAlias,
                crate::output::CreateDeviceProfileOutput,
                crate::error::CreateDeviceProfileError,
                crate::input::CreateDeviceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanDeviceProfile) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDeviceProfile>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFuotaTask`.
    ///
    /// <p>Creates a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fuota_task_input::Builder,
    }
    impl<C, M, R> CreateFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFuotaTaskInputOperationOutputAlias,
                crate::output::CreateFuotaTaskOutput,
                crate::error::CreateFuotaTaskError,
                crate::input::CreateFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanFuotaTask) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanFuotaTask>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn firmware_update_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firmware_update_image(input.into());
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firmware_update_image(input);
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn firmware_update_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firmware_update_role(input.into());
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firmware_update_role(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMulticastGroup`.
    ///
    /// <p>Creates a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_multicast_group_input::Builder,
    }
    impl<C, M, R> CreateMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMulticastGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMulticastGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMulticastGroupInputOperationOutputAlias,
                crate::output::CreateMulticastGroupOutput,
                crate::error::CreateMulticastGroupError,
                crate::input::CreateMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the multicast group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the multicast group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the multicast group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticast) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticast>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceProfile`.
    ///
    /// <p>Creates a new service profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_profile_input::Builder,
    }
    impl<C, M, R> CreateServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceProfileInputOperationOutputAlias,
                crate::output::CreateServiceProfileOutput,
                crate::error::CreateServiceProfileError,
                crate::input::CreateServiceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanServiceProfile) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanServiceProfile>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessDevice`.
    ///
    /// <p>Provisions a wireless device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_device_input::Builder,
    }
    impl<C, M, R> CreateWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessDeviceInputOperationOutputAlias,
                crate::output::CreateWirelessDeviceOutput,
                crate::error::CreateWirelessDeviceError,
                crate::input::CreateWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The wireless device type.</p>
        pub fn r#type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The wireless device type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanDevice) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDevice>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGateway`.
    ///
    /// <p>Provisions a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_input::Builder,
    }
    impl<C, M, R> CreateWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayOutput,
                crate::error::CreateWirelessGatewayError,
                crate::input::CreateWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanGateway) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGateway>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGatewayTask`.
    ///
    /// <p>Creates a task for a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> CreateWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayTaskOutput,
                crate::error::CreateWirelessGatewayTaskError,
                crate::input::CreateWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn wireless_gateway_task_definition_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.wireless_gateway_task_definition_id(input.into());
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn set_wireless_gateway_task_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_task_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGatewayTaskDefinition`.
    ///
    /// <p>Creates a gateway task definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> CreateWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateWirelessGatewayTaskDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayTaskDefinitionOutput,
                crate::error::CreateWirelessGatewayTaskDefinitionError,
                crate::input::CreateWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn auto_create_tasks(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_create_tasks(input);
            self
        }
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn set_auto_create_tasks(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create_tasks(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn update(mut self, input: crate::model::UpdateWirelessGatewayTaskCreate) -> Self {
            self.inner = self.inner.update(input);
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn set_update(
            mut self,
            input: std::option::Option<crate::model::UpdateWirelessGatewayTaskCreate>,
        ) -> Self {
            self.inner = self.inner.set_update(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDestination`.
    ///
    /// <p>Deletes a destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_destination_input::Builder,
    }
    impl<C, M, R> DeleteDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDestinationInputOperationOutputAlias,
                crate::output::DeleteDestinationOutput,
                crate::error::DeleteDestinationError,
                crate::input::DeleteDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the resource to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeviceProfile`.
    ///
    /// <p>Deletes a device profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_profile_input::Builder,
    }
    impl<C, M, R> DeleteDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceProfileInputOperationOutputAlias,
                crate::output::DeleteDeviceProfileOutput,
                crate::error::DeleteDeviceProfileError,
                crate::input::DeleteDeviceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFuotaTask`.
    ///
    /// <p>Deletes a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fuota_task_input::Builder,
    }
    impl<C, M, R> DeleteFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFuotaTaskInputOperationOutputAlias,
                crate::output::DeleteFuotaTaskOutput,
                crate::error::DeleteFuotaTaskError,
                crate::input::DeleteFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMulticastGroup`.
    ///
    /// <p>Deletes a multicast group if it is not in use by a fuota task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_multicast_group_input::Builder,
    }
    impl<C, M, R> DeleteMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMulticastGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMulticastGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMulticastGroupInputOperationOutputAlias,
                crate::output::DeleteMulticastGroupOutput,
                crate::error::DeleteMulticastGroupError,
                crate::input::DeleteMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueuedMessages`.
    ///
    /// <p> The operation to delete queued messages. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQueuedMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_queued_messages_input::Builder,
    }
    impl<C, M, R> DeleteQueuedMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQueuedMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueuedMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueuedMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQueuedMessagesInputOperationOutputAlias,
                crate::output::DeleteQueuedMessagesOutput,
                crate::error::DeleteQueuedMessagesError,
                crate::input::DeleteQueuedMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Id of a given wireless device which messages will be deleted </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Id of a given wireless device which messages will be deleted </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_id(input.into());
            self
        }
        /// <p>if messageID=="*", the queue for a particular wireless deviceId will be purged, otherwise, the specific message with messageId will be deleted </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_id(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.wireless_device_type(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN. </p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceProfile`.
    ///
    /// <p>Deletes a service profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_profile_input::Builder,
    }
    impl<C, M, R> DeleteServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceProfileInputOperationOutputAlias,
                crate::output::DeleteServiceProfileOutput,
                crate::error::DeleteServiceProfileError,
                crate::input::DeleteServiceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessDevice`.
    ///
    /// <p>Deletes a wireless device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_device_input::Builder,
    }
    impl<C, M, R> DeleteWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessDeviceInputOperationOutputAlias,
                crate::output::DeleteWirelessDeviceOutput,
                crate::error::DeleteWirelessDeviceError,
                crate::input::DeleteWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGateway`.
    ///
    /// <p>Deletes a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayOutput,
                crate::error::DeleteWirelessGatewayError,
                crate::input::DeleteWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGatewayTask`.
    ///
    /// <p>Deletes a wireless gateway task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayTaskOutput,
                crate::error::DeleteWirelessGatewayTaskError,
                crate::input::DeleteWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGatewayTaskDefinition`.
    ///
    /// <p>Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteWirelessGatewayTaskDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayTaskDefinitionOutput,
                crate::error::DeleteWirelessGatewayTaskDefinitionError,
                crate::input::DeleteWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAwsAccountFromPartnerAccount`.
    ///
    /// <p>Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAwsAccountFromPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_aws_account_from_partner_account_input::Builder,
    }
    impl<C, M, R> DisassociateAwsAccountFromPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAwsAccountFromPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAwsAccountFromPartnerAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateAwsAccountFromPartnerAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAwsAccountFromPartnerAccountInputOperationOutputAlias,
                crate::output::DisassociateAwsAccountFromPartnerAccountOutput,
                crate::error::DisassociateAwsAccountFromPartnerAccountError,
                crate::input::DisassociateAwsAccountFromPartnerAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(input.into());
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMulticastGroupFromFuotaTask`.
    ///
    /// <p>Disassociates a multicast group from a fuota task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMulticastGroupFromFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_multicast_group_from_fuota_task_input::Builder,
    }
    impl<C, M, R> DisassociateMulticastGroupFromFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMulticastGroupFromFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMulticastGroupFromFuotaTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateMulticastGroupFromFuotaTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMulticastGroupFromFuotaTaskInputOperationOutputAlias,
                crate::output::DisassociateMulticastGroupFromFuotaTaskOutput,
                crate::error::DisassociateMulticastGroupFromFuotaTaskError,
                crate::input::DisassociateMulticastGroupFromFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multicast_group_id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_multicast_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessDeviceFromFuotaTask`.
    ///
    /// <p>Disassociates a wireless device from a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWirelessDeviceFromFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_device_from_fuota_task_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessDeviceFromFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessDeviceFromFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessDeviceFromFuotaTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessDeviceFromFuotaTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessDeviceFromFuotaTaskInputOperationOutputAlias,
                crate::output::DisassociateWirelessDeviceFromFuotaTaskOutput,
                crate::error::DisassociateWirelessDeviceFromFuotaTaskError,
                crate::input::DisassociateWirelessDeviceFromFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessDeviceFromMulticastGroup`.
    ///
    /// <p>Disassociates a wireless device from a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWirelessDeviceFromMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_device_from_multicast_group_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessDeviceFromMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessDeviceFromMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessDeviceFromMulticastGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessDeviceFromMulticastGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessDeviceFromMulticastGroupInputOperationOutputAlias,
                crate::output::DisassociateWirelessDeviceFromMulticastGroupOutput,
                crate::error::DisassociateWirelessDeviceFromMulticastGroupError,
                crate::input::DisassociateWirelessDeviceFromMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(input.into());
            self
        }
        /// <p>The ID of the wireless device.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessDeviceFromThing`.
    ///
    /// <p>Disassociates a wireless device from its currently associated thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWirelessDeviceFromThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_device_from_thing_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessDeviceFromThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessDeviceFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessDeviceFromThingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessDeviceFromThingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessDeviceFromThingInputOperationOutputAlias,
                crate::output::DisassociateWirelessDeviceFromThingOutput,
                crate::error::DisassociateWirelessDeviceFromThingError,
                crate::input::DisassociateWirelessDeviceFromThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessGatewayFromCertificate`.
    ///
    /// <p>Disassociates a wireless gateway from its currently associated certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWirelessGatewayFromCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_gateway_from_certificate_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessGatewayFromCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessGatewayFromCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessGatewayFromCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessGatewayFromCertificateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessGatewayFromCertificateInputOperationOutputAlias,
                crate::output::DisassociateWirelessGatewayFromCertificateOutput,
                crate::error::DisassociateWirelessGatewayFromCertificateError,
                crate::input::DisassociateWirelessGatewayFromCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessGatewayFromThing`.
    ///
    /// <p>Disassociates a wireless gateway from its currently associated thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWirelessGatewayFromThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_gateway_from_thing_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessGatewayFromThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessGatewayFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessGatewayFromThingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessGatewayFromThingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessGatewayFromThingInputOperationOutputAlias,
                crate::output::DisassociateWirelessGatewayFromThingOutput,
                crate::error::DisassociateWirelessGatewayFromThingError,
                crate::input::DisassociateWirelessGatewayFromThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDestination`.
    ///
    /// <p>Gets information about a destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_destination_input::Builder,
    }
    impl<C, M, R> GetDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDestinationInputOperationOutputAlias,
                crate::output::GetDestinationOutput,
                crate::error::GetDestinationError,
                crate::input::GetDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the resource to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeviceProfile`.
    ///
    /// <p>Gets information about a device profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_profile_input::Builder,
    }
    impl<C, M, R> GetDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceProfileInputOperationOutputAlias,
                crate::output::GetDeviceProfileOutput,
                crate::error::GetDeviceProfileError,
                crate::input::GetDeviceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFuotaTask`.
    ///
    /// <p>Gets information about a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_fuota_task_input::Builder,
    }
    impl<C, M, R> GetFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFuotaTaskInputOperationOutputAlias,
                crate::output::GetFuotaTaskOutput,
                crate::error::GetFuotaTaskError,
                crate::input::GetFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLogLevelsByResourceTypes`.
    ///
    /// <p>Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLogLevelsByResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_log_levels_by_resource_types_input::Builder,
    }
    impl<C, M, R> GetLogLevelsByResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLogLevelsByResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLogLevelsByResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLogLevelsByResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLogLevelsByResourceTypesInputOperationOutputAlias,
                crate::output::GetLogLevelsByResourceTypesOutput,
                crate::error::GetLogLevelsByResourceTypesError,
                crate::input::GetLogLevelsByResourceTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMulticastGroup`.
    ///
    /// <p>Gets information about a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_multicast_group_input::Builder,
    }
    impl<C, M, R> GetMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMulticastGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMulticastGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMulticastGroupInputOperationOutputAlias,
                crate::output::GetMulticastGroupOutput,
                crate::error::GetMulticastGroupError,
                crate::input::GetMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMulticastGroupSession`.
    ///
    /// <p>Gets information about a multicast group session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMulticastGroupSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_multicast_group_session_input::Builder,
    }
    impl<C, M, R> GetMulticastGroupSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMulticastGroupSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMulticastGroupSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMulticastGroupSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMulticastGroupSessionInputOperationOutputAlias,
                crate::output::GetMulticastGroupSessionOutput,
                crate::error::GetMulticastGroupSessionError,
                crate::input::GetMulticastGroupSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetworkAnalyzerConfiguration`.
    ///
    /// <p>Get NetworkAnalyzer configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetworkAnalyzerConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_analyzer_configuration_input::Builder,
    }
    impl<C, M, R> GetNetworkAnalyzerConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetworkAnalyzerConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkAnalyzerConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkAnalyzerConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkAnalyzerConfigurationInputOperationOutputAlias,
                crate::output::GetNetworkAnalyzerConfigurationOutput,
                crate::error::GetNetworkAnalyzerConfigurationError,
                crate::input::GetNetworkAnalyzerConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_name(input.into());
            self
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPartnerAccount`.
    ///
    /// <p>Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, returns all partner accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_partner_account_input::Builder,
    }
    impl<C, M, R> GetPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPartnerAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPartnerAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPartnerAccountInputOperationOutputAlias,
                crate::output::GetPartnerAccountOutput,
                crate::error::GetPartnerAccountError,
                crate::input::GetPartnerAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(input.into());
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceEventConfiguration`.
    ///
    /// <p>Get the event configuration for a particular resource identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceEventConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_event_configuration_input::Builder,
    }
    impl<C, M, R> GetResourceEventConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceEventConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceEventConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceEventConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceEventConfigurationInputOperationOutputAlias,
                crate::output::GetResourceEventConfigurationOutput,
                crate::error::GetResourceEventConfigurationError,
                crate::input::GetResourceEventConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn identifier_type(mut self, input: crate::model::IdentifierType) -> Self {
            self.inner = self.inner.identifier_type(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::IdentifierType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
        pub fn partner_type(mut self, input: crate::model::EventNotificationPartnerType) -> Self {
            self.inner = self.inner.partner_type(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::EventNotificationPartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceLogLevel`.
    ///
    /// <p>Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_log_level_input::Builder,
    }
    impl<C, M, R> GetResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceLogLevelInputOperationOutputAlias,
                crate::output::GetResourceLogLevelOutput,
                crate::error::GetResourceLogLevelError,
                crate::input::GetResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceEndpoint`.
    ///
    /// <p>Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_endpoint_input::Builder,
    }
    impl<C, M, R> GetServiceEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceEndpointInputOperationOutputAlias,
                crate::output::GetServiceEndpointOutput,
                crate::error::GetServiceEndpointError,
                crate::input::GetServiceEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn service_type(mut self, input: crate::model::WirelessGatewayServiceType) -> Self {
            self.inner = self.inner.service_type(input);
            self
        }
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceProfile`.
    ///
    /// <p>Gets information about a service profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_profile_input::Builder,
    }
    impl<C, M, R> GetServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceProfileInputOperationOutputAlias,
                crate::output::GetServiceProfileOutput,
                crate::error::GetServiceProfileError,
                crate::input::GetServiceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessDevice`.
    ///
    /// <p>Gets information about a wireless device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_device_input::Builder,
    }
    impl<C, M, R> GetWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessDeviceInputOperationOutputAlias,
                crate::output::GetWirelessDeviceOutput,
                crate::error::GetWirelessDeviceError,
                crate::input::GetWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the wireless device to get.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The identifier of the wireless device to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, input: crate::model::WirelessDeviceIdType) -> Self {
            self.inner = self.inner.identifier_type(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceIdType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessDeviceStatistics`.
    ///
    /// <p>Gets operating information about a wireless device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessDeviceStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_device_statistics_input::Builder,
    }
    impl<C, M, R> GetWirelessDeviceStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessDeviceStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessDeviceStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessDeviceStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessDeviceStatisticsInputOperationOutputAlias,
                crate::output::GetWirelessDeviceStatisticsOutput,
                crate::error::GetWirelessDeviceStatisticsError,
                crate::input::GetWirelessDeviceStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn wireless_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(input.into());
            self
        }
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGateway`.
    ///
    /// <p>Gets information about a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_input::Builder,
    }
    impl<C, M, R> GetWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayInputOperationOutputAlias,
                crate::output::GetWirelessGatewayOutput,
                crate::error::GetWirelessGatewayError,
                crate::input::GetWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, input: crate::model::WirelessGatewayIdType) -> Self {
            self.inner = self.inner.identifier_type(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayIdType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayCertificate`.
    ///
    /// <p>Gets the ID of the certificate that is currently associated with a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGatewayCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_certificate_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayCertificateInputOperationOutputAlias,
                crate::output::GetWirelessGatewayCertificateOutput,
                crate::error::GetWirelessGatewayCertificateError,
                crate::input::GetWirelessGatewayCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayFirmwareInformation`.
    ///
    /// <p>Gets the firmware version and other information about a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGatewayFirmwareInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_firmware_information_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayFirmwareInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayFirmwareInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayFirmwareInformationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetWirelessGatewayFirmwareInformationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayFirmwareInformationInputOperationOutputAlias,
                crate::output::GetWirelessGatewayFirmwareInformationOutput,
                crate::error::GetWirelessGatewayFirmwareInformationError,
                crate::input::GetWirelessGatewayFirmwareInformationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayStatistics`.
    ///
    /// <p>Gets operating information about a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGatewayStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_statistics_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayStatisticsInputOperationOutputAlias,
                crate::output::GetWirelessGatewayStatisticsOutput,
                crate::error::GetWirelessGatewayStatisticsError,
                crate::input::GetWirelessGatewayStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn wireless_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_gateway_id(input.into());
            self
        }
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn set_wireless_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayTask`.
    ///
    /// <p>Gets information about a wireless gateway task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::GetWirelessGatewayTaskOutput,
                crate::error::GetWirelessGatewayTaskError,
                crate::input::GetWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayTaskDefinition`.
    ///
    /// <p>Gets information about a wireless gateway task definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayTaskDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::GetWirelessGatewayTaskDefinitionOutput,
                crate::error::GetWirelessGatewayTaskDefinitionError,
                crate::input::GetWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDestinations`.
    ///
    /// <p>Lists the destinations registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_destinations_input::Builder,
    }
    impl<C, M, R> ListDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDestinationsInputOperationOutputAlias,
                crate::output::ListDestinationsOutput,
                crate::error::ListDestinationsError,
                crate::input::ListDestinationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDestinationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDestinationsPaginator<C, M, R> {
            crate::paginator::ListDestinationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceProfiles`.
    ///
    /// <p>Lists the device profiles registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeviceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_profiles_input::Builder,
    }
    impl<C, M, R> ListDeviceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceProfilesInputOperationOutputAlias,
                crate::output::ListDeviceProfilesOutput,
                crate::error::ListDeviceProfilesError,
                crate::input::ListDeviceProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeviceProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeviceProfilesPaginator<C, M, R> {
            crate::paginator::ListDeviceProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFuotaTasks`.
    ///
    /// <p>Lists the FUOTA tasks registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFuotaTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fuota_tasks_input::Builder,
    }
    impl<C, M, R> ListFuotaTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFuotaTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFuotaTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFuotaTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFuotaTasksInputOperationOutputAlias,
                crate::output::ListFuotaTasksOutput,
                crate::error::ListFuotaTasksError,
                crate::input::ListFuotaTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFuotaTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFuotaTasksPaginator<C, M, R> {
            crate::paginator::ListFuotaTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMulticastGroups`.
    ///
    /// <p>Lists the multicast groups registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMulticastGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_multicast_groups_input::Builder,
    }
    impl<C, M, R> ListMulticastGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMulticastGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMulticastGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMulticastGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMulticastGroupsInputOperationOutputAlias,
                crate::output::ListMulticastGroupsOutput,
                crate::error::ListMulticastGroupsError,
                crate::input::ListMulticastGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMulticastGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMulticastGroupsPaginator<C, M, R> {
            crate::paginator::ListMulticastGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMulticastGroupsByFuotaTask`.
    ///
    /// <p>List all multicast groups associated with a fuota task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMulticastGroupsByFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_multicast_groups_by_fuota_task_input::Builder,
    }
    impl<C, M, R> ListMulticastGroupsByFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMulticastGroupsByFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMulticastGroupsByFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMulticastGroupsByFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMulticastGroupsByFuotaTaskInputOperationOutputAlias,
                crate::output::ListMulticastGroupsByFuotaTaskOutput,
                crate::error::ListMulticastGroupsByFuotaTaskError,
                crate::input::ListMulticastGroupsByFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMulticastGroupsByFuotaTaskPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListMulticastGroupsByFuotaTaskPaginator<C, M, R> {
            crate::paginator::ListMulticastGroupsByFuotaTaskPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerAccounts`.
    ///
    /// <p>Lists the partner accounts associated with your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPartnerAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_partner_accounts_input::Builder,
    }
    impl<C, M, R> ListPartnerAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPartnerAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPartnerAccountsInputOperationOutputAlias,
                crate::output::ListPartnerAccountsOutput,
                crate::error::ListPartnerAccountsError,
                crate::input::ListPartnerAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueuedMessages`.
    ///
    /// <p>The operation to list queued messages. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQueuedMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queued_messages_input::Builder,
    }
    impl<C, M, R> ListQueuedMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueuedMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueuedMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueuedMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueuedMessagesInputOperationOutputAlias,
                crate::output::ListQueuedMessagesOutput,
                crate::error::ListQueuedMessagesError,
                crate::input::ListQueuedMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQueuedMessagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQueuedMessagesPaginator<C, M, R> {
            crate::paginator::ListQueuedMessagesPaginator::new(self.handle, self.inner)
        }
        /// <p>Id of a given wireless device which the downlink packets are targeted </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Id of a given wireless device which the downlink packets are targeted </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.wireless_device_type(input);
            self
        }
        /// <p>The wireless device type, it is either Sidewalk or LoRaWAN.</p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceProfiles`.
    ///
    /// <p>Lists the service profiles registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_profiles_input::Builder,
    }
    impl<C, M, R> ListServiceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceProfilesInputOperationOutputAlias,
                crate::output::ListServiceProfilesOutput,
                crate::error::ListServiceProfilesError,
                crate::input::ListServiceProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServiceProfilesPaginator<C, M, R> {
            crate::paginator::ListServiceProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) you have assigned to the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessDevices`.
    ///
    /// <p>Lists the wireless devices registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWirelessDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_devices_input::Builder,
    }
    impl<C, M, R> ListWirelessDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWirelessDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessDevicesInputOperationOutputAlias,
                crate::output::ListWirelessDevicesOutput,
                crate::error::ListWirelessDevicesError,
                crate::input::ListWirelessDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWirelessDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWirelessDevicesPaginator<C, M, R> {
            crate::paginator::ListWirelessDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn device_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_profile_id(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn set_device_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_profile_id(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn service_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_profile_id(input.into());
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn set_service_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_profile_id(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn wireless_device_type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.wireless_device_type(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_type(input);
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn fuota_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fuota_task_id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_fuota_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fuota_task_id(input);
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn multicast_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.multicast_group_id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_multicast_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_multicast_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessGateways`.
    ///
    /// <p>Lists the wireless gateways registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWirelessGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_gateways_input::Builder,
    }
    impl<C, M, R> ListWirelessGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWirelessGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessGatewaysInputOperationOutputAlias,
                crate::output::ListWirelessGatewaysOutput,
                crate::error::ListWirelessGatewaysError,
                crate::input::ListWirelessGatewaysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWirelessGatewaysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWirelessGatewaysPaginator<C, M, R> {
            crate::paginator::ListWirelessGatewaysPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessGatewayTaskDefinitions`.
    ///
    /// <p>List the wireless gateway tasks definitions registered to your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWirelessGatewayTaskDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_gateway_task_definitions_input::Builder,
    }
    impl<C, M, R> ListWirelessGatewayTaskDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessGatewayTaskDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessGatewayTaskDefinitionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListWirelessGatewayTaskDefinitionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessGatewayTaskDefinitionsInputOperationOutputAlias,
                crate::output::ListWirelessGatewayTaskDefinitionsOutput,
                crate::error::ListWirelessGatewayTaskDefinitionsError,
                crate::input::ListWirelessGatewayTaskDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn task_definition_type(
            mut self,
            input: crate::model::WirelessGatewayTaskDefinitionType,
        ) -> Self {
            self.inner = self.inner.task_definition_type(input);
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn set_task_definition_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayTaskDefinitionType>,
        ) -> Self {
            self.inner = self.inner.set_task_definition_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourceLogLevel`.
    ///
    /// <p>Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_log_level_input::Builder,
    }
    impl<C, M, R> PutResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourceLogLevelInputOperationOutputAlias,
                crate::output::PutResourceLogLevelOutput,
                crate::error::PutResourceLogLevelError,
                crate::input::PutResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.inner = self.inner.log_level(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.inner = self.inner.set_log_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetAllResourceLogLevels`.
    ///
    /// <p>Removes the log-level overrides for all resources; both wireless devices and wireless gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetAllResourceLogLevels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_all_resource_log_levels_input::Builder,
    }
    impl<C, M, R> ResetAllResourceLogLevels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetAllResourceLogLevels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetAllResourceLogLevelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetAllResourceLogLevelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetAllResourceLogLevelsInputOperationOutputAlias,
                crate::output::ResetAllResourceLogLevelsOutput,
                crate::error::ResetAllResourceLogLevelsError,
                crate::input::ResetAllResourceLogLevelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ResetResourceLogLevel`.
    ///
    /// <p>Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_resource_log_level_input::Builder,
    }
    impl<C, M, R> ResetResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetResourceLogLevelInputOperationOutputAlias,
                crate::output::ResetResourceLogLevelOutput,
                crate::error::ResetResourceLogLevelError,
                crate::input::ResetResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway, it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendDataToMulticastGroup`.
    ///
    /// <p>Sends the specified data to a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendDataToMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_data_to_multicast_group_input::Builder,
    }
    impl<C, M, R> SendDataToMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendDataToMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendDataToMulticastGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::SendDataToMulticastGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendDataToMulticastGroupInputOperationOutputAlias,
                crate::output::SendDataToMulticastGroupOutput,
                crate::error::SendDataToMulticastGroupError,
                crate::input::SendDataToMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn payload_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_data(input.into());
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn set_payload_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_payload_data(input);
            self
        }
        /// <p>Wireless metadata that is to be sent to multicast group.</p>
        pub fn wireless_metadata(mut self, input: crate::model::MulticastWirelessMetadata) -> Self {
            self.inner = self.inner.wireless_metadata(input);
            self
        }
        /// <p>Wireless metadata that is to be sent to multicast group.</p>
        pub fn set_wireless_metadata(
            mut self,
            input: std::option::Option<crate::model::MulticastWirelessMetadata>,
        ) -> Self {
            self.inner = self.inner.set_wireless_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendDataToWirelessDevice`.
    ///
    /// <p>Sends a decrypted application data frame to a device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendDataToWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_data_to_wireless_device_input::Builder,
    }
    impl<C, M, R> SendDataToWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendDataToWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendDataToWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::SendDataToWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendDataToWirelessDeviceInputOperationOutputAlias,
                crate::output::SendDataToWirelessDeviceOutput,
                crate::error::SendDataToWirelessDeviceError,
                crate::input::SendDataToWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn transmit_mode(mut self, input: i32) -> Self {
            self.inner = self.inner.transmit_mode(input);
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn set_transmit_mode(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_transmit_mode(input);
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn payload_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_data(input.into());
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn set_payload_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_payload_data(input);
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn wireless_metadata(mut self, input: crate::model::WirelessMetadata) -> Self {
            self.inner = self.inner.wireless_metadata(input);
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn set_wireless_metadata(
            mut self,
            input: std::option::Option<crate::model::WirelessMetadata>,
        ) -> Self {
            self.inner = self.inner.set_wireless_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBulkAssociateWirelessDeviceWithMulticastGroup`.
    ///
    /// <p>Starts a bulk association of all qualifying wireless devices with a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBulkAssociateWirelessDeviceWithMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner:
            crate::input::start_bulk_associate_wireless_device_with_multicast_group_input::Builder,
    }
    impl<C, M, R> StartBulkAssociateWirelessDeviceWithMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBulkAssociateWirelessDeviceWithMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::StartBulkAssociateWirelessDeviceWithMulticastGroupOutput, aws_smithy_http::result::SdkError<crate::error::StartBulkAssociateWirelessDeviceWithMulticastGroupError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInputOperationOutputAlias,
                                    crate::output::StartBulkAssociateWirelessDeviceWithMulticastGroupOutput,
                                    crate::error::StartBulkAssociateWirelessDeviceWithMulticastGroupError,
                                    crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBulkDisassociateWirelessDeviceFromMulticastGroup`.
    ///
    /// <p>Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBulkDisassociateWirelessDeviceFromMulticastGroup<C = aws_smithy_client::erase::DynConnector, M= crate::middleware::DefaultMiddleware, R= aws_smithy_client::retry::Standard> {
                            handle: std::sync::Arc<super::Handle<C, M, R>>,
                            inner: crate::input::start_bulk_disassociate_wireless_device_from_multicast_group_input::Builder
                        }
    impl<C, M, R> StartBulkDisassociateWirelessDeviceFromMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBulkDisassociateWirelessDeviceFromMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::StartBulkDisassociateWirelessDeviceFromMulticastGroupOutput, aws_smithy_http::result::SdkError<crate::error::StartBulkDisassociateWirelessDeviceFromMulticastGroupError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInputOperationOutputAlias,
                                    crate::output::StartBulkDisassociateWirelessDeviceFromMulticastGroupOutput,
                                    crate::error::StartBulkDisassociateWirelessDeviceFromMulticastGroupError,
                                    crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>Query string used to search for wireless devices as part of the bulk associate and disassociate process.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFuotaTask`.
    ///
    /// <p>Starts a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fuota_task_input::Builder,
    }
    impl<C, M, R> StartFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFuotaTaskInputOperationOutputAlias,
                crate::output::StartFuotaTaskOutput,
                crate::error::StartFuotaTaskError,
                crate::input::StartFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The LoRaWAN information used to start a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanStartFuotaTask) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information used to start a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanStartFuotaTask>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMulticastGroupSession`.
    ///
    /// <p>Starts a multicast group session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMulticastGroupSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_multicast_group_session_input::Builder,
    }
    impl<C, M, R> StartMulticastGroupSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMulticastGroupSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMulticastGroupSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMulticastGroupSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMulticastGroupSessionInputOperationOutputAlias,
                crate::output::StartMulticastGroupSessionOutput,
                crate::error::StartMulticastGroupSessionError,
                crate::input::StartMulticastGroupSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The LoRaWAN information used with the multicast session.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticastSession) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information used with the multicast session.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticastSession>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestWirelessDevice`.
    ///
    /// <p>Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_wireless_device_input::Builder,
    }
    impl<C, M, R> TestWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::TestWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestWirelessDeviceInputOperationOutputAlias,
                crate::output::TestWirelessDeviceOutput,
                crate::error::TestWirelessDeviceError,
                crate::input::TestWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device to test.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the wireless device to test.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDestination`.
    ///
    /// <p>Updates properties of a destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_destination_input::Builder,
    }
    impl<C, M, R> UpdateDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDestinationInputOperationOutputAlias,
                crate::output::UpdateDestinationOutput,
                crate::error::UpdateDestinationError,
                crate::input::UpdateDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.inner = self.inner.expression_type(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.inner = self.inner.set_expression_type(input);
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(input.into());
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFuotaTask`.
    ///
    /// <p>Updates properties of a FUOTA task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFuotaTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_fuota_task_input::Builder,
    }
    impl<C, M, R> UpdateFuotaTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFuotaTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFuotaTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFuotaTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFuotaTaskInputOperationOutputAlias,
                crate::output::UpdateFuotaTaskOutput,
                crate::error::UpdateFuotaTaskError,
                crate::input::UpdateFuotaTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanFuotaTask) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information used with a FUOTA task.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanFuotaTask>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn firmware_update_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firmware_update_image(input.into());
            self
        }
        /// <p>The S3 URI points to a firmware update image that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firmware_update_image(input);
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn firmware_update_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firmware_update_role(input.into());
            self
        }
        /// <p>The firmware update role that is to be used with a FUOTA task.</p>
        pub fn set_firmware_update_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firmware_update_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLogLevelsByResourceTypes`.
    ///
    /// <p>Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLogLevelsByResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_log_levels_by_resource_types_input::Builder,
    }
    impl<C, M, R> UpdateLogLevelsByResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLogLevelsByResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLogLevelsByResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLogLevelsByResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLogLevelsByResourceTypesInputOperationOutputAlias,
                crate::output::UpdateLogLevelsByResourceTypesOutput,
                crate::error::UpdateLogLevelsByResourceTypesError,
                crate::input::UpdateLogLevelsByResourceTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The log level for a log message.</p>
        pub fn default_log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.inner = self.inner.default_log_level(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_default_log_level(
            mut self,
            input: std::option::Option<crate::model::LogLevel>,
        ) -> Self {
            self.inner = self.inner.set_default_log_level(input);
            self
        }
        /// Appends an item to `WirelessDeviceLogOptions`.
        ///
        /// To override the contents of this collection use [`set_wireless_device_log_options`](Self::set_wireless_device_log_options).
        ///
        /// <p>The list of wireless device log options.</p>
        pub fn wireless_device_log_options(
            mut self,
            input: crate::model::WirelessDeviceLogOption,
        ) -> Self {
            self.inner = self.inner.wireless_device_log_options(input);
            self
        }
        /// <p>The list of wireless device log options.</p>
        pub fn set_wireless_device_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessDeviceLogOption>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_log_options(input);
            self
        }
        /// Appends an item to `WirelessGatewayLogOptions`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateway_log_options`](Self::set_wireless_gateway_log_options).
        ///
        /// <p>The list of wireless gateway log options.</p>
        pub fn wireless_gateway_log_options(
            mut self,
            input: crate::model::WirelessGatewayLogOption,
        ) -> Self {
            self.inner = self.inner.wireless_gateway_log_options(input);
            self
        }
        /// <p>The list of wireless gateway log options.</p>
        pub fn set_wireless_gateway_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessGatewayLogOption>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_log_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMulticastGroup`.
    ///
    /// <p>Updates properties of a multicast group session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMulticastGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_multicast_group_input::Builder,
    }
    impl<C, M, R> UpdateMulticastGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMulticastGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMulticastGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMulticastGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMulticastGroupInputOperationOutputAlias,
                crate::output::UpdateMulticastGroupOutput,
                crate::error::UpdateMulticastGroupError,
                crate::input::UpdateMulticastGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticast) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The LoRaWAN information that is to be used with the multicast group.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticast>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNetworkAnalyzerConfiguration`.
    ///
    /// <p>Update NetworkAnalyzer configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNetworkAnalyzerConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_network_analyzer_configuration_input::Builder,
    }
    impl<C, M, R> UpdateNetworkAnalyzerConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNetworkAnalyzerConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNetworkAnalyzerConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateNetworkAnalyzerConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNetworkAnalyzerConfigurationInputOperationOutputAlias,
                crate::output::UpdateNetworkAnalyzerConfigurationOutput,
                crate::error::UpdateNetworkAnalyzerConfigurationError,
                crate::input::UpdateNetworkAnalyzerConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_name(input.into());
            self
        }
        /// <p>NetworkAnalyzer configuration name.</p>
        pub fn set_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_name(input);
            self
        }
        /// <p>Trace Content for resources.</p>
        pub fn trace_content(mut self, input: crate::model::TraceContent) -> Self {
            self.inner = self.inner.trace_content(input);
            self
        }
        /// <p>Trace Content for resources.</p>
        pub fn set_trace_content(
            mut self,
            input: std::option::Option<crate::model::TraceContent>,
        ) -> Self {
            self.inner = self.inner.set_trace_content(input);
            self
        }
        /// Appends an item to `WirelessDevicesToAdd`.
        ///
        /// To override the contents of this collection use [`set_wireless_devices_to_add`](Self::set_wireless_devices_to_add).
        ///
        /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
        pub fn wireless_devices_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_devices_to_add(input.into());
            self
        }
        /// <p>WirelessDevices to add into NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_devices_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_devices_to_add(input);
            self
        }
        /// Appends an item to `WirelessDevicesToRemove`.
        ///
        /// To override the contents of this collection use [`set_wireless_devices_to_remove`](Self::set_wireless_devices_to_remove).
        ///
        /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
        pub fn wireless_devices_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_devices_to_remove(input.into());
            self
        }
        /// <p>WirelessDevices to remove from NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_devices_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_devices_to_remove(input);
            self
        }
        /// Appends an item to `WirelessGatewaysToAdd`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateways_to_add`](Self::set_wireless_gateways_to_add).
        ///
        /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
        pub fn wireless_gateways_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_gateways_to_add(input.into());
            self
        }
        /// <p>WirelessGateways to add into NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_gateways_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateways_to_add(input);
            self
        }
        /// Appends an item to `WirelessGatewaysToRemove`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateways_to_remove`](Self::set_wireless_gateways_to_remove).
        ///
        /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
        pub fn wireless_gateways_to_remove(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.wireless_gateways_to_remove(input.into());
            self
        }
        /// <p>WirelessGateways to remove from NetworkAnalyzerConfiguration.</p>
        pub fn set_wireless_gateways_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateways_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePartnerAccount`.
    ///
    /// <p>Updates properties of a partner account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_partner_account_input::Builder,
    }
    impl<C, M, R> UpdatePartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePartnerAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePartnerAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePartnerAccountInputOperationOutputAlias,
                crate::output::UpdatePartnerAccountOutput,
                crate::error::UpdatePartnerAccountError,
                crate::input::UpdatePartnerAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkUpdateAccount) -> Self {
            self.inner = self.inner.sidewalk(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkUpdateAccount>,
        ) -> Self {
            self.inner = self.inner.set_sidewalk(input);
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn partner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(input.into());
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, input: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceEventConfiguration`.
    ///
    /// <p>Update the event configuration for a particular resource identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceEventConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_event_configuration_input::Builder,
    }
    impl<C, M, R> UpdateResourceEventConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceEventConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceEventConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceEventConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceEventConfigurationInputOperationOutputAlias,
                crate::output::UpdateResourceEventConfigurationOutput,
                crate::error::UpdateResourceEventConfigurationError,
                crate::input::UpdateResourceEventConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(input.into());
            self
        }
        /// <p>Resource identifier to opt in for event messaging.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn identifier_type(mut self, input: crate::model::IdentifierType) -> Self {
            self.inner = self.inner.identifier_type(input);
            self
        }
        /// <p>Identifier type of the particular resource identifier for event configuration.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::IdentifierType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
        pub fn partner_type(mut self, input: crate::model::EventNotificationPartnerType) -> Self {
            self.inner = self.inner.partner_type(input);
            self
        }
        /// <p>Partner type of the resource if the identifier type is PartnerAccountId</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::EventNotificationPartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
        /// <p>Event configuration for the device registration state event</p>
        pub fn device_registration_state(
            mut self,
            input: crate::model::DeviceRegistrationStateEventConfiguration,
        ) -> Self {
            self.inner = self.inner.device_registration_state(input);
            self
        }
        /// <p>Event configuration for the device registration state event</p>
        pub fn set_device_registration_state(
            mut self,
            input: std::option::Option<crate::model::DeviceRegistrationStateEventConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_device_registration_state(input);
            self
        }
        /// <p>Event configuration for the Proximity event</p>
        pub fn proximity(mut self, input: crate::model::ProximityEventConfiguration) -> Self {
            self.inner = self.inner.proximity(input);
            self
        }
        /// <p>Event configuration for the Proximity event</p>
        pub fn set_proximity(
            mut self,
            input: std::option::Option<crate::model::ProximityEventConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_proximity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWirelessDevice`.
    ///
    /// <p>Updates properties of a wireless device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_wireless_device_input::Builder,
    }
    impl<C, M, R> UpdateWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWirelessDeviceInputOperationOutputAlias,
                crate::output::UpdateWirelessDeviceOutput,
                crate::error::UpdateWirelessDeviceError,
                crate::input::UpdateWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanUpdateDevice) -> Self {
            self.inner = self.inner.lo_ra_wan(input);
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanUpdateDevice>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWirelessGateway`.
    ///
    /// <p>Updates properties of a wireless gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_wireless_gateway_input::Builder,
    }
    impl<C, M, R> UpdateWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWirelessGatewayInputOperationOutputAlias,
                crate::output::UpdateWirelessGatewayOutput,
                crate::error::UpdateWirelessGatewayError,
                crate::input::UpdateWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `JoinEuiFilters`.
        ///
        /// To override the contents of this collection use [`set_join_eui_filters`](Self::set_join_eui_filters).
        ///
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn join_eui_filters(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.join_eui_filters(input);
            self
        }
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn set_join_eui_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_join_eui_filters(input);
            self
        }
        /// Appends an item to `NetIdFilters`.
        ///
        /// To override the contents of this collection use [`set_net_id_filters`](Self::set_net_id_filters).
        ///
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn net_id_filters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.net_id_filters(input.into());
            self
        }
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn set_net_id_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_net_id_filters(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
