// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAwsAccountWithPartnerAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_aws_account_with_partner_account`](crate::client::Client::associate_aws_account_with_partner_account).
///
/// See [`crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAwsAccountWithPartnerAccount {
    _private: (),
}
impl AssociateAwsAccountWithPartnerAccount {
    /// Creates a new builder-style object to manufacture [`AssociateAwsAccountWithPartnerAccountInput`](crate::input::AssociateAwsAccountWithPartnerAccountInput)
    pub fn builder() -> crate::input::associate_aws_account_with_partner_account_input::Builder {
        crate::input::associate_aws_account_with_partner_account_input::Builder::default()
    }
    /// Creates a new `AssociateAwsAccountWithPartnerAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAwsAccountWithPartnerAccount {
    type Output = std::result::Result<
        crate::output::AssociateAwsAccountWithPartnerAccountOutput,
        crate::error::AssociateAwsAccountWithPartnerAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_aws_account_with_partner_account_error(response)
        } else {
            crate::operation_deser::parse_associate_aws_account_with_partner_account_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateMulticastGroupWithFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_multicast_group_with_fuota_task`](crate::client::Client::associate_multicast_group_with_fuota_task).
///
/// See [`crate::client::fluent_builders::AssociateMulticastGroupWithFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateMulticastGroupWithFuotaTask {
    _private: (),
}
impl AssociateMulticastGroupWithFuotaTask {
    /// Creates a new builder-style object to manufacture [`AssociateMulticastGroupWithFuotaTaskInput`](crate::input::AssociateMulticastGroupWithFuotaTaskInput)
    pub fn builder() -> crate::input::associate_multicast_group_with_fuota_task_input::Builder {
        crate::input::associate_multicast_group_with_fuota_task_input::Builder::default()
    }
    /// Creates a new `AssociateMulticastGroupWithFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateMulticastGroupWithFuotaTask {
    type Output = std::result::Result<
        crate::output::AssociateMulticastGroupWithFuotaTaskOutput,
        crate::error::AssociateMulticastGroupWithFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_associate_multicast_group_with_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_associate_multicast_group_with_fuota_task_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateWirelessDeviceWithFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_wireless_device_with_fuota_task`](crate::client::Client::associate_wireless_device_with_fuota_task).
///
/// See [`crate::client::fluent_builders::AssociateWirelessDeviceWithFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithFuotaTask {
    _private: (),
}
impl AssociateWirelessDeviceWithFuotaTask {
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithFuotaTaskInput`](crate::input::AssociateWirelessDeviceWithFuotaTaskInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_fuota_task_input::Builder {
        crate::input::associate_wireless_device_with_fuota_task_input::Builder::default()
    }
    /// Creates a new `AssociateWirelessDeviceWithFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWirelessDeviceWithFuotaTask {
    type Output = std::result::Result<
        crate::output::AssociateWirelessDeviceWithFuotaTaskOutput,
        crate::error::AssociateWirelessDeviceWithFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_associate_wireless_device_with_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_associate_wireless_device_with_fuota_task_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateWirelessDeviceWithMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_wireless_device_with_multicast_group`](crate::client::Client::associate_wireless_device_with_multicast_group).
///
/// See [`crate::client::fluent_builders::AssociateWirelessDeviceWithMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithMulticastGroup {
    _private: (),
}
impl AssociateWirelessDeviceWithMulticastGroup {
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithMulticastGroupInput`](crate::input::AssociateWirelessDeviceWithMulticastGroupInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_multicast_group_input::Builder
    {
        crate::input::associate_wireless_device_with_multicast_group_input::Builder::default()
    }
    /// Creates a new `AssociateWirelessDeviceWithMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWirelessDeviceWithMulticastGroup {
    type Output = std::result::Result<
        crate::output::AssociateWirelessDeviceWithMulticastGroupOutput,
        crate::error::AssociateWirelessDeviceWithMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_associate_wireless_device_with_multicast_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_wireless_device_with_multicast_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateWirelessDeviceWithThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_wireless_device_with_thing`](crate::client::Client::associate_wireless_device_with_thing).
///
/// See [`crate::client::fluent_builders::AssociateWirelessDeviceWithThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithThing {
    _private: (),
}
impl AssociateWirelessDeviceWithThing {
    /// Creates a new builder-style object to manufacture [`AssociateWirelessDeviceWithThingInput`](crate::input::AssociateWirelessDeviceWithThingInput)
    pub fn builder() -> crate::input::associate_wireless_device_with_thing_input::Builder {
        crate::input::associate_wireless_device_with_thing_input::Builder::default()
    }
    /// Creates a new `AssociateWirelessDeviceWithThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWirelessDeviceWithThing {
    type Output = std::result::Result<
        crate::output::AssociateWirelessDeviceWithThingOutput,
        crate::error::AssociateWirelessDeviceWithThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_associate_wireless_device_with_thing_error(response)
        } else {
            crate::operation_deser::parse_associate_wireless_device_with_thing_response(response)
        }
    }
}

/// Operation shape for `AssociateWirelessGatewayWithCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_wireless_gateway_with_certificate`](crate::client::Client::associate_wireless_gateway_with_certificate).
///
/// See [`crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWirelessGatewayWithCertificate {
    _private: (),
}
impl AssociateWirelessGatewayWithCertificate {
    /// Creates a new builder-style object to manufacture [`AssociateWirelessGatewayWithCertificateInput`](crate::input::AssociateWirelessGatewayWithCertificateInput)
    pub fn builder() -> crate::input::associate_wireless_gateway_with_certificate_input::Builder {
        crate::input::associate_wireless_gateway_with_certificate_input::Builder::default()
    }
    /// Creates a new `AssociateWirelessGatewayWithCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWirelessGatewayWithCertificate {
    type Output = std::result::Result<
        crate::output::AssociateWirelessGatewayWithCertificateOutput,
        crate::error::AssociateWirelessGatewayWithCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_wireless_gateway_with_certificate_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_wireless_gateway_with_certificate_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateWirelessGatewayWithThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_wireless_gateway_with_thing`](crate::client::Client::associate_wireless_gateway_with_thing).
///
/// See [`crate::client::fluent_builders::AssociateWirelessGatewayWithThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWirelessGatewayWithThing {
    _private: (),
}
impl AssociateWirelessGatewayWithThing {
    /// Creates a new builder-style object to manufacture [`AssociateWirelessGatewayWithThingInput`](crate::input::AssociateWirelessGatewayWithThingInput)
    pub fn builder() -> crate::input::associate_wireless_gateway_with_thing_input::Builder {
        crate::input::associate_wireless_gateway_with_thing_input::Builder::default()
    }
    /// Creates a new `AssociateWirelessGatewayWithThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWirelessGatewayWithThing {
    type Output = std::result::Result<
        crate::output::AssociateWirelessGatewayWithThingOutput,
        crate::error::AssociateWirelessGatewayWithThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_associate_wireless_gateway_with_thing_error(response)
        } else {
            crate::operation_deser::parse_associate_wireless_gateway_with_thing_response(response)
        }
    }
}

/// Operation shape for `CancelMulticastGroupSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_multicast_group_session`](crate::client::Client::cancel_multicast_group_session).
///
/// See [`crate::client::fluent_builders::CancelMulticastGroupSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelMulticastGroupSession {
    _private: (),
}
impl CancelMulticastGroupSession {
    /// Creates a new builder-style object to manufacture [`CancelMulticastGroupSessionInput`](crate::input::CancelMulticastGroupSessionInput)
    pub fn builder() -> crate::input::cancel_multicast_group_session_input::Builder {
        crate::input::cancel_multicast_group_session_input::Builder::default()
    }
    /// Creates a new `CancelMulticastGroupSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelMulticastGroupSession {
    type Output = std::result::Result<
        crate::output::CancelMulticastGroupSessionOutput,
        crate::error::CancelMulticastGroupSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_cancel_multicast_group_session_error(response)
        } else {
            crate::operation_deser::parse_cancel_multicast_group_session_response(response)
        }
    }
}

/// Operation shape for `CreateDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_destination`](crate::client::Client::create_destination).
///
/// See [`crate::client::fluent_builders::CreateDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDestination {
    _private: (),
}
impl CreateDestination {
    /// Creates a new builder-style object to manufacture [`CreateDestinationInput`](crate::input::CreateDestinationInput)
    pub fn builder() -> crate::input::create_destination_input::Builder {
        crate::input::create_destination_input::Builder::default()
    }
    /// Creates a new `CreateDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDestination {
    type Output = std::result::Result<
        crate::output::CreateDestinationOutput,
        crate::error::CreateDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_destination_error(response)
        } else {
            crate::operation_deser::parse_create_destination_response(response)
        }
    }
}

/// Operation shape for `CreateDeviceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device_profile`](crate::client::Client::create_device_profile).
///
/// See [`crate::client::fluent_builders::CreateDeviceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeviceProfile {
    _private: (),
}
impl CreateDeviceProfile {
    /// Creates a new builder-style object to manufacture [`CreateDeviceProfileInput`](crate::input::CreateDeviceProfileInput)
    pub fn builder() -> crate::input::create_device_profile_input::Builder {
        crate::input::create_device_profile_input::Builder::default()
    }
    /// Creates a new `CreateDeviceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeviceProfile {
    type Output = std::result::Result<
        crate::output::CreateDeviceProfileOutput,
        crate::error::CreateDeviceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_device_profile_error(response)
        } else {
            crate::operation_deser::parse_create_device_profile_response(response)
        }
    }
}

/// Operation shape for `CreateFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fuota_task`](crate::client::Client::create_fuota_task).
///
/// See [`crate::client::fluent_builders::CreateFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFuotaTask {
    _private: (),
}
impl CreateFuotaTask {
    /// Creates a new builder-style object to manufacture [`CreateFuotaTaskInput`](crate::input::CreateFuotaTaskInput)
    pub fn builder() -> crate::input::create_fuota_task_input::Builder {
        crate::input::create_fuota_task_input::Builder::default()
    }
    /// Creates a new `CreateFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFuotaTask {
    type Output = std::result::Result<
        crate::output::CreateFuotaTaskOutput,
        crate::error::CreateFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_create_fuota_task_response(response)
        }
    }
}

/// Operation shape for `CreateMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_multicast_group`](crate::client::Client::create_multicast_group).
///
/// See [`crate::client::fluent_builders::CreateMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMulticastGroup {
    _private: (),
}
impl CreateMulticastGroup {
    /// Creates a new builder-style object to manufacture [`CreateMulticastGroupInput`](crate::input::CreateMulticastGroupInput)
    pub fn builder() -> crate::input::create_multicast_group_input::Builder {
        crate::input::create_multicast_group_input::Builder::default()
    }
    /// Creates a new `CreateMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMulticastGroup {
    type Output = std::result::Result<
        crate::output::CreateMulticastGroupOutput,
        crate::error::CreateMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_create_multicast_group_response(response)
        }
    }
}

/// Operation shape for `CreateServiceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service_profile`](crate::client::Client::create_service_profile).
///
/// See [`crate::client::fluent_builders::CreateServiceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateServiceProfile {
    _private: (),
}
impl CreateServiceProfile {
    /// Creates a new builder-style object to manufacture [`CreateServiceProfileInput`](crate::input::CreateServiceProfileInput)
    pub fn builder() -> crate::input::create_service_profile_input::Builder {
        crate::input::create_service_profile_input::Builder::default()
    }
    /// Creates a new `CreateServiceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateServiceProfile {
    type Output = std::result::Result<
        crate::output::CreateServiceProfileOutput,
        crate::error::CreateServiceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_service_profile_error(response)
        } else {
            crate::operation_deser::parse_create_service_profile_response(response)
        }
    }
}

/// Operation shape for `CreateWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_wireless_device`](crate::client::Client::create_wireless_device).
///
/// See [`crate::client::fluent_builders::CreateWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWirelessDevice {
    _private: (),
}
impl CreateWirelessDevice {
    /// Creates a new builder-style object to manufacture [`CreateWirelessDeviceInput`](crate::input::CreateWirelessDeviceInput)
    pub fn builder() -> crate::input::create_wireless_device_input::Builder {
        crate::input::create_wireless_device_input::Builder::default()
    }
    /// Creates a new `CreateWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWirelessDevice {
    type Output = std::result::Result<
        crate::output::CreateWirelessDeviceOutput,
        crate::error::CreateWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_create_wireless_device_response(response)
        }
    }
}

/// Operation shape for `CreateWirelessGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_wireless_gateway`](crate::client::Client::create_wireless_gateway).
///
/// See [`crate::client::fluent_builders::CreateWirelessGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWirelessGateway {
    _private: (),
}
impl CreateWirelessGateway {
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayInput`](crate::input::CreateWirelessGatewayInput)
    pub fn builder() -> crate::input::create_wireless_gateway_input::Builder {
        crate::input::create_wireless_gateway_input::Builder::default()
    }
    /// Creates a new `CreateWirelessGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWirelessGateway {
    type Output = std::result::Result<
        crate::output::CreateWirelessGatewayOutput,
        crate::error::CreateWirelessGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_wireless_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_wireless_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateWirelessGatewayTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_wireless_gateway_task`](crate::client::Client::create_wireless_gateway_task).
///
/// See [`crate::client::fluent_builders::CreateWirelessGatewayTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWirelessGatewayTask {
    _private: (),
}
impl CreateWirelessGatewayTask {
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayTaskInput`](crate::input::CreateWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::create_wireless_gateway_task_input::Builder {
        crate::input::create_wireless_gateway_task_input::Builder::default()
    }
    /// Creates a new `CreateWirelessGatewayTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWirelessGatewayTask {
    type Output = std::result::Result<
        crate::output::CreateWirelessGatewayTaskOutput,
        crate::error::CreateWirelessGatewayTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_wireless_gateway_task_error(response)
        } else {
            crate::operation_deser::parse_create_wireless_gateway_task_response(response)
        }
    }
}

/// Operation shape for `CreateWirelessGatewayTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_wireless_gateway_task_definition`](crate::client::Client::create_wireless_gateway_task_definition).
///
/// See [`crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWirelessGatewayTaskDefinition {
    _private: (),
}
impl CreateWirelessGatewayTaskDefinition {
    /// Creates a new builder-style object to manufacture [`CreateWirelessGatewayTaskDefinitionInput`](crate::input::CreateWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::create_wireless_gateway_task_definition_input::Builder {
        crate::input::create_wireless_gateway_task_definition_input::Builder::default()
    }
    /// Creates a new `CreateWirelessGatewayTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWirelessGatewayTaskDefinition {
    type Output = std::result::Result<
        crate::output::CreateWirelessGatewayTaskDefinitionOutput,
        crate::error::CreateWirelessGatewayTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_wireless_gateway_task_definition_error(response)
        } else {
            crate::operation_deser::parse_create_wireless_gateway_task_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_destination`](crate::client::Client::delete_destination).
///
/// See [`crate::client::fluent_builders::DeleteDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDestination {
    _private: (),
}
impl DeleteDestination {
    /// Creates a new builder-style object to manufacture [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
    pub fn builder() -> crate::input::delete_destination_input::Builder {
        crate::input::delete_destination_input::Builder::default()
    }
    /// Creates a new `DeleteDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDestination {
    type Output = std::result::Result<
        crate::output::DeleteDestinationOutput,
        crate::error::DeleteDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteDeviceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device_profile`](crate::client::Client::delete_device_profile).
///
/// See [`crate::client::fluent_builders::DeleteDeviceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeviceProfile {
    _private: (),
}
impl DeleteDeviceProfile {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceProfileInput`](crate::input::DeleteDeviceProfileInput)
    pub fn builder() -> crate::input::delete_device_profile_input::Builder {
        crate::input::delete_device_profile_input::Builder::default()
    }
    /// Creates a new `DeleteDeviceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeviceProfile {
    type Output = std::result::Result<
        crate::output::DeleteDeviceProfileOutput,
        crate::error::DeleteDeviceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_device_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_device_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fuota_task`](crate::client::Client::delete_fuota_task).
///
/// See [`crate::client::fluent_builders::DeleteFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFuotaTask {
    _private: (),
}
impl DeleteFuotaTask {
    /// Creates a new builder-style object to manufacture [`DeleteFuotaTaskInput`](crate::input::DeleteFuotaTaskInput)
    pub fn builder() -> crate::input::delete_fuota_task_input::Builder {
        crate::input::delete_fuota_task_input::Builder::default()
    }
    /// Creates a new `DeleteFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFuotaTask {
    type Output = std::result::Result<
        crate::output::DeleteFuotaTaskOutput,
        crate::error::DeleteFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_delete_fuota_task_response(response)
        }
    }
}

/// Operation shape for `DeleteMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_multicast_group`](crate::client::Client::delete_multicast_group).
///
/// See [`crate::client::fluent_builders::DeleteMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMulticastGroup {
    _private: (),
}
impl DeleteMulticastGroup {
    /// Creates a new builder-style object to manufacture [`DeleteMulticastGroupInput`](crate::input::DeleteMulticastGroupInput)
    pub fn builder() -> crate::input::delete_multicast_group_input::Builder {
        crate::input::delete_multicast_group_input::Builder::default()
    }
    /// Creates a new `DeleteMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMulticastGroup {
    type Output = std::result::Result<
        crate::output::DeleteMulticastGroupOutput,
        crate::error::DeleteMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_delete_multicast_group_response(response)
        }
    }
}

/// Operation shape for `DeleteServiceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service_profile`](crate::client::Client::delete_service_profile).
///
/// See [`crate::client::fluent_builders::DeleteServiceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServiceProfile {
    _private: (),
}
impl DeleteServiceProfile {
    /// Creates a new builder-style object to manufacture [`DeleteServiceProfileInput`](crate::input::DeleteServiceProfileInput)
    pub fn builder() -> crate::input::delete_service_profile_input::Builder {
        crate::input::delete_service_profile_input::Builder::default()
    }
    /// Creates a new `DeleteServiceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServiceProfile {
    type Output = std::result::Result<
        crate::output::DeleteServiceProfileOutput,
        crate::error::DeleteServiceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_service_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_service_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_wireless_device`](crate::client::Client::delete_wireless_device).
///
/// See [`crate::client::fluent_builders::DeleteWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWirelessDevice {
    _private: (),
}
impl DeleteWirelessDevice {
    /// Creates a new builder-style object to manufacture [`DeleteWirelessDeviceInput`](crate::input::DeleteWirelessDeviceInput)
    pub fn builder() -> crate::input::delete_wireless_device_input::Builder {
        crate::input::delete_wireless_device_input::Builder::default()
    }
    /// Creates a new `DeleteWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWirelessDevice {
    type Output = std::result::Result<
        crate::output::DeleteWirelessDeviceOutput,
        crate::error::DeleteWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_delete_wireless_device_response(response)
        }
    }
}

/// Operation shape for `DeleteWirelessGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_wireless_gateway`](crate::client::Client::delete_wireless_gateway).
///
/// See [`crate::client::fluent_builders::DeleteWirelessGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWirelessGateway {
    _private: (),
}
impl DeleteWirelessGateway {
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayInput`](crate::input::DeleteWirelessGatewayInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_input::Builder {
        crate::input::delete_wireless_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteWirelessGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWirelessGateway {
    type Output = std::result::Result<
        crate::output::DeleteWirelessGatewayOutput,
        crate::error::DeleteWirelessGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_wireless_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_wireless_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteWirelessGatewayTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_wireless_gateway_task`](crate::client::Client::delete_wireless_gateway_task).
///
/// See [`crate::client::fluent_builders::DeleteWirelessGatewayTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWirelessGatewayTask {
    _private: (),
}
impl DeleteWirelessGatewayTask {
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayTaskInput`](crate::input::DeleteWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_task_input::Builder {
        crate::input::delete_wireless_gateway_task_input::Builder::default()
    }
    /// Creates a new `DeleteWirelessGatewayTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWirelessGatewayTask {
    type Output = std::result::Result<
        crate::output::DeleteWirelessGatewayTaskOutput,
        crate::error::DeleteWirelessGatewayTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_wireless_gateway_task_error(response)
        } else {
            crate::operation_deser::parse_delete_wireless_gateway_task_response(response)
        }
    }
}

/// Operation shape for `DeleteWirelessGatewayTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_wireless_gateway_task_definition`](crate::client::Client::delete_wireless_gateway_task_definition).
///
/// See [`crate::client::fluent_builders::DeleteWirelessGatewayTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWirelessGatewayTaskDefinition {
    _private: (),
}
impl DeleteWirelessGatewayTaskDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteWirelessGatewayTaskDefinitionInput`](crate::input::DeleteWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::delete_wireless_gateway_task_definition_input::Builder {
        crate::input::delete_wireless_gateway_task_definition_input::Builder::default()
    }
    /// Creates a new `DeleteWirelessGatewayTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWirelessGatewayTaskDefinition {
    type Output = std::result::Result<
        crate::output::DeleteWirelessGatewayTaskDefinitionOutput,
        crate::error::DeleteWirelessGatewayTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_wireless_gateway_task_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_wireless_gateway_task_definition_response(response)
        }
    }
}

/// Operation shape for `DisassociateAwsAccountFromPartnerAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_aws_account_from_partner_account`](crate::client::Client::disassociate_aws_account_from_partner_account).
///
/// See [`crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAwsAccountFromPartnerAccount {
    _private: (),
}
impl DisassociateAwsAccountFromPartnerAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateAwsAccountFromPartnerAccountInput`](crate::input::DisassociateAwsAccountFromPartnerAccountInput)
    pub fn builder() -> crate::input::disassociate_aws_account_from_partner_account_input::Builder {
        crate::input::disassociate_aws_account_from_partner_account_input::Builder::default()
    }
    /// Creates a new `DisassociateAwsAccountFromPartnerAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAwsAccountFromPartnerAccount {
    type Output = std::result::Result<
        crate::output::DisassociateAwsAccountFromPartnerAccountOutput,
        crate::error::DisassociateAwsAccountFromPartnerAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_aws_account_from_partner_account_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_aws_account_from_partner_account_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateMulticastGroupFromFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_multicast_group_from_fuota_task`](crate::client::Client::disassociate_multicast_group_from_fuota_task).
///
/// See [`crate::client::fluent_builders::DisassociateMulticastGroupFromFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMulticastGroupFromFuotaTask {
    _private: (),
}
impl DisassociateMulticastGroupFromFuotaTask {
    /// Creates a new builder-style object to manufacture [`DisassociateMulticastGroupFromFuotaTaskInput`](crate::input::DisassociateMulticastGroupFromFuotaTaskInput)
    pub fn builder() -> crate::input::disassociate_multicast_group_from_fuota_task_input::Builder {
        crate::input::disassociate_multicast_group_from_fuota_task_input::Builder::default()
    }
    /// Creates a new `DisassociateMulticastGroupFromFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMulticastGroupFromFuotaTask {
    type Output = std::result::Result<
        crate::output::DisassociateMulticastGroupFromFuotaTaskOutput,
        crate::error::DisassociateMulticastGroupFromFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_multicast_group_from_fuota_task_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_multicast_group_from_fuota_task_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateWirelessDeviceFromFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_wireless_device_from_fuota_task`](crate::client::Client::disassociate_wireless_device_from_fuota_task).
///
/// See [`crate::client::fluent_builders::DisassociateWirelessDeviceFromFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromFuotaTask {
    _private: (),
}
impl DisassociateWirelessDeviceFromFuotaTask {
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromFuotaTaskInput`](crate::input::DisassociateWirelessDeviceFromFuotaTaskInput)
    pub fn builder() -> crate::input::disassociate_wireless_device_from_fuota_task_input::Builder {
        crate::input::disassociate_wireless_device_from_fuota_task_input::Builder::default()
    }
    /// Creates a new `DisassociateWirelessDeviceFromFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWirelessDeviceFromFuotaTask {
    type Output = std::result::Result<
        crate::output::DisassociateWirelessDeviceFromFuotaTaskOutput,
        crate::error::DisassociateWirelessDeviceFromFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_wireless_device_from_fuota_task_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_wireless_device_from_fuota_task_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateWirelessDeviceFromMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_wireless_device_from_multicast_group`](crate::client::Client::disassociate_wireless_device_from_multicast_group).
///
/// See [`crate::client::fluent_builders::DisassociateWirelessDeviceFromMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromMulticastGroup {
    _private: (),
}
impl DisassociateWirelessDeviceFromMulticastGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::DisassociateWirelessDeviceFromMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::disassociate_wireless_device_from_multicast_group_input::Builder {
        crate::input::disassociate_wireless_device_from_multicast_group_input::Builder::default()
    }
    /// Creates a new `DisassociateWirelessDeviceFromMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DisassociateWirelessDeviceFromMulticastGroup
{
    type Output = std::result::Result<
        crate::output::DisassociateWirelessDeviceFromMulticastGroupOutput,
        crate::error::DisassociateWirelessDeviceFromMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_wireless_device_from_multicast_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_wireless_device_from_multicast_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateWirelessDeviceFromThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_wireless_device_from_thing`](crate::client::Client::disassociate_wireless_device_from_thing).
///
/// See [`crate::client::fluent_builders::DisassociateWirelessDeviceFromThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromThing {
    _private: (),
}
impl DisassociateWirelessDeviceFromThing {
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessDeviceFromThingInput`](crate::input::DisassociateWirelessDeviceFromThingInput)
    pub fn builder() -> crate::input::disassociate_wireless_device_from_thing_input::Builder {
        crate::input::disassociate_wireless_device_from_thing_input::Builder::default()
    }
    /// Creates a new `DisassociateWirelessDeviceFromThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWirelessDeviceFromThing {
    type Output = std::result::Result<
        crate::output::DisassociateWirelessDeviceFromThingOutput,
        crate::error::DisassociateWirelessDeviceFromThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_wireless_device_from_thing_error(response)
        } else {
            crate::operation_deser::parse_disassociate_wireless_device_from_thing_response(response)
        }
    }
}

/// Operation shape for `DisassociateWirelessGatewayFromCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_wireless_gateway_from_certificate`](crate::client::Client::disassociate_wireless_gateway_from_certificate).
///
/// See [`crate::client::fluent_builders::DisassociateWirelessGatewayFromCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWirelessGatewayFromCertificate {
    _private: (),
}
impl DisassociateWirelessGatewayFromCertificate {
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessGatewayFromCertificateInput`](crate::input::DisassociateWirelessGatewayFromCertificateInput)
    pub fn builder() -> crate::input::disassociate_wireless_gateway_from_certificate_input::Builder
    {
        crate::input::disassociate_wireless_gateway_from_certificate_input::Builder::default()
    }
    /// Creates a new `DisassociateWirelessGatewayFromCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWirelessGatewayFromCertificate {
    type Output = std::result::Result<
        crate::output::DisassociateWirelessGatewayFromCertificateOutput,
        crate::error::DisassociateWirelessGatewayFromCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_wireless_gateway_from_certificate_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_wireless_gateway_from_certificate_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateWirelessGatewayFromThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_wireless_gateway_from_thing`](crate::client::Client::disassociate_wireless_gateway_from_thing).
///
/// See [`crate::client::fluent_builders::DisassociateWirelessGatewayFromThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWirelessGatewayFromThing {
    _private: (),
}
impl DisassociateWirelessGatewayFromThing {
    /// Creates a new builder-style object to manufacture [`DisassociateWirelessGatewayFromThingInput`](crate::input::DisassociateWirelessGatewayFromThingInput)
    pub fn builder() -> crate::input::disassociate_wireless_gateway_from_thing_input::Builder {
        crate::input::disassociate_wireless_gateway_from_thing_input::Builder::default()
    }
    /// Creates a new `DisassociateWirelessGatewayFromThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWirelessGatewayFromThing {
    type Output = std::result::Result<
        crate::output::DisassociateWirelessGatewayFromThingOutput,
        crate::error::DisassociateWirelessGatewayFromThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_disassociate_wireless_gateway_from_thing_error(response)
        } else {
            crate::operation_deser::parse_disassociate_wireless_gateway_from_thing_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_destination`](crate::client::Client::get_destination).
///
/// See [`crate::client::fluent_builders::GetDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDestination {
    _private: (),
}
impl GetDestination {
    /// Creates a new builder-style object to manufacture [`GetDestinationInput`](crate::input::GetDestinationInput)
    pub fn builder() -> crate::input::get_destination_input::Builder {
        crate::input::get_destination_input::Builder::default()
    }
    /// Creates a new `GetDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDestination {
    type Output =
        std::result::Result<crate::output::GetDestinationOutput, crate::error::GetDestinationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_destination_error(response)
        } else {
            crate::operation_deser::parse_get_destination_response(response)
        }
    }
}

/// Operation shape for `GetDeviceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_profile`](crate::client::Client::get_device_profile).
///
/// See [`crate::client::fluent_builders::GetDeviceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceProfile {
    _private: (),
}
impl GetDeviceProfile {
    /// Creates a new builder-style object to manufacture [`GetDeviceProfileInput`](crate::input::GetDeviceProfileInput)
    pub fn builder() -> crate::input::get_device_profile_input::Builder {
        crate::input::get_device_profile_input::Builder::default()
    }
    /// Creates a new `GetDeviceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceProfile {
    type Output = std::result::Result<
        crate::output::GetDeviceProfileOutput,
        crate::error::GetDeviceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_profile_error(response)
        } else {
            crate::operation_deser::parse_get_device_profile_response(response)
        }
    }
}

/// Operation shape for `GetFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_fuota_task`](crate::client::Client::get_fuota_task).
///
/// See [`crate::client::fluent_builders::GetFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFuotaTask {
    _private: (),
}
impl GetFuotaTask {
    /// Creates a new builder-style object to manufacture [`GetFuotaTaskInput`](crate::input::GetFuotaTaskInput)
    pub fn builder() -> crate::input::get_fuota_task_input::Builder {
        crate::input::get_fuota_task_input::Builder::default()
    }
    /// Creates a new `GetFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFuotaTask {
    type Output =
        std::result::Result<crate::output::GetFuotaTaskOutput, crate::error::GetFuotaTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_get_fuota_task_response(response)
        }
    }
}

/// Operation shape for `GetLogLevelsByResourceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_log_levels_by_resource_types`](crate::client::Client::get_log_levels_by_resource_types).
///
/// See [`crate::client::fluent_builders::GetLogLevelsByResourceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLogLevelsByResourceTypes {
    _private: (),
}
impl GetLogLevelsByResourceTypes {
    /// Creates a new builder-style object to manufacture [`GetLogLevelsByResourceTypesInput`](crate::input::GetLogLevelsByResourceTypesInput)
    pub fn builder() -> crate::input::get_log_levels_by_resource_types_input::Builder {
        crate::input::get_log_levels_by_resource_types_input::Builder::default()
    }
    /// Creates a new `GetLogLevelsByResourceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLogLevelsByResourceTypes {
    type Output = std::result::Result<
        crate::output::GetLogLevelsByResourceTypesOutput,
        crate::error::GetLogLevelsByResourceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_log_levels_by_resource_types_error(response)
        } else {
            crate::operation_deser::parse_get_log_levels_by_resource_types_response(response)
        }
    }
}

/// Operation shape for `GetMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_multicast_group`](crate::client::Client::get_multicast_group).
///
/// See [`crate::client::fluent_builders::GetMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMulticastGroup {
    _private: (),
}
impl GetMulticastGroup {
    /// Creates a new builder-style object to manufacture [`GetMulticastGroupInput`](crate::input::GetMulticastGroupInput)
    pub fn builder() -> crate::input::get_multicast_group_input::Builder {
        crate::input::get_multicast_group_input::Builder::default()
    }
    /// Creates a new `GetMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMulticastGroup {
    type Output = std::result::Result<
        crate::output::GetMulticastGroupOutput,
        crate::error::GetMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_get_multicast_group_response(response)
        }
    }
}

/// Operation shape for `GetMulticastGroupSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_multicast_group_session`](crate::client::Client::get_multicast_group_session).
///
/// See [`crate::client::fluent_builders::GetMulticastGroupSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMulticastGroupSession {
    _private: (),
}
impl GetMulticastGroupSession {
    /// Creates a new builder-style object to manufacture [`GetMulticastGroupSessionInput`](crate::input::GetMulticastGroupSessionInput)
    pub fn builder() -> crate::input::get_multicast_group_session_input::Builder {
        crate::input::get_multicast_group_session_input::Builder::default()
    }
    /// Creates a new `GetMulticastGroupSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMulticastGroupSession {
    type Output = std::result::Result<
        crate::output::GetMulticastGroupSessionOutput,
        crate::error::GetMulticastGroupSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_multicast_group_session_error(response)
        } else {
            crate::operation_deser::parse_get_multicast_group_session_response(response)
        }
    }
}

/// Operation shape for `GetNetworkAnalyzerConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_analyzer_configuration`](crate::client::Client::get_network_analyzer_configuration).
///
/// See [`crate::client::fluent_builders::GetNetworkAnalyzerConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkAnalyzerConfiguration {
    _private: (),
}
impl GetNetworkAnalyzerConfiguration {
    /// Creates a new builder-style object to manufacture [`GetNetworkAnalyzerConfigurationInput`](crate::input::GetNetworkAnalyzerConfigurationInput)
    pub fn builder() -> crate::input::get_network_analyzer_configuration_input::Builder {
        crate::input::get_network_analyzer_configuration_input::Builder::default()
    }
    /// Creates a new `GetNetworkAnalyzerConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkAnalyzerConfiguration {
    type Output = std::result::Result<
        crate::output::GetNetworkAnalyzerConfigurationOutput,
        crate::error::GetNetworkAnalyzerConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_analyzer_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_network_analyzer_configuration_response(response)
        }
    }
}

/// Operation shape for `GetPartnerAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_partner_account`](crate::client::Client::get_partner_account).
///
/// See [`crate::client::fluent_builders::GetPartnerAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPartnerAccount {
    _private: (),
}
impl GetPartnerAccount {
    /// Creates a new builder-style object to manufacture [`GetPartnerAccountInput`](crate::input::GetPartnerAccountInput)
    pub fn builder() -> crate::input::get_partner_account_input::Builder {
        crate::input::get_partner_account_input::Builder::default()
    }
    /// Creates a new `GetPartnerAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPartnerAccount {
    type Output = std::result::Result<
        crate::output::GetPartnerAccountOutput,
        crate::error::GetPartnerAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_partner_account_error(response)
        } else {
            crate::operation_deser::parse_get_partner_account_response(response)
        }
    }
}

/// Operation shape for `GetResourceEventConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_event_configuration`](crate::client::Client::get_resource_event_configuration).
///
/// See [`crate::client::fluent_builders::GetResourceEventConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceEventConfiguration {
    _private: (),
}
impl GetResourceEventConfiguration {
    /// Creates a new builder-style object to manufacture [`GetResourceEventConfigurationInput`](crate::input::GetResourceEventConfigurationInput)
    pub fn builder() -> crate::input::get_resource_event_configuration_input::Builder {
        crate::input::get_resource_event_configuration_input::Builder::default()
    }
    /// Creates a new `GetResourceEventConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceEventConfiguration {
    type Output = std::result::Result<
        crate::output::GetResourceEventConfigurationOutput,
        crate::error::GetResourceEventConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_event_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_resource_event_configuration_response(response)
        }
    }
}

/// Operation shape for `GetResourceLogLevel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_log_level`](crate::client::Client::get_resource_log_level).
///
/// See [`crate::client::fluent_builders::GetResourceLogLevel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceLogLevel {
    _private: (),
}
impl GetResourceLogLevel {
    /// Creates a new builder-style object to manufacture [`GetResourceLogLevelInput`](crate::input::GetResourceLogLevelInput)
    pub fn builder() -> crate::input::get_resource_log_level_input::Builder {
        crate::input::get_resource_log_level_input::Builder::default()
    }
    /// Creates a new `GetResourceLogLevel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceLogLevel {
    type Output = std::result::Result<
        crate::output::GetResourceLogLevelOutput,
        crate::error::GetResourceLogLevelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_log_level_error(response)
        } else {
            crate::operation_deser::parse_get_resource_log_level_response(response)
        }
    }
}

/// Operation shape for `GetServiceEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_endpoint`](crate::client::Client::get_service_endpoint).
///
/// See [`crate::client::fluent_builders::GetServiceEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceEndpoint {
    _private: (),
}
impl GetServiceEndpoint {
    /// Creates a new builder-style object to manufacture [`GetServiceEndpointInput`](crate::input::GetServiceEndpointInput)
    pub fn builder() -> crate::input::get_service_endpoint_input::Builder {
        crate::input::get_service_endpoint_input::Builder::default()
    }
    /// Creates a new `GetServiceEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceEndpoint {
    type Output = std::result::Result<
        crate::output::GetServiceEndpointOutput,
        crate::error::GetServiceEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_service_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetServiceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_profile`](crate::client::Client::get_service_profile).
///
/// See [`crate::client::fluent_builders::GetServiceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceProfile {
    _private: (),
}
impl GetServiceProfile {
    /// Creates a new builder-style object to manufacture [`GetServiceProfileInput`](crate::input::GetServiceProfileInput)
    pub fn builder() -> crate::input::get_service_profile_input::Builder {
        crate::input::get_service_profile_input::Builder::default()
    }
    /// Creates a new `GetServiceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceProfile {
    type Output = std::result::Result<
        crate::output::GetServiceProfileOutput,
        crate::error::GetServiceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_profile_error(response)
        } else {
            crate::operation_deser::parse_get_service_profile_response(response)
        }
    }
}

/// Operation shape for `GetWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_device`](crate::client::Client::get_wireless_device).
///
/// See [`crate::client::fluent_builders::GetWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessDevice {
    _private: (),
}
impl GetWirelessDevice {
    /// Creates a new builder-style object to manufacture [`GetWirelessDeviceInput`](crate::input::GetWirelessDeviceInput)
    pub fn builder() -> crate::input::get_wireless_device_input::Builder {
        crate::input::get_wireless_device_input::Builder::default()
    }
    /// Creates a new `GetWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessDevice {
    type Output = std::result::Result<
        crate::output::GetWirelessDeviceOutput,
        crate::error::GetWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_device_response(response)
        }
    }
}

/// Operation shape for `GetWirelessDeviceStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_device_statistics`](crate::client::Client::get_wireless_device_statistics).
///
/// See [`crate::client::fluent_builders::GetWirelessDeviceStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessDeviceStatistics {
    _private: (),
}
impl GetWirelessDeviceStatistics {
    /// Creates a new builder-style object to manufacture [`GetWirelessDeviceStatisticsInput`](crate::input::GetWirelessDeviceStatisticsInput)
    pub fn builder() -> crate::input::get_wireless_device_statistics_input::Builder {
        crate::input::get_wireless_device_statistics_input::Builder::default()
    }
    /// Creates a new `GetWirelessDeviceStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessDeviceStatistics {
    type Output = std::result::Result<
        crate::output::GetWirelessDeviceStatisticsOutput,
        crate::error::GetWirelessDeviceStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_device_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_device_statistics_response(response)
        }
    }
}

/// Operation shape for `GetWirelessGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway`](crate::client::Client::get_wireless_gateway).
///
/// See [`crate::client::fluent_builders::GetWirelessGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGateway {
    _private: (),
}
impl GetWirelessGateway {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayInput`](crate::input::GetWirelessGatewayInput)
    pub fn builder() -> crate::input::get_wireless_gateway_input::Builder {
        crate::input::get_wireless_gateway_input::Builder::default()
    }
    /// Creates a new `GetWirelessGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGateway {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayOutput,
        crate::error::GetWirelessGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_response(response)
        }
    }
}

/// Operation shape for `GetWirelessGatewayCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway_certificate`](crate::client::Client::get_wireless_gateway_certificate).
///
/// See [`crate::client::fluent_builders::GetWirelessGatewayCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGatewayCertificate {
    _private: (),
}
impl GetWirelessGatewayCertificate {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayCertificateInput`](crate::input::GetWirelessGatewayCertificateInput)
    pub fn builder() -> crate::input::get_wireless_gateway_certificate_input::Builder {
        crate::input::get_wireless_gateway_certificate_input::Builder::default()
    }
    /// Creates a new `GetWirelessGatewayCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGatewayCertificate {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayCertificateOutput,
        crate::error::GetWirelessGatewayCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_certificate_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_certificate_response(response)
        }
    }
}

/// Operation shape for `GetWirelessGatewayFirmwareInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway_firmware_information`](crate::client::Client::get_wireless_gateway_firmware_information).
///
/// See [`crate::client::fluent_builders::GetWirelessGatewayFirmwareInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGatewayFirmwareInformation {
    _private: (),
}
impl GetWirelessGatewayFirmwareInformation {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayFirmwareInformationInput`](crate::input::GetWirelessGatewayFirmwareInformationInput)
    pub fn builder() -> crate::input::get_wireless_gateway_firmware_information_input::Builder {
        crate::input::get_wireless_gateway_firmware_information_input::Builder::default()
    }
    /// Creates a new `GetWirelessGatewayFirmwareInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGatewayFirmwareInformation {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayFirmwareInformationOutput,
        crate::error::GetWirelessGatewayFirmwareInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_firmware_information_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_firmware_information_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetWirelessGatewayStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway_statistics`](crate::client::Client::get_wireless_gateway_statistics).
///
/// See [`crate::client::fluent_builders::GetWirelessGatewayStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGatewayStatistics {
    _private: (),
}
impl GetWirelessGatewayStatistics {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayStatisticsInput`](crate::input::GetWirelessGatewayStatisticsInput)
    pub fn builder() -> crate::input::get_wireless_gateway_statistics_input::Builder {
        crate::input::get_wireless_gateway_statistics_input::Builder::default()
    }
    /// Creates a new `GetWirelessGatewayStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGatewayStatistics {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayStatisticsOutput,
        crate::error::GetWirelessGatewayStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_statistics_response(response)
        }
    }
}

/// Operation shape for `GetWirelessGatewayTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway_task`](crate::client::Client::get_wireless_gateway_task).
///
/// See [`crate::client::fluent_builders::GetWirelessGatewayTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGatewayTask {
    _private: (),
}
impl GetWirelessGatewayTask {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayTaskInput`](crate::input::GetWirelessGatewayTaskInput)
    pub fn builder() -> crate::input::get_wireless_gateway_task_input::Builder {
        crate::input::get_wireless_gateway_task_input::Builder::default()
    }
    /// Creates a new `GetWirelessGatewayTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGatewayTask {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayTaskOutput,
        crate::error::GetWirelessGatewayTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_task_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_task_response(response)
        }
    }
}

/// Operation shape for `GetWirelessGatewayTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_wireless_gateway_task_definition`](crate::client::Client::get_wireless_gateway_task_definition).
///
/// See [`crate::client::fluent_builders::GetWirelessGatewayTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWirelessGatewayTaskDefinition {
    _private: (),
}
impl GetWirelessGatewayTaskDefinition {
    /// Creates a new builder-style object to manufacture [`GetWirelessGatewayTaskDefinitionInput`](crate::input::GetWirelessGatewayTaskDefinitionInput)
    pub fn builder() -> crate::input::get_wireless_gateway_task_definition_input::Builder {
        crate::input::get_wireless_gateway_task_definition_input::Builder::default()
    }
    /// Creates a new `GetWirelessGatewayTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWirelessGatewayTaskDefinition {
    type Output = std::result::Result<
        crate::output::GetWirelessGatewayTaskDefinitionOutput,
        crate::error::GetWirelessGatewayTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_wireless_gateway_task_definition_error(response)
        } else {
            crate::operation_deser::parse_get_wireless_gateway_task_definition_response(response)
        }
    }
}

/// Operation shape for `ListDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_destinations`](crate::client::Client::list_destinations).
///
/// See [`crate::client::fluent_builders::ListDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDestinations {
    _private: (),
}
impl ListDestinations {
    /// Creates a new builder-style object to manufacture [`ListDestinationsInput`](crate::input::ListDestinationsInput)
    pub fn builder() -> crate::input::list_destinations_input::Builder {
        crate::input::list_destinations_input::Builder::default()
    }
    /// Creates a new `ListDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDestinations {
    type Output = std::result::Result<
        crate::output::ListDestinationsOutput,
        crate::error::ListDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_destinations_error(response)
        } else {
            crate::operation_deser::parse_list_destinations_response(response)
        }
    }
}

/// Operation shape for `ListDeviceProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_profiles`](crate::client::Client::list_device_profiles).
///
/// See [`crate::client::fluent_builders::ListDeviceProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceProfiles {
    _private: (),
}
impl ListDeviceProfiles {
    /// Creates a new builder-style object to manufacture [`ListDeviceProfilesInput`](crate::input::ListDeviceProfilesInput)
    pub fn builder() -> crate::input::list_device_profiles_input::Builder {
        crate::input::list_device_profiles_input::Builder::default()
    }
    /// Creates a new `ListDeviceProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceProfiles {
    type Output = std::result::Result<
        crate::output::ListDeviceProfilesOutput,
        crate::error::ListDeviceProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_device_profiles_response(response)
        }
    }
}

/// Operation shape for `ListFuotaTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fuota_tasks`](crate::client::Client::list_fuota_tasks).
///
/// See [`crate::client::fluent_builders::ListFuotaTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFuotaTasks {
    _private: (),
}
impl ListFuotaTasks {
    /// Creates a new builder-style object to manufacture [`ListFuotaTasksInput`](crate::input::ListFuotaTasksInput)
    pub fn builder() -> crate::input::list_fuota_tasks_input::Builder {
        crate::input::list_fuota_tasks_input::Builder::default()
    }
    /// Creates a new `ListFuotaTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFuotaTasks {
    type Output =
        std::result::Result<crate::output::ListFuotaTasksOutput, crate::error::ListFuotaTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fuota_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_fuota_tasks_response(response)
        }
    }
}

/// Operation shape for `ListMulticastGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multicast_groups`](crate::client::Client::list_multicast_groups).
///
/// See [`crate::client::fluent_builders::ListMulticastGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMulticastGroups {
    _private: (),
}
impl ListMulticastGroups {
    /// Creates a new builder-style object to manufacture [`ListMulticastGroupsInput`](crate::input::ListMulticastGroupsInput)
    pub fn builder() -> crate::input::list_multicast_groups_input::Builder {
        crate::input::list_multicast_groups_input::Builder::default()
    }
    /// Creates a new `ListMulticastGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMulticastGroups {
    type Output = std::result::Result<
        crate::output::ListMulticastGroupsOutput,
        crate::error::ListMulticastGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multicast_groups_error(response)
        } else {
            crate::operation_deser::parse_list_multicast_groups_response(response)
        }
    }
}

/// Operation shape for `ListMulticastGroupsByFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multicast_groups_by_fuota_task`](crate::client::Client::list_multicast_groups_by_fuota_task).
///
/// See [`crate::client::fluent_builders::ListMulticastGroupsByFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMulticastGroupsByFuotaTask {
    _private: (),
}
impl ListMulticastGroupsByFuotaTask {
    /// Creates a new builder-style object to manufacture [`ListMulticastGroupsByFuotaTaskInput`](crate::input::ListMulticastGroupsByFuotaTaskInput)
    pub fn builder() -> crate::input::list_multicast_groups_by_fuota_task_input::Builder {
        crate::input::list_multicast_groups_by_fuota_task_input::Builder::default()
    }
    /// Creates a new `ListMulticastGroupsByFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMulticastGroupsByFuotaTask {
    type Output = std::result::Result<
        crate::output::ListMulticastGroupsByFuotaTaskOutput,
        crate::error::ListMulticastGroupsByFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multicast_groups_by_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_list_multicast_groups_by_fuota_task_response(response)
        }
    }
}

/// Operation shape for `ListPartnerAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_partner_accounts`](crate::client::Client::list_partner_accounts).
///
/// See [`crate::client::fluent_builders::ListPartnerAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPartnerAccounts {
    _private: (),
}
impl ListPartnerAccounts {
    /// Creates a new builder-style object to manufacture [`ListPartnerAccountsInput`](crate::input::ListPartnerAccountsInput)
    pub fn builder() -> crate::input::list_partner_accounts_input::Builder {
        crate::input::list_partner_accounts_input::Builder::default()
    }
    /// Creates a new `ListPartnerAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPartnerAccounts {
    type Output = std::result::Result<
        crate::output::ListPartnerAccountsOutput,
        crate::error::ListPartnerAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_partner_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_partner_accounts_response(response)
        }
    }
}

/// Operation shape for `ListServiceProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_profiles`](crate::client::Client::list_service_profiles).
///
/// See [`crate::client::fluent_builders::ListServiceProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceProfiles {
    _private: (),
}
impl ListServiceProfiles {
    /// Creates a new builder-style object to manufacture [`ListServiceProfilesInput`](crate::input::ListServiceProfilesInput)
    pub fn builder() -> crate::input::list_service_profiles_input::Builder {
        crate::input::list_service_profiles_input::Builder::default()
    }
    /// Creates a new `ListServiceProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceProfiles {
    type Output = std::result::Result<
        crate::output::ListServiceProfilesOutput,
        crate::error::ListServiceProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_service_profiles_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWirelessDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_wireless_devices`](crate::client::Client::list_wireless_devices).
///
/// See [`crate::client::fluent_builders::ListWirelessDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWirelessDevices {
    _private: (),
}
impl ListWirelessDevices {
    /// Creates a new builder-style object to manufacture [`ListWirelessDevicesInput`](crate::input::ListWirelessDevicesInput)
    pub fn builder() -> crate::input::list_wireless_devices_input::Builder {
        crate::input::list_wireless_devices_input::Builder::default()
    }
    /// Creates a new `ListWirelessDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWirelessDevices {
    type Output = std::result::Result<
        crate::output::ListWirelessDevicesOutput,
        crate::error::ListWirelessDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_wireless_devices_error(response)
        } else {
            crate::operation_deser::parse_list_wireless_devices_response(response)
        }
    }
}

/// Operation shape for `ListWirelessGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_wireless_gateways`](crate::client::Client::list_wireless_gateways).
///
/// See [`crate::client::fluent_builders::ListWirelessGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWirelessGateways {
    _private: (),
}
impl ListWirelessGateways {
    /// Creates a new builder-style object to manufacture [`ListWirelessGatewaysInput`](crate::input::ListWirelessGatewaysInput)
    pub fn builder() -> crate::input::list_wireless_gateways_input::Builder {
        crate::input::list_wireless_gateways_input::Builder::default()
    }
    /// Creates a new `ListWirelessGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWirelessGateways {
    type Output = std::result::Result<
        crate::output::ListWirelessGatewaysOutput,
        crate::error::ListWirelessGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_wireless_gateways_error(response)
        } else {
            crate::operation_deser::parse_list_wireless_gateways_response(response)
        }
    }
}

/// Operation shape for `ListWirelessGatewayTaskDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_wireless_gateway_task_definitions`](crate::client::Client::list_wireless_gateway_task_definitions).
///
/// See [`crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWirelessGatewayTaskDefinitions {
    _private: (),
}
impl ListWirelessGatewayTaskDefinitions {
    /// Creates a new builder-style object to manufacture [`ListWirelessGatewayTaskDefinitionsInput`](crate::input::ListWirelessGatewayTaskDefinitionsInput)
    pub fn builder() -> crate::input::list_wireless_gateway_task_definitions_input::Builder {
        crate::input::list_wireless_gateway_task_definitions_input::Builder::default()
    }
    /// Creates a new `ListWirelessGatewayTaskDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWirelessGatewayTaskDefinitions {
    type Output = std::result::Result<
        crate::output::ListWirelessGatewayTaskDefinitionsOutput,
        crate::error::ListWirelessGatewayTaskDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_wireless_gateway_task_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_wireless_gateway_task_definitions_response(response)
        }
    }
}

/// Operation shape for `PutResourceLogLevel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_log_level`](crate::client::Client::put_resource_log_level).
///
/// See [`crate::client::fluent_builders::PutResourceLogLevel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourceLogLevel {
    _private: (),
}
impl PutResourceLogLevel {
    /// Creates a new builder-style object to manufacture [`PutResourceLogLevelInput`](crate::input::PutResourceLogLevelInput)
    pub fn builder() -> crate::input::put_resource_log_level_input::Builder {
        crate::input::put_resource_log_level_input::Builder::default()
    }
    /// Creates a new `PutResourceLogLevel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourceLogLevel {
    type Output = std::result::Result<
        crate::output::PutResourceLogLevelOutput,
        crate::error::PutResourceLogLevelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_log_level_error(response)
        } else {
            crate::operation_deser::parse_put_resource_log_level_response(response)
        }
    }
}

/// Operation shape for `ResetAllResourceLogLevels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_all_resource_log_levels`](crate::client::Client::reset_all_resource_log_levels).
///
/// See [`crate::client::fluent_builders::ResetAllResourceLogLevels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetAllResourceLogLevels {
    _private: (),
}
impl ResetAllResourceLogLevels {
    /// Creates a new builder-style object to manufacture [`ResetAllResourceLogLevelsInput`](crate::input::ResetAllResourceLogLevelsInput)
    pub fn builder() -> crate::input::reset_all_resource_log_levels_input::Builder {
        crate::input::reset_all_resource_log_levels_input::Builder::default()
    }
    /// Creates a new `ResetAllResourceLogLevels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetAllResourceLogLevels {
    type Output = std::result::Result<
        crate::output::ResetAllResourceLogLevelsOutput,
        crate::error::ResetAllResourceLogLevelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_reset_all_resource_log_levels_error(response)
        } else {
            crate::operation_deser::parse_reset_all_resource_log_levels_response(response)
        }
    }
}

/// Operation shape for `ResetResourceLogLevel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_resource_log_level`](crate::client::Client::reset_resource_log_level).
///
/// See [`crate::client::fluent_builders::ResetResourceLogLevel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetResourceLogLevel {
    _private: (),
}
impl ResetResourceLogLevel {
    /// Creates a new builder-style object to manufacture [`ResetResourceLogLevelInput`](crate::input::ResetResourceLogLevelInput)
    pub fn builder() -> crate::input::reset_resource_log_level_input::Builder {
        crate::input::reset_resource_log_level_input::Builder::default()
    }
    /// Creates a new `ResetResourceLogLevel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetResourceLogLevel {
    type Output = std::result::Result<
        crate::output::ResetResourceLogLevelOutput,
        crate::error::ResetResourceLogLevelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_reset_resource_log_level_error(response)
        } else {
            crate::operation_deser::parse_reset_resource_log_level_response(response)
        }
    }
}

/// Operation shape for `SendDataToMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_data_to_multicast_group`](crate::client::Client::send_data_to_multicast_group).
///
/// See [`crate::client::fluent_builders::SendDataToMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendDataToMulticastGroup {
    _private: (),
}
impl SendDataToMulticastGroup {
    /// Creates a new builder-style object to manufacture [`SendDataToMulticastGroupInput`](crate::input::SendDataToMulticastGroupInput)
    pub fn builder() -> crate::input::send_data_to_multicast_group_input::Builder {
        crate::input::send_data_to_multicast_group_input::Builder::default()
    }
    /// Creates a new `SendDataToMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendDataToMulticastGroup {
    type Output = std::result::Result<
        crate::output::SendDataToMulticastGroupOutput,
        crate::error::SendDataToMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_send_data_to_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_send_data_to_multicast_group_response(response)
        }
    }
}

/// Operation shape for `SendDataToWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_data_to_wireless_device`](crate::client::Client::send_data_to_wireless_device).
///
/// See [`crate::client::fluent_builders::SendDataToWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendDataToWirelessDevice {
    _private: (),
}
impl SendDataToWirelessDevice {
    /// Creates a new builder-style object to manufacture [`SendDataToWirelessDeviceInput`](crate::input::SendDataToWirelessDeviceInput)
    pub fn builder() -> crate::input::send_data_to_wireless_device_input::Builder {
        crate::input::send_data_to_wireless_device_input::Builder::default()
    }
    /// Creates a new `SendDataToWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendDataToWirelessDevice {
    type Output = std::result::Result<
        crate::output::SendDataToWirelessDeviceOutput,
        crate::error::SendDataToWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_send_data_to_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_send_data_to_wireless_device_response(response)
        }
    }
}

/// Operation shape for `StartBulkAssociateWirelessDeviceWithMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_bulk_associate_wireless_device_with_multicast_group`](crate::client::Client::start_bulk_associate_wireless_device_with_multicast_group).
///
/// See [`crate::client::fluent_builders::StartBulkAssociateWirelessDeviceWithMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBulkAssociateWirelessDeviceWithMulticastGroup {
    _private: (),
}
impl StartBulkAssociateWirelessDeviceWithMulticastGroup {
    /// Creates a new builder-style object to manufacture [`StartBulkAssociateWirelessDeviceWithMulticastGroupInput`](crate::input::StartBulkAssociateWirelessDeviceWithMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::start_bulk_associate_wireless_device_with_multicast_group_input::Builder
    {
        crate::input::start_bulk_associate_wireless_device_with_multicast_group_input::Builder::default()
    }
    /// Creates a new `StartBulkAssociateWirelessDeviceWithMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for StartBulkAssociateWirelessDeviceWithMulticastGroup
{
    type Output = std::result::Result<
        crate::output::StartBulkAssociateWirelessDeviceWithMulticastGroupOutput,
        crate::error::StartBulkAssociateWirelessDeviceWithMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_start_bulk_associate_wireless_device_with_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_start_bulk_associate_wireless_device_with_multicast_group_response(response)
        }
    }
}

/// Operation shape for `StartBulkDisassociateWirelessDeviceFromMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_bulk_disassociate_wireless_device_from_multicast_group`](crate::client::Client::start_bulk_disassociate_wireless_device_from_multicast_group).
///
/// See [`crate::client::fluent_builders::StartBulkDisassociateWirelessDeviceFromMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBulkDisassociateWirelessDeviceFromMulticastGroup {
    _private: (),
}
impl StartBulkDisassociateWirelessDeviceFromMulticastGroup {
    /// Creates a new builder-style object to manufacture [`StartBulkDisassociateWirelessDeviceFromMulticastGroupInput`](crate::input::StartBulkDisassociateWirelessDeviceFromMulticastGroupInput)
    pub fn builder(
    ) -> crate::input::start_bulk_disassociate_wireless_device_from_multicast_group_input::Builder
    {
        crate::input::start_bulk_disassociate_wireless_device_from_multicast_group_input::Builder::default()
    }
    /// Creates a new `StartBulkDisassociateWirelessDeviceFromMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for StartBulkDisassociateWirelessDeviceFromMulticastGroup
{
    type Output = std::result::Result<
        crate::output::StartBulkDisassociateWirelessDeviceFromMulticastGroupOutput,
        crate::error::StartBulkDisassociateWirelessDeviceFromMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_start_bulk_disassociate_wireless_device_from_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_start_bulk_disassociate_wireless_device_from_multicast_group_response(response)
        }
    }
}

/// Operation shape for `StartFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_fuota_task`](crate::client::Client::start_fuota_task).
///
/// See [`crate::client::fluent_builders::StartFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFuotaTask {
    _private: (),
}
impl StartFuotaTask {
    /// Creates a new builder-style object to manufacture [`StartFuotaTaskInput`](crate::input::StartFuotaTaskInput)
    pub fn builder() -> crate::input::start_fuota_task_input::Builder {
        crate::input::start_fuota_task_input::Builder::default()
    }
    /// Creates a new `StartFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFuotaTask {
    type Output =
        std::result::Result<crate::output::StartFuotaTaskOutput, crate::error::StartFuotaTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_start_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_start_fuota_task_response(response)
        }
    }
}

/// Operation shape for `StartMulticastGroupSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_multicast_group_session`](crate::client::Client::start_multicast_group_session).
///
/// See [`crate::client::fluent_builders::StartMulticastGroupSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMulticastGroupSession {
    _private: (),
}
impl StartMulticastGroupSession {
    /// Creates a new builder-style object to manufacture [`StartMulticastGroupSessionInput`](crate::input::StartMulticastGroupSessionInput)
    pub fn builder() -> crate::input::start_multicast_group_session_input::Builder {
        crate::input::start_multicast_group_session_input::Builder::default()
    }
    /// Creates a new `StartMulticastGroupSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMulticastGroupSession {
    type Output = std::result::Result<
        crate::output::StartMulticastGroupSessionOutput,
        crate::error::StartMulticastGroupSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_start_multicast_group_session_error(response)
        } else {
            crate::operation_deser::parse_start_multicast_group_session_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_wireless_device`](crate::client::Client::test_wireless_device).
///
/// See [`crate::client::fluent_builders::TestWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestWirelessDevice {
    _private: (),
}
impl TestWirelessDevice {
    /// Creates a new builder-style object to manufacture [`TestWirelessDeviceInput`](crate::input::TestWirelessDeviceInput)
    pub fn builder() -> crate::input::test_wireless_device_input::Builder {
        crate::input::test_wireless_device_input::Builder::default()
    }
    /// Creates a new `TestWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestWirelessDevice {
    type Output = std::result::Result<
        crate::output::TestWirelessDeviceOutput,
        crate::error::TestWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_test_wireless_device_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_destination`](crate::client::Client::update_destination).
///
/// See [`crate::client::fluent_builders::UpdateDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDestination {
    _private: (),
}
impl UpdateDestination {
    /// Creates a new builder-style object to manufacture [`UpdateDestinationInput`](crate::input::UpdateDestinationInput)
    pub fn builder() -> crate::input::update_destination_input::Builder {
        crate::input::update_destination_input::Builder::default()
    }
    /// Creates a new `UpdateDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDestination {
    type Output = std::result::Result<
        crate::output::UpdateDestinationOutput,
        crate::error::UpdateDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_destination_error(response)
        } else {
            crate::operation_deser::parse_update_destination_response(response)
        }
    }
}

/// Operation shape for `UpdateFuotaTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fuota_task`](crate::client::Client::update_fuota_task).
///
/// See [`crate::client::fluent_builders::UpdateFuotaTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFuotaTask {
    _private: (),
}
impl UpdateFuotaTask {
    /// Creates a new builder-style object to manufacture [`UpdateFuotaTaskInput`](crate::input::UpdateFuotaTaskInput)
    pub fn builder() -> crate::input::update_fuota_task_input::Builder {
        crate::input::update_fuota_task_input::Builder::default()
    }
    /// Creates a new `UpdateFuotaTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFuotaTask {
    type Output = std::result::Result<
        crate::output::UpdateFuotaTaskOutput,
        crate::error::UpdateFuotaTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_fuota_task_error(response)
        } else {
            crate::operation_deser::parse_update_fuota_task_response(response)
        }
    }
}

/// Operation shape for `UpdateLogLevelsByResourceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_log_levels_by_resource_types`](crate::client::Client::update_log_levels_by_resource_types).
///
/// See [`crate::client::fluent_builders::UpdateLogLevelsByResourceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLogLevelsByResourceTypes {
    _private: (),
}
impl UpdateLogLevelsByResourceTypes {
    /// Creates a new builder-style object to manufacture [`UpdateLogLevelsByResourceTypesInput`](crate::input::UpdateLogLevelsByResourceTypesInput)
    pub fn builder() -> crate::input::update_log_levels_by_resource_types_input::Builder {
        crate::input::update_log_levels_by_resource_types_input::Builder::default()
    }
    /// Creates a new `UpdateLogLevelsByResourceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLogLevelsByResourceTypes {
    type Output = std::result::Result<
        crate::output::UpdateLogLevelsByResourceTypesOutput,
        crate::error::UpdateLogLevelsByResourceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_log_levels_by_resource_types_error(response)
        } else {
            crate::operation_deser::parse_update_log_levels_by_resource_types_response(response)
        }
    }
}

/// Operation shape for `UpdateMulticastGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_multicast_group`](crate::client::Client::update_multicast_group).
///
/// See [`crate::client::fluent_builders::UpdateMulticastGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMulticastGroup {
    _private: (),
}
impl UpdateMulticastGroup {
    /// Creates a new builder-style object to manufacture [`UpdateMulticastGroupInput`](crate::input::UpdateMulticastGroupInput)
    pub fn builder() -> crate::input::update_multicast_group_input::Builder {
        crate::input::update_multicast_group_input::Builder::default()
    }
    /// Creates a new `UpdateMulticastGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMulticastGroup {
    type Output = std::result::Result<
        crate::output::UpdateMulticastGroupOutput,
        crate::error::UpdateMulticastGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_multicast_group_error(response)
        } else {
            crate::operation_deser::parse_update_multicast_group_response(response)
        }
    }
}

/// Operation shape for `UpdateNetworkAnalyzerConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_network_analyzer_configuration`](crate::client::Client::update_network_analyzer_configuration).
///
/// See [`crate::client::fluent_builders::UpdateNetworkAnalyzerConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNetworkAnalyzerConfiguration {
    _private: (),
}
impl UpdateNetworkAnalyzerConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateNetworkAnalyzerConfigurationInput`](crate::input::UpdateNetworkAnalyzerConfigurationInput)
    pub fn builder() -> crate::input::update_network_analyzer_configuration_input::Builder {
        crate::input::update_network_analyzer_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateNetworkAnalyzerConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNetworkAnalyzerConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateNetworkAnalyzerConfigurationOutput,
        crate::error::UpdateNetworkAnalyzerConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_network_analyzer_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_network_analyzer_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdatePartnerAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_partner_account`](crate::client::Client::update_partner_account).
///
/// See [`crate::client::fluent_builders::UpdatePartnerAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePartnerAccount {
    _private: (),
}
impl UpdatePartnerAccount {
    /// Creates a new builder-style object to manufacture [`UpdatePartnerAccountInput`](crate::input::UpdatePartnerAccountInput)
    pub fn builder() -> crate::input::update_partner_account_input::Builder {
        crate::input::update_partner_account_input::Builder::default()
    }
    /// Creates a new `UpdatePartnerAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePartnerAccount {
    type Output = std::result::Result<
        crate::output::UpdatePartnerAccountOutput,
        crate::error::UpdatePartnerAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_partner_account_error(response)
        } else {
            crate::operation_deser::parse_update_partner_account_response(response)
        }
    }
}

/// Operation shape for `UpdateResourceEventConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_event_configuration`](crate::client::Client::update_resource_event_configuration).
///
/// See [`crate::client::fluent_builders::UpdateResourceEventConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourceEventConfiguration {
    _private: (),
}
impl UpdateResourceEventConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateResourceEventConfigurationInput`](crate::input::UpdateResourceEventConfigurationInput)
    pub fn builder() -> crate::input::update_resource_event_configuration_input::Builder {
        crate::input::update_resource_event_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateResourceEventConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourceEventConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateResourceEventConfigurationOutput,
        crate::error::UpdateResourceEventConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_resource_event_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_resource_event_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateWirelessDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_wireless_device`](crate::client::Client::update_wireless_device).
///
/// See [`crate::client::fluent_builders::UpdateWirelessDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWirelessDevice {
    _private: (),
}
impl UpdateWirelessDevice {
    /// Creates a new builder-style object to manufacture [`UpdateWirelessDeviceInput`](crate::input::UpdateWirelessDeviceInput)
    pub fn builder() -> crate::input::update_wireless_device_input::Builder {
        crate::input::update_wireless_device_input::Builder::default()
    }
    /// Creates a new `UpdateWirelessDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWirelessDevice {
    type Output = std::result::Result<
        crate::output::UpdateWirelessDeviceOutput,
        crate::error::UpdateWirelessDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_wireless_device_error(response)
        } else {
            crate::operation_deser::parse_update_wireless_device_response(response)
        }
    }
}

/// Operation shape for `UpdateWirelessGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_wireless_gateway`](crate::client::Client::update_wireless_gateway).
///
/// See [`crate::client::fluent_builders::UpdateWirelessGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWirelessGateway {
    _private: (),
}
impl UpdateWirelessGateway {
    /// Creates a new builder-style object to manufacture [`UpdateWirelessGatewayInput`](crate::input::UpdateWirelessGatewayInput)
    pub fn builder() -> crate::input::update_wireless_gateway_input::Builder {
        crate::input::update_wireless_gateway_input::Builder::default()
    }
    /// Creates a new `UpdateWirelessGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWirelessGateway {
    type Output = std::result::Result<
        crate::output::UpdateWirelessGatewayOutput,
        crate::error::UpdateWirelessGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_update_wireless_gateway_error(response)
        } else {
            crate::operation_deser::parse_update_wireless_gateway_response(response)
        }
    }
}
