// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>LoRaWAN object for update functions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanUpdateDevice {
    /// <p>The ID of the device profile for the wireless device.</p>
    pub device_profile_id: std::option::Option<std::string::String>,
    /// <p>The ID of the service profile.</p>
    pub service_profile_id: std::option::Option<std::string::String>,
}
impl LoRaWanUpdateDevice {
    /// <p>The ID of the device profile for the wireless device.</p>
    pub fn device_profile_id(&self) -> std::option::Option<&str> {
        self.device_profile_id.as_deref()
    }
    /// <p>The ID of the service profile.</p>
    pub fn service_profile_id(&self) -> std::option::Option<&str> {
        self.service_profile_id.as_deref()
    }
}
impl std::fmt::Debug for LoRaWanUpdateDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanUpdateDevice");
        formatter.field("device_profile_id", &self.device_profile_id);
        formatter.field("service_profile_id", &self.service_profile_id);
        formatter.finish()
    }
}
/// See [`LoRaWanUpdateDevice`](crate::model::LoRaWanUpdateDevice)
pub mod lo_ra_wan_update_device {
    /// A builder for [`LoRaWanUpdateDevice`](crate::model::LoRaWanUpdateDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_profile_id: std::option::Option<std::string::String>,
        pub(crate) service_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the device profile for the wireless device.</p>
        pub fn device_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the device profile for the wireless device.</p>
        pub fn set_device_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_profile_id = input;
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn service_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn set_service_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanUpdateDevice`](crate::model::LoRaWanUpdateDevice)
        pub fn build(self) -> crate::model::LoRaWanUpdateDevice {
            crate::model::LoRaWanUpdateDevice {
                device_profile_id: self.device_profile_id,
                service_profile_id: self.service_profile_id,
            }
        }
    }
}
impl LoRaWanUpdateDevice {
    /// Creates a new builder-style object to manufacture [`LoRaWanUpdateDevice`](crate::model::LoRaWanUpdateDevice)
    pub fn builder() -> crate::model::lo_ra_wan_update_device::Builder {
        crate::model::lo_ra_wan_update_device::Builder::default()
    }
}

/// <p>Proximity event configuration object for enabling and disabling relevant topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProximityEventConfiguration {
    /// <p>Proximity event configuration object for enabling or disabling Sidewalk related event topics.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
}
impl ProximityEventConfiguration {
    /// <p>Proximity event configuration object for enabling or disabling Sidewalk related event topics.</p>
    pub fn sidewalk(
        &self,
    ) -> std::option::Option<&crate::model::SidewalkEventNotificationConfigurations> {
        self.sidewalk.as_ref()
    }
}
impl std::fmt::Debug for ProximityEventConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProximityEventConfiguration");
        formatter.field("sidewalk", &self.sidewalk);
        formatter.finish()
    }
}
/// See [`ProximityEventConfiguration`](crate::model::ProximityEventConfiguration)
pub mod proximity_event_configuration {
    /// A builder for [`ProximityEventConfiguration`](crate::model::ProximityEventConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sidewalk:
            std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
    }
    impl Builder {
        /// <p>Proximity event configuration object for enabling or disabling Sidewalk related event topics.</p>
        pub fn sidewalk(
            mut self,
            input: crate::model::SidewalkEventNotificationConfigurations,
        ) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>Proximity event configuration object for enabling or disabling Sidewalk related event topics.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// Consumes the builder and constructs a [`ProximityEventConfiguration`](crate::model::ProximityEventConfiguration)
        pub fn build(self) -> crate::model::ProximityEventConfiguration {
            crate::model::ProximityEventConfiguration {
                sidewalk: self.sidewalk,
            }
        }
    }
}
impl ProximityEventConfiguration {
    /// Creates a new builder-style object to manufacture [`ProximityEventConfiguration`](crate::model::ProximityEventConfiguration)
    pub fn builder() -> crate::model::proximity_event_configuration::Builder {
        crate::model::proximity_event_configuration::Builder::default()
    }
}

/// <p> SidewalkEventNotificationConfigurations object
/// Event configuration object for Sidewalk related event topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkEventNotificationConfigurations {
    /// <p>Enum to denote whether amazon id event topic is enabled or disabled.</p>
    pub amazon_id_event_topic: std::option::Option<crate::model::EventNotificationTopicStatus>,
}
impl SidewalkEventNotificationConfigurations {
    /// <p>Enum to denote whether amazon id event topic is enabled or disabled.</p>
    pub fn amazon_id_event_topic(
        &self,
    ) -> std::option::Option<&crate::model::EventNotificationTopicStatus> {
        self.amazon_id_event_topic.as_ref()
    }
}
impl std::fmt::Debug for SidewalkEventNotificationConfigurations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkEventNotificationConfigurations");
        formatter.field("amazon_id_event_topic", &self.amazon_id_event_topic);
        formatter.finish()
    }
}
/// See [`SidewalkEventNotificationConfigurations`](crate::model::SidewalkEventNotificationConfigurations)
pub mod sidewalk_event_notification_configurations {
    /// A builder for [`SidewalkEventNotificationConfigurations`](crate::model::SidewalkEventNotificationConfigurations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_id_event_topic:
            std::option::Option<crate::model::EventNotificationTopicStatus>,
    }
    impl Builder {
        /// <p>Enum to denote whether amazon id event topic is enabled or disabled.</p>
        pub fn amazon_id_event_topic(
            mut self,
            input: crate::model::EventNotificationTopicStatus,
        ) -> Self {
            self.amazon_id_event_topic = Some(input);
            self
        }
        /// <p>Enum to denote whether amazon id event topic is enabled or disabled.</p>
        pub fn set_amazon_id_event_topic(
            mut self,
            input: std::option::Option<crate::model::EventNotificationTopicStatus>,
        ) -> Self {
            self.amazon_id_event_topic = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkEventNotificationConfigurations`](crate::model::SidewalkEventNotificationConfigurations)
        pub fn build(self) -> crate::model::SidewalkEventNotificationConfigurations {
            crate::model::SidewalkEventNotificationConfigurations {
                amazon_id_event_topic: self.amazon_id_event_topic,
            }
        }
    }
}
impl SidewalkEventNotificationConfigurations {
    /// Creates a new builder-style object to manufacture [`SidewalkEventNotificationConfigurations`](crate::model::SidewalkEventNotificationConfigurations)
    pub fn builder() -> crate::model::sidewalk_event_notification_configurations::Builder {
        crate::model::sidewalk_event_notification_configurations::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventNotificationTopicStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventNotificationTopicStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => EventNotificationTopicStatus::Disabled,
            "Enabled" => EventNotificationTopicStatus::Enabled,
            other => EventNotificationTopicStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventNotificationTopicStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventNotificationTopicStatus::from(s))
    }
}
impl EventNotificationTopicStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventNotificationTopicStatus::Disabled => "Disabled",
            EventNotificationTopicStatus::Enabled => "Enabled",
            EventNotificationTopicStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for EventNotificationTopicStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Device registration state event configuration object for enabling and disabling relevant topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceRegistrationStateEventConfiguration {
    /// <p>Device registration state event configuration object for enabling or disabling Sidewalk related event
    /// topics.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
}
impl DeviceRegistrationStateEventConfiguration {
    /// <p>Device registration state event configuration object for enabling or disabling Sidewalk related event
    /// topics.</p>
    pub fn sidewalk(
        &self,
    ) -> std::option::Option<&crate::model::SidewalkEventNotificationConfigurations> {
        self.sidewalk.as_ref()
    }
}
impl std::fmt::Debug for DeviceRegistrationStateEventConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceRegistrationStateEventConfiguration");
        formatter.field("sidewalk", &self.sidewalk);
        formatter.finish()
    }
}
/// See [`DeviceRegistrationStateEventConfiguration`](crate::model::DeviceRegistrationStateEventConfiguration)
pub mod device_registration_state_event_configuration {
    /// A builder for [`DeviceRegistrationStateEventConfiguration`](crate::model::DeviceRegistrationStateEventConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sidewalk:
            std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
    }
    impl Builder {
        /// <p>Device registration state event configuration object for enabling or disabling Sidewalk related event
        /// topics.</p>
        pub fn sidewalk(
            mut self,
            input: crate::model::SidewalkEventNotificationConfigurations,
        ) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>Device registration state event configuration object for enabling or disabling Sidewalk related event
        /// topics.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkEventNotificationConfigurations>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceRegistrationStateEventConfiguration`](crate::model::DeviceRegistrationStateEventConfiguration)
        pub fn build(self) -> crate::model::DeviceRegistrationStateEventConfiguration {
            crate::model::DeviceRegistrationStateEventConfiguration {
                sidewalk: self.sidewalk,
            }
        }
    }
}
impl DeviceRegistrationStateEventConfiguration {
    /// Creates a new builder-style object to manufacture [`DeviceRegistrationStateEventConfiguration`](crate::model::DeviceRegistrationStateEventConfiguration)
    pub fn builder() -> crate::model::device_registration_state_event_configuration::Builder {
        crate::model::device_registration_state_event_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventNotificationPartnerType {
    #[allow(missing_docs)] // documentation missing in model
    Sidewalk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventNotificationPartnerType {
    fn from(s: &str) -> Self {
        match s {
            "Sidewalk" => EventNotificationPartnerType::Sidewalk,
            other => EventNotificationPartnerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventNotificationPartnerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventNotificationPartnerType::from(s))
    }
}
impl EventNotificationPartnerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventNotificationPartnerType::Sidewalk => "Sidewalk",
            EventNotificationPartnerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Sidewalk"]
    }
}
impl AsRef<str> for EventNotificationPartnerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentifierType {
    #[allow(missing_docs)] // documentation missing in model
    PartnerAccountId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentifierType {
    fn from(s: &str) -> Self {
        match s {
            "PartnerAccountId" => IdentifierType::PartnerAccountId,
            other => IdentifierType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentifierType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentifierType::from(s))
    }
}
impl IdentifierType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentifierType::PartnerAccountId => "PartnerAccountId",
            IdentifierType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PartnerAccountId"]
    }
}
impl AsRef<str> for IdentifierType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartnerType {
    #[allow(missing_docs)] // documentation missing in model
    Sidewalk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartnerType {
    fn from(s: &str) -> Self {
        match s {
            "Sidewalk" => PartnerType::Sidewalk,
            other => PartnerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartnerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartnerType::from(s))
    }
}
impl PartnerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartnerType::Sidewalk => "Sidewalk",
            PartnerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Sidewalk"]
    }
}
impl AsRef<str> for PartnerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Sidewalk update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkUpdateAccount {
    /// <p>The new Sidewalk application server private key.</p>
    pub app_server_private_key: std::option::Option<std::string::String>,
}
impl SidewalkUpdateAccount {
    /// <p>The new Sidewalk application server private key.</p>
    pub fn app_server_private_key(&self) -> std::option::Option<&str> {
        self.app_server_private_key.as_deref()
    }
}
impl std::fmt::Debug for SidewalkUpdateAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkUpdateAccount");
        formatter.field("app_server_private_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SidewalkUpdateAccount`](crate::model::SidewalkUpdateAccount)
pub mod sidewalk_update_account {
    /// A builder for [`SidewalkUpdateAccount`](crate::model::SidewalkUpdateAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_server_private_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The new Sidewalk application server private key.</p>
        pub fn app_server_private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_server_private_key = Some(input.into());
            self
        }
        /// <p>The new Sidewalk application server private key.</p>
        pub fn set_app_server_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_server_private_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkUpdateAccount`](crate::model::SidewalkUpdateAccount)
        pub fn build(self) -> crate::model::SidewalkUpdateAccount {
            crate::model::SidewalkUpdateAccount {
                app_server_private_key: self.app_server_private_key,
            }
        }
    }
}
impl SidewalkUpdateAccount {
    /// Creates a new builder-style object to manufacture [`SidewalkUpdateAccount`](crate::model::SidewalkUpdateAccount)
    pub fn builder() -> crate::model::sidewalk_update_account::Builder {
        crate::model::sidewalk_update_account::Builder::default()
    }
}

/// <p>Trace Content for resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TraceContent {
    /// <p>WirelessDevice FrameInfo for trace content.</p>
    pub wireless_device_frame_info: std::option::Option<crate::model::WirelessDeviceFrameInfo>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl TraceContent {
    /// <p>WirelessDevice FrameInfo for trace content.</p>
    pub fn wireless_device_frame_info(
        &self,
    ) -> std::option::Option<&crate::model::WirelessDeviceFrameInfo> {
        self.wireless_device_frame_info.as_ref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for TraceContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TraceContent");
        formatter.field(
            "wireless_device_frame_info",
            &self.wireless_device_frame_info,
        );
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`TraceContent`](crate::model::TraceContent)
pub mod trace_content {
    /// A builder for [`TraceContent`](crate::model::TraceContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wireless_device_frame_info:
            std::option::Option<crate::model::WirelessDeviceFrameInfo>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>WirelessDevice FrameInfo for trace content.</p>
        pub fn wireless_device_frame_info(
            mut self,
            input: crate::model::WirelessDeviceFrameInfo,
        ) -> Self {
            self.wireless_device_frame_info = Some(input);
            self
        }
        /// <p>WirelessDevice FrameInfo for trace content.</p>
        pub fn set_wireless_device_frame_info(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceFrameInfo>,
        ) -> Self {
            self.wireless_device_frame_info = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`TraceContent`](crate::model::TraceContent)
        pub fn build(self) -> crate::model::TraceContent {
            crate::model::TraceContent {
                wireless_device_frame_info: self.wireless_device_frame_info,
                log_level: self.log_level,
            }
        }
    }
}
impl TraceContent {
    /// Creates a new builder-style object to manufacture [`TraceContent`](crate::model::TraceContent)
    pub fn builder() -> crate::model::trace_content::Builder {
        crate::model::trace_content::Builder::default()
    }
}

/// <p>The log level for a log message.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogLevel {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => LogLevel::Disabled,
            "ERROR" => LogLevel::Error,
            "INFO" => LogLevel::Info,
            other => LogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogLevel::from(s))
    }
}
impl LogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogLevel::Disabled => "DISABLED",
            LogLevel::Error => "ERROR",
            LogLevel::Info => "INFO",
            LogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ERROR", "INFO"]
    }
}
impl AsRef<str> for LogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>WirelessDevice FrameInfo for trace content.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessDeviceFrameInfo {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessDeviceFrameInfo {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => WirelessDeviceFrameInfo::Disabled,
            "ENABLED" => WirelessDeviceFrameInfo::Enabled,
            other => WirelessDeviceFrameInfo::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessDeviceFrameInfo {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessDeviceFrameInfo::from(s))
    }
}
impl WirelessDeviceFrameInfo {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessDeviceFrameInfo::Disabled => "DISABLED",
            WirelessDeviceFrameInfo::Enabled => "ENABLED",
            WirelessDeviceFrameInfo::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for WirelessDeviceFrameInfo {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The LoRaWAN information that is to be used with the multicast group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanMulticast {
    /// <p>Supported RfRegions</p>
    pub rf_region: std::option::Option<crate::model::SupportedRfRegion>,
    /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
    pub dl_class: std::option::Option<crate::model::DlClass>,
}
impl LoRaWanMulticast {
    /// <p>Supported RfRegions</p>
    pub fn rf_region(&self) -> std::option::Option<&crate::model::SupportedRfRegion> {
        self.rf_region.as_ref()
    }
    /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
    pub fn dl_class(&self) -> std::option::Option<&crate::model::DlClass> {
        self.dl_class.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanMulticast {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanMulticast");
        formatter.field("rf_region", &self.rf_region);
        formatter.field("dl_class", &self.dl_class);
        formatter.finish()
    }
}
/// See [`LoRaWanMulticast`](crate::model::LoRaWanMulticast)
pub mod lo_ra_wan_multicast {
    /// A builder for [`LoRaWanMulticast`](crate::model::LoRaWanMulticast)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rf_region: std::option::Option<crate::model::SupportedRfRegion>,
        pub(crate) dl_class: std::option::Option<crate::model::DlClass>,
    }
    impl Builder {
        /// <p>Supported RfRegions</p>
        pub fn rf_region(mut self, input: crate::model::SupportedRfRegion) -> Self {
            self.rf_region = Some(input);
            self
        }
        /// <p>Supported RfRegions</p>
        pub fn set_rf_region(
            mut self,
            input: std::option::Option<crate::model::SupportedRfRegion>,
        ) -> Self {
            self.rf_region = input;
            self
        }
        /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
        pub fn dl_class(mut self, input: crate::model::DlClass) -> Self {
            self.dl_class = Some(input);
            self
        }
        /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
        pub fn set_dl_class(mut self, input: std::option::Option<crate::model::DlClass>) -> Self {
            self.dl_class = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanMulticast`](crate::model::LoRaWanMulticast)
        pub fn build(self) -> crate::model::LoRaWanMulticast {
            crate::model::LoRaWanMulticast {
                rf_region: self.rf_region,
                dl_class: self.dl_class,
            }
        }
    }
}
impl LoRaWanMulticast {
    /// Creates a new builder-style object to manufacture [`LoRaWanMulticast`](crate::model::LoRaWanMulticast)
    pub fn builder() -> crate::model::lo_ra_wan_multicast::Builder {
        crate::model::lo_ra_wan_multicast::Builder::default()
    }
}

/// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DlClass {
    #[allow(missing_docs)] // documentation missing in model
    ClassB,
    #[allow(missing_docs)] // documentation missing in model
    ClassC,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DlClass {
    fn from(s: &str) -> Self {
        match s {
            "ClassB" => DlClass::ClassB,
            "ClassC" => DlClass::ClassC,
            other => DlClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DlClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DlClass::from(s))
    }
}
impl DlClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DlClass::ClassB => "ClassB",
            DlClass::ClassC => "ClassC",
            DlClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ClassB", "ClassC"]
    }
}
impl AsRef<str> for DlClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Supported RfRegions</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SupportedRfRegion {
    #[allow(missing_docs)] // documentation missing in model
    As9231,
    #[allow(missing_docs)] // documentation missing in model
    Au915,
    #[allow(missing_docs)] // documentation missing in model
    Eu868,
    #[allow(missing_docs)] // documentation missing in model
    Us915,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SupportedRfRegion {
    fn from(s: &str) -> Self {
        match s {
            "AS923-1" => SupportedRfRegion::As9231,
            "AU915" => SupportedRfRegion::Au915,
            "EU868" => SupportedRfRegion::Eu868,
            "US915" => SupportedRfRegion::Us915,
            other => SupportedRfRegion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SupportedRfRegion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SupportedRfRegion::from(s))
    }
}
impl SupportedRfRegion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SupportedRfRegion::As9231 => "AS923-1",
            SupportedRfRegion::Au915 => "AU915",
            SupportedRfRegion::Eu868 => "EU868",
            SupportedRfRegion::Us915 => "US915",
            SupportedRfRegion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AS923-1", "AU915", "EU868", "US915"]
    }
}
impl AsRef<str> for SupportedRfRegion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The log options for wireless gateways and can be used to set log levels for a specific type of wireless gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessGatewayLogOption {
    /// <p>The wireless gateway type.</p>
    pub r#type: std::option::Option<crate::model::WirelessGatewayType>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// <p>The list of wireless gateway event log options.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::WirelessGatewayEventLogOption>>,
}
impl WirelessGatewayLogOption {
    /// <p>The wireless gateway type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WirelessGatewayType> {
        self.r#type.as_ref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// <p>The list of wireless gateway event log options.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::WirelessGatewayEventLogOption]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for WirelessGatewayLogOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessGatewayLogOption");
        formatter.field("r#type", &self.r#type);
        formatter.field("log_level", &self.log_level);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`WirelessGatewayLogOption`](crate::model::WirelessGatewayLogOption)
pub mod wireless_gateway_log_option {
    /// A builder for [`WirelessGatewayLogOption`](crate::model::WirelessGatewayLogOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WirelessGatewayType>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) events:
            std::option::Option<std::vec::Vec<crate::model::WirelessGatewayEventLogOption>>,
    }
    impl Builder {
        /// <p>The wireless gateway type.</p>
        pub fn r#type(mut self, input: crate::model::WirelessGatewayType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The wireless gateway type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The list of wireless gateway event log options.</p>
        pub fn events(
            mut self,
            input: impl Into<crate::model::WirelessGatewayEventLogOption>,
        ) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The list of wireless gateway event log options.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessGatewayEventLogOption>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessGatewayLogOption`](crate::model::WirelessGatewayLogOption)
        pub fn build(self) -> crate::model::WirelessGatewayLogOption {
            crate::model::WirelessGatewayLogOption {
                r#type: self.r#type,
                log_level: self.log_level,
                events: self.events,
            }
        }
    }
}
impl WirelessGatewayLogOption {
    /// Creates a new builder-style object to manufacture [`WirelessGatewayLogOption`](crate::model::WirelessGatewayLogOption)
    pub fn builder() -> crate::model::wireless_gateway_log_option::Builder {
        crate::model::wireless_gateway_log_option::Builder::default()
    }
}

/// <p>The log options for a wireless gateway event and can be used to set log levels for a specific wireless gateway event.</p>
/// <p>For a LoRaWAN gateway, possible events for a log message are <code>CUPS_Request</code> and <code>Certificate</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessGatewayEventLogOption {
    /// <p>The event for a log message, if the log message is tied to a wireless gateway.</p>
    pub event: std::option::Option<crate::model::WirelessGatewayEvent>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl WirelessGatewayEventLogOption {
    /// <p>The event for a log message, if the log message is tied to a wireless gateway.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::WirelessGatewayEvent> {
        self.event.as_ref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for WirelessGatewayEventLogOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessGatewayEventLogOption");
        formatter.field("event", &self.event);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`WirelessGatewayEventLogOption`](crate::model::WirelessGatewayEventLogOption)
pub mod wireless_gateway_event_log_option {
    /// A builder for [`WirelessGatewayEventLogOption`](crate::model::WirelessGatewayEventLogOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<crate::model::WirelessGatewayEvent>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The event for a log message, if the log message is tied to a wireless gateway.</p>
        pub fn event(mut self, input: crate::model::WirelessGatewayEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for a log message, if the log message is tied to a wireless gateway.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessGatewayEventLogOption`](crate::model::WirelessGatewayEventLogOption)
        pub fn build(self) -> crate::model::WirelessGatewayEventLogOption {
            crate::model::WirelessGatewayEventLogOption {
                event: self.event,
                log_level: self.log_level,
            }
        }
    }
}
impl WirelessGatewayEventLogOption {
    /// Creates a new builder-style object to manufacture [`WirelessGatewayEventLogOption`](crate::model::WirelessGatewayEventLogOption)
    pub fn builder() -> crate::model::wireless_gateway_event_log_option::Builder {
        crate::model::wireless_gateway_event_log_option::Builder::default()
    }
}

/// <p>The event for a log message, if the log message is tied to a wireless gateway.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayEvent {
    #[allow(missing_docs)] // documentation missing in model
    CupsRequest,
    #[allow(missing_docs)] // documentation missing in model
    Certificate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayEvent {
    fn from(s: &str) -> Self {
        match s {
            "CUPS_Request" => WirelessGatewayEvent::CupsRequest,
            "Certificate" => WirelessGatewayEvent::Certificate,
            other => WirelessGatewayEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayEvent::from(s))
    }
}
impl WirelessGatewayEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayEvent::CupsRequest => "CUPS_Request",
            WirelessGatewayEvent::Certificate => "Certificate",
            WirelessGatewayEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUPS_Request", "Certificate"]
    }
}
impl AsRef<str> for WirelessGatewayEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The wireless gateway type.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayType {
    #[allow(missing_docs)] // documentation missing in model
    LoRaWan,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayType {
    fn from(s: &str) -> Self {
        match s {
            "LoRaWAN" => WirelessGatewayType::LoRaWan,
            other => WirelessGatewayType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayType::from(s))
    }
}
impl WirelessGatewayType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayType::LoRaWan => "LoRaWAN",
            WirelessGatewayType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LoRaWAN"]
    }
}
impl AsRef<str> for WirelessGatewayType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The log options for wireless devices and can be used to set log levels for a specific type of wireless device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessDeviceLogOption {
    /// <p>The wireless device type.</p>
    pub r#type: std::option::Option<crate::model::WirelessDeviceType>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// <p>The list of wireless device event log options.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::WirelessDeviceEventLogOption>>,
}
impl WirelessDeviceLogOption {
    /// <p>The wireless device type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.r#type.as_ref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
    /// <p>The list of wireless device event log options.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::WirelessDeviceEventLogOption]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for WirelessDeviceLogOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessDeviceLogOption");
        formatter.field("r#type", &self.r#type);
        formatter.field("log_level", &self.log_level);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`WirelessDeviceLogOption`](crate::model::WirelessDeviceLogOption)
pub mod wireless_device_log_option {
    /// A builder for [`WirelessDeviceLogOption`](crate::model::WirelessDeviceLogOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WirelessDeviceType>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) events:
            std::option::Option<std::vec::Vec<crate::model::WirelessDeviceEventLogOption>>,
    }
    impl Builder {
        /// <p>The wireless device type.</p>
        pub fn r#type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The wireless device type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The list of wireless device event log options.</p>
        pub fn events(
            mut self,
            input: impl Into<crate::model::WirelessDeviceEventLogOption>,
        ) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The list of wireless device event log options.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessDeviceEventLogOption>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessDeviceLogOption`](crate::model::WirelessDeviceLogOption)
        pub fn build(self) -> crate::model::WirelessDeviceLogOption {
            crate::model::WirelessDeviceLogOption {
                r#type: self.r#type,
                log_level: self.log_level,
                events: self.events,
            }
        }
    }
}
impl WirelessDeviceLogOption {
    /// Creates a new builder-style object to manufacture [`WirelessDeviceLogOption`](crate::model::WirelessDeviceLogOption)
    pub fn builder() -> crate::model::wireless_device_log_option::Builder {
        crate::model::wireless_device_log_option::Builder::default()
    }
}

/// <p>The log options for a wireless device event and can be used to set log levels for a specific wireless device event.</p>
/// <p>For a LoRaWAN device, possible events for a log messsage are: <code>Join</code>, <code>Rejoin</code>,
/// <code>Downlink_Data</code>, and <code>Uplink_Data</code>. For a Sidewalk device, possible events for a log message are
/// <code>Registration</code>, <code>Downlink_Data</code>, and <code>Uplink_Data</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessDeviceEventLogOption {
    /// <p>The event for a log message, if the log message is tied to a wireless device.</p>
    pub event: std::option::Option<crate::model::WirelessDeviceEvent>,
    /// <p>The log level for a log message.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl WirelessDeviceEventLogOption {
    /// <p>The event for a log message, if the log message is tied to a wireless device.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::WirelessDeviceEvent> {
        self.event.as_ref()
    }
    /// <p>The log level for a log message.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for WirelessDeviceEventLogOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessDeviceEventLogOption");
        formatter.field("event", &self.event);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`WirelessDeviceEventLogOption`](crate::model::WirelessDeviceEventLogOption)
pub mod wireless_device_event_log_option {
    /// A builder for [`WirelessDeviceEventLogOption`](crate::model::WirelessDeviceEventLogOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<crate::model::WirelessDeviceEvent>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The event for a log message, if the log message is tied to a wireless device.</p>
        pub fn event(mut self, input: crate::model::WirelessDeviceEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for a log message, if the log message is tied to a wireless device.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessDeviceEventLogOption`](crate::model::WirelessDeviceEventLogOption)
        pub fn build(self) -> crate::model::WirelessDeviceEventLogOption {
            crate::model::WirelessDeviceEventLogOption {
                event: self.event,
                log_level: self.log_level,
            }
        }
    }
}
impl WirelessDeviceEventLogOption {
    /// Creates a new builder-style object to manufacture [`WirelessDeviceEventLogOption`](crate::model::WirelessDeviceEventLogOption)
    pub fn builder() -> crate::model::wireless_device_event_log_option::Builder {
        crate::model::wireless_device_event_log_option::Builder::default()
    }
}

/// <p>The event for a log message, if the log message is tied to a wireless device.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessDeviceEvent {
    #[allow(missing_docs)] // documentation missing in model
    DownlinkData,
    #[allow(missing_docs)] // documentation missing in model
    Join,
    #[allow(missing_docs)] // documentation missing in model
    Registration,
    #[allow(missing_docs)] // documentation missing in model
    Rejoin,
    #[allow(missing_docs)] // documentation missing in model
    UplinkData,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessDeviceEvent {
    fn from(s: &str) -> Self {
        match s {
            "Downlink_Data" => WirelessDeviceEvent::DownlinkData,
            "Join" => WirelessDeviceEvent::Join,
            "Registration" => WirelessDeviceEvent::Registration,
            "Rejoin" => WirelessDeviceEvent::Rejoin,
            "Uplink_Data" => WirelessDeviceEvent::UplinkData,
            other => WirelessDeviceEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessDeviceEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessDeviceEvent::from(s))
    }
}
impl WirelessDeviceEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessDeviceEvent::DownlinkData => "Downlink_Data",
            WirelessDeviceEvent::Join => "Join",
            WirelessDeviceEvent::Registration => "Registration",
            WirelessDeviceEvent::Rejoin => "Rejoin",
            WirelessDeviceEvent::UplinkData => "Uplink_Data",
            WirelessDeviceEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Downlink_Data",
            "Join",
            "Registration",
            "Rejoin",
            "Uplink_Data",
        ]
    }
}
impl AsRef<str> for WirelessDeviceEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessDeviceType {
    #[allow(missing_docs)] // documentation missing in model
    LoRaWan,
    #[allow(missing_docs)] // documentation missing in model
    Sidewalk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessDeviceType {
    fn from(s: &str) -> Self {
        match s {
            "LoRaWAN" => WirelessDeviceType::LoRaWan,
            "Sidewalk" => WirelessDeviceType::Sidewalk,
            other => WirelessDeviceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessDeviceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessDeviceType::from(s))
    }
}
impl WirelessDeviceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessDeviceType::LoRaWan => "LoRaWAN",
            WirelessDeviceType::Sidewalk => "Sidewalk",
            WirelessDeviceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LoRaWAN", "Sidewalk"]
    }
}
impl AsRef<str> for WirelessDeviceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The LoRaWAN information used with a FUOTA task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanFuotaTask {
    /// <p>Supported RfRegions</p>
    pub rf_region: std::option::Option<crate::model::SupportedRfRegion>,
}
impl LoRaWanFuotaTask {
    /// <p>Supported RfRegions</p>
    pub fn rf_region(&self) -> std::option::Option<&crate::model::SupportedRfRegion> {
        self.rf_region.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanFuotaTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanFuotaTask");
        formatter.field("rf_region", &self.rf_region);
        formatter.finish()
    }
}
/// See [`LoRaWanFuotaTask`](crate::model::LoRaWanFuotaTask)
pub mod lo_ra_wan_fuota_task {
    /// A builder for [`LoRaWanFuotaTask`](crate::model::LoRaWanFuotaTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rf_region: std::option::Option<crate::model::SupportedRfRegion>,
    }
    impl Builder {
        /// <p>Supported RfRegions</p>
        pub fn rf_region(mut self, input: crate::model::SupportedRfRegion) -> Self {
            self.rf_region = Some(input);
            self
        }
        /// <p>Supported RfRegions</p>
        pub fn set_rf_region(
            mut self,
            input: std::option::Option<crate::model::SupportedRfRegion>,
        ) -> Self {
            self.rf_region = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanFuotaTask`](crate::model::LoRaWanFuotaTask)
        pub fn build(self) -> crate::model::LoRaWanFuotaTask {
            crate::model::LoRaWanFuotaTask {
                rf_region: self.rf_region,
            }
        }
    }
}
impl LoRaWanFuotaTask {
    /// Creates a new builder-style object to manufacture [`LoRaWanFuotaTask`](crate::model::LoRaWanFuotaTask)
    pub fn builder() -> crate::model::lo_ra_wan_fuota_task::Builder {
        crate::model::lo_ra_wan_fuota_task::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpressionType {
    #[allow(missing_docs)] // documentation missing in model
    MqttTopic,
    #[allow(missing_docs)] // documentation missing in model
    RuleName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpressionType {
    fn from(s: &str) -> Self {
        match s {
            "MqttTopic" => ExpressionType::MqttTopic,
            "RuleName" => ExpressionType::RuleName,
            other => ExpressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpressionType::from(s))
    }
}
impl ExpressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpressionType::MqttTopic => "MqttTopic",
            ExpressionType::RuleName => "RuleName",
            ExpressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MqttTopic", "RuleName"]
    }
}
impl AsRef<str> for ExpressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A simple label consisting of a customer-defined key-value pair</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key value.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key value.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key value.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key value.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The LoRaWAN information used with the multicast session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanMulticastSession {
    /// <p>Downlink data rate.</p>
    pub dl_dr: std::option::Option<i32>,
    /// <p>Downlink frequency.</p>
    pub dl_freq: std::option::Option<i32>,
    /// <p>Timestamp of when the multicast group session is to start.</p>
    pub session_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>How long before a multicast group session is to timeout.</p>
    pub session_timeout: std::option::Option<i32>,
}
impl LoRaWanMulticastSession {
    /// <p>Downlink data rate.</p>
    pub fn dl_dr(&self) -> std::option::Option<i32> {
        self.dl_dr
    }
    /// <p>Downlink frequency.</p>
    pub fn dl_freq(&self) -> std::option::Option<i32> {
        self.dl_freq
    }
    /// <p>Timestamp of when the multicast group session is to start.</p>
    pub fn session_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.session_start_time.as_ref()
    }
    /// <p>How long before a multicast group session is to timeout.</p>
    pub fn session_timeout(&self) -> std::option::Option<i32> {
        self.session_timeout
    }
}
impl std::fmt::Debug for LoRaWanMulticastSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanMulticastSession");
        formatter.field("dl_dr", &self.dl_dr);
        formatter.field("dl_freq", &self.dl_freq);
        formatter.field("session_start_time", &self.session_start_time);
        formatter.field("session_timeout", &self.session_timeout);
        formatter.finish()
    }
}
/// See [`LoRaWanMulticastSession`](crate::model::LoRaWanMulticastSession)
pub mod lo_ra_wan_multicast_session {
    /// A builder for [`LoRaWanMulticastSession`](crate::model::LoRaWanMulticastSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dl_dr: std::option::Option<i32>,
        pub(crate) dl_freq: std::option::Option<i32>,
        pub(crate) session_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) session_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Downlink data rate.</p>
        pub fn dl_dr(mut self, input: i32) -> Self {
            self.dl_dr = Some(input);
            self
        }
        /// <p>Downlink data rate.</p>
        pub fn set_dl_dr(mut self, input: std::option::Option<i32>) -> Self {
            self.dl_dr = input;
            self
        }
        /// <p>Downlink frequency.</p>
        pub fn dl_freq(mut self, input: i32) -> Self {
            self.dl_freq = Some(input);
            self
        }
        /// <p>Downlink frequency.</p>
        pub fn set_dl_freq(mut self, input: std::option::Option<i32>) -> Self {
            self.dl_freq = input;
            self
        }
        /// <p>Timestamp of when the multicast group session is to start.</p>
        pub fn session_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.session_start_time = Some(input);
            self
        }
        /// <p>Timestamp of when the multicast group session is to start.</p>
        pub fn set_session_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.session_start_time = input;
            self
        }
        /// <p>How long before a multicast group session is to timeout.</p>
        pub fn session_timeout(mut self, input: i32) -> Self {
            self.session_timeout = Some(input);
            self
        }
        /// <p>How long before a multicast group session is to timeout.</p>
        pub fn set_session_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.session_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanMulticastSession`](crate::model::LoRaWanMulticastSession)
        pub fn build(self) -> crate::model::LoRaWanMulticastSession {
            crate::model::LoRaWanMulticastSession {
                dl_dr: self.dl_dr,
                dl_freq: self.dl_freq,
                session_start_time: self.session_start_time,
                session_timeout: self.session_timeout,
            }
        }
    }
}
impl LoRaWanMulticastSession {
    /// Creates a new builder-style object to manufacture [`LoRaWanMulticastSession`](crate::model::LoRaWanMulticastSession)
    pub fn builder() -> crate::model::lo_ra_wan_multicast_session::Builder {
        crate::model::lo_ra_wan_multicast_session::Builder::default()
    }
}

/// <p>The LoRaWAN information used to start a FUOTA task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanStartFuotaTask {
    /// <p>Start time of a FUOTA task.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LoRaWanStartFuotaTask {
    /// <p>Start time of a FUOTA task.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanStartFuotaTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanStartFuotaTask");
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`LoRaWanStartFuotaTask`](crate::model::LoRaWanStartFuotaTask)
pub mod lo_ra_wan_start_fuota_task {
    /// A builder for [`LoRaWanStartFuotaTask`](crate::model::LoRaWanStartFuotaTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Start time of a FUOTA task.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a FUOTA task.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanStartFuotaTask`](crate::model::LoRaWanStartFuotaTask)
        pub fn build(self) -> crate::model::LoRaWanStartFuotaTask {
            crate::model::LoRaWanStartFuotaTask {
                start_time: self.start_time,
            }
        }
    }
}
impl LoRaWanStartFuotaTask {
    /// Creates a new builder-style object to manufacture [`LoRaWanStartFuotaTask`](crate::model::LoRaWanStartFuotaTask)
    pub fn builder() -> crate::model::lo_ra_wan_start_fuota_task::Builder {
        crate::model::lo_ra_wan_start_fuota_task::Builder::default()
    }
}

/// <p>WirelessMetadata object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessMetadata {
    /// <p>LoRaWAN device info.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanSendDataToDevice>,
    /// <p>The Sidewalk account credentials.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkSendDataToDevice>,
}
impl WirelessMetadata {
    /// <p>LoRaWAN device info.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanSendDataToDevice> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The Sidewalk account credentials.</p>
    pub fn sidewalk(&self) -> std::option::Option<&crate::model::SidewalkSendDataToDevice> {
        self.sidewalk.as_ref()
    }
}
impl std::fmt::Debug for WirelessMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessMetadata");
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("sidewalk", &self.sidewalk);
        formatter.finish()
    }
}
/// See [`WirelessMetadata`](crate::model::WirelessMetadata)
pub mod wireless_metadata {
    /// A builder for [`WirelessMetadata`](crate::model::WirelessMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanSendDataToDevice>,
        pub(crate) sidewalk: std::option::Option<crate::model::SidewalkSendDataToDevice>,
    }
    impl Builder {
        /// <p>LoRaWAN device info.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanSendDataToDevice) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>LoRaWAN device info.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanSendDataToDevice>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkSendDataToDevice) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkSendDataToDevice>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessMetadata`](crate::model::WirelessMetadata)
        pub fn build(self) -> crate::model::WirelessMetadata {
            crate::model::WirelessMetadata {
                lo_ra_wan: self.lo_ra_wan,
                sidewalk: self.sidewalk,
            }
        }
    }
}
impl WirelessMetadata {
    /// Creates a new builder-style object to manufacture [`WirelessMetadata`](crate::model::WirelessMetadata)
    pub fn builder() -> crate::model::wireless_metadata::Builder {
        crate::model::wireless_metadata::Builder::default()
    }
}

/// <p>Information about a Sidewalk router.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkSendDataToDevice {
    /// <p>The sequence number.</p>
    pub seq: std::option::Option<i32>,
    /// <p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>
    pub message_type: std::option::Option<crate::model::MessageType>,
}
impl SidewalkSendDataToDevice {
    /// <p>The sequence number.</p>
    pub fn seq(&self) -> std::option::Option<i32> {
        self.seq
    }
    /// <p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>
    pub fn message_type(&self) -> std::option::Option<&crate::model::MessageType> {
        self.message_type.as_ref()
    }
}
impl std::fmt::Debug for SidewalkSendDataToDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkSendDataToDevice");
        formatter.field("seq", &self.seq);
        formatter.field("message_type", &self.message_type);
        formatter.finish()
    }
}
/// See [`SidewalkSendDataToDevice`](crate::model::SidewalkSendDataToDevice)
pub mod sidewalk_send_data_to_device {
    /// A builder for [`SidewalkSendDataToDevice`](crate::model::SidewalkSendDataToDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) seq: std::option::Option<i32>,
        pub(crate) message_type: std::option::Option<crate::model::MessageType>,
    }
    impl Builder {
        /// <p>The sequence number.</p>
        pub fn seq(mut self, input: i32) -> Self {
            self.seq = Some(input);
            self
        }
        /// <p>The sequence number.</p>
        pub fn set_seq(mut self, input: std::option::Option<i32>) -> Self {
            self.seq = input;
            self
        }
        /// <p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>
        pub fn message_type(mut self, input: crate::model::MessageType) -> Self {
            self.message_type = Some(input);
            self
        }
        /// <p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>
        pub fn set_message_type(
            mut self,
            input: std::option::Option<crate::model::MessageType>,
        ) -> Self {
            self.message_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkSendDataToDevice`](crate::model::SidewalkSendDataToDevice)
        pub fn build(self) -> crate::model::SidewalkSendDataToDevice {
            crate::model::SidewalkSendDataToDevice {
                seq: self.seq,
                message_type: self.message_type,
            }
        }
    }
}
impl SidewalkSendDataToDevice {
    /// Creates a new builder-style object to manufacture [`SidewalkSendDataToDevice`](crate::model::SidewalkSendDataToDevice)
    pub fn builder() -> crate::model::sidewalk_send_data_to_device::Builder {
        crate::model::sidewalk_send_data_to_device::Builder::default()
    }
}

/// <p>Sidewalk device message type. Default value is <code>CUSTOM_COMMAND_ID_NOTIFY</code>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageType {
    #[allow(missing_docs)] // documentation missing in model
    CustomCommandIdGet,
    #[allow(missing_docs)] // documentation missing in model
    CustomCommandIdNotify,
    #[allow(missing_docs)] // documentation missing in model
    CustomCommandIdResp,
    #[allow(missing_docs)] // documentation missing in model
    CustomCommandIdSet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM_COMMAND_ID_GET" => MessageType::CustomCommandIdGet,
            "CUSTOM_COMMAND_ID_NOTIFY" => MessageType::CustomCommandIdNotify,
            "CUSTOM_COMMAND_ID_RESP" => MessageType::CustomCommandIdResp,
            "CUSTOM_COMMAND_ID_SET" => MessageType::CustomCommandIdSet,
            other => MessageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageType::from(s))
    }
}
impl MessageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageType::CustomCommandIdGet => "CUSTOM_COMMAND_ID_GET",
            MessageType::CustomCommandIdNotify => "CUSTOM_COMMAND_ID_NOTIFY",
            MessageType::CustomCommandIdResp => "CUSTOM_COMMAND_ID_RESP",
            MessageType::CustomCommandIdSet => "CUSTOM_COMMAND_ID_SET",
            MessageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CUSTOM_COMMAND_ID_GET",
            "CUSTOM_COMMAND_ID_NOTIFY",
            "CUSTOM_COMMAND_ID_RESP",
            "CUSTOM_COMMAND_ID_SET",
        ]
    }
}
impl AsRef<str> for MessageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWAN router info.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanSendDataToDevice {
    /// <p>The Fport value.</p>
    pub f_port: std::option::Option<i32>,
}
impl LoRaWanSendDataToDevice {
    /// <p>The Fport value.</p>
    pub fn f_port(&self) -> std::option::Option<i32> {
        self.f_port
    }
}
impl std::fmt::Debug for LoRaWanSendDataToDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanSendDataToDevice");
        formatter.field("f_port", &self.f_port);
        formatter.finish()
    }
}
/// See [`LoRaWanSendDataToDevice`](crate::model::LoRaWanSendDataToDevice)
pub mod lo_ra_wan_send_data_to_device {
    /// A builder for [`LoRaWanSendDataToDevice`](crate::model::LoRaWanSendDataToDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) f_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Fport value.</p>
        pub fn f_port(mut self, input: i32) -> Self {
            self.f_port = Some(input);
            self
        }
        /// <p>The Fport value.</p>
        pub fn set_f_port(mut self, input: std::option::Option<i32>) -> Self {
            self.f_port = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanSendDataToDevice`](crate::model::LoRaWanSendDataToDevice)
        pub fn build(self) -> crate::model::LoRaWanSendDataToDevice {
            crate::model::LoRaWanSendDataToDevice {
                f_port: self.f_port,
            }
        }
    }
}
impl LoRaWanSendDataToDevice {
    /// Creates a new builder-style object to manufacture [`LoRaWanSendDataToDevice`](crate::model::LoRaWanSendDataToDevice)
    pub fn builder() -> crate::model::lo_ra_wan_send_data_to_device::Builder {
        crate::model::lo_ra_wan_send_data_to_device::Builder::default()
    }
}

/// <p>Wireless metadata that is to be sent to multicast group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MulticastWirelessMetadata {
    /// <p>The metadata information of the LoRaWAN multicast group.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticastMetadata>,
}
impl MulticastWirelessMetadata {
    /// <p>The metadata information of the LoRaWAN multicast group.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanMulticastMetadata> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for MulticastWirelessMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MulticastWirelessMetadata");
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}
/// See [`MulticastWirelessMetadata`](crate::model::MulticastWirelessMetadata)
pub mod multicast_wireless_metadata {
    /// A builder for [`MulticastWirelessMetadata`](crate::model::MulticastWirelessMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanMulticastMetadata>,
    }
    impl Builder {
        /// <p>The metadata information of the LoRaWAN multicast group.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanMulticastMetadata) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The metadata information of the LoRaWAN multicast group.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanMulticastMetadata>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`MulticastWirelessMetadata`](crate::model::MulticastWirelessMetadata)
        pub fn build(self) -> crate::model::MulticastWirelessMetadata {
            crate::model::MulticastWirelessMetadata {
                lo_ra_wan: self.lo_ra_wan,
            }
        }
    }
}
impl MulticastWirelessMetadata {
    /// Creates a new builder-style object to manufacture [`MulticastWirelessMetadata`](crate::model::MulticastWirelessMetadata)
    pub fn builder() -> crate::model::multicast_wireless_metadata::Builder {
        crate::model::multicast_wireless_metadata::Builder::default()
    }
}

/// <p>The metadata information of the LoRaWAN multicast group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanMulticastMetadata {
    /// <p>The Fport value.</p>
    pub f_port: std::option::Option<i32>,
}
impl LoRaWanMulticastMetadata {
    /// <p>The Fport value.</p>
    pub fn f_port(&self) -> std::option::Option<i32> {
        self.f_port
    }
}
impl std::fmt::Debug for LoRaWanMulticastMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanMulticastMetadata");
        formatter.field("f_port", &self.f_port);
        formatter.finish()
    }
}
/// See [`LoRaWanMulticastMetadata`](crate::model::LoRaWanMulticastMetadata)
pub mod lo_ra_wan_multicast_metadata {
    /// A builder for [`LoRaWanMulticastMetadata`](crate::model::LoRaWanMulticastMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) f_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Fport value.</p>
        pub fn f_port(mut self, input: i32) -> Self {
            self.f_port = Some(input);
            self
        }
        /// <p>The Fport value.</p>
        pub fn set_f_port(mut self, input: std::option::Option<i32>) -> Self {
            self.f_port = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanMulticastMetadata`](crate::model::LoRaWanMulticastMetadata)
        pub fn build(self) -> crate::model::LoRaWanMulticastMetadata {
            crate::model::LoRaWanMulticastMetadata {
                f_port: self.f_port,
            }
        }
    }
}
impl LoRaWanMulticastMetadata {
    /// Creates a new builder-style object to manufacture [`LoRaWanMulticastMetadata`](crate::model::LoRaWanMulticastMetadata)
    pub fn builder() -> crate::model::lo_ra_wan_multicast_metadata::Builder {
        crate::model::lo_ra_wan_multicast_metadata::Builder::default()
    }
}

/// <p>UpdateWirelessGatewayTaskEntry object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWirelessGatewayTaskEntry {
    /// <p>The ID of the new wireless gateway task entry.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskEntry>,
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl UpdateWirelessGatewayTaskEntry {
    /// <p>The ID of the new wireless gateway task entry.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanUpdateGatewayTaskEntry> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateWirelessGatewayTaskEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWirelessGatewayTaskEntry");
        formatter.field("id", &self.id);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`UpdateWirelessGatewayTaskEntry`](crate::model::UpdateWirelessGatewayTaskEntry)
pub mod update_wireless_gateway_task_entry {
    /// A builder for [`UpdateWirelessGatewayTaskEntry`](crate::model::UpdateWirelessGatewayTaskEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskEntry>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the new wireless gateway task entry.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the new wireless gateway task entry.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanUpdateGatewayTaskEntry) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskEntry>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWirelessGatewayTaskEntry`](crate::model::UpdateWirelessGatewayTaskEntry)
        pub fn build(self) -> crate::model::UpdateWirelessGatewayTaskEntry {
            crate::model::UpdateWirelessGatewayTaskEntry {
                id: self.id,
                lo_ra_wan: self.lo_ra_wan,
                arn: self.arn,
            }
        }
    }
}
impl UpdateWirelessGatewayTaskEntry {
    /// Creates a new builder-style object to manufacture [`UpdateWirelessGatewayTaskEntry`](crate::model::UpdateWirelessGatewayTaskEntry)
    pub fn builder() -> crate::model::update_wireless_gateway_task_entry::Builder {
        crate::model::update_wireless_gateway_task_entry::Builder::default()
    }
}

/// <p>LoRaWANUpdateGatewayTaskEntry object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanUpdateGatewayTaskEntry {
    /// <p>The version of the gateways that should receive the update.</p>
    pub current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
    /// <p>The firmware version to update the gateway to.</p>
    pub update_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
}
impl LoRaWanUpdateGatewayTaskEntry {
    /// <p>The version of the gateways that should receive the update.</p>
    pub fn current_version(&self) -> std::option::Option<&crate::model::LoRaWanGatewayVersion> {
        self.current_version.as_ref()
    }
    /// <p>The firmware version to update the gateway to.</p>
    pub fn update_version(&self) -> std::option::Option<&crate::model::LoRaWanGatewayVersion> {
        self.update_version.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanUpdateGatewayTaskEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanUpdateGatewayTaskEntry");
        formatter.field("current_version", &self.current_version);
        formatter.field("update_version", &self.update_version);
        formatter.finish()
    }
}
/// See [`LoRaWanUpdateGatewayTaskEntry`](crate::model::LoRaWanUpdateGatewayTaskEntry)
pub mod lo_ra_wan_update_gateway_task_entry {
    /// A builder for [`LoRaWanUpdateGatewayTaskEntry`](crate::model::LoRaWanUpdateGatewayTaskEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        pub(crate) update_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
    }
    impl Builder {
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn current_version(mut self, input: crate::model::LoRaWanGatewayVersion) -> Self {
            self.current_version = Some(input);
            self
        }
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The firmware version to update the gateway to.</p>
        pub fn update_version(mut self, input: crate::model::LoRaWanGatewayVersion) -> Self {
            self.update_version = Some(input);
            self
        }
        /// <p>The firmware version to update the gateway to.</p>
        pub fn set_update_version(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        ) -> Self {
            self.update_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanUpdateGatewayTaskEntry`](crate::model::LoRaWanUpdateGatewayTaskEntry)
        pub fn build(self) -> crate::model::LoRaWanUpdateGatewayTaskEntry {
            crate::model::LoRaWanUpdateGatewayTaskEntry {
                current_version: self.current_version,
                update_version: self.update_version,
            }
        }
    }
}
impl LoRaWanUpdateGatewayTaskEntry {
    /// Creates a new builder-style object to manufacture [`LoRaWanUpdateGatewayTaskEntry`](crate::model::LoRaWanUpdateGatewayTaskEntry)
    pub fn builder() -> crate::model::lo_ra_wan_update_gateway_task_entry::Builder {
        crate::model::lo_ra_wan_update_gateway_task_entry::Builder::default()
    }
}

/// <p>LoRaWANGatewayVersion object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanGatewayVersion {
    /// <p>The version of the wireless gateway firmware.</p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>The model number of the wireless gateway.</p>
    pub model: std::option::Option<std::string::String>,
    /// <p>The basic station version of the wireless gateway.</p>
    pub station: std::option::Option<std::string::String>,
}
impl LoRaWanGatewayVersion {
    /// <p>The version of the wireless gateway firmware.</p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>The model number of the wireless gateway.</p>
    pub fn model(&self) -> std::option::Option<&str> {
        self.model.as_deref()
    }
    /// <p>The basic station version of the wireless gateway.</p>
    pub fn station(&self) -> std::option::Option<&str> {
        self.station.as_deref()
    }
}
impl std::fmt::Debug for LoRaWanGatewayVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanGatewayVersion");
        formatter.field("package_version", &self.package_version);
        formatter.field("model", &self.model);
        formatter.field("station", &self.station);
        formatter.finish()
    }
}
/// See [`LoRaWanGatewayVersion`](crate::model::LoRaWanGatewayVersion)
pub mod lo_ra_wan_gateway_version {
    /// A builder for [`LoRaWanGatewayVersion`](crate::model::LoRaWanGatewayVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) model: std::option::Option<std::string::String>,
        pub(crate) station: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of the wireless gateway firmware.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The version of the wireless gateway firmware.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>The model number of the wireless gateway.</p>
        pub fn model(mut self, input: impl Into<std::string::String>) -> Self {
            self.model = Some(input.into());
            self
        }
        /// <p>The model number of the wireless gateway.</p>
        pub fn set_model(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model = input;
            self
        }
        /// <p>The basic station version of the wireless gateway.</p>
        pub fn station(mut self, input: impl Into<std::string::String>) -> Self {
            self.station = Some(input.into());
            self
        }
        /// <p>The basic station version of the wireless gateway.</p>
        pub fn set_station(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.station = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanGatewayVersion`](crate::model::LoRaWanGatewayVersion)
        pub fn build(self) -> crate::model::LoRaWanGatewayVersion {
            crate::model::LoRaWanGatewayVersion {
                package_version: self.package_version,
                model: self.model,
                station: self.station,
            }
        }
    }
}
impl LoRaWanGatewayVersion {
    /// Creates a new builder-style object to manufacture [`LoRaWanGatewayVersion`](crate::model::LoRaWanGatewayVersion)
    pub fn builder() -> crate::model::lo_ra_wan_gateway_version::Builder {
        crate::model::lo_ra_wan_gateway_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayTaskDefinitionType {
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayTaskDefinitionType {
    fn from(s: &str) -> Self {
        match s {
            "UPDATE" => WirelessGatewayTaskDefinitionType::Update,
            other => WirelessGatewayTaskDefinitionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayTaskDefinitionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayTaskDefinitionType::from(s))
    }
}
impl WirelessGatewayTaskDefinitionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayTaskDefinitionType::Update => "UPDATE",
            WirelessGatewayTaskDefinitionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UPDATE"]
    }
}
impl AsRef<str> for WirelessGatewayTaskDefinitionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a wireless gateway's operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessGatewayStatistics {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless gateway reporting the data.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>LoRaWAN gateway info.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanGateway>,
    /// <p>The date and time when the most recent uplink was received.</p>
    pub last_uplink_received_at: std::option::Option<std::string::String>,
}
impl WirelessGatewayStatistics {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the wireless gateway reporting the data.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>LoRaWAN gateway info.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanGateway> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The date and time when the most recent uplink was received.</p>
    pub fn last_uplink_received_at(&self) -> std::option::Option<&str> {
        self.last_uplink_received_at.as_deref()
    }
}
impl std::fmt::Debug for WirelessGatewayStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessGatewayStatistics");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("last_uplink_received_at", &self.last_uplink_received_at);
        formatter.finish()
    }
}
/// See [`WirelessGatewayStatistics`](crate::model::WirelessGatewayStatistics)
pub mod wireless_gateway_statistics {
    /// A builder for [`WirelessGatewayStatistics`](crate::model::WirelessGatewayStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanGateway>,
        pub(crate) last_uplink_received_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the wireless gateway reporting the data.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless gateway reporting the data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>LoRaWAN gateway info.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanGateway) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>LoRaWAN gateway info.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGateway>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The date and time when the most recent uplink was received.</p>
        pub fn last_uplink_received_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_uplink_received_at = Some(input.into());
            self
        }
        /// <p>The date and time when the most recent uplink was received.</p>
        pub fn set_last_uplink_received_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_uplink_received_at = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessGatewayStatistics`](crate::model::WirelessGatewayStatistics)
        pub fn build(self) -> crate::model::WirelessGatewayStatistics {
            crate::model::WirelessGatewayStatistics {
                arn: self.arn,
                id: self.id,
                name: self.name,
                description: self.description,
                lo_ra_wan: self.lo_ra_wan,
                last_uplink_received_at: self.last_uplink_received_at,
            }
        }
    }
}
impl WirelessGatewayStatistics {
    /// Creates a new builder-style object to manufacture [`WirelessGatewayStatistics`](crate::model::WirelessGatewayStatistics)
    pub fn builder() -> crate::model::wireless_gateway_statistics::Builder {
        crate::model::wireless_gateway_statistics::Builder::default()
    }
}

/// <p>LoRaWANGateway object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanGateway {
    /// <p>The gateway's EUI value.</p>
    pub gateway_eui: std::option::Option<std::string::String>,
    /// <p>The frequency band (RFRegion) value.</p>
    pub rf_region: std::option::Option<std::string::String>,
    /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
    pub join_eui_filters: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
    pub net_id_filters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of integer indicating which sub bands are supported by LoRa gateway.</p>
    pub sub_bands: std::option::Option<std::vec::Vec<i32>>,
}
impl LoRaWanGateway {
    /// <p>The gateway's EUI value.</p>
    pub fn gateway_eui(&self) -> std::option::Option<&str> {
        self.gateway_eui.as_deref()
    }
    /// <p>The frequency band (RFRegion) value.</p>
    pub fn rf_region(&self) -> std::option::Option<&str> {
        self.rf_region.as_deref()
    }
    /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
    pub fn join_eui_filters(&self) -> std::option::Option<&[std::vec::Vec<std::string::String>]> {
        self.join_eui_filters.as_deref()
    }
    /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
    pub fn net_id_filters(&self) -> std::option::Option<&[std::string::String]> {
        self.net_id_filters.as_deref()
    }
    /// <p>A list of integer indicating which sub bands are supported by LoRa gateway.</p>
    pub fn sub_bands(&self) -> std::option::Option<&[i32]> {
        self.sub_bands.as_deref()
    }
}
impl std::fmt::Debug for LoRaWanGateway {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanGateway");
        formatter.field("gateway_eui", &self.gateway_eui);
        formatter.field("rf_region", &self.rf_region);
        formatter.field("join_eui_filters", &self.join_eui_filters);
        formatter.field("net_id_filters", &self.net_id_filters);
        formatter.field("sub_bands", &self.sub_bands);
        formatter.finish()
    }
}
/// See [`LoRaWanGateway`](crate::model::LoRaWanGateway)
pub mod lo_ra_wan_gateway {
    /// A builder for [`LoRaWanGateway`](crate::model::LoRaWanGateway)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_eui: std::option::Option<std::string::String>,
        pub(crate) rf_region: std::option::Option<std::string::String>,
        pub(crate) join_eui_filters:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) net_id_filters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sub_bands: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>The gateway's EUI value.</p>
        pub fn gateway_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_eui = Some(input.into());
            self
        }
        /// <p>The gateway's EUI value.</p>
        pub fn set_gateway_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_eui = input;
            self
        }
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn rf_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.rf_region = Some(input.into());
            self
        }
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn set_rf_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rf_region = input;
            self
        }
        /// Appends an item to `join_eui_filters`.
        ///
        /// To override the contents of this collection use [`set_join_eui_filters`](Self::set_join_eui_filters).
        ///
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn join_eui_filters(
            mut self,
            input: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut v = self.join_eui_filters.unwrap_or_default();
            v.push(input.into());
            self.join_eui_filters = Some(v);
            self
        }
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn set_join_eui_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.join_eui_filters = input;
            self
        }
        /// Appends an item to `net_id_filters`.
        ///
        /// To override the contents of this collection use [`set_net_id_filters`](Self::set_net_id_filters).
        ///
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn net_id_filters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.net_id_filters.unwrap_or_default();
            v.push(input.into());
            self.net_id_filters = Some(v);
            self
        }
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn set_net_id_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.net_id_filters = input;
            self
        }
        /// Appends an item to `sub_bands`.
        ///
        /// To override the contents of this collection use [`set_sub_bands`](Self::set_sub_bands).
        ///
        /// <p>A list of integer indicating which sub bands are supported by LoRa gateway.</p>
        pub fn sub_bands(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.sub_bands.unwrap_or_default();
            v.push(input.into());
            self.sub_bands = Some(v);
            self
        }
        /// <p>A list of integer indicating which sub bands are supported by LoRa gateway.</p>
        pub fn set_sub_bands(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.sub_bands = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanGateway`](crate::model::LoRaWanGateway)
        pub fn build(self) -> crate::model::LoRaWanGateway {
            crate::model::LoRaWanGateway {
                gateway_eui: self.gateway_eui,
                rf_region: self.rf_region,
                join_eui_filters: self.join_eui_filters,
                net_id_filters: self.net_id_filters,
                sub_bands: self.sub_bands,
            }
        }
    }
}
impl LoRaWanGateway {
    /// Creates a new builder-style object to manufacture [`LoRaWanGateway`](crate::model::LoRaWanGateway)
    pub fn builder() -> crate::model::lo_ra_wan_gateway::Builder {
        crate::model::lo_ra_wan_gateway::Builder::default()
    }
}

/// <p>Information about a wireless device's operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessDeviceStatistics {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the wireless device reporting the data.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The wireless device type.</p>
    pub r#type: std::option::Option<crate::model::WirelessDeviceType>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the destination to which the device is assigned.</p>
    pub destination_name: std::option::Option<std::string::String>,
    /// <p>The date and time when the most recent uplink was received.</p>
    pub last_uplink_received_at: std::option::Option<std::string::String>,
    /// <p>LoRaWAN device info.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanListDevice>,
    /// <p>The Sidewalk account credentials.</p>
    pub sidewalk: std::option::Option<crate::model::SidewalkListDevice>,
    /// <p>The status of a wireless device in a FUOTA task.</p>
    pub fuota_device_status: std::option::Option<crate::model::FuotaDeviceStatus>,
    /// <p>The status of the wireless device in the multicast group.</p>
    pub multicast_device_status: std::option::Option<std::string::String>,
    /// <p>Id of the multicast group.</p>
    pub mc_group_id: std::option::Option<i32>,
}
impl WirelessDeviceStatistics {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the wireless device reporting the data.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The wireless device type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WirelessDeviceType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the destination to which the device is assigned.</p>
    pub fn destination_name(&self) -> std::option::Option<&str> {
        self.destination_name.as_deref()
    }
    /// <p>The date and time when the most recent uplink was received.</p>
    pub fn last_uplink_received_at(&self) -> std::option::Option<&str> {
        self.last_uplink_received_at.as_deref()
    }
    /// <p>LoRaWAN device info.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanListDevice> {
        self.lo_ra_wan.as_ref()
    }
    /// <p>The Sidewalk account credentials.</p>
    pub fn sidewalk(&self) -> std::option::Option<&crate::model::SidewalkListDevice> {
        self.sidewalk.as_ref()
    }
    /// <p>The status of a wireless device in a FUOTA task.</p>
    pub fn fuota_device_status(&self) -> std::option::Option<&crate::model::FuotaDeviceStatus> {
        self.fuota_device_status.as_ref()
    }
    /// <p>The status of the wireless device in the multicast group.</p>
    pub fn multicast_device_status(&self) -> std::option::Option<&str> {
        self.multicast_device_status.as_deref()
    }
    /// <p>Id of the multicast group.</p>
    pub fn mc_group_id(&self) -> std::option::Option<i32> {
        self.mc_group_id
    }
}
impl std::fmt::Debug for WirelessDeviceStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessDeviceStatistics");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("destination_name", &self.destination_name);
        formatter.field("last_uplink_received_at", &self.last_uplink_received_at);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.field("sidewalk", &self.sidewalk);
        formatter.field("fuota_device_status", &self.fuota_device_status);
        formatter.field("multicast_device_status", &self.multicast_device_status);
        formatter.field("mc_group_id", &self.mc_group_id);
        formatter.finish()
    }
}
/// See [`WirelessDeviceStatistics`](crate::model::WirelessDeviceStatistics)
pub mod wireless_device_statistics {
    /// A builder for [`WirelessDeviceStatistics`](crate::model::WirelessDeviceStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::WirelessDeviceType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_name: std::option::Option<std::string::String>,
        pub(crate) last_uplink_received_at: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanListDevice>,
        pub(crate) sidewalk: std::option::Option<crate::model::SidewalkListDevice>,
        pub(crate) fuota_device_status: std::option::Option<crate::model::FuotaDeviceStatus>,
        pub(crate) multicast_device_status: std::option::Option<std::string::String>,
        pub(crate) mc_group_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the wireless device reporting the data.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the wireless device reporting the data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The wireless device type.</p>
        pub fn r#type(mut self, input: crate::model::WirelessDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The wireless device type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the destination to which the device is assigned.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_name = Some(input.into());
            self
        }
        /// <p>The name of the destination to which the device is assigned.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_name = input;
            self
        }
        /// <p>The date and time when the most recent uplink was received.</p>
        pub fn last_uplink_received_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_uplink_received_at = Some(input.into());
            self
        }
        /// <p>The date and time when the most recent uplink was received.</p>
        pub fn set_last_uplink_received_at(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_uplink_received_at = input;
            self
        }
        /// <p>LoRaWAN device info.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanListDevice) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>LoRaWAN device info.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanListDevice>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, input: crate::model::SidewalkListDevice) -> Self {
            self.sidewalk = Some(input);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkListDevice>,
        ) -> Self {
            self.sidewalk = input;
            self
        }
        /// <p>The status of a wireless device in a FUOTA task.</p>
        pub fn fuota_device_status(mut self, input: crate::model::FuotaDeviceStatus) -> Self {
            self.fuota_device_status = Some(input);
            self
        }
        /// <p>The status of a wireless device in a FUOTA task.</p>
        pub fn set_fuota_device_status(
            mut self,
            input: std::option::Option<crate::model::FuotaDeviceStatus>,
        ) -> Self {
            self.fuota_device_status = input;
            self
        }
        /// <p>The status of the wireless device in the multicast group.</p>
        pub fn multicast_device_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.multicast_device_status = Some(input.into());
            self
        }
        /// <p>The status of the wireless device in the multicast group.</p>
        pub fn set_multicast_device_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.multicast_device_status = input;
            self
        }
        /// <p>Id of the multicast group.</p>
        pub fn mc_group_id(mut self, input: i32) -> Self {
            self.mc_group_id = Some(input);
            self
        }
        /// <p>Id of the multicast group.</p>
        pub fn set_mc_group_id(mut self, input: std::option::Option<i32>) -> Self {
            self.mc_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessDeviceStatistics`](crate::model::WirelessDeviceStatistics)
        pub fn build(self) -> crate::model::WirelessDeviceStatistics {
            crate::model::WirelessDeviceStatistics {
                arn: self.arn,
                id: self.id,
                r#type: self.r#type,
                name: self.name,
                destination_name: self.destination_name,
                last_uplink_received_at: self.last_uplink_received_at,
                lo_ra_wan: self.lo_ra_wan,
                sidewalk: self.sidewalk,
                fuota_device_status: self.fuota_device_status,
                multicast_device_status: self.multicast_device_status,
                mc_group_id: self.mc_group_id,
            }
        }
    }
}
impl WirelessDeviceStatistics {
    /// Creates a new builder-style object to manufacture [`WirelessDeviceStatistics`](crate::model::WirelessDeviceStatistics)
    pub fn builder() -> crate::model::wireless_device_statistics::Builder {
        crate::model::wireless_device_statistics::Builder::default()
    }
}

/// <p>The status of a wireless device in a FUOTA task.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FuotaDeviceStatus {
    #[allow(missing_docs)] // documentation missing in model
    FragAlgoUnsupported,
    #[allow(missing_docs)] // documentation missing in model
    FragIndexUnsupported,
    #[allow(missing_docs)] // documentation missing in model
    Initial,
    #[allow(missing_docs)] // documentation missing in model
    MicError,
    #[allow(missing_docs)] // documentation missing in model
    MemoryError,
    #[allow(missing_docs)] // documentation missing in model
    MissingFrag,
    #[allow(missing_docs)] // documentation missing in model
    NotEnoughMemory,
    #[allow(missing_docs)] // documentation missing in model
    PackageNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    SessionCntReplay,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    #[allow(missing_docs)] // documentation missing in model
    WrongDescriptor,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FuotaDeviceStatus {
    fn from(s: &str) -> Self {
        match s {
            "FragAlgo_unsupported" => FuotaDeviceStatus::FragAlgoUnsupported,
            "FragIndex_unsupported" => FuotaDeviceStatus::FragIndexUnsupported,
            "Initial" => FuotaDeviceStatus::Initial,
            "MICError" => FuotaDeviceStatus::MicError,
            "MemoryError" => FuotaDeviceStatus::MemoryError,
            "MissingFrag" => FuotaDeviceStatus::MissingFrag,
            "Not_enough_memory" => FuotaDeviceStatus::NotEnoughMemory,
            "Package_Not_Supported" => FuotaDeviceStatus::PackageNotSupported,
            "SessionCnt_replay" => FuotaDeviceStatus::SessionCntReplay,
            "Successful" => FuotaDeviceStatus::Successful,
            "Wrong_descriptor" => FuotaDeviceStatus::WrongDescriptor,
            other => FuotaDeviceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FuotaDeviceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FuotaDeviceStatus::from(s))
    }
}
impl FuotaDeviceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FuotaDeviceStatus::FragAlgoUnsupported => "FragAlgo_unsupported",
            FuotaDeviceStatus::FragIndexUnsupported => "FragIndex_unsupported",
            FuotaDeviceStatus::Initial => "Initial",
            FuotaDeviceStatus::MicError => "MICError",
            FuotaDeviceStatus::MemoryError => "MemoryError",
            FuotaDeviceStatus::MissingFrag => "MissingFrag",
            FuotaDeviceStatus::NotEnoughMemory => "Not_enough_memory",
            FuotaDeviceStatus::PackageNotSupported => "Package_Not_Supported",
            FuotaDeviceStatus::SessionCntReplay => "SessionCnt_replay",
            FuotaDeviceStatus::Successful => "Successful",
            FuotaDeviceStatus::WrongDescriptor => "Wrong_descriptor",
            FuotaDeviceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FragAlgo_unsupported",
            "FragIndex_unsupported",
            "Initial",
            "MICError",
            "MemoryError",
            "MissingFrag",
            "Not_enough_memory",
            "Package_Not_Supported",
            "SessionCnt_replay",
            "Successful",
            "Wrong_descriptor",
        ]
    }
}
impl AsRef<str> for FuotaDeviceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Sidewalk object used by list functions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkListDevice {
    /// <p>The Sidewalk Amazon ID.</p>
    pub amazon_id: std::option::Option<std::string::String>,
    /// <p>The sidewalk device identification.</p>
    pub sidewalk_id: std::option::Option<std::string::String>,
    /// <p>The Sidewalk manufacturing series number.</p>
    pub sidewalk_manufacturing_sn: std::option::Option<std::string::String>,
    /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
    pub device_certificates: std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
}
impl SidewalkListDevice {
    /// <p>The Sidewalk Amazon ID.</p>
    pub fn amazon_id(&self) -> std::option::Option<&str> {
        self.amazon_id.as_deref()
    }
    /// <p>The sidewalk device identification.</p>
    pub fn sidewalk_id(&self) -> std::option::Option<&str> {
        self.sidewalk_id.as_deref()
    }
    /// <p>The Sidewalk manufacturing series number.</p>
    pub fn sidewalk_manufacturing_sn(&self) -> std::option::Option<&str> {
        self.sidewalk_manufacturing_sn.as_deref()
    }
    /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
    pub fn device_certificates(&self) -> std::option::Option<&[crate::model::CertificateList]> {
        self.device_certificates.as_deref()
    }
}
impl std::fmt::Debug for SidewalkListDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkListDevice");
        formatter.field("amazon_id", &self.amazon_id);
        formatter.field("sidewalk_id", &self.sidewalk_id);
        formatter.field("sidewalk_manufacturing_sn", &self.sidewalk_manufacturing_sn);
        formatter.field("device_certificates", &self.device_certificates);
        formatter.finish()
    }
}
/// See [`SidewalkListDevice`](crate::model::SidewalkListDevice)
pub mod sidewalk_list_device {
    /// A builder for [`SidewalkListDevice`](crate::model::SidewalkListDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_id: std::option::Option<std::string::String>,
        pub(crate) sidewalk_id: std::option::Option<std::string::String>,
        pub(crate) sidewalk_manufacturing_sn: std::option::Option<std::string::String>,
        pub(crate) device_certificates:
            std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
    }
    impl Builder {
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn amazon_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_id = Some(input.into());
            self
        }
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amazon_id = input;
            self
        }
        /// <p>The sidewalk device identification.</p>
        pub fn sidewalk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sidewalk_id = Some(input.into());
            self
        }
        /// <p>The sidewalk device identification.</p>
        pub fn set_sidewalk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sidewalk_id = input;
            self
        }
        /// <p>The Sidewalk manufacturing series number.</p>
        pub fn sidewalk_manufacturing_sn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sidewalk_manufacturing_sn = Some(input.into());
            self
        }
        /// <p>The Sidewalk manufacturing series number.</p>
        pub fn set_sidewalk_manufacturing_sn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sidewalk_manufacturing_sn = input;
            self
        }
        /// Appends an item to `device_certificates`.
        ///
        /// To override the contents of this collection use [`set_device_certificates`](Self::set_device_certificates).
        ///
        /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
        pub fn device_certificates(
            mut self,
            input: impl Into<crate::model::CertificateList>,
        ) -> Self {
            let mut v = self.device_certificates.unwrap_or_default();
            v.push(input.into());
            self.device_certificates = Some(v);
            self
        }
        /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
        pub fn set_device_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
        ) -> Self {
            self.device_certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkListDevice`](crate::model::SidewalkListDevice)
        pub fn build(self) -> crate::model::SidewalkListDevice {
            crate::model::SidewalkListDevice {
                amazon_id: self.amazon_id,
                sidewalk_id: self.sidewalk_id,
                sidewalk_manufacturing_sn: self.sidewalk_manufacturing_sn,
                device_certificates: self.device_certificates,
            }
        }
    }
}
impl SidewalkListDevice {
    /// Creates a new builder-style object to manufacture [`SidewalkListDevice`](crate::model::SidewalkListDevice)
    pub fn builder() -> crate::model::sidewalk_list_device::Builder {
        crate::model::sidewalk_list_device::Builder::default()
    }
}

/// <p>List of sidewalk certificates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateList {
    /// <p>The certificate chain algorithm provided by sidewalk.</p>
    pub signing_alg: std::option::Option<crate::model::SigningAlg>,
    /// <p>The value of the chosen sidewalk certificate.</p>
    pub value: std::option::Option<std::string::String>,
}
impl CertificateList {
    /// <p>The certificate chain algorithm provided by sidewalk.</p>
    pub fn signing_alg(&self) -> std::option::Option<&crate::model::SigningAlg> {
        self.signing_alg.as_ref()
    }
    /// <p>The value of the chosen sidewalk certificate.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CertificateList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateList");
        formatter.field("signing_alg", &self.signing_alg);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CertificateList`](crate::model::CertificateList)
pub mod certificate_list {
    /// A builder for [`CertificateList`](crate::model::CertificateList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_alg: std::option::Option<crate::model::SigningAlg>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate chain algorithm provided by sidewalk.</p>
        pub fn signing_alg(mut self, input: crate::model::SigningAlg) -> Self {
            self.signing_alg = Some(input);
            self
        }
        /// <p>The certificate chain algorithm provided by sidewalk.</p>
        pub fn set_signing_alg(
            mut self,
            input: std::option::Option<crate::model::SigningAlg>,
        ) -> Self {
            self.signing_alg = input;
            self
        }
        /// <p>The value of the chosen sidewalk certificate.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the chosen sidewalk certificate.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateList`](crate::model::CertificateList)
        pub fn build(self) -> crate::model::CertificateList {
            crate::model::CertificateList {
                signing_alg: self.signing_alg,
                value: self.value,
            }
        }
    }
}
impl CertificateList {
    /// Creates a new builder-style object to manufacture [`CertificateList`](crate::model::CertificateList)
    pub fn builder() -> crate::model::certificate_list::Builder {
        crate::model::certificate_list::Builder::default()
    }
}

/// <p>The certificate chain algorithm provided by sidewalk.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SigningAlg {
    #[allow(missing_docs)] // documentation missing in model
    Ed25519,
    #[allow(missing_docs)] // documentation missing in model
    P256r1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SigningAlg {
    fn from(s: &str) -> Self {
        match s {
            "Ed25519" => SigningAlg::Ed25519,
            "P256r1" => SigningAlg::P256r1,
            other => SigningAlg::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SigningAlg {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SigningAlg::from(s))
    }
}
impl SigningAlg {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningAlg::Ed25519 => "Ed25519",
            SigningAlg::P256r1 => "P256r1",
            SigningAlg::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Ed25519", "P256r1"]
    }
}
impl AsRef<str> for SigningAlg {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWAN object for list functions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanListDevice {
    /// <p>The DevEUI value.</p>
    pub dev_eui: std::option::Option<std::string::String>,
}
impl LoRaWanListDevice {
    /// <p>The DevEUI value.</p>
    pub fn dev_eui(&self) -> std::option::Option<&str> {
        self.dev_eui.as_deref()
    }
}
impl std::fmt::Debug for LoRaWanListDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanListDevice");
        formatter.field("dev_eui", &self.dev_eui);
        formatter.finish()
    }
}
/// See [`LoRaWanListDevice`](crate::model::LoRaWanListDevice)
pub mod lo_ra_wan_list_device {
    /// A builder for [`LoRaWanListDevice`](crate::model::LoRaWanListDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_eui: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DevEUI value.</p>
        pub fn dev_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.dev_eui = Some(input.into());
            self
        }
        /// <p>The DevEUI value.</p>
        pub fn set_dev_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dev_eui = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanListDevice`](crate::model::LoRaWanListDevice)
        pub fn build(self) -> crate::model::LoRaWanListDevice {
            crate::model::LoRaWanListDevice {
                dev_eui: self.dev_eui,
            }
        }
    }
}
impl LoRaWanListDevice {
    /// Creates a new builder-style object to manufacture [`LoRaWanListDevice`](crate::model::LoRaWanListDevice)
    pub fn builder() -> crate::model::lo_ra_wan_list_device::Builder {
        crate::model::lo_ra_wan_list_device::Builder::default()
    }
}

/// <p>Information about a service profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceProfile {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the service profile.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ServiceProfile {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the service profile.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ServiceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ServiceProfile`](crate::model::ServiceProfile)
pub mod service_profile {
    /// A builder for [`ServiceProfile`](crate::model::ServiceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceProfile`](crate::model::ServiceProfile)
        pub fn build(self) -> crate::model::ServiceProfile {
            crate::model::ServiceProfile {
                arn: self.arn,
                name: self.name,
                id: self.id,
            }
        }
    }
}
impl ServiceProfile {
    /// Creates a new builder-style object to manufacture [`ServiceProfile`](crate::model::ServiceProfile)
    pub fn builder() -> crate::model::service_profile::Builder {
        crate::model::service_profile::Builder::default()
    }
}

/// <p>Information about a Sidewalk account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkAccountInfoWithFingerprint {
    /// <p>The Sidewalk Amazon ID.</p>
    pub amazon_id: std::option::Option<std::string::String>,
    /// <p>The fingerprint of the Sidewalk application server private key.</p>
    pub fingerprint: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl SidewalkAccountInfoWithFingerprint {
    /// <p>The Sidewalk Amazon ID.</p>
    pub fn amazon_id(&self) -> std::option::Option<&str> {
        self.amazon_id.as_deref()
    }
    /// <p>The fingerprint of the Sidewalk application server private key.</p>
    pub fn fingerprint(&self) -> std::option::Option<&str> {
        self.fingerprint.as_deref()
    }
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for SidewalkAccountInfoWithFingerprint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkAccountInfoWithFingerprint");
        formatter.field("amazon_id", &self.amazon_id);
        formatter.field("fingerprint", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`SidewalkAccountInfoWithFingerprint`](crate::model::SidewalkAccountInfoWithFingerprint)
pub mod sidewalk_account_info_with_fingerprint {
    /// A builder for [`SidewalkAccountInfoWithFingerprint`](crate::model::SidewalkAccountInfoWithFingerprint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_id: std::option::Option<std::string::String>,
        pub(crate) fingerprint: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn amazon_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_id = Some(input.into());
            self
        }
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amazon_id = input;
            self
        }
        /// <p>The fingerprint of the Sidewalk application server private key.</p>
        pub fn fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint = Some(input.into());
            self
        }
        /// <p>The fingerprint of the Sidewalk application server private key.</p>
        pub fn set_fingerprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fingerprint = input;
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkAccountInfoWithFingerprint`](crate::model::SidewalkAccountInfoWithFingerprint)
        pub fn build(self) -> crate::model::SidewalkAccountInfoWithFingerprint {
            crate::model::SidewalkAccountInfoWithFingerprint {
                amazon_id: self.amazon_id,
                fingerprint: self.fingerprint,
                arn: self.arn,
            }
        }
    }
}
impl SidewalkAccountInfoWithFingerprint {
    /// Creates a new builder-style object to manufacture [`SidewalkAccountInfoWithFingerprint`](crate::model::SidewalkAccountInfoWithFingerprint)
    pub fn builder() -> crate::model::sidewalk_account_info_with_fingerprint::Builder {
        crate::model::sidewalk_account_info_with_fingerprint::Builder::default()
    }
}

/// <p>A multicast group that is associated with a FUOTA task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MulticastGroupByFuotaTask {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl MulticastGroupByFuotaTask {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for MulticastGroupByFuotaTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MulticastGroupByFuotaTask");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`MulticastGroupByFuotaTask`](crate::model::MulticastGroupByFuotaTask)
pub mod multicast_group_by_fuota_task {
    /// A builder for [`MulticastGroupByFuotaTask`](crate::model::MulticastGroupByFuotaTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`MulticastGroupByFuotaTask`](crate::model::MulticastGroupByFuotaTask)
        pub fn build(self) -> crate::model::MulticastGroupByFuotaTask {
            crate::model::MulticastGroupByFuotaTask { id: self.id }
        }
    }
}
impl MulticastGroupByFuotaTask {
    /// Creates a new builder-style object to manufacture [`MulticastGroupByFuotaTask`](crate::model::MulticastGroupByFuotaTask)
    pub fn builder() -> crate::model::multicast_group_by_fuota_task::Builder {
        crate::model::multicast_group_by_fuota_task::Builder::default()
    }
}

/// <p>A multicast group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MulticastGroup {
    /// <p>The ID of the multicast group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The arn of the multicast group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the multicast group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl MulticastGroup {
    /// <p>The ID of the multicast group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The arn of the multicast group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the multicast group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for MulticastGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MulticastGroup");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`MulticastGroup`](crate::model::MulticastGroup)
pub mod multicast_group {
    /// A builder for [`MulticastGroup`](crate::model::MulticastGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the multicast group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the multicast group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The arn of the multicast group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The arn of the multicast group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the multicast group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`MulticastGroup`](crate::model::MulticastGroup)
        pub fn build(self) -> crate::model::MulticastGroup {
            crate::model::MulticastGroup {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl MulticastGroup {
    /// Creates a new builder-style object to manufacture [`MulticastGroup`](crate::model::MulticastGroup)
    pub fn builder() -> crate::model::multicast_group::Builder {
        crate::model::multicast_group::Builder::default()
    }
}

/// <p>A FUOTA task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FuotaTask {
    /// <p>The ID of a FUOTA task.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The arn of a FUOTA task.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of a FUOTA task.</p>
    pub name: std::option::Option<std::string::String>,
}
impl FuotaTask {
    /// <p>The ID of a FUOTA task.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The arn of a FUOTA task.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of a FUOTA task.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for FuotaTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FuotaTask");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`FuotaTask`](crate::model::FuotaTask)
pub mod fuota_task {
    /// A builder for [`FuotaTask`](crate::model::FuotaTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a FUOTA task.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of a FUOTA task.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The arn of a FUOTA task.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The arn of a FUOTA task.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a FUOTA task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`FuotaTask`](crate::model::FuotaTask)
        pub fn build(self) -> crate::model::FuotaTask {
            crate::model::FuotaTask {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl FuotaTask {
    /// Creates a new builder-style object to manufacture [`FuotaTask`](crate::model::FuotaTask)
    pub fn builder() -> crate::model::fuota_task::Builder {
        crate::model::fuota_task::Builder::default()
    }
}

/// <p>Describes a device profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceProfile {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the device profile.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeviceProfile {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the device profile.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeviceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`DeviceProfile`](crate::model::DeviceProfile)
pub mod device_profile {
    /// A builder for [`DeviceProfile`](crate::model::DeviceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the device profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the device profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceProfile`](crate::model::DeviceProfile)
        pub fn build(self) -> crate::model::DeviceProfile {
            crate::model::DeviceProfile {
                arn: self.arn,
                name: self.name,
                id: self.id,
            }
        }
    }
}
impl DeviceProfile {
    /// Creates a new builder-style object to manufacture [`DeviceProfile`](crate::model::DeviceProfile)
    pub fn builder() -> crate::model::device_profile::Builder {
        crate::model::device_profile::Builder::default()
    }
}

/// <p>Describes a destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destinations {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of value in <code>Expression</code>.</p>
    pub expression_type: std::option::Option<crate::model::ExpressionType>,
    /// <p>The rule name or topic rule to send messages to.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The description of the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl Destinations {
    /// <p>The Amazon Resource Name of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of value in <code>Expression</code>.</p>
    pub fn expression_type(&self) -> std::option::Option<&crate::model::ExpressionType> {
        self.expression_type.as_ref()
    }
    /// <p>The rule name or topic rule to send messages to.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The description of the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the IAM Role that authorizes the destination.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for Destinations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destinations");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("expression_type", &self.expression_type);
        formatter.field("expression", &self.expression);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`Destinations`](crate::model::Destinations)
pub mod destinations {
    /// A builder for [`Destinations`](crate::model::Destinations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) expression_type: std::option::Option<crate::model::ExpressionType>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.expression_type = Some(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.expression_type = input;
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>The description of the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Destinations`](crate::model::Destinations)
        pub fn build(self) -> crate::model::Destinations {
            crate::model::Destinations {
                arn: self.arn,
                name: self.name,
                expression_type: self.expression_type,
                expression: self.expression,
                description: self.description,
                role_arn: self.role_arn,
            }
        }
    }
}
impl Destinations {
    /// Creates a new builder-style object to manufacture [`Destinations`](crate::model::Destinations)
    pub fn builder() -> crate::model::destinations::Builder {
        crate::model::destinations::Builder::default()
    }
}

/// <p>UpdateWirelessGatewayTaskCreate object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWirelessGatewayTaskCreate {
    /// <p>The link to the S3 bucket.</p>
    pub update_data_source: std::option::Option<std::string::String>,
    /// <p>The IAM role used to read data from the S3 bucket.</p>
    pub update_data_role: std::option::Option<std::string::String>,
    /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
    pub lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskCreate>,
}
impl UpdateWirelessGatewayTaskCreate {
    /// <p>The link to the S3 bucket.</p>
    pub fn update_data_source(&self) -> std::option::Option<&str> {
        self.update_data_source.as_deref()
    }
    /// <p>The IAM role used to read data from the S3 bucket.</p>
    pub fn update_data_role(&self) -> std::option::Option<&str> {
        self.update_data_role.as_deref()
    }
    /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
    pub fn lo_ra_wan(&self) -> std::option::Option<&crate::model::LoRaWanUpdateGatewayTaskCreate> {
        self.lo_ra_wan.as_ref()
    }
}
impl std::fmt::Debug for UpdateWirelessGatewayTaskCreate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWirelessGatewayTaskCreate");
        formatter.field("update_data_source", &self.update_data_source);
        formatter.field("update_data_role", &self.update_data_role);
        formatter.field("lo_ra_wan", &self.lo_ra_wan);
        formatter.finish()
    }
}
/// See [`UpdateWirelessGatewayTaskCreate`](crate::model::UpdateWirelessGatewayTaskCreate)
pub mod update_wireless_gateway_task_create {
    /// A builder for [`UpdateWirelessGatewayTaskCreate`](crate::model::UpdateWirelessGatewayTaskCreate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_data_source: std::option::Option<std::string::String>,
        pub(crate) update_data_role: std::option::Option<std::string::String>,
        pub(crate) lo_ra_wan: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskCreate>,
    }
    impl Builder {
        /// <p>The link to the S3 bucket.</p>
        pub fn update_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_data_source = Some(input.into());
            self
        }
        /// <p>The link to the S3 bucket.</p>
        pub fn set_update_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_data_source = input;
            self
        }
        /// <p>The IAM role used to read data from the S3 bucket.</p>
        pub fn update_data_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_data_role = Some(input.into());
            self
        }
        /// <p>The IAM role used to read data from the S3 bucket.</p>
        pub fn set_update_data_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_data_role = input;
            self
        }
        /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
        pub fn lo_ra_wan(mut self, input: crate::model::LoRaWanUpdateGatewayTaskCreate) -> Self {
            self.lo_ra_wan = Some(input);
            self
        }
        /// <p>The properties that relate to the LoRaWAN wireless gateway.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanUpdateGatewayTaskCreate>,
        ) -> Self {
            self.lo_ra_wan = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWirelessGatewayTaskCreate`](crate::model::UpdateWirelessGatewayTaskCreate)
        pub fn build(self) -> crate::model::UpdateWirelessGatewayTaskCreate {
            crate::model::UpdateWirelessGatewayTaskCreate {
                update_data_source: self.update_data_source,
                update_data_role: self.update_data_role,
                lo_ra_wan: self.lo_ra_wan,
            }
        }
    }
}
impl UpdateWirelessGatewayTaskCreate {
    /// Creates a new builder-style object to manufacture [`UpdateWirelessGatewayTaskCreate`](crate::model::UpdateWirelessGatewayTaskCreate)
    pub fn builder() -> crate::model::update_wireless_gateway_task_create::Builder {
        crate::model::update_wireless_gateway_task_create::Builder::default()
    }
}

/// <p>LoRaWANUpdateGatewayTaskCreate object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanUpdateGatewayTaskCreate {
    /// <p>The signature used to verify the update firmware.</p>
    pub update_signature: std::option::Option<std::string::String>,
    /// <p>The CRC of the signature private key to check.</p>
    pub sig_key_crc: std::option::Option<i64>,
    /// <p>The version of the gateways that should receive the update.</p>
    pub current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
    /// <p>The firmware version to update the gateway to.</p>
    pub update_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
}
impl LoRaWanUpdateGatewayTaskCreate {
    /// <p>The signature used to verify the update firmware.</p>
    pub fn update_signature(&self) -> std::option::Option<&str> {
        self.update_signature.as_deref()
    }
    /// <p>The CRC of the signature private key to check.</p>
    pub fn sig_key_crc(&self) -> std::option::Option<i64> {
        self.sig_key_crc
    }
    /// <p>The version of the gateways that should receive the update.</p>
    pub fn current_version(&self) -> std::option::Option<&crate::model::LoRaWanGatewayVersion> {
        self.current_version.as_ref()
    }
    /// <p>The firmware version to update the gateway to.</p>
    pub fn update_version(&self) -> std::option::Option<&crate::model::LoRaWanGatewayVersion> {
        self.update_version.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanUpdateGatewayTaskCreate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanUpdateGatewayTaskCreate");
        formatter.field("update_signature", &self.update_signature);
        formatter.field("sig_key_crc", &self.sig_key_crc);
        formatter.field("current_version", &self.current_version);
        formatter.field("update_version", &self.update_version);
        formatter.finish()
    }
}
/// See [`LoRaWanUpdateGatewayTaskCreate`](crate::model::LoRaWanUpdateGatewayTaskCreate)
pub mod lo_ra_wan_update_gateway_task_create {
    /// A builder for [`LoRaWanUpdateGatewayTaskCreate`](crate::model::LoRaWanUpdateGatewayTaskCreate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_signature: std::option::Option<std::string::String>,
        pub(crate) sig_key_crc: std::option::Option<i64>,
        pub(crate) current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        pub(crate) update_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
    }
    impl Builder {
        /// <p>The signature used to verify the update firmware.</p>
        pub fn update_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_signature = Some(input.into());
            self
        }
        /// <p>The signature used to verify the update firmware.</p>
        pub fn set_update_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_signature = input;
            self
        }
        /// <p>The CRC of the signature private key to check.</p>
        pub fn sig_key_crc(mut self, input: i64) -> Self {
            self.sig_key_crc = Some(input);
            self
        }
        /// <p>The CRC of the signature private key to check.</p>
        pub fn set_sig_key_crc(mut self, input: std::option::Option<i64>) -> Self {
            self.sig_key_crc = input;
            self
        }
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn current_version(mut self, input: crate::model::LoRaWanGatewayVersion) -> Self {
            self.current_version = Some(input);
            self
        }
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// <p>The firmware version to update the gateway to.</p>
        pub fn update_version(mut self, input: crate::model::LoRaWanGatewayVersion) -> Self {
            self.update_version = Some(input);
            self
        }
        /// <p>The firmware version to update the gateway to.</p>
        pub fn set_update_version(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        ) -> Self {
            self.update_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanUpdateGatewayTaskCreate`](crate::model::LoRaWanUpdateGatewayTaskCreate)
        pub fn build(self) -> crate::model::LoRaWanUpdateGatewayTaskCreate {
            crate::model::LoRaWanUpdateGatewayTaskCreate {
                update_signature: self.update_signature,
                sig_key_crc: self.sig_key_crc,
                current_version: self.current_version,
                update_version: self.update_version,
            }
        }
    }
}
impl LoRaWanUpdateGatewayTaskCreate {
    /// Creates a new builder-style object to manufacture [`LoRaWanUpdateGatewayTaskCreate`](crate::model::LoRaWanUpdateGatewayTaskCreate)
    pub fn builder() -> crate::model::lo_ra_wan_update_gateway_task_create::Builder {
        crate::model::lo_ra_wan_update_gateway_task_create::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    FirstRetry,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    SecondRetry,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => WirelessGatewayTaskStatus::Completed,
            "FAILED" => WirelessGatewayTaskStatus::Failed,
            "FIRST_RETRY" => WirelessGatewayTaskStatus::FirstRetry,
            "IN_PROGRESS" => WirelessGatewayTaskStatus::InProgress,
            "PENDING" => WirelessGatewayTaskStatus::Pending,
            "SECOND_RETRY" => WirelessGatewayTaskStatus::SecondRetry,
            other => WirelessGatewayTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayTaskStatus::from(s))
    }
}
impl WirelessGatewayTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayTaskStatus::Completed => "COMPLETED",
            WirelessGatewayTaskStatus::Failed => "FAILED",
            WirelessGatewayTaskStatus::FirstRetry => "FIRST_RETRY",
            WirelessGatewayTaskStatus::InProgress => "IN_PROGRESS",
            WirelessGatewayTaskStatus::Pending => "PENDING",
            WirelessGatewayTaskStatus::SecondRetry => "SECOND_RETRY",
            WirelessGatewayTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "FAILED",
            "FIRST_RETRY",
            "IN_PROGRESS",
            "PENDING",
            "SECOND_RETRY",
        ]
    }
}
impl AsRef<str> for WirelessGatewayTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Connected" => ConnectionStatus::Connected,
            "Disconnected" => ConnectionStatus::Disconnected,
            other => ConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStatus::from(s))
    }
}
impl ConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStatus::Connected => "Connected",
            ConnectionStatus::Disconnected => "Disconnected",
            ConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Connected", "Disconnected"]
    }
}
impl AsRef<str> for ConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWANGatewayCurrentVersion object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanGatewayCurrentVersion {
    /// <p>The version of the gateways that should receive the update.</p>
    pub current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
}
impl LoRaWanGatewayCurrentVersion {
    /// <p>The version of the gateways that should receive the update.</p>
    pub fn current_version(&self) -> std::option::Option<&crate::model::LoRaWanGatewayVersion> {
        self.current_version.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanGatewayCurrentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanGatewayCurrentVersion");
        formatter.field("current_version", &self.current_version);
        formatter.finish()
    }
}
/// See [`LoRaWanGatewayCurrentVersion`](crate::model::LoRaWanGatewayCurrentVersion)
pub mod lo_ra_wan_gateway_current_version {
    /// A builder for [`LoRaWanGatewayCurrentVersion`](crate::model::LoRaWanGatewayCurrentVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current_version: std::option::Option<crate::model::LoRaWanGatewayVersion>,
    }
    impl Builder {
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn current_version(mut self, input: crate::model::LoRaWanGatewayVersion) -> Self {
            self.current_version = Some(input);
            self
        }
        /// <p>The version of the gateways that should receive the update.</p>
        pub fn set_current_version(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGatewayVersion>,
        ) -> Self {
            self.current_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanGatewayCurrentVersion`](crate::model::LoRaWanGatewayCurrentVersion)
        pub fn build(self) -> crate::model::LoRaWanGatewayCurrentVersion {
            crate::model::LoRaWanGatewayCurrentVersion {
                current_version: self.current_version,
            }
        }
    }
}
impl LoRaWanGatewayCurrentVersion {
    /// Creates a new builder-style object to manufacture [`LoRaWanGatewayCurrentVersion`](crate::model::LoRaWanGatewayCurrentVersion)
    pub fn builder() -> crate::model::lo_ra_wan_gateway_current_version::Builder {
        crate::model::lo_ra_wan_gateway_current_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayIdType {
    #[allow(missing_docs)] // documentation missing in model
    GatewayEui,
    #[allow(missing_docs)] // documentation missing in model
    ThingName,
    #[allow(missing_docs)] // documentation missing in model
    WirelessGatewayId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayIdType {
    fn from(s: &str) -> Self {
        match s {
            "GatewayEui" => WirelessGatewayIdType::GatewayEui,
            "ThingName" => WirelessGatewayIdType::ThingName,
            "WirelessGatewayId" => WirelessGatewayIdType::WirelessGatewayId,
            other => WirelessGatewayIdType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayIdType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayIdType::from(s))
    }
}
impl WirelessGatewayIdType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayIdType::GatewayEui => "GatewayEui",
            WirelessGatewayIdType::ThingName => "ThingName",
            WirelessGatewayIdType::WirelessGatewayId => "WirelessGatewayId",
            WirelessGatewayIdType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GatewayEui", "ThingName", "WirelessGatewayId"]
    }
}
impl AsRef<str> for WirelessGatewayIdType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>MetaData for Sidewalk device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkDeviceMetadata {
    /// <p>The RSSI value.</p>
    pub rssi: std::option::Option<i32>,
    /// <p>Sidewalk device battery level.</p>
    pub battery_level: std::option::Option<crate::model::BatteryLevel>,
    /// <p>Sidewalk device status notification.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>Device state defines the device status of sidewalk device.</p>
    pub device_state: std::option::Option<crate::model::DeviceState>,
}
impl SidewalkDeviceMetadata {
    /// <p>The RSSI value.</p>
    pub fn rssi(&self) -> std::option::Option<i32> {
        self.rssi
    }
    /// <p>Sidewalk device battery level.</p>
    pub fn battery_level(&self) -> std::option::Option<&crate::model::BatteryLevel> {
        self.battery_level.as_ref()
    }
    /// <p>Sidewalk device status notification.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>Device state defines the device status of sidewalk device.</p>
    pub fn device_state(&self) -> std::option::Option<&crate::model::DeviceState> {
        self.device_state.as_ref()
    }
}
impl std::fmt::Debug for SidewalkDeviceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkDeviceMetadata");
        formatter.field("rssi", &self.rssi);
        formatter.field("battery_level", &self.battery_level);
        formatter.field("event", &self.event);
        formatter.field("device_state", &self.device_state);
        formatter.finish()
    }
}
/// See [`SidewalkDeviceMetadata`](crate::model::SidewalkDeviceMetadata)
pub mod sidewalk_device_metadata {
    /// A builder for [`SidewalkDeviceMetadata`](crate::model::SidewalkDeviceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rssi: std::option::Option<i32>,
        pub(crate) battery_level: std::option::Option<crate::model::BatteryLevel>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) device_state: std::option::Option<crate::model::DeviceState>,
    }
    impl Builder {
        /// <p>The RSSI value.</p>
        pub fn rssi(mut self, input: i32) -> Self {
            self.rssi = Some(input);
            self
        }
        /// <p>The RSSI value.</p>
        pub fn set_rssi(mut self, input: std::option::Option<i32>) -> Self {
            self.rssi = input;
            self
        }
        /// <p>Sidewalk device battery level.</p>
        pub fn battery_level(mut self, input: crate::model::BatteryLevel) -> Self {
            self.battery_level = Some(input);
            self
        }
        /// <p>Sidewalk device battery level.</p>
        pub fn set_battery_level(
            mut self,
            input: std::option::Option<crate::model::BatteryLevel>,
        ) -> Self {
            self.battery_level = input;
            self
        }
        /// <p>Sidewalk device status notification.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>Sidewalk device status notification.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>Device state defines the device status of sidewalk device.</p>
        pub fn device_state(mut self, input: crate::model::DeviceState) -> Self {
            self.device_state = Some(input);
            self
        }
        /// <p>Device state defines the device status of sidewalk device.</p>
        pub fn set_device_state(
            mut self,
            input: std::option::Option<crate::model::DeviceState>,
        ) -> Self {
            self.device_state = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkDeviceMetadata`](crate::model::SidewalkDeviceMetadata)
        pub fn build(self) -> crate::model::SidewalkDeviceMetadata {
            crate::model::SidewalkDeviceMetadata {
                rssi: self.rssi,
                battery_level: self.battery_level,
                event: self.event,
                device_state: self.device_state,
            }
        }
    }
}
impl SidewalkDeviceMetadata {
    /// Creates a new builder-style object to manufacture [`SidewalkDeviceMetadata`](crate::model::SidewalkDeviceMetadata)
    pub fn builder() -> crate::model::sidewalk_device_metadata::Builder {
        crate::model::sidewalk_device_metadata::Builder::default()
    }
}

/// <p>Device state defines the device status of sidewalk device.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceState {
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    #[allow(missing_docs)] // documentation missing in model
    Registerednotseen,
    #[allow(missing_docs)] // documentation missing in model
    Registeredreachable,
    #[allow(missing_docs)] // documentation missing in model
    Registeredunreachable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceState {
    fn from(s: &str) -> Self {
        match s {
            "Provisioned" => DeviceState::Provisioned,
            "RegisteredNotSeen" => DeviceState::Registerednotseen,
            "RegisteredReachable" => DeviceState::Registeredreachable,
            "RegisteredUnreachable" => DeviceState::Registeredunreachable,
            other => DeviceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceState::from(s))
    }
}
impl DeviceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceState::Provisioned => "Provisioned",
            DeviceState::Registerednotseen => "RegisteredNotSeen",
            DeviceState::Registeredreachable => "RegisteredReachable",
            DeviceState::Registeredunreachable => "RegisteredUnreachable",
            DeviceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Provisioned",
            "RegisteredNotSeen",
            "RegisteredReachable",
            "RegisteredUnreachable",
        ]
    }
}
impl AsRef<str> for DeviceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Sidewalk device status notification.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Event {
    #[allow(missing_docs)] // documentation missing in model
    Ack,
    #[allow(missing_docs)] // documentation missing in model
    Discovered,
    #[allow(missing_docs)] // documentation missing in model
    Lost,
    #[allow(missing_docs)] // documentation missing in model
    Nack,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Event {
    fn from(s: &str) -> Self {
        match s {
            "ack" => Event::Ack,
            "discovered" => Event::Discovered,
            "lost" => Event::Lost,
            "nack" => Event::Nack,
            "passthrough" => Event::Passthrough,
            other => Event::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Event {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Event::from(s))
    }
}
impl Event {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Event::Ack => "ack",
            Event::Discovered => "discovered",
            Event::Lost => "lost",
            Event::Nack => "nack",
            Event::Passthrough => "passthrough",
            Event::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ack", "discovered", "lost", "nack", "passthrough"]
    }
}
impl AsRef<str> for Event {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Sidewalk device battery level.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatteryLevel {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Normal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatteryLevel {
    fn from(s: &str) -> Self {
        match s {
            "critical" => BatteryLevel::Critical,
            "low" => BatteryLevel::Low,
            "normal" => BatteryLevel::Normal,
            other => BatteryLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatteryLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatteryLevel::from(s))
    }
}
impl BatteryLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatteryLevel::Critical => "critical",
            BatteryLevel::Low => "low",
            BatteryLevel::Normal => "normal",
            BatteryLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["critical", "low", "normal"]
    }
}
impl AsRef<str> for BatteryLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWAN device metatdata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanDeviceMetadata {
    /// <p>The DevEUI value.</p>
    pub dev_eui: std::option::Option<std::string::String>,
    /// <p>The FPort value.</p>
    pub f_port: std::option::Option<i32>,
    /// <p>The DataRate value.</p>
    pub data_rate: std::option::Option<i32>,
    /// <p>The device's channel frequency in Hz.</p>
    pub frequency: std::option::Option<i32>,
    /// <p>The date and time of the metadata.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>Information about the gateways accessed by the device.</p>
    pub gateways: std::option::Option<std::vec::Vec<crate::model::LoRaWanGatewayMetadata>>,
}
impl LoRaWanDeviceMetadata {
    /// <p>The DevEUI value.</p>
    pub fn dev_eui(&self) -> std::option::Option<&str> {
        self.dev_eui.as_deref()
    }
    /// <p>The FPort value.</p>
    pub fn f_port(&self) -> std::option::Option<i32> {
        self.f_port
    }
    /// <p>The DataRate value.</p>
    pub fn data_rate(&self) -> std::option::Option<i32> {
        self.data_rate
    }
    /// <p>The device's channel frequency in Hz.</p>
    pub fn frequency(&self) -> std::option::Option<i32> {
        self.frequency
    }
    /// <p>The date and time of the metadata.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>Information about the gateways accessed by the device.</p>
    pub fn gateways(&self) -> std::option::Option<&[crate::model::LoRaWanGatewayMetadata]> {
        self.gateways.as_deref()
    }
}
impl std::fmt::Debug for LoRaWanDeviceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanDeviceMetadata");
        formatter.field("dev_eui", &self.dev_eui);
        formatter.field("f_port", &self.f_port);
        formatter.field("data_rate", &self.data_rate);
        formatter.field("frequency", &self.frequency);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("gateways", &self.gateways);
        formatter.finish()
    }
}
/// See [`LoRaWanDeviceMetadata`](crate::model::LoRaWanDeviceMetadata)
pub mod lo_ra_wan_device_metadata {
    /// A builder for [`LoRaWanDeviceMetadata`](crate::model::LoRaWanDeviceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_eui: std::option::Option<std::string::String>,
        pub(crate) f_port: std::option::Option<i32>,
        pub(crate) data_rate: std::option::Option<i32>,
        pub(crate) frequency: std::option::Option<i32>,
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) gateways:
            std::option::Option<std::vec::Vec<crate::model::LoRaWanGatewayMetadata>>,
    }
    impl Builder {
        /// <p>The DevEUI value.</p>
        pub fn dev_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.dev_eui = Some(input.into());
            self
        }
        /// <p>The DevEUI value.</p>
        pub fn set_dev_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dev_eui = input;
            self
        }
        /// <p>The FPort value.</p>
        pub fn f_port(mut self, input: i32) -> Self {
            self.f_port = Some(input);
            self
        }
        /// <p>The FPort value.</p>
        pub fn set_f_port(mut self, input: std::option::Option<i32>) -> Self {
            self.f_port = input;
            self
        }
        /// <p>The DataRate value.</p>
        pub fn data_rate(mut self, input: i32) -> Self {
            self.data_rate = Some(input);
            self
        }
        /// <p>The DataRate value.</p>
        pub fn set_data_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.data_rate = input;
            self
        }
        /// <p>The device's channel frequency in Hz.</p>
        pub fn frequency(mut self, input: i32) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The device's channel frequency in Hz.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The date and time of the metadata.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The date and time of the metadata.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// Appends an item to `gateways`.
        ///
        /// To override the contents of this collection use [`set_gateways`](Self::set_gateways).
        ///
        /// <p>Information about the gateways accessed by the device.</p>
        pub fn gateways(mut self, input: impl Into<crate::model::LoRaWanGatewayMetadata>) -> Self {
            let mut v = self.gateways.unwrap_or_default();
            v.push(input.into());
            self.gateways = Some(v);
            self
        }
        /// <p>Information about the gateways accessed by the device.</p>
        pub fn set_gateways(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoRaWanGatewayMetadata>>,
        ) -> Self {
            self.gateways = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanDeviceMetadata`](crate::model::LoRaWanDeviceMetadata)
        pub fn build(self) -> crate::model::LoRaWanDeviceMetadata {
            crate::model::LoRaWanDeviceMetadata {
                dev_eui: self.dev_eui,
                f_port: self.f_port,
                data_rate: self.data_rate,
                frequency: self.frequency,
                timestamp: self.timestamp,
                gateways: self.gateways,
            }
        }
    }
}
impl LoRaWanDeviceMetadata {
    /// Creates a new builder-style object to manufacture [`LoRaWanDeviceMetadata`](crate::model::LoRaWanDeviceMetadata)
    pub fn builder() -> crate::model::lo_ra_wan_device_metadata::Builder {
        crate::model::lo_ra_wan_device_metadata::Builder::default()
    }
}

/// <p>LoRaWAN gateway metatdata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanGatewayMetadata {
    /// <p>The gateway's EUI value.</p>
    pub gateway_eui: std::option::Option<std::string::String>,
    /// <p>The SNR value.</p>
    pub snr: std::option::Option<f64>,
    /// <p>The RSSI value.</p>
    pub rssi: std::option::Option<f64>,
}
impl LoRaWanGatewayMetadata {
    /// <p>The gateway's EUI value.</p>
    pub fn gateway_eui(&self) -> std::option::Option<&str> {
        self.gateway_eui.as_deref()
    }
    /// <p>The SNR value.</p>
    pub fn snr(&self) -> std::option::Option<f64> {
        self.snr
    }
    /// <p>The RSSI value.</p>
    pub fn rssi(&self) -> std::option::Option<f64> {
        self.rssi
    }
}
impl std::fmt::Debug for LoRaWanGatewayMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanGatewayMetadata");
        formatter.field("gateway_eui", &self.gateway_eui);
        formatter.field("snr", &self.snr);
        formatter.field("rssi", &self.rssi);
        formatter.finish()
    }
}
/// See [`LoRaWanGatewayMetadata`](crate::model::LoRaWanGatewayMetadata)
pub mod lo_ra_wan_gateway_metadata {
    /// A builder for [`LoRaWanGatewayMetadata`](crate::model::LoRaWanGatewayMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_eui: std::option::Option<std::string::String>,
        pub(crate) snr: std::option::Option<f64>,
        pub(crate) rssi: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The gateway's EUI value.</p>
        pub fn gateway_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_eui = Some(input.into());
            self
        }
        /// <p>The gateway's EUI value.</p>
        pub fn set_gateway_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_eui = input;
            self
        }
        /// <p>The SNR value.</p>
        pub fn snr(mut self, input: f64) -> Self {
            self.snr = Some(input);
            self
        }
        /// <p>The SNR value.</p>
        pub fn set_snr(mut self, input: std::option::Option<f64>) -> Self {
            self.snr = input;
            self
        }
        /// <p>The RSSI value.</p>
        pub fn rssi(mut self, input: f64) -> Self {
            self.rssi = Some(input);
            self
        }
        /// <p>The RSSI value.</p>
        pub fn set_rssi(mut self, input: std::option::Option<f64>) -> Self {
            self.rssi = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanGatewayMetadata`](crate::model::LoRaWanGatewayMetadata)
        pub fn build(self) -> crate::model::LoRaWanGatewayMetadata {
            crate::model::LoRaWanGatewayMetadata {
                gateway_eui: self.gateway_eui,
                snr: self.snr,
                rssi: self.rssi,
            }
        }
    }
}
impl LoRaWanGatewayMetadata {
    /// Creates a new builder-style object to manufacture [`LoRaWanGatewayMetadata`](crate::model::LoRaWanGatewayMetadata)
    pub fn builder() -> crate::model::lo_ra_wan_gateway_metadata::Builder {
        crate::model::lo_ra_wan_gateway_metadata::Builder::default()
    }
}

/// <p>Sidewalk device object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkDevice {
    /// <p>The Sidewalk Amazon ID.</p>
    pub amazon_id: std::option::Option<std::string::String>,
    /// <p>The sidewalk device identification.</p>
    pub sidewalk_id: std::option::Option<std::string::String>,
    /// <p>The Sidewalk manufacturing series number.</p>
    pub sidewalk_manufacturing_sn: std::option::Option<std::string::String>,
    /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
    pub device_certificates: std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
}
impl SidewalkDevice {
    /// <p>The Sidewalk Amazon ID.</p>
    pub fn amazon_id(&self) -> std::option::Option<&str> {
        self.amazon_id.as_deref()
    }
    /// <p>The sidewalk device identification.</p>
    pub fn sidewalk_id(&self) -> std::option::Option<&str> {
        self.sidewalk_id.as_deref()
    }
    /// <p>The Sidewalk manufacturing series number.</p>
    pub fn sidewalk_manufacturing_sn(&self) -> std::option::Option<&str> {
        self.sidewalk_manufacturing_sn.as_deref()
    }
    /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
    pub fn device_certificates(&self) -> std::option::Option<&[crate::model::CertificateList]> {
        self.device_certificates.as_deref()
    }
}
impl std::fmt::Debug for SidewalkDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkDevice");
        formatter.field("amazon_id", &self.amazon_id);
        formatter.field("sidewalk_id", &self.sidewalk_id);
        formatter.field("sidewalk_manufacturing_sn", &self.sidewalk_manufacturing_sn);
        formatter.field("device_certificates", &self.device_certificates);
        formatter.finish()
    }
}
/// See [`SidewalkDevice`](crate::model::SidewalkDevice)
pub mod sidewalk_device {
    /// A builder for [`SidewalkDevice`](crate::model::SidewalkDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_id: std::option::Option<std::string::String>,
        pub(crate) sidewalk_id: std::option::Option<std::string::String>,
        pub(crate) sidewalk_manufacturing_sn: std::option::Option<std::string::String>,
        pub(crate) device_certificates:
            std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
    }
    impl Builder {
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn amazon_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_id = Some(input.into());
            self
        }
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amazon_id = input;
            self
        }
        /// <p>The sidewalk device identification.</p>
        pub fn sidewalk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sidewalk_id = Some(input.into());
            self
        }
        /// <p>The sidewalk device identification.</p>
        pub fn set_sidewalk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sidewalk_id = input;
            self
        }
        /// <p>The Sidewalk manufacturing series number.</p>
        pub fn sidewalk_manufacturing_sn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sidewalk_manufacturing_sn = Some(input.into());
            self
        }
        /// <p>The Sidewalk manufacturing series number.</p>
        pub fn set_sidewalk_manufacturing_sn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sidewalk_manufacturing_sn = input;
            self
        }
        /// Appends an item to `device_certificates`.
        ///
        /// To override the contents of this collection use [`set_device_certificates`](Self::set_device_certificates).
        ///
        /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
        pub fn device_certificates(
            mut self,
            input: impl Into<crate::model::CertificateList>,
        ) -> Self {
            let mut v = self.device_certificates.unwrap_or_default();
            v.push(input.into());
            self.device_certificates = Some(v);
            self
        }
        /// <p>The sidewalk device certificates for Ed25519 and P256r1.</p>
        pub fn set_device_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateList>>,
        ) -> Self {
            self.device_certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkDevice`](crate::model::SidewalkDevice)
        pub fn build(self) -> crate::model::SidewalkDevice {
            crate::model::SidewalkDevice {
                amazon_id: self.amazon_id,
                sidewalk_id: self.sidewalk_id,
                sidewalk_manufacturing_sn: self.sidewalk_manufacturing_sn,
                device_certificates: self.device_certificates,
            }
        }
    }
}
impl SidewalkDevice {
    /// Creates a new builder-style object to manufacture [`SidewalkDevice`](crate::model::SidewalkDevice)
    pub fn builder() -> crate::model::sidewalk_device::Builder {
        crate::model::sidewalk_device::Builder::default()
    }
}

/// <p>LoRaWAN object for create functions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanDevice {
    /// <p>The DevEUI value.</p>
    pub dev_eui: std::option::Option<std::string::String>,
    /// <p>The ID of the device profile for the new wireless device.</p>
    pub device_profile_id: std::option::Option<std::string::String>,
    /// <p>The ID of the service profile.</p>
    pub service_profile_id: std::option::Option<std::string::String>,
    /// <p>OTAA device object for v1.1 for create APIs</p>
    pub otaa_v1_1: std::option::Option<crate::model::OtaaV11>,
    /// <p>OTAA device object for create APIs for v1.0.x</p>
    pub otaa_v1_0_x: std::option::Option<crate::model::OtaaV10X>,
    /// <p>ABP device object for create APIs for v1.1</p>
    pub abp_v1_1: std::option::Option<crate::model::AbpV11>,
    /// <p>LoRaWAN object for create APIs</p>
    pub abp_v1_0_x: std::option::Option<crate::model::AbpV10X>,
    /// <p>List of FPort assigned for different LoRaWAN application packages to use</p>
    pub f_ports: std::option::Option<crate::model::FPorts>,
}
impl LoRaWanDevice {
    /// <p>The DevEUI value.</p>
    pub fn dev_eui(&self) -> std::option::Option<&str> {
        self.dev_eui.as_deref()
    }
    /// <p>The ID of the device profile for the new wireless device.</p>
    pub fn device_profile_id(&self) -> std::option::Option<&str> {
        self.device_profile_id.as_deref()
    }
    /// <p>The ID of the service profile.</p>
    pub fn service_profile_id(&self) -> std::option::Option<&str> {
        self.service_profile_id.as_deref()
    }
    /// <p>OTAA device object for v1.1 for create APIs</p>
    pub fn otaa_v1_1(&self) -> std::option::Option<&crate::model::OtaaV11> {
        self.otaa_v1_1.as_ref()
    }
    /// <p>OTAA device object for create APIs for v1.0.x</p>
    pub fn otaa_v1_0_x(&self) -> std::option::Option<&crate::model::OtaaV10X> {
        self.otaa_v1_0_x.as_ref()
    }
    /// <p>ABP device object for create APIs for v1.1</p>
    pub fn abp_v1_1(&self) -> std::option::Option<&crate::model::AbpV11> {
        self.abp_v1_1.as_ref()
    }
    /// <p>LoRaWAN object for create APIs</p>
    pub fn abp_v1_0_x(&self) -> std::option::Option<&crate::model::AbpV10X> {
        self.abp_v1_0_x.as_ref()
    }
    /// <p>List of FPort assigned for different LoRaWAN application packages to use</p>
    pub fn f_ports(&self) -> std::option::Option<&crate::model::FPorts> {
        self.f_ports.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanDevice");
        formatter.field("dev_eui", &self.dev_eui);
        formatter.field("device_profile_id", &self.device_profile_id);
        formatter.field("service_profile_id", &self.service_profile_id);
        formatter.field("otaa_v1_1", &self.otaa_v1_1);
        formatter.field("otaa_v1_0_x", &self.otaa_v1_0_x);
        formatter.field("abp_v1_1", &self.abp_v1_1);
        formatter.field("abp_v1_0_x", &self.abp_v1_0_x);
        formatter.field("f_ports", &self.f_ports);
        formatter.finish()
    }
}
/// See [`LoRaWanDevice`](crate::model::LoRaWanDevice)
pub mod lo_ra_wan_device {
    /// A builder for [`LoRaWanDevice`](crate::model::LoRaWanDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_eui: std::option::Option<std::string::String>,
        pub(crate) device_profile_id: std::option::Option<std::string::String>,
        pub(crate) service_profile_id: std::option::Option<std::string::String>,
        pub(crate) otaa_v1_1: std::option::Option<crate::model::OtaaV11>,
        pub(crate) otaa_v1_0_x: std::option::Option<crate::model::OtaaV10X>,
        pub(crate) abp_v1_1: std::option::Option<crate::model::AbpV11>,
        pub(crate) abp_v1_0_x: std::option::Option<crate::model::AbpV10X>,
        pub(crate) f_ports: std::option::Option<crate::model::FPorts>,
    }
    impl Builder {
        /// <p>The DevEUI value.</p>
        pub fn dev_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.dev_eui = Some(input.into());
            self
        }
        /// <p>The DevEUI value.</p>
        pub fn set_dev_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dev_eui = input;
            self
        }
        /// <p>The ID of the device profile for the new wireless device.</p>
        pub fn device_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the device profile for the new wireless device.</p>
        pub fn set_device_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_profile_id = input;
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn service_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_profile_id = Some(input.into());
            self
        }
        /// <p>The ID of the service profile.</p>
        pub fn set_service_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_profile_id = input;
            self
        }
        /// <p>OTAA device object for v1.1 for create APIs</p>
        pub fn otaa_v1_1(mut self, input: crate::model::OtaaV11) -> Self {
            self.otaa_v1_1 = Some(input);
            self
        }
        /// <p>OTAA device object for v1.1 for create APIs</p>
        pub fn set_otaa_v1_1(mut self, input: std::option::Option<crate::model::OtaaV11>) -> Self {
            self.otaa_v1_1 = input;
            self
        }
        /// <p>OTAA device object for create APIs for v1.0.x</p>
        pub fn otaa_v1_0_x(mut self, input: crate::model::OtaaV10X) -> Self {
            self.otaa_v1_0_x = Some(input);
            self
        }
        /// <p>OTAA device object for create APIs for v1.0.x</p>
        pub fn set_otaa_v1_0_x(
            mut self,
            input: std::option::Option<crate::model::OtaaV10X>,
        ) -> Self {
            self.otaa_v1_0_x = input;
            self
        }
        /// <p>ABP device object for create APIs for v1.1</p>
        pub fn abp_v1_1(mut self, input: crate::model::AbpV11) -> Self {
            self.abp_v1_1 = Some(input);
            self
        }
        /// <p>ABP device object for create APIs for v1.1</p>
        pub fn set_abp_v1_1(mut self, input: std::option::Option<crate::model::AbpV11>) -> Self {
            self.abp_v1_1 = input;
            self
        }
        /// <p>LoRaWAN object for create APIs</p>
        pub fn abp_v1_0_x(mut self, input: crate::model::AbpV10X) -> Self {
            self.abp_v1_0_x = Some(input);
            self
        }
        /// <p>LoRaWAN object for create APIs</p>
        pub fn set_abp_v1_0_x(mut self, input: std::option::Option<crate::model::AbpV10X>) -> Self {
            self.abp_v1_0_x = input;
            self
        }
        /// <p>List of FPort assigned for different LoRaWAN application packages to use</p>
        pub fn f_ports(mut self, input: crate::model::FPorts) -> Self {
            self.f_ports = Some(input);
            self
        }
        /// <p>List of FPort assigned for different LoRaWAN application packages to use</p>
        pub fn set_f_ports(mut self, input: std::option::Option<crate::model::FPorts>) -> Self {
            self.f_ports = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanDevice`](crate::model::LoRaWanDevice)
        pub fn build(self) -> crate::model::LoRaWanDevice {
            crate::model::LoRaWanDevice {
                dev_eui: self.dev_eui,
                device_profile_id: self.device_profile_id,
                service_profile_id: self.service_profile_id,
                otaa_v1_1: self.otaa_v1_1,
                otaa_v1_0_x: self.otaa_v1_0_x,
                abp_v1_1: self.abp_v1_1,
                abp_v1_0_x: self.abp_v1_0_x,
                f_ports: self.f_ports,
            }
        }
    }
}
impl LoRaWanDevice {
    /// Creates a new builder-style object to manufacture [`LoRaWanDevice`](crate::model::LoRaWanDevice)
    pub fn builder() -> crate::model::lo_ra_wan_device::Builder {
        crate::model::lo_ra_wan_device::Builder::default()
    }
}

/// <p>List of FPort assigned for different LoRaWAN application packages to use</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FPorts {
    /// <p>The Fport value.</p>
    pub fuota: std::option::Option<i32>,
    /// <p>The Fport value.</p>
    pub multicast: std::option::Option<i32>,
    /// <p>The Fport value.</p>
    pub clock_sync: std::option::Option<i32>,
}
impl FPorts {
    /// <p>The Fport value.</p>
    pub fn fuota(&self) -> std::option::Option<i32> {
        self.fuota
    }
    /// <p>The Fport value.</p>
    pub fn multicast(&self) -> std::option::Option<i32> {
        self.multicast
    }
    /// <p>The Fport value.</p>
    pub fn clock_sync(&self) -> std::option::Option<i32> {
        self.clock_sync
    }
}
impl std::fmt::Debug for FPorts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FPorts");
        formatter.field("fuota", &self.fuota);
        formatter.field("multicast", &self.multicast);
        formatter.field("clock_sync", &self.clock_sync);
        formatter.finish()
    }
}
/// See [`FPorts`](crate::model::FPorts)
pub mod f_ports {
    /// A builder for [`FPorts`](crate::model::FPorts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fuota: std::option::Option<i32>,
        pub(crate) multicast: std::option::Option<i32>,
        pub(crate) clock_sync: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Fport value.</p>
        pub fn fuota(mut self, input: i32) -> Self {
            self.fuota = Some(input);
            self
        }
        /// <p>The Fport value.</p>
        pub fn set_fuota(mut self, input: std::option::Option<i32>) -> Self {
            self.fuota = input;
            self
        }
        /// <p>The Fport value.</p>
        pub fn multicast(mut self, input: i32) -> Self {
            self.multicast = Some(input);
            self
        }
        /// <p>The Fport value.</p>
        pub fn set_multicast(mut self, input: std::option::Option<i32>) -> Self {
            self.multicast = input;
            self
        }
        /// <p>The Fport value.</p>
        pub fn clock_sync(mut self, input: i32) -> Self {
            self.clock_sync = Some(input);
            self
        }
        /// <p>The Fport value.</p>
        pub fn set_clock_sync(mut self, input: std::option::Option<i32>) -> Self {
            self.clock_sync = input;
            self
        }
        /// Consumes the builder and constructs a [`FPorts`](crate::model::FPorts)
        pub fn build(self) -> crate::model::FPorts {
            crate::model::FPorts {
                fuota: self.fuota,
                multicast: self.multicast,
                clock_sync: self.clock_sync,
            }
        }
    }
}
impl FPorts {
    /// Creates a new builder-style object to manufacture [`FPorts`](crate::model::FPorts)
    pub fn builder() -> crate::model::f_ports::Builder {
        crate::model::f_ports::Builder::default()
    }
}

/// <p>ABP device object for LoRaWAN specification v1.0.x</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbpV10X {
    /// <p>The DevAddr value.</p>
    pub dev_addr: std::option::Option<std::string::String>,
    /// <p>Session keys for ABP v1.0.x</p>
    pub session_keys: std::option::Option<crate::model::SessionKeysAbpV10X>,
}
impl AbpV10X {
    /// <p>The DevAddr value.</p>
    pub fn dev_addr(&self) -> std::option::Option<&str> {
        self.dev_addr.as_deref()
    }
    /// <p>Session keys for ABP v1.0.x</p>
    pub fn session_keys(&self) -> std::option::Option<&crate::model::SessionKeysAbpV10X> {
        self.session_keys.as_ref()
    }
}
impl std::fmt::Debug for AbpV10X {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbpV10X");
        formatter.field("dev_addr", &self.dev_addr);
        formatter.field("session_keys", &self.session_keys);
        formatter.finish()
    }
}
/// See [`AbpV10X`](crate::model::AbpV10X)
pub mod abp_v10_x {
    /// A builder for [`AbpV10X`](crate::model::AbpV10X)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_addr: std::option::Option<std::string::String>,
        pub(crate) session_keys: std::option::Option<crate::model::SessionKeysAbpV10X>,
    }
    impl Builder {
        /// <p>The DevAddr value.</p>
        pub fn dev_addr(mut self, input: impl Into<std::string::String>) -> Self {
            self.dev_addr = Some(input.into());
            self
        }
        /// <p>The DevAddr value.</p>
        pub fn set_dev_addr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dev_addr = input;
            self
        }
        /// <p>Session keys for ABP v1.0.x</p>
        pub fn session_keys(mut self, input: crate::model::SessionKeysAbpV10X) -> Self {
            self.session_keys = Some(input);
            self
        }
        /// <p>Session keys for ABP v1.0.x</p>
        pub fn set_session_keys(
            mut self,
            input: std::option::Option<crate::model::SessionKeysAbpV10X>,
        ) -> Self {
            self.session_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AbpV10X`](crate::model::AbpV10X)
        pub fn build(self) -> crate::model::AbpV10X {
            crate::model::AbpV10X {
                dev_addr: self.dev_addr,
                session_keys: self.session_keys,
            }
        }
    }
}
impl AbpV10X {
    /// Creates a new builder-style object to manufacture [`AbpV10X`](crate::model::AbpV10X)
    pub fn builder() -> crate::model::abp_v10_x::Builder {
        crate::model::abp_v10_x::Builder::default()
    }
}

/// <p>Session keys for ABP v1.1</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionKeysAbpV10X {
    /// <p>The NwkSKey value.</p>
    pub nwk_s_key: std::option::Option<std::string::String>,
    /// <p>The AppSKey value.</p>
    pub app_s_key: std::option::Option<std::string::String>,
}
impl SessionKeysAbpV10X {
    /// <p>The NwkSKey value.</p>
    pub fn nwk_s_key(&self) -> std::option::Option<&str> {
        self.nwk_s_key.as_deref()
    }
    /// <p>The AppSKey value.</p>
    pub fn app_s_key(&self) -> std::option::Option<&str> {
        self.app_s_key.as_deref()
    }
}
impl std::fmt::Debug for SessionKeysAbpV10X {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionKeysAbpV10X");
        formatter.field("nwk_s_key", &self.nwk_s_key);
        formatter.field("app_s_key", &self.app_s_key);
        formatter.finish()
    }
}
/// See [`SessionKeysAbpV10X`](crate::model::SessionKeysAbpV10X)
pub mod session_keys_abp_v10_x {
    /// A builder for [`SessionKeysAbpV10X`](crate::model::SessionKeysAbpV10X)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nwk_s_key: std::option::Option<std::string::String>,
        pub(crate) app_s_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The NwkSKey value.</p>
        pub fn nwk_s_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.nwk_s_key = Some(input.into());
            self
        }
        /// <p>The NwkSKey value.</p>
        pub fn set_nwk_s_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nwk_s_key = input;
            self
        }
        /// <p>The AppSKey value.</p>
        pub fn app_s_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_s_key = Some(input.into());
            self
        }
        /// <p>The AppSKey value.</p>
        pub fn set_app_s_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_s_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionKeysAbpV10X`](crate::model::SessionKeysAbpV10X)
        pub fn build(self) -> crate::model::SessionKeysAbpV10X {
            crate::model::SessionKeysAbpV10X {
                nwk_s_key: self.nwk_s_key,
                app_s_key: self.app_s_key,
            }
        }
    }
}
impl SessionKeysAbpV10X {
    /// Creates a new builder-style object to manufacture [`SessionKeysAbpV10X`](crate::model::SessionKeysAbpV10X)
    pub fn builder() -> crate::model::session_keys_abp_v10_x::Builder {
        crate::model::session_keys_abp_v10_x::Builder::default()
    }
}

/// <p>ABP device object for LoRaWAN specification v1.1</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbpV11 {
    /// <p>The DevAddr value.</p>
    pub dev_addr: std::option::Option<std::string::String>,
    /// <p>Session keys for ABP v1.1</p>
    pub session_keys: std::option::Option<crate::model::SessionKeysAbpV11>,
}
impl AbpV11 {
    /// <p>The DevAddr value.</p>
    pub fn dev_addr(&self) -> std::option::Option<&str> {
        self.dev_addr.as_deref()
    }
    /// <p>Session keys for ABP v1.1</p>
    pub fn session_keys(&self) -> std::option::Option<&crate::model::SessionKeysAbpV11> {
        self.session_keys.as_ref()
    }
}
impl std::fmt::Debug for AbpV11 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbpV11");
        formatter.field("dev_addr", &self.dev_addr);
        formatter.field("session_keys", &self.session_keys);
        formatter.finish()
    }
}
/// See [`AbpV11`](crate::model::AbpV11)
pub mod abp_v11 {
    /// A builder for [`AbpV11`](crate::model::AbpV11)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_addr: std::option::Option<std::string::String>,
        pub(crate) session_keys: std::option::Option<crate::model::SessionKeysAbpV11>,
    }
    impl Builder {
        /// <p>The DevAddr value.</p>
        pub fn dev_addr(mut self, input: impl Into<std::string::String>) -> Self {
            self.dev_addr = Some(input.into());
            self
        }
        /// <p>The DevAddr value.</p>
        pub fn set_dev_addr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dev_addr = input;
            self
        }
        /// <p>Session keys for ABP v1.1</p>
        pub fn session_keys(mut self, input: crate::model::SessionKeysAbpV11) -> Self {
            self.session_keys = Some(input);
            self
        }
        /// <p>Session keys for ABP v1.1</p>
        pub fn set_session_keys(
            mut self,
            input: std::option::Option<crate::model::SessionKeysAbpV11>,
        ) -> Self {
            self.session_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`AbpV11`](crate::model::AbpV11)
        pub fn build(self) -> crate::model::AbpV11 {
            crate::model::AbpV11 {
                dev_addr: self.dev_addr,
                session_keys: self.session_keys,
            }
        }
    }
}
impl AbpV11 {
    /// Creates a new builder-style object to manufacture [`AbpV11`](crate::model::AbpV11)
    pub fn builder() -> crate::model::abp_v11::Builder {
        crate::model::abp_v11::Builder::default()
    }
}

/// <p>Session keys for ABP v1.1</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionKeysAbpV11 {
    /// <p>The FNwkSIntKey value.</p>
    pub f_nwk_s_int_key: std::option::Option<std::string::String>,
    /// <p>The SNwkSIntKey value.</p>
    pub s_nwk_s_int_key: std::option::Option<std::string::String>,
    /// <p>The NwkSEncKey value.</p>
    pub nwk_s_enc_key: std::option::Option<std::string::String>,
    /// <p>The AppSKey value.</p>
    pub app_s_key: std::option::Option<std::string::String>,
}
impl SessionKeysAbpV11 {
    /// <p>The FNwkSIntKey value.</p>
    pub fn f_nwk_s_int_key(&self) -> std::option::Option<&str> {
        self.f_nwk_s_int_key.as_deref()
    }
    /// <p>The SNwkSIntKey value.</p>
    pub fn s_nwk_s_int_key(&self) -> std::option::Option<&str> {
        self.s_nwk_s_int_key.as_deref()
    }
    /// <p>The NwkSEncKey value.</p>
    pub fn nwk_s_enc_key(&self) -> std::option::Option<&str> {
        self.nwk_s_enc_key.as_deref()
    }
    /// <p>The AppSKey value.</p>
    pub fn app_s_key(&self) -> std::option::Option<&str> {
        self.app_s_key.as_deref()
    }
}
impl std::fmt::Debug for SessionKeysAbpV11 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionKeysAbpV11");
        formatter.field("f_nwk_s_int_key", &self.f_nwk_s_int_key);
        formatter.field("s_nwk_s_int_key", &self.s_nwk_s_int_key);
        formatter.field("nwk_s_enc_key", &self.nwk_s_enc_key);
        formatter.field("app_s_key", &self.app_s_key);
        formatter.finish()
    }
}
/// See [`SessionKeysAbpV11`](crate::model::SessionKeysAbpV11)
pub mod session_keys_abp_v11 {
    /// A builder for [`SessionKeysAbpV11`](crate::model::SessionKeysAbpV11)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) f_nwk_s_int_key: std::option::Option<std::string::String>,
        pub(crate) s_nwk_s_int_key: std::option::Option<std::string::String>,
        pub(crate) nwk_s_enc_key: std::option::Option<std::string::String>,
        pub(crate) app_s_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The FNwkSIntKey value.</p>
        pub fn f_nwk_s_int_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.f_nwk_s_int_key = Some(input.into());
            self
        }
        /// <p>The FNwkSIntKey value.</p>
        pub fn set_f_nwk_s_int_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.f_nwk_s_int_key = input;
            self
        }
        /// <p>The SNwkSIntKey value.</p>
        pub fn s_nwk_s_int_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s_nwk_s_int_key = Some(input.into());
            self
        }
        /// <p>The SNwkSIntKey value.</p>
        pub fn set_s_nwk_s_int_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s_nwk_s_int_key = input;
            self
        }
        /// <p>The NwkSEncKey value.</p>
        pub fn nwk_s_enc_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.nwk_s_enc_key = Some(input.into());
            self
        }
        /// <p>The NwkSEncKey value.</p>
        pub fn set_nwk_s_enc_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nwk_s_enc_key = input;
            self
        }
        /// <p>The AppSKey value.</p>
        pub fn app_s_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_s_key = Some(input.into());
            self
        }
        /// <p>The AppSKey value.</p>
        pub fn set_app_s_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_s_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionKeysAbpV11`](crate::model::SessionKeysAbpV11)
        pub fn build(self) -> crate::model::SessionKeysAbpV11 {
            crate::model::SessionKeysAbpV11 {
                f_nwk_s_int_key: self.f_nwk_s_int_key,
                s_nwk_s_int_key: self.s_nwk_s_int_key,
                nwk_s_enc_key: self.nwk_s_enc_key,
                app_s_key: self.app_s_key,
            }
        }
    }
}
impl SessionKeysAbpV11 {
    /// Creates a new builder-style object to manufacture [`SessionKeysAbpV11`](crate::model::SessionKeysAbpV11)
    pub fn builder() -> crate::model::session_keys_abp_v11::Builder {
        crate::model::session_keys_abp_v11::Builder::default()
    }
}

/// <p>OTAA device object for v1.0.x</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaaV10X {
    /// <p>The AppKey value.</p>
    pub app_key: std::option::Option<std::string::String>,
    /// <p>The AppEUI value.</p>
    pub app_eui: std::option::Option<std::string::String>,
    /// <p>The GenAppKey value.</p>
    pub gen_app_key: std::option::Option<std::string::String>,
}
impl OtaaV10X {
    /// <p>The AppKey value.</p>
    pub fn app_key(&self) -> std::option::Option<&str> {
        self.app_key.as_deref()
    }
    /// <p>The AppEUI value.</p>
    pub fn app_eui(&self) -> std::option::Option<&str> {
        self.app_eui.as_deref()
    }
    /// <p>The GenAppKey value.</p>
    pub fn gen_app_key(&self) -> std::option::Option<&str> {
        self.gen_app_key.as_deref()
    }
}
impl std::fmt::Debug for OtaaV10X {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaaV10X");
        formatter.field("app_key", &self.app_key);
        formatter.field("app_eui", &self.app_eui);
        formatter.field("gen_app_key", &self.gen_app_key);
        formatter.finish()
    }
}
/// See [`OtaaV10X`](crate::model::OtaaV10X)
pub mod otaa_v10_x {
    /// A builder for [`OtaaV10X`](crate::model::OtaaV10X)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_key: std::option::Option<std::string::String>,
        pub(crate) app_eui: std::option::Option<std::string::String>,
        pub(crate) gen_app_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AppKey value.</p>
        pub fn app_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_key = Some(input.into());
            self
        }
        /// <p>The AppKey value.</p>
        pub fn set_app_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_key = input;
            self
        }
        /// <p>The AppEUI value.</p>
        pub fn app_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_eui = Some(input.into());
            self
        }
        /// <p>The AppEUI value.</p>
        pub fn set_app_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_eui = input;
            self
        }
        /// <p>The GenAppKey value.</p>
        pub fn gen_app_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.gen_app_key = Some(input.into());
            self
        }
        /// <p>The GenAppKey value.</p>
        pub fn set_gen_app_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gen_app_key = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaaV10X`](crate::model::OtaaV10X)
        pub fn build(self) -> crate::model::OtaaV10X {
            crate::model::OtaaV10X {
                app_key: self.app_key,
                app_eui: self.app_eui,
                gen_app_key: self.gen_app_key,
            }
        }
    }
}
impl OtaaV10X {
    /// Creates a new builder-style object to manufacture [`OtaaV10X`](crate::model::OtaaV10X)
    pub fn builder() -> crate::model::otaa_v10_x::Builder {
        crate::model::otaa_v10_x::Builder::default()
    }
}

/// <p>OTAA device object for v1.1</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaaV11 {
    /// <p>The AppKey value.</p>
    pub app_key: std::option::Option<std::string::String>,
    /// <p>The NwkKey value.</p>
    pub nwk_key: std::option::Option<std::string::String>,
    /// <p>The JoinEUI value.</p>
    pub join_eui: std::option::Option<std::string::String>,
}
impl OtaaV11 {
    /// <p>The AppKey value.</p>
    pub fn app_key(&self) -> std::option::Option<&str> {
        self.app_key.as_deref()
    }
    /// <p>The NwkKey value.</p>
    pub fn nwk_key(&self) -> std::option::Option<&str> {
        self.nwk_key.as_deref()
    }
    /// <p>The JoinEUI value.</p>
    pub fn join_eui(&self) -> std::option::Option<&str> {
        self.join_eui.as_deref()
    }
}
impl std::fmt::Debug for OtaaV11 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaaV11");
        formatter.field("app_key", &self.app_key);
        formatter.field("nwk_key", &self.nwk_key);
        formatter.field("join_eui", &self.join_eui);
        formatter.finish()
    }
}
/// See [`OtaaV11`](crate::model::OtaaV11)
pub mod otaa_v11 {
    /// A builder for [`OtaaV11`](crate::model::OtaaV11)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_key: std::option::Option<std::string::String>,
        pub(crate) nwk_key: std::option::Option<std::string::String>,
        pub(crate) join_eui: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AppKey value.</p>
        pub fn app_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_key = Some(input.into());
            self
        }
        /// <p>The AppKey value.</p>
        pub fn set_app_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_key = input;
            self
        }
        /// <p>The NwkKey value.</p>
        pub fn nwk_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.nwk_key = Some(input.into());
            self
        }
        /// <p>The NwkKey value.</p>
        pub fn set_nwk_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nwk_key = input;
            self
        }
        /// <p>The JoinEUI value.</p>
        pub fn join_eui(mut self, input: impl Into<std::string::String>) -> Self {
            self.join_eui = Some(input.into());
            self
        }
        /// <p>The JoinEUI value.</p>
        pub fn set_join_eui(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.join_eui = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaaV11`](crate::model::OtaaV11)
        pub fn build(self) -> crate::model::OtaaV11 {
            crate::model::OtaaV11 {
                app_key: self.app_key,
                nwk_key: self.nwk_key,
                join_eui: self.join_eui,
            }
        }
    }
}
impl OtaaV11 {
    /// Creates a new builder-style object to manufacture [`OtaaV11`](crate::model::OtaaV11)
    pub fn builder() -> crate::model::otaa_v11::Builder {
        crate::model::otaa_v11::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessDeviceIdType {
    #[allow(missing_docs)] // documentation missing in model
    DevEui,
    #[allow(missing_docs)] // documentation missing in model
    SidewalkManufacturingSn,
    #[allow(missing_docs)] // documentation missing in model
    ThingName,
    #[allow(missing_docs)] // documentation missing in model
    WirelessDeviceId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessDeviceIdType {
    fn from(s: &str) -> Self {
        match s {
            "DevEui" => WirelessDeviceIdType::DevEui,
            "SidewalkManufacturingSn" => WirelessDeviceIdType::SidewalkManufacturingSn,
            "ThingName" => WirelessDeviceIdType::ThingName,
            "WirelessDeviceId" => WirelessDeviceIdType::WirelessDeviceId,
            other => WirelessDeviceIdType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessDeviceIdType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessDeviceIdType::from(s))
    }
}
impl WirelessDeviceIdType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessDeviceIdType::DevEui => "DevEui",
            WirelessDeviceIdType::SidewalkManufacturingSn => "SidewalkManufacturingSn",
            WirelessDeviceIdType::ThingName => "ThingName",
            WirelessDeviceIdType::WirelessDeviceId => "WirelessDeviceId",
            WirelessDeviceIdType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DevEui",
            "SidewalkManufacturingSn",
            "ThingName",
            "WirelessDeviceId",
        ]
    }
}
impl AsRef<str> for WirelessDeviceIdType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWANGetServiceProfileInfo object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanGetServiceProfileInfo {
    /// <p>The ULRate value.</p>
    pub ul_rate: std::option::Option<i32>,
    /// <p>The ULBucketSize value.</p>
    pub ul_bucket_size: std::option::Option<i32>,
    /// <p>The ULRatePolicy value.</p>
    pub ul_rate_policy: std::option::Option<std::string::String>,
    /// <p>The DLRate value.</p>
    pub dl_rate: std::option::Option<i32>,
    /// <p>The DLBucketSize value.</p>
    pub dl_bucket_size: std::option::Option<i32>,
    /// <p>The DLRatePolicy value.</p>
    pub dl_rate_policy: std::option::Option<std::string::String>,
    /// <p>The AddGWMetaData value.</p>
    pub add_gw_metadata: bool,
    /// <p>The DevStatusReqFreq value.</p>
    pub dev_status_req_freq: std::option::Option<i32>,
    /// <p>The ReportDevStatusBattery value.</p>
    pub report_dev_status_battery: bool,
    /// <p>The ReportDevStatusMargin value.</p>
    pub report_dev_status_margin: bool,
    /// <p>The DRMin value.</p>
    pub dr_min: i32,
    /// <p>The DRMax value.</p>
    pub dr_max: i32,
    /// <p>The ChannelMask value.</p>
    pub channel_mask: std::option::Option<std::string::String>,
    /// <p>The PRAllowed value that describes whether passive roaming is allowed.</p>
    pub pr_allowed: bool,
    /// <p>The HRAllowed value that describes whether handover roaming is allowed.</p>
    pub hr_allowed: bool,
    /// <p>The RAAllowed value that describes whether roaming activation is allowed.</p>
    pub ra_allowed: bool,
    /// <p>The NwkGeoLoc value.</p>
    pub nwk_geo_loc: bool,
    /// <p>The TargetPER value.</p>
    pub target_per: i32,
    /// <p>The MinGwDiversity value.</p>
    pub min_gw_diversity: std::option::Option<i32>,
}
impl LoRaWanGetServiceProfileInfo {
    /// <p>The ULRate value.</p>
    pub fn ul_rate(&self) -> std::option::Option<i32> {
        self.ul_rate
    }
    /// <p>The ULBucketSize value.</p>
    pub fn ul_bucket_size(&self) -> std::option::Option<i32> {
        self.ul_bucket_size
    }
    /// <p>The ULRatePolicy value.</p>
    pub fn ul_rate_policy(&self) -> std::option::Option<&str> {
        self.ul_rate_policy.as_deref()
    }
    /// <p>The DLRate value.</p>
    pub fn dl_rate(&self) -> std::option::Option<i32> {
        self.dl_rate
    }
    /// <p>The DLBucketSize value.</p>
    pub fn dl_bucket_size(&self) -> std::option::Option<i32> {
        self.dl_bucket_size
    }
    /// <p>The DLRatePolicy value.</p>
    pub fn dl_rate_policy(&self) -> std::option::Option<&str> {
        self.dl_rate_policy.as_deref()
    }
    /// <p>The AddGWMetaData value.</p>
    pub fn add_gw_metadata(&self) -> bool {
        self.add_gw_metadata
    }
    /// <p>The DevStatusReqFreq value.</p>
    pub fn dev_status_req_freq(&self) -> std::option::Option<i32> {
        self.dev_status_req_freq
    }
    /// <p>The ReportDevStatusBattery value.</p>
    pub fn report_dev_status_battery(&self) -> bool {
        self.report_dev_status_battery
    }
    /// <p>The ReportDevStatusMargin value.</p>
    pub fn report_dev_status_margin(&self) -> bool {
        self.report_dev_status_margin
    }
    /// <p>The DRMin value.</p>
    pub fn dr_min(&self) -> i32 {
        self.dr_min
    }
    /// <p>The DRMax value.</p>
    pub fn dr_max(&self) -> i32 {
        self.dr_max
    }
    /// <p>The ChannelMask value.</p>
    pub fn channel_mask(&self) -> std::option::Option<&str> {
        self.channel_mask.as_deref()
    }
    /// <p>The PRAllowed value that describes whether passive roaming is allowed.</p>
    pub fn pr_allowed(&self) -> bool {
        self.pr_allowed
    }
    /// <p>The HRAllowed value that describes whether handover roaming is allowed.</p>
    pub fn hr_allowed(&self) -> bool {
        self.hr_allowed
    }
    /// <p>The RAAllowed value that describes whether roaming activation is allowed.</p>
    pub fn ra_allowed(&self) -> bool {
        self.ra_allowed
    }
    /// <p>The NwkGeoLoc value.</p>
    pub fn nwk_geo_loc(&self) -> bool {
        self.nwk_geo_loc
    }
    /// <p>The TargetPER value.</p>
    pub fn target_per(&self) -> i32 {
        self.target_per
    }
    /// <p>The MinGwDiversity value.</p>
    pub fn min_gw_diversity(&self) -> std::option::Option<i32> {
        self.min_gw_diversity
    }
}
impl std::fmt::Debug for LoRaWanGetServiceProfileInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanGetServiceProfileInfo");
        formatter.field("ul_rate", &self.ul_rate);
        formatter.field("ul_bucket_size", &self.ul_bucket_size);
        formatter.field("ul_rate_policy", &self.ul_rate_policy);
        formatter.field("dl_rate", &self.dl_rate);
        formatter.field("dl_bucket_size", &self.dl_bucket_size);
        formatter.field("dl_rate_policy", &self.dl_rate_policy);
        formatter.field("add_gw_metadata", &self.add_gw_metadata);
        formatter.field("dev_status_req_freq", &self.dev_status_req_freq);
        formatter.field("report_dev_status_battery", &self.report_dev_status_battery);
        formatter.field("report_dev_status_margin", &self.report_dev_status_margin);
        formatter.field("dr_min", &self.dr_min);
        formatter.field("dr_max", &self.dr_max);
        formatter.field("channel_mask", &self.channel_mask);
        formatter.field("pr_allowed", &self.pr_allowed);
        formatter.field("hr_allowed", &self.hr_allowed);
        formatter.field("ra_allowed", &self.ra_allowed);
        formatter.field("nwk_geo_loc", &self.nwk_geo_loc);
        formatter.field("target_per", &self.target_per);
        formatter.field("min_gw_diversity", &self.min_gw_diversity);
        formatter.finish()
    }
}
/// See [`LoRaWanGetServiceProfileInfo`](crate::model::LoRaWanGetServiceProfileInfo)
pub mod lo_ra_wan_get_service_profile_info {
    /// A builder for [`LoRaWanGetServiceProfileInfo`](crate::model::LoRaWanGetServiceProfileInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ul_rate: std::option::Option<i32>,
        pub(crate) ul_bucket_size: std::option::Option<i32>,
        pub(crate) ul_rate_policy: std::option::Option<std::string::String>,
        pub(crate) dl_rate: std::option::Option<i32>,
        pub(crate) dl_bucket_size: std::option::Option<i32>,
        pub(crate) dl_rate_policy: std::option::Option<std::string::String>,
        pub(crate) add_gw_metadata: std::option::Option<bool>,
        pub(crate) dev_status_req_freq: std::option::Option<i32>,
        pub(crate) report_dev_status_battery: std::option::Option<bool>,
        pub(crate) report_dev_status_margin: std::option::Option<bool>,
        pub(crate) dr_min: std::option::Option<i32>,
        pub(crate) dr_max: std::option::Option<i32>,
        pub(crate) channel_mask: std::option::Option<std::string::String>,
        pub(crate) pr_allowed: std::option::Option<bool>,
        pub(crate) hr_allowed: std::option::Option<bool>,
        pub(crate) ra_allowed: std::option::Option<bool>,
        pub(crate) nwk_geo_loc: std::option::Option<bool>,
        pub(crate) target_per: std::option::Option<i32>,
        pub(crate) min_gw_diversity: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ULRate value.</p>
        pub fn ul_rate(mut self, input: i32) -> Self {
            self.ul_rate = Some(input);
            self
        }
        /// <p>The ULRate value.</p>
        pub fn set_ul_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.ul_rate = input;
            self
        }
        /// <p>The ULBucketSize value.</p>
        pub fn ul_bucket_size(mut self, input: i32) -> Self {
            self.ul_bucket_size = Some(input);
            self
        }
        /// <p>The ULBucketSize value.</p>
        pub fn set_ul_bucket_size(mut self, input: std::option::Option<i32>) -> Self {
            self.ul_bucket_size = input;
            self
        }
        /// <p>The ULRatePolicy value.</p>
        pub fn ul_rate_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.ul_rate_policy = Some(input.into());
            self
        }
        /// <p>The ULRatePolicy value.</p>
        pub fn set_ul_rate_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ul_rate_policy = input;
            self
        }
        /// <p>The DLRate value.</p>
        pub fn dl_rate(mut self, input: i32) -> Self {
            self.dl_rate = Some(input);
            self
        }
        /// <p>The DLRate value.</p>
        pub fn set_dl_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.dl_rate = input;
            self
        }
        /// <p>The DLBucketSize value.</p>
        pub fn dl_bucket_size(mut self, input: i32) -> Self {
            self.dl_bucket_size = Some(input);
            self
        }
        /// <p>The DLBucketSize value.</p>
        pub fn set_dl_bucket_size(mut self, input: std::option::Option<i32>) -> Self {
            self.dl_bucket_size = input;
            self
        }
        /// <p>The DLRatePolicy value.</p>
        pub fn dl_rate_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.dl_rate_policy = Some(input.into());
            self
        }
        /// <p>The DLRatePolicy value.</p>
        pub fn set_dl_rate_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dl_rate_policy = input;
            self
        }
        /// <p>The AddGWMetaData value.</p>
        pub fn add_gw_metadata(mut self, input: bool) -> Self {
            self.add_gw_metadata = Some(input);
            self
        }
        /// <p>The AddGWMetaData value.</p>
        pub fn set_add_gw_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.add_gw_metadata = input;
            self
        }
        /// <p>The DevStatusReqFreq value.</p>
        pub fn dev_status_req_freq(mut self, input: i32) -> Self {
            self.dev_status_req_freq = Some(input);
            self
        }
        /// <p>The DevStatusReqFreq value.</p>
        pub fn set_dev_status_req_freq(mut self, input: std::option::Option<i32>) -> Self {
            self.dev_status_req_freq = input;
            self
        }
        /// <p>The ReportDevStatusBattery value.</p>
        pub fn report_dev_status_battery(mut self, input: bool) -> Self {
            self.report_dev_status_battery = Some(input);
            self
        }
        /// <p>The ReportDevStatusBattery value.</p>
        pub fn set_report_dev_status_battery(mut self, input: std::option::Option<bool>) -> Self {
            self.report_dev_status_battery = input;
            self
        }
        /// <p>The ReportDevStatusMargin value.</p>
        pub fn report_dev_status_margin(mut self, input: bool) -> Self {
            self.report_dev_status_margin = Some(input);
            self
        }
        /// <p>The ReportDevStatusMargin value.</p>
        pub fn set_report_dev_status_margin(mut self, input: std::option::Option<bool>) -> Self {
            self.report_dev_status_margin = input;
            self
        }
        /// <p>The DRMin value.</p>
        pub fn dr_min(mut self, input: i32) -> Self {
            self.dr_min = Some(input);
            self
        }
        /// <p>The DRMin value.</p>
        pub fn set_dr_min(mut self, input: std::option::Option<i32>) -> Self {
            self.dr_min = input;
            self
        }
        /// <p>The DRMax value.</p>
        pub fn dr_max(mut self, input: i32) -> Self {
            self.dr_max = Some(input);
            self
        }
        /// <p>The DRMax value.</p>
        pub fn set_dr_max(mut self, input: std::option::Option<i32>) -> Self {
            self.dr_max = input;
            self
        }
        /// <p>The ChannelMask value.</p>
        pub fn channel_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_mask = Some(input.into());
            self
        }
        /// <p>The ChannelMask value.</p>
        pub fn set_channel_mask(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_mask = input;
            self
        }
        /// <p>The PRAllowed value that describes whether passive roaming is allowed.</p>
        pub fn pr_allowed(mut self, input: bool) -> Self {
            self.pr_allowed = Some(input);
            self
        }
        /// <p>The PRAllowed value that describes whether passive roaming is allowed.</p>
        pub fn set_pr_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.pr_allowed = input;
            self
        }
        /// <p>The HRAllowed value that describes whether handover roaming is allowed.</p>
        pub fn hr_allowed(mut self, input: bool) -> Self {
            self.hr_allowed = Some(input);
            self
        }
        /// <p>The HRAllowed value that describes whether handover roaming is allowed.</p>
        pub fn set_hr_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.hr_allowed = input;
            self
        }
        /// <p>The RAAllowed value that describes whether roaming activation is allowed.</p>
        pub fn ra_allowed(mut self, input: bool) -> Self {
            self.ra_allowed = Some(input);
            self
        }
        /// <p>The RAAllowed value that describes whether roaming activation is allowed.</p>
        pub fn set_ra_allowed(mut self, input: std::option::Option<bool>) -> Self {
            self.ra_allowed = input;
            self
        }
        /// <p>The NwkGeoLoc value.</p>
        pub fn nwk_geo_loc(mut self, input: bool) -> Self {
            self.nwk_geo_loc = Some(input);
            self
        }
        /// <p>The NwkGeoLoc value.</p>
        pub fn set_nwk_geo_loc(mut self, input: std::option::Option<bool>) -> Self {
            self.nwk_geo_loc = input;
            self
        }
        /// <p>The TargetPER value.</p>
        pub fn target_per(mut self, input: i32) -> Self {
            self.target_per = Some(input);
            self
        }
        /// <p>The TargetPER value.</p>
        pub fn set_target_per(mut self, input: std::option::Option<i32>) -> Self {
            self.target_per = input;
            self
        }
        /// <p>The MinGwDiversity value.</p>
        pub fn min_gw_diversity(mut self, input: i32) -> Self {
            self.min_gw_diversity = Some(input);
            self
        }
        /// <p>The MinGwDiversity value.</p>
        pub fn set_min_gw_diversity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_gw_diversity = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanGetServiceProfileInfo`](crate::model::LoRaWanGetServiceProfileInfo)
        pub fn build(self) -> crate::model::LoRaWanGetServiceProfileInfo {
            crate::model::LoRaWanGetServiceProfileInfo {
                ul_rate: self.ul_rate,
                ul_bucket_size: self.ul_bucket_size,
                ul_rate_policy: self.ul_rate_policy,
                dl_rate: self.dl_rate,
                dl_bucket_size: self.dl_bucket_size,
                dl_rate_policy: self.dl_rate_policy,
                add_gw_metadata: self.add_gw_metadata.unwrap_or_default(),
                dev_status_req_freq: self.dev_status_req_freq,
                report_dev_status_battery: self.report_dev_status_battery.unwrap_or_default(),
                report_dev_status_margin: self.report_dev_status_margin.unwrap_or_default(),
                dr_min: self.dr_min.unwrap_or_default(),
                dr_max: self.dr_max.unwrap_or_default(),
                channel_mask: self.channel_mask,
                pr_allowed: self.pr_allowed.unwrap_or_default(),
                hr_allowed: self.hr_allowed.unwrap_or_default(),
                ra_allowed: self.ra_allowed.unwrap_or_default(),
                nwk_geo_loc: self.nwk_geo_loc.unwrap_or_default(),
                target_per: self.target_per.unwrap_or_default(),
                min_gw_diversity: self.min_gw_diversity,
            }
        }
    }
}
impl LoRaWanGetServiceProfileInfo {
    /// Creates a new builder-style object to manufacture [`LoRaWanGetServiceProfileInfo`](crate::model::LoRaWanGetServiceProfileInfo)
    pub fn builder() -> crate::model::lo_ra_wan_get_service_profile_info::Builder {
        crate::model::lo_ra_wan_get_service_profile_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WirelessGatewayServiceType {
    #[allow(missing_docs)] // documentation missing in model
    Cups,
    #[allow(missing_docs)] // documentation missing in model
    Lns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WirelessGatewayServiceType {
    fn from(s: &str) -> Self {
        match s {
            "CUPS" => WirelessGatewayServiceType::Cups,
            "LNS" => WirelessGatewayServiceType::Lns,
            other => WirelessGatewayServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WirelessGatewayServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WirelessGatewayServiceType::from(s))
    }
}
impl WirelessGatewayServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WirelessGatewayServiceType::Cups => "CUPS",
            WirelessGatewayServiceType::Lns => "LNS",
            WirelessGatewayServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUPS", "LNS"]
    }
}
impl AsRef<str> for WirelessGatewayServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The LoRaWAN information that is to be returned from getting multicast group information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanMulticastGet {
    /// <p>Supported RfRegions</p>
    pub rf_region: std::option::Option<crate::model::SupportedRfRegion>,
    /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
    pub dl_class: std::option::Option<crate::model::DlClass>,
    /// <p>Number of devices that are requested to be associated with the multicast group.</p>
    pub number_of_devices_requested: std::option::Option<i32>,
    /// <p>Number of devices that are associated to the multicast group.</p>
    pub number_of_devices_in_group: std::option::Option<i32>,
}
impl LoRaWanMulticastGet {
    /// <p>Supported RfRegions</p>
    pub fn rf_region(&self) -> std::option::Option<&crate::model::SupportedRfRegion> {
        self.rf_region.as_ref()
    }
    /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
    pub fn dl_class(&self) -> std::option::Option<&crate::model::DlClass> {
        self.dl_class.as_ref()
    }
    /// <p>Number of devices that are requested to be associated with the multicast group.</p>
    pub fn number_of_devices_requested(&self) -> std::option::Option<i32> {
        self.number_of_devices_requested
    }
    /// <p>Number of devices that are associated to the multicast group.</p>
    pub fn number_of_devices_in_group(&self) -> std::option::Option<i32> {
        self.number_of_devices_in_group
    }
}
impl std::fmt::Debug for LoRaWanMulticastGet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanMulticastGet");
        formatter.field("rf_region", &self.rf_region);
        formatter.field("dl_class", &self.dl_class);
        formatter.field(
            "number_of_devices_requested",
            &self.number_of_devices_requested,
        );
        formatter.field(
            "number_of_devices_in_group",
            &self.number_of_devices_in_group,
        );
        formatter.finish()
    }
}
/// See [`LoRaWanMulticastGet`](crate::model::LoRaWanMulticastGet)
pub mod lo_ra_wan_multicast_get {
    /// A builder for [`LoRaWanMulticastGet`](crate::model::LoRaWanMulticastGet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rf_region: std::option::Option<crate::model::SupportedRfRegion>,
        pub(crate) dl_class: std::option::Option<crate::model::DlClass>,
        pub(crate) number_of_devices_requested: std::option::Option<i32>,
        pub(crate) number_of_devices_in_group: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Supported RfRegions</p>
        pub fn rf_region(mut self, input: crate::model::SupportedRfRegion) -> Self {
            self.rf_region = Some(input);
            self
        }
        /// <p>Supported RfRegions</p>
        pub fn set_rf_region(
            mut self,
            input: std::option::Option<crate::model::SupportedRfRegion>,
        ) -> Self {
            self.rf_region = input;
            self
        }
        /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
        pub fn dl_class(mut self, input: crate::model::DlClass) -> Self {
            self.dl_class = Some(input);
            self
        }
        /// <p>DlClass for LoRaWAM, valid values are ClassB and ClassC.</p>
        pub fn set_dl_class(mut self, input: std::option::Option<crate::model::DlClass>) -> Self {
            self.dl_class = input;
            self
        }
        /// <p>Number of devices that are requested to be associated with the multicast group.</p>
        pub fn number_of_devices_requested(mut self, input: i32) -> Self {
            self.number_of_devices_requested = Some(input);
            self
        }
        /// <p>Number of devices that are requested to be associated with the multicast group.</p>
        pub fn set_number_of_devices_requested(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_devices_requested = input;
            self
        }
        /// <p>Number of devices that are associated to the multicast group.</p>
        pub fn number_of_devices_in_group(mut self, input: i32) -> Self {
            self.number_of_devices_in_group = Some(input);
            self
        }
        /// <p>Number of devices that are associated to the multicast group.</p>
        pub fn set_number_of_devices_in_group(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_devices_in_group = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanMulticastGet`](crate::model::LoRaWanMulticastGet)
        pub fn build(self) -> crate::model::LoRaWanMulticastGet {
            crate::model::LoRaWanMulticastGet {
                rf_region: self.rf_region,
                dl_class: self.dl_class,
                number_of_devices_requested: self.number_of_devices_requested,
                number_of_devices_in_group: self.number_of_devices_in_group,
            }
        }
    }
}
impl LoRaWanMulticastGet {
    /// Creates a new builder-style object to manufacture [`LoRaWanMulticastGet`](crate::model::LoRaWanMulticastGet)
    pub fn builder() -> crate::model::lo_ra_wan_multicast_get::Builder {
        crate::model::lo_ra_wan_multicast_get::Builder::default()
    }
}

/// <p>The LoRaWAN information returned from getting a FUOTA task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanFuotaTaskGetInfo {
    /// <p>The frequency band (RFRegion) value.</p>
    pub rf_region: std::option::Option<std::string::String>,
    /// <p>Start time of a FUOTA task.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LoRaWanFuotaTaskGetInfo {
    /// <p>The frequency band (RFRegion) value.</p>
    pub fn rf_region(&self) -> std::option::Option<&str> {
        self.rf_region.as_deref()
    }
    /// <p>Start time of a FUOTA task.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
}
impl std::fmt::Debug for LoRaWanFuotaTaskGetInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanFuotaTaskGetInfo");
        formatter.field("rf_region", &self.rf_region);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`LoRaWanFuotaTaskGetInfo`](crate::model::LoRaWanFuotaTaskGetInfo)
pub mod lo_ra_wan_fuota_task_get_info {
    /// A builder for [`LoRaWanFuotaTaskGetInfo`](crate::model::LoRaWanFuotaTaskGetInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rf_region: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn rf_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.rf_region = Some(input.into());
            self
        }
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn set_rf_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rf_region = input;
            self
        }
        /// <p>Start time of a FUOTA task.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a FUOTA task.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanFuotaTaskGetInfo`](crate::model::LoRaWanFuotaTaskGetInfo)
        pub fn build(self) -> crate::model::LoRaWanFuotaTaskGetInfo {
            crate::model::LoRaWanFuotaTaskGetInfo {
                rf_region: self.rf_region,
                start_time: self.start_time,
            }
        }
    }
}
impl LoRaWanFuotaTaskGetInfo {
    /// Creates a new builder-style object to manufacture [`LoRaWanFuotaTaskGetInfo`](crate::model::LoRaWanFuotaTaskGetInfo)
    pub fn builder() -> crate::model::lo_ra_wan_fuota_task_get_info::Builder {
        crate::model::lo_ra_wan_fuota_task_get_info::Builder::default()
    }
}

/// <p>The status of a FUOTA task.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FuotaTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    DeleteWaiting,
    #[allow(missing_docs)] // documentation missing in model
    FuotaDone,
    #[allow(missing_docs)] // documentation missing in model
    FuotaSessionWaiting,
    #[allow(missing_docs)] // documentation missing in model
    InFuotaSession,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FuotaTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "Delete_Waiting" => FuotaTaskStatus::DeleteWaiting,
            "FuotaDone" => FuotaTaskStatus::FuotaDone,
            "FuotaSession_Waiting" => FuotaTaskStatus::FuotaSessionWaiting,
            "In_FuotaSession" => FuotaTaskStatus::InFuotaSession,
            "Pending" => FuotaTaskStatus::Pending,
            other => FuotaTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FuotaTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FuotaTaskStatus::from(s))
    }
}
impl FuotaTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FuotaTaskStatus::DeleteWaiting => "Delete_Waiting",
            FuotaTaskStatus::FuotaDone => "FuotaDone",
            FuotaTaskStatus::FuotaSessionWaiting => "FuotaSession_Waiting",
            FuotaTaskStatus::InFuotaSession => "In_FuotaSession",
            FuotaTaskStatus::Pending => "Pending",
            FuotaTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Delete_Waiting",
            "FuotaDone",
            "FuotaSession_Waiting",
            "In_FuotaSession",
            "Pending",
        ]
    }
}
impl AsRef<str> for FuotaTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>LoRaWANDeviceProfile object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanDeviceProfile {
    /// <p>The SupportsClassB value.</p>
    pub supports_class_b: bool,
    /// <p>The ClassBTimeout value.</p>
    pub class_b_timeout: std::option::Option<i32>,
    /// <p>The PingSlotPeriod value.</p>
    pub ping_slot_period: std::option::Option<i32>,
    /// <p>The PingSlotDR value.</p>
    pub ping_slot_dr: std::option::Option<i32>,
    /// <p>The PingSlotFreq value.</p>
    pub ping_slot_freq: std::option::Option<i32>,
    /// <p>The SupportsClassC value.</p>
    pub supports_class_c: bool,
    /// <p>The ClassCTimeout value.</p>
    pub class_c_timeout: std::option::Option<i32>,
    /// <p>The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.</p>
    pub mac_version: std::option::Option<std::string::String>,
    /// <p>The version of regional parameters.</p>
    pub reg_params_revision: std::option::Option<std::string::String>,
    /// <p>The RXDelay1 value.</p>
    pub rx_delay1: std::option::Option<i32>,
    /// <p>The RXDROffset1 value.</p>
    pub rx_dr_offset1: std::option::Option<i32>,
    /// <p>The RXDataRate2 value.</p>
    pub rx_data_rate2: std::option::Option<i32>,
    /// <p>The RXFreq2 value.</p>
    pub rx_freq2: std::option::Option<i32>,
    /// <p>The list of values that make up the FactoryPresetFreqs value.</p>
    pub factory_preset_freqs_list: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The MaxEIRP value.</p>
    pub max_eirp: std::option::Option<i32>,
    /// <p>The MaxDutyCycle value.</p>
    pub max_duty_cycle: std::option::Option<i32>,
    /// <p>The frequency band (RFRegion) value.</p>
    pub rf_region: std::option::Option<std::string::String>,
    /// <p>The SupportsJoin value.</p>
    pub supports_join: std::option::Option<bool>,
    /// <p>The Supports32BitFCnt value.</p>
    pub supports32_bit_f_cnt: bool,
}
impl LoRaWanDeviceProfile {
    /// <p>The SupportsClassB value.</p>
    pub fn supports_class_b(&self) -> bool {
        self.supports_class_b
    }
    /// <p>The ClassBTimeout value.</p>
    pub fn class_b_timeout(&self) -> std::option::Option<i32> {
        self.class_b_timeout
    }
    /// <p>The PingSlotPeriod value.</p>
    pub fn ping_slot_period(&self) -> std::option::Option<i32> {
        self.ping_slot_period
    }
    /// <p>The PingSlotDR value.</p>
    pub fn ping_slot_dr(&self) -> std::option::Option<i32> {
        self.ping_slot_dr
    }
    /// <p>The PingSlotFreq value.</p>
    pub fn ping_slot_freq(&self) -> std::option::Option<i32> {
        self.ping_slot_freq
    }
    /// <p>The SupportsClassC value.</p>
    pub fn supports_class_c(&self) -> bool {
        self.supports_class_c
    }
    /// <p>The ClassCTimeout value.</p>
    pub fn class_c_timeout(&self) -> std::option::Option<i32> {
        self.class_c_timeout
    }
    /// <p>The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.</p>
    pub fn mac_version(&self) -> std::option::Option<&str> {
        self.mac_version.as_deref()
    }
    /// <p>The version of regional parameters.</p>
    pub fn reg_params_revision(&self) -> std::option::Option<&str> {
        self.reg_params_revision.as_deref()
    }
    /// <p>The RXDelay1 value.</p>
    pub fn rx_delay1(&self) -> std::option::Option<i32> {
        self.rx_delay1
    }
    /// <p>The RXDROffset1 value.</p>
    pub fn rx_dr_offset1(&self) -> std::option::Option<i32> {
        self.rx_dr_offset1
    }
    /// <p>The RXDataRate2 value.</p>
    pub fn rx_data_rate2(&self) -> std::option::Option<i32> {
        self.rx_data_rate2
    }
    /// <p>The RXFreq2 value.</p>
    pub fn rx_freq2(&self) -> std::option::Option<i32> {
        self.rx_freq2
    }
    /// <p>The list of values that make up the FactoryPresetFreqs value.</p>
    pub fn factory_preset_freqs_list(&self) -> std::option::Option<&[i32]> {
        self.factory_preset_freqs_list.as_deref()
    }
    /// <p>The MaxEIRP value.</p>
    pub fn max_eirp(&self) -> std::option::Option<i32> {
        self.max_eirp
    }
    /// <p>The MaxDutyCycle value.</p>
    pub fn max_duty_cycle(&self) -> std::option::Option<i32> {
        self.max_duty_cycle
    }
    /// <p>The frequency band (RFRegion) value.</p>
    pub fn rf_region(&self) -> std::option::Option<&str> {
        self.rf_region.as_deref()
    }
    /// <p>The SupportsJoin value.</p>
    pub fn supports_join(&self) -> std::option::Option<bool> {
        self.supports_join
    }
    /// <p>The Supports32BitFCnt value.</p>
    pub fn supports32_bit_f_cnt(&self) -> bool {
        self.supports32_bit_f_cnt
    }
}
impl std::fmt::Debug for LoRaWanDeviceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanDeviceProfile");
        formatter.field("supports_class_b", &self.supports_class_b);
        formatter.field("class_b_timeout", &self.class_b_timeout);
        formatter.field("ping_slot_period", &self.ping_slot_period);
        formatter.field("ping_slot_dr", &self.ping_slot_dr);
        formatter.field("ping_slot_freq", &self.ping_slot_freq);
        formatter.field("supports_class_c", &self.supports_class_c);
        formatter.field("class_c_timeout", &self.class_c_timeout);
        formatter.field("mac_version", &self.mac_version);
        formatter.field("reg_params_revision", &self.reg_params_revision);
        formatter.field("rx_delay1", &self.rx_delay1);
        formatter.field("rx_dr_offset1", &self.rx_dr_offset1);
        formatter.field("rx_data_rate2", &self.rx_data_rate2);
        formatter.field("rx_freq2", &self.rx_freq2);
        formatter.field("factory_preset_freqs_list", &self.factory_preset_freqs_list);
        formatter.field("max_eirp", &self.max_eirp);
        formatter.field("max_duty_cycle", &self.max_duty_cycle);
        formatter.field("rf_region", &self.rf_region);
        formatter.field("supports_join", &self.supports_join);
        formatter.field("supports32_bit_f_cnt", &self.supports32_bit_f_cnt);
        formatter.finish()
    }
}
/// See [`LoRaWanDeviceProfile`](crate::model::LoRaWanDeviceProfile)
pub mod lo_ra_wan_device_profile {
    /// A builder for [`LoRaWanDeviceProfile`](crate::model::LoRaWanDeviceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) supports_class_b: std::option::Option<bool>,
        pub(crate) class_b_timeout: std::option::Option<i32>,
        pub(crate) ping_slot_period: std::option::Option<i32>,
        pub(crate) ping_slot_dr: std::option::Option<i32>,
        pub(crate) ping_slot_freq: std::option::Option<i32>,
        pub(crate) supports_class_c: std::option::Option<bool>,
        pub(crate) class_c_timeout: std::option::Option<i32>,
        pub(crate) mac_version: std::option::Option<std::string::String>,
        pub(crate) reg_params_revision: std::option::Option<std::string::String>,
        pub(crate) rx_delay1: std::option::Option<i32>,
        pub(crate) rx_dr_offset1: std::option::Option<i32>,
        pub(crate) rx_data_rate2: std::option::Option<i32>,
        pub(crate) rx_freq2: std::option::Option<i32>,
        pub(crate) factory_preset_freqs_list: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) max_eirp: std::option::Option<i32>,
        pub(crate) max_duty_cycle: std::option::Option<i32>,
        pub(crate) rf_region: std::option::Option<std::string::String>,
        pub(crate) supports_join: std::option::Option<bool>,
        pub(crate) supports32_bit_f_cnt: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The SupportsClassB value.</p>
        pub fn supports_class_b(mut self, input: bool) -> Self {
            self.supports_class_b = Some(input);
            self
        }
        /// <p>The SupportsClassB value.</p>
        pub fn set_supports_class_b(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_class_b = input;
            self
        }
        /// <p>The ClassBTimeout value.</p>
        pub fn class_b_timeout(mut self, input: i32) -> Self {
            self.class_b_timeout = Some(input);
            self
        }
        /// <p>The ClassBTimeout value.</p>
        pub fn set_class_b_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.class_b_timeout = input;
            self
        }
        /// <p>The PingSlotPeriod value.</p>
        pub fn ping_slot_period(mut self, input: i32) -> Self {
            self.ping_slot_period = Some(input);
            self
        }
        /// <p>The PingSlotPeriod value.</p>
        pub fn set_ping_slot_period(mut self, input: std::option::Option<i32>) -> Self {
            self.ping_slot_period = input;
            self
        }
        /// <p>The PingSlotDR value.</p>
        pub fn ping_slot_dr(mut self, input: i32) -> Self {
            self.ping_slot_dr = Some(input);
            self
        }
        /// <p>The PingSlotDR value.</p>
        pub fn set_ping_slot_dr(mut self, input: std::option::Option<i32>) -> Self {
            self.ping_slot_dr = input;
            self
        }
        /// <p>The PingSlotFreq value.</p>
        pub fn ping_slot_freq(mut self, input: i32) -> Self {
            self.ping_slot_freq = Some(input);
            self
        }
        /// <p>The PingSlotFreq value.</p>
        pub fn set_ping_slot_freq(mut self, input: std::option::Option<i32>) -> Self {
            self.ping_slot_freq = input;
            self
        }
        /// <p>The SupportsClassC value.</p>
        pub fn supports_class_c(mut self, input: bool) -> Self {
            self.supports_class_c = Some(input);
            self
        }
        /// <p>The SupportsClassC value.</p>
        pub fn set_supports_class_c(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_class_c = input;
            self
        }
        /// <p>The ClassCTimeout value.</p>
        pub fn class_c_timeout(mut self, input: i32) -> Self {
            self.class_c_timeout = Some(input);
            self
        }
        /// <p>The ClassCTimeout value.</p>
        pub fn set_class_c_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.class_c_timeout = input;
            self
        }
        /// <p>The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.</p>
        pub fn mac_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_version = Some(input.into());
            self
        }
        /// <p>The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.</p>
        pub fn set_mac_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_version = input;
            self
        }
        /// <p>The version of regional parameters.</p>
        pub fn reg_params_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.reg_params_revision = Some(input.into());
            self
        }
        /// <p>The version of regional parameters.</p>
        pub fn set_reg_params_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reg_params_revision = input;
            self
        }
        /// <p>The RXDelay1 value.</p>
        pub fn rx_delay1(mut self, input: i32) -> Self {
            self.rx_delay1 = Some(input);
            self
        }
        /// <p>The RXDelay1 value.</p>
        pub fn set_rx_delay1(mut self, input: std::option::Option<i32>) -> Self {
            self.rx_delay1 = input;
            self
        }
        /// <p>The RXDROffset1 value.</p>
        pub fn rx_dr_offset1(mut self, input: i32) -> Self {
            self.rx_dr_offset1 = Some(input);
            self
        }
        /// <p>The RXDROffset1 value.</p>
        pub fn set_rx_dr_offset1(mut self, input: std::option::Option<i32>) -> Self {
            self.rx_dr_offset1 = input;
            self
        }
        /// <p>The RXDataRate2 value.</p>
        pub fn rx_data_rate2(mut self, input: i32) -> Self {
            self.rx_data_rate2 = Some(input);
            self
        }
        /// <p>The RXDataRate2 value.</p>
        pub fn set_rx_data_rate2(mut self, input: std::option::Option<i32>) -> Self {
            self.rx_data_rate2 = input;
            self
        }
        /// <p>The RXFreq2 value.</p>
        pub fn rx_freq2(mut self, input: i32) -> Self {
            self.rx_freq2 = Some(input);
            self
        }
        /// <p>The RXFreq2 value.</p>
        pub fn set_rx_freq2(mut self, input: std::option::Option<i32>) -> Self {
            self.rx_freq2 = input;
            self
        }
        /// Appends an item to `factory_preset_freqs_list`.
        ///
        /// To override the contents of this collection use [`set_factory_preset_freqs_list`](Self::set_factory_preset_freqs_list).
        ///
        /// <p>The list of values that make up the FactoryPresetFreqs value.</p>
        pub fn factory_preset_freqs_list(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.factory_preset_freqs_list.unwrap_or_default();
            v.push(input.into());
            self.factory_preset_freqs_list = Some(v);
            self
        }
        /// <p>The list of values that make up the FactoryPresetFreqs value.</p>
        pub fn set_factory_preset_freqs_list(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.factory_preset_freqs_list = input;
            self
        }
        /// <p>The MaxEIRP value.</p>
        pub fn max_eirp(mut self, input: i32) -> Self {
            self.max_eirp = Some(input);
            self
        }
        /// <p>The MaxEIRP value.</p>
        pub fn set_max_eirp(mut self, input: std::option::Option<i32>) -> Self {
            self.max_eirp = input;
            self
        }
        /// <p>The MaxDutyCycle value.</p>
        pub fn max_duty_cycle(mut self, input: i32) -> Self {
            self.max_duty_cycle = Some(input);
            self
        }
        /// <p>The MaxDutyCycle value.</p>
        pub fn set_max_duty_cycle(mut self, input: std::option::Option<i32>) -> Self {
            self.max_duty_cycle = input;
            self
        }
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn rf_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.rf_region = Some(input.into());
            self
        }
        /// <p>The frequency band (RFRegion) value.</p>
        pub fn set_rf_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rf_region = input;
            self
        }
        /// <p>The SupportsJoin value.</p>
        pub fn supports_join(mut self, input: bool) -> Self {
            self.supports_join = Some(input);
            self
        }
        /// <p>The SupportsJoin value.</p>
        pub fn set_supports_join(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_join = input;
            self
        }
        /// <p>The Supports32BitFCnt value.</p>
        pub fn supports32_bit_f_cnt(mut self, input: bool) -> Self {
            self.supports32_bit_f_cnt = Some(input);
            self
        }
        /// <p>The Supports32BitFCnt value.</p>
        pub fn set_supports32_bit_f_cnt(mut self, input: std::option::Option<bool>) -> Self {
            self.supports32_bit_f_cnt = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanDeviceProfile`](crate::model::LoRaWanDeviceProfile)
        pub fn build(self) -> crate::model::LoRaWanDeviceProfile {
            crate::model::LoRaWanDeviceProfile {
                supports_class_b: self.supports_class_b.unwrap_or_default(),
                class_b_timeout: self.class_b_timeout,
                ping_slot_period: self.ping_slot_period,
                ping_slot_dr: self.ping_slot_dr,
                ping_slot_freq: self.ping_slot_freq,
                supports_class_c: self.supports_class_c.unwrap_or_default(),
                class_c_timeout: self.class_c_timeout,
                mac_version: self.mac_version,
                reg_params_revision: self.reg_params_revision,
                rx_delay1: self.rx_delay1,
                rx_dr_offset1: self.rx_dr_offset1,
                rx_data_rate2: self.rx_data_rate2,
                rx_freq2: self.rx_freq2,
                factory_preset_freqs_list: self.factory_preset_freqs_list,
                max_eirp: self.max_eirp,
                max_duty_cycle: self.max_duty_cycle,
                rf_region: self.rf_region,
                supports_join: self.supports_join,
                supports32_bit_f_cnt: self.supports32_bit_f_cnt.unwrap_or_default(),
            }
        }
    }
}
impl LoRaWanDeviceProfile {
    /// Creates a new builder-style object to manufacture [`LoRaWanDeviceProfile`](crate::model::LoRaWanDeviceProfile)
    pub fn builder() -> crate::model::lo_ra_wan_device_profile::Builder {
        crate::model::lo_ra_wan_device_profile::Builder::default()
    }
}

/// <p>LoRaWANServiceProfile object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoRaWanServiceProfile {
    /// <p>The AddGWMetaData value.</p>
    pub add_gw_metadata: bool,
}
impl LoRaWanServiceProfile {
    /// <p>The AddGWMetaData value.</p>
    pub fn add_gw_metadata(&self) -> bool {
        self.add_gw_metadata
    }
}
impl std::fmt::Debug for LoRaWanServiceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoRaWanServiceProfile");
        formatter.field("add_gw_metadata", &self.add_gw_metadata);
        formatter.finish()
    }
}
/// See [`LoRaWanServiceProfile`](crate::model::LoRaWanServiceProfile)
pub mod lo_ra_wan_service_profile {
    /// A builder for [`LoRaWanServiceProfile`](crate::model::LoRaWanServiceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_gw_metadata: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The AddGWMetaData value.</p>
        pub fn add_gw_metadata(mut self, input: bool) -> Self {
            self.add_gw_metadata = Some(input);
            self
        }
        /// <p>The AddGWMetaData value.</p>
        pub fn set_add_gw_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.add_gw_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`LoRaWanServiceProfile`](crate::model::LoRaWanServiceProfile)
        pub fn build(self) -> crate::model::LoRaWanServiceProfile {
            crate::model::LoRaWanServiceProfile {
                add_gw_metadata: self.add_gw_metadata.unwrap_or_default(),
            }
        }
    }
}
impl LoRaWanServiceProfile {
    /// Creates a new builder-style object to manufacture [`LoRaWanServiceProfile`](crate::model::LoRaWanServiceProfile)
    pub fn builder() -> crate::model::lo_ra_wan_service_profile::Builder {
        crate::model::lo_ra_wan_service_profile::Builder::default()
    }
}

/// <p>Information about a Sidewalk account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SidewalkAccountInfo {
    /// <p>The Sidewalk Amazon ID.</p>
    pub amazon_id: std::option::Option<std::string::String>,
    /// <p>The Sidewalk application server private key.</p>
    pub app_server_private_key: std::option::Option<std::string::String>,
}
impl SidewalkAccountInfo {
    /// <p>The Sidewalk Amazon ID.</p>
    pub fn amazon_id(&self) -> std::option::Option<&str> {
        self.amazon_id.as_deref()
    }
    /// <p>The Sidewalk application server private key.</p>
    pub fn app_server_private_key(&self) -> std::option::Option<&str> {
        self.app_server_private_key.as_deref()
    }
}
impl std::fmt::Debug for SidewalkAccountInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SidewalkAccountInfo");
        formatter.field("amazon_id", &self.amazon_id);
        formatter.field("app_server_private_key", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SidewalkAccountInfo`](crate::model::SidewalkAccountInfo)
pub mod sidewalk_account_info {
    /// A builder for [`SidewalkAccountInfo`](crate::model::SidewalkAccountInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_id: std::option::Option<std::string::String>,
        pub(crate) app_server_private_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn amazon_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.amazon_id = Some(input.into());
            self
        }
        /// <p>The Sidewalk Amazon ID.</p>
        pub fn set_amazon_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amazon_id = input;
            self
        }
        /// <p>The Sidewalk application server private key.</p>
        pub fn app_server_private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_server_private_key = Some(input.into());
            self
        }
        /// <p>The Sidewalk application server private key.</p>
        pub fn set_app_server_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_server_private_key = input;
            self
        }
        /// Consumes the builder and constructs a [`SidewalkAccountInfo`](crate::model::SidewalkAccountInfo)
        pub fn build(self) -> crate::model::SidewalkAccountInfo {
            crate::model::SidewalkAccountInfo {
                amazon_id: self.amazon_id,
                app_server_private_key: self.app_server_private_key,
            }
        }
    }
}
impl SidewalkAccountInfo {
    /// Creates a new builder-style object to manufacture [`SidewalkAccountInfo`](crate::model::SidewalkAccountInfo)
    pub fn builder() -> crate::model::sidewalk_account_info::Builder {
        crate::model::sidewalk_account_info::Builder::default()
    }
}
