// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAwsAccountWithPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAwsAccountWithPartnerAccountError {
    /// Kind of error that occurred.
    pub kind: AssociateAwsAccountWithPartnerAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAwsAccountWithPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAwsAccountWithPartnerAccountErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAwsAccountWithPartnerAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAwsAccountWithPartnerAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAwsAccountWithPartnerAccountError {
    fn code(&self) -> Option<&str> {
        AssociateAwsAccountWithPartnerAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAwsAccountWithPartnerAccountError {
    /// Creates a new `AssociateAwsAccountWithPartnerAccountError`.
    pub fn new(
        kind: AssociateAwsAccountWithPartnerAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAwsAccountWithPartnerAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAwsAccountWithPartnerAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAwsAccountWithPartnerAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAwsAccountWithPartnerAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAwsAccountWithPartnerAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAwsAccountWithPartnerAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateAwsAccountWithPartnerAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAwsAccountWithPartnerAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateAwsAccountWithPartnerAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateMulticastGroupWithFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateMulticastGroupWithFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: AssociateMulticastGroupWithFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateMulticastGroupWithFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateMulticastGroupWithFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateMulticastGroupWithFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateMulticastGroupWithFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateMulticastGroupWithFuotaTaskError {
    fn code(&self) -> Option<&str> {
        AssociateMulticastGroupWithFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateMulticastGroupWithFuotaTaskError {
    /// Creates a new `AssociateMulticastGroupWithFuotaTaskError`.
    pub fn new(
        kind: AssociateMulticastGroupWithFuotaTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateMulticastGroupWithFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateMulticastGroupWithFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateMulticastGroupWithFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateMulticastGroupWithFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMulticastGroupWithFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMulticastGroupWithFuotaTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateMulticastGroupWithFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateMulticastGroupWithFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateMulticastGroupWithFuotaTaskErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateWirelessDeviceWithFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: AssociateWirelessDeviceWithFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWirelessDeviceWithFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWirelessDeviceWithFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWirelessDeviceWithFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWirelessDeviceWithFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWirelessDeviceWithFuotaTaskError {
    fn code(&self) -> Option<&str> {
        AssociateWirelessDeviceWithFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWirelessDeviceWithFuotaTaskError {
    /// Creates a new `AssociateWirelessDeviceWithFuotaTaskError`.
    pub fn new(
        kind: AssociateWirelessDeviceWithFuotaTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWirelessDeviceWithFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWirelessDeviceWithFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWirelessDeviceWithFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWirelessDeviceWithFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateWirelessDeviceWithFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWirelessDeviceWithFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithFuotaTaskErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateWirelessDeviceWithMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: AssociateWirelessDeviceWithMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWirelessDeviceWithMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWirelessDeviceWithMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWirelessDeviceWithMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWirelessDeviceWithMulticastGroupError {
    fn code(&self) -> Option<&str> {
        AssociateWirelessDeviceWithMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWirelessDeviceWithMulticastGroupError {
    /// Creates a new `AssociateWirelessDeviceWithMulticastGroupError`.
    pub fn new(
        kind: AssociateWirelessDeviceWithMulticastGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWirelessDeviceWithMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWirelessDeviceWithMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateWirelessDeviceWithMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateWirelessDeviceWithThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWirelessDeviceWithThingError {
    /// Kind of error that occurred.
    pub kind: AssociateWirelessDeviceWithThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWirelessDeviceWithThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWirelessDeviceWithThingErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWirelessDeviceWithThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWirelessDeviceWithThingErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithThingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateWirelessDeviceWithThingErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithThingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessDeviceWithThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateWirelessDeviceWithThingErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateWirelessDeviceWithThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWirelessDeviceWithThingError {
    fn code(&self) -> Option<&str> {
        AssociateWirelessDeviceWithThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWirelessDeviceWithThingError {
    /// Creates a new `AssociateWirelessDeviceWithThingError`.
    pub fn new(
        kind: AssociateWirelessDeviceWithThingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWirelessDeviceWithThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWirelessDeviceWithThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWirelessDeviceWithThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWirelessDeviceWithThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessDeviceWithThingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessDeviceWithThingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateWirelessDeviceWithThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWirelessDeviceWithThingErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithThingErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateWirelessDeviceWithThingErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithThingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessDeviceWithThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateWirelessDeviceWithThingErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateWirelessDeviceWithThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateWirelessGatewayWithCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWirelessGatewayWithCertificateError {
    /// Kind of error that occurred.
    pub kind: AssociateWirelessGatewayWithCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWirelessGatewayWithCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWirelessGatewayWithCertificateErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWirelessGatewayWithCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWirelessGatewayWithCertificateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWirelessGatewayWithCertificateError {
    fn code(&self) -> Option<&str> {
        AssociateWirelessGatewayWithCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWirelessGatewayWithCertificateError {
    /// Creates a new `AssociateWirelessGatewayWithCertificateError`.
    pub fn new(
        kind: AssociateWirelessGatewayWithCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWirelessGatewayWithCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWirelessGatewayWithCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWirelessGatewayWithCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWirelessGatewayWithCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithCertificateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithCertificateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateWirelessGatewayWithCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWirelessGatewayWithCertificateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithCertificateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateWirelessGatewayWithThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWirelessGatewayWithThingError {
    /// Kind of error that occurred.
    pub kind: AssociateWirelessGatewayWithThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWirelessGatewayWithThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWirelessGatewayWithThingErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWirelessGatewayWithThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWirelessGatewayWithThingErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithThingErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateWirelessGatewayWithThingErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithThingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithThingErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithThingErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateWirelessGatewayWithThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWirelessGatewayWithThingError {
    fn code(&self) -> Option<&str> {
        AssociateWirelessGatewayWithThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWirelessGatewayWithThingError {
    /// Creates a new `AssociateWirelessGatewayWithThingError`.
    pub fn new(
        kind: AssociateWirelessGatewayWithThingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWirelessGatewayWithThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWirelessGatewayWithThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWirelessGatewayWithThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWirelessGatewayWithThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWirelessGatewayWithThingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWirelessGatewayWithThingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateWirelessGatewayWithThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWirelessGatewayWithThingErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithThingErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateWirelessGatewayWithThingErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithThingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateWirelessGatewayWithThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateWirelessGatewayWithThingErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateWirelessGatewayWithThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelMulticastGroupSessionError {
    /// Kind of error that occurred.
    pub kind: CancelMulticastGroupSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelMulticastGroupSessionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelMulticastGroupSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelMulticastGroupSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelMulticastGroupSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelMulticastGroupSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelMulticastGroupSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelMulticastGroupSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelMulticastGroupSessionError {
    fn code(&self) -> Option<&str> {
        CancelMulticastGroupSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelMulticastGroupSessionError {
    /// Creates a new `CancelMulticastGroupSessionError`.
    pub fn new(kind: CancelMulticastGroupSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelMulticastGroupSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelMulticastGroupSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelMulticastGroupSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelMulticastGroupSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMulticastGroupSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMulticastGroupSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelMulticastGroupSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::ConflictException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::ValidationException(_inner) => Some(_inner),
            CancelMulticastGroupSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDestinationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDestinationError {
    fn code(&self) -> Option<&str> {
        CreateDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDestinationError {
    /// Creates a new `CreateDestinationError`.
    pub fn new(kind: CreateDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDestinationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDestinationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeviceProfileError {
    /// Kind of error that occurred.
    pub kind: CreateDeviceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeviceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeviceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeviceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDeviceProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDeviceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDeviceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDeviceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDeviceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeviceProfileError {
    fn code(&self) -> Option<&str> {
        CreateDeviceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeviceProfileError {
    /// Creates a new `CreateDeviceProfileError`.
    pub fn new(kind: CreateDeviceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeviceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeviceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeviceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeviceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeviceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeviceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeviceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDeviceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeviceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDeviceProfileErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDeviceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDeviceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDeviceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDeviceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: CreateFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFuotaTaskError {
    fn code(&self) -> Option<&str> {
        CreateFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFuotaTaskError {
    /// Creates a new `CreateFuotaTaskError`.
    pub fn new(kind: CreateFuotaTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFuotaTaskErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateFuotaTaskErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFuotaTaskErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: CreateMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMulticastGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMulticastGroupError {
    fn code(&self) -> Option<&str> {
        CreateMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMulticastGroupError {
    /// Creates a new `CreateMulticastGroupError`.
    pub fn new(kind: CreateMulticastGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMulticastGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::ValidationException(_inner) => Some(_inner),
            CreateMulticastGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNetworkAnalyzerConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateNetworkAnalyzerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNetworkAnalyzerConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNetworkAnalyzerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNetworkAnalyzerConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateNetworkAnalyzerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNetworkAnalyzerConfigurationError {
    /// Creates a new `CreateNetworkAnalyzerConfigurationError`.
    pub fn new(
        kind: CreateNetworkAnalyzerConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNetworkAnalyzerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNetworkAnalyzerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkAnalyzerConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkAnalyzerConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateNetworkAnalyzerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceProfileError {
    /// Kind of error that occurred.
    pub kind: CreateServiceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateServiceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateServiceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServiceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServiceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceProfileError {
    fn code(&self) -> Option<&str> {
        CreateServiceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceProfileError {
    /// Creates a new `CreateServiceProfileError`.
    pub fn new(kind: CreateServiceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateServiceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceProfileErrorKind::ConflictException(_inner) => Some(_inner),
            CreateServiceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateServiceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServiceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServiceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: CreateWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWirelessDeviceErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWirelessDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        CreateWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWirelessDeviceError {
    /// Creates a new `CreateWirelessDeviceError`.
    pub fn new(kind: CreateWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWirelessDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWirelessGatewayError {
    /// Kind of error that occurred.
    pub kind: CreateWirelessGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWirelessGatewayErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWirelessGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWirelessGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWirelessGatewayError {
    fn code(&self) -> Option<&str> {
        CreateWirelessGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWirelessGatewayError {
    /// Creates a new `CreateWirelessGatewayError`.
    pub fn new(kind: CreateWirelessGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWirelessGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWirelessGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWirelessGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWirelessGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateWirelessGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWirelessGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWirelessGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWirelessGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWirelessGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWirelessGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWirelessGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWirelessGatewayTaskError {
    /// Kind of error that occurred.
    pub kind: CreateWirelessGatewayTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWirelessGatewayTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWirelessGatewayTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWirelessGatewayTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWirelessGatewayTaskError {
    fn code(&self) -> Option<&str> {
        CreateWirelessGatewayTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWirelessGatewayTaskError {
    /// Creates a new `CreateWirelessGatewayTaskError`.
    pub fn new(kind: CreateWirelessGatewayTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWirelessGatewayTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWirelessGatewayTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWirelessGatewayTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWirelessGatewayTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateWirelessGatewayTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWirelessGatewayTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: CreateWirelessGatewayTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWirelessGatewayTaskDefinitionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWirelessGatewayTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWirelessGatewayTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        CreateWirelessGatewayTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWirelessGatewayTaskDefinitionError {
    /// Creates a new `CreateWirelessGatewayTaskDefinitionError`.
    pub fn new(
        kind: CreateWirelessGatewayTaskDefinitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWirelessGatewayTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWirelessGatewayTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWirelessGatewayTaskDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWirelessGatewayTaskDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateWirelessGatewayTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDestinationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDestinationError {
    /// Creates a new `DeleteDestinationError`.
    pub fn new(kind: DeleteDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDestinationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDeviceProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteDeviceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDeviceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDeviceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDeviceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDeviceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDeviceProfileError {
    fn code(&self) -> Option<&str> {
        DeleteDeviceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDeviceProfileError {
    /// Creates a new `DeleteDeviceProfileError`.
    pub fn new(kind: DeleteDeviceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDeviceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDeviceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDeviceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDeviceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDeviceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDeviceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDeviceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDeviceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDeviceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: DeleteFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFuotaTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFuotaTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFuotaTaskError {
    fn code(&self) -> Option<&str> {
        DeleteFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFuotaTaskError {
    /// Creates a new `DeleteFuotaTaskError`.
    pub fn new(kind: DeleteFuotaTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFuotaTaskErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFuotaTaskErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFuotaTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFuotaTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMulticastGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMulticastGroupError {
    fn code(&self) -> Option<&str> {
        DeleteMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMulticastGroupError {
    /// Creates a new `DeleteMulticastGroupError`.
    pub fn new(kind: DeleteMulticastGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMulticastGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteMulticastGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNetworkAnalyzerConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteNetworkAnalyzerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNetworkAnalyzerConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNetworkAnalyzerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNetworkAnalyzerConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteNetworkAnalyzerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNetworkAnalyzerConfigurationError {
    /// Creates a new `DeleteNetworkAnalyzerConfigurationError`.
    pub fn new(
        kind: DeleteNetworkAnalyzerConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNetworkAnalyzerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNetworkAnalyzerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNetworkAnalyzerConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNetworkAnalyzerConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteNetworkAnalyzerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQueuedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQueuedMessagesError {
    /// Kind of error that occurred.
    pub kind: DeleteQueuedMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQueuedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQueuedMessagesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQueuedMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQueuedMessagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteQueuedMessagesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteQueuedMessagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteQueuedMessagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteQueuedMessagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteQueuedMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQueuedMessagesError {
    fn code(&self) -> Option<&str> {
        DeleteQueuedMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQueuedMessagesError {
    /// Creates a new `DeleteQueuedMessagesError`.
    pub fn new(kind: DeleteQueuedMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQueuedMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQueuedMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQueuedMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQueuedMessagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQueuedMessagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueuedMessagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueuedMessagesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueuedMessagesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueuedMessagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueuedMessagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueuedMessagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueuedMessagesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueuedMessagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueuedMessagesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteQueuedMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQueuedMessagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteQueuedMessagesErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteQueuedMessagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteQueuedMessagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteQueuedMessagesErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteQueuedMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServiceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceProfileError {
    fn code(&self) -> Option<&str> {
        DeleteServiceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceProfileError {
    /// Creates a new `DeleteServiceProfileError`.
    pub fn new(kind: DeleteServiceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteServiceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServiceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWirelessDeviceErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWirelessDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        DeleteWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWirelessDeviceError {
    /// Creates a new `DeleteWirelessDeviceError`.
    pub fn new(kind: DeleteWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWirelessDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWirelessDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWirelessGatewayError {
    /// Kind of error that occurred.
    pub kind: DeleteWirelessGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWirelessGatewayErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWirelessGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWirelessGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWirelessGatewayError {
    fn code(&self) -> Option<&str> {
        DeleteWirelessGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWirelessGatewayError {
    /// Creates a new `DeleteWirelessGatewayError`.
    pub fn new(kind: DeleteWirelessGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWirelessGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWirelessGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWirelessGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWirelessGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteWirelessGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWirelessGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWirelessGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWirelessGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWirelessGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWirelessGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWirelessGatewayTaskError {
    /// Kind of error that occurred.
    pub kind: DeleteWirelessGatewayTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWirelessGatewayTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWirelessGatewayTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWirelessGatewayTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWirelessGatewayTaskError {
    fn code(&self) -> Option<&str> {
        DeleteWirelessGatewayTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWirelessGatewayTaskError {
    /// Creates a new `DeleteWirelessGatewayTaskError`.
    pub fn new(kind: DeleteWirelessGatewayTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWirelessGatewayTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWirelessGatewayTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWirelessGatewayTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWirelessGatewayTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteWirelessGatewayTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWirelessGatewayTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWirelessGatewayTaskErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWirelessGatewayTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWirelessGatewayTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeleteWirelessGatewayTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWirelessGatewayTaskDefinitionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWirelessGatewayTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWirelessGatewayTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        DeleteWirelessGatewayTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWirelessGatewayTaskDefinitionError {
    /// Creates a new `DeleteWirelessGatewayTaskDefinitionError`.
    pub fn new(
        kind: DeleteWirelessGatewayTaskDefinitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWirelessGatewayTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWirelessGatewayTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWirelessGatewayTaskDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWirelessGatewayTaskDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteWirelessGatewayTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateAwsAccountFromPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateAwsAccountFromPartnerAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateAwsAccountFromPartnerAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateAwsAccountFromPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateAwsAccountFromPartnerAccountErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateAwsAccountFromPartnerAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateAwsAccountFromPartnerAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateAwsAccountFromPartnerAccountErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateAwsAccountFromPartnerAccountError {
    fn code(&self) -> Option<&str> {
        DisassociateAwsAccountFromPartnerAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateAwsAccountFromPartnerAccountError {
    /// Creates a new `DisassociateAwsAccountFromPartnerAccountError`.
    pub fn new(
        kind: DisassociateAwsAccountFromPartnerAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateAwsAccountFromPartnerAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateAwsAccountFromPartnerAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateAwsAccountFromPartnerAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateAwsAccountFromPartnerAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateAwsAccountFromPartnerAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAwsAccountFromPartnerAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAwsAccountFromPartnerAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAwsAccountFromPartnerAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAwsAccountFromPartnerAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAwsAccountFromPartnerAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAwsAccountFromPartnerAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAwsAccountFromPartnerAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateAwsAccountFromPartnerAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateAwsAccountFromPartnerAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DisassociateAwsAccountFromPartnerAccountErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateAwsAccountFromPartnerAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateMulticastGroupFromFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMulticastGroupFromFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: DisassociateMulticastGroupFromFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMulticastGroupFromFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMulticastGroupFromFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMulticastGroupFromFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMulticastGroupFromFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMulticastGroupFromFuotaTaskError {
    fn code(&self) -> Option<&str> {
        DisassociateMulticastGroupFromFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateMulticastGroupFromFuotaTaskError {
    /// Creates a new `DisassociateMulticastGroupFromFuotaTaskError`.
    pub fn new(
        kind: DisassociateMulticastGroupFromFuotaTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMulticastGroupFromFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMulticastGroupFromFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMulticastGroupFromFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMulticastGroupFromFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateMulticastGroupFromFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMulticastGroupFromFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMulticastGroupFromFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMulticastGroupFromFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMulticastGroupFromFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMulticastGroupFromFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMulticastGroupFromFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateMulticastGroupFromFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMulticastGroupFromFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateMulticastGroupFromFuotaTaskErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWirelessDeviceFromFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: DisassociateWirelessDeviceFromFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWirelessDeviceFromFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWirelessDeviceFromFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWirelessDeviceFromFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWirelessDeviceFromFuotaTaskError {
    fn code(&self) -> Option<&str> {
        DisassociateWirelessDeviceFromFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWirelessDeviceFromFuotaTaskError {
    /// Creates a new `DisassociateWirelessDeviceFromFuotaTaskError`.
    pub fn new(
        kind: DisassociateWirelessDeviceFromFuotaTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWirelessDeviceFromFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWirelessDeviceFromFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWirelessDeviceFromFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWirelessDeviceFromFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateWirelessDeviceFromFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromFuotaTaskErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWirelessDeviceFromMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: DisassociateWirelessDeviceFromMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWirelessDeviceFromMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWirelessDeviceFromMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWirelessDeviceFromMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DisassociateWirelessDeviceFromMulticastGroupError
{
    fn code(&self) -> Option<&str> {
        DisassociateWirelessDeviceFromMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWirelessDeviceFromMulticastGroupError {
    /// Creates a new `DisassociateWirelessDeviceFromMulticastGroupError`.
    pub fn new(
        kind: DisassociateWirelessDeviceFromMulticastGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWirelessDeviceFromMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWirelessDeviceFromMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateWirelessDeviceFromMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(
                _inner,
            ) => Some(_inner),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWirelessDeviceFromThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWirelessDeviceFromThingError {
    /// Kind of error that occurred.
    pub kind: DisassociateWirelessDeviceFromThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWirelessDeviceFromThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWirelessDeviceFromThingErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWirelessDeviceFromThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWirelessDeviceFromThingErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessDeviceFromThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWirelessDeviceFromThingError {
    fn code(&self) -> Option<&str> {
        DisassociateWirelessDeviceFromThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWirelessDeviceFromThingError {
    /// Creates a new `DisassociateWirelessDeviceFromThingError`.
    pub fn new(
        kind: DisassociateWirelessDeviceFromThingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWirelessDeviceFromThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWirelessDeviceFromThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWirelessDeviceFromThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWirelessDeviceFromThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessDeviceFromThingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessDeviceFromThingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateWirelessDeviceFromThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWirelessDeviceFromThingErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateWirelessDeviceFromThingErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromThingErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessDeviceFromThingErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWirelessGatewayFromCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWirelessGatewayFromCertificateError {
    /// Kind of error that occurred.
    pub kind: DisassociateWirelessGatewayFromCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWirelessGatewayFromCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWirelessGatewayFromCertificateErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWirelessGatewayFromCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWirelessGatewayFromCertificateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWirelessGatewayFromCertificateErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateWirelessGatewayFromCertificateErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWirelessGatewayFromCertificateError {
    fn code(&self) -> Option<&str> {
        DisassociateWirelessGatewayFromCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWirelessGatewayFromCertificateError {
    /// Creates a new `DisassociateWirelessGatewayFromCertificateError`.
    pub fn new(
        kind: DisassociateWirelessGatewayFromCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWirelessGatewayFromCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWirelessGatewayFromCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWirelessGatewayFromCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWirelessGatewayFromCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromCertificateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromCertificateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromCertificateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromCertificateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateWirelessGatewayFromCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWirelessGatewayFromCertificateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            DisassociateWirelessGatewayFromCertificateErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DisassociateWirelessGatewayFromCertificateErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromCertificateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateWirelessGatewayFromThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWirelessGatewayFromThingError {
    /// Kind of error that occurred.
    pub kind: DisassociateWirelessGatewayFromThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWirelessGatewayFromThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWirelessGatewayFromThingErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWirelessGatewayFromThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWirelessGatewayFromThingErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateWirelessGatewayFromThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWirelessGatewayFromThingError {
    fn code(&self) -> Option<&str> {
        DisassociateWirelessGatewayFromThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWirelessGatewayFromThingError {
    /// Creates a new `DisassociateWirelessGatewayFromThingError`.
    pub fn new(
        kind: DisassociateWirelessGatewayFromThingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWirelessGatewayFromThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWirelessGatewayFromThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWirelessGatewayFromThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWirelessGatewayFromThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWirelessGatewayFromThingErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWirelessGatewayFromThingErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateWirelessGatewayFromThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWirelessGatewayFromThingErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateWirelessGatewayFromThingErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDestinationError {
    /// Kind of error that occurred.
    pub kind: GetDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDestinationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDestinationError {
    fn code(&self) -> Option<&str> {
        GetDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDestinationError {
    /// Creates a new `GetDestinationError`.
    pub fn new(kind: GetDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDestinationErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDestinationErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            GetDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceProfileError {
    /// Kind of error that occurred.
    pub kind: GetDeviceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeviceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDeviceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDeviceProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeviceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDeviceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDeviceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceProfileError {
    fn code(&self) -> Option<&str> {
        GetDeviceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceProfileError {
    /// Creates a new `GetDeviceProfileError`.
    pub fn new(kind: GetDeviceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeviceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDeviceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDeviceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDeviceProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeviceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDeviceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            GetDeviceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventConfigurationByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventConfigurationByResourceTypesError {
    /// Kind of error that occurred.
    pub kind: GetEventConfigurationByResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventConfigurationByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventConfigurationByResourceTypesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventConfigurationByResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetEventConfigurationByResourceTypesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetEventConfigurationByResourceTypesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetEventConfigurationByResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventConfigurationByResourceTypesError {
    fn code(&self) -> Option<&str> {
        GetEventConfigurationByResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventConfigurationByResourceTypesError {
    /// Creates a new `GetEventConfigurationByResourceTypesError`.
    pub fn new(
        kind: GetEventConfigurationByResourceTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventConfigurationByResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventConfigurationByResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventConfigurationByResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventConfigurationByResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventConfigurationByResourceTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventConfigurationByResourceTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventConfigurationByResourceTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventConfigurationByResourceTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventConfigurationByResourceTypesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetEventConfigurationByResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetEventConfigurationByResourceTypesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetEventConfigurationByResourceTypesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetEventConfigurationByResourceTypesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: GetFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFuotaTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFuotaTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFuotaTaskError {
    fn code(&self) -> Option<&str> {
        GetFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFuotaTaskError {
    /// Creates a new `GetFuotaTaskError`.
    pub fn new(kind: GetFuotaTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetFuotaTaskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetFuotaTaskErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetFuotaTaskErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFuotaTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFuotaTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            GetFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLogLevelsByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLogLevelsByResourceTypesError {
    /// Kind of error that occurred.
    pub kind: GetLogLevelsByResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLogLevelsByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLogLevelsByResourceTypesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLogLevelsByResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLogLevelsByResourceTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLogLevelsByResourceTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetLogLevelsByResourceTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLogLevelsByResourceTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLogLevelsByResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLogLevelsByResourceTypesError {
    fn code(&self) -> Option<&str> {
        GetLogLevelsByResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLogLevelsByResourceTypesError {
    /// Creates a new `GetLogLevelsByResourceTypesError`.
    pub fn new(kind: GetLogLevelsByResourceTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLogLevelsByResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLogLevelsByResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLogLevelsByResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLogLevelsByResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLogLevelsByResourceTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogLevelsByResourceTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogLevelsByResourceTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogLevelsByResourceTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogLevelsByResourceTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogLevelsByResourceTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogLevelsByResourceTypesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogLevelsByResourceTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogLevelsByResourceTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLogLevelsByResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLogLevelsByResourceTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLogLevelsByResourceTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLogLevelsByResourceTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLogLevelsByResourceTypesErrorKind::ValidationException(_inner) => Some(_inner),
            GetLogLevelsByResourceTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: GetMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMulticastGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMulticastGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMulticastGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMulticastGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMulticastGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMulticastGroupError {
    fn code(&self) -> Option<&str> {
        GetMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMulticastGroupError {
    /// Creates a new `GetMulticastGroupError`.
    pub fn new(kind: GetMulticastGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMulticastGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMulticastGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMulticastGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMulticastGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMulticastGroupErrorKind::ValidationException(_inner) => Some(_inner),
            GetMulticastGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMulticastGroupSessionError {
    /// Kind of error that occurred.
    pub kind: GetMulticastGroupSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMulticastGroupSessionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMulticastGroupSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMulticastGroupSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMulticastGroupSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMulticastGroupSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMulticastGroupSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMulticastGroupSessionError {
    fn code(&self) -> Option<&str> {
        GetMulticastGroupSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMulticastGroupSessionError {
    /// Creates a new `GetMulticastGroupSessionError`.
    pub fn new(kind: GetMulticastGroupSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMulticastGroupSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMulticastGroupSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMulticastGroupSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMulticastGroupSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMulticastGroupSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMulticastGroupSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMulticastGroupSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetMulticastGroupSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMulticastGroupSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMulticastGroupSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMulticastGroupSessionErrorKind::ValidationException(_inner) => Some(_inner),
            GetMulticastGroupSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkAnalyzerConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetNetworkAnalyzerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkAnalyzerConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkAnalyzerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkAnalyzerConfigurationError {
    fn code(&self) -> Option<&str> {
        GetNetworkAnalyzerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkAnalyzerConfigurationError {
    /// Creates a new `GetNetworkAnalyzerConfigurationError`.
    pub fn new(
        kind: GetNetworkAnalyzerConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkAnalyzerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkAnalyzerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkAnalyzerConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkAnalyzerConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkAnalyzerConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkAnalyzerConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkAnalyzerConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkAnalyzerConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetNetworkAnalyzerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPartnerAccountError {
    /// Kind of error that occurred.
    pub kind: GetPartnerAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPartnerAccountErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPartnerAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPartnerAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPartnerAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPartnerAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPartnerAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPartnerAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPartnerAccountError {
    fn code(&self) -> Option<&str> {
        GetPartnerAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPartnerAccountError {
    /// Creates a new `GetPartnerAccountError`.
    pub fn new(kind: GetPartnerAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPartnerAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPartnerAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPartnerAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPartnerAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPartnerAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartnerAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartnerAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartnerAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartnerAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartnerAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartnerAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartnerAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPartnerAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPartnerAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPartnerAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPartnerAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPartnerAccountErrorKind::ValidationException(_inner) => Some(_inner),
            GetPartnerAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceEventConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceEventConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetResourceEventConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceEventConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceEventConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceEventConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceEventConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourceEventConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceEventConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceEventConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourceEventConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourceEventConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceEventConfigurationError {
    fn code(&self) -> Option<&str> {
        GetResourceEventConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceEventConfigurationError {
    /// Creates a new `GetResourceEventConfigurationError`.
    pub fn new(
        kind: GetResourceEventConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceEventConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceEventConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceEventConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceEventConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceEventConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceEventConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceEventConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceEventConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceEventConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceEventConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceEventConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceEventConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceEventConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceEventConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourceEventConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceEventConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourceEventConfigurationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourceEventConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetResourceEventConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourceEventConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourceEventConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceLogLevelError {
    /// Kind of error that occurred.
    pub kind: GetResourceLogLevelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceLogLevelErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceLogLevelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceLogLevelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourceLogLevelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourceLogLevelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourceLogLevelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourceLogLevelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceLogLevelError {
    fn code(&self) -> Option<&str> {
        GetResourceLogLevelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceLogLevelError {
    /// Creates a new `GetResourceLogLevelError`.
    pub fn new(kind: GetResourceLogLevelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceLogLevelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceLogLevelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceLogLevelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceLogLevelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceLogLevelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLogLevelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceLogLevelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLogLevelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceLogLevelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLogLevelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceLogLevelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLogLevelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceLogLevelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceLogLevelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetResourceLogLevelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceLogLevelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourceLogLevelErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourceLogLevelErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourceLogLevelErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourceLogLevelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceEndpointError {
    /// Kind of error that occurred.
    pub kind: GetServiceEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceEndpointErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceEndpointErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceEndpointErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceEndpointErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceEndpointError {
    fn code(&self) -> Option<&str> {
        GetServiceEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceEndpointError {
    /// Creates a new `GetServiceEndpointError`.
    pub fn new(kind: GetServiceEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceEndpointErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceEndpointErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceEndpointErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceEndpointErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceEndpointErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceEndpointErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServiceEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceEndpointErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceEndpointErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceEndpointErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceProfileError {
    /// Kind of error that occurred.
    pub kind: GetServiceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceProfileErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceProfileErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceProfileError {
    fn code(&self) -> Option<&str> {
        GetServiceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceProfileError {
    /// Creates a new `GetServiceProfileError`.
    pub fn new(kind: GetServiceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceProfileErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceProfileErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServiceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceProfileErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: GetWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessDeviceErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        GetWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessDeviceError {
    /// Creates a new `GetWirelessDeviceError`.
    pub fn new(kind: GetWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessDeviceStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessDeviceStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetWirelessDeviceStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessDeviceStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessDeviceStatisticsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessDeviceStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessDeviceStatisticsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessDeviceStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWirelessDeviceStatisticsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessDeviceStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessDeviceStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessDeviceStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessDeviceStatisticsError {
    fn code(&self) -> Option<&str> {
        GetWirelessDeviceStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessDeviceStatisticsError {
    /// Creates a new `GetWirelessDeviceStatisticsError`.
    pub fn new(kind: GetWirelessDeviceStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessDeviceStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessDeviceStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessDeviceStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessDeviceStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceStatisticsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceStatisticsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessDeviceStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessDeviceStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessDeviceStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessDeviceStatisticsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessDeviceStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessDeviceStatisticsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWirelessDeviceStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessDeviceStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessDeviceStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetWirelessGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayError {
    /// Creates a new `GetWirelessGatewayError`.
    pub fn new(kind: GetWirelessGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWirelessGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessGatewayCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayCertificateError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGatewayCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayCertificateErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayCertificateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessGatewayCertificateErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayCertificateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessGatewayCertificateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessGatewayCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayCertificateError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayCertificateError {
    /// Creates a new `GetWirelessGatewayCertificateError`.
    pub fn new(
        kind: GetWirelessGatewayCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayCertificateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayCertificateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayCertificateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayCertificateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayCertificateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessGatewayCertificateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessGatewayCertificateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessGatewayCertificateErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessGatewayCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessGatewayFirmwareInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayFirmwareInformationError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayFirmwareInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGatewayFirmwareInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayFirmwareInformationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayFirmwareInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayFirmwareInformationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayFirmwareInformationError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayFirmwareInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayFirmwareInformationError {
    /// Creates a new `GetWirelessGatewayFirmwareInformationError`.
    pub fn new(
        kind: GetWirelessGatewayFirmwareInformationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayFirmwareInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayFirmwareInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayFirmwareInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayFirmwareInformationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayFirmwareInformationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayFirmwareInformationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayFirmwareInformationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayFirmwareInformationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayFirmwareInformationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayFirmwareInformationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayFirmwareInformationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayFirmwareInformationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayFirmwareInformationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayFirmwareInformationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayFirmwareInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayFirmwareInformationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayFirmwareInformationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetWirelessGatewayStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGatewayStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayStatisticsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayStatisticsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessGatewayStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWirelessGatewayStatisticsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessGatewayStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessGatewayStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayStatisticsError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayStatisticsError {
    /// Creates a new `GetWirelessGatewayStatisticsError`.
    pub fn new(kind: GetWirelessGatewayStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayStatisticsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayStatisticsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayStatisticsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessGatewayStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessGatewayStatisticsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessGatewayStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessGatewayStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayTaskError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGatewayTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayTaskError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayTaskError {
    /// Creates a new `GetWirelessGatewayTaskError`.
    pub fn new(kind: GetWirelessGatewayTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWirelessGatewayTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWirelessGatewayTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWirelessGatewayTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessGatewayTaskErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessGatewayTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWirelessGatewayTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: GetWirelessGatewayTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWirelessGatewayTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWirelessGatewayTaskDefinitionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWirelessGatewayTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWirelessGatewayTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        GetWirelessGatewayTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWirelessGatewayTaskDefinitionError {
    /// Creates a new `GetWirelessGatewayTaskDefinitionError`.
    pub fn new(
        kind: GetWirelessGatewayTaskDefinitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWirelessGatewayTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWirelessGatewayTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWirelessGatewayTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskDefinitionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskDefinitionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWirelessGatewayTaskDefinitionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWirelessGatewayTaskDefinitionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetWirelessGatewayTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWirelessGatewayTaskDefinitionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetWirelessGatewayTaskDefinitionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWirelessGatewayTaskDefinitionErrorKind::ValidationException(_inner) => Some(_inner),
            GetWirelessGatewayTaskDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDestinationsError {
    /// Kind of error that occurred.
    pub kind: ListDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDestinationsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDestinationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDestinationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDestinationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDestinationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDestinationsError {
    fn code(&self) -> Option<&str> {
        ListDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDestinationsError {
    /// Creates a new `ListDestinationsError`.
    pub fn new(kind: ListDestinationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDestinationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDestinationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDestinationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDestinationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDestinationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDestinationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDestinationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDestinationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDestinationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDestinationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDestinationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDestinationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDestinationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeviceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeviceProfilesError {
    /// Kind of error that occurred.
    pub kind: ListDeviceProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeviceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeviceProfilesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeviceProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeviceProfilesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDeviceProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDeviceProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDeviceProfilesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDeviceProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeviceProfilesError {
    fn code(&self) -> Option<&str> {
        ListDeviceProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeviceProfilesError {
    /// Creates a new `ListDeviceProfilesError`.
    pub fn new(kind: ListDeviceProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeviceProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeviceProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeviceProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeviceProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeviceProfilesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceProfilesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceProfilesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceProfilesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceProfilesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDeviceProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeviceProfilesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDeviceProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDeviceProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDeviceProfilesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDeviceProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListEventConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventConfigurationsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventConfigurationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEventConfigurationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEventConfigurationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEventConfigurationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEventConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListEventConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventConfigurationsError {
    /// Creates a new `ListEventConfigurationsError`.
    pub fn new(kind: ListEventConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventConfigurationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventConfigurationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventConfigurationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventConfigurationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventConfigurationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventConfigurationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventConfigurationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventConfigurationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEventConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventConfigurationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEventConfigurationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEventConfigurationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEventConfigurationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEventConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFuotaTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFuotaTasksError {
    /// Kind of error that occurred.
    pub kind: ListFuotaTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFuotaTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFuotaTasksErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFuotaTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFuotaTasksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFuotaTasksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFuotaTasksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFuotaTasksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFuotaTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFuotaTasksError {
    fn code(&self) -> Option<&str> {
        ListFuotaTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFuotaTasksError {
    /// Creates a new `ListFuotaTasksError`.
    pub fn new(kind: ListFuotaTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFuotaTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFuotaTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFuotaTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFuotaTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFuotaTasksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFuotaTasksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFuotaTasksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFuotaTasksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFuotaTasksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFuotaTasksErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFuotaTasksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFuotaTasksErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFuotaTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFuotaTasksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFuotaTasksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFuotaTasksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFuotaTasksErrorKind::ValidationException(_inner) => Some(_inner),
            ListFuotaTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMulticastGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMulticastGroupsError {
    /// Kind of error that occurred.
    pub kind: ListMulticastGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMulticastGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMulticastGroupsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMulticastGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMulticastGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMulticastGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListMulticastGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMulticastGroupsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMulticastGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMulticastGroupsError {
    fn code(&self) -> Option<&str> {
        ListMulticastGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMulticastGroupsError {
    /// Creates a new `ListMulticastGroupsError`.
    pub fn new(kind: ListMulticastGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMulticastGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMulticastGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMulticastGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMulticastGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListMulticastGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMulticastGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMulticastGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListMulticastGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMulticastGroupsErrorKind::ValidationException(_inner) => Some(_inner),
            ListMulticastGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMulticastGroupsByFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMulticastGroupsByFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: ListMulticastGroupsByFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMulticastGroupsByFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMulticastGroupsByFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMulticastGroupsByFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMulticastGroupsByFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMulticastGroupsByFuotaTaskErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListMulticastGroupsByFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListMulticastGroupsByFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMulticastGroupsByFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMulticastGroupsByFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMulticastGroupsByFuotaTaskError {
    fn code(&self) -> Option<&str> {
        ListMulticastGroupsByFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMulticastGroupsByFuotaTaskError {
    /// Creates a new `ListMulticastGroupsByFuotaTaskError`.
    pub fn new(
        kind: ListMulticastGroupsByFuotaTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMulticastGroupsByFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMulticastGroupsByFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMulticastGroupsByFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMulticastGroupsByFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsByFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsByFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsByFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsByFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsByFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsByFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsByFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsByFuotaTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMulticastGroupsByFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMulticastGroupsByFuotaTaskErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListMulticastGroupsByFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMulticastGroupsByFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMulticastGroupsByFuotaTaskErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListMulticastGroupsByFuotaTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListMulticastGroupsByFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMulticastGroupsByFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            ListMulticastGroupsByFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNetworkAnalyzerConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNetworkAnalyzerConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListNetworkAnalyzerConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNetworkAnalyzerConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNetworkAnalyzerConfigurationsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNetworkAnalyzerConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNetworkAnalyzerConfigurationsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNetworkAnalyzerConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListNetworkAnalyzerConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNetworkAnalyzerConfigurationsError {
    /// Creates a new `ListNetworkAnalyzerConfigurationsError`.
    pub fn new(
        kind: ListNetworkAnalyzerConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNetworkAnalyzerConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNetworkAnalyzerConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNetworkAnalyzerConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNetworkAnalyzerConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNetworkAnalyzerConfigurationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkAnalyzerConfigurationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkAnalyzerConfigurationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkAnalyzerConfigurationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkAnalyzerConfigurationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkAnalyzerConfigurationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworkAnalyzerConfigurationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworkAnalyzerConfigurationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNetworkAnalyzerConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNetworkAnalyzerConfigurationsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListNetworkAnalyzerConfigurationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNetworkAnalyzerConfigurationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNetworkAnalyzerConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPartnerAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPartnerAccountsError {
    /// Kind of error that occurred.
    pub kind: ListPartnerAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPartnerAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPartnerAccountsErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPartnerAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPartnerAccountsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPartnerAccountsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPartnerAccountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPartnerAccountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPartnerAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPartnerAccountsError {
    fn code(&self) -> Option<&str> {
        ListPartnerAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPartnerAccountsError {
    /// Creates a new `ListPartnerAccountsError`.
    pub fn new(kind: ListPartnerAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPartnerAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPartnerAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPartnerAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPartnerAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPartnerAccountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerAccountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerAccountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerAccountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerAccountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerAccountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPartnerAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPartnerAccountsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPartnerAccountsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPartnerAccountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPartnerAccountsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPartnerAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueuedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueuedMessagesError {
    /// Kind of error that occurred.
    pub kind: ListQueuedMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueuedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueuedMessagesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueuedMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueuedMessagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListQueuedMessagesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListQueuedMessagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListQueuedMessagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListQueuedMessagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListQueuedMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueuedMessagesError {
    fn code(&self) -> Option<&str> {
        ListQueuedMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueuedMessagesError {
    /// Creates a new `ListQueuedMessagesError`.
    pub fn new(kind: ListQueuedMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueuedMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueuedMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueuedMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueuedMessagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueuedMessagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuedMessagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuedMessagesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuedMessagesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuedMessagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuedMessagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuedMessagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuedMessagesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuedMessagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuedMessagesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListQueuedMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueuedMessagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListQueuedMessagesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListQueuedMessagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListQueuedMessagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListQueuedMessagesErrorKind::ValidationException(_inner) => Some(_inner),
            ListQueuedMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceProfilesError {
    /// Kind of error that occurred.
    pub kind: ListServiceProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceProfilesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceProfilesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServiceProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServiceProfilesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServiceProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceProfilesError {
    fn code(&self) -> Option<&str> {
        ListServiceProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceProfilesError {
    /// Creates a new `ListServiceProfilesError`.
    pub fn new(kind: ListServiceProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceProfilesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceProfilesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceProfilesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceProfilesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceProfilesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceProfilesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServiceProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServiceProfilesErrorKind::ValidationException(_inner) => Some(_inner),
            ListServiceProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWirelessDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWirelessDevicesError {
    /// Kind of error that occurred.
    pub kind: ListWirelessDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWirelessDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWirelessDevicesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWirelessDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWirelessDevicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWirelessDevicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWirelessDevicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWirelessDevicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWirelessDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWirelessDevicesError {
    fn code(&self) -> Option<&str> {
        ListWirelessDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWirelessDevicesError {
    /// Creates a new `ListWirelessDevicesError`.
    pub fn new(kind: ListWirelessDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWirelessDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWirelessDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWirelessDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWirelessDevicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWirelessDevicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessDevicesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessDevicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessDevicesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessDevicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessDevicesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessDevicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessDevicesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListWirelessDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWirelessDevicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWirelessDevicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWirelessDevicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWirelessDevicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListWirelessDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWirelessGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWirelessGatewaysError {
    /// Kind of error that occurred.
    pub kind: ListWirelessGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWirelessGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWirelessGatewaysErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWirelessGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWirelessGatewaysErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWirelessGatewaysErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWirelessGatewaysErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWirelessGatewaysErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWirelessGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWirelessGatewaysError {
    fn code(&self) -> Option<&str> {
        ListWirelessGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWirelessGatewaysError {
    /// Creates a new `ListWirelessGatewaysError`.
    pub fn new(kind: ListWirelessGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWirelessGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWirelessGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWirelessGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWirelessGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWirelessGatewaysErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewaysErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewaysErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewaysErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewaysErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewaysErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewaysErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewaysErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListWirelessGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWirelessGatewaysErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWirelessGatewaysErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWirelessGatewaysErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWirelessGatewaysErrorKind::ValidationException(_inner) => Some(_inner),
            ListWirelessGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWirelessGatewayTaskDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWirelessGatewayTaskDefinitionsError {
    /// Kind of error that occurred.
    pub kind: ListWirelessGatewayTaskDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWirelessGatewayTaskDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWirelessGatewayTaskDefinitionsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWirelessGatewayTaskDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWirelessGatewayTaskDefinitionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWirelessGatewayTaskDefinitionsError {
    fn code(&self) -> Option<&str> {
        ListWirelessGatewayTaskDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWirelessGatewayTaskDefinitionsError {
    /// Creates a new `ListWirelessGatewayTaskDefinitionsError`.
    pub fn new(
        kind: ListWirelessGatewayTaskDefinitionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWirelessGatewayTaskDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWirelessGatewayTaskDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWirelessGatewayTaskDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWirelessGatewayTaskDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWirelessGatewayTaskDefinitionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewayTaskDefinitionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewayTaskDefinitionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewayTaskDefinitionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewayTaskDefinitionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewayTaskDefinitionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWirelessGatewayTaskDefinitionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWirelessGatewayTaskDefinitionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListWirelessGatewayTaskDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWirelessGatewayTaskDefinitionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListWirelessGatewayTaskDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourceLogLevelError {
    /// Kind of error that occurred.
    pub kind: PutResourceLogLevelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourceLogLevelErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourceLogLevelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourceLogLevelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutResourceLogLevelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourceLogLevelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutResourceLogLevelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutResourceLogLevelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourceLogLevelError {
    fn code(&self) -> Option<&str> {
        PutResourceLogLevelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourceLogLevelError {
    /// Creates a new `PutResourceLogLevelError`.
    pub fn new(kind: PutResourceLogLevelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourceLogLevelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourceLogLevelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourceLogLevelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourceLogLevelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourceLogLevelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceLogLevelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceLogLevelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceLogLevelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceLogLevelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceLogLevelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceLogLevelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceLogLevelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourceLogLevelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourceLogLevelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutResourceLogLevelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourceLogLevelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutResourceLogLevelErrorKind::InternalServerException(_inner) => Some(_inner),
            PutResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourceLogLevelErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutResourceLogLevelErrorKind::ValidationException(_inner) => Some(_inner),
            PutResourceLogLevelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetAllResourceLogLevels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetAllResourceLogLevelsError {
    /// Kind of error that occurred.
    pub kind: ResetAllResourceLogLevelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetAllResourceLogLevels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetAllResourceLogLevelsErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetAllResourceLogLevelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetAllResourceLogLevelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ResetAllResourceLogLevelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ResetAllResourceLogLevelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResetAllResourceLogLevelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ResetAllResourceLogLevelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ResetAllResourceLogLevelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetAllResourceLogLevelsError {
    fn code(&self) -> Option<&str> {
        ResetAllResourceLogLevelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetAllResourceLogLevelsError {
    /// Creates a new `ResetAllResourceLogLevelsError`.
    pub fn new(kind: ResetAllResourceLogLevelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetAllResourceLogLevelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetAllResourceLogLevelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetAllResourceLogLevelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetAllResourceLogLevelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetAllResourceLogLevelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAllResourceLogLevelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetAllResourceLogLevelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAllResourceLogLevelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetAllResourceLogLevelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAllResourceLogLevelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetAllResourceLogLevelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAllResourceLogLevelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetAllResourceLogLevelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetAllResourceLogLevelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ResetAllResourceLogLevelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetAllResourceLogLevelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ResetAllResourceLogLevelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ResetAllResourceLogLevelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResetAllResourceLogLevelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ResetAllResourceLogLevelsErrorKind::ValidationException(_inner) => Some(_inner),
            ResetAllResourceLogLevelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetResourceLogLevelError {
    /// Kind of error that occurred.
    pub kind: ResetResourceLogLevelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetResourceLogLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetResourceLogLevelErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetResourceLogLevelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetResourceLogLevelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ResetResourceLogLevelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ResetResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResetResourceLogLevelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ResetResourceLogLevelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ResetResourceLogLevelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetResourceLogLevelError {
    fn code(&self) -> Option<&str> {
        ResetResourceLogLevelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetResourceLogLevelError {
    /// Creates a new `ResetResourceLogLevelError`.
    pub fn new(kind: ResetResourceLogLevelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetResourceLogLevelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetResourceLogLevelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetResourceLogLevelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetResourceLogLevelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetResourceLogLevelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetResourceLogLevelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetResourceLogLevelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetResourceLogLevelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetResourceLogLevelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetResourceLogLevelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetResourceLogLevelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetResourceLogLevelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetResourceLogLevelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetResourceLogLevelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ResetResourceLogLevelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetResourceLogLevelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ResetResourceLogLevelErrorKind::InternalServerException(_inner) => Some(_inner),
            ResetResourceLogLevelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResetResourceLogLevelErrorKind::ThrottlingException(_inner) => Some(_inner),
            ResetResourceLogLevelErrorKind::ValidationException(_inner) => Some(_inner),
            ResetResourceLogLevelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendDataToMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendDataToMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: SendDataToMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendDataToMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendDataToMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendDataToMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendDataToMulticastGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendDataToMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendDataToMulticastGroupError {
    fn code(&self) -> Option<&str> {
        SendDataToMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendDataToMulticastGroupError {
    /// Creates a new `SendDataToMulticastGroupError`.
    pub fn new(kind: SendDataToMulticastGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendDataToMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendDataToMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendDataToMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendDataToMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SendDataToMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendDataToMulticastGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::ConflictException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::ValidationException(_inner) => Some(_inner),
            SendDataToMulticastGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendDataToWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendDataToWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: SendDataToWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendDataToWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendDataToWirelessDeviceErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendDataToWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendDataToWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendDataToWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendDataToWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendDataToWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendDataToWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendDataToWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        SendDataToWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendDataToWirelessDeviceError {
    /// Creates a new `SendDataToWirelessDeviceError`.
    pub fn new(kind: SendDataToWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendDataToWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendDataToWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendDataToWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendDataToWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendDataToWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SendDataToWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendDataToWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SendDataToWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendDataToWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            SendDataToWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendDataToWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendDataToWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            SendDataToWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBulkAssociateWirelessDeviceWithMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBulkAssociateWirelessDeviceWithMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBulkAssociateWirelessDeviceWithMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBulkAssociateWirelessDeviceWithMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for StartBulkAssociateWirelessDeviceWithMulticastGroupError
{
    fn code(&self) -> Option<&str> {
        StartBulkAssociateWirelessDeviceWithMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBulkAssociateWirelessDeviceWithMulticastGroupError {
    /// Creates a new `StartBulkAssociateWirelessDeviceWithMulticastGroupError`.
    pub fn new(
        kind: StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBulkAssociateWirelessDeviceWithMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBulkAssociateWirelessDeviceWithMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartBulkAssociateWirelessDeviceWithMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            StartBulkAssociateWirelessDeviceWithMulticastGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StartBulkDisassociateWirelessDeviceFromMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBulkDisassociateWirelessDeviceFromMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBulkDisassociateWirelessDeviceFromMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBulkDisassociateWirelessDeviceFromMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_inner) =>
            _inner.fmt(f)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for StartBulkDisassociateWirelessDeviceFromMulticastGroupError
{
    fn code(&self) -> Option<&str> {
        StartBulkDisassociateWirelessDeviceFromMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBulkDisassociateWirelessDeviceFromMulticastGroupError {
    /// Creates a new `StartBulkDisassociateWirelessDeviceFromMulticastGroupError`.
    pub fn new(
        kind: StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBulkDisassociateWirelessDeviceFromMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBulkDisassociateWirelessDeviceFromMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartBulkDisassociateWirelessDeviceFromMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::InternalServerException(_inner) =>
            Some(_inner)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::ValidationException(_inner) =>
            Some(_inner)
            ,
            StartBulkDisassociateWirelessDeviceFromMulticastGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StartFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: StartFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFuotaTaskError {
    fn code(&self) -> Option<&str> {
        StartFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFuotaTaskError {
    /// Creates a new `StartFuotaTaskError`.
    pub fn new(kind: StartFuotaTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartFuotaTaskErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartFuotaTaskErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartFuotaTaskErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::ConflictException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            StartFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMulticastGroupSessionError {
    /// Kind of error that occurred.
    pub kind: StartMulticastGroupSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMulticastGroupSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMulticastGroupSessionErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMulticastGroupSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartMulticastGroupSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMulticastGroupSessionError {
    fn code(&self) -> Option<&str> {
        StartMulticastGroupSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMulticastGroupSessionError {
    /// Creates a new `StartMulticastGroupSessionError`.
    pub fn new(kind: StartMulticastGroupSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMulticastGroupSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMulticastGroupSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMulticastGroupSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMulticastGroupSessionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMulticastGroupSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMulticastGroupSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartMulticastGroupSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMulticastGroupSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::ConflictException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::ValidationException(_inner) => Some(_inner),
            StartMulticastGroupSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request was denied because the resource can't have any more tags.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: TestWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestWirelessDeviceErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TestWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TestWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TestWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TestWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        TestWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestWirelessDeviceError {
    /// Creates a new `TestWirelessDeviceError`.
    pub fn new(kind: TestWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `TestWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TestWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `TestWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for TestWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            TestWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TestWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TestWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            TestWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDestinationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDestinationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDestinationError {
    /// Creates a new `UpdateDestinationError`.
    pub fn new(kind: UpdateDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDestinationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDestinationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDestinationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDestinationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDestinationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDestinationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventConfigurationByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventConfigurationByResourceTypesError {
    /// Kind of error that occurred.
    pub kind: UpdateEventConfigurationByResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventConfigurationByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventConfigurationByResourceTypesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventConfigurationByResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventConfigurationByResourceTypesError {
    fn code(&self) -> Option<&str> {
        UpdateEventConfigurationByResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventConfigurationByResourceTypesError {
    /// Creates a new `UpdateEventConfigurationByResourceTypesError`.
    pub fn new(
        kind: UpdateEventConfigurationByResourceTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventConfigurationByResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventConfigurationByResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventConfigurationByResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventConfigurationByResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventConfigurationByResourceTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventConfigurationByResourceTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventConfigurationByResourceTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventConfigurationByResourceTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventConfigurationByResourceTypesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventConfigurationByResourceTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventConfigurationByResourceTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEventConfigurationByResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventConfigurationByResourceTypesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateEventConfigurationByResourceTypesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFuotaTaskError {
    /// Kind of error that occurred.
    pub kind: UpdateFuotaTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFuotaTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFuotaTaskErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFuotaTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFuotaTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFuotaTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFuotaTaskError {
    fn code(&self) -> Option<&str> {
        UpdateFuotaTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFuotaTaskError {
    /// Creates a new `UpdateFuotaTaskError`.
    pub fn new(kind: UpdateFuotaTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFuotaTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFuotaTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFuotaTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFuotaTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFuotaTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateFuotaTaskErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFuotaTaskErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFuotaTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateFuotaTaskErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateFuotaTaskErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateFuotaTaskErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateFuotaTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFuotaTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFuotaTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLogLevelsByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLogLevelsByResourceTypesError {
    /// Kind of error that occurred.
    pub kind: UpdateLogLevelsByResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLogLevelsByResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLogLevelsByResourceTypesErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLogLevelsByResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLogLevelsByResourceTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLogLevelsByResourceTypesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLogLevelsByResourceTypesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLogLevelsByResourceTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLogLevelsByResourceTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLogLevelsByResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLogLevelsByResourceTypesError {
    fn code(&self) -> Option<&str> {
        UpdateLogLevelsByResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLogLevelsByResourceTypesError {
    /// Creates a new `UpdateLogLevelsByResourceTypesError`.
    pub fn new(
        kind: UpdateLogLevelsByResourceTypesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLogLevelsByResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLogLevelsByResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLogLevelsByResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLogLevelsByResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLogLevelsByResourceTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLogLevelsByResourceTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLogLevelsByResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLogLevelsByResourceTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLogLevelsByResourceTypesErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLogLevelsByResourceTypesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateLogLevelsByResourceTypesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateLogLevelsByResourceTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLogLevelsByResourceTypesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLogLevelsByResourceTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMulticastGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateMulticastGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMulticastGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMulticastGroupErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMulticastGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMulticastGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateMulticastGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMulticastGroupError {
    fn code(&self) -> Option<&str> {
        UpdateMulticastGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMulticastGroupError {
    /// Creates a new `UpdateMulticastGroupError`.
    pub fn new(kind: UpdateMulticastGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMulticastGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMulticastGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMulticastGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMulticastGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMulticastGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMulticastGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateMulticastGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMulticastGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateMulticastGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNetworkAnalyzerConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateNetworkAnalyzerConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNetworkAnalyzerConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNetworkAnalyzerConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNetworkAnalyzerConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNetworkAnalyzerConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateNetworkAnalyzerConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNetworkAnalyzerConfigurationError {
    /// Creates a new `UpdateNetworkAnalyzerConfigurationError`.
    pub fn new(
        kind: UpdateNetworkAnalyzerConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNetworkAnalyzerConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNetworkAnalyzerConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNetworkAnalyzerConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkAnalyzerConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkAnalyzerConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNetworkAnalyzerConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNetworkAnalyzerConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateNetworkAnalyzerConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNetworkAnalyzerConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateNetworkAnalyzerConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePartnerAccountError {
    /// Kind of error that occurred.
    pub kind: UpdatePartnerAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePartnerAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePartnerAccountErrorKind {
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePartnerAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePartnerAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePartnerAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePartnerAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePartnerAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePartnerAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePartnerAccountError {
    fn code(&self) -> Option<&str> {
        UpdatePartnerAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePartnerAccountError {
    /// Creates a new `UpdatePartnerAccountError`.
    pub fn new(kind: UpdatePartnerAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePartnerAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePartnerAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePartnerAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePartnerAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePartnerAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartnerAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartnerAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartnerAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePartnerAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePartnerAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePartnerAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePartnerAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePartnerAccountErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePartnerAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceEventConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceEventConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceEventConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceEventConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceEventConfigurationErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceEventConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceEventConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceEventConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateResourceEventConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceEventConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceEventConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResourceEventConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateResourceEventConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceEventConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateResourceEventConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceEventConfigurationError {
    /// Creates a new `UpdateResourceEventConfigurationError`.
    pub fn new(
        kind: UpdateResourceEventConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceEventConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceEventConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceEventConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceEventConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceEventConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceEventConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateResourceEventConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceEventConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateResourceEventConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateResourceEventConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateResourceEventConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateResourceEventConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResourceEventConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateResourceEventConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWirelessDeviceError {
    /// Kind of error that occurred.
    pub kind: UpdateWirelessDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWirelessDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWirelessDeviceErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWirelessDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWirelessDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWirelessDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWirelessDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWirelessDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWirelessDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWirelessDeviceError {
    fn code(&self) -> Option<&str> {
        UpdateWirelessDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWirelessDeviceError {
    /// Creates a new `UpdateWirelessDeviceError`.
    pub fn new(kind: UpdateWirelessDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWirelessDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWirelessDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWirelessDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWirelessDeviceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWirelessDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateWirelessDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWirelessDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWirelessDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWirelessDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWirelessDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWirelessDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWirelessDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWirelessGatewayError {
    /// Kind of error that occurred.
    pub kind: UpdateWirelessGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWirelessGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWirelessGatewayErrorKind {
    /// <p>User does not have permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error occurred while processing a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because it exceeded the allowed API request rate.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input did not meet the specified constraints.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWirelessGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWirelessGatewayErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWirelessGatewayErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWirelessGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWirelessGatewayErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWirelessGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWirelessGatewayError {
    fn code(&self) -> Option<&str> {
        UpdateWirelessGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWirelessGatewayError {
    /// Creates a new `UpdateWirelessGatewayError`.
    pub fn new(kind: UpdateWirelessGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWirelessGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWirelessGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWirelessGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWirelessGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWirelessGatewayErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessGatewayErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessGatewayErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessGatewayErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessGatewayErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWirelessGatewayErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWirelessGatewayErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateWirelessGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWirelessGatewayErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWirelessGatewayErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWirelessGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWirelessGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWirelessGatewayErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWirelessGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input did not meet the specified constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied because it exceeded the allowed API request rate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Id of the not found resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the font found resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>Id of the not found resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of the font found resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Id of the not found resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Id of the not found resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the font found resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the font found resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An unexpected error occurred while processing a request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>User does not have permission to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Adding, updating, or deleting the resource can cause an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Id of the resource in the conflicting operation.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource in the conflicting operation.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>Id of the resource in the conflicting operation.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of the resource in the conflicting operation.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Id of the resource in the conflicting operation.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Id of the resource in the conflicting operation.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource in the conflicting operation.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource in the conflicting operation.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request was denied because the resource can't have any more tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Name of the resource that exceeds maximum number of tags allowed.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    /// <p>Name of the resource that exceeds maximum number of tags allowed.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Name of the resource that exceeds maximum number of tags allowed.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>Name of the resource that exceeds maximum number of tags allowed.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}
