// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `iotwireless`.
///
/// This client allows ergonomic access to a `iotwireless`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateAwsAccountWithPartnerAccount` operation.
    ///
    /// See [`AssociateAwsAccountWithPartnerAccount`](crate::client::fluent_builders::AssociateAwsAccountWithPartnerAccount) for more information about the
    /// operation and its arguments.
    pub fn associate_aws_account_with_partner_account(
        &self,
    ) -> fluent_builders::AssociateAwsAccountWithPartnerAccount<C, M, R> {
        fluent_builders::AssociateAwsAccountWithPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateWirelessDeviceWithThing` operation.
    ///
    /// See [`AssociateWirelessDeviceWithThing`](crate::client::fluent_builders::AssociateWirelessDeviceWithThing) for more information about the
    /// operation and its arguments.
    pub fn associate_wireless_device_with_thing(
        &self,
    ) -> fluent_builders::AssociateWirelessDeviceWithThing<C, M, R> {
        fluent_builders::AssociateWirelessDeviceWithThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateWirelessGatewayWithCertificate` operation.
    ///
    /// See [`AssociateWirelessGatewayWithCertificate`](crate::client::fluent_builders::AssociateWirelessGatewayWithCertificate) for more information about the
    /// operation and its arguments.
    pub fn associate_wireless_gateway_with_certificate(
        &self,
    ) -> fluent_builders::AssociateWirelessGatewayWithCertificate<C, M, R> {
        fluent_builders::AssociateWirelessGatewayWithCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateWirelessGatewayWithThing` operation.
    ///
    /// See [`AssociateWirelessGatewayWithThing`](crate::client::fluent_builders::AssociateWirelessGatewayWithThing) for more information about the
    /// operation and its arguments.
    pub fn associate_wireless_gateway_with_thing(
        &self,
    ) -> fluent_builders::AssociateWirelessGatewayWithThing<C, M, R> {
        fluent_builders::AssociateWirelessGatewayWithThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDestination` operation.
    ///
    /// See [`CreateDestination`](crate::client::fluent_builders::CreateDestination) for more information about the
    /// operation and its arguments.
    pub fn create_destination(&self) -> fluent_builders::CreateDestination<C, M, R> {
        fluent_builders::CreateDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeviceProfile` operation.
    ///
    /// See [`CreateDeviceProfile`](crate::client::fluent_builders::CreateDeviceProfile) for more information about the
    /// operation and its arguments.
    pub fn create_device_profile(&self) -> fluent_builders::CreateDeviceProfile<C, M, R> {
        fluent_builders::CreateDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceProfile` operation.
    ///
    /// See [`CreateServiceProfile`](crate::client::fluent_builders::CreateServiceProfile) for more information about the
    /// operation and its arguments.
    pub fn create_service_profile(&self) -> fluent_builders::CreateServiceProfile<C, M, R> {
        fluent_builders::CreateServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWirelessDevice` operation.
    ///
    /// See [`CreateWirelessDevice`](crate::client::fluent_builders::CreateWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn create_wireless_device(&self) -> fluent_builders::CreateWirelessDevice<C, M, R> {
        fluent_builders::CreateWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWirelessGateway` operation.
    ///
    /// See [`CreateWirelessGateway`](crate::client::fluent_builders::CreateWirelessGateway) for more information about the
    /// operation and its arguments.
    pub fn create_wireless_gateway(&self) -> fluent_builders::CreateWirelessGateway<C, M, R> {
        fluent_builders::CreateWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWirelessGatewayTask` operation.
    ///
    /// See [`CreateWirelessGatewayTask`](crate::client::fluent_builders::CreateWirelessGatewayTask) for more information about the
    /// operation and its arguments.
    pub fn create_wireless_gateway_task(
        &self,
    ) -> fluent_builders::CreateWirelessGatewayTask<C, M, R> {
        fluent_builders::CreateWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWirelessGatewayTaskDefinition` operation.
    ///
    /// See [`CreateWirelessGatewayTaskDefinition`](crate::client::fluent_builders::CreateWirelessGatewayTaskDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::CreateWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::CreateWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDestination` operation.
    ///
    /// See [`DeleteDestination`](crate::client::fluent_builders::DeleteDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_destination(&self) -> fluent_builders::DeleteDestination<C, M, R> {
        fluent_builders::DeleteDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeviceProfile` operation.
    ///
    /// See [`DeleteDeviceProfile`](crate::client::fluent_builders::DeleteDeviceProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_device_profile(&self) -> fluent_builders::DeleteDeviceProfile<C, M, R> {
        fluent_builders::DeleteDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceProfile` operation.
    ///
    /// See [`DeleteServiceProfile`](crate::client::fluent_builders::DeleteServiceProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_service_profile(&self) -> fluent_builders::DeleteServiceProfile<C, M, R> {
        fluent_builders::DeleteServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWirelessDevice` operation.
    ///
    /// See [`DeleteWirelessDevice`](crate::client::fluent_builders::DeleteWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn delete_wireless_device(&self) -> fluent_builders::DeleteWirelessDevice<C, M, R> {
        fluent_builders::DeleteWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWirelessGateway` operation.
    ///
    /// See [`DeleteWirelessGateway`](crate::client::fluent_builders::DeleteWirelessGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_wireless_gateway(&self) -> fluent_builders::DeleteWirelessGateway<C, M, R> {
        fluent_builders::DeleteWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWirelessGatewayTask` operation.
    ///
    /// See [`DeleteWirelessGatewayTask`](crate::client::fluent_builders::DeleteWirelessGatewayTask) for more information about the
    /// operation and its arguments.
    pub fn delete_wireless_gateway_task(
        &self,
    ) -> fluent_builders::DeleteWirelessGatewayTask<C, M, R> {
        fluent_builders::DeleteWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWirelessGatewayTaskDefinition` operation.
    ///
    /// See [`DeleteWirelessGatewayTaskDefinition`](crate::client::fluent_builders::DeleteWirelessGatewayTaskDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::DeleteWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::DeleteWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateAwsAccountFromPartnerAccount` operation.
    ///
    /// See [`DisassociateAwsAccountFromPartnerAccount`](crate::client::fluent_builders::DisassociateAwsAccountFromPartnerAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_aws_account_from_partner_account(
        &self,
    ) -> fluent_builders::DisassociateAwsAccountFromPartnerAccount<C, M, R> {
        fluent_builders::DisassociateAwsAccountFromPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWirelessDeviceFromThing` operation.
    ///
    /// See [`DisassociateWirelessDeviceFromThing`](crate::client::fluent_builders::DisassociateWirelessDeviceFromThing) for more information about the
    /// operation and its arguments.
    pub fn disassociate_wireless_device_from_thing(
        &self,
    ) -> fluent_builders::DisassociateWirelessDeviceFromThing<C, M, R> {
        fluent_builders::DisassociateWirelessDeviceFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWirelessGatewayFromCertificate` operation.
    ///
    /// See [`DisassociateWirelessGatewayFromCertificate`](crate::client::fluent_builders::DisassociateWirelessGatewayFromCertificate) for more information about the
    /// operation and its arguments.
    pub fn disassociate_wireless_gateway_from_certificate(
        &self,
    ) -> fluent_builders::DisassociateWirelessGatewayFromCertificate<C, M, R> {
        fluent_builders::DisassociateWirelessGatewayFromCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWirelessGatewayFromThing` operation.
    ///
    /// See [`DisassociateWirelessGatewayFromThing`](crate::client::fluent_builders::DisassociateWirelessGatewayFromThing) for more information about the
    /// operation and its arguments.
    pub fn disassociate_wireless_gateway_from_thing(
        &self,
    ) -> fluent_builders::DisassociateWirelessGatewayFromThing<C, M, R> {
        fluent_builders::DisassociateWirelessGatewayFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDestination` operation.
    ///
    /// See [`GetDestination`](crate::client::fluent_builders::GetDestination) for more information about the
    /// operation and its arguments.
    pub fn get_destination(&self) -> fluent_builders::GetDestination<C, M, R> {
        fluent_builders::GetDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeviceProfile` operation.
    ///
    /// See [`GetDeviceProfile`](crate::client::fluent_builders::GetDeviceProfile) for more information about the
    /// operation and its arguments.
    pub fn get_device_profile(&self) -> fluent_builders::GetDeviceProfile<C, M, R> {
        fluent_builders::GetDeviceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLogLevelsByResourceTypes` operation.
    ///
    /// See [`GetLogLevelsByResourceTypes`](crate::client::fluent_builders::GetLogLevelsByResourceTypes) for more information about the
    /// operation and its arguments.
    pub fn get_log_levels_by_resource_types(
        &self,
    ) -> fluent_builders::GetLogLevelsByResourceTypes<C, M, R> {
        fluent_builders::GetLogLevelsByResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPartnerAccount` operation.
    ///
    /// See [`GetPartnerAccount`](crate::client::fluent_builders::GetPartnerAccount) for more information about the
    /// operation and its arguments.
    pub fn get_partner_account(&self) -> fluent_builders::GetPartnerAccount<C, M, R> {
        fluent_builders::GetPartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceLogLevel` operation.
    ///
    /// See [`GetResourceLogLevel`](crate::client::fluent_builders::GetResourceLogLevel) for more information about the
    /// operation and its arguments.
    pub fn get_resource_log_level(&self) -> fluent_builders::GetResourceLogLevel<C, M, R> {
        fluent_builders::GetResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceEndpoint` operation.
    ///
    /// See [`GetServiceEndpoint`](crate::client::fluent_builders::GetServiceEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_service_endpoint(&self) -> fluent_builders::GetServiceEndpoint<C, M, R> {
        fluent_builders::GetServiceEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceProfile` operation.
    ///
    /// See [`GetServiceProfile`](crate::client::fluent_builders::GetServiceProfile) for more information about the
    /// operation and its arguments.
    pub fn get_service_profile(&self) -> fluent_builders::GetServiceProfile<C, M, R> {
        fluent_builders::GetServiceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessDevice` operation.
    ///
    /// See [`GetWirelessDevice`](crate::client::fluent_builders::GetWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_device(&self) -> fluent_builders::GetWirelessDevice<C, M, R> {
        fluent_builders::GetWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessDeviceStatistics` operation.
    ///
    /// See [`GetWirelessDeviceStatistics`](crate::client::fluent_builders::GetWirelessDeviceStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_device_statistics(
        &self,
    ) -> fluent_builders::GetWirelessDeviceStatistics<C, M, R> {
        fluent_builders::GetWirelessDeviceStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGateway` operation.
    ///
    /// See [`GetWirelessGateway`](crate::client::fluent_builders::GetWirelessGateway) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway(&self) -> fluent_builders::GetWirelessGateway<C, M, R> {
        fluent_builders::GetWirelessGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGatewayCertificate` operation.
    ///
    /// See [`GetWirelessGatewayCertificate`](crate::client::fluent_builders::GetWirelessGatewayCertificate) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway_certificate(
        &self,
    ) -> fluent_builders::GetWirelessGatewayCertificate<C, M, R> {
        fluent_builders::GetWirelessGatewayCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGatewayFirmwareInformation` operation.
    ///
    /// See [`GetWirelessGatewayFirmwareInformation`](crate::client::fluent_builders::GetWirelessGatewayFirmwareInformation) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway_firmware_information(
        &self,
    ) -> fluent_builders::GetWirelessGatewayFirmwareInformation<C, M, R> {
        fluent_builders::GetWirelessGatewayFirmwareInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGatewayStatistics` operation.
    ///
    /// See [`GetWirelessGatewayStatistics`](crate::client::fluent_builders::GetWirelessGatewayStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway_statistics(
        &self,
    ) -> fluent_builders::GetWirelessGatewayStatistics<C, M, R> {
        fluent_builders::GetWirelessGatewayStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGatewayTask` operation.
    ///
    /// See [`GetWirelessGatewayTask`](crate::client::fluent_builders::GetWirelessGatewayTask) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway_task(&self) -> fluent_builders::GetWirelessGatewayTask<C, M, R> {
        fluent_builders::GetWirelessGatewayTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWirelessGatewayTaskDefinition` operation.
    ///
    /// See [`GetWirelessGatewayTaskDefinition`](crate::client::fluent_builders::GetWirelessGatewayTaskDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_wireless_gateway_task_definition(
        &self,
    ) -> fluent_builders::GetWirelessGatewayTaskDefinition<C, M, R> {
        fluent_builders::GetWirelessGatewayTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDestinations` operation.
    ///
    /// See [`ListDestinations`](crate::client::fluent_builders::ListDestinations) for more information about the
    /// operation and its arguments.
    pub fn list_destinations(&self) -> fluent_builders::ListDestinations<C, M, R> {
        fluent_builders::ListDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceProfiles` operation.
    ///
    /// See [`ListDeviceProfiles`](crate::client::fluent_builders::ListDeviceProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_device_profiles(&self) -> fluent_builders::ListDeviceProfiles<C, M, R> {
        fluent_builders::ListDeviceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPartnerAccounts` operation.
    ///
    /// See [`ListPartnerAccounts`](crate::client::fluent_builders::ListPartnerAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_partner_accounts(&self) -> fluent_builders::ListPartnerAccounts<C, M, R> {
        fluent_builders::ListPartnerAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceProfiles` operation.
    ///
    /// See [`ListServiceProfiles`](crate::client::fluent_builders::ListServiceProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_service_profiles(&self) -> fluent_builders::ListServiceProfiles<C, M, R> {
        fluent_builders::ListServiceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWirelessDevices` operation.
    ///
    /// See [`ListWirelessDevices`](crate::client::fluent_builders::ListWirelessDevices) for more information about the
    /// operation and its arguments.
    pub fn list_wireless_devices(&self) -> fluent_builders::ListWirelessDevices<C, M, R> {
        fluent_builders::ListWirelessDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWirelessGateways` operation.
    ///
    /// See [`ListWirelessGateways`](crate::client::fluent_builders::ListWirelessGateways) for more information about the
    /// operation and its arguments.
    pub fn list_wireless_gateways(&self) -> fluent_builders::ListWirelessGateways<C, M, R> {
        fluent_builders::ListWirelessGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWirelessGatewayTaskDefinitions` operation.
    ///
    /// See [`ListWirelessGatewayTaskDefinitions`](crate::client::fluent_builders::ListWirelessGatewayTaskDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_wireless_gateway_task_definitions(
        &self,
    ) -> fluent_builders::ListWirelessGatewayTaskDefinitions<C, M, R> {
        fluent_builders::ListWirelessGatewayTaskDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourceLogLevel` operation.
    ///
    /// See [`PutResourceLogLevel`](crate::client::fluent_builders::PutResourceLogLevel) for more information about the
    /// operation and its arguments.
    pub fn put_resource_log_level(&self) -> fluent_builders::PutResourceLogLevel<C, M, R> {
        fluent_builders::PutResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetAllResourceLogLevels` operation.
    ///
    /// See [`ResetAllResourceLogLevels`](crate::client::fluent_builders::ResetAllResourceLogLevels) for more information about the
    /// operation and its arguments.
    pub fn reset_all_resource_log_levels(
        &self,
    ) -> fluent_builders::ResetAllResourceLogLevels<C, M, R> {
        fluent_builders::ResetAllResourceLogLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetResourceLogLevel` operation.
    ///
    /// See [`ResetResourceLogLevel`](crate::client::fluent_builders::ResetResourceLogLevel) for more information about the
    /// operation and its arguments.
    pub fn reset_resource_log_level(&self) -> fluent_builders::ResetResourceLogLevel<C, M, R> {
        fluent_builders::ResetResourceLogLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendDataToWirelessDevice` operation.
    ///
    /// See [`SendDataToWirelessDevice`](crate::client::fluent_builders::SendDataToWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn send_data_to_wireless_device(
        &self,
    ) -> fluent_builders::SendDataToWirelessDevice<C, M, R> {
        fluent_builders::SendDataToWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestWirelessDevice` operation.
    ///
    /// See [`TestWirelessDevice`](crate::client::fluent_builders::TestWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn test_wireless_device(&self) -> fluent_builders::TestWirelessDevice<C, M, R> {
        fluent_builders::TestWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDestination` operation.
    ///
    /// See [`UpdateDestination`](crate::client::fluent_builders::UpdateDestination) for more information about the
    /// operation and its arguments.
    pub fn update_destination(&self) -> fluent_builders::UpdateDestination<C, M, R> {
        fluent_builders::UpdateDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLogLevelsByResourceTypes` operation.
    ///
    /// See [`UpdateLogLevelsByResourceTypes`](crate::client::fluent_builders::UpdateLogLevelsByResourceTypes) for more information about the
    /// operation and its arguments.
    pub fn update_log_levels_by_resource_types(
        &self,
    ) -> fluent_builders::UpdateLogLevelsByResourceTypes<C, M, R> {
        fluent_builders::UpdateLogLevelsByResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePartnerAccount` operation.
    ///
    /// See [`UpdatePartnerAccount`](crate::client::fluent_builders::UpdatePartnerAccount) for more information about the
    /// operation and its arguments.
    pub fn update_partner_account(&self) -> fluent_builders::UpdatePartnerAccount<C, M, R> {
        fluent_builders::UpdatePartnerAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWirelessDevice` operation.
    ///
    /// See [`UpdateWirelessDevice`](crate::client::fluent_builders::UpdateWirelessDevice) for more information about the
    /// operation and its arguments.
    pub fn update_wireless_device(&self) -> fluent_builders::UpdateWirelessDevice<C, M, R> {
        fluent_builders::UpdateWirelessDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWirelessGateway` operation.
    ///
    /// See [`UpdateWirelessGateway`](crate::client::fluent_builders::UpdateWirelessGateway) for more information about the
    /// operation and its arguments.
    pub fn update_wireless_gateway(&self) -> fluent_builders::UpdateWirelessGateway<C, M, R> {
        fluent_builders::UpdateWirelessGateway::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAwsAccountWithPartnerAccount`.
    ///
    /// <p>Associates a partner account with your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateAwsAccountWithPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_aws_account_with_partner_account_input::Builder,
    }
    impl<C, M, R> AssociateAwsAccountWithPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAwsAccountWithPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAwsAccountWithPartnerAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateAwsAccountWithPartnerAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAwsAccountWithPartnerAccountInputOperationOutputAlias,
                crate::output::AssociateAwsAccountWithPartnerAccountOutput,
                crate::error::AssociateAwsAccountWithPartnerAccountError,
                crate::input::AssociateAwsAccountWithPartnerAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, inp: crate::model::SidewalkAccountInfo) -> Self {
            self.inner = self.inner.sidewalk(inp);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkAccountInfo>,
        ) -> Self {
            self.inner = self.inner.set_sidewalk(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessDeviceWithThing`.
    ///
    /// <p>Associates a wireless device with a thing.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateWirelessDeviceWithThing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_device_with_thing_input::Builder,
    }
    impl<C, M, R> AssociateWirelessDeviceWithThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessDeviceWithThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessDeviceWithThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWirelessDeviceWithThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessDeviceWithThingInputOperationOutputAlias,
                crate::output::AssociateWirelessDeviceWithThingOutput,
                crate::error::AssociateWirelessDeviceWithThingError,
                crate::input::AssociateWirelessDeviceWithThingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn thing_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(inp);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless device.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessGatewayWithCertificate`.
    ///
    /// <p>Associates a wireless gateway with a certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateWirelessGatewayWithCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_gateway_with_certificate_input::Builder,
    }
    impl<C, M, R> AssociateWirelessGatewayWithCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessGatewayWithCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessGatewayWithCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateWirelessGatewayWithCertificateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessGatewayWithCertificateInputOperationOutputAlias,
                crate::output::AssociateWirelessGatewayWithCertificateOutput,
                crate::error::AssociateWirelessGatewayWithCertificateError,
                crate::input::AssociateWirelessGatewayWithCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn iot_certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iot_certificate_id(inp);
            self
        }
        /// <p>The ID of the certificate to associate with the wireless gateway.</p>
        pub fn set_iot_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_iot_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateWirelessGatewayWithThing`.
    ///
    /// <p>Associates a wireless gateway with a thing.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateWirelessGatewayWithThing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_wireless_gateway_with_thing_input::Builder,
    }
    impl<C, M, R> AssociateWirelessGatewayWithThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWirelessGatewayWithThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWirelessGatewayWithThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWirelessGatewayWithThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWirelessGatewayWithThingInputOperationOutputAlias,
                crate::output::AssociateWirelessGatewayWithThingOutput,
                crate::error::AssociateWirelessGatewayWithThingError,
                crate::input::AssociateWirelessGatewayWithThingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn thing_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(inp);
            self
        }
        /// <p>The ARN of the thing to associate with the wireless gateway.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDestination`.
    ///
    /// <p>Creates a new destination that maps a device message to an AWS IoT rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_destination_input::Builder,
    }
    impl<C, M, R> CreateDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDestinationInputOperationOutputAlias,
                crate::output::CreateDestinationOutput,
                crate::error::CreateDestinationError,
                crate::input::CreateDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, inp: crate::model::ExpressionType) -> Self {
            self.inner = self.inner.expression_type(inp);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.inner = self.inner.set_expression_type(input);
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>The rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new destination. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeviceProfile`.
    ///
    /// <p>Creates a new device profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_profile_input::Builder,
    }
    impl<C, M, R> CreateDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceProfileInputOperationOutputAlias,
                crate::output::CreateDeviceProfileOutput,
                crate::error::CreateDeviceProfileError,
                crate::input::CreateDeviceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn lo_ra_wan(mut self, inp: crate::model::LoRaWanDeviceProfile) -> Self {
            self.inner = self.inner.lo_ra_wan(inp);
            self
        }
        /// <p>The device profile information to use to create the device profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDeviceProfile>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new device profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceProfile`.
    ///
    /// <p>Creates a new service profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_profile_input::Builder,
    }
    impl<C, M, R> CreateServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceProfileInputOperationOutputAlias,
                crate::output::CreateServiceProfileOutput,
                crate::error::CreateServiceProfileError,
                crate::input::CreateServiceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn lo_ra_wan(mut self, inp: crate::model::LoRaWanServiceProfile) -> Self {
            self.inner = self.inner.lo_ra_wan(inp);
            self
        }
        /// <p>The service profile information to use to create the service profile.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanServiceProfile>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new service profile. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessDevice`.
    ///
    /// <p>Provisions a wireless device.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_device_input::Builder,
    }
    impl<C, M, R> CreateWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessDeviceInputOperationOutputAlias,
                crate::output::CreateWirelessDeviceOutput,
                crate::error::CreateWirelessDeviceError,
                crate::input::CreateWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The wireless device type.</p>
        pub fn r#type(mut self, inp: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The wireless device type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(inp);
            self
        }
        /// <p>The name of the destination to assign to the new wireless device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn lo_ra_wan(mut self, inp: crate::model::LoRaWanDevice) -> Self {
            self.inner = self.inner.lo_ra_wan(inp);
            self
        }
        /// <p>The device configuration information to use to create the wireless device.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanDevice>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGateway`.
    ///
    /// <p>Provisions a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_input::Builder,
    }
    impl<C, M, R> CreateWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayOutput,
                crate::error::CreateWirelessGatewayError,
                crate::input::CreateWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the new resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn lo_ra_wan(mut self, inp: crate::model::LoRaWanGateway) -> Self {
            self.inner = self.inner.lo_ra_wan(inp);
            self
        }
        /// <p>The gateway configuration information to use to create the wireless gateway.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanGateway>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGatewayTask`.
    ///
    /// <p>Creates a task for a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> CreateWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayTaskOutput,
                crate::error::CreateWirelessGatewayTaskError,
                crate::input::CreateWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn wireless_gateway_task_definition_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.wireless_gateway_task_definition_id(inp);
            self
        }
        /// <p>The ID of the WirelessGatewayTaskDefinition.</p>
        pub fn set_wireless_gateway_task_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_task_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWirelessGatewayTaskDefinition`.
    ///
    /// <p>Creates a gateway task definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> CreateWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateWirelessGatewayTaskDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::CreateWirelessGatewayTaskDefinitionOutput,
                crate::error::CreateWirelessGatewayTaskDefinitionError,
                crate::input::CreateWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn auto_create_tasks(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_create_tasks(inp);
            self
        }
        /// <p>Whether to automatically create tasks using this task definition for all gateways with the specified current version. If <code>false</code>, the task must me created by calling <code>CreateWirelessGatewayTask</code>.</p>
        pub fn set_auto_create_tasks(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create_tasks(input);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn update(mut self, inp: crate::model::UpdateWirelessGatewayTaskCreate) -> Self {
            self.inner = self.inner.update(inp);
            self
        }
        /// <p>Information about the gateways to update.</p>
        pub fn set_update(
            mut self,
            input: std::option::Option<crate::model::UpdateWirelessGatewayTaskCreate>,
        ) -> Self {
            self.inner = self.inner.set_update(input);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Each resource must have a unique client request token. If you try to create a new resource with the same token as a resource that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to attach to the specified resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDestination`.
    ///
    /// <p>Deletes a destination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_destination_input::Builder,
    }
    impl<C, M, R> DeleteDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDestinationInputOperationOutputAlias,
                crate::output::DeleteDestinationOutput,
                crate::error::DeleteDestinationError,
                crate::input::DeleteDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeviceProfile`.
    ///
    /// <p>Deletes a device profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_profile_input::Builder,
    }
    impl<C, M, R> DeleteDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceProfileInputOperationOutputAlias,
                crate::output::DeleteDeviceProfileOutput,
                crate::error::DeleteDeviceProfileError,
                crate::input::DeleteDeviceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceProfile`.
    ///
    /// <p>Deletes a service profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_profile_input::Builder,
    }
    impl<C, M, R> DeleteServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceProfileInputOperationOutputAlias,
                crate::output::DeleteServiceProfileOutput,
                crate::error::DeleteServiceProfileError,
                crate::input::DeleteServiceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessDevice`.
    ///
    /// <p>Deletes a wireless device.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_device_input::Builder,
    }
    impl<C, M, R> DeleteWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessDeviceInputOperationOutputAlias,
                crate::output::DeleteWirelessDeviceOutput,
                crate::error::DeleteWirelessDeviceError,
                crate::input::DeleteWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGateway`.
    ///
    /// <p>Deletes a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayOutput,
                crate::error::DeleteWirelessGatewayError,
                crate::input::DeleteWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGatewayTask`.
    ///
    /// <p>Deletes a wireless gateway task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayTaskOutput,
                crate::error::DeleteWirelessGatewayTaskError,
                crate::input::DeleteWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWirelessGatewayTaskDefinition`.
    ///
    /// <p>Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> DeleteWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteWirelessGatewayTaskDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::DeleteWirelessGatewayTaskDefinitionOutput,
                crate::error::DeleteWirelessGatewayTaskDefinitionError,
                crate::input::DeleteWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAwsAccountFromPartnerAccount`.
    ///
    /// <p>Disassociates your AWS account from a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, disassociates your AWS account from all partner accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateAwsAccountFromPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_aws_account_from_partner_account_input::Builder,
    }
    impl<C, M, R> DisassociateAwsAccountFromPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAwsAccountFromPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAwsAccountFromPartnerAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateAwsAccountFromPartnerAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAwsAccountFromPartnerAccountInputOperationOutputAlias,
                crate::output::DisassociateAwsAccountFromPartnerAccountOutput,
                crate::error::DisassociateAwsAccountFromPartnerAccountError,
                crate::input::DisassociateAwsAccountFromPartnerAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(inp);
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, inp: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(inp);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessDeviceFromThing`.
    ///
    /// <p>Disassociates a wireless device from its currently associated thing.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateWirelessDeviceFromThing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_device_from_thing_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessDeviceFromThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessDeviceFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessDeviceFromThingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessDeviceFromThingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessDeviceFromThingInputOperationOutputAlias,
                crate::output::DisassociateWirelessDeviceFromThingOutput,
                crate::error::DisassociateWirelessDeviceFromThingError,
                crate::input::DisassociateWirelessDeviceFromThingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessGatewayFromCertificate`.
    ///
    /// <p>Disassociates a wireless gateway from its currently associated certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateWirelessGatewayFromCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_gateway_from_certificate_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessGatewayFromCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessGatewayFromCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessGatewayFromCertificateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessGatewayFromCertificateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessGatewayFromCertificateInputOperationOutputAlias,
                crate::output::DisassociateWirelessGatewayFromCertificateOutput,
                crate::error::DisassociateWirelessGatewayFromCertificateError,
                crate::input::DisassociateWirelessGatewayFromCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWirelessGatewayFromThing`.
    ///
    /// <p>Disassociates a wireless gateway from its currently associated thing.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateWirelessGatewayFromThing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_wireless_gateway_from_thing_input::Builder,
    }
    impl<C, M, R> DisassociateWirelessGatewayFromThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWirelessGatewayFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWirelessGatewayFromThingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateWirelessGatewayFromThingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWirelessGatewayFromThingInputOperationOutputAlias,
                crate::output::DisassociateWirelessGatewayFromThingOutput,
                crate::error::DisassociateWirelessGatewayFromThingError,
                crate::input::DisassociateWirelessGatewayFromThingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDestination`.
    ///
    /// <p>Gets information about a destination.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_destination_input::Builder,
    }
    impl<C, M, R> GetDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDestinationInputOperationOutputAlias,
                crate::output::GetDestinationOutput,
                crate::error::GetDestinationError,
                crate::input::GetDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource to get.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeviceProfile`.
    ///
    /// <p>Gets information about a device profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeviceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_profile_input::Builder,
    }
    impl<C, M, R> GetDeviceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceProfileInputOperationOutputAlias,
                crate::output::GetDeviceProfileOutput,
                crate::error::GetDeviceProfileError,
                crate::input::GetDeviceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLogLevelsByResourceTypes`.
    ///
    /// <p>Returns current default log levels or log levels by resource types. Based on resource types, log levels can be
    /// for wireless device log options or wireless gateway log options.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLogLevelsByResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_log_levels_by_resource_types_input::Builder,
    }
    impl<C, M, R> GetLogLevelsByResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLogLevelsByResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLogLevelsByResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLogLevelsByResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLogLevelsByResourceTypesInputOperationOutputAlias,
                crate::output::GetLogLevelsByResourceTypesOutput,
                crate::error::GetLogLevelsByResourceTypesError,
                crate::input::GetLogLevelsByResourceTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPartnerAccount`.
    ///
    /// <p>Gets information about a partner account. If <code>PartnerAccountId</code> and <code>PartnerType</code> are <code>null</code>, returns all partner accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_partner_account_input::Builder,
    }
    impl<C, M, R> GetPartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPartnerAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPartnerAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPartnerAccountInputOperationOutputAlias,
                crate::output::GetPartnerAccountOutput,
                crate::error::GetPartnerAccountError,
                crate::input::GetPartnerAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn partner_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(inp);
            self
        }
        /// <p>The partner account ID to disassociate from the AWS account.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, inp: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(inp);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceLogLevel`.
    ///
    /// <p>Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for
    /// a wireless device or a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_log_level_input::Builder,
    }
    impl<C, M, R> GetResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceLogLevelInputOperationOutputAlias,
                crate::output::GetResourceLogLevelOutput,
                crate::error::GetResourceLogLevelError,
                crate::input::GetResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceEndpoint`.
    ///
    /// <p>Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_endpoint_input::Builder,
    }
    impl<C, M, R> GetServiceEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceEndpointInputOperationOutputAlias,
                crate::output::GetServiceEndpointOutput,
                crate::error::GetServiceEndpointError,
                crate::input::GetServiceEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn service_type(mut self, inp: crate::model::WirelessGatewayServiceType) -> Self {
            self.inner = self.inner.service_type(inp);
            self
        }
        /// <p>The service type for which to get endpoint information about. Can be <code>CUPS</code> for the Configuration and Update Server endpoint, or <code>LNS</code> for the LoRaWAN Network Server endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceProfile`.
    ///
    /// <p>Gets information about a service profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_profile_input::Builder,
    }
    impl<C, M, R> GetServiceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceProfileInputOperationOutputAlias,
                crate::output::GetServiceProfileOutput,
                crate::error::GetServiceProfileError,
                crate::input::GetServiceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessDevice`.
    ///
    /// <p>Gets information about a wireless device.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_device_input::Builder,
    }
    impl<C, M, R> GetWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessDeviceInputOperationOutputAlias,
                crate::output::GetWirelessDeviceOutput,
                crate::error::GetWirelessDeviceError,
                crate::input::GetWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the wireless device to get.</p>
        pub fn identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(inp);
            self
        }
        /// <p>The identifier of the wireless device to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, inp: crate::model::WirelessDeviceIdType) -> Self {
            self.inner = self.inner.identifier_type(inp);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceIdType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessDeviceStatistics`.
    ///
    /// <p>Gets operating information about a wireless device.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessDeviceStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_device_statistics_input::Builder,
    }
    impl<C, M, R> GetWirelessDeviceStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessDeviceStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessDeviceStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessDeviceStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessDeviceStatisticsInputOperationOutputAlias,
                crate::output::GetWirelessDeviceStatisticsOutput,
                crate::error::GetWirelessDeviceStatisticsError,
                crate::input::GetWirelessDeviceStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn wireless_device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_device_id(inp);
            self
        }
        /// <p>The ID of the wireless device for which to get the data.</p>
        pub fn set_wireless_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGateway`.
    ///
    /// <p>Gets information about a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_input::Builder,
    }
    impl<C, M, R> GetWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayInputOperationOutputAlias,
                crate::output::GetWirelessGatewayOutput,
                crate::error::GetWirelessGatewayError,
                crate::input::GetWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identifier(inp);
            self
        }
        /// <p>The identifier of the wireless gateway to get.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identifier(input);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn identifier_type(mut self, inp: crate::model::WirelessGatewayIdType) -> Self {
            self.inner = self.inner.identifier_type(inp);
            self
        }
        /// <p>The type of identifier used in <code>identifier</code>.</p>
        pub fn set_identifier_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayIdType>,
        ) -> Self {
            self.inner = self.inner.set_identifier_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayCertificate`.
    ///
    /// <p>Gets the ID of the certificate that is currently associated with a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGatewayCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_certificate_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayCertificateInputOperationOutputAlias,
                crate::output::GetWirelessGatewayCertificateOutput,
                crate::error::GetWirelessGatewayCertificateError,
                crate::input::GetWirelessGatewayCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayFirmwareInformation`.
    ///
    /// <p>Gets the firmware version and other information about a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGatewayFirmwareInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_firmware_information_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayFirmwareInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayFirmwareInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayFirmwareInformationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetWirelessGatewayFirmwareInformationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayFirmwareInformationInputOperationOutputAlias,
                crate::output::GetWirelessGatewayFirmwareInformationOutput,
                crate::error::GetWirelessGatewayFirmwareInformationError,
                crate::input::GetWirelessGatewayFirmwareInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayStatistics`.
    ///
    /// <p>Gets operating information about a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGatewayStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_statistics_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayStatisticsInputOperationOutputAlias,
                crate::output::GetWirelessGatewayStatisticsOutput,
                crate::error::GetWirelessGatewayStatisticsError,
                crate::input::GetWirelessGatewayStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn wireless_gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.wireless_gateway_id(inp);
            self
        }
        /// <p>The ID of the wireless gateway for which to get the data.</p>
        pub fn set_wireless_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayTask`.
    ///
    /// <p>Gets information about a wireless gateway task.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGatewayTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_task_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayTaskInputOperationOutputAlias,
                crate::output::GetWirelessGatewayTaskOutput,
                crate::error::GetWirelessGatewayTaskError,
                crate::input::GetWirelessGatewayTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWirelessGatewayTaskDefinition`.
    ///
    /// <p>Gets information about a wireless gateway task definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWirelessGatewayTaskDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_wireless_gateway_task_definition_input::Builder,
    }
    impl<C, M, R> GetWirelessGatewayTaskDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWirelessGatewayTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWirelessGatewayTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWirelessGatewayTaskDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWirelessGatewayTaskDefinitionInputOperationOutputAlias,
                crate::output::GetWirelessGatewayTaskDefinitionOutput,
                crate::error::GetWirelessGatewayTaskDefinitionError,
                crate::input::GetWirelessGatewayTaskDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to get.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to get.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDestinations`.
    ///
    /// <p>Lists the destinations registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_destinations_input::Builder,
    }
    impl<C, M, R> ListDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDestinationsInputOperationOutputAlias,
                crate::output::ListDestinationsOutput,
                crate::error::ListDestinationsError,
                crate::input::ListDestinationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceProfiles`.
    ///
    /// <p>Lists the device profiles registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeviceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_profiles_input::Builder,
    }
    impl<C, M, R> ListDeviceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceProfilesInputOperationOutputAlias,
                crate::output::ListDeviceProfilesOutput,
                crate::error::ListDeviceProfilesError,
                crate::input::ListDeviceProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerAccounts`.
    ///
    /// <p>Lists the partner accounts associated with your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPartnerAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_partner_accounts_input::Builder,
    }
    impl<C, M, R> ListPartnerAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPartnerAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPartnerAccountsInputOperationOutputAlias,
                crate::output::ListPartnerAccountsOutput,
                crate::error::ListPartnerAccountsError,
                crate::input::ListPartnerAccountsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceProfiles`.
    ///
    /// <p>Lists the service profiles registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_profiles_input::Builder,
    }
    impl<C, M, R> ListServiceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceProfilesInputOperationOutputAlias,
                crate::output::ListServiceProfilesOutput,
                crate::error::ListServiceProfilesError,
                crate::input::ListServiceProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) you have assigned to the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource for which you want to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessDevices`.
    ///
    /// <p>Lists the wireless devices registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWirelessDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_devices_input::Builder,
    }
    impl<C, M, R> ListWirelessDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWirelessDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessDevicesInputOperationOutputAlias,
                crate::output::ListWirelessDevicesOutput,
                crate::error::ListWirelessDevicesError,
                crate::input::ListWirelessDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(inp);
            self
        }
        /// <p>A filter to list only the wireless devices that use this destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn device_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_profile_id(inp);
            self
        }
        /// <p>A filter to list only the wireless devices that use this device profile.</p>
        pub fn set_device_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_profile_id(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn service_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_profile_id(inp);
            self
        }
        /// <p>A filter to list only the wireless devices that use this service profile.</p>
        pub fn set_service_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_profile_id(input);
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn wireless_device_type(mut self, inp: crate::model::WirelessDeviceType) -> Self {
            self.inner = self.inner.wireless_device_type(inp);
            self
        }
        /// <p>A filter to list only the wireless devices that use this wireless device type.</p>
        pub fn set_wireless_device_type(
            mut self,
            input: std::option::Option<crate::model::WirelessDeviceType>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessGateways`.
    ///
    /// <p>Lists the wireless gateways registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWirelessGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_gateways_input::Builder,
    }
    impl<C, M, R> ListWirelessGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWirelessGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessGatewaysInputOperationOutputAlias,
                crate::output::ListWirelessGatewaysOutput,
                crate::error::ListWirelessGatewaysError,
                crate::input::ListWirelessGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWirelessGatewayTaskDefinitions`.
    ///
    /// <p>List the wireless gateway tasks definitions registered to your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWirelessGatewayTaskDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_wireless_gateway_task_definitions_input::Builder,
    }
    impl<C, M, R> ListWirelessGatewayTaskDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWirelessGatewayTaskDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWirelessGatewayTaskDefinitionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListWirelessGatewayTaskDefinitionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWirelessGatewayTaskDefinitionsInputOperationOutputAlias,
                crate::output::ListWirelessGatewayTaskDefinitionsOutput,
                crate::error::ListWirelessGatewayTaskDefinitionsError,
                crate::input::ListWirelessGatewayTaskDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn task_definition_type(
            mut self,
            inp: crate::model::WirelessGatewayTaskDefinitionType,
        ) -> Self {
            self.inner = self.inner.task_definition_type(inp);
            self
        }
        /// <p>A filter to list only the wireless gateway task definitions that use this task definition type.</p>
        pub fn set_task_definition_type(
            mut self,
            input: std::option::Option<crate::model::WirelessGatewayTaskDefinitionType>,
        ) -> Self {
            self.inner = self.inner.set_task_definition_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourceLogLevel`.
    ///
    /// <p>Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway
    /// or a wireless device. A limit of 200 log level override can be set per account.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_log_level_input::Builder,
    }
    impl<C, M, R> PutResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourceLogLevelInputOperationOutputAlias,
                crate::output::PutResourceLogLevelOutput,
                crate::error::PutResourceLogLevelError,
                crate::input::PutResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn log_level(mut self, inp: crate::model::LogLevel) -> Self {
            self.inner = self.inner.log_level(inp);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.inner = self.inner.set_log_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetAllResourceLogLevels`.
    ///
    /// <p>Removes the log-level overrides for all resources; both wireless devices and wireless gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetAllResourceLogLevels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_all_resource_log_levels_input::Builder,
    }
    impl<C, M, R> ResetAllResourceLogLevels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetAllResourceLogLevels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetAllResourceLogLevelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetAllResourceLogLevelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetAllResourceLogLevelsInputOperationOutputAlias,
                crate::output::ResetAllResourceLogLevelsOutput,
                crate::error::ResetAllResourceLogLevelsError,
                crate::input::ResetAllResourceLogLevelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ResetResourceLogLevel`.
    ///
    /// <p>Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for
    /// a wireless device or a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetResourceLogLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_resource_log_level_input::Builder,
    }
    impl<C, M, R> ResetResourceLogLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetResourceLogLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetResourceLogLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetResourceLogLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetResourceLogLevelInputOperationOutputAlias,
                crate::output::ResetResourceLogLevelOutput,
                crate::error::ResetResourceLogLevelError,
                crate::input::ResetResourceLogLevelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The identifier of the resource. For a Wireless Device, it is the wireless device ID. For a wireless gateway,
        /// it is the wireless gateway ID.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the resource, which can be <code>WirelessDevice</code> or <code>WirelessGateway</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendDataToWirelessDevice`.
    ///
    /// <p>Sends a decrypted application data frame to a device.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendDataToWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_data_to_wireless_device_input::Builder,
    }
    impl<C, M, R> SendDataToWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendDataToWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendDataToWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::SendDataToWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendDataToWirelessDeviceInputOperationOutputAlias,
                crate::output::SendDataToWirelessDeviceOutput,
                crate::error::SendDataToWirelessDeviceError,
                crate::input::SendDataToWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the wireless device to receive the data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn transmit_mode(mut self, inp: i32) -> Self {
            self.inner = self.inner.transmit_mode(inp);
            self
        }
        /// <p>The transmit mode to use to send data to the wireless device. Can be: <code>0</code> for UM (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).</p>
        pub fn set_transmit_mode(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_transmit_mode(input);
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn payload_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.payload_data(inp);
            self
        }
        /// <p>The binary to be sent to the end device, encoded in base64.</p>
        pub fn set_payload_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_payload_data(input);
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn wireless_metadata(mut self, inp: crate::model::WirelessMetadata) -> Self {
            self.inner = self.inner.wireless_metadata(inp);
            self
        }
        /// <p>Metadata about the message request.</p>
        pub fn set_wireless_metadata(
            mut self,
            input: std::option::Option<crate::model::WirelessMetadata>,
        ) -> Self {
            self.inner = self.inner.set_wireless_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestWirelessDevice`.
    ///
    /// <p>Simulates a provisioned device by sending an uplink data payload of <code>Hello</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_wireless_device_input::Builder,
    }
    impl<C, M, R> TestWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::TestWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestWirelessDeviceInputOperationOutputAlias,
                crate::output::TestWirelessDeviceOutput,
                crate::error::TestWirelessDeviceError,
                crate::input::TestWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the wireless device to test.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the wireless device to test.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of the keys of the tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDestination`.
    ///
    /// <p>Updates properties of a destination.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_destination_input::Builder,
    }
    impl<C, M, R> UpdateDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDestinationInputOperationOutputAlias,
                crate::output::UpdateDestinationOutput,
                crate::error::UpdateDestinationError,
                crate::input::UpdateDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn expression_type(mut self, inp: crate::model::ExpressionType) -> Self {
            self.inner = self.inner.expression_type(inp);
            self
        }
        /// <p>The type of value in <code>Expression</code>.</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.inner = self.inner.set_expression_type(input);
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>The new rule name or topic rule to send messages to.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM Role that authorizes the destination.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLogLevelsByResourceTypes`.
    ///
    /// <p>Set default log level, or log levels by resource types. This can be for wireless device log options or
    /// wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLogLevelsByResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_log_levels_by_resource_types_input::Builder,
    }
    impl<C, M, R> UpdateLogLevelsByResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLogLevelsByResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLogLevelsByResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLogLevelsByResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLogLevelsByResourceTypesInputOperationOutputAlias,
                crate::output::UpdateLogLevelsByResourceTypesOutput,
                crate::error::UpdateLogLevelsByResourceTypesError,
                crate::input::UpdateLogLevelsByResourceTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The log level for a log message.</p>
        pub fn default_log_level(mut self, inp: crate::model::LogLevel) -> Self {
            self.inner = self.inner.default_log_level(inp);
            self
        }
        /// <p>The log level for a log message.</p>
        pub fn set_default_log_level(
            mut self,
            input: std::option::Option<crate::model::LogLevel>,
        ) -> Self {
            self.inner = self.inner.set_default_log_level(input);
            self
        }
        /// Appends an item to `WirelessDeviceLogOptions`.
        ///
        /// To override the contents of this collection use [`set_wireless_device_log_options`](Self::set_wireless_device_log_options).
        ///
        /// <p>The list of wireless device log options.</p>
        pub fn wireless_device_log_options(
            mut self,
            inp: impl Into<crate::model::WirelessDeviceLogOption>,
        ) -> Self {
            self.inner = self.inner.wireless_device_log_options(inp);
            self
        }
        /// <p>The list of wireless device log options.</p>
        pub fn set_wireless_device_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessDeviceLogOption>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_device_log_options(input);
            self
        }
        /// Appends an item to `WirelessGatewayLogOptions`.
        ///
        /// To override the contents of this collection use [`set_wireless_gateway_log_options`](Self::set_wireless_gateway_log_options).
        ///
        /// <p>The list of wireless gateway log options.</p>
        pub fn wireless_gateway_log_options(
            mut self,
            inp: impl Into<crate::model::WirelessGatewayLogOption>,
        ) -> Self {
            self.inner = self.inner.wireless_gateway_log_options(inp);
            self
        }
        /// <p>The list of wireless gateway log options.</p>
        pub fn set_wireless_gateway_log_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WirelessGatewayLogOption>>,
        ) -> Self {
            self.inner = self.inner.set_wireless_gateway_log_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePartnerAccount`.
    ///
    /// <p>Updates properties of a partner account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePartnerAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_partner_account_input::Builder,
    }
    impl<C, M, R> UpdatePartnerAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePartnerAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePartnerAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePartnerAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePartnerAccountInputOperationOutputAlias,
                crate::output::UpdatePartnerAccountOutput,
                crate::error::UpdatePartnerAccountError,
                crate::input::UpdatePartnerAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn sidewalk(mut self, inp: crate::model::SidewalkUpdateAccount) -> Self {
            self.inner = self.inner.sidewalk(inp);
            self
        }
        /// <p>The Sidewalk account credentials.</p>
        pub fn set_sidewalk(
            mut self,
            input: std::option::Option<crate::model::SidewalkUpdateAccount>,
        ) -> Self {
            self.inner = self.inner.set_sidewalk(input);
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn partner_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_account_id(inp);
            self
        }
        /// <p>The ID of the partner account to update.</p>
        pub fn set_partner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_partner_account_id(input);
            self
        }
        /// <p>The partner type.</p>
        pub fn partner_type(mut self, inp: crate::model::PartnerType) -> Self {
            self.inner = self.inner.partner_type(inp);
            self
        }
        /// <p>The partner type.</p>
        pub fn set_partner_type(
            mut self,
            input: std::option::Option<crate::model::PartnerType>,
        ) -> Self {
            self.inner = self.inner.set_partner_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWirelessDevice`.
    ///
    /// <p>Updates properties of a wireless device.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWirelessDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_wireless_device_input::Builder,
    }
    impl<C, M, R> UpdateWirelessDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWirelessDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWirelessDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWirelessDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWirelessDeviceInputOperationOutputAlias,
                crate::output::UpdateWirelessDeviceOutput,
                crate::error::UpdateWirelessDeviceError,
                crate::input::UpdateWirelessDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(inp);
            self
        }
        /// <p>The name of the new destination for the device.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn lo_ra_wan(mut self, inp: crate::model::LoRaWanUpdateDevice) -> Self {
            self.inner = self.inner.lo_ra_wan(inp);
            self
        }
        /// <p>The updated wireless device's configuration.</p>
        pub fn set_lo_ra_wan(
            mut self,
            input: std::option::Option<crate::model::LoRaWanUpdateDevice>,
        ) -> Self {
            self.inner = self.inner.set_lo_ra_wan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWirelessGateway`.
    ///
    /// <p>Updates properties of a wireless gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWirelessGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_wireless_gateway_input::Builder,
    }
    impl<C, M, R> UpdateWirelessGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWirelessGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWirelessGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWirelessGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWirelessGatewayInputOperationOutputAlias,
                crate::output::UpdateWirelessGatewayOutput,
                crate::error::UpdateWirelessGatewayError,
                crate::input::UpdateWirelessGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the resource to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the resource to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name of the resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new description of the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `JoinEuiFilters`.
        ///
        /// To override the contents of this collection use [`set_join_eui_filters`](Self::set_join_eui_filters).
        ///
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn join_eui_filters(
            mut self,
            inp: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.join_eui_filters(inp);
            self
        }
        /// <p>A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.</p>
        pub fn set_join_eui_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_join_eui_filters(input);
            self
        }
        /// Appends an item to `NetIdFilters`.
        ///
        /// To override the contents of this collection use [`set_net_id_filters`](Self::set_net_id_filters).
        ///
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn net_id_filters(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.net_id_filters(inp);
            self
        }
        /// <p>A list of NetId values that are used by LoRa gateways to filter the uplink frames.</p>
        pub fn set_net_id_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_net_id_filters(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
