// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchPutPropertyValues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_property_values`](crate::client::Client::batch_put_property_values).
///
/// See [`crate::client::fluent_builders::BatchPutPropertyValues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutPropertyValues {
    _private: (),
}
impl BatchPutPropertyValues {
    /// Creates a new builder-style object to manufacture [`BatchPutPropertyValuesInput`](crate::input::BatchPutPropertyValuesInput)
    pub fn builder() -> crate::input::batch_put_property_values_input::Builder {
        crate::input::batch_put_property_values_input::Builder::default()
    }
    /// Creates a new `BatchPutPropertyValues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutPropertyValues {
    type Output = std::result::Result<
        crate::output::BatchPutPropertyValuesOutput,
        crate::error::BatchPutPropertyValuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_property_values_error(response)
        } else {
            crate::operation_deser::parse_batch_put_property_values_response(response)
        }
    }
}

/// Operation shape for `CreateComponentType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_component_type`](crate::client::Client::create_component_type).
///
/// See [`crate::client::fluent_builders::CreateComponentType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateComponentType {
    _private: (),
}
impl CreateComponentType {
    /// Creates a new builder-style object to manufacture [`CreateComponentTypeInput`](crate::input::CreateComponentTypeInput)
    pub fn builder() -> crate::input::create_component_type_input::Builder {
        crate::input::create_component_type_input::Builder::default()
    }
    /// Creates a new `CreateComponentType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateComponentType {
    type Output = std::result::Result<
        crate::output::CreateComponentTypeOutput,
        crate::error::CreateComponentTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_component_type_error(response)
        } else {
            crate::operation_deser::parse_create_component_type_response(response)
        }
    }
}

/// Operation shape for `CreateEntity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_entity`](crate::client::Client::create_entity).
///
/// See [`crate::client::fluent_builders::CreateEntity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEntity {
    _private: (),
}
impl CreateEntity {
    /// Creates a new builder-style object to manufacture [`CreateEntityInput`](crate::input::CreateEntityInput)
    pub fn builder() -> crate::input::create_entity_input::Builder {
        crate::input::create_entity_input::Builder::default()
    }
    /// Creates a new `CreateEntity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEntity {
    type Output =
        std::result::Result<crate::output::CreateEntityOutput, crate::error::CreateEntityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_entity_error(response)
        } else {
            crate::operation_deser::parse_create_entity_response(response)
        }
    }
}

/// Operation shape for `CreateScene`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_scene`](crate::client::Client::create_scene).
///
/// See [`crate::client::fluent_builders::CreateScene`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateScene {
    _private: (),
}
impl CreateScene {
    /// Creates a new builder-style object to manufacture [`CreateSceneInput`](crate::input::CreateSceneInput)
    pub fn builder() -> crate::input::create_scene_input::Builder {
        crate::input::create_scene_input::Builder::default()
    }
    /// Creates a new `CreateScene` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateScene {
    type Output =
        std::result::Result<crate::output::CreateSceneOutput, crate::error::CreateSceneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_scene_error(response)
        } else {
            crate::operation_deser::parse_create_scene_response(response)
        }
    }
}

/// Operation shape for `CreateWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workspace`](crate::client::Client::create_workspace).
///
/// See [`crate::client::fluent_builders::CreateWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkspace {
    _private: (),
}
impl CreateWorkspace {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    pub fn builder() -> crate::input::create_workspace_input::Builder {
        crate::input::create_workspace_input::Builder::default()
    }
    /// Creates a new `CreateWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkspace {
    type Output = std::result::Result<
        crate::output::CreateWorkspaceOutput,
        crate::error::CreateWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workspace_error(response)
        } else {
            crate::operation_deser::parse_create_workspace_response(response)
        }
    }
}

/// Operation shape for `DeleteComponentType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_component_type`](crate::client::Client::delete_component_type).
///
/// See [`crate::client::fluent_builders::DeleteComponentType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteComponentType {
    _private: (),
}
impl DeleteComponentType {
    /// Creates a new builder-style object to manufacture [`DeleteComponentTypeInput`](crate::input::DeleteComponentTypeInput)
    pub fn builder() -> crate::input::delete_component_type_input::Builder {
        crate::input::delete_component_type_input::Builder::default()
    }
    /// Creates a new `DeleteComponentType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteComponentType {
    type Output = std::result::Result<
        crate::output::DeleteComponentTypeOutput,
        crate::error::DeleteComponentTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_component_type_error(response)
        } else {
            crate::operation_deser::parse_delete_component_type_response(response)
        }
    }
}

/// Operation shape for `DeleteEntity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_entity`](crate::client::Client::delete_entity).
///
/// See [`crate::client::fluent_builders::DeleteEntity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEntity {
    _private: (),
}
impl DeleteEntity {
    /// Creates a new builder-style object to manufacture [`DeleteEntityInput`](crate::input::DeleteEntityInput)
    pub fn builder() -> crate::input::delete_entity_input::Builder {
        crate::input::delete_entity_input::Builder::default()
    }
    /// Creates a new `DeleteEntity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEntity {
    type Output =
        std::result::Result<crate::output::DeleteEntityOutput, crate::error::DeleteEntityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_entity_error(response)
        } else {
            crate::operation_deser::parse_delete_entity_response(response)
        }
    }
}

/// Operation shape for `DeleteScene`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_scene`](crate::client::Client::delete_scene).
///
/// See [`crate::client::fluent_builders::DeleteScene`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScene {
    _private: (),
}
impl DeleteScene {
    /// Creates a new builder-style object to manufacture [`DeleteSceneInput`](crate::input::DeleteSceneInput)
    pub fn builder() -> crate::input::delete_scene_input::Builder {
        crate::input::delete_scene_input::Builder::default()
    }
    /// Creates a new `DeleteScene` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScene {
    type Output =
        std::result::Result<crate::output::DeleteSceneOutput, crate::error::DeleteSceneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_scene_error(response)
        } else {
            crate::operation_deser::parse_delete_scene_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workspace`](crate::client::Client::delete_workspace).
///
/// See [`crate::client::fluent_builders::DeleteWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkspace {
    _private: (),
}
impl DeleteWorkspace {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    pub fn builder() -> crate::input::delete_workspace_input::Builder {
        crate::input::delete_workspace_input::Builder::default()
    }
    /// Creates a new `DeleteWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkspace {
    type Output = std::result::Result<
        crate::output::DeleteWorkspaceOutput,
        crate::error::DeleteWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workspace_error(response)
        } else {
            crate::operation_deser::parse_delete_workspace_response(response)
        }
    }
}

/// Operation shape for `GetComponentType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_component_type`](crate::client::Client::get_component_type).
///
/// See [`crate::client::fluent_builders::GetComponentType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComponentType {
    _private: (),
}
impl GetComponentType {
    /// Creates a new builder-style object to manufacture [`GetComponentTypeInput`](crate::input::GetComponentTypeInput)
    pub fn builder() -> crate::input::get_component_type_input::Builder {
        crate::input::get_component_type_input::Builder::default()
    }
    /// Creates a new `GetComponentType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComponentType {
    type Output = std::result::Result<
        crate::output::GetComponentTypeOutput,
        crate::error::GetComponentTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_component_type_error(response)
        } else {
            crate::operation_deser::parse_get_component_type_response(response)
        }
    }
}

/// Operation shape for `GetEntity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_entity`](crate::client::Client::get_entity).
///
/// See [`crate::client::fluent_builders::GetEntity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEntity {
    _private: (),
}
impl GetEntity {
    /// Creates a new builder-style object to manufacture [`GetEntityInput`](crate::input::GetEntityInput)
    pub fn builder() -> crate::input::get_entity_input::Builder {
        crate::input::get_entity_input::Builder::default()
    }
    /// Creates a new `GetEntity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEntity {
    type Output = std::result::Result<crate::output::GetEntityOutput, crate::error::GetEntityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_entity_error(response)
        } else {
            crate::operation_deser::parse_get_entity_response(response)
        }
    }
}

/// Operation shape for `GetPropertyValue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_property_value`](crate::client::Client::get_property_value).
///
/// See [`crate::client::fluent_builders::GetPropertyValue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPropertyValue {
    _private: (),
}
impl GetPropertyValue {
    /// Creates a new builder-style object to manufacture [`GetPropertyValueInput`](crate::input::GetPropertyValueInput)
    pub fn builder() -> crate::input::get_property_value_input::Builder {
        crate::input::get_property_value_input::Builder::default()
    }
    /// Creates a new `GetPropertyValue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPropertyValue {
    type Output = std::result::Result<
        crate::output::GetPropertyValueOutput,
        crate::error::GetPropertyValueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_property_value_error(response)
        } else {
            crate::operation_deser::parse_get_property_value_response(response)
        }
    }
}

/// Operation shape for `GetPropertyValueHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_property_value_history`](crate::client::Client::get_property_value_history).
///
/// See [`crate::client::fluent_builders::GetPropertyValueHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPropertyValueHistory {
    _private: (),
}
impl GetPropertyValueHistory {
    /// Creates a new builder-style object to manufacture [`GetPropertyValueHistoryInput`](crate::input::GetPropertyValueHistoryInput)
    pub fn builder() -> crate::input::get_property_value_history_input::Builder {
        crate::input::get_property_value_history_input::Builder::default()
    }
    /// Creates a new `GetPropertyValueHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPropertyValueHistory {
    type Output = std::result::Result<
        crate::output::GetPropertyValueHistoryOutput,
        crate::error::GetPropertyValueHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_property_value_history_error(response)
        } else {
            crate::operation_deser::parse_get_property_value_history_response(response)
        }
    }
}

/// Operation shape for `GetScene`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_scene`](crate::client::Client::get_scene).
///
/// See [`crate::client::fluent_builders::GetScene`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetScene {
    _private: (),
}
impl GetScene {
    /// Creates a new builder-style object to manufacture [`GetSceneInput`](crate::input::GetSceneInput)
    pub fn builder() -> crate::input::get_scene_input::Builder {
        crate::input::get_scene_input::Builder::default()
    }
    /// Creates a new `GetScene` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetScene {
    type Output = std::result::Result<crate::output::GetSceneOutput, crate::error::GetSceneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_scene_error(response)
        } else {
            crate::operation_deser::parse_get_scene_response(response)
        }
    }
}

/// Operation shape for `GetWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workspace`](crate::client::Client::get_workspace).
///
/// See [`crate::client::fluent_builders::GetWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkspace {
    _private: (),
}
impl GetWorkspace {
    /// Creates a new builder-style object to manufacture [`GetWorkspaceInput`](crate::input::GetWorkspaceInput)
    pub fn builder() -> crate::input::get_workspace_input::Builder {
        crate::input::get_workspace_input::Builder::default()
    }
    /// Creates a new `GetWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkspace {
    type Output =
        std::result::Result<crate::output::GetWorkspaceOutput, crate::error::GetWorkspaceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workspace_error(response)
        } else {
            crate::operation_deser::parse_get_workspace_response(response)
        }
    }
}

/// Operation shape for `ListComponentTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_component_types`](crate::client::Client::list_component_types).
///
/// See [`crate::client::fluent_builders::ListComponentTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComponentTypes {
    _private: (),
}
impl ListComponentTypes {
    /// Creates a new builder-style object to manufacture [`ListComponentTypesInput`](crate::input::ListComponentTypesInput)
    pub fn builder() -> crate::input::list_component_types_input::Builder {
        crate::input::list_component_types_input::Builder::default()
    }
    /// Creates a new `ListComponentTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComponentTypes {
    type Output = std::result::Result<
        crate::output::ListComponentTypesOutput,
        crate::error::ListComponentTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_component_types_error(response)
        } else {
            crate::operation_deser::parse_list_component_types_response(response)
        }
    }
}

/// Operation shape for `ListEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entities`](crate::client::Client::list_entities).
///
/// See [`crate::client::fluent_builders::ListEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntities {
    _private: (),
}
impl ListEntities {
    /// Creates a new builder-style object to manufacture [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    pub fn builder() -> crate::input::list_entities_input::Builder {
        crate::input::list_entities_input::Builder::default()
    }
    /// Creates a new `ListEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntities {
    type Output =
        std::result::Result<crate::output::ListEntitiesOutput, crate::error::ListEntitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entities_error(response)
        } else {
            crate::operation_deser::parse_list_entities_response(response)
        }
    }
}

/// Operation shape for `ListScenes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_scenes`](crate::client::Client::list_scenes).
///
/// See [`crate::client::fluent_builders::ListScenes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListScenes {
    _private: (),
}
impl ListScenes {
    /// Creates a new builder-style object to manufacture [`ListScenesInput`](crate::input::ListScenesInput)
    pub fn builder() -> crate::input::list_scenes_input::Builder {
        crate::input::list_scenes_input::Builder::default()
    }
    /// Creates a new `ListScenes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListScenes {
    type Output =
        std::result::Result<crate::output::ListScenesOutput, crate::error::ListScenesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_scenes_error(response)
        } else {
            crate::operation_deser::parse_list_scenes_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workspaces`](crate::client::Client::list_workspaces).
///
/// See [`crate::client::fluent_builders::ListWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkspaces {
    _private: (),
}
impl ListWorkspaces {
    /// Creates a new builder-style object to manufacture [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    pub fn builder() -> crate::input::list_workspaces_input::Builder {
        crate::input::list_workspaces_input::Builder::default()
    }
    /// Creates a new `ListWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkspaces {
    type Output =
        std::result::Result<crate::output::ListWorkspacesOutput, crate::error::ListWorkspacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workspaces_error(response)
        } else {
            crate::operation_deser::parse_list_workspaces_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateComponentType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_component_type`](crate::client::Client::update_component_type).
///
/// See [`crate::client::fluent_builders::UpdateComponentType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateComponentType {
    _private: (),
}
impl UpdateComponentType {
    /// Creates a new builder-style object to manufacture [`UpdateComponentTypeInput`](crate::input::UpdateComponentTypeInput)
    pub fn builder() -> crate::input::update_component_type_input::Builder {
        crate::input::update_component_type_input::Builder::default()
    }
    /// Creates a new `UpdateComponentType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateComponentType {
    type Output = std::result::Result<
        crate::output::UpdateComponentTypeOutput,
        crate::error::UpdateComponentTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_component_type_error(response)
        } else {
            crate::operation_deser::parse_update_component_type_response(response)
        }
    }
}

/// Operation shape for `UpdateEntity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_entity`](crate::client::Client::update_entity).
///
/// See [`crate::client::fluent_builders::UpdateEntity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEntity {
    _private: (),
}
impl UpdateEntity {
    /// Creates a new builder-style object to manufacture [`UpdateEntityInput`](crate::input::UpdateEntityInput)
    pub fn builder() -> crate::input::update_entity_input::Builder {
        crate::input::update_entity_input::Builder::default()
    }
    /// Creates a new `UpdateEntity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEntity {
    type Output =
        std::result::Result<crate::output::UpdateEntityOutput, crate::error::UpdateEntityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_entity_error(response)
        } else {
            crate::operation_deser::parse_update_entity_response(response)
        }
    }
}

/// Operation shape for `UpdateScene`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_scene`](crate::client::Client::update_scene).
///
/// See [`crate::client::fluent_builders::UpdateScene`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateScene {
    _private: (),
}
impl UpdateScene {
    /// Creates a new builder-style object to manufacture [`UpdateSceneInput`](crate::input::UpdateSceneInput)
    pub fn builder() -> crate::input::update_scene_input::Builder {
        crate::input::update_scene_input::Builder::default()
    }
    /// Creates a new `UpdateScene` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateScene {
    type Output =
        std::result::Result<crate::output::UpdateSceneOutput, crate::error::UpdateSceneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_scene_error(response)
        } else {
            crate::operation_deser::parse_update_scene_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workspace`](crate::client::Client::update_workspace).
///
/// See [`crate::client::fluent_builders::UpdateWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkspace {
    _private: (),
}
impl UpdateWorkspace {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    pub fn builder() -> crate::input::update_workspace_input::Builder {
        crate::input::update_workspace_input::Builder::default()
    }
    /// Creates a new `UpdateWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkspace {
    type Output = std::result::Result<
        crate::output::UpdateWorkspaceOutput,
        crate::error::UpdateWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workspace_error(response)
        } else {
            crate::operation_deser::parse_update_workspace_response(response)
        }
    }
}
