// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT TwinMaker
///
/// Client for invoking operations on AWS IoT TwinMaker. Each operation on AWS IoT TwinMaker is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iottwinmaker::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iottwinmaker::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iottwinmaker::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`BatchPutPropertyValues`](crate::client::fluent_builders::BatchPutPropertyValues) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::BatchPutPropertyValues::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::BatchPutPropertyValues::set_workspace_id): <p>The ID of the workspace that contains the properties to set.</p>
    ///   - [`entries(Vec<PropertyValueEntry>)`](crate::client::fluent_builders::BatchPutPropertyValues::entries) / [`set_entries(Option<Vec<PropertyValueEntry>>)`](crate::client::fluent_builders::BatchPutPropertyValues::set_entries): <p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>
    /// - On success, responds with [`BatchPutPropertyValuesOutput`](crate::output::BatchPutPropertyValuesOutput) with field(s):
    ///   - [`error_entries(Option<Vec<BatchPutPropertyErrorEntry>>)`](crate::output::BatchPutPropertyValuesOutput::error_entries): <p>Entries that caused errors in the batch put operation.</p>
    /// - On failure, responds with [`SdkError<BatchPutPropertyValuesError>`](crate::error::BatchPutPropertyValuesError)
    pub fn batch_put_property_values(&self) -> fluent_builders::BatchPutPropertyValues<C, M, R> {
        fluent_builders::BatchPutPropertyValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComponentType`](crate::client::fluent_builders::CreateComponentType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateComponentType::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateComponentType::set_workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`is_singleton(bool)`](crate::client::fluent_builders::CreateComponentType::is_singleton) / [`set_is_singleton(Option<bool>)`](crate::client::fluent_builders::CreateComponentType::set_is_singleton): <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::CreateComponentType::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::CreateComponentType::set_component_type_id): <p>The ID of the component type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateComponentType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateComponentType::set_description): <p>The description of the component type.</p>
    ///   - [`property_definitions(HashMap<String, PropertyDefinitionRequest>)`](crate::client::fluent_builders::CreateComponentType::property_definitions) / [`set_property_definitions(Option<HashMap<String, PropertyDefinitionRequest>>)`](crate::client::fluent_builders::CreateComponentType::set_property_definitions): <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`extends_from(Vec<String>)`](crate::client::fluent_builders::CreateComponentType::extends_from) / [`set_extends_from(Option<Vec<String>>)`](crate::client::fluent_builders::CreateComponentType::set_extends_from): <p>Specifies the parent component type to extend.</p>
    ///   - [`functions(HashMap<String, FunctionRequest>)`](crate::client::fluent_builders::CreateComponentType::functions) / [`set_functions(Option<HashMap<String, FunctionRequest>>)`](crate::client::fluent_builders::CreateComponentType::set_functions): <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateComponentType::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateComponentType::set_tags): <p>Metadata that you can use to manage the component type.</p>
    /// - On success, responds with [`CreateComponentTypeOutput`](crate::output::CreateComponentTypeOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateComponentTypeOutput::arn): <p>The ARN of the component type.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateComponentTypeOutput::creation_date_time): <p>The date and time when the entity was created.</p>
    ///   - [`state(Option<State>)`](crate::output::CreateComponentTypeOutput::state): <p>The current state of the component type.</p>
    /// - On failure, responds with [`SdkError<CreateComponentTypeError>`](crate::error::CreateComponentTypeError)
    pub fn create_component_type(&self) -> fluent_builders::CreateComponentType<C, M, R> {
        fluent_builders::CreateComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEntity`](crate::client::fluent_builders::CreateEntity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateEntity::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateEntity::set_workspace_id): <p>The ID of the workspace that contains the entity.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::CreateEntity::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::CreateEntity::set_entity_id): <p>The ID of the entity.</p>
    ///   - [`entity_name(impl Into<String>)`](crate::client::fluent_builders::CreateEntity::entity_name) / [`set_entity_name(Option<String>)`](crate::client::fluent_builders::CreateEntity::set_entity_name): <p>The name of the entity.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEntity::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEntity::set_description): <p>The description of the entity.</p>
    ///   - [`components(HashMap<String, ComponentRequest>)`](crate::client::fluent_builders::CreateEntity::components) / [`set_components(Option<HashMap<String, ComponentRequest>>)`](crate::client::fluent_builders::CreateEntity::set_components): <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
    ///   - [`parent_entity_id(impl Into<String>)`](crate::client::fluent_builders::CreateEntity::parent_entity_id) / [`set_parent_entity_id(Option<String>)`](crate::client::fluent_builders::CreateEntity::set_parent_entity_id): <p>The ID of the entity's parent entity.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateEntity::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateEntity::set_tags): <p>Metadata that you can use to manage the entity.</p>
    /// - On success, responds with [`CreateEntityOutput`](crate::output::CreateEntityOutput) with field(s):
    ///   - [`entity_id(Option<String>)`](crate::output::CreateEntityOutput::entity_id): <p>The ID of the entity.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateEntityOutput::arn): <p>The ARN of the entity.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateEntityOutput::creation_date_time): <p>The date and time when the entity was created.</p>
    ///   - [`state(Option<State>)`](crate::output::CreateEntityOutput::state): <p>The current state of the entity.</p>
    /// - On failure, responds with [`SdkError<CreateEntityError>`](crate::error::CreateEntityError)
    pub fn create_entity(&self) -> fluent_builders::CreateEntity<C, M, R> {
        fluent_builders::CreateEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateScene`](crate::client::fluent_builders::CreateScene) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateScene::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateScene::set_workspace_id): <p>The ID of the workspace that contains the scene.</p>
    ///   - [`scene_id(impl Into<String>)`](crate::client::fluent_builders::CreateScene::scene_id) / [`set_scene_id(Option<String>)`](crate::client::fluent_builders::CreateScene::set_scene_id): <p>The ID of the scene.</p>
    ///   - [`content_location(impl Into<String>)`](crate::client::fluent_builders::CreateScene::content_location) / [`set_content_location(Option<String>)`](crate::client::fluent_builders::CreateScene::set_content_location): <p>The relative path that specifies the location of the content definition file.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateScene::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateScene::set_description): <p>The description for this scene.</p>
    ///   - [`capabilities(Vec<String>)`](crate::client::fluent_builders::CreateScene::capabilities) / [`set_capabilities(Option<Vec<String>>)`](crate::client::fluent_builders::CreateScene::set_capabilities): <p>A list of capabilities that the scene uses to render itself.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateScene::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateScene::set_tags): <p>Metadata that you can use to manage the scene.</p>
    /// - On success, responds with [`CreateSceneOutput`](crate::output::CreateSceneOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateSceneOutput::arn): <p>The ARN of the scene.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateSceneOutput::creation_date_time): <p>The date and time when the scene was created.</p>
    /// - On failure, responds with [`SdkError<CreateSceneError>`](crate::error::CreateSceneError)
    pub fn create_scene(&self) -> fluent_builders::CreateScene<C, M, R> {
        fluent_builders::CreateScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkspace`](crate::client::fluent_builders::CreateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_description): <p>The description of the workspace.</p>
    ///   - [`s3_location(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::s3_location) / [`set_s3_location(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_s3_location): <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_role): <p>The ARN of the execution role associated with the workspace.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateWorkspace::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateWorkspace::set_tags): <p>Metadata that you can use to manage the workspace</p>
    /// - On success, responds with [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateWorkspaceOutput::arn): <p>The ARN of the workspace.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateWorkspaceOutput::creation_date_time): <p>The date and time when the workspace was created.</p>
    /// - On failure, responds with [`SdkError<CreateWorkspaceError>`](crate::error::CreateWorkspaceError)
    pub fn create_workspace(&self) -> fluent_builders::CreateWorkspace<C, M, R> {
        fluent_builders::CreateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComponentType`](crate::client::fluent_builders::DeleteComponentType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComponentType::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteComponentType::set_workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::DeleteComponentType::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::DeleteComponentType::set_component_type_id): <p>The ID of the component type to delete.</p>
    /// - On success, responds with [`DeleteComponentTypeOutput`](crate::output::DeleteComponentTypeOutput) with field(s):
    ///   - [`state(Option<State>)`](crate::output::DeleteComponentTypeOutput::state): <p>The current state of the component type to be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteComponentTypeError>`](crate::error::DeleteComponentTypeError)
    pub fn delete_component_type(&self) -> fluent_builders::DeleteComponentType<C, M, R> {
        fluent_builders::DeleteComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEntity`](crate::client::fluent_builders::DeleteEntity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEntity::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteEntity::set_workspace_id): <p>The ID of the workspace that contains the entity to delete.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEntity::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::DeleteEntity::set_entity_id): <p>The ID of the entity to delete.</p>
    ///   - [`is_recursive(bool)`](crate::client::fluent_builders::DeleteEntity::is_recursive) / [`set_is_recursive(Option<bool>)`](crate::client::fluent_builders::DeleteEntity::set_is_recursive): <p>A Boolean value that specifies whether the operation deletes child entities.</p>
    /// - On success, responds with [`DeleteEntityOutput`](crate::output::DeleteEntityOutput) with field(s):
    ///   - [`state(Option<State>)`](crate::output::DeleteEntityOutput::state): <p>The current state of the deleted entity.</p>
    /// - On failure, responds with [`SdkError<DeleteEntityError>`](crate::error::DeleteEntityError)
    pub fn delete_entity(&self) -> fluent_builders::DeleteEntity<C, M, R> {
        fluent_builders::DeleteEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteScene`](crate::client::fluent_builders::DeleteScene) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteScene::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteScene::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`scene_id(impl Into<String>)`](crate::client::fluent_builders::DeleteScene::scene_id) / [`set_scene_id(Option<String>)`](crate::client::fluent_builders::DeleteScene::set_scene_id): <p>The ID of the scene to delete.</p>
    /// - On success, responds with [`DeleteSceneOutput`](crate::output::DeleteSceneOutput)

    /// - On failure, responds with [`SdkError<DeleteSceneError>`](crate::error::DeleteSceneError)
    pub fn delete_scene(&self) -> fluent_builders::DeleteScene<C, M, R> {
        fluent_builders::DeleteScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkspace`](crate::client::fluent_builders::DeleteWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkspace::set_workspace_id): <p>The ID of the workspace to delete.</p>
    /// - On success, responds with [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkspaceError>`](crate::error::DeleteWorkspaceError)
    pub fn delete_workspace(&self) -> fluent_builders::DeleteWorkspace<C, M, R> {
        fluent_builders::DeleteWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponentType`](crate::client::fluent_builders::GetComponentType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetComponentType::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetComponentType::set_workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::GetComponentType::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::GetComponentType::set_component_type_id): <p>The ID of the component type.</p>
    /// - On success, responds with [`GetComponentTypeOutput`](crate::output::GetComponentTypeOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::GetComponentTypeOutput::workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`is_singleton(Option<bool>)`](crate::output::GetComponentTypeOutput::is_singleton): <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
    ///   - [`component_type_id(Option<String>)`](crate::output::GetComponentTypeOutput::component_type_id): <p>The ID of the component type.</p>
    ///   - [`description(Option<String>)`](crate::output::GetComponentTypeOutput::description): <p>The description of the component type.</p>
    ///   - [`property_definitions(Option<HashMap<String, PropertyDefinitionResponse>>)`](crate::output::GetComponentTypeOutput::property_definitions): <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`extends_from(Option<Vec<String>>)`](crate::output::GetComponentTypeOutput::extends_from): <p>The name of the parent component type that this component type extends.</p>
    ///   - [`functions(Option<HashMap<String, FunctionResponse>>)`](crate::output::GetComponentTypeOutput::functions): <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::GetComponentTypeOutput::creation_date_time): <p>The date and time when the component type was created.</p>
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::GetComponentTypeOutput::update_date_time): <p>The date and time when the component was last updated.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetComponentTypeOutput::arn): <p>The ARN of the component type.</p>
    ///   - [`is_abstract(Option<bool>)`](crate::output::GetComponentTypeOutput::is_abstract): <p>A Boolean value that specifies whether the component type is abstract.</p>
    ///   - [`is_schema_initialized(Option<bool>)`](crate::output::GetComponentTypeOutput::is_schema_initialized): <p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>
    ///   - [`status(Option<Status>)`](crate::output::GetComponentTypeOutput::status): <p>The current status of the component type.</p>
    /// - On failure, responds with [`SdkError<GetComponentTypeError>`](crate::error::GetComponentTypeError)
    pub fn get_component_type(&self) -> fluent_builders::GetComponentType<C, M, R> {
        fluent_builders::GetComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEntity`](crate::client::fluent_builders::GetEntity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetEntity::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetEntity::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::GetEntity::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::GetEntity::set_entity_id): <p>The ID of the entity.</p>
    /// - On success, responds with [`GetEntityOutput`](crate::output::GetEntityOutput) with field(s):
    ///   - [`entity_id(Option<String>)`](crate::output::GetEntityOutput::entity_id): <p>The ID of the entity.</p>
    ///   - [`entity_name(Option<String>)`](crate::output::GetEntityOutput::entity_name): <p>The name of the entity.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetEntityOutput::arn): <p>The ARN of the entity.</p>
    ///   - [`status(Option<Status>)`](crate::output::GetEntityOutput::status): <p>The current status of the entity.</p>
    ///   - [`workspace_id(Option<String>)`](crate::output::GetEntityOutput::workspace_id): <p>The ID of the workspace.</p>
    ///   - [`description(Option<String>)`](crate::output::GetEntityOutput::description): <p>The description of the entity.</p>
    ///   - [`components(Option<HashMap<String, ComponentResponse>>)`](crate::output::GetEntityOutput::components): <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
    ///   - [`parent_entity_id(Option<String>)`](crate::output::GetEntityOutput::parent_entity_id): <p>The ID of the parent entity for this entity.</p>
    ///   - [`has_child_entities(Option<bool>)`](crate::output::GetEntityOutput::has_child_entities): <p>A Boolean value that specifies whether the entity has associated child entities.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::GetEntityOutput::creation_date_time): <p>The date and time when the entity was created.</p>
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::GetEntityOutput::update_date_time): <p>The date and time when the entity was last updated.</p>
    /// - On failure, responds with [`SdkError<GetEntityError>`](crate::error::GetEntityError)
    pub fn get_entity(&self) -> fluent_builders::GetEntity<C, M, R> {
        fluent_builders::GetEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPropertyValue`](crate::client::fluent_builders::GetPropertyValue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValue::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::GetPropertyValue::set_component_name): <p>The name of the component whose property values the operation returns.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValue::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValue::set_component_type_id): <p>The ID of the component type whose property values the operation returns.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValue::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValue::set_entity_id): <p>The ID of the entity whose property values the operation returns.</p>
    ///   - [`selected_properties(Vec<String>)`](crate::client::fluent_builders::GetPropertyValue::selected_properties) / [`set_selected_properties(Option<Vec<String>>)`](crate::client::fluent_builders::GetPropertyValue::set_selected_properties): <p>The properties whose values the operation returns.</p>
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValue::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValue::set_workspace_id): <p>The ID of the workspace whose values the operation returns.</p>
    /// - On success, responds with [`GetPropertyValueOutput`](crate::output::GetPropertyValueOutput) with field(s):
    ///   - [`property_values(Option<HashMap<String, PropertyLatestValue>>)`](crate::output::GetPropertyValueOutput::property_values): <p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>
    /// - On failure, responds with [`SdkError<GetPropertyValueError>`](crate::error::GetPropertyValueError)
    pub fn get_property_value(&self) -> fluent_builders::GetPropertyValue<C, M, R> {
        fluent_builders::GetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPropertyValueHistory`](crate::client::fluent_builders::GetPropertyValueHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetPropertyValueHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_entity_id): <p>The ID of the entity.</p>
    ///   - [`component_name(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::component_name) / [`set_component_name(Option<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_component_name): <p>The name of the component.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_component_type_id): <p>The ID of the component type.</p>
    ///   - [`selected_properties(Vec<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::selected_properties) / [`set_selected_properties(Option<Vec<String>>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_selected_properties): <p>A list of properties whose value histories the request retrieves.</p>
    ///   - [`property_filters(Vec<PropertyFilter>)`](crate::client::fluent_builders::GetPropertyValueHistory::property_filters) / [`set_property_filters(Option<Vec<PropertyFilter>>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_property_filters): <p>A list of objects that filter the property value history request.</p>
    ///   - [`start_date_time(DateTime)`](crate::client::fluent_builders::GetPropertyValueHistory::start_date_time) / [`set_start_date_time(Option<DateTime>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_start_date_time): <p>The date and time of the earliest property value to return.</p>
    ///   - [`end_date_time(DateTime)`](crate::client::fluent_builders::GetPropertyValueHistory::end_date_time) / [`set_end_date_time(Option<DateTime>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_end_date_time): <p>The date and time of the latest property value to return.</p>
    ///   - [`interpolation(InterpolationParameters)`](crate::client::fluent_builders::GetPropertyValueHistory::interpolation) / [`set_interpolation(Option<InterpolationParameters>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_interpolation): <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_next_token): <p>The string that specifies the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetPropertyValueHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`order_by_time(OrderByTime)`](crate::client::fluent_builders::GetPropertyValueHistory::order_by_time) / [`set_order_by_time(Option<OrderByTime>)`](crate::client::fluent_builders::GetPropertyValueHistory::set_order_by_time): <p>The time direction to use in the result order.</p>
    /// - On success, responds with [`GetPropertyValueHistoryOutput`](crate::output::GetPropertyValueHistoryOutput) with field(s):
    ///   - [`property_values(Option<Vec<PropertyValueHistory>>)`](crate::output::GetPropertyValueHistoryOutput::property_values): <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetPropertyValueHistoryOutput::next_token): <p>The string that specifies the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetPropertyValueHistoryError>`](crate::error::GetPropertyValueHistoryError)
    pub fn get_property_value_history(&self) -> fluent_builders::GetPropertyValueHistory<C, M, R> {
        fluent_builders::GetPropertyValueHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetScene`](crate::client::fluent_builders::GetScene) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetScene::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetScene::set_workspace_id): <p>The ID of the workspace that contains the scene.</p>
    ///   - [`scene_id(impl Into<String>)`](crate::client::fluent_builders::GetScene::scene_id) / [`set_scene_id(Option<String>)`](crate::client::fluent_builders::GetScene::set_scene_id): <p>The ID of the scene.</p>
    /// - On success, responds with [`GetSceneOutput`](crate::output::GetSceneOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::GetSceneOutput::workspace_id): <p>The ID of the workspace that contains the scene.</p>
    ///   - [`scene_id(Option<String>)`](crate::output::GetSceneOutput::scene_id): <p>The ID of the scene.</p>
    ///   - [`content_location(Option<String>)`](crate::output::GetSceneOutput::content_location): <p>The relative path that specifies the location of the content definition file.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetSceneOutput::arn): <p>The ARN of the scene.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::GetSceneOutput::creation_date_time): <p>The date and time when the scene was created.</p>
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::GetSceneOutput::update_date_time): <p>The date and time when the scene was last updated.</p>
    ///   - [`description(Option<String>)`](crate::output::GetSceneOutput::description): <p>The description of the scene.</p>
    ///   - [`capabilities(Option<Vec<String>>)`](crate::output::GetSceneOutput::capabilities): <p>A list of capabilities that the scene uses to render.</p>
    /// - On failure, responds with [`SdkError<GetSceneError>`](crate::error::GetSceneError)
    pub fn get_scene(&self) -> fluent_builders::GetScene<C, M, R> {
        fluent_builders::GetScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkspace`](crate::client::fluent_builders::GetWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::GetWorkspace::set_workspace_id): <p>The ID of the workspace.</p>
    /// - On success, responds with [`GetWorkspaceOutput`](crate::output::GetWorkspaceOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::GetWorkspaceOutput::workspace_id): <p>The ID of the workspace.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetWorkspaceOutput::arn): <p>The ARN of the workspace.</p>
    ///   - [`description(Option<String>)`](crate::output::GetWorkspaceOutput::description): <p>The description of the workspace.</p>
    ///   - [`s3_location(Option<String>)`](crate::output::GetWorkspaceOutput::s3_location): <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    ///   - [`role(Option<String>)`](crate::output::GetWorkspaceOutput::role): <p>The ARN of the execution role associated with the workspace.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::GetWorkspaceOutput::creation_date_time): <p>The date and time when the workspace was created.</p>
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::GetWorkspaceOutput::update_date_time): <p>The date and time when the workspace was last updated.</p>
    /// - On failure, responds with [`SdkError<GetWorkspaceError>`](crate::error::GetWorkspaceError)
    pub fn get_workspace(&self) -> fluent_builders::GetWorkspace<C, M, R> {
        fluent_builders::GetWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponentTypes`](crate::client::fluent_builders::ListComponentTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponentTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ListComponentTypes::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ListComponentTypes::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`filters(Vec<ListComponentTypesFilter>)`](crate::client::fluent_builders::ListComponentTypes::filters) / [`set_filters(Option<Vec<ListComponentTypesFilter>>)`](crate::client::fluent_builders::ListComponentTypes::set_filters): <p>A list of objects that filter the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponentTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponentTypes::set_next_token): <p>The string that specifies the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponentTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponentTypes::set_max_results): <p>The maximum number of results to display.</p>
    /// - On success, responds with [`ListComponentTypesOutput`](crate::output::ListComponentTypesOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::ListComponentTypesOutput::workspace_id): <p>The ID of the workspace.</p>
    ///   - [`component_type_summaries(Option<Vec<ComponentTypeSummary>>)`](crate::output::ListComponentTypesOutput::component_type_summaries): <p>A list of objects that contain information about the component types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentTypesOutput::next_token): <p>The string that specifies the next page of results.</p>
    ///   - [`max_results(Option<i32>)`](crate::output::ListComponentTypesOutput::max_results): <p>Specifies the maximum number of results to display.</p>
    /// - On failure, responds with [`SdkError<ListComponentTypesError>`](crate::error::ListComponentTypesError)
    pub fn list_component_types(&self) -> fluent_builders::ListComponentTypes<C, M, R> {
        fluent_builders::ListComponentTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntities`](crate::client::fluent_builders::ListEntities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEntities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ListEntities::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ListEntities::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`filters(Vec<ListEntitiesFilter>)`](crate::client::fluent_builders::ListEntities::filters) / [`set_filters(Option<Vec<ListEntitiesFilter>>)`](crate::client::fluent_builders::ListEntities::set_filters): <p>A list of objects that filter the request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEntities::set_max_results): <p>The maximum number of results to display.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntities::set_next_token): <p>The string that specifies the next page of results.</p>
    /// - On success, responds with [`ListEntitiesOutput`](crate::output::ListEntitiesOutput) with field(s):
    ///   - [`entity_summaries(Option<Vec<EntitySummary>>)`](crate::output::ListEntitiesOutput::entity_summaries): <p>A list of objects that contain information about the entities.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEntitiesOutput::next_token): <p>The string that specifies the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListEntitiesError>`](crate::error::ListEntitiesError)
    pub fn list_entities(&self) -> fluent_builders::ListEntities<C, M, R> {
        fluent_builders::ListEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListScenes`](crate::client::fluent_builders::ListScenes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListScenes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ListScenes::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ListScenes::set_workspace_id): <p>The ID of the workspace that contains the scenes.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListScenes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListScenes::set_max_results): <p>Specifies the maximum number of results to display.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListScenes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListScenes::set_next_token): <p>The string that specifies the next page of results.</p>
    /// - On success, responds with [`ListScenesOutput`](crate::output::ListScenesOutput) with field(s):
    ///   - [`scene_summaries(Option<Vec<SceneSummary>>)`](crate::output::ListScenesOutput::scene_summaries): <p>A list of objects that contain information about the scenes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListScenesOutput::next_token): <p>The string that specifies the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListScenesError>`](crate::error::ListScenesError)
    pub fn list_scenes(&self) -> fluent_builders::ListScenes<C, M, R> {
        fluent_builders::ListScenes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of results to display.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The string that specifies the next page of results.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Metadata that you can use to manage a resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The string that specifies the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkspaces`](crate::client::fluent_builders::ListWorkspaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkspaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkspaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkspaces::set_max_results): <p>The maximum number of results to display.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkspaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkspaces::set_next_token): <p>The string that specifies the next page of results.</p>
    /// - On success, responds with [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput) with field(s):
    ///   - [`workspace_summaries(Option<Vec<WorkspaceSummary>>)`](crate::output::ListWorkspacesOutput::workspace_summaries): <p>A list of objects that contain information about the workspaces.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkspacesOutput::next_token): <p>The string that specifies the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListWorkspacesError>`](crate::error::ListWorkspacesError)
    pub fn list_workspaces(&self) -> fluent_builders::ListWorkspaces<C, M, R> {
        fluent_builders::ListWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Metadata to add to this resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateComponentType`](crate::client::fluent_builders::UpdateComponentType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentType::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateComponentType::set_workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`is_singleton(bool)`](crate::client::fluent_builders::UpdateComponentType::is_singleton) / [`set_is_singleton(Option<bool>)`](crate::client::fluent_builders::UpdateComponentType::set_is_singleton): <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
    ///   - [`component_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentType::component_type_id) / [`set_component_type_id(Option<String>)`](crate::client::fluent_builders::UpdateComponentType::set_component_type_id): <p>The ID of the component type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateComponentType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateComponentType::set_description): <p>The description of the component type.</p>
    ///   - [`property_definitions(HashMap<String, PropertyDefinitionRequest>)`](crate::client::fluent_builders::UpdateComponentType::property_definitions) / [`set_property_definitions(Option<HashMap<String, PropertyDefinitionRequest>>)`](crate::client::fluent_builders::UpdateComponentType::set_property_definitions): <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    ///   - [`extends_from(Vec<String>)`](crate::client::fluent_builders::UpdateComponentType::extends_from) / [`set_extends_from(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateComponentType::set_extends_from): <p>Specifies the component type that this component type extends.</p>
    ///   - [`functions(HashMap<String, FunctionRequest>)`](crate::client::fluent_builders::UpdateComponentType::functions) / [`set_functions(Option<HashMap<String, FunctionRequest>>)`](crate::client::fluent_builders::UpdateComponentType::set_functions): <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
    /// - On success, responds with [`UpdateComponentTypeOutput`](crate::output::UpdateComponentTypeOutput) with field(s):
    ///   - [`workspace_id(Option<String>)`](crate::output::UpdateComponentTypeOutput::workspace_id): <p>The ID of the workspace that contains the component type.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateComponentTypeOutput::arn): <p>The ARN of the component type.</p>
    ///   - [`component_type_id(Option<String>)`](crate::output::UpdateComponentTypeOutput::component_type_id): <p>The ID of the component type.</p>
    ///   - [`state(Option<State>)`](crate::output::UpdateComponentTypeOutput::state): <p>The current state of the component type.</p>
    /// - On failure, responds with [`SdkError<UpdateComponentTypeError>`](crate::error::UpdateComponentTypeError)
    pub fn update_component_type(&self) -> fluent_builders::UpdateComponentType<C, M, R> {
        fluent_builders::UpdateComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEntity`](crate::client::fluent_builders::UpdateEntity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEntity::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateEntity::set_workspace_id): <p>The ID of the workspace that contains the entity.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEntity::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::UpdateEntity::set_entity_id): <p>The ID of the entity.</p>
    ///   - [`entity_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEntity::entity_name) / [`set_entity_name(Option<String>)`](crate::client::fluent_builders::UpdateEntity::set_entity_name): <p>The name of the entity.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEntity::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEntity::set_description): <p>The description of the entity.</p>
    ///   - [`component_updates(HashMap<String, ComponentUpdateRequest>)`](crate::client::fluent_builders::UpdateEntity::component_updates) / [`set_component_updates(Option<HashMap<String, ComponentUpdateRequest>>)`](crate::client::fluent_builders::UpdateEntity::set_component_updates): <p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>
    ///   - [`parent_entity_update(ParentEntityUpdateRequest)`](crate::client::fluent_builders::UpdateEntity::parent_entity_update) / [`set_parent_entity_update(Option<ParentEntityUpdateRequest>)`](crate::client::fluent_builders::UpdateEntity::set_parent_entity_update): <p>An object that describes the update request for a parent entity.</p>
    /// - On success, responds with [`UpdateEntityOutput`](crate::output::UpdateEntityOutput) with field(s):
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::UpdateEntityOutput::update_date_time): <p>The date and time when the entity was last updated.</p>
    ///   - [`state(Option<State>)`](crate::output::UpdateEntityOutput::state): <p>The current state of the entity update.</p>
    /// - On failure, responds with [`SdkError<UpdateEntityError>`](crate::error::UpdateEntityError)
    pub fn update_entity(&self) -> fluent_builders::UpdateEntity<C, M, R> {
        fluent_builders::UpdateEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateScene`](crate::client::fluent_builders::UpdateScene) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateScene::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateScene::set_workspace_id): <p>The ID of the workspace that contains the scene.</p>
    ///   - [`scene_id(impl Into<String>)`](crate::client::fluent_builders::UpdateScene::scene_id) / [`set_scene_id(Option<String>)`](crate::client::fluent_builders::UpdateScene::set_scene_id): <p>The ID of the scene.</p>
    ///   - [`content_location(impl Into<String>)`](crate::client::fluent_builders::UpdateScene::content_location) / [`set_content_location(Option<String>)`](crate::client::fluent_builders::UpdateScene::set_content_location): <p>The relative path that specifies the location of the content definition file.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateScene::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateScene::set_description): <p>The description of this scene.</p>
    ///   - [`capabilities(Vec<String>)`](crate::client::fluent_builders::UpdateScene::capabilities) / [`set_capabilities(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateScene::set_capabilities): <p>A list of capabilities that the scene uses to render.</p>
    /// - On success, responds with [`UpdateSceneOutput`](crate::output::UpdateSceneOutput) with field(s):
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::UpdateSceneOutput::update_date_time): <p>The date and time when the scene was last updated.</p>
    /// - On failure, responds with [`SdkError<UpdateSceneError>`](crate::error::UpdateSceneError)
    pub fn update_scene(&self) -> fluent_builders::UpdateScene<C, M, R> {
        fluent_builders::UpdateScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspace`](crate::client::fluent_builders::UpdateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_id): <p>The ID of the workspace.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_description): <p>The description of the workspace.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_role): <p>The ARN of the execution role associated with the workspace.</p>
    /// - On success, responds with [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput) with field(s):
    ///   - [`update_date_time(Option<DateTime>)`](crate::output::UpdateWorkspaceOutput::update_date_time): <p>The date and time of the current update.</p>
    /// - On failure, responds with [`SdkError<UpdateWorkspaceError>`](crate::error::UpdateWorkspaceError)
    pub fn update_workspace(&self) -> fluent_builders::UpdateWorkspace<C, M, R> {
        fluent_builders::UpdateWorkspace::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchPutPropertyValues`.
    ///
    /// <p>Sets values for multiple time series properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchPutPropertyValues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_property_values_input::Builder,
    }
    impl<C, M, R> BatchPutPropertyValues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutPropertyValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutPropertyValuesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutPropertyValuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutPropertyValuesInputOperationOutputAlias,
                crate::output::BatchPutPropertyValuesOutput,
                crate::error::BatchPutPropertyValuesError,
                crate::input::BatchPutPropertyValuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>
        pub fn entries(mut self, input: crate::model::PropertyValueEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValueEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponentType`.
    ///
    /// <p>Creates a component type.</p> <important>
    /// <p> TwinMaker is in public preview and is subject to change. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_component_type_input::Builder,
    }
    impl<C, M, R> CreateComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComponentTypeInputOperationOutputAlias,
                crate::output::CreateComponentTypeOutput,
                crate::error::CreateComponentTypeError,
                crate::input::CreateComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.inner = self.inner.is_singleton(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_singleton(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `propertyDefinitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyDefinitionRequest,
        ) -> Self {
            self.inner = self.inner.property_definitions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_property_definitions(input);
            self
        }
        /// Appends an item to `extendsFrom`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the parent component type to extend.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extends_from(input.into());
            self
        }
        /// <p>Specifies the parent component type to extend.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_extends_from(input);
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FunctionRequest,
        ) -> Self {
            self.inner = self.inner.functions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_functions(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEntity`.
    ///
    /// <p>Creates an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_entity_input::Builder,
    }
    impl<C, M, R> CreateEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEntityInputOperationOutputAlias,
                crate::output::CreateEntityOutput,
                crate::error::CreateEntityError,
                crate::input::CreateEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_name(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_name(input);
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentRequest,
        ) -> Self {
            self.inner = self.inner.components(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_entity_id(input.into());
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_entity_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScene`.
    ///
    /// <p>Creates a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scene_input::Builder,
    }
    impl<C, M, R> CreateScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSceneInputOperationOutputAlias,
                crate::output::CreateSceneOutput,
                crate::error::CreateSceneError,
                crate::input::CreateSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_location(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_location(input);
            self
        }
        /// <p>The description for this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(input.into());
            self
        }
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspace`.
    ///
    /// <p>Creates a workplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspace_input::Builder,
    }
    impl<C, M, R> CreateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspaceInputOperationOutputAlias,
                crate::output::CreateWorkspaceOutput,
                crate::error::CreateWorkspaceError,
                crate::input::CreateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_location(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn set_s3_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_location(input);
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponentType`.
    ///
    /// <p>Deletes a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_component_type_input::Builder,
    }
    impl<C, M, R> DeleteComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteComponentTypeInputOperationOutputAlias,
                crate::output::DeleteComponentTypeOutput,
                crate::error::DeleteComponentTypeError,
                crate::input::DeleteComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntity`.
    ///
    /// <p>Deletes an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_entity_input::Builder,
    }
    impl<C, M, R> DeleteEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEntityInputOperationOutputAlias,
                crate::output::DeleteEntityOutput,
                crate::error::DeleteEntityError,
                crate::input::DeleteEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn is_recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.is_recursive(input);
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn set_is_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_recursive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScene`.
    ///
    /// <p>Deletes a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scene_input::Builder,
    }
    impl<C, M, R> DeleteScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSceneInputOperationOutputAlias,
                crate::output::DeleteSceneOutput,
                crate::error::DeleteSceneError,
                crate::input::DeleteSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspace`.
    ///
    /// <p>Deletes a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_input::Builder,
    }
    impl<C, M, R> DeleteWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceInputOperationOutputAlias,
                crate::output::DeleteWorkspaceOutput,
                crate::error::DeleteWorkspaceError,
                crate::input::DeleteWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponentType`.
    ///
    /// <p>Retrieves information about a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_component_type_input::Builder,
    }
    impl<C, M, R> GetComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComponentTypeInputOperationOutputAlias,
                crate::output::GetComponentTypeOutput,
                crate::error::GetComponentTypeError,
                crate::input::GetComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntity`.
    ///
    /// <p>Retrieves information about an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_entity_input::Builder,
    }
    impl<C, M, R> GetEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEntityInputOperationOutputAlias,
                crate::output::GetEntityOutput,
                crate::error::GetEntityError,
                crate::input::GetEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPropertyValue`.
    ///
    /// <p>Gets the property values for a component, component type, entity, or workspace.</p>
    /// <p>You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>, <code>entityId</code>, or <code>workspaceId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPropertyValue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_property_value_input::Builder,
    }
    impl<C, M, R> GetPropertyValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPropertyValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPropertyValueInputOperationOutputAlias,
                crate::output::GetPropertyValueOutput,
                crate::error::GetPropertyValueError,
                crate::input::GetPropertyValueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// Appends an item to `selectedProperties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>The properties whose values the operation returns.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_properties(input.into());
            self
        }
        /// <p>The properties whose values the operation returns.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_properties(input);
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPropertyValueHistory`.
    ///
    /// <p>Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.</p>
    /// <p>You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for <code>componentTypeId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPropertyValueHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_property_value_history_input::Builder,
    }
    impl<C, M, R> GetPropertyValueHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPropertyValueHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPropertyValueHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPropertyValueHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPropertyValueHistoryInputOperationOutputAlias,
                crate::output::GetPropertyValueHistoryOutput,
                crate::error::GetPropertyValueHistoryError,
                crate::input::GetPropertyValueHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPropertyValueHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetPropertyValueHistoryPaginator<C, M, R> {
            crate::paginator::GetPropertyValueHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// Appends an item to `selectedProperties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_properties(input.into());
            self
        }
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_properties(input);
            self
        }
        /// Appends an item to `propertyFilters`.
        ///
        /// To override the contents of this collection use [`set_property_filters`](Self::set_property_filters).
        ///
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn property_filters(mut self, input: crate::model::PropertyFilter) -> Self {
            self.inner = self.inner.property_filters(input);
            self
        }
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn set_property_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyFilter>>,
        ) -> Self {
            self.inner = self.inner.set_property_filters(input);
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date_time(input);
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date_time(input);
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date_time(input);
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date_time(input);
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn interpolation(mut self, input: crate::model::InterpolationParameters) -> Self {
            self.inner = self.inner.interpolation(input);
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn set_interpolation(
            mut self,
            input: std::option::Option<crate::model::InterpolationParameters>,
        ) -> Self {
            self.inner = self.inner.set_interpolation(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn order_by_time(mut self, input: crate::model::OrderByTime) -> Self {
            self.inner = self.inner.order_by_time(input);
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn set_order_by_time(
            mut self,
            input: std::option::Option<crate::model::OrderByTime>,
        ) -> Self {
            self.inner = self.inner.set_order_by_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetScene`.
    ///
    /// <p>Retrieves information about a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_scene_input::Builder,
    }
    impl<C, M, R> GetScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSceneInputOperationOutputAlias,
                crate::output::GetSceneOutput,
                crate::error::GetSceneError,
                crate::input::GetSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkspace`.
    ///
    /// <p>Retrieves information about a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workspace_input::Builder,
    }
    impl<C, M, R> GetWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkspaceInputOperationOutputAlias,
                crate::output::GetWorkspaceOutput,
                crate::error::GetWorkspaceError,
                crate::input::GetWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponentTypes`.
    ///
    /// <p>Lists all component types in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponentTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_component_types_input::Builder,
    }
    impl<C, M, R> ListComponentTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponentTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentTypesInputOperationOutputAlias,
                crate::output::ListComponentTypesOutput,
                crate::error::ListComponentTypesError,
                crate::input::ListComponentTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentTypesPaginator<C, M, R> {
            crate::paginator::ListComponentTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: crate::model::ListComponentTypesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListComponentTypesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntities`.
    ///
    /// <p>Lists all entities in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entities_input::Builder,
    }
    impl<C, M, R> ListEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitiesInputOperationOutputAlias,
                crate::output::ListEntitiesOutput,
                crate::error::ListEntitiesError,
                crate::input::ListEntitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntitiesPaginator<C, M, R> {
            crate::paginator::ListEntitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: crate::model::ListEntitiesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEntitiesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListScenes`.
    ///
    /// <p>Lists all scenes in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListScenes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_scenes_input::Builder,
    }
    impl<C, M, R> ListScenes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListScenes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListScenesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListScenesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListScenesInputOperationOutputAlias,
                crate::output::ListScenesOutput,
                crate::error::ListScenesError,
                crate::input::ListScenesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListScenesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListScenesPaginator<C, M, R> {
            crate::paginator::ListScenesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkspaces`.
    ///
    /// <p>Retrieves information about workspaces in the current account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workspaces_input::Builder,
    }
    impl<C, M, R> ListWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkspacesInputOperationOutputAlias,
                crate::output::ListWorkspacesOutput,
                crate::error::ListWorkspacesError,
                crate::input::ListWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkspacesPaginator<C, M, R> {
            crate::paginator::ListWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to add to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to add to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponentType`.
    ///
    /// <p>Updates information in a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_component_type_input::Builder,
    }
    impl<C, M, R> UpdateComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateComponentTypeInputOperationOutputAlias,
                crate::output::UpdateComponentTypeOutput,
                crate::error::UpdateComponentTypeError,
                crate::input::UpdateComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.inner = self.inner.is_singleton(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_singleton(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `propertyDefinitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyDefinitionRequest,
        ) -> Self {
            self.inner = self.inner.property_definitions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_property_definitions(input);
            self
        }
        /// Appends an item to `extendsFrom`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extends_from(input.into());
            self
        }
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_extends_from(input);
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FunctionRequest,
        ) -> Self {
            self.inner = self.inner.functions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_functions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEntity`.
    ///
    /// <p>Updates an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_entity_input::Builder,
    }
    impl<C, M, R> UpdateEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEntityInputOperationOutputAlias,
                crate::output::UpdateEntityOutput,
                crate::error::UpdateEntityError,
                crate::input::UpdateEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_name(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_name(input);
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `componentUpdates`.
        ///
        /// To override the contents of this collection use [`set_component_updates`](Self::set_component_updates).
        ///
        /// <p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>
        pub fn component_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentUpdateRequest,
        ) -> Self {
            self.inner = self.inner.component_updates(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>
        pub fn set_component_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentUpdateRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_component_updates(input);
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn parent_entity_update(
            mut self,
            input: crate::model::ParentEntityUpdateRequest,
        ) -> Self {
            self.inner = self.inner.parent_entity_update(input);
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn set_parent_entity_update(
            mut self,
            input: std::option::Option<crate::model::ParentEntityUpdateRequest>,
        ) -> Self {
            self.inner = self.inner.set_parent_entity_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateScene`.
    ///
    /// <p>Updates a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_scene_input::Builder,
    }
    impl<C, M, R> UpdateScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSceneInputOperationOutputAlias,
                crate::output::UpdateSceneOutput,
                crate::error::UpdateSceneError,
                crate::input::UpdateSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_location(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_location(input);
            self
        }
        /// <p>The description of this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(input.into());
            self
        }
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspace`.
    ///
    /// <p>Updates a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_input::Builder,
    }
    impl<C, M, R> UpdateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceInputOperationOutputAlias,
                crate::output::UpdateWorkspaceOutput,
                crate::error::UpdateWorkspaceError,
                crate::input::UpdateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
