// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => State::Active,
            "CREATING" => State::Creating,
            "DELETING" => State::Deleting,
            "ERROR" => State::Error,
            "UPDATING" => State::Updating,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Active => "ACTIVE",
            State::Creating => "CREATING",
            State::Deleting => "DELETING",
            State::Error => "ERROR",
            State::Updating => "UPDATING",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "ERROR", "UPDATING"]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The parent entity update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParentEntityUpdateRequest {
    /// <p>The type of the update.</p>
    pub update_type: std::option::Option<crate::model::ParentEntityUpdateType>,
    /// <p>The ID of the parent entity.</p>
    pub parent_entity_id: std::option::Option<std::string::String>,
}
impl ParentEntityUpdateRequest {
    /// <p>The type of the update.</p>
    pub fn update_type(&self) -> std::option::Option<&crate::model::ParentEntityUpdateType> {
        self.update_type.as_ref()
    }
    /// <p>The ID of the parent entity.</p>
    pub fn parent_entity_id(&self) -> std::option::Option<&str> {
        self.parent_entity_id.as_deref()
    }
}
impl std::fmt::Debug for ParentEntityUpdateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParentEntityUpdateRequest");
        formatter.field("update_type", &self.update_type);
        formatter.field("parent_entity_id", &self.parent_entity_id);
        formatter.finish()
    }
}
/// See [`ParentEntityUpdateRequest`](crate::model::ParentEntityUpdateRequest)
pub mod parent_entity_update_request {
    /// A builder for [`ParentEntityUpdateRequest`](crate::model::ParentEntityUpdateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_type: std::option::Option<crate::model::ParentEntityUpdateType>,
        pub(crate) parent_entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the update.</p>
        pub fn update_type(mut self, input: crate::model::ParentEntityUpdateType) -> Self {
            self.update_type = Some(input);
            self
        }
        /// <p>The type of the update.</p>
        pub fn set_update_type(
            mut self,
            input: std::option::Option<crate::model::ParentEntityUpdateType>,
        ) -> Self {
            self.update_type = input;
            self
        }
        /// <p>The ID of the parent entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ParentEntityUpdateRequest`](crate::model::ParentEntityUpdateRequest)
        pub fn build(self) -> crate::model::ParentEntityUpdateRequest {
            crate::model::ParentEntityUpdateRequest {
                update_type: self.update_type,
                parent_entity_id: self.parent_entity_id,
            }
        }
    }
}
impl ParentEntityUpdateRequest {
    /// Creates a new builder-style object to manufacture [`ParentEntityUpdateRequest`](crate::model::ParentEntityUpdateRequest)
    pub fn builder() -> crate::model::parent_entity_update_request::Builder {
        crate::model::parent_entity_update_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParentEntityUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParentEntityUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => ParentEntityUpdateType::Delete,
            "UPDATE" => ParentEntityUpdateType::Update,
            other => ParentEntityUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParentEntityUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParentEntityUpdateType::from(s))
    }
}
impl ParentEntityUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParentEntityUpdateType::Delete => "DELETE",
            ParentEntityUpdateType::Update => "UPDATE",
            ParentEntityUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "UPDATE"]
    }
}
impl AsRef<str> for ParentEntityUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The component update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentUpdateRequest {
    /// <p>The update type of the component update request.</p>
    pub update_type: std::option::Option<crate::model::ComponentUpdateType>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>
    pub property_updates: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
    >,
}
impl ComponentUpdateRequest {
    /// <p>The update type of the component update request.</p>
    pub fn update_type(&self) -> std::option::Option<&crate::model::ComponentUpdateType> {
        self.update_type.as_ref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>
    pub fn property_updates(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
    > {
        self.property_updates.as_ref()
    }
}
impl std::fmt::Debug for ComponentUpdateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentUpdateRequest");
        formatter.field("update_type", &self.update_type);
        formatter.field("description", &self.description);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("property_updates", &self.property_updates);
        formatter.finish()
    }
}
/// See [`ComponentUpdateRequest`](crate::model::ComponentUpdateRequest)
pub mod component_update_request {
    /// A builder for [`ComponentUpdateRequest`](crate::model::ComponentUpdateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_type: std::option::Option<crate::model::ComponentUpdateType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) property_updates: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
        >,
    }
    impl Builder {
        /// <p>The update type of the component update request.</p>
        pub fn update_type(mut self, input: crate::model::ComponentUpdateType) -> Self {
            self.update_type = Some(input);
            self
        }
        /// <p>The update type of the component update request.</p>
        pub fn set_update_type(
            mut self,
            input: std::option::Option<crate::model::ComponentUpdateType>,
        ) -> Self {
            self.update_type = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// Adds a key-value pair to `property_updates`.
        ///
        /// To override the contents of this collection use [`set_property_updates`](Self::set_property_updates).
        ///
        /// <p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>
        pub fn property_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyRequest,
        ) -> Self {
            let mut hash_map = self.property_updates.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.property_updates = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
            >,
        ) -> Self {
            self.property_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentUpdateRequest`](crate::model::ComponentUpdateRequest)
        pub fn build(self) -> crate::model::ComponentUpdateRequest {
            crate::model::ComponentUpdateRequest {
                update_type: self.update_type,
                description: self.description,
                component_type_id: self.component_type_id,
                property_updates: self.property_updates,
            }
        }
    }
}
impl ComponentUpdateRequest {
    /// Creates a new builder-style object to manufacture [`ComponentUpdateRequest`](crate::model::ComponentUpdateRequest)
    pub fn builder() -> crate::model::component_update_request::Builder {
        crate::model::component_update_request::Builder::default()
    }
}

/// <p>An object that sets information about a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyRequest {
    /// <p>An object that specifies information about a property.</p>
    pub definition: std::option::Option<crate::model::PropertyDefinitionRequest>,
    /// <p>The value of the property.</p>
    pub value: std::option::Option<crate::model::DataValue>,
    /// <p>The update type of the update property request.</p>
    pub update_type: std::option::Option<crate::model::PropertyUpdateType>,
}
impl PropertyRequest {
    /// <p>An object that specifies information about a property.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::PropertyDefinitionRequest> {
        self.definition.as_ref()
    }
    /// <p>The value of the property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.value.as_ref()
    }
    /// <p>The update type of the update property request.</p>
    pub fn update_type(&self) -> std::option::Option<&crate::model::PropertyUpdateType> {
        self.update_type.as_ref()
    }
}
impl std::fmt::Debug for PropertyRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyRequest");
        formatter.field("definition", &self.definition);
        formatter.field("value", &self.value);
        formatter.field("update_type", &self.update_type);
        formatter.finish()
    }
}
/// See [`PropertyRequest`](crate::model::PropertyRequest)
pub mod property_request {
    /// A builder for [`PropertyRequest`](crate::model::PropertyRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<crate::model::PropertyDefinitionRequest>,
        pub(crate) value: std::option::Option<crate::model::DataValue>,
        pub(crate) update_type: std::option::Option<crate::model::PropertyUpdateType>,
    }
    impl Builder {
        /// <p>An object that specifies information about a property.</p>
        pub fn definition(mut self, input: crate::model::PropertyDefinitionRequest) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>An object that specifies information about a property.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::PropertyDefinitionRequest>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn value(mut self, input: crate::model::DataValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::DataValue>) -> Self {
            self.value = input;
            self
        }
        /// <p>The update type of the update property request.</p>
        pub fn update_type(mut self, input: crate::model::PropertyUpdateType) -> Self {
            self.update_type = Some(input);
            self
        }
        /// <p>The update type of the update property request.</p>
        pub fn set_update_type(
            mut self,
            input: std::option::Option<crate::model::PropertyUpdateType>,
        ) -> Self {
            self.update_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyRequest`](crate::model::PropertyRequest)
        pub fn build(self) -> crate::model::PropertyRequest {
            crate::model::PropertyRequest {
                definition: self.definition,
                value: self.value,
                update_type: self.update_type,
            }
        }
    }
}
impl PropertyRequest {
    /// Creates a new builder-style object to manufacture [`PropertyRequest`](crate::model::PropertyRequest)
    pub fn builder() -> crate::model::property_request::Builder {
        crate::model::property_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropertyUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropertyUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => PropertyUpdateType::Delete,
            "UPDATE" => PropertyUpdateType::Update,
            other => PropertyUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropertyUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropertyUpdateType::from(s))
    }
}
impl PropertyUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropertyUpdateType::Delete => "DELETE",
            PropertyUpdateType::Update => "UPDATE",
            PropertyUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "UPDATE"]
    }
}
impl AsRef<str> for PropertyUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that specifies a value for a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataValue {
    /// <p>A Boolean value.</p>
    pub boolean_value: std::option::Option<bool>,
    /// <p>A double value.</p>
    pub double_value: std::option::Option<f64>,
    /// <p>An integer value.</p>
    pub integer_value: std::option::Option<i32>,
    /// <p>A long value.</p>
    pub long_value: std::option::Option<i64>,
    /// <p>A string value.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>A list of multiple values.</p>
    pub list_value: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
    /// <p>An object that maps strings to multiple <code>DataValue</code> objects.</p>
    pub map_value: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::DataValue>,
    >,
    /// <p>A value that relates a component to another component.</p>
    pub relationship_value: std::option::Option<crate::model::RelationshipValue>,
    /// <p>An expression that produces the value.</p>
    pub expression: std::option::Option<std::string::String>,
}
impl DataValue {
    /// <p>A Boolean value.</p>
    pub fn boolean_value(&self) -> std::option::Option<bool> {
        self.boolean_value
    }
    /// <p>A double value.</p>
    pub fn double_value(&self) -> std::option::Option<f64> {
        self.double_value
    }
    /// <p>An integer value.</p>
    pub fn integer_value(&self) -> std::option::Option<i32> {
        self.integer_value
    }
    /// <p>A long value.</p>
    pub fn long_value(&self) -> std::option::Option<i64> {
        self.long_value
    }
    /// <p>A string value.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>A list of multiple values.</p>
    pub fn list_value(&self) -> std::option::Option<&[crate::model::DataValue]> {
        self.list_value.as_deref()
    }
    /// <p>An object that maps strings to multiple <code>DataValue</code> objects.</p>
    pub fn map_value(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::DataValue>>
    {
        self.map_value.as_ref()
    }
    /// <p>A value that relates a component to another component.</p>
    pub fn relationship_value(&self) -> std::option::Option<&crate::model::RelationshipValue> {
        self.relationship_value.as_ref()
    }
    /// <p>An expression that produces the value.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for DataValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataValue");
        formatter.field("boolean_value", &self.boolean_value);
        formatter.field("double_value", &self.double_value);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("long_value", &self.long_value);
        formatter.field("string_value", &self.string_value);
        formatter.field("list_value", &self.list_value);
        formatter.field("map_value", &self.map_value);
        formatter.field("relationship_value", &self.relationship_value);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`DataValue`](crate::model::DataValue)
pub mod data_value {
    /// A builder for [`DataValue`](crate::model::DataValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) boolean_value: std::option::Option<bool>,
        pub(crate) double_value: std::option::Option<f64>,
        pub(crate) integer_value: std::option::Option<i32>,
        pub(crate) long_value: std::option::Option<i64>,
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) list_value: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
        pub(crate) map_value: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::DataValue>,
        >,
        pub(crate) relationship_value: std::option::Option<crate::model::RelationshipValue>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value.</p>
        pub fn boolean_value(mut self, input: bool) -> Self {
            self.boolean_value = Some(input);
            self
        }
        /// <p>A Boolean value.</p>
        pub fn set_boolean_value(mut self, input: std::option::Option<bool>) -> Self {
            self.boolean_value = input;
            self
        }
        /// <p>A double value.</p>
        pub fn double_value(mut self, input: f64) -> Self {
            self.double_value = Some(input);
            self
        }
        /// <p>A double value.</p>
        pub fn set_double_value(mut self, input: std::option::Option<f64>) -> Self {
            self.double_value = input;
            self
        }
        /// <p>An integer value.</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p>An integer value.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// <p>A long value.</p>
        pub fn long_value(mut self, input: i64) -> Self {
            self.long_value = Some(input);
            self
        }
        /// <p>A long value.</p>
        pub fn set_long_value(mut self, input: std::option::Option<i64>) -> Self {
            self.long_value = input;
            self
        }
        /// <p>A string value.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>A string value.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// Appends an item to `list_value`.
        ///
        /// To override the contents of this collection use [`set_list_value`](Self::set_list_value).
        ///
        /// <p>A list of multiple values.</p>
        pub fn list_value(mut self, input: crate::model::DataValue) -> Self {
            let mut v = self.list_value.unwrap_or_default();
            v.push(input);
            self.list_value = Some(v);
            self
        }
        /// <p>A list of multiple values.</p>
        pub fn set_list_value(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
        ) -> Self {
            self.list_value = input;
            self
        }
        /// Adds a key-value pair to `map_value`.
        ///
        /// To override the contents of this collection use [`set_map_value`](Self::set_map_value).
        ///
        /// <p>An object that maps strings to multiple <code>DataValue</code> objects.</p>
        pub fn map_value(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::DataValue,
        ) -> Self {
            let mut hash_map = self.map_value.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.map_value = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to multiple <code>DataValue</code> objects.</p>
        pub fn set_map_value(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::DataValue>,
            >,
        ) -> Self {
            self.map_value = input;
            self
        }
        /// <p>A value that relates a component to another component.</p>
        pub fn relationship_value(mut self, input: crate::model::RelationshipValue) -> Self {
            self.relationship_value = Some(input);
            self
        }
        /// <p>A value that relates a component to another component.</p>
        pub fn set_relationship_value(
            mut self,
            input: std::option::Option<crate::model::RelationshipValue>,
        ) -> Self {
            self.relationship_value = input;
            self
        }
        /// <p>An expression that produces the value.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>An expression that produces the value.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`DataValue`](crate::model::DataValue)
        pub fn build(self) -> crate::model::DataValue {
            crate::model::DataValue {
                boolean_value: self.boolean_value,
                double_value: self.double_value,
                integer_value: self.integer_value,
                long_value: self.long_value,
                string_value: self.string_value,
                list_value: self.list_value,
                map_value: self.map_value,
                relationship_value: self.relationship_value,
                expression: self.expression,
            }
        }
    }
}
impl DataValue {
    /// Creates a new builder-style object to manufacture [`DataValue`](crate::model::DataValue)
    pub fn builder() -> crate::model::data_value::Builder {
        crate::model::data_value::Builder::default()
    }
}

/// <p>A value that associates a component and an entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationshipValue {
    /// <p>The ID of the target entity associated with this relationship value.</p>
    pub target_entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the target component associated with the relationship value.</p>
    pub target_component_name: std::option::Option<std::string::String>,
}
impl RelationshipValue {
    /// <p>The ID of the target entity associated with this relationship value.</p>
    pub fn target_entity_id(&self) -> std::option::Option<&str> {
        self.target_entity_id.as_deref()
    }
    /// <p>The name of the target component associated with the relationship value.</p>
    pub fn target_component_name(&self) -> std::option::Option<&str> {
        self.target_component_name.as_deref()
    }
}
impl std::fmt::Debug for RelationshipValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationshipValue");
        formatter.field("target_entity_id", &self.target_entity_id);
        formatter.field("target_component_name", &self.target_component_name);
        formatter.finish()
    }
}
/// See [`RelationshipValue`](crate::model::RelationshipValue)
pub mod relationship_value {
    /// A builder for [`RelationshipValue`](crate::model::RelationshipValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_entity_id: std::option::Option<std::string::String>,
        pub(crate) target_component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target entity associated with this relationship value.</p>
        pub fn target_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the target entity associated with this relationship value.</p>
        pub fn set_target_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_entity_id = input;
            self
        }
        /// <p>The name of the target component associated with the relationship value.</p>
        pub fn target_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_component_name = Some(input.into());
            self
        }
        /// <p>The name of the target component associated with the relationship value.</p>
        pub fn set_target_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationshipValue`](crate::model::RelationshipValue)
        pub fn build(self) -> crate::model::RelationshipValue {
            crate::model::RelationshipValue {
                target_entity_id: self.target_entity_id,
                target_component_name: self.target_component_name,
            }
        }
    }
}
impl RelationshipValue {
    /// Creates a new builder-style object to manufacture [`RelationshipValue`](crate::model::RelationshipValue)
    pub fn builder() -> crate::model::relationship_value::Builder {
        crate::model::relationship_value::Builder::default()
    }
}

/// <p>An object that sets information about a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyDefinitionRequest {
    /// <p>An object that contains information about the data type.</p>
    pub data_type: std::option::Option<crate::model::DataType>,
    /// <p>A Boolean value that specifies whether the property is required.</p>
    pub is_required_in_entity: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
    pub is_external_id: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property is stored externally.</p>
    pub is_stored_externally: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
    pub is_time_series: std::option::Option<bool>,
    /// <p>An object that contains the default value.</p>
    pub default_value: std::option::Option<crate::model::DataValue>,
    /// <p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>
    pub configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PropertyDefinitionRequest {
    /// <p>An object that contains information about the data type.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::DataType> {
        self.data_type.as_ref()
    }
    /// <p>A Boolean value that specifies whether the property is required.</p>
    pub fn is_required_in_entity(&self) -> std::option::Option<bool> {
        self.is_required_in_entity
    }
    /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
    pub fn is_external_id(&self) -> std::option::Option<bool> {
        self.is_external_id
    }
    /// <p>A Boolean value that specifies whether the property is stored externally.</p>
    pub fn is_stored_externally(&self) -> std::option::Option<bool> {
        self.is_stored_externally
    }
    /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
    pub fn is_time_series(&self) -> std::option::Option<bool> {
        self.is_time_series
    }
    /// <p>An object that contains the default value.</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.default_value.as_ref()
    }
    /// <p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for PropertyDefinitionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyDefinitionRequest");
        formatter.field("data_type", &self.data_type);
        formatter.field("is_required_in_entity", &self.is_required_in_entity);
        formatter.field("is_external_id", &self.is_external_id);
        formatter.field("is_stored_externally", &self.is_stored_externally);
        formatter.field("is_time_series", &self.is_time_series);
        formatter.field("default_value", &self.default_value);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`PropertyDefinitionRequest`](crate::model::PropertyDefinitionRequest)
pub mod property_definition_request {
    /// A builder for [`PropertyDefinitionRequest`](crate::model::PropertyDefinitionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_type: std::option::Option<crate::model::DataType>,
        pub(crate) is_required_in_entity: std::option::Option<bool>,
        pub(crate) is_external_id: std::option::Option<bool>,
        pub(crate) is_stored_externally: std::option::Option<bool>,
        pub(crate) is_time_series: std::option::Option<bool>,
        pub(crate) default_value: std::option::Option<crate::model::DataValue>,
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An object that contains information about the data type.</p>
        pub fn data_type(mut self, input: crate::model::DataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>An object that contains information about the data type.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property is required.</p>
        pub fn is_required_in_entity(mut self, input: bool) -> Self {
            self.is_required_in_entity = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property is required.</p>
        pub fn set_is_required_in_entity(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required_in_entity = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
        pub fn is_external_id(mut self, input: bool) -> Self {
            self.is_external_id = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
        pub fn set_is_external_id(mut self, input: std::option::Option<bool>) -> Self {
            self.is_external_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property is stored externally.</p>
        pub fn is_stored_externally(mut self, input: bool) -> Self {
            self.is_stored_externally = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property is stored externally.</p>
        pub fn set_is_stored_externally(mut self, input: std::option::Option<bool>) -> Self {
            self.is_stored_externally = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
        pub fn is_time_series(mut self, input: bool) -> Self {
            self.is_time_series = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
        pub fn set_is_time_series(mut self, input: std::option::Option<bool>) -> Self {
            self.is_time_series = input;
            self
        }
        /// <p>An object that contains the default value.</p>
        pub fn default_value(mut self, input: crate::model::DataValue) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>An object that contains the default value.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::DataValue>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration = Some(hash_map);
            self
        }
        /// <p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyDefinitionRequest`](crate::model::PropertyDefinitionRequest)
        pub fn build(self) -> crate::model::PropertyDefinitionRequest {
            crate::model::PropertyDefinitionRequest {
                data_type: self.data_type,
                is_required_in_entity: self.is_required_in_entity,
                is_external_id: self.is_external_id,
                is_stored_externally: self.is_stored_externally,
                is_time_series: self.is_time_series,
                default_value: self.default_value,
                configuration: self.configuration,
            }
        }
    }
}
impl PropertyDefinitionRequest {
    /// Creates a new builder-style object to manufacture [`PropertyDefinitionRequest`](crate::model::PropertyDefinitionRequest)
    pub fn builder() -> crate::model::property_definition_request::Builder {
        crate::model::property_definition_request::Builder::default()
    }
}

/// <p>An object that specifies the data type of a property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataType {
    /// <p>The underlying type of the data type.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>The nested type in the data type.</p>
    pub nested_type: std::option::Option<std::boxed::Box<crate::model::DataType>>,
    /// <p>The allowed values for this data type.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
    /// <p>The unit of measure used in this data type.</p>
    pub unit_of_measure: std::option::Option<std::string::String>,
    /// <p>A relationship that associates a component with another component.</p>
    pub relationship: std::option::Option<crate::model::Relationship>,
}
impl DataType {
    /// <p>The underlying type of the data type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>The nested type in the data type.</p>
    pub fn nested_type(&self) -> std::option::Option<&crate::model::DataType> {
        self.nested_type.as_deref()
    }
    /// <p>The allowed values for this data type.</p>
    pub fn allowed_values(&self) -> std::option::Option<&[crate::model::DataValue]> {
        self.allowed_values.as_deref()
    }
    /// <p>The unit of measure used in this data type.</p>
    pub fn unit_of_measure(&self) -> std::option::Option<&str> {
        self.unit_of_measure.as_deref()
    }
    /// <p>A relationship that associates a component with another component.</p>
    pub fn relationship(&self) -> std::option::Option<&crate::model::Relationship> {
        self.relationship.as_ref()
    }
}
impl std::fmt::Debug for DataType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataType");
        formatter.field("r#type", &self.r#type);
        formatter.field("nested_type", &self.nested_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("unit_of_measure", &self.unit_of_measure);
        formatter.field("relationship", &self.relationship);
        formatter.finish()
    }
}
/// See [`DataType`](crate::model::DataType)
pub mod data_type {
    /// A builder for [`DataType`](crate::model::DataType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) nested_type: std::option::Option<std::boxed::Box<crate::model::DataType>>,
        pub(crate) allowed_values: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
        pub(crate) unit_of_measure: std::option::Option<std::string::String>,
        pub(crate) relationship: std::option::Option<crate::model::Relationship>,
    }
    impl Builder {
        /// <p>The underlying type of the data type.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The underlying type of the data type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The nested type in the data type.</p>
        pub fn nested_type(
            mut self,
            input: impl Into<std::boxed::Box<crate::model::DataType>>,
        ) -> Self {
            self.nested_type = Some(input.into());
            self
        }
        /// <p>The nested type in the data type.</p>
        pub fn set_nested_type(
            mut self,
            input: std::option::Option<std::boxed::Box<crate::model::DataType>>,
        ) -> Self {
            self.nested_type = input;
            self
        }
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>The allowed values for this data type.</p>
        pub fn allowed_values(mut self, input: crate::model::DataValue) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input);
            self.allowed_values = Some(v);
            self
        }
        /// <p>The allowed values for this data type.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataValue>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>The unit of measure used in this data type.</p>
        pub fn unit_of_measure(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit_of_measure = Some(input.into());
            self
        }
        /// <p>The unit of measure used in this data type.</p>
        pub fn set_unit_of_measure(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unit_of_measure = input;
            self
        }
        /// <p>A relationship that associates a component with another component.</p>
        pub fn relationship(mut self, input: crate::model::Relationship) -> Self {
            self.relationship = Some(input);
            self
        }
        /// <p>A relationship that associates a component with another component.</p>
        pub fn set_relationship(
            mut self,
            input: std::option::Option<crate::model::Relationship>,
        ) -> Self {
            self.relationship = input;
            self
        }
        /// Consumes the builder and constructs a [`DataType`](crate::model::DataType)
        pub fn build(self) -> crate::model::DataType {
            crate::model::DataType {
                r#type: self.r#type,
                nested_type: self.nested_type,
                allowed_values: self.allowed_values,
                unit_of_measure: self.unit_of_measure,
                relationship: self.relationship,
            }
        }
    }
}
impl DataType {
    /// Creates a new builder-style object to manufacture [`DataType`](crate::model::DataType)
    pub fn builder() -> crate::model::data_type::Builder {
        crate::model::data_type::Builder::default()
    }
}

/// <p>An object that specifies a relationship with another component type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Relationship {
    /// <p>The ID of the target component type associated with this relationship.</p>
    pub target_component_type_id: std::option::Option<std::string::String>,
    /// <p>The type of the relationship.</p>
    pub relationship_type: std::option::Option<std::string::String>,
}
impl Relationship {
    /// <p>The ID of the target component type associated with this relationship.</p>
    pub fn target_component_type_id(&self) -> std::option::Option<&str> {
        self.target_component_type_id.as_deref()
    }
    /// <p>The type of the relationship.</p>
    pub fn relationship_type(&self) -> std::option::Option<&str> {
        self.relationship_type.as_deref()
    }
}
impl std::fmt::Debug for Relationship {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Relationship");
        formatter.field("target_component_type_id", &self.target_component_type_id);
        formatter.field("relationship_type", &self.relationship_type);
        formatter.finish()
    }
}
/// See [`Relationship`](crate::model::Relationship)
pub mod relationship {
    /// A builder for [`Relationship`](crate::model::Relationship)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_component_type_id: std::option::Option<std::string::String>,
        pub(crate) relationship_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target component type associated with this relationship.</p>
        pub fn target_component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the target component type associated with this relationship.</p>
        pub fn set_target_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_component_type_id = input;
            self
        }
        /// <p>The type of the relationship.</p>
        pub fn relationship_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.relationship_type = Some(input.into());
            self
        }
        /// <p>The type of the relationship.</p>
        pub fn set_relationship_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relationship_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Relationship`](crate::model::Relationship)
        pub fn build(self) -> crate::model::Relationship {
            crate::model::Relationship {
                target_component_type_id: self.target_component_type_id,
                relationship_type: self.relationship_type,
            }
        }
    }
}
impl Relationship {
    /// Creates a new builder-style object to manufacture [`Relationship`](crate::model::Relationship)
    pub fn builder() -> crate::model::relationship::Builder {
        crate::model::relationship::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    List,
    #[allow(missing_docs)] // documentation missing in model
    Long,
    #[allow(missing_docs)] // documentation missing in model
    Map,
    #[allow(missing_docs)] // documentation missing in model
    Relationship,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "BOOLEAN" => Type::Boolean,
            "DOUBLE" => Type::Double,
            "INTEGER" => Type::Integer,
            "LIST" => Type::List,
            "LONG" => Type::Long,
            "MAP" => Type::Map,
            "RELATIONSHIP" => Type::Relationship,
            "STRING" => Type::String,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::Boolean => "BOOLEAN",
            Type::Double => "DOUBLE",
            Type::Integer => "INTEGER",
            Type::List => "LIST",
            Type::Long => "LONG",
            Type::Map => "MAP",
            Type::Relationship => "RELATIONSHIP",
            Type::String => "STRING",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOLEAN",
            "DOUBLE",
            "INTEGER",
            "LIST",
            "LONG",
            "MAP",
            "RELATIONSHIP",
            "STRING",
        ]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => ComponentUpdateType::Create,
            "DELETE" => ComponentUpdateType::Delete,
            "UPDATE" => ComponentUpdateType::Update,
            other => ComponentUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentUpdateType::from(s))
    }
}
impl ComponentUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentUpdateType::Create => "CREATE",
            ComponentUpdateType::Delete => "DELETE",
            ComponentUpdateType::Update => "UPDATE",
            ComponentUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "DELETE", "UPDATE"]
    }
}
impl AsRef<str> for ComponentUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The function request body.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionRequest {
    /// <p>The required properties of the function.</p>
    pub required_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The scope of the function.</p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p>The data connector.</p>
    pub implemented_by: std::option::Option<crate::model::DataConnector>,
}
impl FunctionRequest {
    /// <p>The required properties of the function.</p>
    pub fn required_properties(&self) -> std::option::Option<&std::vec::Vec<std::string::String>> {
        self.required_properties.as_ref()
    }
    /// <p>The scope of the function.</p>
    pub fn scope(&self) -> std::option::Option<&crate::model::Scope> {
        self.scope.as_ref()
    }
    /// <p>The data connector.</p>
    pub fn implemented_by(&self) -> std::option::Option<&crate::model::DataConnector> {
        self.implemented_by.as_ref()
    }
}
impl std::fmt::Debug for FunctionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionRequest");
        formatter.field("required_properties", &self.required_properties);
        formatter.field("scope", &self.scope);
        formatter.field("implemented_by", &self.implemented_by);
        formatter.finish()
    }
}
/// See [`FunctionRequest`](crate::model::FunctionRequest)
pub mod function_request {
    /// A builder for [`FunctionRequest`](crate::model::FunctionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) required_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) implemented_by: std::option::Option<crate::model::DataConnector>,
    }
    impl Builder {
        /// <p>The required properties of the function.</p>
        pub fn required_properties(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.required_properties = Some(input);
            self
        }
        /// <p>The required properties of the function.</p>
        pub fn set_required_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.required_properties = input;
            self
        }
        /// <p>The scope of the function.</p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope of the function.</p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// <p>The data connector.</p>
        pub fn implemented_by(mut self, input: crate::model::DataConnector) -> Self {
            self.implemented_by = Some(input);
            self
        }
        /// <p>The data connector.</p>
        pub fn set_implemented_by(
            mut self,
            input: std::option::Option<crate::model::DataConnector>,
        ) -> Self {
            self.implemented_by = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionRequest`](crate::model::FunctionRequest)
        pub fn build(self) -> crate::model::FunctionRequest {
            crate::model::FunctionRequest {
                required_properties: self.required_properties,
                scope: self.scope,
                implemented_by: self.implemented_by,
            }
        }
    }
}
impl FunctionRequest {
    /// Creates a new builder-style object to manufacture [`FunctionRequest`](crate::model::FunctionRequest)
    pub fn builder() -> crate::model::function_request::Builder {
        crate::model::function_request::Builder::default()
    }
}

/// <p>The data connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataConnector {
    /// <p>The Lambda function associated with this data connector.</p>
    pub lambda: std::option::Option<crate::model::LambdaFunction>,
    /// <p>A Boolean value that specifies whether the data connector is native to TwinMaker.</p>
    pub is_native: std::option::Option<bool>,
}
impl DataConnector {
    /// <p>The Lambda function associated with this data connector.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaFunction> {
        self.lambda.as_ref()
    }
    /// <p>A Boolean value that specifies whether the data connector is native to TwinMaker.</p>
    pub fn is_native(&self) -> std::option::Option<bool> {
        self.is_native
    }
}
impl std::fmt::Debug for DataConnector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataConnector");
        formatter.field("lambda", &self.lambda);
        formatter.field("is_native", &self.is_native);
        formatter.finish()
    }
}
/// See [`DataConnector`](crate::model::DataConnector)
pub mod data_connector {
    /// A builder for [`DataConnector`](crate::model::DataConnector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda: std::option::Option<crate::model::LambdaFunction>,
        pub(crate) is_native: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Lambda function associated with this data connector.</p>
        pub fn lambda(mut self, input: crate::model::LambdaFunction) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>The Lambda function associated with this data connector.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaFunction>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// <p>A Boolean value that specifies whether the data connector is native to TwinMaker.</p>
        pub fn is_native(mut self, input: bool) -> Self {
            self.is_native = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the data connector is native to TwinMaker.</p>
        pub fn set_is_native(mut self, input: std::option::Option<bool>) -> Self {
            self.is_native = input;
            self
        }
        /// Consumes the builder and constructs a [`DataConnector`](crate::model::DataConnector)
        pub fn build(self) -> crate::model::DataConnector {
            crate::model::DataConnector {
                lambda: self.lambda,
                is_native: self.is_native,
            }
        }
    }
}
impl DataConnector {
    /// Creates a new builder-style object to manufacture [`DataConnector`](crate::model::DataConnector)
    pub fn builder() -> crate::model::data_connector::Builder {
        crate::model::data_connector::Builder::default()
    }
}

/// <p>The Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunction {
    /// <p>The ARN of the Lambda function.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl LambdaFunction {
    /// <p>The ARN of the Lambda function.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunction");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`LambdaFunction`](crate::model::LambdaFunction)
pub mod lambda_function {
    /// A builder for [`LambdaFunction`](crate::model::LambdaFunction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda function.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunction`](crate::model::LambdaFunction)
        pub fn build(self) -> crate::model::LambdaFunction {
            crate::model::LambdaFunction { arn: self.arn }
        }
    }
}
impl LambdaFunction {
    /// Creates a new builder-style object to manufacture [`LambdaFunction`](crate::model::LambdaFunction)
    pub fn builder() -> crate::model::lambda_function::Builder {
        crate::model::lambda_function::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Scope {
    #[allow(missing_docs)] // documentation missing in model
    Entity,
    #[allow(missing_docs)] // documentation missing in model
    Workspace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Scope {
    fn from(s: &str) -> Self {
        match s {
            "ENTITY" => Scope::Entity,
            "WORKSPACE" => Scope::Workspace,
            other => Scope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Scope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Scope::from(s))
    }
}
impl Scope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Scope::Entity => "ENTITY",
            Scope::Workspace => "WORKSPACE",
            Scope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENTITY", "WORKSPACE"]
    }
}
impl AsRef<str> for Scope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about a workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceSummary {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the workspace.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time when the workspace was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the workspace was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl WorkspaceSummary {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ARN of the workspace.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time when the workspace was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the workspace was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceSummary");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`WorkspaceSummary`](crate::model::WorkspaceSummary)
pub mod workspace_summary {
    /// A builder for [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ARN of the workspace.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the workspace.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the workspace was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the workspace was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceSummary`](crate::model::WorkspaceSummary)
        pub fn build(self) -> crate::model::WorkspaceSummary {
            crate::model::WorkspaceSummary {
                workspace_id: self.workspace_id,
                arn: self.arn,
                description: self.description,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl WorkspaceSummary {
    /// Creates a new builder-style object to manufacture [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    pub fn builder() -> crate::model::workspace_summary::Builder {
        crate::model::workspace_summary::Builder::default()
    }
}

/// <p>An object that contains information about a scene.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SceneSummary {
    /// <p>The ID of the scene.</p>
    pub scene_id: std::option::Option<std::string::String>,
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub content_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the scene.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the scene was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the scene was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The scene description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl SceneSummary {
    /// <p>The ID of the scene.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub fn content_location(&self) -> std::option::Option<&str> {
        self.content_location.as_deref()
    }
    /// <p>The ARN of the scene.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the scene was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the scene was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>The scene description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for SceneSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SceneSummary");
        formatter.field("scene_id", &self.scene_id);
        formatter.field("content_location", &self.content_location);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`SceneSummary`](crate::model::SceneSummary)
pub mod scene_summary {
    /// A builder for [`SceneSummary`](crate::model::SceneSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scene_id: std::option::Option<std::string::String>,
        pub(crate) content_location: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_location = Some(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_location = input;
            self
        }
        /// <p>The ARN of the scene.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scene.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the scene was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>The scene description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The scene description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`SceneSummary`](crate::model::SceneSummary)
        pub fn build(self) -> crate::model::SceneSummary {
            crate::model::SceneSummary {
                scene_id: self.scene_id,
                content_location: self.content_location,
                arn: self.arn,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
                description: self.description,
            }
        }
    }
}
impl SceneSummary {
    /// Creates a new builder-style object to manufacture [`SceneSummary`](crate::model::SceneSummary)
    pub fn builder() -> crate::model::scene_summary::Builder {
        crate::model::scene_summary::Builder::default()
    }
}

/// <p>An object that contains information about an entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitySummary {
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the entity.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the entity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the parent entity.</p>
    pub parent_entity_id: std::option::Option<std::string::String>,
    /// <p>The current status of the entity.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The description of the entity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether the entity has child entities or not.</p>
    pub has_child_entities: std::option::Option<bool>,
    /// <p>The date and time when the entity was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last date and time when the entity was updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl EntitySummary {
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the entity.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>The ARN of the entity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the parent entity.</p>
    pub fn parent_entity_id(&self) -> std::option::Option<&str> {
        self.parent_entity_id.as_deref()
    }
    /// <p>The current status of the entity.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The description of the entity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A Boolean value that specifies whether the entity has child entities or not.</p>
    pub fn has_child_entities(&self) -> std::option::Option<bool> {
        self.has_child_entities
    }
    /// <p>The date and time when the entity was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The last date and time when the entity was updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for EntitySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitySummary");
        formatter.field("entity_id", &self.entity_id);
        formatter.field("entity_name", &self.entity_name);
        formatter.field("arn", &self.arn);
        formatter.field("parent_entity_id", &self.parent_entity_id);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("has_child_entities", &self.has_child_entities);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`EntitySummary`](crate::model::EntitySummary)
pub mod entity_summary {
    /// A builder for [`EntitySummary`](crate::model::EntitySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) parent_entity_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) has_child_entities: std::option::Option<bool>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the parent entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_entity_id = input;
            self
        }
        /// <p>The current status of the entity.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the entity.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A Boolean value that specifies whether the entity has child entities or not.</p>
        pub fn has_child_entities(mut self, input: bool) -> Self {
            self.has_child_entities = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the entity has child entities or not.</p>
        pub fn set_has_child_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.has_child_entities = input;
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The last date and time when the entity was updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The last date and time when the entity was updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitySummary`](crate::model::EntitySummary)
        pub fn build(self) -> crate::model::EntitySummary {
            crate::model::EntitySummary {
                entity_id: self.entity_id,
                entity_name: self.entity_name,
                arn: self.arn,
                parent_entity_id: self.parent_entity_id,
                status: self.status,
                description: self.description,
                has_child_entities: self.has_child_entities,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl EntitySummary {
    /// Creates a new builder-style object to manufacture [`EntitySummary`](crate::model::EntitySummary)
    pub fn builder() -> crate::model::entity_summary::Builder {
        crate::model::entity_summary::Builder::default()
    }
}

/// <p>An object that represents the status of an entity, component, component type, or workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Status {
    /// <p>The current state of the entity, component, component type, or workspace.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The error message.</p>
    pub error: std::option::Option<crate::model::ErrorDetails>,
}
impl Status {
    /// <p>The current state of the entity, component, component type, or workspace.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for Status {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Status");
        formatter.field("state", &self.state);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`Status`](crate::model::Status)
pub mod status {
    /// A builder for [`Status`](crate::model::Status)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The current state of the entity, component, component type, or workspace.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the entity, component, component type, or workspace.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>The error message.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetails>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`Status`](crate::model::Status)
        pub fn build(self) -> crate::model::Status {
            crate::model::Status {
                state: self.state,
                error: self.error,
            }
        }
    }
}
impl Status {
    /// Creates a new builder-style object to manufacture [`Status`](crate::model::Status)
    pub fn builder() -> crate::model::status::Builder {
        crate::model::status::Builder::default()
    }
}

/// <p>The error details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetails {
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ErrorDetails {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ErrorDetails`](crate::model::ErrorDetails)
pub mod error_details {
    /// A builder for [`ErrorDetails`](crate::model::ErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetails`](crate::model::ErrorDetails)
        pub fn build(self) -> crate::model::ErrorDetails {
            crate::model::ErrorDetails {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::model::ErrorDetails)
    pub fn builder() -> crate::model::error_details::Builder {
        crate::model::error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_FAILURE" => ErrorCode::InternalFailure,
            "VALIDATION_ERROR" => ErrorCode::ValidationError,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::InternalFailure => "INTERNAL_FAILURE",
            ErrorCode::ValidationError => "VALIDATION_ERROR",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_FAILURE", "VALIDATION_ERROR"]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that filters items in a list of entities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ListEntitiesFilter {
    /// <p>The ID of the component type in the entities in the list.</p>
    ComponentTypeId(std::string::String),
    /// <p>The parent of the entities in the list.</p>
    ParentEntityId(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ListEntitiesFilter {
    /// Tries to convert the enum instance into [`ComponentTypeId`](crate::model::ListEntitiesFilter::ComponentTypeId), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_component_type_id(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ListEntitiesFilter::ComponentTypeId(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ComponentTypeId`](crate::model::ListEntitiesFilter::ComponentTypeId).
    pub fn is_component_type_id(&self) -> bool {
        self.as_component_type_id().is_ok()
    }
    /// Tries to convert the enum instance into [`ParentEntityId`](crate::model::ListEntitiesFilter::ParentEntityId), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_parent_entity_id(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ListEntitiesFilter::ParentEntityId(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ParentEntityId`](crate::model::ListEntitiesFilter::ParentEntityId).
    pub fn is_parent_entity_id(&self) -> bool {
        self.as_parent_entity_id().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>An object that contains information about a component type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentTypeSummary {
    /// <p>The ARN of the component type.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the component type was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the component type was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the component type.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl ComponentTypeSummary {
    /// <p>The ARN of the component type.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The date and time when the component type was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the component type was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The current status of the component type.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ComponentTypeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentTypeSummary");
        formatter.field("arn", &self.arn);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ComponentTypeSummary`](crate::model::ComponentTypeSummary)
pub mod component_type_summary {
    /// A builder for [`ComponentTypeSummary`](crate::model::ComponentTypeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The ARN of the component type.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The date and time when the component type was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the component type was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the component type was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the component type was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the component type.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the component type.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentTypeSummary`](crate::model::ComponentTypeSummary)
        pub fn build(self) -> crate::model::ComponentTypeSummary {
            crate::model::ComponentTypeSummary {
                arn: self.arn,
                component_type_id: self.component_type_id,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
                description: self.description,
                status: self.status,
            }
        }
    }
}
impl ComponentTypeSummary {
    /// Creates a new builder-style object to manufacture [`ComponentTypeSummary`](crate::model::ComponentTypeSummary)
    pub fn builder() -> crate::model::component_type_summary::Builder {
        crate::model::component_type_summary::Builder::default()
    }
}

/// <p>An object that filters items in a list of component types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ListComponentTypesFilter {
    /// <p>The component type that the component types in the list extend.</p>
    ExtendsFrom(std::string::String),
    /// <p>A Boolean value that specifies whether the component types in the list are abstract.</p>
    IsAbstract(bool),
    /// <p>The namespace to which the component types in the list belong.</p>
    Namespace(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ListComponentTypesFilter {
    /// Tries to convert the enum instance into [`ExtendsFrom`](crate::model::ListComponentTypesFilter::ExtendsFrom), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_extends_from(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ListComponentTypesFilter::ExtendsFrom(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ExtendsFrom`](crate::model::ListComponentTypesFilter::ExtendsFrom).
    pub fn is_extends_from(&self) -> bool {
        self.as_extends_from().is_ok()
    }
    /// Tries to convert the enum instance into [`IsAbstract`](crate::model::ListComponentTypesFilter::IsAbstract), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_is_abstract(&self) -> std::result::Result<&bool, &Self> {
        if let ListComponentTypesFilter::IsAbstract(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`IsAbstract`](crate::model::ListComponentTypesFilter::IsAbstract).
    pub fn is_is_abstract(&self) -> bool {
        self.as_is_abstract().is_ok()
    }
    /// Tries to convert the enum instance into [`Namespace`](crate::model::ListComponentTypesFilter::Namespace), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_namespace(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ListComponentTypesFilter::Namespace(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Namespace`](crate::model::ListComponentTypesFilter::Namespace).
    pub fn is_namespace(&self) -> bool {
        self.as_namespace().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The history of values for a time series property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyValueHistory {
    /// <p>An object that uniquely identifies an entity property.</p>
    pub entity_property_reference: std::option::Option<crate::model::EntityPropertyReference>,
    /// <p>A list of objects that contain information about the values in the history of a time series property.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
}
impl PropertyValueHistory {
    /// <p>An object that uniquely identifies an entity property.</p>
    pub fn entity_property_reference(
        &self,
    ) -> std::option::Option<&crate::model::EntityPropertyReference> {
        self.entity_property_reference.as_ref()
    }
    /// <p>A list of objects that contain information about the values in the history of a time series property.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::PropertyValue]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for PropertyValueHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyValueHistory");
        formatter.field("entity_property_reference", &self.entity_property_reference);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PropertyValueHistory`](crate::model::PropertyValueHistory)
pub mod property_value_history {
    /// A builder for [`PropertyValueHistory`](crate::model::PropertyValueHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_property_reference:
            std::option::Option<crate::model::EntityPropertyReference>,
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
    }
    impl Builder {
        /// <p>An object that uniquely identifies an entity property.</p>
        pub fn entity_property_reference(
            mut self,
            input: crate::model::EntityPropertyReference,
        ) -> Self {
            self.entity_property_reference = Some(input);
            self
        }
        /// <p>An object that uniquely identifies an entity property.</p>
        pub fn set_entity_property_reference(
            mut self,
            input: std::option::Option<crate::model::EntityPropertyReference>,
        ) -> Self {
            self.entity_property_reference = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of objects that contain information about the values in the history of a time series property.</p>
        pub fn values(mut self, input: crate::model::PropertyValue) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the values in the history of a time series property.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyValueHistory`](crate::model::PropertyValueHistory)
        pub fn build(self) -> crate::model::PropertyValueHistory {
            crate::model::PropertyValueHistory {
                entity_property_reference: self.entity_property_reference,
                values: self.values,
            }
        }
    }
}
impl PropertyValueHistory {
    /// Creates a new builder-style object to manufacture [`PropertyValueHistory`](crate::model::PropertyValueHistory)
    pub fn builder() -> crate::model::property_value_history::Builder {
        crate::model::property_value_history::Builder::default()
    }
}

/// <p>An object that contains information about a value for a time series property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyValue {
    /// <p>The timestamp of a value for a time series property.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An object that specifies a value for a time series property.</p>
    pub value: std::option::Option<crate::model::DataValue>,
}
impl PropertyValue {
    /// <p>The timestamp of a value for a time series property.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>An object that specifies a value for a time series property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for PropertyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyValue");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PropertyValue`](crate::model::PropertyValue)
pub mod property_value {
    /// A builder for [`PropertyValue`](crate::model::PropertyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) value: std::option::Option<crate::model::DataValue>,
    }
    impl Builder {
        /// <p>The timestamp of a value for a time series property.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp of a value for a time series property.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>An object that specifies a value for a time series property.</p>
        pub fn value(mut self, input: crate::model::DataValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>An object that specifies a value for a time series property.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::DataValue>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyValue`](crate::model::PropertyValue)
        pub fn build(self) -> crate::model::PropertyValue {
            crate::model::PropertyValue {
                timestamp: self.timestamp,
                value: self.value,
            }
        }
    }
}
impl PropertyValue {
    /// Creates a new builder-style object to manufacture [`PropertyValue`](crate::model::PropertyValue)
    pub fn builder() -> crate::model::property_value::Builder {
        crate::model::property_value::Builder::default()
    }
}

/// <p>An object that uniquely identifies an entity property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityPropertyReference {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>
    pub external_id_property:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the property.</p>
    pub property_name: std::option::Option<std::string::String>,
}
impl EntityPropertyReference {
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>
    pub fn external_id_property(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.external_id_property.as_ref()
    }
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the property.</p>
    pub fn property_name(&self) -> std::option::Option<&str> {
        self.property_name.as_deref()
    }
}
impl std::fmt::Debug for EntityPropertyReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityPropertyReference");
        formatter.field("component_name", &self.component_name);
        formatter.field("external_id_property", &self.external_id_property);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("property_name", &self.property_name);
        formatter.finish()
    }
}
/// See [`EntityPropertyReference`](crate::model::EntityPropertyReference)
pub mod entity_property_reference {
    /// A builder for [`EntityPropertyReference`](crate::model::EntityPropertyReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) external_id_property: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) property_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// Adds a key-value pair to `external_id_property`.
        ///
        /// To override the contents of this collection use [`set_external_id_property`](Self::set_external_id_property).
        ///
        /// <p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>
        pub fn external_id_property(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.external_id_property.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.external_id_property = Some(hash_map);
            self
        }
        /// <p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>
        pub fn set_external_id_property(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.external_id_property = input;
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the property.</p>
        pub fn property_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_name = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_property_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityPropertyReference`](crate::model::EntityPropertyReference)
        pub fn build(self) -> crate::model::EntityPropertyReference {
            crate::model::EntityPropertyReference {
                component_name: self.component_name,
                external_id_property: self.external_id_property,
                entity_id: self.entity_id,
                property_name: self.property_name,
            }
        }
    }
}
impl EntityPropertyReference {
    /// Creates a new builder-style object to manufacture [`EntityPropertyReference`](crate::model::EntityPropertyReference)
    pub fn builder() -> crate::model::entity_property_reference::Builder {
        crate::model::entity_property_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderByTime {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderByTime {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => OrderByTime::Ascending,
            "DESCENDING" => OrderByTime::Descending,
            other => OrderByTime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderByTime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderByTime::from(s))
    }
}
impl OrderByTime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderByTime::Ascending => "ASCENDING",
            OrderByTime::Descending => "DESCENDING",
            OrderByTime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for OrderByTime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that specifies how to interpolate data in a list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InterpolationParameters {
    /// <p>The interpolation type.</p>
    pub interpolation_type: std::option::Option<crate::model::InterpolationType>,
    /// <p>The interpolation time interval in seconds.</p>
    pub interval_in_seconds: std::option::Option<i64>,
}
impl InterpolationParameters {
    /// <p>The interpolation type.</p>
    pub fn interpolation_type(&self) -> std::option::Option<&crate::model::InterpolationType> {
        self.interpolation_type.as_ref()
    }
    /// <p>The interpolation time interval in seconds.</p>
    pub fn interval_in_seconds(&self) -> std::option::Option<i64> {
        self.interval_in_seconds
    }
}
impl std::fmt::Debug for InterpolationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InterpolationParameters");
        formatter.field("interpolation_type", &self.interpolation_type);
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.finish()
    }
}
/// See [`InterpolationParameters`](crate::model::InterpolationParameters)
pub mod interpolation_parameters {
    /// A builder for [`InterpolationParameters`](crate::model::InterpolationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interpolation_type: std::option::Option<crate::model::InterpolationType>,
        pub(crate) interval_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The interpolation type.</p>
        pub fn interpolation_type(mut self, input: crate::model::InterpolationType) -> Self {
            self.interpolation_type = Some(input);
            self
        }
        /// <p>The interpolation type.</p>
        pub fn set_interpolation_type(
            mut self,
            input: std::option::Option<crate::model::InterpolationType>,
        ) -> Self {
            self.interpolation_type = input;
            self
        }
        /// <p>The interpolation time interval in seconds.</p>
        pub fn interval_in_seconds(mut self, input: i64) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        /// <p>The interpolation time interval in seconds.</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InterpolationParameters`](crate::model::InterpolationParameters)
        pub fn build(self) -> crate::model::InterpolationParameters {
            crate::model::InterpolationParameters {
                interpolation_type: self.interpolation_type,
                interval_in_seconds: self.interval_in_seconds,
            }
        }
    }
}
impl InterpolationParameters {
    /// Creates a new builder-style object to manufacture [`InterpolationParameters`](crate::model::InterpolationParameters)
    pub fn builder() -> crate::model::interpolation_parameters::Builder {
        crate::model::interpolation_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InterpolationType {
    #[allow(missing_docs)] // documentation missing in model
    Linear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InterpolationType {
    fn from(s: &str) -> Self {
        match s {
            "LINEAR" => InterpolationType::Linear,
            other => InterpolationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InterpolationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InterpolationType::from(s))
    }
}
impl InterpolationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InterpolationType::Linear => "LINEAR",
            InterpolationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINEAR"]
    }
}
impl AsRef<str> for InterpolationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that filters items returned by a property request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyFilter {
    /// <p>The property name associated with this property filter.</p>
    pub property_name: std::option::Option<std::string::String>,
    /// <p>The operator associated with this property filter.</p>
    pub operator: std::option::Option<std::string::String>,
    /// <p>The value associated with this property filter.</p>
    pub value: std::option::Option<crate::model::DataValue>,
}
impl PropertyFilter {
    /// <p>The property name associated with this property filter.</p>
    pub fn property_name(&self) -> std::option::Option<&str> {
        self.property_name.as_deref()
    }
    /// <p>The operator associated with this property filter.</p>
    pub fn operator(&self) -> std::option::Option<&str> {
        self.operator.as_deref()
    }
    /// <p>The value associated with this property filter.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for PropertyFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyFilter");
        formatter.field("property_name", &self.property_name);
        formatter.field("operator", &self.operator);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PropertyFilter`](crate::model::PropertyFilter)
pub mod property_filter {
    /// A builder for [`PropertyFilter`](crate::model::PropertyFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_name: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::DataValue>,
    }
    impl Builder {
        /// <p>The property name associated with this property filter.</p>
        pub fn property_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_name = Some(input.into());
            self
        }
        /// <p>The property name associated with this property filter.</p>
        pub fn set_property_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_name = input;
            self
        }
        /// <p>The operator associated with this property filter.</p>
        pub fn operator(mut self, input: impl Into<std::string::String>) -> Self {
            self.operator = Some(input.into());
            self
        }
        /// <p>The operator associated with this property filter.</p>
        pub fn set_operator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operator = input;
            self
        }
        /// <p>The value associated with this property filter.</p>
        pub fn value(mut self, input: crate::model::DataValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value associated with this property filter.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::DataValue>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyFilter`](crate::model::PropertyFilter)
        pub fn build(self) -> crate::model::PropertyFilter {
            crate::model::PropertyFilter {
                property_name: self.property_name,
                operator: self.operator,
                value: self.value,
            }
        }
    }
}
impl PropertyFilter {
    /// Creates a new builder-style object to manufacture [`PropertyFilter`](crate::model::PropertyFilter)
    pub fn builder() -> crate::model::property_filter::Builder {
        crate::model::property_filter::Builder::default()
    }
}

/// <p>The latest value of the property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyLatestValue {
    /// <p>An object that specifies information about a property.&gt;</p>
    pub property_reference: std::option::Option<crate::model::EntityPropertyReference>,
    /// <p>The value of the property.</p>
    pub property_value: std::option::Option<crate::model::DataValue>,
}
impl PropertyLatestValue {
    /// <p>An object that specifies information about a property.&gt;</p>
    pub fn property_reference(
        &self,
    ) -> std::option::Option<&crate::model::EntityPropertyReference> {
        self.property_reference.as_ref()
    }
    /// <p>The value of the property.</p>
    pub fn property_value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.property_value.as_ref()
    }
}
impl std::fmt::Debug for PropertyLatestValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyLatestValue");
        formatter.field("property_reference", &self.property_reference);
        formatter.field("property_value", &self.property_value);
        formatter.finish()
    }
}
/// See [`PropertyLatestValue`](crate::model::PropertyLatestValue)
pub mod property_latest_value {
    /// A builder for [`PropertyLatestValue`](crate::model::PropertyLatestValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_reference: std::option::Option<crate::model::EntityPropertyReference>,
        pub(crate) property_value: std::option::Option<crate::model::DataValue>,
    }
    impl Builder {
        /// <p>An object that specifies information about a property.&gt;</p>
        pub fn property_reference(mut self, input: crate::model::EntityPropertyReference) -> Self {
            self.property_reference = Some(input);
            self
        }
        /// <p>An object that specifies information about a property.&gt;</p>
        pub fn set_property_reference(
            mut self,
            input: std::option::Option<crate::model::EntityPropertyReference>,
        ) -> Self {
            self.property_reference = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn property_value(mut self, input: crate::model::DataValue) -> Self {
            self.property_value = Some(input);
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_property_value(
            mut self,
            input: std::option::Option<crate::model::DataValue>,
        ) -> Self {
            self.property_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyLatestValue`](crate::model::PropertyLatestValue)
        pub fn build(self) -> crate::model::PropertyLatestValue {
            crate::model::PropertyLatestValue {
                property_reference: self.property_reference,
                property_value: self.property_value,
            }
        }
    }
}
impl PropertyLatestValue {
    /// Creates a new builder-style object to manufacture [`PropertyLatestValue`](crate::model::PropertyLatestValue)
    pub fn builder() -> crate::model::property_latest_value::Builder {
        crate::model::property_latest_value::Builder::default()
    }
}

/// <p>An object that returns information about a component type create or update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentResponse {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The status of the component type.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The name of the property definition set in the request.</p>
    pub defined_in: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyResponse>,
    >,
}
impl ComponentResponse {
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The status of the component type.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The name of the property definition set in the request.</p>
    pub fn defined_in(&self) -> std::option::Option<&str> {
        self.defined_in.as_deref()
    }
    /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyResponse>,
    > {
        self.properties.as_ref()
    }
}
impl std::fmt::Debug for ComponentResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentResponse");
        formatter.field("component_name", &self.component_name);
        formatter.field("description", &self.description);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("status", &self.status);
        formatter.field("defined_in", &self.defined_in);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`ComponentResponse`](crate::model::ComponentResponse)
pub mod component_response {
    /// A builder for [`ComponentResponse`](crate::model::ComponentResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) defined_in: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyResponse>,
        >,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The status of the component type.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the component type.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the property definition set in the request.</p>
        pub fn defined_in(mut self, input: impl Into<std::string::String>) -> Self {
            self.defined_in = Some(input.into());
            self
        }
        /// <p>The name of the property definition set in the request.</p>
        pub fn set_defined_in(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.defined_in = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyResponse,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PropertyResponse>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentResponse`](crate::model::ComponentResponse)
        pub fn build(self) -> crate::model::ComponentResponse {
            crate::model::ComponentResponse {
                component_name: self.component_name,
                description: self.description,
                component_type_id: self.component_type_id,
                status: self.status,
                defined_in: self.defined_in,
                properties: self.properties,
            }
        }
    }
}
impl ComponentResponse {
    /// Creates a new builder-style object to manufacture [`ComponentResponse`](crate::model::ComponentResponse)
    pub fn builder() -> crate::model::component_response::Builder {
        crate::model::component_response::Builder::default()
    }
}

/// <p>An object that contains information about a property response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyResponse {
    /// <p>An object that specifies information about a property.</p>
    pub definition: std::option::Option<crate::model::PropertyDefinitionResponse>,
    /// <p>The value of the property.</p>
    pub value: std::option::Option<crate::model::DataValue>,
}
impl PropertyResponse {
    /// <p>An object that specifies information about a property.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::PropertyDefinitionResponse> {
        self.definition.as_ref()
    }
    /// <p>The value of the property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for PropertyResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyResponse");
        formatter.field("definition", &self.definition);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PropertyResponse`](crate::model::PropertyResponse)
pub mod property_response {
    /// A builder for [`PropertyResponse`](crate::model::PropertyResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<crate::model::PropertyDefinitionResponse>,
        pub(crate) value: std::option::Option<crate::model::DataValue>,
    }
    impl Builder {
        /// <p>An object that specifies information about a property.</p>
        pub fn definition(mut self, input: crate::model::PropertyDefinitionResponse) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>An object that specifies information about a property.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::PropertyDefinitionResponse>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn value(mut self, input: crate::model::DataValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::DataValue>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyResponse`](crate::model::PropertyResponse)
        pub fn build(self) -> crate::model::PropertyResponse {
            crate::model::PropertyResponse {
                definition: self.definition,
                value: self.value,
            }
        }
    }
}
impl PropertyResponse {
    /// Creates a new builder-style object to manufacture [`PropertyResponse`](crate::model::PropertyResponse)
    pub fn builder() -> crate::model::property_response::Builder {
        crate::model::property_response::Builder::default()
    }
}

/// <p>An object that contains response data from a property definition request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyDefinitionResponse {
    /// <p>An object that contains information about the data type.</p>
    pub data_type: std::option::Option<crate::model::DataType>,
    /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
    pub is_time_series: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property is required in an entity.</p>
    pub is_required_in_entity: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
    pub is_external_id: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property is stored externally.</p>
    pub is_stored_externally: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>
    pub is_imported: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property definition can be updated.</p>
    pub is_final: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>
    pub is_inherited: std::option::Option<bool>,
    /// <p>An object that contains the default value.</p>
    pub default_value: std::option::Option<crate::model::DataValue>,
    /// <p>A mapping that specifies configuration information about the property.</p>
    pub configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PropertyDefinitionResponse {
    /// <p>An object that contains information about the data type.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::DataType> {
        self.data_type.as_ref()
    }
    /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
    pub fn is_time_series(&self) -> std::option::Option<bool> {
        self.is_time_series
    }
    /// <p>A Boolean value that specifies whether the property is required in an entity.</p>
    pub fn is_required_in_entity(&self) -> std::option::Option<bool> {
        self.is_required_in_entity
    }
    /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
    pub fn is_external_id(&self) -> std::option::Option<bool> {
        self.is_external_id
    }
    /// <p>A Boolean value that specifies whether the property is stored externally.</p>
    pub fn is_stored_externally(&self) -> std::option::Option<bool> {
        self.is_stored_externally
    }
    /// <p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>
    pub fn is_imported(&self) -> std::option::Option<bool> {
        self.is_imported
    }
    /// <p>A Boolean value that specifies whether the property definition can be updated.</p>
    pub fn is_final(&self) -> std::option::Option<bool> {
        self.is_final
    }
    /// <p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>
    pub fn is_inherited(&self) -> std::option::Option<bool> {
        self.is_inherited
    }
    /// <p>An object that contains the default value.</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::DataValue> {
        self.default_value.as_ref()
    }
    /// <p>A mapping that specifies configuration information about the property.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for PropertyDefinitionResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyDefinitionResponse");
        formatter.field("data_type", &self.data_type);
        formatter.field("is_time_series", &self.is_time_series);
        formatter.field("is_required_in_entity", &self.is_required_in_entity);
        formatter.field("is_external_id", &self.is_external_id);
        formatter.field("is_stored_externally", &self.is_stored_externally);
        formatter.field("is_imported", &self.is_imported);
        formatter.field("is_final", &self.is_final);
        formatter.field("is_inherited", &self.is_inherited);
        formatter.field("default_value", &self.default_value);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`PropertyDefinitionResponse`](crate::model::PropertyDefinitionResponse)
pub mod property_definition_response {
    /// A builder for [`PropertyDefinitionResponse`](crate::model::PropertyDefinitionResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_type: std::option::Option<crate::model::DataType>,
        pub(crate) is_time_series: std::option::Option<bool>,
        pub(crate) is_required_in_entity: std::option::Option<bool>,
        pub(crate) is_external_id: std::option::Option<bool>,
        pub(crate) is_stored_externally: std::option::Option<bool>,
        pub(crate) is_imported: std::option::Option<bool>,
        pub(crate) is_final: std::option::Option<bool>,
        pub(crate) is_inherited: std::option::Option<bool>,
        pub(crate) default_value: std::option::Option<crate::model::DataValue>,
        pub(crate) configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>An object that contains information about the data type.</p>
        pub fn data_type(mut self, input: crate::model::DataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>An object that contains information about the data type.</p>
        pub fn set_data_type(mut self, input: std::option::Option<crate::model::DataType>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
        pub fn is_time_series(mut self, input: bool) -> Self {
            self.is_time_series = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property consists of time series data.</p>
        pub fn set_is_time_series(mut self, input: std::option::Option<bool>) -> Self {
            self.is_time_series = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property is required in an entity.</p>
        pub fn is_required_in_entity(mut self, input: bool) -> Self {
            self.is_required_in_entity = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property is required in an entity.</p>
        pub fn set_is_required_in_entity(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required_in_entity = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
        pub fn is_external_id(mut self, input: bool) -> Self {
            self.is_external_id = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property ID comes from an external data store.</p>
        pub fn set_is_external_id(mut self, input: std::option::Option<bool>) -> Self {
            self.is_external_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property is stored externally.</p>
        pub fn is_stored_externally(mut self, input: bool) -> Self {
            self.is_stored_externally = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property is stored externally.</p>
        pub fn set_is_stored_externally(mut self, input: std::option::Option<bool>) -> Self {
            self.is_stored_externally = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>
        pub fn is_imported(mut self, input: bool) -> Self {
            self.is_imported = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>
        pub fn set_is_imported(mut self, input: std::option::Option<bool>) -> Self {
            self.is_imported = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property definition can be updated.</p>
        pub fn is_final(mut self, input: bool) -> Self {
            self.is_final = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property definition can be updated.</p>
        pub fn set_is_final(mut self, input: std::option::Option<bool>) -> Self {
            self.is_final = input;
            self
        }
        /// <p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>
        pub fn is_inherited(mut self, input: bool) -> Self {
            self.is_inherited = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>
        pub fn set_is_inherited(mut self, input: std::option::Option<bool>) -> Self {
            self.is_inherited = input;
            self
        }
        /// <p>An object that contains the default value.</p>
        pub fn default_value(mut self, input: crate::model::DataValue) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>An object that contains the default value.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::DataValue>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Adds a key-value pair to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>A mapping that specifies configuration information about the property.</p>
        pub fn configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration = Some(hash_map);
            self
        }
        /// <p>A mapping that specifies configuration information about the property.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyDefinitionResponse`](crate::model::PropertyDefinitionResponse)
        pub fn build(self) -> crate::model::PropertyDefinitionResponse {
            crate::model::PropertyDefinitionResponse {
                data_type: self.data_type,
                is_time_series: self.is_time_series,
                is_required_in_entity: self.is_required_in_entity,
                is_external_id: self.is_external_id,
                is_stored_externally: self.is_stored_externally,
                is_imported: self.is_imported,
                is_final: self.is_final,
                is_inherited: self.is_inherited,
                default_value: self.default_value,
                configuration: self.configuration,
            }
        }
    }
}
impl PropertyDefinitionResponse {
    /// Creates a new builder-style object to manufacture [`PropertyDefinitionResponse`](crate::model::PropertyDefinitionResponse)
    pub fn builder() -> crate::model::property_definition_response::Builder {
        crate::model::property_definition_response::Builder::default()
    }
}

/// <p>The function response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionResponse {
    /// <p>The required properties of the function.</p>
    pub required_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The scope of the function.</p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p>The data connector.</p>
    pub implemented_by: std::option::Option<crate::model::DataConnector>,
    /// <p>Indicates whether this function is inherited.</p>
    pub is_inherited: std::option::Option<bool>,
}
impl FunctionResponse {
    /// <p>The required properties of the function.</p>
    pub fn required_properties(&self) -> std::option::Option<&std::vec::Vec<std::string::String>> {
        self.required_properties.as_ref()
    }
    /// <p>The scope of the function.</p>
    pub fn scope(&self) -> std::option::Option<&crate::model::Scope> {
        self.scope.as_ref()
    }
    /// <p>The data connector.</p>
    pub fn implemented_by(&self) -> std::option::Option<&crate::model::DataConnector> {
        self.implemented_by.as_ref()
    }
    /// <p>Indicates whether this function is inherited.</p>
    pub fn is_inherited(&self) -> std::option::Option<bool> {
        self.is_inherited
    }
}
impl std::fmt::Debug for FunctionResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionResponse");
        formatter.field("required_properties", &self.required_properties);
        formatter.field("scope", &self.scope);
        formatter.field("implemented_by", &self.implemented_by);
        formatter.field("is_inherited", &self.is_inherited);
        formatter.finish()
    }
}
/// See [`FunctionResponse`](crate::model::FunctionResponse)
pub mod function_response {
    /// A builder for [`FunctionResponse`](crate::model::FunctionResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) required_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) implemented_by: std::option::Option<crate::model::DataConnector>,
        pub(crate) is_inherited: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The required properties of the function.</p>
        pub fn required_properties(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.required_properties = Some(input);
            self
        }
        /// <p>The required properties of the function.</p>
        pub fn set_required_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.required_properties = input;
            self
        }
        /// <p>The scope of the function.</p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope of the function.</p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// <p>The data connector.</p>
        pub fn implemented_by(mut self, input: crate::model::DataConnector) -> Self {
            self.implemented_by = Some(input);
            self
        }
        /// <p>The data connector.</p>
        pub fn set_implemented_by(
            mut self,
            input: std::option::Option<crate::model::DataConnector>,
        ) -> Self {
            self.implemented_by = input;
            self
        }
        /// <p>Indicates whether this function is inherited.</p>
        pub fn is_inherited(mut self, input: bool) -> Self {
            self.is_inherited = Some(input);
            self
        }
        /// <p>Indicates whether this function is inherited.</p>
        pub fn set_is_inherited(mut self, input: std::option::Option<bool>) -> Self {
            self.is_inherited = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionResponse`](crate::model::FunctionResponse)
        pub fn build(self) -> crate::model::FunctionResponse {
            crate::model::FunctionResponse {
                required_properties: self.required_properties,
                scope: self.scope,
                implemented_by: self.implemented_by,
                is_inherited: self.is_inherited,
            }
        }
    }
}
impl FunctionResponse {
    /// Creates a new builder-style object to manufacture [`FunctionResponse`](crate::model::FunctionResponse)
    pub fn builder() -> crate::model::function_response::Builder {
        crate::model::function_response::Builder::default()
    }
}

/// <p>An object that sets information about a component type create or update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentRequest {
    /// <p>The description of the component request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
    pub properties: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
    >,
}
impl ComponentRequest {
    /// <p>The description of the component request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
    > {
        self.properties.as_ref()
    }
}
impl std::fmt::Debug for ComponentRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentRequest");
        formatter.field("description", &self.description);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`ComponentRequest`](crate::model::ComponentRequest)
pub mod component_request {
    /// A builder for [`ComponentRequest`](crate::model::ComponentRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
        >,
    }
    impl Builder {
        /// <p>The description of the component request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyRequest,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.properties = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PropertyRequest>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentRequest`](crate::model::ComponentRequest)
        pub fn build(self) -> crate::model::ComponentRequest {
            crate::model::ComponentRequest {
                description: self.description,
                component_type_id: self.component_type_id,
                properties: self.properties,
            }
        }
    }
}
impl ComponentRequest {
    /// Creates a new builder-style object to manufacture [`ComponentRequest`](crate::model::ComponentRequest)
    pub fn builder() -> crate::model::component_request::Builder {
        crate::model::component_request::Builder::default()
    }
}

/// <p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutPropertyErrorEntry {
    /// <p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyError>>,
}
impl BatchPutPropertyErrorEntry {
    /// <p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchPutPropertyError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchPutPropertyErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutPropertyErrorEntry");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchPutPropertyErrorEntry`](crate::model::BatchPutPropertyErrorEntry)
pub mod batch_put_property_error_entry {
    /// A builder for [`BatchPutPropertyErrorEntry`](crate::model::BatchPutPropertyErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>
        pub fn errors(mut self, input: crate::model::BatchPutPropertyError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutPropertyErrorEntry`](crate::model::BatchPutPropertyErrorEntry)
        pub fn build(self) -> crate::model::BatchPutPropertyErrorEntry {
            crate::model::BatchPutPropertyErrorEntry {
                errors: self.errors,
            }
        }
    }
}
impl BatchPutPropertyErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchPutPropertyErrorEntry`](crate::model::BatchPutPropertyErrorEntry)
    pub fn builder() -> crate::model::batch_put_property_error_entry::Builder {
        crate::model::batch_put_property_error_entry::Builder::default()
    }
}

/// <p>An error returned by the <code>BatchPutProperty</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutPropertyError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>
    pub entry: std::option::Option<crate::model::PropertyValueEntry>,
}
impl BatchPutPropertyError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>
    pub fn entry(&self) -> std::option::Option<&crate::model::PropertyValueEntry> {
        self.entry.as_ref()
    }
}
impl std::fmt::Debug for BatchPutPropertyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutPropertyError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("entry", &self.entry);
        formatter.finish()
    }
}
/// See [`BatchPutPropertyError`](crate::model::BatchPutPropertyError)
pub mod batch_put_property_error {
    /// A builder for [`BatchPutPropertyError`](crate::model::BatchPutPropertyError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) entry: std::option::Option<crate::model::PropertyValueEntry>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>
        pub fn entry(mut self, input: crate::model::PropertyValueEntry) -> Self {
            self.entry = Some(input);
            self
        }
        /// <p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>
        pub fn set_entry(
            mut self,
            input: std::option::Option<crate::model::PropertyValueEntry>,
        ) -> Self {
            self.entry = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutPropertyError`](crate::model::BatchPutPropertyError)
        pub fn build(self) -> crate::model::BatchPutPropertyError {
            crate::model::BatchPutPropertyError {
                error_code: self.error_code,
                error_message: self.error_message,
                entry: self.entry,
            }
        }
    }
}
impl BatchPutPropertyError {
    /// Creates a new builder-style object to manufacture [`BatchPutPropertyError`](crate::model::BatchPutPropertyError)
    pub fn builder() -> crate::model::batch_put_property_error::Builder {
        crate::model::batch_put_property_error::Builder::default()
    }
}

/// <p>An object that specifies information about time series property values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyValueEntry {
    /// <p>An object that contains information about the entity that has the property.</p>
    pub entity_property_reference: std::option::Option<crate::model::EntityPropertyReference>,
    /// <p>A list of objects that specify time series property values.</p>
    pub property_values: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
}
impl PropertyValueEntry {
    /// <p>An object that contains information about the entity that has the property.</p>
    pub fn entity_property_reference(
        &self,
    ) -> std::option::Option<&crate::model::EntityPropertyReference> {
        self.entity_property_reference.as_ref()
    }
    /// <p>A list of objects that specify time series property values.</p>
    pub fn property_values(&self) -> std::option::Option<&[crate::model::PropertyValue]> {
        self.property_values.as_deref()
    }
}
impl std::fmt::Debug for PropertyValueEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyValueEntry");
        formatter.field("entity_property_reference", &self.entity_property_reference);
        formatter.field("property_values", &self.property_values);
        formatter.finish()
    }
}
/// See [`PropertyValueEntry`](crate::model::PropertyValueEntry)
pub mod property_value_entry {
    /// A builder for [`PropertyValueEntry`](crate::model::PropertyValueEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_property_reference:
            std::option::Option<crate::model::EntityPropertyReference>,
        pub(crate) property_values: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
    }
    impl Builder {
        /// <p>An object that contains information about the entity that has the property.</p>
        pub fn entity_property_reference(
            mut self,
            input: crate::model::EntityPropertyReference,
        ) -> Self {
            self.entity_property_reference = Some(input);
            self
        }
        /// <p>An object that contains information about the entity that has the property.</p>
        pub fn set_entity_property_reference(
            mut self,
            input: std::option::Option<crate::model::EntityPropertyReference>,
        ) -> Self {
            self.entity_property_reference = input;
            self
        }
        /// Appends an item to `property_values`.
        ///
        /// To override the contents of this collection use [`set_property_values`](Self::set_property_values).
        ///
        /// <p>A list of objects that specify time series property values.</p>
        pub fn property_values(mut self, input: crate::model::PropertyValue) -> Self {
            let mut v = self.property_values.unwrap_or_default();
            v.push(input);
            self.property_values = Some(v);
            self
        }
        /// <p>A list of objects that specify time series property values.</p>
        pub fn set_property_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValue>>,
        ) -> Self {
            self.property_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyValueEntry`](crate::model::PropertyValueEntry)
        pub fn build(self) -> crate::model::PropertyValueEntry {
            crate::model::PropertyValueEntry {
                entity_property_reference: self.entity_property_reference,
                property_values: self.property_values,
            }
        }
    }
}
impl PropertyValueEntry {
    /// Creates a new builder-style object to manufacture [`PropertyValueEntry`](crate::model::PropertyValueEntry)
    pub fn builder() -> crate::model::property_value_entry::Builder {
        crate::model::property_value_entry::Builder::default()
    }
}
