// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceOutput {
    /// <p>The date and time of the current update.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateWorkspaceOutput {
    /// <p>The date and time of the current update.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceOutput");
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
pub mod update_workspace_output {
    /// A builder for [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time of the current update.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time of the current update.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
        pub fn build(self) -> crate::output::UpdateWorkspaceOutput {
            crate::output::UpdateWorkspaceOutput {
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl UpdateWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
    pub fn builder() -> crate::output::update_workspace_output::Builder {
        crate::output::update_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSceneOutput {
    /// <p>The date and time when the scene was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateSceneOutput {
    /// <p>The date and time when the scene was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateSceneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSceneOutput");
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`UpdateSceneOutput`](crate::output::UpdateSceneOutput)
pub mod update_scene_output {
    /// A builder for [`UpdateSceneOutput`](crate::output::UpdateSceneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time when the scene was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSceneOutput`](crate::output::UpdateSceneOutput)
        pub fn build(self) -> crate::output::UpdateSceneOutput {
            crate::output::UpdateSceneOutput {
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl UpdateSceneOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSceneOutput`](crate::output::UpdateSceneOutput)
    pub fn builder() -> crate::output::update_scene_output::Builder {
        crate::output::update_scene_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEntityOutput {
    /// <p>The date and time when the entity was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the entity update.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl UpdateEntityOutput {
    /// <p>The date and time when the entity was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>The current state of the entity update.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for UpdateEntityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEntityOutput");
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`UpdateEntityOutput`](crate::output::UpdateEntityOutput)
pub mod update_entity_output {
    /// A builder for [`UpdateEntityOutput`](crate::output::UpdateEntityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The date and time when the entity was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>The current state of the entity update.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the entity update.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEntityOutput`](crate::output::UpdateEntityOutput)
        pub fn build(self) -> crate::output::UpdateEntityOutput {
            crate::output::UpdateEntityOutput {
                update_date_time: self.update_date_time,
                state: self.state,
            }
        }
    }
}
impl UpdateEntityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEntityOutput`](crate::output::UpdateEntityOutput)
    pub fn builder() -> crate::output::update_entity_output::Builder {
        crate::output::update_entity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentTypeOutput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the component type.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The current state of the component type.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl UpdateComponentTypeOutput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ARN of the component type.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The current state of the component type.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for UpdateComponentTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentTypeOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("arn", &self.arn);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`UpdateComponentTypeOutput`](crate::output::UpdateComponentTypeOutput)
pub mod update_component_type_output {
    /// A builder for [`UpdateComponentTypeOutput`](crate::output::UpdateComponentTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The current state of the component type.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the component type.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentTypeOutput`](crate::output::UpdateComponentTypeOutput)
        pub fn build(self) -> crate::output::UpdateComponentTypeOutput {
            crate::output::UpdateComponentTypeOutput {
                workspace_id: self.workspace_id,
                arn: self.arn,
                component_type_id: self.component_type_id,
                state: self.state,
            }
        }
    }
}
impl UpdateComponentTypeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateComponentTypeOutput`](crate::output::UpdateComponentTypeOutput)
    pub fn builder() -> crate::output::update_component_type_output::Builder {
        crate::output::update_component_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkspacesOutput {
    /// <p>A list of objects that contain information about the workspaces.</p>
    pub workspace_summaries: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkspacesOutput {
    /// <p>A list of objects that contain information about the workspaces.</p>
    pub fn workspace_summaries(&self) -> std::option::Option<&[crate::model::WorkspaceSummary]> {
        self.workspace_summaries.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkspacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkspacesOutput");
        formatter.field("workspace_summaries", &self.workspace_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
pub mod list_workspaces_output {
    /// A builder for [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_summaries:
            std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workspace_summaries`.
        ///
        /// To override the contents of this collection use [`set_workspace_summaries`](Self::set_workspace_summaries).
        ///
        /// <p>A list of objects that contain information about the workspaces.</p>
        pub fn workspace_summaries(mut self, input: crate::model::WorkspaceSummary) -> Self {
            let mut v = self.workspace_summaries.unwrap_or_default();
            v.push(input);
            self.workspace_summaries = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the workspaces.</p>
        pub fn set_workspace_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        ) -> Self {
            self.workspace_summaries = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
        pub fn build(self) -> crate::output::ListWorkspacesOutput {
            crate::output::ListWorkspacesOutput {
                workspace_summaries: self.workspace_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkspacesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    pub fn builder() -> crate::output::list_workspaces_output::Builder {
        crate::output::list_workspaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Metadata that you can use to manage a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>Metadata that you can use to manage a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can use to manage a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListScenesOutput {
    /// <p>A list of objects that contain information about the scenes.</p>
    pub scene_summaries: std::option::Option<std::vec::Vec<crate::model::SceneSummary>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListScenesOutput {
    /// <p>A list of objects that contain information about the scenes.</p>
    pub fn scene_summaries(&self) -> std::option::Option<&[crate::model::SceneSummary]> {
        self.scene_summaries.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListScenesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListScenesOutput");
        formatter.field("scene_summaries", &self.scene_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListScenesOutput`](crate::output::ListScenesOutput)
pub mod list_scenes_output {
    /// A builder for [`ListScenesOutput`](crate::output::ListScenesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scene_summaries: std::option::Option<std::vec::Vec<crate::model::SceneSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scene_summaries`.
        ///
        /// To override the contents of this collection use [`set_scene_summaries`](Self::set_scene_summaries).
        ///
        /// <p>A list of objects that contain information about the scenes.</p>
        pub fn scene_summaries(mut self, input: crate::model::SceneSummary) -> Self {
            let mut v = self.scene_summaries.unwrap_or_default();
            v.push(input);
            self.scene_summaries = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the scenes.</p>
        pub fn set_scene_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SceneSummary>>,
        ) -> Self {
            self.scene_summaries = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListScenesOutput`](crate::output::ListScenesOutput)
        pub fn build(self) -> crate::output::ListScenesOutput {
            crate::output::ListScenesOutput {
                scene_summaries: self.scene_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListScenesOutput {
    /// Creates a new builder-style object to manufacture [`ListScenesOutput`](crate::output::ListScenesOutput)
    pub fn builder() -> crate::output::list_scenes_output::Builder {
        crate::output::list_scenes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitiesOutput {
    /// <p>A list of objects that contain information about the entities.</p>
    pub entity_summaries: std::option::Option<std::vec::Vec<crate::model::EntitySummary>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEntitiesOutput {
    /// <p>A list of objects that contain information about the entities.</p>
    pub fn entity_summaries(&self) -> std::option::Option<&[crate::model::EntitySummary]> {
        self.entity_summaries.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEntitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitiesOutput");
        formatter.field("entity_summaries", &self.entity_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEntitiesOutput`](crate::output::ListEntitiesOutput)
pub mod list_entities_output {
    /// A builder for [`ListEntitiesOutput`](crate::output::ListEntitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_summaries:
            std::option::Option<std::vec::Vec<crate::model::EntitySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entity_summaries`.
        ///
        /// To override the contents of this collection use [`set_entity_summaries`](Self::set_entity_summaries).
        ///
        /// <p>A list of objects that contain information about the entities.</p>
        pub fn entity_summaries(mut self, input: crate::model::EntitySummary) -> Self {
            let mut v = self.entity_summaries.unwrap_or_default();
            v.push(input);
            self.entity_summaries = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the entities.</p>
        pub fn set_entity_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitySummary>>,
        ) -> Self {
            self.entity_summaries = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesOutput`](crate::output::ListEntitiesOutput)
        pub fn build(self) -> crate::output::ListEntitiesOutput {
            crate::output::ListEntitiesOutput {
                entity_summaries: self.entity_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEntitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListEntitiesOutput`](crate::output::ListEntitiesOutput)
    pub fn builder() -> crate::output::list_entities_output::Builder {
        crate::output::list_entities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentTypesOutput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A list of objects that contain information about the component types.</p>
    pub component_type_summaries:
        std::option::Option<std::vec::Vec<crate::model::ComponentTypeSummary>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListComponentTypesOutput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A list of objects that contain information about the component types.</p>
    pub fn component_type_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ComponentTypeSummary]> {
        self.component_type_summaries.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListComponentTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentTypesOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("component_type_summaries", &self.component_type_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
/// See [`ListComponentTypesOutput`](crate::output::ListComponentTypesOutput)
pub mod list_component_types_output {
    /// A builder for [`ListComponentTypesOutput`](crate::output::ListComponentTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) component_type_summaries:
            std::option::Option<std::vec::Vec<crate::model::ComponentTypeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Appends an item to `component_type_summaries`.
        ///
        /// To override the contents of this collection use [`set_component_type_summaries`](Self::set_component_type_summaries).
        ///
        /// <p>A list of objects that contain information about the component types.</p>
        pub fn component_type_summaries(
            mut self,
            input: crate::model::ComponentTypeSummary,
        ) -> Self {
            let mut v = self.component_type_summaries.unwrap_or_default();
            v.push(input);
            self.component_type_summaries = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the component types.</p>
        pub fn set_component_type_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentTypeSummary>>,
        ) -> Self {
            self.component_type_summaries = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentTypesOutput`](crate::output::ListComponentTypesOutput)
        pub fn build(self) -> crate::output::ListComponentTypesOutput {
            crate::output::ListComponentTypesOutput {
                workspace_id: self.workspace_id,
                component_type_summaries: self.component_type_summaries,
                next_token: self.next_token,
                max_results: self.max_results,
            }
        }
    }
}
impl ListComponentTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentTypesOutput`](crate::output::ListComponentTypesOutput)
    pub fn builder() -> crate::output::list_component_types_output::Builder {
        crate::output::list_component_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkspaceOutput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the workspace.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    pub s3_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The date and time when the workspace was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the workspace was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetWorkspaceOutput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ARN of the workspace.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    pub fn s3_location(&self) -> std::option::Option<&str> {
        self.s3_location.as_deref()
    }
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The date and time when the workspace was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the workspace was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for GetWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkspaceOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("s3_location", &self.s3_location);
        formatter.field("role", &self.role);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`GetWorkspaceOutput`](crate::output::GetWorkspaceOutput)
pub mod get_workspace_output {
    /// A builder for [`GetWorkspaceOutput`](crate::output::GetWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) s3_location: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ARN of the workspace.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the workspace.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_location = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn set_s3_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_location = input;
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the workspace was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the workspace was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkspaceOutput`](crate::output::GetWorkspaceOutput)
        pub fn build(self) -> crate::output::GetWorkspaceOutput {
            crate::output::GetWorkspaceOutput {
                workspace_id: self.workspace_id,
                arn: self.arn,
                description: self.description,
                s3_location: self.s3_location,
                role: self.role,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl GetWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkspaceOutput`](crate::output::GetWorkspaceOutput)
    pub fn builder() -> crate::output::get_workspace_output::Builder {
        crate::output::get_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSceneOutput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the scene.</p>
    pub scene_id: std::option::Option<std::string::String>,
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub content_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the scene.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the scene was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the scene was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the scene.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of capabilities that the scene uses to render.</p>
    pub capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetSceneOutput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the scene.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub fn content_location(&self) -> std::option::Option<&str> {
        self.content_location.as_deref()
    }
    /// <p>The ARN of the scene.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the scene was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the scene was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>The description of the scene.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of capabilities that the scene uses to render.</p>
    pub fn capabilities(&self) -> std::option::Option<&[std::string::String]> {
        self.capabilities.as_deref()
    }
}
impl std::fmt::Debug for GetSceneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSceneOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("scene_id", &self.scene_id);
        formatter.field("content_location", &self.content_location);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("description", &self.description);
        formatter.field("capabilities", &self.capabilities);
        formatter.finish()
    }
}
/// See [`GetSceneOutput`](crate::output::GetSceneOutput)
pub mod get_scene_output {
    /// A builder for [`GetSceneOutput`](crate::output::GetSceneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) scene_id: std::option::Option<std::string::String>,
        pub(crate) content_location: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_location = Some(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_location = input;
            self
        }
        /// <p>The ARN of the scene.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scene.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the scene was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>The description of the scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSceneOutput`](crate::output::GetSceneOutput)
        pub fn build(self) -> crate::output::GetSceneOutput {
            crate::output::GetSceneOutput {
                workspace_id: self.workspace_id,
                scene_id: self.scene_id,
                content_location: self.content_location,
                arn: self.arn,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
                description: self.description,
                capabilities: self.capabilities,
            }
        }
    }
}
impl GetSceneOutput {
    /// Creates a new builder-style object to manufacture [`GetSceneOutput`](crate::output::GetSceneOutput)
    pub fn builder() -> crate::output::get_scene_output::Builder {
        crate::output::get_scene_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPropertyValueHistoryOutput {
    /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    pub property_values: std::option::Option<std::vec::Vec<crate::model::PropertyValueHistory>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetPropertyValueHistoryOutput {
    /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    pub fn property_values(&self) -> std::option::Option<&[crate::model::PropertyValueHistory]> {
        self.property_values.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetPropertyValueHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPropertyValueHistoryOutput");
        formatter.field("property_values", &self.property_values);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetPropertyValueHistoryOutput`](crate::output::GetPropertyValueHistoryOutput)
pub mod get_property_value_history_output {
    /// A builder for [`GetPropertyValueHistoryOutput`](crate::output::GetPropertyValueHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_values:
            std::option::Option<std::vec::Vec<crate::model::PropertyValueHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `property_values`.
        ///
        /// To override the contents of this collection use [`set_property_values`](Self::set_property_values).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_values(mut self, input: crate::model::PropertyValueHistory) -> Self {
            let mut v = self.property_values.unwrap_or_default();
            v.push(input);
            self.property_values = Some(v);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValueHistory>>,
        ) -> Self {
            self.property_values = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPropertyValueHistoryOutput`](crate::output::GetPropertyValueHistoryOutput)
        pub fn build(self) -> crate::output::GetPropertyValueHistoryOutput {
            crate::output::GetPropertyValueHistoryOutput {
                property_values: self.property_values,
                next_token: self.next_token,
            }
        }
    }
}
impl GetPropertyValueHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetPropertyValueHistoryOutput`](crate::output::GetPropertyValueHistoryOutput)
    pub fn builder() -> crate::output::get_property_value_history_output::Builder {
        crate::output::get_property_value_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPropertyValueOutput {
    /// <p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>
    pub property_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyLatestValue>,
    >,
}
impl GetPropertyValueOutput {
    /// <p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>
    pub fn property_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyLatestValue>,
    > {
        self.property_values.as_ref()
    }
}
impl std::fmt::Debug for GetPropertyValueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPropertyValueOutput");
        formatter.field("property_values", &self.property_values);
        formatter.finish()
    }
}
/// See [`GetPropertyValueOutput`](crate::output::GetPropertyValueOutput)
pub mod get_property_value_output {
    /// A builder for [`GetPropertyValueOutput`](crate::output::GetPropertyValueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyLatestValue>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `property_values`.
        ///
        /// To override the contents of this collection use [`set_property_values`](Self::set_property_values).
        ///
        /// <p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>
        pub fn property_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyLatestValue,
        ) -> Self {
            let mut hash_map = self.property_values.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.property_values = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PropertyLatestValue>,
            >,
        ) -> Self {
            self.property_values = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPropertyValueOutput`](crate::output::GetPropertyValueOutput)
        pub fn build(self) -> crate::output::GetPropertyValueOutput {
            crate::output::GetPropertyValueOutput {
                property_values: self.property_values,
            }
        }
    }
}
impl GetPropertyValueOutput {
    /// Creates a new builder-style object to manufacture [`GetPropertyValueOutput`](crate::output::GetPropertyValueOutput)
    pub fn builder() -> crate::output::get_property_value_output::Builder {
        crate::output::get_property_value_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntityOutput {
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the entity.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the entity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The current status of the entity.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The description of the entity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
    pub components: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentResponse>,
    >,
    /// <p>The ID of the parent entity for this entity.</p>
    pub parent_entity_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether the entity has associated child entities.</p>
    pub has_child_entities: std::option::Option<bool>,
    /// <p>The date and time when the entity was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the entity was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetEntityOutput {
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the entity.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>The ARN of the entity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The current status of the entity.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The description of the entity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
    pub fn components(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentResponse>,
    > {
        self.components.as_ref()
    }
    /// <p>The ID of the parent entity for this entity.</p>
    pub fn parent_entity_id(&self) -> std::option::Option<&str> {
        self.parent_entity_id.as_deref()
    }
    /// <p>A Boolean value that specifies whether the entity has associated child entities.</p>
    pub fn has_child_entities(&self) -> std::option::Option<bool> {
        self.has_child_entities
    }
    /// <p>The date and time when the entity was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the entity was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
}
impl std::fmt::Debug for GetEntityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntityOutput");
        formatter.field("entity_id", &self.entity_id);
        formatter.field("entity_name", &self.entity_name);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("description", &self.description);
        formatter.field("components", &self.components);
        formatter.field("parent_entity_id", &self.parent_entity_id);
        formatter.field("has_child_entities", &self.has_child_entities);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.finish()
    }
}
/// See [`GetEntityOutput`](crate::output::GetEntityOutput)
pub mod get_entity_output {
    /// A builder for [`GetEntityOutput`](crate::output::GetEntityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) components: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentResponse>,
        >,
        pub(crate) parent_entity_id: std::option::Option<std::string::String>,
        pub(crate) has_child_entities: std::option::Option<bool>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The current status of the entity.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the entity.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentResponse,
        ) -> Self {
            let mut hash_map = self.components.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.components = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentResponse>,
            >,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The ID of the parent entity for this entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent entity for this entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_entity_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether the entity has associated child entities.</p>
        pub fn has_child_entities(mut self, input: bool) -> Self {
            self.has_child_entities = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the entity has associated child entities.</p>
        pub fn set_has_child_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.has_child_entities = input;
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the entity was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntityOutput`](crate::output::GetEntityOutput)
        pub fn build(self) -> crate::output::GetEntityOutput {
            crate::output::GetEntityOutput {
                entity_id: self.entity_id,
                entity_name: self.entity_name,
                arn: self.arn,
                status: self.status,
                workspace_id: self.workspace_id,
                description: self.description,
                components: self.components,
                parent_entity_id: self.parent_entity_id,
                has_child_entities: self.has_child_entities,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
            }
        }
    }
}
impl GetEntityOutput {
    /// Creates a new builder-style object to manufacture [`GetEntityOutput`](crate::output::GetEntityOutput)
    pub fn builder() -> crate::output::get_entity_output::Builder {
        crate::output::get_entity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentTypeOutput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
    pub is_singleton: std::option::Option<bool>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    pub property_definitions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionResponse>,
    >,
    /// <p>The name of the parent component type that this component type extends.</p>
    pub extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
    pub functions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::FunctionResponse>,
    >,
    /// <p>The date and time when the component type was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the component was last updated.</p>
    pub update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of the component type.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether the component type is abstract.</p>
    pub is_abstract: std::option::Option<bool>,
    /// <p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>
    pub is_schema_initialized: std::option::Option<bool>,
    /// <p>The current status of the component type.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl GetComponentTypeOutput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
    pub fn is_singleton(&self) -> std::option::Option<bool> {
        self.is_singleton
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
    pub fn property_definitions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionResponse>,
    > {
        self.property_definitions.as_ref()
    }
    /// <p>The name of the parent component type that this component type extends.</p>
    pub fn extends_from(&self) -> std::option::Option<&[std::string::String]> {
        self.extends_from.as_deref()
    }
    /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
    pub fn functions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::FunctionResponse>,
    > {
        self.functions.as_ref()
    }
    /// <p>The date and time when the component type was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time when the component was last updated.</p>
    pub fn update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date_time.as_ref()
    }
    /// <p>The ARN of the component type.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A Boolean value that specifies whether the component type is abstract.</p>
    pub fn is_abstract(&self) -> std::option::Option<bool> {
        self.is_abstract
    }
    /// <p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>
    pub fn is_schema_initialized(&self) -> std::option::Option<bool> {
        self.is_schema_initialized
    }
    /// <p>The current status of the component type.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetComponentTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentTypeOutput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("is_singleton", &self.is_singleton);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("description", &self.description);
        formatter.field("property_definitions", &self.property_definitions);
        formatter.field("extends_from", &self.extends_from);
        formatter.field("functions", &self.functions);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("update_date_time", &self.update_date_time);
        formatter.field("arn", &self.arn);
        formatter.field("is_abstract", &self.is_abstract);
        formatter.field("is_schema_initialized", &self.is_schema_initialized);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetComponentTypeOutput`](crate::output::GetComponentTypeOutput)
pub mod get_component_type_output {
    /// A builder for [`GetComponentTypeOutput`](crate::output::GetComponentTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) is_singleton: std::option::Option<bool>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) property_definitions: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::PropertyDefinitionResponse,
            >,
        >,
        pub(crate) extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) functions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FunctionResponse>,
        >,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) is_abstract: std::option::Option<bool>,
        pub(crate) is_schema_initialized: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.is_singleton = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.is_singleton = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `property_definitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyDefinitionResponse,
        ) -> Self {
            let mut hash_map = self.property_definitions.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.property_definitions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionResponse,
                >,
            >,
        ) -> Self {
            self.property_definitions = input;
            self
        }
        /// Appends an item to `extends_from`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>The name of the parent component type that this component type extends.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.extends_from.unwrap_or_default();
            v.push(input.into());
            self.extends_from = Some(v);
            self
        }
        /// <p>The name of the parent component type that this component type extends.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.extends_from = input;
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FunctionResponse,
        ) -> Self {
            let mut hash_map = self.functions.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.functions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionResponse>,
            >,
        ) -> Self {
            self.functions = input;
            self
        }
        /// <p>The date and time when the component type was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the component type was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time when the component was last updated.</p>
        pub fn update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date_time = Some(input);
            self
        }
        /// <p>The date and time when the component was last updated.</p>
        pub fn set_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date_time = input;
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A Boolean value that specifies whether the component type is abstract.</p>
        pub fn is_abstract(mut self, input: bool) -> Self {
            self.is_abstract = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the component type is abstract.</p>
        pub fn set_is_abstract(mut self, input: std::option::Option<bool>) -> Self {
            self.is_abstract = input;
            self
        }
        /// <p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>
        pub fn is_schema_initialized(mut self, input: bool) -> Self {
            self.is_schema_initialized = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>
        pub fn set_is_schema_initialized(mut self, input: std::option::Option<bool>) -> Self {
            self.is_schema_initialized = input;
            self
        }
        /// <p>The current status of the component type.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the component type.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentTypeOutput`](crate::output::GetComponentTypeOutput)
        pub fn build(self) -> crate::output::GetComponentTypeOutput {
            crate::output::GetComponentTypeOutput {
                workspace_id: self.workspace_id,
                is_singleton: self.is_singleton,
                component_type_id: self.component_type_id,
                description: self.description,
                property_definitions: self.property_definitions,
                extends_from: self.extends_from,
                functions: self.functions,
                creation_date_time: self.creation_date_time,
                update_date_time: self.update_date_time,
                arn: self.arn,
                is_abstract: self.is_abstract,
                is_schema_initialized: self.is_schema_initialized,
                status: self.status,
            }
        }
    }
}
impl GetComponentTypeOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentTypeOutput`](crate::output::GetComponentTypeOutput)
    pub fn builder() -> crate::output::get_component_type_output::Builder {
        crate::output::get_component_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceOutput {}
impl std::fmt::Debug for DeleteWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
pub mod delete_workspace_output {
    /// A builder for [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
        pub fn build(self) -> crate::output::DeleteWorkspaceOutput {
            crate::output::DeleteWorkspaceOutput {}
        }
    }
}
impl DeleteWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    pub fn builder() -> crate::output::delete_workspace_output::Builder {
        crate::output::delete_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSceneOutput {}
impl std::fmt::Debug for DeleteSceneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSceneOutput");
        formatter.finish()
    }
}
/// See [`DeleteSceneOutput`](crate::output::DeleteSceneOutput)
pub mod delete_scene_output {
    /// A builder for [`DeleteSceneOutput`](crate::output::DeleteSceneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSceneOutput`](crate::output::DeleteSceneOutput)
        pub fn build(self) -> crate::output::DeleteSceneOutput {
            crate::output::DeleteSceneOutput {}
        }
    }
}
impl DeleteSceneOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSceneOutput`](crate::output::DeleteSceneOutput)
    pub fn builder() -> crate::output::delete_scene_output::Builder {
        crate::output::delete_scene_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntityOutput {
    /// <p>The current state of the deleted entity.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl DeleteEntityOutput {
    /// <p>The current state of the deleted entity.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for DeleteEntityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntityOutput");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`DeleteEntityOutput`](crate::output::DeleteEntityOutput)
pub mod delete_entity_output {
    /// A builder for [`DeleteEntityOutput`](crate::output::DeleteEntityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The current state of the deleted entity.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the deleted entity.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEntityOutput`](crate::output::DeleteEntityOutput)
        pub fn build(self) -> crate::output::DeleteEntityOutput {
            crate::output::DeleteEntityOutput { state: self.state }
        }
    }
}
impl DeleteEntityOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEntityOutput`](crate::output::DeleteEntityOutput)
    pub fn builder() -> crate::output::delete_entity_output::Builder {
        crate::output::delete_entity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentTypeOutput {
    /// <p>The current state of the component type to be deleted.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl DeleteComponentTypeOutput {
    /// <p>The current state of the component type to be deleted.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for DeleteComponentTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentTypeOutput");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`DeleteComponentTypeOutput`](crate::output::DeleteComponentTypeOutput)
pub mod delete_component_type_output {
    /// A builder for [`DeleteComponentTypeOutput`](crate::output::DeleteComponentTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The current state of the component type to be deleted.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the component type to be deleted.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentTypeOutput`](crate::output::DeleteComponentTypeOutput)
        pub fn build(self) -> crate::output::DeleteComponentTypeOutput {
            crate::output::DeleteComponentTypeOutput { state: self.state }
        }
    }
}
impl DeleteComponentTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteComponentTypeOutput`](crate::output::DeleteComponentTypeOutput)
    pub fn builder() -> crate::output::delete_component_type_output::Builder {
        crate::output::delete_component_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceOutput {
    /// <p>The ARN of the workspace.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the workspace was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateWorkspaceOutput {
    /// <p>The ARN of the workspace.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the workspace was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
pub mod create_workspace_output {
    /// A builder for [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the workspace.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the workspace.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the workspace was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
        pub fn build(self) -> crate::output::CreateWorkspaceOutput {
            crate::output::CreateWorkspaceOutput {
                arn: self.arn,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    pub fn builder() -> crate::output::create_workspace_output::Builder {
        crate::output::create_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSceneOutput {
    /// <p>The ARN of the scene.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the scene was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateSceneOutput {
    /// <p>The ARN of the scene.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the scene was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateSceneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSceneOutput");
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateSceneOutput`](crate::output::CreateSceneOutput)
pub mod create_scene_output {
    /// A builder for [`CreateSceneOutput`](crate::output::CreateSceneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the scene.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scene.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the scene was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSceneOutput`](crate::output::CreateSceneOutput)
        pub fn build(self) -> crate::output::CreateSceneOutput {
            crate::output::CreateSceneOutput {
                arn: self.arn,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateSceneOutput {
    /// Creates a new builder-style object to manufacture [`CreateSceneOutput`](crate::output::CreateSceneOutput)
    pub fn builder() -> crate::output::create_scene_output::Builder {
        crate::output::create_scene_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEntityOutput {
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the entity.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the entity was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the entity.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl CreateEntityOutput {
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The ARN of the entity.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the entity was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The current state of the entity.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for CreateEntityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEntityOutput");
        formatter.field("entity_id", &self.entity_id);
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`CreateEntityOutput`](crate::output::CreateEntityOutput)
pub mod create_entity_output {
    /// A builder for [`CreateEntityOutput`](crate::output::CreateEntityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The current state of the entity.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the entity.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEntityOutput`](crate::output::CreateEntityOutput)
        pub fn build(self) -> crate::output::CreateEntityOutput {
            crate::output::CreateEntityOutput {
                entity_id: self.entity_id,
                arn: self.arn,
                creation_date_time: self.creation_date_time,
                state: self.state,
            }
        }
    }
}
impl CreateEntityOutput {
    /// Creates a new builder-style object to manufacture [`CreateEntityOutput`](crate::output::CreateEntityOutput)
    pub fn builder() -> crate::output::create_entity_output::Builder {
        crate::output::create_entity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentTypeOutput {
    /// <p>The ARN of the component type.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time when the entity was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the component type.</p>
    pub state: std::option::Option<crate::model::State>,
}
impl CreateComponentTypeOutput {
    /// <p>The ARN of the component type.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time when the entity was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The current state of the component type.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for CreateComponentTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentTypeOutput");
        formatter.field("arn", &self.arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`CreateComponentTypeOutput`](crate::output::CreateComponentTypeOutput)
pub mod create_component_type_output {
    /// A builder for [`CreateComponentTypeOutput`](crate::output::CreateComponentTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>The ARN of the component type.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the component type.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the entity was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The current state of the component type.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the component type.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentTypeOutput`](crate::output::CreateComponentTypeOutput)
        pub fn build(self) -> crate::output::CreateComponentTypeOutput {
            crate::output::CreateComponentTypeOutput {
                arn: self.arn,
                creation_date_time: self.creation_date_time,
                state: self.state,
            }
        }
    }
}
impl CreateComponentTypeOutput {
    /// Creates a new builder-style object to manufacture [`CreateComponentTypeOutput`](crate::output::CreateComponentTypeOutput)
    pub fn builder() -> crate::output::create_component_type_output::Builder {
        crate::output::create_component_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutPropertyValuesOutput {
    /// <p>Entries that caused errors in the batch put operation.</p>
    pub error_entries: std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyErrorEntry>>,
}
impl BatchPutPropertyValuesOutput {
    /// <p>Entries that caused errors in the batch put operation.</p>
    pub fn error_entries(
        &self,
    ) -> std::option::Option<&[crate::model::BatchPutPropertyErrorEntry]> {
        self.error_entries.as_deref()
    }
}
impl std::fmt::Debug for BatchPutPropertyValuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutPropertyValuesOutput");
        formatter.field("error_entries", &self.error_entries);
        formatter.finish()
    }
}
/// See [`BatchPutPropertyValuesOutput`](crate::output::BatchPutPropertyValuesOutput)
pub mod batch_put_property_values_output {
    /// A builder for [`BatchPutPropertyValuesOutput`](crate::output::BatchPutPropertyValuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_entries:
            std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyErrorEntry>>,
    }
    impl Builder {
        /// Appends an item to `error_entries`.
        ///
        /// To override the contents of this collection use [`set_error_entries`](Self::set_error_entries).
        ///
        /// <p>Entries that caused errors in the batch put operation.</p>
        pub fn error_entries(mut self, input: crate::model::BatchPutPropertyErrorEntry) -> Self {
            let mut v = self.error_entries.unwrap_or_default();
            v.push(input);
            self.error_entries = Some(v);
            self
        }
        /// <p>Entries that caused errors in the batch put operation.</p>
        pub fn set_error_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutPropertyErrorEntry>>,
        ) -> Self {
            self.error_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutPropertyValuesOutput`](crate::output::BatchPutPropertyValuesOutput)
        pub fn build(self) -> crate::output::BatchPutPropertyValuesOutput {
            crate::output::BatchPutPropertyValuesOutput {
                error_entries: self.error_entries,
            }
        }
    }
}
impl BatchPutPropertyValuesOutput {
    /// Creates a new builder-style object to manufacture [`BatchPutPropertyValuesOutput`](crate::output::BatchPutPropertyValuesOutput)
    pub fn builder() -> crate::output::batch_put_property_values_output::Builder {
        crate::output::batch_put_property_values_output::Builder::default()
    }
}
