// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT TwinMaker
///
/// Client for invoking operations on AWS IoT TwinMaker. Each operation on AWS IoT TwinMaker is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iottwinmaker::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iottwinmaker::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iottwinmaker::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchPutPropertyValues` operation.
    ///
    /// See [`BatchPutPropertyValues`](crate::client::fluent_builders::BatchPutPropertyValues) for more information about the
    /// operation and its arguments.
    pub fn batch_put_property_values(&self) -> fluent_builders::BatchPutPropertyValues<C, M, R> {
        fluent_builders::BatchPutPropertyValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateComponentType` operation.
    ///
    /// See [`CreateComponentType`](crate::client::fluent_builders::CreateComponentType) for more information about the
    /// operation and its arguments.
    pub fn create_component_type(&self) -> fluent_builders::CreateComponentType<C, M, R> {
        fluent_builders::CreateComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEntity` operation.
    ///
    /// See [`CreateEntity`](crate::client::fluent_builders::CreateEntity) for more information about the
    /// operation and its arguments.
    pub fn create_entity(&self) -> fluent_builders::CreateEntity<C, M, R> {
        fluent_builders::CreateEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateScene` operation.
    ///
    /// See [`CreateScene`](crate::client::fluent_builders::CreateScene) for more information about the
    /// operation and its arguments.
    pub fn create_scene(&self) -> fluent_builders::CreateScene<C, M, R> {
        fluent_builders::CreateScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkspace` operation.
    ///
    /// See [`CreateWorkspace`](crate::client::fluent_builders::CreateWorkspace) for more information about the
    /// operation and its arguments.
    pub fn create_workspace(&self) -> fluent_builders::CreateWorkspace<C, M, R> {
        fluent_builders::CreateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteComponentType` operation.
    ///
    /// See [`DeleteComponentType`](crate::client::fluent_builders::DeleteComponentType) for more information about the
    /// operation and its arguments.
    pub fn delete_component_type(&self) -> fluent_builders::DeleteComponentType<C, M, R> {
        fluent_builders::DeleteComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEntity` operation.
    ///
    /// See [`DeleteEntity`](crate::client::fluent_builders::DeleteEntity) for more information about the
    /// operation and its arguments.
    pub fn delete_entity(&self) -> fluent_builders::DeleteEntity<C, M, R> {
        fluent_builders::DeleteEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteScene` operation.
    ///
    /// See [`DeleteScene`](crate::client::fluent_builders::DeleteScene) for more information about the
    /// operation and its arguments.
    pub fn delete_scene(&self) -> fluent_builders::DeleteScene<C, M, R> {
        fluent_builders::DeleteScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkspace` operation.
    ///
    /// See [`DeleteWorkspace`](crate::client::fluent_builders::DeleteWorkspace) for more information about the
    /// operation and its arguments.
    pub fn delete_workspace(&self) -> fluent_builders::DeleteWorkspace<C, M, R> {
        fluent_builders::DeleteWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComponentType` operation.
    ///
    /// See [`GetComponentType`](crate::client::fluent_builders::GetComponentType) for more information about the
    /// operation and its arguments.
    pub fn get_component_type(&self) -> fluent_builders::GetComponentType<C, M, R> {
        fluent_builders::GetComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEntity` operation.
    ///
    /// See [`GetEntity`](crate::client::fluent_builders::GetEntity) for more information about the
    /// operation and its arguments.
    pub fn get_entity(&self) -> fluent_builders::GetEntity<C, M, R> {
        fluent_builders::GetEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPropertyValue` operation.
    ///
    /// See [`GetPropertyValue`](crate::client::fluent_builders::GetPropertyValue) for more information about the
    /// operation and its arguments.
    pub fn get_property_value(&self) -> fluent_builders::GetPropertyValue<C, M, R> {
        fluent_builders::GetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPropertyValueHistory` operation.
    ///
    /// See [`GetPropertyValueHistory`](crate::client::fluent_builders::GetPropertyValueHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetPropertyValueHistory::into_paginator).
    pub fn get_property_value_history(&self) -> fluent_builders::GetPropertyValueHistory<C, M, R> {
        fluent_builders::GetPropertyValueHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetScene` operation.
    ///
    /// See [`GetScene`](crate::client::fluent_builders::GetScene) for more information about the
    /// operation and its arguments.
    pub fn get_scene(&self) -> fluent_builders::GetScene<C, M, R> {
        fluent_builders::GetScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkspace` operation.
    ///
    /// See [`GetWorkspace`](crate::client::fluent_builders::GetWorkspace) for more information about the
    /// operation and its arguments.
    pub fn get_workspace(&self) -> fluent_builders::GetWorkspace<C, M, R> {
        fluent_builders::GetWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComponentTypes` operation.
    ///
    /// See [`ListComponentTypes`](crate::client::fluent_builders::ListComponentTypes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListComponentTypes::into_paginator).
    pub fn list_component_types(&self) -> fluent_builders::ListComponentTypes<C, M, R> {
        fluent_builders::ListComponentTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntities` operation.
    ///
    /// See [`ListEntities`](crate::client::fluent_builders::ListEntities) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListEntities::into_paginator).
    pub fn list_entities(&self) -> fluent_builders::ListEntities<C, M, R> {
        fluent_builders::ListEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListScenes` operation.
    ///
    /// See [`ListScenes`](crate::client::fluent_builders::ListScenes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListScenes::into_paginator).
    pub fn list_scenes(&self) -> fluent_builders::ListScenes<C, M, R> {
        fluent_builders::ListScenes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkspaces` operation.
    ///
    /// See [`ListWorkspaces`](crate::client::fluent_builders::ListWorkspaces) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkspaces::into_paginator).
    pub fn list_workspaces(&self) -> fluent_builders::ListWorkspaces<C, M, R> {
        fluent_builders::ListWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateComponentType` operation.
    ///
    /// See [`UpdateComponentType`](crate::client::fluent_builders::UpdateComponentType) for more information about the
    /// operation and its arguments.
    pub fn update_component_type(&self) -> fluent_builders::UpdateComponentType<C, M, R> {
        fluent_builders::UpdateComponentType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEntity` operation.
    ///
    /// See [`UpdateEntity`](crate::client::fluent_builders::UpdateEntity) for more information about the
    /// operation and its arguments.
    pub fn update_entity(&self) -> fluent_builders::UpdateEntity<C, M, R> {
        fluent_builders::UpdateEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateScene` operation.
    ///
    /// See [`UpdateScene`](crate::client::fluent_builders::UpdateScene) for more information about the
    /// operation and its arguments.
    pub fn update_scene(&self) -> fluent_builders::UpdateScene<C, M, R> {
        fluent_builders::UpdateScene::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkspace` operation.
    ///
    /// See [`UpdateWorkspace`](crate::client::fluent_builders::UpdateWorkspace) for more information about the
    /// operation and its arguments.
    pub fn update_workspace(&self) -> fluent_builders::UpdateWorkspace<C, M, R> {
        fluent_builders::UpdateWorkspace::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchPutPropertyValues`.
    ///
    /// <p>Sets values for multiple time series properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchPutPropertyValues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_property_values_input::Builder,
    }
    impl<C, M, R> BatchPutPropertyValues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutPropertyValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutPropertyValuesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutPropertyValuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutPropertyValuesInputOperationOutputAlias,
                crate::output::BatchPutPropertyValuesOutput,
                crate::error::BatchPutPropertyValuesError,
                crate::input::BatchPutPropertyValuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>
        pub fn entries(mut self, input: crate::model::PropertyValueEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValueEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponentType`.
    ///
    /// <p>Creates a component type.</p> <important>
    /// <p> TwinMaker is in public preview and is subject to change. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_component_type_input::Builder,
    }
    impl<C, M, R> CreateComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComponentTypeInputOperationOutputAlias,
                crate::output::CreateComponentTypeOutput,
                crate::error::CreateComponentTypeError,
                crate::input::CreateComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.inner = self.inner.is_singleton(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_singleton(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `propertyDefinitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyDefinitionRequest,
        ) -> Self {
            self.inner = self.inner.property_definitions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_property_definitions(input);
            self
        }
        /// Appends an item to `extendsFrom`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the parent component type to extend.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extends_from(input.into());
            self
        }
        /// <p>Specifies the parent component type to extend.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_extends_from(input);
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FunctionRequest,
        ) -> Self {
            self.inner = self.inner.functions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_functions(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEntity`.
    ///
    /// <p>Creates an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_entity_input::Builder,
    }
    impl<C, M, R> CreateEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEntityInputOperationOutputAlias,
                crate::output::CreateEntityOutput,
                crate::error::CreateEntityError,
                crate::input::CreateEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_name(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_name(input);
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentRequest,
        ) -> Self {
            self.inner = self.inner.components(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_entity_id(input.into());
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_entity_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScene`.
    ///
    /// <p>Creates a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scene_input::Builder,
    }
    impl<C, M, R> CreateScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSceneInputOperationOutputAlias,
                crate::output::CreateSceneOutput,
                crate::error::CreateSceneError,
                crate::input::CreateSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_location(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_location(input);
            self
        }
        /// <p>The description for this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(input.into());
            self
        }
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspace`.
    ///
    /// <p>Creates a workplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workspace_input::Builder,
    }
    impl<C, M, R> CreateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkspaceInputOperationOutputAlias,
                crate::output::CreateWorkspaceOutput,
                crate::error::CreateWorkspaceError,
                crate::input::CreateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_location(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn set_s3_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_location(input);
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponentType`.
    ///
    /// <p>Deletes a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_component_type_input::Builder,
    }
    impl<C, M, R> DeleteComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteComponentTypeInputOperationOutputAlias,
                crate::output::DeleteComponentTypeOutput,
                crate::error::DeleteComponentTypeError,
                crate::input::DeleteComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntity`.
    ///
    /// <p>Deletes an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_entity_input::Builder,
    }
    impl<C, M, R> DeleteEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEntityInputOperationOutputAlias,
                crate::output::DeleteEntityOutput,
                crate::error::DeleteEntityError,
                crate::input::DeleteEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn is_recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.is_recursive(input);
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn set_is_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_recursive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScene`.
    ///
    /// <p>Deletes a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scene_input::Builder,
    }
    impl<C, M, R> DeleteScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSceneInputOperationOutputAlias,
                crate::output::DeleteSceneOutput,
                crate::error::DeleteSceneError,
                crate::input::DeleteSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspace`.
    ///
    /// <p>Deletes a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workspace_input::Builder,
    }
    impl<C, M, R> DeleteWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkspaceInputOperationOutputAlias,
                crate::output::DeleteWorkspaceOutput,
                crate::error::DeleteWorkspaceError,
                crate::input::DeleteWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponentType`.
    ///
    /// <p>Retrieves information about a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_component_type_input::Builder,
    }
    impl<C, M, R> GetComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComponentTypeInputOperationOutputAlias,
                crate::output::GetComponentTypeOutput,
                crate::error::GetComponentTypeError,
                crate::input::GetComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntity`.
    ///
    /// <p>Retrieves information about an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_entity_input::Builder,
    }
    impl<C, M, R> GetEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEntityInputOperationOutputAlias,
                crate::output::GetEntityOutput,
                crate::error::GetEntityError,
                crate::input::GetEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPropertyValue`.
    ///
    /// <p>Gets the property values for a component, component type, entity, or workspace.</p>
    /// <p>You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>, <code>entityId</code>, or <code>workspaceId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPropertyValue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_property_value_input::Builder,
    }
    impl<C, M, R> GetPropertyValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPropertyValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPropertyValueInputOperationOutputAlias,
                crate::output::GetPropertyValueOutput,
                crate::error::GetPropertyValueError,
                crate::input::GetPropertyValueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// Appends an item to `selectedProperties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>The properties whose values the operation returns.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_properties(input.into());
            self
        }
        /// <p>The properties whose values the operation returns.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_properties(input);
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPropertyValueHistory`.
    ///
    /// <p>Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.</p>
    /// <p>You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for <code>componentTypeId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPropertyValueHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_property_value_history_input::Builder,
    }
    impl<C, M, R> GetPropertyValueHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPropertyValueHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPropertyValueHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPropertyValueHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPropertyValueHistoryInputOperationOutputAlias,
                crate::output::GetPropertyValueHistoryOutput,
                crate::error::GetPropertyValueHistoryError,
                crate::input::GetPropertyValueHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPropertyValueHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetPropertyValueHistoryPaginator<C, M, R> {
            crate::paginator::GetPropertyValueHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_name(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// Appends an item to `selectedProperties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_properties(input.into());
            self
        }
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_properties(input);
            self
        }
        /// Appends an item to `propertyFilters`.
        ///
        /// To override the contents of this collection use [`set_property_filters`](Self::set_property_filters).
        ///
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn property_filters(mut self, input: crate::model::PropertyFilter) -> Self {
            self.inner = self.inner.property_filters(input);
            self
        }
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn set_property_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyFilter>>,
        ) -> Self {
            self.inner = self.inner.set_property_filters(input);
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date_time(input);
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date_time(input);
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date_time(input);
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date_time(input);
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn interpolation(mut self, input: crate::model::InterpolationParameters) -> Self {
            self.inner = self.inner.interpolation(input);
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn set_interpolation(
            mut self,
            input: std::option::Option<crate::model::InterpolationParameters>,
        ) -> Self {
            self.inner = self.inner.set_interpolation(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn order_by_time(mut self, input: crate::model::OrderByTime) -> Self {
            self.inner = self.inner.order_by_time(input);
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn set_order_by_time(
            mut self,
            input: std::option::Option<crate::model::OrderByTime>,
        ) -> Self {
            self.inner = self.inner.set_order_by_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetScene`.
    ///
    /// <p>Retrieves information about a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_scene_input::Builder,
    }
    impl<C, M, R> GetScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSceneInputOperationOutputAlias,
                crate::output::GetSceneOutput,
                crate::error::GetSceneError,
                crate::input::GetSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkspace`.
    ///
    /// <p>Retrieves information about a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workspace_input::Builder,
    }
    impl<C, M, R> GetWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkspaceInputOperationOutputAlias,
                crate::output::GetWorkspaceOutput,
                crate::error::GetWorkspaceError,
                crate::input::GetWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponentTypes`.
    ///
    /// <p>Lists all component types in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponentTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_component_types_input::Builder,
    }
    impl<C, M, R> ListComponentTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponentTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentTypesInputOperationOutputAlias,
                crate::output::ListComponentTypesOutput,
                crate::error::ListComponentTypesError,
                crate::input::ListComponentTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentTypesPaginator<C, M, R> {
            crate::paginator::ListComponentTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: crate::model::ListComponentTypesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListComponentTypesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntities`.
    ///
    /// <p>Lists all entities in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entities_input::Builder,
    }
    impl<C, M, R> ListEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitiesInputOperationOutputAlias,
                crate::output::ListEntitiesOutput,
                crate::error::ListEntitiesError,
                crate::input::ListEntitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntitiesPaginator<C, M, R> {
            crate::paginator::ListEntitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: crate::model::ListEntitiesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEntitiesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListScenes`.
    ///
    /// <p>Lists all scenes in a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListScenes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_scenes_input::Builder,
    }
    impl<C, M, R> ListScenes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListScenes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListScenesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListScenesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListScenesInputOperationOutputAlias,
                crate::output::ListScenesOutput,
                crate::error::ListScenesError,
                crate::input::ListScenesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListScenesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListScenesPaginator<C, M, R> {
            crate::paginator::ListScenesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkspaces`.
    ///
    /// <p>Retrieves information about workspaces in the current account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkspaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workspaces_input::Builder,
    }
    impl<C, M, R> ListWorkspaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkspacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkspacesInputOperationOutputAlias,
                crate::output::ListWorkspacesOutput,
                crate::error::ListWorkspacesError,
                crate::input::ListWorkspacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkspacesPaginator<C, M, R> {
            crate::paginator::ListWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to add to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Metadata to add to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComponentType`.
    ///
    /// <p>Updates information in a component type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComponentType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_component_type_input::Builder,
    }
    impl<C, M, R> UpdateComponentType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComponentType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateComponentTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateComponentTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateComponentTypeInputOperationOutputAlias,
                crate::output::UpdateComponentTypeOutput,
                crate::error::UpdateComponentTypeError,
                crate::input::UpdateComponentTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.inner = self.inner.is_singleton(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_singleton(input);
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_type_id(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_type_id(input);
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `propertyDefinitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PropertyDefinitionRequest,
        ) -> Self {
            self.inner = self.inner.property_definitions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_property_definitions(input);
            self
        }
        /// Appends an item to `extendsFrom`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extends_from(input.into());
            self
        }
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_extends_from(input);
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FunctionRequest,
        ) -> Self {
            self.inner = self.inner.functions(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_functions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEntity`.
    ///
    /// <p>Updates an entity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_entity_input::Builder,
    }
    impl<C, M, R> UpdateEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEntityInputOperationOutputAlias,
                crate::output::UpdateEntityOutput,
                crate::error::UpdateEntityError,
                crate::input::UpdateEntityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_name(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_name(input);
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `componentUpdates`.
        ///
        /// To override the contents of this collection use [`set_component_updates`](Self::set_component_updates).
        ///
        /// <p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>
        pub fn component_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentUpdateRequest,
        ) -> Self {
            self.inner = self.inner.component_updates(k.into(), v);
            self
        }
        /// <p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>
        pub fn set_component_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentUpdateRequest,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_component_updates(input);
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn parent_entity_update(
            mut self,
            input: crate::model::ParentEntityUpdateRequest,
        ) -> Self {
            self.inner = self.inner.parent_entity_update(input);
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn set_parent_entity_update(
            mut self,
            input: std::option::Option<crate::model::ParentEntityUpdateRequest>,
        ) -> Self {
            self.inner = self.inner.set_parent_entity_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateScene`.
    ///
    /// <p>Updates a scene.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateScene<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_scene_input::Builder,
    }
    impl<C, M, R> UpdateScene<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateScene`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSceneOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSceneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSceneInputOperationOutputAlias,
                crate::output::UpdateSceneOutput,
                crate::error::UpdateSceneError,
                crate::input::UpdateSceneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scene_id(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_scene_id(input);
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_location(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_location(input);
            self
        }
        /// <p>The description of this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capabilities(input.into());
            self
        }
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspace`.
    ///
    /// <p>Updates a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workspace_input::Builder,
    }
    impl<C, M, R> UpdateWorkspace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkspaceInputOperationOutputAlias,
                crate::output::UpdateWorkspaceOutput,
                crate::error::UpdateWorkspaceError,
                crate::input::UpdateWorkspaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
