// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchPutPropertyValuesInput`](crate::input::BatchPutPropertyValuesInput)
pub mod batch_put_property_values_input {
    /// A builder for [`BatchPutPropertyValuesInput`](crate::input::BatchPutPropertyValuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entries: std::option::Option<std::vec::Vec<crate::model::PropertyValueEntry>>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the properties to set.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>An object that maps strings to the property value entries to set. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn entries(mut self, input: impl Into<crate::model::PropertyValueEntry>) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>An object that maps strings to the property value entries to set. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyValueEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutPropertyValuesInput`](crate::input::BatchPutPropertyValuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutPropertyValuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutPropertyValuesInput {
                workspace_id: self.workspace_id,
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutPropertyValuesInputOperationOutputAlias = crate::operation::BatchPutPropertyValues;
#[doc(hidden)]
pub type BatchPutPropertyValuesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchPutPropertyValuesInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutPropertyValues`](crate::operation::BatchPutPropertyValues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutPropertyValues,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchPutPropertyValuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.workspace_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_1, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entity-properties",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchPutPropertyValuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchPutPropertyValuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_put_property_values(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutPropertyValues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutPropertyValues",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchPutPropertyValuesInput`](crate::input::BatchPutPropertyValuesInput)
    pub fn builder() -> crate::input::batch_put_property_values_input::Builder {
        crate::input::batch_put_property_values_input::Builder::default()
    }
}

/// See [`CreateComponentTypeInput`](crate::input::CreateComponentTypeInput)
pub mod create_component_type_input {
    /// A builder for [`CreateComponentTypeInput`](crate::input::CreateComponentTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) is_singleton: std::option::Option<bool>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) property_definitions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
        >,
        pub(crate) extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) functions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of
        /// this type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.is_singleton = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of
        /// this type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.is_singleton = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `property_definitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PropertyDefinitionRequest>,
        ) -> Self {
            let mut hash_map = self.property_definitions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.property_definitions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.property_definitions = input;
            self
        }
        /// Appends an item to `extends_from`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the parent component type to extend.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.extends_from.unwrap_or_default();
            v.push(input.into());
            self.extends_from = Some(v);
            self
        }
        /// <p>Specifies the parent component type to extend.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.extends_from = input;
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string in the
        /// mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::FunctionRequest>,
        ) -> Self {
            let mut hash_map = self.functions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.functions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string in the
        /// mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can use to manage the component type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentTypeInput`](crate::input::CreateComponentTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComponentTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComponentTypeInput {
                workspace_id: self.workspace_id,
                is_singleton: self.is_singleton,
                component_type_id: self.component_type_id,
                description: self.description,
                property_definitions: self.property_definitions,
                extends_from: self.extends_from,
                functions: self.functions,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComponentTypeInputOperationOutputAlias = crate::operation::CreateComponentType;
#[doc(hidden)]
pub type CreateComponentTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateComponentTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateComponentType`](crate::operation::CreateComponentType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComponentType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateComponentTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.workspace_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_2, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.component_type_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "component_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let component_type_id = aws_smithy_http::label::fmt_string(input_3, false);
            if component_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "component_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/component-types/{componentTypeId}",
                workspaceId = workspace_id,
                componentTypeId = component_type_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateComponentTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateComponentTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_component_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComponentType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComponentType",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateComponentTypeInput`](crate::input::CreateComponentTypeInput)
    pub fn builder() -> crate::input::create_component_type_input::Builder {
        crate::input::create_component_type_input::Builder::default()
    }
}

/// See [`CreateEntityInput`](crate::input::CreateEntityInput)
pub mod create_entity_input {
    /// A builder for [`CreateEntityInput`](crate::input::CreateEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) components: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
        >,
        pub(crate) parent_entity_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>An object that maps strings to the components in the entity. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ComponentRequest>,
        ) -> Self {
            let mut hash_map = self.components.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.components = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the components in the entity. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
            >,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn parent_entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity's parent entity.</p>
        pub fn set_parent_entity_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_entity_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can use to manage the entity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEntityInput`](crate::input::CreateEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEntityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEntityInput {
                workspace_id: self.workspace_id,
                entity_id: self.entity_id,
                entity_name: self.entity_name,
                description: self.description,
                components: self.components,
                parent_entity_id: self.parent_entity_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEntityInputOperationOutputAlias = crate::operation::CreateEntity;
#[doc(hidden)]
pub type CreateEntityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEntityInput {
    /// Consumes the builder and constructs an Operation<[`CreateEntity`](crate::operation::CreateEntity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEntity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.workspace_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_4, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entities",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_entity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEntity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEntity",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEntityInput`](crate::input::CreateEntityInput)
    pub fn builder() -> crate::input::create_entity_input::Builder {
        crate::input::create_entity_input::Builder::default()
    }
}

/// See [`CreateSceneInput`](crate::input::CreateSceneInput)
pub mod create_scene_input {
    /// A builder for [`CreateSceneInput`](crate::input::CreateSceneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) scene_id: std::option::Option<std::string::String>,
        pub(crate) content_location: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_location = Some(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_location = input;
            self
        }
        /// <p>The description for this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>A list of capabilities that the scene uses to render itself.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can use to manage the scene.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSceneInput`](crate::input::CreateSceneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSceneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSceneInput {
                workspace_id: self.workspace_id,
                scene_id: self.scene_id,
                content_location: self.content_location,
                description: self.description,
                capabilities: self.capabilities,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSceneInputOperationOutputAlias = crate::operation::CreateScene;
#[doc(hidden)]
pub type CreateSceneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSceneInput {
    /// Consumes the builder and constructs an Operation<[`CreateScene`](crate::operation::CreateScene)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateScene,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSceneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.workspace_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_5, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/scenes",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSceneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSceneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_scene(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateScene::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateScene",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSceneInput`](crate::input::CreateSceneInput)
    pub fn builder() -> crate::input::create_scene_input::Builder {
        crate::input::create_scene_input::Builder::default()
    }
}

/// See [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
pub mod create_workspace_input {
    /// A builder for [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) s3_location: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn s3_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_location = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
        pub fn set_s3_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_location = input;
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata that you can use to manage the workspace</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkspaceInput {
                workspace_id: self.workspace_id,
                description: self.description,
                s3_location: self.s3_location,
                role: self.role,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkspaceInputOperationOutputAlias = crate::operation::CreateWorkspace;
#[doc(hidden)]
pub type CreateWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkspace`](crate::operation::CreateWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.workspace_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_6, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkspace",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    pub fn builder() -> crate::input::create_workspace_input::Builder {
        crate::input::create_workspace_input::Builder::default()
    }
}

/// See [`DeleteComponentTypeInput`](crate::input::DeleteComponentTypeInput)
pub mod delete_component_type_input {
    /// A builder for [`DeleteComponentTypeInput`](crate::input::DeleteComponentTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type to delete.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentTypeInput`](crate::input::DeleteComponentTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteComponentTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteComponentTypeInput {
                workspace_id: self.workspace_id,
                component_type_id: self.component_type_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteComponentTypeInputOperationOutputAlias = crate::operation::DeleteComponentType;
#[doc(hidden)]
pub type DeleteComponentTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteComponentTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComponentType`](crate::operation::DeleteComponentType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComponentType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteComponentTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.workspace_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_7, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.component_type_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "component_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let component_type_id = aws_smithy_http::label::fmt_string(input_8, false);
            if component_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "component_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/component-types/{componentTypeId}",
                workspaceId = workspace_id,
                componentTypeId = component_type_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteComponentTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteComponentTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComponentType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComponentType",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteComponentTypeInput`](crate::input::DeleteComponentTypeInput)
    pub fn builder() -> crate::input::delete_component_type_input::Builder {
        crate::input::delete_component_type_input::Builder::default()
    }
}

/// See [`DeleteEntityInput`](crate::input::DeleteEntityInput)
pub mod delete_entity_input {
    /// A builder for [`DeleteEntityInput`](crate::input::DeleteEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) is_recursive: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity to delete.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn is_recursive(mut self, input: bool) -> Self {
            self.is_recursive = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
        pub fn set_is_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.is_recursive = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEntityInput`](crate::input::DeleteEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEntityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEntityInput {
                workspace_id: self.workspace_id,
                entity_id: self.entity_id,
                is_recursive: self.is_recursive,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEntityInputOperationOutputAlias = crate::operation::DeleteEntity;
#[doc(hidden)]
pub type DeleteEntityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEntityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEntity`](crate::operation::DeleteEntity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEntity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.workspace_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_9, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.entity_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "entity_id",
                        details: "cannot be empty or unset",
                    })?;
            let entity_id = aws_smithy_http::label::fmt_string(input_10, false);
            if entity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "entity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entities/{entityId}",
                workspaceId = workspace_id,
                entityId = entity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteEntityInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.is_recursive {
                query.push_kv(
                    "isRecursive",
                    aws_smithy_types::primitive::Encoder::from(*inner_11).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEntity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEntity",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEntityInput`](crate::input::DeleteEntityInput)
    pub fn builder() -> crate::input::delete_entity_input::Builder {
        crate::input::delete_entity_input::Builder::default()
    }
}

/// See [`DeleteSceneInput`](crate::input::DeleteSceneInput)
pub mod delete_scene_input {
    /// A builder for [`DeleteSceneInput`](crate::input::DeleteSceneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) scene_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene to delete.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSceneInput`](crate::input::DeleteSceneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSceneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSceneInput {
                workspace_id: self.workspace_id,
                scene_id: self.scene_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSceneInputOperationOutputAlias = crate::operation::DeleteScene;
#[doc(hidden)]
pub type DeleteSceneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSceneInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScene`](crate::operation::DeleteScene)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScene,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSceneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.workspace_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_12, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.scene_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scene_id",
                        details: "cannot be empty or unset",
                    })?;
            let scene_id = aws_smithy_http::label::fmt_string(input_13, false);
            if scene_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "scene_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/scenes/{sceneId}",
                workspaceId = workspace_id,
                sceneId = scene_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSceneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSceneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScene::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScene",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSceneInput`](crate::input::DeleteSceneInput)
    pub fn builder() -> crate::input::delete_scene_input::Builder {
        crate::input::delete_scene_input::Builder::default()
    }
}

/// See [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
pub mod delete_workspace_input {
    /// A builder for [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkspaceInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkspaceInputOperationOutputAlias = crate::operation::DeleteWorkspace;
#[doc(hidden)]
pub type DeleteWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkspace`](crate::operation::DeleteWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.workspace_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_14, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkspace",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    pub fn builder() -> crate::input::delete_workspace_input::Builder {
        crate::input::delete_workspace_input::Builder::default()
    }
}

/// See [`GetComponentTypeInput`](crate::input::GetComponentTypeInput)
pub mod get_component_type_input {
    /// A builder for [`GetComponentTypeInput`](crate::input::GetComponentTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentTypeInput`](crate::input::GetComponentTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentTypeInput {
                workspace_id: self.workspace_id,
                component_type_id: self.component_type_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentTypeInputOperationOutputAlias = crate::operation::GetComponentType;
#[doc(hidden)]
pub type GetComponentTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetComponentTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetComponentType`](crate::operation::GetComponentType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponentType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetComponentTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.workspace_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_15, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.component_type_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "component_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let component_type_id = aws_smithy_http::label::fmt_string(input_16, false);
            if component_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "component_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/component-types/{componentTypeId}",
                workspaceId = workspace_id,
                componentTypeId = component_type_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetComponentTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetComponentTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponentType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponentType",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetComponentTypeInput`](crate::input::GetComponentTypeInput)
    pub fn builder() -> crate::input::get_component_type_input::Builder {
        crate::input::get_component_type_input::Builder::default()
    }
}

/// See [`GetEntityInput`](crate::input::GetEntityInput)
pub mod get_entity_input {
    /// A builder for [`GetEntityInput`](crate::input::GetEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntityInput`](crate::input::GetEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetEntityInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetEntityInput {
                workspace_id: self.workspace_id,
                entity_id: self.entity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEntityInputOperationOutputAlias = crate::operation::GetEntity;
#[doc(hidden)]
pub type GetEntityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEntityInput {
    /// Consumes the builder and constructs an Operation<[`GetEntity`](crate::operation::GetEntity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEntity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.workspace_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_17, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_18 = &_input.entity_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "entity_id",
                        details: "cannot be empty or unset",
                    })?;
            let entity_id = aws_smithy_http::label::fmt_string(input_18, false);
            if entity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "entity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entities/{entityId}",
                workspaceId = workspace_id,
                entityId = entity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetEntity::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetEntity",
                    "iottwinmaker",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEntityInput`](crate::input::GetEntityInput)
    pub fn builder() -> crate::input::get_entity_input::Builder {
        crate::input::get_entity_input::Builder::default()
    }
}

/// See [`GetPropertyValueInput`](crate::input::GetPropertyValueInput)
pub mod get_property_value_input {
    /// A builder for [`GetPropertyValueInput`](crate::input::GetPropertyValueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) selected_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component whose property values the operation returns.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type whose property values the operation returns.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity whose property values the operation returns.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Appends an item to `selected_properties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>The properties whose values the operation returns.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_properties.unwrap_or_default();
            v.push(input.into());
            self.selected_properties = Some(v);
            self
        }
        /// <p>The properties whose values the operation returns.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_properties = input;
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace whose values the operation returns.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPropertyValueInput`](crate::input::GetPropertyValueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPropertyValueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPropertyValueInput {
                component_name: self.component_name,
                component_type_id: self.component_type_id,
                entity_id: self.entity_id,
                selected_properties: self.selected_properties,
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPropertyValueInputOperationOutputAlias = crate::operation::GetPropertyValue;
#[doc(hidden)]
pub type GetPropertyValueInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPropertyValueInput {
    /// Consumes the builder and constructs an Operation<[`GetPropertyValue`](crate::operation::GetPropertyValue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPropertyValue,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPropertyValueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.workspace_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_19, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entity-properties/value",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPropertyValueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPropertyValueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_property_value(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPropertyValue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPropertyValue",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPropertyValueInput`](crate::input::GetPropertyValueInput)
    pub fn builder() -> crate::input::get_property_value_input::Builder {
        crate::input::get_property_value_input::Builder::default()
    }
}

/// See [`GetPropertyValueHistoryInput`](crate::input::GetPropertyValueHistoryInput)
pub mod get_property_value_history_input {
    /// A builder for [`GetPropertyValueHistoryInput`](crate::input::GetPropertyValueHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) selected_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) property_filters:
            std::option::Option<std::vec::Vec<crate::model::PropertyFilter>>,
        pub(crate) start_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) interpolation: std::option::Option<crate::model::InterpolationParameters>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) order_by_time: std::option::Option<crate::model::OrderByTime>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// Appends an item to `selected_properties`.
        ///
        /// To override the contents of this collection use [`set_selected_properties`](Self::set_selected_properties).
        ///
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn selected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_properties.unwrap_or_default();
            v.push(input.into());
            self.selected_properties = Some(v);
            self
        }
        /// <p>A list of properties whose value histories the request retrieves.</p>
        pub fn set_selected_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_properties = input;
            self
        }
        /// Appends an item to `property_filters`.
        ///
        /// To override the contents of this collection use [`set_property_filters`](Self::set_property_filters).
        ///
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn property_filters(mut self, input: impl Into<crate::model::PropertyFilter>) -> Self {
            let mut v = self.property_filters.unwrap_or_default();
            v.push(input.into());
            self.property_filters = Some(v);
            self
        }
        /// <p>A list of objects that filter the property value history request.</p>
        pub fn set_property_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyFilter>>,
        ) -> Self {
            self.property_filters = input;
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn start_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date_time = Some(input);
            self
        }
        /// <p>The date and time of the earliest property value to return.</p>
        pub fn set_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date_time = input;
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn end_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date_time = Some(input);
            self
        }
        /// <p>The date and time of the latest property value to return.</p>
        pub fn set_end_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date_time = input;
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn interpolation(mut self, input: crate::model::InterpolationParameters) -> Self {
            self.interpolation = Some(input);
            self
        }
        /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
        pub fn set_interpolation(
            mut self,
            input: std::option::Option<crate::model::InterpolationParameters>,
        ) -> Self {
            self.interpolation = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn order_by_time(mut self, input: crate::model::OrderByTime) -> Self {
            self.order_by_time = Some(input);
            self
        }
        /// <p>The time direction to use in the result order.</p>
        pub fn set_order_by_time(
            mut self,
            input: std::option::Option<crate::model::OrderByTime>,
        ) -> Self {
            self.order_by_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPropertyValueHistoryInput`](crate::input::GetPropertyValueHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPropertyValueHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPropertyValueHistoryInput {
                workspace_id: self.workspace_id,
                entity_id: self.entity_id,
                component_name: self.component_name,
                component_type_id: self.component_type_id,
                selected_properties: self.selected_properties,
                property_filters: self.property_filters,
                start_date_time: self.start_date_time,
                end_date_time: self.end_date_time,
                interpolation: self.interpolation,
                next_token: self.next_token,
                max_results: self.max_results,
                order_by_time: self.order_by_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPropertyValueHistoryInputOperationOutputAlias =
    crate::operation::GetPropertyValueHistory;
#[doc(hidden)]
pub type GetPropertyValueHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPropertyValueHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetPropertyValueHistory`](crate::operation::GetPropertyValueHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPropertyValueHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPropertyValueHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.workspace_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_20, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entity-properties/history",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPropertyValueHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPropertyValueHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_property_value_history(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPropertyValueHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPropertyValueHistory",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPropertyValueHistoryInput`](crate::input::GetPropertyValueHistoryInput)
    pub fn builder() -> crate::input::get_property_value_history_input::Builder {
        crate::input::get_property_value_history_input::Builder::default()
    }
}

/// See [`GetSceneInput`](crate::input::GetSceneInput)
pub mod get_scene_input {
    /// A builder for [`GetSceneInput`](crate::input::GetSceneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) scene_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSceneInput`](crate::input::GetSceneInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetSceneInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetSceneInput {
                workspace_id: self.workspace_id,
                scene_id: self.scene_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSceneInputOperationOutputAlias = crate::operation::GetScene;
#[doc(hidden)]
pub type GetSceneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSceneInput {
    /// Consumes the builder and constructs an Operation<[`GetScene`](crate::operation::GetScene)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetScene,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSceneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.workspace_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_21, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.scene_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scene_id",
                        details: "cannot be empty or unset",
                    })?;
            let scene_id = aws_smithy_http::label::fmt_string(input_22, false);
            if scene_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "scene_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/scenes/{sceneId}",
                workspaceId = workspace_id,
                sceneId = scene_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSceneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSceneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetScene::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetScene",
                    "iottwinmaker",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSceneInput`](crate::input::GetSceneInput)
    pub fn builder() -> crate::input::get_scene_input::Builder {
        crate::input::get_scene_input::Builder::default()
    }
}

/// See [`GetWorkspaceInput`](crate::input::GetWorkspaceInput)
pub mod get_workspace_input {
    /// A builder for [`GetWorkspaceInput`](crate::input::GetWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkspaceInput`](crate::input::GetWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkspaceInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkspaceInputOperationOutputAlias = crate::operation::GetWorkspace;
#[doc(hidden)]
pub type GetWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkspace`](crate::operation::GetWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.workspace_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_23, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkspace",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkspaceInput`](crate::input::GetWorkspaceInput)
    pub fn builder() -> crate::input::get_workspace_input::Builder {
        crate::input::get_workspace_input::Builder::default()
    }
}

/// See [`ListComponentTypesInput`](crate::input::ListComponentTypesInput)
pub mod list_component_types_input {
    /// A builder for [`ListComponentTypesInput`](crate::input::ListComponentTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ListComponentTypesFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ListComponentTypesFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListComponentTypesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentTypesInput`](crate::input::ListComponentTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentTypesInput {
                workspace_id: self.workspace_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentTypesInputOperationOutputAlias = crate::operation::ListComponentTypes;
#[doc(hidden)]
pub type ListComponentTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComponentTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListComponentTypes`](crate::operation::ListComponentTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponentTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComponentTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.workspace_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_24, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/component-types-list",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComponentTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComponentTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_component_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponentTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponentTypes",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComponentTypesInput`](crate::input::ListComponentTypesInput)
    pub fn builder() -> crate::input::list_component_types_input::Builder {
        crate::input::list_component_types_input::Builder::default()
    }
}

/// See [`ListEntitiesInput`](crate::input::ListEntitiesInput)
pub mod list_entities_input {
    /// A builder for [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ListEntitiesFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of objects that filter the request.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ListEntitiesFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A list of objects that filter the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListEntitiesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesInput`](crate::input::ListEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitiesInput {
                workspace_id: self.workspace_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitiesInputOperationOutputAlias = crate::operation::ListEntities;
#[doc(hidden)]
pub type ListEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListEntities`](crate::operation::ListEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.workspace_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_25, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entities-list",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_entities(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntities",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    pub fn builder() -> crate::input::list_entities_input::Builder {
        crate::input::list_entities_input::Builder::default()
    }
}

/// See [`ListScenesInput`](crate::input::ListScenesInput)
pub mod list_scenes_input {
    /// A builder for [`ListScenesInput`](crate::input::ListScenesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scenes.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListScenesInput`](crate::input::ListScenesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListScenesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListScenesInput {
                workspace_id: self.workspace_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListScenesInputOperationOutputAlias = crate::operation::ListScenes;
#[doc(hidden)]
pub type ListScenesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListScenesInput {
    /// Consumes the builder and constructs an Operation<[`ListScenes`](crate::operation::ListScenes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListScenes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListScenesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.workspace_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_26, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/scenes-list",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListScenesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListScenesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_scenes(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListScenes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListScenes",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListScenesInput`](crate::input::ListScenesInput)
    pub fn builder() -> crate::input::list_scenes_input::Builder {
        crate::input::list_scenes_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags-list").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
pub mod list_workspaces_input {
    /// A builder for [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to display.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to display.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkspacesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkspacesInputOperationOutputAlias = crate::operation::ListWorkspaces;
#[doc(hidden)]
pub type ListWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkspaces`](crate::operation::ListWorkspaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/workspaces-list").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_workspaces(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkspaces",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    pub fn builder() -> crate::input::list_workspaces_input::Builder {
        crate::input::list_workspaces_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata to add to this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Metadata to add to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.resource_arn {
                query.push_kv(
                    "resourceARN",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
            if let Some(inner_28) = &_input.tag_keys {
                for inner_29 in inner_28 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_29));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateComponentTypeInput`](crate::input::UpdateComponentTypeInput)
pub mod update_component_type_input {
    /// A builder for [`UpdateComponentTypeInput`](crate::input::UpdateComponentTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) is_singleton: std::option::Option<bool>,
        pub(crate) component_type_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) property_definitions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
        >,
        pub(crate) extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) functions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
        >,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the component type.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this
        /// type.</p>
        pub fn is_singleton(mut self, input: bool) -> Self {
            self.is_singleton = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether an entity can have more than one component of this
        /// type.</p>
        pub fn set_is_singleton(mut self, input: std::option::Option<bool>) -> Self {
            self.is_singleton = input;
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn component_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type_id = Some(input.into());
            self
        }
        /// <p>The ID of the component type.</p>
        pub fn set_component_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type_id = input;
            self
        }
        /// <p>The description of the component type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `property_definitions`.
        ///
        /// To override the contents of this collection use [`set_property_definitions`](Self::set_property_definitions).
        ///
        /// <p>An object that maps strings to the property definitions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn property_definitions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PropertyDefinitionRequest>,
        ) -> Self {
            let mut hash_map = self.property_definitions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.property_definitions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the property definitions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_property_definitions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PropertyDefinitionRequest,
                >,
            >,
        ) -> Self {
            self.property_definitions = input;
            self
        }
        /// Appends an item to `extends_from`.
        ///
        /// To override the contents of this collection use [`set_extends_from`](Self::set_extends_from).
        ///
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn extends_from(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.extends_from.unwrap_or_default();
            v.push(input.into());
            self.extends_from = Some(v);
            self
        }
        /// <p>Specifies the component type that this component type extends.</p>
        pub fn set_extends_from(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.extends_from = input;
            self
        }
        /// Adds a key-value pair to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>An object that maps strings to the functions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn functions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::FunctionRequest>,
        ) -> Self {
            let mut hash_map = self.functions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.functions = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the functions in the component type. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
            >,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateComponentTypeInput`](crate::input::UpdateComponentTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateComponentTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateComponentTypeInput {
                workspace_id: self.workspace_id,
                is_singleton: self.is_singleton,
                component_type_id: self.component_type_id,
                description: self.description,
                property_definitions: self.property_definitions,
                extends_from: self.extends_from,
                functions: self.functions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateComponentTypeInputOperationOutputAlias = crate::operation::UpdateComponentType;
#[doc(hidden)]
pub type UpdateComponentTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateComponentTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateComponentType`](crate::operation::UpdateComponentType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateComponentType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateComponentTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.workspace_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_30, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.component_type_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "component_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let component_type_id = aws_smithy_http::label::fmt_string(input_31, false);
            if component_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "component_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/component-types/{componentTypeId}",
                workspaceId = workspace_id,
                componentTypeId = component_type_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateComponentTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateComponentTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_component_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateComponentType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateComponentType",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateComponentTypeInput`](crate::input::UpdateComponentTypeInput)
    pub fn builder() -> crate::input::update_component_type_input::Builder {
        crate::input::update_component_type_input::Builder::default()
    }
}

/// See [`UpdateEntityInput`](crate::input::UpdateEntityInput)
pub mod update_entity_input {
    /// A builder for [`UpdateEntityInput`](crate::input::UpdateEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) entity_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) component_updates: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ComponentUpdateRequest>,
        >,
        pub(crate) parent_entity_update:
            std::option::Option<crate::model::ParentEntityUpdateRequest>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the entity.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The name of the entity.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The name of the entity.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// <p>The description of the entity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `component_updates`.
        ///
        /// To override the contents of this collection use [`set_component_updates`](Self::set_component_updates).
        ///
        /// <p>An object that maps strings to the component updates in the request. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn component_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ComponentUpdateRequest>,
        ) -> Self {
            let mut hash_map = self.component_updates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.component_updates = Some(hash_map);
            self
        }
        /// <p>An object that maps strings to the component updates in the request. Each string
        /// in the mapping must be unique to this object.</p>
        pub fn set_component_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentUpdateRequest,
                >,
            >,
        ) -> Self {
            self.component_updates = input;
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn parent_entity_update(
            mut self,
            input: crate::model::ParentEntityUpdateRequest,
        ) -> Self {
            self.parent_entity_update = Some(input);
            self
        }
        /// <p>An object that describes the update request for a parent entity.</p>
        pub fn set_parent_entity_update(
            mut self,
            input: std::option::Option<crate::model::ParentEntityUpdateRequest>,
        ) -> Self {
            self.parent_entity_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEntityInput`](crate::input::UpdateEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEntityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEntityInput {
                workspace_id: self.workspace_id,
                entity_id: self.entity_id,
                entity_name: self.entity_name,
                description: self.description,
                component_updates: self.component_updates,
                parent_entity_update: self.parent_entity_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEntityInputOperationOutputAlias = crate::operation::UpdateEntity;
#[doc(hidden)]
pub type UpdateEntityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEntityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEntity`](crate::operation::UpdateEntity)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEntity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.workspace_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_32, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.entity_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "entity_id",
                        details: "cannot be empty or unset",
                    })?;
            let entity_id = aws_smithy_http::label::fmt_string(input_33, false);
            if entity_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "entity_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/entities/{entityId}",
                workspaceId = workspace_id,
                entityId = entity_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_entity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEntity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEntity",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEntityInput`](crate::input::UpdateEntityInput)
    pub fn builder() -> crate::input::update_entity_input::Builder {
        crate::input::update_entity_input::Builder::default()
    }
}

/// See [`UpdateSceneInput`](crate::input::UpdateSceneInput)
pub mod update_scene_input {
    /// A builder for [`UpdateSceneInput`](crate::input::UpdateSceneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) scene_id: std::option::Option<std::string::String>,
        pub(crate) content_location: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace that contains the scene.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn scene_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.scene_id = Some(input.into());
            self
        }
        /// <p>The ID of the scene.</p>
        pub fn set_scene_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scene_id = input;
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn content_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_location = Some(input.into());
            self
        }
        /// <p>The relative path that specifies the location of the content definition file.</p>
        pub fn set_content_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_location = input;
            self
        }
        /// <p>The description of this scene.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of this scene.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn capabilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input.into());
            self.capabilities = Some(v);
            self
        }
        /// <p>A list of capabilities that the scene uses to render.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSceneInput`](crate::input::UpdateSceneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSceneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSceneInput {
                workspace_id: self.workspace_id,
                scene_id: self.scene_id,
                content_location: self.content_location,
                description: self.description,
                capabilities: self.capabilities,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSceneInputOperationOutputAlias = crate::operation::UpdateScene;
#[doc(hidden)]
pub type UpdateSceneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSceneInput {
    /// Consumes the builder and constructs an Operation<[`UpdateScene`](crate::operation::UpdateScene)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateScene,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSceneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.workspace_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_34, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.scene_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scene_id",
                        details: "cannot be empty or unset",
                    })?;
            let scene_id = aws_smithy_http::label::fmt_string(input_35, false);
            if scene_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "scene_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/scenes/{sceneId}",
                workspaceId = workspace_id,
                sceneId = scene_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSceneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSceneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_scene(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateScene::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateScene",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSceneInput`](crate::input::UpdateSceneInput)
    pub fn builder() -> crate::input::update_scene_input::Builder {
        crate::input::update_scene_input::Builder::default()
    }
}

/// See [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
pub mod update_workspace_input {
    /// A builder for [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The ARN of the execution role associated with the workspace.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkspaceInput {
                workspace_id: self.workspace_id,
                description: self.description,
                role: self.role,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkspaceInputOperationOutputAlias = crate::operation::UpdateWorkspace;
#[doc(hidden)]
pub type UpdateWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkspace`](crate::operation::UpdateWorkspace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.workspace_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_36, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkspace",
            "iottwinmaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    pub fn builder() -> crate::input::update_workspace_input::Builder {
        crate::input::update_workspace_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub role: std::option::Option<std::string::String>,
}
impl UpdateWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("description", &self.description);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the scene.</p>
    pub scene_id: std::option::Option<std::string::String>,
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub content_location: std::option::Option<std::string::String>,
    /// <p>The description of this scene.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of capabilities that the scene uses to render.</p>
    pub capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the scene.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub fn content_location(&self) -> std::option::Option<&str> {
        self.content_location.as_deref()
    }
    /// <p>The description of this scene.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of capabilities that the scene uses to render.</p>
    pub fn capabilities(&self) -> std::option::Option<&[std::string::String]> {
        self.capabilities.as_deref()
    }
}
impl std::fmt::Debug for UpdateSceneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSceneInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("scene_id", &self.scene_id);
        formatter.field("content_location", &self.content_location);
        formatter.field("description", &self.description);
        formatter.field("capabilities", &self.capabilities);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEntityInput {
    /// <p>The ID of the workspace that contains the entity.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the entity.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>The description of the entity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the component updates in the request. Each string
    /// in the mapping must be unique to this object.</p>
    pub component_updates: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentUpdateRequest>,
    >,
    /// <p>An object that describes the update request for a parent entity.</p>
    pub parent_entity_update: std::option::Option<crate::model::ParentEntityUpdateRequest>,
}
impl UpdateEntityInput {
    /// <p>The ID of the workspace that contains the entity.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the entity.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>The description of the entity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the component updates in the request. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn component_updates(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentUpdateRequest>,
    > {
        self.component_updates.as_ref()
    }
    /// <p>An object that describes the update request for a parent entity.</p>
    pub fn parent_entity_update(
        &self,
    ) -> std::option::Option<&crate::model::ParentEntityUpdateRequest> {
        self.parent_entity_update.as_ref()
    }
}
impl std::fmt::Debug for UpdateEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEntityInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("entity_name", &self.entity_name);
        formatter.field("description", &self.description);
        formatter.field("component_updates", &self.component_updates);
        formatter.field("parent_entity_update", &self.parent_entity_update);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether an entity can have more than one component of this
    /// type.</p>
    pub is_singleton: std::option::Option<bool>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the property definitions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub property_definitions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
    >,
    /// <p>Specifies the component type that this component type extends.</p>
    pub extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object that maps strings to the functions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub functions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
    >,
}
impl UpdateComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A Boolean value that specifies whether an entity can have more than one component of this
    /// type.</p>
    pub fn is_singleton(&self) -> std::option::Option<bool> {
        self.is_singleton
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the property definitions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn property_definitions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
    > {
        self.property_definitions.as_ref()
    }
    /// <p>Specifies the component type that this component type extends.</p>
    pub fn extends_from(&self) -> std::option::Option<&[std::string::String]> {
        self.extends_from.as_deref()
    }
    /// <p>An object that maps strings to the functions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn functions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
    > {
        self.functions.as_ref()
    }
}
impl std::fmt::Debug for UpdateComponentTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateComponentTypeInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("is_singleton", &self.is_singleton);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("description", &self.description);
        formatter.field("property_definitions", &self.property_definitions);
        formatter.field("extends_from", &self.extends_from);
        formatter.field("functions", &self.functions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Metadata to add to this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Metadata to add to this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkspacesInput {
    /// <p>The maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkspacesInput {
    /// <p>The maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkspacesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListScenesInput {
    /// <p>The ID of the workspace that contains the scenes.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListScenesInput {
    /// <p>The ID of the workspace that contains the scenes.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>Specifies the maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListScenesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListScenesInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitiesInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A list of objects that filter the request.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ListEntitiesFilter>>,
    /// <p>The maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEntitiesInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A list of objects that filter the request.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ListEntitiesFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitiesInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentTypesInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A list of objects that filter the request.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ListComponentTypesFilter>>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to display.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListComponentTypesInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A list of objects that filter the request.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ListComponentTypesFilter]> {
        self.filters.as_deref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to display.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListComponentTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentTypesInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl GetWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for GetWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the scene.</p>
    pub scene_id: std::option::Option<std::string::String>,
}
impl GetSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the scene.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
}
impl std::fmt::Debug for GetSceneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSceneInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("scene_id", &self.scene_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPropertyValueHistoryInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>A list of properties whose value histories the request retrieves.</p>
    pub selected_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of objects that filter the property value history request.</p>
    pub property_filters: std::option::Option<std::vec::Vec<crate::model::PropertyFilter>>,
    /// <p>The date and time of the earliest property value to return.</p>
    pub start_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time of the latest property value to return.</p>
    pub end_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
    pub interpolation: std::option::Option<crate::model::InterpolationParameters>,
    /// <p>The string that specifies the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The time direction to use in the result order.</p>
    pub order_by_time: std::option::Option<crate::model::OrderByTime>,
}
impl GetPropertyValueHistoryInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>A list of properties whose value histories the request retrieves.</p>
    pub fn selected_properties(&self) -> std::option::Option<&[std::string::String]> {
        self.selected_properties.as_deref()
    }
    /// <p>A list of objects that filter the property value history request.</p>
    pub fn property_filters(&self) -> std::option::Option<&[crate::model::PropertyFilter]> {
        self.property_filters.as_deref()
    }
    /// <p>The date and time of the earliest property value to return.</p>
    pub fn start_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date_time.as_ref()
    }
    /// <p>The date and time of the latest property value to return.</p>
    pub fn end_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date_time.as_ref()
    }
    /// <p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>
    pub fn interpolation(&self) -> std::option::Option<&crate::model::InterpolationParameters> {
        self.interpolation.as_ref()
    }
    /// <p>The string that specifies the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The time direction to use in the result order.</p>
    pub fn order_by_time(&self) -> std::option::Option<&crate::model::OrderByTime> {
        self.order_by_time.as_ref()
    }
}
impl std::fmt::Debug for GetPropertyValueHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPropertyValueHistoryInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("component_name", &self.component_name);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("selected_properties", &self.selected_properties);
        formatter.field("property_filters", &self.property_filters);
        formatter.field("start_date_time", &self.start_date_time);
        formatter.field("end_date_time", &self.end_date_time);
        formatter.field("interpolation", &self.interpolation);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("order_by_time", &self.order_by_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPropertyValueInput {
    /// <p>The name of the component whose property values the operation returns.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The ID of the component type whose property values the operation returns.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity whose property values the operation returns.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The properties whose values the operation returns.</p>
    pub selected_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the workspace whose values the operation returns.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl GetPropertyValueInput {
    /// <p>The name of the component whose property values the operation returns.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The ID of the component type whose property values the operation returns.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The ID of the entity whose property values the operation returns.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The properties whose values the operation returns.</p>
    pub fn selected_properties(&self) -> std::option::Option<&[std::string::String]> {
        self.selected_properties.as_deref()
    }
    /// <p>The ID of the workspace whose values the operation returns.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for GetPropertyValueInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPropertyValueInput");
        formatter.field("component_name", &self.component_name);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("selected_properties", &self.selected_properties);
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntityInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl GetEntityInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for GetEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntityInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
}
impl GetComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
}
impl std::fmt::Debug for GetComponentTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentTypeInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceInput {
    /// <p>The ID of the workspace to delete.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl DeleteWorkspaceInput {
    /// <p>The ID of the workspace to delete.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSceneInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the scene to delete.</p>
    pub scene_id: std::option::Option<std::string::String>,
}
impl DeleteSceneInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the scene to delete.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSceneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSceneInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("scene_id", &self.scene_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntityInput {
    /// <p>The ID of the workspace that contains the entity to delete.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity to delete.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
    pub is_recursive: std::option::Option<bool>,
}
impl DeleteEntityInput {
    /// <p>The ID of the workspace that contains the entity to delete.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the entity to delete.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>A Boolean value that specifies whether the operation deletes child entities.</p>
    pub fn is_recursive(&self) -> std::option::Option<bool> {
        self.is_recursive
    }
}
impl std::fmt::Debug for DeleteEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntityInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("is_recursive", &self.is_recursive);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the component type to delete.</p>
    pub component_type_id: std::option::Option<std::string::String>,
}
impl DeleteComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the component type to delete.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteComponentTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentTypeInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    pub s3_location: std::option::Option<std::string::String>,
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>Metadata that you can use to manage the workspace</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorkspaceInput {
    /// <p>The ID of the workspace.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>
    pub fn s3_location(&self) -> std::option::Option<&str> {
        self.s3_location.as_deref()
    }
    /// <p>The ARN of the execution role associated with the workspace.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>Metadata that you can use to manage the workspace</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("description", &self.description);
        formatter.field("s3_location", &self.s3_location);
        formatter.field("role", &self.role);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the scene.</p>
    pub scene_id: std::option::Option<std::string::String>,
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub content_location: std::option::Option<std::string::String>,
    /// <p>The description for this scene.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of capabilities that the scene uses to render itself.</p>
    pub capabilities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Metadata that you can use to manage the scene.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateSceneInput {
    /// <p>The ID of the workspace that contains the scene.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the scene.</p>
    pub fn scene_id(&self) -> std::option::Option<&str> {
        self.scene_id.as_deref()
    }
    /// <p>The relative path that specifies the location of the content definition file.</p>
    pub fn content_location(&self) -> std::option::Option<&str> {
        self.content_location.as_deref()
    }
    /// <p>The description for this scene.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of capabilities that the scene uses to render itself.</p>
    pub fn capabilities(&self) -> std::option::Option<&[std::string::String]> {
        self.capabilities.as_deref()
    }
    /// <p>Metadata that you can use to manage the scene.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateSceneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSceneInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("scene_id", &self.scene_id);
        formatter.field("content_location", &self.content_location);
        formatter.field("description", &self.description);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEntityInput {
    /// <p>The ID of the workspace that contains the entity.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The ID of the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The name of the entity.</p>
    pub entity_name: std::option::Option<std::string::String>,
    /// <p>The description of the entity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the components in the entity. Each string
    /// in the mapping must be unique to this object.</p>
    pub components: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
    >,
    /// <p>The ID of the entity's parent entity.</p>
    pub parent_entity_id: std::option::Option<std::string::String>,
    /// <p>Metadata that you can use to manage the entity.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateEntityInput {
    /// <p>The ID of the workspace that contains the entity.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The ID of the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The name of the entity.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
    /// <p>The description of the entity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the components in the entity. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn components(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ComponentRequest>,
    > {
        self.components.as_ref()
    }
    /// <p>The ID of the entity's parent entity.</p>
    pub fn parent_entity_id(&self) -> std::option::Option<&str> {
        self.parent_entity_id.as_deref()
    }
    /// <p>Metadata that you can use to manage the entity.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEntityInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("entity_name", &self.entity_name);
        formatter.field("description", &self.description);
        formatter.field("components", &self.components);
        formatter.field("parent_entity_id", &self.parent_entity_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value that specifies whether an entity can have more than one component of
    /// this type.</p>
    pub is_singleton: std::option::Option<bool>,
    /// <p>The ID of the component type.</p>
    pub component_type_id: std::option::Option<std::string::String>,
    /// <p>The description of the component type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the property definitions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub property_definitions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
    >,
    /// <p>Specifies the parent component type to extend.</p>
    pub extends_from: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object that maps strings to the functions in the component type. Each string in the
    /// mapping must be unique to this object.</p>
    pub functions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
    >,
    /// <p>Metadata that you can use to manage the component type.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateComponentTypeInput {
    /// <p>The ID of the workspace that contains the component type.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A Boolean value that specifies whether an entity can have more than one component of
    /// this type.</p>
    pub fn is_singleton(&self) -> std::option::Option<bool> {
        self.is_singleton
    }
    /// <p>The ID of the component type.</p>
    pub fn component_type_id(&self) -> std::option::Option<&str> {
        self.component_type_id.as_deref()
    }
    /// <p>The description of the component type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object that maps strings to the property definitions in the component type. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn property_definitions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PropertyDefinitionRequest>,
    > {
        self.property_definitions.as_ref()
    }
    /// <p>Specifies the parent component type to extend.</p>
    pub fn extends_from(&self) -> std::option::Option<&[std::string::String]> {
        self.extends_from.as_deref()
    }
    /// <p>An object that maps strings to the functions in the component type. Each string in the
    /// mapping must be unique to this object.</p>
    pub fn functions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::FunctionRequest>,
    > {
        self.functions.as_ref()
    }
    /// <p>Metadata that you can use to manage the component type.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateComponentTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentTypeInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("is_singleton", &self.is_singleton);
        formatter.field("component_type_id", &self.component_type_id);
        formatter.field("description", &self.description);
        formatter.field("property_definitions", &self.property_definitions);
        formatter.field("extends_from", &self.extends_from);
        formatter.field("functions", &self.functions);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutPropertyValuesInput {
    /// <p>The ID of the workspace that contains the properties to set.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>An object that maps strings to the property value entries to set. Each string
    /// in the mapping must be unique to this object.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PropertyValueEntry>>,
}
impl BatchPutPropertyValuesInput {
    /// <p>The ID of the workspace that contains the properties to set.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>An object that maps strings to the property value entries to set. Each string
    /// in the mapping must be unique to this object.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PropertyValueEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for BatchPutPropertyValuesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutPropertyValuesInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}
