// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchPutPropertyValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutPropertyValuesError {
    /// Kind of error that occurred.
    pub kind: BatchPutPropertyValuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutPropertyValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutPropertyValuesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutPropertyValuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutPropertyValuesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchPutPropertyValuesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchPutPropertyValuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchPutPropertyValuesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchPutPropertyValuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutPropertyValuesError {
    fn code(&self) -> Option<&str> {
        BatchPutPropertyValuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutPropertyValuesError {
    /// Creates a new `BatchPutPropertyValuesError`.
    pub fn new(kind: BatchPutPropertyValuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutPropertyValuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutPropertyValuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutPropertyValuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutPropertyValuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchPutPropertyValuesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutPropertyValuesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutPropertyValuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutPropertyValuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutPropertyValuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutPropertyValuesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutPropertyValuesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutPropertyValuesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchPutPropertyValuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutPropertyValuesErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchPutPropertyValuesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchPutPropertyValuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchPutPropertyValuesErrorKind::ValidationException(_inner) => Some(_inner),
            BatchPutPropertyValuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateComponentTypeError {
    /// Kind of error that occurred.
    pub kind: CreateComponentTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateComponentTypeErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateComponentTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateComponentTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateComponentTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateComponentTypeError {
    fn code(&self) -> Option<&str> {
        CreateComponentTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateComponentTypeError {
    /// Creates a new `CreateComponentTypeError`.
    pub fn new(kind: CreateComponentTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateComponentTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateComponentTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateComponentTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateComponentTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateComponentTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateComponentTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::ConflictException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::ValidationException(_inner) => Some(_inner),
            CreateComponentTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEntityError {
    /// Kind of error that occurred.
    pub kind: CreateEntityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEntityErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEntityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEntityErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEntityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEntityError {
    fn code(&self) -> Option<&str> {
        CreateEntityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEntityError {
    /// Creates a new `CreateEntityError`.
    pub fn new(kind: CreateEntityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEntityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEntityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEntityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEntityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateEntityErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateEntityErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEntityErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateEntityErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateEntityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateEntityErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateEntityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEntityErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEntityErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEntityErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEntityErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateEntityErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEntityErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEntityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSceneError {
    /// Kind of error that occurred.
    pub kind: CreateSceneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSceneErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSceneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSceneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSceneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSceneError {
    fn code(&self) -> Option<&str> {
        CreateSceneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSceneError {
    /// Creates a new `CreateSceneError`.
    pub fn new(kind: CreateSceneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSceneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSceneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSceneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSceneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateSceneErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSceneErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateSceneErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSceneErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateSceneErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateSceneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSceneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSceneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSceneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSceneErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSceneErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSceneErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateSceneErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSceneErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSceneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: CreateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkspaceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkspaceError {
    fn code(&self) -> Option<&str> {
        CreateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkspaceError {
    /// Creates a new `CreateWorkspaceError`.
    pub fn new(kind: CreateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteComponentTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteComponentTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteComponentTypeErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteComponentTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteComponentTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteComponentTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteComponentTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteComponentTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteComponentTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteComponentTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteComponentTypeError {
    fn code(&self) -> Option<&str> {
        DeleteComponentTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteComponentTypeError {
    /// Creates a new `DeleteComponentTypeError`.
    pub fn new(kind: DeleteComponentTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteComponentTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteComponentTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteComponentTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteComponentTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteComponentTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteComponentTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteComponentTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteComponentTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteComponentTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteComponentTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteComponentTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteComponentTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEntityError {
    /// Kind of error that occurred.
    pub kind: DeleteEntityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEntityErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEntityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEntityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEntityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEntityErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteEntityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEntityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEntityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEntityError {
    fn code(&self) -> Option<&str> {
        DeleteEntityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEntityError {
    /// Creates a new `DeleteEntityError`.
    pub fn new(kind: DeleteEntityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEntityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEntityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEntityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEntityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEntityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEntityErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEntityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteEntityErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteEntityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteEntityErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteEntityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEntityErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEntityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEntityErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteEntityErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEntityErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEntityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSceneError {
    /// Kind of error that occurred.
    pub kind: DeleteSceneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSceneErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSceneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSceneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSceneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSceneErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSceneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSceneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSceneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSceneError {
    fn code(&self) -> Option<&str> {
        DeleteSceneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSceneError {
    /// Creates a new `DeleteSceneError`.
    pub fn new(kind: DeleteSceneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSceneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSceneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSceneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSceneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSceneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSceneErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteSceneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteSceneErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteSceneErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSceneErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSceneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSceneErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSceneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSceneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSceneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSceneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSceneErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSceneErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSceneErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSceneErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSceneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkspaceError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkspaceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkspaceError {
    fn code(&self) -> Option<&str> {
        DeleteWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkspaceError {
    /// Creates a new `DeleteWorkspaceError`.
    pub fn new(kind: DeleteWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComponentTypeError {
    /// Kind of error that occurred.
    pub kind: GetComponentTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComponentTypeErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComponentTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComponentTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetComponentTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetComponentTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetComponentTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetComponentTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComponentTypeError {
    fn code(&self) -> Option<&str> {
        GetComponentTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComponentTypeError {
    /// Creates a new `GetComponentTypeError`.
    pub fn new(kind: GetComponentTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComponentTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComponentTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComponentTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComponentTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComponentTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentTypeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetComponentTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComponentTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetComponentTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            GetComponentTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetComponentTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetComponentTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEntityError {
    /// Kind of error that occurred.
    pub kind: GetEntityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEntityErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEntityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEntityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEntityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEntityErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetEntityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEntityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEntityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEntityError {
    fn code(&self) -> Option<&str> {
        GetEntityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEntityError {
    /// Creates a new `GetEntityError`.
    pub fn new(kind: GetEntityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEntityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEntityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEntityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEntityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEntityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetEntityErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetEntityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetEntityErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetEntityErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEntityErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEntityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEntityErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetEntityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEntityErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEntityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEntityErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEntityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEntityErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetEntityErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEntityErrorKind::ValidationException(_inner) => Some(_inner),
            GetEntityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPropertyValueError {
    /// Kind of error that occurred.
    pub kind: GetPropertyValueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPropertyValueErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The connector failed.</p>
    ConnectorFailureException(crate::error::ConnectorFailureException),
    /// <p>The connector timed out.</p>
    ConnectorTimeoutException(crate::error::ConnectorTimeoutException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPropertyValueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPropertyValueErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::ConnectorFailureException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::ConnectorTimeoutException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPropertyValueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPropertyValueError {
    fn code(&self) -> Option<&str> {
        GetPropertyValueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPropertyValueError {
    /// Creates a new `GetPropertyValueError`.
    pub fn new(kind: GetPropertyValueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPropertyValueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPropertyValueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPropertyValueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPropertyValueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::ConnectorFailureException`.
    pub fn is_connector_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::ConnectorFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::ConnectorTimeoutException`.
    pub fn is_connector_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::ConnectorTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPropertyValueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPropertyValueErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::ConnectorFailureException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::ConnectorTimeoutException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::ValidationException(_inner) => Some(_inner),
            GetPropertyValueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPropertyValueHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPropertyValueHistoryError {
    /// Kind of error that occurred.
    pub kind: GetPropertyValueHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPropertyValueHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPropertyValueHistoryErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The connector failed.</p>
    ConnectorFailureException(crate::error::ConnectorFailureException),
    /// <p>The connector timed out.</p>
    ConnectorTimeoutException(crate::error::ConnectorTimeoutException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPropertyValueHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPropertyValueHistoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::ConnectorFailureException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::ConnectorTimeoutException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPropertyValueHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPropertyValueHistoryError {
    fn code(&self) -> Option<&str> {
        GetPropertyValueHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPropertyValueHistoryError {
    /// Creates a new `GetPropertyValueHistoryError`.
    pub fn new(kind: GetPropertyValueHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPropertyValueHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPropertyValueHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPropertyValueHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPropertyValueHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::ConnectorFailureException`.
    pub fn is_connector_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::ConnectorFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::ConnectorTimeoutException`.
    pub fn is_connector_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::ConnectorTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPropertyValueHistoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPropertyValueHistoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPropertyValueHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPropertyValueHistoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::ConnectorFailureException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::ConnectorTimeoutException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetPropertyValueHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSceneError {
    /// Kind of error that occurred.
    pub kind: GetSceneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSceneErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSceneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSceneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSceneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSceneErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSceneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSceneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSceneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSceneError {
    fn code(&self) -> Option<&str> {
        GetSceneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSceneError {
    /// Creates a new `GetSceneError`.
    pub fn new(kind: GetSceneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSceneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSceneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSceneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSceneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSceneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSceneErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSceneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetSceneErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetSceneErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSceneErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSceneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetSceneErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetSceneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSceneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetSceneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSceneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSceneErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSceneErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSceneErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSceneErrorKind::ValidationException(_inner) => Some(_inner),
            GetSceneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkspaceError {
    /// Kind of error that occurred.
    pub kind: GetWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkspaceErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkspaceError {
    fn code(&self) -> Option<&str> {
        GetWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkspaceError {
    /// Creates a new `GetWorkspaceError`.
    pub fn new(kind: GetWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkspaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkspaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            GetWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComponentTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComponentTypesError {
    /// Kind of error that occurred.
    pub kind: ListComponentTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComponentTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComponentTypesErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComponentTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComponentTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListComponentTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListComponentTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListComponentTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListComponentTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComponentTypesError {
    fn code(&self) -> Option<&str> {
        ListComponentTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComponentTypesError {
    /// Creates a new `ListComponentTypesError`.
    pub fn new(kind: ListComponentTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComponentTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComponentTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComponentTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComponentTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComponentTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentTypesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListComponentTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComponentTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListComponentTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListComponentTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListComponentTypesErrorKind::ValidationException(_inner) => Some(_inner),
            ListComponentTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntitiesError {
    /// Kind of error that occurred.
    pub kind: ListEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntitiesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntitiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEntitiesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListEntitiesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEntitiesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntitiesError {
    fn code(&self) -> Option<&str> {
        ListEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntitiesError {
    /// Creates a new `ListEntitiesError`.
    pub fn new(kind: ListEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntitiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListEntitiesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListEntitiesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListEntitiesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntitiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEntitiesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListEntitiesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEntitiesErrorKind::ValidationException(_inner) => Some(_inner),
            ListEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListScenes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListScenesError {
    /// Kind of error that occurred.
    pub kind: ListScenesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListScenes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListScenesErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListScenesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListScenesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListScenesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListScenesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListScenesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListScenesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListScenesError {
    fn code(&self) -> Option<&str> {
        ListScenesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListScenesError {
    /// Creates a new `ListScenesError`.
    pub fn new(kind: ListScenesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListScenesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListScenesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListScenesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListScenesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListScenesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListScenesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListScenesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListScenesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListScenesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListScenesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListScenesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListScenesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListScenesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListScenesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListScenesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListScenesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListScenesErrorKind::ValidationException(_inner) => Some(_inner),
            ListScenesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkspacesError {
    /// Kind of error that occurred.
    pub kind: ListWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkspacesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkspacesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkspacesError {
    fn code(&self) -> Option<&str> {
        ListWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkspacesError {
    /// Creates a new `ListWorkspacesError`.
    pub fn new(kind: ListWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListWorkspacesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListWorkspacesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkspacesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ValidationException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of tags exceeds the limit.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateComponentTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateComponentTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateComponentType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateComponentTypeErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateComponentTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateComponentTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateComponentTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateComponentTypeError {
    fn code(&self) -> Option<&str> {
        UpdateComponentTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateComponentTypeError {
    /// Creates a new `UpdateComponentTypeError`.
    pub fn new(kind: UpdateComponentTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateComponentTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateComponentTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateComponentTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateComponentTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateComponentTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateComponentTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateComponentTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateComponentTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateComponentTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEntityError {
    /// Kind of error that occurred.
    pub kind: UpdateEntityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEntity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEntityErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEntityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEntityErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEntityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEntityError {
    fn code(&self) -> Option<&str> {
        UpdateEntityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEntityError {
    /// Creates a new `UpdateEntityError`.
    pub fn new(kind: UpdateEntityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEntityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEntityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEntityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEntityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateEntityErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateEntityErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEntityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEntityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEntityErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateEntityErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateEntityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateEntityErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateEntityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEntityErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEntityErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEntityErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEntityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEntityErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateEntityErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEntityErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEntityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSceneError {
    /// Kind of error that occurred.
    pub kind: UpdateSceneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateScene` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSceneErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSceneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSceneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSceneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSceneErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSceneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSceneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSceneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSceneError {
    fn code(&self) -> Option<&str> {
        UpdateSceneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSceneError {
    /// Creates a new `UpdateSceneError`.
    pub fn new(kind: UpdateSceneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSceneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSceneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSceneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSceneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSceneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateSceneErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateSceneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateSceneErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateSceneErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSceneErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSceneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateSceneErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateSceneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSceneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSceneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSceneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSceneErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSceneErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSceneErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSceneErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSceneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceErrorKind {
    /// <p>Access is denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An unexpected error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota was exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Failed</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkspaceError {
    /// Creates a new `UpdateWorkspaceError`.
    pub fn new(kind: UpdateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Failed</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The rate exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service quota was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The resource wasn't found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An unexpected error has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Access is denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A conflict occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The number of tags exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The connector timed out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorTimeoutException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectorTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConnectorTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConnectorTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConnectorTimeoutException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConnectorTimeoutException {}
/// See [`ConnectorTimeoutException`](crate::error::ConnectorTimeoutException)
pub mod connector_timeout_exception {
    /// A builder for [`ConnectorTimeoutException`](crate::error::ConnectorTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorTimeoutException`](crate::error::ConnectorTimeoutException)
        pub fn build(self) -> crate::error::ConnectorTimeoutException {
            crate::error::ConnectorTimeoutException {
                message: self.message,
            }
        }
    }
}
impl ConnectorTimeoutException {
    /// Creates a new builder-style object to manufacture [`ConnectorTimeoutException`](crate::error::ConnectorTimeoutException)
    pub fn builder() -> crate::error::connector_timeout_exception::Builder {
        crate::error::connector_timeout_exception::Builder::default()
    }
}

/// <p>The connector failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectorFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConnectorFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConnectorFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConnectorFailureException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConnectorFailureException {}
/// See [`ConnectorFailureException`](crate::error::ConnectorFailureException)
pub mod connector_failure_exception {
    /// A builder for [`ConnectorFailureException`](crate::error::ConnectorFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorFailureException`](crate::error::ConnectorFailureException)
        pub fn build(self) -> crate::error::ConnectorFailureException {
            crate::error::ConnectorFailureException {
                message: self.message,
            }
        }
    }
}
impl ConnectorFailureException {
    /// Creates a new builder-style object to manufacture [`ConnectorFailureException`](crate::error::ConnectorFailureException)
    pub fn builder() -> crate::error::connector_failure_exception::Builder {
        crate::error::connector_failure_exception::Builder::default()
    }
}
