// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Things Graph
///
/// Client for invoking operations on AWS IoT Things Graph. Each operation on AWS IoT Things Graph is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotthingsgraph::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotthingsgraph::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotthingsgraph::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateEntityToThing`](crate::client::fluent_builders::AssociateEntityToThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::AssociateEntityToThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::AssociateEntityToThing::set_thing_name): <p>The name of the thing to which the entity is to be associated.</p>
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::AssociateEntityToThing::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::AssociateEntityToThing::set_entity_id): <p>The ID of the device to be associated with the thing.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
    ///   - [`namespace_version(i64)`](crate::client::fluent_builders::AssociateEntityToThing::namespace_version) / [`set_namespace_version(Option<i64>)`](crate::client::fluent_builders::AssociateEntityToThing::set_namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    /// - On success, responds with [`AssociateEntityToThingOutput`](crate::output::AssociateEntityToThingOutput)

    /// - On failure, responds with [`SdkError<AssociateEntityToThingError>`](crate::error::AssociateEntityToThingError)
    pub fn associate_entity_to_thing(&self) -> fluent_builders::AssociateEntityToThing {
        fluent_builders::AssociateEntityToThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFlowTemplate`](crate::client::fluent_builders::CreateFlowTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`definition(DefinitionDocument)`](crate::client::fluent_builders::CreateFlowTemplate::definition) / [`set_definition(Option<DefinitionDocument>)`](crate::client::fluent_builders::CreateFlowTemplate::set_definition): <p>The workflow <code>DefinitionDocument</code>.</p>
    ///   - [`compatible_namespace_version(i64)`](crate::client::fluent_builders::CreateFlowTemplate::compatible_namespace_version) / [`set_compatible_namespace_version(Option<i64>)`](crate::client::fluent_builders::CreateFlowTemplate::set_compatible_namespace_version): <p>The namespace version in which the workflow is to be created.</p>  <p>If no value is specified, the latest version is used by default.</p>
    /// - On success, responds with [`CreateFlowTemplateOutput`](crate::output::CreateFlowTemplateOutput) with field(s):
    ///   - [`summary(Option<FlowTemplateSummary>)`](crate::output::CreateFlowTemplateOutput::summary): <p>The summary object that describes the created workflow.</p>
    /// - On failure, responds with [`SdkError<CreateFlowTemplateError>`](crate::error::CreateFlowTemplateError)
    pub fn create_flow_template(&self) -> fluent_builders::CreateFlowTemplate {
        fluent_builders::CreateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSystemInstance`](crate::client::fluent_builders::CreateSystemInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSystemInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSystemInstance::set_tags): <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
    ///   - [`definition(DefinitionDocument)`](crate::client::fluent_builders::CreateSystemInstance::definition) / [`set_definition(Option<DefinitionDocument>)`](crate::client::fluent_builders::CreateSystemInstance::set_definition): <p>A document that defines an entity. </p>
    ///   - [`target(DeploymentTarget)`](crate::client::fluent_builders::CreateSystemInstance::target) / [`set_target(Option<DeploymentTarget>)`](crate::client::fluent_builders::CreateSystemInstance::set_target): <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
    ///   - [`greengrass_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateSystemInstance::greengrass_group_name) / [`set_greengrass_group_name(Option<String>)`](crate::client::fluent_builders::CreateSystemInstance::set_greengrass_group_name): <p>The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateSystemInstance::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateSystemInstance::set_s3_bucket_name): <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
    ///   - [`metrics_configuration(MetricsConfiguration)`](crate::client::fluent_builders::CreateSystemInstance::metrics_configuration) / [`set_metrics_configuration(Option<MetricsConfiguration>)`](crate::client::fluent_builders::CreateSystemInstance::set_metrics_configuration): <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
    ///   - [`flow_actions_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSystemInstance::flow_actions_role_arn) / [`set_flow_actions_role_arn(Option<String>)`](crate::client::fluent_builders::CreateSystemInstance::set_flow_actions_role_arn): <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
    /// - On success, responds with [`CreateSystemInstanceOutput`](crate::output::CreateSystemInstanceOutput) with field(s):
    ///   - [`summary(Option<SystemInstanceSummary>)`](crate::output::CreateSystemInstanceOutput::summary): <p>The summary object that describes the new system instance.</p>
    /// - On failure, responds with [`SdkError<CreateSystemInstanceError>`](crate::error::CreateSystemInstanceError)
    pub fn create_system_instance(&self) -> fluent_builders::CreateSystemInstance {
        fluent_builders::CreateSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSystemTemplate`](crate::client::fluent_builders::CreateSystemTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`definition(DefinitionDocument)`](crate::client::fluent_builders::CreateSystemTemplate::definition) / [`set_definition(Option<DefinitionDocument>)`](crate::client::fluent_builders::CreateSystemTemplate::set_definition): <p>The <code>DefinitionDocument</code> used to create the system.</p>
    ///   - [`compatible_namespace_version(i64)`](crate::client::fluent_builders::CreateSystemTemplate::compatible_namespace_version) / [`set_compatible_namespace_version(Option<i64>)`](crate::client::fluent_builders::CreateSystemTemplate::set_compatible_namespace_version): <p>The namespace version in which the system is to be created.</p>  <p>If no value is specified, the latest version is used by default.</p>
    /// - On success, responds with [`CreateSystemTemplateOutput`](crate::output::CreateSystemTemplateOutput) with field(s):
    ///   - [`summary(Option<SystemTemplateSummary>)`](crate::output::CreateSystemTemplateOutput::summary): <p>The summary object that describes the created system.</p>
    /// - On failure, responds with [`SdkError<CreateSystemTemplateError>`](crate::error::CreateSystemTemplateError)
    pub fn create_system_template(&self) -> fluent_builders::CreateSystemTemplate {
        fluent_builders::CreateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFlowTemplate`](crate::client::fluent_builders::DeleteFlowTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteFlowTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteFlowTemplate::set_id): <p>The ID of the workflow to be deleted.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
    /// - On success, responds with [`DeleteFlowTemplateOutput`](crate::output::DeleteFlowTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteFlowTemplateError>`](crate::error::DeleteFlowTemplateError)
    pub fn delete_flow_template(&self) -> fluent_builders::DeleteFlowTemplate {
        fluent_builders::DeleteFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNamespace`](crate::client::fluent_builders::DeleteNamespace) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteNamespace::send) it.

    /// - On success, responds with [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput) with field(s):
    ///   - [`namespace_arn(Option<String>)`](crate::output::DeleteNamespaceOutput::namespace_arn): <p>The ARN of the namespace to be deleted.</p>
    ///   - [`namespace_name(Option<String>)`](crate::output::DeleteNamespaceOutput::namespace_name): <p>The name of the namespace to be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteNamespaceError>`](crate::error::DeleteNamespaceError)
    pub fn delete_namespace(&self) -> fluent_builders::DeleteNamespace {
        fluent_builders::DeleteNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSystemInstance`](crate::client::fluent_builders::DeleteSystemInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteSystemInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteSystemInstance::set_id): <p>The ID of the system instance to be deleted.</p>
    /// - On success, responds with [`DeleteSystemInstanceOutput`](crate::output::DeleteSystemInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteSystemInstanceError>`](crate::error::DeleteSystemInstanceError)
    pub fn delete_system_instance(&self) -> fluent_builders::DeleteSystemInstance {
        fluent_builders::DeleteSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSystemTemplate`](crate::client::fluent_builders::DeleteSystemTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteSystemTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteSystemTemplate::set_id): <p>The ID of the system to be deleted.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
    /// - On success, responds with [`DeleteSystemTemplateOutput`](crate::output::DeleteSystemTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteSystemTemplateError>`](crate::error::DeleteSystemTemplateError)
    pub fn delete_system_template(&self) -> fluent_builders::DeleteSystemTemplate {
        fluent_builders::DeleteSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeploySystemInstance`](crate::client::fluent_builders::DeploySystemInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeploySystemInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeploySystemInstance::set_id): <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
    /// - On success, responds with [`DeploySystemInstanceOutput`](crate::output::DeploySystemInstanceOutput) with field(s):
    ///   - [`summary(Option<SystemInstanceSummary>)`](crate::output::DeploySystemInstanceOutput::summary): <p>An object that contains summary information about a system instance that was deployed. </p>
    ///   - [`greengrass_deployment_id(Option<String>)`](crate::output::DeploySystemInstanceOutput::greengrass_deployment_id): <p>The ID of the Greengrass deployment used to deploy the system instance.</p>
    /// - On failure, responds with [`SdkError<DeploySystemInstanceError>`](crate::error::DeploySystemInstanceError)
    pub fn deploy_system_instance(&self) -> fluent_builders::DeploySystemInstance {
        fluent_builders::DeploySystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateFlowTemplate`](crate::client::fluent_builders::DeprecateFlowTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeprecateFlowTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeprecateFlowTemplate::set_id): <p>The ID of the workflow to be deleted.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
    /// - On success, responds with [`DeprecateFlowTemplateOutput`](crate::output::DeprecateFlowTemplateOutput)

    /// - On failure, responds with [`SdkError<DeprecateFlowTemplateError>`](crate::error::DeprecateFlowTemplateError)
    pub fn deprecate_flow_template(&self) -> fluent_builders::DeprecateFlowTemplate {
        fluent_builders::DeprecateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateSystemTemplate`](crate::client::fluent_builders::DeprecateSystemTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeprecateSystemTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeprecateSystemTemplate::set_id): <p>The ID of the system to delete.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
    /// - On success, responds with [`DeprecateSystemTemplateOutput`](crate::output::DeprecateSystemTemplateOutput)

    /// - On failure, responds with [`SdkError<DeprecateSystemTemplateError>`](crate::error::DeprecateSystemTemplateError)
    pub fn deprecate_system_template(&self) -> fluent_builders::DeprecateSystemTemplate {
        fluent_builders::DeprecateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNamespace`](crate::client::fluent_builders::DescribeNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`namespace_name(impl Into<String>)`](crate::client::fluent_builders::DescribeNamespace::namespace_name) / [`set_namespace_name(Option<String>)`](crate::client::fluent_builders::DescribeNamespace::set_namespace_name): <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
    /// - On success, responds with [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput) with field(s):
    ///   - [`namespace_arn(Option<String>)`](crate::output::DescribeNamespaceOutput::namespace_arn): <p>The ARN of the namespace.</p>
    ///   - [`namespace_name(Option<String>)`](crate::output::DescribeNamespaceOutput::namespace_name): <p>The name of the namespace.</p>
    ///   - [`tracking_namespace_name(Option<String>)`](crate::output::DescribeNamespaceOutput::tracking_namespace_name): <p>The name of the public namespace that the latest namespace version is tracking.</p>
    ///   - [`tracking_namespace_version(Option<i64>)`](crate::output::DescribeNamespaceOutput::tracking_namespace_version): <p>The version of the public namespace that the latest version is tracking.</p>
    ///   - [`namespace_version(Option<i64>)`](crate::output::DescribeNamespaceOutput::namespace_version): <p>The version of the user's namespace to describe.</p>
    /// - On failure, responds with [`SdkError<DescribeNamespaceError>`](crate::error::DescribeNamespaceError)
    pub fn describe_namespace(&self) -> fluent_builders::DescribeNamespace {
        fluent_builders::DescribeNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DissociateEntityFromThing`](crate::client::fluent_builders::DissociateEntityFromThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DissociateEntityFromThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DissociateEntityFromThing::set_thing_name): <p>The name of the thing to disassociate.</p>
    ///   - [`entity_type(EntityType)`](crate::client::fluent_builders::DissociateEntityFromThing::entity_type) / [`set_entity_type(Option<EntityType>)`](crate::client::fluent_builders::DissociateEntityFromThing::set_entity_type): <p>The entity type from which to disassociate the thing.</p>
    /// - On success, responds with [`DissociateEntityFromThingOutput`](crate::output::DissociateEntityFromThingOutput)

    /// - On failure, responds with [`SdkError<DissociateEntityFromThingError>`](crate::error::DissociateEntityFromThingError)
    pub fn dissociate_entity_from_thing(&self) -> fluent_builders::DissociateEntityFromThing {
        fluent_builders::DissociateEntityFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEntities`](crate::client::fluent_builders::GetEntities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::GetEntities::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetEntities::set_ids): <p>An array of entity IDs.</p>  <p>The IDs should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
    ///   - [`namespace_version(i64)`](crate::client::fluent_builders::GetEntities::namespace_version) / [`set_namespace_version(Option<i64>)`](crate::client::fluent_builders::GetEntities::set_namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    /// - On success, responds with [`GetEntitiesOutput`](crate::output::GetEntitiesOutput) with field(s):
    ///   - [`descriptions(Option<Vec<EntityDescription>>)`](crate::output::GetEntitiesOutput::descriptions): <p>An array of descriptions for the specified entities.</p>
    /// - On failure, responds with [`SdkError<GetEntitiesError>`](crate::error::GetEntitiesError)
    pub fn get_entities(&self) -> fluent_builders::GetEntities {
        fluent_builders::GetEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFlowTemplate`](crate::client::fluent_builders::GetFlowTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFlowTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFlowTemplate::set_id): <p>The ID of the workflow.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
    ///   - [`revision_number(i64)`](crate::client::fluent_builders::GetFlowTemplate::revision_number) / [`set_revision_number(Option<i64>)`](crate::client::fluent_builders::GetFlowTemplate::set_revision_number): <p>The number of the workflow revision to retrieve.</p>
    /// - On success, responds with [`GetFlowTemplateOutput`](crate::output::GetFlowTemplateOutput) with field(s):
    ///   - [`description(Option<FlowTemplateDescription>)`](crate::output::GetFlowTemplateOutput::description): <p>The object that describes the specified workflow.</p>
    /// - On failure, responds with [`SdkError<GetFlowTemplateError>`](crate::error::GetFlowTemplateError)
    pub fn get_flow_template(&self) -> fluent_builders::GetFlowTemplate {
        fluent_builders::GetFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFlowTemplateRevisions`](crate::client::fluent_builders::GetFlowTemplateRevisions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetFlowTemplateRevisions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFlowTemplateRevisions::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFlowTemplateRevisions::set_id): <p>The ID of the workflow.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetFlowTemplateRevisions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetFlowTemplateRevisions::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetFlowTemplateRevisions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetFlowTemplateRevisions::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`GetFlowTemplateRevisionsOutput`](crate::output::GetFlowTemplateRevisionsOutput) with field(s):
    ///   - [`summaries(Option<Vec<FlowTemplateSummary>>)`](crate::output::GetFlowTemplateRevisionsOutput::summaries): <p>An array of objects that provide summary data about each revision.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetFlowTemplateRevisionsOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<GetFlowTemplateRevisionsError>`](crate::error::GetFlowTemplateRevisionsError)
    pub fn get_flow_template_revisions(&self) -> fluent_builders::GetFlowTemplateRevisions {
        fluent_builders::GetFlowTemplateRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNamespaceDeletionStatus`](crate::client::fluent_builders::GetNamespaceDeletionStatus) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetNamespaceDeletionStatus::send) it.

    /// - On success, responds with [`GetNamespaceDeletionStatusOutput`](crate::output::GetNamespaceDeletionStatusOutput) with field(s):
    ///   - [`namespace_arn(Option<String>)`](crate::output::GetNamespaceDeletionStatusOutput::namespace_arn): <p>The ARN of the namespace that is being deleted.</p>
    ///   - [`namespace_name(Option<String>)`](crate::output::GetNamespaceDeletionStatusOutput::namespace_name): <p>The name of the namespace that is being deleted.</p>
    ///   - [`status(Option<NamespaceDeletionStatus>)`](crate::output::GetNamespaceDeletionStatusOutput::status): <p>The status of the deletion request.</p>
    ///   - [`error_code(Option<NamespaceDeletionStatusErrorCodes>)`](crate::output::GetNamespaceDeletionStatusOutput::error_code): <p>An error code returned by the namespace deletion task.</p>
    ///   - [`error_message(Option<String>)`](crate::output::GetNamespaceDeletionStatusOutput::error_message): <p>An error code returned by the namespace deletion task.</p>
    /// - On failure, responds with [`SdkError<GetNamespaceDeletionStatusError>`](crate::error::GetNamespaceDeletionStatusError)
    pub fn get_namespace_deletion_status(&self) -> fluent_builders::GetNamespaceDeletionStatus {
        fluent_builders::GetNamespaceDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSystemInstance`](crate::client::fluent_builders::GetSystemInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetSystemInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetSystemInstance::set_id): <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
    /// - On success, responds with [`GetSystemInstanceOutput`](crate::output::GetSystemInstanceOutput) with field(s):
    ///   - [`description(Option<SystemInstanceDescription>)`](crate::output::GetSystemInstanceOutput::description): <p>An object that describes the system instance.</p>
    /// - On failure, responds with [`SdkError<GetSystemInstanceError>`](crate::error::GetSystemInstanceError)
    pub fn get_system_instance(&self) -> fluent_builders::GetSystemInstance {
        fluent_builders::GetSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSystemTemplate`](crate::client::fluent_builders::GetSystemTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetSystemTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetSystemTemplate::set_id): <p>The ID of the system to get. This ID must be in the user's namespace.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
    ///   - [`revision_number(i64)`](crate::client::fluent_builders::GetSystemTemplate::revision_number) / [`set_revision_number(Option<i64>)`](crate::client::fluent_builders::GetSystemTemplate::set_revision_number): <p>The number that specifies the revision of the system to get.</p>
    /// - On success, responds with [`GetSystemTemplateOutput`](crate::output::GetSystemTemplateOutput) with field(s):
    ///   - [`description(Option<SystemTemplateDescription>)`](crate::output::GetSystemTemplateOutput::description): <p>An object that contains summary data about the system.</p>
    /// - On failure, responds with [`SdkError<GetSystemTemplateError>`](crate::error::GetSystemTemplateError)
    pub fn get_system_template(&self) -> fluent_builders::GetSystemTemplate {
        fluent_builders::GetSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSystemTemplateRevisions`](crate::client::fluent_builders::GetSystemTemplateRevisions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSystemTemplateRevisions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetSystemTemplateRevisions::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetSystemTemplateRevisions::set_id): <p>The ID of the system template.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSystemTemplateRevisions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSystemTemplateRevisions::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSystemTemplateRevisions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSystemTemplateRevisions::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`GetSystemTemplateRevisionsOutput`](crate::output::GetSystemTemplateRevisionsOutput) with field(s):
    ///   - [`summaries(Option<Vec<SystemTemplateSummary>>)`](crate::output::GetSystemTemplateRevisionsOutput::summaries): <p>An array of objects that contain summary data about the system template revisions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSystemTemplateRevisionsOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    /// - On failure, responds with [`SdkError<GetSystemTemplateRevisionsError>`](crate::error::GetSystemTemplateRevisionsError)
    pub fn get_system_template_revisions(&self) -> fluent_builders::GetSystemTemplateRevisions {
        fluent_builders::GetSystemTemplateRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUploadStatus`](crate::client::fluent_builders::GetUploadStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::GetUploadStatus::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::GetUploadStatus::set_upload_id): <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
    /// - On success, responds with [`GetUploadStatusOutput`](crate::output::GetUploadStatusOutput) with field(s):
    ///   - [`upload_id(Option<String>)`](crate::output::GetUploadStatusOutput::upload_id): <p>The ID of the upload.</p>
    ///   - [`upload_status(Option<UploadStatus>)`](crate::output::GetUploadStatusOutput::upload_status): <p>The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation failures if the upload fails.</p>
    ///   - [`namespace_arn(Option<String>)`](crate::output::GetUploadStatusOutput::namespace_arn): <p>The ARN of the upload.</p>
    ///   - [`namespace_name(Option<String>)`](crate::output::GetUploadStatusOutput::namespace_name): <p>The name of the upload's namespace.</p>
    ///   - [`namespace_version(Option<i64>)`](crate::output::GetUploadStatusOutput::namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    ///   - [`failure_reason(Option<Vec<String>>)`](crate::output::GetUploadStatusOutput::failure_reason): <p>The reason for an upload failure.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetUploadStatusOutput::created_date): <p>The date at which the upload was created.</p>
    /// - On failure, responds with [`SdkError<GetUploadStatusError>`](crate::error::GetUploadStatusError)
    pub fn get_upload_status(&self) -> fluent_builders::GetUploadStatus {
        fluent_builders::GetUploadStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFlowExecutionMessages`](crate::client::fluent_builders::ListFlowExecutionMessages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFlowExecutionMessages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_execution_id(impl Into<String>)`](crate::client::fluent_builders::ListFlowExecutionMessages::flow_execution_id) / [`set_flow_execution_id(Option<String>)`](crate::client::fluent_builders::ListFlowExecutionMessages::set_flow_execution_id): <p>The ID of the flow execution.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFlowExecutionMessages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFlowExecutionMessages::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFlowExecutionMessages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFlowExecutionMessages::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListFlowExecutionMessagesOutput`](crate::output::ListFlowExecutionMessagesOutput) with field(s):
    ///   - [`messages(Option<Vec<FlowExecutionMessage>>)`](crate::output::ListFlowExecutionMessagesOutput::messages): <p>A list of objects that contain information about events in the specified flow execution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFlowExecutionMessagesOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    /// - On failure, responds with [`SdkError<ListFlowExecutionMessagesError>`](crate::error::ListFlowExecutionMessagesError)
    pub fn list_flow_execution_messages(&self) -> fluent_builders::ListFlowExecutionMessages {
        fluent_builders::ListFlowExecutionMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of tags to return.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The token that specifies the next page of results to return.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The token that specifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchEntities`](crate::client::fluent_builders::SearchEntities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchEntities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`entity_types(Vec<EntityType>)`](crate::client::fluent_builders::SearchEntities::entity_types) / [`set_entity_types(Option<Vec<EntityType>>)`](crate::client::fluent_builders::SearchEntities::set_entity_types): <p>The entity types for which to search.</p>
    ///   - [`filters(Vec<EntityFilter>)`](crate::client::fluent_builders::SearchEntities::filters) / [`set_filters(Option<Vec<EntityFilter>>)`](crate::client::fluent_builders::SearchEntities::set_filters): <p>Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.</p>  <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchEntities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchEntities::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchEntities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchEntities::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`namespace_version(i64)`](crate::client::fluent_builders::SearchEntities::namespace_version) / [`set_namespace_version(Option<i64>)`](crate::client::fluent_builders::SearchEntities::set_namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    /// - On success, responds with [`SearchEntitiesOutput`](crate::output::SearchEntitiesOutput) with field(s):
    ///   - [`descriptions(Option<Vec<EntityDescription>>)`](crate::output::SearchEntitiesOutput::descriptions): <p>An array of descriptions for each entity returned in the search result.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchEntitiesOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<SearchEntitiesError>`](crate::error::SearchEntitiesError)
    pub fn search_entities(&self) -> fluent_builders::SearchEntities {
        fluent_builders::SearchEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchFlowExecutions`](crate::client::fluent_builders::SearchFlowExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchFlowExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`system_instance_id(impl Into<String>)`](crate::client::fluent_builders::SearchFlowExecutions::system_instance_id) / [`set_system_instance_id(Option<String>)`](crate::client::fluent_builders::SearchFlowExecutions::set_system_instance_id): <p>The ID of the system instance that contains the flow.</p>
    ///   - [`flow_execution_id(impl Into<String>)`](crate::client::fluent_builders::SearchFlowExecutions::flow_execution_id) / [`set_flow_execution_id(Option<String>)`](crate::client::fluent_builders::SearchFlowExecutions::set_flow_execution_id): <p>The ID of a flow execution.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::SearchFlowExecutions::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::SearchFlowExecutions::set_start_time): <p>The date and time of the earliest flow execution to return.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::SearchFlowExecutions::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::SearchFlowExecutions::set_end_time): <p>The date and time of the latest flow execution to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchFlowExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchFlowExecutions::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchFlowExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchFlowExecutions::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`SearchFlowExecutionsOutput`](crate::output::SearchFlowExecutionsOutput) with field(s):
    ///   - [`summaries(Option<Vec<FlowExecutionSummary>>)`](crate::output::SearchFlowExecutionsOutput::summaries): <p>An array of objects that contain summary information about each workflow execution in the result set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchFlowExecutionsOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<SearchFlowExecutionsError>`](crate::error::SearchFlowExecutionsError)
    pub fn search_flow_executions(&self) -> fluent_builders::SearchFlowExecutions {
        fluent_builders::SearchFlowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchFlowTemplates`](crate::client::fluent_builders::SearchFlowTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchFlowTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<FlowTemplateFilter>)`](crate::client::fluent_builders::SearchFlowTemplates::filters) / [`set_filters(Option<Vec<FlowTemplateFilter>>)`](crate::client::fluent_builders::SearchFlowTemplates::set_filters): <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchFlowTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchFlowTemplates::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchFlowTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchFlowTemplates::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`SearchFlowTemplatesOutput`](crate::output::SearchFlowTemplatesOutput) with field(s):
    ///   - [`summaries(Option<Vec<FlowTemplateSummary>>)`](crate::output::SearchFlowTemplatesOutput::summaries): <p>An array of objects that contain summary information about each workflow in the result set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchFlowTemplatesOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<SearchFlowTemplatesError>`](crate::error::SearchFlowTemplatesError)
    pub fn search_flow_templates(&self) -> fluent_builders::SearchFlowTemplates {
        fluent_builders::SearchFlowTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchSystemInstances`](crate::client::fluent_builders::SearchSystemInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchSystemInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<SystemInstanceFilter>)`](crate::client::fluent_builders::SearchSystemInstances::filters) / [`set_filters(Option<Vec<SystemInstanceFilter>>)`](crate::client::fluent_builders::SearchSystemInstances::set_filters): <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and <code>GREENGRASS_GROUP_NAME</code>.</p>  <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchSystemInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchSystemInstances::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchSystemInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchSystemInstances::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`SearchSystemInstancesOutput`](crate::output::SearchSystemInstancesOutput) with field(s):
    ///   - [`summaries(Option<Vec<SystemInstanceSummary>>)`](crate::output::SearchSystemInstancesOutput::summaries): <p>An array of objects that contain summary data abour the system instances in the result set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchSystemInstancesOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    /// - On failure, responds with [`SdkError<SearchSystemInstancesError>`](crate::error::SearchSystemInstancesError)
    pub fn search_system_instances(&self) -> fluent_builders::SearchSystemInstances {
        fluent_builders::SearchSystemInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchSystemTemplates`](crate::client::fluent_builders::SearchSystemTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchSystemTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<SystemTemplateFilter>)`](crate::client::fluent_builders::SearchSystemTemplates::filters) / [`set_filters(Option<Vec<SystemTemplateFilter>>)`](crate::client::fluent_builders::SearchSystemTemplates::set_filters): <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchSystemTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchSystemTemplates::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchSystemTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchSystemTemplates::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`SearchSystemTemplatesOutput`](crate::output::SearchSystemTemplatesOutput) with field(s):
    ///   - [`summaries(Option<Vec<SystemTemplateSummary>>)`](crate::output::SearchSystemTemplatesOutput::summaries): <p>An array of objects that contain summary information about each system deployment in the result set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchSystemTemplatesOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<SearchSystemTemplatesError>`](crate::error::SearchSystemTemplatesError)
    pub fn search_system_templates(&self) -> fluent_builders::SearchSystemTemplates {
        fluent_builders::SearchSystemTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchThings`](crate::client::fluent_builders::SearchThings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchThings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`entity_id(impl Into<String>)`](crate::client::fluent_builders::SearchThings::entity_id) / [`set_entity_id(Option<String>)`](crate::client::fluent_builders::SearchThings::set_entity_id): <p>The ID of the entity to which the things are associated.</p>  <p>The IDs should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchThings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchThings::set_next_token): <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchThings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchThings::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`namespace_version(i64)`](crate::client::fluent_builders::SearchThings::namespace_version) / [`set_namespace_version(Option<i64>)`](crate::client::fluent_builders::SearchThings::set_namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    /// - On success, responds with [`SearchThingsOutput`](crate::output::SearchThingsOutput) with field(s):
    ///   - [`things(Option<Vec<Thing>>)`](crate::output::SearchThingsOutput::things): <p>An array of things in the result set.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchThingsOutput::next_token): <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    /// - On failure, responds with [`SdkError<SearchThingsError>`](crate::error::SearchThingsError)
    pub fn search_things(&self) -> fluent_builders::SearchThings {
        fluent_builders::SearchThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to add to the resource.&gt;</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UndeploySystemInstance`](crate::client::fluent_builders::UndeploySystemInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UndeploySystemInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UndeploySystemInstance::set_id): <p>The ID of the system instance to remove from its target.</p>
    /// - On success, responds with [`UndeploySystemInstanceOutput`](crate::output::UndeploySystemInstanceOutput) with field(s):
    ///   - [`summary(Option<SystemInstanceSummary>)`](crate::output::UndeploySystemInstanceOutput::summary): <p>An object that contains summary information about the system instance that was removed from its target.</p>
    /// - On failure, responds with [`SdkError<UndeploySystemInstanceError>`](crate::error::UndeploySystemInstanceError)
    pub fn undeploy_system_instance(&self) -> fluent_builders::UndeploySystemInstance {
        fluent_builders::UndeploySystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>  <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlowTemplate`](crate::client::fluent_builders::UpdateFlowTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateFlowTemplate::set_id): <p>The ID of the workflow to be updated.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
    ///   - [`definition(DefinitionDocument)`](crate::client::fluent_builders::UpdateFlowTemplate::definition) / [`set_definition(Option<DefinitionDocument>)`](crate::client::fluent_builders::UpdateFlowTemplate::set_definition): <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
    ///   - [`compatible_namespace_version(i64)`](crate::client::fluent_builders::UpdateFlowTemplate::compatible_namespace_version) / [`set_compatible_namespace_version(Option<i64>)`](crate::client::fluent_builders::UpdateFlowTemplate::set_compatible_namespace_version): <p>The version of the user's namespace.</p>  <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow to update.</p>
    /// - On success, responds with [`UpdateFlowTemplateOutput`](crate::output::UpdateFlowTemplateOutput) with field(s):
    ///   - [`summary(Option<FlowTemplateSummary>)`](crate::output::UpdateFlowTemplateOutput::summary): <p>An object containing summary information about the updated workflow.</p>
    /// - On failure, responds with [`SdkError<UpdateFlowTemplateError>`](crate::error::UpdateFlowTemplateError)
    pub fn update_flow_template(&self) -> fluent_builders::UpdateFlowTemplate {
        fluent_builders::UpdateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSystemTemplate`](crate::client::fluent_builders::UpdateSystemTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateSystemTemplate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateSystemTemplate::set_id): <p>The ID of the system to be updated.</p>  <p>The ID should be in the following format.</p>  <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
    ///   - [`definition(DefinitionDocument)`](crate::client::fluent_builders::UpdateSystemTemplate::definition) / [`set_definition(Option<DefinitionDocument>)`](crate::client::fluent_builders::UpdateSystemTemplate::set_definition): <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
    ///   - [`compatible_namespace_version(i64)`](crate::client::fluent_builders::UpdateSystemTemplate::compatible_namespace_version) / [`set_compatible_namespace_version(Option<i64>)`](crate::client::fluent_builders::UpdateSystemTemplate::set_compatible_namespace_version): <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>  <p>If no value is specified, the latest version is used by default.</p>
    /// - On success, responds with [`UpdateSystemTemplateOutput`](crate::output::UpdateSystemTemplateOutput) with field(s):
    ///   - [`summary(Option<SystemTemplateSummary>)`](crate::output::UpdateSystemTemplateOutput::summary): <p>An object containing summary information about the updated system.</p>
    /// - On failure, responds with [`SdkError<UpdateSystemTemplateError>`](crate::error::UpdateSystemTemplateError)
    pub fn update_system_template(&self) -> fluent_builders::UpdateSystemTemplate {
        fluent_builders::UpdateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UploadEntityDefinitions`](crate::client::fluent_builders::UploadEntityDefinitions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document(DefinitionDocument)`](crate::client::fluent_builders::UploadEntityDefinitions::document) / [`set_document(Option<DefinitionDocument>)`](crate::client::fluent_builders::UploadEntityDefinitions::set_document): <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
    ///   - [`sync_with_public_namespace(bool)`](crate::client::fluent_builders::UploadEntityDefinitions::sync_with_public_namespace) / [`set_sync_with_public_namespace(bool)`](crate::client::fluent_builders::UploadEntityDefinitions::set_sync_with_public_namespace): <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
    ///   - [`deprecate_existing_entities(bool)`](crate::client::fluent_builders::UploadEntityDefinitions::deprecate_existing_entities) / [`set_deprecate_existing_entities(bool)`](crate::client::fluent_builders::UploadEntityDefinitions::set_deprecate_existing_entities): <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.</p>
    /// - On success, responds with [`UploadEntityDefinitionsOutput`](crate::output::UploadEntityDefinitionsOutput) with field(s):
    ///   - [`upload_id(Option<String>)`](crate::output::UploadEntityDefinitionsOutput::upload_id): <p>The ID that specifies the upload action. You can use this to track the status of the upload.</p>
    /// - On failure, responds with [`SdkError<UploadEntityDefinitionsError>`](crate::error::UploadEntityDefinitionsError)
    pub fn upload_entity_definitions(&self) -> fluent_builders::UploadEntityDefinitions {
        fluent_builders::UploadEntityDefinitions::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateEntityToThing`.
    ///
    /// <p>Associates a device with a concrete thing that is in the user's registry.</p>
    /// <p>A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateEntityToThing {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_entity_to_thing_input::Builder,
    }
    impl AssociateEntityToThing {
        /// Creates a new `AssociateEntityToThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEntityToThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateEntityToThingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlowTemplate`.
    ///
    /// <p>Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlowTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_flow_template_input::Builder,
    }
    impl CreateFlowTemplate {
        /// Creates a new `CreateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSystemInstance`.
    ///
    /// <p>Creates a system instance. </p>
    /// <p>This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call <code>DeploySystemInstance</code> after running this action.</p>
    /// <p>For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.</p>
    /// <p>For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.</p>
    /// <p>If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSystemInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_system_instance_input::Builder,
    }
    impl CreateSystemInstance {
        /// Creates a new `CreateSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSystemInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn target(mut self, input: crate::model::DeploymentTarget) -> Self {
            self.inner = self.inner.target(input);
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::DeploymentTarget>,
        ) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn greengrass_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.greengrass_group_name(input.into());
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_greengrass_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_greengrass_group_name(input);
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(input.into());
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.inner = self.inner.metrics_configuration(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_metrics_configuration(input);
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn flow_actions_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_actions_role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn set_flow_actions_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_actions_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSystemTemplate`.
    ///
    /// <p>Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSystemTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_system_template_input::Builder,
    }
    impl CreateSystemTemplate {
        /// Creates a new `CreateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSystemTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlowTemplate`.
    ///
    /// <p>Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFlowTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_flow_template_input::Builder,
    }
    impl DeleteFlowTemplate {
        /// Creates a new `DeleteFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamespace`.
    ///
    /// <p>Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_namespace_input::Builder,
    }
    impl DeleteNamespace {
        /// Creates a new `DeleteNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteSystemInstance`.
    ///
    /// <p>Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.</p>
    /// <p>Users can create a new system instance that has the same ID as a deleted system instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSystemInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_system_instance_input::Builder,
    }
    impl DeleteSystemInstance {
        /// Creates a new `DeleteSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSystemInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSystemTemplate`.
    ///
    /// <p>Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSystemTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_system_template_input::Builder,
    }
    impl DeleteSystemTemplate {
        /// Creates a new `DeleteSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSystemTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeploySystemInstance`.
    ///
    /// <p> <b>Greengrass and Cloud Deployments</b> </p>
    /// <p>Deploys the system instance to the target specified in <code>CreateSystemInstance</code>. </p>
    /// <p> <b>Greengrass Deployments</b> </p>
    /// <p>If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.</p>
    /// <p>Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.</p>
    /// <p>For information about the artifacts that get added to your Greengrass core device when you use this API, see <a href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT Greengrass</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeploySystemInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deploy_system_instance_input::Builder,
    }
    impl DeploySystemInstance {
        /// Creates a new `DeploySystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeploySystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeploySystemInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateFlowTemplate`.
    ///
    /// <p>Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateFlowTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprecate_flow_template_input::Builder,
    }
    impl DeprecateFlowTemplate {
        /// Creates a new `DeprecateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateFlowTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateSystemTemplate`.
    ///
    /// <p>Deprecates the specified system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateSystemTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprecate_system_template_input::Builder,
    }
    impl DeprecateSystemTemplate {
        /// Creates a new `DeprecateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateSystemTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNamespace`.
    ///
    /// <p>Gets the latest version of the user's namespace and the public version that it is tracking.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNamespace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_namespace_input::Builder,
    }
    impl DescribeNamespace {
        /// Creates a new `DescribeNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_name(input.into());
            self
        }
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_namespace_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociateEntityFromThing`.
    ///
    /// <p>Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DissociateEntityFromThing {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::dissociate_entity_from_thing_input::Builder,
    }
    impl DissociateEntityFromThing {
        /// Creates a new `DissociateEntityFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociateEntityFromThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociateEntityFromThingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to disassociate.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to disassociate.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn entity_type(mut self, input: crate::model::EntityType) -> Self {
            self.inner = self.inner.entity_type(input);
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn set_entity_type(
            mut self,
            input: std::option::Option<crate::model::EntityType>,
        ) -> Self {
            self.inner = self.inner.set_entity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntities`.
    ///
    /// <p>Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.</p>
    /// <ul>
    /// <li> <p>Properties</p> </li>
    /// <li> <p>States</p> </li>
    /// <li> <p>Events</p> </li>
    /// <li> <p>Actions</p> </li>
    /// <li> <p>Capabilities</p> </li>
    /// <li> <p>Mappings</p> </li>
    /// <li> <p>Devices</p> </li>
    /// <li> <p>Device Models</p> </li>
    /// <li> <p>Services</p> </li>
    /// </ul>
    /// <p>This action doesn't return definitions for systems, flows, and deployments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_entities_input::Builder,
    }
    impl GetEntities {
        /// Creates a new `GetEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFlowTemplate`.
    ///
    /// <p>Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFlowTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_flow_template_input::Builder,
    }
    impl GetFlowTemplate {
        /// Creates a new `GetFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFlowTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.inner = self.inner.revision_number(input);
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_revision_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFlowTemplateRevisions`.
    ///
    /// <p>Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFlowTemplateRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_flow_template_revisions_input::Builder,
    }
    impl GetFlowTemplateRevisions {
        /// Creates a new `GetFlowTemplateRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFlowTemplateRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFlowTemplateRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFlowTemplateRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetFlowTemplateRevisionsPaginator {
            crate::paginator::GetFlowTemplateRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNamespaceDeletionStatus`.
    ///
    /// <p>Gets the status of a namespace deletion task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNamespaceDeletionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_namespace_deletion_status_input::Builder,
    }
    impl GetNamespaceDeletionStatus {
        /// Creates a new `GetNamespaceDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNamespaceDeletionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNamespaceDeletionStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSystemInstance`.
    ///
    /// <p>Gets a system instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_system_instance_input::Builder,
    }
    impl GetSystemInstance {
        /// Creates a new `GetSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSystemTemplate`.
    ///
    /// <p>Gets a system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_system_template_input::Builder,
    }
    impl GetSystemTemplate {
        /// Creates a new `GetSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.inner = self.inner.revision_number(input);
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_revision_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSystemTemplateRevisions`.
    ///
    /// <p>Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemTemplateRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_system_template_revisions_input::Builder,
    }
    impl GetSystemTemplateRevisions {
        /// Creates a new `GetSystemTemplateRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemTemplateRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemTemplateRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSystemTemplateRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSystemTemplateRevisionsPaginator {
            crate::paginator::GetSystemTemplateRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUploadStatus`.
    ///
    /// <p>Gets the status of the specified upload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUploadStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_upload_status_input::Builder,
    }
    impl GetUploadStatus {
        /// Creates a new `GetUploadStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUploadStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUploadStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlowExecutionMessages`.
    ///
    /// <p>Returns a list of objects that contain information about events in a flow execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFlowExecutionMessages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_flow_execution_messages_input::Builder,
    }
    impl ListFlowExecutionMessages {
        /// Creates a new `ListFlowExecutionMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowExecutionMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowExecutionMessagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFlowExecutionMessagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFlowExecutionMessagesPaginator {
            crate::paginator::ListFlowExecutionMessagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_execution_id(input.into());
            self
        }
        /// <p>The ID of the flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_execution_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an AWS IoT Things Graph resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of tags to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tags to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchEntities`.
    ///
    /// <p>Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_entities_input::Builder,
    }
    impl SearchEntities {
        /// Creates a new `SearchEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchEntitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchEntitiesPaginator {
            crate::paginator::SearchEntitiesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `entityTypes`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity types for which to search.</p>
        pub fn entity_types(mut self, input: crate::model::EntityType) -> Self {
            self.inner = self.inner.entity_types(input);
            self
        }
        /// <p>The entity types for which to search.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.inner = self.inner.set_entity_types(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: crate::model::EntityFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFlowExecutions`.
    ///
    /// <p>Searches for AWS IoT Things Graph workflow execution instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFlowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_flow_executions_input::Builder,
    }
    impl SearchFlowExecutions {
        /// Creates a new `SearchFlowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFlowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFlowExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchFlowExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchFlowExecutionsPaginator {
            crate::paginator::SearchFlowExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn system_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.system_instance_id(input.into());
            self
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn set_system_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_system_instance_id(input);
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_execution_id(input.into());
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_execution_id(input);
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFlowTemplates`.
    ///
    /// <p>Searches for summary information about workflows.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFlowTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_flow_templates_input::Builder,
    }
    impl SearchFlowTemplates {
        /// Creates a new `SearchFlowTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFlowTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFlowTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchFlowTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchFlowTemplatesPaginator {
            crate::paginator::SearchFlowTemplatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn filters(mut self, input: crate::model::FlowTemplateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowTemplateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSystemInstances`.
    ///
    /// <p>Searches for system instances in the user's account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchSystemInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_system_instances_input::Builder,
    }
    impl SearchSystemInstances {
        /// Creates a new `SearchSystemInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSystemInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSystemInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchSystemInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchSystemInstancesPaginator {
            crate::paginator::SearchSystemInstancesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: crate::model::SystemInstanceFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemInstanceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSystemTemplates`.
    ///
    /// <p>Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchSystemTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_system_templates_input::Builder,
    }
    impl SearchSystemTemplates {
        /// Creates a new `SearchSystemTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSystemTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSystemTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchSystemTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchSystemTemplatesPaginator {
            crate::paginator::SearchSystemTemplatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn filters(mut self, input: crate::model::SystemTemplateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemTemplateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchThings`.
    ///
    /// <p>Searches for things associated with the specified entity. You can search by both device and device model.</p>
    /// <p>For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2, but <code>SearchThings(camera)</code> will return both thing1 and thing2.</p>
    /// <p>This action searches for exact matches and doesn't perform partial text matching.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchThings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_things_input::Builder,
    }
    impl SearchThings {
        /// Creates a new `SearchThings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchThingsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchThingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchThingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchThingsPaginator {
            crate::paginator::SearchThingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a tag for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the resource.&gt;</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the resource.&gt;</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeploySystemInstance`.
    ///
    /// <p>Removes a system instance from its target (Cloud or Greengrass).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UndeploySystemInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::undeploy_system_instance_input::Builder,
    }
    impl UndeploySystemInstance {
        /// Creates a new `UndeploySystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeploySystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeploySystemInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowTemplate`.
    ///
    /// <p>Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_template_input::Builder,
    }
    impl UpdateFlowTemplate {
        /// Creates a new `UpdateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow to update.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow to update.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSystemTemplate`.
    ///
    /// <p>Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSystemTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_system_template_input::Builder,
    }
    impl UpdateSystemTemplate {
        /// Creates a new `UpdateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSystemTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UploadEntityDefinitions`.
    ///
    /// <p>Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code> parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false. If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is uploaded.</p>
    /// <p>When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to <code>true</code>.</p>
    /// <p>The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.</p>
    /// <p>Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>, <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>, <code>Enum</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UploadEntityDefinitions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upload_entity_definitions_input::Builder,
    }
    impl UploadEntityDefinitions {
        /// Creates a new `UploadEntityDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UploadEntityDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UploadEntityDefinitionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn document(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.document(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn set_document(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn sync_with_public_namespace(mut self, input: bool) -> Self {
            self.inner = self.inner.sync_with_public_namespace(input);
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_sync_with_public_namespace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sync_with_public_namespace(input);
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn deprecate_existing_entities(mut self, input: bool) -> Self {
            self.inner = self.inner.deprecate_existing_entities(input);
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_deprecate_existing_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deprecate_existing_entities(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
