// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Things Graph
///
/// Client for invoking operations on AWS IoT Things Graph. Each operation on AWS IoT Things Graph is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotthingsgraph::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotthingsgraph::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotthingsgraph::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateEntityToThing` operation.
    ///
    /// See [`AssociateEntityToThing`](crate::client::fluent_builders::AssociateEntityToThing) for more information about the
    /// operation and its arguments.
    pub fn associate_entity_to_thing(&self) -> fluent_builders::AssociateEntityToThing<C, M, R> {
        fluent_builders::AssociateEntityToThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFlowTemplate` operation.
    ///
    /// See [`CreateFlowTemplate`](crate::client::fluent_builders::CreateFlowTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_flow_template(&self) -> fluent_builders::CreateFlowTemplate<C, M, R> {
        fluent_builders::CreateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSystemInstance` operation.
    ///
    /// See [`CreateSystemInstance`](crate::client::fluent_builders::CreateSystemInstance) for more information about the
    /// operation and its arguments.
    pub fn create_system_instance(&self) -> fluent_builders::CreateSystemInstance<C, M, R> {
        fluent_builders::CreateSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSystemTemplate` operation.
    ///
    /// See [`CreateSystemTemplate`](crate::client::fluent_builders::CreateSystemTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_system_template(&self) -> fluent_builders::CreateSystemTemplate<C, M, R> {
        fluent_builders::CreateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFlowTemplate` operation.
    ///
    /// See [`DeleteFlowTemplate`](crate::client::fluent_builders::DeleteFlowTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_flow_template(&self) -> fluent_builders::DeleteFlowTemplate<C, M, R> {
        fluent_builders::DeleteFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNamespace` operation.
    ///
    /// See [`DeleteNamespace`](crate::client::fluent_builders::DeleteNamespace) for more information about the
    /// operation and its arguments.
    pub fn delete_namespace(&self) -> fluent_builders::DeleteNamespace<C, M, R> {
        fluent_builders::DeleteNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSystemInstance` operation.
    ///
    /// See [`DeleteSystemInstance`](crate::client::fluent_builders::DeleteSystemInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_system_instance(&self) -> fluent_builders::DeleteSystemInstance<C, M, R> {
        fluent_builders::DeleteSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSystemTemplate` operation.
    ///
    /// See [`DeleteSystemTemplate`](crate::client::fluent_builders::DeleteSystemTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_system_template(&self) -> fluent_builders::DeleteSystemTemplate<C, M, R> {
        fluent_builders::DeleteSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeploySystemInstance` operation.
    ///
    /// See [`DeploySystemInstance`](crate::client::fluent_builders::DeploySystemInstance) for more information about the
    /// operation and its arguments.
    pub fn deploy_system_instance(&self) -> fluent_builders::DeploySystemInstance<C, M, R> {
        fluent_builders::DeploySystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateFlowTemplate` operation.
    ///
    /// See [`DeprecateFlowTemplate`](crate::client::fluent_builders::DeprecateFlowTemplate) for more information about the
    /// operation and its arguments.
    pub fn deprecate_flow_template(&self) -> fluent_builders::DeprecateFlowTemplate<C, M, R> {
        fluent_builders::DeprecateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateSystemTemplate` operation.
    ///
    /// See [`DeprecateSystemTemplate`](crate::client::fluent_builders::DeprecateSystemTemplate) for more information about the
    /// operation and its arguments.
    pub fn deprecate_system_template(&self) -> fluent_builders::DeprecateSystemTemplate<C, M, R> {
        fluent_builders::DeprecateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNamespace` operation.
    ///
    /// See [`DescribeNamespace`](crate::client::fluent_builders::DescribeNamespace) for more information about the
    /// operation and its arguments.
    pub fn describe_namespace(&self) -> fluent_builders::DescribeNamespace<C, M, R> {
        fluent_builders::DescribeNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DissociateEntityFromThing` operation.
    ///
    /// See [`DissociateEntityFromThing`](crate::client::fluent_builders::DissociateEntityFromThing) for more information about the
    /// operation and its arguments.
    pub fn dissociate_entity_from_thing(
        &self,
    ) -> fluent_builders::DissociateEntityFromThing<C, M, R> {
        fluent_builders::DissociateEntityFromThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEntities` operation.
    ///
    /// See [`GetEntities`](crate::client::fluent_builders::GetEntities) for more information about the
    /// operation and its arguments.
    pub fn get_entities(&self) -> fluent_builders::GetEntities<C, M, R> {
        fluent_builders::GetEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFlowTemplate` operation.
    ///
    /// See [`GetFlowTemplate`](crate::client::fluent_builders::GetFlowTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_flow_template(&self) -> fluent_builders::GetFlowTemplate<C, M, R> {
        fluent_builders::GetFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFlowTemplateRevisions` operation.
    ///
    /// See [`GetFlowTemplateRevisions`](crate::client::fluent_builders::GetFlowTemplateRevisions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetFlowTemplateRevisions::into_paginator).
    pub fn get_flow_template_revisions(
        &self,
    ) -> fluent_builders::GetFlowTemplateRevisions<C, M, R> {
        fluent_builders::GetFlowTemplateRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNamespaceDeletionStatus` operation.
    ///
    /// See [`GetNamespaceDeletionStatus`](crate::client::fluent_builders::GetNamespaceDeletionStatus) for more information about the
    /// operation and its arguments.
    pub fn get_namespace_deletion_status(
        &self,
    ) -> fluent_builders::GetNamespaceDeletionStatus<C, M, R> {
        fluent_builders::GetNamespaceDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSystemInstance` operation.
    ///
    /// See [`GetSystemInstance`](crate::client::fluent_builders::GetSystemInstance) for more information about the
    /// operation and its arguments.
    pub fn get_system_instance(&self) -> fluent_builders::GetSystemInstance<C, M, R> {
        fluent_builders::GetSystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSystemTemplate` operation.
    ///
    /// See [`GetSystemTemplate`](crate::client::fluent_builders::GetSystemTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_system_template(&self) -> fluent_builders::GetSystemTemplate<C, M, R> {
        fluent_builders::GetSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSystemTemplateRevisions` operation.
    ///
    /// See [`GetSystemTemplateRevisions`](crate::client::fluent_builders::GetSystemTemplateRevisions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetSystemTemplateRevisions::into_paginator).
    pub fn get_system_template_revisions(
        &self,
    ) -> fluent_builders::GetSystemTemplateRevisions<C, M, R> {
        fluent_builders::GetSystemTemplateRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUploadStatus` operation.
    ///
    /// See [`GetUploadStatus`](crate::client::fluent_builders::GetUploadStatus) for more information about the
    /// operation and its arguments.
    pub fn get_upload_status(&self) -> fluent_builders::GetUploadStatus<C, M, R> {
        fluent_builders::GetUploadStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFlowExecutionMessages` operation.
    ///
    /// See [`ListFlowExecutionMessages`](crate::client::fluent_builders::ListFlowExecutionMessages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFlowExecutionMessages::into_paginator).
    pub fn list_flow_execution_messages(
        &self,
    ) -> fluent_builders::ListFlowExecutionMessages<C, M, R> {
        fluent_builders::ListFlowExecutionMessages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchEntities` operation.
    ///
    /// See [`SearchEntities`](crate::client::fluent_builders::SearchEntities) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchEntities::into_paginator).
    pub fn search_entities(&self) -> fluent_builders::SearchEntities<C, M, R> {
        fluent_builders::SearchEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchFlowExecutions` operation.
    ///
    /// See [`SearchFlowExecutions`](crate::client::fluent_builders::SearchFlowExecutions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchFlowExecutions::into_paginator).
    pub fn search_flow_executions(&self) -> fluent_builders::SearchFlowExecutions<C, M, R> {
        fluent_builders::SearchFlowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchFlowTemplates` operation.
    ///
    /// See [`SearchFlowTemplates`](crate::client::fluent_builders::SearchFlowTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchFlowTemplates::into_paginator).
    pub fn search_flow_templates(&self) -> fluent_builders::SearchFlowTemplates<C, M, R> {
        fluent_builders::SearchFlowTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchSystemInstances` operation.
    ///
    /// See [`SearchSystemInstances`](crate::client::fluent_builders::SearchSystemInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchSystemInstances::into_paginator).
    pub fn search_system_instances(&self) -> fluent_builders::SearchSystemInstances<C, M, R> {
        fluent_builders::SearchSystemInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchSystemTemplates` operation.
    ///
    /// See [`SearchSystemTemplates`](crate::client::fluent_builders::SearchSystemTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchSystemTemplates::into_paginator).
    pub fn search_system_templates(&self) -> fluent_builders::SearchSystemTemplates<C, M, R> {
        fluent_builders::SearchSystemTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchThings` operation.
    ///
    /// See [`SearchThings`](crate::client::fluent_builders::SearchThings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchThings::into_paginator).
    pub fn search_things(&self) -> fluent_builders::SearchThings<C, M, R> {
        fluent_builders::SearchThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UndeploySystemInstance` operation.
    ///
    /// See [`UndeploySystemInstance`](crate::client::fluent_builders::UndeploySystemInstance) for more information about the
    /// operation and its arguments.
    pub fn undeploy_system_instance(&self) -> fluent_builders::UndeploySystemInstance<C, M, R> {
        fluent_builders::UndeploySystemInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlowTemplate` operation.
    ///
    /// See [`UpdateFlowTemplate`](crate::client::fluent_builders::UpdateFlowTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_flow_template(&self) -> fluent_builders::UpdateFlowTemplate<C, M, R> {
        fluent_builders::UpdateFlowTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSystemTemplate` operation.
    ///
    /// See [`UpdateSystemTemplate`](crate::client::fluent_builders::UpdateSystemTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_system_template(&self) -> fluent_builders::UpdateSystemTemplate<C, M, R> {
        fluent_builders::UpdateSystemTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadEntityDefinitions` operation.
    ///
    /// See [`UploadEntityDefinitions`](crate::client::fluent_builders::UploadEntityDefinitions) for more information about the
    /// operation and its arguments.
    pub fn upload_entity_definitions(&self) -> fluent_builders::UploadEntityDefinitions<C, M, R> {
        fluent_builders::UploadEntityDefinitions::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateEntityToThing`.
    ///
    /// <p>Associates a device with a concrete thing that is in the user's registry.</p>
    /// <p>A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateEntityToThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_entity_to_thing_input::Builder,
    }
    impl<C, M, R> AssociateEntityToThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateEntityToThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEntityToThingOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateEntityToThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateEntityToThingInputOperationOutputAlias,
                crate::output::AssociateEntityToThingOutput,
                crate::error::AssociateEntityToThingError,
                crate::input::AssociateEntityToThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlowTemplate`.
    ///
    /// <p>Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlowTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_flow_template_input::Builder,
    }
    impl<C, M, R> CreateFlowTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFlowTemplateInputOperationOutputAlias,
                crate::output::CreateFlowTemplateOutput,
                crate::error::CreateFlowTemplateError,
                crate::input::CreateFlowTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSystemInstance`.
    ///
    /// <p>Creates a system instance. </p>
    /// <p>This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call <code>DeploySystemInstance</code> after running this action.</p>
    /// <p>For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.</p>
    /// <p>For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.</p>
    /// <p>If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSystemInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_system_instance_input::Builder,
    }
    impl<C, M, R> CreateSystemInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSystemInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSystemInstanceInputOperationOutputAlias,
                crate::output::CreateSystemInstanceOutput,
                crate::error::CreateSystemInstanceError,
                crate::input::CreateSystemInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn target(mut self, input: crate::model::DeploymentTarget) -> Self {
            self.inner = self.inner.target(input);
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::DeploymentTarget>,
        ) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn greengrass_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.greengrass_group_name(input.into());
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_greengrass_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_greengrass_group_name(input);
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(input.into());
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.inner = self.inner.metrics_configuration(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_metrics_configuration(input);
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn flow_actions_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_actions_role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn set_flow_actions_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_actions_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSystemTemplate`.
    ///
    /// <p>Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSystemTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_system_template_input::Builder,
    }
    impl<C, M, R> CreateSystemTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSystemTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSystemTemplateInputOperationOutputAlias,
                crate::output::CreateSystemTemplateOutput,
                crate::error::CreateSystemTemplateError,
                crate::input::CreateSystemTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlowTemplate`.
    ///
    /// <p>Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFlowTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_flow_template_input::Builder,
    }
    impl<C, M, R> DeleteFlowTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFlowTemplateInputOperationOutputAlias,
                crate::output::DeleteFlowTemplateOutput,
                crate::error::DeleteFlowTemplateError,
                crate::input::DeleteFlowTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamespace`.
    ///
    /// <p>Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_namespace_input::Builder,
    }
    impl<C, M, R> DeleteNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNamespaceInputOperationOutputAlias,
                crate::output::DeleteNamespaceOutput,
                crate::error::DeleteNamespaceError,
                crate::input::DeleteNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteSystemInstance`.
    ///
    /// <p>Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.</p>
    /// <p>Users can create a new system instance that has the same ID as a deleted system instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSystemInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_system_instance_input::Builder,
    }
    impl<C, M, R> DeleteSystemInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSystemInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSystemInstanceInputOperationOutputAlias,
                crate::output::DeleteSystemInstanceOutput,
                crate::error::DeleteSystemInstanceError,
                crate::input::DeleteSystemInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSystemTemplate`.
    ///
    /// <p>Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSystemTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_system_template_input::Builder,
    }
    impl<C, M, R> DeleteSystemTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSystemTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSystemTemplateInputOperationOutputAlias,
                crate::output::DeleteSystemTemplateOutput,
                crate::error::DeleteSystemTemplateError,
                crate::input::DeleteSystemTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeploySystemInstance`.
    ///
    /// <p> <b>Greengrass and Cloud Deployments</b> </p>
    /// <p>Deploys the system instance to the target specified in <code>CreateSystemInstance</code>. </p>
    /// <p> <b>Greengrass Deployments</b> </p>
    /// <p>If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.</p>
    /// <p>Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.</p>
    /// <p>For information about the artifacts that get added to your Greengrass core device when you use this API, see <a href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT Greengrass</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeploySystemInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deploy_system_instance_input::Builder,
    }
    impl<C, M, R> DeploySystemInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeploySystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeploySystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeploySystemInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeploySystemInstanceInputOperationOutputAlias,
                crate::output::DeploySystemInstanceOutput,
                crate::error::DeploySystemInstanceError,
                crate::input::DeploySystemInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateFlowTemplate`.
    ///
    /// <p>Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateFlowTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_flow_template_input::Builder,
    }
    impl<C, M, R> DeprecateFlowTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateFlowTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateFlowTemplateInputOperationOutputAlias,
                crate::output::DeprecateFlowTemplateOutput,
                crate::error::DeprecateFlowTemplateError,
                crate::input::DeprecateFlowTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateSystemTemplate`.
    ///
    /// <p>Deprecates the specified system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateSystemTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_system_template_input::Builder,
    }
    impl<C, M, R> DeprecateSystemTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateSystemTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateSystemTemplateInputOperationOutputAlias,
                crate::output::DeprecateSystemTemplateOutput,
                crate::error::DeprecateSystemTemplateError,
                crate::input::DeprecateSystemTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNamespace`.
    ///
    /// <p>Gets the latest version of the user's namespace and the public version that it is tracking.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_namespace_input::Builder,
    }
    impl<C, M, R> DescribeNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNamespaceInputOperationOutputAlias,
                crate::output::DescribeNamespaceOutput,
                crate::error::DescribeNamespaceError,
                crate::input::DescribeNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_name(input.into());
            self
        }
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_namespace_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DissociateEntityFromThing`.
    ///
    /// <p>Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DissociateEntityFromThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::dissociate_entity_from_thing_input::Builder,
    }
    impl<C, M, R> DissociateEntityFromThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DissociateEntityFromThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DissociateEntityFromThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DissociateEntityFromThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DissociateEntityFromThingInputOperationOutputAlias,
                crate::output::DissociateEntityFromThingOutput,
                crate::error::DissociateEntityFromThingError,
                crate::input::DissociateEntityFromThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to disassociate.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to disassociate.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn entity_type(mut self, input: crate::model::EntityType) -> Self {
            self.inner = self.inner.entity_type(input);
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn set_entity_type(
            mut self,
            input: std::option::Option<crate::model::EntityType>,
        ) -> Self {
            self.inner = self.inner.set_entity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEntities`.
    ///
    /// <p>Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.</p>
    /// <ul>
    /// <li> <p>Properties</p> </li>
    /// <li> <p>States</p> </li>
    /// <li> <p>Events</p> </li>
    /// <li> <p>Actions</p> </li>
    /// <li> <p>Capabilities</p> </li>
    /// <li> <p>Mappings</p> </li>
    /// <li> <p>Devices</p> </li>
    /// <li> <p>Device Models</p> </li>
    /// <li> <p>Services</p> </li>
    /// </ul>
    /// <p>This action doesn't return definitions for systems, flows, and deployments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_entities_input::Builder,
    }
    impl<C, M, R> GetEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEntitiesInputOperationOutputAlias,
                crate::output::GetEntitiesOutput,
                crate::error::GetEntitiesError,
                crate::input::GetEntitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFlowTemplate`.
    ///
    /// <p>Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFlowTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_flow_template_input::Builder,
    }
    impl<C, M, R> GetFlowTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFlowTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFlowTemplateInputOperationOutputAlias,
                crate::output::GetFlowTemplateOutput,
                crate::error::GetFlowTemplateError,
                crate::input::GetFlowTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.inner = self.inner.revision_number(input);
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_revision_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFlowTemplateRevisions`.
    ///
    /// <p>Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFlowTemplateRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_flow_template_revisions_input::Builder,
    }
    impl<C, M, R> GetFlowTemplateRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFlowTemplateRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFlowTemplateRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFlowTemplateRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFlowTemplateRevisionsInputOperationOutputAlias,
                crate::output::GetFlowTemplateRevisionsOutput,
                crate::error::GetFlowTemplateRevisionsError,
                crate::input::GetFlowTemplateRevisionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFlowTemplateRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetFlowTemplateRevisionsPaginator<C, M, R> {
            crate::paginator::GetFlowTemplateRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNamespaceDeletionStatus`.
    ///
    /// <p>Gets the status of a namespace deletion task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNamespaceDeletionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_namespace_deletion_status_input::Builder,
    }
    impl<C, M, R> GetNamespaceDeletionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNamespaceDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNamespaceDeletionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNamespaceDeletionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNamespaceDeletionStatusInputOperationOutputAlias,
                crate::output::GetNamespaceDeletionStatusOutput,
                crate::error::GetNamespaceDeletionStatusError,
                crate::input::GetNamespaceDeletionStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSystemInstance`.
    ///
    /// <p>Gets a system instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_system_instance_input::Builder,
    }
    impl<C, M, R> GetSystemInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSystemInstanceInputOperationOutputAlias,
                crate::output::GetSystemInstanceOutput,
                crate::error::GetSystemInstanceError,
                crate::input::GetSystemInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSystemTemplate`.
    ///
    /// <p>Gets a system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_system_template_input::Builder,
    }
    impl<C, M, R> GetSystemTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSystemTemplateInputOperationOutputAlias,
                crate::output::GetSystemTemplateOutput,
                crate::error::GetSystemTemplateError,
                crate::input::GetSystemTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.inner = self.inner.revision_number(input);
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_revision_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSystemTemplateRevisions`.
    ///
    /// <p>Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSystemTemplateRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_system_template_revisions_input::Builder,
    }
    impl<C, M, R> GetSystemTemplateRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSystemTemplateRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSystemTemplateRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSystemTemplateRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSystemTemplateRevisionsInputOperationOutputAlias,
                crate::output::GetSystemTemplateRevisionsOutput,
                crate::error::GetSystemTemplateRevisionsError,
                crate::input::GetSystemTemplateRevisionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSystemTemplateRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetSystemTemplateRevisionsPaginator<C, M, R> {
            crate::paginator::GetSystemTemplateRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUploadStatus`.
    ///
    /// <p>Gets the status of the specified upload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUploadStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_upload_status_input::Builder,
    }
    impl<C, M, R> GetUploadStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUploadStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUploadStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUploadStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUploadStatusInputOperationOutputAlias,
                crate::output::GetUploadStatusOutput,
                crate::error::GetUploadStatusError,
                crate::input::GetUploadStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlowExecutionMessages`.
    ///
    /// <p>Returns a list of objects that contain information about events in a flow execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFlowExecutionMessages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_flow_execution_messages_input::Builder,
    }
    impl<C, M, R> ListFlowExecutionMessages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFlowExecutionMessages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowExecutionMessagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowExecutionMessagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFlowExecutionMessagesInputOperationOutputAlias,
                crate::output::ListFlowExecutionMessagesOutput,
                crate::error::ListFlowExecutionMessagesError,
                crate::input::ListFlowExecutionMessagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFlowExecutionMessagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListFlowExecutionMessagesPaginator<C, M, R> {
            crate::paginator::ListFlowExecutionMessagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_execution_id(input.into());
            self
        }
        /// <p>The ID of the flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_execution_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an AWS IoT Things Graph resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator<C, M, R> {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of tags to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tags to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchEntities`.
    ///
    /// <p>Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_entities_input::Builder,
    }
    impl<C, M, R> SearchEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchEntitiesInputOperationOutputAlias,
                crate::output::SearchEntitiesOutput,
                crate::error::SearchEntitiesError,
                crate::input::SearchEntitiesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchEntitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchEntitiesPaginator<C, M, R> {
            crate::paginator::SearchEntitiesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `entityTypes`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity types for which to search.</p>
        pub fn entity_types(mut self, input: crate::model::EntityType) -> Self {
            self.inner = self.inner.entity_types(input);
            self
        }
        /// <p>The entity types for which to search.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.inner = self.inner.set_entity_types(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: crate::model::EntityFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFlowExecutions`.
    ///
    /// <p>Searches for AWS IoT Things Graph workflow execution instances.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFlowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_flow_executions_input::Builder,
    }
    impl<C, M, R> SearchFlowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFlowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFlowExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFlowExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFlowExecutionsInputOperationOutputAlias,
                crate::output::SearchFlowExecutionsOutput,
                crate::error::SearchFlowExecutionsError,
                crate::input::SearchFlowExecutionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchFlowExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchFlowExecutionsPaginator<C, M, R> {
            crate::paginator::SearchFlowExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn system_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.system_instance_id(input.into());
            self
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn set_system_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_system_instance_id(input);
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_execution_id(input.into());
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_execution_id(input);
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFlowTemplates`.
    ///
    /// <p>Searches for summary information about workflows.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFlowTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_flow_templates_input::Builder,
    }
    impl<C, M, R> SearchFlowTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFlowTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFlowTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFlowTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFlowTemplatesInputOperationOutputAlias,
                crate::output::SearchFlowTemplatesOutput,
                crate::error::SearchFlowTemplatesError,
                crate::input::SearchFlowTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchFlowTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchFlowTemplatesPaginator<C, M, R> {
            crate::paginator::SearchFlowTemplatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn filters(mut self, input: crate::model::FlowTemplateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowTemplateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSystemInstances`.
    ///
    /// <p>Searches for system instances in the user's account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchSystemInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_system_instances_input::Builder,
    }
    impl<C, M, R> SearchSystemInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchSystemInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSystemInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSystemInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchSystemInstancesInputOperationOutputAlias,
                crate::output::SearchSystemInstancesOutput,
                crate::error::SearchSystemInstancesError,
                crate::input::SearchSystemInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchSystemInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchSystemInstancesPaginator<C, M, R> {
            crate::paginator::SearchSystemInstancesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: crate::model::SystemInstanceFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemInstanceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSystemTemplates`.
    ///
    /// <p>Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchSystemTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_system_templates_input::Builder,
    }
    impl<C, M, R> SearchSystemTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchSystemTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSystemTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSystemTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchSystemTemplatesInputOperationOutputAlias,
                crate::output::SearchSystemTemplatesOutput,
                crate::error::SearchSystemTemplatesError,
                crate::input::SearchSystemTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchSystemTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchSystemTemplatesPaginator<C, M, R> {
            crate::paginator::SearchSystemTemplatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn filters(mut self, input: crate::model::SystemTemplateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemTemplateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchThings`.
    ///
    /// <p>Searches for things associated with the specified entity. You can search by both device and device model.</p>
    /// <p>For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2, but <code>SearchThings(camera)</code> will return both thing1 and thing2.</p>
    /// <p>This action searches for exact matches and doesn't perform partial text matching.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchThings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_things_input::Builder,
    }
    impl<C, M, R> SearchThings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchThings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchThingsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchThingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchThingsInputOperationOutputAlias,
                crate::output::SearchThingsOutput,
                crate::error::SearchThingsError,
                crate::input::SearchThingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchThingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchThingsPaginator<C, M, R> {
            crate::paginator::SearchThingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(input.into());
            self
        }
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code> </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a tag for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the resource.&gt;</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the resource.&gt;</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UndeploySystemInstance`.
    ///
    /// <p>Removes a system instance from its target (Cloud or Greengrass).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UndeploySystemInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::undeploy_system_instance_input::Builder,
    }
    impl<C, M, R> UndeploySystemInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UndeploySystemInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UndeploySystemInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UndeploySystemInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UndeploySystemInstanceInputOperationOutputAlias,
                crate::output::UndeploySystemInstanceOutput,
                crate::error::UndeploySystemInstanceError,
                crate::input::UndeploySystemInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowTemplate`.
    ///
    /// <p>Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_template_input::Builder,
    }
    impl<C, M, R> UpdateFlowTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlowTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowTemplateInputOperationOutputAlias,
                crate::output::UpdateFlowTemplateOutput,
                crate::error::UpdateFlowTemplateError,
                crate::input::UpdateFlowTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow to update.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow to update.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSystemTemplate`.
    ///
    /// <p>Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSystemTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_system_template_input::Builder,
    }
    impl<C, M, R> UpdateSystemTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSystemTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSystemTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSystemTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSystemTemplateInputOperationOutputAlias,
                crate::output::UpdateSystemTemplateOutput,
                crate::error::UpdateSystemTemplateError,
                crate::input::UpdateSystemTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code> </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.inner = self.inner.compatible_namespace_version(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_compatible_namespace_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UploadEntityDefinitions`.
    ///
    /// <p>Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code> parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false. If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is uploaded.</p>
    /// <p>When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to <code>true</code>.</p>
    /// <p>The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.</p>
    /// <p>Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>, <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>, <code>Enum</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UploadEntityDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upload_entity_definitions_input::Builder,
    }
    impl<C, M, R> UploadEntityDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UploadEntityDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UploadEntityDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UploadEntityDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UploadEntityDefinitionsInputOperationOutputAlias,
                crate::output::UploadEntityDefinitionsOutput,
                crate::error::UploadEntityDefinitionsError,
                crate::input::UploadEntityDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn document(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.inner = self.inner.document(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn set_document(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn sync_with_public_namespace(mut self, input: bool) -> Self {
            self.inner = self.inner.sync_with_public_namespace(input);
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_sync_with_public_namespace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sync_with_public_namespace(input);
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn deprecate_existing_entities(mut self, input: bool) -> Self {
            self.inner = self.inner.deprecate_existing_entities(input);
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_deprecate_existing_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deprecate_existing_entities(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
