// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateEntityToThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_entity_to_thing`](crate::client::Client::associate_entity_to_thing).
///
/// See [`crate::client::fluent_builders::AssociateEntityToThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateEntityToThing {
    _private: (),
}
impl AssociateEntityToThing {
    /// Creates a new builder-style object to manufacture [`AssociateEntityToThingInput`](crate::input::AssociateEntityToThingInput)
    pub fn builder() -> crate::input::associate_entity_to_thing_input::Builder {
        crate::input::associate_entity_to_thing_input::Builder::default()
    }
    /// Creates a new `AssociateEntityToThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateEntityToThing {
    type Output = std::result::Result<
        crate::output::AssociateEntityToThingOutput,
        crate::error::AssociateEntityToThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_entity_to_thing_error(response)
        } else {
            crate::operation_deser::parse_associate_entity_to_thing_response(response)
        }
    }
}

/// Operation shape for `CreateFlowTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_flow_template`](crate::client::Client::create_flow_template).
///
/// See [`crate::client::fluent_builders::CreateFlowTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFlowTemplate {
    _private: (),
}
impl CreateFlowTemplate {
    /// Creates a new builder-style object to manufacture [`CreateFlowTemplateInput`](crate::input::CreateFlowTemplateInput)
    pub fn builder() -> crate::input::create_flow_template_input::Builder {
        crate::input::create_flow_template_input::Builder::default()
    }
    /// Creates a new `CreateFlowTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFlowTemplate {
    type Output = std::result::Result<
        crate::output::CreateFlowTemplateOutput,
        crate::error::CreateFlowTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_flow_template_error(response)
        } else {
            crate::operation_deser::parse_create_flow_template_response(response)
        }
    }
}

/// Operation shape for `CreateSystemInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_system_instance`](crate::client::Client::create_system_instance).
///
/// See [`crate::client::fluent_builders::CreateSystemInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSystemInstance {
    _private: (),
}
impl CreateSystemInstance {
    /// Creates a new builder-style object to manufacture [`CreateSystemInstanceInput`](crate::input::CreateSystemInstanceInput)
    pub fn builder() -> crate::input::create_system_instance_input::Builder {
        crate::input::create_system_instance_input::Builder::default()
    }
    /// Creates a new `CreateSystemInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSystemInstance {
    type Output = std::result::Result<
        crate::output::CreateSystemInstanceOutput,
        crate::error::CreateSystemInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_system_instance_error(response)
        } else {
            crate::operation_deser::parse_create_system_instance_response(response)
        }
    }
}

/// Operation shape for `CreateSystemTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_system_template`](crate::client::Client::create_system_template).
///
/// See [`crate::client::fluent_builders::CreateSystemTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSystemTemplate {
    _private: (),
}
impl CreateSystemTemplate {
    /// Creates a new builder-style object to manufacture [`CreateSystemTemplateInput`](crate::input::CreateSystemTemplateInput)
    pub fn builder() -> crate::input::create_system_template_input::Builder {
        crate::input::create_system_template_input::Builder::default()
    }
    /// Creates a new `CreateSystemTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSystemTemplate {
    type Output = std::result::Result<
        crate::output::CreateSystemTemplateOutput,
        crate::error::CreateSystemTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_system_template_error(response)
        } else {
            crate::operation_deser::parse_create_system_template_response(response)
        }
    }
}

/// Operation shape for `DeleteFlowTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_flow_template`](crate::client::Client::delete_flow_template).
///
/// See [`crate::client::fluent_builders::DeleteFlowTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFlowTemplate {
    _private: (),
}
impl DeleteFlowTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteFlowTemplateInput`](crate::input::DeleteFlowTemplateInput)
    pub fn builder() -> crate::input::delete_flow_template_input::Builder {
        crate::input::delete_flow_template_input::Builder::default()
    }
    /// Creates a new `DeleteFlowTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFlowTemplate {
    type Output = std::result::Result<
        crate::output::DeleteFlowTemplateOutput,
        crate::error::DeleteFlowTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_flow_template_error(response)
        } else {
            crate::operation_deser::parse_delete_flow_template_response(response)
        }
    }
}

/// Operation shape for `DeleteNamespace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_namespace`](crate::client::Client::delete_namespace).
///
/// See [`crate::client::fluent_builders::DeleteNamespace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNamespace {
    _private: (),
}
impl DeleteNamespace {
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    pub fn builder() -> crate::input::delete_namespace_input::Builder {
        crate::input::delete_namespace_input::Builder::default()
    }
    /// Creates a new `DeleteNamespace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNamespace {
    type Output = std::result::Result<
        crate::output::DeleteNamespaceOutput,
        crate::error::DeleteNamespaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_namespace_error(response)
        } else {
            crate::operation_deser::parse_delete_namespace_response(response)
        }
    }
}

/// Operation shape for `DeleteSystemInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_system_instance`](crate::client::Client::delete_system_instance).
///
/// See [`crate::client::fluent_builders::DeleteSystemInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSystemInstance {
    _private: (),
}
impl DeleteSystemInstance {
    /// Creates a new builder-style object to manufacture [`DeleteSystemInstanceInput`](crate::input::DeleteSystemInstanceInput)
    pub fn builder() -> crate::input::delete_system_instance_input::Builder {
        crate::input::delete_system_instance_input::Builder::default()
    }
    /// Creates a new `DeleteSystemInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSystemInstance {
    type Output = std::result::Result<
        crate::output::DeleteSystemInstanceOutput,
        crate::error::DeleteSystemInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_system_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_system_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteSystemTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_system_template`](crate::client::Client::delete_system_template).
///
/// See [`crate::client::fluent_builders::DeleteSystemTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSystemTemplate {
    _private: (),
}
impl DeleteSystemTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteSystemTemplateInput`](crate::input::DeleteSystemTemplateInput)
    pub fn builder() -> crate::input::delete_system_template_input::Builder {
        crate::input::delete_system_template_input::Builder::default()
    }
    /// Creates a new `DeleteSystemTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSystemTemplate {
    type Output = std::result::Result<
        crate::output::DeleteSystemTemplateOutput,
        crate::error::DeleteSystemTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_system_template_error(response)
        } else {
            crate::operation_deser::parse_delete_system_template_response(response)
        }
    }
}

/// Operation shape for `DeploySystemInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deploy_system_instance`](crate::client::Client::deploy_system_instance).
///
/// See [`crate::client::fluent_builders::DeploySystemInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeploySystemInstance {
    _private: (),
}
impl DeploySystemInstance {
    /// Creates a new builder-style object to manufacture [`DeploySystemInstanceInput`](crate::input::DeploySystemInstanceInput)
    pub fn builder() -> crate::input::deploy_system_instance_input::Builder {
        crate::input::deploy_system_instance_input::Builder::default()
    }
    /// Creates a new `DeploySystemInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeploySystemInstance {
    type Output = std::result::Result<
        crate::output::DeploySystemInstanceOutput,
        crate::error::DeploySystemInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deploy_system_instance_error(response)
        } else {
            crate::operation_deser::parse_deploy_system_instance_response(response)
        }
    }
}

/// Operation shape for `DeprecateFlowTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_flow_template`](crate::client::Client::deprecate_flow_template).
///
/// See [`crate::client::fluent_builders::DeprecateFlowTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateFlowTemplate {
    _private: (),
}
impl DeprecateFlowTemplate {
    /// Creates a new builder-style object to manufacture [`DeprecateFlowTemplateInput`](crate::input::DeprecateFlowTemplateInput)
    pub fn builder() -> crate::input::deprecate_flow_template_input::Builder {
        crate::input::deprecate_flow_template_input::Builder::default()
    }
    /// Creates a new `DeprecateFlowTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateFlowTemplate {
    type Output = std::result::Result<
        crate::output::DeprecateFlowTemplateOutput,
        crate::error::DeprecateFlowTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_flow_template_error(response)
        } else {
            crate::operation_deser::parse_deprecate_flow_template_response(response)
        }
    }
}

/// Operation shape for `DeprecateSystemTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_system_template`](crate::client::Client::deprecate_system_template).
///
/// See [`crate::client::fluent_builders::DeprecateSystemTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateSystemTemplate {
    _private: (),
}
impl DeprecateSystemTemplate {
    /// Creates a new builder-style object to manufacture [`DeprecateSystemTemplateInput`](crate::input::DeprecateSystemTemplateInput)
    pub fn builder() -> crate::input::deprecate_system_template_input::Builder {
        crate::input::deprecate_system_template_input::Builder::default()
    }
    /// Creates a new `DeprecateSystemTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateSystemTemplate {
    type Output = std::result::Result<
        crate::output::DeprecateSystemTemplateOutput,
        crate::error::DeprecateSystemTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_system_template_error(response)
        } else {
            crate::operation_deser::parse_deprecate_system_template_response(response)
        }
    }
}

/// Operation shape for `DescribeNamespace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_namespace`](crate::client::Client::describe_namespace).
///
/// See [`crate::client::fluent_builders::DescribeNamespace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNamespace {
    _private: (),
}
impl DescribeNamespace {
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    pub fn builder() -> crate::input::describe_namespace_input::Builder {
        crate::input::describe_namespace_input::Builder::default()
    }
    /// Creates a new `DescribeNamespace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNamespace {
    type Output = std::result::Result<
        crate::output::DescribeNamespaceOutput,
        crate::error::DescribeNamespaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_namespace_error(response)
        } else {
            crate::operation_deser::parse_describe_namespace_response(response)
        }
    }
}

/// Operation shape for `DissociateEntityFromThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`dissociate_entity_from_thing`](crate::client::Client::dissociate_entity_from_thing).
///
/// See [`crate::client::fluent_builders::DissociateEntityFromThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DissociateEntityFromThing {
    _private: (),
}
impl DissociateEntityFromThing {
    /// Creates a new builder-style object to manufacture [`DissociateEntityFromThingInput`](crate::input::DissociateEntityFromThingInput)
    pub fn builder() -> crate::input::dissociate_entity_from_thing_input::Builder {
        crate::input::dissociate_entity_from_thing_input::Builder::default()
    }
    /// Creates a new `DissociateEntityFromThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DissociateEntityFromThing {
    type Output = std::result::Result<
        crate::output::DissociateEntityFromThingOutput,
        crate::error::DissociateEntityFromThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_dissociate_entity_from_thing_error(response)
        } else {
            crate::operation_deser::parse_dissociate_entity_from_thing_response(response)
        }
    }
}

/// Operation shape for `GetEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_entities`](crate::client::Client::get_entities).
///
/// See [`crate::client::fluent_builders::GetEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEntities {
    _private: (),
}
impl GetEntities {
    /// Creates a new builder-style object to manufacture [`GetEntitiesInput`](crate::input::GetEntitiesInput)
    pub fn builder() -> crate::input::get_entities_input::Builder {
        crate::input::get_entities_input::Builder::default()
    }
    /// Creates a new `GetEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEntities {
    type Output =
        std::result::Result<crate::output::GetEntitiesOutput, crate::error::GetEntitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_entities_error(response)
        } else {
            crate::operation_deser::parse_get_entities_response(response)
        }
    }
}

/// Operation shape for `GetFlowTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_flow_template`](crate::client::Client::get_flow_template).
///
/// See [`crate::client::fluent_builders::GetFlowTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFlowTemplate {
    _private: (),
}
impl GetFlowTemplate {
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateInput`](crate::input::GetFlowTemplateInput)
    pub fn builder() -> crate::input::get_flow_template_input::Builder {
        crate::input::get_flow_template_input::Builder::default()
    }
    /// Creates a new `GetFlowTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFlowTemplate {
    type Output = std::result::Result<
        crate::output::GetFlowTemplateOutput,
        crate::error::GetFlowTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_flow_template_error(response)
        } else {
            crate::operation_deser::parse_get_flow_template_response(response)
        }
    }
}

/// Operation shape for `GetFlowTemplateRevisions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_flow_template_revisions`](crate::client::Client::get_flow_template_revisions).
///
/// See [`crate::client::fluent_builders::GetFlowTemplateRevisions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFlowTemplateRevisions {
    _private: (),
}
impl GetFlowTemplateRevisions {
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateRevisionsInput`](crate::input::GetFlowTemplateRevisionsInput)
    pub fn builder() -> crate::input::get_flow_template_revisions_input::Builder {
        crate::input::get_flow_template_revisions_input::Builder::default()
    }
    /// Creates a new `GetFlowTemplateRevisions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFlowTemplateRevisions {
    type Output = std::result::Result<
        crate::output::GetFlowTemplateRevisionsOutput,
        crate::error::GetFlowTemplateRevisionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_flow_template_revisions_error(response)
        } else {
            crate::operation_deser::parse_get_flow_template_revisions_response(response)
        }
    }
}

/// Operation shape for `GetNamespaceDeletionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_namespace_deletion_status`](crate::client::Client::get_namespace_deletion_status).
///
/// See [`crate::client::fluent_builders::GetNamespaceDeletionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNamespaceDeletionStatus {
    _private: (),
}
impl GetNamespaceDeletionStatus {
    /// Creates a new builder-style object to manufacture [`GetNamespaceDeletionStatusInput`](crate::input::GetNamespaceDeletionStatusInput)
    pub fn builder() -> crate::input::get_namespace_deletion_status_input::Builder {
        crate::input::get_namespace_deletion_status_input::Builder::default()
    }
    /// Creates a new `GetNamespaceDeletionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNamespaceDeletionStatus {
    type Output = std::result::Result<
        crate::output::GetNamespaceDeletionStatusOutput,
        crate::error::GetNamespaceDeletionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_namespace_deletion_status_error(response)
        } else {
            crate::operation_deser::parse_get_namespace_deletion_status_response(response)
        }
    }
}

/// Operation shape for `GetSystemInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_system_instance`](crate::client::Client::get_system_instance).
///
/// See [`crate::client::fluent_builders::GetSystemInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSystemInstance {
    _private: (),
}
impl GetSystemInstance {
    /// Creates a new builder-style object to manufacture [`GetSystemInstanceInput`](crate::input::GetSystemInstanceInput)
    pub fn builder() -> crate::input::get_system_instance_input::Builder {
        crate::input::get_system_instance_input::Builder::default()
    }
    /// Creates a new `GetSystemInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSystemInstance {
    type Output = std::result::Result<
        crate::output::GetSystemInstanceOutput,
        crate::error::GetSystemInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_system_instance_error(response)
        } else {
            crate::operation_deser::parse_get_system_instance_response(response)
        }
    }
}

/// Operation shape for `GetSystemTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_system_template`](crate::client::Client::get_system_template).
///
/// See [`crate::client::fluent_builders::GetSystemTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSystemTemplate {
    _private: (),
}
impl GetSystemTemplate {
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateInput`](crate::input::GetSystemTemplateInput)
    pub fn builder() -> crate::input::get_system_template_input::Builder {
        crate::input::get_system_template_input::Builder::default()
    }
    /// Creates a new `GetSystemTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSystemTemplate {
    type Output = std::result::Result<
        crate::output::GetSystemTemplateOutput,
        crate::error::GetSystemTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_system_template_error(response)
        } else {
            crate::operation_deser::parse_get_system_template_response(response)
        }
    }
}

/// Operation shape for `GetSystemTemplateRevisions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_system_template_revisions`](crate::client::Client::get_system_template_revisions).
///
/// See [`crate::client::fluent_builders::GetSystemTemplateRevisions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSystemTemplateRevisions {
    _private: (),
}
impl GetSystemTemplateRevisions {
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateRevisionsInput`](crate::input::GetSystemTemplateRevisionsInput)
    pub fn builder() -> crate::input::get_system_template_revisions_input::Builder {
        crate::input::get_system_template_revisions_input::Builder::default()
    }
    /// Creates a new `GetSystemTemplateRevisions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSystemTemplateRevisions {
    type Output = std::result::Result<
        crate::output::GetSystemTemplateRevisionsOutput,
        crate::error::GetSystemTemplateRevisionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_system_template_revisions_error(response)
        } else {
            crate::operation_deser::parse_get_system_template_revisions_response(response)
        }
    }
}

/// Operation shape for `GetUploadStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_upload_status`](crate::client::Client::get_upload_status).
///
/// See [`crate::client::fluent_builders::GetUploadStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUploadStatus {
    _private: (),
}
impl GetUploadStatus {
    /// Creates a new builder-style object to manufacture [`GetUploadStatusInput`](crate::input::GetUploadStatusInput)
    pub fn builder() -> crate::input::get_upload_status_input::Builder {
        crate::input::get_upload_status_input::Builder::default()
    }
    /// Creates a new `GetUploadStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUploadStatus {
    type Output = std::result::Result<
        crate::output::GetUploadStatusOutput,
        crate::error::GetUploadStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_upload_status_error(response)
        } else {
            crate::operation_deser::parse_get_upload_status_response(response)
        }
    }
}

/// Operation shape for `ListFlowExecutionMessages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_flow_execution_messages`](crate::client::Client::list_flow_execution_messages).
///
/// See [`crate::client::fluent_builders::ListFlowExecutionMessages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFlowExecutionMessages {
    _private: (),
}
impl ListFlowExecutionMessages {
    /// Creates a new builder-style object to manufacture [`ListFlowExecutionMessagesInput`](crate::input::ListFlowExecutionMessagesInput)
    pub fn builder() -> crate::input::list_flow_execution_messages_input::Builder {
        crate::input::list_flow_execution_messages_input::Builder::default()
    }
    /// Creates a new `ListFlowExecutionMessages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFlowExecutionMessages {
    type Output = std::result::Result<
        crate::output::ListFlowExecutionMessagesOutput,
        crate::error::ListFlowExecutionMessagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_flow_execution_messages_error(response)
        } else {
            crate::operation_deser::parse_list_flow_execution_messages_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `SearchEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_entities`](crate::client::Client::search_entities).
///
/// See [`crate::client::fluent_builders::SearchEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchEntities {
    _private: (),
}
impl SearchEntities {
    /// Creates a new builder-style object to manufacture [`SearchEntitiesInput`](crate::input::SearchEntitiesInput)
    pub fn builder() -> crate::input::search_entities_input::Builder {
        crate::input::search_entities_input::Builder::default()
    }
    /// Creates a new `SearchEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchEntities {
    type Output =
        std::result::Result<crate::output::SearchEntitiesOutput, crate::error::SearchEntitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_entities_error(response)
        } else {
            crate::operation_deser::parse_search_entities_response(response)
        }
    }
}

/// Operation shape for `SearchFlowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_flow_executions`](crate::client::Client::search_flow_executions).
///
/// See [`crate::client::fluent_builders::SearchFlowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchFlowExecutions {
    _private: (),
}
impl SearchFlowExecutions {
    /// Creates a new builder-style object to manufacture [`SearchFlowExecutionsInput`](crate::input::SearchFlowExecutionsInput)
    pub fn builder() -> crate::input::search_flow_executions_input::Builder {
        crate::input::search_flow_executions_input::Builder::default()
    }
    /// Creates a new `SearchFlowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchFlowExecutions {
    type Output = std::result::Result<
        crate::output::SearchFlowExecutionsOutput,
        crate::error::SearchFlowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_flow_executions_error(response)
        } else {
            crate::operation_deser::parse_search_flow_executions_response(response)
        }
    }
}

/// Operation shape for `SearchFlowTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_flow_templates`](crate::client::Client::search_flow_templates).
///
/// See [`crate::client::fluent_builders::SearchFlowTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchFlowTemplates {
    _private: (),
}
impl SearchFlowTemplates {
    /// Creates a new builder-style object to manufacture [`SearchFlowTemplatesInput`](crate::input::SearchFlowTemplatesInput)
    pub fn builder() -> crate::input::search_flow_templates_input::Builder {
        crate::input::search_flow_templates_input::Builder::default()
    }
    /// Creates a new `SearchFlowTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchFlowTemplates {
    type Output = std::result::Result<
        crate::output::SearchFlowTemplatesOutput,
        crate::error::SearchFlowTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_flow_templates_error(response)
        } else {
            crate::operation_deser::parse_search_flow_templates_response(response)
        }
    }
}

/// Operation shape for `SearchSystemInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_system_instances`](crate::client::Client::search_system_instances).
///
/// See [`crate::client::fluent_builders::SearchSystemInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchSystemInstances {
    _private: (),
}
impl SearchSystemInstances {
    /// Creates a new builder-style object to manufacture [`SearchSystemInstancesInput`](crate::input::SearchSystemInstancesInput)
    pub fn builder() -> crate::input::search_system_instances_input::Builder {
        crate::input::search_system_instances_input::Builder::default()
    }
    /// Creates a new `SearchSystemInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchSystemInstances {
    type Output = std::result::Result<
        crate::output::SearchSystemInstancesOutput,
        crate::error::SearchSystemInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_system_instances_error(response)
        } else {
            crate::operation_deser::parse_search_system_instances_response(response)
        }
    }
}

/// Operation shape for `SearchSystemTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_system_templates`](crate::client::Client::search_system_templates).
///
/// See [`crate::client::fluent_builders::SearchSystemTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchSystemTemplates {
    _private: (),
}
impl SearchSystemTemplates {
    /// Creates a new builder-style object to manufacture [`SearchSystemTemplatesInput`](crate::input::SearchSystemTemplatesInput)
    pub fn builder() -> crate::input::search_system_templates_input::Builder {
        crate::input::search_system_templates_input::Builder::default()
    }
    /// Creates a new `SearchSystemTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchSystemTemplates {
    type Output = std::result::Result<
        crate::output::SearchSystemTemplatesOutput,
        crate::error::SearchSystemTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_system_templates_error(response)
        } else {
            crate::operation_deser::parse_search_system_templates_response(response)
        }
    }
}

/// Operation shape for `SearchThings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_things`](crate::client::Client::search_things).
///
/// See [`crate::client::fluent_builders::SearchThings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchThings {
    _private: (),
}
impl SearchThings {
    /// Creates a new builder-style object to manufacture [`SearchThingsInput`](crate::input::SearchThingsInput)
    pub fn builder() -> crate::input::search_things_input::Builder {
        crate::input::search_things_input::Builder::default()
    }
    /// Creates a new `SearchThings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchThings {
    type Output =
        std::result::Result<crate::output::SearchThingsOutput, crate::error::SearchThingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_things_error(response)
        } else {
            crate::operation_deser::parse_search_things_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UndeploySystemInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`undeploy_system_instance`](crate::client::Client::undeploy_system_instance).
///
/// See [`crate::client::fluent_builders::UndeploySystemInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UndeploySystemInstance {
    _private: (),
}
impl UndeploySystemInstance {
    /// Creates a new builder-style object to manufacture [`UndeploySystemInstanceInput`](crate::input::UndeploySystemInstanceInput)
    pub fn builder() -> crate::input::undeploy_system_instance_input::Builder {
        crate::input::undeploy_system_instance_input::Builder::default()
    }
    /// Creates a new `UndeploySystemInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UndeploySystemInstance {
    type Output = std::result::Result<
        crate::output::UndeploySystemInstanceOutput,
        crate::error::UndeploySystemInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_undeploy_system_instance_error(response)
        } else {
            crate::operation_deser::parse_undeploy_system_instance_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFlowTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow_template`](crate::client::Client::update_flow_template).
///
/// See [`crate::client::fluent_builders::UpdateFlowTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlowTemplate {
    _private: (),
}
impl UpdateFlowTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateFlowTemplateInput`](crate::input::UpdateFlowTemplateInput)
    pub fn builder() -> crate::input::update_flow_template_input::Builder {
        crate::input::update_flow_template_input::Builder::default()
    }
    /// Creates a new `UpdateFlowTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlowTemplate {
    type Output = std::result::Result<
        crate::output::UpdateFlowTemplateOutput,
        crate::error::UpdateFlowTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_flow_template_error(response)
        } else {
            crate::operation_deser::parse_update_flow_template_response(response)
        }
    }
}

/// Operation shape for `UpdateSystemTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_system_template`](crate::client::Client::update_system_template).
///
/// See [`crate::client::fluent_builders::UpdateSystemTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSystemTemplate {
    _private: (),
}
impl UpdateSystemTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateSystemTemplateInput`](crate::input::UpdateSystemTemplateInput)
    pub fn builder() -> crate::input::update_system_template_input::Builder {
        crate::input::update_system_template_input::Builder::default()
    }
    /// Creates a new `UpdateSystemTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSystemTemplate {
    type Output = std::result::Result<
        crate::output::UpdateSystemTemplateOutput,
        crate::error::UpdateSystemTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_system_template_error(response)
        } else {
            crate::operation_deser::parse_update_system_template_response(response)
        }
    }
}

/// Operation shape for `UploadEntityDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_entity_definitions`](crate::client::Client::upload_entity_definitions).
///
/// See [`crate::client::fluent_builders::UploadEntityDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadEntityDefinitions {
    _private: (),
}
impl UploadEntityDefinitions {
    /// Creates a new builder-style object to manufacture [`UploadEntityDefinitionsInput`](crate::input::UploadEntityDefinitionsInput)
    pub fn builder() -> crate::input::upload_entity_definitions_input::Builder {
        crate::input::upload_entity_definitions_input::Builder::default()
    }
    /// Creates a new `UploadEntityDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadEntityDefinitions {
    type Output = std::result::Result<
        crate::output::UploadEntityDefinitionsOutput,
        crate::error::UploadEntityDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_entity_definitions_error(response)
        } else {
            crate::operation_deser::parse_upload_entity_definitions_response(response)
        }
    }
}
