// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadEntityDefinitionsOutput {
    /// <p>The ID that specifies the upload action. You can use this to track the status of the upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
}
impl UploadEntityDefinitionsOutput {
    /// <p>The ID that specifies the upload action. You can use this to track the status of the upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
}
impl std::fmt::Debug for UploadEntityDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadEntityDefinitionsOutput");
        formatter.field("upload_id", &self.upload_id);
        formatter.finish()
    }
}
/// See [`UploadEntityDefinitionsOutput`](crate::output::UploadEntityDefinitionsOutput)
pub mod upload_entity_definitions_output {
    /// A builder for [`UploadEntityDefinitionsOutput`](crate::output::UploadEntityDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that specifies the upload action. You can use this to track the status of the upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The ID that specifies the upload action. You can use this to track the status of the upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadEntityDefinitionsOutput`](crate::output::UploadEntityDefinitionsOutput)
        pub fn build(self) -> crate::output::UploadEntityDefinitionsOutput {
            crate::output::UploadEntityDefinitionsOutput {
                upload_id: self.upload_id,
            }
        }
    }
}
impl UploadEntityDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`UploadEntityDefinitionsOutput`](crate::output::UploadEntityDefinitionsOutput)
    pub fn builder() -> crate::output::upload_entity_definitions_output::Builder {
        crate::output::upload_entity_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSystemTemplateOutput {
    /// <p>An object containing summary information about the updated system.</p>
    pub summary: std::option::Option<crate::model::SystemTemplateSummary>,
}
impl UpdateSystemTemplateOutput {
    /// <p>An object containing summary information about the updated system.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemTemplateSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for UpdateSystemTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSystemTemplateOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`UpdateSystemTemplateOutput`](crate::output::UpdateSystemTemplateOutput)
pub mod update_system_template_output {
    /// A builder for [`UpdateSystemTemplateOutput`](crate::output::UpdateSystemTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemTemplateSummary>,
    }
    impl Builder {
        /// <p>An object containing summary information about the updated system.</p>
        pub fn summary(mut self, input: crate::model::SystemTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object containing summary information about the updated system.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSystemTemplateOutput`](crate::output::UpdateSystemTemplateOutput)
        pub fn build(self) -> crate::output::UpdateSystemTemplateOutput {
            crate::output::UpdateSystemTemplateOutput {
                summary: self.summary,
            }
        }
    }
}
impl UpdateSystemTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSystemTemplateOutput`](crate::output::UpdateSystemTemplateOutput)
    pub fn builder() -> crate::output::update_system_template_output::Builder {
        crate::output::update_system_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowTemplateOutput {
    /// <p>An object containing summary information about the updated workflow.</p>
    pub summary: std::option::Option<crate::model::FlowTemplateSummary>,
}
impl UpdateFlowTemplateOutput {
    /// <p>An object containing summary information about the updated workflow.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::FlowTemplateSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowTemplateOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`UpdateFlowTemplateOutput`](crate::output::UpdateFlowTemplateOutput)
pub mod update_flow_template_output {
    /// A builder for [`UpdateFlowTemplateOutput`](crate::output::UpdateFlowTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::FlowTemplateSummary>,
    }
    impl Builder {
        /// <p>An object containing summary information about the updated workflow.</p>
        pub fn summary(mut self, input: crate::model::FlowTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object containing summary information about the updated workflow.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::FlowTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowTemplateOutput`](crate::output::UpdateFlowTemplateOutput)
        pub fn build(self) -> crate::output::UpdateFlowTemplateOutput {
            crate::output::UpdateFlowTemplateOutput {
                summary: self.summary,
            }
        }
    }
}
impl UpdateFlowTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowTemplateOutput`](crate::output::UpdateFlowTemplateOutput)
    pub fn builder() -> crate::output::update_flow_template_output::Builder {
        crate::output::update_flow_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UndeploySystemInstanceOutput {
    /// <p>An object that contains summary information about the system instance that was removed from its target.</p>
    pub summary: std::option::Option<crate::model::SystemInstanceSummary>,
}
impl UndeploySystemInstanceOutput {
    /// <p>An object that contains summary information about the system instance that was removed from its target.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemInstanceSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for UndeploySystemInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UndeploySystemInstanceOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`UndeploySystemInstanceOutput`](crate::output::UndeploySystemInstanceOutput)
pub mod undeploy_system_instance_output {
    /// A builder for [`UndeploySystemInstanceOutput`](crate::output::UndeploySystemInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemInstanceSummary>,
    }
    impl Builder {
        /// <p>An object that contains summary information about the system instance that was removed from its target.</p>
        pub fn summary(mut self, input: crate::model::SystemInstanceSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object that contains summary information about the system instance that was removed from its target.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`UndeploySystemInstanceOutput`](crate::output::UndeploySystemInstanceOutput)
        pub fn build(self) -> crate::output::UndeploySystemInstanceOutput {
            crate::output::UndeploySystemInstanceOutput {
                summary: self.summary,
            }
        }
    }
}
impl UndeploySystemInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UndeploySystemInstanceOutput`](crate::output::UndeploySystemInstanceOutput)
    pub fn builder() -> crate::output::undeploy_system_instance_output::Builder {
        crate::output::undeploy_system_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchThingsOutput {
    /// <p>An array of things in the result set.</p>
    pub things: std::option::Option<std::vec::Vec<crate::model::Thing>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchThingsOutput {
    /// <p>An array of things in the result set.</p>
    pub fn things(&self) -> std::option::Option<&[crate::model::Thing]> {
        self.things.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchThingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchThingsOutput");
        formatter.field("things", &self.things);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchThingsOutput`](crate::output::SearchThingsOutput)
pub mod search_things_output {
    /// A builder for [`SearchThingsOutput`](crate::output::SearchThingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) things: std::option::Option<std::vec::Vec<crate::model::Thing>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>An array of things in the result set.</p>
        pub fn things(mut self, input: impl Into<crate::model::Thing>) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input.into());
            self.things = Some(v);
            self
        }
        /// <p>An array of things in the result set.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Thing>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchThingsOutput`](crate::output::SearchThingsOutput)
        pub fn build(self) -> crate::output::SearchThingsOutput {
            crate::output::SearchThingsOutput {
                things: self.things,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchThingsOutput {
    /// Creates a new builder-style object to manufacture [`SearchThingsOutput`](crate::output::SearchThingsOutput)
    pub fn builder() -> crate::output::search_things_output::Builder {
        crate::output::search_things_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSystemTemplatesOutput {
    /// <p>An array of objects that contain summary information about each system deployment in the result set.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchSystemTemplatesOutput {
    /// <p>An array of objects that contain summary information about each system deployment in the result set.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::SystemTemplateSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchSystemTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSystemTemplatesOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchSystemTemplatesOutput`](crate::output::SearchSystemTemplatesOutput)
pub mod search_system_templates_output {
    /// A builder for [`SearchSystemTemplatesOutput`](crate::output::SearchSystemTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that contain summary information about each system deployment in the result set.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::SystemTemplateSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that contain summary information about each system deployment in the result set.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSystemTemplatesOutput`](crate::output::SearchSystemTemplatesOutput)
        pub fn build(self) -> crate::output::SearchSystemTemplatesOutput {
            crate::output::SearchSystemTemplatesOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchSystemTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`SearchSystemTemplatesOutput`](crate::output::SearchSystemTemplatesOutput)
    pub fn builder() -> crate::output::search_system_templates_output::Builder {
        crate::output::search_system_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSystemInstancesOutput {
    /// <p>An array of objects that contain summary data abour the system instances in the result set.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::SystemInstanceSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchSystemInstancesOutput {
    /// <p>An array of objects that contain summary data abour the system instances in the result set.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::SystemInstanceSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchSystemInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSystemInstancesOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchSystemInstancesOutput`](crate::output::SearchSystemInstancesOutput)
pub mod search_system_instances_output {
    /// A builder for [`SearchSystemInstancesOutput`](crate::output::SearchSystemInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::SystemInstanceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that contain summary data abour the system instances in the result set.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::SystemInstanceSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that contain summary data abour the system instances in the result set.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemInstanceSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSystemInstancesOutput`](crate::output::SearchSystemInstancesOutput)
        pub fn build(self) -> crate::output::SearchSystemInstancesOutput {
            crate::output::SearchSystemInstancesOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchSystemInstancesOutput {
    /// Creates a new builder-style object to manufacture [`SearchSystemInstancesOutput`](crate::output::SearchSystemInstancesOutput)
    pub fn builder() -> crate::output::search_system_instances_output::Builder {
        crate::output::search_system_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFlowTemplatesOutput {
    /// <p>An array of objects that contain summary information about each workflow in the result set.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchFlowTemplatesOutput {
    /// <p>An array of objects that contain summary information about each workflow in the result set.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::FlowTemplateSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchFlowTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFlowTemplatesOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchFlowTemplatesOutput`](crate::output::SearchFlowTemplatesOutput)
pub mod search_flow_templates_output {
    /// A builder for [`SearchFlowTemplatesOutput`](crate::output::SearchFlowTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that contain summary information about each workflow in the result set.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::FlowTemplateSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that contain summary information about each workflow in the result set.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFlowTemplatesOutput`](crate::output::SearchFlowTemplatesOutput)
        pub fn build(self) -> crate::output::SearchFlowTemplatesOutput {
            crate::output::SearchFlowTemplatesOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchFlowTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`SearchFlowTemplatesOutput`](crate::output::SearchFlowTemplatesOutput)
    pub fn builder() -> crate::output::search_flow_templates_output::Builder {
        crate::output::search_flow_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFlowExecutionsOutput {
    /// <p>An array of objects that contain summary information about each workflow execution in the result set.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::FlowExecutionSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchFlowExecutionsOutput {
    /// <p>An array of objects that contain summary information about each workflow execution in the result set.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::FlowExecutionSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchFlowExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFlowExecutionsOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchFlowExecutionsOutput`](crate::output::SearchFlowExecutionsOutput)
pub mod search_flow_executions_output {
    /// A builder for [`SearchFlowExecutionsOutput`](crate::output::SearchFlowExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::FlowExecutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that contain summary information about each workflow execution in the result set.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::FlowExecutionSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that contain summary information about each workflow execution in the result set.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowExecutionSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFlowExecutionsOutput`](crate::output::SearchFlowExecutionsOutput)
        pub fn build(self) -> crate::output::SearchFlowExecutionsOutput {
            crate::output::SearchFlowExecutionsOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchFlowExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`SearchFlowExecutionsOutput`](crate::output::SearchFlowExecutionsOutput)
    pub fn builder() -> crate::output::search_flow_executions_output::Builder {
        crate::output::search_flow_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchEntitiesOutput {
    /// <p>An array of descriptions for each entity returned in the search result.</p>
    pub descriptions: std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchEntitiesOutput {
    /// <p>An array of descriptions for each entity returned in the search result.</p>
    pub fn descriptions(&self) -> std::option::Option<&[crate::model::EntityDescription]> {
        self.descriptions.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchEntitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchEntitiesOutput");
        formatter.field("descriptions", &self.descriptions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchEntitiesOutput`](crate::output::SearchEntitiesOutput)
pub mod search_entities_output {
    /// A builder for [`SearchEntitiesOutput`](crate::output::SearchEntitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) descriptions:
            std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>An array of descriptions for each entity returned in the search result.</p>
        pub fn descriptions(mut self, input: impl Into<crate::model::EntityDescription>) -> Self {
            let mut v = self.descriptions.unwrap_or_default();
            v.push(input.into());
            self.descriptions = Some(v);
            self
        }
        /// <p>An array of descriptions for each entity returned in the search result.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
        ) -> Self {
            self.descriptions = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchEntitiesOutput`](crate::output::SearchEntitiesOutput)
        pub fn build(self) -> crate::output::SearchEntitiesOutput {
            crate::output::SearchEntitiesOutput {
                descriptions: self.descriptions,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchEntitiesOutput {
    /// Creates a new builder-style object to manufacture [`SearchEntitiesOutput`](crate::output::SearchEntitiesOutput)
    pub fn builder() -> crate::output::search_entities_output::Builder {
        crate::output::search_entities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The token that specifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The token that specifies the next page of results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowExecutionMessagesOutput {
    /// <p>A list of objects that contain information about events in the specified flow execution.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::FlowExecutionMessage>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowExecutionMessagesOutput {
    /// <p>A list of objects that contain information about events in the specified flow execution.</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::FlowExecutionMessage]> {
        self.messages.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowExecutionMessagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowExecutionMessagesOutput");
        formatter.field("messages", &self.messages);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFlowExecutionMessagesOutput`](crate::output::ListFlowExecutionMessagesOutput)
pub mod list_flow_execution_messages_output {
    /// A builder for [`ListFlowExecutionMessagesOutput`](crate::output::ListFlowExecutionMessagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::FlowExecutionMessage>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A list of objects that contain information about events in the specified flow execution.</p>
        pub fn messages(mut self, input: impl Into<crate::model::FlowExecutionMessage>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>A list of objects that contain information about events in the specified flow execution.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowExecutionMessage>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowExecutionMessagesOutput`](crate::output::ListFlowExecutionMessagesOutput)
        pub fn build(self) -> crate::output::ListFlowExecutionMessagesOutput {
            crate::output::ListFlowExecutionMessagesOutput {
                messages: self.messages,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFlowExecutionMessagesOutput {
    /// Creates a new builder-style object to manufacture [`ListFlowExecutionMessagesOutput`](crate::output::ListFlowExecutionMessagesOutput)
    pub fn builder() -> crate::output::list_flow_execution_messages_output::Builder {
        crate::output::list_flow_execution_messages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUploadStatusOutput {
    /// <p>The ID of the upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation failures if the upload fails.</p>
    pub upload_status: std::option::Option<crate::model::UploadStatus>,
    /// <p>The ARN of the upload.</p>
    pub namespace_arn: std::option::Option<std::string::String>,
    /// <p>The name of the upload's namespace.</p>
    pub namespace_name: std::option::Option<std::string::String>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub namespace_version: std::option::Option<i64>,
    /// <p>The reason for an upload failure.</p>
    pub failure_reason: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date at which the upload was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetUploadStatusOutput {
    /// <p>The ID of the upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation failures if the upload fails.</p>
    pub fn upload_status(&self) -> std::option::Option<&crate::model::UploadStatus> {
        self.upload_status.as_ref()
    }
    /// <p>The ARN of the upload.</p>
    pub fn namespace_arn(&self) -> std::option::Option<&str> {
        self.namespace_arn.as_deref()
    }
    /// <p>The name of the upload's namespace.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub fn namespace_version(&self) -> std::option::Option<i64> {
        self.namespace_version
    }
    /// <p>The reason for an upload failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reason.as_deref()
    }
    /// <p>The date at which the upload was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for GetUploadStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUploadStatusOutput");
        formatter.field("upload_id", &self.upload_id);
        formatter.field("upload_status", &self.upload_status);
        formatter.field("namespace_arn", &self.namespace_arn);
        formatter.field("namespace_name", &self.namespace_name);
        formatter.field("namespace_version", &self.namespace_version);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`GetUploadStatusOutput`](crate::output::GetUploadStatusOutput)
pub mod get_upload_status_output {
    /// A builder for [`GetUploadStatusOutput`](crate::output::GetUploadStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) upload_status: std::option::Option<crate::model::UploadStatus>,
        pub(crate) namespace_arn: std::option::Option<std::string::String>,
        pub(crate) namespace_name: std::option::Option<std::string::String>,
        pub(crate) namespace_version: std::option::Option<i64>,
        pub(crate) failure_reason: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The ID of the upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation failures if the upload fails.</p>
        pub fn upload_status(mut self, input: crate::model::UploadStatus) -> Self {
            self.upload_status = Some(input);
            self
        }
        /// <p>The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation failures if the upload fails.</p>
        pub fn set_upload_status(
            mut self,
            input: std::option::Option<crate::model::UploadStatus>,
        ) -> Self {
            self.upload_status = input;
            self
        }
        /// <p>The ARN of the upload.</p>
        pub fn namespace_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the upload.</p>
        pub fn set_namespace_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_arn = input;
            self
        }
        /// <p>The name of the upload's namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the upload's namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Appends an item to `failure_reason`.
        ///
        /// To override the contents of this collection use [`set_failure_reason`](Self::set_failure_reason).
        ///
        /// <p>The reason for an upload failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reason.unwrap_or_default();
            v.push(input.into());
            self.failure_reason = Some(v);
            self
        }
        /// <p>The reason for an upload failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date at which the upload was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date at which the upload was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUploadStatusOutput`](crate::output::GetUploadStatusOutput)
        pub fn build(self) -> crate::output::GetUploadStatusOutput {
            crate::output::GetUploadStatusOutput {
                upload_id: self.upload_id,
                upload_status: self.upload_status,
                namespace_arn: self.namespace_arn,
                namespace_name: self.namespace_name,
                namespace_version: self.namespace_version,
                failure_reason: self.failure_reason,
                created_date: self.created_date,
            }
        }
    }
}
impl GetUploadStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetUploadStatusOutput`](crate::output::GetUploadStatusOutput)
    pub fn builder() -> crate::output::get_upload_status_output::Builder {
        crate::output::get_upload_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemTemplateRevisionsOutput {
    /// <p>An array of objects that contain summary data about the system template revisions.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSystemTemplateRevisionsOutput {
    /// <p>An array of objects that contain summary data about the system template revisions.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::SystemTemplateSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSystemTemplateRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemTemplateRevisionsOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSystemTemplateRevisionsOutput`](crate::output::GetSystemTemplateRevisionsOutput)
pub mod get_system_template_revisions_output {
    /// A builder for [`GetSystemTemplateRevisionsOutput`](crate::output::GetSystemTemplateRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that contain summary data about the system template revisions.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::SystemTemplateSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that contain summary data about the system template revisions.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemTemplateSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemTemplateRevisionsOutput`](crate::output::GetSystemTemplateRevisionsOutput)
        pub fn build(self) -> crate::output::GetSystemTemplateRevisionsOutput {
            crate::output::GetSystemTemplateRevisionsOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSystemTemplateRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateRevisionsOutput`](crate::output::GetSystemTemplateRevisionsOutput)
    pub fn builder() -> crate::output::get_system_template_revisions_output::Builder {
        crate::output::get_system_template_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemTemplateOutput {
    /// <p>An object that contains summary data about the system.</p>
    pub description: std::option::Option<crate::model::SystemTemplateDescription>,
}
impl GetSystemTemplateOutput {
    /// <p>An object that contains summary data about the system.</p>
    pub fn description(&self) -> std::option::Option<&crate::model::SystemTemplateDescription> {
        self.description.as_ref()
    }
}
impl std::fmt::Debug for GetSystemTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemTemplateOutput");
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GetSystemTemplateOutput`](crate::output::GetSystemTemplateOutput)
pub mod get_system_template_output {
    /// A builder for [`GetSystemTemplateOutput`](crate::output::GetSystemTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<crate::model::SystemTemplateDescription>,
    }
    impl Builder {
        /// <p>An object that contains summary data about the system.</p>
        pub fn description(mut self, input: crate::model::SystemTemplateDescription) -> Self {
            self.description = Some(input);
            self
        }
        /// <p>An object that contains summary data about the system.</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<crate::model::SystemTemplateDescription>,
        ) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemTemplateOutput`](crate::output::GetSystemTemplateOutput)
        pub fn build(self) -> crate::output::GetSystemTemplateOutput {
            crate::output::GetSystemTemplateOutput {
                description: self.description,
            }
        }
    }
}
impl GetSystemTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateOutput`](crate::output::GetSystemTemplateOutput)
    pub fn builder() -> crate::output::get_system_template_output::Builder {
        crate::output::get_system_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemInstanceOutput {
    /// <p>An object that describes the system instance.</p>
    pub description: std::option::Option<crate::model::SystemInstanceDescription>,
}
impl GetSystemInstanceOutput {
    /// <p>An object that describes the system instance.</p>
    pub fn description(&self) -> std::option::Option<&crate::model::SystemInstanceDescription> {
        self.description.as_ref()
    }
}
impl std::fmt::Debug for GetSystemInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemInstanceOutput");
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GetSystemInstanceOutput`](crate::output::GetSystemInstanceOutput)
pub mod get_system_instance_output {
    /// A builder for [`GetSystemInstanceOutput`](crate::output::GetSystemInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<crate::model::SystemInstanceDescription>,
    }
    impl Builder {
        /// <p>An object that describes the system instance.</p>
        pub fn description(mut self, input: crate::model::SystemInstanceDescription) -> Self {
            self.description = Some(input);
            self
        }
        /// <p>An object that describes the system instance.</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceDescription>,
        ) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemInstanceOutput`](crate::output::GetSystemInstanceOutput)
        pub fn build(self) -> crate::output::GetSystemInstanceOutput {
            crate::output::GetSystemInstanceOutput {
                description: self.description,
            }
        }
    }
}
impl GetSystemInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetSystemInstanceOutput`](crate::output::GetSystemInstanceOutput)
    pub fn builder() -> crate::output::get_system_instance_output::Builder {
        crate::output::get_system_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNamespaceDeletionStatusOutput {
    /// <p>The ARN of the namespace that is being deleted.</p>
    pub namespace_arn: std::option::Option<std::string::String>,
    /// <p>The name of the namespace that is being deleted.</p>
    pub namespace_name: std::option::Option<std::string::String>,
    /// <p>The status of the deletion request.</p>
    pub status: std::option::Option<crate::model::NamespaceDeletionStatus>,
    /// <p>An error code returned by the namespace deletion task.</p>
    pub error_code: std::option::Option<crate::model::NamespaceDeletionStatusErrorCodes>,
    /// <p>An error code returned by the namespace deletion task.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl GetNamespaceDeletionStatusOutput {
    /// <p>The ARN of the namespace that is being deleted.</p>
    pub fn namespace_arn(&self) -> std::option::Option<&str> {
        self.namespace_arn.as_deref()
    }
    /// <p>The name of the namespace that is being deleted.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
    /// <p>The status of the deletion request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NamespaceDeletionStatus> {
        self.status.as_ref()
    }
    /// <p>An error code returned by the namespace deletion task.</p>
    pub fn error_code(
        &self,
    ) -> std::option::Option<&crate::model::NamespaceDeletionStatusErrorCodes> {
        self.error_code.as_ref()
    }
    /// <p>An error code returned by the namespace deletion task.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for GetNamespaceDeletionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNamespaceDeletionStatusOutput");
        formatter.field("namespace_arn", &self.namespace_arn);
        formatter.field("namespace_name", &self.namespace_name);
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`GetNamespaceDeletionStatusOutput`](crate::output::GetNamespaceDeletionStatusOutput)
pub mod get_namespace_deletion_status_output {
    /// A builder for [`GetNamespaceDeletionStatusOutput`](crate::output::GetNamespaceDeletionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_arn: std::option::Option<std::string::String>,
        pub(crate) namespace_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NamespaceDeletionStatus>,
        pub(crate) error_code: std::option::Option<crate::model::NamespaceDeletionStatusErrorCodes>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the namespace that is being deleted.</p>
        pub fn namespace_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the namespace that is being deleted.</p>
        pub fn set_namespace_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_arn = input;
            self
        }
        /// <p>The name of the namespace that is being deleted.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the namespace that is being deleted.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// <p>The status of the deletion request.</p>
        pub fn status(mut self, input: crate::model::NamespaceDeletionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the deletion request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NamespaceDeletionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An error code returned by the namespace deletion task.</p>
        pub fn error_code(
            mut self,
            input: crate::model::NamespaceDeletionStatusErrorCodes,
        ) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>An error code returned by the namespace deletion task.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::NamespaceDeletionStatusErrorCodes>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error code returned by the namespace deletion task.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error code returned by the namespace deletion task.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNamespaceDeletionStatusOutput`](crate::output::GetNamespaceDeletionStatusOutput)
        pub fn build(self) -> crate::output::GetNamespaceDeletionStatusOutput {
            crate::output::GetNamespaceDeletionStatusOutput {
                namespace_arn: self.namespace_arn,
                namespace_name: self.namespace_name,
                status: self.status,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl GetNamespaceDeletionStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetNamespaceDeletionStatusOutput`](crate::output::GetNamespaceDeletionStatusOutput)
    pub fn builder() -> crate::output::get_namespace_deletion_status_output::Builder {
        crate::output::get_namespace_deletion_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFlowTemplateRevisionsOutput {
    /// <p>An array of objects that provide summary data about each revision.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetFlowTemplateRevisionsOutput {
    /// <p>An array of objects that provide summary data about each revision.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::FlowTemplateSummary]> {
        self.summaries.as_deref()
    }
    /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetFlowTemplateRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFlowTemplateRevisionsOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetFlowTemplateRevisionsOutput`](crate::output::GetFlowTemplateRevisionsOutput)
pub mod get_flow_template_revisions_output {
    /// A builder for [`GetFlowTemplateRevisionsOutput`](crate::output::GetFlowTemplateRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>An array of objects that provide summary data about each revision.</p>
        pub fn summaries(mut self, input: impl Into<crate::model::FlowTemplateSummary>) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input.into());
            self.summaries = Some(v);
            self
        }
        /// <p>An array of objects that provide summary data about each revision.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowTemplateSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to specify as <code>nextToken</code> when you request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFlowTemplateRevisionsOutput`](crate::output::GetFlowTemplateRevisionsOutput)
        pub fn build(self) -> crate::output::GetFlowTemplateRevisionsOutput {
            crate::output::GetFlowTemplateRevisionsOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetFlowTemplateRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateRevisionsOutput`](crate::output::GetFlowTemplateRevisionsOutput)
    pub fn builder() -> crate::output::get_flow_template_revisions_output::Builder {
        crate::output::get_flow_template_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFlowTemplateOutput {
    /// <p>The object that describes the specified workflow.</p>
    pub description: std::option::Option<crate::model::FlowTemplateDescription>,
}
impl GetFlowTemplateOutput {
    /// <p>The object that describes the specified workflow.</p>
    pub fn description(&self) -> std::option::Option<&crate::model::FlowTemplateDescription> {
        self.description.as_ref()
    }
}
impl std::fmt::Debug for GetFlowTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFlowTemplateOutput");
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GetFlowTemplateOutput`](crate::output::GetFlowTemplateOutput)
pub mod get_flow_template_output {
    /// A builder for [`GetFlowTemplateOutput`](crate::output::GetFlowTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<crate::model::FlowTemplateDescription>,
    }
    impl Builder {
        /// <p>The object that describes the specified workflow.</p>
        pub fn description(mut self, input: crate::model::FlowTemplateDescription) -> Self {
            self.description = Some(input);
            self
        }
        /// <p>The object that describes the specified workflow.</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<crate::model::FlowTemplateDescription>,
        ) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFlowTemplateOutput`](crate::output::GetFlowTemplateOutput)
        pub fn build(self) -> crate::output::GetFlowTemplateOutput {
            crate::output::GetFlowTemplateOutput {
                description: self.description,
            }
        }
    }
}
impl GetFlowTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateOutput`](crate::output::GetFlowTemplateOutput)
    pub fn builder() -> crate::output::get_flow_template_output::Builder {
        crate::output::get_flow_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntitiesOutput {
    /// <p>An array of descriptions for the specified entities.</p>
    pub descriptions: std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
}
impl GetEntitiesOutput {
    /// <p>An array of descriptions for the specified entities.</p>
    pub fn descriptions(&self) -> std::option::Option<&[crate::model::EntityDescription]> {
        self.descriptions.as_deref()
    }
}
impl std::fmt::Debug for GetEntitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntitiesOutput");
        formatter.field("descriptions", &self.descriptions);
        formatter.finish()
    }
}
/// See [`GetEntitiesOutput`](crate::output::GetEntitiesOutput)
pub mod get_entities_output {
    /// A builder for [`GetEntitiesOutput`](crate::output::GetEntitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) descriptions:
            std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
    }
    impl Builder {
        /// Appends an item to `descriptions`.
        ///
        /// To override the contents of this collection use [`set_descriptions`](Self::set_descriptions).
        ///
        /// <p>An array of descriptions for the specified entities.</p>
        pub fn descriptions(mut self, input: impl Into<crate::model::EntityDescription>) -> Self {
            let mut v = self.descriptions.unwrap_or_default();
            v.push(input.into());
            self.descriptions = Some(v);
            self
        }
        /// <p>An array of descriptions for the specified entities.</p>
        pub fn set_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityDescription>>,
        ) -> Self {
            self.descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntitiesOutput`](crate::output::GetEntitiesOutput)
        pub fn build(self) -> crate::output::GetEntitiesOutput {
            crate::output::GetEntitiesOutput {
                descriptions: self.descriptions,
            }
        }
    }
}
impl GetEntitiesOutput {
    /// Creates a new builder-style object to manufacture [`GetEntitiesOutput`](crate::output::GetEntitiesOutput)
    pub fn builder() -> crate::output::get_entities_output::Builder {
        crate::output::get_entities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociateEntityFromThingOutput {}
impl std::fmt::Debug for DissociateEntityFromThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociateEntityFromThingOutput");
        formatter.finish()
    }
}
/// See [`DissociateEntityFromThingOutput`](crate::output::DissociateEntityFromThingOutput)
pub mod dissociate_entity_from_thing_output {
    /// A builder for [`DissociateEntityFromThingOutput`](crate::output::DissociateEntityFromThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DissociateEntityFromThingOutput`](crate::output::DissociateEntityFromThingOutput)
        pub fn build(self) -> crate::output::DissociateEntityFromThingOutput {
            crate::output::DissociateEntityFromThingOutput {}
        }
    }
}
impl DissociateEntityFromThingOutput {
    /// Creates a new builder-style object to manufacture [`DissociateEntityFromThingOutput`](crate::output::DissociateEntityFromThingOutput)
    pub fn builder() -> crate::output::dissociate_entity_from_thing_output::Builder {
        crate::output::dissociate_entity_from_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNamespaceOutput {
    /// <p>The ARN of the namespace.</p>
    pub namespace_arn: std::option::Option<std::string::String>,
    /// <p>The name of the namespace.</p>
    pub namespace_name: std::option::Option<std::string::String>,
    /// <p>The name of the public namespace that the latest namespace version is tracking.</p>
    pub tracking_namespace_name: std::option::Option<std::string::String>,
    /// <p>The version of the public namespace that the latest version is tracking.</p>
    pub tracking_namespace_version: std::option::Option<i64>,
    /// <p>The version of the user's namespace to describe.</p>
    pub namespace_version: std::option::Option<i64>,
}
impl DescribeNamespaceOutput {
    /// <p>The ARN of the namespace.</p>
    pub fn namespace_arn(&self) -> std::option::Option<&str> {
        self.namespace_arn.as_deref()
    }
    /// <p>The name of the namespace.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
    /// <p>The name of the public namespace that the latest namespace version is tracking.</p>
    pub fn tracking_namespace_name(&self) -> std::option::Option<&str> {
        self.tracking_namespace_name.as_deref()
    }
    /// <p>The version of the public namespace that the latest version is tracking.</p>
    pub fn tracking_namespace_version(&self) -> std::option::Option<i64> {
        self.tracking_namespace_version
    }
    /// <p>The version of the user's namespace to describe.</p>
    pub fn namespace_version(&self) -> std::option::Option<i64> {
        self.namespace_version
    }
}
impl std::fmt::Debug for DescribeNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNamespaceOutput");
        formatter.field("namespace_arn", &self.namespace_arn);
        formatter.field("namespace_name", &self.namespace_name);
        formatter.field("tracking_namespace_name", &self.tracking_namespace_name);
        formatter.field(
            "tracking_namespace_version",
            &self.tracking_namespace_version,
        );
        formatter.field("namespace_version", &self.namespace_version);
        formatter.finish()
    }
}
/// See [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
pub mod describe_namespace_output {
    /// A builder for [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_arn: std::option::Option<std::string::String>,
        pub(crate) namespace_name: std::option::Option<std::string::String>,
        pub(crate) tracking_namespace_name: std::option::Option<std::string::String>,
        pub(crate) tracking_namespace_version: std::option::Option<i64>,
        pub(crate) namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ARN of the namespace.</p>
        pub fn namespace_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the namespace.</p>
        pub fn set_namespace_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_arn = input;
            self
        }
        /// <p>The name of the namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// <p>The name of the public namespace that the latest namespace version is tracking.</p>
        pub fn tracking_namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the public namespace that the latest namespace version is tracking.</p>
        pub fn set_tracking_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracking_namespace_name = input;
            self
        }
        /// <p>The version of the public namespace that the latest version is tracking.</p>
        pub fn tracking_namespace_version(mut self, input: i64) -> Self {
            self.tracking_namespace_version = Some(input);
            self
        }
        /// <p>The version of the public namespace that the latest version is tracking.</p>
        pub fn set_tracking_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.tracking_namespace_version = input;
            self
        }
        /// <p>The version of the user's namespace to describe.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace to describe.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
        pub fn build(self) -> crate::output::DescribeNamespaceOutput {
            crate::output::DescribeNamespaceOutput {
                namespace_arn: self.namespace_arn,
                namespace_name: self.namespace_name,
                tracking_namespace_name: self.tracking_namespace_name,
                tracking_namespace_version: self.tracking_namespace_version,
                namespace_version: self.namespace_version,
            }
        }
    }
}
impl DescribeNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
    pub fn builder() -> crate::output::describe_namespace_output::Builder {
        crate::output::describe_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateSystemTemplateOutput {}
impl std::fmt::Debug for DeprecateSystemTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateSystemTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeprecateSystemTemplateOutput`](crate::output::DeprecateSystemTemplateOutput)
pub mod deprecate_system_template_output {
    /// A builder for [`DeprecateSystemTemplateOutput`](crate::output::DeprecateSystemTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeprecateSystemTemplateOutput`](crate::output::DeprecateSystemTemplateOutput)
        pub fn build(self) -> crate::output::DeprecateSystemTemplateOutput {
            crate::output::DeprecateSystemTemplateOutput {}
        }
    }
}
impl DeprecateSystemTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeprecateSystemTemplateOutput`](crate::output::DeprecateSystemTemplateOutput)
    pub fn builder() -> crate::output::deprecate_system_template_output::Builder {
        crate::output::deprecate_system_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateFlowTemplateOutput {}
impl std::fmt::Debug for DeprecateFlowTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateFlowTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeprecateFlowTemplateOutput`](crate::output::DeprecateFlowTemplateOutput)
pub mod deprecate_flow_template_output {
    /// A builder for [`DeprecateFlowTemplateOutput`](crate::output::DeprecateFlowTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeprecateFlowTemplateOutput`](crate::output::DeprecateFlowTemplateOutput)
        pub fn build(self) -> crate::output::DeprecateFlowTemplateOutput {
            crate::output::DeprecateFlowTemplateOutput {}
        }
    }
}
impl DeprecateFlowTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeprecateFlowTemplateOutput`](crate::output::DeprecateFlowTemplateOutput)
    pub fn builder() -> crate::output::deprecate_flow_template_output::Builder {
        crate::output::deprecate_flow_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploySystemInstanceOutput {
    /// <p>An object that contains summary information about a system instance that was deployed. </p>
    pub summary: std::option::Option<crate::model::SystemInstanceSummary>,
    /// <p>The ID of the Greengrass deployment used to deploy the system instance.</p>
    pub greengrass_deployment_id: std::option::Option<std::string::String>,
}
impl DeploySystemInstanceOutput {
    /// <p>An object that contains summary information about a system instance that was deployed. </p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemInstanceSummary> {
        self.summary.as_ref()
    }
    /// <p>The ID of the Greengrass deployment used to deploy the system instance.</p>
    pub fn greengrass_deployment_id(&self) -> std::option::Option<&str> {
        self.greengrass_deployment_id.as_deref()
    }
}
impl std::fmt::Debug for DeploySystemInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploySystemInstanceOutput");
        formatter.field("summary", &self.summary);
        formatter.field("greengrass_deployment_id", &self.greengrass_deployment_id);
        formatter.finish()
    }
}
/// See [`DeploySystemInstanceOutput`](crate::output::DeploySystemInstanceOutput)
pub mod deploy_system_instance_output {
    /// A builder for [`DeploySystemInstanceOutput`](crate::output::DeploySystemInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemInstanceSummary>,
        pub(crate) greengrass_deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An object that contains summary information about a system instance that was deployed. </p>
        pub fn summary(mut self, input: crate::model::SystemInstanceSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object that contains summary information about a system instance that was deployed. </p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// <p>The ID of the Greengrass deployment used to deploy the system instance.</p>
        pub fn greengrass_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the Greengrass deployment used to deploy the system instance.</p>
        pub fn set_greengrass_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploySystemInstanceOutput`](crate::output::DeploySystemInstanceOutput)
        pub fn build(self) -> crate::output::DeploySystemInstanceOutput {
            crate::output::DeploySystemInstanceOutput {
                summary: self.summary,
                greengrass_deployment_id: self.greengrass_deployment_id,
            }
        }
    }
}
impl DeploySystemInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeploySystemInstanceOutput`](crate::output::DeploySystemInstanceOutput)
    pub fn builder() -> crate::output::deploy_system_instance_output::Builder {
        crate::output::deploy_system_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSystemTemplateOutput {}
impl std::fmt::Debug for DeleteSystemTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSystemTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteSystemTemplateOutput`](crate::output::DeleteSystemTemplateOutput)
pub mod delete_system_template_output {
    /// A builder for [`DeleteSystemTemplateOutput`](crate::output::DeleteSystemTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSystemTemplateOutput`](crate::output::DeleteSystemTemplateOutput)
        pub fn build(self) -> crate::output::DeleteSystemTemplateOutput {
            crate::output::DeleteSystemTemplateOutput {}
        }
    }
}
impl DeleteSystemTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSystemTemplateOutput`](crate::output::DeleteSystemTemplateOutput)
    pub fn builder() -> crate::output::delete_system_template_output::Builder {
        crate::output::delete_system_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSystemInstanceOutput {}
impl std::fmt::Debug for DeleteSystemInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSystemInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeleteSystemInstanceOutput`](crate::output::DeleteSystemInstanceOutput)
pub mod delete_system_instance_output {
    /// A builder for [`DeleteSystemInstanceOutput`](crate::output::DeleteSystemInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSystemInstanceOutput`](crate::output::DeleteSystemInstanceOutput)
        pub fn build(self) -> crate::output::DeleteSystemInstanceOutput {
            crate::output::DeleteSystemInstanceOutput {}
        }
    }
}
impl DeleteSystemInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSystemInstanceOutput`](crate::output::DeleteSystemInstanceOutput)
    pub fn builder() -> crate::output::delete_system_instance_output::Builder {
        crate::output::delete_system_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNamespaceOutput {
    /// <p>The ARN of the namespace to be deleted.</p>
    pub namespace_arn: std::option::Option<std::string::String>,
    /// <p>The name of the namespace to be deleted.</p>
    pub namespace_name: std::option::Option<std::string::String>,
}
impl DeleteNamespaceOutput {
    /// <p>The ARN of the namespace to be deleted.</p>
    pub fn namespace_arn(&self) -> std::option::Option<&str> {
        self.namespace_arn.as_deref()
    }
    /// <p>The name of the namespace to be deleted.</p>
    pub fn namespace_name(&self) -> std::option::Option<&str> {
        self.namespace_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNamespaceOutput");
        formatter.field("namespace_arn", &self.namespace_arn);
        formatter.field("namespace_name", &self.namespace_name);
        formatter.finish()
    }
}
/// See [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
pub mod delete_namespace_output {
    /// A builder for [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_arn: std::option::Option<std::string::String>,
        pub(crate) namespace_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the namespace to be deleted.</p>
        pub fn namespace_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the namespace to be deleted.</p>
        pub fn set_namespace_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_arn = input;
            self
        }
        /// <p>The name of the namespace to be deleted.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the namespace to be deleted.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
        pub fn build(self) -> crate::output::DeleteNamespaceOutput {
            crate::output::DeleteNamespaceOutput {
                namespace_arn: self.namespace_arn,
                namespace_name: self.namespace_name,
            }
        }
    }
}
impl DeleteNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    pub fn builder() -> crate::output::delete_namespace_output::Builder {
        crate::output::delete_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowTemplateOutput {}
impl std::fmt::Debug for DeleteFlowTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteFlowTemplateOutput`](crate::output::DeleteFlowTemplateOutput)
pub mod delete_flow_template_output {
    /// A builder for [`DeleteFlowTemplateOutput`](crate::output::DeleteFlowTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFlowTemplateOutput`](crate::output::DeleteFlowTemplateOutput)
        pub fn build(self) -> crate::output::DeleteFlowTemplateOutput {
            crate::output::DeleteFlowTemplateOutput {}
        }
    }
}
impl DeleteFlowTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFlowTemplateOutput`](crate::output::DeleteFlowTemplateOutput)
    pub fn builder() -> crate::output::delete_flow_template_output::Builder {
        crate::output::delete_flow_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSystemTemplateOutput {
    /// <p>The summary object that describes the created system.</p>
    pub summary: std::option::Option<crate::model::SystemTemplateSummary>,
}
impl CreateSystemTemplateOutput {
    /// <p>The summary object that describes the created system.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemTemplateSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for CreateSystemTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSystemTemplateOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`CreateSystemTemplateOutput`](crate::output::CreateSystemTemplateOutput)
pub mod create_system_template_output {
    /// A builder for [`CreateSystemTemplateOutput`](crate::output::CreateSystemTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemTemplateSummary>,
    }
    impl Builder {
        /// <p>The summary object that describes the created system.</p>
        pub fn summary(mut self, input: crate::model::SystemTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>The summary object that describes the created system.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSystemTemplateOutput`](crate::output::CreateSystemTemplateOutput)
        pub fn build(self) -> crate::output::CreateSystemTemplateOutput {
            crate::output::CreateSystemTemplateOutput {
                summary: self.summary,
            }
        }
    }
}
impl CreateSystemTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateSystemTemplateOutput`](crate::output::CreateSystemTemplateOutput)
    pub fn builder() -> crate::output::create_system_template_output::Builder {
        crate::output::create_system_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSystemInstanceOutput {
    /// <p>The summary object that describes the new system instance.</p>
    pub summary: std::option::Option<crate::model::SystemInstanceSummary>,
}
impl CreateSystemInstanceOutput {
    /// <p>The summary object that describes the new system instance.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemInstanceSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for CreateSystemInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSystemInstanceOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`CreateSystemInstanceOutput`](crate::output::CreateSystemInstanceOutput)
pub mod create_system_instance_output {
    /// A builder for [`CreateSystemInstanceOutput`](crate::output::CreateSystemInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemInstanceSummary>,
    }
    impl Builder {
        /// <p>The summary object that describes the new system instance.</p>
        pub fn summary(mut self, input: crate::model::SystemInstanceSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>The summary object that describes the new system instance.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSystemInstanceOutput`](crate::output::CreateSystemInstanceOutput)
        pub fn build(self) -> crate::output::CreateSystemInstanceOutput {
            crate::output::CreateSystemInstanceOutput {
                summary: self.summary,
            }
        }
    }
}
impl CreateSystemInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateSystemInstanceOutput`](crate::output::CreateSystemInstanceOutput)
    pub fn builder() -> crate::output::create_system_instance_output::Builder {
        crate::output::create_system_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowTemplateOutput {
    /// <p>The summary object that describes the created workflow.</p>
    pub summary: std::option::Option<crate::model::FlowTemplateSummary>,
}
impl CreateFlowTemplateOutput {
    /// <p>The summary object that describes the created workflow.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::FlowTemplateSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for CreateFlowTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowTemplateOutput");
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`CreateFlowTemplateOutput`](crate::output::CreateFlowTemplateOutput)
pub mod create_flow_template_output {
    /// A builder for [`CreateFlowTemplateOutput`](crate::output::CreateFlowTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::FlowTemplateSummary>,
    }
    impl Builder {
        /// <p>The summary object that describes the created workflow.</p>
        pub fn summary(mut self, input: crate::model::FlowTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>The summary object that describes the created workflow.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::FlowTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowTemplateOutput`](crate::output::CreateFlowTemplateOutput)
        pub fn build(self) -> crate::output::CreateFlowTemplateOutput {
            crate::output::CreateFlowTemplateOutput {
                summary: self.summary,
            }
        }
    }
}
impl CreateFlowTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateFlowTemplateOutput`](crate::output::CreateFlowTemplateOutput)
    pub fn builder() -> crate::output::create_flow_template_output::Builder {
        crate::output::create_flow_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateEntityToThingOutput {}
impl std::fmt::Debug for AssociateEntityToThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateEntityToThingOutput");
        formatter.finish()
    }
}
/// See [`AssociateEntityToThingOutput`](crate::output::AssociateEntityToThingOutput)
pub mod associate_entity_to_thing_output {
    /// A builder for [`AssociateEntityToThingOutput`](crate::output::AssociateEntityToThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateEntityToThingOutput`](crate::output::AssociateEntityToThingOutput)
        pub fn build(self) -> crate::output::AssociateEntityToThingOutput {
            crate::output::AssociateEntityToThingOutput {}
        }
    }
}
impl AssociateEntityToThingOutput {
    /// Creates a new builder-style object to manufacture [`AssociateEntityToThingOutput`](crate::output::AssociateEntityToThingOutput)
    pub fn builder() -> crate::output::associate_entity_to_thing_output::Builder {
        crate::output::associate_entity_to_thing_output::Builder::default()
    }
}
