// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A document that defines an entity. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefinitionDocument {
    /// <p>The language used to define the entity. <code>GRAPHQL</code> is the only valid value.</p>
    pub language: std::option::Option<crate::model::DefinitionLanguage>,
    /// <p>The GraphQL text that defines the entity.</p>
    pub text: std::option::Option<std::string::String>,
}
impl DefinitionDocument {
    /// <p>The language used to define the entity. <code>GRAPHQL</code> is the only valid value.</p>
    pub fn language(&self) -> std::option::Option<&crate::model::DefinitionLanguage> {
        self.language.as_ref()
    }
    /// <p>The GraphQL text that defines the entity.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl std::fmt::Debug for DefinitionDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefinitionDocument");
        formatter.field("language", &self.language);
        formatter.field("text", &self.text);
        formatter.finish()
    }
}
/// See [`DefinitionDocument`](crate::model::DefinitionDocument)
pub mod definition_document {
    /// A builder for [`DefinitionDocument`](crate::model::DefinitionDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<crate::model::DefinitionLanguage>,
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The language used to define the entity. <code>GRAPHQL</code> is the only valid value.</p>
        pub fn language(mut self, input: crate::model::DefinitionLanguage) -> Self {
            self.language = Some(input);
            self
        }
        /// <p>The language used to define the entity. <code>GRAPHQL</code> is the only valid value.</p>
        pub fn set_language(
            mut self,
            input: std::option::Option<crate::model::DefinitionLanguage>,
        ) -> Self {
            self.language = input;
            self
        }
        /// <p>The GraphQL text that defines the entity.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The GraphQL text that defines the entity.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`DefinitionDocument`](crate::model::DefinitionDocument)
        pub fn build(self) -> crate::model::DefinitionDocument {
            crate::model::DefinitionDocument {
                language: self.language,
                text: self.text,
            }
        }
    }
}
impl DefinitionDocument {
    /// Creates a new builder-style object to manufacture [`DefinitionDocument`](crate::model::DefinitionDocument)
    pub fn builder() -> crate::model::definition_document::Builder {
        crate::model::definition_document::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DefinitionLanguage {
    #[allow(missing_docs)] // documentation missing in model
    Graphql,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DefinitionLanguage {
    fn from(s: &str) -> Self {
        match s {
            "GRAPHQL" => DefinitionLanguage::Graphql,
            other => DefinitionLanguage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DefinitionLanguage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DefinitionLanguage::from(s))
    }
}
impl DefinitionLanguage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DefinitionLanguage::Graphql => "GRAPHQL",
            DefinitionLanguage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GRAPHQL"]
    }
}
impl AsRef<str> for DefinitionLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about a system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemTemplateSummary {
    /// <p>The ID of the system.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the system.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The revision number of the system.</p>
    pub revision_number: std::option::Option<i64>,
    /// <p>The date when the system was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl SystemTemplateSummary {
    /// <p>The ID of the system.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the system.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The revision number of the system.</p>
    pub fn revision_number(&self) -> std::option::Option<i64> {
        self.revision_number
    }
    /// <p>The date when the system was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for SystemTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemTemplateSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("revision_number", &self.revision_number);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`SystemTemplateSummary`](crate::model::SystemTemplateSummary)
pub mod system_template_summary {
    /// A builder for [`SystemTemplateSummary`](crate::model::SystemTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) revision_number: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the system.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the system.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the system.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The revision number of the system.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.revision_number = Some(input);
            self
        }
        /// <p>The revision number of the system.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.revision_number = input;
            self
        }
        /// <p>The date when the system was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the system was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemTemplateSummary`](crate::model::SystemTemplateSummary)
        pub fn build(self) -> crate::model::SystemTemplateSummary {
            crate::model::SystemTemplateSummary {
                id: self.id,
                arn: self.arn,
                revision_number: self.revision_number,
                created_at: self.created_at,
            }
        }
    }
}
impl SystemTemplateSummary {
    /// Creates a new builder-style object to manufacture [`SystemTemplateSummary`](crate::model::SystemTemplateSummary)
    pub fn builder() -> crate::model::system_template_summary::Builder {
        crate::model::system_template_summary::Builder::default()
    }
}

/// <p>An object that contains summary information about a workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowTemplateSummary {
    /// <p>The ID of the workflow.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the workflow.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The revision number of the workflow.</p>
    pub revision_number: std::option::Option<i64>,
    /// <p>The date when the workflow was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl FlowTemplateSummary {
    /// <p>The ID of the workflow.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the workflow.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The revision number of the workflow.</p>
    pub fn revision_number(&self) -> std::option::Option<i64> {
        self.revision_number
    }
    /// <p>The date when the workflow was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for FlowTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowTemplateSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("revision_number", &self.revision_number);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`FlowTemplateSummary`](crate::model::FlowTemplateSummary)
pub mod flow_template_summary {
    /// A builder for [`FlowTemplateSummary`](crate::model::FlowTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) revision_number: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the workflow.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the workflow.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the workflow.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The revision number of the workflow.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.revision_number = Some(input);
            self
        }
        /// <p>The revision number of the workflow.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.revision_number = input;
            self
        }
        /// <p>The date when the workflow was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the workflow was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowTemplateSummary`](crate::model::FlowTemplateSummary)
        pub fn build(self) -> crate::model::FlowTemplateSummary {
            crate::model::FlowTemplateSummary {
                id: self.id,
                arn: self.arn,
                revision_number: self.revision_number,
                created_at: self.created_at,
            }
        }
    }
}
impl FlowTemplateSummary {
    /// Creates a new builder-style object to manufacture [`FlowTemplateSummary`](crate::model::FlowTemplateSummary)
    pub fn builder() -> crate::model::flow_template_summary::Builder {
        crate::model::flow_template_summary::Builder::default()
    }
}

/// <p>An object that contains summary information about a system instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemInstanceSummary {
    /// <p>The ID of the system instance.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the system instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the system instance.</p>
    pub status: std::option::Option<crate::model::SystemInstanceDeploymentStatus>,
    /// <p>The target of the system instance.</p>
    pub target: std::option::Option<crate::model::DeploymentTarget>,
    /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
    pub greengrass_group_name: std::option::Option<std::string::String>,
    /// <p>The date when the system instance was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    ///
    /// The date and time when the system instance was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
    pub greengrass_group_id: std::option::Option<std::string::String>,
    /// <p>The version of the Greengrass group where the system instance is deployed.</p>
    pub greengrass_group_version_id: std::option::Option<std::string::String>,
}
impl SystemInstanceSummary {
    /// <p>The ID of the system instance.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the system instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the system instance.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SystemInstanceDeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>The target of the system instance.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::DeploymentTarget> {
        self.target.as_ref()
    }
    /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
    pub fn greengrass_group_name(&self) -> std::option::Option<&str> {
        self.greengrass_group_name.as_deref()
    }
    /// <p>The date when the system instance was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>
    ///
    /// The date and time when the system instance was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
    pub fn greengrass_group_id(&self) -> std::option::Option<&str> {
        self.greengrass_group_id.as_deref()
    }
    /// <p>The version of the Greengrass group where the system instance is deployed.</p>
    pub fn greengrass_group_version_id(&self) -> std::option::Option<&str> {
        self.greengrass_group_version_id.as_deref()
    }
}
impl std::fmt::Debug for SystemInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemInstanceSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("target", &self.target);
        formatter.field("greengrass_group_name", &self.greengrass_group_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("greengrass_group_id", &self.greengrass_group_id);
        formatter.field(
            "greengrass_group_version_id",
            &self.greengrass_group_version_id,
        );
        formatter.finish()
    }
}
/// See [`SystemInstanceSummary`](crate::model::SystemInstanceSummary)
pub mod system_instance_summary {
    /// A builder for [`SystemInstanceSummary`](crate::model::SystemInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SystemInstanceDeploymentStatus>,
        pub(crate) target: std::option::Option<crate::model::DeploymentTarget>,
        pub(crate) greengrass_group_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) greengrass_group_id: std::option::Option<std::string::String>,
        pub(crate) greengrass_group_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the system instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the system instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the system instance.</p>
        pub fn status(mut self, input: crate::model::SystemInstanceDeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the system instance.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceDeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The target of the system instance.</p>
        pub fn target(mut self, input: crate::model::DeploymentTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>The target of the system instance.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::DeploymentTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
        pub fn greengrass_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_name = Some(input.into());
            self
        }
        /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
        pub fn set_greengrass_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_name = input;
            self
        }
        /// <p>The date when the system instance was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the system instance was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>
        ///
        /// The date and time when the system instance was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>
        ///
        /// The date and time when the system instance was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
        pub fn greengrass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the Greengrass group where the system instance is deployed.</p>
        pub fn set_greengrass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_id = input;
            self
        }
        /// <p>The version of the Greengrass group where the system instance is deployed.</p>
        pub fn greengrass_group_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.greengrass_group_version_id = Some(input.into());
            self
        }
        /// <p>The version of the Greengrass group where the system instance is deployed.</p>
        pub fn set_greengrass_group_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemInstanceSummary`](crate::model::SystemInstanceSummary)
        pub fn build(self) -> crate::model::SystemInstanceSummary {
            crate::model::SystemInstanceSummary {
                id: self.id,
                arn: self.arn,
                status: self.status,
                target: self.target,
                greengrass_group_name: self.greengrass_group_name,
                created_at: self.created_at,
                updated_at: self.updated_at,
                greengrass_group_id: self.greengrass_group_id,
                greengrass_group_version_id: self.greengrass_group_version_id,
            }
        }
    }
}
impl SystemInstanceSummary {
    /// Creates a new builder-style object to manufacture [`SystemInstanceSummary`](crate::model::SystemInstanceSummary)
    pub fn builder() -> crate::model::system_instance_summary::Builder {
        crate::model::system_instance_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentTarget {
    #[allow(missing_docs)] // documentation missing in model
    Cloud,
    #[allow(missing_docs)] // documentation missing in model
    Greengrass,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentTarget {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD" => DeploymentTarget::Cloud,
            "GREENGRASS" => DeploymentTarget::Greengrass,
            other => DeploymentTarget::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentTarget {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentTarget::from(s))
    }
}
impl DeploymentTarget {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentTarget::Cloud => "CLOUD",
            DeploymentTarget::Greengrass => "GREENGRASS",
            DeploymentTarget::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD", "GREENGRASS"]
    }
}
impl AsRef<str> for DeploymentTarget {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SystemInstanceDeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Bootstrap,
    #[allow(missing_docs)] // documentation missing in model
    DeletedInTarget,
    #[allow(missing_docs)] // documentation missing in model
    DeployedInTarget,
    #[allow(missing_docs)] // documentation missing in model
    DeployInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotDeployed,
    #[allow(missing_docs)] // documentation missing in model
    PendingDelete,
    #[allow(missing_docs)] // documentation missing in model
    UndeployInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SystemInstanceDeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "BOOTSTRAP" => SystemInstanceDeploymentStatus::Bootstrap,
            "DELETED_IN_TARGET" => SystemInstanceDeploymentStatus::DeletedInTarget,
            "DEPLOYED_IN_TARGET" => SystemInstanceDeploymentStatus::DeployedInTarget,
            "DEPLOY_IN_PROGRESS" => SystemInstanceDeploymentStatus::DeployInProgress,
            "FAILED" => SystemInstanceDeploymentStatus::Failed,
            "NOT_DEPLOYED" => SystemInstanceDeploymentStatus::NotDeployed,
            "PENDING_DELETE" => SystemInstanceDeploymentStatus::PendingDelete,
            "UNDEPLOY_IN_PROGRESS" => SystemInstanceDeploymentStatus::UndeployInProgress,
            other => SystemInstanceDeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SystemInstanceDeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SystemInstanceDeploymentStatus::from(s))
    }
}
impl SystemInstanceDeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SystemInstanceDeploymentStatus::Bootstrap => "BOOTSTRAP",
            SystemInstanceDeploymentStatus::DeletedInTarget => "DELETED_IN_TARGET",
            SystemInstanceDeploymentStatus::DeployedInTarget => "DEPLOYED_IN_TARGET",
            SystemInstanceDeploymentStatus::DeployInProgress => "DEPLOY_IN_PROGRESS",
            SystemInstanceDeploymentStatus::Failed => "FAILED",
            SystemInstanceDeploymentStatus::NotDeployed => "NOT_DEPLOYED",
            SystemInstanceDeploymentStatus::PendingDelete => "PENDING_DELETE",
            SystemInstanceDeploymentStatus::UndeployInProgress => "UNDEPLOY_IN_PROGRESS",
            SystemInstanceDeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOOTSTRAP",
            "DELETED_IN_TARGET",
            "DEPLOYED_IN_TARGET",
            "DEPLOY_IN_PROGRESS",
            "FAILED",
            "NOT_DEPLOYED",
            "PENDING_DELETE",
            "UNDEPLOY_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for SystemInstanceDeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata assigned to an AWS IoT Things Graph resource consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The required name of the tag. The string value can be from 1 to 128 Unicode characters in length.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional value of the tag. The string value can be from 1 to 256 Unicode characters in length.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An AWS IoT thing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Thing {
    /// <p>The ARN of the thing.</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>The name of the thing.</p>
    pub thing_name: std::option::Option<std::string::String>,
}
impl Thing {
    /// <p>The ARN of the thing.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>The name of the thing.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
}
impl std::fmt::Debug for Thing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Thing");
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}
/// See [`Thing`](crate::model::Thing)
pub mod thing {
    /// A builder for [`Thing`](crate::model::Thing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the thing.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Thing`](crate::model::Thing)
        pub fn build(self) -> crate::model::Thing {
            crate::model::Thing {
                thing_arn: self.thing_arn,
                thing_name: self.thing_name,
            }
        }
    }
}
impl Thing {
    /// Creates a new builder-style object to manufacture [`Thing`](crate::model::Thing)
    pub fn builder() -> crate::model::thing::Builder {
        crate::model::thing::Builder::default()
    }
}

/// <p>An object that filters a system search.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemTemplateFilter {
    /// <p>The name of the system search filter field.</p>
    pub name: std::option::Option<crate::model::SystemTemplateFilterName>,
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SystemTemplateFilter {
    /// <p>The name of the system search filter field.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SystemTemplateFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub fn value(&self) -> std::option::Option<&[std::string::String]> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SystemTemplateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemTemplateFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SystemTemplateFilter`](crate::model::SystemTemplateFilter)
pub mod system_template_filter {
    /// A builder for [`SystemTemplateFilter`](crate::model::SystemTemplateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SystemTemplateFilterName>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the system search filter field.</p>
        pub fn name(mut self, input: crate::model::SystemTemplateFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the system search filter field.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SystemTemplateFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemTemplateFilter`](crate::model::SystemTemplateFilter)
        pub fn build(self) -> crate::model::SystemTemplateFilter {
            crate::model::SystemTemplateFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SystemTemplateFilter {
    /// Creates a new builder-style object to manufacture [`SystemTemplateFilter`](crate::model::SystemTemplateFilter)
    pub fn builder() -> crate::model::system_template_filter::Builder {
        crate::model::system_template_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SystemTemplateFilterName {
    #[allow(missing_docs)] // documentation missing in model
    FlowTemplateId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SystemTemplateFilterName {
    fn from(s: &str) -> Self {
        match s {
            "FLOW_TEMPLATE_ID" => SystemTemplateFilterName::FlowTemplateId,
            other => SystemTemplateFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SystemTemplateFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SystemTemplateFilterName::from(s))
    }
}
impl SystemTemplateFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SystemTemplateFilterName::FlowTemplateId => "FLOW_TEMPLATE_ID",
            SystemTemplateFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FLOW_TEMPLATE_ID"]
    }
}
impl AsRef<str> for SystemTemplateFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that filters a system instance search.
/// Multiple filters function as OR criteria in the search. For example a search that includes a GREENGRASS_GROUP_NAME and a
/// STATUS filter searches for system instances in the specified Greengrass group that have the specified status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemInstanceFilter {
    /// <p>The name of the search filter field.</p>
    pub name: std::option::Option<crate::model::SystemInstanceFilterName>,
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search. </p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SystemInstanceFilter {
    /// <p>The name of the search filter field.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SystemInstanceFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search. </p>
    pub fn value(&self) -> std::option::Option<&[std::string::String]> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SystemInstanceFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemInstanceFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SystemInstanceFilter`](crate::model::SystemInstanceFilter)
pub mod system_instance_filter {
    /// A builder for [`SystemInstanceFilter`](crate::model::SystemInstanceFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SystemInstanceFilterName>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the search filter field.</p>
        pub fn name(mut self, input: crate::model::SystemInstanceFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the search filter field.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search. </p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemInstanceFilter`](crate::model::SystemInstanceFilter)
        pub fn build(self) -> crate::model::SystemInstanceFilter {
            crate::model::SystemInstanceFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SystemInstanceFilter {
    /// Creates a new builder-style object to manufacture [`SystemInstanceFilter`](crate::model::SystemInstanceFilter)
    pub fn builder() -> crate::model::system_instance_filter::Builder {
        crate::model::system_instance_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SystemInstanceFilterName {
    #[allow(missing_docs)] // documentation missing in model
    GreengrassGroupName,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    SystemTemplateId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SystemInstanceFilterName {
    fn from(s: &str) -> Self {
        match s {
            "GREENGRASS_GROUP_NAME" => SystemInstanceFilterName::GreengrassGroupName,
            "STATUS" => SystemInstanceFilterName::Status,
            "SYSTEM_TEMPLATE_ID" => SystemInstanceFilterName::SystemTemplateId,
            other => SystemInstanceFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SystemInstanceFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SystemInstanceFilterName::from(s))
    }
}
impl SystemInstanceFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SystemInstanceFilterName::GreengrassGroupName => "GREENGRASS_GROUP_NAME",
            SystemInstanceFilterName::Status => "STATUS",
            SystemInstanceFilterName::SystemTemplateId => "SYSTEM_TEMPLATE_ID",
            SystemInstanceFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GREENGRASS_GROUP_NAME", "STATUS", "SYSTEM_TEMPLATE_ID"]
    }
}
impl AsRef<str> for SystemInstanceFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that filters a workflow search.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowTemplateFilter {
    /// <p>The name of the search filter field.</p>
    pub name: std::option::Option<crate::model::FlowTemplateFilterName>,
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FlowTemplateFilter {
    /// <p>The name of the search filter field.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FlowTemplateFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub fn value(&self) -> std::option::Option<&[std::string::String]> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for FlowTemplateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowTemplateFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`FlowTemplateFilter`](crate::model::FlowTemplateFilter)
pub mod flow_template_filter {
    /// A builder for [`FlowTemplateFilter`](crate::model::FlowTemplateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FlowTemplateFilterName>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the search filter field.</p>
        pub fn name(mut self, input: crate::model::FlowTemplateFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the search filter field.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::FlowTemplateFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowTemplateFilter`](crate::model::FlowTemplateFilter)
        pub fn build(self) -> crate::model::FlowTemplateFilter {
            crate::model::FlowTemplateFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl FlowTemplateFilter {
    /// Creates a new builder-style object to manufacture [`FlowTemplateFilter`](crate::model::FlowTemplateFilter)
    pub fn builder() -> crate::model::flow_template_filter::Builder {
        crate::model::flow_template_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlowTemplateFilterName {
    #[allow(missing_docs)] // documentation missing in model
    DeviceModelId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlowTemplateFilterName {
    fn from(s: &str) -> Self {
        match s {
            "DEVICE_MODEL_ID" => FlowTemplateFilterName::DeviceModelId,
            other => FlowTemplateFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlowTemplateFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlowTemplateFilterName::from(s))
    }
}
impl FlowTemplateFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlowTemplateFilterName::DeviceModelId => "DEVICE_MODEL_ID",
            FlowTemplateFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEVICE_MODEL_ID"]
    }
}
impl AsRef<str> for FlowTemplateFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains summary information about a flow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowExecutionSummary {
    /// <p>The ID of the flow execution.</p>
    pub flow_execution_id: std::option::Option<std::string::String>,
    /// <p>The current status of the flow execution.</p>
    pub status: std::option::Option<crate::model::FlowExecutionStatus>,
    /// <p>The ID of the system instance that contains the flow.</p>
    pub system_instance_id: std::option::Option<std::string::String>,
    /// <p>The ID of the flow.</p>
    pub flow_template_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the flow execution summary was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the flow execution summary was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl FlowExecutionSummary {
    /// <p>The ID of the flow execution.</p>
    pub fn flow_execution_id(&self) -> std::option::Option<&str> {
        self.flow_execution_id.as_deref()
    }
    /// <p>The current status of the flow execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FlowExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The ID of the system instance that contains the flow.</p>
    pub fn system_instance_id(&self) -> std::option::Option<&str> {
        self.system_instance_id.as_deref()
    }
    /// <p>The ID of the flow.</p>
    pub fn flow_template_id(&self) -> std::option::Option<&str> {
        self.flow_template_id.as_deref()
    }
    /// <p>The date and time when the flow execution summary was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The date and time when the flow execution summary was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for FlowExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowExecutionSummary");
        formatter.field("flow_execution_id", &self.flow_execution_id);
        formatter.field("status", &self.status);
        formatter.field("system_instance_id", &self.system_instance_id);
        formatter.field("flow_template_id", &self.flow_template_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`FlowExecutionSummary`](crate::model::FlowExecutionSummary)
pub mod flow_execution_summary {
    /// A builder for [`FlowExecutionSummary`](crate::model::FlowExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FlowExecutionStatus>,
        pub(crate) system_instance_id: std::option::Option<std::string::String>,
        pub(crate) flow_template_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_execution_id = input;
            self
        }
        /// <p>The current status of the flow execution.</p>
        pub fn status(mut self, input: crate::model::FlowExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the flow execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FlowExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn system_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.system_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn set_system_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.system_instance_id = input;
            self
        }
        /// <p>The ID of the flow.</p>
        pub fn flow_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the flow.</p>
        pub fn set_flow_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_template_id = input;
            self
        }
        /// <p>The date and time when the flow execution summary was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the flow execution summary was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time when the flow execution summary was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time when the flow execution summary was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowExecutionSummary`](crate::model::FlowExecutionSummary)
        pub fn build(self) -> crate::model::FlowExecutionSummary {
            crate::model::FlowExecutionSummary {
                flow_execution_id: self.flow_execution_id,
                status: self.status,
                system_instance_id: self.system_instance_id,
                flow_template_id: self.flow_template_id,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl FlowExecutionSummary {
    /// Creates a new builder-style object to manufacture [`FlowExecutionSummary`](crate::model::FlowExecutionSummary)
    pub fn builder() -> crate::model::flow_execution_summary::Builder {
        crate::model::flow_execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlowExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlowExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => FlowExecutionStatus::Aborted,
            "FAILED" => FlowExecutionStatus::Failed,
            "RUNNING" => FlowExecutionStatus::Running,
            "SUCCEEDED" => FlowExecutionStatus::Succeeded,
            other => FlowExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlowExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlowExecutionStatus::from(s))
    }
}
impl FlowExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlowExecutionStatus::Aborted => "ABORTED",
            FlowExecutionStatus::Failed => "FAILED",
            FlowExecutionStatus::Running => "RUNNING",
            FlowExecutionStatus::Succeeded => "SUCCEEDED",
            FlowExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORTED", "FAILED", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for FlowExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the properties of an entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityDescription {
    /// <p>The entity ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The entity ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The entity type.</p>
    pub r#type: std::option::Option<crate::model::EntityType>,
    /// <p>The time at which the entity was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The definition document of the entity.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
}
impl EntityDescription {
    /// <p>The entity ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The entity ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The entity type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EntityType> {
        self.r#type.as_ref()
    }
    /// <p>The time at which the entity was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The definition document of the entity.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::DefinitionDocument> {
        self.definition.as_ref()
    }
}
impl std::fmt::Debug for EntityDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityDescription");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_at", &self.created_at);
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}
/// See [`EntityDescription`](crate::model::EntityDescription)
pub mod entity_description {
    /// A builder for [`EntityDescription`](crate::model::EntityDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::EntityType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
    }
    impl Builder {
        /// <p>The entity ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The entity ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The entity ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The entity ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The entity type.</p>
        pub fn r#type(mut self, input: crate::model::EntityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The entity type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::EntityType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time at which the entity was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the entity was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The definition document of the entity.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The definition document of the entity.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityDescription`](crate::model::EntityDescription)
        pub fn build(self) -> crate::model::EntityDescription {
            crate::model::EntityDescription {
                id: self.id,
                arn: self.arn,
                r#type: self.r#type,
                created_at: self.created_at,
                definition: self.definition,
            }
        }
    }
}
impl EntityDescription {
    /// Creates a new builder-style object to manufacture [`EntityDescription`](crate::model::EntityDescription)
    pub fn builder() -> crate::model::entity_description::Builder {
        crate::model::entity_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityType {
    #[allow(missing_docs)] // documentation missing in model
    Action,
    #[allow(missing_docs)] // documentation missing in model
    Capability,
    #[allow(missing_docs)] // documentation missing in model
    Device,
    #[allow(missing_docs)] // documentation missing in model
    DeviceModel,
    #[allow(missing_docs)] // documentation missing in model
    Enum,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Mapping,
    #[allow(missing_docs)] // documentation missing in model
    Property,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    #[allow(missing_docs)] // documentation missing in model
    State,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityType {
    fn from(s: &str) -> Self {
        match s {
            "ACTION" => EntityType::Action,
            "CAPABILITY" => EntityType::Capability,
            "DEVICE" => EntityType::Device,
            "DEVICE_MODEL" => EntityType::DeviceModel,
            "ENUM" => EntityType::Enum,
            "EVENT" => EntityType::Event,
            "MAPPING" => EntityType::Mapping,
            "PROPERTY" => EntityType::Property,
            "SERVICE" => EntityType::Service,
            "STATE" => EntityType::State,
            other => EntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityType::from(s))
    }
}
impl EntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityType::Action => "ACTION",
            EntityType::Capability => "CAPABILITY",
            EntityType::Device => "DEVICE",
            EntityType::DeviceModel => "DEVICE_MODEL",
            EntityType::Enum => "ENUM",
            EntityType::Event => "EVENT",
            EntityType::Mapping => "MAPPING",
            EntityType::Property => "PROPERTY",
            EntityType::Service => "SERVICE",
            EntityType::State => "STATE",
            EntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTION",
            "CAPABILITY",
            "DEVICE",
            "DEVICE_MODEL",
            "ENUM",
            "EVENT",
            "MAPPING",
            "PROPERTY",
            "SERVICE",
            "STATE",
        ]
    }
}
impl AsRef<str> for EntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that filters an entity search. Multiple filters function as OR criteria in the search. For example a search that includes
/// a <code>NAMESPACE</code> and a <code>REFERENCED_ENTITY_ID</code> filter searches for entities in the specified namespace that use the entity specified by
/// the value of <code>REFERENCED_ENTITY_ID</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityFilter {
    /// <p>The name of the entity search filter field. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
    /// you can filter on the ID of a property that is used in a state.</p>
    pub name: std::option::Option<crate::model::EntityFilterName>,
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EntityFilter {
    /// <p>The name of the entity search filter field. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
    /// you can filter on the ID of a property that is used in a state.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::EntityFilterName> {
        self.name.as_ref()
    }
    /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
    pub fn value(&self) -> std::option::Option<&[std::string::String]> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for EntityFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`EntityFilter`](crate::model::EntityFilter)
pub mod entity_filter {
    /// A builder for [`EntityFilter`](crate::model::EntityFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::EntityFilterName>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the entity search filter field. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
        /// you can filter on the ID of a property that is used in a state.</p>
        pub fn name(mut self, input: crate::model::EntityFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the entity search filter field. <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
        /// you can filter on the ID of a property that is used in a state.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::EntityFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>An array of string values for the search filter field. Multiple values function as AND criteria in the search.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityFilter`](crate::model::EntityFilter)
        pub fn build(self) -> crate::model::EntityFilter {
            crate::model::EntityFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl EntityFilter {
    /// Creates a new builder-style object to manufacture [`EntityFilter`](crate::model::EntityFilter)
    pub fn builder() -> crate::model::entity_filter::Builder {
        crate::model::entity_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Namespace,
    #[allow(missing_docs)] // documentation missing in model
    ReferencedEntityId,
    #[allow(missing_docs)] // documentation missing in model
    SemanticTypePath,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityFilterName {
    fn from(s: &str) -> Self {
        match s {
            "NAME" => EntityFilterName::Name,
            "NAMESPACE" => EntityFilterName::Namespace,
            "REFERENCED_ENTITY_ID" => EntityFilterName::ReferencedEntityId,
            "SEMANTIC_TYPE_PATH" => EntityFilterName::SemanticTypePath,
            other => EntityFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityFilterName::from(s))
    }
}
impl EntityFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityFilterName::Name => "NAME",
            EntityFilterName::Namespace => "NAMESPACE",
            EntityFilterName::ReferencedEntityId => "REFERENCED_ENTITY_ID",
            EntityFilterName::SemanticTypePath => "SEMANTIC_TYPE_PATH",
            EntityFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NAME",
            "NAMESPACE",
            "REFERENCED_ENTITY_ID",
            "SEMANTIC_TYPE_PATH",
        ]
    }
}
impl AsRef<str> for EntityFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about a flow event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowExecutionMessage {
    /// <p>The unique identifier of the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The type of flow event .</p>
    pub event_type: std::option::Option<crate::model::FlowExecutionEventType>,
    /// <p>The date and time when the message was last updated.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A string containing information about the flow event.</p>
    pub payload: std::option::Option<std::string::String>,
}
impl FlowExecutionMessage {
    /// <p>The unique identifier of the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The type of flow event .</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::FlowExecutionEventType> {
        self.event_type.as_ref()
    }
    /// <p>The date and time when the message was last updated.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>A string containing information about the flow event.</p>
    pub fn payload(&self) -> std::option::Option<&str> {
        self.payload.as_deref()
    }
}
impl std::fmt::Debug for FlowExecutionMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowExecutionMessage");
        formatter.field("message_id", &self.message_id);
        formatter.field("event_type", &self.event_type);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`FlowExecutionMessage`](crate::model::FlowExecutionMessage)
pub mod flow_execution_message {
    /// A builder for [`FlowExecutionMessage`](crate::model::FlowExecutionMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<crate::model::FlowExecutionEventType>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) payload: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The type of flow event .</p>
        pub fn event_type(mut self, input: crate::model::FlowExecutionEventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The type of flow event .</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::FlowExecutionEventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>The date and time when the message was last updated.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The date and time when the message was last updated.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>A string containing information about the flow event.</p>
        pub fn payload(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload = Some(input.into());
            self
        }
        /// <p>A string containing information about the flow event.</p>
        pub fn set_payload(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowExecutionMessage`](crate::model::FlowExecutionMessage)
        pub fn build(self) -> crate::model::FlowExecutionMessage {
            crate::model::FlowExecutionMessage {
                message_id: self.message_id,
                event_type: self.event_type,
                timestamp: self.timestamp,
                payload: self.payload,
            }
        }
    }
}
impl FlowExecutionMessage {
    /// Creates a new builder-style object to manufacture [`FlowExecutionMessage`](crate::model::FlowExecutionMessage)
    pub fn builder() -> crate::model::flow_execution_message::Builder {
        crate::model::flow_execution_message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FlowExecutionEventType {
    #[allow(missing_docs)] // documentation missing in model
    AcknowledgeTaskMessage,
    #[allow(missing_docs)] // documentation missing in model
    ActivityFailed,
    #[allow(missing_docs)] // documentation missing in model
    ActivityScheduled,
    #[allow(missing_docs)] // documentation missing in model
    ActivityStarted,
    #[allow(missing_docs)] // documentation missing in model
    ActivitySucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionAborted,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionStarted,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ScheduleNextReadyStepsTask,
    #[allow(missing_docs)] // documentation missing in model
    StartFlowExecutionTask,
    #[allow(missing_docs)] // documentation missing in model
    StepFailed,
    #[allow(missing_docs)] // documentation missing in model
    StepStarted,
    #[allow(missing_docs)] // documentation missing in model
    StepSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ThingActionTask,
    #[allow(missing_docs)] // documentation missing in model
    ThingActionTaskFailed,
    #[allow(missing_docs)] // documentation missing in model
    ThingActionTaskSucceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FlowExecutionEventType {
    fn from(s: &str) -> Self {
        match s {
            "ACKNOWLEDGE_TASK_MESSAGE" => FlowExecutionEventType::AcknowledgeTaskMessage,
            "ACTIVITY_FAILED" => FlowExecutionEventType::ActivityFailed,
            "ACTIVITY_SCHEDULED" => FlowExecutionEventType::ActivityScheduled,
            "ACTIVITY_STARTED" => FlowExecutionEventType::ActivityStarted,
            "ACTIVITY_SUCCEEDED" => FlowExecutionEventType::ActivitySucceeded,
            "EXECUTION_ABORTED" => FlowExecutionEventType::ExecutionAborted,
            "EXECUTION_FAILED" => FlowExecutionEventType::ExecutionFailed,
            "EXECUTION_STARTED" => FlowExecutionEventType::ExecutionStarted,
            "EXECUTION_SUCCEEDED" => FlowExecutionEventType::ExecutionSucceeded,
            "SCHEDULE_NEXT_READY_STEPS_TASK" => FlowExecutionEventType::ScheduleNextReadyStepsTask,
            "START_FLOW_EXECUTION_TASK" => FlowExecutionEventType::StartFlowExecutionTask,
            "STEP_FAILED" => FlowExecutionEventType::StepFailed,
            "STEP_STARTED" => FlowExecutionEventType::StepStarted,
            "STEP_SUCCEEDED" => FlowExecutionEventType::StepSucceeded,
            "THING_ACTION_TASK" => FlowExecutionEventType::ThingActionTask,
            "THING_ACTION_TASK_FAILED" => FlowExecutionEventType::ThingActionTaskFailed,
            "THING_ACTION_TASK_SUCCEEDED" => FlowExecutionEventType::ThingActionTaskSucceeded,
            other => FlowExecutionEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FlowExecutionEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FlowExecutionEventType::from(s))
    }
}
impl FlowExecutionEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FlowExecutionEventType::AcknowledgeTaskMessage => "ACKNOWLEDGE_TASK_MESSAGE",
            FlowExecutionEventType::ActivityFailed => "ACTIVITY_FAILED",
            FlowExecutionEventType::ActivityScheduled => "ACTIVITY_SCHEDULED",
            FlowExecutionEventType::ActivityStarted => "ACTIVITY_STARTED",
            FlowExecutionEventType::ActivitySucceeded => "ACTIVITY_SUCCEEDED",
            FlowExecutionEventType::ExecutionAborted => "EXECUTION_ABORTED",
            FlowExecutionEventType::ExecutionFailed => "EXECUTION_FAILED",
            FlowExecutionEventType::ExecutionStarted => "EXECUTION_STARTED",
            FlowExecutionEventType::ExecutionSucceeded => "EXECUTION_SUCCEEDED",
            FlowExecutionEventType::ScheduleNextReadyStepsTask => "SCHEDULE_NEXT_READY_STEPS_TASK",
            FlowExecutionEventType::StartFlowExecutionTask => "START_FLOW_EXECUTION_TASK",
            FlowExecutionEventType::StepFailed => "STEP_FAILED",
            FlowExecutionEventType::StepStarted => "STEP_STARTED",
            FlowExecutionEventType::StepSucceeded => "STEP_SUCCEEDED",
            FlowExecutionEventType::ThingActionTask => "THING_ACTION_TASK",
            FlowExecutionEventType::ThingActionTaskFailed => "THING_ACTION_TASK_FAILED",
            FlowExecutionEventType::ThingActionTaskSucceeded => "THING_ACTION_TASK_SUCCEEDED",
            FlowExecutionEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACKNOWLEDGE_TASK_MESSAGE",
            "ACTIVITY_FAILED",
            "ACTIVITY_SCHEDULED",
            "ACTIVITY_STARTED",
            "ACTIVITY_SUCCEEDED",
            "EXECUTION_ABORTED",
            "EXECUTION_FAILED",
            "EXECUTION_STARTED",
            "EXECUTION_SUCCEEDED",
            "SCHEDULE_NEXT_READY_STEPS_TASK",
            "START_FLOW_EXECUTION_TASK",
            "STEP_FAILED",
            "STEP_STARTED",
            "STEP_SUCCEEDED",
            "THING_ACTION_TASK",
            "THING_ACTION_TASK_FAILED",
            "THING_ACTION_TASK_SUCCEEDED",
        ]
    }
}
impl AsRef<str> for FlowExecutionEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UploadStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UploadStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => UploadStatus::Failed,
            "IN_PROGRESS" => UploadStatus::InProgress,
            "SUCCEEDED" => UploadStatus::Succeeded,
            other => UploadStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UploadStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UploadStatus::from(s))
    }
}
impl UploadStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UploadStatus::Failed => "FAILED",
            UploadStatus::InProgress => "IN_PROGRESS",
            UploadStatus::Succeeded => "SUCCEEDED",
            UploadStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for UploadStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains a system's definition document and summary information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemTemplateDescription {
    /// <p>An object that contains summary information about a system.</p>
    pub summary: std::option::Option<crate::model::SystemTemplateSummary>,
    /// <p>The definition document of a system.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The namespace version against which the system was validated. Use this value in your system instance.</p>
    pub validated_namespace_version: std::option::Option<i64>,
}
impl SystemTemplateDescription {
    /// <p>An object that contains summary information about a system.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemTemplateSummary> {
        self.summary.as_ref()
    }
    /// <p>The definition document of a system.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::DefinitionDocument> {
        self.definition.as_ref()
    }
    /// <p>The namespace version against which the system was validated. Use this value in your system instance.</p>
    pub fn validated_namespace_version(&self) -> std::option::Option<i64> {
        self.validated_namespace_version
    }
}
impl std::fmt::Debug for SystemTemplateDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemTemplateDescription");
        formatter.field("summary", &self.summary);
        formatter.field("definition", &self.definition);
        formatter.field(
            "validated_namespace_version",
            &self.validated_namespace_version,
        );
        formatter.finish()
    }
}
/// See [`SystemTemplateDescription`](crate::model::SystemTemplateDescription)
pub mod system_template_description {
    /// A builder for [`SystemTemplateDescription`](crate::model::SystemTemplateDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemTemplateSummary>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) validated_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>An object that contains summary information about a system.</p>
        pub fn summary(mut self, input: crate::model::SystemTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object that contains summary information about a system.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// <p>The definition document of a system.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The definition document of a system.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The namespace version against which the system was validated. Use this value in your system instance.</p>
        pub fn validated_namespace_version(mut self, input: i64) -> Self {
            self.validated_namespace_version = Some(input);
            self
        }
        /// <p>The namespace version against which the system was validated. Use this value in your system instance.</p>
        pub fn set_validated_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.validated_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemTemplateDescription`](crate::model::SystemTemplateDescription)
        pub fn build(self) -> crate::model::SystemTemplateDescription {
            crate::model::SystemTemplateDescription {
                summary: self.summary,
                definition: self.definition,
                validated_namespace_version: self.validated_namespace_version,
            }
        }
    }
}
impl SystemTemplateDescription {
    /// Creates a new builder-style object to manufacture [`SystemTemplateDescription`](crate::model::SystemTemplateDescription)
    pub fn builder() -> crate::model::system_template_description::Builder {
        crate::model::system_template_description::Builder::default()
    }
}

/// <p>An object that contains a system instance definition and summary information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemInstanceDescription {
    /// <p>An object that contains summary information about a system instance.</p>
    pub summary: std::option::Option<crate::model::SystemInstanceSummary>,
    /// <p>A document that defines an entity. </p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The Amazon Simple Storage Service bucket where information about a system instance is stored.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
    pub metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
    /// <p>The version of the user's namespace against which the system instance was validated.</p>
    pub validated_namespace_version: std::option::Option<i64>,
    /// <p>A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.</p>
    pub validated_dependency_revisions:
        std::option::Option<std::vec::Vec<crate::model::DependencyRevision>>,
    /// <p>The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a
    /// cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other
    /// AWS services that the flow uses.</p>
    pub flow_actions_role_arn: std::option::Option<std::string::String>,
}
impl SystemInstanceDescription {
    /// <p>An object that contains summary information about a system instance.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SystemInstanceSummary> {
        self.summary.as_ref()
    }
    /// <p>A document that defines an entity. </p>
    pub fn definition(&self) -> std::option::Option<&crate::model::DefinitionDocument> {
        self.definition.as_ref()
    }
    /// <p>The Amazon Simple Storage Service bucket where information about a system instance is stored.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
    pub fn metrics_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MetricsConfiguration> {
        self.metrics_configuration.as_ref()
    }
    /// <p>The version of the user's namespace against which the system instance was validated.</p>
    pub fn validated_namespace_version(&self) -> std::option::Option<i64> {
        self.validated_namespace_version
    }
    /// <p>A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.</p>
    pub fn validated_dependency_revisions(
        &self,
    ) -> std::option::Option<&[crate::model::DependencyRevision]> {
        self.validated_dependency_revisions.as_deref()
    }
    /// <p>The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a
    /// cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other
    /// AWS services that the flow uses.</p>
    pub fn flow_actions_role_arn(&self) -> std::option::Option<&str> {
        self.flow_actions_role_arn.as_deref()
    }
}
impl std::fmt::Debug for SystemInstanceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemInstanceDescription");
        formatter.field("summary", &self.summary);
        formatter.field("definition", &self.definition);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("metrics_configuration", &self.metrics_configuration);
        formatter.field(
            "validated_namespace_version",
            &self.validated_namespace_version,
        );
        formatter.field(
            "validated_dependency_revisions",
            &self.validated_dependency_revisions,
        );
        formatter.field("flow_actions_role_arn", &self.flow_actions_role_arn);
        formatter.finish()
    }
}
/// See [`SystemInstanceDescription`](crate::model::SystemInstanceDescription)
pub mod system_instance_description {
    /// A builder for [`SystemInstanceDescription`](crate::model::SystemInstanceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SystemInstanceSummary>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
        pub(crate) validated_namespace_version: std::option::Option<i64>,
        pub(crate) validated_dependency_revisions:
            std::option::Option<std::vec::Vec<crate::model::DependencyRevision>>,
        pub(crate) flow_actions_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An object that contains summary information about a system instance.</p>
        pub fn summary(mut self, input: crate::model::SystemInstanceSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object that contains summary information about a system instance.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SystemInstanceSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The Amazon Simple Storage Service bucket where information about a system instance is stored.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service bucket where information about a system instance is stored.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.metrics_configuration = Some(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.metrics_configuration = input;
            self
        }
        /// <p>The version of the user's namespace against which the system instance was validated.</p>
        pub fn validated_namespace_version(mut self, input: i64) -> Self {
            self.validated_namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace against which the system instance was validated.</p>
        pub fn set_validated_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.validated_namespace_version = input;
            self
        }
        /// Appends an item to `validated_dependency_revisions`.
        ///
        /// To override the contents of this collection use [`set_validated_dependency_revisions`](Self::set_validated_dependency_revisions).
        ///
        /// <p>A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.</p>
        pub fn validated_dependency_revisions(
            mut self,
            input: impl Into<crate::model::DependencyRevision>,
        ) -> Self {
            let mut v = self.validated_dependency_revisions.unwrap_or_default();
            v.push(input.into());
            self.validated_dependency_revisions = Some(v);
            self
        }
        /// <p>A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.</p>
        pub fn set_validated_dependency_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DependencyRevision>>,
        ) -> Self {
            self.validated_dependency_revisions = input;
            self
        }
        /// <p>The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a
        /// cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other
        /// AWS services that the flow uses.</p>
        pub fn flow_actions_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_actions_role_arn = Some(input.into());
            self
        }
        /// <p>The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a
        /// cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other
        /// AWS services that the flow uses.</p>
        pub fn set_flow_actions_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_actions_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemInstanceDescription`](crate::model::SystemInstanceDescription)
        pub fn build(self) -> crate::model::SystemInstanceDescription {
            crate::model::SystemInstanceDescription {
                summary: self.summary,
                definition: self.definition,
                s3_bucket_name: self.s3_bucket_name,
                metrics_configuration: self.metrics_configuration,
                validated_namespace_version: self.validated_namespace_version,
                validated_dependency_revisions: self.validated_dependency_revisions,
                flow_actions_role_arn: self.flow_actions_role_arn,
            }
        }
    }
}
impl SystemInstanceDescription {
    /// Creates a new builder-style object to manufacture [`SystemInstanceDescription`](crate::model::SystemInstanceDescription)
    pub fn builder() -> crate::model::system_instance_description::Builder {
        crate::model::system_instance_description::Builder::default()
    }
}

/// <p>An object that contains the ID and revision number of a workflow or system that is part of a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyRevision {
    /// <p>The ID of the workflow or system.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The revision number of the workflow or system.</p>
    pub revision_number: std::option::Option<i64>,
}
impl DependencyRevision {
    /// <p>The ID of the workflow or system.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The revision number of the workflow or system.</p>
    pub fn revision_number(&self) -> std::option::Option<i64> {
        self.revision_number
    }
}
impl std::fmt::Debug for DependencyRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyRevision");
        formatter.field("id", &self.id);
        formatter.field("revision_number", &self.revision_number);
        formatter.finish()
    }
}
/// See [`DependencyRevision`](crate::model::DependencyRevision)
pub mod dependency_revision {
    /// A builder for [`DependencyRevision`](crate::model::DependencyRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) revision_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the workflow or system.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow or system.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The revision number of the workflow or system.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.revision_number = Some(input);
            self
        }
        /// <p>The revision number of the workflow or system.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.revision_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyRevision`](crate::model::DependencyRevision)
        pub fn build(self) -> crate::model::DependencyRevision {
            crate::model::DependencyRevision {
                id: self.id,
                revision_number: self.revision_number,
            }
        }
    }
}
impl DependencyRevision {
    /// Creates a new builder-style object to manufacture [`DependencyRevision`](crate::model::DependencyRevision)
    pub fn builder() -> crate::model::dependency_revision::Builder {
        crate::model::dependency_revision::Builder::default()
    }
}

/// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricsConfiguration {
    /// <p>A Boolean that specifies whether cloud metrics are collected.</p>
    pub cloud_metric_enabled: bool,
    /// <p>The ARN of the role that is used to collect cloud metrics.</p>
    pub metric_rule_role_arn: std::option::Option<std::string::String>,
}
impl MetricsConfiguration {
    /// <p>A Boolean that specifies whether cloud metrics are collected.</p>
    pub fn cloud_metric_enabled(&self) -> bool {
        self.cloud_metric_enabled
    }
    /// <p>The ARN of the role that is used to collect cloud metrics.</p>
    pub fn metric_rule_role_arn(&self) -> std::option::Option<&str> {
        self.metric_rule_role_arn.as_deref()
    }
}
impl std::fmt::Debug for MetricsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricsConfiguration");
        formatter.field("cloud_metric_enabled", &self.cloud_metric_enabled);
        formatter.field("metric_rule_role_arn", &self.metric_rule_role_arn);
        formatter.finish()
    }
}
/// See [`MetricsConfiguration`](crate::model::MetricsConfiguration)
pub mod metrics_configuration {
    /// A builder for [`MetricsConfiguration`](crate::model::MetricsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_metric_enabled: std::option::Option<bool>,
        pub(crate) metric_rule_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean that specifies whether cloud metrics are collected.</p>
        pub fn cloud_metric_enabled(mut self, input: bool) -> Self {
            self.cloud_metric_enabled = Some(input);
            self
        }
        /// <p>A Boolean that specifies whether cloud metrics are collected.</p>
        pub fn set_cloud_metric_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cloud_metric_enabled = input;
            self
        }
        /// <p>The ARN of the role that is used to collect cloud metrics.</p>
        pub fn metric_rule_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_rule_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that is used to collect cloud metrics.</p>
        pub fn set_metric_rule_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_rule_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricsConfiguration`](crate::model::MetricsConfiguration)
        pub fn build(self) -> crate::model::MetricsConfiguration {
            crate::model::MetricsConfiguration {
                cloud_metric_enabled: self.cloud_metric_enabled.unwrap_or_default(),
                metric_rule_role_arn: self.metric_rule_role_arn,
            }
        }
    }
}
impl MetricsConfiguration {
    /// Creates a new builder-style object to manufacture [`MetricsConfiguration`](crate::model::MetricsConfiguration)
    pub fn builder() -> crate::model::metrics_configuration::Builder {
        crate::model::metrics_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceDeletionStatusErrorCodes {
    #[allow(missing_docs)] // documentation missing in model
    ValidationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceDeletionStatusErrorCodes {
    fn from(s: &str) -> Self {
        match s {
            "VALIDATION_FAILED" => NamespaceDeletionStatusErrorCodes::ValidationFailed,
            other => NamespaceDeletionStatusErrorCodes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceDeletionStatusErrorCodes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceDeletionStatusErrorCodes::from(s))
    }
}
impl NamespaceDeletionStatusErrorCodes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceDeletionStatusErrorCodes::ValidationFailed => "VALIDATION_FAILED",
            NamespaceDeletionStatusErrorCodes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VALIDATION_FAILED"]
    }
}
impl AsRef<str> for NamespaceDeletionStatusErrorCodes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceDeletionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceDeletionStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => NamespaceDeletionStatus::Failed,
            "IN_PROGRESS" => NamespaceDeletionStatus::InProgress,
            "SUCCEEDED" => NamespaceDeletionStatus::Succeeded,
            other => NamespaceDeletionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceDeletionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceDeletionStatus::from(s))
    }
}
impl NamespaceDeletionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceDeletionStatus::Failed => "FAILED",
            NamespaceDeletionStatus::InProgress => "IN_PROGRESS",
            NamespaceDeletionStatus::Succeeded => "SUCCEEDED",
            NamespaceDeletionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for NamespaceDeletionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains a workflow's definition and summary information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowTemplateDescription {
    /// <p>An object that contains summary information about a workflow.</p>
    pub summary: std::option::Option<crate::model::FlowTemplateSummary>,
    /// <p>A workflow's definition document.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The version of the user's namespace against which the workflow was validated. Use this value in your system instance.</p>
    pub validated_namespace_version: std::option::Option<i64>,
}
impl FlowTemplateDescription {
    /// <p>An object that contains summary information about a workflow.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::FlowTemplateSummary> {
        self.summary.as_ref()
    }
    /// <p>A workflow's definition document.</p>
    pub fn definition(&self) -> std::option::Option<&crate::model::DefinitionDocument> {
        self.definition.as_ref()
    }
    /// <p>The version of the user's namespace against which the workflow was validated. Use this value in your system instance.</p>
    pub fn validated_namespace_version(&self) -> std::option::Option<i64> {
        self.validated_namespace_version
    }
}
impl std::fmt::Debug for FlowTemplateDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowTemplateDescription");
        formatter.field("summary", &self.summary);
        formatter.field("definition", &self.definition);
        formatter.field(
            "validated_namespace_version",
            &self.validated_namespace_version,
        );
        formatter.finish()
    }
}
/// See [`FlowTemplateDescription`](crate::model::FlowTemplateDescription)
pub mod flow_template_description {
    /// A builder for [`FlowTemplateDescription`](crate::model::FlowTemplateDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::FlowTemplateSummary>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) validated_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>An object that contains summary information about a workflow.</p>
        pub fn summary(mut self, input: crate::model::FlowTemplateSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>An object that contains summary information about a workflow.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::FlowTemplateSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// <p>A workflow's definition document.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>A workflow's definition document.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The version of the user's namespace against which the workflow was validated. Use this value in your system instance.</p>
        pub fn validated_namespace_version(mut self, input: i64) -> Self {
            self.validated_namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace against which the workflow was validated. Use this value in your system instance.</p>
        pub fn set_validated_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.validated_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowTemplateDescription`](crate::model::FlowTemplateDescription)
        pub fn build(self) -> crate::model::FlowTemplateDescription {
            crate::model::FlowTemplateDescription {
                summary: self.summary,
                definition: self.definition,
                validated_namespace_version: self.validated_namespace_version,
            }
        }
    }
}
impl FlowTemplateDescription {
    /// Creates a new builder-style object to manufacture [`FlowTemplateDescription`](crate::model::FlowTemplateDescription)
    pub fn builder() -> crate::model::flow_template_description::Builder {
        crate::model::flow_template_description::Builder::default()
    }
}
