// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateEntityToThingInput`](crate::input::AssociateEntityToThingInput)
pub mod associate_entity_to_thing_input {
    /// A builder for [`AssociateEntityToThingInput`](crate::input::AssociateEntityToThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to which the entity is to be associated.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the device to be associated with the thing.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateEntityToThingInput`](crate::input::AssociateEntityToThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateEntityToThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateEntityToThingInput {
                thing_name: self.thing_name,
                entity_id: self.entity_id,
                namespace_version: self.namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateEntityToThingInputOperationOutputAlias = crate::operation::AssociateEntityToThing;
#[doc(hidden)]
pub type AssociateEntityToThingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateEntityToThingInput {
    /// Consumes the builder and constructs an Operation<[`AssociateEntityToThing`](crate::operation::AssociateEntityToThing)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateEntityToThing,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateEntityToThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateEntityToThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateEntityToThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.AssociateEntityToThing",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_entity_to_thing(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateEntityToThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateEntityToThing",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateEntityToThingInput`](crate::input::AssociateEntityToThingInput)
    pub fn builder() -> crate::input::associate_entity_to_thing_input::Builder {
        crate::input::associate_entity_to_thing_input::Builder::default()
    }
}

/// See [`CreateFlowTemplateInput`](crate::input::CreateFlowTemplateInput)
pub mod create_flow_template_input {
    /// A builder for [`CreateFlowTemplateInput`](crate::input::CreateFlowTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) compatible_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The workflow <code>DefinitionDocument</code>.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.compatible_namespace_version = Some(input);
            self
        }
        /// <p>The namespace version in which the workflow is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.compatible_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowTemplateInput`](crate::input::CreateFlowTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFlowTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFlowTemplateInput {
                definition: self.definition,
                compatible_namespace_version: self.compatible_namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFlowTemplateInputOperationOutputAlias = crate::operation::CreateFlowTemplate;
#[doc(hidden)]
pub type CreateFlowTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFlowTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateFlowTemplate`](crate::operation::CreateFlowTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFlowTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFlowTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFlowTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFlowTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.CreateFlowTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_flow_template(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFlowTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFlowTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFlowTemplateInput`](crate::input::CreateFlowTemplateInput)
    pub fn builder() -> crate::input::create_flow_template_input::Builder {
        crate::input::create_flow_template_input::Builder::default()
    }
}

/// See [`CreateSystemInstanceInput`](crate::input::CreateSystemInstanceInput)
pub mod create_system_instance_input {
    /// A builder for [`CreateSystemInstanceInput`](crate::input::CreateSystemInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) target: std::option::Option<crate::model::DeploymentTarget>,
        pub(crate) greengrass_group_name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
        pub(crate) flow_actions_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>A document that defines an entity. </p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn target(mut self, input: crate::model::DeploymentTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::DeploymentTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if
        /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn greengrass_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if
        /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_greengrass_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_name = input;
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if
        /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if
        /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.metrics_configuration = Some(input);
            self
        }
        /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.metrics_configuration = input;
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have
        /// read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes.  This
        /// value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn flow_actions_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_actions_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have
        /// read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes.  This
        /// value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
        pub fn set_flow_actions_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_actions_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSystemInstanceInput`](crate::input::CreateSystemInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSystemInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSystemInstanceInput {
                tags: self.tags,
                definition: self.definition,
                target: self.target,
                greengrass_group_name: self.greengrass_group_name,
                s3_bucket_name: self.s3_bucket_name,
                metrics_configuration: self.metrics_configuration,
                flow_actions_role_arn: self.flow_actions_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSystemInstanceInputOperationOutputAlias = crate::operation::CreateSystemInstance;
#[doc(hidden)]
pub type CreateSystemInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSystemInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateSystemInstance`](crate::operation::CreateSystemInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSystemInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSystemInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSystemInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSystemInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.CreateSystemInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_system_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSystemInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSystemInstance",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSystemInstanceInput`](crate::input::CreateSystemInstanceInput)
    pub fn builder() -> crate::input::create_system_instance_input::Builder {
        crate::input::create_system_instance_input::Builder::default()
    }
}

/// See [`CreateSystemTemplateInput`](crate::input::CreateSystemTemplateInput)
pub mod create_system_template_input {
    /// A builder for [`CreateSystemTemplateInput`](crate::input::CreateSystemTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) compatible_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.compatible_namespace_version = Some(input);
            self
        }
        /// <p>The namespace version in which the system is to be created.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.compatible_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSystemTemplateInput`](crate::input::CreateSystemTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSystemTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSystemTemplateInput {
                definition: self.definition,
                compatible_namespace_version: self.compatible_namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSystemTemplateInputOperationOutputAlias = crate::operation::CreateSystemTemplate;
#[doc(hidden)]
pub type CreateSystemTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSystemTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateSystemTemplate`](crate::operation::CreateSystemTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSystemTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSystemTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSystemTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSystemTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.CreateSystemTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_system_template(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSystemTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSystemTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSystemTemplateInput`](crate::input::CreateSystemTemplateInput)
    pub fn builder() -> crate::input::create_system_template_input::Builder {
        crate::input::create_system_template_input::Builder::default()
    }
}

/// See [`DeleteFlowTemplateInput`](crate::input::DeleteFlowTemplateInput)
pub mod delete_flow_template_input {
    /// A builder for [`DeleteFlowTemplateInput`](crate::input::DeleteFlowTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFlowTemplateInput`](crate::input::DeleteFlowTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFlowTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFlowTemplateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteFlowTemplateInputOperationOutputAlias = crate::operation::DeleteFlowTemplate;
#[doc(hidden)]
pub type DeleteFlowTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFlowTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFlowTemplate`](crate::operation::DeleteFlowTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFlowTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFlowTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFlowTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFlowTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeleteFlowTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_flow_template(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFlowTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFlowTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFlowTemplateInput`](crate::input::DeleteFlowTemplateInput)
    pub fn builder() -> crate::input::delete_flow_template_input::Builder {
        crate::input::delete_flow_template_input::Builder::default()
    }
}

/// See [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
pub mod delete_namespace_input {
    /// A builder for [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNamespaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNamespaceInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteNamespaceInputOperationOutputAlias = crate::operation::DeleteNamespace;
#[doc(hidden)]
pub type DeleteNamespaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNamespaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNamespace`](crate::operation::DeleteNamespace)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNamespace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNamespaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNamespaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNamespaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeleteNamespace",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_namespace(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNamespace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNamespace",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    pub fn builder() -> crate::input::delete_namespace_input::Builder {
        crate::input::delete_namespace_input::Builder::default()
    }
}

/// See [`DeleteSystemInstanceInput`](crate::input::DeleteSystemInstanceInput)
pub mod delete_system_instance_input {
    /// A builder for [`DeleteSystemInstanceInput`](crate::input::DeleteSystemInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance to be deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSystemInstanceInput`](crate::input::DeleteSystemInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSystemInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSystemInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteSystemInstanceInputOperationOutputAlias = crate::operation::DeleteSystemInstance;
#[doc(hidden)]
pub type DeleteSystemInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSystemInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSystemInstance`](crate::operation::DeleteSystemInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSystemInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSystemInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSystemInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSystemInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeleteSystemInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_system_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSystemInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSystemInstance",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSystemInstanceInput`](crate::input::DeleteSystemInstanceInput)
    pub fn builder() -> crate::input::delete_system_instance_input::Builder {
        crate::input::delete_system_instance_input::Builder::default()
    }
}

/// See [`DeleteSystemTemplateInput`](crate::input::DeleteSystemTemplateInput)
pub mod delete_system_template_input {
    /// A builder for [`DeleteSystemTemplateInput`](crate::input::DeleteSystemTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSystemTemplateInput`](crate::input::DeleteSystemTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSystemTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSystemTemplateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteSystemTemplateInputOperationOutputAlias = crate::operation::DeleteSystemTemplate;
#[doc(hidden)]
pub type DeleteSystemTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSystemTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSystemTemplate`](crate::operation::DeleteSystemTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSystemTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSystemTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSystemTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSystemTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeleteSystemTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_system_template(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSystemTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSystemTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSystemTemplateInput`](crate::input::DeleteSystemTemplateInput)
    pub fn builder() -> crate::input::delete_system_template_input::Builder {
        crate::input::delete_system_template_input::Builder::default()
    }
}

/// See [`DeploySystemInstanceInput`](crate::input::DeploySystemInstanceInput)
pub mod deploy_system_instance_input {
    /// A builder for [`DeploySystemInstanceInput`](crate::input::DeploySystemInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploySystemInstanceInput`](crate::input::DeploySystemInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeploySystemInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeploySystemInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeploySystemInstanceInputOperationOutputAlias = crate::operation::DeploySystemInstance;
#[doc(hidden)]
pub type DeploySystemInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeploySystemInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeploySystemInstance`](crate::operation::DeploySystemInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeploySystemInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeploySystemInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeploySystemInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeploySystemInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeploySystemInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deploy_system_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeploySystemInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeploySystemInstance",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeploySystemInstanceInput`](crate::input::DeploySystemInstanceInput)
    pub fn builder() -> crate::input::deploy_system_instance_input::Builder {
        crate::input::deploy_system_instance_input::Builder::default()
    }
}

/// See [`DeprecateFlowTemplateInput`](crate::input::DeprecateFlowTemplateInput)
pub mod deprecate_flow_template_input {
    /// A builder for [`DeprecateFlowTemplateInput`](crate::input::DeprecateFlowTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow to be deleted.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateFlowTemplateInput`](crate::input::DeprecateFlowTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateFlowTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateFlowTemplateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeprecateFlowTemplateInputOperationOutputAlias = crate::operation::DeprecateFlowTemplate;
#[doc(hidden)]
pub type DeprecateFlowTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprecateFlowTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateFlowTemplate`](crate::operation::DeprecateFlowTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateFlowTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprecateFlowTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprecateFlowTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprecateFlowTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeprecateFlowTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprecate_flow_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateFlowTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateFlowTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprecateFlowTemplateInput`](crate::input::DeprecateFlowTemplateInput)
    pub fn builder() -> crate::input::deprecate_flow_template_input::Builder {
        crate::input::deprecate_flow_template_input::Builder::default()
    }
}

/// See [`DeprecateSystemTemplateInput`](crate::input::DeprecateSystemTemplateInput)
pub mod deprecate_system_template_input {
    /// A builder for [`DeprecateSystemTemplateInput`](crate::input::DeprecateSystemTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system to delete.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateSystemTemplateInput`](crate::input::DeprecateSystemTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateSystemTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateSystemTemplateInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeprecateSystemTemplateInputOperationOutputAlias =
    crate::operation::DeprecateSystemTemplate;
#[doc(hidden)]
pub type DeprecateSystemTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprecateSystemTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateSystemTemplate`](crate::operation::DeprecateSystemTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateSystemTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprecateSystemTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprecateSystemTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprecateSystemTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DeprecateSystemTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprecate_system_template(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateSystemTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateSystemTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprecateSystemTemplateInput`](crate::input::DeprecateSystemTemplateInput)
    pub fn builder() -> crate::input::deprecate_system_template_input::Builder {
        crate::input::deprecate_system_template_input::Builder::default()
    }
}

/// See [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
pub mod describe_namespace_input {
    /// A builder for [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn namespace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_name = Some(input.into());
            self
        }
        /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
        pub fn set_namespace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.namespace_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNamespaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNamespaceInput {
                namespace_name: self.namespace_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNamespaceInputOperationOutputAlias = crate::operation::DescribeNamespace;
#[doc(hidden)]
pub type DescribeNamespaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNamespaceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNamespace`](crate::operation::DescribeNamespace)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNamespace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNamespaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNamespaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNamespaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DescribeNamespace",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_namespace(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNamespace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNamespace",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    pub fn builder() -> crate::input::describe_namespace_input::Builder {
        crate::input::describe_namespace_input::Builder::default()
    }
}

/// See [`DissociateEntityFromThingInput`](crate::input::DissociateEntityFromThingInput)
pub mod dissociate_entity_from_thing_input {
    /// A builder for [`DissociateEntityFromThingInput`](crate::input::DissociateEntityFromThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) entity_type: std::option::Option<crate::model::EntityType>,
    }
    impl Builder {
        /// <p>The name of the thing to disassociate.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to disassociate.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn entity_type(mut self, input: crate::model::EntityType) -> Self {
            self.entity_type = Some(input);
            self
        }
        /// <p>The entity type from which to disassociate the thing.</p>
        pub fn set_entity_type(
            mut self,
            input: std::option::Option<crate::model::EntityType>,
        ) -> Self {
            self.entity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DissociateEntityFromThingInput`](crate::input::DissociateEntityFromThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DissociateEntityFromThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DissociateEntityFromThingInput {
                thing_name: self.thing_name,
                entity_type: self.entity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DissociateEntityFromThingInputOperationOutputAlias =
    crate::operation::DissociateEntityFromThing;
#[doc(hidden)]
pub type DissociateEntityFromThingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DissociateEntityFromThingInput {
    /// Consumes the builder and constructs an Operation<[`DissociateEntityFromThing`](crate::operation::DissociateEntityFromThing)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DissociateEntityFromThing,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DissociateEntityFromThingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DissociateEntityFromThingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DissociateEntityFromThingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.DissociateEntityFromThing",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_dissociate_entity_from_thing(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DissociateEntityFromThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DissociateEntityFromThing",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DissociateEntityFromThingInput`](crate::input::DissociateEntityFromThingInput)
    pub fn builder() -> crate::input::dissociate_entity_from_thing_input::Builder {
        crate::input::dissociate_entity_from_thing_input::Builder::default()
    }
}

/// See [`GetEntitiesInput`](crate::input::GetEntitiesInput)
pub mod get_entities_input {
    /// A builder for [`GetEntitiesInput`](crate::input::GetEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>An array of entity IDs.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEntitiesInput`](crate::input::GetEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEntitiesInput {
                ids: self.ids,
                namespace_version: self.namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEntitiesInputOperationOutputAlias = crate::operation::GetEntities;
#[doc(hidden)]
pub type GetEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`GetEntities`](crate::operation::GetEntities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_entities(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEntities",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEntitiesInput`](crate::input::GetEntitiesInput)
    pub fn builder() -> crate::input::get_entities_input::Builder {
        crate::input::get_entities_input::Builder::default()
    }
}

/// See [`GetFlowTemplateInput`](crate::input::GetFlowTemplateInput)
pub mod get_flow_template_input {
    /// A builder for [`GetFlowTemplateInput`](crate::input::GetFlowTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) revision_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.revision_number = Some(input);
            self
        }
        /// <p>The number of the workflow revision to retrieve.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.revision_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFlowTemplateInput`](crate::input::GetFlowTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFlowTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFlowTemplateInput {
                id: self.id,
                revision_number: self.revision_number,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFlowTemplateInputOperationOutputAlias = crate::operation::GetFlowTemplate;
#[doc(hidden)]
pub type GetFlowTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFlowTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetFlowTemplate`](crate::operation::GetFlowTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFlowTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFlowTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFlowTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFlowTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetFlowTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_flow_template(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFlowTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFlowTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateInput`](crate::input::GetFlowTemplateInput)
    pub fn builder() -> crate::input::get_flow_template_input::Builder {
        crate::input::get_flow_template_input::Builder::default()
    }
}

/// See [`GetFlowTemplateRevisionsInput`](crate::input::GetFlowTemplateRevisionsInput)
pub mod get_flow_template_revisions_input {
    /// A builder for [`GetFlowTemplateRevisionsInput`](crate::input::GetFlowTemplateRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFlowTemplateRevisionsInput`](crate::input::GetFlowTemplateRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFlowTemplateRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFlowTemplateRevisionsInput {
                id: self.id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFlowTemplateRevisionsInputOperationOutputAlias =
    crate::operation::GetFlowTemplateRevisions;
#[doc(hidden)]
pub type GetFlowTemplateRevisionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFlowTemplateRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`GetFlowTemplateRevisions`](crate::operation::GetFlowTemplateRevisions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFlowTemplateRevisions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFlowTemplateRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFlowTemplateRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFlowTemplateRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetFlowTemplateRevisions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_flow_template_revisions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFlowTemplateRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFlowTemplateRevisions",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFlowTemplateRevisionsInput`](crate::input::GetFlowTemplateRevisionsInput)
    pub fn builder() -> crate::input::get_flow_template_revisions_input::Builder {
        crate::input::get_flow_template_revisions_input::Builder::default()
    }
}

/// See [`GetNamespaceDeletionStatusInput`](crate::input::GetNamespaceDeletionStatusInput)
pub mod get_namespace_deletion_status_input {
    /// A builder for [`GetNamespaceDeletionStatusInput`](crate::input::GetNamespaceDeletionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetNamespaceDeletionStatusInput`](crate::input::GetNamespaceDeletionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNamespaceDeletionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNamespaceDeletionStatusInput {})
        }
    }
}
#[doc(hidden)]
pub type GetNamespaceDeletionStatusInputOperationOutputAlias =
    crate::operation::GetNamespaceDeletionStatus;
#[doc(hidden)]
pub type GetNamespaceDeletionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetNamespaceDeletionStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetNamespaceDeletionStatus`](crate::operation::GetNamespaceDeletionStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNamespaceDeletionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNamespaceDeletionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNamespaceDeletionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNamespaceDeletionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetNamespaceDeletionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_namespace_deletion_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNamespaceDeletionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNamespaceDeletionStatus",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNamespaceDeletionStatusInput`](crate::input::GetNamespaceDeletionStatusInput)
    pub fn builder() -> crate::input::get_namespace_deletion_status_input::Builder {
        crate::input::get_namespace_deletion_status_input::Builder::default()
    }
}

/// See [`GetSystemInstanceInput`](crate::input::GetSystemInstanceInput)
pub mod get_system_instance_input {
    /// A builder for [`GetSystemInstanceInput`](crate::input::GetSystemInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemInstanceInput`](crate::input::GetSystemInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSystemInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSystemInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetSystemInstanceInputOperationOutputAlias = crate::operation::GetSystemInstance;
#[doc(hidden)]
pub type GetSystemInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSystemInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetSystemInstance`](crate::operation::GetSystemInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSystemInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSystemInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSystemInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSystemInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetSystemInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_system_instance(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSystemInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSystemInstance",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSystemInstanceInput`](crate::input::GetSystemInstanceInput)
    pub fn builder() -> crate::input::get_system_instance_input::Builder {
        crate::input::get_system_instance_input::Builder::default()
    }
}

/// See [`GetSystemTemplateInput`](crate::input::GetSystemTemplateInput)
pub mod get_system_template_input {
    /// A builder for [`GetSystemTemplateInput`](crate::input::GetSystemTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) revision_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn revision_number(mut self, input: i64) -> Self {
            self.revision_number = Some(input);
            self
        }
        /// <p>The number that specifies the revision of the system to get.</p>
        pub fn set_revision_number(mut self, input: std::option::Option<i64>) -> Self {
            self.revision_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemTemplateInput`](crate::input::GetSystemTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSystemTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSystemTemplateInput {
                id: self.id,
                revision_number: self.revision_number,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSystemTemplateInputOperationOutputAlias = crate::operation::GetSystemTemplate;
#[doc(hidden)]
pub type GetSystemTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSystemTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetSystemTemplate`](crate::operation::GetSystemTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSystemTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSystemTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSystemTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSystemTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetSystemTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_system_template(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSystemTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSystemTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateInput`](crate::input::GetSystemTemplateInput)
    pub fn builder() -> crate::input::get_system_template_input::Builder {
        crate::input::get_system_template_input::Builder::default()
    }
}

/// See [`GetSystemTemplateRevisionsInput`](crate::input::GetSystemTemplateRevisionsInput)
pub mod get_system_template_revisions_input {
    /// A builder for [`GetSystemTemplateRevisionsInput`](crate::input::GetSystemTemplateRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system template.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSystemTemplateRevisionsInput`](crate::input::GetSystemTemplateRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSystemTemplateRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSystemTemplateRevisionsInput {
                id: self.id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSystemTemplateRevisionsInputOperationOutputAlias =
    crate::operation::GetSystemTemplateRevisions;
#[doc(hidden)]
pub type GetSystemTemplateRevisionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSystemTemplateRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`GetSystemTemplateRevisions`](crate::operation::GetSystemTemplateRevisions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSystemTemplateRevisions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSystemTemplateRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSystemTemplateRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSystemTemplateRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetSystemTemplateRevisions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_system_template_revisions(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSystemTemplateRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSystemTemplateRevisions",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSystemTemplateRevisionsInput`](crate::input::GetSystemTemplateRevisionsInput)
    pub fn builder() -> crate::input::get_system_template_revisions_input::Builder {
        crate::input::get_system_template_revisions_input::Builder::default()
    }
}

/// See [`GetUploadStatusInput`](crate::input::GetUploadStatusInput)
pub mod get_upload_status_input {
    /// A builder for [`GetUploadStatusInput`](crate::input::GetUploadStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUploadStatusInput`](crate::input::GetUploadStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUploadStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUploadStatusInput {
                upload_id: self.upload_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUploadStatusInputOperationOutputAlias = crate::operation::GetUploadStatus;
#[doc(hidden)]
pub type GetUploadStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUploadStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetUploadStatus`](crate::operation::GetUploadStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUploadStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUploadStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUploadStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUploadStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.GetUploadStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_upload_status(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUploadStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUploadStatus",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUploadStatusInput`](crate::input::GetUploadStatusInput)
    pub fn builder() -> crate::input::get_upload_status_input::Builder {
        crate::input::get_upload_status_input::Builder::default()
    }
}

/// See [`ListFlowExecutionMessagesInput`](crate::input::ListFlowExecutionMessagesInput)
pub mod list_flow_execution_messages_input {
    /// A builder for [`ListFlowExecutionMessagesInput`](crate::input::ListFlowExecutionMessagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_execution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_execution_id = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowExecutionMessagesInput`](crate::input::ListFlowExecutionMessagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFlowExecutionMessagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFlowExecutionMessagesInput {
                flow_execution_id: self.flow_execution_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFlowExecutionMessagesInputOperationOutputAlias =
    crate::operation::ListFlowExecutionMessages;
#[doc(hidden)]
pub type ListFlowExecutionMessagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFlowExecutionMessagesInput {
    /// Consumes the builder and constructs an Operation<[`ListFlowExecutionMessages`](crate::operation::ListFlowExecutionMessages)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFlowExecutionMessages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFlowExecutionMessagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFlowExecutionMessagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFlowExecutionMessagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.ListFlowExecutionMessages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_flow_execution_messages(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFlowExecutionMessages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFlowExecutionMessages",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFlowExecutionMessagesInput`](crate::input::ListFlowExecutionMessagesInput)
    pub fn builder() -> crate::input::list_flow_execution_messages_input::Builder {
        crate::input::list_flow_execution_messages_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of tags to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tags to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that specifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                max_results: self.max_results,
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`SearchEntitiesInput`](crate::input::SearchEntitiesInput)
pub mod search_entities_input {
    /// A builder for [`SearchEntitiesInput`](crate::input::SearchEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::EntityFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The entity types for which to search.</p>
        pub fn entity_types(mut self, input: impl Into<crate::model::EntityType>) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>The entity types for which to search.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code>
        /// <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
        /// <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
        /// you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: impl Into<crate::model::EntityFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code>
        /// <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
        /// <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
        /// you can filter on the ID of a property that is used in a state.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchEntitiesInput`](crate::input::SearchEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchEntitiesInput {
                entity_types: self.entity_types,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
                namespace_version: self.namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchEntitiesInputOperationOutputAlias = crate::operation::SearchEntities;
#[doc(hidden)]
pub type SearchEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`SearchEntities`](crate::operation::SearchEntities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_entities(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchEntities",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchEntitiesInput`](crate::input::SearchEntitiesInput)
    pub fn builder() -> crate::input::search_entities_input::Builder {
        crate::input::search_entities_input::Builder::default()
    }
}

/// See [`SearchFlowExecutionsInput`](crate::input::SearchFlowExecutionsInput)
pub mod search_flow_executions_input {
    /// A builder for [`SearchFlowExecutionsInput`](crate::input::SearchFlowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) system_instance_id: std::option::Option<std::string::String>,
        pub(crate) flow_execution_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn system_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.system_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance that contains the flow.</p>
        pub fn set_system_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.system_instance_id = input;
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn flow_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of a flow execution.</p>
        pub fn set_flow_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_execution_id = input;
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time of the earliest flow execution to return.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time of the latest flow execution to return.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFlowExecutionsInput`](crate::input::SearchFlowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchFlowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchFlowExecutionsInput {
                system_instance_id: self.system_instance_id,
                flow_execution_id: self.flow_execution_id,
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchFlowExecutionsInputOperationOutputAlias = crate::operation::SearchFlowExecutions;
#[doc(hidden)]
pub type SearchFlowExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchFlowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`SearchFlowExecutions`](crate::operation::SearchFlowExecutions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchFlowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchFlowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchFlowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchFlowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchFlowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_flow_executions(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchFlowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchFlowExecutions",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchFlowExecutionsInput`](crate::input::SearchFlowExecutionsInput)
    pub fn builder() -> crate::input::search_flow_executions_input::Builder {
        crate::input::search_flow_executions_input::Builder::default()
    }
}

/// See [`SearchFlowTemplatesInput`](crate::input::SearchFlowTemplatesInput)
pub mod search_flow_templates_input {
    /// A builder for [`SearchFlowTemplatesInput`](crate::input::SearchFlowTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::FlowTemplateFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::FlowTemplateFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowTemplateFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFlowTemplatesInput`](crate::input::SearchFlowTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchFlowTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchFlowTemplatesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchFlowTemplatesInputOperationOutputAlias = crate::operation::SearchFlowTemplates;
#[doc(hidden)]
pub type SearchFlowTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchFlowTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`SearchFlowTemplates`](crate::operation::SearchFlowTemplates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchFlowTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchFlowTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchFlowTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchFlowTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchFlowTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_flow_templates(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchFlowTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchFlowTemplates",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchFlowTemplatesInput`](crate::input::SearchFlowTemplatesInput)
    pub fn builder() -> crate::input::search_flow_templates_input::Builder {
        crate::input::search_flow_templates_input::Builder::default()
    }
}

/// See [`SearchSystemInstancesInput`](crate::input::SearchSystemInstancesInput)
pub mod search_system_instances_input {
    /// A builder for [`SearchSystemInstancesInput`](crate::input::SearchSystemInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SystemInstanceFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and
        /// <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn filters(mut self, input: impl Into<crate::model::SystemInstanceFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and
        /// <code>GREENGRASS_GROUP_NAME</code>.</p>
        /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemInstanceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSystemInstancesInput`](crate::input::SearchSystemInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchSystemInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchSystemInstancesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchSystemInstancesInputOperationOutputAlias = crate::operation::SearchSystemInstances;
#[doc(hidden)]
pub type SearchSystemInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchSystemInstancesInput {
    /// Consumes the builder and constructs an Operation<[`SearchSystemInstances`](crate::operation::SearchSystemInstances)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchSystemInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchSystemInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchSystemInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchSystemInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchSystemInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_system_instances(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchSystemInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchSystemInstances",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchSystemInstancesInput`](crate::input::SearchSystemInstancesInput)
    pub fn builder() -> crate::input::search_system_instances_input::Builder {
        crate::input::search_system_instances_input::Builder::default()
    }
}

/// See [`SearchSystemTemplatesInput`](crate::input::SearchSystemTemplatesInput)
pub mod search_system_templates_input {
    /// A builder for [`SearchSystemTemplatesInput`](crate::input::SearchSystemTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SystemTemplateFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::SystemTemplateFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemTemplateFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchSystemTemplatesInput`](crate::input::SearchSystemTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchSystemTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchSystemTemplatesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchSystemTemplatesInputOperationOutputAlias = crate::operation::SearchSystemTemplates;
#[doc(hidden)]
pub type SearchSystemTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchSystemTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`SearchSystemTemplates`](crate::operation::SearchSystemTemplates)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchSystemTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchSystemTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchSystemTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchSystemTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchSystemTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_system_templates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchSystemTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchSystemTemplates",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchSystemTemplatesInput`](crate::input::SearchSystemTemplatesInput)
    pub fn builder() -> crate::input::search_system_templates_input::Builder {
        crate::input::search_system_templates_input::Builder::default()
    }
}

/// See [`SearchThingsInput`](crate::input::SearchThingsInput)
pub mod search_things_input {
    /// A builder for [`SearchThingsInput`](crate::input::SearchThingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The ID of the entity to which the things are associated.</p>
        /// <p>The IDs should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
        /// </p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn namespace_version(mut self, input: i64) -> Self {
            self.namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        pub fn set_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchThingsInput`](crate::input::SearchThingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchThingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchThingsInput {
                entity_id: self.entity_id,
                next_token: self.next_token,
                max_results: self.max_results,
                namespace_version: self.namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchThingsInputOperationOutputAlias = crate::operation::SearchThings;
#[doc(hidden)]
pub type SearchThingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchThingsInput {
    /// Consumes the builder and constructs an Operation<[`SearchThings`](crate::operation::SearchThings)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchThings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchThingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchThingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchThingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.SearchThings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_things(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchThings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchThings",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchThingsInput`](crate::input::SearchThingsInput)
    pub fn builder() -> crate::input::search_things_input::Builder {
        crate::input::search_things_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the resource.></p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to add to the resource.></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UndeploySystemInstanceInput`](crate::input::UndeploySystemInstanceInput)
pub mod undeploy_system_instance_input {
    /// A builder for [`UndeploySystemInstanceInput`](crate::input::UndeploySystemInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system instance to remove from its target.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`UndeploySystemInstanceInput`](crate::input::UndeploySystemInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UndeploySystemInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UndeploySystemInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type UndeploySystemInstanceInputOperationOutputAlias = crate::operation::UndeploySystemInstance;
#[doc(hidden)]
pub type UndeploySystemInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UndeploySystemInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UndeploySystemInstance`](crate::operation::UndeploySystemInstance)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UndeploySystemInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UndeploySystemInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UndeploySystemInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UndeploySystemInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.UndeploySystemInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_undeploy_system_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UndeploySystemInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UndeploySystemInstance",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UndeploySystemInstanceInput`](crate::input::UndeploySystemInstanceInput)
    pub fn builder() -> crate::input::undeploy_system_instance_input::Builder {
        crate::input::undeploy_system_instance_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
        /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFlowTemplateInput`](crate::input::UpdateFlowTemplateInput)
pub mod update_flow_template_input {
    /// A builder for [`UpdateFlowTemplateInput`](crate::input::UpdateFlowTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) compatible_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the workflow to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow
        /// to update.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.compatible_namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow
        /// to update.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.compatible_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowTemplateInput`](crate::input::UpdateFlowTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowTemplateInput {
                id: self.id,
                definition: self.definition,
                compatible_namespace_version: self.compatible_namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowTemplateInputOperationOutputAlias = crate::operation::UpdateFlowTemplate;
#[doc(hidden)]
pub type UpdateFlowTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlowTemplate`](crate::operation::UpdateFlowTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlowTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.UpdateFlowTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_flow_template(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlowTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlowTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowTemplateInput`](crate::input::UpdateFlowTemplateInput)
    pub fn builder() -> crate::input::update_flow_template_input::Builder {
        crate::input::update_flow_template_input::Builder::default()
    }
}

/// See [`UpdateSystemTemplateInput`](crate::input::UpdateSystemTemplateInput)
pub mod update_system_template_input {
    /// A builder for [`UpdateSystemTemplateInput`](crate::input::UpdateSystemTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) compatible_namespace_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the system to be updated.</p>
        /// <p>The ID should be in the following format.</p>
        /// <p>
        /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn definition(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn compatible_namespace_version(mut self, input: i64) -> Self {
            self.compatible_namespace_version = Some(input);
            self
        }
        /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
        /// <p>If no value is specified, the latest version is used by default.</p>
        pub fn set_compatible_namespace_version(mut self, input: std::option::Option<i64>) -> Self {
            self.compatible_namespace_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSystemTemplateInput`](crate::input::UpdateSystemTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSystemTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSystemTemplateInput {
                id: self.id,
                definition: self.definition,
                compatible_namespace_version: self.compatible_namespace_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSystemTemplateInputOperationOutputAlias = crate::operation::UpdateSystemTemplate;
#[doc(hidden)]
pub type UpdateSystemTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSystemTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSystemTemplate`](crate::operation::UpdateSystemTemplate)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSystemTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSystemTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSystemTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSystemTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.UpdateSystemTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_system_template(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSystemTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSystemTemplate",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSystemTemplateInput`](crate::input::UpdateSystemTemplateInput)
    pub fn builder() -> crate::input::update_system_template_input::Builder {
        crate::input::update_system_template_input::Builder::default()
    }
}

/// See [`UploadEntityDefinitionsInput`](crate::input::UploadEntityDefinitionsInput)
pub mod upload_entity_definitions_input {
    /// A builder for [`UploadEntityDefinitionsInput`](crate::input::UploadEntityDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<crate::model::DefinitionDocument>,
        pub(crate) sync_with_public_namespace: std::option::Option<bool>,
        pub(crate) deprecate_existing_entities: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn document(mut self, input: crate::model::DefinitionDocument) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
        pub fn set_document(
            mut self,
            input: std::option::Option<crate::model::DefinitionDocument>,
        ) -> Self {
            self.document = input;
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn sync_with_public_namespace(mut self, input: bool) -> Self {
            self.sync_with_public_namespace = Some(input);
            self
        }
        /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_sync_with_public_namespace(mut self, input: std::option::Option<bool>) -> Self {
            self.sync_with_public_namespace = input;
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>.
        /// If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn deprecate_existing_entities(mut self, input: bool) -> Self {
            self.deprecate_existing_entities = Some(input);
            self
        }
        /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>.
        /// If set to <code>true</code>, the upload will create a new namespace version.</p>
        pub fn set_deprecate_existing_entities(mut self, input: std::option::Option<bool>) -> Self {
            self.deprecate_existing_entities = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadEntityDefinitionsInput`](crate::input::UploadEntityDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UploadEntityDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UploadEntityDefinitionsInput {
                document: self.document,
                sync_with_public_namespace: self.sync_with_public_namespace.unwrap_or_default(),
                deprecate_existing_entities: self.deprecate_existing_entities.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UploadEntityDefinitionsInputOperationOutputAlias =
    crate::operation::UploadEntityDefinitions;
#[doc(hidden)]
pub type UploadEntityDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UploadEntityDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`UploadEntityDefinitions`](crate::operation::UploadEntityDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UploadEntityDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UploadEntityDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UploadEntityDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UploadEntityDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "IotThingsGraphFrontEndService.UploadEntityDefinitions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upload_entity_definitions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UploadEntityDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UploadEntityDefinitions",
            "iotthingsgraph",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UploadEntityDefinitionsInput`](crate::input::UploadEntityDefinitionsInput)
    pub fn builder() -> crate::input::upload_entity_definitions_input::Builder {
        crate::input::upload_entity_definitions_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadEntityDefinitionsInput {
    /// <p>The <code>DefinitionDocument</code> that defines the updated entities.</p>
    pub document: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to <code>true</code>, the upload will create a new namespace version.</p>
    pub sync_with_public_namespace: bool,
    /// <p>A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new <code>DefinitionDocument</code>.
    /// If set to <code>true</code>, the upload will create a new namespace version.</p>
    pub deprecate_existing_entities: bool,
}
impl std::fmt::Debug for UploadEntityDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadEntityDefinitionsInput");
        formatter.field("document", &self.document);
        formatter.field(
            "sync_with_public_namespace",
            &self.sync_with_public_namespace,
        );
        formatter.field(
            "deprecate_existing_entities",
            &self.deprecate_existing_entities,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSystemTemplateInput {
    /// <p>The ID of the system to be updated.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The <code>DefinitionDocument</code> that contains the updated system definition.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    /// <p>If no value is specified, the latest version is used by default.</p>
    pub compatible_namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for UpdateSystemTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSystemTemplateInput");
        formatter.field("id", &self.id);
        formatter.field("definition", &self.definition);
        formatter.field(
            "compatible_namespace_version",
            &self.compatible_namespace_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowTemplateInput {
    /// <p>The ID of the workflow to be updated.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The <code>DefinitionDocument</code> that contains the updated workflow definition.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The version of the user's namespace.</p>
    /// <p>If no value is specified, the latest version is used by default. Use the <code>GetFlowTemplateRevisions</code> if you want to find earlier revisions of the flow
    /// to update.</p>
    pub compatible_namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for UpdateFlowTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowTemplateInput");
        formatter.field("id", &self.id);
        formatter.field("definition", &self.definition);
        formatter.field(
            "compatible_namespace_version",
            &self.compatible_namespace_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be removed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag key names to remove from the resource. You don't specify the value. Both the key and its associated value are removed. </p>
    /// <p>This parameter to the API requires a JSON text string argument. For information on how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json">Using JSON for Parameters</a> in the <i>AWS CLI User Guide</i>. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UndeploySystemInstanceInput {
    /// <p>The ID of the system instance to remove from its target.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UndeploySystemInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UndeploySystemInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags are returned.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags to add to the resource.></p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchThingsInput {
    /// <p>The ID of the entity to which the things are associated.</p>
    /// <p>The IDs should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
    /// </p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for SearchThingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchThingsInput");
        formatter.field("entity_id", &self.entity_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("namespace_version", &self.namespace_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSystemTemplatesInput {
    /// <p>An array of filters that limit the result set. The only valid filter is <code>FLOW_TEMPLATE_ID</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SystemTemplateFilter>>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchSystemTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSystemTemplatesInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchSystemInstancesInput {
    /// <p>Optional filter to apply to the search. Valid filters are <code>SYSTEM_TEMPLATE_ID</code>, <code>STATUS</code>, and
    /// <code>GREENGRASS_GROUP_NAME</code>.</p>
    /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SystemInstanceFilter>>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchSystemInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchSystemInstancesInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFlowTemplatesInput {
    /// <p>An array of objects that limit the result set. The only valid filter is <code>DEVICE_MODEL_ID</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::FlowTemplateFilter>>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchFlowTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFlowTemplatesInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFlowExecutionsInput {
    /// <p>The ID of the system instance that contains the flow.</p>
    pub system_instance_id: std::option::Option<std::string::String>,
    /// <p>The ID of a flow execution.</p>
    pub flow_execution_id: std::option::Option<std::string::String>,
    /// <p>The date and time of the earliest flow execution to return.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time of the latest flow execution to return.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for SearchFlowExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFlowExecutionsInput");
        formatter.field("system_instance_id", &self.system_instance_id);
        formatter.field("flow_execution_id", &self.flow_execution_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchEntitiesInput {
    /// <p>The entity types for which to search.</p>
    pub entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
    /// <p>Optional filter to apply to the search. Valid filters are <code>NAME</code>
    /// <code>NAMESPACE</code>, <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
    /// <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set. For example,
    /// you can filter on the ID of a property that is used in a state.</p>
    /// <p>Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND criteria.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::EntityFilter>>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for SearchEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchEntitiesInput");
        formatter.field("entity_types", &self.entity_types);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("namespace_version", &self.namespace_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The maximum number of tags to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags are to be returned.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The token that specifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowExecutionMessagesInput {
    /// <p>The ID of the flow execution.</p>
    pub flow_execution_id: std::option::Option<std::string::String>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListFlowExecutionMessagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowExecutionMessagesInput");
        formatter.field("flow_execution_id", &self.flow_execution_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUploadStatusInput {
    /// <p>The ID of the upload. This value is returned by the <code>UploadEntityDefinitions</code> action.</p>
    pub upload_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUploadStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUploadStatusInput");
        formatter.field("upload_id", &self.upload_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemTemplateRevisionsInput {
    /// <p>The ID of the system template.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetSystemTemplateRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemTemplateRevisionsInput");
        formatter.field("id", &self.id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemTemplateInput {
    /// <p>The ID of the system to get. This ID must be in the user's namespace.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The number that specifies the revision of the system to get.</p>
    pub revision_number: std::option::Option<i64>,
}
impl std::fmt::Debug for GetSystemTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemTemplateInput");
        formatter.field("id", &self.id);
        formatter.field("revision_number", &self.revision_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSystemInstanceInput {
    /// <p>The ID of the system deployment instance. This value is returned by <code>CreateSystemInstance</code>.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSystemInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSystemInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNamespaceDeletionStatusInput {}
impl std::fmt::Debug for GetNamespaceDeletionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNamespaceDeletionStatusInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFlowTemplateRevisionsInput {
    /// <p>The ID of the workflow.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The string that specifies the next page of results. Use this when you're paginating results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetFlowTemplateRevisionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFlowTemplateRevisionsInput");
        formatter.field("id", &self.id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFlowTemplateInput {
    /// <p>The ID of the workflow.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The number of the workflow revision to retrieve.</p>
    pub revision_number: std::option::Option<i64>,
}
impl std::fmt::Debug for GetFlowTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFlowTemplateInput");
        formatter.field("id", &self.id);
        formatter.field("revision_number", &self.revision_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEntitiesInput {
    /// <p>An array of entity IDs.</p>
    /// <p>The IDs should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
    /// </p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for GetEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEntitiesInput");
        formatter.field("ids", &self.ids);
        formatter.field("namespace_version", &self.namespace_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DissociateEntityFromThingInput {
    /// <p>The name of the thing to disassociate.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The entity type from which to disassociate the thing.</p>
    pub entity_type: std::option::Option<crate::model::EntityType>,
}
impl std::fmt::Debug for DissociateEntityFromThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DissociateEntityFromThingInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("entity_type", &self.entity_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNamespaceInput {
    /// <p>The name of the user's namespace. Set this to <code>aws</code> to get the public namespace.</p>
    pub namespace_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeNamespaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNamespaceInput");
        formatter.field("namespace_name", &self.namespace_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateSystemTemplateInput {
    /// <p>The ID of the system to delete.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeprecateSystemTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateSystemTemplateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateFlowTemplateInput {
    /// <p>The ID of the workflow to be deleted.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeprecateFlowTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateFlowTemplateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploySystemInstanceInput {
    /// <p>The ID of the system instance. This value is returned by the <code>CreateSystemInstance</code> action.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeploySystemInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploySystemInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSystemTemplateInput {
    /// <p>The ID of the system to be deleted.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSystemTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSystemTemplateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSystemInstanceInput {
    /// <p>The ID of the system instance to be deleted.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSystemInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSystemInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNamespaceInput {}
impl std::fmt::Debug for DeleteNamespaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNamespaceInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowTemplateInput {
    /// <p>The ID of the workflow to be deleted.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME</code>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteFlowTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowTemplateInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSystemTemplateInput {
    /// <p>The <code>DefinitionDocument</code> used to create the system.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The namespace version in which the system is to be created.</p>
    /// <p>If no value is specified, the latest version is used by default.</p>
    pub compatible_namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for CreateSystemTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSystemTemplateInput");
        formatter.field("definition", &self.definition);
        formatter.field(
            "compatible_namespace_version",
            &self.compatible_namespace_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSystemInstanceInput {
    /// <p>Metadata, consisting of key-value pairs, that can be used to categorize your system instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A document that defines an entity. </p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.</p>
    pub target: std::option::Option<crate::model::DeploymentTarget>,
    /// <p>The name of the Greengrass group where the system instance will be deployed. This value is required if
    /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
    pub greengrass_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if
    /// the value of the <code>target</code> parameter is <code>GREENGRASS</code>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.</p>
    pub metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
    /// <p>The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have
    /// read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes.  This
    /// value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.</p>
    pub flow_actions_role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateSystemInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSystemInstanceInput");
        formatter.field("tags", &self.tags);
        formatter.field("definition", &self.definition);
        formatter.field("target", &self.target);
        formatter.field("greengrass_group_name", &self.greengrass_group_name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("metrics_configuration", &self.metrics_configuration);
        formatter.field("flow_actions_role_arn", &self.flow_actions_role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowTemplateInput {
    /// <p>The workflow <code>DefinitionDocument</code>.</p>
    pub definition: std::option::Option<crate::model::DefinitionDocument>,
    /// <p>The namespace version in which the workflow is to be created.</p>
    /// <p>If no value is specified, the latest version is used by default.</p>
    pub compatible_namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for CreateFlowTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowTemplateInput");
        formatter.field("definition", &self.definition);
        formatter.field(
            "compatible_namespace_version",
            &self.compatible_namespace_version,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateEntityToThingInput {
    /// <p>The name of the thing to which the entity is to be associated.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The ID of the device to be associated with the thing.</p>
    /// <p>The ID should be in the following format.</p>
    /// <p>
    /// <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
    /// </p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The version of the user's namespace. Defaults to the latest version of the user's namespace.</p>
    pub namespace_version: std::option::Option<i64>,
}
impl std::fmt::Debug for AssociateEntityToThingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateEntityToThingInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("namespace_version", &self.namespace_version);
        formatter.finish()
    }
}
