// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {}
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortalOutput {
    /// <p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
}
impl UpdatePortalOutput {
    /// <p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
}
impl std::fmt::Debug for UpdatePortalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortalOutput");
        formatter.field("portal_status", &self.portal_status);
        formatter.finish()
    }
}
/// See [`UpdatePortalOutput`](crate::output::UpdatePortalOutput)
pub mod update_portal_output {
    /// A builder for [`UpdatePortalOutput`](crate::output::UpdatePortalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
    }
    impl Builder {
        /// <p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortalOutput`](crate::output::UpdatePortalOutput)
        pub fn build(self) -> crate::output::UpdatePortalOutput {
            crate::output::UpdatePortalOutput {
                portal_status: self.portal_status,
            }
        }
    }
}
impl UpdatePortalOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePortalOutput`](crate::output::UpdatePortalOutput)
    pub fn builder() -> crate::output::update_portal_output::Builder {
        crate::output::update_portal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayCapabilityConfigurationOutput {
    /// <p>The namespace of the gateway capability.</p>
    pub capability_namespace: std::option::Option<std::string::String>,
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    /// <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>
    pub capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
}
impl UpdateGatewayCapabilityConfigurationOutput {
    /// <p>The namespace of the gateway capability.</p>
    pub fn capability_namespace(&self) -> std::option::Option<&str> {
        self.capability_namespace.as_deref()
    }
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    /// <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>
    pub fn capability_sync_status(
        &self,
    ) -> std::option::Option<&crate::model::CapabilitySyncStatus> {
        self.capability_sync_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateGatewayCapabilityConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayCapabilityConfigurationOutput");
        formatter.field("capability_namespace", &self.capability_namespace);
        formatter.field("capability_sync_status", &self.capability_sync_status);
        formatter.finish()
    }
}
/// See [`UpdateGatewayCapabilityConfigurationOutput`](crate::output::UpdateGatewayCapabilityConfigurationOutput)
pub mod update_gateway_capability_configuration_output {
    /// A builder for [`UpdateGatewayCapabilityConfigurationOutput`](crate::output::UpdateGatewayCapabilityConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capability_namespace: std::option::Option<std::string::String>,
        pub(crate) capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
    }
    impl Builder {
        /// <p>The namespace of the gateway capability.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the gateway capability.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_namespace = input;
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        /// <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>
        pub fn capability_sync_status(mut self, input: crate::model::CapabilitySyncStatus) -> Self {
            self.capability_sync_status = Some(input);
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        /// <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>
        pub fn set_capability_sync_status(
            mut self,
            input: std::option::Option<crate::model::CapabilitySyncStatus>,
        ) -> Self {
            self.capability_sync_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayCapabilityConfigurationOutput`](crate::output::UpdateGatewayCapabilityConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateGatewayCapabilityConfigurationOutput {
            crate::output::UpdateGatewayCapabilityConfigurationOutput {
                capability_namespace: self.capability_namespace,
                capability_sync_status: self.capability_sync_status,
            }
        }
    }
}
impl UpdateGatewayCapabilityConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayCapabilityConfigurationOutput`](crate::output::UpdateGatewayCapabilityConfigurationOutput)
    pub fn builder() -> crate::output::update_gateway_capability_configuration_output::Builder {
        crate::output::update_gateway_capability_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayOutput {}
impl std::fmt::Debug for UpdateGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayOutput");
        formatter.finish()
    }
}
/// See [`UpdateGatewayOutput`](crate::output::UpdateGatewayOutput)
pub mod update_gateway_output {
    /// A builder for [`UpdateGatewayOutput`](crate::output::UpdateGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateGatewayOutput`](crate::output::UpdateGatewayOutput)
        pub fn build(self) -> crate::output::UpdateGatewayOutput {
            crate::output::UpdateGatewayOutput {}
        }
    }
}
impl UpdateGatewayOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayOutput`](crate::output::UpdateGatewayOutput)
    pub fn builder() -> crate::output::update_gateway_output::Builder {
        crate::output::update_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDashboardOutput {}
impl std::fmt::Debug for UpdateDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDashboardOutput");
        formatter.finish()
    }
}
/// See [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
pub mod update_dashboard_output {
    /// A builder for [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
        pub fn build(self) -> crate::output::UpdateDashboardOutput {
            crate::output::UpdateDashboardOutput {}
        }
    }
}
impl UpdateDashboardOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
    pub fn builder() -> crate::output::update_dashboard_output::Builder {
        crate::output::update_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetPropertyOutput {}
impl std::fmt::Debug for UpdateAssetPropertyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetPropertyOutput");
        formatter.finish()
    }
}
/// See [`UpdateAssetPropertyOutput`](crate::output::UpdateAssetPropertyOutput)
pub mod update_asset_property_output {
    /// A builder for [`UpdateAssetPropertyOutput`](crate::output::UpdateAssetPropertyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAssetPropertyOutput`](crate::output::UpdateAssetPropertyOutput)
        pub fn build(self) -> crate::output::UpdateAssetPropertyOutput {
            crate::output::UpdateAssetPropertyOutput {}
        }
    }
}
impl UpdateAssetPropertyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssetPropertyOutput`](crate::output::UpdateAssetPropertyOutput)
    pub fn builder() -> crate::output::update_asset_property_output::Builder {
        crate::output::update_asset_property_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetModelOutput {
    /// <p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
}
impl UpdateAssetModelOutput {
    /// <p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_model_status(&self) -> std::option::Option<&crate::model::AssetModelStatus> {
        self.asset_model_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetModelOutput");
        formatter.field("asset_model_status", &self.asset_model_status);
        formatter.finish()
    }
}
/// See [`UpdateAssetModelOutput`](crate::output::UpdateAssetModelOutput)
pub mod update_asset_model_output {
    /// A builder for [`UpdateAssetModelOutput`](crate::output::UpdateAssetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
    }
    impl Builder {
        /// <p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_model_status(mut self, input: crate::model::AssetModelStatus) -> Self {
            self.asset_model_status = Some(input);
            self
        }
        /// <p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_model_status(
            mut self,
            input: std::option::Option<crate::model::AssetModelStatus>,
        ) -> Self {
            self.asset_model_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetModelOutput`](crate::output::UpdateAssetModelOutput)
        pub fn build(self) -> crate::output::UpdateAssetModelOutput {
            crate::output::UpdateAssetModelOutput {
                asset_model_status: self.asset_model_status,
            }
        }
    }
}
impl UpdateAssetModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssetModelOutput`](crate::output::UpdateAssetModelOutput)
    pub fn builder() -> crate::output::update_asset_model_output::Builder {
        crate::output::update_asset_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetOutput {
    /// <p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub asset_status: std::option::Option<crate::model::AssetStatus>,
}
impl UpdateAssetOutput {
    /// <p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.asset_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetOutput");
        formatter.field("asset_status", &self.asset_status);
        formatter.finish()
    }
}
/// See [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
pub mod update_asset_output {
    /// A builder for [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_status: std::option::Option<crate::model::AssetStatus>,
    }
    impl Builder {
        /// <p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_status(mut self, input: crate::model::AssetStatus) -> Self {
            self.asset_status = Some(input);
            self
        }
        /// <p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_status(
            mut self,
            input: std::option::Option<crate::model::AssetStatus>,
        ) -> Self {
            self.asset_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
        pub fn build(self) -> crate::output::UpdateAssetOutput {
            crate::output::UpdateAssetOutput {
                asset_status: self.asset_status,
            }
        }
    }
}
impl UpdateAssetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssetOutput`](crate::output::UpdateAssetOutput)
    pub fn builder() -> crate::output::update_asset_output::Builder {
        crate::output::update_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccessPolicyOutput {}
impl std::fmt::Debug for UpdateAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`UpdateAccessPolicyOutput`](crate::output::UpdateAccessPolicyOutput)
pub mod update_access_policy_output {
    /// A builder for [`UpdateAccessPolicyOutput`](crate::output::UpdateAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAccessPolicyOutput`](crate::output::UpdateAccessPolicyOutput)
        pub fn build(self) -> crate::output::UpdateAccessPolicyOutput {
            crate::output::UpdateAccessPolicyOutput {}
        }
    }
}
impl UpdateAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccessPolicyOutput`](crate::output::UpdateAccessPolicyOutput)
    pub fn builder() -> crate::output::update_access_policy_output::Builder {
        crate::output::update_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageConfigurationOutput {
    /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
    /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
    /// </ul>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>Contains information about the storage destination.</p>
    pub multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important> </li>
    /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub disassociated_data_storage:
        std::option::Option<crate::model::DisassociatedDataStorageState>,
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>Contains current status information for the configuration.</p>
    pub configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
}
impl PutStorageConfigurationOutput {
    /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
    /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
    /// </ul>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>Contains information about the storage destination.</p>
    pub fn multi_layer_storage(&self) -> std::option::Option<&crate::model::MultiLayerStorage> {
        self.multi_layer_storage.as_ref()
    }
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important> </li>
    /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn disassociated_data_storage(
        &self,
    ) -> std::option::Option<&crate::model::DisassociatedDataStorageState> {
        self.disassociated_data_storage.as_ref()
    }
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>Contains current status information for the configuration.</p>
    pub fn configuration_status(&self) -> std::option::Option<&crate::model::ConfigurationStatus> {
        self.configuration_status.as_ref()
    }
}
impl std::fmt::Debug for PutStorageConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageConfigurationOutput");
        formatter.field("storage_type", &self.storage_type);
        formatter.field("multi_layer_storage", &self.multi_layer_storage);
        formatter.field(
            "disassociated_data_storage",
            &self.disassociated_data_storage,
        );
        formatter.field("retention_period", &self.retention_period);
        formatter.field("configuration_status", &self.configuration_status);
        formatter.finish()
    }
}
/// See [`PutStorageConfigurationOutput`](crate::output::PutStorageConfigurationOutput)
pub mod put_storage_configuration_output {
    /// A builder for [`PutStorageConfigurationOutput`](crate::output::PutStorageConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
        pub(crate) disassociated_data_storage:
            std::option::Option<crate::model::DisassociatedDataStorageState>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
    }
    impl Builder {
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Contains information about the storage destination.</p>
        pub fn multi_layer_storage(mut self, input: crate::model::MultiLayerStorage) -> Self {
            self.multi_layer_storage = Some(input);
            self
        }
        /// <p>Contains information about the storage destination.</p>
        pub fn set_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::MultiLayerStorage>,
        ) -> Self {
            self.multi_layer_storage = input;
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn disassociated_data_storage(
            mut self,
            input: crate::model::DisassociatedDataStorageState,
        ) -> Self {
            self.disassociated_data_storage = Some(input);
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_disassociated_data_storage(
            mut self,
            input: std::option::Option<crate::model::DisassociatedDataStorageState>,
        ) -> Self {
            self.disassociated_data_storage = input;
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Contains current status information for the configuration.</p>
        pub fn configuration_status(mut self, input: crate::model::ConfigurationStatus) -> Self {
            self.configuration_status = Some(input);
            self
        }
        /// <p>Contains current status information for the configuration.</p>
        pub fn set_configuration_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationStatus>,
        ) -> Self {
            self.configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStorageConfigurationOutput`](crate::output::PutStorageConfigurationOutput)
        pub fn build(self) -> crate::output::PutStorageConfigurationOutput {
            crate::output::PutStorageConfigurationOutput {
                storage_type: self.storage_type,
                multi_layer_storage: self.multi_layer_storage,
                disassociated_data_storage: self.disassociated_data_storage,
                retention_period: self.retention_period,
                configuration_status: self.configuration_status,
            }
        }
    }
}
impl PutStorageConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutStorageConfigurationOutput`](crate::output::PutStorageConfigurationOutput)
    pub fn builder() -> crate::output::put_storage_configuration_output::Builder {
        crate::output::put_storage_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLoggingOptionsOutput {}
impl std::fmt::Debug for PutLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLoggingOptionsOutput");
        formatter.finish()
    }
}
/// See [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
pub mod put_logging_options_output {
    /// A builder for [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
        pub fn build(self) -> crate::output::PutLoggingOptionsOutput {
            crate::output::PutLoggingOptionsOutput {}
        }
    }
}
impl PutLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
    pub fn builder() -> crate::output::put_logging_options_output::Builder {
        crate::output::put_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDefaultEncryptionConfigurationOutput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>
    pub configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
}
impl PutDefaultEncryptionConfigurationOutput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>
    pub fn configuration_status(&self) -> std::option::Option<&crate::model::ConfigurationStatus> {
        self.configuration_status.as_ref()
    }
}
impl std::fmt::Debug for PutDefaultEncryptionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDefaultEncryptionConfigurationOutput");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("configuration_status", &self.configuration_status);
        formatter.finish()
    }
}
/// See [`PutDefaultEncryptionConfigurationOutput`](crate::output::PutDefaultEncryptionConfigurationOutput)
pub mod put_default_encryption_configuration_output {
    /// A builder for [`PutDefaultEncryptionConfigurationOutput`](crate::output::PutDefaultEncryptionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
    }
    impl Builder {
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>
        pub fn configuration_status(mut self, input: crate::model::ConfigurationStatus) -> Self {
            self.configuration_status = Some(input);
            self
        }
        /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>
        pub fn set_configuration_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationStatus>,
        ) -> Self {
            self.configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDefaultEncryptionConfigurationOutput`](crate::output::PutDefaultEncryptionConfigurationOutput)
        pub fn build(self) -> crate::output::PutDefaultEncryptionConfigurationOutput {
            crate::output::PutDefaultEncryptionConfigurationOutput {
                encryption_type: self.encryption_type,
                kms_key_arn: self.kms_key_arn,
                configuration_status: self.configuration_status,
            }
        }
    }
}
impl PutDefaultEncryptionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutDefaultEncryptionConfigurationOutput`](crate::output::PutDefaultEncryptionConfigurationOutput)
    pub fn builder() -> crate::output::put_default_encryption_configuration_output::Builder {
        crate::output::put_default_encryption_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTimeSeriesOutput {
    /// <p>One or more time series summaries to list.</p>
    pub time_series_summaries: std::option::Option<std::vec::Vec<crate::model::TimeSeriesSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTimeSeriesOutput {
    /// <p>One or more time series summaries to list.</p>
    pub fn time_series_summaries(&self) -> std::option::Option<&[crate::model::TimeSeriesSummary]> {
        self.time_series_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTimeSeriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTimeSeriesOutput");
        formatter.field("time_series_summaries", &self.time_series_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTimeSeriesOutput`](crate::output::ListTimeSeriesOutput)
pub mod list_time_series_output {
    /// A builder for [`ListTimeSeriesOutput`](crate::output::ListTimeSeriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_series_summaries:
            std::option::Option<std::vec::Vec<crate::model::TimeSeriesSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `time_series_summaries`.
        ///
        /// To override the contents of this collection use [`set_time_series_summaries`](Self::set_time_series_summaries).
        ///
        /// <p>One or more time series summaries to list.</p>
        pub fn time_series_summaries(mut self, input: crate::model::TimeSeriesSummary) -> Self {
            let mut v = self.time_series_summaries.unwrap_or_default();
            v.push(input);
            self.time_series_summaries = Some(v);
            self
        }
        /// <p>One or more time series summaries to list.</p>
        pub fn set_time_series_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimeSeriesSummary>>,
        ) -> Self {
            self.time_series_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTimeSeriesOutput`](crate::output::ListTimeSeriesOutput)
        pub fn build(self) -> crate::output::ListTimeSeriesOutput {
            crate::output::ListTimeSeriesOutput {
                time_series_summaries: self.time_series_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTimeSeriesOutput {
    /// Creates a new builder-style object to manufacture [`ListTimeSeriesOutput`](crate::output::ListTimeSeriesOutput)
    pub fn builder() -> crate::output::list_time_series_output::Builder {
        crate::output::list_time_series_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>A list that summarizes each project in the portal.</p>
    pub project_summaries: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>A list that summarizes each project in the portal.</p>
    pub fn project_summaries(&self) -> std::option::Option<&[crate::model::ProjectSummary]> {
        self.project_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("project_summaries", &self.project_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_summaries:
            std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `project_summaries`.
        ///
        /// To override the contents of this collection use [`set_project_summaries`](Self::set_project_summaries).
        ///
        /// <p>A list that summarizes each project in the portal.</p>
        pub fn project_summaries(mut self, input: crate::model::ProjectSummary) -> Self {
            let mut v = self.project_summaries.unwrap_or_default();
            v.push(input);
            self.project_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each project in the portal.</p>
        pub fn set_project_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        ) -> Self {
            self.project_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                project_summaries: self.project_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectAssetsOutput {
    /// <p>A list that contains the IDs of each asset associated with the project.</p>
    pub asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectAssetsOutput {
    /// <p>A list that contains the IDs of each asset associated with the project.</p>
    pub fn asset_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.asset_ids.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectAssetsOutput");
        formatter.field("asset_ids", &self.asset_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectAssetsOutput`](crate::output::ListProjectAssetsOutput)
pub mod list_project_assets_output {
    /// A builder for [`ListProjectAssetsOutput`](crate::output::ListProjectAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_ids`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>A list that contains the IDs of each asset associated with the project.</p>
        pub fn asset_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.asset_ids.unwrap_or_default();
            v.push(input.into());
            self.asset_ids = Some(v);
            self
        }
        /// <p>A list that contains the IDs of each asset associated with the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.asset_ids = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectAssetsOutput`](crate::output::ListProjectAssetsOutput)
        pub fn build(self) -> crate::output::ListProjectAssetsOutput {
            crate::output::ListProjectAssetsOutput {
                asset_ids: self.asset_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectAssetsOutput`](crate::output::ListProjectAssetsOutput)
    pub fn builder() -> crate::output::list_project_assets_output::Builder {
        crate::output::list_project_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortalsOutput {
    /// <p>A list that summarizes each portal.</p>
    pub portal_summaries: std::option::Option<std::vec::Vec<crate::model::PortalSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPortalsOutput {
    /// <p>A list that summarizes each portal.</p>
    pub fn portal_summaries(&self) -> std::option::Option<&[crate::model::PortalSummary]> {
        self.portal_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPortalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortalsOutput");
        formatter.field("portal_summaries", &self.portal_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPortalsOutput`](crate::output::ListPortalsOutput)
pub mod list_portals_output {
    /// A builder for [`ListPortalsOutput`](crate::output::ListPortalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_summaries:
            std::option::Option<std::vec::Vec<crate::model::PortalSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `portal_summaries`.
        ///
        /// To override the contents of this collection use [`set_portal_summaries`](Self::set_portal_summaries).
        ///
        /// <p>A list that summarizes each portal.</p>
        pub fn portal_summaries(mut self, input: crate::model::PortalSummary) -> Self {
            let mut v = self.portal_summaries.unwrap_or_default();
            v.push(input);
            self.portal_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each portal.</p>
        pub fn set_portal_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortalSummary>>,
        ) -> Self {
            self.portal_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortalsOutput`](crate::output::ListPortalsOutput)
        pub fn build(self) -> crate::output::ListPortalsOutput {
            crate::output::ListPortalsOutput {
                portal_summaries: self.portal_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPortalsOutput {
    /// Creates a new builder-style object to manufacture [`ListPortalsOutput`](crate::output::ListPortalsOutput)
    pub fn builder() -> crate::output::list_portals_output::Builder {
        crate::output::list_portals_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysOutput {
    /// <p>A list that summarizes each gateway.</p>
    pub gateway_summaries: std::option::Option<std::vec::Vec<crate::model::GatewaySummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGatewaysOutput {
    /// <p>A list that summarizes each gateway.</p>
    pub fn gateway_summaries(&self) -> std::option::Option<&[crate::model::GatewaySummary]> {
        self.gateway_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGatewaysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysOutput");
        formatter.field("gateway_summaries", &self.gateway_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
pub mod list_gateways_output {
    /// A builder for [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_summaries:
            std::option::Option<std::vec::Vec<crate::model::GatewaySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `gateway_summaries`.
        ///
        /// To override the contents of this collection use [`set_gateway_summaries`](Self::set_gateway_summaries).
        ///
        /// <p>A list that summarizes each gateway.</p>
        pub fn gateway_summaries(mut self, input: crate::model::GatewaySummary) -> Self {
            let mut v = self.gateway_summaries.unwrap_or_default();
            v.push(input);
            self.gateway_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each gateway.</p>
        pub fn set_gateway_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewaySummary>>,
        ) -> Self {
            self.gateway_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
        pub fn build(self) -> crate::output::ListGatewaysOutput {
            crate::output::ListGatewaysOutput {
                gateway_summaries: self.gateway_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGatewaysOutput {
    /// Creates a new builder-style object to manufacture [`ListGatewaysOutput`](crate::output::ListGatewaysOutput)
    pub fn builder() -> crate::output::list_gateways_output::Builder {
        crate::output::list_gateways_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDashboardsOutput {
    /// <p>A list that summarizes each dashboard in the project.</p>
    pub dashboard_summaries: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDashboardsOutput {
    /// <p>A list that summarizes each dashboard in the project.</p>
    pub fn dashboard_summaries(&self) -> std::option::Option<&[crate::model::DashboardSummary]> {
        self.dashboard_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDashboardsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDashboardsOutput");
        formatter.field("dashboard_summaries", &self.dashboard_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
pub mod list_dashboards_output {
    /// A builder for [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_summaries:
            std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dashboard_summaries`.
        ///
        /// To override the contents of this collection use [`set_dashboard_summaries`](Self::set_dashboard_summaries).
        ///
        /// <p>A list that summarizes each dashboard in the project.</p>
        pub fn dashboard_summaries(mut self, input: crate::model::DashboardSummary) -> Self {
            let mut v = self.dashboard_summaries.unwrap_or_default();
            v.push(input);
            self.dashboard_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each dashboard in the project.</p>
        pub fn set_dashboard_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        ) -> Self {
            self.dashboard_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
        pub fn build(self) -> crate::output::ListDashboardsOutput {
            crate::output::ListDashboardsOutput {
                dashboard_summaries: self.dashboard_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDashboardsOutput {
    /// Creates a new builder-style object to manufacture [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
    pub fn builder() -> crate::output::list_dashboards_output::Builder {
        crate::output::list_dashboards_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedAssetsOutput {
    /// <p>A list that summarizes the associated assets.</p>
    pub asset_summaries: std::option::Option<std::vec::Vec<crate::model::AssociatedAssetsSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedAssetsOutput {
    /// <p>A list that summarizes the associated assets.</p>
    pub fn asset_summaries(&self) -> std::option::Option<&[crate::model::AssociatedAssetsSummary]> {
        self.asset_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedAssetsOutput");
        formatter.field("asset_summaries", &self.asset_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedAssetsOutput`](crate::output::ListAssociatedAssetsOutput)
pub mod list_associated_assets_output {
    /// A builder for [`ListAssociatedAssetsOutput`](crate::output::ListAssociatedAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssociatedAssetsSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_summaries`.
        ///
        /// To override the contents of this collection use [`set_asset_summaries`](Self::set_asset_summaries).
        ///
        /// <p>A list that summarizes the associated assets.</p>
        pub fn asset_summaries(mut self, input: crate::model::AssociatedAssetsSummary) -> Self {
            let mut v = self.asset_summaries.unwrap_or_default();
            v.push(input);
            self.asset_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes the associated assets.</p>
        pub fn set_asset_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociatedAssetsSummary>>,
        ) -> Self {
            self.asset_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedAssetsOutput`](crate::output::ListAssociatedAssetsOutput)
        pub fn build(self) -> crate::output::ListAssociatedAssetsOutput {
            crate::output::ListAssociatedAssetsOutput {
                asset_summaries: self.asset_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedAssetsOutput`](crate::output::ListAssociatedAssetsOutput)
    pub fn builder() -> crate::output::list_associated_assets_output::Builder {
        crate::output::list_associated_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetsOutput {
    /// <p>A list that summarizes each asset.</p>
    pub asset_summaries: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssetsOutput {
    /// <p>A list that summarizes each asset.</p>
    pub fn asset_summaries(&self) -> std::option::Option<&[crate::model::AssetSummary]> {
        self.asset_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetsOutput");
        formatter.field("asset_summaries", &self.asset_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssetsOutput`](crate::output::ListAssetsOutput)
pub mod list_assets_output {
    /// A builder for [`ListAssetsOutput`](crate::output::ListAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_summaries: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_summaries`.
        ///
        /// To override the contents of this collection use [`set_asset_summaries`](Self::set_asset_summaries).
        ///
        /// <p>A list that summarizes each asset.</p>
        pub fn asset_summaries(mut self, input: crate::model::AssetSummary) -> Self {
            let mut v = self.asset_summaries.unwrap_or_default();
            v.push(input);
            self.asset_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each asset.</p>
        pub fn set_asset_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
        ) -> Self {
            self.asset_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetsOutput`](crate::output::ListAssetsOutput)
        pub fn build(self) -> crate::output::ListAssetsOutput {
            crate::output::ListAssetsOutput {
                asset_summaries: self.asset_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssetsOutput`](crate::output::ListAssetsOutput)
    pub fn builder() -> crate::output::list_assets_output::Builder {
        crate::output::list_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetRelationshipsOutput {
    /// <p>A list that summarizes each asset relationship.</p>
    pub asset_relationship_summaries:
        std::option::Option<std::vec::Vec<crate::model::AssetRelationshipSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssetRelationshipsOutput {
    /// <p>A list that summarizes each asset relationship.</p>
    pub fn asset_relationship_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AssetRelationshipSummary]> {
        self.asset_relationship_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssetRelationshipsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetRelationshipsOutput");
        formatter.field(
            "asset_relationship_summaries",
            &self.asset_relationship_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssetRelationshipsOutput`](crate::output::ListAssetRelationshipsOutput)
pub mod list_asset_relationships_output {
    /// A builder for [`ListAssetRelationshipsOutput`](crate::output::ListAssetRelationshipsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_relationship_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssetRelationshipSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_relationship_summaries`.
        ///
        /// To override the contents of this collection use [`set_asset_relationship_summaries`](Self::set_asset_relationship_summaries).
        ///
        /// <p>A list that summarizes each asset relationship.</p>
        pub fn asset_relationship_summaries(
            mut self,
            input: crate::model::AssetRelationshipSummary,
        ) -> Self {
            let mut v = self.asset_relationship_summaries.unwrap_or_default();
            v.push(input);
            self.asset_relationship_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each asset relationship.</p>
        pub fn set_asset_relationship_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetRelationshipSummary>>,
        ) -> Self {
            self.asset_relationship_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetRelationshipsOutput`](crate::output::ListAssetRelationshipsOutput)
        pub fn build(self) -> crate::output::ListAssetRelationshipsOutput {
            crate::output::ListAssetRelationshipsOutput {
                asset_relationship_summaries: self.asset_relationship_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssetRelationshipsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssetRelationshipsOutput`](crate::output::ListAssetRelationshipsOutput)
    pub fn builder() -> crate::output::list_asset_relationships_output::Builder {
        crate::output::list_asset_relationships_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetModelsOutput {
    /// <p>A list that summarizes each asset model.</p>
    pub asset_model_summaries: std::option::Option<std::vec::Vec<crate::model::AssetModelSummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssetModelsOutput {
    /// <p>A list that summarizes each asset model.</p>
    pub fn asset_model_summaries(&self) -> std::option::Option<&[crate::model::AssetModelSummary]> {
        self.asset_model_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssetModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetModelsOutput");
        formatter.field("asset_model_summaries", &self.asset_model_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssetModelsOutput`](crate::output::ListAssetModelsOutput)
pub mod list_asset_models_output {
    /// A builder for [`ListAssetModelsOutput`](crate::output::ListAssetModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssetModelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_model_summaries`.
        ///
        /// To override the contents of this collection use [`set_asset_model_summaries`](Self::set_asset_model_summaries).
        ///
        /// <p>A list that summarizes each asset model.</p>
        pub fn asset_model_summaries(mut self, input: crate::model::AssetModelSummary) -> Self {
            let mut v = self.asset_model_summaries.unwrap_or_default();
            v.push(input);
            self.asset_model_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each asset model.</p>
        pub fn set_asset_model_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelSummary>>,
        ) -> Self {
            self.asset_model_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetModelsOutput`](crate::output::ListAssetModelsOutput)
        pub fn build(self) -> crate::output::ListAssetModelsOutput {
            crate::output::ListAssetModelsOutput {
                asset_model_summaries: self.asset_model_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssetModelsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssetModelsOutput`](crate::output::ListAssetModelsOutput)
    pub fn builder() -> crate::output::list_asset_models_output::Builder {
        crate::output::list_asset_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPoliciesOutput {
    /// <p>A list that summarizes each access policy.</p>
    pub access_policy_summaries:
        std::option::Option<std::vec::Vec<crate::model::AccessPolicySummary>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccessPoliciesOutput {
    /// <p>A list that summarizes each access policy.</p>
    pub fn access_policy_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AccessPolicySummary]> {
        self.access_policy_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccessPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPoliciesOutput");
        formatter.field("access_policy_summaries", &self.access_policy_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccessPoliciesOutput`](crate::output::ListAccessPoliciesOutput)
pub mod list_access_policies_output {
    /// A builder for [`ListAccessPoliciesOutput`](crate::output::ListAccessPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_summaries:
            std::option::Option<std::vec::Vec<crate::model::AccessPolicySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_policy_summaries`.
        ///
        /// To override the contents of this collection use [`set_access_policy_summaries`](Self::set_access_policy_summaries).
        ///
        /// <p>A list that summarizes each access policy.</p>
        pub fn access_policy_summaries(mut self, input: crate::model::AccessPolicySummary) -> Self {
            let mut v = self.access_policy_summaries.unwrap_or_default();
            v.push(input);
            self.access_policy_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each access policy.</p>
        pub fn set_access_policy_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessPolicySummary>>,
        ) -> Self {
            self.access_policy_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPoliciesOutput`](crate::output::ListAccessPoliciesOutput)
        pub fn build(self) -> crate::output::ListAccessPoliciesOutput {
            crate::output::ListAccessPoliciesOutput {
                access_policy_summaries: self.access_policy_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccessPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessPoliciesOutput`](crate::output::ListAccessPoliciesOutput)
    pub fn builder() -> crate::output::list_access_policies_output::Builder {
        crate::output::list_access_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInterpolatedAssetPropertyValuesOutput {
    /// <p>The requested interpolated values.</p>
    pub interpolated_asset_property_values:
        std::option::Option<std::vec::Vec<crate::model::InterpolatedAssetPropertyValue>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInterpolatedAssetPropertyValuesOutput {
    /// <p>The requested interpolated values.</p>
    pub fn interpolated_asset_property_values(
        &self,
    ) -> std::option::Option<&[crate::model::InterpolatedAssetPropertyValue]> {
        self.interpolated_asset_property_values.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInterpolatedAssetPropertyValuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInterpolatedAssetPropertyValuesOutput");
        formatter.field(
            "interpolated_asset_property_values",
            &self.interpolated_asset_property_values,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInterpolatedAssetPropertyValuesOutput`](crate::output::GetInterpolatedAssetPropertyValuesOutput)
pub mod get_interpolated_asset_property_values_output {
    /// A builder for [`GetInterpolatedAssetPropertyValuesOutput`](crate::output::GetInterpolatedAssetPropertyValuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interpolated_asset_property_values:
            std::option::Option<std::vec::Vec<crate::model::InterpolatedAssetPropertyValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `interpolated_asset_property_values`.
        ///
        /// To override the contents of this collection use [`set_interpolated_asset_property_values`](Self::set_interpolated_asset_property_values).
        ///
        /// <p>The requested interpolated values.</p>
        pub fn interpolated_asset_property_values(
            mut self,
            input: crate::model::InterpolatedAssetPropertyValue,
        ) -> Self {
            let mut v = self.interpolated_asset_property_values.unwrap_or_default();
            v.push(input);
            self.interpolated_asset_property_values = Some(v);
            self
        }
        /// <p>The requested interpolated values.</p>
        pub fn set_interpolated_asset_property_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InterpolatedAssetPropertyValue>>,
        ) -> Self {
            self.interpolated_asset_property_values = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInterpolatedAssetPropertyValuesOutput`](crate::output::GetInterpolatedAssetPropertyValuesOutput)
        pub fn build(self) -> crate::output::GetInterpolatedAssetPropertyValuesOutput {
            crate::output::GetInterpolatedAssetPropertyValuesOutput {
                interpolated_asset_property_values: self.interpolated_asset_property_values,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInterpolatedAssetPropertyValuesOutput {
    /// Creates a new builder-style object to manufacture [`GetInterpolatedAssetPropertyValuesOutput`](crate::output::GetInterpolatedAssetPropertyValuesOutput)
    pub fn builder() -> crate::output::get_interpolated_asset_property_values_output::Builder {
        crate::output::get_interpolated_asset_property_values_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyValueHistoryOutput {
    /// <p>The asset property's value history.</p>
    pub asset_property_value_history:
        std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAssetPropertyValueHistoryOutput {
    /// <p>The asset property's value history.</p>
    pub fn asset_property_value_history(
        &self,
    ) -> std::option::Option<&[crate::model::AssetPropertyValue]> {
        self.asset_property_value_history.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAssetPropertyValueHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyValueHistoryOutput");
        formatter.field(
            "asset_property_value_history",
            &self.asset_property_value_history,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetAssetPropertyValueHistoryOutput`](crate::output::GetAssetPropertyValueHistoryOutput)
pub mod get_asset_property_value_history_output {
    /// A builder for [`GetAssetPropertyValueHistoryOutput`](crate::output::GetAssetPropertyValueHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_property_value_history:
            std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `asset_property_value_history`.
        ///
        /// To override the contents of this collection use [`set_asset_property_value_history`](Self::set_asset_property_value_history).
        ///
        /// <p>The asset property's value history.</p>
        pub fn asset_property_value_history(
            mut self,
            input: crate::model::AssetPropertyValue,
        ) -> Self {
            let mut v = self.asset_property_value_history.unwrap_or_default();
            v.push(input);
            self.asset_property_value_history = Some(v);
            self
        }
        /// <p>The asset property's value history.</p>
        pub fn set_asset_property_value_history(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
        ) -> Self {
            self.asset_property_value_history = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyValueHistoryOutput`](crate::output::GetAssetPropertyValueHistoryOutput)
        pub fn build(self) -> crate::output::GetAssetPropertyValueHistoryOutput {
            crate::output::GetAssetPropertyValueHistoryOutput {
                asset_property_value_history: self.asset_property_value_history,
                next_token: self.next_token,
            }
        }
    }
}
impl GetAssetPropertyValueHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueHistoryOutput`](crate::output::GetAssetPropertyValueHistoryOutput)
    pub fn builder() -> crate::output::get_asset_property_value_history_output::Builder {
        crate::output::get_asset_property_value_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyValueOutput {
    /// <p>The current asset property value.</p>
    pub property_value: std::option::Option<crate::model::AssetPropertyValue>,
}
impl GetAssetPropertyValueOutput {
    /// <p>The current asset property value.</p>
    pub fn property_value(&self) -> std::option::Option<&crate::model::AssetPropertyValue> {
        self.property_value.as_ref()
    }
}
impl std::fmt::Debug for GetAssetPropertyValueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyValueOutput");
        formatter.field("property_value", &self.property_value);
        formatter.finish()
    }
}
/// See [`GetAssetPropertyValueOutput`](crate::output::GetAssetPropertyValueOutput)
pub mod get_asset_property_value_output {
    /// A builder for [`GetAssetPropertyValueOutput`](crate::output::GetAssetPropertyValueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_value: std::option::Option<crate::model::AssetPropertyValue>,
    }
    impl Builder {
        /// <p>The current asset property value.</p>
        pub fn property_value(mut self, input: crate::model::AssetPropertyValue) -> Self {
            self.property_value = Some(input);
            self
        }
        /// <p>The current asset property value.</p>
        pub fn set_property_value(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyValue>,
        ) -> Self {
            self.property_value = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyValueOutput`](crate::output::GetAssetPropertyValueOutput)
        pub fn build(self) -> crate::output::GetAssetPropertyValueOutput {
            crate::output::GetAssetPropertyValueOutput {
                property_value: self.property_value,
            }
        }
    }
}
impl GetAssetPropertyValueOutput {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueOutput`](crate::output::GetAssetPropertyValueOutput)
    pub fn builder() -> crate::output::get_asset_property_value_output::Builder {
        crate::output::get_asset_property_value_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyAggregatesOutput {
    /// <p>The requested aggregated values.</p>
    pub aggregated_values: std::option::Option<std::vec::Vec<crate::model::AggregatedValue>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAssetPropertyAggregatesOutput {
    /// <p>The requested aggregated values.</p>
    pub fn aggregated_values(&self) -> std::option::Option<&[crate::model::AggregatedValue]> {
        self.aggregated_values.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAssetPropertyAggregatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyAggregatesOutput");
        formatter.field("aggregated_values", &self.aggregated_values);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetAssetPropertyAggregatesOutput`](crate::output::GetAssetPropertyAggregatesOutput)
pub mod get_asset_property_aggregates_output {
    /// A builder for [`GetAssetPropertyAggregatesOutput`](crate::output::GetAssetPropertyAggregatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregated_values:
            std::option::Option<std::vec::Vec<crate::model::AggregatedValue>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `aggregated_values`.
        ///
        /// To override the contents of this collection use [`set_aggregated_values`](Self::set_aggregated_values).
        ///
        /// <p>The requested aggregated values.</p>
        pub fn aggregated_values(mut self, input: crate::model::AggregatedValue) -> Self {
            let mut v = self.aggregated_values.unwrap_or_default();
            v.push(input);
            self.aggregated_values = Some(v);
            self
        }
        /// <p>The requested aggregated values.</p>
        pub fn set_aggregated_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedValue>>,
        ) -> Self {
            self.aggregated_values = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyAggregatesOutput`](crate::output::GetAssetPropertyAggregatesOutput)
        pub fn build(self) -> crate::output::GetAssetPropertyAggregatesOutput {
            crate::output::GetAssetPropertyAggregatesOutput {
                aggregated_values: self.aggregated_values,
                next_token: self.next_token,
            }
        }
    }
}
impl GetAssetPropertyAggregatesOutput {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyAggregatesOutput`](crate::output::GetAssetPropertyAggregatesOutput)
    pub fn builder() -> crate::output::get_asset_property_aggregates_output::Builder {
        crate::output::get_asset_property_aggregates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTimeSeriesFromAssetPropertyOutput {}
impl std::fmt::Debug for DisassociateTimeSeriesFromAssetPropertyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTimeSeriesFromAssetPropertyOutput");
        formatter.finish()
    }
}
/// See [`DisassociateTimeSeriesFromAssetPropertyOutput`](crate::output::DisassociateTimeSeriesFromAssetPropertyOutput)
pub mod disassociate_time_series_from_asset_property_output {
    /// A builder for [`DisassociateTimeSeriesFromAssetPropertyOutput`](crate::output::DisassociateTimeSeriesFromAssetPropertyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateTimeSeriesFromAssetPropertyOutput`](crate::output::DisassociateTimeSeriesFromAssetPropertyOutput)
        pub fn build(self) -> crate::output::DisassociateTimeSeriesFromAssetPropertyOutput {
            crate::output::DisassociateTimeSeriesFromAssetPropertyOutput {}
        }
    }
}
impl DisassociateTimeSeriesFromAssetPropertyOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTimeSeriesFromAssetPropertyOutput`](crate::output::DisassociateTimeSeriesFromAssetPropertyOutput)
    pub fn builder() -> crate::output::disassociate_time_series_from_asset_property_output::Builder
    {
        crate::output::disassociate_time_series_from_asset_property_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAssetsOutput {}
impl std::fmt::Debug for DisassociateAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAssetsOutput");
        formatter.finish()
    }
}
/// See [`DisassociateAssetsOutput`](crate::output::DisassociateAssetsOutput)
pub mod disassociate_assets_output {
    /// A builder for [`DisassociateAssetsOutput`](crate::output::DisassociateAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateAssetsOutput`](crate::output::DisassociateAssetsOutput)
        pub fn build(self) -> crate::output::DisassociateAssetsOutput {
            crate::output::DisassociateAssetsOutput {}
        }
    }
}
impl DisassociateAssetsOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateAssetsOutput`](crate::output::DisassociateAssetsOutput)
    pub fn builder() -> crate::output::disassociate_assets_output::Builder {
        crate::output::disassociate_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTimeSeriesOutput {
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the time series.</p>
    pub time_series_id: std::option::Option<std::string::String>,
    /// <p>The data type of the time series.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub data_type_spec: std::option::Option<std::string::String>,
    /// <p>The date that the time series was created, in Unix epoch time.</p>
    pub time_series_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the time series was last updated, in Unix epoch time.</p>
    pub time_series_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeTimeSeriesOutput {
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the time series.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
    /// <p>The data type of the time series.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub fn data_type_spec(&self) -> std::option::Option<&str> {
        self.data_type_spec.as_deref()
    }
    /// <p>The date that the time series was created, in Unix epoch time.</p>
    pub fn time_series_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_series_creation_date.as_ref()
    }
    /// <p>The date that the time series was last updated, in Unix epoch time.</p>
    pub fn time_series_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_series_last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeTimeSeriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTimeSeriesOutput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("alias", &self.alias);
        formatter.field("time_series_id", &self.time_series_id);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_type_spec", &self.data_type_spec);
        formatter.field("time_series_creation_date", &self.time_series_creation_date);
        formatter.field(
            "time_series_last_update_date",
            &self.time_series_last_update_date,
        );
        formatter.finish()
    }
}
/// See [`DescribeTimeSeriesOutput`](crate::output::DescribeTimeSeriesOutput)
pub mod describe_time_series_output {
    /// A builder for [`DescribeTimeSeriesOutput`](crate::output::DescribeTimeSeriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) time_series_id: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) data_type_spec: std::option::Option<std::string::String>,
        pub(crate) time_series_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_series_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the time series.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the time series.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// <p>The data type of the time series.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the time series.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn data_type_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type_spec = Some(input.into());
            self
        }
        /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn set_data_type_spec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_type_spec = input;
            self
        }
        /// <p>The date that the time series was created, in Unix epoch time.</p>
        pub fn time_series_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_series_creation_date = Some(input);
            self
        }
        /// <p>The date that the time series was created, in Unix epoch time.</p>
        pub fn set_time_series_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_series_creation_date = input;
            self
        }
        /// <p>The date that the time series was last updated, in Unix epoch time.</p>
        pub fn time_series_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_series_last_update_date = Some(input);
            self
        }
        /// <p>The date that the time series was last updated, in Unix epoch time.</p>
        pub fn set_time_series_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_series_last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTimeSeriesOutput`](crate::output::DescribeTimeSeriesOutput)
        pub fn build(self) -> crate::output::DescribeTimeSeriesOutput {
            crate::output::DescribeTimeSeriesOutput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                alias: self.alias,
                time_series_id: self.time_series_id,
                data_type: self.data_type,
                data_type_spec: self.data_type_spec,
                time_series_creation_date: self.time_series_creation_date,
                time_series_last_update_date: self.time_series_last_update_date,
            }
        }
    }
}
impl DescribeTimeSeriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTimeSeriesOutput`](crate::output::DescribeTimeSeriesOutput)
    pub fn builder() -> crate::output::describe_time_series_output::Builder {
        crate::output::describe_time_series_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorageConfigurationOutput {
    /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
    /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
    /// </ul>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>Contains information about the storage destination.</p>
    pub multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important> </li>
    /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub disassociated_data_storage:
        std::option::Option<crate::model::DisassociatedDataStorageState>,
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>Contains current status information for the configuration.</p>
    pub configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
    /// <p>The date the storage configuration was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeStorageConfigurationOutput {
    /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
    /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
    /// </ul>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>Contains information about the storage destination.</p>
    pub fn multi_layer_storage(&self) -> std::option::Option<&crate::model::MultiLayerStorage> {
        self.multi_layer_storage.as_ref()
    }
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important> </li>
    /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn disassociated_data_storage(
        &self,
    ) -> std::option::Option<&crate::model::DisassociatedDataStorageState> {
        self.disassociated_data_storage.as_ref()
    }
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>Contains current status information for the configuration.</p>
    pub fn configuration_status(&self) -> std::option::Option<&crate::model::ConfigurationStatus> {
        self.configuration_status.as_ref()
    }
    /// <p>The date the storage configuration was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeStorageConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorageConfigurationOutput");
        formatter.field("storage_type", &self.storage_type);
        formatter.field("multi_layer_storage", &self.multi_layer_storage);
        formatter.field(
            "disassociated_data_storage",
            &self.disassociated_data_storage,
        );
        formatter.field("retention_period", &self.retention_period);
        formatter.field("configuration_status", &self.configuration_status);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`DescribeStorageConfigurationOutput`](crate::output::DescribeStorageConfigurationOutput)
pub mod describe_storage_configuration_output {
    /// A builder for [`DescribeStorageConfigurationOutput`](crate::output::DescribeStorageConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
        pub(crate) disassociated_data_storage:
            std::option::Option<crate::model::DisassociatedDataStorageState>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Contains information about the storage destination.</p>
        pub fn multi_layer_storage(mut self, input: crate::model::MultiLayerStorage) -> Self {
            self.multi_layer_storage = Some(input);
            self
        }
        /// <p>Contains information about the storage destination.</p>
        pub fn set_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::MultiLayerStorage>,
        ) -> Self {
            self.multi_layer_storage = input;
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn disassociated_data_storage(
            mut self,
            input: crate::model::DisassociatedDataStorageState,
        ) -> Self {
            self.disassociated_data_storage = Some(input);
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_disassociated_data_storage(
            mut self,
            input: std::option::Option<crate::model::DisassociatedDataStorageState>,
        ) -> Self {
            self.disassociated_data_storage = input;
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Contains current status information for the configuration.</p>
        pub fn configuration_status(mut self, input: crate::model::ConfigurationStatus) -> Self {
            self.configuration_status = Some(input);
            self
        }
        /// <p>Contains current status information for the configuration.</p>
        pub fn set_configuration_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationStatus>,
        ) -> Self {
            self.configuration_status = input;
            self
        }
        /// <p>The date the storage configuration was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the storage configuration was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorageConfigurationOutput`](crate::output::DescribeStorageConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeStorageConfigurationOutput {
            crate::output::DescribeStorageConfigurationOutput {
                storage_type: self.storage_type,
                multi_layer_storage: self.multi_layer_storage,
                disassociated_data_storage: self.disassociated_data_storage,
                retention_period: self.retention_period,
                configuration_status: self.configuration_status,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl DescribeStorageConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStorageConfigurationOutput`](crate::output::DescribeStorageConfigurationOutput)
    pub fn builder() -> crate::output::describe_storage_configuration_output::Builder {
        crate::output::describe_storage_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectOutput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The ID of the portal that the project is in.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>The project's description.</p>
    pub project_description: std::option::Option<std::string::String>,
    /// <p>The date the project was created, in Unix epoch time.</p>
    pub project_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the project was last updated, in Unix epoch time.</p>
    pub project_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeProjectOutput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The ID of the portal that the project is in.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>The project's description.</p>
    pub fn project_description(&self) -> std::option::Option<&str> {
        self.project_description.as_deref()
    }
    /// <p>The date the project was created, in Unix epoch time.</p>
    pub fn project_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.project_creation_date.as_ref()
    }
    /// <p>The date the project was last updated, in Unix epoch time.</p>
    pub fn project_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.project_last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectOutput");
        formatter.field("project_id", &self.project_id);
        formatter.field("project_arn", &self.project_arn);
        formatter.field("project_name", &self.project_name);
        formatter.field("portal_id", &self.portal_id);
        formatter.field("project_description", &self.project_description);
        formatter.field("project_creation_date", &self.project_creation_date);
        formatter.field("project_last_update_date", &self.project_last_update_date);
        formatter.finish()
    }
}
/// See [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
pub mod describe_project_output {
    /// A builder for [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) project_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) project_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The ID of the portal that the project is in.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal that the project is in.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>The project's description.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>The project's description.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>The date the project was created, in Unix epoch time.</p>
        pub fn project_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.project_creation_date = Some(input);
            self
        }
        /// <p>The date the project was created, in Unix epoch time.</p>
        pub fn set_project_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.project_creation_date = input;
            self
        }
        /// <p>The date the project was last updated, in Unix epoch time.</p>
        pub fn project_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.project_last_update_date = Some(input);
            self
        }
        /// <p>The date the project was last updated, in Unix epoch time.</p>
        pub fn set_project_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.project_last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
        pub fn build(self) -> crate::output::DescribeProjectOutput {
            crate::output::DescribeProjectOutput {
                project_id: self.project_id,
                project_arn: self.project_arn,
                project_name: self.project_name,
                portal_id: self.portal_id,
                project_description: self.project_description,
                project_creation_date: self.project_creation_date,
                project_last_update_date: self.project_last_update_date,
            }
        }
    }
}
impl DescribeProjectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    pub fn builder() -> crate::output::describe_project_output::Builder {
        crate::output::describe_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortalOutput {
    /// <p>The ID of the portal.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The name of the portal.</p>
    pub portal_name: std::option::Option<std::string::String>,
    /// <p>The portal's description.</p>
    pub portal_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes <code>portalClientId</code> for only portals that use Amazon Web Services SSO to authenticate users.</p>
    pub portal_client_id: std::option::Option<std::string::String>,
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub portal_start_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub portal_contact_email: std::option::Option<std::string::String>,
    /// <p>The current status of the portal, which contains a state and any error message.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
    /// <p>The date the portal was created, in Unix epoch time.</p>
    pub portal_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the portal was last updated, in Unix epoch time.</p>
    pub portal_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The portal's logo image, which is available at a URL.</p>
    pub portal_logo_image_location: std::option::Option<crate::model::ImageLocation>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The service to use to authenticate users to the portal.</p>
    pub portal_auth_mode: std::option::Option<crate::model::AuthMode>,
    /// <p>The email address that sends alarm notifications.</p>
    pub notification_sender_email: std::option::Option<std::string::String>,
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>
    pub alarms: std::option::Option<crate::model::Alarms>,
}
impl DescribePortalOutput {
    /// <p>The ID of the portal.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The name of the portal.</p>
    pub fn portal_name(&self) -> std::option::Option<&str> {
        self.portal_name.as_deref()
    }
    /// <p>The portal's description.</p>
    pub fn portal_description(&self) -> std::option::Option<&str> {
        self.portal_description.as_deref()
    }
    /// <p>The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes <code>portalClientId</code> for only portals that use Amazon Web Services SSO to authenticate users.</p>
    pub fn portal_client_id(&self) -> std::option::Option<&str> {
        self.portal_client_id.as_deref()
    }
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub fn portal_start_url(&self) -> std::option::Option<&str> {
        self.portal_start_url.as_deref()
    }
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub fn portal_contact_email(&self) -> std::option::Option<&str> {
        self.portal_contact_email.as_deref()
    }
    /// <p>The current status of the portal, which contains a state and any error message.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
    /// <p>The date the portal was created, in Unix epoch time.</p>
    pub fn portal_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.portal_creation_date.as_ref()
    }
    /// <p>The date the portal was last updated, in Unix epoch time.</p>
    pub fn portal_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.portal_last_update_date.as_ref()
    }
    /// <p>The portal's logo image, which is available at a URL.</p>
    pub fn portal_logo_image_location(&self) -> std::option::Option<&crate::model::ImageLocation> {
        self.portal_logo_image_location.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The service to use to authenticate users to the portal.</p>
    pub fn portal_auth_mode(&self) -> std::option::Option<&crate::model::AuthMode> {
        self.portal_auth_mode.as_ref()
    }
    /// <p>The email address that sends alarm notifications.</p>
    pub fn notification_sender_email(&self) -> std::option::Option<&str> {
        self.notification_sender_email.as_deref()
    }
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>
    pub fn alarms(&self) -> std::option::Option<&crate::model::Alarms> {
        self.alarms.as_ref()
    }
}
impl std::fmt::Debug for DescribePortalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortalOutput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("portal_name", &self.portal_name);
        formatter.field("portal_description", &self.portal_description);
        formatter.field("portal_client_id", &self.portal_client_id);
        formatter.field("portal_start_url", &self.portal_start_url);
        formatter.field("portal_contact_email", &self.portal_contact_email);
        formatter.field("portal_status", &self.portal_status);
        formatter.field("portal_creation_date", &self.portal_creation_date);
        formatter.field("portal_last_update_date", &self.portal_last_update_date);
        formatter.field(
            "portal_logo_image_location",
            &self.portal_logo_image_location,
        );
        formatter.field("role_arn", &self.role_arn);
        formatter.field("portal_auth_mode", &self.portal_auth_mode);
        formatter.field("notification_sender_email", &self.notification_sender_email);
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}
/// See [`DescribePortalOutput`](crate::output::DescribePortalOutput)
pub mod describe_portal_output {
    /// A builder for [`DescribePortalOutput`](crate::output::DescribePortalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) portal_name: std::option::Option<std::string::String>,
        pub(crate) portal_description: std::option::Option<std::string::String>,
        pub(crate) portal_client_id: std::option::Option<std::string::String>,
        pub(crate) portal_start_url: std::option::Option<std::string::String>,
        pub(crate) portal_contact_email: std::option::Option<std::string::String>,
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
        pub(crate) portal_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) portal_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) portal_logo_image_location: std::option::Option<crate::model::ImageLocation>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) portal_auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) notification_sender_email: std::option::Option<std::string::String>,
        pub(crate) alarms: std::option::Option<crate::model::Alarms>,
    }
    impl Builder {
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The name of the portal.</p>
        pub fn portal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_name = Some(input.into());
            self
        }
        /// <p>The name of the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_name = input;
            self
        }
        /// <p>The portal's description.</p>
        pub fn portal_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_description = Some(input.into());
            self
        }
        /// <p>The portal's description.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_description = input;
            self
        }
        /// <p>The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes <code>portalClientId</code> for only portals that use Amazon Web Services SSO to authenticate users.</p>
        pub fn portal_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_client_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes <code>portalClientId</code> for only portals that use Amazon Web Services SSO to authenticate users.</p>
        pub fn set_portal_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_client_id = input;
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn portal_start_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_start_url = Some(input.into());
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn set_portal_start_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_start_url = input;
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_contact_email = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_contact_email = input;
            self
        }
        /// <p>The current status of the portal, which contains a state and any error message.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The current status of the portal, which contains a state and any error message.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// <p>The date the portal was created, in Unix epoch time.</p>
        pub fn portal_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.portal_creation_date = Some(input);
            self
        }
        /// <p>The date the portal was created, in Unix epoch time.</p>
        pub fn set_portal_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.portal_creation_date = input;
            self
        }
        /// <p>The date the portal was last updated, in Unix epoch time.</p>
        pub fn portal_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.portal_last_update_date = Some(input);
            self
        }
        /// <p>The date the portal was last updated, in Unix epoch time.</p>
        pub fn set_portal_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.portal_last_update_date = input;
            self
        }
        /// <p>The portal's logo image, which is available at a URL.</p>
        pub fn portal_logo_image_location(mut self, input: crate::model::ImageLocation) -> Self {
            self.portal_logo_image_location = Some(input);
            self
        }
        /// <p>The portal's logo image, which is available at a URL.</p>
        pub fn set_portal_logo_image_location(
            mut self,
            input: std::option::Option<crate::model::ImageLocation>,
        ) -> Self {
            self.portal_logo_image_location = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The service to use to authenticate users to the portal.</p>
        pub fn portal_auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.portal_auth_mode = Some(input);
            self
        }
        /// <p>The service to use to authenticate users to the portal.</p>
        pub fn set_portal_auth_mode(
            mut self,
            input: std::option::Option<crate::model::AuthMode>,
        ) -> Self {
            self.portal_auth_mode = input;
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn notification_sender_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_sender_email = Some(input.into());
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_sender_email = input;
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>
        pub fn alarms(mut self, input: crate::model::Alarms) -> Self {
            self.alarms = Some(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortalOutput`](crate::output::DescribePortalOutput)
        pub fn build(self) -> crate::output::DescribePortalOutput {
            crate::output::DescribePortalOutput {
                portal_id: self.portal_id,
                portal_arn: self.portal_arn,
                portal_name: self.portal_name,
                portal_description: self.portal_description,
                portal_client_id: self.portal_client_id,
                portal_start_url: self.portal_start_url,
                portal_contact_email: self.portal_contact_email,
                portal_status: self.portal_status,
                portal_creation_date: self.portal_creation_date,
                portal_last_update_date: self.portal_last_update_date,
                portal_logo_image_location: self.portal_logo_image_location,
                role_arn: self.role_arn,
                portal_auth_mode: self.portal_auth_mode,
                notification_sender_email: self.notification_sender_email,
                alarms: self.alarms,
            }
        }
    }
}
impl DescribePortalOutput {
    /// Creates a new builder-style object to manufacture [`DescribePortalOutput`](crate::output::DescribePortalOutput)
    pub fn builder() -> crate::output::describe_portal_output::Builder {
        crate::output::describe_portal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingOptionsOutput {
    /// <p>The current logging options.</p>
    pub logging_options: std::option::Option<crate::model::LoggingOptions>,
}
impl DescribeLoggingOptionsOutput {
    /// <p>The current logging options.</p>
    pub fn logging_options(&self) -> std::option::Option<&crate::model::LoggingOptions> {
        self.logging_options.as_ref()
    }
}
impl std::fmt::Debug for DescribeLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingOptionsOutput");
        formatter.field("logging_options", &self.logging_options);
        formatter.finish()
    }
}
/// See [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
pub mod describe_logging_options_output {
    /// A builder for [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_options: std::option::Option<crate::model::LoggingOptions>,
    }
    impl Builder {
        /// <p>The current logging options.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.logging_options = Some(input);
            self
        }
        /// <p>The current logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
        pub fn build(self) -> crate::output::DescribeLoggingOptionsOutput {
            crate::output::DescribeLoggingOptionsOutput {
                logging_options: self.logging_options,
            }
        }
    }
}
impl DescribeLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
    pub fn builder() -> crate::output::describe_logging_options_output::Builder {
        crate::output::describe_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayCapabilityConfigurationOutput {
    /// <p>The ID of the gateway that defines the capability configuration.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The namespace of the gateway capability.</p>
    pub capability_namespace: std::option::Option<std::string::String>,
    /// <p>The JSON document that defines the gateway capability's configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub capability_configuration: std::option::Option<std::string::String>,
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    pub capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
}
impl DescribeGatewayCapabilityConfigurationOutput {
    /// <p>The ID of the gateway that defines the capability configuration.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The namespace of the gateway capability.</p>
    pub fn capability_namespace(&self) -> std::option::Option<&str> {
        self.capability_namespace.as_deref()
    }
    /// <p>The JSON document that defines the gateway capability's configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn capability_configuration(&self) -> std::option::Option<&str> {
        self.capability_configuration.as_deref()
    }
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    pub fn capability_sync_status(
        &self,
    ) -> std::option::Option<&crate::model::CapabilitySyncStatus> {
        self.capability_sync_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeGatewayCapabilityConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayCapabilityConfigurationOutput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("capability_namespace", &self.capability_namespace);
        formatter.field("capability_configuration", &self.capability_configuration);
        formatter.field("capability_sync_status", &self.capability_sync_status);
        formatter.finish()
    }
}
/// See [`DescribeGatewayCapabilityConfigurationOutput`](crate::output::DescribeGatewayCapabilityConfigurationOutput)
pub mod describe_gateway_capability_configuration_output {
    /// A builder for [`DescribeGatewayCapabilityConfigurationOutput`](crate::output::DescribeGatewayCapabilityConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) capability_namespace: std::option::Option<std::string::String>,
        pub(crate) capability_configuration: std::option::Option<std::string::String>,
        pub(crate) capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
    }
    impl Builder {
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The namespace of the gateway capability.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the gateway capability.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_namespace = input;
            self
        }
        /// <p>The JSON document that defines the gateway capability's configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn capability_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_configuration = Some(input.into());
            self
        }
        /// <p>The JSON document that defines the gateway capability's configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_capability_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_configuration = input;
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        pub fn capability_sync_status(mut self, input: crate::model::CapabilitySyncStatus) -> Self {
            self.capability_sync_status = Some(input);
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        pub fn set_capability_sync_status(
            mut self,
            input: std::option::Option<crate::model::CapabilitySyncStatus>,
        ) -> Self {
            self.capability_sync_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayCapabilityConfigurationOutput`](crate::output::DescribeGatewayCapabilityConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeGatewayCapabilityConfigurationOutput {
            crate::output::DescribeGatewayCapabilityConfigurationOutput {
                gateway_id: self.gateway_id,
                capability_namespace: self.capability_namespace,
                capability_configuration: self.capability_configuration,
                capability_sync_status: self.capability_sync_status,
            }
        }
    }
}
impl DescribeGatewayCapabilityConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayCapabilityConfigurationOutput`](crate::output::DescribeGatewayCapabilityConfigurationOutput)
    pub fn builder() -> crate::output::describe_gateway_capability_configuration_output::Builder {
        crate::output::describe_gateway_capability_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayOutput {
    /// <p>The ID of the gateway device.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The name of the gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    pub gateway_arn: std::option::Option<std::string::String>,
    /// <p>The gateway's platform.</p>
    pub gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
    /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
    pub gateway_capability_summaries:
        std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
    /// <p>The date the gateway was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the gateway was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeGatewayOutput {
    /// <p>The ID of the gateway device.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The name of the gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
    /// <p>The gateway's platform.</p>
    pub fn gateway_platform(&self) -> std::option::Option<&crate::model::GatewayPlatform> {
        self.gateway_platform.as_ref()
    }
    /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
    pub fn gateway_capability_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::GatewayCapabilitySummary]> {
        self.gateway_capability_summaries.as_deref()
    }
    /// <p>The date the gateway was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the gateway was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayOutput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.field("gateway_platform", &self.gateway_platform);
        formatter.field(
            "gateway_capability_summaries",
            &self.gateway_capability_summaries,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`DescribeGatewayOutput`](crate::output::DescribeGatewayOutput)
pub mod describe_gateway_output {
    /// A builder for [`DescribeGatewayOutput`](crate::output::DescribeGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
        pub(crate) gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
        pub(crate) gateway_capability_summaries:
            std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the gateway device.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway device.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// <p>The gateway's platform.</p>
        pub fn gateway_platform(mut self, input: crate::model::GatewayPlatform) -> Self {
            self.gateway_platform = Some(input);
            self
        }
        /// <p>The gateway's platform.</p>
        pub fn set_gateway_platform(
            mut self,
            input: std::option::Option<crate::model::GatewayPlatform>,
        ) -> Self {
            self.gateway_platform = input;
            self
        }
        /// Appends an item to `gateway_capability_summaries`.
        ///
        /// To override the contents of this collection use [`set_gateway_capability_summaries`](Self::set_gateway_capability_summaries).
        ///
        /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
        pub fn gateway_capability_summaries(
            mut self,
            input: crate::model::GatewayCapabilitySummary,
        ) -> Self {
            let mut v = self.gateway_capability_summaries.unwrap_or_default();
            v.push(input);
            self.gateway_capability_summaries = Some(v);
            self
        }
        /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
        pub fn set_gateway_capability_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
        ) -> Self {
            self.gateway_capability_summaries = input;
            self
        }
        /// <p>The date the gateway was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the gateway was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the gateway was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the gateway was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayOutput`](crate::output::DescribeGatewayOutput)
        pub fn build(self) -> crate::output::DescribeGatewayOutput {
            crate::output::DescribeGatewayOutput {
                gateway_id: self.gateway_id,
                gateway_name: self.gateway_name,
                gateway_arn: self.gateway_arn,
                gateway_platform: self.gateway_platform,
                gateway_capability_summaries: self.gateway_capability_summaries,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl DescribeGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayOutput`](crate::output::DescribeGatewayOutput)
    pub fn builder() -> crate::output::describe_gateway_output::Builder {
        crate::output::describe_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultEncryptionConfigurationOutput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there's an error, it also contains the <code>ErrorDetails</code>.</p>
    pub configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
}
impl DescribeDefaultEncryptionConfigurationOutput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there's an error, it also contains the <code>ErrorDetails</code>.</p>
    pub fn configuration_status(&self) -> std::option::Option<&crate::model::ConfigurationStatus> {
        self.configuration_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeDefaultEncryptionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultEncryptionConfigurationOutput");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("configuration_status", &self.configuration_status);
        formatter.finish()
    }
}
/// See [`DescribeDefaultEncryptionConfigurationOutput`](crate::output::DescribeDefaultEncryptionConfigurationOutput)
pub mod describe_default_encryption_configuration_output {
    /// A builder for [`DescribeDefaultEncryptionConfigurationOutput`](crate::output::DescribeDefaultEncryptionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_status: std::option::Option<crate::model::ConfigurationStatus>,
    }
    impl Builder {
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there's an error, it also contains the <code>ErrorDetails</code>.</p>
        pub fn configuration_status(mut self, input: crate::model::ConfigurationStatus) -> Self {
            self.configuration_status = Some(input);
            self
        }
        /// <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there's an error, it also contains the <code>ErrorDetails</code>.</p>
        pub fn set_configuration_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationStatus>,
        ) -> Self {
            self.configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultEncryptionConfigurationOutput`](crate::output::DescribeDefaultEncryptionConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeDefaultEncryptionConfigurationOutput {
            crate::output::DescribeDefaultEncryptionConfigurationOutput {
                encryption_type: self.encryption_type,
                kms_key_arn: self.kms_key_arn,
                configuration_status: self.configuration_status,
            }
        }
    }
}
impl DescribeDefaultEncryptionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultEncryptionConfigurationOutput`](crate::output::DescribeDefaultEncryptionConfigurationOutput)
    pub fn builder() -> crate::output::describe_default_encryption_configuration_output::Builder {
        crate::output::describe_default_encryption_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDashboardOutput {
    /// <p>The ID of the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    pub dashboard_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dashboard.</p>
    pub dashboard_name: std::option::Option<std::string::String>,
    /// <p>The ID of the project that the dashboard is in.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The dashboard's description.</p>
    pub dashboard_description: std::option::Option<std::string::String>,
    /// <p>The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub dashboard_definition: std::option::Option<std::string::String>,
    /// <p>The date the dashboard was created, in Unix epoch time.</p>
    pub dashboard_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
    pub dashboard_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeDashboardOutput {
    /// <p>The ID of the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
    /// <p>The name of the dashboard.</p>
    pub fn dashboard_name(&self) -> std::option::Option<&str> {
        self.dashboard_name.as_deref()
    }
    /// <p>The ID of the project that the dashboard is in.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The dashboard's description.</p>
    pub fn dashboard_description(&self) -> std::option::Option<&str> {
        self.dashboard_description.as_deref()
    }
    /// <p>The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn dashboard_definition(&self) -> std::option::Option<&str> {
        self.dashboard_definition.as_deref()
    }
    /// <p>The date the dashboard was created, in Unix epoch time.</p>
    pub fn dashboard_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.dashboard_creation_date.as_ref()
    }
    /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
    pub fn dashboard_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.dashboard_last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDashboardOutput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.field("dashboard_name", &self.dashboard_name);
        formatter.field("project_id", &self.project_id);
        formatter.field("dashboard_description", &self.dashboard_description);
        formatter.field("dashboard_definition", &self.dashboard_definition);
        formatter.field("dashboard_creation_date", &self.dashboard_creation_date);
        formatter.field(
            "dashboard_last_update_date",
            &self.dashboard_last_update_date,
        );
        formatter.finish()
    }
}
/// See [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
pub mod describe_dashboard_output {
    /// A builder for [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_name: std::option::Option<std::string::String>,
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_description: std::option::Option<std::string::String>,
        pub(crate) dashboard_definition: std::option::Option<std::string::String>,
        pub(crate) dashboard_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dashboard_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// <p>The name of the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_name = Some(input.into());
            self
        }
        /// <p>The name of the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_name = input;
            self
        }
        /// <p>The ID of the project that the dashboard is in.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project that the dashboard is in.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The dashboard's description.</p>
        pub fn dashboard_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_description = Some(input.into());
            self
        }
        /// <p>The dashboard's description.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_description = input;
            self
        }
        /// <p>The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_definition = Some(input.into());
            self
        }
        /// <p>The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_definition = input;
            self
        }
        /// <p>The date the dashboard was created, in Unix epoch time.</p>
        pub fn dashboard_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.dashboard_creation_date = Some(input);
            self
        }
        /// <p>The date the dashboard was created, in Unix epoch time.</p>
        pub fn set_dashboard_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.dashboard_creation_date = input;
            self
        }
        /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
        pub fn dashboard_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.dashboard_last_update_date = Some(input);
            self
        }
        /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
        pub fn set_dashboard_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.dashboard_last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
        pub fn build(self) -> crate::output::DescribeDashboardOutput {
            crate::output::DescribeDashboardOutput {
                dashboard_id: self.dashboard_id,
                dashboard_arn: self.dashboard_arn,
                dashboard_name: self.dashboard_name,
                project_id: self.project_id,
                dashboard_description: self.dashboard_description,
                dashboard_definition: self.dashboard_definition,
                dashboard_creation_date: self.dashboard_creation_date,
                dashboard_last_update_date: self.dashboard_last_update_date,
            }
        }
    }
}
impl DescribeDashboardOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
    pub fn builder() -> crate::output::describe_dashboard_output::Builder {
        crate::output::describe_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetPropertyOutput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The name of the asset.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The asset property's definition, alias, and notification state.</p>
    /// <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>
    pub asset_property: std::option::Option<crate::model::Property>,
    /// <p>The composite asset model that declares this asset property, if this asset property exists in a composite model.</p>
    pub composite_model: std::option::Option<crate::model::CompositeModelProperty>,
}
impl DescribeAssetPropertyOutput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The name of the asset.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The ID of the asset model.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The asset property's definition, alias, and notification state.</p>
    /// <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>
    pub fn asset_property(&self) -> std::option::Option<&crate::model::Property> {
        self.asset_property.as_ref()
    }
    /// <p>The composite asset model that declares this asset property, if this asset property exists in a composite model.</p>
    pub fn composite_model(&self) -> std::option::Option<&crate::model::CompositeModelProperty> {
        self.composite_model.as_ref()
    }
}
impl std::fmt::Debug for DescribeAssetPropertyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetPropertyOutput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("asset_name", &self.asset_name);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("asset_property", &self.asset_property);
        formatter.field("composite_model", &self.composite_model);
        formatter.finish()
    }
}
/// See [`DescribeAssetPropertyOutput`](crate::output::DescribeAssetPropertyOutput)
pub mod describe_asset_property_output {
    /// A builder for [`DescribeAssetPropertyOutput`](crate::output::DescribeAssetPropertyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) asset_property: std::option::Option<crate::model::Property>,
        pub(crate) composite_model: std::option::Option<crate::model::CompositeModelProperty>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The name of the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>The name of the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The asset property's definition, alias, and notification state.</p>
        /// <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>
        pub fn asset_property(mut self, input: crate::model::Property) -> Self {
            self.asset_property = Some(input);
            self
        }
        /// <p>The asset property's definition, alias, and notification state.</p>
        /// <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>
        pub fn set_asset_property(
            mut self,
            input: std::option::Option<crate::model::Property>,
        ) -> Self {
            self.asset_property = input;
            self
        }
        /// <p>The composite asset model that declares this asset property, if this asset property exists in a composite model.</p>
        pub fn composite_model(mut self, input: crate::model::CompositeModelProperty) -> Self {
            self.composite_model = Some(input);
            self
        }
        /// <p>The composite asset model that declares this asset property, if this asset property exists in a composite model.</p>
        pub fn set_composite_model(
            mut self,
            input: std::option::Option<crate::model::CompositeModelProperty>,
        ) -> Self {
            self.composite_model = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetPropertyOutput`](crate::output::DescribeAssetPropertyOutput)
        pub fn build(self) -> crate::output::DescribeAssetPropertyOutput {
            crate::output::DescribeAssetPropertyOutput {
                asset_id: self.asset_id,
                asset_name: self.asset_name,
                asset_model_id: self.asset_model_id,
                asset_property: self.asset_property,
                composite_model: self.composite_model,
            }
        }
    }
}
impl DescribeAssetPropertyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssetPropertyOutput`](crate::output::DescribeAssetPropertyOutput)
    pub fn builder() -> crate::output::describe_asset_property_output::Builder {
        crate::output::describe_asset_property_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetModelOutput {
    /// <p>The ID of the asset model.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub asset_model_arn: std::option::Option<std::string::String>,
    /// <p>The name of the asset model.</p>
    pub asset_model_name: std::option::Option<std::string::String>,
    /// <p>The asset model's description.</p>
    pub asset_model_description: std::option::Option<std::string::String>,
    /// <p>The list of asset properties for the asset model.</p>
    /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>
    pub asset_model_properties:
        std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
    /// <p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>
    pub asset_model_hierarchies:
        std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
    /// <p>The list of composite asset models for the asset model.</p>
    pub asset_model_composite_models:
        std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
    /// <p>The date the asset model was created, in Unix epoch time.</p>
    pub asset_model_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the asset model was last updated, in Unix epoch time.</p>
    pub asset_model_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the asset model, which contains a state and any error message.</p>
    pub asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
}
impl DescribeAssetModelOutput {
    /// <p>The ID of the asset model.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub fn asset_model_arn(&self) -> std::option::Option<&str> {
        self.asset_model_arn.as_deref()
    }
    /// <p>The name of the asset model.</p>
    pub fn asset_model_name(&self) -> std::option::Option<&str> {
        self.asset_model_name.as_deref()
    }
    /// <p>The asset model's description.</p>
    pub fn asset_model_description(&self) -> std::option::Option<&str> {
        self.asset_model_description.as_deref()
    }
    /// <p>The list of asset properties for the asset model.</p>
    /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>
    pub fn asset_model_properties(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelProperty]> {
        self.asset_model_properties.as_deref()
    }
    /// <p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>
    pub fn asset_model_hierarchies(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelHierarchy]> {
        self.asset_model_hierarchies.as_deref()
    }
    /// <p>The list of composite asset models for the asset model.</p>
    pub fn asset_model_composite_models(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelCompositeModel]> {
        self.asset_model_composite_models.as_deref()
    }
    /// <p>The date the asset model was created, in Unix epoch time.</p>
    pub fn asset_model_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.asset_model_creation_date.as_ref()
    }
    /// <p>The date the asset model was last updated, in Unix epoch time.</p>
    pub fn asset_model_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.asset_model_last_update_date.as_ref()
    }
    /// <p>The current status of the asset model, which contains a state and any error message.</p>
    pub fn asset_model_status(&self) -> std::option::Option<&crate::model::AssetModelStatus> {
        self.asset_model_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeAssetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetModelOutput");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("asset_model_arn", &self.asset_model_arn);
        formatter.field("asset_model_name", &self.asset_model_name);
        formatter.field("asset_model_description", &self.asset_model_description);
        formatter.field("asset_model_properties", &self.asset_model_properties);
        formatter.field("asset_model_hierarchies", &self.asset_model_hierarchies);
        formatter.field(
            "asset_model_composite_models",
            &self.asset_model_composite_models,
        );
        formatter.field("asset_model_creation_date", &self.asset_model_creation_date);
        formatter.field(
            "asset_model_last_update_date",
            &self.asset_model_last_update_date,
        );
        formatter.field("asset_model_status", &self.asset_model_status);
        formatter.finish()
    }
}
/// See [`DescribeAssetModelOutput`](crate::output::DescribeAssetModelOutput)
pub mod describe_asset_model_output {
    /// A builder for [`DescribeAssetModelOutput`](crate::output::DescribeAssetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) asset_model_arn: std::option::Option<std::string::String>,
        pub(crate) asset_model_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_description: std::option::Option<std::string::String>,
        pub(crate) asset_model_properties:
            std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        pub(crate) asset_model_hierarchies:
            std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        pub(crate) asset_model_composite_models:
            std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        pub(crate) asset_model_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) asset_model_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
    }
    impl Builder {
        /// <p>The ID of the asset model.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn asset_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn set_asset_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_arn = input;
            self
        }
        /// <p>The name of the asset model.</p>
        pub fn asset_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_name = Some(input.into());
            self
        }
        /// <p>The name of the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_name = input;
            self
        }
        /// <p>The asset model's description.</p>
        pub fn asset_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_description = Some(input.into());
            self
        }
        /// <p>The asset model's description.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_description = input;
            self
        }
        /// Appends an item to `asset_model_properties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The list of asset properties for the asset model.</p>
        /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>
        pub fn asset_model_properties(mut self, input: crate::model::AssetModelProperty) -> Self {
            let mut v = self.asset_model_properties.unwrap_or_default();
            v.push(input);
            self.asset_model_properties = Some(v);
            self
        }
        /// <p>The list of asset properties for the asset model.</p>
        /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        ) -> Self {
            self.asset_model_properties = input;
            self
        }
        /// Appends an item to `asset_model_hierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>
        pub fn asset_model_hierarchies(mut self, input: crate::model::AssetModelHierarchy) -> Self {
            let mut v = self.asset_model_hierarchies.unwrap_or_default();
            v.push(input);
            self.asset_model_hierarchies = Some(v);
            self
        }
        /// <p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        ) -> Self {
            self.asset_model_hierarchies = input;
            self
        }
        /// Appends an item to `asset_model_composite_models`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The list of composite asset models for the asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            input: crate::model::AssetModelCompositeModel,
        ) -> Self {
            let mut v = self.asset_model_composite_models.unwrap_or_default();
            v.push(input);
            self.asset_model_composite_models = Some(v);
            self
        }
        /// <p>The list of composite asset models for the asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        ) -> Self {
            self.asset_model_composite_models = input;
            self
        }
        /// <p>The date the asset model was created, in Unix epoch time.</p>
        pub fn asset_model_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.asset_model_creation_date = Some(input);
            self
        }
        /// <p>The date the asset model was created, in Unix epoch time.</p>
        pub fn set_asset_model_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.asset_model_creation_date = input;
            self
        }
        /// <p>The date the asset model was last updated, in Unix epoch time.</p>
        pub fn asset_model_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.asset_model_last_update_date = Some(input);
            self
        }
        /// <p>The date the asset model was last updated, in Unix epoch time.</p>
        pub fn set_asset_model_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.asset_model_last_update_date = input;
            self
        }
        /// <p>The current status of the asset model, which contains a state and any error message.</p>
        pub fn asset_model_status(mut self, input: crate::model::AssetModelStatus) -> Self {
            self.asset_model_status = Some(input);
            self
        }
        /// <p>The current status of the asset model, which contains a state and any error message.</p>
        pub fn set_asset_model_status(
            mut self,
            input: std::option::Option<crate::model::AssetModelStatus>,
        ) -> Self {
            self.asset_model_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetModelOutput`](crate::output::DescribeAssetModelOutput)
        pub fn build(self) -> crate::output::DescribeAssetModelOutput {
            crate::output::DescribeAssetModelOutput {
                asset_model_id: self.asset_model_id,
                asset_model_arn: self.asset_model_arn,
                asset_model_name: self.asset_model_name,
                asset_model_description: self.asset_model_description,
                asset_model_properties: self.asset_model_properties,
                asset_model_hierarchies: self.asset_model_hierarchies,
                asset_model_composite_models: self.asset_model_composite_models,
                asset_model_creation_date: self.asset_model_creation_date,
                asset_model_last_update_date: self.asset_model_last_update_date,
                asset_model_status: self.asset_model_status,
            }
        }
    }
}
impl DescribeAssetModelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssetModelOutput`](crate::output::DescribeAssetModelOutput)
    pub fn builder() -> crate::output::describe_asset_model_output::Builder {
        crate::output::describe_asset_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetOutput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub asset_arn: std::option::Option<std::string::String>,
    /// <p>The name of the asset.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model that was used to create the asset.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The list of asset properties for the asset.</p>
    /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>
    pub asset_properties: std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub asset_hierarchies: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
    /// <p>The composite models for the asset.</p>
    pub asset_composite_models:
        std::option::Option<std::vec::Vec<crate::model::AssetCompositeModel>>,
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub asset_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub asset_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the asset, which contains a state and any error message.</p>
    pub asset_status: std::option::Option<crate::model::AssetStatus>,
}
impl DescribeAssetOutput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub fn asset_arn(&self) -> std::option::Option<&str> {
        self.asset_arn.as_deref()
    }
    /// <p>The name of the asset.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The ID of the asset model that was used to create the asset.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The list of asset properties for the asset.</p>
    /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>
    pub fn asset_properties(&self) -> std::option::Option<&[crate::model::AssetProperty]> {
        self.asset_properties.as_deref()
    }
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub fn asset_hierarchies(&self) -> std::option::Option<&[crate::model::AssetHierarchy]> {
        self.asset_hierarchies.as_deref()
    }
    /// <p>The composite models for the asset.</p>
    pub fn asset_composite_models(
        &self,
    ) -> std::option::Option<&[crate::model::AssetCompositeModel]> {
        self.asset_composite_models.as_deref()
    }
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub fn asset_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.asset_creation_date.as_ref()
    }
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub fn asset_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.asset_last_update_date.as_ref()
    }
    /// <p>The current status of the asset, which contains a state and any error message.</p>
    pub fn asset_status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.asset_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetOutput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("asset_arn", &self.asset_arn);
        formatter.field("asset_name", &self.asset_name);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("asset_properties", &self.asset_properties);
        formatter.field("asset_hierarchies", &self.asset_hierarchies);
        formatter.field("asset_composite_models", &self.asset_composite_models);
        formatter.field("asset_creation_date", &self.asset_creation_date);
        formatter.field("asset_last_update_date", &self.asset_last_update_date);
        formatter.field("asset_status", &self.asset_status);
        formatter.finish()
    }
}
/// See [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
pub mod describe_asset_output {
    /// A builder for [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) asset_arn: std::option::Option<std::string::String>,
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) asset_properties:
            std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
        pub(crate) asset_hierarchies:
            std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
        pub(crate) asset_composite_models:
            std::option::Option<std::vec::Vec<crate::model::AssetCompositeModel>>,
        pub(crate) asset_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) asset_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) asset_status: std::option::Option<crate::model::AssetStatus>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn asset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn set_asset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_arn = input;
            self
        }
        /// <p>The name of the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>The name of the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The ID of the asset model that was used to create the asset.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model that was used to create the asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// Appends an item to `asset_properties`.
        ///
        /// To override the contents of this collection use [`set_asset_properties`](Self::set_asset_properties).
        ///
        /// <p>The list of asset properties for the asset.</p>
        /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>
        pub fn asset_properties(mut self, input: crate::model::AssetProperty) -> Self {
            let mut v = self.asset_properties.unwrap_or_default();
            v.push(input);
            self.asset_properties = Some(v);
            self
        }
        /// <p>The list of asset properties for the asset.</p>
        /// <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>
        pub fn set_asset_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
        ) -> Self {
            self.asset_properties = input;
            self
        }
        /// Appends an item to `asset_hierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_hierarchies`](Self::set_asset_hierarchies).
        ///
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn asset_hierarchies(mut self, input: crate::model::AssetHierarchy) -> Self {
            let mut v = self.asset_hierarchies.unwrap_or_default();
            v.push(input);
            self.asset_hierarchies = Some(v);
            self
        }
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn set_asset_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
        ) -> Self {
            self.asset_hierarchies = input;
            self
        }
        /// Appends an item to `asset_composite_models`.
        ///
        /// To override the contents of this collection use [`set_asset_composite_models`](Self::set_asset_composite_models).
        ///
        /// <p>The composite models for the asset.</p>
        pub fn asset_composite_models(mut self, input: crate::model::AssetCompositeModel) -> Self {
            let mut v = self.asset_composite_models.unwrap_or_default();
            v.push(input);
            self.asset_composite_models = Some(v);
            self
        }
        /// <p>The composite models for the asset.</p>
        pub fn set_asset_composite_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetCompositeModel>>,
        ) -> Self {
            self.asset_composite_models = input;
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn asset_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.asset_creation_date = Some(input);
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn set_asset_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.asset_creation_date = input;
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn asset_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.asset_last_update_date = Some(input);
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn set_asset_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.asset_last_update_date = input;
            self
        }
        /// <p>The current status of the asset, which contains a state and any error message.</p>
        pub fn asset_status(mut self, input: crate::model::AssetStatus) -> Self {
            self.asset_status = Some(input);
            self
        }
        /// <p>The current status of the asset, which contains a state and any error message.</p>
        pub fn set_asset_status(
            mut self,
            input: std::option::Option<crate::model::AssetStatus>,
        ) -> Self {
            self.asset_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
        pub fn build(self) -> crate::output::DescribeAssetOutput {
            crate::output::DescribeAssetOutput {
                asset_id: self.asset_id,
                asset_arn: self.asset_arn,
                asset_name: self.asset_name,
                asset_model_id: self.asset_model_id,
                asset_properties: self.asset_properties,
                asset_hierarchies: self.asset_hierarchies,
                asset_composite_models: self.asset_composite_models,
                asset_creation_date: self.asset_creation_date,
                asset_last_update_date: self.asset_last_update_date,
                asset_status: self.asset_status,
            }
        }
    }
}
impl DescribeAssetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssetOutput`](crate::output::DescribeAssetOutput)
    pub fn builder() -> crate::output::describe_asset_output::Builder {
        crate::output::describe_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessPolicyOutput {
    /// <p>The ID of the access policy.</p>
    pub access_policy_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    pub access_policy_arn: std::option::Option<std::string::String>,
    /// <p>The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy applies.</p>
    pub access_policy_identity: std::option::Option<crate::model::Identity>,
    /// <p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>
    pub access_policy_resource: std::option::Option<crate::model::Resource>,
    /// <p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub access_policy_permission: std::option::Option<crate::model::Permission>,
    /// <p>The date the access policy was created, in Unix epoch time.</p>
    pub access_policy_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the access policy was last updated, in Unix epoch time.</p>
    pub access_policy_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeAccessPolicyOutput {
    /// <p>The ID of the access policy.</p>
    pub fn access_policy_id(&self) -> std::option::Option<&str> {
        self.access_policy_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    pub fn access_policy_arn(&self) -> std::option::Option<&str> {
        self.access_policy_arn.as_deref()
    }
    /// <p>The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy applies.</p>
    pub fn access_policy_identity(&self) -> std::option::Option<&crate::model::Identity> {
        self.access_policy_identity.as_ref()
    }
    /// <p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>
    pub fn access_policy_resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.access_policy_resource.as_ref()
    }
    /// <p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub fn access_policy_permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.access_policy_permission.as_ref()
    }
    /// <p>The date the access policy was created, in Unix epoch time.</p>
    pub fn access_policy_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.access_policy_creation_date.as_ref()
    }
    /// <p>The date the access policy was last updated, in Unix epoch time.</p>
    pub fn access_policy_last_update_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.access_policy_last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessPolicyOutput");
        formatter.field("access_policy_id", &self.access_policy_id);
        formatter.field("access_policy_arn", &self.access_policy_arn);
        formatter.field("access_policy_identity", &self.access_policy_identity);
        formatter.field("access_policy_resource", &self.access_policy_resource);
        formatter.field("access_policy_permission", &self.access_policy_permission);
        formatter.field(
            "access_policy_creation_date",
            &self.access_policy_creation_date,
        );
        formatter.field(
            "access_policy_last_update_date",
            &self.access_policy_last_update_date,
        );
        formatter.finish()
    }
}
/// See [`DescribeAccessPolicyOutput`](crate::output::DescribeAccessPolicyOutput)
pub mod describe_access_policy_output {
    /// A builder for [`DescribeAccessPolicyOutput`](crate::output::DescribeAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_id: std::option::Option<std::string::String>,
        pub(crate) access_policy_arn: std::option::Option<std::string::String>,
        pub(crate) access_policy_identity: std::option::Option<crate::model::Identity>,
        pub(crate) access_policy_resource: std::option::Option<crate::model::Resource>,
        pub(crate) access_policy_permission: std::option::Option<crate::model::Permission>,
        pub(crate) access_policy_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) access_policy_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
        pub fn access_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
        pub fn set_access_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_arn = input;
            self
        }
        /// <p>The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy applies.</p>
        pub fn access_policy_identity(mut self, input: crate::model::Identity) -> Self {
            self.access_policy_identity = Some(input);
            self
        }
        /// <p>The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy applies.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.access_policy_identity = input;
            self
        }
        /// <p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>
        pub fn access_policy_resource(mut self, input: crate::model::Resource) -> Self {
            self.access_policy_resource = Some(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.access_policy_resource = input;
            self
        }
        /// <p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, input: crate::model::Permission) -> Self {
            self.access_policy_permission = Some(input);
            self
        }
        /// <p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.access_policy_permission = input;
            self
        }
        /// <p>The date the access policy was created, in Unix epoch time.</p>
        pub fn access_policy_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.access_policy_creation_date = Some(input);
            self
        }
        /// <p>The date the access policy was created, in Unix epoch time.</p>
        pub fn set_access_policy_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.access_policy_creation_date = input;
            self
        }
        /// <p>The date the access policy was last updated, in Unix epoch time.</p>
        pub fn access_policy_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.access_policy_last_update_date = Some(input);
            self
        }
        /// <p>The date the access policy was last updated, in Unix epoch time.</p>
        pub fn set_access_policy_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.access_policy_last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessPolicyOutput`](crate::output::DescribeAccessPolicyOutput)
        pub fn build(self) -> crate::output::DescribeAccessPolicyOutput {
            crate::output::DescribeAccessPolicyOutput {
                access_policy_id: self.access_policy_id,
                access_policy_arn: self.access_policy_arn,
                access_policy_identity: self.access_policy_identity,
                access_policy_resource: self.access_policy_resource,
                access_policy_permission: self.access_policy_permission,
                access_policy_creation_date: self.access_policy_creation_date,
                access_policy_last_update_date: self.access_policy_last_update_date,
            }
        }
    }
}
impl DescribeAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccessPolicyOutput`](crate::output::DescribeAccessPolicyOutput)
    pub fn builder() -> crate::output::describe_access_policy_output::Builder {
        crate::output::describe_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTimeSeriesOutput {}
impl std::fmt::Debug for DeleteTimeSeriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTimeSeriesOutput");
        formatter.finish()
    }
}
/// See [`DeleteTimeSeriesOutput`](crate::output::DeleteTimeSeriesOutput)
pub mod delete_time_series_output {
    /// A builder for [`DeleteTimeSeriesOutput`](crate::output::DeleteTimeSeriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTimeSeriesOutput`](crate::output::DeleteTimeSeriesOutput)
        pub fn build(self) -> crate::output::DeleteTimeSeriesOutput {
            crate::output::DeleteTimeSeriesOutput {}
        }
    }
}
impl DeleteTimeSeriesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTimeSeriesOutput`](crate::output::DeleteTimeSeriesOutput)
    pub fn builder() -> crate::output::delete_time_series_output::Builder {
        crate::output::delete_time_series_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {}
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePortalOutput {
    /// <p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
}
impl DeletePortalOutput {
    /// <p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
}
impl std::fmt::Debug for DeletePortalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePortalOutput");
        formatter.field("portal_status", &self.portal_status);
        formatter.finish()
    }
}
/// See [`DeletePortalOutput`](crate::output::DeletePortalOutput)
pub mod delete_portal_output {
    /// A builder for [`DeletePortalOutput`](crate::output::DeletePortalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
    }
    impl Builder {
        /// <p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortalOutput`](crate::output::DeletePortalOutput)
        pub fn build(self) -> crate::output::DeletePortalOutput {
            crate::output::DeletePortalOutput {
                portal_status: self.portal_status,
            }
        }
    }
}
impl DeletePortalOutput {
    /// Creates a new builder-style object to manufacture [`DeletePortalOutput`](crate::output::DeletePortalOutput)
    pub fn builder() -> crate::output::delete_portal_output::Builder {
        crate::output::delete_portal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayOutput {}
impl std::fmt::Debug for DeleteGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayOutput");
        formatter.finish()
    }
}
/// See [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
pub mod delete_gateway_output {
    /// A builder for [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
        pub fn build(self) -> crate::output::DeleteGatewayOutput {
            crate::output::DeleteGatewayOutput {}
        }
    }
}
impl DeleteGatewayOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)
    pub fn builder() -> crate::output::delete_gateway_output::Builder {
        crate::output::delete_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDashboardOutput {}
impl std::fmt::Debug for DeleteDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDashboardOutput");
        formatter.finish()
    }
}
/// See [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
pub mod delete_dashboard_output {
    /// A builder for [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
        pub fn build(self) -> crate::output::DeleteDashboardOutput {
            crate::output::DeleteDashboardOutput {}
        }
    }
}
impl DeleteDashboardOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
    pub fn builder() -> crate::output::delete_dashboard_output::Builder {
        crate::output::delete_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetModelOutput {
    /// <p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
}
impl DeleteAssetModelOutput {
    /// <p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_model_status(&self) -> std::option::Option<&crate::model::AssetModelStatus> {
        self.asset_model_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteAssetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetModelOutput");
        formatter.field("asset_model_status", &self.asset_model_status);
        formatter.finish()
    }
}
/// See [`DeleteAssetModelOutput`](crate::output::DeleteAssetModelOutput)
pub mod delete_asset_model_output {
    /// A builder for [`DeleteAssetModelOutput`](crate::output::DeleteAssetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
    }
    impl Builder {
        /// <p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_model_status(mut self, input: crate::model::AssetModelStatus) -> Self {
            self.asset_model_status = Some(input);
            self
        }
        /// <p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_model_status(
            mut self,
            input: std::option::Option<crate::model::AssetModelStatus>,
        ) -> Self {
            self.asset_model_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetModelOutput`](crate::output::DeleteAssetModelOutput)
        pub fn build(self) -> crate::output::DeleteAssetModelOutput {
            crate::output::DeleteAssetModelOutput {
                asset_model_status: self.asset_model_status,
            }
        }
    }
}
impl DeleteAssetModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssetModelOutput`](crate::output::DeleteAssetModelOutput)
    pub fn builder() -> crate::output::delete_asset_model_output::Builder {
        crate::output::delete_asset_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetOutput {
    /// <p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub asset_status: std::option::Option<crate::model::AssetStatus>,
}
impl DeleteAssetOutput {
    /// <p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.asset_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetOutput");
        formatter.field("asset_status", &self.asset_status);
        formatter.finish()
    }
}
/// See [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
pub mod delete_asset_output {
    /// A builder for [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_status: std::option::Option<crate::model::AssetStatus>,
    }
    impl Builder {
        /// <p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_status(mut self, input: crate::model::AssetStatus) -> Self {
            self.asset_status = Some(input);
            self
        }
        /// <p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_status(
            mut self,
            input: std::option::Option<crate::model::AssetStatus>,
        ) -> Self {
            self.asset_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
        pub fn build(self) -> crate::output::DeleteAssetOutput {
            crate::output::DeleteAssetOutput {
                asset_status: self.asset_status,
            }
        }
    }
}
impl DeleteAssetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssetOutput`](crate::output::DeleteAssetOutput)
    pub fn builder() -> crate::output::delete_asset_output::Builder {
        crate::output::delete_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPolicyOutput {}
impl std::fmt::Debug for DeleteAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPolicyOutput`](crate::output::DeleteAccessPolicyOutput)
pub mod delete_access_policy_output {
    /// A builder for [`DeleteAccessPolicyOutput`](crate::output::DeleteAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPolicyOutput`](crate::output::DeleteAccessPolicyOutput)
        pub fn build(self) -> crate::output::DeleteAccessPolicyOutput {
            crate::output::DeleteAccessPolicyOutput {}
        }
    }
}
impl DeleteAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPolicyOutput`](crate::output::DeleteAccessPolicyOutput)
    pub fn builder() -> crate::output::delete_access_policy_output::Builder {
        crate::output::delete_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl CreateProjectOutput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("project_id", &self.project_id);
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                project_id: self.project_id,
                project_arn: self.project_arn,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePortalOutput {
    /// <p>The ID of the created portal.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    pub portal_arn: std::option::Option<std::string::String>,
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub portal_start_url: std::option::Option<std::string::String>,
    /// <p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub portal_status: std::option::Option<crate::model::PortalStatus>,
    /// <p>The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.</p>
    pub sso_application_id: std::option::Option<std::string::String>,
}
impl CreatePortalOutput {
    /// <p>The ID of the created portal.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    pub fn portal_arn(&self) -> std::option::Option<&str> {
        self.portal_arn.as_deref()
    }
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub fn portal_start_url(&self) -> std::option::Option<&str> {
        self.portal_start_url.as_deref()
    }
    /// <p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub fn portal_status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.portal_status.as_ref()
    }
    /// <p>The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.</p>
    pub fn sso_application_id(&self) -> std::option::Option<&str> {
        self.sso_application_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePortalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePortalOutput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("portal_arn", &self.portal_arn);
        formatter.field("portal_start_url", &self.portal_start_url);
        formatter.field("portal_status", &self.portal_status);
        formatter.field("sso_application_id", &self.sso_application_id);
        formatter.finish()
    }
}
/// See [`CreatePortalOutput`](crate::output::CreatePortalOutput)
pub mod create_portal_output {
    /// A builder for [`CreatePortalOutput`](crate::output::CreatePortalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) portal_arn: std::option::Option<std::string::String>,
        pub(crate) portal_start_url: std::option::Option<std::string::String>,
        pub(crate) portal_status: std::option::Option<crate::model::PortalStatus>,
        pub(crate) sso_application_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the created portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the created portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
        pub fn portal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
        pub fn set_portal_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_arn = input;
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn portal_start_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_start_url = Some(input.into());
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn set_portal_start_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_start_url = input;
            self
        }
        /// <p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn portal_status(mut self, input: crate::model::PortalStatus) -> Self {
            self.portal_status = Some(input);
            self
        }
        /// <p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_portal_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.portal_status = input;
            self
        }
        /// <p>The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.</p>
        pub fn sso_application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sso_application_id = Some(input.into());
            self
        }
        /// <p>The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.</p>
        pub fn set_sso_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sso_application_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortalOutput`](crate::output::CreatePortalOutput)
        pub fn build(self) -> crate::output::CreatePortalOutput {
            crate::output::CreatePortalOutput {
                portal_id: self.portal_id,
                portal_arn: self.portal_arn,
                portal_start_url: self.portal_start_url,
                portal_status: self.portal_status,
                sso_application_id: self.sso_application_id,
            }
        }
    }
}
impl CreatePortalOutput {
    /// Creates a new builder-style object to manufacture [`CreatePortalOutput`](crate::output::CreatePortalOutput)
    pub fn builder() -> crate::output::create_portal_output::Builder {
        crate::output::create_portal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayOutput {
    /// <p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise APIs.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    pub gateway_arn: std::option::Option<std::string::String>,
}
impl CreateGatewayOutput {
    /// <p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise APIs.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    pub fn gateway_arn(&self) -> std::option::Option<&str> {
        self.gateway_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateGatewayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayOutput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_arn", &self.gateway_arn);
        formatter.finish()
    }
}
/// See [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
pub mod create_gateway_output {
    /// A builder for [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise APIs.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise APIs.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
        pub fn gateway_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
        pub fn set_gateway_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
        pub fn build(self) -> crate::output::CreateGatewayOutput {
            crate::output::CreateGatewayOutput {
                gateway_id: self.gateway_id,
                gateway_arn: self.gateway_arn,
            }
        }
    }
}
impl CreateGatewayOutput {
    /// Creates a new builder-style object to manufacture [`CreateGatewayOutput`](crate::output::CreateGatewayOutput)
    pub fn builder() -> crate::output::create_gateway_output::Builder {
        crate::output::create_gateway_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDashboardOutput {
    /// <p>The ID of the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    pub dashboard_arn: std::option::Option<std::string::String>,
}
impl CreateDashboardOutput {
    /// <p>The ID of the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDashboardOutput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.finish()
    }
}
/// See [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
pub mod create_dashboard_output {
    /// A builder for [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
        pub fn build(self) -> crate::output::CreateDashboardOutput {
            crate::output::CreateDashboardOutput {
                dashboard_id: self.dashboard_id,
                dashboard_arn: self.dashboard_arn,
            }
        }
    }
}
impl CreateDashboardOutput {
    /// Creates a new builder-style object to manufacture [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
    pub fn builder() -> crate::output::create_dashboard_output::Builder {
        crate::output::create_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetModelOutput {
    /// <p>The ID of the asset model. You can use this ID when you call other IoT SiteWise APIs.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub asset_model_arn: std::option::Option<std::string::String>,
    /// <p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
}
impl CreateAssetModelOutput {
    /// <p>The ID of the asset model. You can use this ID when you call other IoT SiteWise APIs.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub fn asset_model_arn(&self) -> std::option::Option<&str> {
        self.asset_model_arn.as_deref()
    }
    /// <p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_model_status(&self) -> std::option::Option<&crate::model::AssetModelStatus> {
        self.asset_model_status.as_ref()
    }
}
impl std::fmt::Debug for CreateAssetModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetModelOutput");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("asset_model_arn", &self.asset_model_arn);
        formatter.field("asset_model_status", &self.asset_model_status);
        formatter.finish()
    }
}
/// See [`CreateAssetModelOutput`](crate::output::CreateAssetModelOutput)
pub mod create_asset_model_output {
    /// A builder for [`CreateAssetModelOutput`](crate::output::CreateAssetModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) asset_model_arn: std::option::Option<std::string::String>,
        pub(crate) asset_model_status: std::option::Option<crate::model::AssetModelStatus>,
    }
    impl Builder {
        /// <p>The ID of the asset model. You can use this ID when you call other IoT SiteWise APIs.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model. You can use this ID when you call other IoT SiteWise APIs.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn asset_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn set_asset_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_arn = input;
            self
        }
        /// <p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_model_status(mut self, input: crate::model::AssetModelStatus) -> Self {
            self.asset_model_status = Some(input);
            self
        }
        /// <p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_model_status(
            mut self,
            input: std::option::Option<crate::model::AssetModelStatus>,
        ) -> Self {
            self.asset_model_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetModelOutput`](crate::output::CreateAssetModelOutput)
        pub fn build(self) -> crate::output::CreateAssetModelOutput {
            crate::output::CreateAssetModelOutput {
                asset_model_id: self.asset_model_id,
                asset_model_arn: self.asset_model_arn,
                asset_model_status: self.asset_model_status,
            }
        }
    }
}
impl CreateAssetModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssetModelOutput`](crate::output::CreateAssetModelOutput)
    pub fn builder() -> crate::output::create_asset_model_output::Builder {
        crate::output::create_asset_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetOutput {
    /// <p>The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub asset_arn: std::option::Option<std::string::String>,
    /// <p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub asset_status: std::option::Option<crate::model::AssetStatus>,
}
impl CreateAssetOutput {
    /// <p>The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub fn asset_arn(&self) -> std::option::Option<&str> {
        self.asset_arn.as_deref()
    }
    /// <p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    pub fn asset_status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.asset_status.as_ref()
    }
}
impl std::fmt::Debug for CreateAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetOutput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("asset_arn", &self.asset_arn);
        formatter.field("asset_status", &self.asset_status);
        formatter.finish()
    }
}
/// See [`CreateAssetOutput`](crate::output::CreateAssetOutput)
pub mod create_asset_output {
    /// A builder for [`CreateAssetOutput`](crate::output::CreateAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) asset_arn: std::option::Option<std::string::String>,
        pub(crate) asset_status: std::option::Option<crate::model::AssetStatus>,
    }
    impl Builder {
        /// <p>The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn asset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn set_asset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_arn = input;
            self
        }
        /// <p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn asset_status(mut self, input: crate::model::AssetStatus) -> Self {
            self.asset_status = Some(input);
            self
        }
        /// <p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
        pub fn set_asset_status(
            mut self,
            input: std::option::Option<crate::model::AssetStatus>,
        ) -> Self {
            self.asset_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetOutput`](crate::output::CreateAssetOutput)
        pub fn build(self) -> crate::output::CreateAssetOutput {
            crate::output::CreateAssetOutput {
                asset_id: self.asset_id,
                asset_arn: self.asset_arn,
                asset_status: self.asset_status,
            }
        }
    }
}
impl CreateAssetOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssetOutput`](crate::output::CreateAssetOutput)
    pub fn builder() -> crate::output::create_asset_output::Builder {
        crate::output::create_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPolicyOutput {
    /// <p>The ID of the access policy.</p>
    pub access_policy_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    pub access_policy_arn: std::option::Option<std::string::String>,
}
impl CreateAccessPolicyOutput {
    /// <p>The ID of the access policy.</p>
    pub fn access_policy_id(&self) -> std::option::Option<&str> {
        self.access_policy_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    pub fn access_policy_arn(&self) -> std::option::Option<&str> {
        self.access_policy_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPolicyOutput");
        formatter.field("access_policy_id", &self.access_policy_id);
        formatter.field("access_policy_arn", &self.access_policy_arn);
        formatter.finish()
    }
}
/// See [`CreateAccessPolicyOutput`](crate::output::CreateAccessPolicyOutput)
pub mod create_access_policy_output {
    /// A builder for [`CreateAccessPolicyOutput`](crate::output::CreateAccessPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_id: std::option::Option<std::string::String>,
        pub(crate) access_policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
        pub fn access_policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
        pub fn set_access_policy_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPolicyOutput`](crate::output::CreateAccessPolicyOutput)
        pub fn build(self) -> crate::output::CreateAccessPolicyOutput {
            crate::output::CreateAccessPolicyOutput {
                access_policy_id: self.access_policy_id,
                access_policy_arn: self.access_policy_arn,
            }
        }
    }
}
impl CreateAccessPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessPolicyOutput`](crate::output::CreateAccessPolicyOutput)
    pub fn builder() -> crate::output::create_access_policy_output::Builder {
        crate::output::create_access_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutAssetPropertyValueOutput {
    /// <p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>
    pub error_entries:
        std::option::Option<std::vec::Vec<crate::model::BatchPutAssetPropertyErrorEntry>>,
}
impl BatchPutAssetPropertyValueOutput {
    /// <p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>
    pub fn error_entries(
        &self,
    ) -> std::option::Option<&[crate::model::BatchPutAssetPropertyErrorEntry]> {
        self.error_entries.as_deref()
    }
}
impl std::fmt::Debug for BatchPutAssetPropertyValueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutAssetPropertyValueOutput");
        formatter.field("error_entries", &self.error_entries);
        formatter.finish()
    }
}
/// See [`BatchPutAssetPropertyValueOutput`](crate::output::BatchPutAssetPropertyValueOutput)
pub mod batch_put_asset_property_value_output {
    /// A builder for [`BatchPutAssetPropertyValueOutput`](crate::output::BatchPutAssetPropertyValueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_entries:
            std::option::Option<std::vec::Vec<crate::model::BatchPutAssetPropertyErrorEntry>>,
    }
    impl Builder {
        /// Appends an item to `error_entries`.
        ///
        /// To override the contents of this collection use [`set_error_entries`](Self::set_error_entries).
        ///
        /// <p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>
        pub fn error_entries(
            mut self,
            input: crate::model::BatchPutAssetPropertyErrorEntry,
        ) -> Self {
            let mut v = self.error_entries.unwrap_or_default();
            v.push(input);
            self.error_entries = Some(v);
            self
        }
        /// <p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>
        pub fn set_error_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchPutAssetPropertyErrorEntry>,
            >,
        ) -> Self {
            self.error_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutAssetPropertyValueOutput`](crate::output::BatchPutAssetPropertyValueOutput)
        pub fn build(self) -> crate::output::BatchPutAssetPropertyValueOutput {
            crate::output::BatchPutAssetPropertyValueOutput {
                error_entries: self.error_entries,
            }
        }
    }
}
impl BatchPutAssetPropertyValueOutput {
    /// Creates a new builder-style object to manufacture [`BatchPutAssetPropertyValueOutput`](crate::output::BatchPutAssetPropertyValueOutput)
    pub fn builder() -> crate::output::batch_put_asset_property_value_output::Builder {
        crate::output::batch_put_asset_property_value_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateProjectAssetsOutput {
    /// <p>A list of associated error information, if any.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
}
impl BatchDisassociateProjectAssetsOutput {
    /// <p>A list of associated error information, if any.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::AssetErrorDetails]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateProjectAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateProjectAssetsOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDisassociateProjectAssetsOutput`](crate::output::BatchDisassociateProjectAssetsOutput)
pub mod batch_disassociate_project_assets_output {
    /// A builder for [`BatchDisassociateProjectAssetsOutput`](crate::output::BatchDisassociateProjectAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of associated error information, if any.</p>
        pub fn errors(mut self, input: crate::model::AssetErrorDetails) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of associated error information, if any.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateProjectAssetsOutput`](crate::output::BatchDisassociateProjectAssetsOutput)
        pub fn build(self) -> crate::output::BatchDisassociateProjectAssetsOutput {
            crate::output::BatchDisassociateProjectAssetsOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDisassociateProjectAssetsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateProjectAssetsOutput`](crate::output::BatchDisassociateProjectAssetsOutput)
    pub fn builder() -> crate::output::batch_disassociate_project_assets_output::Builder {
        crate::output::batch_disassociate_project_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateProjectAssetsOutput {
    /// <p>A list of associated error information, if any.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
}
impl BatchAssociateProjectAssetsOutput {
    /// <p>A list of associated error information, if any.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::AssetErrorDetails]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateProjectAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateProjectAssetsOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchAssociateProjectAssetsOutput`](crate::output::BatchAssociateProjectAssetsOutput)
pub mod batch_associate_project_assets_output {
    /// A builder for [`BatchAssociateProjectAssetsOutput`](crate::output::BatchAssociateProjectAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of associated error information, if any.</p>
        pub fn errors(mut self, input: crate::model::AssetErrorDetails) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of associated error information, if any.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetErrorDetails>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateProjectAssetsOutput`](crate::output::BatchAssociateProjectAssetsOutput)
        pub fn build(self) -> crate::output::BatchAssociateProjectAssetsOutput {
            crate::output::BatchAssociateProjectAssetsOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchAssociateProjectAssetsOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateProjectAssetsOutput`](crate::output::BatchAssociateProjectAssetsOutput)
    pub fn builder() -> crate::output::batch_associate_project_assets_output::Builder {
        crate::output::batch_associate_project_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTimeSeriesToAssetPropertyOutput {}
impl std::fmt::Debug for AssociateTimeSeriesToAssetPropertyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTimeSeriesToAssetPropertyOutput");
        formatter.finish()
    }
}
/// See [`AssociateTimeSeriesToAssetPropertyOutput`](crate::output::AssociateTimeSeriesToAssetPropertyOutput)
pub mod associate_time_series_to_asset_property_output {
    /// A builder for [`AssociateTimeSeriesToAssetPropertyOutput`](crate::output::AssociateTimeSeriesToAssetPropertyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateTimeSeriesToAssetPropertyOutput`](crate::output::AssociateTimeSeriesToAssetPropertyOutput)
        pub fn build(self) -> crate::output::AssociateTimeSeriesToAssetPropertyOutput {
            crate::output::AssociateTimeSeriesToAssetPropertyOutput {}
        }
    }
}
impl AssociateTimeSeriesToAssetPropertyOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTimeSeriesToAssetPropertyOutput`](crate::output::AssociateTimeSeriesToAssetPropertyOutput)
    pub fn builder() -> crate::output::associate_time_series_to_asset_property_output::Builder {
        crate::output::associate_time_series_to_asset_property_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAssetsOutput {}
impl std::fmt::Debug for AssociateAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAssetsOutput");
        formatter.finish()
    }
}
/// See [`AssociateAssetsOutput`](crate::output::AssociateAssetsOutput)
pub mod associate_assets_output {
    /// A builder for [`AssociateAssetsOutput`](crate::output::AssociateAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateAssetsOutput`](crate::output::AssociateAssetsOutput)
        pub fn build(self) -> crate::output::AssociateAssetsOutput {
            crate::output::AssociateAssetsOutput {}
        }
    }
}
impl AssociateAssetsOutput {
    /// Creates a new builder-style object to manufacture [`AssociateAssetsOutput`](crate::output::AssociateAssetsOutput)
    pub fn builder() -> crate::output::associate_assets_output::Builder {
        crate::output::associate_assets_output::Builder::default()
    }
}
