// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about the current status of a portal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortalStatus {
    /// <p>The current state of the portal.</p>
    pub state: std::option::Option<crate::model::PortalState>,
    /// <p>Contains associated error information, if any.</p>
    pub error: std::option::Option<crate::model::MonitorErrorDetails>,
}
impl PortalStatus {
    /// <p>The current state of the portal.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::PortalState> {
        self.state.as_ref()
    }
    /// <p>Contains associated error information, if any.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::MonitorErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for PortalStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortalStatus");
        formatter.field("state", &self.state);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`PortalStatus`](crate::model::PortalStatus)
pub mod portal_status {
    /// A builder for [`PortalStatus`](crate::model::PortalStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::PortalState>,
        pub(crate) error: std::option::Option<crate::model::MonitorErrorDetails>,
    }
    impl Builder {
        /// <p>The current state of the portal.</p>
        pub fn state(mut self, input: crate::model::PortalState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the portal.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::PortalState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn error(mut self, input: crate::model::MonitorErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::MonitorErrorDetails>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`PortalStatus`](crate::model::PortalStatus)
        pub fn build(self) -> crate::model::PortalStatus {
            crate::model::PortalStatus {
                state: self.state,
                error: self.error,
            }
        }
    }
}
impl PortalStatus {
    /// Creates a new builder-style object to manufacture [`PortalStatus`](crate::model::PortalStatus)
    pub fn builder() -> crate::model::portal_status::Builder {
        crate::model::portal_status::Builder::default()
    }
}

/// <p>Contains IoT SiteWise Monitor error details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitorErrorDetails {
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::MonitorErrorCode>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl MonitorErrorDetails {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::MonitorErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for MonitorErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitorErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`MonitorErrorDetails`](crate::model::MonitorErrorDetails)
pub mod monitor_error_details {
    /// A builder for [`MonitorErrorDetails`](crate::model::MonitorErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::MonitorErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::MonitorErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::MonitorErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitorErrorDetails`](crate::model::MonitorErrorDetails)
        pub fn build(self) -> crate::model::MonitorErrorDetails {
            crate::model::MonitorErrorDetails {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl MonitorErrorDetails {
    /// Creates a new builder-style object to manufacture [`MonitorErrorDetails`](crate::model::MonitorErrorDetails)
    pub fn builder() -> crate::model::monitor_error_details::Builder {
        crate::model::monitor_error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MonitorErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MonitorErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_FAILURE" => MonitorErrorCode::InternalFailure,
            "LIMIT_EXCEEDED" => MonitorErrorCode::LimitExceeded,
            "VALIDATION_ERROR" => MonitorErrorCode::ValidationError,
            other => MonitorErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MonitorErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MonitorErrorCode::from(s))
    }
}
impl MonitorErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MonitorErrorCode::InternalFailure => "INTERNAL_FAILURE",
            MonitorErrorCode::LimitExceeded => "LIMIT_EXCEEDED",
            MonitorErrorCode::ValidationError => "VALIDATION_ERROR",
            MonitorErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_FAILURE", "LIMIT_EXCEEDED", "VALIDATION_ERROR"]
    }
}
impl AsRef<str> for MonitorErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortalState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortalState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => PortalState::Active,
            "CREATING" => PortalState::Creating,
            "DELETING" => PortalState::Deleting,
            "FAILED" => PortalState::Failed,
            "UPDATING" => PortalState::Updating,
            other => PortalState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortalState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortalState::from(s))
    }
}
impl PortalState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortalState::Active => "ACTIVE",
            PortalState::Creating => "CREATING",
            PortalState::Deleting => "DELETING",
            PortalState::Failed => "FAILED",
            PortalState::Updating => "UPDATING",
            PortalState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for PortalState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarms {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT Events.</p>
    pub alarm_role_arn: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function that manages alarm notifications. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm notifications</a> in the <i>IoT Events Developer Guide</i>.</p>
    pub notification_lambda_arn: std::option::Option<std::string::String>,
}
impl Alarms {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT Events.</p>
    pub fn alarm_role_arn(&self) -> std::option::Option<&str> {
        self.alarm_role_arn.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function that manages alarm notifications. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm notifications</a> in the <i>IoT Events Developer Guide</i>.</p>
    pub fn notification_lambda_arn(&self) -> std::option::Option<&str> {
        self.notification_lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for Alarms {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarms");
        formatter.field("alarm_role_arn", &self.alarm_role_arn);
        formatter.field("notification_lambda_arn", &self.notification_lambda_arn);
        formatter.finish()
    }
}
/// See [`Alarms`](crate::model::Alarms)
pub mod alarms {
    /// A builder for [`Alarms`](crate::model::Alarms)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_role_arn: std::option::Option<std::string::String>,
        pub(crate) notification_lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT Events.</p>
        pub fn alarm_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT Events.</p>
        pub fn set_alarm_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_role_arn = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function that manages alarm notifications. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm notifications</a> in the <i>IoT Events Developer Guide</i>.</p>
        pub fn notification_lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_lambda_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function that manages alarm notifications. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm notifications</a> in the <i>IoT Events Developer Guide</i>.</p>
        pub fn set_notification_lambda_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarms`](crate::model::Alarms)
        pub fn build(self) -> crate::model::Alarms {
            crate::model::Alarms {
                alarm_role_arn: self.alarm_role_arn,
                notification_lambda_arn: self.notification_lambda_arn,
            }
        }
    }
}
impl Alarms {
    /// Creates a new builder-style object to manufacture [`Alarms`](crate::model::Alarms)
    pub fn builder() -> crate::model::alarms::Builder {
        crate::model::alarms::Builder::default()
    }
}

/// <p>Contains an image that is one of the following:</p>
/// <ul>
/// <li> <p>An image file. Choose this option to upload a new image.</p> </li>
/// <li> <p>The ID of an existing image. Choose this option to keep an existing image.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>The ID of an existing image. Specify this parameter to keep an existing image.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Contains an image file.</p>
    pub file: std::option::Option<crate::model::ImageFile>,
}
impl Image {
    /// <p>The ID of an existing image. Specify this parameter to keep an existing image.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Contains an image file.</p>
    pub fn file(&self) -> std::option::Option<&crate::model::ImageFile> {
        self.file.as_ref()
    }
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("id", &self.id);
        formatter.field("file", &self.file);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) file: std::option::Option<crate::model::ImageFile>,
    }
    impl Builder {
        /// <p>The ID of an existing image. Specify this parameter to keep an existing image.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of an existing image. Specify this parameter to keep an existing image.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Contains an image file.</p>
        pub fn file(mut self, input: crate::model::ImageFile) -> Self {
            self.file = Some(input);
            self
        }
        /// <p>Contains an image file.</p>
        pub fn set_file(mut self, input: std::option::Option<crate::model::ImageFile>) -> Self {
            self.file = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                id: self.id,
                file: self.file,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

/// <p>Contains an image file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageFile {
    /// <p>The image file contents, represented as a base64-encoded string. The file size must be less than 1 MB.</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The file type of the image.</p>
    pub r#type: std::option::Option<crate::model::ImageFileType>,
}
impl ImageFile {
    /// <p>The image file contents, represented as a base64-encoded string. The file size must be less than 1 MB.</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
    /// <p>The file type of the image.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ImageFileType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ImageFile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageFile");
        formatter.field("data", &self.data);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ImageFile`](crate::model::ImageFile)
pub mod image_file {
    /// A builder for [`ImageFile`](crate::model::ImageFile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) r#type: std::option::Option<crate::model::ImageFileType>,
    }
    impl Builder {
        /// <p>The image file contents, represented as a base64-encoded string. The file size must be less than 1 MB.</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The image file contents, represented as a base64-encoded string. The file size must be less than 1 MB.</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// <p>The file type of the image.</p>
        pub fn r#type(mut self, input: crate::model::ImageFileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The file type of the image.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ImageFileType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageFile`](crate::model::ImageFile)
        pub fn build(self) -> crate::model::ImageFile {
            crate::model::ImageFile {
                data: self.data,
                r#type: self.r#type,
            }
        }
    }
}
impl ImageFile {
    /// Creates a new builder-style object to manufacture [`ImageFile`](crate::model::ImageFile)
    pub fn builder() -> crate::model::image_file::Builder {
        crate::model::image_file::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageFileType {
    #[allow(missing_docs)] // documentation missing in model
    Png,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageFileType {
    fn from(s: &str) -> Self {
        match s {
            "PNG" => ImageFileType::Png,
            other => ImageFileType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageFileType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageFileType::from(s))
    }
}
impl ImageFileType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageFileType::Png => "PNG",
            ImageFileType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PNG"]
    }
}
impl AsRef<str> for ImageFileType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `CapabilitySyncStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapabilitySyncStatus {
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    OutOfSync,
    #[allow(missing_docs)] // documentation missing in model
    SyncFailed,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapabilitySyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "IN_SYNC" => CapabilitySyncStatus::InSync,
            "OUT_OF_SYNC" => CapabilitySyncStatus::OutOfSync,
            "SYNC_FAILED" => CapabilitySyncStatus::SyncFailed,
            "UNKNOWN" => CapabilitySyncStatus::UnknownValue,
            other => CapabilitySyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapabilitySyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapabilitySyncStatus::from(s))
    }
}
impl CapabilitySyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapabilitySyncStatus::InSync => "IN_SYNC",
            CapabilitySyncStatus::OutOfSync => "OUT_OF_SYNC",
            CapabilitySyncStatus::SyncFailed => "SYNC_FAILED",
            CapabilitySyncStatus::UnknownValue => "UNKNOWN",
            CapabilitySyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IN_SYNC", "OUT_OF_SYNC", "SYNC_FAILED", "UNKNOWN"]
    }
}
impl AsRef<str> for CapabilitySyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropertyNotificationState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropertyNotificationState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => PropertyNotificationState::Disabled,
            "ENABLED" => PropertyNotificationState::Enabled,
            other => PropertyNotificationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropertyNotificationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropertyNotificationState::from(s))
    }
}
impl PropertyNotificationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropertyNotificationState::Disabled => "DISABLED",
            PropertyNotificationState::Enabled => "ENABLED",
            PropertyNotificationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for PropertyNotificationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains current status information for an asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html">Asset and model states</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelStatus {
    /// <p>The current state of the asset model.</p>
    pub state: std::option::Option<crate::model::AssetModelState>,
    /// <p>Contains associated error information, if any.</p>
    pub error: std::option::Option<crate::model::ErrorDetails>,
}
impl AssetModelStatus {
    /// <p>The current state of the asset model.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AssetModelState> {
        self.state.as_ref()
    }
    /// <p>Contains associated error information, if any.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for AssetModelStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelStatus");
        formatter.field("state", &self.state);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`AssetModelStatus`](crate::model::AssetModelStatus)
pub mod asset_model_status {
    /// A builder for [`AssetModelStatus`](crate::model::AssetModelStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::AssetModelState>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The current state of the asset model.</p>
        pub fn state(mut self, input: crate::model::AssetModelState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the asset model.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AssetModelState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn error(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetails>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelStatus`](crate::model::AssetModelStatus)
        pub fn build(self) -> crate::model::AssetModelStatus {
            crate::model::AssetModelStatus {
                state: self.state,
                error: self.error,
            }
        }
    }
}
impl AssetModelStatus {
    /// Creates a new builder-style object to manufacture [`AssetModelStatus`](crate::model::AssetModelStatus)
    pub fn builder() -> crate::model::asset_model_status::Builder {
        crate::model::asset_model_status::Builder::default()
    }
}

/// <p>Contains the details of an IoT SiteWise error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetails {
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p> A list of detailed errors. </p>
    pub details: std::option::Option<std::vec::Vec<crate::model::DetailedError>>,
}
impl ErrorDetails {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p> A list of detailed errors. </p>
    pub fn details(&self) -> std::option::Option<&[crate::model::DetailedError]> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ErrorDetails`](crate::model::ErrorDetails)
pub mod error_details {
    /// A builder for [`ErrorDetails`](crate::model::ErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::vec::Vec<crate::model::DetailedError>>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p> A list of detailed errors. </p>
        pub fn details(mut self, input: crate::model::DetailedError) -> Self {
            let mut v = self.details.unwrap_or_default();
            v.push(input);
            self.details = Some(v);
            self
        }
        /// <p> A list of detailed errors. </p>
        pub fn set_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DetailedError>>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetails`](crate::model::ErrorDetails)
        pub fn build(self) -> crate::model::ErrorDetails {
            crate::model::ErrorDetails {
                code: self.code,
                message: self.message,
                details: self.details,
            }
        }
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::model::ErrorDetails)
    pub fn builder() -> crate::model::error_details::Builder {
        crate::model::error_details::Builder::default()
    }
}

/// <p>Contains detailed error information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetailedError {
    /// <p>The error code. </p>
    pub code: std::option::Option<crate::model::DetailedErrorCode>,
    /// <p>The error message. </p>
    pub message: std::option::Option<std::string::String>,
}
impl DetailedError {
    /// <p>The error code. </p>
    pub fn code(&self) -> std::option::Option<&crate::model::DetailedErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DetailedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetailedError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DetailedError`](crate::model::DetailedError)
pub mod detailed_error {
    /// A builder for [`DetailedError`](crate::model::DetailedError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::DetailedErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code. </p>
        pub fn code(mut self, input: crate::model::DetailedErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code. </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::DetailedErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DetailedError`](crate::model::DetailedError)
        pub fn build(self) -> crate::model::DetailedError {
            crate::model::DetailedError {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl DetailedError {
    /// Creates a new builder-style object to manufacture [`DetailedError`](crate::model::DetailedError)
    pub fn builder() -> crate::model::detailed_error::Builder {
        crate::model::detailed_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetailedErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleComputeLocation,
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleForwardingConfiguration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetailedErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INCOMPATIBLE_COMPUTE_LOCATION" => DetailedErrorCode::IncompatibleComputeLocation,
            "INCOMPATIBLE_FORWARDING_CONFIGURATION" => {
                DetailedErrorCode::IncompatibleForwardingConfiguration
            }
            other => DetailedErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetailedErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetailedErrorCode::from(s))
    }
}
impl DetailedErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetailedErrorCode::IncompatibleComputeLocation => "INCOMPATIBLE_COMPUTE_LOCATION",
            DetailedErrorCode::IncompatibleForwardingConfiguration => {
                "INCOMPATIBLE_FORWARDING_CONFIGURATION"
            }
            DetailedErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "INCOMPATIBLE_COMPUTE_LOCATION",
            "INCOMPATIBLE_FORWARDING_CONFIGURATION",
        ]
    }
}
impl AsRef<str> for DetailedErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_FAILURE" => ErrorCode::InternalFailure,
            "VALIDATION_ERROR" => ErrorCode::ValidationError,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::InternalFailure => "INTERNAL_FAILURE",
            ErrorCode::ValidationError => "VALIDATION_ERROR",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_FAILURE", "VALIDATION_ERROR"]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetModelState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Propagating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetModelState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AssetModelState::Active,
            "CREATING" => AssetModelState::Creating,
            "DELETING" => AssetModelState::Deleting,
            "FAILED" => AssetModelState::Failed,
            "PROPAGATING" => AssetModelState::Propagating,
            "UPDATING" => AssetModelState::Updating,
            other => AssetModelState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetModelState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetModelState::from(s))
    }
}
impl AssetModelState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetModelState::Active => "ACTIVE",
            AssetModelState::Creating => "CREATING",
            AssetModelState::Deleting => "DELETING",
            AssetModelState::Failed => "FAILED",
            AssetModelState::Propagating => "PROPAGATING",
            AssetModelState::Updating => "UPDATING",
            AssetModelState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "DELETING",
            "FAILED",
            "PROPAGATING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for AssetModelState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a composite model in an asset model. This object contains the asset property definitions that you define in the composite model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelCompositeModel {
    /// <p>The name of the composite model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the composite model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The asset property definitions for this composite model.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
}
impl AssetModelCompositeModel {
    /// <p>The name of the composite model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the composite model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The asset property definitions for this composite model.</p>
    pub fn properties(&self) -> std::option::Option<&[crate::model::AssetModelProperty]> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for AssetModelCompositeModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelCompositeModel");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`AssetModelCompositeModel`](crate::model::AssetModelCompositeModel)
pub mod asset_model_composite_model {
    /// A builder for [`AssetModelCompositeModel`](crate::model::AssetModelCompositeModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
    }
    impl Builder {
        /// <p>The name of the composite model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the composite model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The asset property definitions for this composite model.</p>
        pub fn properties(mut self, input: crate::model::AssetModelProperty) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input);
            self.properties = Some(v);
            self
        }
        /// <p>The asset property definitions for this composite model.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelCompositeModel`](crate::model::AssetModelCompositeModel)
        pub fn build(self) -> crate::model::AssetModelCompositeModel {
            crate::model::AssetModelCompositeModel {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                properties: self.properties,
            }
        }
    }
}
impl AssetModelCompositeModel {
    /// Creates a new builder-style object to manufacture [`AssetModelCompositeModel`](crate::model::AssetModelCompositeModel)
    pub fn builder() -> crate::model::asset_model_composite_model::Builder {
        crate::model::asset_model_composite_model::Builder::default()
    }
}

/// <p>Contains information about an asset model property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelProperty {
    /// <p>The ID of the asset model property.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the asset model property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the asset model property.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
    pub data_type_spec: std::option::Option<std::string::String>,
    /// <p>The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The property type (see <code>PropertyType</code>).</p>
    pub r#type: std::option::Option<crate::model::PropertyType>,
}
impl AssetModelProperty {
    /// <p>The ID of the asset model property.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the asset model property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the asset model property.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
    pub fn data_type_spec(&self) -> std::option::Option<&str> {
        self.data_type_spec.as_deref()
    }
    /// <p>The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The property type (see <code>PropertyType</code>).</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PropertyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for AssetModelProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelProperty");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_type_spec", &self.data_type_spec);
        formatter.field("unit", &self.unit);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AssetModelProperty`](crate::model::AssetModelProperty)
pub mod asset_model_property {
    /// A builder for [`AssetModelProperty`](crate::model::AssetModelProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) data_type_spec: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PropertyType>,
    }
    impl Builder {
        /// <p>The ID of the asset model property.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model property.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the asset model property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset model property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the asset model property.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the asset model property.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
        pub fn data_type_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type_spec = Some(input.into());
            self
        }
        /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
        pub fn set_data_type_spec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_type_spec = input;
            self
        }
        /// <p>The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The property type (see <code>PropertyType</code>).</p>
        pub fn r#type(mut self, input: crate::model::PropertyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The property type (see <code>PropertyType</code>).</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PropertyType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelProperty`](crate::model::AssetModelProperty)
        pub fn build(self) -> crate::model::AssetModelProperty {
            crate::model::AssetModelProperty {
                id: self.id,
                name: self.name,
                data_type: self.data_type,
                data_type_spec: self.data_type_spec,
                unit: self.unit,
                r#type: self.r#type,
            }
        }
    }
}
impl AssetModelProperty {
    /// Creates a new builder-style object to manufacture [`AssetModelProperty`](crate::model::AssetModelProperty)
    pub fn builder() -> crate::model::asset_model_property::Builder {
        crate::model::asset_model_property::Builder::default()
    }
}

/// <p>Contains a property type, which can be one of <code>attribute</code>, <code>measurement</code>, <code>metric</code>, or <code>transform</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyType {
    /// <p>Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.</p>
    pub attribute: std::option::Option<crate::model::Attribute>,
    /// <p>Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as timestamped temperature values or timestamped power values.</p>
    pub measurement: std::option::Option<crate::model::Measurement>,
    /// <p>Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.</p>
    pub transform: std::option::Option<crate::model::Transform>,
    /// <p>Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.</p>
    pub metric: std::option::Option<crate::model::Metric>,
}
impl PropertyType {
    /// <p>Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.</p>
    pub fn attribute(&self) -> std::option::Option<&crate::model::Attribute> {
        self.attribute.as_ref()
    }
    /// <p>Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as timestamped temperature values or timestamped power values.</p>
    pub fn measurement(&self) -> std::option::Option<&crate::model::Measurement> {
        self.measurement.as_ref()
    }
    /// <p>Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.</p>
    pub fn transform(&self) -> std::option::Option<&crate::model::Transform> {
        self.transform.as_ref()
    }
    /// <p>Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.</p>
    pub fn metric(&self) -> std::option::Option<&crate::model::Metric> {
        self.metric.as_ref()
    }
}
impl std::fmt::Debug for PropertyType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyType");
        formatter.field("attribute", &self.attribute);
        formatter.field("measurement", &self.measurement);
        formatter.field("transform", &self.transform);
        formatter.field("metric", &self.metric);
        formatter.finish()
    }
}
/// See [`PropertyType`](crate::model::PropertyType)
pub mod property_type {
    /// A builder for [`PropertyType`](crate::model::PropertyType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::Attribute>,
        pub(crate) measurement: std::option::Option<crate::model::Measurement>,
        pub(crate) transform: std::option::Option<crate::model::Transform>,
        pub(crate) metric: std::option::Option<crate::model::Metric>,
    }
    impl Builder {
        /// <p>Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.</p>
        pub fn attribute(mut self, input: crate::model::Attribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::Attribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as timestamped temperature values or timestamped power values.</p>
        pub fn measurement(mut self, input: crate::model::Measurement) -> Self {
            self.measurement = Some(input);
            self
        }
        /// <p>Specifies an asset measurement property. A measurement represents a device's raw sensor data stream, such as timestamped temperature values or timestamped power values.</p>
        pub fn set_measurement(
            mut self,
            input: std::option::Option<crate::model::Measurement>,
        ) -> Self {
            self.measurement = input;
            self
        }
        /// <p>Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.</p>
        pub fn transform(mut self, input: crate::model::Transform) -> Self {
            self.transform = Some(input);
            self
        }
        /// <p>Specifies an asset transform property. A transform contains a mathematical expression that maps a property's data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.</p>
        pub fn set_transform(
            mut self,
            input: std::option::Option<crate::model::Transform>,
        ) -> Self {
            self.transform = input;
            self
        }
        /// <p>Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.</p>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.</p>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.metric = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyType`](crate::model::PropertyType)
        pub fn build(self) -> crate::model::PropertyType {
            crate::model::PropertyType {
                attribute: self.attribute,
                measurement: self.measurement,
                transform: self.transform,
                metric: self.metric,
            }
        }
    }
}
impl PropertyType {
    /// Creates a new builder-style object to manufacture [`PropertyType`](crate::model::PropertyType)
    pub fn builder() -> crate::model::property_type::Builder {
        crate::model::property_type::Builder::default()
    }
}

/// <p>Contains an asset metric property. With metrics, you can calculate aggregate functions, such as an average, maximum, or minimum, as specified through an expression. A metric maps several values to a single value (such as a sum).</p>
/// <p>The maximum number of dependent/cascading variables used in any one metric calculation is 10. Therefore, a <i>root</i> metric can have up to 10 cascading metrics in its computational dependency tree. Additionally, a metric can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics">Metrics</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metric {
    /// <p>The mathematical expression that defines the metric aggregation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The list of variables used in the expression.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
    /// <p>The window (time interval) over which IoT SiteWise computes the metric's aggregation expression. IoT SiteWise computes one data point per <code>window</code>.</p>
    pub window: std::option::Option<crate::model::MetricWindow>,
    /// <p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>
    pub processing_config: std::option::Option<crate::model::MetricProcessingConfig>,
}
impl Metric {
    /// <p>The mathematical expression that defines the metric aggregation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The list of variables used in the expression.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::ExpressionVariable]> {
        self.variables.as_deref()
    }
    /// <p>The window (time interval) over which IoT SiteWise computes the metric's aggregation expression. IoT SiteWise computes one data point per <code>window</code>.</p>
    pub fn window(&self) -> std::option::Option<&crate::model::MetricWindow> {
        self.window.as_ref()
    }
    /// <p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>
    pub fn processing_config(&self) -> std::option::Option<&crate::model::MetricProcessingConfig> {
        self.processing_config.as_ref()
    }
}
impl std::fmt::Debug for Metric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metric");
        formatter.field("expression", &self.expression);
        formatter.field("variables", &self.variables);
        formatter.field("window", &self.window);
        formatter.field("processing_config", &self.processing_config);
        formatter.finish()
    }
}
/// See [`Metric`](crate::model::Metric)
pub mod metric {
    /// A builder for [`Metric`](crate::model::Metric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
        pub(crate) window: std::option::Option<crate::model::MetricWindow>,
        pub(crate) processing_config: std::option::Option<crate::model::MetricProcessingConfig>,
    }
    impl Builder {
        /// <p>The mathematical expression that defines the metric aggregation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The mathematical expression that defines the metric aggregation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The list of variables used in the expression.</p>
        pub fn variables(mut self, input: crate::model::ExpressionVariable) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input);
            self.variables = Some(v);
            self
        }
        /// <p>The list of variables used in the expression.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The window (time interval) over which IoT SiteWise computes the metric's aggregation expression. IoT SiteWise computes one data point per <code>window</code>.</p>
        pub fn window(mut self, input: crate::model::MetricWindow) -> Self {
            self.window = Some(input);
            self
        }
        /// <p>The window (time interval) over which IoT SiteWise computes the metric's aggregation expression. IoT SiteWise computes one data point per <code>window</code>.</p>
        pub fn set_window(
            mut self,
            input: std::option::Option<crate::model::MetricWindow>,
        ) -> Self {
            self.window = input;
            self
        }
        /// <p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>
        pub fn processing_config(mut self, input: crate::model::MetricProcessingConfig) -> Self {
            self.processing_config = Some(input);
            self
        }
        /// <p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>
        pub fn set_processing_config(
            mut self,
            input: std::option::Option<crate::model::MetricProcessingConfig>,
        ) -> Self {
            self.processing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Metric`](crate::model::Metric)
        pub fn build(self) -> crate::model::Metric {
            crate::model::Metric {
                expression: self.expression,
                variables: self.variables,
                window: self.window,
                processing_config: self.processing_config,
            }
        }
    }
}
impl Metric {
    /// Creates a new builder-style object to manufacture [`Metric`](crate::model::Metric)
    pub fn builder() -> crate::model::metric::Builder {
        crate::model::metric::Builder::default()
    }
}

/// <p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricProcessingConfig {
    /// <p>The compute location for the given metric property. </p>
    pub compute_location: std::option::Option<crate::model::ComputeLocation>,
}
impl MetricProcessingConfig {
    /// <p>The compute location for the given metric property. </p>
    pub fn compute_location(&self) -> std::option::Option<&crate::model::ComputeLocation> {
        self.compute_location.as_ref()
    }
}
impl std::fmt::Debug for MetricProcessingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricProcessingConfig");
        formatter.field("compute_location", &self.compute_location);
        formatter.finish()
    }
}
/// See [`MetricProcessingConfig`](crate::model::MetricProcessingConfig)
pub mod metric_processing_config {
    /// A builder for [`MetricProcessingConfig`](crate::model::MetricProcessingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compute_location: std::option::Option<crate::model::ComputeLocation>,
    }
    impl Builder {
        /// <p>The compute location for the given metric property. </p>
        pub fn compute_location(mut self, input: crate::model::ComputeLocation) -> Self {
            self.compute_location = Some(input);
            self
        }
        /// <p>The compute location for the given metric property. </p>
        pub fn set_compute_location(
            mut self,
            input: std::option::Option<crate::model::ComputeLocation>,
        ) -> Self {
            self.compute_location = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricProcessingConfig`](crate::model::MetricProcessingConfig)
        pub fn build(self) -> crate::model::MetricProcessingConfig {
            crate::model::MetricProcessingConfig {
                compute_location: self.compute_location,
            }
        }
    }
}
impl MetricProcessingConfig {
    /// Creates a new builder-style object to manufacture [`MetricProcessingConfig`](crate::model::MetricProcessingConfig)
    pub fn builder() -> crate::model::metric_processing_config::Builder {
        crate::model::metric_processing_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeLocation {
    #[allow(missing_docs)] // documentation missing in model
    Cloud,
    #[allow(missing_docs)] // documentation missing in model
    Edge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeLocation {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD" => ComputeLocation::Cloud,
            "EDGE" => ComputeLocation::Edge,
            other => ComputeLocation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeLocation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeLocation::from(s))
    }
}
impl ComputeLocation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeLocation::Cloud => "CLOUD",
            ComputeLocation::Edge => "EDGE",
            ComputeLocation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD", "EDGE"]
    }
}
impl AsRef<str> for ComputeLocation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricWindow {
    /// <p>The tumbling time interval window.</p>
    pub tumbling: std::option::Option<crate::model::TumblingWindow>,
}
impl MetricWindow {
    /// <p>The tumbling time interval window.</p>
    pub fn tumbling(&self) -> std::option::Option<&crate::model::TumblingWindow> {
        self.tumbling.as_ref()
    }
}
impl std::fmt::Debug for MetricWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricWindow");
        formatter.field("tumbling", &self.tumbling);
        formatter.finish()
    }
}
/// See [`MetricWindow`](crate::model::MetricWindow)
pub mod metric_window {
    /// A builder for [`MetricWindow`](crate::model::MetricWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tumbling: std::option::Option<crate::model::TumblingWindow>,
    }
    impl Builder {
        /// <p>The tumbling time interval window.</p>
        pub fn tumbling(mut self, input: crate::model::TumblingWindow) -> Self {
            self.tumbling = Some(input);
            self
        }
        /// <p>The tumbling time interval window.</p>
        pub fn set_tumbling(
            mut self,
            input: std::option::Option<crate::model::TumblingWindow>,
        ) -> Self {
            self.tumbling = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricWindow`](crate::model::MetricWindow)
        pub fn build(self) -> crate::model::MetricWindow {
            crate::model::MetricWindow {
                tumbling: self.tumbling,
            }
        }
    }
}
impl MetricWindow {
    /// Creates a new builder-style object to manufacture [`MetricWindow`](crate::model::MetricWindow)
    pub fn builder() -> crate::model::metric_window::Builder {
        crate::model::metric_window::Builder::default()
    }
}

/// <p>Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time window. You can use this window in metrics to aggregate data from properties and other assets.</p>
/// <p>You can use <code>m</code>, <code>h</code>, <code>d</code>, and <code>w</code> when you specify an interval or offset. Note that <code>m</code> represents minutes, <code>h</code> represents hours, <code>d</code> represents days, and <code>w</code> represents weeks. You can also use <code>s</code> to represent seconds in <code>offset</code>.</p>
/// <p>The <code>interval</code> and <code>offset</code> parameters support the <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a>. For example, <code>PT5S</code> represents 5 seconds, <code>PT5M</code> represents 5 minutes, and <code>PT5H</code> represents 5 hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TumblingWindow {
    /// <p>The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
    /// <p>IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on. </p>
    /// <p>When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.</p>
    pub interval: std::option::Option<std::string::String>,
    /// <p>The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
    /// <ul>
    /// <li> <p>The offset time.</p> <p>For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
    /// </ul> </li>
    /// <li> <p>The ISO 8601 format.</p> <p>For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
    /// </ul> </li>
    /// <li> <p>The 24-hour clock.</p> <p>For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC). </p> </li>
    /// <li> <p>The offset time zone.</p> <p>For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub offset: std::option::Option<std::string::String>,
}
impl TumblingWindow {
    /// <p>The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
    /// <p>IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on. </p>
    /// <p>When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.</p>
    pub fn interval(&self) -> std::option::Option<&str> {
        self.interval.as_deref()
    }
    /// <p>The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
    /// <ul>
    /// <li> <p>The offset time.</p> <p>For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
    /// </ul> </li>
    /// <li> <p>The ISO 8601 format.</p> <p>For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
    /// </ul> </li>
    /// <li> <p>The 24-hour clock.</p> <p>For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC). </p> </li>
    /// <li> <p>The offset time zone.</p> <p>For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
    /// <ul>
    /// <li> <p>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</p> </li>
    /// <li> <p>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn offset(&self) -> std::option::Option<&str> {
        self.offset.as_deref()
    }
}
impl std::fmt::Debug for TumblingWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TumblingWindow");
        formatter.field("interval", &self.interval);
        formatter.field("offset", &self.offset);
        formatter.finish()
    }
}
/// See [`TumblingWindow`](crate::model::TumblingWindow)
pub mod tumbling_window {
    /// A builder for [`TumblingWindow`](crate::model::TumblingWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) interval: std::option::Option<std::string::String>,
        pub(crate) offset: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
        /// <p>IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on. </p>
        /// <p>When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.</p>
        pub fn interval(mut self, input: impl Into<std::string::String>) -> Self {
            self.interval = Some(input.into());
            self
        }
        /// <p>The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p>
        /// <p>IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on. </p>
        /// <p>When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.</p>
        pub fn set_interval(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
        /// <ul>
        /// <li> <p>The offset time.</p> <p>For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
        /// </ul> </li>
        /// <li> <p>The ISO 8601 format.</p> <p>For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
        /// </ul> </li>
        /// <li> <p>The 24-hour clock.</p> <p>For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC). </p> </li>
        /// <li> <p>The offset time zone.</p> <p>For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.offset = Some(input.into());
            self
        }
        /// <p>The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p>
        /// <ul>
        /// <li> <p>The offset time.</p> <p>For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
        /// </ul> </li>
        /// <li> <p>The ISO 8601 format.</p> <p>For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li>
        /// </ul> </li>
        /// <li> <p>The 24-hour clock.</p> <p>For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC). </p> </li>
        /// <li> <p>The offset time zone.</p> <p>For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p>
        /// <ul>
        /// <li> <p>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</p> </li>
        /// <li> <p>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_offset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offset = input;
            self
        }
        /// Consumes the builder and constructs a [`TumblingWindow`](crate::model::TumblingWindow)
        pub fn build(self) -> crate::model::TumblingWindow {
            crate::model::TumblingWindow {
                interval: self.interval,
                offset: self.offset,
            }
        }
    }
}
impl TumblingWindow {
    /// Creates a new builder-style object to manufacture [`TumblingWindow`](crate::model::TumblingWindow)
    pub fn builder() -> crate::model::tumbling_window::Builder {
        crate::model::tumbling_window::Builder::default()
    }
}

/// <p>Contains expression variable information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpressionVariable {
    /// <p>The friendly name of the variable to be used in the expression.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The variable that identifies an asset property from which to use values.</p>
    pub value: std::option::Option<crate::model::VariableValue>,
}
impl ExpressionVariable {
    /// <p>The friendly name of the variable to be used in the expression.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The variable that identifies an asset property from which to use values.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::VariableValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for ExpressionVariable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpressionVariable");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExpressionVariable`](crate::model::ExpressionVariable)
pub mod expression_variable {
    /// A builder for [`ExpressionVariable`](crate::model::ExpressionVariable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::VariableValue>,
    }
    impl Builder {
        /// <p>The friendly name of the variable to be used in the expression.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the variable to be used in the expression.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The variable that identifies an asset property from which to use values.</p>
        pub fn value(mut self, input: crate::model::VariableValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The variable that identifies an asset property from which to use values.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::VariableValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpressionVariable`](crate::model::ExpressionVariable)
        pub fn build(self) -> crate::model::ExpressionVariable {
            crate::model::ExpressionVariable {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ExpressionVariable {
    /// Creates a new builder-style object to manufacture [`ExpressionVariable`](crate::model::ExpressionVariable)
    pub fn builder() -> crate::model::expression_variable::Builder {
        crate::model::expression_variable::Builder::default()
    }
}

/// <p>Identifies a property value used in an expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableValue {
    /// <p>The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same asset model.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's ID.</p>
    /// <p>You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub hierarchy_id: std::option::Option<std::string::String>,
}
impl VariableValue {
    /// <p>The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same asset model.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's ID.</p>
    /// <p>You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn hierarchy_id(&self) -> std::option::Option<&str> {
        self.hierarchy_id.as_deref()
    }
}
impl std::fmt::Debug for VariableValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableValue");
        formatter.field("property_id", &self.property_id);
        formatter.field("hierarchy_id", &self.hierarchy_id);
        formatter.finish()
    }
}
/// See [`VariableValue`](crate::model::VariableValue)
pub mod variable_value {
    /// A builder for [`VariableValue`](crate::model::VariableValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same asset model.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the property to use as the variable. You can use the property <code>name</code> if it's from the same asset model.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's ID.</p>
        /// <p>You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_id = Some(input.into());
            self
        }
        /// <p>The ID of the hierarchy to query for the property ID. You can use the hierarchy's name instead of the hierarchy's ID.</p>
        /// <p>You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hierarchy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableValue`](crate::model::VariableValue)
        pub fn build(self) -> crate::model::VariableValue {
            crate::model::VariableValue {
                property_id: self.property_id,
                hierarchy_id: self.hierarchy_id,
            }
        }
    }
}
impl VariableValue {
    /// Creates a new builder-style object to manufacture [`VariableValue`](crate::model::VariableValue)
    pub fn builder() -> crate::model::variable_value::Builder {
        crate::model::variable_value::Builder::default()
    }
}

/// <p>Contains an asset transform property. A transform is a one-to-one mapping of a property's data points from one form to another. For example, you can use a transform to convert a Celsius data stream to Fahrenheit by applying the transformation expression to each data point of the Celsius stream. A transform can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms">Transforms</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Transform {
    /// <p>The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>The list of variables used in the expression.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
    /// <p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>
    pub processing_config: std::option::Option<crate::model::TransformProcessingConfig>,
}
impl Transform {
    /// <p>The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>The list of variables used in the expression.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::ExpressionVariable]> {
        self.variables.as_deref()
    }
    /// <p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>
    pub fn processing_config(
        &self,
    ) -> std::option::Option<&crate::model::TransformProcessingConfig> {
        self.processing_config.as_ref()
    }
}
impl std::fmt::Debug for Transform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Transform");
        formatter.field("expression", &self.expression);
        formatter.field("variables", &self.variables);
        formatter.field("processing_config", &self.processing_config);
        formatter.finish()
    }
}
/// See [`Transform`](crate::model::Transform)
pub mod transform {
    /// A builder for [`Transform`](crate::model::Transform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
        pub(crate) processing_config: std::option::Option<crate::model::TransformProcessingConfig>,
    }
    impl Builder {
        /// <p>The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The list of variables used in the expression.</p>
        pub fn variables(mut self, input: crate::model::ExpressionVariable) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input);
            self.variables = Some(v);
            self
        }
        /// <p>The list of variables used in the expression.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpressionVariable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>
        pub fn processing_config(mut self, input: crate::model::TransformProcessingConfig) -> Self {
            self.processing_config = Some(input);
            self
        }
        /// <p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>
        pub fn set_processing_config(
            mut self,
            input: std::option::Option<crate::model::TransformProcessingConfig>,
        ) -> Self {
            self.processing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Transform`](crate::model::Transform)
        pub fn build(self) -> crate::model::Transform {
            crate::model::Transform {
                expression: self.expression,
                variables: self.variables,
                processing_config: self.processing_config,
            }
        }
    }
}
impl Transform {
    /// Creates a new builder-style object to manufacture [`Transform`](crate::model::Transform)
    pub fn builder() -> crate::model::transform::Builder {
        crate::model::transform::Builder::default()
    }
}

/// <p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformProcessingConfig {
    /// <p>The compute location for the given transform property. </p>
    pub compute_location: std::option::Option<crate::model::ComputeLocation>,
    /// <p>The forwarding configuration for a given property.</p>
    pub forwarding_config: std::option::Option<crate::model::ForwardingConfig>,
}
impl TransformProcessingConfig {
    /// <p>The compute location for the given transform property. </p>
    pub fn compute_location(&self) -> std::option::Option<&crate::model::ComputeLocation> {
        self.compute_location.as_ref()
    }
    /// <p>The forwarding configuration for a given property.</p>
    pub fn forwarding_config(&self) -> std::option::Option<&crate::model::ForwardingConfig> {
        self.forwarding_config.as_ref()
    }
}
impl std::fmt::Debug for TransformProcessingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformProcessingConfig");
        formatter.field("compute_location", &self.compute_location);
        formatter.field("forwarding_config", &self.forwarding_config);
        formatter.finish()
    }
}
/// See [`TransformProcessingConfig`](crate::model::TransformProcessingConfig)
pub mod transform_processing_config {
    /// A builder for [`TransformProcessingConfig`](crate::model::TransformProcessingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compute_location: std::option::Option<crate::model::ComputeLocation>,
        pub(crate) forwarding_config: std::option::Option<crate::model::ForwardingConfig>,
    }
    impl Builder {
        /// <p>The compute location for the given transform property. </p>
        pub fn compute_location(mut self, input: crate::model::ComputeLocation) -> Self {
            self.compute_location = Some(input);
            self
        }
        /// <p>The compute location for the given transform property. </p>
        pub fn set_compute_location(
            mut self,
            input: std::option::Option<crate::model::ComputeLocation>,
        ) -> Self {
            self.compute_location = input;
            self
        }
        /// <p>The forwarding configuration for a given property.</p>
        pub fn forwarding_config(mut self, input: crate::model::ForwardingConfig) -> Self {
            self.forwarding_config = Some(input);
            self
        }
        /// <p>The forwarding configuration for a given property.</p>
        pub fn set_forwarding_config(
            mut self,
            input: std::option::Option<crate::model::ForwardingConfig>,
        ) -> Self {
            self.forwarding_config = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformProcessingConfig`](crate::model::TransformProcessingConfig)
        pub fn build(self) -> crate::model::TransformProcessingConfig {
            crate::model::TransformProcessingConfig {
                compute_location: self.compute_location,
                forwarding_config: self.forwarding_config,
            }
        }
    }
}
impl TransformProcessingConfig {
    /// Creates a new builder-style object to manufacture [`TransformProcessingConfig`](crate::model::TransformProcessingConfig)
    pub fn builder() -> crate::model::transform_processing_config::Builder {
        crate::model::transform_processing_config::Builder::default()
    }
}

/// <p>The forwarding configuration for a given property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForwardingConfig {
    /// <p>The forwarding state for the given property. </p>
    pub state: std::option::Option<crate::model::ForwardingConfigState>,
}
impl ForwardingConfig {
    /// <p>The forwarding state for the given property. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ForwardingConfigState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ForwardingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForwardingConfig");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ForwardingConfig`](crate::model::ForwardingConfig)
pub mod forwarding_config {
    /// A builder for [`ForwardingConfig`](crate::model::ForwardingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ForwardingConfigState>,
    }
    impl Builder {
        /// <p>The forwarding state for the given property. </p>
        pub fn state(mut self, input: crate::model::ForwardingConfigState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The forwarding state for the given property. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ForwardingConfigState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ForwardingConfig`](crate::model::ForwardingConfig)
        pub fn build(self) -> crate::model::ForwardingConfig {
            crate::model::ForwardingConfig { state: self.state }
        }
    }
}
impl ForwardingConfig {
    /// Creates a new builder-style object to manufacture [`ForwardingConfig`](crate::model::ForwardingConfig)
    pub fn builder() -> crate::model::forwarding_config::Builder {
        crate::model::forwarding_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ForwardingConfigState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ForwardingConfigState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ForwardingConfigState::Disabled,
            "ENABLED" => ForwardingConfigState::Enabled,
            other => ForwardingConfigState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ForwardingConfigState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ForwardingConfigState::from(s))
    }
}
impl ForwardingConfigState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ForwardingConfigState::Disabled => "DISABLED",
            ForwardingConfigState::Enabled => "ENABLED",
            ForwardingConfigState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ForwardingConfigState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an asset measurement property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements">Measurements</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Measurement {
    /// <p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>
    pub processing_config: std::option::Option<crate::model::MeasurementProcessingConfig>,
}
impl Measurement {
    /// <p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>
    pub fn processing_config(
        &self,
    ) -> std::option::Option<&crate::model::MeasurementProcessingConfig> {
        self.processing_config.as_ref()
    }
}
impl std::fmt::Debug for Measurement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Measurement");
        formatter.field("processing_config", &self.processing_config);
        formatter.finish()
    }
}
/// See [`Measurement`](crate::model::Measurement)
pub mod measurement {
    /// A builder for [`Measurement`](crate::model::Measurement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processing_config:
            std::option::Option<crate::model::MeasurementProcessingConfig>,
    }
    impl Builder {
        /// <p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>
        pub fn processing_config(
            mut self,
            input: crate::model::MeasurementProcessingConfig,
        ) -> Self {
            self.processing_config = Some(input);
            self
        }
        /// <p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>
        pub fn set_processing_config(
            mut self,
            input: std::option::Option<crate::model::MeasurementProcessingConfig>,
        ) -> Self {
            self.processing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Measurement`](crate::model::Measurement)
        pub fn build(self) -> crate::model::Measurement {
            crate::model::Measurement {
                processing_config: self.processing_config,
            }
        }
    }
}
impl Measurement {
    /// Creates a new builder-style object to manufacture [`Measurement`](crate::model::Measurement)
    pub fn builder() -> crate::model::measurement::Builder {
        crate::model::measurement::Builder::default()
    }
}

/// <p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeasurementProcessingConfig {
    /// <p>The forwarding configuration for the given measurement property. </p>
    pub forwarding_config: std::option::Option<crate::model::ForwardingConfig>,
}
impl MeasurementProcessingConfig {
    /// <p>The forwarding configuration for the given measurement property. </p>
    pub fn forwarding_config(&self) -> std::option::Option<&crate::model::ForwardingConfig> {
        self.forwarding_config.as_ref()
    }
}
impl std::fmt::Debug for MeasurementProcessingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeasurementProcessingConfig");
        formatter.field("forwarding_config", &self.forwarding_config);
        formatter.finish()
    }
}
/// See [`MeasurementProcessingConfig`](crate::model::MeasurementProcessingConfig)
pub mod measurement_processing_config {
    /// A builder for [`MeasurementProcessingConfig`](crate::model::MeasurementProcessingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forwarding_config: std::option::Option<crate::model::ForwardingConfig>,
    }
    impl Builder {
        /// <p>The forwarding configuration for the given measurement property. </p>
        pub fn forwarding_config(mut self, input: crate::model::ForwardingConfig) -> Self {
            self.forwarding_config = Some(input);
            self
        }
        /// <p>The forwarding configuration for the given measurement property. </p>
        pub fn set_forwarding_config(
            mut self,
            input: std::option::Option<crate::model::ForwardingConfig>,
        ) -> Self {
            self.forwarding_config = input;
            self
        }
        /// Consumes the builder and constructs a [`MeasurementProcessingConfig`](crate::model::MeasurementProcessingConfig)
        pub fn build(self) -> crate::model::MeasurementProcessingConfig {
            crate::model::MeasurementProcessingConfig {
                forwarding_config: self.forwarding_config,
            }
        }
    }
}
impl MeasurementProcessingConfig {
    /// Creates a new builder-style object to manufacture [`MeasurementProcessingConfig`](crate::model::MeasurementProcessingConfig)
    pub fn builder() -> crate::model::measurement_processing_config::Builder {
        crate::model::measurement_processing_config::Builder::default()
    }
}

/// <p>Contains an asset attribute property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes">Attributes</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl Attribute {
    /// <p>The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute's value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                default_value: self.default_value,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropertyDataType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    Struct,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropertyDataType {
    fn from(s: &str) -> Self {
        match s {
            "BOOLEAN" => PropertyDataType::Boolean,
            "DOUBLE" => PropertyDataType::Double,
            "INTEGER" => PropertyDataType::Integer,
            "STRING" => PropertyDataType::String,
            "STRUCT" => PropertyDataType::Struct,
            other => PropertyDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropertyDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropertyDataType::from(s))
    }
}
impl PropertyDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropertyDataType::Boolean => "BOOLEAN",
            PropertyDataType::Double => "DOUBLE",
            PropertyDataType::Integer => "INTEGER",
            PropertyDataType::String => "STRING",
            PropertyDataType::Struct => "STRUCT",
            PropertyDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOOLEAN", "DOUBLE", "INTEGER", "STRING", "STRUCT"]
    }
}
impl AsRef<str> for PropertyDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an asset hierarchy that contains a hierarchy's name, ID, and child asset model ID that specifies the type of asset that can be in this hierarchy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelHierarchy {
    /// <p>The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model. All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model.</p>
    pub child_asset_model_id: std::option::Option<std::string::String>,
}
impl AssetModelHierarchy {
    /// <p>The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the asset model. All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model.</p>
    pub fn child_asset_model_id(&self) -> std::option::Option<&str> {
        self.child_asset_model_id.as_deref()
    }
}
impl std::fmt::Debug for AssetModelHierarchy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelHierarchy");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("child_asset_model_id", &self.child_asset_model_id);
        formatter.finish()
    }
}
/// See [`AssetModelHierarchy`](crate::model::AssetModelHierarchy)
pub mod asset_model_hierarchy {
    /// A builder for [`AssetModelHierarchy`](crate::model::AssetModelHierarchy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) child_asset_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the asset model. All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model.</p>
        pub fn child_asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model. All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model.</p>
        pub fn set_child_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.child_asset_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelHierarchy`](crate::model::AssetModelHierarchy)
        pub fn build(self) -> crate::model::AssetModelHierarchy {
            crate::model::AssetModelHierarchy {
                id: self.id,
                name: self.name,
                child_asset_model_id: self.child_asset_model_id,
            }
        }
    }
}
impl AssetModelHierarchy {
    /// Creates a new builder-style object to manufacture [`AssetModelHierarchy`](crate::model::AssetModelHierarchy)
    pub fn builder() -> crate::model::asset_model_hierarchy::Builder {
        crate::model::asset_model_hierarchy::Builder::default()
    }
}

/// <p>Contains information about the current status of an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html">Asset and model states</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetStatus {
    /// <p>The current status of the asset.</p>
    pub state: std::option::Option<crate::model::AssetState>,
    /// <p>Contains associated error information, if any.</p>
    pub error: std::option::Option<crate::model::ErrorDetails>,
}
impl AssetStatus {
    /// <p>The current status of the asset.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AssetState> {
        self.state.as_ref()
    }
    /// <p>Contains associated error information, if any.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for AssetStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetStatus");
        formatter.field("state", &self.state);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`AssetStatus`](crate::model::AssetStatus)
pub mod asset_status {
    /// A builder for [`AssetStatus`](crate::model::AssetStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::AssetState>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The current status of the asset.</p>
        pub fn state(mut self, input: crate::model::AssetState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current status of the asset.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::AssetState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn error(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetails>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetStatus`](crate::model::AssetStatus)
        pub fn build(self) -> crate::model::AssetStatus {
            crate::model::AssetStatus {
                state: self.state,
                error: self.error,
            }
        }
    }
}
impl AssetStatus {
    /// Creates a new builder-style object to manufacture [`AssetStatus`](crate::model::AssetStatus)
    pub fn builder() -> crate::model::asset_status::Builder {
        crate::model::asset_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AssetState::Active,
            "CREATING" => AssetState::Creating,
            "DELETING" => AssetState::Deleting,
            "FAILED" => AssetState::Failed,
            "UPDATING" => AssetState::Updating,
            other => AssetState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetState::from(s))
    }
}
impl AssetState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetState::Active => "ACTIVE",
            AssetState::Creating => "CREATING",
            AssetState::Deleting => "DELETING",
            AssetState::Failed => "FAILED",
            AssetState::Updating => "UPDATING",
            AssetState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for AssetState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    Administrator,
    #[allow(missing_docs)] // documentation missing in model
    Viewer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "ADMINISTRATOR" => Permission::Administrator,
            "VIEWER" => Permission::Viewer,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::Administrator => "ADMINISTRATOR",
            Permission::Viewer => "VIEWER",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADMINISTRATOR", "VIEWER"]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an IoT SiteWise Monitor resource ID for a portal or project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>A portal resource.</p>
    pub portal: std::option::Option<crate::model::PortalResource>,
    /// <p>A project resource.</p>
    pub project: std::option::Option<crate::model::ProjectResource>,
}
impl Resource {
    /// <p>A portal resource.</p>
    pub fn portal(&self) -> std::option::Option<&crate::model::PortalResource> {
        self.portal.as_ref()
    }
    /// <p>A project resource.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::ProjectResource> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("portal", &self.portal);
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal: std::option::Option<crate::model::PortalResource>,
        pub(crate) project: std::option::Option<crate::model::ProjectResource>,
    }
    impl Builder {
        /// <p>A portal resource.</p>
        pub fn portal(mut self, input: crate::model::PortalResource) -> Self {
            self.portal = Some(input);
            self
        }
        /// <p>A portal resource.</p>
        pub fn set_portal(
            mut self,
            input: std::option::Option<crate::model::PortalResource>,
        ) -> Self {
            self.portal = input;
            self
        }
        /// <p>A project resource.</p>
        pub fn project(mut self, input: crate::model::ProjectResource) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>A project resource.</p>
        pub fn set_project(
            mut self,
            input: std::option::Option<crate::model::ProjectResource>,
        ) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                portal: self.portal,
                project: self.project,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>Identifies a specific IoT SiteWise Monitor project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectResource {
    /// <p>The ID of the project.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ProjectResource {
    /// <p>The ID of the project.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ProjectResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectResource");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ProjectResource`](crate::model::ProjectResource)
pub mod project_resource {
    /// A builder for [`ProjectResource`](crate::model::ProjectResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectResource`](crate::model::ProjectResource)
        pub fn build(self) -> crate::model::ProjectResource {
            crate::model::ProjectResource { id: self.id }
        }
    }
}
impl ProjectResource {
    /// Creates a new builder-style object to manufacture [`ProjectResource`](crate::model::ProjectResource)
    pub fn builder() -> crate::model::project_resource::Builder {
        crate::model::project_resource::Builder::default()
    }
}

/// <p>Identifies an IoT SiteWise Monitor portal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortalResource {
    /// <p>The ID of the portal.</p>
    pub id: std::option::Option<std::string::String>,
}
impl PortalResource {
    /// <p>The ID of the portal.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for PortalResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortalResource");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`PortalResource`](crate::model::PortalResource)
pub mod portal_resource {
    /// A builder for [`PortalResource`](crate::model::PortalResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the portal.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`PortalResource`](crate::model::PortalResource)
        pub fn build(self) -> crate::model::PortalResource {
            crate::model::PortalResource { id: self.id }
        }
    }
}
impl PortalResource {
    /// Creates a new builder-style object to manufacture [`PortalResource`](crate::model::PortalResource)
    pub fn builder() -> crate::model::portal_resource::Builder {
        crate::model::portal_resource::Builder::default()
    }
}

/// <p>Contains an identity that can access an IoT SiteWise Monitor resource.</p> <note>
/// <p>Currently, you can't use Amazon Web Services APIs to retrieve Amazon Web Services SSO identity IDs. You can find the Amazon Web Services SSO identity IDs in the URL of user and group pages in the <a href="https://console.aws.amazon.com/singlesignon">Amazon Web Services SSO console</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Identity {
    /// <p>An Amazon Web Services SSO user identity.</p>
    pub user: std::option::Option<crate::model::UserIdentity>,
    /// <p>An Amazon Web Services SSO group identity.</p>
    pub group: std::option::Option<crate::model::GroupIdentity>,
    /// <p>An IAM user identity.</p>
    pub iam_user: std::option::Option<crate::model::IamUserIdentity>,
    /// <p>An IAM role identity.</p>
    pub iam_role: std::option::Option<crate::model::IamRoleIdentity>,
}
impl Identity {
    /// <p>An Amazon Web Services SSO user identity.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::UserIdentity> {
        self.user.as_ref()
    }
    /// <p>An Amazon Web Services SSO group identity.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::GroupIdentity> {
        self.group.as_ref()
    }
    /// <p>An IAM user identity.</p>
    pub fn iam_user(&self) -> std::option::Option<&crate::model::IamUserIdentity> {
        self.iam_user.as_ref()
    }
    /// <p>An IAM role identity.</p>
    pub fn iam_role(&self) -> std::option::Option<&crate::model::IamRoleIdentity> {
        self.iam_role.as_ref()
    }
}
impl std::fmt::Debug for Identity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Identity");
        formatter.field("user", &self.user);
        formatter.field("group", &self.group);
        formatter.field("iam_user", &self.iam_user);
        formatter.field("iam_role", &self.iam_role);
        formatter.finish()
    }
}
/// See [`Identity`](crate::model::Identity)
pub mod identity {
    /// A builder for [`Identity`](crate::model::Identity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::UserIdentity>,
        pub(crate) group: std::option::Option<crate::model::GroupIdentity>,
        pub(crate) iam_user: std::option::Option<crate::model::IamUserIdentity>,
        pub(crate) iam_role: std::option::Option<crate::model::IamRoleIdentity>,
    }
    impl Builder {
        /// <p>An Amazon Web Services SSO user identity.</p>
        pub fn user(mut self, input: crate::model::UserIdentity) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>An Amazon Web Services SSO user identity.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::UserIdentity>) -> Self {
            self.user = input;
            self
        }
        /// <p>An Amazon Web Services SSO group identity.</p>
        pub fn group(mut self, input: crate::model::GroupIdentity) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>An Amazon Web Services SSO group identity.</p>
        pub fn set_group(
            mut self,
            input: std::option::Option<crate::model::GroupIdentity>,
        ) -> Self {
            self.group = input;
            self
        }
        /// <p>An IAM user identity.</p>
        pub fn iam_user(mut self, input: crate::model::IamUserIdentity) -> Self {
            self.iam_user = Some(input);
            self
        }
        /// <p>An IAM user identity.</p>
        pub fn set_iam_user(
            mut self,
            input: std::option::Option<crate::model::IamUserIdentity>,
        ) -> Self {
            self.iam_user = input;
            self
        }
        /// <p>An IAM role identity.</p>
        pub fn iam_role(mut self, input: crate::model::IamRoleIdentity) -> Self {
            self.iam_role = Some(input);
            self
        }
        /// <p>An IAM role identity.</p>
        pub fn set_iam_role(
            mut self,
            input: std::option::Option<crate::model::IamRoleIdentity>,
        ) -> Self {
            self.iam_role = input;
            self
        }
        /// Consumes the builder and constructs a [`Identity`](crate::model::Identity)
        pub fn build(self) -> crate::model::Identity {
            crate::model::Identity {
                user: self.user,
                group: self.group,
                iam_user: self.iam_user,
                iam_role: self.iam_role,
            }
        }
    }
}
impl Identity {
    /// Creates a new builder-style object to manufacture [`Identity`](crate::model::Identity)
    pub fn builder() -> crate::model::identity::Builder {
        crate::model::identity::Builder::default()
    }
}

/// <p>Contains information about an Identity and Access Management role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamRoleIdentity {
    /// <p>The ARN of the IAM role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl IamRoleIdentity {
    /// <p>The ARN of the IAM role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for IamRoleIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamRoleIdentity");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`IamRoleIdentity`](crate::model::IamRoleIdentity)
pub mod iam_role_identity {
    /// A builder for [`IamRoleIdentity`](crate::model::IamRoleIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IamRoleIdentity`](crate::model::IamRoleIdentity)
        pub fn build(self) -> crate::model::IamRoleIdentity {
            crate::model::IamRoleIdentity { arn: self.arn }
        }
    }
}
impl IamRoleIdentity {
    /// Creates a new builder-style object to manufacture [`IamRoleIdentity`](crate::model::IamRoleIdentity)
    pub fn builder() -> crate::model::iam_role_identity::Builder {
        crate::model::iam_role_identity::Builder::default()
    }
}

/// <p>Contains information about an Identity and Access Management user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamUserIdentity {
    /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p> <note>
    /// <p>If you delete the IAM user, access policies that contain this identity include an empty <code>arn</code>. You can delete the access policy for the IAM user that no longer exists.</p>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
}
impl IamUserIdentity {
    /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p> <note>
    /// <p>If you delete the IAM user, access policies that contain this identity include an empty <code>arn</code>. You can delete the access policy for the IAM user that no longer exists.</p>
    /// </note>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for IamUserIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamUserIdentity");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`IamUserIdentity`](crate::model::IamUserIdentity)
pub mod iam_user_identity {
    /// A builder for [`IamUserIdentity`](crate::model::IamUserIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p> <note>
        /// <p>If you delete the IAM user, access policies that contain this identity include an empty <code>arn</code>. You can delete the access policy for the IAM user that no longer exists.</p>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p> <note>
        /// <p>If you delete the IAM user, access policies that contain this identity include an empty <code>arn</code>. You can delete the access policy for the IAM user that no longer exists.</p>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IamUserIdentity`](crate::model::IamUserIdentity)
        pub fn build(self) -> crate::model::IamUserIdentity {
            crate::model::IamUserIdentity { arn: self.arn }
        }
    }
}
impl IamUserIdentity {
    /// Creates a new builder-style object to manufacture [`IamUserIdentity`](crate::model::IamUserIdentity)
    pub fn builder() -> crate::model::iam_user_identity::Builder {
        crate::model::iam_user_identity::Builder::default()
    }
}

/// <p>Contains information for a group identity in an access policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupIdentity {
    /// <p>The Amazon Web Services SSO ID of the group.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GroupIdentity {
    /// <p>The Amazon Web Services SSO ID of the group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GroupIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupIdentity");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`GroupIdentity`](crate::model::GroupIdentity)
pub mod group_identity {
    /// A builder for [`GroupIdentity`](crate::model::GroupIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services SSO ID of the group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services SSO ID of the group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupIdentity`](crate::model::GroupIdentity)
        pub fn build(self) -> crate::model::GroupIdentity {
            crate::model::GroupIdentity { id: self.id }
        }
    }
}
impl GroupIdentity {
    /// Creates a new builder-style object to manufacture [`GroupIdentity`](crate::model::GroupIdentity)
    pub fn builder() -> crate::model::group_identity::Builder {
        crate::model::group_identity::Builder::default()
    }
}

/// <p>Contains information for a user identity in an access policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserIdentity {
    /// <p>The Amazon Web Services SSO ID of the user.</p>
    pub id: std::option::Option<std::string::String>,
}
impl UserIdentity {
    /// <p>The Amazon Web Services SSO ID of the user.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for UserIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserIdentity");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`UserIdentity`](crate::model::UserIdentity)
pub mod user_identity {
    /// A builder for [`UserIdentity`](crate::model::UserIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services SSO ID of the user.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services SSO ID of the user.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserIdentity`](crate::model::UserIdentity)
        pub fn build(self) -> crate::model::UserIdentity {
            crate::model::UserIdentity { id: self.id }
        }
    }
}
impl UserIdentity {
    /// Creates a new builder-style object to manufacture [`UserIdentity`](crate::model::UserIdentity)
    pub fn builder() -> crate::model::user_identity::Builder {
        crate::model::user_identity::Builder::default()
    }
}

/// <p>Contains current status information for the configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationStatus {
    /// <p>The current state of the configuration.</p>
    pub state: std::option::Option<crate::model::ConfigurationState>,
    /// <p>Contains associated error information, if any.</p>
    pub error: std::option::Option<crate::model::ConfigurationErrorDetails>,
}
impl ConfigurationStatus {
    /// <p>The current state of the configuration.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ConfigurationState> {
        self.state.as_ref()
    }
    /// <p>Contains associated error information, if any.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ConfigurationErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for ConfigurationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationStatus");
        formatter.field("state", &self.state);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ConfigurationStatus`](crate::model::ConfigurationStatus)
pub mod configuration_status {
    /// A builder for [`ConfigurationStatus`](crate::model::ConfigurationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ConfigurationState>,
        pub(crate) error: std::option::Option<crate::model::ConfigurationErrorDetails>,
    }
    impl Builder {
        /// <p>The current state of the configuration.</p>
        pub fn state(mut self, input: crate::model::ConfigurationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the configuration.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ConfigurationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn error(mut self, input: crate::model::ConfigurationErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains associated error information, if any.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ConfigurationErrorDetails>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationStatus`](crate::model::ConfigurationStatus)
        pub fn build(self) -> crate::model::ConfigurationStatus {
            crate::model::ConfigurationStatus {
                state: self.state,
                error: self.error,
            }
        }
    }
}
impl ConfigurationStatus {
    /// Creates a new builder-style object to manufacture [`ConfigurationStatus`](crate::model::ConfigurationStatus)
    pub fn builder() -> crate::model::configuration_status::Builder {
        crate::model::configuration_status::Builder::default()
    }
}

/// <p>Contains the details of an IoT SiteWise configuration error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationErrorDetails {
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ConfigurationErrorDetails {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ConfigurationErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ConfigurationErrorDetails`](crate::model::ConfigurationErrorDetails)
pub mod configuration_error_details {
    /// A builder for [`ConfigurationErrorDetails`](crate::model::ConfigurationErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::ErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::ErrorCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationErrorDetails`](crate::model::ConfigurationErrorDetails)
        pub fn build(self) -> crate::model::ConfigurationErrorDetails {
            crate::model::ConfigurationErrorDetails {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ConfigurationErrorDetails {
    /// Creates a new builder-style object to manufacture [`ConfigurationErrorDetails`](crate::model::ConfigurationErrorDetails)
    pub fn builder() -> crate::model::configuration_error_details::Builder {
        crate::model::configuration_error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ConfigurationState::Active,
            "UPDATE_FAILED" => ConfigurationState::UpdateFailed,
            "UPDATE_IN_PROGRESS" => ConfigurationState::UpdateInProgress,
            other => ConfigurationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationState::from(s))
    }
}
impl ConfigurationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationState::Active => "ACTIVE",
            ConfigurationState::UpdateFailed => "UPDATE_FAILED",
            ConfigurationState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ConfigurationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "UPDATE_FAILED", "UPDATE_IN_PROGRESS"]
    }
}
impl AsRef<str> for ConfigurationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetentionPeriod {
    /// <p>The number of days that your data is kept.</p> <note>
    /// <p>If you specified a value for this parameter, the <code>unlimited</code> parameter must be <code>false</code>.</p>
    /// </note>
    pub number_of_days: std::option::Option<i32>,
    /// <p>If true, your data is kept indefinitely.</p> <note>
    /// <p>If configured to <code>true</code>, you must not specify a value for the <code>numberOfDays</code> parameter.</p>
    /// </note>
    pub unlimited: std::option::Option<bool>,
}
impl RetentionPeriod {
    /// <p>The number of days that your data is kept.</p> <note>
    /// <p>If you specified a value for this parameter, the <code>unlimited</code> parameter must be <code>false</code>.</p>
    /// </note>
    pub fn number_of_days(&self) -> std::option::Option<i32> {
        self.number_of_days
    }
    /// <p>If true, your data is kept indefinitely.</p> <note>
    /// <p>If configured to <code>true</code>, you must not specify a value for the <code>numberOfDays</code> parameter.</p>
    /// </note>
    pub fn unlimited(&self) -> std::option::Option<bool> {
        self.unlimited
    }
}
impl std::fmt::Debug for RetentionPeriod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetentionPeriod");
        formatter.field("number_of_days", &self.number_of_days);
        formatter.field("unlimited", &self.unlimited);
        formatter.finish()
    }
}
/// See [`RetentionPeriod`](crate::model::RetentionPeriod)
pub mod retention_period {
    /// A builder for [`RetentionPeriod`](crate::model::RetentionPeriod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_days: std::option::Option<i32>,
        pub(crate) unlimited: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The number of days that your data is kept.</p> <note>
        /// <p>If you specified a value for this parameter, the <code>unlimited</code> parameter must be <code>false</code>.</p>
        /// </note>
        pub fn number_of_days(mut self, input: i32) -> Self {
            self.number_of_days = Some(input);
            self
        }
        /// <p>The number of days that your data is kept.</p> <note>
        /// <p>If you specified a value for this parameter, the <code>unlimited</code> parameter must be <code>false</code>.</p>
        /// </note>
        pub fn set_number_of_days(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_days = input;
            self
        }
        /// <p>If true, your data is kept indefinitely.</p> <note>
        /// <p>If configured to <code>true</code>, you must not specify a value for the <code>numberOfDays</code> parameter.</p>
        /// </note>
        pub fn unlimited(mut self, input: bool) -> Self {
            self.unlimited = Some(input);
            self
        }
        /// <p>If true, your data is kept indefinitely.</p> <note>
        /// <p>If configured to <code>true</code>, you must not specify a value for the <code>numberOfDays</code> parameter.</p>
        /// </note>
        pub fn set_unlimited(mut self, input: std::option::Option<bool>) -> Self {
            self.unlimited = input;
            self
        }
        /// Consumes the builder and constructs a [`RetentionPeriod`](crate::model::RetentionPeriod)
        pub fn build(self) -> crate::model::RetentionPeriod {
            crate::model::RetentionPeriod {
                number_of_days: self.number_of_days,
                unlimited: self.unlimited,
            }
        }
    }
}
impl RetentionPeriod {
    /// Creates a new builder-style object to manufacture [`RetentionPeriod`](crate::model::RetentionPeriod)
    pub fn builder() -> crate::model::retention_period::Builder {
        crate::model::retention_period::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DisassociatedDataStorageState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DisassociatedDataStorageState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DisassociatedDataStorageState::Disabled,
            "ENABLED" => DisassociatedDataStorageState::Enabled,
            other => DisassociatedDataStorageState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DisassociatedDataStorageState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DisassociatedDataStorageState::from(s))
    }
}
impl DisassociatedDataStorageState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DisassociatedDataStorageState::Disabled => "DISABLED",
            DisassociatedDataStorageState::Enabled => "ENABLED",
            DisassociatedDataStorageState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DisassociatedDataStorageState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the storage destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiLayerStorage {
    /// <p>Contains information about a customer managed Amazon S3 bucket.</p>
    pub customer_managed_s3_storage: std::option::Option<crate::model::CustomerManagedS3Storage>,
}
impl MultiLayerStorage {
    /// <p>Contains information about a customer managed Amazon S3 bucket.</p>
    pub fn customer_managed_s3_storage(
        &self,
    ) -> std::option::Option<&crate::model::CustomerManagedS3Storage> {
        self.customer_managed_s3_storage.as_ref()
    }
}
impl std::fmt::Debug for MultiLayerStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiLayerStorage");
        formatter.field(
            "customer_managed_s3_storage",
            &self.customer_managed_s3_storage,
        );
        formatter.finish()
    }
}
/// See [`MultiLayerStorage`](crate::model::MultiLayerStorage)
pub mod multi_layer_storage {
    /// A builder for [`MultiLayerStorage`](crate::model::MultiLayerStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_managed_s3_storage:
            std::option::Option<crate::model::CustomerManagedS3Storage>,
    }
    impl Builder {
        /// <p>Contains information about a customer managed Amazon S3 bucket.</p>
        pub fn customer_managed_s3_storage(
            mut self,
            input: crate::model::CustomerManagedS3Storage,
        ) -> Self {
            self.customer_managed_s3_storage = Some(input);
            self
        }
        /// <p>Contains information about a customer managed Amazon S3 bucket.</p>
        pub fn set_customer_managed_s3_storage(
            mut self,
            input: std::option::Option<crate::model::CustomerManagedS3Storage>,
        ) -> Self {
            self.customer_managed_s3_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiLayerStorage`](crate::model::MultiLayerStorage)
        pub fn build(self) -> crate::model::MultiLayerStorage {
            crate::model::MultiLayerStorage {
                customer_managed_s3_storage: self.customer_managed_s3_storage,
            }
        }
    }
}
impl MultiLayerStorage {
    /// Creates a new builder-style object to manufacture [`MultiLayerStorage`](crate::model::MultiLayerStorage)
    pub fn builder() -> crate::model::multi_layer_storage::Builder {
        crate::model::multi_layer_storage::Builder::default()
    }
}

/// <p>Contains information about a customer managed Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerManagedS3Storage {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
    pub s3_resource_arn: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CustomerManagedS3Storage {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
    pub fn s3_resource_arn(&self) -> std::option::Option<&str> {
        self.s3_resource_arn.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomerManagedS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerManagedS3Storage");
        formatter.field("s3_resource_arn", &self.s3_resource_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CustomerManagedS3Storage`](crate::model::CustomerManagedS3Storage)
pub mod customer_managed_s3_storage {
    /// A builder for [`CustomerManagedS3Storage`](crate::model::CustomerManagedS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_resource_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
        pub fn s3_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
        pub fn set_s3_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_resource_arn = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerManagedS3Storage`](crate::model::CustomerManagedS3Storage)
        pub fn build(self) -> crate::model::CustomerManagedS3Storage {
            crate::model::CustomerManagedS3Storage {
                s3_resource_arn: self.s3_resource_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CustomerManagedS3Storage {
    /// Creates a new builder-style object to manufacture [`CustomerManagedS3Storage`](crate::model::CustomerManagedS3Storage)
    pub fn builder() -> crate::model::customer_managed_s3_storage::Builder {
        crate::model::customer_managed_s3_storage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageType {
    #[allow(missing_docs)] // documentation missing in model
    MultiLayerStorage,
    #[allow(missing_docs)] // documentation missing in model
    SitewiseDefaultStorage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageType {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_LAYER_STORAGE" => StorageType::MultiLayerStorage,
            "SITEWISE_DEFAULT_STORAGE" => StorageType::SitewiseDefaultStorage,
            other => StorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageType::from(s))
    }
}
impl StorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageType::MultiLayerStorage => "MULTI_LAYER_STORAGE",
            StorageType::SitewiseDefaultStorage => "SITEWISE_DEFAULT_STORAGE",
            StorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_LAYER_STORAGE", "SITEWISE_DEFAULT_STORAGE"]
    }
}
impl AsRef<str> for StorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains logging options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingOptions {
    /// <p>The IoT SiteWise logging verbosity level.</p>
    pub level: std::option::Option<crate::model::LoggingLevel>,
}
impl LoggingOptions {
    /// <p>The IoT SiteWise logging verbosity level.</p>
    pub fn level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.level.as_ref()
    }
}
impl std::fmt::Debug for LoggingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingOptions");
        formatter.field("level", &self.level);
        formatter.finish()
    }
}
/// See [`LoggingOptions`](crate::model::LoggingOptions)
pub mod logging_options {
    /// A builder for [`LoggingOptions`](crate::model::LoggingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) level: std::option::Option<crate::model::LoggingLevel>,
    }
    impl Builder {
        /// <p>The IoT SiteWise logging verbosity level.</p>
        pub fn level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// <p>The IoT SiteWise logging verbosity level.</p>
        pub fn set_level(mut self, input: std::option::Option<crate::model::LoggingLevel>) -> Self {
            self.level = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingOptions`](crate::model::LoggingOptions)
        pub fn build(self) -> crate::model::LoggingOptions {
            crate::model::LoggingOptions { level: self.level }
        }
    }
}
impl LoggingOptions {
    /// Creates a new builder-style object to manufacture [`LoggingOptions`](crate::model::LoggingOptions)
    pub fn builder() -> crate::model::logging_options::Builder {
        crate::model::logging_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggingLevel {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggingLevel {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => LoggingLevel::Error,
            "INFO" => LoggingLevel::Info,
            "OFF" => LoggingLevel::Off,
            other => LoggingLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggingLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggingLevel::from(s))
    }
}
impl LoggingLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggingLevel::Error => "ERROR",
            LoggingLevel::Info => "INFO",
            LoggingLevel::Off => "OFF",
            LoggingLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "INFO", "OFF"]
    }
}
impl AsRef<str> for LoggingLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    KmsBasedEncryption,
    #[allow(missing_docs)] // documentation missing in model
    SitewiseDefaultEncryption,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "KMS_BASED_ENCRYPTION" => EncryptionType::KmsBasedEncryption,
            "SITEWISE_DEFAULT_ENCRYPTION" => EncryptionType::SitewiseDefaultEncryption,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::KmsBasedEncryption => "KMS_BASED_ENCRYPTION",
            EncryptionType::SitewiseDefaultEncryption => "SITEWISE_DEFAULT_ENCRYPTION",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS_BASED_ENCRYPTION", "SITEWISE_DEFAULT_ENCRYPTION"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a summary of a time series (data stream).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeSeriesSummary {
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the time series.</p>
    pub time_series_id: std::option::Option<std::string::String>,
    /// <p>The data type of the time series.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub data_type_spec: std::option::Option<std::string::String>,
    /// <p>The date that the time series was created, in Unix epoch time.</p>
    pub time_series_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the time series was last updated, in Unix epoch time.</p>
    pub time_series_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeSeriesSummary {
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the time series.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
    /// <p>The data type of the time series.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub fn data_type_spec(&self) -> std::option::Option<&str> {
        self.data_type_spec.as_deref()
    }
    /// <p>The date that the time series was created, in Unix epoch time.</p>
    pub fn time_series_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_series_creation_date.as_ref()
    }
    /// <p>The date that the time series was last updated, in Unix epoch time.</p>
    pub fn time_series_last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_series_last_update_date.as_ref()
    }
}
impl std::fmt::Debug for TimeSeriesSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeSeriesSummary");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("alias", &self.alias);
        formatter.field("time_series_id", &self.time_series_id);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_type_spec", &self.data_type_spec);
        formatter.field("time_series_creation_date", &self.time_series_creation_date);
        formatter.field(
            "time_series_last_update_date",
            &self.time_series_last_update_date,
        );
        formatter.finish()
    }
}
/// See [`TimeSeriesSummary`](crate::model::TimeSeriesSummary)
pub mod time_series_summary {
    /// A builder for [`TimeSeriesSummary`](crate::model::TimeSeriesSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) time_series_id: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) data_type_spec: std::option::Option<std::string::String>,
        pub(crate) time_series_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_series_last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the time series.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the time series.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// <p>The data type of the time series.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the time series.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn data_type_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type_spec = Some(input.into());
            self
        }
        /// <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn set_data_type_spec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_type_spec = input;
            self
        }
        /// <p>The date that the time series was created, in Unix epoch time.</p>
        pub fn time_series_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_series_creation_date = Some(input);
            self
        }
        /// <p>The date that the time series was created, in Unix epoch time.</p>
        pub fn set_time_series_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_series_creation_date = input;
            self
        }
        /// <p>The date that the time series was last updated, in Unix epoch time.</p>
        pub fn time_series_last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_series_last_update_date = Some(input);
            self
        }
        /// <p>The date that the time series was last updated, in Unix epoch time.</p>
        pub fn set_time_series_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_series_last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeSeriesSummary`](crate::model::TimeSeriesSummary)
        pub fn build(self) -> crate::model::TimeSeriesSummary {
            crate::model::TimeSeriesSummary {
                asset_id: self.asset_id,
                property_id: self.property_id,
                alias: self.alias,
                time_series_id: self.time_series_id,
                data_type: self.data_type,
                data_type_spec: self.data_type_spec,
                time_series_creation_date: self.time_series_creation_date,
                time_series_last_update_date: self.time_series_last_update_date,
            }
        }
    }
}
impl TimeSeriesSummary {
    /// Creates a new builder-style object to manufacture [`TimeSeriesSummary`](crate::model::TimeSeriesSummary)
    pub fn builder() -> crate::model::time_series_summary::Builder {
        crate::model::time_series_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListTimeSeriesType {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Disassociated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListTimeSeriesType {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATED" => ListTimeSeriesType::Associated,
            "DISASSOCIATED" => ListTimeSeriesType::Disassociated,
            other => ListTimeSeriesType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListTimeSeriesType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListTimeSeriesType::from(s))
    }
}
impl ListTimeSeriesType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListTimeSeriesType::Associated => "ASSOCIATED",
            ListTimeSeriesType::Disassociated => "DISASSOCIATED",
            ListTimeSeriesType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSOCIATED", "DISASSOCIATED"]
    }
}
impl AsRef<str> for ListTimeSeriesType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains project summary information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectSummary {
    /// <p>The ID of the project.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The project's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date the project was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the project was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProjectSummary {
    /// <p>The ID of the project.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The project's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date the project was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the project was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for ProjectSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`ProjectSummary`](crate::model::ProjectSummary)
pub mod project_summary {
    /// A builder for [`ProjectSummary`](crate::model::ProjectSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The project's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The project's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date the project was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the project was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the project was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the project was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectSummary`](crate::model::ProjectSummary)
        pub fn build(self) -> crate::model::ProjectSummary {
            crate::model::ProjectSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl ProjectSummary {
    /// Creates a new builder-style object to manufacture [`ProjectSummary`](crate::model::ProjectSummary)
    pub fn builder() -> crate::model::project_summary::Builder {
        crate::model::project_summary::Builder::default()
    }
}

/// <p>Contains a portal summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortalSummary {
    /// <p>The ID of the portal.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the portal.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The portal's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub start_url: std::option::Option<std::string::String>,
    /// <p>The date the portal was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the portal was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Contains information about the current status of a portal.</p>
    pub status: std::option::Option<crate::model::PortalStatus>,
}
impl PortalSummary {
    /// <p>The ID of the portal.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the portal.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The portal's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    pub fn start_url(&self) -> std::option::Option<&str> {
        self.start_url.as_deref()
    }
    /// <p>The date the portal was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the portal was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Contains information about the current status of a portal.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PortalStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PortalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortalSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("start_url", &self.start_url);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PortalSummary`](crate::model::PortalSummary)
pub mod portal_summary {
    /// A builder for [`PortalSummary`](crate::model::PortalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) start_url: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PortalStatus>,
    }
    impl Builder {
        /// <p>The ID of the portal.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the portal.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the portal.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The portal's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The portal's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn start_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_url = Some(input.into());
            self
        }
        /// <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
        pub fn set_start_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_url = input;
            self
        }
        /// <p>The date the portal was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the portal was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the portal was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the portal was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Contains information about the current status of a portal.</p>
        pub fn status(mut self, input: crate::model::PortalStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Contains information about the current status of a portal.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PortalStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PortalSummary`](crate::model::PortalSummary)
        pub fn build(self) -> crate::model::PortalSummary {
            crate::model::PortalSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                start_url: self.start_url,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
                role_arn: self.role_arn,
                status: self.status,
            }
        }
    }
}
impl PortalSummary {
    /// Creates a new builder-style object to manufacture [`PortalSummary`](crate::model::PortalSummary)
    pub fn builder() -> crate::model::portal_summary::Builder {
        crate::model::portal_summary::Builder::default()
    }
}

/// <p>Contains a summary of a gateway.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewaySummary {
    /// <p>The ID of the gateway device.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The name of the asset.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>Contains a gateway's platform information.</p>
    pub gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
    /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
    pub gateway_capability_summaries:
        std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
    /// <p>The date the gateway was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the gateway was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GatewaySummary {
    /// <p>The ID of the gateway device.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The name of the asset.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
    /// <p>Contains a gateway's platform information.</p>
    pub fn gateway_platform(&self) -> std::option::Option<&crate::model::GatewayPlatform> {
        self.gateway_platform.as_ref()
    }
    /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
    pub fn gateway_capability_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::GatewayCapabilitySummary]> {
        self.gateway_capability_summaries.as_deref()
    }
    /// <p>The date the gateway was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the gateway was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for GatewaySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewaySummary");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("gateway_platform", &self.gateway_platform);
        formatter.field(
            "gateway_capability_summaries",
            &self.gateway_capability_summaries,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`GatewaySummary`](crate::model::GatewaySummary)
pub mod gateway_summary {
    /// A builder for [`GatewaySummary`](crate::model::GatewaySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
        pub(crate) gateway_capability_summaries:
            std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the gateway device.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway device.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The name of the asset.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the asset.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>Contains a gateway's platform information.</p>
        pub fn gateway_platform(mut self, input: crate::model::GatewayPlatform) -> Self {
            self.gateway_platform = Some(input);
            self
        }
        /// <p>Contains a gateway's platform information.</p>
        pub fn set_gateway_platform(
            mut self,
            input: std::option::Option<crate::model::GatewayPlatform>,
        ) -> Self {
            self.gateway_platform = input;
            self
        }
        /// Appends an item to `gateway_capability_summaries`.
        ///
        /// To override the contents of this collection use [`set_gateway_capability_summaries`](Self::set_gateway_capability_summaries).
        ///
        /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
        pub fn gateway_capability_summaries(
            mut self,
            input: crate::model::GatewayCapabilitySummary,
        ) -> Self {
            let mut v = self.gateway_capability_summaries.unwrap_or_default();
            v.push(input);
            self.gateway_capability_summaries = Some(v);
            self
        }
        /// <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
        pub fn set_gateway_capability_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GatewayCapabilitySummary>>,
        ) -> Self {
            self.gateway_capability_summaries = input;
            self
        }
        /// <p>The date the gateway was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the gateway was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the gateway was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the gateway was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewaySummary`](crate::model::GatewaySummary)
        pub fn build(self) -> crate::model::GatewaySummary {
            crate::model::GatewaySummary {
                gateway_id: self.gateway_id,
                gateway_name: self.gateway_name,
                gateway_platform: self.gateway_platform,
                gateway_capability_summaries: self.gateway_capability_summaries,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl GatewaySummary {
    /// Creates a new builder-style object to manufacture [`GatewaySummary`](crate::model::GatewaySummary)
    pub fn builder() -> crate::model::gateway_summary::Builder {
        crate::model::gateway_summary::Builder::default()
    }
}

/// <p>Contains a summary of a gateway capability configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayCapabilitySummary {
    /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
    pub capability_namespace: std::option::Option<std::string::String>,
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    pub capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
}
impl GatewayCapabilitySummary {
    /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
    pub fn capability_namespace(&self) -> std::option::Option<&str> {
        self.capability_namespace.as_deref()
    }
    /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
    /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
    /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
    /// </ul>
    pub fn capability_sync_status(
        &self,
    ) -> std::option::Option<&crate::model::CapabilitySyncStatus> {
        self.capability_sync_status.as_ref()
    }
}
impl std::fmt::Debug for GatewayCapabilitySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayCapabilitySummary");
        formatter.field("capability_namespace", &self.capability_namespace);
        formatter.field("capability_sync_status", &self.capability_sync_status);
        formatter.finish()
    }
}
/// See [`GatewayCapabilitySummary`](crate::model::GatewayCapabilitySummary)
pub mod gateway_capability_summary {
    /// A builder for [`GatewayCapabilitySummary`](crate::model::GatewayCapabilitySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capability_namespace: std::option::Option<std::string::String>,
        pub(crate) capability_sync_status: std::option::Option<crate::model::CapabilitySyncStatus>,
    }
    impl Builder {
        /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_namespace = input;
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        pub fn capability_sync_status(mut self, input: crate::model::CapabilitySyncStatus) -> Self {
            self.capability_sync_status = Some(input);
            self
        }
        /// <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>
        /// <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>
        /// <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>
        /// </ul>
        pub fn set_capability_sync_status(
            mut self,
            input: std::option::Option<crate::model::CapabilitySyncStatus>,
        ) -> Self {
            self.capability_sync_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayCapabilitySummary`](crate::model::GatewayCapabilitySummary)
        pub fn build(self) -> crate::model::GatewayCapabilitySummary {
            crate::model::GatewayCapabilitySummary {
                capability_namespace: self.capability_namespace,
                capability_sync_status: self.capability_sync_status,
            }
        }
    }
}
impl GatewayCapabilitySummary {
    /// Creates a new builder-style object to manufacture [`GatewayCapabilitySummary`](crate::model::GatewayCapabilitySummary)
    pub fn builder() -> crate::model::gateway_capability_summary::Builder {
        crate::model::gateway_capability_summary::Builder::default()
    }
}

/// <p>Contains a gateway's platform information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatewayPlatform {
    /// <p>A gateway that runs on IoT Greengrass.</p>
    pub greengrass: std::option::Option<crate::model::Greengrass>,
    /// <p>A gateway that runs on IoT Greengrass V2.</p>
    pub greengrass_v2: std::option::Option<crate::model::GreengrassV2>,
}
impl GatewayPlatform {
    /// <p>A gateway that runs on IoT Greengrass.</p>
    pub fn greengrass(&self) -> std::option::Option<&crate::model::Greengrass> {
        self.greengrass.as_ref()
    }
    /// <p>A gateway that runs on IoT Greengrass V2.</p>
    pub fn greengrass_v2(&self) -> std::option::Option<&crate::model::GreengrassV2> {
        self.greengrass_v2.as_ref()
    }
}
impl std::fmt::Debug for GatewayPlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatewayPlatform");
        formatter.field("greengrass", &self.greengrass);
        formatter.field("greengrass_v2", &self.greengrass_v2);
        formatter.finish()
    }
}
/// See [`GatewayPlatform`](crate::model::GatewayPlatform)
pub mod gateway_platform {
    /// A builder for [`GatewayPlatform`](crate::model::GatewayPlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) greengrass: std::option::Option<crate::model::Greengrass>,
        pub(crate) greengrass_v2: std::option::Option<crate::model::GreengrassV2>,
    }
    impl Builder {
        /// <p>A gateway that runs on IoT Greengrass.</p>
        pub fn greengrass(mut self, input: crate::model::Greengrass) -> Self {
            self.greengrass = Some(input);
            self
        }
        /// <p>A gateway that runs on IoT Greengrass.</p>
        pub fn set_greengrass(
            mut self,
            input: std::option::Option<crate::model::Greengrass>,
        ) -> Self {
            self.greengrass = input;
            self
        }
        /// <p>A gateway that runs on IoT Greengrass V2.</p>
        pub fn greengrass_v2(mut self, input: crate::model::GreengrassV2) -> Self {
            self.greengrass_v2 = Some(input);
            self
        }
        /// <p>A gateway that runs on IoT Greengrass V2.</p>
        pub fn set_greengrass_v2(
            mut self,
            input: std::option::Option<crate::model::GreengrassV2>,
        ) -> Self {
            self.greengrass_v2 = input;
            self
        }
        /// Consumes the builder and constructs a [`GatewayPlatform`](crate::model::GatewayPlatform)
        pub fn build(self) -> crate::model::GatewayPlatform {
            crate::model::GatewayPlatform {
                greengrass: self.greengrass,
                greengrass_v2: self.greengrass_v2,
            }
        }
    }
}
impl GatewayPlatform {
    /// Creates a new builder-style object to manufacture [`GatewayPlatform`](crate::model::GatewayPlatform)
    pub fn builder() -> crate::model::gateway_platform::Builder {
        crate::model::gateway_platform::Builder::default()
    }
}

/// <p>Contains details for a gateway that runs on IoT Greengrass V2. To create a gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise Edge component to your gateway device. Your <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html">Greengrass device role</a> must use the <code>AWSIoTSiteWiseEdgeAccess</code> policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html">Using IoT SiteWise at the edge</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GreengrassV2 {
    /// <p>The name of the IoT thing for your IoT Greengrass V2 core device.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
}
impl GreengrassV2 {
    /// <p>The name of the IoT thing for your IoT Greengrass V2 core device.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
}
impl std::fmt::Debug for GreengrassV2 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GreengrassV2");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.finish()
    }
}
/// See [`GreengrassV2`](crate::model::GreengrassV2)
pub mod greengrass_v2 {
    /// A builder for [`GreengrassV2`](crate::model::GreengrassV2)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT thing for your IoT Greengrass V2 core device.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing for your IoT Greengrass V2 core device.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GreengrassV2`](crate::model::GreengrassV2)
        pub fn build(self) -> crate::model::GreengrassV2 {
            crate::model::GreengrassV2 {
                core_device_thing_name: self.core_device_thing_name,
            }
        }
    }
}
impl GreengrassV2 {
    /// Creates a new builder-style object to manufacture [`GreengrassV2`](crate::model::GreengrassV2)
    pub fn builder() -> crate::model::greengrass_v2::Builder {
        crate::model::greengrass_v2::Builder::default()
    }
}

/// <p>Contains details for a gateway that runs on IoT Greengrass. To create a gateway that runs on IoT Greengrass, you must add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass group must also have permissions to upload data to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Greengrass {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Greengrass group. For more information about how to find a group's ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT Greengrass API Reference</i>.</p>
    pub group_arn: std::option::Option<std::string::String>,
}
impl Greengrass {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Greengrass group. For more information about how to find a group's ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT Greengrass API Reference</i>.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for Greengrass {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Greengrass");
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}
/// See [`Greengrass`](crate::model::Greengrass)
pub mod greengrass {
    /// A builder for [`Greengrass`](crate::model::Greengrass)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Greengrass group. For more information about how to find a group's ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT Greengrass API Reference</i>.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Greengrass group. For more information about how to find a group's ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT Greengrass API Reference</i>.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Greengrass`](crate::model::Greengrass)
        pub fn build(self) -> crate::model::Greengrass {
            crate::model::Greengrass {
                group_arn: self.group_arn,
            }
        }
    }
}
impl Greengrass {
    /// Creates a new builder-style object to manufacture [`Greengrass`](crate::model::Greengrass)
    pub fn builder() -> crate::model::greengrass::Builder {
        crate::model::greengrass::Builder::default()
    }
}

/// <p>Contains a dashboard summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardSummary {
    /// <p>The ID of the dashboard.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the dashboard</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The dashboard's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date the dashboard was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DashboardSummary {
    /// <p>The ID of the dashboard.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the dashboard</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The dashboard's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date the dashboard was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for DashboardSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`DashboardSummary`](crate::model::DashboardSummary)
pub mod dashboard_summary {
    /// A builder for [`DashboardSummary`](crate::model::DashboardSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the dashboard.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the dashboard</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dashboard</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The dashboard's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The dashboard's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date the dashboard was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the dashboard was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the dashboard was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardSummary`](crate::model::DashboardSummary)
        pub fn build(self) -> crate::model::DashboardSummary {
            crate::model::DashboardSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl DashboardSummary {
    /// Creates a new builder-style object to manufacture [`DashboardSummary`](crate::model::DashboardSummary)
    pub fn builder() -> crate::model::dashboard_summary::Builder {
        crate::model::dashboard_summary::Builder::default()
    }
}

/// <p>Contains a summary of an associated asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedAssetsSummary {
    /// <p>The ID of the asset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the asset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model used to create the asset.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the asset.</p>
    pub status: std::option::Option<crate::model::AssetStatus>,
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub hierarchies: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
}
impl AssociatedAssetsSummary {
    /// <p>The ID of the asset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the asset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the asset model used to create the asset.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
    /// <p>The current status of the asset.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.status.as_ref()
    }
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub fn hierarchies(&self) -> std::option::Option<&[crate::model::AssetHierarchy]> {
        self.hierarchies.as_deref()
    }
}
impl std::fmt::Debug for AssociatedAssetsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedAssetsSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.field("status", &self.status);
        formatter.field("hierarchies", &self.hierarchies);
        formatter.finish()
    }
}
/// See [`AssociatedAssetsSummary`](crate::model::AssociatedAssetsSummary)
pub mod associated_assets_summary {
    /// A builder for [`AssociatedAssetsSummary`](crate::model::AssociatedAssetsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AssetStatus>,
        pub(crate) hierarchies: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the asset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the asset model used to create the asset.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model used to create the asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// <p>The current status of the asset.</p>
        pub fn status(mut self, input: crate::model::AssetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the asset.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AssetStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `hierarchies`.
        ///
        /// To override the contents of this collection use [`set_hierarchies`](Self::set_hierarchies).
        ///
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn hierarchies(mut self, input: crate::model::AssetHierarchy) -> Self {
            let mut v = self.hierarchies.unwrap_or_default();
            v.push(input);
            self.hierarchies = Some(v);
            self
        }
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn set_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
        ) -> Self {
            self.hierarchies = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedAssetsSummary`](crate::model::AssociatedAssetsSummary)
        pub fn build(self) -> crate::model::AssociatedAssetsSummary {
            crate::model::AssociatedAssetsSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                asset_model_id: self.asset_model_id,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
                status: self.status,
                hierarchies: self.hierarchies,
            }
        }
    }
}
impl AssociatedAssetsSummary {
    /// Creates a new builder-style object to manufacture [`AssociatedAssetsSummary`](crate::model::AssociatedAssetsSummary)
    pub fn builder() -> crate::model::associated_assets_summary::Builder {
        crate::model::associated_assets_summary::Builder::default()
    }
}

/// <p>Describes an asset hierarchy that contains a hierarchy's name and ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetHierarchy {
    /// <p>The ID of the hierarchy. This ID is a <code>hierarchyId</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The hierarchy name provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AssetHierarchy {
    /// <p>The ID of the hierarchy. This ID is a <code>hierarchyId</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The hierarchy name provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AssetHierarchy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetHierarchy");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AssetHierarchy`](crate::model::AssetHierarchy)
pub mod asset_hierarchy {
    /// A builder for [`AssetHierarchy`](crate::model::AssetHierarchy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hierarchy. This ID is a <code>hierarchyId</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the hierarchy. This ID is a <code>hierarchyId</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The hierarchy name provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The hierarchy name provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetHierarchy`](crate::model::AssetHierarchy)
        pub fn build(self) -> crate::model::AssetHierarchy {
            crate::model::AssetHierarchy {
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl AssetHierarchy {
    /// Creates a new builder-style object to manufacture [`AssetHierarchy`](crate::model::AssetHierarchy)
    pub fn builder() -> crate::model::asset_hierarchy::Builder {
        crate::model::asset_hierarchy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TraversalDirection {
    #[allow(missing_docs)] // documentation missing in model
    Child,
    #[allow(missing_docs)] // documentation missing in model
    Parent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TraversalDirection {
    fn from(s: &str) -> Self {
        match s {
            "CHILD" => TraversalDirection::Child,
            "PARENT" => TraversalDirection::Parent,
            other => TraversalDirection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TraversalDirection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TraversalDirection::from(s))
    }
}
impl TraversalDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TraversalDirection::Child => "CHILD",
            TraversalDirection::Parent => "PARENT",
            TraversalDirection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHILD", "PARENT"]
    }
}
impl AsRef<str> for TraversalDirection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a summary of an asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetSummary {
    /// <p>The ID of the asset.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the asset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model used to create this asset.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the asset.</p>
    pub status: std::option::Option<crate::model::AssetStatus>,
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub hierarchies: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
}
impl AssetSummary {
    /// <p>The ID of the asset.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the asset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the asset model used to create this asset.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The date the asset was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the asset was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
    /// <p>The current status of the asset.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssetStatus> {
        self.status.as_ref()
    }
    /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    pub fn hierarchies(&self) -> std::option::Option<&[crate::model::AssetHierarchy]> {
        self.hierarchies.as_deref()
    }
}
impl std::fmt::Debug for AssetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.field("status", &self.status);
        formatter.field("hierarchies", &self.hierarchies);
        formatter.finish()
    }
}
/// See [`AssetSummary`](crate::model::AssetSummary)
pub mod asset_summary {
    /// A builder for [`AssetSummary`](crate::model::AssetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AssetStatus>,
        pub(crate) hierarchies: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the asset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the asset model used to create this asset.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model used to create this asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the asset was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the asset was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// <p>The current status of the asset.</p>
        pub fn status(mut self, input: crate::model::AssetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the asset.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AssetStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `hierarchies`.
        ///
        /// To override the contents of this collection use [`set_hierarchies`](Self::set_hierarchies).
        ///
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn hierarchies(mut self, input: crate::model::AssetHierarchy) -> Self {
            let mut v = self.hierarchies.unwrap_or_default();
            v.push(input);
            self.hierarchies = Some(v);
            self
        }
        /// <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
        pub fn set_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetHierarchy>>,
        ) -> Self {
            self.hierarchies = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetSummary`](crate::model::AssetSummary)
        pub fn build(self) -> crate::model::AssetSummary {
            crate::model::AssetSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                asset_model_id: self.asset_model_id,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
                status: self.status,
                hierarchies: self.hierarchies,
            }
        }
    }
}
impl AssetSummary {
    /// Creates a new builder-style object to manufacture [`AssetSummary`](crate::model::AssetSummary)
    pub fn builder() -> crate::model::asset_summary::Builder {
        crate::model::asset_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListAssetsFilter {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    TopLevel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListAssetsFilter {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ListAssetsFilter::All,
            "TOP_LEVEL" => ListAssetsFilter::TopLevel,
            other => ListAssetsFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListAssetsFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListAssetsFilter::from(s))
    }
}
impl ListAssetsFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListAssetsFilter::All => "ALL",
            ListAssetsFilter::TopLevel => "TOP_LEVEL",
            ListAssetsFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "TOP_LEVEL"]
    }
}
impl AsRef<str> for ListAssetsFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about assets that are related to one another.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetRelationshipSummary {
    /// <p>The assets that are related through an asset hierarchy.</p>
    /// <p>This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.</p>
    pub hierarchy_info: std::option::Option<crate::model::AssetHierarchyInfo>,
    /// <p>The relationship type of the assets in this relationship. This value is one of the following:</p>
    /// <ul>
    /// <li> <p> <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.</p> </li>
    /// </ul>
    pub relationship_type: std::option::Option<crate::model::AssetRelationshipType>,
}
impl AssetRelationshipSummary {
    /// <p>The assets that are related through an asset hierarchy.</p>
    /// <p>This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.</p>
    pub fn hierarchy_info(&self) -> std::option::Option<&crate::model::AssetHierarchyInfo> {
        self.hierarchy_info.as_ref()
    }
    /// <p>The relationship type of the assets in this relationship. This value is one of the following:</p>
    /// <ul>
    /// <li> <p> <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.</p> </li>
    /// </ul>
    pub fn relationship_type(&self) -> std::option::Option<&crate::model::AssetRelationshipType> {
        self.relationship_type.as_ref()
    }
}
impl std::fmt::Debug for AssetRelationshipSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetRelationshipSummary");
        formatter.field("hierarchy_info", &self.hierarchy_info);
        formatter.field("relationship_type", &self.relationship_type);
        formatter.finish()
    }
}
/// See [`AssetRelationshipSummary`](crate::model::AssetRelationshipSummary)
pub mod asset_relationship_summary {
    /// A builder for [`AssetRelationshipSummary`](crate::model::AssetRelationshipSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hierarchy_info: std::option::Option<crate::model::AssetHierarchyInfo>,
        pub(crate) relationship_type: std::option::Option<crate::model::AssetRelationshipType>,
    }
    impl Builder {
        /// <p>The assets that are related through an asset hierarchy.</p>
        /// <p>This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.</p>
        pub fn hierarchy_info(mut self, input: crate::model::AssetHierarchyInfo) -> Self {
            self.hierarchy_info = Some(input);
            self
        }
        /// <p>The assets that are related through an asset hierarchy.</p>
        /// <p>This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.</p>
        pub fn set_hierarchy_info(
            mut self,
            input: std::option::Option<crate::model::AssetHierarchyInfo>,
        ) -> Self {
            self.hierarchy_info = input;
            self
        }
        /// <p>The relationship type of the assets in this relationship. This value is one of the following:</p>
        /// <ul>
        /// <li> <p> <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.</p> </li>
        /// </ul>
        pub fn relationship_type(mut self, input: crate::model::AssetRelationshipType) -> Self {
            self.relationship_type = Some(input);
            self
        }
        /// <p>The relationship type of the assets in this relationship. This value is one of the following:</p>
        /// <ul>
        /// <li> <p> <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.</p> </li>
        /// </ul>
        pub fn set_relationship_type(
            mut self,
            input: std::option::Option<crate::model::AssetRelationshipType>,
        ) -> Self {
            self.relationship_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetRelationshipSummary`](crate::model::AssetRelationshipSummary)
        pub fn build(self) -> crate::model::AssetRelationshipSummary {
            crate::model::AssetRelationshipSummary {
                hierarchy_info: self.hierarchy_info,
                relationship_type: self.relationship_type,
            }
        }
    }
}
impl AssetRelationshipSummary {
    /// Creates a new builder-style object to manufacture [`AssetRelationshipSummary`](crate::model::AssetRelationshipSummary)
    pub fn builder() -> crate::model::asset_relationship_summary::Builder {
        crate::model::asset_relationship_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetRelationshipType {
    #[allow(missing_docs)] // documentation missing in model
    Hierarchy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetRelationshipType {
    fn from(s: &str) -> Self {
        match s {
            "HIERARCHY" => AssetRelationshipType::Hierarchy,
            other => AssetRelationshipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetRelationshipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetRelationshipType::from(s))
    }
}
impl AssetRelationshipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetRelationshipType::Hierarchy => "HIERARCHY",
            AssetRelationshipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIERARCHY"]
    }
}
impl AsRef<str> for AssetRelationshipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a parent asset and a child asset that are related through an asset hierarchy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetHierarchyInfo {
    /// <p>The ID of the parent asset in this asset relationship.</p>
    pub parent_asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the child asset in this asset relationship.</p>
    pub child_asset_id: std::option::Option<std::string::String>,
}
impl AssetHierarchyInfo {
    /// <p>The ID of the parent asset in this asset relationship.</p>
    pub fn parent_asset_id(&self) -> std::option::Option<&str> {
        self.parent_asset_id.as_deref()
    }
    /// <p>The ID of the child asset in this asset relationship.</p>
    pub fn child_asset_id(&self) -> std::option::Option<&str> {
        self.child_asset_id.as_deref()
    }
}
impl std::fmt::Debug for AssetHierarchyInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetHierarchyInfo");
        formatter.field("parent_asset_id", &self.parent_asset_id);
        formatter.field("child_asset_id", &self.child_asset_id);
        formatter.finish()
    }
}
/// See [`AssetHierarchyInfo`](crate::model::AssetHierarchyInfo)
pub mod asset_hierarchy_info {
    /// A builder for [`AssetHierarchyInfo`](crate::model::AssetHierarchyInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parent_asset_id: std::option::Option<std::string::String>,
        pub(crate) child_asset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the parent asset in this asset relationship.</p>
        pub fn parent_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent asset in this asset relationship.</p>
        pub fn set_parent_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_asset_id = input;
            self
        }
        /// <p>The ID of the child asset in this asset relationship.</p>
        pub fn child_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the child asset in this asset relationship.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.child_asset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetHierarchyInfo`](crate::model::AssetHierarchyInfo)
        pub fn build(self) -> crate::model::AssetHierarchyInfo {
            crate::model::AssetHierarchyInfo {
                parent_asset_id: self.parent_asset_id,
                child_asset_id: self.child_asset_id,
            }
        }
    }
}
impl AssetHierarchyInfo {
    /// Creates a new builder-style object to manufacture [`AssetHierarchyInfo`](crate::model::AssetHierarchyInfo)
    pub fn builder() -> crate::model::asset_hierarchy_info::Builder {
        crate::model::asset_hierarchy_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TraversalType {
    #[allow(missing_docs)] // documentation missing in model
    PathToRoot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TraversalType {
    fn from(s: &str) -> Self {
        match s {
            "PATH_TO_ROOT" => TraversalType::PathToRoot,
            other => TraversalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TraversalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TraversalType::from(s))
    }
}
impl TraversalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TraversalType::PathToRoot => "PATH_TO_ROOT",
            TraversalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PATH_TO_ROOT"]
    }
}
impl AsRef<str> for TraversalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a summary of an asset model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelSummary {
    /// <p>The ID of the asset model (used with IoT SiteWise APIs).</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the asset model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The asset model description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date the asset model was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the asset model was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the asset model.</p>
    pub status: std::option::Option<crate::model::AssetModelStatus>,
}
impl AssetModelSummary {
    /// <p>The ID of the asset model (used with IoT SiteWise APIs).</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
    /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the asset model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The asset model description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date the asset model was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the asset model was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
    /// <p>The current status of the asset model.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssetModelStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AssetModelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AssetModelSummary`](crate::model::AssetModelSummary)
pub mod asset_model_summary {
    /// A builder for [`AssetModelSummary`](crate::model::AssetModelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AssetModelStatus>,
    }
    impl Builder {
        /// <p>The ID of the asset model (used with IoT SiteWise APIs).</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model (used with IoT SiteWise APIs).</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>
        /// <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the asset model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The asset model description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The asset model description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date the asset model was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the asset model was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the asset model was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the asset model was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// <p>The current status of the asset model.</p>
        pub fn status(mut self, input: crate::model::AssetModelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the asset model.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssetModelStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelSummary`](crate::model::AssetModelSummary)
        pub fn build(self) -> crate::model::AssetModelSummary {
            crate::model::AssetModelSummary {
                id: self.id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
                status: self.status,
            }
        }
    }
}
impl AssetModelSummary {
    /// Creates a new builder-style object to manufacture [`AssetModelSummary`](crate::model::AssetModelSummary)
    pub fn builder() -> crate::model::asset_model_summary::Builder {
        crate::model::asset_model_summary::Builder::default()
    }
}

/// <p>Contains an access policy that defines an identity's access to an IoT SiteWise Monitor resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPolicySummary {
    /// <p>The ID of the access policy.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).</p>
    pub identity: std::option::Option<crate::model::Identity>,
    /// <p>The IoT SiteWise Monitor resource (a portal or project).</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub permission: std::option::Option<crate::model::Permission>,
    /// <p>The date the access policy was created, in Unix epoch time.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the access policy was last updated, in Unix epoch time.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl AccessPolicySummary {
    /// <p>The ID of the access policy.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).</p>
    pub fn identity(&self) -> std::option::Option<&crate::model::Identity> {
        self.identity.as_ref()
    }
    /// <p>The IoT SiteWise Monitor resource (a portal or project).</p>
    pub fn resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.resource.as_ref()
    }
    /// <p>The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub fn permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.permission.as_ref()
    }
    /// <p>The date the access policy was created, in Unix epoch time.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the access policy was last updated, in Unix epoch time.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date.as_ref()
    }
}
impl std::fmt::Debug for AccessPolicySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPolicySummary");
        formatter.field("id", &self.id);
        formatter.field("identity", &self.identity);
        formatter.field("resource", &self.resource);
        formatter.field("permission", &self.permission);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.finish()
    }
}
/// See [`AccessPolicySummary`](crate::model::AccessPolicySummary)
pub mod access_policy_summary {
    /// A builder for [`AccessPolicySummary`](crate::model::AccessPolicySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) identity: std::option::Option<crate::model::Identity>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) permission: std::option::Option<crate::model::Permission>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the access policy.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).</p>
        pub fn identity(mut self, input: crate::model::Identity) -> Self {
            self.identity = Some(input);
            self
        }
        /// <p>The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).</p>
        pub fn set_identity(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The IoT SiteWise Monitor resource (a portal or project).</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource (a portal or project).</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn permission(mut self, input: crate::model::Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// <p>The date the access policy was created, in Unix epoch time.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the access policy was created, in Unix epoch time.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the access policy was last updated, in Unix epoch time.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date the access policy was last updated, in Unix epoch time.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPolicySummary`](crate::model::AccessPolicySummary)
        pub fn build(self) -> crate::model::AccessPolicySummary {
            crate::model::AccessPolicySummary {
                id: self.id,
                identity: self.identity,
                resource: self.resource,
                permission: self.permission,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
            }
        }
    }
}
impl AccessPolicySummary {
    /// Creates a new builder-style object to manufacture [`AccessPolicySummary`](crate::model::AccessPolicySummary)
    pub fn builder() -> crate::model::access_policy_summary::Builder {
        crate::model::access_policy_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Portal,
    #[allow(missing_docs)] // documentation missing in model
    Project,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "PORTAL" => ResourceType::Portal,
            "PROJECT" => ResourceType::Project,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Portal => "PORTAL",
            ResourceType::Project => "PROJECT",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PORTAL", "PROJECT"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => IdentityType::Group,
            "IAM" => IdentityType::Iam,
            "USER" => IdentityType::User,
            other => IdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityType::from(s))
    }
}
impl IdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityType::Group => "GROUP",
            IdentityType::Iam => "IAM",
            IdentityType::User => "USER",
            IdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "IAM", "USER"]
    }
}
impl AsRef<str> for IdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an interpolated asset property value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InterpolatedAssetPropertyValue {
    /// <p>Contains a timestamp with optional nanosecond granularity.</p>
    pub timestamp: std::option::Option<crate::model::TimeInNanos>,
    /// <p>Contains an asset property value (of a single type only).</p>
    pub value: std::option::Option<crate::model::Variant>,
}
impl InterpolatedAssetPropertyValue {
    /// <p>Contains a timestamp with optional nanosecond granularity.</p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::TimeInNanos> {
        self.timestamp.as_ref()
    }
    /// <p>Contains an asset property value (of a single type only).</p>
    pub fn value(&self) -> std::option::Option<&crate::model::Variant> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for InterpolatedAssetPropertyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InterpolatedAssetPropertyValue");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`InterpolatedAssetPropertyValue`](crate::model::InterpolatedAssetPropertyValue)
pub mod interpolated_asset_property_value {
    /// A builder for [`InterpolatedAssetPropertyValue`](crate::model::InterpolatedAssetPropertyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<crate::model::TimeInNanos>,
        pub(crate) value: std::option::Option<crate::model::Variant>,
    }
    impl Builder {
        /// <p>Contains a timestamp with optional nanosecond granularity.</p>
        pub fn timestamp(mut self, input: crate::model::TimeInNanos) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Contains a timestamp with optional nanosecond granularity.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::TimeInNanos>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Contains an asset property value (of a single type only).</p>
        pub fn value(mut self, input: crate::model::Variant) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Contains an asset property value (of a single type only).</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::Variant>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`InterpolatedAssetPropertyValue`](crate::model::InterpolatedAssetPropertyValue)
        pub fn build(self) -> crate::model::InterpolatedAssetPropertyValue {
            crate::model::InterpolatedAssetPropertyValue {
                timestamp: self.timestamp,
                value: self.value,
            }
        }
    }
}
impl InterpolatedAssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`InterpolatedAssetPropertyValue`](crate::model::InterpolatedAssetPropertyValue)
    pub fn builder() -> crate::model::interpolated_asset_property_value::Builder {
        crate::model::interpolated_asset_property_value::Builder::default()
    }
}

/// <p>Contains an asset property value (of a single type only).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Variant {
    /// <p>Asset property data of type string (sequence of characters).</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>Asset property data of type integer (whole number).</p>
    pub integer_value: std::option::Option<i32>,
    /// <p>Asset property data of type double (floating point number).</p>
    pub double_value: std::option::Option<f64>,
    /// <p>Asset property data of type Boolean (true or false).</p>
    pub boolean_value: std::option::Option<bool>,
}
impl Variant {
    /// <p>Asset property data of type string (sequence of characters).</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>Asset property data of type integer (whole number).</p>
    pub fn integer_value(&self) -> std::option::Option<i32> {
        self.integer_value
    }
    /// <p>Asset property data of type double (floating point number).</p>
    pub fn double_value(&self) -> std::option::Option<f64> {
        self.double_value
    }
    /// <p>Asset property data of type Boolean (true or false).</p>
    pub fn boolean_value(&self) -> std::option::Option<bool> {
        self.boolean_value
    }
}
impl std::fmt::Debug for Variant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Variant");
        formatter.field("string_value", &self.string_value);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("double_value", &self.double_value);
        formatter.field("boolean_value", &self.boolean_value);
        formatter.finish()
    }
}
/// See [`Variant`](crate::model::Variant)
pub mod variant {
    /// A builder for [`Variant`](crate::model::Variant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) integer_value: std::option::Option<i32>,
        pub(crate) double_value: std::option::Option<f64>,
        pub(crate) boolean_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Asset property data of type string (sequence of characters).</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>Asset property data of type string (sequence of characters).</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>Asset property data of type integer (whole number).</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p>Asset property data of type integer (whole number).</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// <p>Asset property data of type double (floating point number).</p>
        pub fn double_value(mut self, input: f64) -> Self {
            self.double_value = Some(input);
            self
        }
        /// <p>Asset property data of type double (floating point number).</p>
        pub fn set_double_value(mut self, input: std::option::Option<f64>) -> Self {
            self.double_value = input;
            self
        }
        /// <p>Asset property data of type Boolean (true or false).</p>
        pub fn boolean_value(mut self, input: bool) -> Self {
            self.boolean_value = Some(input);
            self
        }
        /// <p>Asset property data of type Boolean (true or false).</p>
        pub fn set_boolean_value(mut self, input: std::option::Option<bool>) -> Self {
            self.boolean_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Variant`](crate::model::Variant)
        pub fn build(self) -> crate::model::Variant {
            crate::model::Variant {
                string_value: self.string_value,
                integer_value: self.integer_value,
                double_value: self.double_value,
                boolean_value: self.boolean_value,
            }
        }
    }
}
impl Variant {
    /// Creates a new builder-style object to manufacture [`Variant`](crate::model::Variant)
    pub fn builder() -> crate::model::variant::Builder {
        crate::model::variant::Builder::default()
    }
}

/// <p>Contains a timestamp with optional nanosecond granularity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeInNanos {
    /// <p>The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by <code>offsetInNanos</code>.</p>
    pub time_in_seconds: std::option::Option<i64>,
    /// <p>The nanosecond offset from <code>timeInSeconds</code>.</p>
    pub offset_in_nanos: std::option::Option<i32>,
}
impl TimeInNanos {
    /// <p>The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by <code>offsetInNanos</code>.</p>
    pub fn time_in_seconds(&self) -> std::option::Option<i64> {
        self.time_in_seconds
    }
    /// <p>The nanosecond offset from <code>timeInSeconds</code>.</p>
    pub fn offset_in_nanos(&self) -> std::option::Option<i32> {
        self.offset_in_nanos
    }
}
impl std::fmt::Debug for TimeInNanos {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeInNanos");
        formatter.field("time_in_seconds", &self.time_in_seconds);
        formatter.field("offset_in_nanos", &self.offset_in_nanos);
        formatter.finish()
    }
}
/// See [`TimeInNanos`](crate::model::TimeInNanos)
pub mod time_in_nanos {
    /// A builder for [`TimeInNanos`](crate::model::TimeInNanos)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_in_seconds: std::option::Option<i64>,
        pub(crate) offset_in_nanos: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by <code>offsetInNanos</code>.</p>
        pub fn time_in_seconds(mut self, input: i64) -> Self {
            self.time_in_seconds = Some(input);
            self
        }
        /// <p>The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by <code>offsetInNanos</code>.</p>
        pub fn set_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.time_in_seconds = input;
            self
        }
        /// <p>The nanosecond offset from <code>timeInSeconds</code>.</p>
        pub fn offset_in_nanos(mut self, input: i32) -> Self {
            self.offset_in_nanos = Some(input);
            self
        }
        /// <p>The nanosecond offset from <code>timeInSeconds</code>.</p>
        pub fn set_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.offset_in_nanos = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeInNanos`](crate::model::TimeInNanos)
        pub fn build(self) -> crate::model::TimeInNanos {
            crate::model::TimeInNanos {
                time_in_seconds: self.time_in_seconds,
                offset_in_nanos: self.offset_in_nanos,
            }
        }
    }
}
impl TimeInNanos {
    /// Creates a new builder-style object to manufacture [`TimeInNanos`](crate::model::TimeInNanos)
    pub fn builder() -> crate::model::time_in_nanos::Builder {
        crate::model::time_in_nanos::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Quality {
    #[allow(missing_docs)] // documentation missing in model
    Bad,
    #[allow(missing_docs)] // documentation missing in model
    Good,
    #[allow(missing_docs)] // documentation missing in model
    Uncertain,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Quality {
    fn from(s: &str) -> Self {
        match s {
            "BAD" => Quality::Bad,
            "GOOD" => Quality::Good,
            "UNCERTAIN" => Quality::Uncertain,
            other => Quality::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Quality {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Quality::from(s))
    }
}
impl Quality {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Quality::Bad => "BAD",
            Quality::Good => "GOOD",
            Quality::Uncertain => "UNCERTAIN",
            Quality::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BAD", "GOOD", "UNCERTAIN"]
    }
}
impl AsRef<str> for Quality {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains asset property value information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyValue {
    /// <p>The value of the asset property (see <code>Variant</code>).</p>
    pub value: std::option::Option<crate::model::Variant>,
    /// <p>The timestamp of the asset property value.</p>
    pub timestamp: std::option::Option<crate::model::TimeInNanos>,
    /// <p>The quality of the asset property value.</p>
    pub quality: std::option::Option<crate::model::Quality>,
}
impl AssetPropertyValue {
    /// <p>The value of the asset property (see <code>Variant</code>).</p>
    pub fn value(&self) -> std::option::Option<&crate::model::Variant> {
        self.value.as_ref()
    }
    /// <p>The timestamp of the asset property value.</p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::TimeInNanos> {
        self.timestamp.as_ref()
    }
    /// <p>The quality of the asset property value.</p>
    pub fn quality(&self) -> std::option::Option<&crate::model::Quality> {
        self.quality.as_ref()
    }
}
impl std::fmt::Debug for AssetPropertyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyValue");
        formatter.field("value", &self.value);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("quality", &self.quality);
        formatter.finish()
    }
}
/// See [`AssetPropertyValue`](crate::model::AssetPropertyValue)
pub mod asset_property_value {
    /// A builder for [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::Variant>,
        pub(crate) timestamp: std::option::Option<crate::model::TimeInNanos>,
        pub(crate) quality: std::option::Option<crate::model::Quality>,
    }
    impl Builder {
        /// <p>The value of the asset property (see <code>Variant</code>).</p>
        pub fn value(mut self, input: crate::model::Variant) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the asset property (see <code>Variant</code>).</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::Variant>) -> Self {
            self.value = input;
            self
        }
        /// <p>The timestamp of the asset property value.</p>
        pub fn timestamp(mut self, input: crate::model::TimeInNanos) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the asset property value.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::TimeInNanos>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The quality of the asset property value.</p>
        pub fn quality(mut self, input: crate::model::Quality) -> Self {
            self.quality = Some(input);
            self
        }
        /// <p>The quality of the asset property value.</p>
        pub fn set_quality(mut self, input: std::option::Option<crate::model::Quality>) -> Self {
            self.quality = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyValue`](crate::model::AssetPropertyValue)
        pub fn build(self) -> crate::model::AssetPropertyValue {
            crate::model::AssetPropertyValue {
                value: self.value,
                timestamp: self.timestamp,
                quality: self.quality,
            }
        }
    }
}
impl AssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    pub fn builder() -> crate::model::asset_property_value::Builder {
        crate::model::asset_property_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeOrdering {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeOrdering {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => TimeOrdering::Ascending,
            "DESCENDING" => TimeOrdering::Descending,
            other => TimeOrdering::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeOrdering {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeOrdering::from(s))
    }
}
impl TimeOrdering {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeOrdering::Ascending => "ASCENDING",
            TimeOrdering::Descending => "DESCENDING",
            TimeOrdering::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for TimeOrdering {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains aggregated asset property values (for example, average, minimum, and maximum).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedValue {
    /// <p>The date the aggregating computations occurred, in Unix epoch time.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The quality of the aggregated data.</p>
    pub quality: std::option::Option<crate::model::Quality>,
    /// <p>The value of the aggregates.</p>
    pub value: std::option::Option<crate::model::Aggregates>,
}
impl AggregatedValue {
    /// <p>The date the aggregating computations occurred, in Unix epoch time.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The quality of the aggregated data.</p>
    pub fn quality(&self) -> std::option::Option<&crate::model::Quality> {
        self.quality.as_ref()
    }
    /// <p>The value of the aggregates.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::Aggregates> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for AggregatedValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedValue");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("quality", &self.quality);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AggregatedValue`](crate::model::AggregatedValue)
pub mod aggregated_value {
    /// A builder for [`AggregatedValue`](crate::model::AggregatedValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) quality: std::option::Option<crate::model::Quality>,
        pub(crate) value: std::option::Option<crate::model::Aggregates>,
    }
    impl Builder {
        /// <p>The date the aggregating computations occurred, in Unix epoch time.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The date the aggregating computations occurred, in Unix epoch time.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The quality of the aggregated data.</p>
        pub fn quality(mut self, input: crate::model::Quality) -> Self {
            self.quality = Some(input);
            self
        }
        /// <p>The quality of the aggregated data.</p>
        pub fn set_quality(mut self, input: std::option::Option<crate::model::Quality>) -> Self {
            self.quality = input;
            self
        }
        /// <p>The value of the aggregates.</p>
        pub fn value(mut self, input: crate::model::Aggregates) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the aggregates.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::Aggregates>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedValue`](crate::model::AggregatedValue)
        pub fn build(self) -> crate::model::AggregatedValue {
            crate::model::AggregatedValue {
                timestamp: self.timestamp,
                quality: self.quality,
                value: self.value,
            }
        }
    }
}
impl AggregatedValue {
    /// Creates a new builder-style object to manufacture [`AggregatedValue`](crate::model::AggregatedValue)
    pub fn builder() -> crate::model::aggregated_value::Builder {
        crate::model::aggregated_value::Builder::default()
    }
}

/// <p>Contains the (pre-calculated) aggregate values for an asset property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Aggregates {
    /// <p>The average (mean) value of the time series over a time interval window.</p>
    pub average: std::option::Option<f64>,
    /// <p>The count of data points in the time series over a time interval window.</p>
    pub count: std::option::Option<f64>,
    /// <p>The maximum value of the time series over a time interval window.</p>
    pub maximum: std::option::Option<f64>,
    /// <p>The minimum value of the time series over a time interval window.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The sum of the time series over a time interval window.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The standard deviation of the time series over a time interval window.</p>
    pub standard_deviation: std::option::Option<f64>,
}
impl Aggregates {
    /// <p>The average (mean) value of the time series over a time interval window.</p>
    pub fn average(&self) -> std::option::Option<f64> {
        self.average
    }
    /// <p>The count of data points in the time series over a time interval window.</p>
    pub fn count(&self) -> std::option::Option<f64> {
        self.count
    }
    /// <p>The maximum value of the time series over a time interval window.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
    /// <p>The minimum value of the time series over a time interval window.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>The sum of the time series over a time interval window.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>The standard deviation of the time series over a time interval window.</p>
    pub fn standard_deviation(&self) -> std::option::Option<f64> {
        self.standard_deviation
    }
}
impl std::fmt::Debug for Aggregates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Aggregates");
        formatter.field("average", &self.average);
        formatter.field("count", &self.count);
        formatter.field("maximum", &self.maximum);
        formatter.field("minimum", &self.minimum);
        formatter.field("sum", &self.sum);
        formatter.field("standard_deviation", &self.standard_deviation);
        formatter.finish()
    }
}
/// See [`Aggregates`](crate::model::Aggregates)
pub mod aggregates {
    /// A builder for [`Aggregates`](crate::model::Aggregates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) average: std::option::Option<f64>,
        pub(crate) count: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) standard_deviation: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The average (mean) value of the time series over a time interval window.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average (mean) value of the time series over a time interval window.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The count of data points in the time series over a time interval window.</p>
        pub fn count(mut self, input: f64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The count of data points in the time series over a time interval window.</p>
        pub fn set_count(mut self, input: std::option::Option<f64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The maximum value of the time series over a time interval window.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum value of the time series over a time interval window.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>The minimum value of the time series over a time interval window.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum value of the time series over a time interval window.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The sum of the time series over a time interval window.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of the time series over a time interval window.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The standard deviation of the time series over a time interval window.</p>
        pub fn standard_deviation(mut self, input: f64) -> Self {
            self.standard_deviation = Some(input);
            self
        }
        /// <p>The standard deviation of the time series over a time interval window.</p>
        pub fn set_standard_deviation(mut self, input: std::option::Option<f64>) -> Self {
            self.standard_deviation = input;
            self
        }
        /// Consumes the builder and constructs a [`Aggregates`](crate::model::Aggregates)
        pub fn build(self) -> crate::model::Aggregates {
            crate::model::Aggregates {
                average: self.average,
                count: self.count,
                maximum: self.maximum,
                minimum: self.minimum,
                sum: self.sum,
                standard_deviation: self.standard_deviation,
            }
        }
    }
}
impl Aggregates {
    /// Creates a new builder-style object to manufacture [`Aggregates`](crate::model::Aggregates)
    pub fn builder() -> crate::model::aggregates::Builder {
        crate::model::aggregates::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregateType {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    StandardDeviation,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregateType {
    fn from(s: &str) -> Self {
        match s {
            "AVERAGE" => AggregateType::Average,
            "COUNT" => AggregateType::Count,
            "MAXIMUM" => AggregateType::Maximum,
            "MINIMUM" => AggregateType::Minimum,
            "STANDARD_DEVIATION" => AggregateType::StandardDeviation,
            "SUM" => AggregateType::Sum,
            other => AggregateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregateType::from(s))
    }
}
impl AggregateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregateType::Average => "AVERAGE",
            AggregateType::Count => "COUNT",
            AggregateType::Maximum => "MAXIMUM",
            AggregateType::Minimum => "MINIMUM",
            AggregateType::StandardDeviation => "STANDARD_DEVIATION",
            AggregateType::Sum => "SUM",
            AggregateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVERAGE",
            "COUNT",
            "MAXIMUM",
            "MINIMUM",
            "STANDARD_DEVIATION",
            "SUM",
        ]
    }
}
impl AsRef<str> for AggregateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthMode {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    Sso,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthMode {
    fn from(s: &str) -> Self {
        match s {
            "IAM" => AuthMode::Iam,
            "SSO" => AuthMode::Sso,
            other => AuthMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthMode::from(s))
    }
}
impl AuthMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthMode::Iam => "IAM",
            AuthMode::Sso => "SSO",
            AuthMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM", "SSO"]
    }
}
impl AsRef<str> for AuthMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an image that is uploaded to IoT SiteWise and available at a URL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageLocation {
    /// <p>The ID of the image.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The URL where the image is available. The URL is valid for 15 minutes so that you can view and download the image</p>
    pub url: std::option::Option<std::string::String>,
}
impl ImageLocation {
    /// <p>The ID of the image.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The URL where the image is available. The URL is valid for 15 minutes so that you can view and download the image</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for ImageLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageLocation");
        formatter.field("id", &self.id);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`ImageLocation`](crate::model::ImageLocation)
pub mod image_location {
    /// A builder for [`ImageLocation`](crate::model::ImageLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the image.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the image.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The URL where the image is available. The URL is valid for 15 minutes so that you can view and download the image</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL where the image is available. The URL is valid for 15 minutes so that you can view and download the image</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageLocation`](crate::model::ImageLocation)
        pub fn build(self) -> crate::model::ImageLocation {
            crate::model::ImageLocation {
                id: self.id,
                url: self.url,
            }
        }
    }
}
impl ImageLocation {
    /// Creates a new builder-style object to manufacture [`ImageLocation`](crate::model::ImageLocation)
    pub fn builder() -> crate::model::image_location::Builder {
        crate::model::image_location::Builder::default()
    }
}

/// <p>Contains information about a composite model property on an asset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompositeModelProperty {
    /// <p>The name of the property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the composite model that defines this property.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Contains asset property information.</p>
    pub asset_property: std::option::Option<crate::model::Property>,
}
impl CompositeModelProperty {
    /// <p>The name of the property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the composite model that defines this property.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>Contains asset property information.</p>
    pub fn asset_property(&self) -> std::option::Option<&crate::model::Property> {
        self.asset_property.as_ref()
    }
}
impl std::fmt::Debug for CompositeModelProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompositeModelProperty");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("asset_property", &self.asset_property);
        formatter.finish()
    }
}
/// See [`CompositeModelProperty`](crate::model::CompositeModelProperty)
pub mod composite_model_property {
    /// A builder for [`CompositeModelProperty`](crate::model::CompositeModelProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) asset_property: std::option::Option<crate::model::Property>,
    }
    impl Builder {
        /// <p>The name of the property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the composite model that defines this property.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the composite model that defines this property.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Contains asset property information.</p>
        pub fn asset_property(mut self, input: crate::model::Property) -> Self {
            self.asset_property = Some(input);
            self
        }
        /// <p>Contains asset property information.</p>
        pub fn set_asset_property(
            mut self,
            input: std::option::Option<crate::model::Property>,
        ) -> Self {
            self.asset_property = input;
            self
        }
        /// Consumes the builder and constructs a [`CompositeModelProperty`](crate::model::CompositeModelProperty)
        pub fn build(self) -> crate::model::CompositeModelProperty {
            crate::model::CompositeModelProperty {
                name: self.name,
                r#type: self.r#type,
                asset_property: self.asset_property,
            }
        }
    }
}
impl CompositeModelProperty {
    /// Creates a new builder-style object to manufacture [`CompositeModelProperty`](crate::model::CompositeModelProperty)
    pub fn builder() -> crate::model::composite_model_property::Builder {
        crate::model::composite_model_property::Builder::default()
    }
}

/// <p>Contains asset property information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Property {
    /// <p>The ID of the asset property.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    pub notification: std::option::Option<crate::model::PropertyNotification>,
    /// <p>The property data type.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The property type (see <code>PropertyType</code>). A property contains one type.</p>
    pub r#type: std::option::Option<crate::model::PropertyType>,
}
impl Property {
    /// <p>The ID of the asset property.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::PropertyNotification> {
        self.notification.as_ref()
    }
    /// <p>The property data type.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The property type (see <code>PropertyType</code>). A property contains one type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PropertyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Property {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Property");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("alias", &self.alias);
        formatter.field("notification", &self.notification);
        formatter.field("data_type", &self.data_type);
        formatter.field("unit", &self.unit);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Property`](crate::model::Property)
pub mod property {
    /// A builder for [`Property`](crate::model::Property)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::PropertyNotification>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PropertyType>,
    }
    impl Builder {
        /// <p>The ID of the asset property.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
        pub fn notification(mut self, input: crate::model::PropertyNotification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::PropertyNotification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The property data type.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The property data type.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The property type (see <code>PropertyType</code>). A property contains one type.</p>
        pub fn r#type(mut self, input: crate::model::PropertyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The property type (see <code>PropertyType</code>). A property contains one type.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PropertyType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Property`](crate::model::Property)
        pub fn build(self) -> crate::model::Property {
            crate::model::Property {
                id: self.id,
                name: self.name,
                alias: self.alias,
                notification: self.notification,
                data_type: self.data_type,
                unit: self.unit,
                r#type: self.r#type,
            }
        }
    }
}
impl Property {
    /// Creates a new builder-style object to manufacture [`Property`](crate::model::Property)
    pub fn builder() -> crate::model::property::Builder {
        crate::model::property::Builder::default()
    }
}

/// <p>Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyNotification {
    /// <p>The MQTT topic to which IoT SiteWise publishes property value update notifications.</p>
    pub topic: std::option::Option<std::string::String>,
    /// <p>The current notification state.</p>
    pub state: std::option::Option<crate::model::PropertyNotificationState>,
}
impl PropertyNotification {
    /// <p>The MQTT topic to which IoT SiteWise publishes property value update notifications.</p>
    pub fn topic(&self) -> std::option::Option<&str> {
        self.topic.as_deref()
    }
    /// <p>The current notification state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::PropertyNotificationState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for PropertyNotification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyNotification");
        formatter.field("topic", &self.topic);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`PropertyNotification`](crate::model::PropertyNotification)
pub mod property_notification {
    /// A builder for [`PropertyNotification`](crate::model::PropertyNotification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::PropertyNotificationState>,
    }
    impl Builder {
        /// <p>The MQTT topic to which IoT SiteWise publishes property value update notifications.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>The MQTT topic to which IoT SiteWise publishes property value update notifications.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        /// <p>The current notification state.</p>
        pub fn state(mut self, input: crate::model::PropertyNotificationState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current notification state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::PropertyNotificationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyNotification`](crate::model::PropertyNotification)
        pub fn build(self) -> crate::model::PropertyNotification {
            crate::model::PropertyNotification {
                topic: self.topic,
                state: self.state,
            }
        }
    }
}
impl PropertyNotification {
    /// Creates a new builder-style object to manufacture [`PropertyNotification`](crate::model::PropertyNotification)
    pub fn builder() -> crate::model::property_notification::Builder {
        crate::model::property_notification::Builder::default()
    }
}

/// <p>Contains information about a composite model in an asset. This object contains the asset's properties that you define in the composite model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetCompositeModel {
    /// <p>The name of the composite model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the composite model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The asset properties that this composite model defines.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
}
impl AssetCompositeModel {
    /// <p>The name of the composite model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the composite model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The asset properties that this composite model defines.</p>
    pub fn properties(&self) -> std::option::Option<&[crate::model::AssetProperty]> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for AssetCompositeModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetCompositeModel");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`AssetCompositeModel`](crate::model::AssetCompositeModel)
pub mod asset_composite_model {
    /// A builder for [`AssetCompositeModel`](crate::model::AssetCompositeModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
    }
    impl Builder {
        /// <p>The name of the composite model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the composite model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The asset properties that this composite model defines.</p>
        pub fn properties(mut self, input: crate::model::AssetProperty) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input);
            self.properties = Some(v);
            self
        }
        /// <p>The asset properties that this composite model defines.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetProperty>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetCompositeModel`](crate::model::AssetCompositeModel)
        pub fn build(self) -> crate::model::AssetCompositeModel {
            crate::model::AssetCompositeModel {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                properties: self.properties,
            }
        }
    }
}
impl AssetCompositeModel {
    /// Creates a new builder-style object to manufacture [`AssetCompositeModel`](crate::model::AssetCompositeModel)
    pub fn builder() -> crate::model::asset_composite_model::Builder {
        crate::model::asset_composite_model::Builder::default()
    }
}

/// <p>Contains asset property information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetProperty {
    /// <p>The ID of the asset property.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    pub notification: std::option::Option<crate::model::PropertyNotification>,
    /// <p>The data type of the asset property.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
    pub data_type_spec: std::option::Option<std::string::String>,
    /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl AssetProperty {
    /// <p>The ID of the asset property.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the property.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::PropertyNotification> {
        self.notification.as_ref()
    }
    /// <p>The data type of the asset property.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
    pub fn data_type_spec(&self) -> std::option::Option<&str> {
        self.data_type_spec.as_deref()
    }
    /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for AssetProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetProperty");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("alias", &self.alias);
        formatter.field("notification", &self.notification);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_type_spec", &self.data_type_spec);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`AssetProperty`](crate::model::AssetProperty)
pub mod asset_property {
    /// A builder for [`AssetProperty`](crate::model::AssetProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::PropertyNotification>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) data_type_spec: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset property.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
        pub fn notification(mut self, input: crate::model::PropertyNotification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::PropertyNotification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The data type of the asset property.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the asset property.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
        pub fn data_type_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type_spec = Some(input.into());
            self
        }
        /// <p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>
        pub fn set_data_type_spec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_type_spec = input;
            self
        }
        /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetProperty`](crate::model::AssetProperty)
        pub fn build(self) -> crate::model::AssetProperty {
            crate::model::AssetProperty {
                id: self.id,
                name: self.name,
                alias: self.alias,
                notification: self.notification,
                data_type: self.data_type,
                data_type_spec: self.data_type_spec,
                unit: self.unit,
            }
        }
    }
}
impl AssetProperty {
    /// Creates a new builder-style object to manufacture [`AssetProperty`](crate::model::AssetProperty)
    pub fn builder() -> crate::model::asset_property::Builder {
        crate::model::asset_property::Builder::default()
    }
}

/// <p>Contains a composite model definition in an asset model. This composite model definition is applied to all assets created from the asset model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelCompositeModelDefinition {
    /// <p>The name of the composite model.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the composite model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The asset property definitions for this composite model.</p>
    pub properties: std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
}
impl AssetModelCompositeModelDefinition {
    /// <p>The name of the composite model.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the composite model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The asset property definitions for this composite model.</p>
    pub fn properties(&self) -> std::option::Option<&[crate::model::AssetModelPropertyDefinition]> {
        self.properties.as_deref()
    }
}
impl std::fmt::Debug for AssetModelCompositeModelDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelCompositeModelDefinition");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`AssetModelCompositeModelDefinition`](crate::model::AssetModelCompositeModelDefinition)
pub mod asset_model_composite_model_definition {
    /// A builder for [`AssetModelCompositeModelDefinition`](crate::model::AssetModelCompositeModelDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) properties:
            std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
    }
    impl Builder {
        /// <p>The name of the composite model.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the composite model.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the composite model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The asset property definitions for this composite model.</p>
        pub fn properties(mut self, input: crate::model::AssetModelPropertyDefinition) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input);
            self.properties = Some(v);
            self
        }
        /// <p>The asset property definitions for this composite model.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelCompositeModelDefinition`](crate::model::AssetModelCompositeModelDefinition)
        pub fn build(self) -> crate::model::AssetModelCompositeModelDefinition {
            crate::model::AssetModelCompositeModelDefinition {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                properties: self.properties,
            }
        }
    }
}
impl AssetModelCompositeModelDefinition {
    /// Creates a new builder-style object to manufacture [`AssetModelCompositeModelDefinition`](crate::model::AssetModelCompositeModelDefinition)
    pub fn builder() -> crate::model::asset_model_composite_model_definition::Builder {
        crate::model::asset_model_composite_model_definition::Builder::default()
    }
}

/// <p>Contains an asset model property definition. This property definition is applied to all assets created from the asset model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelPropertyDefinition {
    /// <p>The name of the property definition.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the property definition.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.</p>
    pub data_type: std::option::Option<crate::model::PropertyDataType>,
    /// <p>The data type of the structure for this property. This parameter is required on properties that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you define this property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub data_type_spec: std::option::Option<std::string::String>,
    /// <p>The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The property definition type (see <code>PropertyType</code>). You can only specify one type in a property definition.</p>
    pub r#type: std::option::Option<crate::model::PropertyType>,
}
impl AssetModelPropertyDefinition {
    /// <p>The name of the property definition.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the property definition.</p>
    /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.</p>
    pub fn data_type(&self) -> std::option::Option<&crate::model::PropertyDataType> {
        self.data_type.as_ref()
    }
    /// <p>The data type of the structure for this property. This parameter is required on properties that have the <code>STRUCT</code> data type.</p>
    /// <p>The options for this parameter depend on the type of the composite model in which you define this property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    pub fn data_type_spec(&self) -> std::option::Option<&str> {
        self.data_type_spec.as_deref()
    }
    /// <p>The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The property definition type (see <code>PropertyType</code>). You can only specify one type in a property definition.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PropertyType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for AssetModelPropertyDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelPropertyDefinition");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("data_type_spec", &self.data_type_spec);
        formatter.field("unit", &self.unit);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AssetModelPropertyDefinition`](crate::model::AssetModelPropertyDefinition)
pub mod asset_model_property_definition {
    /// A builder for [`AssetModelPropertyDefinition`](crate::model::AssetModelPropertyDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::PropertyDataType>,
        pub(crate) data_type_spec: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PropertyType>,
    }
    impl Builder {
        /// <p>The name of the property definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the property definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the property definition.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.</p>
        pub fn data_type(mut self, input: crate::model::PropertyDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the property definition.</p>
        /// <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::PropertyDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The data type of the structure for this property. This parameter is required on properties that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you define this property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn data_type_spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type_spec = Some(input.into());
            self
        }
        /// <p>The data type of the structure for this property. This parameter is required on properties that have the <code>STRUCT</code> data type.</p>
        /// <p>The options for this parameter depend on the type of the composite model in which you define this property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
        pub fn set_data_type_spec(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_type_spec = input;
            self
        }
        /// <p>The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The property definition type (see <code>PropertyType</code>). You can only specify one type in a property definition.</p>
        pub fn r#type(mut self, input: crate::model::PropertyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The property definition type (see <code>PropertyType</code>). You can only specify one type in a property definition.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PropertyType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelPropertyDefinition`](crate::model::AssetModelPropertyDefinition)
        pub fn build(self) -> crate::model::AssetModelPropertyDefinition {
            crate::model::AssetModelPropertyDefinition {
                name: self.name,
                data_type: self.data_type,
                data_type_spec: self.data_type_spec,
                unit: self.unit,
                r#type: self.r#type,
            }
        }
    }
}
impl AssetModelPropertyDefinition {
    /// Creates a new builder-style object to manufacture [`AssetModelPropertyDefinition`](crate::model::AssetModelPropertyDefinition)
    pub fn builder() -> crate::model::asset_model_property_definition::Builder {
        crate::model::asset_model_property_definition::Builder::default()
    }
}

/// <p>Contains an asset model hierarchy used in asset model creation. An asset model hierarchy determines the kind (or type) of asset that can belong to a hierarchy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetModelHierarchyDefinition {
    /// <p>The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of an asset model for this hierarchy.</p>
    pub child_asset_model_id: std::option::Option<std::string::String>,
}
impl AssetModelHierarchyDefinition {
    /// <p>The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of an asset model for this hierarchy.</p>
    pub fn child_asset_model_id(&self) -> std::option::Option<&str> {
        self.child_asset_model_id.as_deref()
    }
}
impl std::fmt::Debug for AssetModelHierarchyDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetModelHierarchyDefinition");
        formatter.field("name", &self.name);
        formatter.field("child_asset_model_id", &self.child_asset_model_id);
        formatter.finish()
    }
}
/// See [`AssetModelHierarchyDefinition`](crate::model::AssetModelHierarchyDefinition)
pub mod asset_model_hierarchy_definition {
    /// A builder for [`AssetModelHierarchyDefinition`](crate::model::AssetModelHierarchyDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) child_asset_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of an asset model for this hierarchy.</p>
        pub fn child_asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of an asset model for this hierarchy.</p>
        pub fn set_child_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.child_asset_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetModelHierarchyDefinition`](crate::model::AssetModelHierarchyDefinition)
        pub fn build(self) -> crate::model::AssetModelHierarchyDefinition {
            crate::model::AssetModelHierarchyDefinition {
                name: self.name,
                child_asset_model_id: self.child_asset_model_id,
            }
        }
    }
}
impl AssetModelHierarchyDefinition {
    /// Creates a new builder-style object to manufacture [`AssetModelHierarchyDefinition`](crate::model::AssetModelHierarchyDefinition)
    pub fn builder() -> crate::model::asset_model_hierarchy_definition::Builder {
        crate::model::asset_model_hierarchy_definition::Builder::default()
    }
}

/// <p>Contains error information for asset property value entries that are associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue</a> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutAssetPropertyErrorEntry {
    /// <p>The ID of the failed entry.</p>
    pub entry_id: std::option::Option<std::string::String>,
    /// <p>The list of update property value errors.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchPutAssetPropertyError>>,
}
impl BatchPutAssetPropertyErrorEntry {
    /// <p>The ID of the failed entry.</p>
    pub fn entry_id(&self) -> std::option::Option<&str> {
        self.entry_id.as_deref()
    }
    /// <p>The list of update property value errors.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchPutAssetPropertyError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchPutAssetPropertyErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutAssetPropertyErrorEntry");
        formatter.field("entry_id", &self.entry_id);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchPutAssetPropertyErrorEntry`](crate::model::BatchPutAssetPropertyErrorEntry)
pub mod batch_put_asset_property_error_entry {
    /// A builder for [`BatchPutAssetPropertyErrorEntry`](crate::model::BatchPutAssetPropertyErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_id: std::option::Option<std::string::String>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchPutAssetPropertyError>>,
    }
    impl Builder {
        /// <p>The ID of the failed entry.</p>
        pub fn entry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_id = Some(input.into());
            self
        }
        /// <p>The ID of the failed entry.</p>
        pub fn set_entry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_id = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The list of update property value errors.</p>
        pub fn errors(mut self, input: crate::model::BatchPutAssetPropertyError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>The list of update property value errors.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutAssetPropertyError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutAssetPropertyErrorEntry`](crate::model::BatchPutAssetPropertyErrorEntry)
        pub fn build(self) -> crate::model::BatchPutAssetPropertyErrorEntry {
            crate::model::BatchPutAssetPropertyErrorEntry {
                entry_id: self.entry_id,
                errors: self.errors,
            }
        }
    }
}
impl BatchPutAssetPropertyErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchPutAssetPropertyErrorEntry`](crate::model::BatchPutAssetPropertyErrorEntry)
    pub fn builder() -> crate::model::batch_put_asset_property_error_entry::Builder {
        crate::model::batch_put_asset_property_error_entry::Builder::default()
    }
}

/// <p>Contains error information from updating a batch of asset property values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutAssetPropertyError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::BatchPutAssetPropertyValueErrorCode>,
    /// <p>The associated error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>A list of timestamps for each error, if any.</p>
    pub timestamps: std::option::Option<std::vec::Vec<crate::model::TimeInNanos>>,
}
impl BatchPutAssetPropertyError {
    /// <p>The error code.</p>
    pub fn error_code(
        &self,
    ) -> std::option::Option<&crate::model::BatchPutAssetPropertyValueErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The associated error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>A list of timestamps for each error, if any.</p>
    pub fn timestamps(&self) -> std::option::Option<&[crate::model::TimeInNanos]> {
        self.timestamps.as_deref()
    }
}
impl std::fmt::Debug for BatchPutAssetPropertyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutAssetPropertyError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("timestamps", &self.timestamps);
        formatter.finish()
    }
}
/// See [`BatchPutAssetPropertyError`](crate::model::BatchPutAssetPropertyError)
pub mod batch_put_asset_property_error {
    /// A builder for [`BatchPutAssetPropertyError`](crate::model::BatchPutAssetPropertyError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code:
            std::option::Option<crate::model::BatchPutAssetPropertyValueErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) timestamps: std::option::Option<std::vec::Vec<crate::model::TimeInNanos>>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(
            mut self,
            input: crate::model::BatchPutAssetPropertyValueErrorCode,
        ) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::BatchPutAssetPropertyValueErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The associated error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The associated error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>A list of timestamps for each error, if any.</p>
        pub fn timestamps(mut self, input: crate::model::TimeInNanos) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input);
            self.timestamps = Some(v);
            self
        }
        /// <p>A list of timestamps for each error, if any.</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimeInNanos>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutAssetPropertyError`](crate::model::BatchPutAssetPropertyError)
        pub fn build(self) -> crate::model::BatchPutAssetPropertyError {
            crate::model::BatchPutAssetPropertyError {
                error_code: self.error_code,
                error_message: self.error_message,
                timestamps: self.timestamps,
            }
        }
    }
}
impl BatchPutAssetPropertyError {
    /// Creates a new builder-style object to manufacture [`BatchPutAssetPropertyError`](crate::model::BatchPutAssetPropertyError)
    pub fn builder() -> crate::model::batch_put_asset_property_error::Builder {
        crate::model::batch_put_asset_property_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchPutAssetPropertyValueErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedException,
    #[allow(missing_docs)] // documentation missing in model
    ConflictingOperationException,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceededException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException,
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException,
    #[allow(missing_docs)] // documentation missing in model
    TimestampOutOfRangeException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchPutAssetPropertyValueErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDeniedException" => BatchPutAssetPropertyValueErrorCode::AccessDeniedException,
            "ConflictingOperationException" => {
                BatchPutAssetPropertyValueErrorCode::ConflictingOperationException
            }
            "InternalFailureException" => {
                BatchPutAssetPropertyValueErrorCode::InternalFailureException
            }
            "InvalidRequestException" => {
                BatchPutAssetPropertyValueErrorCode::InvalidRequestException
            }
            "LimitExceededException" => BatchPutAssetPropertyValueErrorCode::LimitExceededException,
            "ResourceNotFoundException" => {
                BatchPutAssetPropertyValueErrorCode::ResourceNotFoundException
            }
            "ServiceUnavailableException" => {
                BatchPutAssetPropertyValueErrorCode::ServiceUnavailableException
            }
            "ThrottlingException" => BatchPutAssetPropertyValueErrorCode::ThrottlingException,
            "TimestampOutOfRangeException" => {
                BatchPutAssetPropertyValueErrorCode::TimestampOutOfRangeException
            }
            other => BatchPutAssetPropertyValueErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchPutAssetPropertyValueErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchPutAssetPropertyValueErrorCode::from(s))
    }
}
impl BatchPutAssetPropertyValueErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchPutAssetPropertyValueErrorCode::AccessDeniedException => "AccessDeniedException",
            BatchPutAssetPropertyValueErrorCode::ConflictingOperationException => {
                "ConflictingOperationException"
            }
            BatchPutAssetPropertyValueErrorCode::InternalFailureException => {
                "InternalFailureException"
            }
            BatchPutAssetPropertyValueErrorCode::InvalidRequestException => {
                "InvalidRequestException"
            }
            BatchPutAssetPropertyValueErrorCode::LimitExceededException => "LimitExceededException",
            BatchPutAssetPropertyValueErrorCode::ResourceNotFoundException => {
                "ResourceNotFoundException"
            }
            BatchPutAssetPropertyValueErrorCode::ServiceUnavailableException => {
                "ServiceUnavailableException"
            }
            BatchPutAssetPropertyValueErrorCode::ThrottlingException => "ThrottlingException",
            BatchPutAssetPropertyValueErrorCode::TimestampOutOfRangeException => {
                "TimestampOutOfRangeException"
            }
            BatchPutAssetPropertyValueErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDeniedException",
            "ConflictingOperationException",
            "InternalFailureException",
            "InvalidRequestException",
            "LimitExceededException",
            "ResourceNotFoundException",
            "ServiceUnavailableException",
            "ThrottlingException",
            "TimestampOutOfRangeException",
        ]
    }
}
impl AsRef<str> for BatchPutAssetPropertyValueErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a list of value updates for an asset property in the list of asset entries consumed by the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue</a> API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAssetPropertyValueEntry {
    /// <p>The user specified ID for the entry. You can use this ID to identify which entries failed.</p>
    pub entry_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset to update.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property for this entry.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements. </p>
    pub property_values: std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
}
impl PutAssetPropertyValueEntry {
    /// <p>The user specified ID for the entry. You can use this ID to identify which entries failed.</p>
    pub fn entry_id(&self) -> std::option::Option<&str> {
        self.entry_id.as_deref()
    }
    /// <p>The ID of the asset to update.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property for this entry.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements. </p>
    pub fn property_values(&self) -> std::option::Option<&[crate::model::AssetPropertyValue]> {
        self.property_values.as_deref()
    }
}
impl std::fmt::Debug for PutAssetPropertyValueEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAssetPropertyValueEntry");
        formatter.field("entry_id", &self.entry_id);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("property_values", &self.property_values);
        formatter.finish()
    }
}
/// See [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
pub mod put_asset_property_value_entry {
    /// A builder for [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_id: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) property_values:
            std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
    }
    impl Builder {
        /// <p>The user specified ID for the entry. You can use this ID to identify which entries failed.</p>
        pub fn entry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_id = Some(input.into());
            self
        }
        /// <p>The user specified ID for the entry. You can use this ID to identify which entries failed.</p>
        pub fn set_entry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_id = input;
            self
        }
        /// <p>The ID of the asset to update.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset to update.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property for this entry.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property for this entry.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// Appends an item to `property_values`.
        ///
        /// To override the contents of this collection use [`set_property_values`](Self::set_property_values).
        ///
        /// <p>The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements. </p>
        pub fn property_values(mut self, input: crate::model::AssetPropertyValue) -> Self {
            let mut v = self.property_values.unwrap_or_default();
            v.push(input);
            self.property_values = Some(v);
            self
        }
        /// <p>The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements. </p>
        pub fn set_property_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
        ) -> Self {
            self.property_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
        pub fn build(self) -> crate::model::PutAssetPropertyValueEntry {
            crate::model::PutAssetPropertyValueEntry {
                entry_id: self.entry_id,
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                property_values: self.property_values,
            }
        }
    }
}
impl PutAssetPropertyValueEntry {
    /// Creates a new builder-style object to manufacture [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
    pub fn builder() -> crate::model::put_asset_property_value_entry::Builder {
        crate::model::put_asset_property_value_entry::Builder::default()
    }
}

/// <p>Contains error details for the requested associate project asset action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetErrorDetails {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::AssetErrorCode>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AssetErrorDetails {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::AssetErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for AssetErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetErrorDetails");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AssetErrorDetails`](crate::model::AssetErrorDetails)
pub mod asset_error_details {
    /// A builder for [`AssetErrorDetails`](crate::model::AssetErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::AssetErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::AssetErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::AssetErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetErrorDetails`](crate::model::AssetErrorDetails)
        pub fn build(self) -> crate::model::AssetErrorDetails {
            crate::model::AssetErrorDetails {
                asset_id: self.asset_id,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl AssetErrorDetails {
    /// Creates a new builder-style object to manufacture [`AssetErrorDetails`](crate::model::AssetErrorDetails)
    pub fn builder() -> crate::model::asset_error_details::Builder {
        crate::model::asset_error_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_FAILURE" => AssetErrorCode::InternalFailure,
            other => AssetErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetErrorCode::from(s))
    }
}
impl AssetErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetErrorCode::InternalFailure => "INTERNAL_FAILURE",
            AssetErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_FAILURE"]
    }
}
impl AsRef<str> for AssetErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
