// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT SiteWise
///
/// Client for invoking operations on AWS IoT SiteWise. Each operation on AWS IoT SiteWise is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotsitewise::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotsitewise::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotsitewise::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateAssets`](crate::client::fluent_builders::AssociateAssets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAssets::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::AssociateAssets::set_asset_id): <p>The ID of the parent asset.</p>
    ///   - [`hierarchy_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAssets::hierarchy_id) / [`set_hierarchy_id(Option<String>)`](crate::client::fluent_builders::AssociateAssets::set_hierarchy_id): <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`child_asset_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAssets::child_asset_id) / [`set_child_asset_id(Option<String>)`](crate::client::fluent_builders::AssociateAssets::set_child_asset_id): <p>The ID of the child asset to be associated.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateAssets::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateAssets::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`AssociateAssetsOutput`](crate::output::AssociateAssetsOutput)

    /// - On failure, responds with [`SdkError<AssociateAssetsError>`](crate::error::AssociateAssetsError)
    pub fn associate_assets(&self) -> fluent_builders::AssociateAssets {
        fluent_builders::AssociateAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTimeSeriesToAssetProperty`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::set_alias): <p>The alias that identifies the time series.</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::set_asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateTimeSeriesToAssetProperty::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`AssociateTimeSeriesToAssetPropertyOutput`](crate::output::AssociateTimeSeriesToAssetPropertyOutput)

    /// - On failure, responds with [`SdkError<AssociateTimeSeriesToAssetPropertyError>`](crate::error::AssociateTimeSeriesToAssetPropertyError)
    pub fn associate_time_series_to_asset_property(
        &self,
    ) -> fluent_builders::AssociateTimeSeriesToAssetProperty {
        fluent_builders::AssociateTimeSeriesToAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateProjectAssets`](crate::client::fluent_builders::BatchAssociateProjectAssets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::set_project_id): <p>The ID of the project to which to associate the assets.</p>
    ///   - [`asset_ids(Vec<String>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::asset_ids) / [`set_asset_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::set_asset_ids): <p>The IDs of the assets to be associated to the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::BatchAssociateProjectAssets::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`BatchAssociateProjectAssetsOutput`](crate::output::BatchAssociateProjectAssetsOutput) with field(s):
    ///   - [`errors(Option<Vec<AssetErrorDetails>>)`](crate::output::BatchAssociateProjectAssetsOutput::errors): <p>A list of associated error information, if any.</p>
    /// - On failure, responds with [`SdkError<BatchAssociateProjectAssetsError>`](crate::error::BatchAssociateProjectAssetsError)
    pub fn batch_associate_project_assets(&self) -> fluent_builders::BatchAssociateProjectAssets {
        fluent_builders::BatchAssociateProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateProjectAssets`](crate::client::fluent_builders::BatchDisassociateProjectAssets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::set_project_id): <p>The ID of the project from which to disassociate the assets.</p>
    ///   - [`asset_ids(Vec<String>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::asset_ids) / [`set_asset_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::set_asset_ids): <p>The IDs of the assets to be disassociated from the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::BatchDisassociateProjectAssets::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`BatchDisassociateProjectAssetsOutput`](crate::output::BatchDisassociateProjectAssetsOutput) with field(s):
    ///   - [`errors(Option<Vec<AssetErrorDetails>>)`](crate::output::BatchDisassociateProjectAssetsOutput::errors): <p>A list of associated error information, if any.</p>
    /// - On failure, responds with [`SdkError<BatchDisassociateProjectAssetsError>`](crate::error::BatchDisassociateProjectAssetsError)
    pub fn batch_disassociate_project_assets(
        &self,
    ) -> fluent_builders::BatchDisassociateProjectAssets {
        fluent_builders::BatchDisassociateProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchPutAssetPropertyValue`](crate::client::fluent_builders::BatchPutAssetPropertyValue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<PutAssetPropertyValueEntry>)`](crate::client::fluent_builders::BatchPutAssetPropertyValue::entries) / [`set_entries(Option<Vec<PutAssetPropertyValueEntry>>)`](crate::client::fluent_builders::BatchPutAssetPropertyValue::set_entries): <p>The list of asset property value entries for the batch put request. You can specify up to 10 entries per request.</p>
    /// - On success, responds with [`BatchPutAssetPropertyValueOutput`](crate::output::BatchPutAssetPropertyValueOutput) with field(s):
    ///   - [`error_entries(Option<Vec<BatchPutAssetPropertyErrorEntry>>)`](crate::output::BatchPutAssetPropertyValueOutput::error_entries): <p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>
    /// - On failure, responds with [`SdkError<BatchPutAssetPropertyValueError>`](crate::error::BatchPutAssetPropertyValueError)
    pub fn batch_put_asset_property_value(&self) -> fluent_builders::BatchPutAssetPropertyValue {
        fluent_builders::BatchPutAssetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccessPolicy`](crate::client::fluent_builders::CreateAccessPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_policy_identity(Identity)`](crate::client::fluent_builders::CreateAccessPolicy::access_policy_identity) / [`set_access_policy_identity(Option<Identity>)`](crate::client::fluent_builders::CreateAccessPolicy::set_access_policy_identity): <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    ///   - [`access_policy_resource(Resource)`](crate::client::fluent_builders::CreateAccessPolicy::access_policy_resource) / [`set_access_policy_resource(Option<Resource>)`](crate::client::fluent_builders::CreateAccessPolicy::set_access_policy_resource): <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    ///   - [`access_policy_permission(Permission)`](crate::client::fluent_builders::CreateAccessPolicy::access_policy_permission) / [`set_access_policy_permission(Option<Permission>)`](crate::client::fluent_builders::CreateAccessPolicy::set_access_policy_permission): <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAccessPolicy::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAccessPolicy::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAccessPolicy::set_tags): <p>A list of key-value pairs that contain metadata for the access policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateAccessPolicyOutput`](crate::output::CreateAccessPolicyOutput) with field(s):
    ///   - [`access_policy_id(Option<String>)`](crate::output::CreateAccessPolicyOutput::access_policy_id): <p>The ID of the access policy.</p>
    ///   - [`access_policy_arn(Option<String>)`](crate::output::CreateAccessPolicyOutput::access_policy_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    /// - On failure, responds with [`SdkError<CreateAccessPolicyError>`](crate::error::CreateAccessPolicyError)
    pub fn create_access_policy(&self) -> fluent_builders::CreateAccessPolicy {
        fluent_builders::CreateAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAsset`](crate::client::fluent_builders::CreateAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_name(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::asset_name) / [`set_asset_name(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_asset_name): <p>A unique, friendly name for the asset.</p>
    ///   - [`asset_model_id(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::asset_model_id) / [`set_asset_model_id(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_asset_model_id): <p>The ID of the asset model from which to create the asset.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAsset::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAsset::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAsset::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAsset::set_tags): <p>A list of key-value pairs that contain metadata for the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateAssetOutput`](crate::output::CreateAssetOutput) with field(s):
    ///   - [`asset_id(Option<String>)`](crate::output::CreateAssetOutput::asset_id): <p>The ID of the asset. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>
    ///   - [`asset_arn(Option<String>)`](crate::output::CreateAssetOutput::asset_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    ///   - [`asset_status(Option<AssetStatus>)`](crate::output::CreateAssetOutput::asset_status): <p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<CreateAssetError>`](crate::error::CreateAssetError)
    pub fn create_asset(&self) -> fluent_builders::CreateAsset {
        fluent_builders::CreateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssetModel`](crate::client::fluent_builders::CreateAssetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_model_name(impl Into<String>)`](crate::client::fluent_builders::CreateAssetModel::asset_model_name) / [`set_asset_model_name(Option<String>)`](crate::client::fluent_builders::CreateAssetModel::set_asset_model_name): <p>A unique, friendly name for the asset model.</p>
    ///   - [`asset_model_description(impl Into<String>)`](crate::client::fluent_builders::CreateAssetModel::asset_model_description) / [`set_asset_model_description(Option<String>)`](crate::client::fluent_builders::CreateAssetModel::set_asset_model_description): <p>A description for the asset model.</p>
    ///   - [`asset_model_properties(Vec<AssetModelPropertyDefinition>)`](crate::client::fluent_builders::CreateAssetModel::asset_model_properties) / [`set_asset_model_properties(Option<Vec<AssetModelPropertyDefinition>>)`](crate::client::fluent_builders::CreateAssetModel::set_asset_model_properties): <p>The property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`asset_model_hierarchies(Vec<AssetModelHierarchyDefinition>)`](crate::client::fluent_builders::CreateAssetModel::asset_model_hierarchies) / [`set_asset_model_hierarchies(Option<Vec<AssetModelHierarchyDefinition>>)`](crate::client::fluent_builders::CreateAssetModel::set_asset_model_hierarchies): <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`asset_model_composite_models(Vec<AssetModelCompositeModelDefinition>)`](crate::client::fluent_builders::CreateAssetModel::asset_model_composite_models) / [`set_asset_model_composite_models(Option<Vec<AssetModelCompositeModelDefinition>>)`](crate::client::fluent_builders::CreateAssetModel::set_asset_model_composite_models): <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAssetModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAssetModel::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAssetModel::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAssetModel::set_tags): <p>A list of key-value pairs that contain metadata for the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateAssetModelOutput`](crate::output::CreateAssetModelOutput) with field(s):
    ///   - [`asset_model_id(Option<String>)`](crate::output::CreateAssetModelOutput::asset_model_id): <p>The ID of the asset model. You can use this ID when you call other IoT SiteWise APIs.</p>
    ///   - [`asset_model_arn(Option<String>)`](crate::output::CreateAssetModelOutput::asset_model_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    ///   - [`asset_model_status(Option<AssetModelStatus>)`](crate::output::CreateAssetModelOutput::asset_model_status): <p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<CreateAssetModelError>`](crate::error::CreateAssetModelError)
    pub fn create_asset_model(&self) -> fluent_builders::CreateAssetModel {
        fluent_builders::CreateAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDashboard`](crate::client::fluent_builders::CreateDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_project_id): <p>The ID of the project in which to create the dashboard.</p>
    ///   - [`dashboard_name(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::dashboard_name) / [`set_dashboard_name(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_dashboard_name): <p>A friendly name for the dashboard.</p>
    ///   - [`dashboard_description(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::dashboard_description) / [`set_dashboard_description(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_dashboard_description): <p>A description for the dashboard.</p>
    ///   - [`dashboard_definition(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::dashboard_definition) / [`set_dashboard_definition(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_dashboard_definition): <p>The dashboard definition specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDashboard::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDashboard::set_tags): <p>A list of key-value pairs that contain metadata for the dashboard. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateDashboardOutput`](crate::output::CreateDashboardOutput) with field(s):
    ///   - [`dashboard_id(Option<String>)`](crate::output::CreateDashboardOutput::dashboard_id): <p>The ID of the dashboard.</p>
    ///   - [`dashboard_arn(Option<String>)`](crate::output::CreateDashboardOutput::dashboard_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    /// - On failure, responds with [`SdkError<CreateDashboardError>`](crate::error::CreateDashboardError)
    pub fn create_dashboard(&self) -> fluent_builders::CreateDashboard {
        fluent_builders::CreateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGateway`](crate::client::fluent_builders::CreateGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_name(impl Into<String>)`](crate::client::fluent_builders::CreateGateway::gateway_name) / [`set_gateway_name(Option<String>)`](crate::client::fluent_builders::CreateGateway::set_gateway_name): <p>A unique, friendly name for the gateway.</p>
    ///   - [`gateway_platform(GatewayPlatform)`](crate::client::fluent_builders::CreateGateway::gateway_platform) / [`set_gateway_platform(Option<GatewayPlatform>)`](crate::client::fluent_builders::CreateGateway::set_gateway_platform): <p>The gateway's platform. You can only specify one platform in a gateway.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGateway::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGateway::set_tags): <p>A list of key-value pairs that contain metadata for the gateway. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateGatewayOutput`](crate::output::CreateGatewayOutput) with field(s):
    ///   - [`gateway_id(Option<String>)`](crate::output::CreateGatewayOutput::gateway_id): <p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise APIs.</p>
    ///   - [`gateway_arn(Option<String>)`](crate::output::CreateGatewayOutput::gateway_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    /// - On failure, responds with [`SdkError<CreateGatewayError>`](crate::error::CreateGatewayError)
    pub fn create_gateway(&self) -> fluent_builders::CreateGateway {
        fluent_builders::CreateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePortal`](crate::client::fluent_builders::CreatePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_name(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::portal_name) / [`set_portal_name(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_portal_name): <p>A friendly name for the portal.</p>
    ///   - [`portal_description(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::portal_description) / [`set_portal_description(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_portal_description): <p>A description for the portal.</p>
    ///   - [`portal_contact_email(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::portal_contact_email) / [`set_portal_contact_email(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_portal_contact_email): <p>The Amazon Web Services administrator's contact email address.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`portal_logo_image_file(ImageFile)`](crate::client::fluent_builders::CreatePortal::portal_logo_image_file) / [`set_portal_logo_image_file(Option<ImageFile>)`](crate::client::fluent_builders::CreatePortal::set_portal_logo_image_file): <p>A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_role_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePortal::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePortal::set_tags): <p>A list of key-value pairs that contain metadata for the portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`portal_auth_mode(AuthMode)`](crate::client::fluent_builders::CreatePortal::portal_auth_mode) / [`set_portal_auth_mode(Option<AuthMode>)`](crate::client::fluent_builders::CreatePortal::set_portal_auth_mode): <p>The service to use to authenticate users to the portal. Choose from the following options:</p>  <ul>   <li> <p> <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than the China Regions.</p> </li>   <li> <p> <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user permissions.</p> </li>  </ul>  <p>You can't change this value after you create a portal.</p>  <p>Default: <code>SSO</code> </p>
    ///   - [`notification_sender_email(impl Into<String>)`](crate::client::fluent_builders::CreatePortal::notification_sender_email) / [`set_notification_sender_email(Option<String>)`](crate::client::fluent_builders::CreatePortal::set_notification_sender_email): <p>The email address that sends alarm notifications.</p> <important>   <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a>.</p>  </important>
    ///   - [`alarms(Alarms)`](crate::client::fluent_builders::CreatePortal::alarms) / [`set_alarms(Option<Alarms>)`](crate::client::fluent_builders::CreatePortal::set_alarms): <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    /// - On success, responds with [`CreatePortalOutput`](crate::output::CreatePortalOutput) with field(s):
    ///   - [`portal_id(Option<String>)`](crate::output::CreatePortalOutput::portal_id): <p>The ID of the created portal.</p>
    ///   - [`portal_arn(Option<String>)`](crate::output::CreatePortalOutput::portal_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    ///   - [`portal_start_url(Option<String>)`](crate::output::CreatePortalOutput::portal_start_url): <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    ///   - [`portal_status(Option<PortalStatus>)`](crate::output::CreatePortalOutput::portal_status): <p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>
    ///   - [`sso_application_id(Option<String>)`](crate::output::CreatePortalOutput::sso_application_id): <p>The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.</p>
    /// - On failure, responds with [`SdkError<CreatePortalError>`](crate::error::CreatePortalError)
    pub fn create_portal(&self) -> fluent_builders::CreatePortal {
        fluent_builders::CreatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_id(impl Into<String>)`](crate::client::fluent_builders::CreateProject::portal_id) / [`set_portal_id(Option<String>)`](crate::client::fluent_builders::CreateProject::set_portal_id): <p>The ID of the portal in which to create the project.</p>
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_project_name): <p>A friendly name for the project.</p>
    ///   - [`project_description(impl Into<String>)`](crate::client::fluent_builders::CreateProject::project_description) / [`set_project_description(Option<String>)`](crate::client::fluent_builders::CreateProject::set_project_description): <p>A description for the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateProject::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateProject::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProject::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProject::set_tags): <p>A list of key-value pairs that contain metadata for the project. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`project_id(Option<String>)`](crate::output::CreateProjectOutput::project_id): <p>The ID of the project.</p>
    ///   - [`project_arn(Option<String>)`](crate::output::CreateProjectOutput::project_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPolicy`](crate::client::fluent_builders::DeleteAccessPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_policy_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPolicy::access_policy_id) / [`set_access_policy_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPolicy::set_access_policy_id): <p>The ID of the access policy to be deleted.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAccessPolicy::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteAccessPolicyOutput`](crate::output::DeleteAccessPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPolicyError>`](crate::error::DeleteAccessPolicyError)
    pub fn delete_access_policy(&self) -> fluent_builders::DeleteAccessPolicy {
        fluent_builders::DeleteAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAsset`](crate::client::fluent_builders::DeleteAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_asset_id): <p>The ID of the asset to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAsset::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAsset::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteAssetOutput`](crate::output::DeleteAssetOutput) with field(s):
    ///   - [`asset_status(Option<AssetStatus>)`](crate::output::DeleteAssetOutput::asset_status): <p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<DeleteAssetError>`](crate::error::DeleteAssetError)
    pub fn delete_asset(&self) -> fluent_builders::DeleteAsset {
        fluent_builders::DeleteAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssetModel`](crate::client::fluent_builders::DeleteAssetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssetModel::asset_model_id) / [`set_asset_model_id(Option<String>)`](crate::client::fluent_builders::DeleteAssetModel::set_asset_model_id): <p>The ID of the asset model to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAssetModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAssetModel::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteAssetModelOutput`](crate::output::DeleteAssetModelOutput) with field(s):
    ///   - [`asset_model_status(Option<AssetModelStatus>)`](crate::output::DeleteAssetModelOutput::asset_model_status): <p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<DeleteAssetModelError>`](crate::error::DeleteAssetModelError)
    pub fn delete_asset_model(&self) -> fluent_builders::DeleteAssetModel {
        fluent_builders::DeleteAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDashboard`](crate::client::fluent_builders::DeleteDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::DeleteDashboard::set_dashboard_id): <p>The ID of the dashboard to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteDashboard::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteDashboard::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)

    /// - On failure, responds with [`SdkError<DeleteDashboardError>`](crate::error::DeleteDashboardError)
    pub fn delete_dashboard(&self) -> fluent_builders::DeleteDashboard {
        fluent_builders::DeleteDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGateway`](crate::client::fluent_builders::DeleteGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGateway::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteGateway::set_gateway_id): <p>The ID of the gateway to delete.</p>
    /// - On success, responds with [`DeleteGatewayOutput`](crate::output::DeleteGatewayOutput)

    /// - On failure, responds with [`SdkError<DeleteGatewayError>`](crate::error::DeleteGatewayError)
    pub fn delete_gateway(&self) -> fluent_builders::DeleteGateway {
        fluent_builders::DeleteGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePortal`](crate::client::fluent_builders::DeletePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_id(impl Into<String>)`](crate::client::fluent_builders::DeletePortal::portal_id) / [`set_portal_id(Option<String>)`](crate::client::fluent_builders::DeletePortal::set_portal_id): <p>The ID of the portal to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeletePortal::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeletePortal::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeletePortalOutput`](crate::output::DeletePortalOutput) with field(s):
    ///   - [`portal_status(Option<PortalStatus>)`](crate::output::DeletePortalOutput::portal_status): <p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<DeletePortalError>`](crate::error::DeletePortalError)
    pub fn delete_portal(&self) -> fluent_builders::DeletePortal {
        fluent_builders::DeletePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_project_id): <p>The ID of the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)

    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTimeSeries`](crate::client::fluent_builders::DeleteTimeSeries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::DeleteTimeSeries::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::DeleteTimeSeries::set_alias): <p>The alias that identifies the time series.</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTimeSeries::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DeleteTimeSeries::set_asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTimeSeries::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::DeleteTimeSeries::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteTimeSeries::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteTimeSeries::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DeleteTimeSeriesOutput`](crate::output::DeleteTimeSeriesOutput)

    /// - On failure, responds with [`SdkError<DeleteTimeSeriesError>`](crate::error::DeleteTimeSeriesError)
    pub fn delete_time_series(&self) -> fluent_builders::DeleteTimeSeries {
        fluent_builders::DeleteTimeSeries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccessPolicy`](crate::client::fluent_builders::DescribeAccessPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_policy_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccessPolicy::access_policy_id) / [`set_access_policy_id(Option<String>)`](crate::client::fluent_builders::DescribeAccessPolicy::set_access_policy_id): <p>The ID of the access policy.</p>
    /// - On success, responds with [`DescribeAccessPolicyOutput`](crate::output::DescribeAccessPolicyOutput) with field(s):
    ///   - [`access_policy_id(Option<String>)`](crate::output::DescribeAccessPolicyOutput::access_policy_id): <p>The ID of the access policy.</p>
    ///   - [`access_policy_arn(Option<String>)`](crate::output::DescribeAccessPolicyOutput::access_policy_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>
    ///   - [`access_policy_identity(Option<Identity>)`](crate::output::DescribeAccessPolicyOutput::access_policy_identity): <p>The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy applies.</p>
    ///   - [`access_policy_resource(Option<Resource>)`](crate::output::DescribeAccessPolicyOutput::access_policy_resource): <p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>
    ///   - [`access_policy_permission(Option<Permission>)`](crate::output::DescribeAccessPolicyOutput::access_policy_permission): <p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    ///   - [`access_policy_creation_date(Option<DateTime>)`](crate::output::DescribeAccessPolicyOutput::access_policy_creation_date): <p>The date the access policy was created, in Unix epoch time.</p>
    ///   - [`access_policy_last_update_date(Option<DateTime>)`](crate::output::DescribeAccessPolicyOutput::access_policy_last_update_date): <p>The date the access policy was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeAccessPolicyError>`](crate::error::DescribeAccessPolicyError)
    pub fn describe_access_policy(&self) -> fluent_builders::DescribeAccessPolicy {
        fluent_builders::DescribeAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAsset`](crate::client::fluent_builders::DescribeAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DescribeAsset::set_asset_id): <p>The ID of the asset.</p>
    /// - On success, responds with [`DescribeAssetOutput`](crate::output::DescribeAssetOutput) with field(s):
    ///   - [`asset_id(Option<String>)`](crate::output::DescribeAssetOutput::asset_id): <p>The ID of the asset.</p>
    ///   - [`asset_arn(Option<String>)`](crate::output::DescribeAssetOutput::asset_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>
    ///   - [`asset_name(Option<String>)`](crate::output::DescribeAssetOutput::asset_name): <p>The name of the asset.</p>
    ///   - [`asset_model_id(Option<String>)`](crate::output::DescribeAssetOutput::asset_model_id): <p>The ID of the asset model that was used to create the asset.</p>
    ///   - [`asset_properties(Option<Vec<AssetProperty>>)`](crate::output::DescribeAssetOutput::asset_properties): <p>The list of asset properties for the asset.</p>  <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>
    ///   - [`asset_hierarchies(Option<Vec<AssetHierarchy>>)`](crate::output::DescribeAssetOutput::asset_hierarchies): <p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>
    ///   - [`asset_composite_models(Option<Vec<AssetCompositeModel>>)`](crate::output::DescribeAssetOutput::asset_composite_models): <p>The composite models for the asset.</p>
    ///   - [`asset_creation_date(Option<DateTime>)`](crate::output::DescribeAssetOutput::asset_creation_date): <p>The date the asset was created, in Unix epoch time.</p>
    ///   - [`asset_last_update_date(Option<DateTime>)`](crate::output::DescribeAssetOutput::asset_last_update_date): <p>The date the asset was last updated, in Unix epoch time.</p>
    ///   - [`asset_status(Option<AssetStatus>)`](crate::output::DescribeAssetOutput::asset_status): <p>The current status of the asset, which contains a state and any error message.</p>
    /// - On failure, responds with [`SdkError<DescribeAssetError>`](crate::error::DescribeAssetError)
    pub fn describe_asset(&self) -> fluent_builders::DescribeAsset {
        fluent_builders::DescribeAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssetModel`](crate::client::fluent_builders::DescribeAssetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_model_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssetModel::asset_model_id) / [`set_asset_model_id(Option<String>)`](crate::client::fluent_builders::DescribeAssetModel::set_asset_model_id): <p>The ID of the asset model.</p>
    /// - On success, responds with [`DescribeAssetModelOutput`](crate::output::DescribeAssetModelOutput) with field(s):
    ///   - [`asset_model_id(Option<String>)`](crate::output::DescribeAssetModelOutput::asset_model_id): <p>The ID of the asset model.</p>
    ///   - [`asset_model_arn(Option<String>)`](crate::output::DescribeAssetModelOutput::asset_model_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>
    ///   - [`asset_model_name(Option<String>)`](crate::output::DescribeAssetModelOutput::asset_model_name): <p>The name of the asset model.</p>
    ///   - [`asset_model_description(Option<String>)`](crate::output::DescribeAssetModelOutput::asset_model_description): <p>The asset model's description.</p>
    ///   - [`asset_model_properties(Option<Vec<AssetModelProperty>>)`](crate::output::DescribeAssetModelOutput::asset_model_properties): <p>The list of asset properties for the asset model.</p>  <p>This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>
    ///   - [`asset_model_hierarchies(Option<Vec<AssetModelHierarchy>>)`](crate::output::DescribeAssetModelOutput::asset_model_hierarchies): <p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>
    ///   - [`asset_model_composite_models(Option<Vec<AssetModelCompositeModel>>)`](crate::output::DescribeAssetModelOutput::asset_model_composite_models): <p>The list of composite asset models for the asset model.</p>
    ///   - [`asset_model_creation_date(Option<DateTime>)`](crate::output::DescribeAssetModelOutput::asset_model_creation_date): <p>The date the asset model was created, in Unix epoch time.</p>
    ///   - [`asset_model_last_update_date(Option<DateTime>)`](crate::output::DescribeAssetModelOutput::asset_model_last_update_date): <p>The date the asset model was last updated, in Unix epoch time.</p>
    ///   - [`asset_model_status(Option<AssetModelStatus>)`](crate::output::DescribeAssetModelOutput::asset_model_status): <p>The current status of the asset model, which contains a state and any error message.</p>
    /// - On failure, responds with [`SdkError<DescribeAssetModelError>`](crate::error::DescribeAssetModelError)
    pub fn describe_asset_model(&self) -> fluent_builders::DescribeAssetModel {
        fluent_builders::DescribeAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssetProperty`](crate::client::fluent_builders::DescribeAssetProperty) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssetProperty::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DescribeAssetProperty::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssetProperty::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::DescribeAssetProperty::set_property_id): <p>The ID of the asset property.</p>
    /// - On success, responds with [`DescribeAssetPropertyOutput`](crate::output::DescribeAssetPropertyOutput) with field(s):
    ///   - [`asset_id(Option<String>)`](crate::output::DescribeAssetPropertyOutput::asset_id): <p>The ID of the asset.</p>
    ///   - [`asset_name(Option<String>)`](crate::output::DescribeAssetPropertyOutput::asset_name): <p>The name of the asset.</p>
    ///   - [`asset_model_id(Option<String>)`](crate::output::DescribeAssetPropertyOutput::asset_model_id): <p>The ID of the asset model.</p>
    ///   - [`asset_property(Option<Property>)`](crate::output::DescribeAssetPropertyOutput::asset_property): <p>The asset property's definition, alias, and notification state.</p>  <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>
    ///   - [`composite_model(Option<CompositeModelProperty>)`](crate::output::DescribeAssetPropertyOutput::composite_model): <p>The composite asset model that declares this asset property, if this asset property exists in a composite model.</p>
    /// - On failure, responds with [`SdkError<DescribeAssetPropertyError>`](crate::error::DescribeAssetPropertyError)
    pub fn describe_asset_property(&self) -> fluent_builders::DescribeAssetProperty {
        fluent_builders::DescribeAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDashboard`](crate::client::fluent_builders::DescribeDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::DescribeDashboard::set_dashboard_id): <p>The ID of the dashboard.</p>
    /// - On success, responds with [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput) with field(s):
    ///   - [`dashboard_id(Option<String>)`](crate::output::DescribeDashboardOutput::dashboard_id): <p>The ID of the dashboard.</p>
    ///   - [`dashboard_arn(Option<String>)`](crate::output::DescribeDashboardOutput::dashboard_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>
    ///   - [`dashboard_name(Option<String>)`](crate::output::DescribeDashboardOutput::dashboard_name): <p>The name of the dashboard.</p>
    ///   - [`project_id(Option<String>)`](crate::output::DescribeDashboardOutput::project_id): <p>The ID of the project that the dashboard is in.</p>
    ///   - [`dashboard_description(Option<String>)`](crate::output::DescribeDashboardOutput::dashboard_description): <p>The dashboard's description.</p>
    ///   - [`dashboard_definition(Option<String>)`](crate::output::DescribeDashboardOutput::dashboard_definition): <p>The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`dashboard_creation_date(Option<DateTime>)`](crate::output::DescribeDashboardOutput::dashboard_creation_date): <p>The date the dashboard was created, in Unix epoch time.</p>
    ///   - [`dashboard_last_update_date(Option<DateTime>)`](crate::output::DescribeDashboardOutput::dashboard_last_update_date): <p>The date the dashboard was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeDashboardError>`](crate::error::DescribeDashboardError)
    pub fn describe_dashboard(&self) -> fluent_builders::DescribeDashboard {
        fluent_builders::DescribeDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDefaultEncryptionConfiguration`](crate::client::fluent_builders::DescribeDefaultEncryptionConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeDefaultEncryptionConfiguration::send) it.

    /// - On success, responds with [`DescribeDefaultEncryptionConfigurationOutput`](crate::output::DescribeDefaultEncryptionConfigurationOutput) with field(s):
    ///   - [`encryption_type(Option<EncryptionType>)`](crate::output::DescribeDefaultEncryptionConfigurationOutput::encryption_type): <p>The type of encryption used for the encryption configuration.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::DescribeDefaultEncryptionConfigurationOutput::kms_key_arn): <p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    ///   - [`configuration_status(Option<ConfigurationStatus>)`](crate::output::DescribeDefaultEncryptionConfigurationOutput::configuration_status): <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there's an error, it also contains the <code>ErrorDetails</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDefaultEncryptionConfigurationError>`](crate::error::DescribeDefaultEncryptionConfigurationError)
    pub fn describe_default_encryption_configuration(
        &self,
    ) -> fluent_builders::DescribeDefaultEncryptionConfiguration {
        fluent_builders::DescribeDefaultEncryptionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGateway`](crate::client::fluent_builders::DescribeGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGateway::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeGateway::set_gateway_id): <p>The ID of the gateway device.</p>
    /// - On success, responds with [`DescribeGatewayOutput`](crate::output::DescribeGatewayOutput) with field(s):
    ///   - [`gateway_id(Option<String>)`](crate::output::DescribeGatewayOutput::gateway_id): <p>The ID of the gateway device.</p>
    ///   - [`gateway_name(Option<String>)`](crate::output::DescribeGatewayOutput::gateway_name): <p>The name of the gateway.</p>
    ///   - [`gateway_arn(Option<String>)`](crate::output::DescribeGatewayOutput::gateway_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>
    ///   - [`gateway_platform(Option<GatewayPlatform>)`](crate::output::DescribeGatewayOutput::gateway_platform): <p>The gateway's platform.</p>
    ///   - [`gateway_capability_summaries(Option<Vec<GatewayCapabilitySummary>>)`](crate::output::DescribeGatewayOutput::gateway_capability_summaries): <p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeGatewayOutput::creation_date): <p>The date the gateway was created, in Unix epoch time.</p>
    ///   - [`last_update_date(Option<DateTime>)`](crate::output::DescribeGatewayOutput::last_update_date): <p>The date the gateway was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeGatewayError>`](crate::error::DescribeGatewayError)
    pub fn describe_gateway(&self) -> fluent_builders::DescribeGateway {
        fluent_builders::DescribeGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGatewayCapabilityConfiguration`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration::set_gateway_id): <p>The ID of the gateway that defines the capability configuration.</p>
    ///   - [`capability_namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration::capability_namespace) / [`set_capability_namespace(Option<String>)`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration::set_capability_namespace): <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
    /// - On success, responds with [`DescribeGatewayCapabilityConfigurationOutput`](crate::output::DescribeGatewayCapabilityConfigurationOutput) with field(s):
    ///   - [`gateway_id(Option<String>)`](crate::output::DescribeGatewayCapabilityConfigurationOutput::gateway_id): <p>The ID of the gateway that defines the capability configuration.</p>
    ///   - [`capability_namespace(Option<String>)`](crate::output::DescribeGatewayCapabilityConfigurationOutput::capability_namespace): <p>The namespace of the gateway capability.</p>
    ///   - [`capability_configuration(Option<String>)`](crate::output::DescribeGatewayCapabilityConfigurationOutput::capability_configuration): <p>The JSON document that defines the gateway capability's configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`capability_sync_status(Option<CapabilitySyncStatus>)`](crate::output::DescribeGatewayCapabilityConfigurationOutput::capability_sync_status): <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>  <ul>   <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>   <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>   <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeGatewayCapabilityConfigurationError>`](crate::error::DescribeGatewayCapabilityConfigurationError)
    pub fn describe_gateway_capability_configuration(
        &self,
    ) -> fluent_builders::DescribeGatewayCapabilityConfiguration {
        fluent_builders::DescribeGatewayCapabilityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeLoggingOptions::send) it.

    /// - On success, responds with [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput) with field(s):
    ///   - [`logging_options(Option<LoggingOptions>)`](crate::output::DescribeLoggingOptionsOutput::logging_options): <p>The current logging options.</p>
    /// - On failure, responds with [`SdkError<DescribeLoggingOptionsError>`](crate::error::DescribeLoggingOptionsError)
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePortal`](crate::client::fluent_builders::DescribePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_id(impl Into<String>)`](crate::client::fluent_builders::DescribePortal::portal_id) / [`set_portal_id(Option<String>)`](crate::client::fluent_builders::DescribePortal::set_portal_id): <p>The ID of the portal.</p>
    /// - On success, responds with [`DescribePortalOutput`](crate::output::DescribePortalOutput) with field(s):
    ///   - [`portal_id(Option<String>)`](crate::output::DescribePortalOutput::portal_id): <p>The ID of the portal.</p>
    ///   - [`portal_arn(Option<String>)`](crate::output::DescribePortalOutput::portal_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>
    ///   - [`portal_name(Option<String>)`](crate::output::DescribePortalOutput::portal_name): <p>The name of the portal.</p>
    ///   - [`portal_description(Option<String>)`](crate::output::DescribePortalOutput::portal_description): <p>The portal's description.</p>
    ///   - [`portal_client_id(Option<String>)`](crate::output::DescribePortalOutput::portal_client_id): <p>The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes <code>portalClientId</code> for only portals that use Amazon Web Services SSO to authenticate users.</p>
    ///   - [`portal_start_url(Option<String>)`](crate::output::DescribePortalOutput::portal_start_url): <p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>
    ///   - [`portal_contact_email(Option<String>)`](crate::output::DescribePortalOutput::portal_contact_email): <p>The Amazon Web Services administrator's contact email address.</p>
    ///   - [`portal_status(Option<PortalStatus>)`](crate::output::DescribePortalOutput::portal_status): <p>The current status of the portal, which contains a state and any error message.</p>
    ///   - [`portal_creation_date(Option<DateTime>)`](crate::output::DescribePortalOutput::portal_creation_date): <p>The date the portal was created, in Unix epoch time.</p>
    ///   - [`portal_last_update_date(Option<DateTime>)`](crate::output::DescribePortalOutput::portal_last_update_date): <p>The date the portal was last updated, in Unix epoch time.</p>
    ///   - [`portal_logo_image_location(Option<ImageLocation>)`](crate::output::DescribePortalOutput::portal_logo_image_location): <p>The portal's logo image, which is available at a URL.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribePortalOutput::role_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`portal_auth_mode(Option<AuthMode>)`](crate::output::DescribePortalOutput::portal_auth_mode): <p>The service to use to authenticate users to the portal.</p>
    ///   - [`notification_sender_email(Option<String>)`](crate::output::DescribePortalOutput::notification_sender_email): <p>The email address that sends alarm notifications.</p>
    ///   - [`alarms(Option<Alarms>)`](crate::output::DescribePortalOutput::alarms): <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>
    /// - On failure, responds with [`SdkError<DescribePortalError>`](crate::error::DescribePortalError)
    pub fn describe_portal(&self) -> fluent_builders::DescribePortal {
        fluent_builders::DescribePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProject`](crate::client::fluent_builders::DescribeProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProject::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::DescribeProject::set_project_id): <p>The ID of the project.</p>
    /// - On success, responds with [`DescribeProjectOutput`](crate::output::DescribeProjectOutput) with field(s):
    ///   - [`project_id(Option<String>)`](crate::output::DescribeProjectOutput::project_id): <p>The ID of the project.</p>
    ///   - [`project_arn(Option<String>)`](crate::output::DescribeProjectOutput::project_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p>  <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>
    ///   - [`project_name(Option<String>)`](crate::output::DescribeProjectOutput::project_name): <p>The name of the project.</p>
    ///   - [`portal_id(Option<String>)`](crate::output::DescribeProjectOutput::portal_id): <p>The ID of the portal that the project is in.</p>
    ///   - [`project_description(Option<String>)`](crate::output::DescribeProjectOutput::project_description): <p>The project's description.</p>
    ///   - [`project_creation_date(Option<DateTime>)`](crate::output::DescribeProjectOutput::project_creation_date): <p>The date the project was created, in Unix epoch time.</p>
    ///   - [`project_last_update_date(Option<DateTime>)`](crate::output::DescribeProjectOutput::project_last_update_date): <p>The date the project was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeProjectError>`](crate::error::DescribeProjectError)
    pub fn describe_project(&self) -> fluent_builders::DescribeProject {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStorageConfiguration`](crate::client::fluent_builders::DescribeStorageConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeStorageConfiguration::send) it.

    /// - On success, responds with [`DescribeStorageConfigurationOutput`](crate::output::DescribeStorageConfigurationOutput) with field(s):
    ///   - [`storage_type(Option<StorageType>)`](crate::output::DescribeStorageConfigurationOutput::storage_type): <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>  <ul>   <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>   <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>  </ul>
    ///   - [`multi_layer_storage(Option<MultiLayerStorage>)`](crate::output::DescribeStorageConfigurationOutput::multi_layer_storage): <p>Contains information about the storage destination.</p>
    ///   - [`disassociated_data_storage(Option<DisassociatedDataStorageState>)`](crate::output::DescribeStorageConfigurationOutput::disassociated_data_storage): <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>  <ul>   <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>     <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>    </important> </li>   <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`retention_period(Option<RetentionPeriod>)`](crate::output::DescribeStorageConfigurationOutput::retention_period): <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    ///   - [`configuration_status(Option<ConfigurationStatus>)`](crate::output::DescribeStorageConfigurationOutput::configuration_status): <p>Contains current status information for the configuration.</p>
    ///   - [`last_update_date(Option<DateTime>)`](crate::output::DescribeStorageConfigurationOutput::last_update_date): <p>The date the storage configuration was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeStorageConfigurationError>`](crate::error::DescribeStorageConfigurationError)
    pub fn describe_storage_configuration(&self) -> fluent_builders::DescribeStorageConfiguration {
        fluent_builders::DescribeStorageConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTimeSeries`](crate::client::fluent_builders::DescribeTimeSeries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::DescribeTimeSeries::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::DescribeTimeSeries::set_alias): <p>The alias that identifies the time series.</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTimeSeries::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DescribeTimeSeries::set_asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTimeSeries::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::DescribeTimeSeries::set_property_id): <p>The ID of the asset property.</p>
    /// - On success, responds with [`DescribeTimeSeriesOutput`](crate::output::DescribeTimeSeriesOutput) with field(s):
    ///   - [`asset_id(Option<String>)`](crate::output::DescribeTimeSeriesOutput::asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`property_id(Option<String>)`](crate::output::DescribeTimeSeriesOutput::property_id): <p>The ID of the asset property.</p>
    ///   - [`alias(Option<String>)`](crate::output::DescribeTimeSeriesOutput::alias): <p>The alias that identifies the time series.</p>
    ///   - [`time_series_id(Option<String>)`](crate::output::DescribeTimeSeriesOutput::time_series_id): <p>The ID of the time series.</p>
    ///   - [`data_type(Option<PropertyDataType>)`](crate::output::DescribeTimeSeriesOutput::data_type): <p>The data type of the time series.</p>  <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>
    ///   - [`data_type_spec(Option<String>)`](crate::output::DescribeTimeSeriesOutput::data_type_spec): <p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p>  <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>
    ///   - [`time_series_creation_date(Option<DateTime>)`](crate::output::DescribeTimeSeriesOutput::time_series_creation_date): <p>The date that the time series was created, in Unix epoch time.</p>
    ///   - [`time_series_last_update_date(Option<DateTime>)`](crate::output::DescribeTimeSeriesOutput::time_series_last_update_date): <p>The date that the time series was last updated, in Unix epoch time.</p>
    /// - On failure, responds with [`SdkError<DescribeTimeSeriesError>`](crate::error::DescribeTimeSeriesError)
    pub fn describe_time_series(&self) -> fluent_builders::DescribeTimeSeries {
        fluent_builders::DescribeTimeSeries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAssets`](crate::client::fluent_builders::DisassociateAssets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssets::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DisassociateAssets::set_asset_id): <p>The ID of the parent asset from which to disassociate the child asset.</p>
    ///   - [`hierarchy_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssets::hierarchy_id) / [`set_hierarchy_id(Option<String>)`](crate::client::fluent_builders::DisassociateAssets::set_hierarchy_id): <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`child_asset_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssets::child_asset_id) / [`set_child_asset_id(Option<String>)`](crate::client::fluent_builders::DisassociateAssets::set_child_asset_id): <p>The ID of the child asset to disassociate.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssets::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DisassociateAssets::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DisassociateAssetsOutput`](crate::output::DisassociateAssetsOutput)

    /// - On failure, responds with [`SdkError<DisassociateAssetsError>`](crate::error::DisassociateAssetsError)
    pub fn disassociate_assets(&self) -> fluent_builders::DisassociateAssets {
        fluent_builders::DisassociateAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTimeSeriesFromAssetProperty`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::set_alias): <p>The alias that identifies the time series.</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::set_asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DisassociateTimeSeriesFromAssetProperty::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`DisassociateTimeSeriesFromAssetPropertyOutput`](crate::output::DisassociateTimeSeriesFromAssetPropertyOutput)

    /// - On failure, responds with [`SdkError<DisassociateTimeSeriesFromAssetPropertyError>`](crate::error::DisassociateTimeSeriesFromAssetPropertyError)
    pub fn disassociate_time_series_from_asset_property(
        &self,
    ) -> fluent_builders::DisassociateTimeSeriesFromAssetProperty {
        fluent_builders::DisassociateTimeSeriesFromAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssetPropertyAggregates`](crate::client::fluent_builders::GetAssetPropertyAggregates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetAssetPropertyAggregates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`property_alias(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::property_alias) / [`set_property_alias(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_property_alias): <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`aggregate_types(Vec<AggregateType>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::aggregate_types) / [`set_aggregate_types(Option<Vec<AggregateType>>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_aggregate_types): <p>The data aggregating function.</p>
    ///   - [`resolution(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::resolution) / [`set_resolution(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_resolution): <p>The time interval over which to aggregate data.</p>
    ///   - [`qualities(Vec<Quality>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::qualities) / [`set_qualities(Option<Vec<Quality>>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_qualities): <p>The quality by which to filter asset data.</p>
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::GetAssetPropertyAggregates::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_start_date): <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::GetAssetPropertyAggregates::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_end_date): <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    ///   - [`time_ordering(TimeOrdering)`](crate::client::fluent_builders::GetAssetPropertyAggregates::time_ordering) / [`set_time_ordering(Option<TimeOrdering>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_time_ordering): <p>The chronological sorting order of the requested information.</p>  <p>Default: <code>ASCENDING</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAssetPropertyAggregates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetAssetPropertyAggregates::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 100</p>
    /// - On success, responds with [`GetAssetPropertyAggregatesOutput`](crate::output::GetAssetPropertyAggregatesOutput) with field(s):
    ///   - [`aggregated_values(Option<Vec<AggregatedValue>>)`](crate::output::GetAssetPropertyAggregatesOutput::aggregated_values): <p>The requested aggregated values.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetAssetPropertyAggregatesOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<GetAssetPropertyAggregatesError>`](crate::error::GetAssetPropertyAggregatesError)
    pub fn get_asset_property_aggregates(&self) -> fluent_builders::GetAssetPropertyAggregates {
        fluent_builders::GetAssetPropertyAggregates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssetPropertyValue`](crate::client::fluent_builders::GetAssetPropertyValue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`property_alias(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::property_alias) / [`set_property_alias(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValue::set_property_alias): <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`GetAssetPropertyValueOutput`](crate::output::GetAssetPropertyValueOutput) with field(s):
    ///   - [`property_value(Option<AssetPropertyValue>)`](crate::output::GetAssetPropertyValueOutput::property_value): <p>The current asset property value.</p>
    /// - On failure, responds with [`SdkError<GetAssetPropertyValueError>`](crate::error::GetAssetPropertyValueError)
    pub fn get_asset_property_value(&self) -> fluent_builders::GetAssetPropertyValue {
        fluent_builders::GetAssetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssetPropertyValueHistory`](crate::client::fluent_builders::GetAssetPropertyValueHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetAssetPropertyValueHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`property_alias(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::property_alias) / [`set_property_alias(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_property_alias): <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_start_date): <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_end_date): <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    ///   - [`qualities(Vec<Quality>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::qualities) / [`set_qualities(Option<Vec<Quality>>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_qualities): <p>The quality by which to filter asset data.</p>
    ///   - [`time_ordering(TimeOrdering)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::time_ordering) / [`set_time_ordering(Option<TimeOrdering>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_time_ordering): <p>The chronological sorting order of the requested information.</p>  <p>Default: <code>ASCENDING</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetAssetPropertyValueHistory::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 100</p>
    /// - On success, responds with [`GetAssetPropertyValueHistoryOutput`](crate::output::GetAssetPropertyValueHistoryOutput) with field(s):
    ///   - [`asset_property_value_history(Option<Vec<AssetPropertyValue>>)`](crate::output::GetAssetPropertyValueHistoryOutput::asset_property_value_history): <p>The asset property's value history.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetAssetPropertyValueHistoryOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<GetAssetPropertyValueHistoryError>`](crate::error::GetAssetPropertyValueHistoryError)
    pub fn get_asset_property_value_history(
        &self,
    ) -> fluent_builders::GetAssetPropertyValueHistory {
        fluent_builders::GetAssetPropertyValueHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInterpolatedAssetPropertyValues`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_property_id): <p>The ID of the asset property.</p>
    ///   - [`property_alias(impl Into<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::property_alias) / [`set_property_alias(Option<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_property_alias): <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`start_time_in_seconds(i64)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::start_time_in_seconds) / [`set_start_time_in_seconds(Option<i64>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_start_time_in_seconds): <p>The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
    ///   - [`start_time_offset_in_nanos(i32)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::start_time_offset_in_nanos) / [`set_start_time_offset_in_nanos(Option<i32>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_start_time_offset_in_nanos): <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
    ///   - [`end_time_in_seconds(i64)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::end_time_in_seconds) / [`set_end_time_in_seconds(Option<i64>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_end_time_in_seconds): <p>The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
    ///   - [`end_time_offset_in_nanos(i32)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::end_time_offset_in_nanos) / [`set_end_time_offset_in_nanos(Option<i32>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_end_time_offset_in_nanos): <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
    ///   - [`quality(Quality)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::quality) / [`set_quality(Option<Quality>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_quality): <p>The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.</p>
    ///   - [`interval_in_seconds(i64)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::interval_in_seconds) / [`set_interval_in_seconds(Option<i64>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_interval_in_seconds): <p>The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_max_results): <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::type) / [`set_type(Option<String>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_type): <p>The interpolation type.</p>  <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code> </p>  <ul>   <li> <p> <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p> <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.</p> </li>   <li> <p> <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p> <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.</p> <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p> </li>  </ul>
    ///   - [`interval_window_in_seconds(i64)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::interval_window_in_seconds) / [`set_interval_window_in_seconds(Option<i64>)`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues::set_interval_window_in_seconds): <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.</p> <note>   <ul>    <li> <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the value for the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p> </li>    <li> <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an interpolated value for the interval. This indicates that there's a gap in the ingested data points.</p> </li>   </ul>  </note>  <p>For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on. </p>
    /// - On success, responds with [`GetInterpolatedAssetPropertyValuesOutput`](crate::output::GetInterpolatedAssetPropertyValuesOutput) with field(s):
    ///   - [`interpolated_asset_property_values(Option<Vec<InterpolatedAssetPropertyValue>>)`](crate::output::GetInterpolatedAssetPropertyValuesOutput::interpolated_asset_property_values): <p>The requested interpolated values.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInterpolatedAssetPropertyValuesOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<GetInterpolatedAssetPropertyValuesError>`](crate::error::GetInterpolatedAssetPropertyValuesError)
    pub fn get_interpolated_asset_property_values(
        &self,
    ) -> fluent_builders::GetInterpolatedAssetPropertyValues {
        fluent_builders::GetInterpolatedAssetPropertyValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessPolicies`](crate::client::fluent_builders::ListAccessPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccessPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::ListAccessPolicies::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::ListAccessPolicies::set_identity_type): <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required if you specify <code>identityId</code>.</p>
    ///   - [`identity_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessPolicies::identity_id) / [`set_identity_id(Option<String>)`](crate::client::fluent_builders::ListAccessPolicies::set_identity_id): <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for <code>identityType</code>.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::ListAccessPolicies::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::ListAccessPolicies::set_resource_type): <p>The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessPolicies::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListAccessPolicies::set_resource_id): <p>The ID of the resource. This parameter is required if you specify <code>resourceType</code>.</p>
    ///   - [`iam_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccessPolicies::iam_arn) / [`set_iam_arn(Option<String>)`](crate::client::fluent_builders::ListAccessPolicies::set_iam_arn): <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccessPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccessPolicies::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccessPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccessPolicies::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListAccessPoliciesOutput`](crate::output::ListAccessPoliciesOutput) with field(s):
    ///   - [`access_policy_summaries(Option<Vec<AccessPolicySummary>>)`](crate::output::ListAccessPoliciesOutput::access_policy_summaries): <p>A list that summarizes each access policy.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessPoliciesOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAccessPoliciesError>`](crate::error::ListAccessPoliciesError)
    pub fn list_access_policies(&self) -> fluent_builders::ListAccessPolicies {
        fluent_builders::ListAccessPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssetModels`](crate::client::fluent_builders::ListAssetModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssetModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssetModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssetModels::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssetModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssetModels::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListAssetModelsOutput`](crate::output::ListAssetModelsOutput) with field(s):
    ///   - [`asset_model_summaries(Option<Vec<AssetModelSummary>>)`](crate::output::ListAssetModelsOutput::asset_model_summaries): <p>A list that summarizes each asset model.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssetModelsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAssetModelsError>`](crate::error::ListAssetModelsError)
    pub fn list_asset_models(&self) -> fluent_builders::ListAssetModels {
        fluent_builders::ListAssetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssetRelationships`](crate::client::fluent_builders::ListAssetRelationships) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssetRelationships::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::ListAssetRelationships::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::ListAssetRelationships::set_asset_id): <p>The ID of the asset.</p>
    ///   - [`traversal_type(TraversalType)`](crate::client::fluent_builders::ListAssetRelationships::traversal_type) / [`set_traversal_type(Option<TraversalType>)`](crate::client::fluent_builders::ListAssetRelationships::set_traversal_type): <p>The type of traversal to use to identify asset relationships. Choose the following option:</p>  <ul>   <li> <p> <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssetRelationships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssetRelationships::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssetRelationships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssetRelationships::set_max_results): <p>The maximum number of results to return for each paginated request.</p>
    /// - On success, responds with [`ListAssetRelationshipsOutput`](crate::output::ListAssetRelationshipsOutput) with field(s):
    ///   - [`asset_relationship_summaries(Option<Vec<AssetRelationshipSummary>>)`](crate::output::ListAssetRelationshipsOutput::asset_relationship_summaries): <p>A list that summarizes each asset relationship.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssetRelationshipsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAssetRelationshipsError>`](crate::error::ListAssetRelationshipsError)
    pub fn list_asset_relationships(&self) -> fluent_builders::ListAssetRelationships {
        fluent_builders::ListAssetRelationships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssets`](crate::client::fluent_builders::ListAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssets::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssets::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    ///   - [`asset_model_id(impl Into<String>)`](crate::client::fluent_builders::ListAssets::asset_model_id) / [`set_asset_model_id(Option<String>)`](crate::client::fluent_builders::ListAssets::set_asset_model_id): <p>The ID of the asset model by which to filter the list of assets. This parameter is required if you choose <code>ALL</code> for <code>filter</code>.</p>
    ///   - [`filter(ListAssetsFilter)`](crate::client::fluent_builders::ListAssets::filter) / [`set_filter(Option<ListAssetsFilter>)`](crate::client::fluent_builders::ListAssets::set_filter): <p>The filter for the requested list of assets. Choose one of the following options:</p>  <ul>   <li> <p> <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.</p> </li>   <li> <p> <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.</p> </li>  </ul>  <p>Default: <code>ALL</code> </p>
    /// - On success, responds with [`ListAssetsOutput`](crate::output::ListAssetsOutput) with field(s):
    ///   - [`asset_summaries(Option<Vec<AssetSummary>>)`](crate::output::ListAssetsOutput::asset_summaries): <p>A list that summarizes each asset.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssetsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAssetsError>`](crate::error::ListAssetsError)
    pub fn list_assets(&self) -> fluent_builders::ListAssets {
        fluent_builders::ListAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedAssets`](crate::client::fluent_builders::ListAssociatedAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociatedAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedAssets::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::ListAssociatedAssets::set_asset_id): <p>The ID of the asset to query.</p>
    ///   - [`hierarchy_id(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedAssets::hierarchy_id) / [`set_hierarchy_id(Option<String>)`](crate::client::fluent_builders::ListAssociatedAssets::set_hierarchy_id): <p>The ID of the hierarchy by which child assets are associated to the asset. To find a hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This parameter is required if you choose <code>CHILD</code> for <code>traversalDirection</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`traversal_direction(TraversalDirection)`](crate::client::fluent_builders::ListAssociatedAssets::traversal_direction) / [`set_traversal_direction(Option<TraversalDirection>)`](crate::client::fluent_builders::ListAssociatedAssets::set_traversal_direction): <p>The direction to list associated assets. Choose one of the following options:</p>  <ul>   <li> <p> <code>CHILD</code> – The list includes all child assets associated to the asset. The <code>hierarchyId</code> parameter is required if you choose <code>CHILD</code>.</p> </li>   <li> <p> <code>PARENT</code> – The list includes the asset's parent asset.</p> </li>  </ul>  <p>Default: <code>CHILD</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedAssets::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociatedAssets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociatedAssets::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListAssociatedAssetsOutput`](crate::output::ListAssociatedAssetsOutput) with field(s):
    ///   - [`asset_summaries(Option<Vec<AssociatedAssetsSummary>>)`](crate::output::ListAssociatedAssetsOutput::asset_summaries): <p>A list that summarizes the associated assets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedAssetsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAssociatedAssetsError>`](crate::error::ListAssociatedAssetsError)
    pub fn list_associated_assets(&self) -> fluent_builders::ListAssociatedAssets {
        fluent_builders::ListAssociatedAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDashboards`](crate::client::fluent_builders::ListDashboards) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDashboards::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::ListDashboards::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::ListDashboards::set_project_id): <p>The ID of the project.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDashboards::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDashboards::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDashboards::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDashboards::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListDashboardsOutput`](crate::output::ListDashboardsOutput) with field(s):
    ///   - [`dashboard_summaries(Option<Vec<DashboardSummary>>)`](crate::output::ListDashboardsOutput::dashboard_summaries): <p>A list that summarizes each dashboard in the project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDashboardsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListDashboardsError>`](crate::error::ListDashboardsError)
    pub fn list_dashboards(&self) -> fluent_builders::ListDashboards {
        fluent_builders::ListDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGateways`](crate::client::fluent_builders::ListGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGateways::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGateways::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListGatewaysOutput`](crate::output::ListGatewaysOutput) with field(s):
    ///   - [`gateway_summaries(Option<Vec<GatewaySummary>>)`](crate::output::ListGatewaysOutput::gateway_summaries): <p>A list that summarizes each gateway.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGatewaysOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListGatewaysError>`](crate::error::ListGatewaysError)
    pub fn list_gateways(&self) -> fluent_builders::ListGateways {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPortals`](crate::client::fluent_builders::ListPortals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPortals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPortals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPortals::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPortals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPortals::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListPortalsOutput`](crate::output::ListPortalsOutput) with field(s):
    ///   - [`portal_summaries(Option<Vec<PortalSummary>>)`](crate::output::ListPortalsOutput::portal_summaries): <p>A list that summarizes each portal.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPortalsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListPortalsError>`](crate::error::ListPortalsError)
    pub fn list_portals(&self) -> fluent_builders::ListPortals {
        fluent_builders::ListPortals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjectAssets`](crate::client::fluent_builders::ListProjectAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjectAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::ListProjectAssets::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::ListProjectAssets::set_project_id): <p>The ID of the project.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjectAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjectAssets::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjectAssets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjectAssets::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListProjectAssetsOutput`](crate::output::ListProjectAssetsOutput) with field(s):
    ///   - [`asset_ids(Option<Vec<String>>)`](crate::output::ListProjectAssetsOutput::asset_ids): <p>A list that contains the IDs of each asset associated with the project.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectAssetsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListProjectAssetsError>`](crate::error::ListProjectAssetsError)
    pub fn list_project_assets(&self) -> fluent_builders::ListProjectAssets {
        fluent_builders::ListProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_id(impl Into<String>)`](crate::client::fluent_builders::ListProjects::portal_id) / [`set_portal_id(Option<String>)`](crate::client::fluent_builders::ListProjects::set_portal_id): <p>The ID of the portal.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjects::set_max_results): <p>The maximum number of results to return for each paginated request.</p>  <p>Default: 50</p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`project_summaries(Option<Vec<ProjectSummary>>)`](crate::output::ListProjectsOutput::project_summaries): <p>A list that summarizes each project in the portal.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTimeSeries`](crate::client::fluent_builders::ListTimeSeries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTimeSeries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTimeSeries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTimeSeries::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTimeSeries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTimeSeries::set_max_results): <p>The maximum number of results to return for each paginated request.</p>
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::ListTimeSeries::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::ListTimeSeries::set_asset_id): <p>The ID of the asset in which the asset property was created.</p>
    ///   - [`alias_prefix(impl Into<String>)`](crate::client::fluent_builders::ListTimeSeries::alias_prefix) / [`set_alias_prefix(Option<String>)`](crate::client::fluent_builders::ListTimeSeries::set_alias_prefix): <p>The alias prefix of the time series.</p>
    ///   - [`time_series_type(ListTimeSeriesType)`](crate::client::fluent_builders::ListTimeSeries::time_series_type) / [`set_time_series_type(Option<ListTimeSeriesType>)`](crate::client::fluent_builders::ListTimeSeries::set_time_series_type): <p>The type of the time series. The time series type can be one of the following values:</p>  <ul>   <li> <p> <code>ASSOCIATED</code> – The time series is associated with an asset property.</p> </li>   <li> <p> <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.</p> </li>  </ul>
    /// - On success, responds with [`ListTimeSeriesOutput`](crate::output::ListTimeSeriesOutput) with field(s):
    ///   - [`time_series_summaries(Option<Vec<TimeSeriesSummary>>)`](crate::output::ListTimeSeriesOutput::time_series_summaries): <p>One or more time series summaries to list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTimeSeriesOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListTimeSeriesError>`](crate::error::ListTimeSeriesError)
    pub fn list_time_series(&self) -> fluent_builders::ListTimeSeries {
        fluent_builders::ListTimeSeries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDefaultEncryptionConfiguration`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`encryption_type(EncryptionType)`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration::encryption_type) / [`set_encryption_type(Option<EncryptionType>)`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration::set_encryption_type): <p>The type of encryption used for the encryption configuration.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration::set_kms_key_id): <p>The Key ID of the customer managed key used for KMS encryption. This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    /// - On success, responds with [`PutDefaultEncryptionConfigurationOutput`](crate::output::PutDefaultEncryptionConfigurationOutput) with field(s):
    ///   - [`encryption_type(Option<EncryptionType>)`](crate::output::PutDefaultEncryptionConfigurationOutput::encryption_type): <p>The type of encryption used for the encryption configuration.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::PutDefaultEncryptionConfigurationOutput::kms_key_arn): <p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
    ///   - [`configuration_status(Option<ConfigurationStatus>)`](crate::output::PutDefaultEncryptionConfigurationOutput::configuration_status): <p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>
    /// - On failure, responds with [`SdkError<PutDefaultEncryptionConfigurationError>`](crate::error::PutDefaultEncryptionConfigurationError)
    pub fn put_default_encryption_configuration(
        &self,
    ) -> fluent_builders::PutDefaultEncryptionConfiguration {
        fluent_builders::PutDefaultEncryptionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_options(LoggingOptions)`](crate::client::fluent_builders::PutLoggingOptions::logging_options) / [`set_logging_options(Option<LoggingOptions>)`](crate::client::fluent_builders::PutLoggingOptions::set_logging_options): <p>The logging options to set.</p>
    /// - On success, responds with [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutLoggingOptionsError>`](crate::error::PutLoggingOptionsError)
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutStorageConfiguration`](crate::client::fluent_builders::PutStorageConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`storage_type(StorageType)`](crate::client::fluent_builders::PutStorageConfiguration::storage_type) / [`set_storage_type(Option<StorageType>)`](crate::client::fluent_builders::PutStorageConfiguration::set_storage_type): <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>  <ul>   <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>   <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>  </ul>
    ///   - [`multi_layer_storage(MultiLayerStorage)`](crate::client::fluent_builders::PutStorageConfiguration::multi_layer_storage) / [`set_multi_layer_storage(Option<MultiLayerStorage>)`](crate::client::fluent_builders::PutStorageConfiguration::set_multi_layer_storage): <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you must specify a <code>MultiLayerStorage</code> object.</p>
    ///   - [`disassociated_data_storage(DisassociatedDataStorageState)`](crate::client::fluent_builders::PutStorageConfiguration::disassociated_data_storage) / [`set_disassociated_data_storage(Option<DisassociatedDataStorageState>)`](crate::client::fluent_builders::PutStorageConfiguration::set_disassociated_data_storage): <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>  <ul>   <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>     <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>    </important> </li>   <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::PutStorageConfiguration::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::PutStorageConfiguration::set_retention_period): <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    /// - On success, responds with [`PutStorageConfigurationOutput`](crate::output::PutStorageConfigurationOutput) with field(s):
    ///   - [`storage_type(Option<StorageType>)`](crate::output::PutStorageConfigurationOutput::storage_type): <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>  <ul>   <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>   <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>  </ul>
    ///   - [`multi_layer_storage(Option<MultiLayerStorage>)`](crate::output::PutStorageConfigurationOutput::multi_layer_storage): <p>Contains information about the storage destination.</p>
    ///   - [`disassociated_data_storage(Option<DisassociatedDataStorageState>)`](crate::output::PutStorageConfigurationOutput::disassociated_data_storage): <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>  <ul>   <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>     <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>    </important> </li>   <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`retention_period(Option<RetentionPeriod>)`](crate::output::PutStorageConfigurationOutput::retention_period): <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    ///   - [`configuration_status(Option<ConfigurationStatus>)`](crate::output::PutStorageConfigurationOutput::configuration_status): <p>Contains current status information for the configuration.</p>
    /// - On failure, responds with [`SdkError<PutStorageConfigurationError>`](crate::error::PutStorageConfigurationError)
    pub fn put_storage_configuration(&self) -> fluent_builders::PutStorageConfiguration {
        fluent_builders::PutStorageConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of keys for tags to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccessPolicy`](crate::client::fluent_builders::UpdateAccessPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_policy_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccessPolicy::access_policy_id) / [`set_access_policy_id(Option<String>)`](crate::client::fluent_builders::UpdateAccessPolicy::set_access_policy_id): <p>The ID of the access policy.</p>
    ///   - [`access_policy_identity(Identity)`](crate::client::fluent_builders::UpdateAccessPolicy::access_policy_identity) / [`set_access_policy_identity(Option<Identity>)`](crate::client::fluent_builders::UpdateAccessPolicy::set_access_policy_identity): <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    ///   - [`access_policy_resource(Resource)`](crate::client::fluent_builders::UpdateAccessPolicy::access_policy_resource) / [`set_access_policy_resource(Option<Resource>)`](crate::client::fluent_builders::UpdateAccessPolicy::set_access_policy_resource): <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    ///   - [`access_policy_permission(Permission)`](crate::client::fluent_builders::UpdateAccessPolicy::access_policy_permission) / [`set_access_policy_permission(Option<Permission>)`](crate::client::fluent_builders::UpdateAccessPolicy::set_access_policy_permission): <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAccessPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateAccessPolicy::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateAccessPolicyOutput`](crate::output::UpdateAccessPolicyOutput)

    /// - On failure, responds with [`SdkError<UpdateAccessPolicyError>`](crate::error::UpdateAccessPolicyError)
    pub fn update_access_policy(&self) -> fluent_builders::UpdateAccessPolicy {
        fluent_builders::UpdateAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAsset`](crate::client::fluent_builders::UpdateAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_asset_id): <p>The ID of the asset to update.</p>
    ///   - [`asset_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::asset_name) / [`set_asset_name(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_asset_name): <p>A unique, friendly name for the asset.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAsset::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateAsset::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateAssetOutput`](crate::output::UpdateAssetOutput) with field(s):
    ///   - [`asset_status(Option<AssetStatus>)`](crate::output::UpdateAssetOutput::asset_status): <p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<UpdateAssetError>`](crate::error::UpdateAssetError)
    pub fn update_asset(&self) -> fluent_builders::UpdateAsset {
        fluent_builders::UpdateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssetModel`](crate::client::fluent_builders::UpdateAssetModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_id) / [`set_asset_model_id(Option<String>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_id): <p>The ID of the asset model to update.</p>
    ///   - [`asset_model_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_name) / [`set_asset_model_name(Option<String>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_name): <p>A unique, friendly name for the asset model.</p>
    ///   - [`asset_model_description(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_description) / [`set_asset_model_description(Option<String>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_description): <p>A description for the asset model.</p>
    ///   - [`asset_model_properties(Vec<AssetModelProperty>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_properties) / [`set_asset_model_properties(Option<Vec<AssetModelProperty>>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_properties): <p>The updated property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`asset_model_hierarchies(Vec<AssetModelHierarchy>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_hierarchies) / [`set_asset_model_hierarchies(Option<Vec<AssetModelHierarchy>>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_hierarchies): <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`asset_model_composite_models(Vec<AssetModelCompositeModel>)`](crate::client::fluent_builders::UpdateAssetModel::asset_model_composite_models) / [`set_asset_model_composite_models(Option<Vec<AssetModelCompositeModel>>)`](crate::client::fluent_builders::UpdateAssetModel::set_asset_model_composite_models): <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateAssetModel::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateAssetModelOutput`](crate::output::UpdateAssetModelOutput) with field(s):
    ///   - [`asset_model_status(Option<AssetModelStatus>)`](crate::output::UpdateAssetModelOutput::asset_model_status): <p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<UpdateAssetModelError>`](crate::error::UpdateAssetModelError)
    pub fn update_asset_model(&self) -> fluent_builders::UpdateAssetModel {
        fluent_builders::UpdateAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssetProperty`](crate::client::fluent_builders::UpdateAssetProperty) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`asset_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetProperty::asset_id) / [`set_asset_id(Option<String>)`](crate::client::fluent_builders::UpdateAssetProperty::set_asset_id): <p>The ID of the asset to be updated.</p>
    ///   - [`property_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetProperty::property_id) / [`set_property_id(Option<String>)`](crate::client::fluent_builders::UpdateAssetProperty::set_property_id): <p>The ID of the asset property to be updated.</p>
    ///   - [`property_alias(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetProperty::property_alias) / [`set_property_alias(Option<String>)`](crate::client::fluent_builders::UpdateAssetProperty::set_property_alias): <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>If you omit this parameter, the alias is removed from the property.</p>
    ///   - [`property_notification_state(PropertyNotificationState)`](crate::client::fluent_builders::UpdateAssetProperty::property_notification_state) / [`set_property_notification_state(Option<PropertyNotificationState>)`](crate::client::fluent_builders::UpdateAssetProperty::set_property_notification_state): <p>The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>  <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAssetProperty::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateAssetProperty::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateAssetPropertyOutput`](crate::output::UpdateAssetPropertyOutput)

    /// - On failure, responds with [`SdkError<UpdateAssetPropertyError>`](crate::error::UpdateAssetPropertyError)
    pub fn update_asset_property(&self) -> fluent_builders::UpdateAssetProperty {
        fluent_builders::UpdateAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDashboard`](crate::client::fluent_builders::UpdateDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_id): <p>The ID of the dashboard to update.</p>
    ///   - [`dashboard_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::dashboard_name) / [`set_dashboard_name(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_name): <p>A new friendly name for the dashboard.</p>
    ///   - [`dashboard_description(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::dashboard_description) / [`set_dashboard_description(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_description): <p>A new description for the dashboard.</p>
    ///   - [`dashboard_definition(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::dashboard_definition) / [`set_dashboard_definition(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_definition): <p>The new dashboard definition, as specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)

    /// - On failure, responds with [`SdkError<UpdateDashboardError>`](crate::error::UpdateDashboardError)
    pub fn update_dashboard(&self) -> fluent_builders::UpdateDashboard {
        fluent_builders::UpdateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGateway`](crate::client::fluent_builders::UpdateGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGateway::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::UpdateGateway::set_gateway_id): <p>The ID of the gateway to update.</p>
    ///   - [`gateway_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGateway::gateway_name) / [`set_gateway_name(Option<String>)`](crate::client::fluent_builders::UpdateGateway::set_gateway_name): <p>A unique, friendly name for the gateway.</p>
    /// - On success, responds with [`UpdateGatewayOutput`](crate::output::UpdateGatewayOutput)

    /// - On failure, responds with [`SdkError<UpdateGatewayError>`](crate::error::UpdateGatewayError)
    pub fn update_gateway(&self) -> fluent_builders::UpdateGateway {
        fluent_builders::UpdateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewayCapabilityConfiguration`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::set_gateway_id): <p>The ID of the gateway to be updated.</p>
    ///   - [`capability_namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::capability_namespace) / [`set_capability_namespace(Option<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::set_capability_namespace): <p>The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
    ///   - [`capability_configuration(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::capability_configuration) / [`set_capability_configuration(Option<String>)`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration::set_capability_configuration): <p>The JSON document that defines the configuration for the gateway capability. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// - On success, responds with [`UpdateGatewayCapabilityConfigurationOutput`](crate::output::UpdateGatewayCapabilityConfigurationOutput) with field(s):
    ///   - [`capability_namespace(Option<String>)`](crate::output::UpdateGatewayCapabilityConfigurationOutput::capability_namespace): <p>The namespace of the gateway capability.</p>
    ///   - [`capability_sync_status(Option<CapabilitySyncStatus>)`](crate::output::UpdateGatewayCapabilityConfigurationOutput::capability_sync_status): <p>The synchronization status of the capability configuration. The sync status can be one of the following:</p>  <ul>   <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li>   <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn't received the capability configuration.</p> </li>   <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li>  </ul>  <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateGatewayCapabilityConfigurationError>`](crate::error::UpdateGatewayCapabilityConfigurationError)
    pub fn update_gateway_capability_configuration(
        &self,
    ) -> fluent_builders::UpdateGatewayCapabilityConfiguration {
        fluent_builders::UpdateGatewayCapabilityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePortal`](crate::client::fluent_builders::UpdatePortal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`portal_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::portal_id) / [`set_portal_id(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_portal_id): <p>The ID of the portal to update.</p>
    ///   - [`portal_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::portal_name) / [`set_portal_name(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_portal_name): <p>A new friendly name for the portal.</p>
    ///   - [`portal_description(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::portal_description) / [`set_portal_description(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_portal_description): <p>A new description for the portal.</p>
    ///   - [`portal_contact_email(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::portal_contact_email) / [`set_portal_contact_email(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_portal_contact_email): <p>The Amazon Web Services administrator's contact email address.</p>
    ///   - [`portal_logo_image(Image)`](crate::client::fluent_builders::UpdatePortal::portal_logo_image) / [`set_portal_logo_image(Option<Image>)`](crate::client::fluent_builders::UpdatePortal::set_portal_logo_image): <p>Contains an image that is one of the following:</p>  <ul>   <li> <p>An image file. Choose this option to upload a new image.</p> </li>   <li> <p>The ID of an existing image. Choose this option to keep an existing image.</p> </li>  </ul>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_role_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    ///   - [`notification_sender_email(impl Into<String>)`](crate::client::fluent_builders::UpdatePortal::notification_sender_email) / [`set_notification_sender_email(Option<String>)`](crate::client::fluent_builders::UpdatePortal::set_notification_sender_email): <p>The email address that sends alarm notifications.</p>
    ///   - [`alarms(Alarms)`](crate::client::fluent_builders::UpdatePortal::alarms) / [`set_alarms(Option<Alarms>)`](crate::client::fluent_builders::UpdatePortal::set_alarms): <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    /// - On success, responds with [`UpdatePortalOutput`](crate::output::UpdatePortalOutput) with field(s):
    ///   - [`portal_status(Option<PortalStatus>)`](crate::output::UpdatePortalOutput::portal_status): <p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>
    /// - On failure, responds with [`SdkError<UpdatePortalError>`](crate::error::UpdatePortalError)
    pub fn update_portal(&self) -> fluent_builders::UpdatePortal {
        fluent_builders::UpdatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProject`](crate::client::fluent_builders::UpdateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::project_id) / [`set_project_id(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_project_id): <p>The ID of the project to update.</p>
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_project_name): <p>A new friendly name for the project.</p>
    ///   - [`project_description(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::project_description) / [`set_project_description(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_project_description): <p>A new description for the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_client_token): <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    /// - On success, responds with [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)

    /// - On failure, responds with [`SdkError<UpdateProjectError>`](crate::error::UpdateProjectError)
    pub fn update_project(&self) -> fluent_builders::UpdateProject {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAssets`.
    ///
    /// <p>Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_assets_input::Builder,
    }
    impl AssociateAssets {
        /// Creates a new `AssociateAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the parent asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(input.into());
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn child_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_asset_id(input.into());
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_child_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTimeSeriesToAssetProperty`.
    ///
    /// <p>Associates a time series (data stream) with an asset property.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTimeSeriesToAssetProperty {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_time_series_to_asset_property_input::Builder,
    }
    impl AssociateTimeSeriesToAssetProperty {
        /// Creates a new `AssociateTimeSeriesToAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTimeSeriesToAssetPropertyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateTimeSeriesToAssetPropertyError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateProjectAssets`.
    ///
    /// <p>Associates a group (batch) of assets with an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateProjectAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_associate_project_assets_input::Builder,
    }
    impl BatchAssociateProjectAssets {
        /// Creates a new `BatchAssociateProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchAssociateProjectAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// Appends an item to `assetIds`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn asset_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_ids(input.into());
            self
        }
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_asset_ids(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateProjectAssets`.
    ///
    /// <p>Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateProjectAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_disassociate_project_assets_input::Builder,
    }
    impl BatchDisassociateProjectAssets {
        /// Creates a new `BatchDisassociateProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDisassociateProjectAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// Appends an item to `assetIds`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn asset_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_ids(input.into());
            self
        }
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_asset_ids(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchPutAssetPropertyValue`.
    ///
    /// <p>Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li>
    /// <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li>
    /// </ul> <important>
    /// <p>With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.</p>
    /// <p>For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing <code>{T1, GOOD, V2}</code> replaces the existing TQV.</p>
    /// </important>
    /// <p>IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchPutAssetPropertyValue {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_put_asset_property_value_input::Builder,
    }
    impl BatchPutAssetPropertyValue {
        /// Creates a new `BatchPutAssetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutAssetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutAssetPropertyValueError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of asset property value entries for the batch put request. You can specify up to 10 entries per request.</p>
        pub fn entries(mut self, input: crate::model::PutAssetPropertyValueEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The list of asset property value entries for the batch put request. You can specify up to 10 entries per request.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPolicy`.
    ///
    /// <p>Creates an access policy that grants the specified identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccessPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_policy_input::Builder,
    }
    impl CreateAccessPolicy {
        /// Creates a new `CreateAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, input: crate::model::Identity) -> Self {
            self.inner = self.inner.access_policy_identity(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_identity(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.access_policy_resource(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_resource(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.access_policy_permission(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_permission(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAsset`.
    ///
    /// <p>Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_asset_input::Builder,
    }
    impl CreateAsset {
        /// Creates a new `CreateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_name(input);
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(input.into());
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssetModel`.
    ///
    /// <p>Creates an asset model from specified property and hierarchy definitions. You create assets from asset models. With asset models, you can easily create assets of the same type that have standardized definitions. Each asset created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssetModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_asset_model_input::Builder,
    }
    impl CreateAssetModel {
        /// Creates a new `CreateAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssetModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_name(input);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_description(input.into());
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_description(input);
            self
        }
        /// Appends an item to `assetModelProperties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(
            mut self,
            input: crate::model::AssetModelPropertyDefinition,
        ) -> Self {
            self.inner = self.inner.asset_model_properties(input);
            self
        }
        /// <p>The property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_properties(input);
            self
        }
        /// Appends an item to `assetModelHierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(
            mut self,
            input: crate::model::AssetModelHierarchyDefinition,
        ) -> Self {
            self.inner = self.inner.asset_model_hierarchies(input);
            self
        }
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchyDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_hierarchies(input);
            self
        }
        /// Appends an item to `assetModelCompositeModels`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            input: crate::model::AssetModelCompositeModelDefinition,
        ) -> Self {
            self.inner = self.inner.asset_model_composite_models(input);
            self
        }
        /// <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssetModelCompositeModelDefinition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_asset_model_composite_models(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDashboard`.
    ///
    /// <p>Creates a dashboard in an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDashboard {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dashboard_input::Builder,
    }
    impl CreateDashboard {
        /// Creates a new `CreateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDashboardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_name(input.into());
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_name(input);
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn dashboard_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_description(input.into());
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_description(input);
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_definition(input.into());
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_definition(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGateway`.
    ///
    /// <p>Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_gateway_input::Builder,
    }
    impl CreateGateway {
        /// Creates a new `CreateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn gateway_platform(mut self, input: crate::model::GatewayPlatform) -> Self {
            self.inner = self.inner.gateway_platform(input);
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn set_gateway_platform(
            mut self,
            input: std::option::Option<crate::model::GatewayPlatform>,
        ) -> Self {
            self.inner = self.inner.set_gateway_platform(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortal`.
    ///
    /// <p>Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM to authenticate portal users and manage user permissions.</p> <note>
    /// <p>Before you can sign in to a new portal, you must add at least one identity to that portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePortal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_portal_input::Builder,
    }
    impl CreatePortal {
        /// Creates a new `CreatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name for the portal.</p>
        pub fn portal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_name(input.into());
            self
        }
        /// <p>A friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_name(input);
            self
        }
        /// <p>A description for the portal.</p>
        pub fn portal_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_description(input.into());
            self
        }
        /// <p>A description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_description(input);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_contact_email(input.into());
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_contact_email(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.</p>
        pub fn portal_logo_image_file(mut self, input: crate::model::ImageFile) -> Self {
            self.inner = self.inner.portal_logo_image_file(input);
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.</p>
        pub fn set_portal_logo_image_file(
            mut self,
            input: std::option::Option<crate::model::ImageFile>,
        ) -> Self {
            self.inner = self.inner.set_portal_logo_image_file(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following options:</p>
        /// <ul>
        /// <li> <p> <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than the China Regions.</p> </li>
        /// <li> <p> <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user permissions.</p> </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code> </p>
        pub fn portal_auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.inner = self.inner.portal_auth_mode(input);
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following options:</p>
        /// <ul>
        /// <li> <p> <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than the China Regions.</p> </li>
        /// <li> <p> <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user permissions.</p> </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code> </p>
        pub fn set_portal_auth_mode(
            mut self,
            input: std::option::Option<crate::model::AuthMode>,
        ) -> Self {
            self.inner = self.inner.set_portal_auth_mode(input);
            self
        }
        /// <p>The email address that sends alarm notifications.</p> <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a>.</p>
        /// </important>
        pub fn notification_sender_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_sender_email(input.into());
            self
        }
        /// <p>The email address that sends alarm notifications.</p> <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a>.</p>
        /// </important>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_sender_email(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, input: crate::model::Alarms) -> Self {
            self.inner = self.inner.alarms(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.inner = self.inner.set_alarms(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project in the specified portal.</p> <note>
    /// <p>Make sure that the project name and description don't contain confidential information.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(input.into());
            self
        }
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_description(input.into());
            self
        }
        /// <p>A description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_description(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPolicy`.
    ///
    /// <p>Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_policy_input::Builder,
    }
    impl DeleteAccessPolicy {
        /// Creates a new `DeleteAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(input.into());
            self
        }
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAsset`.
    ///
    /// <p>Deletes an asset. This action can't be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the <i>IoT SiteWise User Guide</i>. </p> <note>
    /// <p>You can't delete an asset that's associated to another asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_asset_input::Builder,
    }
    impl DeleteAsset {
        /// Creates a new `DeleteAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to delete.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset to delete.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssetModel`.
    ///
    /// <p>Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssetModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_asset_model_input::Builder,
    }
    impl DeleteAssetModel {
        /// Creates a new `DeleteAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model to delete.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(input.into());
            self
        }
        /// <p>The ID of the asset model to delete.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDashboard`.
    ///
    /// <p>Deletes a dashboard from IoT SiteWise Monitor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDashboard {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dashboard_input::Builder,
    }
    impl DeleteDashboard {
        /// Creates a new `DeleteDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard to delete.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID of the dashboard to delete.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGateway`.
    ///
    /// <p>Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your gateway's file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_gateway_input::Builder,
    }
    impl DeleteGateway {
        /// Creates a new `DeleteGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to delete.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the gateway to delete.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortal`.
    ///
    /// <p>Deletes a portal from IoT SiteWise Monitor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePortal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_portal_input::Builder,
    }
    impl DeletePortal {
        /// Creates a new `DeletePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal to delete.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(input.into());
            self
        }
        /// <p>The ID of the portal to delete.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes a project from IoT SiteWise Monitor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTimeSeries`.
    ///
    /// <p>Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the asset property still exists, but the time series will no longer be associated with this asset property.</p>
    /// <p>To identify a time series, do one of the following:</p>
    /// <ul>
    /// <li> <p>If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.</p> </li>
    /// <li> <p>If the time series is associated with an asset property, specify one of the following: </p>
    /// <ul>
    /// <li> <p>The <code>alias</code> of the time series.</p> </li>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.</p> </li>
    /// </ul> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTimeSeries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_time_series_input::Builder,
    }
    impl DeleteTimeSeries {
        /// Creates a new `DeleteTimeSeries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTimeSeriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTimeSeriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccessPolicy`.
    ///
    /// <p>Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccessPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_access_policy_input::Builder,
    }
    impl DescribeAccessPolicy {
        /// Creates a new `DescribeAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccessPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAsset`.
    ///
    /// <p>Retrieves information about an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_asset_input::Builder,
    }
    impl DescribeAsset {
        /// Creates a new `DescribeAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssetModel`.
    ///
    /// <p>Retrieves information about an asset model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssetModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_asset_model_input::Builder,
    }
    impl DescribeAssetModel {
        /// Creates a new `DescribeAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(input.into());
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssetProperty`.
    ///
    /// <p>Retrieves information about an asset property.</p> <note>
    /// <p>When you call this operation for an attribute property, this response includes the default attribute value that you define in the asset model. If you update the default value in the model, this operation's response includes the new default value.</p>
    /// </note>
    /// <p>This operation doesn't return the value of the asset property. To get the value of an asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssetProperty {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_asset_property_input::Builder,
    }
    impl DescribeAssetProperty {
        /// Creates a new `DescribeAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetPropertyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetPropertyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboard`.
    ///
    /// <p>Retrieves information about a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDashboard {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dashboard_input::Builder,
    }
    impl DescribeDashboard {
        /// Creates a new `DescribeDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultEncryptionConfiguration`.
    ///
    /// <p>Retrieves information about the default encryption configuration for the Amazon Web Services account in the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDefaultEncryptionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_default_encryption_configuration_input::Builder,
    }
    impl DescribeDefaultEncryptionConfiguration {
        /// Creates a new `DescribeDefaultEncryptionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultEncryptionConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDefaultEncryptionConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeGateway`.
    ///
    /// <p>Retrieves information about a gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_gateway_input::Builder,
    }
    impl DescribeGateway {
        /// Creates a new `DescribeGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway device.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the gateway device.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayCapabilityConfiguration`.
    ///
    /// <p>Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGatewayCapabilityConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_gateway_capability_configuration_input::Builder,
    }
    impl DescribeGatewayCapabilityConfiguration {
        /// Creates a new `DescribeGatewayCapabilityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayCapabilityConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeGatewayCapabilityConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_namespace(input.into());
            self
        }
        /// <p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current IoT SiteWise logging options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl DescribeLoggingOptions {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribePortal`.
    ///
    /// <p>Retrieves information about a portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePortal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_portal_input::Builder,
    }
    impl DescribePortal {
        /// Creates a new `DescribePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Retrieves information about a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl DescribeProject {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorageConfiguration`.
    ///
    /// <p>Retrieves information about the storage configuration for IoT SiteWise.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStorageConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_storage_configuration_input::Builder,
    }
    impl DescribeStorageConfiguration {
        /// Creates a new `DescribeStorageConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorageConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorageConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeTimeSeries`.
    ///
    /// <p>Retrieves information about a time series (data stream).</p>
    /// <p>To identify a time series, do one of the following:</p>
    /// <ul>
    /// <li> <p>If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.</p> </li>
    /// <li> <p>If the time series is associated with an asset property, specify one of the following: </p>
    /// <ul>
    /// <li> <p>The <code>alias</code> of the time series.</p> </li>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.</p> </li>
    /// </ul> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTimeSeries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_time_series_input::Builder,
    }
    impl DescribeTimeSeries {
        /// Creates a new `DescribeTimeSeries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTimeSeriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTimeSeriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAssets`.
    ///
    /// <p>Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_assets_input::Builder,
    }
    impl DisassociateAssets {
        /// Creates a new `DisassociateAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(input.into());
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn child_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_asset_id(input.into());
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_child_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTimeSeriesFromAssetProperty`.
    ///
    /// <p>Disassociates a time series (data stream) from an asset property.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTimeSeriesFromAssetProperty {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_time_series_from_asset_property_input::Builder,
    }
    impl DisassociateTimeSeriesFromAssetProperty {
        /// Creates a new `DisassociateTimeSeriesFromAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTimeSeriesFromAssetPropertyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateTimeSeriesFromAssetPropertyError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyAggregates`.
    ///
    /// <p>Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying aggregates</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li>
    /// <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssetPropertyAggregates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_asset_property_aggregates_input::Builder,
    }
    impl GetAssetPropertyAggregates {
        /// Creates a new `GetAssetPropertyAggregates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyAggregatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyAggregatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAssetPropertyAggregatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetAssetPropertyAggregatesPaginator {
            crate::paginator::GetAssetPropertyAggregatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// Appends an item to `aggregateTypes`.
        ///
        /// To override the contents of this collection use [`set_aggregate_types`](Self::set_aggregate_types).
        ///
        /// <p>The data aggregating function.</p>
        pub fn aggregate_types(mut self, input: crate::model::AggregateType) -> Self {
            self.inner = self.inner.aggregate_types(input);
            self
        }
        /// <p>The data aggregating function.</p>
        pub fn set_aggregate_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregateType>>,
        ) -> Self {
            self.inner = self.inner.set_aggregate_types(input);
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution(input.into());
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolution(input);
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, input: crate::model::Quality) -> Self {
            self.inner = self.inner.qualities(input);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.inner = self.inner.set_qualities(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code> </p>
        pub fn time_ordering(mut self, input: crate::model::TimeOrdering) -> Self {
            self.inner = self.inner.time_ordering(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code> </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.inner = self.inner.set_time_ordering(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyValue`.
    ///
    /// <p>Gets an asset property's current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying current values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li>
    /// <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssetPropertyValue {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_asset_property_value_input::Builder,
    }
    impl GetAssetPropertyValue {
        /// Creates a new `GetAssetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyValueError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyValueHistory`.
    ///
    /// <p>Gets the history of an asset property's values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li>
    /// <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssetPropertyValueHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_asset_property_value_history_input::Builder,
    }
    impl GetAssetPropertyValueHistory {
        /// Creates a new `GetAssetPropertyValueHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyValueHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyValueHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAssetPropertyValueHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetAssetPropertyValueHistoryPaginator {
            crate::paginator::GetAssetPropertyValueHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, input: crate::model::Quality) -> Self {
            self.inner = self.inner.qualities(input);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.inner = self.inner.set_qualities(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code> </p>
        pub fn time_ordering(mut self, input: crate::model::TimeOrdering) -> Self {
            self.inner = self.inner.time_ordering(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code> </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.inner = self.inner.set_time_ordering(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInterpolatedAssetPropertyValues`.
    ///
    /// <p>Get interpolated values for an asset property for a specified time interval, during a period of time. If your time series is missing data points during the specified time interval, you can use interpolation to estimate the missing data.</p>
    /// <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li>
    /// <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInterpolatedAssetPropertyValues {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_interpolated_asset_property_values_input::Builder,
    }
    impl GetInterpolatedAssetPropertyValues {
        /// Creates a new `GetInterpolatedAssetPropertyValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInterpolatedAssetPropertyValuesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetInterpolatedAssetPropertyValuesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInterpolatedAssetPropertyValuesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetInterpolatedAssetPropertyValuesPaginator {
            crate::paginator::GetInterpolatedAssetPropertyValuesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
        pub fn start_time_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.start_time_in_seconds(input);
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_time_in_seconds(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn start_time_offset_in_nanos(mut self, input: i32) -> Self {
            self.inner = self.inner.start_time_offset_in_nanos(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn set_start_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_start_time_offset_in_nanos(input);
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
        pub fn end_time_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.end_time_in_seconds(input);
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_end_time_in_seconds(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn end_time_offset_in_nanos(mut self, input: i32) -> Self {
            self.inner = self.inner.end_time_offset_in_nanos(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn set_end_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_end_time_offset_in_nanos(input);
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.</p>
        pub fn quality(mut self, input: crate::model::Quality) -> Self {
            self.inner = self.inner.quality(input);
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.</p>
        pub fn set_quality(mut self, input: std::option::Option<crate::model::Quality>) -> Self {
            self.inner = self.inner.set_quality(input);
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.</p>
        pub fn interval_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.interval_in_seconds(input);
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_interval_in_seconds(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code> </p>
        /// <ul>
        /// <li> <p> <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p> <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.</p> </li>
        /// <li> <p> <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p> <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.</p> <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code> </p>
        /// <ul>
        /// <li> <p> <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p> <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.</p> </li>
        /// <li> <p> <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p> <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.</p> <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.</p> <note>
        /// <ul>
        /// <li> <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the value for the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p> </li>
        /// <li> <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an interpolated value for the interval. This indicates that there's a gap in the ingested data points.</p> </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on. </p>
        pub fn interval_window_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.interval_window_in_seconds(input);
            self
        }
        /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.</p> <note>
        /// <ul>
        /// <li> <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the value for the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p> </li>
        /// <li> <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an interpolated value for the interval. This indicates that there's a gap in the ingested data points.</p> </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on. </p>
        pub fn set_interval_window_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_interval_window_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPolicies`.
    ///
    /// <p>Retrieves a paginated list of access policies for an identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_policies_input::Builder,
    }
    impl ListAccessPolicies {
        /// Creates a new `ListAccessPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessPoliciesPaginator {
            crate::paginator::ListAccessPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required if you specify <code>identityId</code>.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required if you specify <code>identityId</code>.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(input.into());
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify <code>resourceType</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify <code>resourceType</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.</p>
        pub fn iam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.</p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_arn(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssetModels`.
    ///
    /// <p>Retrieves a paginated list of summaries of all asset models.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssetModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_asset_models_input::Builder,
    }
    impl ListAssetModels {
        /// Creates a new `ListAssetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssetModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssetModelsPaginator {
            crate::paginator::ListAssetModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssetRelationships`.
    ///
    /// <p>Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's root asset and all associated assets between that asset and its root.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssetRelationships {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_asset_relationships_input::Builder,
    }
    impl ListAssetRelationships {
        /// Creates a new `ListAssetRelationships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetRelationshipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetRelationshipsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssetRelationshipsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssetRelationshipsPaginator {
            crate::paginator::ListAssetRelationshipsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following option:</p>
        /// <ul>
        /// <li> <p> <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p> </li>
        /// </ul>
        pub fn traversal_type(mut self, input: crate::model::TraversalType) -> Self {
            self.inner = self.inner.traversal_type(input);
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following option:</p>
        /// <ul>
        /// <li> <p> <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root asset. The asset that you specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p> </li>
        /// </ul>
        pub fn set_traversal_type(
            mut self,
            input: std::option::Option<crate::model::TraversalType>,
        ) -> Self {
            self.inner = self.inner.set_traversal_type(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssets`.
    ///
    /// <p>Retrieves a paginated list of asset summaries.</p>
    /// <p>You can use this operation to do the following:</p>
    /// <ul>
    /// <li> <p>List assets based on a specific asset model.</p> </li>
    /// <li> <p>List top-level assets.</p> </li>
    /// </ul>
    /// <p>You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a> to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assets_input::Builder,
    }
    impl ListAssets {
        /// Creates a new `ListAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssetsPaginator {
            crate::paginator::ListAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(input.into());
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.</p> </li>
        /// <li> <p> <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.</p> </li>
        /// </ul>
        /// <p>Default: <code>ALL</code> </p>
        pub fn filter(mut self, input: crate::model::ListAssetsFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.</p> </li>
        /// <li> <p> <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.</p> </li>
        /// </ul>
        /// <p>Default: <code>ALL</code> </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListAssetsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedAssets`.
    ///
    /// <p>Retrieves a paginated list of associated assets.</p>
    /// <p>You can use this operation to do the following:</p>
    /// <ul>
    /// <li> <p>List child assets associated to a parent asset by a hierarchy that you specify.</p> </li>
    /// <li> <p>List an asset's parent asset.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_associated_assets_input::Builder,
    }
    impl ListAssociatedAssets {
        /// Creates a new `ListAssociatedAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociatedAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssociatedAssetsPaginator {
            crate::paginator::ListAssociatedAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the asset to query.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset to query.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This parameter is required if you choose <code>CHILD</code> for <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(input.into());
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This parameter is required if you choose <code>CHILD</code> for <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>CHILD</code> – The list includes all child assets associated to the asset. The <code>hierarchyId</code> parameter is required if you choose <code>CHILD</code>.</p> </li>
        /// <li> <p> <code>PARENT</code> – The list includes the asset's parent asset.</p> </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code> </p>
        pub fn traversal_direction(mut self, input: crate::model::TraversalDirection) -> Self {
            self.inner = self.inner.traversal_direction(input);
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>CHILD</code> – The list includes all child assets associated to the asset. The <code>hierarchyId</code> parameter is required if you choose <code>CHILD</code>.</p> </li>
        /// <li> <p> <code>PARENT</code> – The list includes the asset's parent asset.</p> </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code> </p>
        pub fn set_traversal_direction(
            mut self,
            input: std::option::Option<crate::model::TraversalDirection>,
        ) -> Self {
            self.inner = self.inner.set_traversal_direction(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboards`.
    ///
    /// <p>Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDashboards {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dashboards_input::Builder,
    }
    impl ListDashboards {
        /// Creates a new `ListDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDashboardsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDashboardsPaginator {
            crate::paginator::ListDashboardsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Retrieves a paginated list of gateways.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl ListGateways {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGatewaysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGatewaysPaginator {
            crate::paginator::ListGatewaysPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortals`.
    ///
    /// <p>Retrieves a paginated list of IoT SiteWise Monitor portals.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPortals {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_portals_input::Builder,
    }
    impl ListPortals {
        /// Creates a new `ListPortals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortalsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPortalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPortalsPaginator {
            crate::paginator::ListPortalsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjectAssets`.
    ///
    /// <p>Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjectAssets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_project_assets_input::Builder,
    }
    impl ListProjectAssets {
        /// Creates a new `ListProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectAssetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectAssetsPaginator {
            crate::paginator::ListProjectAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl ListProjects {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of tags for an IoT SiteWise resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTimeSeries`.
    ///
    /// <p>Retrieves a paginated list of time series (data streams).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTimeSeries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_time_series_input::Builder,
    }
    impl ListTimeSeries {
        /// Creates a new `ListTimeSeries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTimeSeriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTimeSeriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTimeSeriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTimeSeriesPaginator {
            crate::paginator::ListTimeSeriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The alias prefix of the time series.</p>
        pub fn alias_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_prefix(input.into());
            self
        }
        /// <p>The alias prefix of the time series.</p>
        pub fn set_alias_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_prefix(input);
            self
        }
        /// <p>The type of the time series. The time series type can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ASSOCIATED</code> – The time series is associated with an asset property.</p> </li>
        /// <li> <p> <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.</p> </li>
        /// </ul>
        pub fn time_series_type(mut self, input: crate::model::ListTimeSeriesType) -> Self {
            self.inner = self.inner.time_series_type(input);
            self
        }
        /// <p>The type of the time series. The time series type can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ASSOCIATED</code> – The time series is associated with an asset property.</p> </li>
        /// <li> <p> <code>DISASSOCIATED</code> – The time series isn't associated with any asset property.</p> </li>
        /// </ul>
        pub fn set_time_series_type(
            mut self,
            input: std::option::Option<crate::model::ListTimeSeriesType>,
        ) -> Self {
            self.inner = self.inner.set_time_series_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDefaultEncryptionConfiguration`.
    ///
    /// <p>Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDefaultEncryptionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_default_encryption_configuration_input::Builder,
    }
    impl PutDefaultEncryptionConfiguration {
        /// Creates a new `PutDefaultEncryptionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDefaultEncryptionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDefaultEncryptionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.inner = self.inner.encryption_type(input);
            self
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.inner = self.inner.set_encryption_type(input);
            self
        }
        /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets logging options for IoT SiteWise.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl PutLoggingOptions {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The logging options to set.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(input);
            self
        }
        /// <p>The logging options to set.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageConfiguration`.
    ///
    /// <p>Configures storage settings for IoT SiteWise.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutStorageConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_storage_configuration_input::Builder,
    }
    impl PutStorageConfiguration {
        /// Creates a new `PutStorageConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStorageConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.inner = self.inner.storage_type(input);
            self
        }
        /// <p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li>
        /// <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li>
        /// </ul>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn multi_layer_storage(mut self, input: crate::model::MultiLayerStorage) -> Self {
            self.inner = self.inner.multi_layer_storage(input);
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn set_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::MultiLayerStorage>,
        ) -> Self {
            self.inner = self.inner.set_multi_layer_storage(input);
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn disassociated_data_storage(
            mut self,
            input: crate::model::DisassociatedDataStorageState,
        ) -> Self {
            self.inner = self.inner.disassociated_data_storage(input);
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p> <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important> </li>
        /// <li> <p> <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_disassociated_data_storage(
            mut self,
            input: std::option::Option<crate::model::DisassociatedDataStorageState>,
        ) -> Self {
            self.inner = self.inner.set_disassociated_data_storage(input);
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an IoT SiteWise resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccessPolicy`.
    ///
    /// <p>Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or project resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccessPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_access_policy_input::Builder,
    }
    impl UpdateAccessPolicy {
        /// Creates a new `UpdateAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccessPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, input: crate::model::Identity) -> Self {
            self.inner = self.inner.access_policy_identity(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_identity(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.access_policy_resource(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_resource(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, input: crate::model::Permission) -> Self {
            self.inner = self.inner.access_policy_permission(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_permission(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAsset`.
    ///
    /// <p>Updates an asset's name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAsset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_asset_input::Builder,
    }
    impl UpdateAsset {
        /// Creates a new `UpdateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to update.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset to update.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_name(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssetModel`.
    ///
    /// <p>Updates an asset model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model's property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p> <important>
    /// <p>This operation overwrites the existing model with the provided model. To avoid deleting your asset model's properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a>.</p>
    /// <p>If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that hierarchy. You can't change the type or data type of an existing property.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssetModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_asset_model_input::Builder,
    }
    impl UpdateAssetModel {
        /// Creates a new `UpdateAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model to update.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(input.into());
            self
        }
        /// <p>The ID of the asset model to update.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_name(input);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_description(input.into());
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_description(input);
            self
        }
        /// Appends an item to `assetModelProperties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The updated property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(mut self, input: crate::model::AssetModelProperty) -> Self {
            self.inner = self.inner.asset_model_properties(input);
            self
        }
        /// <p>The updated property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_properties(input);
            self
        }
        /// Appends an item to `assetModelHierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(mut self, input: crate::model::AssetModelHierarchy) -> Self {
            self.inner = self.inner.asset_model_hierarchies(input);
            self
        }
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_hierarchies(input);
            self
        }
        /// Appends an item to `assetModelCompositeModels`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            input: crate::model::AssetModelCompositeModel,
        ) -> Self {
            self.inner = self.inner.asset_model_composite_models(input);
            self
        }
        /// <p>The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties. Each composite model has a type that defines the properties that the composite model supports. Use composite asset models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_composite_models(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssetProperty`.
    ///
    /// <p>Updates an asset property's alias and notification state.</p> <important>
    /// <p>This operation overwrites the property's existing alias and notification state. To keep your existing property's alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssetProperty {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_asset_property_input::Builder,
    }
    impl UpdateAssetProperty {
        /// Creates a new `UpdateAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetPropertyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetPropertyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to be updated.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(input.into());
            self
        }
        /// <p>The ID of the asset to be updated.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(input.into());
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn property_notification_state(
            mut self,
            input: crate::model::PropertyNotificationState,
        ) -> Self {
            self.inner = self.inner.property_notification_state(input);
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn set_property_notification_state(
            mut self,
            input: std::option::Option<crate::model::PropertyNotificationState>,
        ) -> Self {
            self.inner = self.inner.set_property_notification_state(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboard`.
    ///
    /// <p>Updates an IoT SiteWise Monitor dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDashboard {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_dashboard_input::Builder,
    }
    impl UpdateDashboard {
        /// Creates a new `UpdateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard to update.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID of the dashboard to update.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_name(input.into());
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_name(input);
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn dashboard_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_description(input.into());
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_description(input);
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_definition(input.into());
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_definition(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGateway`.
    ///
    /// <p>Updates a gateway's name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_input::Builder,
    }
    impl UpdateGateway {
        /// Creates a new `UpdateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to update.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the gateway to update.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(input.into());
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayCapabilityConfiguration`.
    ///
    /// <p>Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewayCapabilityConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_capability_configuration_input::Builder,
    }
    impl UpdateGatewayCapabilityConfiguration {
        /// Creates a new `UpdateGatewayCapabilityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayCapabilityConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateGatewayCapabilityConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to be updated.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the gateway to be updated.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_namespace(input.into());
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_namespace(input);
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn capability_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_configuration(input.into());
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_capability_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortal`.
    ///
    /// <p>Updates an IoT SiteWise Monitor portal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePortal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_portal_input::Builder,
    }
    impl UpdatePortal {
        /// Creates a new `UpdatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal to update.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(input.into());
            self
        }
        /// <p>The ID of the portal to update.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn portal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_name(input.into());
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_name(input);
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn portal_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_description(input.into());
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_description(input);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_contact_email(input.into());
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_contact_email(input);
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li> <p>An image file. Choose this option to upload a new image.</p> </li>
        /// <li> <p>The ID of an existing image. Choose this option to keep an existing image.</p> </li>
        /// </ul>
        pub fn portal_logo_image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.portal_logo_image(input);
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li> <p>An image file. Choose this option to upload a new image.</p> </li>
        /// <li> <p>The ID of an existing image. Choose this option to keep an existing image.</p> </li>
        /// </ul>
        pub fn set_portal_logo_image(
            mut self,
            input: std::option::Option<crate::model::Image>,
        ) -> Self {
            self.inner = self.inner.set_portal_logo_image(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn notification_sender_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_sender_email(input.into());
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_sender_email(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, input: crate::model::Alarms) -> Self {
            self.inner = self.inner.alarms(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.inner = self.inner.set_alarms(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates an IoT SiteWise Monitor project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_input::Builder,
    }
    impl UpdateProject {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to update.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(input.into());
            self
        }
        /// <p>The ID of the project to update.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A new description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_description(input.into());
            self
        }
        /// <p>A new description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_description(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
