// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateAssetsInput`](crate::input::AssociateAssetsInput)
pub mod associate_assets_input {
    /// A builder for [`AssociateAssetsInput`](crate::input::AssociateAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_id: std::option::Option<std::string::String>,
        pub(crate) child_asset_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the parent asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_id = Some(input.into());
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hierarchy_id = input;
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn child_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.child_asset_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAssetsInput`](crate::input::AssociateAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAssetsInput {
                asset_id: self.asset_id,
                hierarchy_id: self.hierarchy_id,
                child_asset_id: self.child_asset_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAssetsInputOperationOutputAlias = crate::operation::AssociateAssets;
#[doc(hidden)]
pub type AssociateAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateAssetsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAssets`](crate::operation::AssociateAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.asset_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_1, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}/associate", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_assets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateAssetsInput`](crate::input::AssociateAssetsInput)
    pub fn builder() -> crate::input::associate_assets_input::Builder {
        crate::input::associate_assets_input::Builder::default()
    }
}

/// See [`AssociateTimeSeriesToAssetPropertyInput`](crate::input::AssociateTimeSeriesToAssetPropertyInput)
pub mod associate_time_series_to_asset_property_input {
    /// A builder for [`AssociateTimeSeriesToAssetPropertyInput`](crate::input::AssociateTimeSeriesToAssetPropertyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTimeSeriesToAssetPropertyInput`](crate::input::AssociateTimeSeriesToAssetPropertyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTimeSeriesToAssetPropertyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTimeSeriesToAssetPropertyInput {
                alias: self.alias,
                asset_id: self.asset_id,
                property_id: self.property_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTimeSeriesToAssetPropertyInputOperationOutputAlias =
    crate::operation::AssociateTimeSeriesToAssetProperty;
#[doc(hidden)]
pub type AssociateTimeSeriesToAssetPropertyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateTimeSeriesToAssetPropertyInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTimeSeriesToAssetProperty`](crate::operation::AssociateTimeSeriesToAssetProperty)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTimeSeriesToAssetProperty,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateTimeSeriesToAssetPropertyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/timeseries/associate").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateTimeSeriesToAssetPropertyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.alias {
                query.push_kv("alias", &aws_smithy_http::query::fmt_string(&inner_2));
            }
            if let Some(inner_3) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_3));
            }
            if let Some(inner_4) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_4));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateTimeSeriesToAssetPropertyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateTimeSeriesToAssetPropertyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_time_series_to_asset_property(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTimeSeriesToAssetProperty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTimeSeriesToAssetProperty",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateTimeSeriesToAssetPropertyInput`](crate::input::AssociateTimeSeriesToAssetPropertyInput)
    pub fn builder() -> crate::input::associate_time_series_to_asset_property_input::Builder {
        crate::input::associate_time_series_to_asset_property_input::Builder::default()
    }
}

/// See [`BatchAssociateProjectAssetsInput`](crate::input::BatchAssociateProjectAssetsInput)
pub mod batch_associate_project_assets_input {
    /// A builder for [`BatchAssociateProjectAssetsInput`](crate::input::BatchAssociateProjectAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Appends an item to `asset_ids`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn asset_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.asset_ids.unwrap_or_default();
            v.push(input.into());
            self.asset_ids = Some(v);
            self
        }
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.asset_ids = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateProjectAssetsInput`](crate::input::BatchAssociateProjectAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateProjectAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchAssociateProjectAssetsInput {
                project_id: self.project_id,
                asset_ids: self.asset_ids,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateProjectAssetsInputOperationOutputAlias =
    crate::operation::BatchAssociateProjectAssets;
#[doc(hidden)]
pub type BatchAssociateProjectAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchAssociateProjectAssetsInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateProjectAssets`](crate::operation::BatchAssociateProjectAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateProjectAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAssociateProjectAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.project_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_5, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectId}/assets/associate",
                projectId = project_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAssociateProjectAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAssociateProjectAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_project_assets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateProjectAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateProjectAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateProjectAssetsInput`](crate::input::BatchAssociateProjectAssetsInput)
    pub fn builder() -> crate::input::batch_associate_project_assets_input::Builder {
        crate::input::batch_associate_project_assets_input::Builder::default()
    }
}

/// See [`BatchDisassociateProjectAssetsInput`](crate::input::BatchDisassociateProjectAssetsInput)
pub mod batch_disassociate_project_assets_input {
    /// A builder for [`BatchDisassociateProjectAssetsInput`](crate::input::BatchDisassociateProjectAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Appends an item to `asset_ids`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn asset_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.asset_ids.unwrap_or_default();
            v.push(input.into());
            self.asset_ids = Some(v);
            self
        }
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.asset_ids = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateProjectAssetsInput`](crate::input::BatchDisassociateProjectAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateProjectAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDisassociateProjectAssetsInput {
                project_id: self.project_id,
                asset_ids: self.asset_ids,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateProjectAssetsInputOperationOutputAlias =
    crate::operation::BatchDisassociateProjectAssets;
#[doc(hidden)]
pub type BatchDisassociateProjectAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDisassociateProjectAssetsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateProjectAssets`](crate::operation::BatchDisassociateProjectAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateProjectAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisassociateProjectAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.project_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_6, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectId}/assets/disassociate",
                projectId = project_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisassociateProjectAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisassociateProjectAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_project_assets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateProjectAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateProjectAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateProjectAssetsInput`](crate::input::BatchDisassociateProjectAssetsInput)
    pub fn builder() -> crate::input::batch_disassociate_project_assets_input::Builder {
        crate::input::batch_disassociate_project_assets_input::Builder::default()
    }
}

/// See [`BatchPutAssetPropertyValueInput`](crate::input::BatchPutAssetPropertyValueInput)
pub mod batch_put_asset_property_value_input {
    /// A builder for [`BatchPutAssetPropertyValueInput`](crate::input::BatchPutAssetPropertyValueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of asset property value entries for the batch put request. You can specify up to
        /// 10 entries per request.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::PutAssetPropertyValueEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The list of asset property value entries for the batch put request. You can specify up to
        /// 10 entries per request.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutAssetPropertyValueInput`](crate::input::BatchPutAssetPropertyValueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutAssetPropertyValueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutAssetPropertyValueInput {
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutAssetPropertyValueInputOperationOutputAlias =
    crate::operation::BatchPutAssetPropertyValue;
#[doc(hidden)]
pub type BatchPutAssetPropertyValueInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchPutAssetPropertyValueInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutAssetPropertyValue`](crate::operation::BatchPutAssetPropertyValue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutAssetPropertyValue,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchPutAssetPropertyValueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/properties").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchPutAssetPropertyValueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchPutAssetPropertyValueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_put_asset_property_value(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutAssetPropertyValue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutAssetPropertyValue",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchPutAssetPropertyValueInput`](crate::input::BatchPutAssetPropertyValueInput)
    pub fn builder() -> crate::input::batch_put_asset_property_value_input::Builder {
        crate::input::batch_put_asset_property_value_input::Builder::default()
    }
}

/// See [`CreateAccessPolicyInput`](crate::input::CreateAccessPolicyInput)
pub mod create_access_policy_input {
    /// A builder for [`CreateAccessPolicyInput`](crate::input::CreateAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_identity: std::option::Option<crate::model::Identity>,
        pub(crate) access_policy_resource: std::option::Option<crate::model::Resource>,
        pub(crate) access_policy_permission: std::option::Option<crate::model::Permission>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, input: crate::model::Identity) -> Self {
            self.access_policy_identity = Some(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.access_policy_identity = input;
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, input: crate::model::Resource) -> Self {
            self.access_policy_resource = Some(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.access_policy_resource = input;
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, input: crate::model::Permission) -> Self {
            self.access_policy_permission = Some(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.access_policy_permission = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
        /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
        /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPolicyInput`](crate::input::CreateAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessPolicyInput {
                access_policy_identity: self.access_policy_identity,
                access_policy_resource: self.access_policy_resource,
                access_policy_permission: self.access_policy_permission,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessPolicyInputOperationOutputAlias = crate::operation::CreateAccessPolicy;
#[doc(hidden)]
pub type CreateAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessPolicy`](crate::operation::CreateAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/access-policies").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_access_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessPolicy",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessPolicyInput`](crate::input::CreateAccessPolicyInput)
    pub fn builder() -> crate::input::create_access_policy_input::Builder {
        crate::input::create_access_policy_input::Builder::default()
    }
}

/// See [`CreateAssetInput`](crate::input::CreateAssetInput)
pub mod create_asset_input {
    /// A builder for [`CreateAssetInput`](crate::input::CreateAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetInput`](crate::input::CreateAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssetInput {
                asset_name: self.asset_name,
                asset_model_id: self.asset_model_id,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssetInputOperationOutputAlias = crate::operation::CreateAsset;
#[doc(hidden)]
pub type CreateAssetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssetInput {
    /// Consumes the builder and constructs an Operation<[`CreateAsset`](crate::operation::CreateAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAsset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_asset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAsset",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssetInput`](crate::input::CreateAssetInput)
    pub fn builder() -> crate::input::create_asset_input::Builder {
        crate::input::create_asset_input::Builder::default()
    }
}

/// See [`CreateAssetModelInput`](crate::input::CreateAssetModelInput)
pub mod create_asset_model_input {
    /// A builder for [`CreateAssetModelInput`](crate::input::CreateAssetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_description: std::option::Option<std::string::String>,
        pub(crate) asset_model_properties:
            std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
        pub(crate) asset_model_hierarchies:
            std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchyDefinition>>,
        pub(crate) asset_model_composite_models:
            std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModelDefinition>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_name = input;
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_description = Some(input.into());
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_description = input;
            self
        }
        /// Appends an item to `asset_model_properties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(
            mut self,
            input: impl Into<crate::model::AssetModelPropertyDefinition>,
        ) -> Self {
            let mut v = self.asset_model_properties.unwrap_or_default();
            v.push(input.into());
            self.asset_model_properties = Some(v);
            self
        }
        /// <p>The property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
        ) -> Self {
            self.asset_model_properties = input;
            self
        }
        /// Appends an item to `asset_model_hierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
        /// whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(
            mut self,
            input: impl Into<crate::model::AssetModelHierarchyDefinition>,
        ) -> Self {
            let mut v = self.asset_model_hierarchies.unwrap_or_default();
            v.push(input.into());
            self.asset_model_hierarchies = Some(v);
            self
        }
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
        /// whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchyDefinition>>,
        ) -> Self {
            self.asset_model_hierarchies = input;
            self
        }
        /// Appends an item to `asset_model_composite_models`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            input: impl Into<crate::model::AssetModelCompositeModelDefinition>,
        ) -> Self {
            let mut v = self.asset_model_composite_models.unwrap_or_default();
            v.push(input.into());
            self.asset_model_composite_models = Some(v);
            self
        }
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssetModelCompositeModelDefinition>,
            >,
        ) -> Self {
            self.asset_model_composite_models = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssetModelInput`](crate::input::CreateAssetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssetModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssetModelInput {
                asset_model_name: self.asset_model_name,
                asset_model_description: self.asset_model_description,
                asset_model_properties: self.asset_model_properties,
                asset_model_hierarchies: self.asset_model_hierarchies,
                asset_model_composite_models: self.asset_model_composite_models,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssetModelInputOperationOutputAlias = crate::operation::CreateAssetModel;
#[doc(hidden)]
pub type CreateAssetModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssetModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssetModel`](crate::operation::CreateAssetModel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssetModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssetModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/asset-models").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssetModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssetModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_asset_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssetModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssetModel",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssetModelInput`](crate::input::CreateAssetModelInput)
    pub fn builder() -> crate::input::create_asset_model_input::Builder {
        crate::input::create_asset_model_input::Builder::default()
    }
}

/// See [`CreateDashboardInput`](crate::input::CreateDashboardInput)
pub mod create_dashboard_input {
    /// A builder for [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_name: std::option::Option<std::string::String>,
        pub(crate) dashboard_description: std::option::Option<std::string::String>,
        pub(crate) dashboard_definition: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_name = input;
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn dashboard_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_description = Some(input.into());
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_description = input;
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_definition = Some(input.into());
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_definition = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDashboardInput`](crate::input::CreateDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDashboardInput {
                project_id: self.project_id,
                dashboard_name: self.dashboard_name,
                dashboard_description: self.dashboard_description,
                dashboard_definition: self.dashboard_definition,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDashboardInputOperationOutputAlias = crate::operation::CreateDashboard;
#[doc(hidden)]
pub type CreateDashboardInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDashboardInput {
    /// Consumes the builder and constructs an Operation<[`CreateDashboard`](crate::operation::CreateDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDashboard,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/dashboards").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dashboard(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDashboard",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    pub fn builder() -> crate::input::create_dashboard_input::Builder {
        crate::input::create_dashboard_input::Builder::default()
    }
}

/// See [`CreateGatewayInput`](crate::input::CreateGatewayInput)
pub mod create_gateway_input {
    /// A builder for [`CreateGatewayInput`](crate::input::CreateGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_name: std::option::Option<std::string::String>,
        pub(crate) gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn gateway_platform(mut self, input: crate::model::GatewayPlatform) -> Self {
            self.gateway_platform = Some(input);
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn set_gateway_platform(
            mut self,
            input: std::option::Option<crate::model::GatewayPlatform>,
        ) -> Self {
            self.gateway_platform = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayInput`](crate::input::CreateGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGatewayInput {
                gateway_name: self.gateway_name,
                gateway_platform: self.gateway_platform,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGatewayInputOperationOutputAlias = crate::operation::CreateGateway;
#[doc(hidden)]
pub type CreateGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateGateway`](crate::operation::CreateGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/20200301/gateways").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGateway",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGatewayInput`](crate::input::CreateGatewayInput)
    pub fn builder() -> crate::input::create_gateway_input::Builder {
        crate::input::create_gateway_input::Builder::default()
    }
}

/// See [`CreatePortalInput`](crate::input::CreatePortalInput)
pub mod create_portal_input {
    /// A builder for [`CreatePortalInput`](crate::input::CreatePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_name: std::option::Option<std::string::String>,
        pub(crate) portal_description: std::option::Option<std::string::String>,
        pub(crate) portal_contact_email: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) portal_logo_image_file: std::option::Option<crate::model::ImageFile>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) portal_auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) notification_sender_email: std::option::Option<std::string::String>,
        pub(crate) alarms: std::option::Option<crate::model::Alarms>,
    }
    impl Builder {
        /// <p>A friendly name for the portal.</p>
        pub fn portal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_name = input;
            self
        }
        /// <p>A description for the portal.</p>
        pub fn portal_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_description = Some(input.into());
            self
        }
        /// <p>A description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_description = input;
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_contact_email = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_contact_email = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
        /// image is displayed on a dark background.</p>
        pub fn portal_logo_image_file(mut self, input: crate::model::ImageFile) -> Self {
            self.portal_logo_image_file = Some(input);
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
        /// image is displayed on a dark background.</p>
        pub fn set_portal_logo_image_file(
            mut self,
            input: std::option::Option<crate::model::ImageFile>,
        ) -> Self {
            self.portal_logo_image_file = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following
        /// options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
        /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
        /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
        /// the China Regions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
        /// user permissions.</p>
        /// </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code>
        /// </p>
        pub fn portal_auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.portal_auth_mode = Some(input);
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following
        /// options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
        /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
        /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
        /// the China Regions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
        /// user permissions.</p>
        /// </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code>
        /// </p>
        pub fn set_portal_auth_mode(
            mut self,
            input: std::option::Option<crate::model::AuthMode>,
        ) -> Self {
            self.portal_auth_mode = input;
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        /// <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
        /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
        /// address in Amazon SES</a>.</p>
        /// </important>
        pub fn notification_sender_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_sender_email = Some(input.into());
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        /// <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
        /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
        /// address in Amazon SES</a>.</p>
        /// </important>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_sender_email = input;
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, input: crate::model::Alarms) -> Self {
            self.alarms = Some(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePortalInput`](crate::input::CreatePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePortalInput {
                portal_name: self.portal_name,
                portal_description: self.portal_description,
                portal_contact_email: self.portal_contact_email,
                client_token: self.client_token,
                portal_logo_image_file: self.portal_logo_image_file,
                role_arn: self.role_arn,
                tags: self.tags,
                portal_auth_mode: self.portal_auth_mode,
                notification_sender_email: self.notification_sender_email,
                alarms: self.alarms,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePortalInputOperationOutputAlias = crate::operation::CreatePortal;
#[doc(hidden)]
pub type CreatePortalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePortalInput {
    /// Consumes the builder and constructs an Operation<[`CreatePortal`](crate::operation::CreatePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePortal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/portals").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_portal(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePortal",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePortalInput`](crate::input::CreatePortalInput)
    pub fn builder() -> crate::input::create_portal_input::Builder {
        crate::input::create_portal_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>A description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>A description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                portal_id: self.portal_id,
                project_name: self.project_name,
                project_description: self.project_description,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`DeleteAccessPolicyInput`](crate::input::DeleteAccessPolicyInput)
pub mod delete_access_policy_input {
    /// A builder for [`DeleteAccessPolicyInput`](crate::input::DeleteAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPolicyInput`](crate::input::DeleteAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPolicyInput {
                access_policy_id: self.access_policy_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPolicyInputOperationOutputAlias = crate::operation::DeleteAccessPolicy;
#[doc(hidden)]
pub type DeleteAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPolicy`](crate::operation::DeleteAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.access_policy_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_policy_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_policy_id = aws_smithy_http::label::fmt_string(input_7, false);
            if access_policy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_policy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/access-policies/{accessPolicyId}",
                accessPolicyId = access_policy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAccessPolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.client_token {
                query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPolicy",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPolicyInput`](crate::input::DeleteAccessPolicyInput)
    pub fn builder() -> crate::input::delete_access_policy_input::Builder {
        crate::input::delete_access_policy_input::Builder::default()
    }
}

/// See [`DeleteAssetInput`](crate::input::DeleteAssetInput)
pub mod delete_asset_input {
    /// A builder for [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset to delete.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset to delete.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetInput`](crate::input::DeleteAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssetInput {
                asset_id: self.asset_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssetInputOperationOutputAlias = crate::operation::DeleteAsset;
#[doc(hidden)]
pub type DeleteAssetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAsset`](crate::operation::DeleteAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAsset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.asset_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_9, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAssetInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_10) = &_input.client_token {
                query.push_kv(
                    "clientToken",
                    &aws_smithy_http::query::fmt_string(&inner_10),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAsset",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    pub fn builder() -> crate::input::delete_asset_input::Builder {
        crate::input::delete_asset_input::Builder::default()
    }
}

/// See [`DeleteAssetModelInput`](crate::input::DeleteAssetModelInput)
pub mod delete_asset_model_input {
    /// A builder for [`DeleteAssetModelInput`](crate::input::DeleteAssetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset model to delete.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model to delete.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssetModelInput`](crate::input::DeleteAssetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssetModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssetModelInput {
                asset_model_id: self.asset_model_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssetModelInputOperationOutputAlias = crate::operation::DeleteAssetModel;
#[doc(hidden)]
pub type DeleteAssetModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssetModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssetModel`](crate::operation::DeleteAssetModel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssetModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssetModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.asset_model_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_model_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_model_id = aws_smithy_http::label::fmt_string(input_11, false);
            if asset_model_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_model_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/asset-models/{assetModelId}",
                assetModelId = asset_model_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAssetModelInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_12) = &_input.client_token {
                query.push_kv(
                    "clientToken",
                    &aws_smithy_http::query::fmt_string(&inner_12),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssetModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssetModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssetModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssetModel",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssetModelInput`](crate::input::DeleteAssetModelInput)
    pub fn builder() -> crate::input::delete_asset_model_input::Builder {
        crate::input::delete_asset_model_input::Builder::default()
    }
}

/// See [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
pub mod delete_dashboard_input {
    /// A builder for [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dashboard to delete.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard to delete.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDashboardInput {
                dashboard_id: self.dashboard_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDashboardInputOperationOutputAlias = crate::operation::DeleteDashboard;
#[doc(hidden)]
pub type DeleteDashboardInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDashboardInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDashboard`](crate::operation::DeleteDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDashboard,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.dashboard_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_13, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/dashboards/{dashboardId}",
                dashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteDashboardInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.client_token {
                query.push_kv(
                    "clientToken",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDashboard",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    pub fn builder() -> crate::input::delete_dashboard_input::Builder {
        crate::input::delete_dashboard_input::Builder::default()
    }
}

/// See [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
pub mod delete_gateway_input {
    /// A builder for [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway to delete.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway to delete.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGatewayInput {
                gateway_id: self.gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGatewayInputOperationOutputAlias = crate::operation::DeleteGateway;
#[doc(hidden)]
pub type DeleteGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGateway`](crate::operation::DeleteGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.gateway_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let gateway_id = aws_smithy_http::label::fmt_string(input_15, false);
            if gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/20200301/gateways/{gatewayId}",
                gatewayId = gateway_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGateway",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    pub fn builder() -> crate::input::delete_gateway_input::Builder {
        crate::input::delete_gateway_input::Builder::default()
    }
}

/// See [`DeletePortalInput`](crate::input::DeletePortalInput)
pub mod delete_portal_input {
    /// A builder for [`DeletePortalInput`](crate::input::DeletePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the portal to delete.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal to delete.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePortalInput`](crate::input::DeletePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePortalInput {
                portal_id: self.portal_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePortalInputOperationOutputAlias = crate::operation::DeletePortal;
#[doc(hidden)]
pub type DeletePortalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePortalInput {
    /// Consumes the builder and constructs an Operation<[`DeletePortal`](crate::operation::DeletePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePortal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.portal_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_id",
                        details: "cannot be empty or unset",
                    })?;
            let portal_id = aws_smithy_http::label::fmt_string(input_16, false);
            if portal_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalId}", portalId = portal_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeletePortalInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.client_token {
                query.push_kv(
                    "clientToken",
                    &aws_smithy_http::query::fmt_string(&inner_17),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePortal",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePortalInput`](crate::input::DeletePortalInput)
    pub fn builder() -> crate::input::delete_portal_input::Builder {
        crate::input::delete_portal_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project_id: self.project_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.project_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_18, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{projectId}", projectId = project_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteProjectInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.client_token {
                query.push_kv(
                    "clientToken",
                    &aws_smithy_http::query::fmt_string(&inner_19),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DeleteTimeSeriesInput`](crate::input::DeleteTimeSeriesInput)
pub mod delete_time_series_input {
    /// A builder for [`DeleteTimeSeriesInput`](crate::input::DeleteTimeSeriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTimeSeriesInput`](crate::input::DeleteTimeSeriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTimeSeriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTimeSeriesInput {
                alias: self.alias,
                asset_id: self.asset_id,
                property_id: self.property_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTimeSeriesInputOperationOutputAlias = crate::operation::DeleteTimeSeries;
#[doc(hidden)]
pub type DeleteTimeSeriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTimeSeriesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTimeSeries`](crate::operation::DeleteTimeSeries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTimeSeries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTimeSeriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/timeseries/delete").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteTimeSeriesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.alias {
                query.push_kv("alias", &aws_smithy_http::query::fmt_string(&inner_20));
            }
            if let Some(inner_21) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_21));
            }
            if let Some(inner_22) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTimeSeriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTimeSeriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_time_series(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTimeSeries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTimeSeries",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTimeSeriesInput`](crate::input::DeleteTimeSeriesInput)
    pub fn builder() -> crate::input::delete_time_series_input::Builder {
        crate::input::delete_time_series_input::Builder::default()
    }
}

/// See [`DescribeAccessPolicyInput`](crate::input::DescribeAccessPolicyInput)
pub mod describe_access_policy_input {
    /// A builder for [`DescribeAccessPolicyInput`](crate::input::DescribeAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessPolicyInput`](crate::input::DescribeAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccessPolicyInput {
                access_policy_id: self.access_policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccessPolicyInputOperationOutputAlias = crate::operation::DescribeAccessPolicy;
#[doc(hidden)]
pub type DescribeAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccessPolicy`](crate::operation::DescribeAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.access_policy_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_policy_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_policy_id = aws_smithy_http::label::fmt_string(input_23, false);
            if access_policy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_policy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/access-policies/{accessPolicyId}",
                accessPolicyId = access_policy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccessPolicy",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccessPolicyInput`](crate::input::DescribeAccessPolicyInput)
    pub fn builder() -> crate::input::describe_access_policy_input::Builder {
        crate::input::describe_access_policy_input::Builder::default()
    }
}

/// See [`DescribeAssetInput`](crate::input::DescribeAssetInput)
pub mod describe_asset_input {
    /// A builder for [`DescribeAssetInput`](crate::input::DescribeAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetInput`](crate::input::DescribeAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssetInput {
                asset_id: self.asset_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssetInputOperationOutputAlias = crate::operation::DescribeAsset;
#[doc(hidden)]
pub type DescribeAssetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAsset`](crate::operation::DescribeAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAsset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.asset_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_24, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAsset",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssetInput`](crate::input::DescribeAssetInput)
    pub fn builder() -> crate::input::describe_asset_input::Builder {
        crate::input::describe_asset_input::Builder::default()
    }
}

/// See [`DescribeAssetModelInput`](crate::input::DescribeAssetModelInput)
pub mod describe_asset_model_input {
    /// A builder for [`DescribeAssetModelInput`](crate::input::DescribeAssetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset model.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetModelInput`](crate::input::DescribeAssetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssetModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssetModelInput {
                asset_model_id: self.asset_model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssetModelInputOperationOutputAlias = crate::operation::DescribeAssetModel;
#[doc(hidden)]
pub type DescribeAssetModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssetModelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssetModel`](crate::operation::DescribeAssetModel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssetModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssetModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.asset_model_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_model_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_model_id = aws_smithy_http::label::fmt_string(input_25, false);
            if asset_model_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_model_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/asset-models/{assetModelId}",
                assetModelId = asset_model_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssetModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssetModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssetModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssetModel",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssetModelInput`](crate::input::DescribeAssetModelInput)
    pub fn builder() -> crate::input::describe_asset_model_input::Builder {
        crate::input::describe_asset_model_input::Builder::default()
    }
}

/// See [`DescribeAssetPropertyInput`](crate::input::DescribeAssetPropertyInput)
pub mod describe_asset_property_input {
    /// A builder for [`DescribeAssetPropertyInput`](crate::input::DescribeAssetPropertyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssetPropertyInput`](crate::input::DescribeAssetPropertyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssetPropertyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssetPropertyInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssetPropertyInputOperationOutputAlias = crate::operation::DescribeAssetProperty;
#[doc(hidden)]
pub type DescribeAssetPropertyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssetPropertyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssetProperty`](crate::operation::DescribeAssetProperty)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssetProperty,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssetPropertyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.asset_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_26, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.property_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "property_id",
                        details: "cannot be empty or unset",
                    })?;
            let property_id = aws_smithy_http::label::fmt_string(input_27, false);
            if property_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "property_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assets/{assetId}/properties/{propertyId}",
                assetId = asset_id,
                propertyId = property_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssetPropertyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssetPropertyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssetProperty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssetProperty",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssetPropertyInput`](crate::input::DescribeAssetPropertyInput)
    pub fn builder() -> crate::input::describe_asset_property_input::Builder {
        crate::input::describe_asset_property_input::Builder::default()
    }
}

/// See [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
pub mod describe_dashboard_input {
    /// A builder for [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDashboardInput {
                dashboard_id: self.dashboard_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDashboardInputOperationOutputAlias = crate::operation::DescribeDashboard;
#[doc(hidden)]
pub type DescribeDashboardInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDashboardInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDashboard`](crate::operation::DescribeDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDashboard,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.dashboard_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_28, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/dashboards/{dashboardId}",
                dashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDashboard",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    pub fn builder() -> crate::input::describe_dashboard_input::Builder {
        crate::input::describe_dashboard_input::Builder::default()
    }
}

/// See [`DescribeDefaultEncryptionConfigurationInput`](crate::input::DescribeDefaultEncryptionConfigurationInput)
pub mod describe_default_encryption_configuration_input {
    /// A builder for [`DescribeDefaultEncryptionConfigurationInput`](crate::input::DescribeDefaultEncryptionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeDefaultEncryptionConfigurationInput`](crate::input::DescribeDefaultEncryptionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDefaultEncryptionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDefaultEncryptionConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeDefaultEncryptionConfigurationInputOperationOutputAlias =
    crate::operation::DescribeDefaultEncryptionConfiguration;
#[doc(hidden)]
pub type DescribeDefaultEncryptionConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDefaultEncryptionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDefaultEncryptionConfiguration`](crate::operation::DescribeDefaultEncryptionConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDefaultEncryptionConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDefaultEncryptionConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/configuration/account/encryption").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDefaultEncryptionConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDefaultEncryptionConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDefaultEncryptionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDefaultEncryptionConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDefaultEncryptionConfigurationInput`](crate::input::DescribeDefaultEncryptionConfigurationInput)
    pub fn builder() -> crate::input::describe_default_encryption_configuration_input::Builder {
        crate::input::describe_default_encryption_configuration_input::Builder::default()
    }
}

/// See [`DescribeGatewayInput`](crate::input::DescribeGatewayInput)
pub mod describe_gateway_input {
    /// A builder for [`DescribeGatewayInput`](crate::input::DescribeGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway device.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway device.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayInput`](crate::input::DescribeGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGatewayInput {
                gateway_id: self.gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGatewayInputOperationOutputAlias = crate::operation::DescribeGateway;
#[doc(hidden)]
pub type DescribeGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGateway`](crate::operation::DescribeGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.gateway_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let gateway_id = aws_smithy_http::label::fmt_string(input_29, false);
            if gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/20200301/gateways/{gatewayId}",
                gatewayId = gateway_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGateway",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGatewayInput`](crate::input::DescribeGatewayInput)
    pub fn builder() -> crate::input::describe_gateway_input::Builder {
        crate::input::describe_gateway_input::Builder::default()
    }
}

/// See [`DescribeGatewayCapabilityConfigurationInput`](crate::input::DescribeGatewayCapabilityConfigurationInput)
pub mod describe_gateway_capability_configuration_input {
    /// A builder for [`DescribeGatewayCapabilityConfigurationInput`](crate::input::DescribeGatewayCapabilityConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) capability_namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The namespace of the capability configuration.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the capability configuration.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayCapabilityConfigurationInput`](crate::input::DescribeGatewayCapabilityConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGatewayCapabilityConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGatewayCapabilityConfigurationInput {
                gateway_id: self.gateway_id,
                capability_namespace: self.capability_namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGatewayCapabilityConfigurationInputOperationOutputAlias =
    crate::operation::DescribeGatewayCapabilityConfiguration;
#[doc(hidden)]
pub type DescribeGatewayCapabilityConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeGatewayCapabilityConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGatewayCapabilityConfiguration`](crate::operation::DescribeGatewayCapabilityConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGatewayCapabilityConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGatewayCapabilityConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.gateway_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let gateway_id = aws_smithy_http::label::fmt_string(input_30, false);
            if gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.capability_namespace;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "capability_namespace",
                        details: "cannot be empty or unset",
                    })?;
            let capability_namespace = aws_smithy_http::label::fmt_string(input_31, false);
            if capability_namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "capability_namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/20200301/gateways/{gatewayId}/capability/{capabilityNamespace}",
                gatewayId = gateway_id,
                capabilityNamespace = capability_namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGatewayCapabilityConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGatewayCapabilityConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGatewayCapabilityConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGatewayCapabilityConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGatewayCapabilityConfigurationInput`](crate::input::DescribeGatewayCapabilityConfigurationInput)
    pub fn builder() -> crate::input::describe_gateway_capability_configuration_input::Builder {
        crate::input::describe_gateway_capability_configuration_input::Builder::default()
    }
}

/// See [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
pub mod describe_logging_options_input {
    /// A builder for [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoggingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoggingOptionsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeLoggingOptionsInputOperationOutputAlias = crate::operation::DescribeLoggingOptions;
#[doc(hidden)]
pub type DescribeLoggingOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoggingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoggingOptions`](crate::operation::DescribeLoggingOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoggingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoggingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/logging").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoggingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoggingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoggingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoggingOptions",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    pub fn builder() -> crate::input::describe_logging_options_input::Builder {
        crate::input::describe_logging_options_input::Builder::default()
    }
}

/// See [`DescribePortalInput`](crate::input::DescribePortalInput)
pub mod describe_portal_input {
    /// A builder for [`DescribePortalInput`](crate::input::DescribePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePortalInput`](crate::input::DescribePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePortalInput {
                portal_id: self.portal_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePortalInputOperationOutputAlias = crate::operation::DescribePortal;
#[doc(hidden)]
pub type DescribePortalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePortalInput {
    /// Consumes the builder and constructs an Operation<[`DescribePortal`](crate::operation::DescribePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePortal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.portal_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_id",
                        details: "cannot be empty or unset",
                    })?;
            let portal_id = aws_smithy_http::label::fmt_string(input_32, false);
            if portal_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalId}", portalId = portal_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePortal",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePortalInput`](crate::input::DescribePortalInput)
    pub fn builder() -> crate::input::describe_portal_input::Builder {
        crate::input::describe_portal_input::Builder::default()
    }
}

/// See [`DescribeProjectInput`](crate::input::DescribeProjectInput)
pub mod describe_project_input {
    /// A builder for [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectInput`](crate::input::DescribeProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProjectInput {
                project_id: self.project_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProjectInputOperationOutputAlias = crate::operation::DescribeProject;
#[doc(hidden)]
pub type DescribeProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeProjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProject`](crate::operation::DescribeProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.project_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_33, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{projectId}", projectId = project_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProject",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
}

/// See [`DescribeStorageConfigurationInput`](crate::input::DescribeStorageConfigurationInput)
pub mod describe_storage_configuration_input {
    /// A builder for [`DescribeStorageConfigurationInput`](crate::input::DescribeStorageConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeStorageConfigurationInput`](crate::input::DescribeStorageConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStorageConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStorageConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeStorageConfigurationInputOperationOutputAlias =
    crate::operation::DescribeStorageConfiguration;
#[doc(hidden)]
pub type DescribeStorageConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStorageConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStorageConfiguration`](crate::operation::DescribeStorageConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStorageConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStorageConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/configuration/account/storage").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStorageConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStorageConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStorageConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStorageConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStorageConfigurationInput`](crate::input::DescribeStorageConfigurationInput)
    pub fn builder() -> crate::input::describe_storage_configuration_input::Builder {
        crate::input::describe_storage_configuration_input::Builder::default()
    }
}

/// See [`DescribeTimeSeriesInput`](crate::input::DescribeTimeSeriesInput)
pub mod describe_time_series_input {
    /// A builder for [`DescribeTimeSeriesInput`](crate::input::DescribeTimeSeriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTimeSeriesInput`](crate::input::DescribeTimeSeriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTimeSeriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTimeSeriesInput {
                alias: self.alias,
                asset_id: self.asset_id,
                property_id: self.property_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTimeSeriesInputOperationOutputAlias = crate::operation::DescribeTimeSeries;
#[doc(hidden)]
pub type DescribeTimeSeriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTimeSeriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTimeSeries`](crate::operation::DescribeTimeSeries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTimeSeries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTimeSeriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/timeseries/describe").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeTimeSeriesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.alias {
                query.push_kv("alias", &aws_smithy_http::query::fmt_string(&inner_34));
            }
            if let Some(inner_35) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if let Some(inner_36) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTimeSeriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTimeSeriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTimeSeries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTimeSeries",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTimeSeriesInput`](crate::input::DescribeTimeSeriesInput)
    pub fn builder() -> crate::input::describe_time_series_input::Builder {
        crate::input::describe_time_series_input::Builder::default()
    }
}

/// See [`DisassociateAssetsInput`](crate::input::DisassociateAssetsInput)
pub mod disassociate_assets_input {
    /// A builder for [`DisassociateAssetsInput`](crate::input::DisassociateAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_id: std::option::Option<std::string::String>,
        pub(crate) child_asset_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
        /// to identify the correct asset to disassociate. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_id = Some(input.into());
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
        /// to identify the correct asset to disassociate. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hierarchy_id = input;
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn child_asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.child_asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.child_asset_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAssetsInput`](crate::input::DisassociateAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateAssetsInput {
                asset_id: self.asset_id,
                hierarchy_id: self.hierarchy_id,
                child_asset_id: self.child_asset_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateAssetsInputOperationOutputAlias = crate::operation::DisassociateAssets;
#[doc(hidden)]
pub type DisassociateAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateAssetsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateAssets`](crate::operation::DisassociateAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.asset_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_37, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}/disassociate", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_assets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateAssetsInput`](crate::input::DisassociateAssetsInput)
    pub fn builder() -> crate::input::disassociate_assets_input::Builder {
        crate::input::disassociate_assets_input::Builder::default()
    }
}

/// See [`DisassociateTimeSeriesFromAssetPropertyInput`](crate::input::DisassociateTimeSeriesFromAssetPropertyInput)
pub mod disassociate_time_series_from_asset_property_input {
    /// A builder for [`DisassociateTimeSeriesFromAssetPropertyInput`](crate::input::DisassociateTimeSeriesFromAssetPropertyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias that identifies the time series.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the time series.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTimeSeriesFromAssetPropertyInput`](crate::input::DisassociateTimeSeriesFromAssetPropertyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateTimeSeriesFromAssetPropertyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateTimeSeriesFromAssetPropertyInput {
                alias: self.alias,
                asset_id: self.asset_id,
                property_id: self.property_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateTimeSeriesFromAssetPropertyInputOperationOutputAlias =
    crate::operation::DisassociateTimeSeriesFromAssetProperty;
#[doc(hidden)]
pub type DisassociateTimeSeriesFromAssetPropertyInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateTimeSeriesFromAssetPropertyInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateTimeSeriesFromAssetProperty`](crate::operation::DisassociateTimeSeriesFromAssetProperty)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateTimeSeriesFromAssetProperty,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateTimeSeriesFromAssetPropertyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/timeseries/disassociate").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateTimeSeriesFromAssetPropertyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_38) = &_input.alias {
                query.push_kv("alias", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            if let Some(inner_39) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateTimeSeriesFromAssetPropertyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateTimeSeriesFromAssetPropertyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_time_series_from_asset_property(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateTimeSeriesFromAssetProperty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateTimeSeriesFromAssetProperty",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateTimeSeriesFromAssetPropertyInput`](crate::input::DisassociateTimeSeriesFromAssetPropertyInput)
    pub fn builder() -> crate::input::disassociate_time_series_from_asset_property_input::Builder {
        crate::input::disassociate_time_series_from_asset_property_input::Builder::default()
    }
}

/// See [`GetAssetPropertyAggregatesInput`](crate::input::GetAssetPropertyAggregatesInput)
pub mod get_asset_property_aggregates_input {
    /// A builder for [`GetAssetPropertyAggregatesInput`](crate::input::GetAssetPropertyAggregatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) aggregate_types: std::option::Option<std::vec::Vec<crate::model::AggregateType>>,
        pub(crate) resolution: std::option::Option<std::string::String>,
        pub(crate) qualities: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_ordering: std::option::Option<crate::model::TimeOrdering>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// Appends an item to `aggregate_types`.
        ///
        /// To override the contents of this collection use [`set_aggregate_types`](Self::set_aggregate_types).
        ///
        /// <p>The data aggregating function.</p>
        pub fn aggregate_types(mut self, input: impl Into<crate::model::AggregateType>) -> Self {
            let mut v = self.aggregate_types.unwrap_or_default();
            v.push(input.into());
            self.aggregate_types = Some(v);
            self
        }
        /// <p>The data aggregating function.</p>
        pub fn set_aggregate_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregateType>>,
        ) -> Self {
            self.aggregate_types = input;
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn resolution(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution = Some(input.into());
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolution = input;
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, input: impl Into<crate::model::Quality>) -> Self {
            let mut v = self.qualities.unwrap_or_default();
            v.push(input.into());
            self.qualities = Some(v);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.qualities = input;
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn time_ordering(mut self, input: crate::model::TimeOrdering) -> Self {
            self.time_ordering = Some(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.time_ordering = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyAggregatesInput`](crate::input::GetAssetPropertyAggregatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssetPropertyAggregatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssetPropertyAggregatesInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                aggregate_types: self.aggregate_types,
                resolution: self.resolution,
                qualities: self.qualities,
                start_date: self.start_date,
                end_date: self.end_date,
                time_ordering: self.time_ordering,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssetPropertyAggregatesInputOperationOutputAlias =
    crate::operation::GetAssetPropertyAggregates;
#[doc(hidden)]
pub type GetAssetPropertyAggregatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssetPropertyAggregatesInput {
    /// Consumes the builder and constructs an Operation<[`GetAssetPropertyAggregates`](crate::operation::GetAssetPropertyAggregates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssetPropertyAggregates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssetPropertyAggregatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/properties/aggregates").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetAssetPropertyAggregatesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            if let Some(inner_42) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_42));
            }
            if let Some(inner_43) = &_input.property_alias {
                query.push_kv(
                    "propertyAlias",
                    &aws_smithy_http::query::fmt_string(&inner_43),
                );
            }
            if let Some(inner_44) = &_input.aggregate_types {
                for inner_45 in inner_44 {
                    query.push_kv(
                        "aggregateTypes",
                        &aws_smithy_http::query::fmt_string(&inner_45),
                    );
                }
            }
            if let Some(inner_46) = &_input.resolution {
                query.push_kv("resolution", &aws_smithy_http::query::fmt_string(&inner_46));
            }
            if let Some(inner_47) = &_input.qualities {
                for inner_48 in inner_47 {
                    query.push_kv("qualities", &aws_smithy_http::query::fmt_string(&inner_48));
                }
            }
            if let Some(inner_49) = &_input.start_date {
                query.push_kv(
                    "startDate",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_49,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_50) = &_input.end_date {
                query.push_kv(
                    "endDate",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_50,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_51) = &_input.time_ordering {
                query.push_kv(
                    "timeOrdering",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
            if let Some(inner_52) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_52));
            }
            if let Some(inner_53) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_53).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssetPropertyAggregatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssetPropertyAggregatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssetPropertyAggregates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssetPropertyAggregates",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyAggregatesInput`](crate::input::GetAssetPropertyAggregatesInput)
    pub fn builder() -> crate::input::get_asset_property_aggregates_input::Builder {
        crate::input::get_asset_property_aggregates_input::Builder::default()
    }
}

/// See [`GetAssetPropertyValueInput`](crate::input::GetAssetPropertyValueInput)
pub mod get_asset_property_value_input {
    /// A builder for [`GetAssetPropertyValueInput`](crate::input::GetAssetPropertyValueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyValueInput`](crate::input::GetAssetPropertyValueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssetPropertyValueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssetPropertyValueInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssetPropertyValueInputOperationOutputAlias = crate::operation::GetAssetPropertyValue;
#[doc(hidden)]
pub type GetAssetPropertyValueInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssetPropertyValueInput {
    /// Consumes the builder and constructs an Operation<[`GetAssetPropertyValue`](crate::operation::GetAssetPropertyValue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssetPropertyValue,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssetPropertyValueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/properties/latest").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetAssetPropertyValueInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_54) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_54));
            }
            if let Some(inner_55) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_55));
            }
            if let Some(inner_56) = &_input.property_alias {
                query.push_kv(
                    "propertyAlias",
                    &aws_smithy_http::query::fmt_string(&inner_56),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssetPropertyValueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssetPropertyValueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssetPropertyValue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssetPropertyValue",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueInput`](crate::input::GetAssetPropertyValueInput)
    pub fn builder() -> crate::input::get_asset_property_value_input::Builder {
        crate::input::get_asset_property_value_input::Builder::default()
    }
}

/// See [`GetAssetPropertyValueHistoryInput`](crate::input::GetAssetPropertyValueHistoryInput)
pub mod get_asset_property_value_history_input {
    /// A builder for [`GetAssetPropertyValueHistoryInput`](crate::input::GetAssetPropertyValueHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) qualities: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        pub(crate) time_ordering: std::option::Option<crate::model::TimeOrdering>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, input: impl Into<crate::model::Quality>) -> Self {
            let mut v = self.qualities.unwrap_or_default();
            v.push(input.into());
            self.qualities = Some(v);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.qualities = input;
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn time_ordering(mut self, input: crate::model::TimeOrdering) -> Self {
            self.time_ordering = Some(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.time_ordering = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssetPropertyValueHistoryInput`](crate::input::GetAssetPropertyValueHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssetPropertyValueHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssetPropertyValueHistoryInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                start_date: self.start_date,
                end_date: self.end_date,
                qualities: self.qualities,
                time_ordering: self.time_ordering,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssetPropertyValueHistoryInputOperationOutputAlias =
    crate::operation::GetAssetPropertyValueHistory;
#[doc(hidden)]
pub type GetAssetPropertyValueHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssetPropertyValueHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetAssetPropertyValueHistory`](crate::operation::GetAssetPropertyValueHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssetPropertyValueHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssetPropertyValueHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/properties/history").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetAssetPropertyValueHistoryInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_57) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_57));
            }
            if let Some(inner_58) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_58));
            }
            if let Some(inner_59) = &_input.property_alias {
                query.push_kv(
                    "propertyAlias",
                    &aws_smithy_http::query::fmt_string(&inner_59),
                );
            }
            if let Some(inner_60) = &_input.start_date {
                query.push_kv(
                    "startDate",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_60,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_61) = &_input.end_date {
                query.push_kv(
                    "endDate",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_61,
                        aws_smithy_types::date_time::Format::DateTime,
                    )?,
                );
            }
            if let Some(inner_62) = &_input.qualities {
                for inner_63 in inner_62 {
                    query.push_kv("qualities", &aws_smithy_http::query::fmt_string(&inner_63));
                }
            }
            if let Some(inner_64) = &_input.time_ordering {
                query.push_kv(
                    "timeOrdering",
                    &aws_smithy_http::query::fmt_string(&inner_64),
                );
            }
            if let Some(inner_65) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_65));
            }
            if let Some(inner_66) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_66).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssetPropertyValueHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssetPropertyValueHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssetPropertyValueHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssetPropertyValueHistory",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueHistoryInput`](crate::input::GetAssetPropertyValueHistoryInput)
    pub fn builder() -> crate::input::get_asset_property_value_history_input::Builder {
        crate::input::get_asset_property_value_history_input::Builder::default()
    }
}

/// See [`GetInterpolatedAssetPropertyValuesInput`](crate::input::GetInterpolatedAssetPropertyValuesInput)
pub mod get_interpolated_asset_property_values_input {
    /// A builder for [`GetInterpolatedAssetPropertyValuesInput`](crate::input::GetInterpolatedAssetPropertyValuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) start_time_in_seconds: std::option::Option<i64>,
        pub(crate) start_time_offset_in_nanos: std::option::Option<i32>,
        pub(crate) end_time_in_seconds: std::option::Option<i64>,
        pub(crate) end_time_offset_in_nanos: std::option::Option<i32>,
        pub(crate) quality: std::option::Option<crate::model::Quality>,
        pub(crate) interval_in_seconds: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) interval_window_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn start_time_in_seconds(mut self, input: i64) -> Self {
            self.start_time_in_seconds = Some(input);
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn set_start_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.start_time_in_seconds = input;
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn start_time_offset_in_nanos(mut self, input: i32) -> Self {
            self.start_time_offset_in_nanos = Some(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn set_start_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.start_time_offset_in_nanos = input;
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn end_time_in_seconds(mut self, input: i64) -> Self {
            self.end_time_in_seconds = Some(input);
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn set_end_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.end_time_in_seconds = input;
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn end_time_offset_in_nanos(mut self, input: i32) -> Self {
            self.end_time_offset_in_nanos = Some(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn set_end_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.end_time_offset_in_nanos = input;
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
        /// only the asset property values that have a specific quality.</p>
        pub fn quality(mut self, input: crate::model::Quality) -> Self {
            self.quality = Some(input);
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
        /// only the asset property values that have a specific quality.</p>
        pub fn set_quality(mut self, input: std::option::Option<crate::model::Quality>) -> Self {
            self.quality = input;
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
        /// previous one ends.</p>
        pub fn interval_in_seconds(mut self, input: i64) -> Self {
            self.interval_in_seconds = Some(input);
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
        /// previous one ends.</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.interval_in_seconds = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear
        /// interpolation</a>.</p>
        /// <p>For example, you can use this operation to return the interpolated temperature values
        /// for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts
        /// July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM,
        /// the second interpolated value on July 3, 2021, at 9 AM, and so on.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation
        /// carried forward interpolation</p>
        /// <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point
        /// for the previous interval and carries forward this interpolated value until a new data
        /// point is found.</p>
        /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration
        /// of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last
        /// observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first
        /// interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the
        /// same interpolated value for the rest of the days.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear
        /// interpolation</a>.</p>
        /// <p>For example, you can use this operation to return the interpolated temperature values
        /// for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts
        /// July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM,
        /// the second interpolated value on July 3, 2021, at 9 AM, and so on.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation
        /// carried forward interpolation</p>
        /// <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point
        /// for the previous interval and carries forward this interpolated value until a new data
        /// point is found.</p>
        /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration
        /// of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last
        /// observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first
        /// interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the
        /// same interpolated value for the rest of the days.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by
        /// using data points from the timestamp of each interval, minus the window to the timestamp of
        /// each interval plus the window. If not specified, the window ranges between the start time
        /// minus the interval and the end time plus the interval.</p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the
        /// value for the <code>type</code> parameter must be
        /// <code>LINEAR_INTERPOLATION</code>.</p>
        /// </li>
        /// <li>
        /// <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an
        /// interpolated value for the interval. This indicates that there's a gap in the ingested
        /// data points.</p>
        /// </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24
        /// hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a
        /// window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM
        /// plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the
        /// data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to
        /// compute the second interpolated value, and so on. </p>
        pub fn interval_window_in_seconds(mut self, input: i64) -> Self {
            self.interval_window_in_seconds = Some(input);
            self
        }
        /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by
        /// using data points from the timestamp of each interval, minus the window to the timestamp of
        /// each interval plus the window. If not specified, the window ranges between the start time
        /// minus the interval and the end time plus the interval.</p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the
        /// value for the <code>type</code> parameter must be
        /// <code>LINEAR_INTERPOLATION</code>.</p>
        /// </li>
        /// <li>
        /// <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an
        /// interpolated value for the interval. This indicates that there's a gap in the ingested
        /// data points.</p>
        /// </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24
        /// hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a
        /// window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM
        /// plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the
        /// data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to
        /// compute the second interpolated value, and so on. </p>
        pub fn set_interval_window_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.interval_window_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInterpolatedAssetPropertyValuesInput`](crate::input::GetInterpolatedAssetPropertyValuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInterpolatedAssetPropertyValuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInterpolatedAssetPropertyValuesInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                start_time_in_seconds: self.start_time_in_seconds,
                start_time_offset_in_nanos: self.start_time_offset_in_nanos,
                end_time_in_seconds: self.end_time_in_seconds,
                end_time_offset_in_nanos: self.end_time_offset_in_nanos,
                quality: self.quality,
                interval_in_seconds: self.interval_in_seconds,
                next_token: self.next_token,
                max_results: self.max_results,
                r#type: self.r#type,
                interval_window_in_seconds: self.interval_window_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInterpolatedAssetPropertyValuesInputOperationOutputAlias =
    crate::operation::GetInterpolatedAssetPropertyValues;
#[doc(hidden)]
pub type GetInterpolatedAssetPropertyValuesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInterpolatedAssetPropertyValuesInput {
    /// Consumes the builder and constructs an Operation<[`GetInterpolatedAssetPropertyValues`](crate::operation::GetInterpolatedAssetPropertyValues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInterpolatedAssetPropertyValues,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInterpolatedAssetPropertyValuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/properties/interpolated").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetInterpolatedAssetPropertyValuesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_67) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if let Some(inner_68) = &_input.property_id {
                query.push_kv("propertyId", &aws_smithy_http::query::fmt_string(&inner_68));
            }
            if let Some(inner_69) = &_input.property_alias {
                query.push_kv(
                    "propertyAlias",
                    &aws_smithy_http::query::fmt_string(&inner_69),
                );
            }
            if let Some(inner_70) = &_input.start_time_in_seconds {
                query.push_kv(
                    "startTimeInSeconds",
                    aws_smithy_types::primitive::Encoder::from(*inner_70).encode(),
                );
            }
            if let Some(inner_71) = &_input.start_time_offset_in_nanos {
                query.push_kv(
                    "startTimeOffsetInNanos",
                    aws_smithy_types::primitive::Encoder::from(*inner_71).encode(),
                );
            }
            if let Some(inner_72) = &_input.end_time_in_seconds {
                query.push_kv(
                    "endTimeInSeconds",
                    aws_smithy_types::primitive::Encoder::from(*inner_72).encode(),
                );
            }
            if let Some(inner_73) = &_input.end_time_offset_in_nanos {
                query.push_kv(
                    "endTimeOffsetInNanos",
                    aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                );
            }
            if let Some(inner_74) = &_input.quality {
                query.push_kv("quality", &aws_smithy_http::query::fmt_string(&inner_74));
            }
            if let Some(inner_75) = &_input.interval_in_seconds {
                query.push_kv(
                    "intervalInSeconds",
                    aws_smithy_types::primitive::Encoder::from(*inner_75).encode(),
                );
            }
            if let Some(inner_76) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_76));
            }
            if let Some(inner_77) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_77).encode(),
                );
            }
            if let Some(inner_78) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_78));
            }
            if let Some(inner_79) = &_input.interval_window_in_seconds {
                query.push_kv(
                    "intervalWindowInSeconds",
                    aws_smithy_types::primitive::Encoder::from(*inner_79).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInterpolatedAssetPropertyValuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInterpolatedAssetPropertyValuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("data.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInterpolatedAssetPropertyValues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInterpolatedAssetPropertyValues",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInterpolatedAssetPropertyValuesInput`](crate::input::GetInterpolatedAssetPropertyValuesInput)
    pub fn builder() -> crate::input::get_interpolated_asset_property_values_input::Builder {
        crate::input::get_interpolated_asset_property_values_input::Builder::default()
    }
}

/// See [`ListAccessPoliciesInput`](crate::input::ListAccessPoliciesInput)
pub mod list_access_policies_input {
    /// A builder for [`ListAccessPoliciesInput`](crate::input::ListAccessPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) identity_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) iam_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
        /// if you specify <code>identityId</code>.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
        /// if you specify <code>identityId</code>.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
        /// <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn identity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_id = Some(input.into());
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
        /// <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity_id = input;
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify
        /// <code>resourceId</code>.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify
        /// <code>resourceId</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify
        /// <code>resourceType</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify
        /// <code>resourceType</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
        /// <i>IAM User Guide</i>. This parameter is required if you specify
        /// <code>IAM</code> for <code>identityType</code>.</p>
        pub fn iam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
        /// <i>IAM User Guide</i>. This parameter is required if you specify
        /// <code>IAM</code> for <code>identityType</code>.</p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_arn = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPoliciesInput`](crate::input::ListAccessPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessPoliciesInput {
                identity_type: self.identity_type,
                identity_id: self.identity_id,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                iam_arn: self.iam_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessPoliciesInputOperationOutputAlias = crate::operation::ListAccessPolicies;
#[doc(hidden)]
pub type ListAccessPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccessPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessPolicies`](crate::operation::ListAccessPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/access-policies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAccessPoliciesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_80) = &_input.identity_type {
                query.push_kv(
                    "identityType",
                    &aws_smithy_http::query::fmt_string(&inner_80),
                );
            }
            if let Some(inner_81) = &_input.identity_id {
                query.push_kv("identityId", &aws_smithy_http::query::fmt_string(&inner_81));
            }
            if let Some(inner_82) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_82),
                );
            }
            if let Some(inner_83) = &_input.resource_id {
                query.push_kv("resourceId", &aws_smithy_http::query::fmt_string(&inner_83));
            }
            if let Some(inner_84) = &_input.iam_arn {
                query.push_kv("iamArn", &aws_smithy_http::query::fmt_string(&inner_84));
            }
            if let Some(inner_85) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_85));
            }
            if let Some(inner_86) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_86).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessPolicies",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessPoliciesInput`](crate::input::ListAccessPoliciesInput)
    pub fn builder() -> crate::input::list_access_policies_input::Builder {
        crate::input::list_access_policies_input::Builder::default()
    }
}

/// See [`ListAssetModelsInput`](crate::input::ListAssetModelsInput)
pub mod list_asset_models_input {
    /// A builder for [`ListAssetModelsInput`](crate::input::ListAssetModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetModelsInput`](crate::input::ListAssetModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssetModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssetModelsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssetModelsInputOperationOutputAlias = crate::operation::ListAssetModels;
#[doc(hidden)]
pub type ListAssetModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssetModelsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssetModels`](crate::operation::ListAssetModels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssetModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssetModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/asset-models").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssetModelsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_87) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_87));
            }
            if let Some(inner_88) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_88).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssetModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssetModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssetModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssetModels",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssetModelsInput`](crate::input::ListAssetModelsInput)
    pub fn builder() -> crate::input::list_asset_models_input::Builder {
        crate::input::list_asset_models_input::Builder::default()
    }
}

/// See [`ListAssetRelationshipsInput`](crate::input::ListAssetRelationshipsInput)
pub mod list_asset_relationships_input {
    /// A builder for [`ListAssetRelationshipsInput`](crate::input::ListAssetRelationshipsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) traversal_type: std::option::Option<crate::model::TraversalType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following
        /// option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
        /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
        /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
        /// </li>
        /// </ul>
        pub fn traversal_type(mut self, input: crate::model::TraversalType) -> Self {
            self.traversal_type = Some(input);
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following
        /// option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
        /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
        /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
        /// </li>
        /// </ul>
        pub fn set_traversal_type(
            mut self,
            input: std::option::Option<crate::model::TraversalType>,
        ) -> Self {
            self.traversal_type = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetRelationshipsInput`](crate::input::ListAssetRelationshipsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssetRelationshipsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssetRelationshipsInput {
                asset_id: self.asset_id,
                traversal_type: self.traversal_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssetRelationshipsInputOperationOutputAlias = crate::operation::ListAssetRelationships;
#[doc(hidden)]
pub type ListAssetRelationshipsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssetRelationshipsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssetRelationships`](crate::operation::ListAssetRelationships)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssetRelationships,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssetRelationshipsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_89 = &_input.asset_id;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_89, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assets/{assetId}/assetRelationships",
                assetId = asset_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssetRelationshipsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_90) = &_input.traversal_type {
                query.push_kv(
                    "traversalType",
                    &aws_smithy_http::query::fmt_string(&inner_90),
                );
            }
            if let Some(inner_91) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_91));
            }
            if let Some(inner_92) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_92).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssetRelationshipsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssetRelationshipsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssetRelationships::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssetRelationships",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssetRelationshipsInput`](crate::input::ListAssetRelationshipsInput)
    pub fn builder() -> crate::input::list_asset_relationships_input::Builder {
        crate::input::list_asset_relationships_input::Builder::default()
    }
}

/// See [`ListAssetsInput`](crate::input::ListAssetsInput)
pub mod list_assets_input {
    /// A builder for [`ListAssetsInput`](crate::input::ListAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::ListAssetsFilter>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
        /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
        /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
        /// <code>assetModelId</code> parameter is required if you filter by
        /// <code>ALL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
        /// hierarchy tree.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>ALL</code>
        /// </p>
        pub fn filter(mut self, input: crate::model::ListAssetsFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
        /// <code>assetModelId</code> parameter is required if you filter by
        /// <code>ALL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
        /// hierarchy tree.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>ALL</code>
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListAssetsFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssetsInput`](crate::input::ListAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssetsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                asset_model_id: self.asset_model_id,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssetsInputOperationOutputAlias = crate::operation::ListAssets;
#[doc(hidden)]
pub type ListAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssets`](crate::operation::ListAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_93) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_93));
            }
            if let Some(inner_94) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_94).encode(),
                );
            }
            if let Some(inner_95) = &_input.asset_model_id {
                query.push_kv(
                    "assetModelId",
                    &aws_smithy_http::query::fmt_string(&inner_95),
                );
            }
            if let Some(inner_96) = &_input.filter {
                query.push_kv("filter", &aws_smithy_http::query::fmt_string(&inner_96));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssetsInput`](crate::input::ListAssetsInput)
    pub fn builder() -> crate::input::list_assets_input::Builder {
        crate::input::list_assets_input::Builder::default()
    }
}

/// See [`ListAssociatedAssetsInput`](crate::input::ListAssociatedAssetsInput)
pub mod list_associated_assets_input {
    /// A builder for [`ListAssociatedAssetsInput`](crate::input::ListAssociatedAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_id: std::option::Option<std::string::String>,
        pub(crate) traversal_direction: std::option::Option<crate::model::TraversalDirection>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the asset to query.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset to query.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
        /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
        /// parameter is required if you choose <code>CHILD</code> for
        /// <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_id = Some(input.into());
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
        /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
        /// parameter is required if you choose <code>CHILD</code> for
        /// <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hierarchy_id = input;
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHILD</code> – The list includes all child assets associated to the
        /// asset. The <code>hierarchyId</code> parameter is required if you choose
        /// <code>CHILD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code>
        /// </p>
        pub fn traversal_direction(mut self, input: crate::model::TraversalDirection) -> Self {
            self.traversal_direction = Some(input);
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHILD</code> – The list includes all child assets associated to the
        /// asset. The <code>hierarchyId</code> parameter is required if you choose
        /// <code>CHILD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code>
        /// </p>
        pub fn set_traversal_direction(
            mut self,
            input: std::option::Option<crate::model::TraversalDirection>,
        ) -> Self {
            self.traversal_direction = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedAssetsInput`](crate::input::ListAssociatedAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociatedAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociatedAssetsInput {
                asset_id: self.asset_id,
                hierarchy_id: self.hierarchy_id,
                traversal_direction: self.traversal_direction,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociatedAssetsInputOperationOutputAlias = crate::operation::ListAssociatedAssets;
#[doc(hidden)]
pub type ListAssociatedAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssociatedAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociatedAssets`](crate::operation::ListAssociatedAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociatedAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssociatedAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_97 = &_input.asset_id;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_97, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}/hierarchies", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssociatedAssetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_98) = &_input.hierarchy_id {
                query.push_kv(
                    "hierarchyId",
                    &aws_smithy_http::query::fmt_string(&inner_98),
                );
            }
            if let Some(inner_99) = &_input.traversal_direction {
                query.push_kv(
                    "traversalDirection",
                    &aws_smithy_http::query::fmt_string(&inner_99),
                );
            }
            if let Some(inner_100) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_100));
            }
            if let Some(inner_101) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_101).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssociatedAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssociatedAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociatedAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociatedAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssociatedAssetsInput`](crate::input::ListAssociatedAssetsInput)
    pub fn builder() -> crate::input::list_associated_assets_input::Builder {
        crate::input::list_associated_assets_input::Builder::default()
    }
}

/// See [`ListDashboardsInput`](crate::input::ListDashboardsInput)
pub mod list_dashboards_input {
    /// A builder for [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardsInput`](crate::input::ListDashboardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDashboardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDashboardsInput {
                project_id: self.project_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDashboardsInputOperationOutputAlias = crate::operation::ListDashboards;
#[doc(hidden)]
pub type ListDashboardsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDashboardsInput {
    /// Consumes the builder and constructs an Operation<[`ListDashboards`](crate::operation::ListDashboards)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDashboards,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDashboardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/dashboards").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDashboardsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_102) = &_input.project_id {
                query.push_kv("projectId", &aws_smithy_http::query::fmt_string(&inner_102));
            }
            if let Some(inner_103) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_103));
            }
            if let Some(inner_104) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_104).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDashboardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDashboardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDashboards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDashboards",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    pub fn builder() -> crate::input::list_dashboards_input::Builder {
        crate::input::list_dashboards_input::Builder::default()
    }
}

/// See [`ListGatewaysInput`](crate::input::ListGatewaysInput)
pub mod list_gateways_input {
    /// A builder for [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewaysInput`](crate::input::ListGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGatewaysInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGatewaysInputOperationOutputAlias = crate::operation::ListGateways;
#[doc(hidden)]
pub type ListGatewaysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`ListGateways`](crate::operation::ListGateways)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGateways,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGatewaysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/20200301/gateways").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListGatewaysInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_105) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_105));
            }
            if let Some(inner_106) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_106).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGatewaysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGatewaysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGateways",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
}

/// See [`ListPortalsInput`](crate::input::ListPortalsInput)
pub mod list_portals_input {
    /// A builder for [`ListPortalsInput`](crate::input::ListPortalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPortalsInput`](crate::input::ListPortalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPortalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPortalsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPortalsInputOperationOutputAlias = crate::operation::ListPortals;
#[doc(hidden)]
pub type ListPortalsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPortalsInput {
    /// Consumes the builder and constructs an Operation<[`ListPortals`](crate::operation::ListPortals)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPortals,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPortalsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/portals").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPortalsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_107) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_107));
            }
            if let Some(inner_108) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_108).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPortalsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPortalsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPortals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPortals",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPortalsInput`](crate::input::ListPortalsInput)
    pub fn builder() -> crate::input::list_portals_input::Builder {
        crate::input::list_portals_input::Builder::default()
    }
}

/// See [`ListProjectAssetsInput`](crate::input::ListProjectAssetsInput)
pub mod list_project_assets_input {
    /// A builder for [`ListProjectAssetsInput`](crate::input::ListProjectAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectAssetsInput`](crate::input::ListProjectAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectAssetsInput {
                project_id: self.project_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectAssetsInputOperationOutputAlias = crate::operation::ListProjectAssets;
#[doc(hidden)]
pub type ListProjectAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProjectAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjectAssets`](crate::operation::ListProjectAssets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjectAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_109 = &_input.project_id;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_109, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectId}/assets",
                projectId = project_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListProjectAssetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_110) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_110));
            }
            if let Some(inner_111) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_111).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjectAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjectAssets",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectAssetsInput`](crate::input::ListProjectAssetsInput)
    pub fn builder() -> crate::input::list_project_assets_input::Builder {
        crate::input::list_project_assets_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                portal_id: self.portal_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListProjectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_112) = &_input.portal_id {
                query.push_kv("portalId", &aws_smithy_http::query::fmt_string(&inner_112));
            }
            if let Some(inner_113) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_113));
            }
            if let Some(inner_114) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_114).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTagsForResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_115) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_115),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTimeSeriesInput`](crate::input::ListTimeSeriesInput)
pub mod list_time_series_input {
    /// A builder for [`ListTimeSeriesInput`](crate::input::ListTimeSeriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) alias_prefix: std::option::Option<std::string::String>,
        pub(crate) time_series_type: std::option::Option<crate::model::ListTimeSeriesType>,
    }
    impl Builder {
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset in which the asset property was created.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The alias prefix of the time series.</p>
        pub fn alias_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_prefix = Some(input.into());
            self
        }
        /// <p>The alias prefix of the time series.</p>
        pub fn set_alias_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_prefix = input;
            self
        }
        /// <p>The type of the time series. The time series type can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASSOCIATED</code> – The time series is associated with an asset
        /// property.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISASSOCIATED</code> – The time series isn't associated with any asset
        /// property.</p>
        /// </li>
        /// </ul>
        pub fn time_series_type(mut self, input: crate::model::ListTimeSeriesType) -> Self {
            self.time_series_type = Some(input);
            self
        }
        /// <p>The type of the time series. The time series type can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASSOCIATED</code> – The time series is associated with an asset
        /// property.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISASSOCIATED</code> – The time series isn't associated with any asset
        /// property.</p>
        /// </li>
        /// </ul>
        pub fn set_time_series_type(
            mut self,
            input: std::option::Option<crate::model::ListTimeSeriesType>,
        ) -> Self {
            self.time_series_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTimeSeriesInput`](crate::input::ListTimeSeriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTimeSeriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTimeSeriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                asset_id: self.asset_id,
                alias_prefix: self.alias_prefix,
                time_series_type: self.time_series_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTimeSeriesInputOperationOutputAlias = crate::operation::ListTimeSeries;
#[doc(hidden)]
pub type ListTimeSeriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTimeSeriesInput {
    /// Consumes the builder and constructs an Operation<[`ListTimeSeries`](crate::operation::ListTimeSeries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTimeSeries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTimeSeriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/timeseries").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTimeSeriesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_116) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_116));
            }
            if let Some(inner_117) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_117).encode(),
                );
            }
            if let Some(inner_118) = &_input.asset_id {
                query.push_kv("assetId", &aws_smithy_http::query::fmt_string(&inner_118));
            }
            if let Some(inner_119) = &_input.alias_prefix {
                query.push_kv(
                    "aliasPrefix",
                    &aws_smithy_http::query::fmt_string(&inner_119),
                );
            }
            if let Some(inner_120) = &_input.time_series_type {
                query.push_kv(
                    "timeSeriesType",
                    &aws_smithy_http::query::fmt_string(&inner_120),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTimeSeriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTimeSeriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTimeSeries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTimeSeries",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTimeSeriesInput`](crate::input::ListTimeSeriesInput)
    pub fn builder() -> crate::input::list_time_series_input::Builder {
        crate::input::list_time_series_input::Builder::default()
    }
}

/// See [`PutDefaultEncryptionConfigurationInput`](crate::input::PutDefaultEncryptionConfigurationInput)
pub mod put_default_encryption_configuration_input {
    /// A builder for [`PutDefaultEncryptionConfigurationInput`](crate::input::PutDefaultEncryptionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you
        /// use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you
        /// use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDefaultEncryptionConfigurationInput`](crate::input::PutDefaultEncryptionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDefaultEncryptionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDefaultEncryptionConfigurationInput {
                encryption_type: self.encryption_type,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDefaultEncryptionConfigurationInputOperationOutputAlias =
    crate::operation::PutDefaultEncryptionConfiguration;
#[doc(hidden)]
pub type PutDefaultEncryptionConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutDefaultEncryptionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutDefaultEncryptionConfiguration`](crate::operation::PutDefaultEncryptionConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDefaultEncryptionConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutDefaultEncryptionConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/configuration/account/encryption").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutDefaultEncryptionConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutDefaultEncryptionConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_default_encryption_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDefaultEncryptionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDefaultEncryptionConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutDefaultEncryptionConfigurationInput`](crate::input::PutDefaultEncryptionConfigurationInput)
    pub fn builder() -> crate::input::put_default_encryption_configuration_input::Builder {
        crate::input::put_default_encryption_configuration_input::Builder::default()
    }
}

/// See [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
pub mod put_logging_options_input {
    /// A builder for [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_options: std::option::Option<crate::model::LoggingOptions>,
    }
    impl Builder {
        /// <p>The logging options to set.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.logging_options = Some(input);
            self
        }
        /// <p>The logging options to set.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLoggingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLoggingOptionsInput {
                logging_options: self.logging_options,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLoggingOptionsInputOperationOutputAlias = crate::operation::PutLoggingOptions;
#[doc(hidden)]
pub type PutLoggingOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLoggingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutLoggingOptions`](crate::operation::PutLoggingOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLoggingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLoggingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/logging").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLoggingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLoggingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_logging_options(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLoggingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLoggingOptions",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    pub fn builder() -> crate::input::put_logging_options_input::Builder {
        crate::input::put_logging_options_input::Builder::default()
    }
}

/// See [`PutStorageConfigurationInput`](crate::input::PutStorageConfigurationInput)
pub mod put_storage_configuration_input {
    /// A builder for [`PutStorageConfigurationInput`](crate::input::PutStorageConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type: std::option::Option<crate::model::StorageType>,
        pub(crate) multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
        pub(crate) disassociated_data_storage:
            std::option::Option<crate::model::DisassociatedDataStorageState>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
    }
    impl Builder {
        /// <p>The storage tier that you specified for your data.
        /// The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier.
        /// The hot tier is a service-managed database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier.
        /// The cold tier is a customer-managed Amazon S3 bucket.</p>
        /// </li>
        /// </ul>
        pub fn storage_type(mut self, input: crate::model::StorageType) -> Self {
            self.storage_type = Some(input);
            self
        }
        /// <p>The storage tier that you specified for your data.
        /// The <code>storageType</code> parameter can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier.
        /// The hot tier is a service-managed database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier.
        /// The cold tier is a customer-managed Amazon S3 bucket.</p>
        /// </li>
        /// </ul>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
        /// you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn multi_layer_storage(mut self, input: crate::model::MultiLayerStorage) -> Self {
            self.multi_layer_storage = Some(input);
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
        /// you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn set_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::MultiLayerStorage>,
        ) -> Self {
            self.multi_layer_storage = input;
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
        /// The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p>
        /// <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a>
        /// in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn disassociated_data_storage(
            mut self,
            input: crate::model::DisassociatedDataStorageState,
        ) -> Self {
            self.disassociated_data_storage = Some(input);
            self
        }
        /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
        /// The <code>disassociatedDataStorage</code> can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p>
        /// <important>
        /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a>
        /// in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_disassociated_data_storage(
            mut self,
            input: std::option::Option<crate::model::DisassociatedDataStorageState>,
        ) -> Self {
            self.disassociated_data_storage = input;
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStorageConfigurationInput`](crate::input::PutStorageConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutStorageConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutStorageConfigurationInput {
                storage_type: self.storage_type,
                multi_layer_storage: self.multi_layer_storage,
                disassociated_data_storage: self.disassociated_data_storage,
                retention_period: self.retention_period,
            })
        }
    }
}
#[doc(hidden)]
pub type PutStorageConfigurationInputOperationOutputAlias =
    crate::operation::PutStorageConfiguration;
#[doc(hidden)]
pub type PutStorageConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutStorageConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutStorageConfiguration`](crate::operation::PutStorageConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutStorageConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutStorageConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/configuration/account/storage").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutStorageConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutStorageConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_storage_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutStorageConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutStorageConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutStorageConfigurationInput`](crate::input::PutStorageConfigurationInput)
    pub fn builder() -> crate::input::put_storage_configuration_input::Builder {
        crate::input::put_storage_configuration_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::TagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_121) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_121),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_122) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_122),
                );
            }
            if let Some(inner_123) = &_input.tag_keys {
                for inner_124 in inner_123 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_124));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAccessPolicyInput`](crate::input::UpdateAccessPolicyInput)
pub mod update_access_policy_input {
    /// A builder for [`UpdateAccessPolicyInput`](crate::input::UpdateAccessPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policy_id: std::option::Option<std::string::String>,
        pub(crate) access_policy_identity: std::option::Option<crate::model::Identity>,
        pub(crate) access_policy_resource: std::option::Option<crate::model::Resource>,
        pub(crate) access_policy_permission: std::option::Option<crate::model::Permission>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy_id = input;
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, input: crate::model::Identity) -> Self {
            self.access_policy_identity = Some(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.access_policy_identity = input;
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, input: crate::model::Resource) -> Self {
            self.access_policy_resource = Some(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.access_policy_resource = input;
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, input: crate::model::Permission) -> Self {
            self.access_policy_permission = Some(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.access_policy_permission = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccessPolicyInput`](crate::input::UpdateAccessPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccessPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccessPolicyInput {
                access_policy_id: self.access_policy_id,
                access_policy_identity: self.access_policy_identity,
                access_policy_resource: self.access_policy_resource,
                access_policy_permission: self.access_policy_permission,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccessPolicyInputOperationOutputAlias = crate::operation::UpdateAccessPolicy;
#[doc(hidden)]
pub type UpdateAccessPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAccessPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccessPolicy`](crate::operation::UpdateAccessPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccessPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccessPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_125 = &_input.access_policy_id;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_policy_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_policy_id = aws_smithy_http::label::fmt_string(input_125, false);
            if access_policy_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_policy_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/access-policies/{accessPolicyId}",
                accessPolicyId = access_policy_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccessPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccessPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_access_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccessPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccessPolicy",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccessPolicyInput`](crate::input::UpdateAccessPolicyInput)
    pub fn builder() -> crate::input::update_access_policy_input::Builder {
        crate::input::update_access_policy_input::Builder::default()
    }
}

/// See [`UpdateAssetInput`](crate::input::UpdateAssetInput)
pub mod update_asset_input {
    /// A builder for [`UpdateAssetInput`](crate::input::UpdateAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset to update.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset to update.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetInput`](crate::input::UpdateAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssetInput {
                asset_id: self.asset_id,
                asset_name: self.asset_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssetInputOperationOutputAlias = crate::operation::UpdateAsset;
#[doc(hidden)]
pub type UpdateAssetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAsset`](crate::operation::UpdateAsset)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAsset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_126 = &_input.asset_id;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_126, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assets/{assetId}", assetId = asset_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_asset(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAsset",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssetInput`](crate::input::UpdateAssetInput)
    pub fn builder() -> crate::input::update_asset_input::Builder {
        crate::input::update_asset_input::Builder::default()
    }
}

/// See [`UpdateAssetModelInput`](crate::input::UpdateAssetModelInput)
pub mod update_asset_model_input {
    /// A builder for [`UpdateAssetModelInput`](crate::input::UpdateAssetModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) asset_model_name: std::option::Option<std::string::String>,
        pub(crate) asset_model_description: std::option::Option<std::string::String>,
        pub(crate) asset_model_properties:
            std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        pub(crate) asset_model_hierarchies:
            std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        pub(crate) asset_model_composite_models:
            std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset model to update.</p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset model to update.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_name = input;
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_description = Some(input.into());
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_description = input;
            self
        }
        /// Appends an item to `asset_model_properties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The updated property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(
            mut self,
            input: impl Into<crate::model::AssetModelProperty>,
        ) -> Self {
            let mut v = self.asset_model_properties.unwrap_or_default();
            v.push(input.into());
            self.asset_model_properties = Some(v);
            self
        }
        /// <p>The updated property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        ) -> Self {
            self.asset_model_properties = input;
            self
        }
        /// Appends an item to `asset_model_hierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
        /// model whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(
            mut self,
            input: impl Into<crate::model::AssetModelHierarchy>,
        ) -> Self {
            let mut v = self.asset_model_hierarchies.unwrap_or_default();
            v.push(input.into());
            self.asset_model_hierarchies = Some(v);
            self
        }
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
        /// model whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        ) -> Self {
            self.asset_model_hierarchies = input;
            self
        }
        /// Appends an item to `asset_model_composite_models`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            input: impl Into<crate::model::AssetModelCompositeModel>,
        ) -> Self {
            let mut v = self.asset_model_composite_models.unwrap_or_default();
            v.push(input.into());
            self.asset_model_composite_models = Some(v);
            self
        }
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        ) -> Self {
            self.asset_model_composite_models = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetModelInput`](crate::input::UpdateAssetModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssetModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssetModelInput {
                asset_model_id: self.asset_model_id,
                asset_model_name: self.asset_model_name,
                asset_model_description: self.asset_model_description,
                asset_model_properties: self.asset_model_properties,
                asset_model_hierarchies: self.asset_model_hierarchies,
                asset_model_composite_models: self.asset_model_composite_models,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssetModelInputOperationOutputAlias = crate::operation::UpdateAssetModel;
#[doc(hidden)]
pub type UpdateAssetModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssetModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssetModel`](crate::operation::UpdateAssetModel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssetModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssetModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_127 = &_input.asset_model_id;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_model_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_model_id = aws_smithy_http::label::fmt_string(input_127, false);
            if asset_model_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_model_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/asset-models/{assetModelId}",
                assetModelId = asset_model_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssetModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssetModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_asset_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssetModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssetModel",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssetModelInput`](crate::input::UpdateAssetModelInput)
    pub fn builder() -> crate::input::update_asset_model_input::Builder {
        crate::input::update_asset_model_input::Builder::default()
    }
}

/// See [`UpdateAssetPropertyInput`](crate::input::UpdateAssetPropertyInput)
pub mod update_asset_property_input {
    /// A builder for [`UpdateAssetPropertyInput`](crate::input::UpdateAssetPropertyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) property_notification_state:
            std::option::Option<crate::model::PropertyNotificationState>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the asset to be updated.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset to be updated.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property.
        /// When the notification state is enabled, IoT SiteWise publishes property value
        /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn property_notification_state(
            mut self,
            input: crate::model::PropertyNotificationState,
        ) -> Self {
            self.property_notification_state = Some(input);
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property.
        /// When the notification state is enabled, IoT SiteWise publishes property value
        /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn set_property_notification_state(
            mut self,
            input: std::option::Option<crate::model::PropertyNotificationState>,
        ) -> Self {
            self.property_notification_state = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssetPropertyInput`](crate::input::UpdateAssetPropertyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssetPropertyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssetPropertyInput {
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                property_notification_state: self.property_notification_state,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssetPropertyInputOperationOutputAlias = crate::operation::UpdateAssetProperty;
#[doc(hidden)]
pub type UpdateAssetPropertyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssetPropertyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssetProperty`](crate::operation::UpdateAssetProperty)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssetProperty,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssetPropertyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_128 = &_input.asset_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "asset_id",
                        details: "cannot be empty or unset",
                    })?;
            let asset_id = aws_smithy_http::label::fmt_string(input_128, false);
            if asset_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "asset_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_129 = &_input.property_id;
            let input_129 =
                input_129
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "property_id",
                        details: "cannot be empty or unset",
                    })?;
            let property_id = aws_smithy_http::label::fmt_string(input_129, false);
            if property_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "property_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assets/{assetId}/properties/{propertyId}",
                assetId = asset_id,
                propertyId = property_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssetPropertyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssetPropertyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_asset_property(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssetProperty::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssetProperty",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssetPropertyInput`](crate::input::UpdateAssetPropertyInput)
    pub fn builder() -> crate::input::update_asset_property_input::Builder {
        crate::input::update_asset_property_input::Builder::default()
    }
}

/// See [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
pub mod update_dashboard_input {
    /// A builder for [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_name: std::option::Option<std::string::String>,
        pub(crate) dashboard_description: std::option::Option<std::string::String>,
        pub(crate) dashboard_definition: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the dashboard to update.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard to update.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_name = Some(input.into());
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_name = input;
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn dashboard_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_description = Some(input.into());
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_description = input;
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_definition = Some(input.into());
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_definition = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDashboardInput {
                dashboard_id: self.dashboard_id,
                dashboard_name: self.dashboard_name,
                dashboard_description: self.dashboard_description,
                dashboard_definition: self.dashboard_definition,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDashboardInputOperationOutputAlias = crate::operation::UpdateDashboard;
#[doc(hidden)]
pub type UpdateDashboardInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDashboardInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDashboard`](crate::operation::UpdateDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDashboard,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_130 = &_input.dashboard_id;
            let input_130 =
                input_130
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_130, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/dashboards/{dashboardId}",
                dashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_dashboard(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDashboard",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    pub fn builder() -> crate::input::update_dashboard_input::Builder {
        crate::input::update_dashboard_input::Builder::default()
    }
}

/// See [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
pub mod update_gateway_input {
    /// A builder for [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway to update.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway to update.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_name = Some(input.into());
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayInput {
                gateway_id: self.gateway_id,
                gateway_name: self.gateway_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayInputOperationOutputAlias = crate::operation::UpdateGateway;
#[doc(hidden)]
pub type UpdateGatewayInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGatewayInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGateway`](crate::operation::UpdateGateway)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGateway,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_131 = &_input.gateway_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let gateway_id = aws_smithy_http::label::fmt_string(input_131, false);
            if gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/20200301/gateways/{gatewayId}",
                gatewayId = gateway_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_gateway(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGateway",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    pub fn builder() -> crate::input::update_gateway_input::Builder {
        crate::input::update_gateway_input::Builder::default()
    }
}

/// See [`UpdateGatewayCapabilityConfigurationInput`](crate::input::UpdateGatewayCapabilityConfigurationInput)
pub mod update_gateway_capability_configuration_input {
    /// A builder for [`UpdateGatewayCapabilityConfigurationInput`](crate::input::UpdateGatewayCapabilityConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) capability_namespace: std::option::Option<std::string::String>,
        pub(crate) capability_configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the gateway to be updated.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway to be updated.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn capability_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_namespace = input;
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn capability_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.capability_configuration = Some(input.into());
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_capability_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capability_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayCapabilityConfigurationInput`](crate::input::UpdateGatewayCapabilityConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayCapabilityConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayCapabilityConfigurationInput {
                gateway_id: self.gateway_id,
                capability_namespace: self.capability_namespace,
                capability_configuration: self.capability_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayCapabilityConfigurationInputOperationOutputAlias =
    crate::operation::UpdateGatewayCapabilityConfiguration;
#[doc(hidden)]
pub type UpdateGatewayCapabilityConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateGatewayCapabilityConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGatewayCapabilityConfiguration`](crate::operation::UpdateGatewayCapabilityConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGatewayCapabilityConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGatewayCapabilityConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_132 = &_input.gateway_id;
            let input_132 =
                input_132
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_id",
                        details: "cannot be empty or unset",
                    })?;
            let gateway_id = aws_smithy_http::label::fmt_string(input_132, false);
            if gateway_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "gateway_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/20200301/gateways/{gatewayId}/capability",
                gatewayId = gateway_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGatewayCapabilityConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGatewayCapabilityConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_gateway_capability_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("api.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGatewayCapabilityConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGatewayCapabilityConfiguration",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayCapabilityConfigurationInput`](crate::input::UpdateGatewayCapabilityConfigurationInput)
    pub fn builder() -> crate::input::update_gateway_capability_configuration_input::Builder {
        crate::input::update_gateway_capability_configuration_input::Builder::default()
    }
}

/// See [`UpdatePortalInput`](crate::input::UpdatePortalInput)
pub mod update_portal_input {
    /// A builder for [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) portal_id: std::option::Option<std::string::String>,
        pub(crate) portal_name: std::option::Option<std::string::String>,
        pub(crate) portal_description: std::option::Option<std::string::String>,
        pub(crate) portal_contact_email: std::option::Option<std::string::String>,
        pub(crate) portal_logo_image: std::option::Option<crate::model::Image>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) notification_sender_email: std::option::Option<std::string::String>,
        pub(crate) alarms: std::option::Option<crate::model::Alarms>,
    }
    impl Builder {
        /// <p>The ID of the portal to update.</p>
        pub fn portal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_id = Some(input.into());
            self
        }
        /// <p>The ID of the portal to update.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_id = input;
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn portal_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_name = Some(input.into());
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.portal_name = input;
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn portal_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_description = Some(input.into());
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_description = input;
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.portal_contact_email = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.portal_contact_email = input;
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An image file. Choose this option to upload a new image.</p>
        /// </li>
        /// <li>
        /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
        /// </li>
        /// </ul>
        pub fn portal_logo_image(mut self, input: crate::model::Image) -> Self {
            self.portal_logo_image = Some(input);
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An image file. Choose this option to upload a new image.</p>
        /// </li>
        /// <li>
        /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
        /// </li>
        /// </ul>
        pub fn set_portal_logo_image(
            mut self,
            input: std::option::Option<crate::model::Image>,
        ) -> Self {
            self.portal_logo_image = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn notification_sender_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_sender_email = Some(input.into());
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_sender_email = input;
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, input: crate::model::Alarms) -> Self {
            self.alarms = Some(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePortalInput`](crate::input::UpdatePortalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePortalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePortalInput {
                portal_id: self.portal_id,
                portal_name: self.portal_name,
                portal_description: self.portal_description,
                portal_contact_email: self.portal_contact_email,
                portal_logo_image: self.portal_logo_image,
                role_arn: self.role_arn,
                client_token: self.client_token,
                notification_sender_email: self.notification_sender_email,
                alarms: self.alarms,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePortalInputOperationOutputAlias = crate::operation::UpdatePortal;
#[doc(hidden)]
pub type UpdatePortalInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdatePortalInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePortal`](crate::operation::UpdatePortal)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePortal,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePortalInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.portal_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "portal_id",
                        details: "cannot be empty or unset",
                    })?;
            let portal_id = aws_smithy_http::label::fmt_string(input_133, false);
            if portal_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "portal_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/portals/{portalId}", portalId = portal_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePortalInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePortalInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_portal(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePortal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePortal",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    pub fn builder() -> crate::input::update_portal_input::Builder {
        crate::input::update_portal_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the project to update.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project to update.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>A new description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>A new description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                project_id: self.project_id,
                project_name: self.project_name,
                project_description: self.project_description,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_134 = &_input.project_id;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_id",
                        details: "cannot be empty or unset",
                    })?;
            let project_id = aws_smithy_http::label::fmt_string(input_134, false);
            if project_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/projects/{projectId}", projectId = project_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("monitor.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "iotsitewise",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>The ID of the project to update.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>A new friendly name for the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>A new description for the project.</p>
    pub project_description: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateProjectInput {
    /// <p>The ID of the project to update.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>A new friendly name for the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>A new description for the project.</p>
    pub fn project_description(&self) -> std::option::Option<&str> {
        self.project_description.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("project_name", &self.project_name);
        formatter.field("project_description", &self.project_description);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePortalInput {
    /// <p>The ID of the portal to update.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>A new friendly name for the portal.</p>
    pub portal_name: std::option::Option<std::string::String>,
    /// <p>A new description for the portal.</p>
    pub portal_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub portal_contact_email: std::option::Option<std::string::String>,
    /// <p>Contains an image that is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>An image file. Choose this option to upload a new image.</p>
    /// </li>
    /// <li>
    /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
    /// </li>
    /// </ul>
    pub portal_logo_image: std::option::Option<crate::model::Image>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
    /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The email address that sends alarm notifications.</p>
    pub notification_sender_email: std::option::Option<std::string::String>,
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
    /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    pub alarms: std::option::Option<crate::model::Alarms>,
}
impl UpdatePortalInput {
    /// <p>The ID of the portal to update.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>A new friendly name for the portal.</p>
    pub fn portal_name(&self) -> std::option::Option<&str> {
        self.portal_name.as_deref()
    }
    /// <p>A new description for the portal.</p>
    pub fn portal_description(&self) -> std::option::Option<&str> {
        self.portal_description.as_deref()
    }
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub fn portal_contact_email(&self) -> std::option::Option<&str> {
        self.portal_contact_email.as_deref()
    }
    /// <p>Contains an image that is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>An image file. Choose this option to upload a new image.</p>
    /// </li>
    /// <li>
    /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
    /// </li>
    /// </ul>
    pub fn portal_logo_image(&self) -> std::option::Option<&crate::model::Image> {
        self.portal_logo_image.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
    /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The email address that sends alarm notifications.</p>
    pub fn notification_sender_email(&self) -> std::option::Option<&str> {
        self.notification_sender_email.as_deref()
    }
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
    /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    pub fn alarms(&self) -> std::option::Option<&crate::model::Alarms> {
        self.alarms.as_ref()
    }
}
impl std::fmt::Debug for UpdatePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePortalInput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("portal_name", &self.portal_name);
        formatter.field("portal_description", &self.portal_description);
        formatter.field("portal_contact_email", &self.portal_contact_email);
        formatter.field("portal_logo_image", &self.portal_logo_image);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("client_token", &self.client_token);
        formatter.field("notification_sender_email", &self.notification_sender_email);
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayCapabilityConfigurationInput {
    /// <p>The ID of the gateway to be updated.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The namespace of the gateway capability configuration to be updated.
    /// For example, if you configure OPC-UA
    /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
    /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
    /// <code>1</code>.</p>
    pub capability_namespace: std::option::Option<std::string::String>,
    /// <p>The JSON document that defines the configuration for the gateway capability. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub capability_configuration: std::option::Option<std::string::String>,
}
impl UpdateGatewayCapabilityConfigurationInput {
    /// <p>The ID of the gateway to be updated.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The namespace of the gateway capability configuration to be updated.
    /// For example, if you configure OPC-UA
    /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
    /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
    /// <code>1</code>.</p>
    pub fn capability_namespace(&self) -> std::option::Option<&str> {
        self.capability_namespace.as_deref()
    }
    /// <p>The JSON document that defines the configuration for the gateway capability. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn capability_configuration(&self) -> std::option::Option<&str> {
        self.capability_configuration.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewayCapabilityConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayCapabilityConfigurationInput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("capability_namespace", &self.capability_namespace);
        formatter.field("capability_configuration", &self.capability_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayInput {
    /// <p>The ID of the gateway to update.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>A unique, friendly name for the gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
}
impl UpdateGatewayInput {
    /// <p>The ID of the gateway to update.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>A unique, friendly name for the gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayInput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("gateway_name", &self.gateway_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDashboardInput {
    /// <p>The ID of the dashboard to update.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>A new friendly name for the dashboard.</p>
    pub dashboard_name: std::option::Option<std::string::String>,
    /// <p>A new description for the dashboard.</p>
    pub dashboard_description: std::option::Option<std::string::String>,
    /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub dashboard_definition: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateDashboardInput {
    /// <p>The ID of the dashboard to update.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>A new friendly name for the dashboard.</p>
    pub fn dashboard_name(&self) -> std::option::Option<&str> {
        self.dashboard_name.as_deref()
    }
    /// <p>A new description for the dashboard.</p>
    pub fn dashboard_description(&self) -> std::option::Option<&str> {
        self.dashboard_description.as_deref()
    }
    /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn dashboard_definition(&self) -> std::option::Option<&str> {
        self.dashboard_definition.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateDashboardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDashboardInput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("dashboard_name", &self.dashboard_name);
        formatter.field("dashboard_description", &self.dashboard_description);
        formatter.field("dashboard_definition", &self.dashboard_definition);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetPropertyInput {
    /// <p>The ID of the asset to be updated.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property to be updated.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    /// <p>If you omit this parameter, the alias is removed from the property.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The MQTT notification state (enabled or disabled) for this asset property.
    /// When the notification state is enabled, IoT SiteWise publishes property value
    /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
    pub property_notification_state: std::option::Option<crate::model::PropertyNotificationState>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateAssetPropertyInput {
    /// <p>The ID of the asset to be updated.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property to be updated.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    /// <p>If you omit this parameter, the alias is removed from the property.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The MQTT notification state (enabled or disabled) for this asset property.
    /// When the notification state is enabled, IoT SiteWise publishes property value
    /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
    pub fn property_notification_state(
        &self,
    ) -> std::option::Option<&crate::model::PropertyNotificationState> {
        self.property_notification_state.as_ref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateAssetPropertyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetPropertyInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field(
            "property_notification_state",
            &self.property_notification_state,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetModelInput {
    /// <p>The ID of the asset model to update.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>A unique, friendly name for the asset model.</p>
    pub asset_model_name: std::option::Option<std::string::String>,
    /// <p>A description for the asset model.</p>
    pub asset_model_description: std::option::Option<std::string::String>,
    /// <p>The updated property definitions of the asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 200 properties per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub asset_model_properties:
        std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
    /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
    /// model whose assets can be children of any other assets created from this asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 10 hierarchies per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub asset_model_hierarchies:
        std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
    /// <p>The composite asset models that are part of this asset model.
    /// Composite asset models are asset models that contain specific properties. Each composite model
    /// has a type that defines the properties that the composite model supports. Use composite asset
    /// models to define alarms on this asset model.</p>
    pub asset_model_composite_models:
        std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateAssetModelInput {
    /// <p>The ID of the asset model to update.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>A unique, friendly name for the asset model.</p>
    pub fn asset_model_name(&self) -> std::option::Option<&str> {
        self.asset_model_name.as_deref()
    }
    /// <p>A description for the asset model.</p>
    pub fn asset_model_description(&self) -> std::option::Option<&str> {
        self.asset_model_description.as_deref()
    }
    /// <p>The updated property definitions of the asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 200 properties per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn asset_model_properties(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelProperty]> {
        self.asset_model_properties.as_deref()
    }
    /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
    /// model whose assets can be children of any other assets created from this asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 10 hierarchies per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn asset_model_hierarchies(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelHierarchy]> {
        self.asset_model_hierarchies.as_deref()
    }
    /// <p>The composite asset models that are part of this asset model.
    /// Composite asset models are asset models that contain specific properties. Each composite model
    /// has a type that defines the properties that the composite model supports. Use composite asset
    /// models to define alarms on this asset model.</p>
    pub fn asset_model_composite_models(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelCompositeModel]> {
        self.asset_model_composite_models.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateAssetModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetModelInput");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("asset_model_name", &self.asset_model_name);
        formatter.field("asset_model_description", &self.asset_model_description);
        formatter.field("asset_model_properties", &self.asset_model_properties);
        formatter.field("asset_model_hierarchies", &self.asset_model_hierarchies);
        formatter.field(
            "asset_model_composite_models",
            &self.asset_model_composite_models,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssetInput {
    /// <p>The ID of the asset to update.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>A unique, friendly name for the asset.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateAssetInput {
    /// <p>The ID of the asset to update.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>A unique, friendly name for the asset.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("asset_name", &self.asset_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccessPolicyInput {
    /// <p>The ID of the access policy.</p>
    pub access_policy_id: std::option::Option<std::string::String>,
    /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    pub access_policy_identity: std::option::Option<crate::model::Identity>,
    /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    pub access_policy_resource: std::option::Option<crate::model::Resource>,
    /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub access_policy_permission: std::option::Option<crate::model::Permission>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateAccessPolicyInput {
    /// <p>The ID of the access policy.</p>
    pub fn access_policy_id(&self) -> std::option::Option<&str> {
        self.access_policy_id.as_deref()
    }
    /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    pub fn access_policy_identity(&self) -> std::option::Option<&crate::model::Identity> {
        self.access_policy_identity.as_ref()
    }
    /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    pub fn access_policy_resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.access_policy_resource.as_ref()
    }
    /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub fn access_policy_permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.access_policy_permission.as_ref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccessPolicyInput");
        formatter.field("access_policy_id", &self.access_policy_id);
        formatter.field("access_policy_identity", &self.access_policy_identity);
        formatter.field("access_policy_resource", &self.access_policy_resource);
        formatter.field("access_policy_permission", &self.access_policy_permission);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of keys for tags to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of keys for tags to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageConfigurationInput {
    /// <p>The storage tier that you specified for your data.
    /// The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier.
    /// The hot tier is a service-managed database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier.
    /// The cold tier is a customer-managed Amazon S3 bucket.</p>
    /// </li>
    /// </ul>
    pub storage_type: std::option::Option<crate::model::StorageType>,
    /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
    /// you must specify a <code>MultiLayerStorage</code> object.</p>
    pub multi_layer_storage: std::option::Option<crate::model::MultiLayerStorage>,
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
    /// The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p>
    /// <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a>
    /// in the <i>IoT SiteWise User Guide</i>.</p>
    pub disassociated_data_storage:
        std::option::Option<crate::model::DisassociatedDataStorageState>,
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
}
impl PutStorageConfigurationInput {
    /// <p>The storage tier that you specified for your data.
    /// The <code>storageType</code> parameter can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier.
    /// The hot tier is a service-managed database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the cold tier.
    /// The cold tier is a customer-managed Amazon S3 bucket.</p>
    /// </li>
    /// </ul>
    pub fn storage_type(&self) -> std::option::Option<&crate::model::StorageType> {
        self.storage_type.as_ref()
    }
    /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
    /// you must specify a <code>MultiLayerStorage</code> object.</p>
    pub fn multi_layer_storage(&self) -> std::option::Option<&crate::model::MultiLayerStorage> {
        self.multi_layer_storage.as_ref()
    }
    /// <p>Contains the storage configuration for time series (data streams) that aren't associated with asset properties.
    /// The <code>disassociatedDataStorage</code> can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code> – IoT SiteWise accepts time series that aren't associated with asset properties.</p>
    /// <important>
    /// <p>After the <code>disassociatedDataStorage</code> is enabled, you can't disable it.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> – IoT SiteWise doesn't accept time series (data streams) that aren't associated with asset properties.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a>
    /// in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn disassociated_data_storage(
        &self,
    ) -> std::option::Option<&crate::model::DisassociatedDataStorageState> {
        self.disassociated_data_storage.as_ref()
    }
    /// <p>How many days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
}
impl std::fmt::Debug for PutStorageConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageConfigurationInput");
        formatter.field("storage_type", &self.storage_type);
        formatter.field("multi_layer_storage", &self.multi_layer_storage);
        formatter.field(
            "disassociated_data_storage",
            &self.disassociated_data_storage,
        );
        formatter.field("retention_period", &self.retention_period);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLoggingOptionsInput {
    /// <p>The logging options to set.</p>
    pub logging_options: std::option::Option<crate::model::LoggingOptions>,
}
impl PutLoggingOptionsInput {
    /// <p>The logging options to set.</p>
    pub fn logging_options(&self) -> std::option::Option<&crate::model::LoggingOptions> {
        self.logging_options.as_ref()
    }
}
impl std::fmt::Debug for PutLoggingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLoggingOptionsInput");
        formatter.field("logging_options", &self.logging_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDefaultEncryptionConfigurationInput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you
    /// use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl PutDefaultEncryptionConfigurationInput {
    /// <p>The type of encryption used for the encryption configuration.</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The Key ID of the customer managed key used for KMS encryption. This is required if you
    /// use <code>KMS_BASED_ENCRYPTION</code>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for PutDefaultEncryptionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDefaultEncryptionConfigurationInput");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTimeSeriesInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The alias prefix of the time series.</p>
    pub alias_prefix: std::option::Option<std::string::String>,
    /// <p>The type of the time series. The time series type can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASSOCIATED</code> – The time series is associated with an asset
    /// property.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISASSOCIATED</code> – The time series isn't associated with any asset
    /// property.</p>
    /// </li>
    /// </ul>
    pub time_series_type: std::option::Option<crate::model::ListTimeSeriesType>,
}
impl ListTimeSeriesInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The alias prefix of the time series.</p>
    pub fn alias_prefix(&self) -> std::option::Option<&str> {
        self.alias_prefix.as_deref()
    }
    /// <p>The type of the time series. The time series type can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASSOCIATED</code> – The time series is associated with an asset
    /// property.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISASSOCIATED</code> – The time series isn't associated with any asset
    /// property.</p>
    /// </li>
    /// </ul>
    pub fn time_series_type(&self) -> std::option::Option<&crate::model::ListTimeSeriesType> {
        self.time_series_type.as_ref()
    }
}
impl std::fmt::Debug for ListTimeSeriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTimeSeriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("alias_prefix", &self.alias_prefix);
        formatter.field("time_series_type", &self.time_series_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>The ID of the portal.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProjectsInput {
    /// <p>The ID of the portal.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectAssetsInput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProjectAssetsInput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProjectAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectAssetsInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPortalsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPortalsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPortalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPortalsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewaysInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListGatewaysInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewaysInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDashboardsInput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDashboardsInput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDashboardsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDashboardsInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedAssetsInput {
    /// <p>The ID of the asset to query.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
    /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
    /// parameter is required if you choose <code>CHILD</code> for
    /// <code>traversalDirection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub hierarchy_id: std::option::Option<std::string::String>,
    /// <p>The direction to list associated assets. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CHILD</code> – The list includes all child assets associated to the
    /// asset. The <code>hierarchyId</code> parameter is required if you choose
    /// <code>CHILD</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>CHILD</code>
    /// </p>
    pub traversal_direction: std::option::Option<crate::model::TraversalDirection>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssociatedAssetsInput {
    /// <p>The ID of the asset to query.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
    /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
    /// parameter is required if you choose <code>CHILD</code> for
    /// <code>traversalDirection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn hierarchy_id(&self) -> std::option::Option<&str> {
        self.hierarchy_id.as_deref()
    }
    /// <p>The direction to list associated assets. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CHILD</code> – The list includes all child assets associated to the
    /// asset. The <code>hierarchyId</code> parameter is required if you choose
    /// <code>CHILD</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>CHILD</code>
    /// </p>
    pub fn traversal_direction(&self) -> std::option::Option<&crate::model::TraversalDirection> {
        self.traversal_direction.as_ref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssociatedAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedAssetsInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("hierarchy_id", &self.hierarchy_id);
        formatter.field("traversal_direction", &self.traversal_direction);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
    /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
    /// <code>assetModelId</code> parameter is required if you filter by
    /// <code>ALL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
    /// hierarchy tree.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>ALL</code>
    /// </p>
    pub filter: std::option::Option<crate::model::ListAssetsFilter>,
}
impl ListAssetsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
    /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
    /// <code>assetModelId</code> parameter is required if you filter by
    /// <code>ALL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
    /// hierarchy tree.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>ALL</code>
    /// </p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ListAssetsFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for ListAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetRelationshipsInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The type of traversal to use to identify asset relationships. Choose the following
    /// option:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
    /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
    /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
    /// </li>
    /// </ul>
    pub traversal_type: std::option::Option<crate::model::TraversalType>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssetRelationshipsInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The type of traversal to use to identify asset relationships. Choose the following
    /// option:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
    /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
    /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
    /// </li>
    /// </ul>
    pub fn traversal_type(&self) -> std::option::Option<&crate::model::TraversalType> {
        self.traversal_type.as_ref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssetRelationshipsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetRelationshipsInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("traversal_type", &self.traversal_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssetModelsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssetModelsInput {
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssetModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssetModelsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPoliciesInput {
    /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
    /// if you specify <code>identityId</code>.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
    /// <code>GROUP</code> for <code>identityType</code>.</p>
    pub identity_id: std::option::Option<std::string::String>,
    /// <p>The type of resource (portal or project). This parameter is required if you specify
    /// <code>resourceId</code>.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource. This parameter is required if you specify
    /// <code>resourceType</code>.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
    /// <i>IAM User Guide</i>. This parameter is required if you specify
    /// <code>IAM</code> for <code>identityType</code>.</p>
    pub iam_arn: std::option::Option<std::string::String>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAccessPoliciesInput {
    /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
    /// if you specify <code>identityId</code>.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
    /// <code>GROUP</code> for <code>identityType</code>.</p>
    pub fn identity_id(&self) -> std::option::Option<&str> {
        self.identity_id.as_deref()
    }
    /// <p>The type of resource (portal or project). This parameter is required if you specify
    /// <code>resourceId</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource. This parameter is required if you specify
    /// <code>resourceType</code>.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
    /// <i>IAM User Guide</i>. This parameter is required if you specify
    /// <code>IAM</code> for <code>identityType</code>.</p>
    pub fn iam_arn(&self) -> std::option::Option<&str> {
        self.iam_arn.as_deref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 50</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccessPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPoliciesInput");
        formatter.field("identity_type", &self.identity_type);
        formatter.field("identity_id", &self.identity_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("iam_arn", &self.iam_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInterpolatedAssetPropertyValuesInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
    /// Unix epoch time.</p>
    pub start_time_in_seconds: std::option::Option<i64>,
    /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
    pub start_time_offset_in_nanos: std::option::Option<i32>,
    /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
    /// Unix epoch time.</p>
    pub end_time_in_seconds: std::option::Option<i64>,
    /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
    pub end_time_offset_in_nanos: std::option::Option<i32>,
    /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
    /// only the asset property values that have a specific quality.</p>
    pub quality: std::option::Option<crate::model::Quality>,
    /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
    /// previous one ends.</p>
    pub interval_in_seconds: std::option::Option<i64>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The interpolation type.</p>
    /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear
    /// interpolation</a>.</p>
    /// <p>For example, you can use this operation to return the interpolated temperature values
    /// for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts
    /// July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM,
    /// the second interpolated value on July 3, 2021, at 9 AM, and so on.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation
    /// carried forward interpolation</p>
    /// <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point
    /// for the previous interval and carries forward this interpolated value until a new data
    /// point is found.</p>
    /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration
    /// of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last
    /// observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first
    /// interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the
    /// same interpolated value for the rest of the days.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by
    /// using data points from the timestamp of each interval, minus the window to the timestamp of
    /// each interval plus the window. If not specified, the window ranges between the start time
    /// minus the interval and the end time plus the interval.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the
    /// value for the <code>type</code> parameter must be
    /// <code>LINEAR_INTERPOLATION</code>.</p>
    /// </li>
    /// <li>
    /// <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an
    /// interpolated value for the interval. This indicates that there's a gap in the ingested
    /// data points.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24
    /// hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a
    /// window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM
    /// plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the
    /// data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to
    /// compute the second interpolated value, and so on. </p>
    pub interval_window_in_seconds: std::option::Option<i64>,
}
impl GetInterpolatedAssetPropertyValuesInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
    /// Unix epoch time.</p>
    pub fn start_time_in_seconds(&self) -> std::option::Option<i64> {
        self.start_time_in_seconds
    }
    /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
    pub fn start_time_offset_in_nanos(&self) -> std::option::Option<i32> {
        self.start_time_offset_in_nanos
    }
    /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
    /// Unix epoch time.</p>
    pub fn end_time_in_seconds(&self) -> std::option::Option<i64> {
        self.end_time_in_seconds
    }
    /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
    pub fn end_time_offset_in_nanos(&self) -> std::option::Option<i32> {
        self.end_time_offset_in_nanos
    }
    /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
    /// only the asset property values that have a specific quality.</p>
    pub fn quality(&self) -> std::option::Option<&crate::model::Quality> {
        self.quality.as_ref()
    }
    /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
    /// previous one ends.</p>
    pub fn interval_in_seconds(&self) -> std::option::Option<i64> {
        self.interval_in_seconds
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The interpolation type.</p>
    /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear
    /// interpolation</a>.</p>
    /// <p>For example, you can use this operation to return the interpolated temperature values
    /// for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts
    /// July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM,
    /// the second interpolated value on July 3, 2021, at 9 AM, and so on.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation
    /// carried forward interpolation</p>
    /// <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point
    /// for the previous interval and carries forward this interpolated value until a new data
    /// point is found.</p>
    /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration
    /// of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last
    /// observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first
    /// interpolated value. If a data point isn't found after 9 AM on July 2, 2021, IoT SiteWise uses the
    /// same interpolated value for the rest of the days.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by
    /// using data points from the timestamp of each interval, minus the window to the timestamp of
    /// each interval plus the window. If not specified, the window ranges between the start time
    /// minus the interval and the end time plus the interval.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the
    /// value for the <code>type</code> parameter must be
    /// <code>LINEAR_INTERPOLATION</code>.</p>
    /// </li>
    /// <li>
    /// <p>If a data point isn't found during the specified query window, IoT SiteWise won't return an
    /// interpolated value for the interval. This indicates that there's a gap in the ingested
    /// data points.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p>For example, you can get the interpolated temperature values for a wind turbine every 24
    /// hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a
    /// window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM
    /// plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the
    /// data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to
    /// compute the second interpolated value, and so on. </p>
    pub fn interval_window_in_seconds(&self) -> std::option::Option<i64> {
        self.interval_window_in_seconds
    }
}
impl std::fmt::Debug for GetInterpolatedAssetPropertyValuesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInterpolatedAssetPropertyValuesInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("start_time_in_seconds", &self.start_time_in_seconds);
        formatter.field(
            "start_time_offset_in_nanos",
            &self.start_time_offset_in_nanos,
        );
        formatter.field("end_time_in_seconds", &self.end_time_in_seconds);
        formatter.field("end_time_offset_in_nanos", &self.end_time_offset_in_nanos);
        formatter.field("quality", &self.quality);
        formatter.field("interval_in_seconds", &self.interval_in_seconds);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "interval_window_in_seconds",
            &self.interval_window_in_seconds,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyValueHistoryInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The quality by which to filter asset data.</p>
    pub qualities: std::option::Option<std::vec::Vec<crate::model::Quality>>,
    /// <p>The chronological sorting order of the requested information.</p>
    /// <p>Default: <code>ASCENDING</code>
    /// </p>
    pub time_ordering: std::option::Option<crate::model::TimeOrdering>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 100</p>
    pub max_results: std::option::Option<i32>,
}
impl GetAssetPropertyValueHistoryInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
    /// <p>The quality by which to filter asset data.</p>
    pub fn qualities(&self) -> std::option::Option<&[crate::model::Quality]> {
        self.qualities.as_deref()
    }
    /// <p>The chronological sorting order of the requested information.</p>
    /// <p>Default: <code>ASCENDING</code>
    /// </p>
    pub fn time_ordering(&self) -> std::option::Option<&crate::model::TimeOrdering> {
        self.time_ordering.as_ref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 100</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetAssetPropertyValueHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyValueHistoryInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("qualities", &self.qualities);
        formatter.field("time_ordering", &self.time_ordering);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyValueInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub property_alias: std::option::Option<std::string::String>,
}
impl GetAssetPropertyValueInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
}
impl std::fmt::Debug for GetAssetPropertyValueInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyValueInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssetPropertyAggregatesInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The data aggregating function.</p>
    pub aggregate_types: std::option::Option<std::vec::Vec<crate::model::AggregateType>>,
    /// <p>The time interval over which to aggregate data.</p>
    pub resolution: std::option::Option<std::string::String>,
    /// <p>The quality by which to filter asset data.</p>
    pub qualities: std::option::Option<std::vec::Vec<crate::model::Quality>>,
    /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The chronological sorting order of the requested information.</p>
    /// <p>Default: <code>ASCENDING</code>
    /// </p>
    pub time_ordering: std::option::Option<crate::model::TimeOrdering>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 100</p>
    pub max_results: std::option::Option<i32>,
}
impl GetAssetPropertyAggregatesInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
    /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The data aggregating function.</p>
    pub fn aggregate_types(&self) -> std::option::Option<&[crate::model::AggregateType]> {
        self.aggregate_types.as_deref()
    }
    /// <p>The time interval over which to aggregate data.</p>
    pub fn resolution(&self) -> std::option::Option<&str> {
        self.resolution.as_deref()
    }
    /// <p>The quality by which to filter asset data.</p>
    pub fn qualities(&self) -> std::option::Option<&[crate::model::Quality]> {
        self.qualities.as_deref()
    }
    /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
    /// <p>The chronological sorting order of the requested information.</p>
    /// <p>Default: <code>ASCENDING</code>
    /// </p>
    pub fn time_ordering(&self) -> std::option::Option<&crate::model::TimeOrdering> {
        self.time_ordering.as_ref()
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return for each paginated request.</p>
    /// <p>Default: 100</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetAssetPropertyAggregatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssetPropertyAggregatesInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("aggregate_types", &self.aggregate_types);
        formatter.field("resolution", &self.resolution);
        formatter.field("qualities", &self.qualities);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("time_ordering", &self.time_ordering);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTimeSeriesFromAssetPropertyInput {
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateTimeSeriesFromAssetPropertyInput {
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateTimeSeriesFromAssetPropertyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTimeSeriesFromAssetPropertyInput");
        formatter.field("alias", &self.alias);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAssetsInput {
    /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
    /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
    /// to identify the correct asset to disassociate. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub hierarchy_id: std::option::Option<std::string::String>,
    /// <p>The ID of the child asset to disassociate.</p>
    pub child_asset_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateAssetsInput {
    /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
    /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
    /// to identify the correct asset to disassociate. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn hierarchy_id(&self) -> std::option::Option<&str> {
        self.hierarchy_id.as_deref()
    }
    /// <p>The ID of the child asset to disassociate.</p>
    pub fn child_asset_id(&self) -> std::option::Option<&str> {
        self.child_asset_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAssetsInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("hierarchy_id", &self.hierarchy_id);
        formatter.field("child_asset_id", &self.child_asset_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTimeSeriesInput {
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
}
impl DescribeTimeSeriesInput {
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTimeSeriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTimeSeriesInput");
        formatter.field("alias", &self.alias);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorageConfigurationInput {}
impl std::fmt::Debug for DescribeStorageConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorageConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectInput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
}
impl DescribeProjectInput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePortalInput {
    /// <p>The ID of the portal.</p>
    pub portal_id: std::option::Option<std::string::String>,
}
impl DescribePortalInput {
    /// <p>The ID of the portal.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePortalInput");
        formatter.field("portal_id", &self.portal_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingOptionsInput {}
impl std::fmt::Debug for DescribeLoggingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingOptionsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayCapabilityConfigurationInput {
    /// <p>The ID of the gateway that defines the capability configuration.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The namespace of the capability configuration.
    /// For example, if you configure OPC-UA
    /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
    /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
    /// <code>1</code>.</p>
    pub capability_namespace: std::option::Option<std::string::String>,
}
impl DescribeGatewayCapabilityConfigurationInput {
    /// <p>The ID of the gateway that defines the capability configuration.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The namespace of the capability configuration.
    /// For example, if you configure OPC-UA
    /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
    /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
    /// <code>1</code>.</p>
    pub fn capability_namespace(&self) -> std::option::Option<&str> {
        self.capability_namespace.as_deref()
    }
}
impl std::fmt::Debug for DescribeGatewayCapabilityConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayCapabilityConfigurationInput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("capability_namespace", &self.capability_namespace);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayInput {
    /// <p>The ID of the gateway device.</p>
    pub gateway_id: std::option::Option<std::string::String>,
}
impl DescribeGatewayInput {
    /// <p>The ID of the gateway device.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayInput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultEncryptionConfigurationInput {}
impl std::fmt::Debug for DescribeDefaultEncryptionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultEncryptionConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDashboardInput {
    /// <p>The ID of the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
}
impl DescribeDashboardInput {
    /// <p>The ID of the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDashboardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDashboardInput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetPropertyInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
}
impl DescribeAssetPropertyInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssetPropertyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetPropertyInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetModelInput {
    /// <p>The ID of the asset model.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
}
impl DescribeAssetModelInput {
    /// <p>The ID of the asset model.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssetModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetModelInput");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssetInput {
    /// <p>The ID of the asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
}
impl DescribeAssetInput {
    /// <p>The ID of the asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessPolicyInput {
    /// <p>The ID of the access policy.</p>
    pub access_policy_id: std::option::Option<std::string::String>,
}
impl DescribeAccessPolicyInput {
    /// <p>The ID of the access policy.</p>
    pub fn access_policy_id(&self) -> std::option::Option<&str> {
        self.access_policy_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessPolicyInput");
        formatter.field("access_policy_id", &self.access_policy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTimeSeriesInput {
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteTimeSeriesInput {
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteTimeSeriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTimeSeriesInput");
        formatter.field("alias", &self.alias);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePortalInput {
    /// <p>The ID of the portal to delete.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeletePortalInput {
    /// <p>The ID of the portal to delete.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeletePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePortalInput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayInput {
    /// <p>The ID of the gateway to delete.</p>
    pub gateway_id: std::option::Option<std::string::String>,
}
impl DeleteGatewayInput {
    /// <p>The ID of the gateway to delete.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayInput");
        formatter.field("gateway_id", &self.gateway_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDashboardInput {
    /// <p>The ID of the dashboard to delete.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteDashboardInput {
    /// <p>The ID of the dashboard to delete.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteDashboardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDashboardInput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetModelInput {
    /// <p>The ID of the asset model to delete.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAssetModelInput {
    /// <p>The ID of the asset model to delete.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssetModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetModelInput");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssetInput {
    /// <p>The ID of the asset to delete.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAssetInput {
    /// <p>The ID of the asset to delete.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssetInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPolicyInput {
    /// <p>The ID of the access policy to be deleted.</p>
    pub access_policy_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAccessPolicyInput {
    /// <p>The ID of the access policy to be deleted.</p>
    pub fn access_policy_id(&self) -> std::option::Option<&str> {
        self.access_policy_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPolicyInput");
        formatter.field("access_policy_id", &self.access_policy_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The ID of the portal in which to create the project.</p>
    pub portal_id: std::option::Option<std::string::String>,
    /// <p>A friendly name for the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>A description for the project.</p>
    pub project_description: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProjectInput {
    /// <p>The ID of the portal in which to create the project.</p>
    pub fn portal_id(&self) -> std::option::Option<&str> {
        self.portal_id.as_deref()
    }
    /// <p>A friendly name for the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>A description for the project.</p>
    pub fn project_description(&self) -> std::option::Option<&str> {
        self.project_description.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("portal_id", &self.portal_id);
        formatter.field("project_name", &self.project_name);
        formatter.field("project_description", &self.project_description);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePortalInput {
    /// <p>A friendly name for the portal.</p>
    pub portal_name: std::option::Option<std::string::String>,
    /// <p>A description for the portal.</p>
    pub portal_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub portal_contact_email: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
    /// image is displayed on a dark background.</p>
    pub portal_logo_image_file: std::option::Option<crate::model::ImageFile>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
    /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The service to use to authenticate users to the portal. Choose from the following
    /// options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
    /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
    /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
    /// the China Regions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
    /// user permissions.</p>
    /// </li>
    /// </ul>
    /// <p>You can't change this value after you create a portal.</p>
    /// <p>Default: <code>SSO</code>
    /// </p>
    pub portal_auth_mode: std::option::Option<crate::model::AuthMode>,
    /// <p>The email address that sends alarm notifications.</p>
    /// <important>
    /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
    /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
    /// address in Amazon SES</a>.</p>
    /// </important>
    pub notification_sender_email: std::option::Option<std::string::String>,
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
    /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    pub alarms: std::option::Option<crate::model::Alarms>,
}
impl CreatePortalInput {
    /// <p>A friendly name for the portal.</p>
    pub fn portal_name(&self) -> std::option::Option<&str> {
        self.portal_name.as_deref()
    }
    /// <p>A description for the portal.</p>
    pub fn portal_description(&self) -> std::option::Option<&str> {
        self.portal_description.as_deref()
    }
    /// <p>The Amazon Web Services administrator's contact email address.</p>
    pub fn portal_contact_email(&self) -> std::option::Option<&str> {
        self.portal_contact_email.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
    /// image is displayed on a dark background.</p>
    pub fn portal_logo_image_file(&self) -> std::option::Option<&crate::model::ImageFile> {
        self.portal_logo_image_file.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
    /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The service to use to authenticate users to the portal. Choose from the following
    /// options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
    /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
    /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
    /// the China Regions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
    /// user permissions.</p>
    /// </li>
    /// </ul>
    /// <p>You can't change this value after you create a portal.</p>
    /// <p>Default: <code>SSO</code>
    /// </p>
    pub fn portal_auth_mode(&self) -> std::option::Option<&crate::model::AuthMode> {
        self.portal_auth_mode.as_ref()
    }
    /// <p>The email address that sends alarm notifications.</p>
    /// <important>
    /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
    /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
    /// address in Amazon SES</a>.</p>
    /// </important>
    pub fn notification_sender_email(&self) -> std::option::Option<&str> {
        self.notification_sender_email.as_deref()
    }
    /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
    /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
    pub fn alarms(&self) -> std::option::Option<&crate::model::Alarms> {
        self.alarms.as_ref()
    }
}
impl std::fmt::Debug for CreatePortalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePortalInput");
        formatter.field("portal_name", &self.portal_name);
        formatter.field("portal_description", &self.portal_description);
        formatter.field("portal_contact_email", &self.portal_contact_email);
        formatter.field("client_token", &self.client_token);
        formatter.field("portal_logo_image_file", &self.portal_logo_image_file);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("portal_auth_mode", &self.portal_auth_mode);
        formatter.field("notification_sender_email", &self.notification_sender_email);
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayInput {
    /// <p>A unique, friendly name for the gateway.</p>
    pub gateway_name: std::option::Option<std::string::String>,
    /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
    pub gateway_platform: std::option::Option<crate::model::GatewayPlatform>,
    /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateGatewayInput {
    /// <p>A unique, friendly name for the gateway.</p>
    pub fn gateway_name(&self) -> std::option::Option<&str> {
        self.gateway_name.as_deref()
    }
    /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
    pub fn gateway_platform(&self) -> std::option::Option<&crate::model::GatewayPlatform> {
        self.gateway_platform.as_ref()
    }
    /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayInput");
        formatter.field("gateway_name", &self.gateway_name);
        formatter.field("gateway_platform", &self.gateway_platform);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDashboardInput {
    /// <p>The ID of the project in which to create the dashboard.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>A friendly name for the dashboard.</p>
    pub dashboard_name: std::option::Option<std::string::String>,
    /// <p>A description for the dashboard.</p>
    pub dashboard_description: std::option::Option<std::string::String>,
    /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub dashboard_definition: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDashboardInput {
    /// <p>The ID of the project in which to create the dashboard.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>A friendly name for the dashboard.</p>
    pub fn dashboard_name(&self) -> std::option::Option<&str> {
        self.dashboard_name.as_deref()
    }
    /// <p>A description for the dashboard.</p>
    pub fn dashboard_description(&self) -> std::option::Option<&str> {
        self.dashboard_description.as_deref()
    }
    /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn dashboard_definition(&self) -> std::option::Option<&str> {
        self.dashboard_definition.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDashboardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDashboardInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("dashboard_name", &self.dashboard_name);
        formatter.field("dashboard_description", &self.dashboard_description);
        formatter.field("dashboard_definition", &self.dashboard_definition);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetModelInput {
    /// <p>A unique, friendly name for the asset model.</p>
    pub asset_model_name: std::option::Option<std::string::String>,
    /// <p>A description for the asset model.</p>
    pub asset_model_description: std::option::Option<std::string::String>,
    /// <p>The property definitions of the asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 200 properties per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub asset_model_properties:
        std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
    /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
    /// whose assets can be children of any other assets created from this asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 10 hierarchies per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub asset_model_hierarchies:
        std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchyDefinition>>,
    /// <p>The composite asset models that are part of this asset model.
    /// Composite asset models are asset models that contain specific properties. Each composite model
    /// has a type that defines the properties that the composite model supports. Use composite asset
    /// models to define alarms on this asset model.</p>
    pub asset_model_composite_models:
        std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModelDefinition>>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAssetModelInput {
    /// <p>A unique, friendly name for the asset model.</p>
    pub fn asset_model_name(&self) -> std::option::Option<&str> {
        self.asset_model_name.as_deref()
    }
    /// <p>A description for the asset model.</p>
    pub fn asset_model_description(&self) -> std::option::Option<&str> {
        self.asset_model_description.as_deref()
    }
    /// <p>The property definitions of the asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 200 properties per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn asset_model_properties(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelPropertyDefinition]> {
        self.asset_model_properties.as_deref()
    }
    /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
    /// whose assets can be children of any other assets created from this asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>You can specify up to 10 hierarchies per asset model. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn asset_model_hierarchies(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelHierarchyDefinition]> {
        self.asset_model_hierarchies.as_deref()
    }
    /// <p>The composite asset models that are part of this asset model.
    /// Composite asset models are asset models that contain specific properties. Each composite model
    /// has a type that defines the properties that the composite model supports. Use composite asset
    /// models to define alarms on this asset model.</p>
    pub fn asset_model_composite_models(
        &self,
    ) -> std::option::Option<&[crate::model::AssetModelCompositeModelDefinition]> {
        self.asset_model_composite_models.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
    /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAssetModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetModelInput");
        formatter.field("asset_model_name", &self.asset_model_name);
        formatter.field("asset_model_description", &self.asset_model_description);
        formatter.field("asset_model_properties", &self.asset_model_properties);
        formatter.field("asset_model_hierarchies", &self.asset_model_hierarchies);
        formatter.field(
            "asset_model_composite_models",
            &self.asset_model_composite_models,
        );
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssetInput {
    /// <p>A unique, friendly name for the asset.</p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>The ID of the asset model from which to create the asset.</p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAssetInput {
    /// <p>A unique, friendly name for the asset.</p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>The ID of the asset model from which to create the asset.</p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
    /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssetInput");
        formatter.field("asset_name", &self.asset_name);
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPolicyInput {
    /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    pub access_policy_identity: std::option::Option<crate::model::Identity>,
    /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    pub access_policy_resource: std::option::Option<crate::model::Resource>,
    /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub access_policy_permission: std::option::Option<crate::model::Permission>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the access policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
    /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAccessPolicyInput {
    /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
    pub fn access_policy_identity(&self) -> std::option::Option<&crate::model::Identity> {
        self.access_policy_identity.as_ref()
    }
    /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
    pub fn access_policy_resource(&self) -> std::option::Option<&crate::model::Resource> {
        self.access_policy_resource.as_ref()
    }
    /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
    pub fn access_policy_permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.access_policy_permission.as_ref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the access policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
    /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPolicyInput");
        formatter.field("access_policy_identity", &self.access_policy_identity);
        formatter.field("access_policy_resource", &self.access_policy_resource);
        formatter.field("access_policy_permission", &self.access_policy_permission);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutAssetPropertyValueInput {
    /// <p>The list of asset property value entries for the batch put request. You can specify up to
    /// 10 entries per request.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
}
impl BatchPutAssetPropertyValueInput {
    /// <p>The list of asset property value entries for the batch put request. You can specify up to
    /// 10 entries per request.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::PutAssetPropertyValueEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for BatchPutAssetPropertyValueInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutAssetPropertyValueInput");
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateProjectAssetsInput {
    /// <p>The ID of the project from which to disassociate the assets.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the assets to be disassociated from the project.</p>
    pub asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl BatchDisassociateProjectAssetsInput {
    /// <p>The ID of the project from which to disassociate the assets.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The IDs of the assets to be disassociated from the project.</p>
    pub fn asset_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.asset_ids.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateProjectAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateProjectAssetsInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("asset_ids", &self.asset_ids);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateProjectAssetsInput {
    /// <p>The ID of the project to which to associate the assets.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the assets to be associated to the project.</p>
    pub asset_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl BatchAssociateProjectAssetsInput {
    /// <p>The ID of the project to which to associate the assets.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The IDs of the assets to be associated to the project.</p>
    pub fn asset_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.asset_ids.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateProjectAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateProjectAssetsInput");
        formatter.field("project_id", &self.project_id);
        formatter.field("asset_ids", &self.asset_ids);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTimeSeriesToAssetPropertyInput {
    /// <p>The alias that identifies the time series.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateTimeSeriesToAssetPropertyInput {
    /// <p>The alias that identifies the time series.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ID of the asset in which the asset property was created.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateTimeSeriesToAssetPropertyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTimeSeriesToAssetPropertyInput");
        formatter.field("alias", &self.alias);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAssetsInput {
    /// <p>The ID of the parent asset.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
    /// of assets to be formed that all come from the same asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub hierarchy_id: std::option::Option<std::string::String>,
    /// <p>The ID of the child asset to be associated.</p>
    pub child_asset_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateAssetsInput {
    /// <p>The ID of the parent asset.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
    /// of assets to be formed that all come from the same asset model. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
    pub fn hierarchy_id(&self) -> std::option::Option<&str> {
        self.hierarchy_id.as_deref()
    }
    /// <p>The ID of the child asset to be associated.</p>
    pub fn child_asset_id(&self) -> std::option::Option<&str> {
        self.child_asset_id.as_deref()
    }
    /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAssetsInput");
        formatter.field("asset_id", &self.asset_id);
        formatter.field("hierarchy_id", &self.hierarchy_id);
        formatter.field("child_asset_id", &self.child_asset_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
