// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_assets`](crate::client::Client::associate_assets).
///
/// See [`crate::client::fluent_builders::AssociateAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAssets {
    _private: (),
}
impl AssociateAssets {
    /// Creates a new builder-style object to manufacture [`AssociateAssetsInput`](crate::input::AssociateAssetsInput)
    pub fn builder() -> crate::input::associate_assets_input::Builder {
        crate::input::associate_assets_input::Builder::default()
    }
    /// Creates a new `AssociateAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAssets {
    type Output = std::result::Result<
        crate::output::AssociateAssetsOutput,
        crate::error::AssociateAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_assets_error(response)
        } else {
            crate::operation_deser::parse_associate_assets_response(response)
        }
    }
}

/// Operation shape for `BatchAssociateProjectAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_project_assets`](crate::client::Client::batch_associate_project_assets).
///
/// See [`crate::client::fluent_builders::BatchAssociateProjectAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateProjectAssets {
    _private: (),
}
impl BatchAssociateProjectAssets {
    /// Creates a new builder-style object to manufacture [`BatchAssociateProjectAssetsInput`](crate::input::BatchAssociateProjectAssetsInput)
    pub fn builder() -> crate::input::batch_associate_project_assets_input::Builder {
        crate::input::batch_associate_project_assets_input::Builder::default()
    }
    /// Creates a new `BatchAssociateProjectAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchAssociateProjectAssets {
    type Output = std::result::Result<
        crate::output::BatchAssociateProjectAssetsOutput,
        crate::error::BatchAssociateProjectAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_project_assets_error(response)
        } else {
            crate::operation_deser::parse_batch_associate_project_assets_response(response)
        }
    }
}

/// Operation shape for `BatchDisassociateProjectAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_project_assets`](crate::client::Client::batch_disassociate_project_assets).
///
/// See [`crate::client::fluent_builders::BatchDisassociateProjectAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateProjectAssets {
    _private: (),
}
impl BatchDisassociateProjectAssets {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateProjectAssetsInput`](crate::input::BatchDisassociateProjectAssetsInput)
    pub fn builder() -> crate::input::batch_disassociate_project_assets_input::Builder {
        crate::input::batch_disassociate_project_assets_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateProjectAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDisassociateProjectAssets {
    type Output = std::result::Result<
        crate::output::BatchDisassociateProjectAssetsOutput,
        crate::error::BatchDisassociateProjectAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_project_assets_error(response)
        } else {
            crate::operation_deser::parse_batch_disassociate_project_assets_response(response)
        }
    }
}

/// Operation shape for `BatchPutAssetPropertyValue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_asset_property_value`](crate::client::Client::batch_put_asset_property_value).
///
/// See [`crate::client::fluent_builders::BatchPutAssetPropertyValue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutAssetPropertyValue {
    _private: (),
}
impl BatchPutAssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`BatchPutAssetPropertyValueInput`](crate::input::BatchPutAssetPropertyValueInput)
    pub fn builder() -> crate::input::batch_put_asset_property_value_input::Builder {
        crate::input::batch_put_asset_property_value_input::Builder::default()
    }
    /// Creates a new `BatchPutAssetPropertyValue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutAssetPropertyValue {
    type Output = std::result::Result<
        crate::output::BatchPutAssetPropertyValueOutput,
        crate::error::BatchPutAssetPropertyValueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_asset_property_value_error(response)
        } else {
            crate::operation_deser::parse_batch_put_asset_property_value_response(response)
        }
    }
}

/// Operation shape for `CreateAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access_policy`](crate::client::Client::create_access_policy).
///
/// See [`crate::client::fluent_builders::CreateAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccessPolicy {
    _private: (),
}
impl CreateAccessPolicy {
    /// Creates a new builder-style object to manufacture [`CreateAccessPolicyInput`](crate::input::CreateAccessPolicyInput)
    pub fn builder() -> crate::input::create_access_policy_input::Builder {
        crate::input::create_access_policy_input::Builder::default()
    }
    /// Creates a new `CreateAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccessPolicy {
    type Output = std::result::Result<
        crate::output::CreateAccessPolicyOutput,
        crate::error::CreateAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_access_policy_error(response)
        } else {
            crate::operation_deser::parse_create_access_policy_response(response)
        }
    }
}

/// Operation shape for `CreateAsset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_asset`](crate::client::Client::create_asset).
///
/// See [`crate::client::fluent_builders::CreateAsset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAsset {
    _private: (),
}
impl CreateAsset {
    /// Creates a new builder-style object to manufacture [`CreateAssetInput`](crate::input::CreateAssetInput)
    pub fn builder() -> crate::input::create_asset_input::Builder {
        crate::input::create_asset_input::Builder::default()
    }
    /// Creates a new `CreateAsset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAsset {
    type Output =
        std::result::Result<crate::output::CreateAssetOutput, crate::error::CreateAssetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_asset_error(response)
        } else {
            crate::operation_deser::parse_create_asset_response(response)
        }
    }
}

/// Operation shape for `CreateAssetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_asset_model`](crate::client::Client::create_asset_model).
///
/// See [`crate::client::fluent_builders::CreateAssetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssetModel {
    _private: (),
}
impl CreateAssetModel {
    /// Creates a new builder-style object to manufacture [`CreateAssetModelInput`](crate::input::CreateAssetModelInput)
    pub fn builder() -> crate::input::create_asset_model_input::Builder {
        crate::input::create_asset_model_input::Builder::default()
    }
    /// Creates a new `CreateAssetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssetModel {
    type Output = std::result::Result<
        crate::output::CreateAssetModelOutput,
        crate::error::CreateAssetModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_asset_model_error(response)
        } else {
            crate::operation_deser::parse_create_asset_model_response(response)
        }
    }
}

/// Operation shape for `CreateDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dashboard`](crate::client::Client::create_dashboard).
///
/// See [`crate::client::fluent_builders::CreateDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDashboard {
    _private: (),
}
impl CreateDashboard {
    /// Creates a new builder-style object to manufacture [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    pub fn builder() -> crate::input::create_dashboard_input::Builder {
        crate::input::create_dashboard_input::Builder::default()
    }
    /// Creates a new `CreateDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDashboard {
    type Output = std::result::Result<
        crate::output::CreateDashboardOutput,
        crate::error::CreateDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_dashboard_error(response)
        } else {
            crate::operation_deser::parse_create_dashboard_response(response)
        }
    }
}

/// Operation shape for `CreateGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_gateway`](crate::client::Client::create_gateway).
///
/// See [`crate::client::fluent_builders::CreateGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGateway {
    _private: (),
}
impl CreateGateway {
    /// Creates a new builder-style object to manufacture [`CreateGatewayInput`](crate::input::CreateGatewayInput)
    pub fn builder() -> crate::input::create_gateway_input::Builder {
        crate::input::create_gateway_input::Builder::default()
    }
    /// Creates a new `CreateGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGateway {
    type Output =
        std::result::Result<crate::output::CreateGatewayOutput, crate::error::CreateGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_gateway_response(response)
        }
    }
}

/// Operation shape for `CreatePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_portal`](crate::client::Client::create_portal).
///
/// See [`crate::client::fluent_builders::CreatePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePortal {
    _private: (),
}
impl CreatePortal {
    /// Creates a new builder-style object to manufacture [`CreatePortalInput`](crate::input::CreatePortalInput)
    pub fn builder() -> crate::input::create_portal_input::Builder {
        crate::input::create_portal_input::Builder::default()
    }
    /// Creates a new `CreatePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePortal {
    type Output =
        std::result::Result<crate::output::CreatePortalOutput, crate::error::CreatePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_portal_error(response)
        } else {
            crate::operation_deser::parse_create_portal_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_policy`](crate::client::Client::delete_access_policy).
///
/// See [`crate::client::fluent_builders::DeleteAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPolicy {
    _private: (),
}
impl DeleteAccessPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPolicyInput`](crate::input::DeleteAccessPolicyInput)
    pub fn builder() -> crate::input::delete_access_policy_input::Builder {
        crate::input::delete_access_policy_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPolicy {
    type Output = std::result::Result<
        crate::output::DeleteAccessPolicyOutput,
        crate::error::DeleteAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_access_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_access_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteAsset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_asset`](crate::client::Client::delete_asset).
///
/// See [`crate::client::fluent_builders::DeleteAsset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAsset {
    _private: (),
}
impl DeleteAsset {
    /// Creates a new builder-style object to manufacture [`DeleteAssetInput`](crate::input::DeleteAssetInput)
    pub fn builder() -> crate::input::delete_asset_input::Builder {
        crate::input::delete_asset_input::Builder::default()
    }
    /// Creates a new `DeleteAsset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAsset {
    type Output =
        std::result::Result<crate::output::DeleteAssetOutput, crate::error::DeleteAssetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_asset_error(response)
        } else {
            crate::operation_deser::parse_delete_asset_response(response)
        }
    }
}

/// Operation shape for `DeleteAssetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_asset_model`](crate::client::Client::delete_asset_model).
///
/// See [`crate::client::fluent_builders::DeleteAssetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssetModel {
    _private: (),
}
impl DeleteAssetModel {
    /// Creates a new builder-style object to manufacture [`DeleteAssetModelInput`](crate::input::DeleteAssetModelInput)
    pub fn builder() -> crate::input::delete_asset_model_input::Builder {
        crate::input::delete_asset_model_input::Builder::default()
    }
    /// Creates a new `DeleteAssetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssetModel {
    type Output = std::result::Result<
        crate::output::DeleteAssetModelOutput,
        crate::error::DeleteAssetModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_asset_model_error(response)
        } else {
            crate::operation_deser::parse_delete_asset_model_response(response)
        }
    }
}

/// Operation shape for `DeleteDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dashboard`](crate::client::Client::delete_dashboard).
///
/// See [`crate::client::fluent_builders::DeleteDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDashboard {
    _private: (),
}
impl DeleteDashboard {
    /// Creates a new builder-style object to manufacture [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    pub fn builder() -> crate::input::delete_dashboard_input::Builder {
        crate::input::delete_dashboard_input::Builder::default()
    }
    /// Creates a new `DeleteDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDashboard {
    type Output = std::result::Result<
        crate::output::DeleteDashboardOutput,
        crate::error::DeleteDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_dashboard_error(response)
        } else {
            crate::operation_deser::parse_delete_dashboard_response(response)
        }
    }
}

/// Operation shape for `DeleteGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_gateway`](crate::client::Client::delete_gateway).
///
/// See [`crate::client::fluent_builders::DeleteGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGateway {
    _private: (),
}
impl DeleteGateway {
    /// Creates a new builder-style object to manufacture [`DeleteGatewayInput`](crate::input::DeleteGatewayInput)
    pub fn builder() -> crate::input::delete_gateway_input::Builder {
        crate::input::delete_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGateway {
    type Output =
        std::result::Result<crate::output::DeleteGatewayOutput, crate::error::DeleteGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_gateway_response(response)
        }
    }
}

/// Operation shape for `DeletePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_portal`](crate::client::Client::delete_portal).
///
/// See [`crate::client::fluent_builders::DeletePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePortal {
    _private: (),
}
impl DeletePortal {
    /// Creates a new builder-style object to manufacture [`DeletePortalInput`](crate::input::DeletePortalInput)
    pub fn builder() -> crate::input::delete_portal_input::Builder {
        crate::input::delete_portal_input::Builder::default()
    }
    /// Creates a new `DeletePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePortal {
    type Output =
        std::result::Result<crate::output::DeletePortalOutput, crate::error::DeletePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_portal_error(response)
        } else {
            crate::operation_deser::parse_delete_portal_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DescribeAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_access_policy`](crate::client::Client::describe_access_policy).
///
/// See [`crate::client::fluent_builders::DescribeAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccessPolicy {
    _private: (),
}
impl DescribeAccessPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeAccessPolicyInput`](crate::input::DescribeAccessPolicyInput)
    pub fn builder() -> crate::input::describe_access_policy_input::Builder {
        crate::input::describe_access_policy_input::Builder::default()
    }
    /// Creates a new `DescribeAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccessPolicy {
    type Output = std::result::Result<
        crate::output::DescribeAccessPolicyOutput,
        crate::error::DescribeAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_access_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_access_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeAsset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_asset`](crate::client::Client::describe_asset).
///
/// See [`crate::client::fluent_builders::DescribeAsset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAsset {
    _private: (),
}
impl DescribeAsset {
    /// Creates a new builder-style object to manufacture [`DescribeAssetInput`](crate::input::DescribeAssetInput)
    pub fn builder() -> crate::input::describe_asset_input::Builder {
        crate::input::describe_asset_input::Builder::default()
    }
    /// Creates a new `DescribeAsset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAsset {
    type Output =
        std::result::Result<crate::output::DescribeAssetOutput, crate::error::DescribeAssetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_asset_error(response)
        } else {
            crate::operation_deser::parse_describe_asset_response(response)
        }
    }
}

/// Operation shape for `DescribeAssetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_asset_model`](crate::client::Client::describe_asset_model).
///
/// See [`crate::client::fluent_builders::DescribeAssetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssetModel {
    _private: (),
}
impl DescribeAssetModel {
    /// Creates a new builder-style object to manufacture [`DescribeAssetModelInput`](crate::input::DescribeAssetModelInput)
    pub fn builder() -> crate::input::describe_asset_model_input::Builder {
        crate::input::describe_asset_model_input::Builder::default()
    }
    /// Creates a new `DescribeAssetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssetModel {
    type Output = std::result::Result<
        crate::output::DescribeAssetModelOutput,
        crate::error::DescribeAssetModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_asset_model_error(response)
        } else {
            crate::operation_deser::parse_describe_asset_model_response(response)
        }
    }
}

/// Operation shape for `DescribeAssetProperty`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_asset_property`](crate::client::Client::describe_asset_property).
///
/// See [`crate::client::fluent_builders::DescribeAssetProperty`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssetProperty {
    _private: (),
}
impl DescribeAssetProperty {
    /// Creates a new builder-style object to manufacture [`DescribeAssetPropertyInput`](crate::input::DescribeAssetPropertyInput)
    pub fn builder() -> crate::input::describe_asset_property_input::Builder {
        crate::input::describe_asset_property_input::Builder::default()
    }
    /// Creates a new `DescribeAssetProperty` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssetProperty {
    type Output = std::result::Result<
        crate::output::DescribeAssetPropertyOutput,
        crate::error::DescribeAssetPropertyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_asset_property_error(response)
        } else {
            crate::operation_deser::parse_describe_asset_property_response(response)
        }
    }
}

/// Operation shape for `DescribeDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dashboard`](crate::client::Client::describe_dashboard).
///
/// See [`crate::client::fluent_builders::DescribeDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDashboard {
    _private: (),
}
impl DescribeDashboard {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    pub fn builder() -> crate::input::describe_dashboard_input::Builder {
        crate::input::describe_dashboard_input::Builder::default()
    }
    /// Creates a new `DescribeDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDashboard {
    type Output = std::result::Result<
        crate::output::DescribeDashboardOutput,
        crate::error::DescribeDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dashboard_error(response)
        } else {
            crate::operation_deser::parse_describe_dashboard_response(response)
        }
    }
}

/// Operation shape for `DescribeDefaultEncryptionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_default_encryption_configuration`](crate::client::Client::describe_default_encryption_configuration).
///
/// See [`crate::client::fluent_builders::DescribeDefaultEncryptionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDefaultEncryptionConfiguration {
    _private: (),
}
impl DescribeDefaultEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultEncryptionConfigurationInput`](crate::input::DescribeDefaultEncryptionConfigurationInput)
    pub fn builder() -> crate::input::describe_default_encryption_configuration_input::Builder {
        crate::input::describe_default_encryption_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeDefaultEncryptionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDefaultEncryptionConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeDefaultEncryptionConfigurationOutput,
        crate::error::DescribeDefaultEncryptionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_default_encryption_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_default_encryption_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_gateway`](crate::client::Client::describe_gateway).
///
/// See [`crate::client::fluent_builders::DescribeGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGateway {
    _private: (),
}
impl DescribeGateway {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayInput`](crate::input::DescribeGatewayInput)
    pub fn builder() -> crate::input::describe_gateway_input::Builder {
        crate::input::describe_gateway_input::Builder::default()
    }
    /// Creates a new `DescribeGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGateway {
    type Output = std::result::Result<
        crate::output::DescribeGatewayOutput,
        crate::error::DescribeGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_gateway_error(response)
        } else {
            crate::operation_deser::parse_describe_gateway_response(response)
        }
    }
}

/// Operation shape for `DescribeGatewayCapabilityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_gateway_capability_configuration`](crate::client::Client::describe_gateway_capability_configuration).
///
/// See [`crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGatewayCapabilityConfiguration {
    _private: (),
}
impl DescribeGatewayCapabilityConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeGatewayCapabilityConfigurationInput`](crate::input::DescribeGatewayCapabilityConfigurationInput)
    pub fn builder() -> crate::input::describe_gateway_capability_configuration_input::Builder {
        crate::input::describe_gateway_capability_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeGatewayCapabilityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGatewayCapabilityConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeGatewayCapabilityConfigurationOutput,
        crate::error::DescribeGatewayCapabilityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_gateway_capability_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_gateway_capability_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_logging_options`](crate::client::Client::describe_logging_options).
///
/// See [`crate::client::fluent_builders::DescribeLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoggingOptions {
    _private: (),
}
impl DescribeLoggingOptions {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    pub fn builder() -> crate::input::describe_logging_options_input::Builder {
        crate::input::describe_logging_options_input::Builder::default()
    }
    /// Creates a new `DescribeLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoggingOptions {
    type Output = std::result::Result<
        crate::output::DescribeLoggingOptionsOutput,
        crate::error::DescribeLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_logging_options_error(response)
        } else {
            crate::operation_deser::parse_describe_logging_options_response(response)
        }
    }
}

/// Operation shape for `DescribePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_portal`](crate::client::Client::describe_portal).
///
/// See [`crate::client::fluent_builders::DescribePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePortal {
    _private: (),
}
impl DescribePortal {
    /// Creates a new builder-style object to manufacture [`DescribePortalInput`](crate::input::DescribePortalInput)
    pub fn builder() -> crate::input::describe_portal_input::Builder {
        crate::input::describe_portal_input::Builder::default()
    }
    /// Creates a new `DescribePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePortal {
    type Output =
        std::result::Result<crate::output::DescribePortalOutput, crate::error::DescribePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_portal_error(response)
        } else {
            crate::operation_deser::parse_describe_portal_response(response)
        }
    }
}

/// Operation shape for `DescribeProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_project`](crate::client::Client::describe_project).
///
/// See [`crate::client::fluent_builders::DescribeProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProject {
    _private: (),
}
impl DescribeProject {
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
    /// Creates a new `DescribeProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProject {
    type Output = std::result::Result<
        crate::output::DescribeProjectOutput,
        crate::error::DescribeProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_project_error(response)
        } else {
            crate::operation_deser::parse_describe_project_response(response)
        }
    }
}

/// Operation shape for `DescribeStorageConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_storage_configuration`](crate::client::Client::describe_storage_configuration).
///
/// See [`crate::client::fluent_builders::DescribeStorageConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStorageConfiguration {
    _private: (),
}
impl DescribeStorageConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeStorageConfigurationInput`](crate::input::DescribeStorageConfigurationInput)
    pub fn builder() -> crate::input::describe_storage_configuration_input::Builder {
        crate::input::describe_storage_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeStorageConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStorageConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeStorageConfigurationOutput,
        crate::error::DescribeStorageConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_storage_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_storage_configuration_response(response)
        }
    }
}

/// Operation shape for `DisassociateAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_assets`](crate::client::Client::disassociate_assets).
///
/// See [`crate::client::fluent_builders::DisassociateAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAssets {
    _private: (),
}
impl DisassociateAssets {
    /// Creates a new builder-style object to manufacture [`DisassociateAssetsInput`](crate::input::DisassociateAssetsInput)
    pub fn builder() -> crate::input::disassociate_assets_input::Builder {
        crate::input::disassociate_assets_input::Builder::default()
    }
    /// Creates a new `DisassociateAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAssets {
    type Output = std::result::Result<
        crate::output::DisassociateAssetsOutput,
        crate::error::DisassociateAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_assets_error(response)
        } else {
            crate::operation_deser::parse_disassociate_assets_response(response)
        }
    }
}

/// Operation shape for `GetAssetPropertyAggregates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_asset_property_aggregates`](crate::client::Client::get_asset_property_aggregates).
///
/// See [`crate::client::fluent_builders::GetAssetPropertyAggregates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssetPropertyAggregates {
    _private: (),
}
impl GetAssetPropertyAggregates {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyAggregatesInput`](crate::input::GetAssetPropertyAggregatesInput)
    pub fn builder() -> crate::input::get_asset_property_aggregates_input::Builder {
        crate::input::get_asset_property_aggregates_input::Builder::default()
    }
    /// Creates a new `GetAssetPropertyAggregates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssetPropertyAggregates {
    type Output = std::result::Result<
        crate::output::GetAssetPropertyAggregatesOutput,
        crate::error::GetAssetPropertyAggregatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_asset_property_aggregates_error(response)
        } else {
            crate::operation_deser::parse_get_asset_property_aggregates_response(response)
        }
    }
}

/// Operation shape for `GetAssetPropertyValue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_asset_property_value`](crate::client::Client::get_asset_property_value).
///
/// See [`crate::client::fluent_builders::GetAssetPropertyValue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssetPropertyValue {
    _private: (),
}
impl GetAssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueInput`](crate::input::GetAssetPropertyValueInput)
    pub fn builder() -> crate::input::get_asset_property_value_input::Builder {
        crate::input::get_asset_property_value_input::Builder::default()
    }
    /// Creates a new `GetAssetPropertyValue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssetPropertyValue {
    type Output = std::result::Result<
        crate::output::GetAssetPropertyValueOutput,
        crate::error::GetAssetPropertyValueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_asset_property_value_error(response)
        } else {
            crate::operation_deser::parse_get_asset_property_value_response(response)
        }
    }
}

/// Operation shape for `GetAssetPropertyValueHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_asset_property_value_history`](crate::client::Client::get_asset_property_value_history).
///
/// See [`crate::client::fluent_builders::GetAssetPropertyValueHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssetPropertyValueHistory {
    _private: (),
}
impl GetAssetPropertyValueHistory {
    /// Creates a new builder-style object to manufacture [`GetAssetPropertyValueHistoryInput`](crate::input::GetAssetPropertyValueHistoryInput)
    pub fn builder() -> crate::input::get_asset_property_value_history_input::Builder {
        crate::input::get_asset_property_value_history_input::Builder::default()
    }
    /// Creates a new `GetAssetPropertyValueHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssetPropertyValueHistory {
    type Output = std::result::Result<
        crate::output::GetAssetPropertyValueHistoryOutput,
        crate::error::GetAssetPropertyValueHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_asset_property_value_history_error(response)
        } else {
            crate::operation_deser::parse_get_asset_property_value_history_response(response)
        }
    }
}

/// Operation shape for `GetInterpolatedAssetPropertyValues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_interpolated_asset_property_values`](crate::client::Client::get_interpolated_asset_property_values).
///
/// See [`crate::client::fluent_builders::GetInterpolatedAssetPropertyValues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInterpolatedAssetPropertyValues {
    _private: (),
}
impl GetInterpolatedAssetPropertyValues {
    /// Creates a new builder-style object to manufacture [`GetInterpolatedAssetPropertyValuesInput`](crate::input::GetInterpolatedAssetPropertyValuesInput)
    pub fn builder() -> crate::input::get_interpolated_asset_property_values_input::Builder {
        crate::input::get_interpolated_asset_property_values_input::Builder::default()
    }
    /// Creates a new `GetInterpolatedAssetPropertyValues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInterpolatedAssetPropertyValues {
    type Output = std::result::Result<
        crate::output::GetInterpolatedAssetPropertyValuesOutput,
        crate::error::GetInterpolatedAssetPropertyValuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_interpolated_asset_property_values_error(response)
        } else {
            crate::operation_deser::parse_get_interpolated_asset_property_values_response(response)
        }
    }
}

/// Operation shape for `ListAccessPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_policies`](crate::client::Client::list_access_policies).
///
/// See [`crate::client::fluent_builders::ListAccessPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessPolicies {
    _private: (),
}
impl ListAccessPolicies {
    /// Creates a new builder-style object to manufacture [`ListAccessPoliciesInput`](crate::input::ListAccessPoliciesInput)
    pub fn builder() -> crate::input::list_access_policies_input::Builder {
        crate::input::list_access_policies_input::Builder::default()
    }
    /// Creates a new `ListAccessPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessPolicies {
    type Output = std::result::Result<
        crate::output::ListAccessPoliciesOutput,
        crate::error::ListAccessPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_policies_error(response)
        } else {
            crate::operation_deser::parse_list_access_policies_response(response)
        }
    }
}

/// Operation shape for `ListAssetModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_asset_models`](crate::client::Client::list_asset_models).
///
/// See [`crate::client::fluent_builders::ListAssetModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssetModels {
    _private: (),
}
impl ListAssetModels {
    /// Creates a new builder-style object to manufacture [`ListAssetModelsInput`](crate::input::ListAssetModelsInput)
    pub fn builder() -> crate::input::list_asset_models_input::Builder {
        crate::input::list_asset_models_input::Builder::default()
    }
    /// Creates a new `ListAssetModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssetModels {
    type Output = std::result::Result<
        crate::output::ListAssetModelsOutput,
        crate::error::ListAssetModelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_asset_models_error(response)
        } else {
            crate::operation_deser::parse_list_asset_models_response(response)
        }
    }
}

/// Operation shape for `ListAssetRelationships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_asset_relationships`](crate::client::Client::list_asset_relationships).
///
/// See [`crate::client::fluent_builders::ListAssetRelationships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssetRelationships {
    _private: (),
}
impl ListAssetRelationships {
    /// Creates a new builder-style object to manufacture [`ListAssetRelationshipsInput`](crate::input::ListAssetRelationshipsInput)
    pub fn builder() -> crate::input::list_asset_relationships_input::Builder {
        crate::input::list_asset_relationships_input::Builder::default()
    }
    /// Creates a new `ListAssetRelationships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssetRelationships {
    type Output = std::result::Result<
        crate::output::ListAssetRelationshipsOutput,
        crate::error::ListAssetRelationshipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_asset_relationships_error(response)
        } else {
            crate::operation_deser::parse_list_asset_relationships_response(response)
        }
    }
}

/// Operation shape for `ListAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assets`](crate::client::Client::list_assets).
///
/// See [`crate::client::fluent_builders::ListAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssets {
    _private: (),
}
impl ListAssets {
    /// Creates a new builder-style object to manufacture [`ListAssetsInput`](crate::input::ListAssetsInput)
    pub fn builder() -> crate::input::list_assets_input::Builder {
        crate::input::list_assets_input::Builder::default()
    }
    /// Creates a new `ListAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssets {
    type Output =
        std::result::Result<crate::output::ListAssetsOutput, crate::error::ListAssetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assets_error(response)
        } else {
            crate::operation_deser::parse_list_assets_response(response)
        }
    }
}

/// Operation shape for `ListAssociatedAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associated_assets`](crate::client::Client::list_associated_assets).
///
/// See [`crate::client::fluent_builders::ListAssociatedAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociatedAssets {
    _private: (),
}
impl ListAssociatedAssets {
    /// Creates a new builder-style object to manufacture [`ListAssociatedAssetsInput`](crate::input::ListAssociatedAssetsInput)
    pub fn builder() -> crate::input::list_associated_assets_input::Builder {
        crate::input::list_associated_assets_input::Builder::default()
    }
    /// Creates a new `ListAssociatedAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociatedAssets {
    type Output = std::result::Result<
        crate::output::ListAssociatedAssetsOutput,
        crate::error::ListAssociatedAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associated_assets_error(response)
        } else {
            crate::operation_deser::parse_list_associated_assets_response(response)
        }
    }
}

/// Operation shape for `ListDashboards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dashboards`](crate::client::Client::list_dashboards).
///
/// See [`crate::client::fluent_builders::ListDashboards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDashboards {
    _private: (),
}
impl ListDashboards {
    /// Creates a new builder-style object to manufacture [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    pub fn builder() -> crate::input::list_dashboards_input::Builder {
        crate::input::list_dashboards_input::Builder::default()
    }
    /// Creates a new `ListDashboards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDashboards {
    type Output =
        std::result::Result<crate::output::ListDashboardsOutput, crate::error::ListDashboardsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dashboards_error(response)
        } else {
            crate::operation_deser::parse_list_dashboards_response(response)
        }
    }
}

/// Operation shape for `ListGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_gateways`](crate::client::Client::list_gateways).
///
/// See [`crate::client::fluent_builders::ListGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGateways {
    _private: (),
}
impl ListGateways {
    /// Creates a new builder-style object to manufacture [`ListGatewaysInput`](crate::input::ListGatewaysInput)
    pub fn builder() -> crate::input::list_gateways_input::Builder {
        crate::input::list_gateways_input::Builder::default()
    }
    /// Creates a new `ListGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGateways {
    type Output =
        std::result::Result<crate::output::ListGatewaysOutput, crate::error::ListGatewaysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_gateways_error(response)
        } else {
            crate::operation_deser::parse_list_gateways_response(response)
        }
    }
}

/// Operation shape for `ListPortals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_portals`](crate::client::Client::list_portals).
///
/// See [`crate::client::fluent_builders::ListPortals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPortals {
    _private: (),
}
impl ListPortals {
    /// Creates a new builder-style object to manufacture [`ListPortalsInput`](crate::input::ListPortalsInput)
    pub fn builder() -> crate::input::list_portals_input::Builder {
        crate::input::list_portals_input::Builder::default()
    }
    /// Creates a new `ListPortals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPortals {
    type Output =
        std::result::Result<crate::output::ListPortalsOutput, crate::error::ListPortalsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_portals_error(response)
        } else {
            crate::operation_deser::parse_list_portals_response(response)
        }
    }
}

/// Operation shape for `ListProjectAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_project_assets`](crate::client::Client::list_project_assets).
///
/// See [`crate::client::fluent_builders::ListProjectAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjectAssets {
    _private: (),
}
impl ListProjectAssets {
    /// Creates a new builder-style object to manufacture [`ListProjectAssetsInput`](crate::input::ListProjectAssetsInput)
    pub fn builder() -> crate::input::list_project_assets_input::Builder {
        crate::input::list_project_assets_input::Builder::default()
    }
    /// Creates a new `ListProjectAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjectAssets {
    type Output = std::result::Result<
        crate::output::ListProjectAssetsOutput,
        crate::error::ListProjectAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_project_assets_error(response)
        } else {
            crate::operation_deser::parse_list_project_assets_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutDefaultEncryptionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_default_encryption_configuration`](crate::client::Client::put_default_encryption_configuration).
///
/// See [`crate::client::fluent_builders::PutDefaultEncryptionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDefaultEncryptionConfiguration {
    _private: (),
}
impl PutDefaultEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`PutDefaultEncryptionConfigurationInput`](crate::input::PutDefaultEncryptionConfigurationInput)
    pub fn builder() -> crate::input::put_default_encryption_configuration_input::Builder {
        crate::input::put_default_encryption_configuration_input::Builder::default()
    }
    /// Creates a new `PutDefaultEncryptionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDefaultEncryptionConfiguration {
    type Output = std::result::Result<
        crate::output::PutDefaultEncryptionConfigurationOutput,
        crate::error::PutDefaultEncryptionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_default_encryption_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_default_encryption_configuration_response(response)
        }
    }
}

/// Operation shape for `PutLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_logging_options`](crate::client::Client::put_logging_options).
///
/// See [`crate::client::fluent_builders::PutLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLoggingOptions {
    _private: (),
}
impl PutLoggingOptions {
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    pub fn builder() -> crate::input::put_logging_options_input::Builder {
        crate::input::put_logging_options_input::Builder::default()
    }
    /// Creates a new `PutLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLoggingOptions {
    type Output = std::result::Result<
        crate::output::PutLoggingOptionsOutput,
        crate::error::PutLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_logging_options_error(response)
        } else {
            crate::operation_deser::parse_put_logging_options_response(response)
        }
    }
}

/// Operation shape for `PutStorageConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_storage_configuration`](crate::client::Client::put_storage_configuration).
///
/// See [`crate::client::fluent_builders::PutStorageConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutStorageConfiguration {
    _private: (),
}
impl PutStorageConfiguration {
    /// Creates a new builder-style object to manufacture [`PutStorageConfigurationInput`](crate::input::PutStorageConfigurationInput)
    pub fn builder() -> crate::input::put_storage_configuration_input::Builder {
        crate::input::put_storage_configuration_input::Builder::default()
    }
    /// Creates a new `PutStorageConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutStorageConfiguration {
    type Output = std::result::Result<
        crate::output::PutStorageConfigurationOutput,
        crate::error::PutStorageConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_storage_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_storage_configuration_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccessPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_access_policy`](crate::client::Client::update_access_policy).
///
/// See [`crate::client::fluent_builders::UpdateAccessPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccessPolicy {
    _private: (),
}
impl UpdateAccessPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateAccessPolicyInput`](crate::input::UpdateAccessPolicyInput)
    pub fn builder() -> crate::input::update_access_policy_input::Builder {
        crate::input::update_access_policy_input::Builder::default()
    }
    /// Creates a new `UpdateAccessPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccessPolicy {
    type Output = std::result::Result<
        crate::output::UpdateAccessPolicyOutput,
        crate::error::UpdateAccessPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_access_policy_error(response)
        } else {
            crate::operation_deser::parse_update_access_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateAsset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_asset`](crate::client::Client::update_asset).
///
/// See [`crate::client::fluent_builders::UpdateAsset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAsset {
    _private: (),
}
impl UpdateAsset {
    /// Creates a new builder-style object to manufacture [`UpdateAssetInput`](crate::input::UpdateAssetInput)
    pub fn builder() -> crate::input::update_asset_input::Builder {
        crate::input::update_asset_input::Builder::default()
    }
    /// Creates a new `UpdateAsset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAsset {
    type Output =
        std::result::Result<crate::output::UpdateAssetOutput, crate::error::UpdateAssetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_asset_error(response)
        } else {
            crate::operation_deser::parse_update_asset_response(response)
        }
    }
}

/// Operation shape for `UpdateAssetModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_asset_model`](crate::client::Client::update_asset_model).
///
/// See [`crate::client::fluent_builders::UpdateAssetModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssetModel {
    _private: (),
}
impl UpdateAssetModel {
    /// Creates a new builder-style object to manufacture [`UpdateAssetModelInput`](crate::input::UpdateAssetModelInput)
    pub fn builder() -> crate::input::update_asset_model_input::Builder {
        crate::input::update_asset_model_input::Builder::default()
    }
    /// Creates a new `UpdateAssetModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssetModel {
    type Output = std::result::Result<
        crate::output::UpdateAssetModelOutput,
        crate::error::UpdateAssetModelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_asset_model_error(response)
        } else {
            crate::operation_deser::parse_update_asset_model_response(response)
        }
    }
}

/// Operation shape for `UpdateAssetProperty`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_asset_property`](crate::client::Client::update_asset_property).
///
/// See [`crate::client::fluent_builders::UpdateAssetProperty`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssetProperty {
    _private: (),
}
impl UpdateAssetProperty {
    /// Creates a new builder-style object to manufacture [`UpdateAssetPropertyInput`](crate::input::UpdateAssetPropertyInput)
    pub fn builder() -> crate::input::update_asset_property_input::Builder {
        crate::input::update_asset_property_input::Builder::default()
    }
    /// Creates a new `UpdateAssetProperty` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssetProperty {
    type Output = std::result::Result<
        crate::output::UpdateAssetPropertyOutput,
        crate::error::UpdateAssetPropertyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_asset_property_error(response)
        } else {
            crate::operation_deser::parse_update_asset_property_response(response)
        }
    }
}

/// Operation shape for `UpdateDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dashboard`](crate::client::Client::update_dashboard).
///
/// See [`crate::client::fluent_builders::UpdateDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDashboard {
    _private: (),
}
impl UpdateDashboard {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    pub fn builder() -> crate::input::update_dashboard_input::Builder {
        crate::input::update_dashboard_input::Builder::default()
    }
    /// Creates a new `UpdateDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDashboard {
    type Output = std::result::Result<
        crate::output::UpdateDashboardOutput,
        crate::error::UpdateDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dashboard_error(response)
        } else {
            crate::operation_deser::parse_update_dashboard_response(response)
        }
    }
}

/// Operation shape for `UpdateGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway`](crate::client::Client::update_gateway).
///
/// See [`crate::client::fluent_builders::UpdateGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGateway {
    _private: (),
}
impl UpdateGateway {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayInput`](crate::input::UpdateGatewayInput)
    pub fn builder() -> crate::input::update_gateway_input::Builder {
        crate::input::update_gateway_input::Builder::default()
    }
    /// Creates a new `UpdateGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGateway {
    type Output =
        std::result::Result<crate::output::UpdateGatewayOutput, crate::error::UpdateGatewayError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_gateway_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_response(response)
        }
    }
}

/// Operation shape for `UpdateGatewayCapabilityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_gateway_capability_configuration`](crate::client::Client::update_gateway_capability_configuration).
///
/// See [`crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGatewayCapabilityConfiguration {
    _private: (),
}
impl UpdateGatewayCapabilityConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateGatewayCapabilityConfigurationInput`](crate::input::UpdateGatewayCapabilityConfigurationInput)
    pub fn builder() -> crate::input::update_gateway_capability_configuration_input::Builder {
        crate::input::update_gateway_capability_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateGatewayCapabilityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGatewayCapabilityConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateGatewayCapabilityConfigurationOutput,
        crate::error::UpdateGatewayCapabilityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_update_gateway_capability_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_gateway_capability_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdatePortal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_portal`](crate::client::Client::update_portal).
///
/// See [`crate::client::fluent_builders::UpdatePortal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePortal {
    _private: (),
}
impl UpdatePortal {
    /// Creates a new builder-style object to manufacture [`UpdatePortalInput`](crate::input::UpdatePortalInput)
    pub fn builder() -> crate::input::update_portal_input::Builder {
        crate::input::update_portal_input::Builder::default()
    }
    /// Creates a new `UpdatePortal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePortal {
    type Output =
        std::result::Result<crate::output::UpdatePortalOutput, crate::error::UpdatePortalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_portal_error(response)
        } else {
            crate::operation_deser::parse_update_portal_response(response)
        }
    }
}

/// Operation shape for `UpdateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project`](crate::client::Client::update_project).
///
/// See [`crate::client::fluent_builders::UpdateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProject {
    _private: (),
}
impl UpdateProject {
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
    /// Creates a new `UpdateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProject {
    type Output =
        std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_error(response)
        } else {
            crate::operation_deser::parse_update_project_response(response)
        }
    }
}
