// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAssetsError {
    /// Kind of error that occurred.
    pub kind: AssociateAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAssetsErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAssetsErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAssetsError {
    fn code(&self) -> Option<&str> {
        AssociateAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAssetsError {
    /// Creates a new `AssociateAssetsError`.
    pub fn new(kind: AssociateAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssetsErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssetsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateAssetsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for AssociateAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAssetsErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchAssociateProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateProjectAssetsError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateProjectAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateProjectAssetsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateProjectAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateProjectAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchAssociateProjectAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchAssociateProjectAssetsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            BatchAssociateProjectAssetsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateProjectAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchAssociateProjectAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAssociateProjectAssetsError {
    fn code(&self) -> Option<&str> {
        BatchAssociateProjectAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateProjectAssetsError {
    /// Creates a new `BatchAssociateProjectAssetsError`.
    pub fn new(kind: BatchAssociateProjectAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateProjectAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateProjectAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateProjectAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateProjectAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchAssociateProjectAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateProjectAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `BatchAssociateProjectAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateProjectAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `BatchAssociateProjectAssetsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateProjectAssetsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `BatchAssociateProjectAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateProjectAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `BatchAssociateProjectAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateProjectAssetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchAssociateProjectAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateProjectAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchAssociateProjectAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchAssociateProjectAssetsErrorKind::LimitExceededException(_inner) => Some(_inner),
            BatchAssociateProjectAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchAssociateProjectAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchAssociateProjectAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDisassociateProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateProjectAssetsError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateProjectAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateProjectAssetsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateProjectAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateProjectAssetsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateProjectAssetsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateProjectAssetsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateProjectAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchDisassociateProjectAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDisassociateProjectAssetsError {
    fn code(&self) -> Option<&str> {
        BatchDisassociateProjectAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateProjectAssetsError {
    /// Creates a new `BatchDisassociateProjectAssetsError`.
    pub fn new(
        kind: BatchDisassociateProjectAssetsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateProjectAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateProjectAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateProjectAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateProjectAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchDisassociateProjectAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateProjectAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `BatchDisassociateProjectAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateProjectAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `BatchDisassociateProjectAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateProjectAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `BatchDisassociateProjectAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateProjectAssetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchDisassociateProjectAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateProjectAssetsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateProjectAssetsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateProjectAssetsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateProjectAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchDisassociateProjectAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchPutAssetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutAssetPropertyValueError {
    /// Kind of error that occurred.
    pub kind: BatchPutAssetPropertyValueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutAssetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutAssetPropertyValueErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested service is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutAssetPropertyValueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutAssetPropertyValueErrorKind::ConflictingOperationException(_inner) => {
                _inner.fmt(f)
            }
            BatchPutAssetPropertyValueErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchPutAssetPropertyValueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchPutAssetPropertyValueErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            BatchPutAssetPropertyValueErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchPutAssetPropertyValueErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchPutAssetPropertyValueErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchPutAssetPropertyValueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutAssetPropertyValueError {
    fn code(&self) -> Option<&str> {
        BatchPutAssetPropertyValueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutAssetPropertyValueError {
    /// Creates a new `BatchPutAssetPropertyValueError`.
    pub fn new(kind: BatchPutAssetPropertyValueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutAssetPropertyValueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutAssetPropertyValueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutAssetPropertyValueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutAssetPropertyValueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `BatchPutAssetPropertyValueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutAssetPropertyValueErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchPutAssetPropertyValueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutAssetPropertyValueErrorKind::ConflictingOperationException(_inner) => {
                Some(_inner)
            }
            BatchPutAssetPropertyValueErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchPutAssetPropertyValueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchPutAssetPropertyValueErrorKind::LimitExceededException(_inner) => Some(_inner),
            BatchPutAssetPropertyValueErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchPutAssetPropertyValueErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            BatchPutAssetPropertyValueErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchPutAssetPropertyValueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccessPolicyErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccessPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAccessPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAccessPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAccessPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccessPolicyError {
    fn code(&self) -> Option<&str> {
        CreateAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccessPolicyError {
    /// Creates a new `CreateAccessPolicyError`.
    pub fn new(kind: CreateAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAccessPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateAccessPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateAccessPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateAccessPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccessPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAccessPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAccessPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAccessPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssetError {
    /// Kind of error that occurred.
    pub kind: CreateAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssetErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssetErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssetError {
    fn code(&self) -> Option<&str> {
        CreateAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssetError {
    /// Creates a new `CreateAssetError`.
    pub fn new(kind: CreateAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAssetErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateAssetErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateAssetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssetErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            CreateAssetErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAssetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAssetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAssetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssetModelError {
    /// Kind of error that occurred.
    pub kind: CreateAssetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssetModelErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssetModelErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAssetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssetModelError {
    fn code(&self) -> Option<&str> {
        CreateAssetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssetModelError {
    /// Creates a new `CreateAssetModelError`.
    pub fn new(kind: CreateAssetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateAssetModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssetModelErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAssetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssetModelErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAssetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDashboardError {
    /// Kind of error that occurred.
    pub kind: CreateDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDashboardErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDashboardError {
    fn code(&self) -> Option<&str> {
        CreateDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDashboardError {
    /// Creates a new `CreateDashboardError`.
    pub fn new(kind: CreateDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDashboardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateDashboardErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDashboardErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDashboardErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDashboardErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDashboardErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGatewayError {
    /// Kind of error that occurred.
    pub kind: CreateGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGatewayErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGatewayErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateGatewayErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateGatewayErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGatewayErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGatewayError {
    fn code(&self) -> Option<&str> {
        CreateGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGatewayError {
    /// Creates a new `CreateGatewayError`.
    pub fn new(kind: CreateGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateGatewayErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateGatewayErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateGatewayErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateGatewayErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateGatewayErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGatewayErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateGatewayErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateGatewayErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGatewayErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePortalError {
    /// Kind of error that occurred.
    pub kind: CreatePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePortalErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePortalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePortalError {
    fn code(&self) -> Option<&str> {
        CreatePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePortalError {
    /// Creates a new `CreatePortalError`.
    pub fn new(kind: CreatePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePortalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePortalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortalErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreatePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreatePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreatePortalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreatePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePortalErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreatePortalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePortalErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateProjectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateProjectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessPolicyErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAccessPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAccessPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessPolicyError {
    /// Creates a new `DeleteAccessPolicyError`.
    pub fn new(kind: DeleteAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAccessPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAccessPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAccessPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAccessPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAccessPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssetError {
    /// Kind of error that occurred.
    pub kind: DeleteAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssetErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssetErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssetError {
    fn code(&self) -> Option<&str> {
        DeleteAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssetError {
    /// Creates a new `DeleteAssetError`.
    pub fn new(kind: DeleteAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAssetErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `DeleteAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteAssetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssetErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            DeleteAssetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAssetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssetModelError {
    /// Kind of error that occurred.
    pub kind: DeleteAssetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssetModelErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssetModelErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            DeleteAssetModelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAssetModelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAssetModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssetModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAssetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssetModelError {
    fn code(&self) -> Option<&str> {
        DeleteAssetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssetModelError {
    /// Creates a new `DeleteAssetModelError`.
    pub fn new(kind: DeleteAssetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAssetModelErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetModelErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetModelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetModelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetModelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetModelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAssetModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssetModelErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteAssetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssetModelErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            DeleteAssetModelErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAssetModelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAssetModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssetModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAssetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDashboardError {
    /// Kind of error that occurred.
    pub kind: DeleteDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDashboardErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDashboardError {
    fn code(&self) -> Option<&str> {
        DeleteDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDashboardError {
    /// Creates a new `DeleteDashboardError`.
    pub fn new(kind: DeleteDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDashboardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDashboardErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDashboardErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGatewayError {
    /// Kind of error that occurred.
    pub kind: DeleteGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGatewayErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGatewayErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGatewayError {
    fn code(&self) -> Option<&str> {
        DeleteGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGatewayError {
    /// Creates a new `DeleteGatewayError`.
    pub fn new(kind: DeleteGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteGatewayErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGatewayErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteGatewayErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePortalError {
    /// Kind of error that occurred.
    pub kind: DeletePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePortalErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePortalErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePortalError {
    fn code(&self) -> Option<&str> {
        DeletePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePortalError {
    /// Creates a new `DeletePortalError`.
    pub fn new(kind: DeletePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePortalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePortalErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortalErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeletePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeletePortalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeletePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePortalErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            DeletePortalErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeletePortalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeletePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteProjectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccessPolicyErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccessPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAccessPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAccessPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccessPolicyError {
    fn code(&self) -> Option<&str> {
        DescribeAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccessPolicyError {
    /// Creates a new `DescribeAccessPolicyError`.
    pub fn new(kind: DescribeAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAccessPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAccessPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAccessPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccessPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAccessPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAccessPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssetError {
    /// Kind of error that occurred.
    pub kind: DescribeAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssetErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssetError {
    fn code(&self) -> Option<&str> {
        DescribeAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssetError {
    /// Creates a new `DescribeAssetError`.
    pub fn new(kind: DescribeAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAssetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeAssetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAssetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssetModelError {
    /// Kind of error that occurred.
    pub kind: DescribeAssetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssetModelErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssetModelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAssetModelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAssetModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAssetModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAssetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssetModelError {
    fn code(&self) -> Option<&str> {
        DescribeAssetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssetModelError {
    /// Creates a new `DescribeAssetModelError`.
    pub fn new(kind: DescribeAssetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAssetModelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetModelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetModelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetModelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetModelErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAssetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssetModelErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAssetModelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAssetModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAssetModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAssetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssetProperty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssetPropertyError {
    /// Kind of error that occurred.
    pub kind: DescribeAssetPropertyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssetProperty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssetPropertyErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssetPropertyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssetPropertyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAssetPropertyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAssetPropertyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAssetPropertyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAssetPropertyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssetPropertyError {
    fn code(&self) -> Option<&str> {
        DescribeAssetPropertyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssetPropertyError {
    /// Creates a new `DescribeAssetPropertyError`.
    pub fn new(kind: DescribeAssetPropertyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssetPropertyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssetPropertyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssetPropertyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssetPropertyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAssetPropertyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetPropertyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetPropertyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetPropertyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetPropertyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetPropertyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAssetPropertyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssetPropertyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAssetPropertyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssetPropertyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAssetPropertyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAssetPropertyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAssetPropertyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAssetPropertyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDashboardError {
    /// Kind of error that occurred.
    pub kind: DescribeDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDashboardErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDashboardError {
    fn code(&self) -> Option<&str> {
        DescribeDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDashboardError {
    /// Creates a new `DescribeDashboardError`.
    pub fn new(kind: DescribeDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDashboardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDashboardErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDefaultEncryptionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDefaultEncryptionConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeDefaultEncryptionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDefaultEncryptionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDefaultEncryptionConfigurationErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDefaultEncryptionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDefaultEncryptionConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDefaultEncryptionConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeDefaultEncryptionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDefaultEncryptionConfigurationError {
    /// Creates a new `DescribeDefaultEncryptionConfigurationError`.
    pub fn new(
        kind: DescribeDefaultEncryptionConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDefaultEncryptionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDefaultEncryptionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDefaultEncryptionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDefaultEncryptionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDefaultEncryptionConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultEncryptionConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDefaultEncryptionConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDefaultEncryptionConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultEncryptionConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDefaultEncryptionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDefaultEncryptionConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeDefaultEncryptionConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGatewayError {
    /// Kind of error that occurred.
    pub kind: DescribeGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGatewayErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGatewayErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeGatewayErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGatewayError {
    fn code(&self) -> Option<&str> {
        DescribeGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGatewayError {
    /// Creates a new `DescribeGatewayError`.
    pub fn new(kind: DescribeGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeGatewayErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeGatewayErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGatewayErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeGatewayErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGatewayCapabilityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGatewayCapabilityConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeGatewayCapabilityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGatewayCapabilityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGatewayCapabilityConfigurationErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGatewayCapabilityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGatewayCapabilityConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGatewayCapabilityConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeGatewayCapabilityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGatewayCapabilityConfigurationError {
    /// Creates a new `DescribeGatewayCapabilityConfigurationError`.
    pub fn new(
        kind: DescribeGatewayCapabilityConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGatewayCapabilityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGatewayCapabilityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGatewayCapabilityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGatewayCapabilityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeGatewayCapabilityConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayCapabilityConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayCapabilityConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeGatewayCapabilityConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayCapabilityConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeGatewayCapabilityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGatewayCapabilityConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeGatewayCapabilityConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeLoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoggingOptionsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoggingOptionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoggingOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeLoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoggingOptionsError {
    /// Creates a new `DescribeLoggingOptionsError`.
    pub fn new(kind: DescribeLoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeLoggingOptionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingOptionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeLoggingOptionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeLoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoggingOptionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePortalError {
    /// Kind of error that occurred.
    pub kind: DescribePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePortalErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePortalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribePortalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePortalError {
    fn code(&self) -> Option<&str> {
        DescribePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePortalError {
    /// Creates a new `DescribePortalError`.
    pub fn new(kind: DescribePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePortalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribePortalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribePortalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePortalErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribePortalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProjectError {
    /// Kind of error that occurred.
    pub kind: DescribeProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProjectErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProjectError {
    fn code(&self) -> Option<&str> {
        DescribeProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProjectError {
    /// Creates a new `DescribeProjectError`.
    pub fn new(kind: DescribeProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeProjectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStorageConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStorageConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeStorageConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStorageConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStorageConfigurationErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStorageConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStorageConfigurationErrorKind::ConflictingOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeStorageConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeStorageConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeStorageConfigurationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeStorageConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeStorageConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeStorageConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStorageConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeStorageConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStorageConfigurationError {
    /// Creates a new `DescribeStorageConfigurationError`.
    pub fn new(kind: DescribeStorageConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStorageConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStorageConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStorageConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStorageConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeStorageConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStorageConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeStorageConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStorageConfigurationErrorKind::ConflictingOperationException(_inner) => {
                Some(_inner)
            }
            DescribeStorageConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeStorageConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeStorageConfigurationErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeStorageConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeStorageConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeStorageConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateAssetsError {
    /// Kind of error that occurred.
    pub kind: DisassociateAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateAssetsErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateAssetsErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            DisassociateAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DisassociateAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateAssetsError {
    fn code(&self) -> Option<&str> {
        DisassociateAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateAssetsError {
    /// Creates a new `DisassociateAssetsError`.
    pub fn new(kind: DisassociateAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateAssetsErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssetsErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateAssetsErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            DisassociateAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DisassociateAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssetPropertyAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssetPropertyAggregatesError {
    /// Kind of error that occurred.
    pub kind: GetAssetPropertyAggregatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssetPropertyAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssetPropertyAggregatesErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested service is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssetPropertyAggregatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssetPropertyAggregatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetAssetPropertyAggregatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetAssetPropertyAggregatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssetPropertyAggregatesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetAssetPropertyAggregatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAssetPropertyAggregatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssetPropertyAggregatesError {
    fn code(&self) -> Option<&str> {
        GetAssetPropertyAggregatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssetPropertyAggregatesError {
    /// Creates a new `GetAssetPropertyAggregatesError`.
    pub fn new(kind: GetAssetPropertyAggregatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssetPropertyAggregatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssetPropertyAggregatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssetPropertyAggregatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssetPropertyAggregatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAssetPropertyAggregatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyAggregatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyAggregatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyAggregatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyAggregatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyAggregatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyAggregatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyAggregatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyAggregatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyAggregatesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetAssetPropertyAggregatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssetPropertyAggregatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetAssetPropertyAggregatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetAssetPropertyAggregatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssetPropertyAggregatesErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetAssetPropertyAggregatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAssetPropertyAggregatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssetPropertyValueError {
    /// Kind of error that occurred.
    pub kind: GetAssetPropertyValueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssetPropertyValue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssetPropertyValueErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested service is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssetPropertyValueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssetPropertyValueErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssetPropertyValueError {
    fn code(&self) -> Option<&str> {
        GetAssetPropertyValueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssetPropertyValueError {
    /// Creates a new `GetAssetPropertyValueError`.
    pub fn new(kind: GetAssetPropertyValueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssetPropertyValueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssetPropertyValueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssetPropertyValueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssetPropertyValueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAssetPropertyValueErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetAssetPropertyValueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssetPropertyValueErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetAssetPropertyValueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetAssetPropertyValueErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssetPropertyValueErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetAssetPropertyValueErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAssetPropertyValueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssetPropertyValueHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssetPropertyValueHistoryError {
    /// Kind of error that occurred.
    pub kind: GetAssetPropertyValueHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssetPropertyValueHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssetPropertyValueHistoryErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested service is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssetPropertyValueHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssetPropertyValueHistoryErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetAssetPropertyValueHistoryErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueHistoryErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetAssetPropertyValueHistoryErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetAssetPropertyValueHistoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAssetPropertyValueHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssetPropertyValueHistoryError {
    fn code(&self) -> Option<&str> {
        GetAssetPropertyValueHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssetPropertyValueHistoryError {
    /// Creates a new `GetAssetPropertyValueHistoryError`.
    pub fn new(kind: GetAssetPropertyValueHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssetPropertyValueHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssetPropertyValueHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssetPropertyValueHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssetPropertyValueHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAssetPropertyValueHistoryErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueHistoryErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueHistoryErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueHistoryErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueHistoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueHistoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueHistoryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueHistoryErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetAssetPropertyValueHistoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssetPropertyValueHistoryErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetAssetPropertyValueHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssetPropertyValueHistoryErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetAssetPropertyValueHistoryErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetAssetPropertyValueHistoryErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetAssetPropertyValueHistoryErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetAssetPropertyValueHistoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAssetPropertyValueHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInterpolatedAssetPropertyValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInterpolatedAssetPropertyValuesError {
    /// Kind of error that occurred.
    pub kind: GetInterpolatedAssetPropertyValuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInterpolatedAssetPropertyValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInterpolatedAssetPropertyValuesErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested service is unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInterpolatedAssetPropertyValuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInterpolatedAssetPropertyValuesErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInterpolatedAssetPropertyValuesError {
    fn code(&self) -> Option<&str> {
        GetInterpolatedAssetPropertyValuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInterpolatedAssetPropertyValuesError {
    /// Creates a new `GetInterpolatedAssetPropertyValuesError`.
    pub fn new(
        kind: GetInterpolatedAssetPropertyValuesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInterpolatedAssetPropertyValuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInterpolatedAssetPropertyValuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInterpolatedAssetPropertyValuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInterpolatedAssetPropertyValuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetInterpolatedAssetPropertyValuesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInterpolatedAssetPropertyValuesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetInterpolatedAssetPropertyValuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInterpolatedAssetPropertyValuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetInterpolatedAssetPropertyValuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInterpolatedAssetPropertyValuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetInterpolatedAssetPropertyValuesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInterpolatedAssetPropertyValuesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `GetInterpolatedAssetPropertyValuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInterpolatedAssetPropertyValuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetInterpolatedAssetPropertyValuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInterpolatedAssetPropertyValuesErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetInterpolatedAssetPropertyValuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccessPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAccessPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccessPoliciesErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccessPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccessPoliciesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAccessPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAccessPoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAccessPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccessPoliciesError {
    fn code(&self) -> Option<&str> {
        ListAccessPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccessPoliciesError {
    /// Creates a new `ListAccessPoliciesError`.
    pub fn new(kind: ListAccessPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccessPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccessPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccessPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccessPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAccessPoliciesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessPoliciesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListAccessPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListAccessPoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessPoliciesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAccessPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccessPoliciesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAccessPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAccessPoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAccessPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssetModelsError {
    /// Kind of error that occurred.
    pub kind: ListAssetModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssetModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssetModelsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssetModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssetModelsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAssetModelsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAssetModelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAssetModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssetModelsError {
    fn code(&self) -> Option<&str> {
        ListAssetModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssetModelsError {
    /// Creates a new `ListAssetModelsError`.
    pub fn new(kind: ListAssetModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssetModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssetModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssetModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssetModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAssetModelsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetModelsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetModelsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetModelsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetModelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAssetModelsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListAssetModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssetModelsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAssetModelsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAssetModelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAssetModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssetRelationships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssetRelationshipsError {
    /// Kind of error that occurred.
    pub kind: ListAssetRelationshipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssetRelationships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssetRelationshipsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssetRelationshipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssetRelationshipsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAssetRelationshipsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAssetRelationshipsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAssetRelationshipsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAssetRelationshipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssetRelationshipsError {
    fn code(&self) -> Option<&str> {
        ListAssetRelationshipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssetRelationshipsError {
    /// Creates a new `ListAssetRelationshipsError`.
    pub fn new(kind: ListAssetRelationshipsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssetRelationshipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssetRelationshipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssetRelationshipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssetRelationshipsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAssetRelationshipsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetRelationshipsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetRelationshipsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetRelationshipsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetRelationshipsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetRelationshipsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetRelationshipsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetRelationshipsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAssetRelationshipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssetRelationshipsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAssetRelationshipsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAssetRelationshipsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAssetRelationshipsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAssetRelationshipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssetsError {
    /// Kind of error that occurred.
    pub kind: ListAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssetsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssetsError {
    fn code(&self) -> Option<&str> {
        ListAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssetsError {
    /// Creates a new `ListAssetsError`.
    pub fn new(kind: ListAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `ListAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `ListAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAssetsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociatedAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociatedAssetsError {
    /// Kind of error that occurred.
    pub kind: ListAssociatedAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociatedAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociatedAssetsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociatedAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociatedAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAssociatedAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAssociatedAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAssociatedAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAssociatedAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociatedAssetsError {
    fn code(&self) -> Option<&str> {
        ListAssociatedAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociatedAssetsError {
    /// Creates a new `ListAssociatedAssetsError`.
    pub fn new(kind: ListAssociatedAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociatedAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociatedAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociatedAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociatedAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAssociatedAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListAssociatedAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListAssociatedAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAssociatedAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedAssetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAssociatedAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociatedAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAssociatedAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAssociatedAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAssociatedAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAssociatedAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDashboardsError {
    /// Kind of error that occurred.
    pub kind: ListDashboardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDashboardsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDashboardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDashboardsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDashboardsError {
    fn code(&self) -> Option<&str> {
        ListDashboardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDashboardsError {
    /// Creates a new `ListDashboardsError`.
    pub fn new(kind: ListDashboardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDashboardsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListDashboardsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListDashboardsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDashboardsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDashboardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDashboardsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDashboardsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDashboardsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDashboardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGatewaysError {
    /// Kind of error that occurred.
    pub kind: ListGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGatewaysErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGatewaysErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListGatewaysErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListGatewaysErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGatewaysError {
    fn code(&self) -> Option<&str> {
        ListGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGatewaysError {
    /// Creates a new `ListGatewaysError`.
    pub fn new(kind: ListGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListGatewaysErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewaysErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListGatewaysErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewaysErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListGatewaysErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListGatewaysErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGatewaysErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListGatewaysErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListGatewaysErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPortals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPortalsError {
    /// Kind of error that occurred.
    pub kind: ListPortalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPortals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPortalsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPortalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPortalsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPortalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPortalsError {
    fn code(&self) -> Option<&str> {
        ListPortalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPortalsError {
    /// Creates a new `ListPortalsError`.
    pub fn new(kind: ListPortalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPortalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPortalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPortalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPortalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPortalsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPortalsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListPortalsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `ListPortalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPortalsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListPortalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPortalsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPortalsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPortalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPortalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectAssetsError {
    /// Kind of error that occurred.
    pub kind: ListProjectAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjectAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectAssetsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectAssetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListProjectAssetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListProjectAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProjectAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectAssetsError {
    fn code(&self) -> Option<&str> {
        ListProjectAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectAssetsError {
    /// Creates a new `ListProjectAssetsError`.
    pub fn new(kind: ListProjectAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectAssetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProjectAssetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectAssetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectAssetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectAssetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectAssetsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProjectAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectAssetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListProjectAssetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListProjectAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProjectAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListProjectsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListProjectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDefaultEncryptionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDefaultEncryptionConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutDefaultEncryptionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDefaultEncryptionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDefaultEncryptionConfigurationErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDefaultEncryptionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDefaultEncryptionConfigurationErrorKind::ConflictingOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutDefaultEncryptionConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            PutDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            PutDefaultEncryptionConfigurationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutDefaultEncryptionConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            PutDefaultEncryptionConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDefaultEncryptionConfigurationError {
    fn code(&self) -> Option<&str> {
        PutDefaultEncryptionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDefaultEncryptionConfigurationError {
    /// Creates a new `PutDefaultEncryptionConfigurationError`.
    pub fn new(
        kind: PutDefaultEncryptionConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDefaultEncryptionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDefaultEncryptionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDefaultEncryptionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDefaultEncryptionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutDefaultEncryptionConfigurationErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDefaultEncryptionConfigurationErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `PutDefaultEncryptionConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDefaultEncryptionConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `PutDefaultEncryptionConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutDefaultEncryptionConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDefaultEncryptionConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutDefaultEncryptionConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDefaultEncryptionConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutDefaultEncryptionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDefaultEncryptionConfigurationErrorKind::ConflictingOperationException(_inner) => {
                Some(_inner)
            }
            PutDefaultEncryptionConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            PutDefaultEncryptionConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            PutDefaultEncryptionConfigurationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            PutDefaultEncryptionConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutDefaultEncryptionConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: PutLoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLoggingOptionsErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLoggingOptionsErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLoggingOptionsError {
    fn code(&self) -> Option<&str> {
        PutLoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLoggingOptionsError {
    /// Creates a new `PutLoggingOptionsError`.
    pub fn new(kind: PutLoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutLoggingOptionsErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `PutLoggingOptionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `PutLoggingOptionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutLoggingOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutLoggingOptionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutLoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLoggingOptionsErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutStorageConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutStorageConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutStorageConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutStorageConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutStorageConfigurationErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutStorageConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutStorageConfigurationErrorKind::ConflictingOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutStorageConfigurationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutStorageConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutStorageConfigurationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutStorageConfigurationErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            PutStorageConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutStorageConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutStorageConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutStorageConfigurationError {
    fn code(&self) -> Option<&str> {
        PutStorageConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutStorageConfigurationError {
    /// Creates a new `PutStorageConfigurationError`.
    pub fn new(kind: PutStorageConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutStorageConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutStorageConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutStorageConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutStorageConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutStorageConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutStorageConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutStorageConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutStorageConfigurationErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            PutStorageConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutStorageConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You've reached the limit for the number of tags allowed for a resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits and
    /// requirements</a> in the <i>Amazon Web Services General Reference</i>.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// <p>You are not authorized.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccessPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateAccessPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccessPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccessPolicyErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccessPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccessPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAccessPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAccessPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAccessPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAccessPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccessPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateAccessPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccessPolicyError {
    /// Creates a new `UpdateAccessPolicyError`.
    pub fn new(kind: UpdateAccessPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccessPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccessPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccessPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccessPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAccessPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAccessPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAccessPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAccessPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessPolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAccessPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccessPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAccessPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAccessPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAccessPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAccessPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssetError {
    /// Kind of error that occurred.
    pub kind: UpdateAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssetErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssetErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssetError {
    fn code(&self) -> Option<&str> {
        UpdateAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssetError {
    /// Creates a new `UpdateAssetError`.
    pub fn new(kind: UpdateAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateAssetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssetErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UpdateAssetErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAssetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssetModelError {
    /// Kind of error that occurred.
    pub kind: UpdateAssetModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssetModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssetModelErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssetModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssetModelErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAssetModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssetModelError {
    fn code(&self) -> Option<&str> {
        UpdateAssetModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssetModelError {
    /// Creates a new `UpdateAssetModelError`.
    pub fn new(kind: UpdateAssetModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssetModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssetModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssetModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssetModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetModelErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAssetModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssetModelErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAssetModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssetProperty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssetPropertyError {
    /// Kind of error that occurred.
    pub kind: UpdateAssetPropertyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssetProperty` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssetPropertyErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssetPropertyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssetPropertyErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UpdateAssetPropertyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAssetPropertyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAssetPropertyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssetPropertyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAssetPropertyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssetPropertyError {
    fn code(&self) -> Option<&str> {
        UpdateAssetPropertyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssetPropertyError {
    /// Creates a new `UpdateAssetPropertyError`.
    pub fn new(kind: UpdateAssetPropertyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssetPropertyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssetPropertyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssetPropertyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssetPropertyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAssetPropertyErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetPropertyErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetPropertyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetPropertyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetPropertyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetPropertyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetPropertyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetPropertyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAssetPropertyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssetPropertyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAssetPropertyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssetPropertyErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UpdateAssetPropertyErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAssetPropertyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAssetPropertyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssetPropertyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAssetPropertyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDashboardError {
    /// Kind of error that occurred.
    pub kind: UpdateDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDashboardErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDashboardError {
    fn code(&self) -> Option<&str> {
        UpdateDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDashboardError {
    /// Creates a new `UpdateDashboardError`.
    pub fn new(kind: UpdateDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDashboardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDashboardErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDashboardErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayError {
    /// Creates a new `UpdateGatewayError`.
    pub fn new(kind: UpdateGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateGatewayErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewayCapabilityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayCapabilityConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayCapabilityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewayCapabilityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayCapabilityConfigurationErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
    /// associate more than the allowed number of child assets or attempting to create more than the
    /// allowed number of properties for an asset model.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayCapabilityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayCapabilityConfigurationErrorKind::ConflictingOperationException(
                _inner,
            ) => _inner.fmt(f),
            UpdateGatewayCapabilityConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayCapabilityConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayCapabilityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGatewayCapabilityConfigurationError {
    /// Creates a new `UpdateGatewayCapabilityConfigurationError`.
    pub fn new(
        kind: UpdateGatewayCapabilityConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayCapabilityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayCapabilityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayCapabilityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayCapabilityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGatewayCapabilityConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayCapabilityConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateGatewayCapabilityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayCapabilityConfigurationErrorKind::ConflictingOperationException(
                _inner,
            ) => Some(_inner),
            UpdateGatewayCapabilityConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateGatewayCapabilityConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePortalError {
    /// Kind of error that occurred.
    pub kind: UpdatePortalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePortal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePortalErrorKind {
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictingOperationException(crate::error::ConflictingOperationException),
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePortalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePortalErrorKind::ConflictingOperationException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePortalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePortalError {
    fn code(&self) -> Option<&str> {
        UpdatePortalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePortalError {
    /// Creates a new `UpdatePortalError`.
    pub fn new(kind: UpdatePortalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePortalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePortalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePortalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePortalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdatePortalErrorKind::ConflictingOperationException`.
    pub fn is_conflicting_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::ConflictingOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePortalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePortalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdatePortalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdatePortalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePortalErrorKind::ConflictingOperationException(_inner) => Some(_inner),
            UpdatePortalErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdatePortalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdatePortalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePortalErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePortalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>IoT SiteWise can't process your request right now. Try again later.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters. Check your request and try again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
    /// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
    /// on.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateProjectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Your request exceeded a rate limit. For example, you might have exceeded the number of
/// IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so
/// on.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The requested resource can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request isn't valid. This can occur if your request contains malformed JSON or
/// unsupported characters. Check your request and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>IoT SiteWise can't process your request right now. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>Your request has conflicting operations. This can occur if you're trying to perform more
/// than one operation on the same resource at the same time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictingOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that conflicts with this operation.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that conflicts with this operation.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictingOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictingOperationException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
impl ConflictingOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictingOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictingOperationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictingOperationException {}
/// See [`ConflictingOperationException`](crate::error::ConflictingOperationException)
pub mod conflicting_operation_exception {
    /// A builder for [`ConflictingOperationException`](crate::error::ConflictingOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that conflicts with this operation.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that conflicts with this operation.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the resource that conflicts with this operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that conflicts with this operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictingOperationException`](crate::error::ConflictingOperationException)
        pub fn build(self) -> crate::error::ConflictingOperationException {
            crate::error::ConflictingOperationException {
                message: self.message,
                resource_id: self.resource_id,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ConflictingOperationException {
    /// Creates a new builder-style object to manufacture [`ConflictingOperationException`](crate::error::ConflictingOperationException)
    pub fn builder() -> crate::error::conflicting_operation_exception::Builder {
        crate::error::conflicting_operation_exception::Builder::default()
    }
}

/// <p>You've reached the limit for a resource. For example, this can occur if you're trying to
/// associate more than the allowed number of child assets or attempting to create more than the
/// allowed number of properties for an asset model.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that already exists.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that already exists.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that already exists.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that already exists.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the resource that already exists.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that already exists.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
                resource_id: self.resource_id,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>You are not authorized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>You've reached the limit for the number of tags allowed for a resource. For more
/// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits and
/// requirements</a> in the <i>Amazon Web Services General Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of the resource with too many tags.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of the resource with too many tags.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource with too many tags.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The requested service is unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}
