// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSIoTSiteWise`.
///
/// This client allows ergonomic access to a `AWSIoTSiteWise`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateAssets` operation.
    ///
    /// See [`AssociateAssets`](crate::client::fluent_builders::AssociateAssets) for more information about the
    /// operation and its arguments.
    pub fn associate_assets(&self) -> fluent_builders::AssociateAssets<C, M, R> {
        fluent_builders::AssociateAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchAssociateProjectAssets` operation.
    ///
    /// See [`BatchAssociateProjectAssets`](crate::client::fluent_builders::BatchAssociateProjectAssets) for more information about the
    /// operation and its arguments.
    pub fn batch_associate_project_assets(
        &self,
    ) -> fluent_builders::BatchAssociateProjectAssets<C, M, R> {
        fluent_builders::BatchAssociateProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDisassociateProjectAssets` operation.
    ///
    /// See [`BatchDisassociateProjectAssets`](crate::client::fluent_builders::BatchDisassociateProjectAssets) for more information about the
    /// operation and its arguments.
    pub fn batch_disassociate_project_assets(
        &self,
    ) -> fluent_builders::BatchDisassociateProjectAssets<C, M, R> {
        fluent_builders::BatchDisassociateProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchPutAssetPropertyValue` operation.
    ///
    /// See [`BatchPutAssetPropertyValue`](crate::client::fluent_builders::BatchPutAssetPropertyValue) for more information about the
    /// operation and its arguments.
    pub fn batch_put_asset_property_value(
        &self,
    ) -> fluent_builders::BatchPutAssetPropertyValue<C, M, R> {
        fluent_builders::BatchPutAssetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccessPolicy` operation.
    ///
    /// See [`CreateAccessPolicy`](crate::client::fluent_builders::CreateAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_access_policy(&self) -> fluent_builders::CreateAccessPolicy<C, M, R> {
        fluent_builders::CreateAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAsset` operation.
    ///
    /// See [`CreateAsset`](crate::client::fluent_builders::CreateAsset) for more information about the
    /// operation and its arguments.
    pub fn create_asset(&self) -> fluent_builders::CreateAsset<C, M, R> {
        fluent_builders::CreateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssetModel` operation.
    ///
    /// See [`CreateAssetModel`](crate::client::fluent_builders::CreateAssetModel) for more information about the
    /// operation and its arguments.
    pub fn create_asset_model(&self) -> fluent_builders::CreateAssetModel<C, M, R> {
        fluent_builders::CreateAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDashboard` operation.
    ///
    /// See [`CreateDashboard`](crate::client::fluent_builders::CreateDashboard) for more information about the
    /// operation and its arguments.
    pub fn create_dashboard(&self) -> fluent_builders::CreateDashboard<C, M, R> {
        fluent_builders::CreateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGateway` operation.
    ///
    /// See [`CreateGateway`](crate::client::fluent_builders::CreateGateway) for more information about the
    /// operation and its arguments.
    pub fn create_gateway(&self) -> fluent_builders::CreateGateway<C, M, R> {
        fluent_builders::CreateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePortal` operation.
    ///
    /// See [`CreatePortal`](crate::client::fluent_builders::CreatePortal) for more information about the
    /// operation and its arguments.
    pub fn create_portal(&self) -> fluent_builders::CreatePortal<C, M, R> {
        fluent_builders::CreatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPolicy` operation.
    ///
    /// See [`DeleteAccessPolicy`](crate::client::fluent_builders::DeleteAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_access_policy(&self) -> fluent_builders::DeleteAccessPolicy<C, M, R> {
        fluent_builders::DeleteAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAsset` operation.
    ///
    /// See [`DeleteAsset`](crate::client::fluent_builders::DeleteAsset) for more information about the
    /// operation and its arguments.
    pub fn delete_asset(&self) -> fluent_builders::DeleteAsset<C, M, R> {
        fluent_builders::DeleteAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssetModel` operation.
    ///
    /// See [`DeleteAssetModel`](crate::client::fluent_builders::DeleteAssetModel) for more information about the
    /// operation and its arguments.
    pub fn delete_asset_model(&self) -> fluent_builders::DeleteAssetModel<C, M, R> {
        fluent_builders::DeleteAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDashboard` operation.
    ///
    /// See [`DeleteDashboard`](crate::client::fluent_builders::DeleteDashboard) for more information about the
    /// operation and its arguments.
    pub fn delete_dashboard(&self) -> fluent_builders::DeleteDashboard<C, M, R> {
        fluent_builders::DeleteDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGateway` operation.
    ///
    /// See [`DeleteGateway`](crate::client::fluent_builders::DeleteGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_gateway(&self) -> fluent_builders::DeleteGateway<C, M, R> {
        fluent_builders::DeleteGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePortal` operation.
    ///
    /// See [`DeletePortal`](crate::client::fluent_builders::DeletePortal) for more information about the
    /// operation and its arguments.
    pub fn delete_portal(&self) -> fluent_builders::DeletePortal<C, M, R> {
        fluent_builders::DeletePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccessPolicy` operation.
    ///
    /// See [`DescribeAccessPolicy`](crate::client::fluent_builders::DescribeAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_access_policy(&self) -> fluent_builders::DescribeAccessPolicy<C, M, R> {
        fluent_builders::DescribeAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAsset` operation.
    ///
    /// See [`DescribeAsset`](crate::client::fluent_builders::DescribeAsset) for more information about the
    /// operation and its arguments.
    pub fn describe_asset(&self) -> fluent_builders::DescribeAsset<C, M, R> {
        fluent_builders::DescribeAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssetModel` operation.
    ///
    /// See [`DescribeAssetModel`](crate::client::fluent_builders::DescribeAssetModel) for more information about the
    /// operation and its arguments.
    pub fn describe_asset_model(&self) -> fluent_builders::DescribeAssetModel<C, M, R> {
        fluent_builders::DescribeAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssetProperty` operation.
    ///
    /// See [`DescribeAssetProperty`](crate::client::fluent_builders::DescribeAssetProperty) for more information about the
    /// operation and its arguments.
    pub fn describe_asset_property(&self) -> fluent_builders::DescribeAssetProperty<C, M, R> {
        fluent_builders::DescribeAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDashboard` operation.
    ///
    /// See [`DescribeDashboard`](crate::client::fluent_builders::DescribeDashboard) for more information about the
    /// operation and its arguments.
    pub fn describe_dashboard(&self) -> fluent_builders::DescribeDashboard<C, M, R> {
        fluent_builders::DescribeDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDefaultEncryptionConfiguration` operation.
    ///
    /// See [`DescribeDefaultEncryptionConfiguration`](crate::client::fluent_builders::DescribeDefaultEncryptionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_default_encryption_configuration(
        &self,
    ) -> fluent_builders::DescribeDefaultEncryptionConfiguration<C, M, R> {
        fluent_builders::DescribeDefaultEncryptionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGateway` operation.
    ///
    /// See [`DescribeGateway`](crate::client::fluent_builders::DescribeGateway) for more information about the
    /// operation and its arguments.
    pub fn describe_gateway(&self) -> fluent_builders::DescribeGateway<C, M, R> {
        fluent_builders::DescribeGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGatewayCapabilityConfiguration` operation.
    ///
    /// See [`DescribeGatewayCapabilityConfiguration`](crate::client::fluent_builders::DescribeGatewayCapabilityConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_gateway_capability_configuration(
        &self,
    ) -> fluent_builders::DescribeGatewayCapabilityConfiguration<C, M, R> {
        fluent_builders::DescribeGatewayCapabilityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoggingOptions` operation.
    ///
    /// See [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions<C, M, R> {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePortal` operation.
    ///
    /// See [`DescribePortal`](crate::client::fluent_builders::DescribePortal) for more information about the
    /// operation and its arguments.
    pub fn describe_portal(&self) -> fluent_builders::DescribePortal<C, M, R> {
        fluent_builders::DescribePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStorageConfiguration` operation.
    ///
    /// See [`DescribeStorageConfiguration`](crate::client::fluent_builders::DescribeStorageConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_storage_configuration(
        &self,
    ) -> fluent_builders::DescribeStorageConfiguration<C, M, R> {
        fluent_builders::DescribeStorageConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateAssets` operation.
    ///
    /// See [`DisassociateAssets`](crate::client::fluent_builders::DisassociateAssets) for more information about the
    /// operation and its arguments.
    pub fn disassociate_assets(&self) -> fluent_builders::DisassociateAssets<C, M, R> {
        fluent_builders::DisassociateAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssetPropertyAggregates` operation.
    ///
    /// See [`GetAssetPropertyAggregates`](crate::client::fluent_builders::GetAssetPropertyAggregates) for more information about the
    /// operation and its arguments.
    pub fn get_asset_property_aggregates(
        &self,
    ) -> fluent_builders::GetAssetPropertyAggregates<C, M, R> {
        fluent_builders::GetAssetPropertyAggregates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssetPropertyValue` operation.
    ///
    /// See [`GetAssetPropertyValue`](crate::client::fluent_builders::GetAssetPropertyValue) for more information about the
    /// operation and its arguments.
    pub fn get_asset_property_value(&self) -> fluent_builders::GetAssetPropertyValue<C, M, R> {
        fluent_builders::GetAssetPropertyValue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssetPropertyValueHistory` operation.
    ///
    /// See [`GetAssetPropertyValueHistory`](crate::client::fluent_builders::GetAssetPropertyValueHistory) for more information about the
    /// operation and its arguments.
    pub fn get_asset_property_value_history(
        &self,
    ) -> fluent_builders::GetAssetPropertyValueHistory<C, M, R> {
        fluent_builders::GetAssetPropertyValueHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInterpolatedAssetPropertyValues` operation.
    ///
    /// See [`GetInterpolatedAssetPropertyValues`](crate::client::fluent_builders::GetInterpolatedAssetPropertyValues) for more information about the
    /// operation and its arguments.
    pub fn get_interpolated_asset_property_values(
        &self,
    ) -> fluent_builders::GetInterpolatedAssetPropertyValues<C, M, R> {
        fluent_builders::GetInterpolatedAssetPropertyValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessPolicies` operation.
    ///
    /// See [`ListAccessPolicies`](crate::client::fluent_builders::ListAccessPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_access_policies(&self) -> fluent_builders::ListAccessPolicies<C, M, R> {
        fluent_builders::ListAccessPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssetModels` operation.
    ///
    /// See [`ListAssetModels`](crate::client::fluent_builders::ListAssetModels) for more information about the
    /// operation and its arguments.
    pub fn list_asset_models(&self) -> fluent_builders::ListAssetModels<C, M, R> {
        fluent_builders::ListAssetModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssetRelationships` operation.
    ///
    /// See [`ListAssetRelationships`](crate::client::fluent_builders::ListAssetRelationships) for more information about the
    /// operation and its arguments.
    pub fn list_asset_relationships(&self) -> fluent_builders::ListAssetRelationships<C, M, R> {
        fluent_builders::ListAssetRelationships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssets` operation.
    ///
    /// See [`ListAssets`](crate::client::fluent_builders::ListAssets) for more information about the
    /// operation and its arguments.
    pub fn list_assets(&self) -> fluent_builders::ListAssets<C, M, R> {
        fluent_builders::ListAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociatedAssets` operation.
    ///
    /// See [`ListAssociatedAssets`](crate::client::fluent_builders::ListAssociatedAssets) for more information about the
    /// operation and its arguments.
    pub fn list_associated_assets(&self) -> fluent_builders::ListAssociatedAssets<C, M, R> {
        fluent_builders::ListAssociatedAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDashboards` operation.
    ///
    /// See [`ListDashboards`](crate::client::fluent_builders::ListDashboards) for more information about the
    /// operation and its arguments.
    pub fn list_dashboards(&self) -> fluent_builders::ListDashboards<C, M, R> {
        fluent_builders::ListDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGateways` operation.
    ///
    /// See [`ListGateways`](crate::client::fluent_builders::ListGateways) for more information about the
    /// operation and its arguments.
    pub fn list_gateways(&self) -> fluent_builders::ListGateways<C, M, R> {
        fluent_builders::ListGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPortals` operation.
    ///
    /// See [`ListPortals`](crate::client::fluent_builders::ListPortals) for more information about the
    /// operation and its arguments.
    pub fn list_portals(&self) -> fluent_builders::ListPortals<C, M, R> {
        fluent_builders::ListPortals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjectAssets` operation.
    ///
    /// See [`ListProjectAssets`](crate::client::fluent_builders::ListProjectAssets) for more information about the
    /// operation and its arguments.
    pub fn list_project_assets(&self) -> fluent_builders::ListProjectAssets<C, M, R> {
        fluent_builders::ListProjectAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDefaultEncryptionConfiguration` operation.
    ///
    /// See [`PutDefaultEncryptionConfiguration`](crate::client::fluent_builders::PutDefaultEncryptionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_default_encryption_configuration(
        &self,
    ) -> fluent_builders::PutDefaultEncryptionConfiguration<C, M, R> {
        fluent_builders::PutDefaultEncryptionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLoggingOptions` operation.
    ///
    /// See [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions<C, M, R> {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutStorageConfiguration` operation.
    ///
    /// See [`PutStorageConfiguration`](crate::client::fluent_builders::PutStorageConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_storage_configuration(&self) -> fluent_builders::PutStorageConfiguration<C, M, R> {
        fluent_builders::PutStorageConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccessPolicy` operation.
    ///
    /// See [`UpdateAccessPolicy`](crate::client::fluent_builders::UpdateAccessPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_access_policy(&self) -> fluent_builders::UpdateAccessPolicy<C, M, R> {
        fluent_builders::UpdateAccessPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAsset` operation.
    ///
    /// See [`UpdateAsset`](crate::client::fluent_builders::UpdateAsset) for more information about the
    /// operation and its arguments.
    pub fn update_asset(&self) -> fluent_builders::UpdateAsset<C, M, R> {
        fluent_builders::UpdateAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssetModel` operation.
    ///
    /// See [`UpdateAssetModel`](crate::client::fluent_builders::UpdateAssetModel) for more information about the
    /// operation and its arguments.
    pub fn update_asset_model(&self) -> fluent_builders::UpdateAssetModel<C, M, R> {
        fluent_builders::UpdateAssetModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssetProperty` operation.
    ///
    /// See [`UpdateAssetProperty`](crate::client::fluent_builders::UpdateAssetProperty) for more information about the
    /// operation and its arguments.
    pub fn update_asset_property(&self) -> fluent_builders::UpdateAssetProperty<C, M, R> {
        fluent_builders::UpdateAssetProperty::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDashboard` operation.
    ///
    /// See [`UpdateDashboard`](crate::client::fluent_builders::UpdateDashboard) for more information about the
    /// operation and its arguments.
    pub fn update_dashboard(&self) -> fluent_builders::UpdateDashboard<C, M, R> {
        fluent_builders::UpdateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGateway` operation.
    ///
    /// See [`UpdateGateway`](crate::client::fluent_builders::UpdateGateway) for more information about the
    /// operation and its arguments.
    pub fn update_gateway(&self) -> fluent_builders::UpdateGateway<C, M, R> {
        fluent_builders::UpdateGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGatewayCapabilityConfiguration` operation.
    ///
    /// See [`UpdateGatewayCapabilityConfiguration`](crate::client::fluent_builders::UpdateGatewayCapabilityConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_gateway_capability_configuration(
        &self,
    ) -> fluent_builders::UpdateGatewayCapabilityConfiguration<C, M, R> {
        fluent_builders::UpdateGatewayCapabilityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePortal` operation.
    ///
    /// See [`UpdatePortal`](crate::client::fluent_builders::UpdatePortal) for more information about the
    /// operation and its arguments.
    pub fn update_portal(&self) -> fluent_builders::UpdatePortal<C, M, R> {
        fluent_builders::UpdatePortal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAssets`.
    ///
    /// <p>Associates a child asset with the given parent asset through a hierarchy defined in the
    /// parent asset's model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_assets_input::Builder,
    }
    impl<C, M, R> AssociateAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAssetsInputOperationOutputAlias,
                crate::output::AssociateAssetsOutput,
                crate::error::AssociateAssetsError,
                crate::input::AssociateAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the parent asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(inp);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn child_asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_asset_id(inp);
            self
        }
        /// <p>The ID of the child asset to be associated.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_child_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateProjectAssets`.
    ///
    /// <p>Associates a group (batch) of assets with an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchAssociateProjectAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_associate_project_assets_input::Builder,
    }
    impl<C, M, R> BatchAssociateProjectAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchAssociateProjectAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchAssociateProjectAssetsInputOperationOutputAlias,
                crate::output::BatchAssociateProjectAssetsOutput,
                crate::error::BatchAssociateProjectAssetsError,
                crate::input::BatchAssociateProjectAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project to which to associate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// Appends an item to `assetIds`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn asset_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_ids(inp);
            self
        }
        /// <p>The IDs of the assets to be associated to the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_asset_ids(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateProjectAssets`.
    ///
    /// <p>Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDisassociateProjectAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_disassociate_project_assets_input::Builder,
    }
    impl<C, M, R> BatchDisassociateProjectAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDisassociateProjectAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDisassociateProjectAssetsInputOperationOutputAlias,
                crate::output::BatchDisassociateProjectAssetsOutput,
                crate::error::BatchDisassociateProjectAssetsError,
                crate::input::BatchDisassociateProjectAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project from which to disassociate the assets.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// Appends an item to `assetIds`.
        ///
        /// To override the contents of this collection use [`set_asset_ids`](Self::set_asset_ids).
        ///
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn asset_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_ids(inp);
            self
        }
        /// <p>The IDs of the assets to be disassociated from the project.</p>
        pub fn set_asset_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_asset_ids(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchPutAssetPropertyValue`.
    ///
    /// <p>Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value
    /// (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p>
    /// </li>
    /// <li>
    /// <p>A <code>propertyAlias</code>, which is a data stream alias (for example,
    /// <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more
    /// than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps
    /// outside of the inclusive range of [-7 days, +10 minutes] and returns a
    /// <code>TimestampOutOfRangeException</code> error.</p>
    /// <p>For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer
    /// TQV has a different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>,
    /// then storing <code>{T1, GOOD, V2}</code> replaces the existing TQV.</p>
    /// </important>
    /// <p>IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchPutAssetPropertyValue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_asset_property_value_input::Builder,
    }
    impl<C, M, R> BatchPutAssetPropertyValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutAssetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutAssetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutAssetPropertyValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutAssetPropertyValueInputOperationOutputAlias,
                crate::output::BatchPutAssetPropertyValueOutput,
                crate::error::BatchPutAssetPropertyValueError,
                crate::input::BatchPutAssetPropertyValueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of asset property value entries for the batch put request. You can specify up to
        /// 10 entries per request.</p>
        pub fn entries(mut self, inp: impl Into<crate::model::PutAssetPropertyValueEntry>) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>The list of asset property value entries for the batch put request. You can specify up to
        /// 10 entries per request.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPolicy`.
    ///
    /// <p>Creates an access policy that grants the specified identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or
    /// IAM user) access to the specified IoT SiteWise Monitor portal or project resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_policy_input::Builder,
    }
    impl<C, M, R> CreateAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessPolicyInputOperationOutputAlias,
                crate::output::CreateAccessPolicyOutput,
                crate::error::CreateAccessPolicyError,
                crate::input::CreateAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, inp: crate::model::Identity) -> Self {
            self.inner = self.inner.access_policy_identity(inp);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_identity(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.access_policy_resource(inp);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_resource(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, inp: crate::model::Permission) -> Self {
            self.inner = self.inner.access_policy_permission(inp);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_permission(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
        /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the access policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
        /// IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAsset`.
    ///
    /// <p>Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_asset_input::Builder,
    }
    impl<C, M, R> CreateAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssetInputOperationOutputAlias,
                crate::output::CreateAssetOutput,
                crate::error::CreateAssetError,
                crate::input::CreateAssetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_name(inp);
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_name(input);
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn asset_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(inp);
            self
        }
        /// <p>The ID of the asset model from which to create the asset.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssetModel`.
    ///
    /// <p>Creates an asset model from specified property and hierarchy definitions. You create
    /// assets from asset models. With asset models, you can easily create assets of the same type
    /// that have standardized definitions. Each asset created from a model inherits the asset model's
    /// property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_asset_model_input::Builder,
    }
    impl<C, M, R> CreateAssetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssetModelInputOperationOutputAlias,
                crate::output::CreateAssetModelOutput,
                crate::error::CreateAssetModelError,
                crate::input::CreateAssetModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_name(inp);
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_name(input);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_description(inp);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_description(input);
            self
        }
        /// Appends an item to `assetModelProperties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(
            mut self,
            inp: impl Into<crate::model::AssetModelPropertyDefinition>,
        ) -> Self {
            self.inner = self.inner.asset_model_properties(inp);
            self
        }
        /// <p>The property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelPropertyDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_properties(input);
            self
        }
        /// Appends an item to `assetModelHierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
        /// whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(
            mut self,
            inp: impl Into<crate::model::AssetModelHierarchyDefinition>,
        ) -> Self {
            self.inner = self.inner.asset_model_hierarchies(inp);
            self
        }
        /// <p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
        /// whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchyDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_hierarchies(input);
            self
        }
        /// Appends an item to `assetModelCompositeModels`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            inp: impl Into<crate::model::AssetModelCompositeModelDefinition>,
        ) -> Self {
            self.inner = self.inner.asset_model_composite_models(inp);
            self
        }
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssetModelCompositeModelDefinition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_asset_model_composite_models(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the asset model. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDashboard`.
    ///
    /// <p>Creates a dashboard in an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dashboard_input::Builder,
    }
    impl<C, M, R> CreateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDashboardInputOperationOutputAlias,
                crate::output::CreateDashboardOutput,
                crate::error::CreateDashboardError,
                crate::input::CreateDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project in which to create the dashboard.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_name(inp);
            self
        }
        /// <p>A friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_name(input);
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn dashboard_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_description(inp);
            self
        }
        /// <p>A description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_description(input);
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_definition(inp);
            self
        }
        /// <p>The dashboard definition specified in a JSON literal. For detailed information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_definition(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the dashboard. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGateway`.
    ///
    /// <p>Creates a gateway, which is a virtual or edge device that delivers industrial data streams
    /// from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_gateway_input::Builder,
    }
    impl<C, M, R> CreateGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGatewayInputOperationOutputAlias,
                crate::output::CreateGatewayOutput,
                crate::error::CreateGatewayError,
                crate::input::CreateGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(inp);
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn gateway_platform(mut self, inp: crate::model::GatewayPlatform) -> Self {
            self.inner = self.inner.gateway_platform(inp);
            self
        }
        /// <p>The gateway's platform. You can only specify one platform in a gateway.</p>
        pub fn set_gateway_platform(
            mut self,
            input: std::option::Option<crate::model::GatewayPlatform>,
        ) -> Self {
            self.inner = self.inner.set_gateway_platform(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the gateway. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePortal`.
    ///
    /// <p>Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM
    /// to authenticate portal users and manage user permissions.</p>
    /// <note>
    /// <p>Before you can sign in to a new portal, you must add at least one identity to that
    /// portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal
    /// administrators</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_portal_input::Builder,
    }
    impl<C, M, R> CreatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePortalInputOperationOutputAlias,
                crate::output::CreatePortalOutput,
                crate::error::CreatePortalError,
                crate::input::CreatePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name for the portal.</p>
        pub fn portal_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_name(inp);
            self
        }
        /// <p>A friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_name(input);
            self
        }
        /// <p>A description for the portal.</p>
        pub fn portal_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_description(inp);
            self
        }
        /// <p>A description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_description(input);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_contact_email(inp);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_contact_email(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
        /// image is displayed on a dark background.</p>
        pub fn portal_logo_image_file(mut self, inp: crate::model::ImageFile) -> Self {
            self.inner = self.inner.portal_logo_image_file(inp);
            self
        }
        /// <p>A logo image to display in the portal. Upload a square, high-resolution image. The
        /// image is displayed on a dark background.</p>
        pub fn set_portal_logo_image_file(
            mut self,
            input: std::option::Option<crate::model::ImageFile>,
        ) -> Self {
            self.inner = self.inner.set_portal_logo_image_file(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the portal. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following
        /// options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
        /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
        /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
        /// the China Regions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
        /// user permissions. This option is only available in the China Regions.</p>
        /// </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code>
        /// </p>
        pub fn portal_auth_mode(mut self, inp: crate::model::AuthMode) -> Self {
            self.inner = self.inner.portal_auth_mode(inp);
            self
        }
        /// <p>The service to use to authenticate users to the portal. Choose from the following
        /// options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
        /// user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO</a> in the
        /// <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than
        /// the China Regions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
        /// user permissions. This option is only available in the China Regions.</p>
        /// </li>
        /// </ul>
        /// <p>You can't change this value after you create a portal.</p>
        /// <p>Default: <code>SSO</code>
        /// </p>
        pub fn set_portal_auth_mode(
            mut self,
            input: std::option::Option<crate::model::AuthMode>,
        ) -> Self {
            self.inner = self.inner.set_portal_auth_mode(input);
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        /// <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
        /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
        /// address in Amazon SES</a>.</p>
        /// </important>
        pub fn notification_sender_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_sender_email(inp);
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        /// <important>
        /// <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
        /// function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
        /// address in Amazon SES</a>.</p>
        /// </important>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_sender_email(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, inp: crate::model::Alarms) -> Self {
            self.inner = self.inner.alarms(inp);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.inner = self.inner.set_alarms(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a project in the specified portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn portal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(inp);
            self
        }
        /// <p>The ID of the portal in which to create the project.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>A friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A description for the project.</p>
        pub fn project_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_description(inp);
            self
        }
        /// <p>A description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_description(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the project. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPolicy`.
    ///
    /// <p>Deletes an access policy that grants the specified identity access to the specified
    /// IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_policy_input::Builder,
    }
    impl<C, M, R> DeleteAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPolicyInputOperationOutputAlias,
                crate::output::DeleteAccessPolicyOutput,
                crate::error::DeleteAccessPolicyError,
                crate::input::DeleteAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn access_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(inp);
            self
        }
        /// <p>The ID of the access policy to be deleted.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAsset`.
    ///
    /// <p>Deletes an asset. This action can't be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and
    /// models</a> in the <i>IoT SiteWise User Guide</i>. </p>
    /// <note>
    /// <p>You can't delete an asset that's associated to another asset. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_asset_input::Builder,
    }
    impl<C, M, R> DeleteAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssetInputOperationOutputAlias,
                crate::output::DeleteAssetOutput,
                crate::error::DeleteAssetError,
                crate::input::DeleteAssetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to delete.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset to delete.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssetModel`.
    ///
    /// <p>Deletes an asset model. This action can't be undone. You must delete all assets created
    /// from an asset model before you can delete the model. Also, you can't delete an asset model if
    /// a parent asset model exists that contains a property formula expression that depends on the
    /// asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_asset_model_input::Builder,
    }
    impl<C, M, R> DeleteAssetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssetModelInputOperationOutputAlias,
                crate::output::DeleteAssetModelOutput,
                crate::error::DeleteAssetModelError,
                crate::input::DeleteAssetModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model to delete.</p>
        pub fn asset_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(inp);
            self
        }
        /// <p>The ID of the asset model to delete.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDashboard`.
    ///
    /// <p>Deletes a dashboard from IoT SiteWise Monitor.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dashboard_input::Builder,
    }
    impl<C, M, R> DeleteDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDashboardInputOperationOutputAlias,
                crate::output::DeleteDashboardOutput,
                crate::error::DeleteDashboardError,
                crate::input::DeleteDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard to delete.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID of the dashboard to delete.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGateway`.
    ///
    /// <p>Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain
    /// in your gateway's file system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_gateway_input::Builder,
    }
    impl<C, M, R> DeleteGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGatewayInputOperationOutputAlias,
                crate::output::DeleteGatewayOutput,
                crate::error::DeleteGatewayError,
                crate::input::DeleteGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to delete.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the gateway to delete.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePortal`.
    ///
    /// <p>Deletes a portal from IoT SiteWise Monitor.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_portal_input::Builder,
    }
    impl<C, M, R> DeletePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePortalInputOperationOutputAlias,
                crate::output::DeletePortalOutput,
                crate::error::DeletePortalError,
                crate::input::DeletePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal to delete.</p>
        pub fn portal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(inp);
            self
        }
        /// <p>The ID of the portal to delete.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes a project from IoT SiteWise Monitor.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccessPolicy`.
    ///
    /// <p>Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or
    /// project.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_access_policy_input::Builder,
    }
    impl<C, M, R> DescribeAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccessPolicyInputOperationOutputAlias,
                crate::output::DescribeAccessPolicyOutput,
                crate::error::DescribeAccessPolicyError,
                crate::input::DescribeAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(inp);
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAsset`.
    ///
    /// <p>Retrieves information about an asset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_asset_input::Builder,
    }
    impl<C, M, R> DescribeAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssetInputOperationOutputAlias,
                crate::output::DescribeAssetOutput,
                crate::error::DescribeAssetError,
                crate::input::DescribeAssetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssetModel`.
    ///
    /// <p>Retrieves information about an asset model.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_asset_model_input::Builder,
    }
    impl<C, M, R> DescribeAssetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssetModelInputOperationOutputAlias,
                crate::output::DescribeAssetModelOutput,
                crate::error::DescribeAssetModelError,
                crate::input::DescribeAssetModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model.</p>
        pub fn asset_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(inp);
            self
        }
        /// <p>The ID of the asset model.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssetProperty`.
    ///
    /// <p>Retrieves information about an asset property.</p>
    /// <note>
    /// <p>When you call this operation for an attribute property, this response includes the
    /// default attribute value that you define in the asset model. If you update the default value
    /// in the model, this operation's response includes the new default value.</p>
    /// </note>
    /// <p>This operation doesn't return the value of the asset property. To get the value of an
    /// asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssetProperty<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_asset_property_input::Builder,
    }
    impl<C, M, R> DescribeAssetProperty<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssetPropertyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssetPropertyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssetPropertyInputOperationOutputAlias,
                crate::output::DescribeAssetPropertyOutput,
                crate::error::DescribeAssetPropertyError,
                crate::input::DescribeAssetPropertyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboard`.
    ///
    /// <p>Retrieves information about a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dashboard_input::Builder,
    }
    impl<C, M, R> DescribeDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDashboardInputOperationOutputAlias,
                crate::output::DescribeDashboardOutput,
                crate::error::DescribeDashboardError,
                crate::input::DescribeDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultEncryptionConfiguration`.
    ///
    /// <p>Retrieves information about the default encryption configuration for the Amazon Web Services account in
    /// the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDefaultEncryptionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_default_encryption_configuration_input::Builder,
    }
    impl<C, M, R> DescribeDefaultEncryptionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDefaultEncryptionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultEncryptionConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDefaultEncryptionConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDefaultEncryptionConfigurationInputOperationOutputAlias,
                crate::output::DescribeDefaultEncryptionConfigurationOutput,
                crate::error::DescribeDefaultEncryptionConfigurationError,
                crate::input::DescribeDefaultEncryptionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeGateway`.
    ///
    /// <p>Retrieves information about a gateway.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_gateway_input::Builder,
    }
    impl<C, M, R> DescribeGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGatewayInputOperationOutputAlias,
                crate::output::DescribeGatewayOutput,
                crate::error::DescribeGatewayError,
                crate::input::DescribeGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway device.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the gateway device.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayCapabilityConfiguration`.
    ///
    /// <p>Retrieves information about a gateway capability configuration.
    /// Each gateway capability defines data sources for a gateway. A capability configuration
    /// can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
    /// the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
    /// list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGatewayCapabilityConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_gateway_capability_configuration_input::Builder,
    }
    impl<C, M, R> DescribeGatewayCapabilityConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGatewayCapabilityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayCapabilityConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeGatewayCapabilityConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGatewayCapabilityConfigurationInputOperationOutputAlias,
                crate::output::DescribeGatewayCapabilityConfigurationOutput,
                crate::error::DescribeGatewayCapabilityConfigurationError,
                crate::input::DescribeGatewayCapabilityConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the gateway that defines the capability configuration.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>The namespace of the capability configuration.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn capability_namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_namespace(inp);
            self
        }
        /// <p>The namespace of the capability configuration.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current IoT SiteWise logging options.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl<C, M, R> DescribeLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoggingOptionsInputOperationOutputAlias,
                crate::output::DescribeLoggingOptionsOutput,
                crate::error::DescribeLoggingOptionsError,
                crate::input::DescribeLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribePortal`.
    ///
    /// <p>Retrieves information about a portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_portal_input::Builder,
    }
    impl<C, M, R> DescribePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePortalInputOperationOutputAlias,
                crate::output::DescribePortalOutput,
                crate::error::DescribePortalError,
                crate::input::DescribePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(inp);
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Retrieves information about a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorageConfiguration`.
    ///
    /// <p>Retrieves information about the storage configuration for IoT SiteWise.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStorageConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_storage_configuration_input::Builder,
    }
    impl<C, M, R> DescribeStorageConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStorageConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorageConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorageConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStorageConfigurationInputOperationOutputAlias,
                crate::output::DescribeStorageConfigurationOutput,
                crate::error::DescribeStorageConfigurationError,
                crate::input::DescribeStorageConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateAssets`.
    ///
    /// <p>Disassociates a child asset from the given parent asset through a hierarchy defined in the
    /// parent asset's model.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_assets_input::Builder,
    }
    impl<C, M, R> DisassociateAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAssetsInputOperationOutputAlias,
                crate::output::DisassociateAssetsOutput,
                crate::error::DisassociateAssetsError,
                crate::input::DisassociateAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the parent asset from which to disassociate the child asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
        /// to identify the correct asset to disassociate. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(inp);
            self
        }
        /// <p>The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
        /// of assets to be formed that all come from the same asset model. You can use the hierarchy ID
        /// to identify the correct asset to disassociate. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn child_asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_asset_id(inp);
            self
        }
        /// <p>The ID of the child asset to disassociate.</p>
        pub fn set_child_asset_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_child_asset_id(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyAggregates`.
    ///
    /// <p>Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
    /// aggregates</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p>
    /// </li>
    /// <li>
    /// <p>A <code>propertyAlias</code>, which is a data stream alias (for example,
    /// <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAssetPropertyAggregates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_asset_property_aggregates_input::Builder,
    }
    impl<C, M, R> GetAssetPropertyAggregates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssetPropertyAggregates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyAggregatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyAggregatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssetPropertyAggregatesInputOperationOutputAlias,
                crate::output::GetAssetPropertyAggregatesOutput,
                crate::error::GetAssetPropertyAggregatesError,
                crate::input::GetAssetPropertyAggregatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(inp);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// Appends an item to `aggregateTypes`.
        ///
        /// To override the contents of this collection use [`set_aggregate_types`](Self::set_aggregate_types).
        ///
        /// <p>The data aggregating function.</p>
        pub fn aggregate_types(mut self, inp: impl Into<crate::model::AggregateType>) -> Self {
            self.inner = self.inner.aggregate_types(inp);
            self
        }
        /// <p>The data aggregating function.</p>
        pub fn set_aggregate_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregateType>>,
        ) -> Self {
            self.inner = self.inner.set_aggregate_types(input);
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn resolution(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution(inp);
            self
        }
        /// <p>The time interval over which to aggregate data.</p>
        pub fn set_resolution(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolution(input);
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, inp: impl Into<crate::model::Quality>) -> Self {
            self.inner = self.inner.qualities(inp);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.inner = self.inner.set_qualities(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn time_ordering(mut self, inp: crate::model::TimeOrdering) -> Self {
            self.inner = self.inner.time_ordering(inp);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.inner = self.inner.set_time_ordering(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyValue`.
    ///
    /// <p>Gets an asset property's current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying
    /// current values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p>
    /// </li>
    /// <li>
    /// <p>A <code>propertyAlias</code>, which is a data stream alias (for example,
    /// <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAssetPropertyValue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_asset_property_value_input::Builder,
    }
    impl<C, M, R> GetAssetPropertyValue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssetPropertyValue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyValueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyValueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssetPropertyValueInputOperationOutputAlias,
                crate::output::GetAssetPropertyValueOutput,
                crate::error::GetAssetPropertyValueError,
                crate::input::GetAssetPropertyValueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(inp);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssetPropertyValueHistory`.
    ///
    /// <p>Gets the history of an asset property's values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying
    /// historical values</a> in the <i>IoT SiteWise User Guide</i>.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p>
    /// </li>
    /// <li>
    /// <p>A <code>propertyAlias</code>, which is a data stream alias (for example,
    /// <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAssetPropertyValueHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_asset_property_value_history_input::Builder,
    }
    impl<C, M, R> GetAssetPropertyValueHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssetPropertyValueHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssetPropertyValueHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssetPropertyValueHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssetPropertyValueHistoryInputOperationOutputAlias,
                crate::output::GetAssetPropertyValueHistoryOutput,
                crate::error::GetAssetPropertyValueHistoryError,
                crate::input::GetAssetPropertyValueHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(inp);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn start_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn end_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// Appends an item to `qualities`.
        ///
        /// To override the contents of this collection use [`set_qualities`](Self::set_qualities).
        ///
        /// <p>The quality by which to filter asset data.</p>
        pub fn qualities(mut self, inp: impl Into<crate::model::Quality>) -> Self {
            self.inner = self.inner.qualities(inp);
            self
        }
        /// <p>The quality by which to filter asset data.</p>
        pub fn set_qualities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Quality>>,
        ) -> Self {
            self.inner = self.inner.set_qualities(input);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn time_ordering(mut self, inp: crate::model::TimeOrdering) -> Self {
            self.inner = self.inner.time_ordering(inp);
            self
        }
        /// <p>The chronological sorting order of the requested information.</p>
        /// <p>Default: <code>ASCENDING</code>
        /// </p>
        pub fn set_time_ordering(
            mut self,
            input: std::option::Option<crate::model::TimeOrdering>,
        ) -> Self {
            self.inner = self.inner.set_time_ordering(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 100</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInterpolatedAssetPropertyValues`.
    ///
    /// <p>Get interpolated values for an asset property for a specified time interval, during a
    /// period of time. If your time series is missing data points during the specified time interval,
    /// you can use interpolation to estimate the missing data.</p>
    /// <p>For example, you can use this operation to return the interpolated
    /// temperature values for a wind turbine every 24 hours over a duration of 7 days.</p>
    /// <p>To identify an asset property, you must specify one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p>
    /// </li>
    /// <li>
    /// <p>A <code>propertyAlias</code>, which is a data stream alias (for example,
    /// <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetInterpolatedAssetPropertyValues<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_interpolated_asset_property_values_input::Builder,
    }
    impl<C, M, R> GetInterpolatedAssetPropertyValues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInterpolatedAssetPropertyValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInterpolatedAssetPropertyValuesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetInterpolatedAssetPropertyValuesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInterpolatedAssetPropertyValuesInputOperationOutputAlias,
                crate::output::GetInterpolatedAssetPropertyValuesOutput,
                crate::error::GetInterpolatedAssetPropertyValuesError,
                crate::input::GetInterpolatedAssetPropertyValuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn property_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(inp);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn start_time_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.start_time_in_seconds(inp);
            self
        }
        /// <p>The exclusive start of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn set_start_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_time_in_seconds(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn start_time_offset_in_nanos(mut self, inp: i32) -> Self {
            self.inner = self.inner.start_time_offset_in_nanos(inp);
            self
        }
        /// <p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>
        pub fn set_start_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_start_time_offset_in_nanos(input);
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn end_time_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.end_time_in_seconds(inp);
            self
        }
        /// <p>The inclusive end of the range from which to interpolate data, expressed in seconds in
        /// Unix epoch time.</p>
        pub fn set_end_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_end_time_in_seconds(input);
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn end_time_offset_in_nanos(mut self, inp: i32) -> Self {
            self.inner = self.inner.end_time_offset_in_nanos(inp);
            self
        }
        /// <p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>
        pub fn set_end_time_offset_in_nanos(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_end_time_offset_in_nanos(input);
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
        /// only the asset property values that have a specific quality.</p>
        pub fn quality(mut self, inp: crate::model::Quality) -> Self {
            self.inner = self.inner.quality(inp);
            self
        }
        /// <p>The quality of the asset property value. You can use this parameter as a filter to choose
        /// only the asset property values that have a specific quality.</p>
        pub fn set_quality(mut self, input: std::option::Option<crate::model::Quality>) -> Self {
            self.inner = self.inner.set_quality(input);
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
        /// previous one ends.</p>
        pub fn interval_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.interval_in_seconds(inp);
            self
        }
        /// <p>The time interval in seconds over which to interpolate data. Each interval starts when the
        /// previous one ends.</p>
        pub fn set_interval_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_interval_in_seconds(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p>
        /// <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
        /// If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value
        /// on July 3, 2021, at 9 AM, and so on.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p>
        /// <p>If no data point is found for an interval,
        /// IoT SiteWise returns the last observed data point for the previous interval
        /// and carries forward this interpolated value until a new data point is found.</p>
        /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days.
        /// If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021,
        /// at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
        /// If no data point is found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The interpolation type.</p>
        /// <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p>
        /// <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
        /// If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value
        /// on July 3, 2021, at 9 AM, and so on.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p>
        /// <p>If no data point is found for an interval,
        /// IoT SiteWise returns the last observed data point for the previous interval
        /// and carries forward this interpolated value until a new data point is found.</p>
        /// <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days.
        /// If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021,
        /// at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
        /// If no data point is found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The query interval for the window in seconds. IoT SiteWise computes each interpolated value by using data points
        /// from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
        /// If not specified, the window is between the start time minus the interval and the end time plus the interval. </p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter,
        /// the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p>
        /// </li>
        /// <li>
        /// <p>If no data point is found during the specified query window,
        /// IoT SiteWise won't return an interpolated value for the interval.
        /// This indicates that there's a gap in the ingested data points.</p>
        /// </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine
        /// every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021,
        /// at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM - 2 hours)
        /// to 11 AM (9 AM + 2 hours) on July 2, 2021 to compute the first interpolated value,
        /// uses the data points from 7 AM (9 AM - 2 hours) to 11 AM (9 AM + 2 hours) on July 3, 2021
        /// to compute the second interpolated value, and so on. </p>
        pub fn interval_window_in_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.interval_window_in_seconds(inp);
            self
        }
        /// <p>The query interval for the window in seconds. IoT SiteWise computes each interpolated value by using data points
        /// from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
        /// If not specified, the window is between the start time minus the interval and the end time plus the interval. </p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter,
        /// the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p>
        /// </li>
        /// <li>
        /// <p>If no data point is found during the specified query window,
        /// IoT SiteWise won't return an interpolated value for the interval.
        /// This indicates that there's a gap in the ingested data points.</p>
        /// </li>
        /// </ul>
        /// </note>
        /// <p>For example, you can get the interpolated temperature values for a wind turbine
        /// every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021,
        /// at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM - 2 hours)
        /// to 11 AM (9 AM + 2 hours) on July 2, 2021 to compute the first interpolated value,
        /// uses the data points from 7 AM (9 AM - 2 hours) to 11 AM (9 AM + 2 hours) on July 3, 2021
        /// to compute the second interpolated value, and so on. </p>
        pub fn set_interval_window_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_interval_window_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPolicies`.
    ///
    /// <p>Retrieves a paginated list of access policies for an identity (an Amazon Web Services SSO user, an Amazon Web Services SSO
    /// group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_policies_input::Builder,
    }
    impl<C, M, R> ListAccessPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessPoliciesInputOperationOutputAlias,
                crate::output::ListAccessPoliciesOutput,
                crate::error::ListAccessPoliciesError,
                crate::input::ListAccessPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
        /// if you specify <code>identityId</code>.</p>
        pub fn identity_type(mut self, inp: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(inp);
            self
        }
        /// <p>The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
        /// if you specify <code>identityId</code>.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
        /// <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn identity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity_id(inp);
            self
        }
        /// <p>The ID of the identity. This parameter is required if you specify <code>USER</code> or
        /// <code>GROUP</code> for <code>identityType</code>.</p>
        pub fn set_identity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity_id(input);
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify
        /// <code>resourceId</code>.</p>
        pub fn resource_type(mut self, inp: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource (portal or project). This parameter is required if you specify
        /// <code>resourceId</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify
        /// <code>resourceType</code>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the resource. This parameter is required if you specify
        /// <code>resourceType</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
        /// <i>IAM User Guide</i>. This parameter is required if you specify
        /// <code>IAM</code> for <code>identityType</code>.</p>
        pub fn iam_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_arn(inp);
            self
        }
        /// <p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
        /// <i>IAM User Guide</i>. This parameter is required if you specify
        /// <code>IAM</code> for <code>identityType</code>.</p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_arn(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssetModels`.
    ///
    /// <p>Retrieves a paginated list of summaries of all asset models.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssetModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_asset_models_input::Builder,
    }
    impl<C, M, R> ListAssetModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssetModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssetModelsInputOperationOutputAlias,
                crate::output::ListAssetModelsOutput,
                crate::error::ListAssetModelsError,
                crate::input::ListAssetModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssetRelationships`.
    ///
    /// <p>Retrieves a paginated list of asset relationships for an asset. You can use this operation
    /// to identify an asset's root asset and all associated assets between that asset and its
    /// root.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssetRelationships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_asset_relationships_input::Builder,
    }
    impl<C, M, R> ListAssetRelationships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssetRelationships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetRelationshipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetRelationshipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssetRelationshipsInputOperationOutputAlias,
                crate::output::ListAssetRelationshipsOutput,
                crate::error::ListAssetRelationshipsError,
                crate::input::ListAssetRelationshipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following
        /// option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
        /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
        /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
        /// </li>
        /// </ul>
        pub fn traversal_type(mut self, inp: crate::model::TraversalType) -> Self {
            self.inner = self.inner.traversal_type(inp);
            self
        }
        /// <p>The type of traversal to use to identify asset relationships. Choose the following
        /// option:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PATH_TO_ROOT</code> – Identify the asset's parent assets up to the root
        /// asset. The asset that you specify in <code>assetId</code> is the first result in the list
        /// of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p>
        /// </li>
        /// </ul>
        pub fn set_traversal_type(
            mut self,
            input: std::option::Option<crate::model::TraversalType>,
        ) -> Self {
            self.inner = self.inner.set_traversal_type(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssets`.
    ///
    /// <p>Retrieves a paginated list of asset summaries.</p>
    /// <p>You can use this operation to do the following:</p>
    /// <ul>
    /// <li>
    /// <p>List assets based on a specific asset model.</p>
    /// </li>
    /// <li>
    /// <p>List top-level assets.</p>
    /// </li>
    /// </ul>
    /// <p>You can't use this operation to list all assets. To retrieve summaries for all of your
    /// assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a> to get all of your asset model IDs. Then, use ListAssets to get all
    /// assets for each asset model.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assets_input::Builder,
    }
    impl<C, M, R> ListAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssetsInputOperationOutputAlias,
                crate::output::ListAssetsOutput,
                crate::error::ListAssetsError,
                crate::input::ListAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
        /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn asset_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(inp);
            self
        }
        /// <p>The ID of the asset model by which to filter the list of assets. This parameter is
        /// required if you choose <code>ALL</code> for <code>filter</code>.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
        /// <code>assetModelId</code> parameter is required if you filter by
        /// <code>ALL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
        /// hierarchy tree.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>ALL</code>
        /// </p>
        pub fn filter(mut self, inp: crate::model::ListAssetsFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The filter for the requested list of assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all assets for a given asset model ID. The
        /// <code>assetModelId</code> parameter is required if you filter by
        /// <code>ALL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset
        /// hierarchy tree.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>ALL</code>
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListAssetsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedAssets`.
    ///
    /// <p>Retrieves a paginated list of associated assets.</p>
    /// <p>You can use this operation to do the following:</p>
    /// <ul>
    /// <li>
    /// <p>List child assets associated to a parent asset by a hierarchy that you specify.</p>
    /// </li>
    /// <li>
    /// <p>List an asset's parent asset.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociatedAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_assets_input::Builder,
    }
    impl<C, M, R> ListAssociatedAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedAssetsInputOperationOutputAlias,
                crate::output::ListAssociatedAssetsOutput,
                crate::error::ListAssociatedAssetsError,
                crate::input::ListAssociatedAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to query.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset to query.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
        /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
        /// parameter is required if you choose <code>CHILD</code> for
        /// <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn hierarchy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_id(inp);
            self
        }
        /// <p>The ID of the hierarchy by which child assets are associated to the asset. To find a
        /// hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This
        /// parameter is required if you choose <code>CHILD</code> for
        /// <code>traversalDirection</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_hierarchy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hierarchy_id(input);
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHILD</code> – The list includes all child assets associated to the
        /// asset. The <code>hierarchyId</code> parameter is required if you choose
        /// <code>CHILD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code>
        /// </p>
        pub fn traversal_direction(mut self, inp: crate::model::TraversalDirection) -> Self {
            self.inner = self.inner.traversal_direction(inp);
            self
        }
        /// <p>The direction to list associated assets. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CHILD</code> – The list includes all child assets associated to the
        /// asset. The <code>hierarchyId</code> parameter is required if you choose
        /// <code>CHILD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PARENT</code> – The list includes the asset's parent asset.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>CHILD</code>
        /// </p>
        pub fn set_traversal_direction(
            mut self,
            input: std::option::Option<crate::model::TraversalDirection>,
        ) -> Self {
            self.inner = self.inner.set_traversal_direction(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboards`.
    ///
    /// <p>Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDashboards<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dashboards_input::Builder,
    }
    impl<C, M, R> ListDashboards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDashboardsInputOperationOutputAlias,
                crate::output::ListDashboardsOutput,
                crate::error::ListDashboardsError,
                crate::input::ListDashboardsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGateways`.
    ///
    /// <p>Retrieves a paginated list of gateways.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGateways<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_gateways_input::Builder,
    }
    impl<C, M, R> ListGateways<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGatewaysInputOperationOutputAlias,
                crate::output::ListGatewaysOutput,
                crate::error::ListGatewaysError,
                crate::input::ListGatewaysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPortals`.
    ///
    /// <p>Retrieves a paginated list of IoT SiteWise Monitor portals.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPortals<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_portals_input::Builder,
    }
    impl<C, M, R> ListPortals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPortals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPortalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPortalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPortalsInputOperationOutputAlias,
                crate::output::ListPortalsOutput,
                crate::error::ListPortalsError,
                crate::input::ListPortalsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjectAssets`.
    ///
    /// <p>Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjectAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_project_assets_input::Builder,
    }
    impl<C, M, R> ListProjectAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjectAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectAssetsInputOperationOutputAlias,
                crate::output::ListProjectAssetsOutput,
                crate::error::ListProjectAssetsError,
                crate::input::ListProjectAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal.</p>
        pub fn portal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(inp);
            self
        }
        /// <p>The ID of the portal.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for each paginated request.</p>
        /// <p>Default: 50</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of tags for an IoT SiteWise resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDefaultEncryptionConfiguration`.
    ///
    /// <p>Sets the default encryption configuration for the Amazon Web Services account. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in
    /// the <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutDefaultEncryptionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_default_encryption_configuration_input::Builder,
    }
    impl<C, M, R> PutDefaultEncryptionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDefaultEncryptionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDefaultEncryptionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDefaultEncryptionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDefaultEncryptionConfigurationInputOperationOutputAlias,
                crate::output::PutDefaultEncryptionConfigurationOutput,
                crate::error::PutDefaultEncryptionConfigurationError,
                crate::input::PutDefaultEncryptionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn encryption_type(mut self, inp: crate::model::EncryptionType) -> Self {
            self.inner = self.inner.encryption_type(inp);
            self
        }
        /// <p>The type of encryption used for the encryption configuration.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.inner = self.inner.set_encryption_type(input);
            self
        }
        /// <p>The Key ID of the customer managed customer master key (CMK) used for KMS encryption.
        /// This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Key ID of the customer managed customer master key (CMK) used for KMS encryption.
        /// This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets logging options for IoT SiteWise.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl<C, M, R> PutLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLoggingOptionsInputOperationOutputAlias,
                crate::output::PutLoggingOptionsOutput,
                crate::error::PutLoggingOptionsError,
                crate::input::PutLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The logging options to set.</p>
        pub fn logging_options(mut self, inp: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(inp);
            self
        }
        /// <p>The logging options to set.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageConfiguration`.
    ///
    /// <p>Configures storage settings for IoT SiteWise.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutStorageConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_storage_configuration_input::Builder,
    }
    impl<C, M, R> PutStorageConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutStorageConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStorageConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutStorageConfigurationInputOperationOutputAlias,
                crate::output::PutStorageConfigurationOutput,
                crate::error::PutStorageConfigurationError,
                crate::input::PutStorageConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of storage that you specified for your data. The storage type can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.</p>
        /// </li>
        /// </ul>
        pub fn storage_type(mut self, inp: crate::model::StorageType) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>The type of storage that you specified for your data. The storage type can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.</p>
        /// </li>
        /// </ul>
        pub fn set_storage_type(
            mut self,
            input: std::option::Option<crate::model::StorageType>,
        ) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
        /// you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn multi_layer_storage(mut self, inp: crate::model::MultiLayerStorage) -> Self {
            self.inner = self.inner.multi_layer_storage(inp);
            self
        }
        /// <p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type,
        /// you must specify a <code>MultiLayerStorage</code> object.</p>
        pub fn set_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::MultiLayerStorage>,
        ) -> Self {
            self.inner = self.inner.set_multi_layer_storage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation
    /// updates the tag's value.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
        /// resources</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an IoT SiteWise resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccessPolicy`.
    ///
    /// <p>Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor
    /// portal or project resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccessPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_access_policy_input::Builder,
    }
    impl<C, M, R> UpdateAccessPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccessPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccessPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccessPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccessPolicyInputOperationOutputAlias,
                crate::output::UpdateAccessPolicyOutput,
                crate::error::UpdateAccessPolicyError,
                crate::input::UpdateAccessPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access policy.</p>
        pub fn access_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy_id(inp);
            self
        }
        /// <p>The ID of the access policy.</p>
        pub fn set_access_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_id(input);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn access_policy_identity(mut self, inp: crate::model::Identity) -> Self {
            self.inner = self.inner.access_policy_identity(inp);
            self
        }
        /// <p>The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.</p>
        pub fn set_access_policy_identity(
            mut self,
            input: std::option::Option<crate::model::Identity>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_identity(input);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn access_policy_resource(mut self, inp: crate::model::Resource) -> Self {
            self.inner = self.inner.access_policy_resource(inp);
            self
        }
        /// <p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>
        pub fn set_access_policy_resource(
            mut self,
            input: std::option::Option<crate::model::Resource>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_resource(input);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn access_policy_permission(mut self, inp: crate::model::Permission) -> Self {
            self.inner = self.inner.access_policy_permission(inp);
            self
        }
        /// <p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>
        pub fn set_access_policy_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.inner = self.inner.set_access_policy_permission(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAsset`.
    ///
    /// <p>Updates an asset's name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_asset_input::Builder,
    }
    impl<C, M, R> UpdateAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssetInputOperationOutputAlias,
                crate::output::UpdateAssetOutput,
                crate::error::UpdateAssetError,
                crate::input::UpdateAssetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to update.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset to update.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn asset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_name(inp);
            self
        }
        /// <p>A unique, friendly name for the asset.</p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_name(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssetModel`.
    ///
    /// <p>Updates an asset model and all of the assets that were created from the model. Each asset
    /// created from the model inherits the updated asset model's property and hierarchy definitions.
    /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the
    /// <i>IoT SiteWise User Guide</i>.</p>
    /// <important>
    /// <p>This operation overwrites the existing model with the provided model. To avoid deleting
    /// your asset model's properties or hierarchies, you must include their IDs and definitions in
    /// the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a>.</p>
    /// <p>If you remove a property from an asset model, IoT SiteWise deletes all previous data for that
    /// property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every
    /// asset associated with that hierarchy. You can't change the type or data type of an existing
    /// property.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssetModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_asset_model_input::Builder,
    }
    impl<C, M, R> UpdateAssetModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssetModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssetModelInputOperationOutputAlias,
                crate::output::UpdateAssetModelOutput,
                crate::error::UpdateAssetModelError,
                crate::input::UpdateAssetModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset model to update.</p>
        pub fn asset_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_id(inp);
            self
        }
        /// <p>The ID of the asset model to update.</p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_id(input);
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn asset_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_name(inp);
            self
        }
        /// <p>A unique, friendly name for the asset model.</p>
        pub fn set_asset_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_name(input);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn asset_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_model_description(inp);
            self
        }
        /// <p>A description for the asset model.</p>
        pub fn set_asset_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_description(input);
            self
        }
        /// Appends an item to `assetModelProperties`.
        ///
        /// To override the contents of this collection use [`set_asset_model_properties`](Self::set_asset_model_properties).
        ///
        /// <p>The updated property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_properties(
            mut self,
            inp: impl Into<crate::model::AssetModelProperty>,
        ) -> Self {
            self.inner = self.inner.asset_model_properties(inp);
            self
        }
        /// <p>The updated property definitions of the asset model. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 200 properties per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelProperty>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_properties(input);
            self
        }
        /// Appends an item to `assetModelHierarchies`.
        ///
        /// To override the contents of this collection use [`set_asset_model_hierarchies`](Self::set_asset_model_hierarchies).
        ///
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
        /// model whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn asset_model_hierarchies(
            mut self,
            inp: impl Into<crate::model::AssetModelHierarchy>,
        ) -> Self {
            self.inner = self.inner.asset_model_hierarchies(inp);
            self
        }
        /// <p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
        /// model whose assets can be children of any other assets created from this asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>You can specify up to 10 hierarchies per asset model. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_asset_model_hierarchies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelHierarchy>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_hierarchies(input);
            self
        }
        /// Appends an item to `assetModelCompositeModels`.
        ///
        /// To override the contents of this collection use [`set_asset_model_composite_models`](Self::set_asset_model_composite_models).
        ///
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn asset_model_composite_models(
            mut self,
            inp: impl Into<crate::model::AssetModelCompositeModel>,
        ) -> Self {
            self.inner = self.inner.asset_model_composite_models(inp);
            self
        }
        /// <p>The composite asset models that are part of this asset model.
        /// Composite asset models are asset models that contain specific properties. Each composite model
        /// has a type that defines the properties that the composite model supports. Use composite asset
        /// models to define alarms on this asset model.</p>
        pub fn set_asset_model_composite_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetModelCompositeModel>>,
        ) -> Self {
            self.inner = self.inner.set_asset_model_composite_models(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssetProperty`.
    ///
    /// <p>Updates an asset property's alias and notification state.</p>
    /// <important>
    /// <p>This operation overwrites the property's existing alias and notification state. To keep
    /// your existing property's alias or notification state, you must include the existing values
    /// in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssetProperty<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_asset_property_input::Builder,
    }
    impl<C, M, R> UpdateAssetProperty<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssetProperty`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssetPropertyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssetPropertyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssetPropertyInputOperationOutputAlias,
                crate::output::UpdateAssetPropertyOutput,
                crate::error::UpdateAssetPropertyError,
                crate::input::UpdateAssetPropertyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the asset to be updated.</p>
        pub fn asset_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset_id(inp);
            self
        }
        /// <p>The ID of the asset to be updated.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset_id(input);
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn property_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_id(inp);
            self
        }
        /// <p>The ID of the asset property to be updated.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_property_id(input);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn property_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.property_alias(inp);
            self
        }
        /// <p>The alias that identifies the property, such as an OPC-UA server data stream path
        /// (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see
        /// <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the alias is removed from the property.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_property_alias(input);
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property.
        /// When the notification state is enabled, IoT SiteWise publishes property value
        /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn property_notification_state(
            mut self,
            inp: crate::model::PropertyNotificationState,
        ) -> Self {
            self.inner = self.inner.property_notification_state(inp);
            self
        }
        /// <p>The MQTT notification state (enabled or disabled) for this asset property.
        /// When the notification state is enabled, IoT SiteWise publishes property value
        /// updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
        /// <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>
        pub fn set_property_notification_state(
            mut self,
            input: std::option::Option<crate::model::PropertyNotificationState>,
        ) -> Self {
            self.inner = self.inner.set_property_notification_state(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboard`.
    ///
    /// <p>Updates an IoT SiteWise Monitor dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_input::Builder,
    }
    impl<C, M, R> UpdateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardInputOperationOutputAlias,
                crate::output::UpdateDashboardOutput,
                crate::error::UpdateDashboardError,
                crate::input::UpdateDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dashboard to update.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID of the dashboard to update.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn dashboard_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_name(inp);
            self
        }
        /// <p>A new friendly name for the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_name(input);
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn dashboard_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_description(inp);
            self
        }
        /// <p>A new description for the dashboard.</p>
        pub fn set_dashboard_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_description(input);
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn dashboard_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_definition(inp);
            self
        }
        /// <p>The new dashboard definition, as specified in a JSON literal. For detailed information,
        /// see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_dashboard_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_definition(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGateway`.
    ///
    /// <p>Updates a gateway's name.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_input::Builder,
    }
    impl<C, M, R> UpdateGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayInputOperationOutputAlias,
                crate::output::UpdateGatewayOutput,
                crate::error::UpdateGatewayError,
                crate::input::UpdateGatewayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to update.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the gateway to update.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn gateway_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_name(inp);
            self
        }
        /// <p>A unique, friendly name for the gateway.</p>
        pub fn set_gateway_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayCapabilityConfiguration`.
    ///
    /// <p>Updates a gateway capability configuration or defines a new capability configuration.
    /// Each gateway capability defines data sources for a gateway. A capability configuration
    /// can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
    /// the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
    /// list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGatewayCapabilityConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_gateway_capability_configuration_input::Builder,
    }
    impl<C, M, R> UpdateGatewayCapabilityConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGatewayCapabilityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayCapabilityConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateGatewayCapabilityConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGatewayCapabilityConfigurationInputOperationOutputAlias,
                crate::output::UpdateGatewayCapabilityConfigurationOutput,
                crate::error::UpdateGatewayCapabilityConfigurationError,
                crate::input::UpdateGatewayCapabilityConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the gateway to be updated.</p>
        pub fn gateway_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(inp);
            self
        }
        /// <p>The ID of the gateway to be updated.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn capability_namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_namespace(inp);
            self
        }
        /// <p>The namespace of the gateway capability configuration to be updated.
        /// For example, if you configure OPC-UA
        /// sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
        /// <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
        /// <code>1</code>.</p>
        pub fn set_capability_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_namespace(input);
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn capability_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capability_configuration(inp);
            self
        }
        /// <p>The JSON document that defines the configuration for the gateway capability. For more
        /// information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_capability_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capability_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePortal`.
    ///
    /// <p>Updates an IoT SiteWise Monitor portal.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePortal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_portal_input::Builder,
    }
    impl<C, M, R> UpdatePortal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePortal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePortalOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePortalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePortalInputOperationOutputAlias,
                crate::output::UpdatePortalOutput,
                crate::error::UpdatePortalError,
                crate::input::UpdatePortalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the portal to update.</p>
        pub fn portal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_id(inp);
            self
        }
        /// <p>The ID of the portal to update.</p>
        pub fn set_portal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_id(input);
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn portal_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_name(inp);
            self
        }
        /// <p>A new friendly name for the portal.</p>
        pub fn set_portal_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_portal_name(input);
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn portal_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_description(inp);
            self
        }
        /// <p>A new description for the portal.</p>
        pub fn set_portal_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_description(input);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn portal_contact_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.portal_contact_email(inp);
            self
        }
        /// <p>The Amazon Web Services administrator's contact email address.</p>
        pub fn set_portal_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_portal_contact_email(input);
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An image file. Choose this option to upload a new image.</p>
        /// </li>
        /// <li>
        /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
        /// </li>
        /// </ul>
        pub fn portal_logo_image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.portal_logo_image(inp);
            self
        }
        /// <p>Contains an image that is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An image file. Choose this option to upload a new image.</p>
        /// </li>
        /// <li>
        /// <p>The ID of an existing image. Choose this option to keep an existing image.</p>
        /// </li>
        /// </ul>
        pub fn set_portal_logo_image(
            mut self,
            input: std::option::Option<crate::model::Image>,
        ) -> Self {
            self.inner = self.inner.set_portal_logo_image(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your IoT SiteWise
        /// resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the
        /// <i>IoT SiteWise User Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn notification_sender_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_sender_email(inp);
            self
        }
        /// <p>The email address that sends alarm notifications.</p>
        pub fn set_notification_sender_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_sender_email(input);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn alarms(mut self, inp: crate::model::Alarms) -> Self {
            self.inner = self.inner.alarms(inp);
            self
        }
        /// <p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
        /// You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
        /// For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>
        pub fn set_alarms(mut self, input: std::option::Option<crate::model::Alarms>) -> Self {
            self.inner = self.inner.set_alarms(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Updates an IoT SiteWise Monitor project.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the project to update.</p>
        pub fn project_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_id(inp);
            self
        }
        /// <p>The ID of the project to update.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_id(input);
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>A new friendly name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A new description for the project.</p>
        pub fn project_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_description(inp);
            self
        }
        /// <p>A new description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_description(input);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
