// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
pub mod describe_job_execution_input {
    /// A builder for [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) include_job_document: std::option::Option<bool>,
        pub(crate) execution_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The thing name associated with the device the job execution is running on.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The thing name associated with the device the job execution is running on.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
        pub fn include_job_document(mut self, input: bool) -> Self {
            self.include_job_document = Some(input);
            self
        }
        /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
        pub fn set_include_job_document(mut self, input: std::option::Option<bool>) -> Self {
            self.include_job_document = input;
            self
        }
        /// <p>Optional. A number that identifies a particular job execution on a particular device. If not specified, the latest job execution is returned.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.execution_number = Some(input);
            self
        }
        /// <p>Optional. A number that identifies a particular job execution on a particular device. If not specified, the latest job execution is returned.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.execution_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobExecutionInput {
                job_id: self.job_id,
                thing_name: self.thing_name,
                include_job_document: self.include_job_document,
                execution_number: self.execution_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobExecutionInputOperationOutputAlias = crate::operation::DescribeJobExecution;
#[doc(hidden)]
pub type DescribeJobExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobExecution`](crate::operation::DescribeJobExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.thing_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_1, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.job_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_2, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/things/{thingName}/jobs/{jobId}",
                thingName = thing_name,
                jobId = job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeJobExecutionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.include_job_document {
                query.push_kv(
                    "includeJobDocument",
                    aws_smithy_types::primitive::Encoder::from(*inner_3).encode(),
                );
            }
            if let Some(inner_4) = &_input.execution_number {
                query.push_kv(
                    "executionNumber",
                    aws_smithy_types::primitive::Encoder::from(*inner_4).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobExecution",
            "iotjobsdataplane",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
    pub fn builder() -> crate::input::describe_job_execution_input::Builder {
        crate::input::describe_job_execution_input::Builder::default()
    }
}

/// See [`GetPendingJobExecutionsInput`](crate::input::GetPendingJobExecutionsInput)
pub mod get_pending_job_executions_input {
    /// A builder for [`GetPendingJobExecutionsInput`](crate::input::GetPendingJobExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing that is executing the job.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing that is executing the job.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPendingJobExecutionsInput`](crate::input::GetPendingJobExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPendingJobExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPendingJobExecutionsInput {
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPendingJobExecutionsInputOperationOutputAlias =
    crate::operation::GetPendingJobExecutions;
#[doc(hidden)]
pub type GetPendingJobExecutionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPendingJobExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`GetPendingJobExecutions`](crate::operation::GetPendingJobExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPendingJobExecutions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPendingJobExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.thing_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_5, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/things/{thingName}/jobs", thingName = thing_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPendingJobExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPendingJobExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPendingJobExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPendingJobExecutions",
            "iotjobsdataplane",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPendingJobExecutionsInput`](crate::input::GetPendingJobExecutionsInput)
    pub fn builder() -> crate::input::get_pending_job_executions_input::Builder {
        crate::input::get_pending_job_executions_input::Builder::default()
    }
}

/// See [`StartNextPendingJobExecutionInput`](crate::input::StartNextPendingJobExecutionInput)
pub mod start_next_pending_job_execution_input {
    /// A builder for [`StartNextPendingJobExecutionInput`](crate::input::StartNextPendingJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) status_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) step_timeout_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the thing associated with the device.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing associated with the device.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Adds a key-value pair to `status_details`.
        ///
        /// To override the contents of this collection use [`set_status_details`](Self::set_status_details).
        ///
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
        pub fn status_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.status_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.status_details = Some(hash_map);
            self
        }
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
        pub fn step_timeout_in_minutes(mut self, input: i64) -> Self {
            self.step_timeout_in_minutes = Some(input);
            self
        }
        /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
        pub fn set_step_timeout_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.step_timeout_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`StartNextPendingJobExecutionInput`](crate::input::StartNextPendingJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartNextPendingJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartNextPendingJobExecutionInput {
                thing_name: self.thing_name,
                status_details: self.status_details,
                step_timeout_in_minutes: self.step_timeout_in_minutes,
            })
        }
    }
}
#[doc(hidden)]
pub type StartNextPendingJobExecutionInputOperationOutputAlias =
    crate::operation::StartNextPendingJobExecution;
#[doc(hidden)]
pub type StartNextPendingJobExecutionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl StartNextPendingJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartNextPendingJobExecution`](crate::operation::StartNextPendingJobExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartNextPendingJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartNextPendingJobExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.thing_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_6, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/things/{thingName}/jobs/$next",
                thingName = thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartNextPendingJobExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartNextPendingJobExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_next_pending_job_execution(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartNextPendingJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartNextPendingJobExecution",
            "iotjobsdataplane",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartNextPendingJobExecutionInput`](crate::input::StartNextPendingJobExecutionInput)
    pub fn builder() -> crate::input::start_next_pending_job_execution_input::Builder {
        crate::input::start_next_pending_job_execution_input::Builder::default()
    }
}

/// See [`UpdateJobExecutionInput`](crate::input::UpdateJobExecutionInput)
pub mod update_job_execution_input {
    /// A builder for [`UpdateJobExecutionInput`](crate::input::UpdateJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobExecutionStatus>,
        pub(crate) status_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) step_timeout_in_minutes: std::option::Option<i64>,
        pub(crate) expected_version: std::option::Option<i64>,
        pub(crate) include_job_execution_state: std::option::Option<bool>,
        pub(crate) include_job_document: std::option::Option<bool>,
        pub(crate) execution_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the thing associated with the device.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing associated with the device.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every update.</p>
        pub fn status(mut self, input: crate::model::JobExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::JobExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `status_details`.
        ///
        /// To override the contents of this collection use [`set_status_details`](Self::set_status_details).
        ///
        /// <p> Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
        pub fn status_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.status_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.status_details = Some(hash_map);
            self
        }
        /// <p> Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by again calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting or resetting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
        pub fn step_timeout_in_minutes(mut self, input: i64) -> Self {
            self.step_timeout_in_minutes = Some(input);
            self
        }
        /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by again calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting or resetting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
        pub fn set_step_timeout_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.step_timeout_in_minutes = input;
            self
        }
        /// <p>Optional. The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>Optional. The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// <p>Optional. When included and set to true, the response contains the JobExecutionState data. The default is false.</p>
        pub fn include_job_execution_state(mut self, input: bool) -> Self {
            self.include_job_execution_state = Some(input);
            self
        }
        /// <p>Optional. When included and set to true, the response contains the JobExecutionState data. The default is false.</p>
        pub fn set_include_job_execution_state(mut self, input: std::option::Option<bool>) -> Self {
            self.include_job_execution_state = input;
            self
        }
        /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
        pub fn include_job_document(mut self, input: bool) -> Self {
            self.include_job_document = Some(input);
            self
        }
        /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
        pub fn set_include_job_document(mut self, input: std::option::Option<bool>) -> Self {
            self.include_job_document = input;
            self
        }
        /// <p>Optional. A number that identifies a particular job execution on a particular device.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.execution_number = Some(input);
            self
        }
        /// <p>Optional. A number that identifies a particular job execution on a particular device.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.execution_number = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobExecutionInput`](crate::input::UpdateJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJobExecutionInput {
                job_id: self.job_id,
                thing_name: self.thing_name,
                status: self.status,
                status_details: self.status_details,
                step_timeout_in_minutes: self.step_timeout_in_minutes,
                expected_version: self.expected_version,
                include_job_execution_state: self.include_job_execution_state,
                include_job_document: self.include_job_document,
                execution_number: self.execution_number,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJobExecutionInputOperationOutputAlias = crate::operation::UpdateJobExecution;
#[doc(hidden)]
pub type UpdateJobExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJobExecution`](crate::operation::UpdateJobExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateJobExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.thing_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_7, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.job_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_8, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/things/{thingName}/jobs/{jobId}",
                thingName = thing_name,
                jobId = job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateJobExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateJobExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_job_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJobExecution",
            "iotjobsdataplane",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateJobExecutionInput`](crate::input::UpdateJobExecutionInput)
    pub fn builder() -> crate::input::update_job_execution_input::Builder {
        crate::input::update_job_execution_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobExecutionInput {
    /// <p>The unique identifier assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name of the thing associated with the device.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every update.</p>
    pub status: std::option::Option<crate::model::JobExecutionStatus>,
    /// <p> Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
    pub status_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by again calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting or resetting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
    pub step_timeout_in_minutes: std::option::Option<i64>,
    /// <p>Optional. The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
    pub expected_version: std::option::Option<i64>,
    /// <p>Optional. When included and set to true, the response contains the JobExecutionState data. The default is false.</p>
    pub include_job_execution_state: std::option::Option<bool>,
    /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
    pub include_job_document: std::option::Option<bool>,
    /// <p>Optional. A number that identifies a particular job execution on a particular device.</p>
    pub execution_number: std::option::Option<i64>,
}
impl UpdateJobExecutionInput {
    /// <p>The unique identifier assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The name of the thing associated with the device.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The new status for the job execution (IN_PROGRESS, FAILED, SUCCESS, or REJECTED). This must be specified on every update.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobExecutionStatus> {
        self.status.as_ref()
    }
    /// <p> Optional. A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
    pub fn status_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.status_details.as_ref()
    }
    /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by again calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in this field) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting or resetting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
    pub fn step_timeout_in_minutes(&self) -> std::option::Option<i64> {
        self.step_timeout_in_minutes
    }
    /// <p>Optional. The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
    pub fn expected_version(&self) -> std::option::Option<i64> {
        self.expected_version
    }
    /// <p>Optional. When included and set to true, the response contains the JobExecutionState data. The default is false.</p>
    pub fn include_job_execution_state(&self) -> std::option::Option<bool> {
        self.include_job_execution_state
    }
    /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
    pub fn include_job_document(&self) -> std::option::Option<bool> {
        self.include_job_document
    }
    /// <p>Optional. A number that identifies a particular job execution on a particular device.</p>
    pub fn execution_number(&self) -> std::option::Option<i64> {
        self.execution_number
    }
}
impl std::fmt::Debug for UpdateJobExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobExecutionInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("step_timeout_in_minutes", &self.step_timeout_in_minutes);
        formatter.field("expected_version", &self.expected_version);
        formatter.field(
            "include_job_execution_state",
            &self.include_job_execution_state,
        );
        formatter.field("include_job_document", &self.include_job_document);
        formatter.field("execution_number", &self.execution_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartNextPendingJobExecutionInput {
    /// <p>The name of the thing associated with the device.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
    pub status_details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
    pub step_timeout_in_minutes: std::option::Option<i64>,
}
impl StartNextPendingJobExecutionInput {
    /// <p>The name of the thing associated with the device.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged.</p>
    pub fn status_details(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.status_details.as_ref()
    }
    /// <p>Specifies the amount of time this device has to finish execution of this job. If the job execution status is not set to a terminal state before this timer expires, or before the timer is reset (by calling <code>UpdateJobExecution</code>, setting the status to <code>IN_PROGRESS</code> and specifying a new timeout value in field <code>stepTimeoutInMinutes</code>) the job execution status will be automatically set to <code>TIMED_OUT</code>. Note that setting this timeout has no effect on that job execution timeout which may have been specified when the job was created (<code>CreateJob</code> using field <code>timeoutConfig</code>).</p>
    pub fn step_timeout_in_minutes(&self) -> std::option::Option<i64> {
        self.step_timeout_in_minutes
    }
}
impl std::fmt::Debug for StartNextPendingJobExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartNextPendingJobExecutionInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("status_details", &self.status_details);
        formatter.field("step_timeout_in_minutes", &self.step_timeout_in_minutes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPendingJobExecutionsInput {
    /// <p>The name of the thing that is executing the job.</p>
    pub thing_name: std::option::Option<std::string::String>,
}
impl GetPendingJobExecutionsInput {
    /// <p>The name of the thing that is executing the job.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
}
impl std::fmt::Debug for GetPendingJobExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPendingJobExecutionsInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobExecutionInput {
    /// <p>The unique identifier assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The thing name associated with the device the job execution is running on.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
    pub include_job_document: std::option::Option<bool>,
    /// <p>Optional. A number that identifies a particular job execution on a particular device. If not specified, the latest job execution is returned.</p>
    pub execution_number: std::option::Option<i64>,
}
impl DescribeJobExecutionInput {
    /// <p>The unique identifier assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The thing name associated with the device the job execution is running on.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>Optional. When set to true, the response contains the job document. The default is false.</p>
    pub fn include_job_document(&self) -> std::option::Option<bool> {
        self.include_job_document
    }
    /// <p>Optional. A number that identifies a particular job execution on a particular device. If not specified, the latest job execution is returned.</p>
    pub fn execution_number(&self) -> std::option::Option<i64> {
        self.execution_number
    }
}
impl std::fmt::Debug for DescribeJobExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobExecutionInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("include_job_document", &self.include_job_document);
        formatter.field("execution_number", &self.execution_number);
        formatter.finish()
    }
}
