// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DescribeJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobExecutionErrorKind {
    /// <p>The certificate is invalid.</p>
    CertificateValidationException(crate::error::CertificateValidationException),
    /// <p>The contents of the request were invalid. For example, this code is returned when an UpdateJobExecution request contains invalid status details. The message contains details about the error.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The job is in a terminal state.</p>
    TerminalStateException(crate::error::TerminalStateException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobExecutionErrorKind::CertificateValidationException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::TerminalStateException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobExecutionError {
    /// Creates a new `DescribeJobExecutionError`.
    pub fn new(kind: DescribeJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::CertificateValidationException`.
    pub fn is_certificate_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::CertificateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::TerminalStateException`.
    pub fn is_terminal_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::TerminalStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobExecutionErrorKind::CertificateValidationException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::TerminalStateException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPendingJobExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPendingJobExecutionsError {
    /// Kind of error that occurred.
    pub kind: GetPendingJobExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPendingJobExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPendingJobExecutionsErrorKind {
    /// <p>The certificate is invalid.</p>
    CertificateValidationException(crate::error::CertificateValidationException),
    /// <p>The contents of the request were invalid. For example, this code is returned when an UpdateJobExecution request contains invalid status details. The message contains details about the error.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPendingJobExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPendingJobExecutionsErrorKind::CertificateValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetPendingJobExecutionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetPendingJobExecutionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPendingJobExecutionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPendingJobExecutionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPendingJobExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPendingJobExecutionsError {
    fn code(&self) -> Option<&str> {
        GetPendingJobExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPendingJobExecutionsError {
    /// Creates a new `GetPendingJobExecutionsError`.
    pub fn new(kind: GetPendingJobExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPendingJobExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPendingJobExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPendingJobExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPendingJobExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPendingJobExecutionsErrorKind::CertificateValidationException`.
    pub fn is_certificate_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPendingJobExecutionsErrorKind::CertificateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPendingJobExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPendingJobExecutionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPendingJobExecutionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPendingJobExecutionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPendingJobExecutionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPendingJobExecutionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPendingJobExecutionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPendingJobExecutionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetPendingJobExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPendingJobExecutionsErrorKind::CertificateValidationException(_inner) => {
                Some(_inner)
            }
            GetPendingJobExecutionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetPendingJobExecutionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPendingJobExecutionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPendingJobExecutionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPendingJobExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartNextPendingJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartNextPendingJobExecutionError {
    /// Kind of error that occurred.
    pub kind: StartNextPendingJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartNextPendingJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartNextPendingJobExecutionErrorKind {
    /// <p>The certificate is invalid.</p>
    CertificateValidationException(crate::error::CertificateValidationException),
    /// <p>The contents of the request were invalid. For example, this code is returned when an UpdateJobExecution request contains invalid status details. The message contains details about the error.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartNextPendingJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartNextPendingJobExecutionErrorKind::CertificateValidationException(_inner) => {
                _inner.fmt(f)
            }
            StartNextPendingJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartNextPendingJobExecutionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartNextPendingJobExecutionErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartNextPendingJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartNextPendingJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartNextPendingJobExecutionError {
    fn code(&self) -> Option<&str> {
        StartNextPendingJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartNextPendingJobExecutionError {
    /// Creates a new `StartNextPendingJobExecutionError`.
    pub fn new(kind: StartNextPendingJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartNextPendingJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartNextPendingJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartNextPendingJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartNextPendingJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartNextPendingJobExecutionErrorKind::CertificateValidationException`.
    pub fn is_certificate_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNextPendingJobExecutionErrorKind::CertificateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartNextPendingJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNextPendingJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartNextPendingJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNextPendingJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartNextPendingJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNextPendingJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartNextPendingJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartNextPendingJobExecutionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for StartNextPendingJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartNextPendingJobExecutionErrorKind::CertificateValidationException(_inner) => {
                Some(_inner)
            }
            StartNextPendingJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartNextPendingJobExecutionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartNextPendingJobExecutionErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            StartNextPendingJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartNextPendingJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobExecutionError {
    /// Kind of error that occurred.
    pub kind: UpdateJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobExecutionErrorKind {
    /// <p>The certificate is invalid.</p>
    CertificateValidationException(crate::error::CertificateValidationException),
    /// <p>The contents of the request were invalid. For example, this code is returned when an UpdateJobExecution request contains invalid status details. The message contains details about the error.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An update attempted to change the job execution to a state that is invalid because of the job execution's
    /// current state (for example, an attempt to change a request in state SUCCESS to state IN_PROGRESS). In this
    /// case, the body of the error message also contains the executionState field.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobExecutionErrorKind::CertificateValidationException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobExecutionError {
    fn code(&self) -> Option<&str> {
        UpdateJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobExecutionError {
    /// Creates a new `UpdateJobExecutionError`.
    pub fn new(kind: UpdateJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::CertificateValidationException`.
    pub fn is_certificate_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::CertificateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobExecutionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobExecutionErrorKind::CertificateValidationException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The rate exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The payload associated with the exception.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
}
impl ThrottlingException {
    /// <p>The payload associated with the exception.</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The payload associated with the exception.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The payload associated with the exception.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                payload: self.payload,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The specified resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An update attempted to change the job execution to a state that is invalid because of the job execution's
/// current state (for example, an attempt to change a request in state SUCCESS to state IN_PROGRESS). In this
/// case, the body of the error message also contains the executionState field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateTransitionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateTransitionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateTransitionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateTransitionException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateTransitionException {}
/// See [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
pub mod invalid_state_transition_exception {
    /// A builder for [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
        pub fn build(self) -> crate::error::InvalidStateTransitionException {
            crate::error::InvalidStateTransitionException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateTransitionException {
    /// Creates a new builder-style object to manufacture [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    pub fn builder() -> crate::error::invalid_state_transition_exception::Builder {
        crate::error::invalid_state_transition_exception::Builder::default()
    }
}

/// <p>The contents of the request were invalid. For example, this code is returned when an UpdateJobExecution request contains invalid status details. The message contains details about the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The certificate is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateValidationException {
    /// <p>Additional information about the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CertificateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CertificateValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CertificateValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CertificateValidationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for CertificateValidationException {}
/// See [`CertificateValidationException`](crate::error::CertificateValidationException)
pub mod certificate_validation_exception {
    /// A builder for [`CertificateValidationException`](crate::error::CertificateValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Additional information about the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information about the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateValidationException`](crate::error::CertificateValidationException)
        pub fn build(self) -> crate::error::CertificateValidationException {
            crate::error::CertificateValidationException {
                message: self.message,
            }
        }
    }
}
impl CertificateValidationException {
    /// Creates a new builder-style object to manufacture [`CertificateValidationException`](crate::error::CertificateValidationException)
    pub fn builder() -> crate::error::certificate_validation_exception::Builder {
        crate::error::certificate_validation_exception::Builder::default()
    }
}

/// <p>The job is in a terminal state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminalStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TerminalStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminalStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TerminalStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TerminalStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TerminalStateException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TerminalStateException {}
/// See [`TerminalStateException`](crate::error::TerminalStateException)
pub mod terminal_state_exception {
    /// A builder for [`TerminalStateException`](crate::error::TerminalStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminalStateException`](crate::error::TerminalStateException)
        pub fn build(self) -> crate::error::TerminalStateException {
            crate::error::TerminalStateException {
                message: self.message,
            }
        }
    }
}
impl TerminalStateException {
    /// Creates a new builder-style object to manufacture [`TerminalStateException`](crate::error::TerminalStateException)
    pub fn builder() -> crate::error::terminal_state_exception::Builder {
        crate::error::terminal_state_exception::Builder::default()
    }
}
