// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchAcknowledgeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAcknowledgeAlarmError {
    /// Kind of error that occurred.
    pub kind: BatchAcknowledgeAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAcknowledgeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAcknowledgeAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAcknowledgeAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAcknowledgeAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchAcknowledgeAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchAcknowledgeAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchAcknowledgeAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchAcknowledgeAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAcknowledgeAlarmError {
    fn code(&self) -> Option<&str> {
        BatchAcknowledgeAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAcknowledgeAlarmError {
    /// Creates a new `BatchAcknowledgeAlarmError`.
    pub fn new(kind: BatchAcknowledgeAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAcknowledgeAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAcknowledgeAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAcknowledgeAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAcknowledgeAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAcknowledgeAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAcknowledgeAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAcknowledgeAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAcknowledgeAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAcknowledgeAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAcknowledgeAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAcknowledgeAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAcknowledgeAlarmErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchAcknowledgeAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAcknowledgeAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchAcknowledgeAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchAcknowledgeAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchAcknowledgeAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchAcknowledgeAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDisableAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisableAlarmError {
    /// Kind of error that occurred.
    pub kind: BatchDisableAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisableAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisableAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisableAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisableAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchDisableAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchDisableAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchDisableAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchDisableAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDisableAlarmError {
    fn code(&self) -> Option<&str> {
        BatchDisableAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisableAlarmError {
    /// Creates a new `BatchDisableAlarmError`.
    pub fn new(kind: BatchDisableAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisableAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisableAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisableAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisableAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisableAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisableAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisableAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisableAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisableAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisableAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisableAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisableAlarmErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchDisableAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisableAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchDisableAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchDisableAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchDisableAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchDisableAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchEnableAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchEnableAlarmError {
    /// Kind of error that occurred.
    pub kind: BatchEnableAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchEnableAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchEnableAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchEnableAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchEnableAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchEnableAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchEnableAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchEnableAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchEnableAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchEnableAlarmError {
    fn code(&self) -> Option<&str> {
        BatchEnableAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchEnableAlarmError {
    /// Creates a new `BatchEnableAlarmError`.
    pub fn new(kind: BatchEnableAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchEnableAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchEnableAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchEnableAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchEnableAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchEnableAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEnableAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEnableAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEnableAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEnableAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEnableAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchEnableAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchEnableAlarmErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchEnableAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchEnableAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchEnableAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchEnableAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchEnableAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchEnableAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchPutMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutMessageError {
    /// Kind of error that occurred.
    pub kind: BatchPutMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutMessageErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutMessageErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutMessageError {
    fn code(&self) -> Option<&str> {
        BatchPutMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutMessageError {
    /// Creates a new `BatchPutMessageError`.
    pub fn new(kind: BatchPutMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutMessageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, BatchPutMessageErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for BatchPutMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutMessageErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchResetAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchResetAlarmError {
    /// Kind of error that occurred.
    pub kind: BatchResetAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchResetAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchResetAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchResetAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchResetAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchResetAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchResetAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchResetAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchResetAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchResetAlarmError {
    fn code(&self) -> Option<&str> {
        BatchResetAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchResetAlarmError {
    /// Creates a new `BatchResetAlarmError`.
    pub fn new(kind: BatchResetAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchResetAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchResetAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchResetAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchResetAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchResetAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchResetAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchResetAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchResetAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchResetAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchResetAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchResetAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, BatchResetAlarmErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for BatchResetAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchResetAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchResetAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchResetAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchResetAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchResetAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchSnoozeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchSnoozeAlarmError {
    /// Kind of error that occurred.
    pub kind: BatchSnoozeAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchSnoozeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchSnoozeAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchSnoozeAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchSnoozeAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchSnoozeAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchSnoozeAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchSnoozeAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchSnoozeAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchSnoozeAlarmError {
    fn code(&self) -> Option<&str> {
        BatchSnoozeAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchSnoozeAlarmError {
    /// Creates a new `BatchSnoozeAlarmError`.
    pub fn new(kind: BatchSnoozeAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchSnoozeAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchSnoozeAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchSnoozeAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchSnoozeAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchSnoozeAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSnoozeAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSnoozeAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSnoozeAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSnoozeAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSnoozeAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchSnoozeAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchSnoozeAlarmErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchSnoozeAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchSnoozeAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchSnoozeAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchSnoozeAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchSnoozeAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchSnoozeAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUpdateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdateDetectorError {
    /// Kind of error that occurred.
    pub kind: BatchUpdateDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdateDetectorErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdateDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdateDetectorErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchUpdateDetectorErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchUpdateDetectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchUpdateDetectorErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchUpdateDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdateDetectorError {
    fn code(&self) -> Option<&str> {
        BatchUpdateDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdateDetectorError {
    /// Creates a new `BatchUpdateDetectorError`.
    pub fn new(kind: BatchUpdateDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdateDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdateDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdateDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdateDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUpdateDetectorErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateDetectorErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateDetectorErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateDetectorErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateDetectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateDetectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdateDetectorErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdateDetectorErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for BatchUpdateDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdateDetectorErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchUpdateDetectorErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchUpdateDetectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchUpdateDetectorErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchUpdateDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlarmError {
    /// Kind of error that occurred.
    pub kind: DescribeAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlarmErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlarmErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAlarmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAlarmErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAlarmErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAlarmErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlarmError {
    fn code(&self) -> Option<&str> {
        DescribeAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlarmError {
    /// Creates a new `DescribeAlarmError`.
    pub fn new(kind: DescribeAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlarmErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlarmErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlarmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlarmErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlarmErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlarmErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlarmErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlarmErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlarmErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeAlarmErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlarmErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAlarmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAlarmErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAlarmErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAlarmErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDetectorError {
    /// Kind of error that occurred.
    pub kind: DescribeDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDetectorErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDetectorErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDetectorError {
    fn code(&self) -> Option<&str> {
        DescribeDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDetectorError {
    /// Creates a new `DescribeDetectorError`.
    pub fn new(kind: DescribeDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDetectorErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectorErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectorErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectorErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectorErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDetectorErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAlarmsError {
    /// Kind of error that occurred.
    pub kind: ListAlarmsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAlarmsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAlarmsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAlarmsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAlarmsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAlarmsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAlarmsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAlarmsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAlarmsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAlarmsError {
    fn code(&self) -> Option<&str> {
        ListAlarmsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAlarmsError {
    /// Creates a new `ListAlarmsError`.
    pub fn new(kind: ListAlarmsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAlarmsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAlarmsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAlarmsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAlarmsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAlarmsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListAlarmsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListAlarmsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListAlarmsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAlarmsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAlarmsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAlarmsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAlarmsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAlarmsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAlarmsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListAlarmsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAlarmsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAlarmsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAlarmsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAlarmsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAlarmsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAlarmsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDetectorsError {
    /// Kind of error that occurred.
    pub kind: ListDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDetectorsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is currently unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request could not be completed due to throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDetectorsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDetectorsError {
    fn code(&self) -> Option<&str> {
        ListDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDetectorsError {
    /// Creates a new `ListDetectorsError`.
    pub fn new(kind: ListDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectorsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectorsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectorsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectorsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDetectorsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDetectorsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDetectorsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDetectorsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDetectorsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDetectorsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request could not be completed due to throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service is currently unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request was invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>An internal failure occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}
