// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about the detector (instance).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorSummary {
    /// <p>The name of the detector model that created this detector (instance).</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key (identifying the device or system) that caused the creation of this
    /// detector (instance).</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The version of the detector model that created this detector (instance).</p>
    pub detector_model_version: std::option::Option<std::string::String>,
    /// <p>The current state of the detector (instance).</p>
    pub state: std::option::Option<crate::model::DetectorStateSummary>,
    /// <p>The time the detector (instance) was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the detector (instance) was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DetectorSummary {
    /// <p>The name of the detector model that created this detector (instance).</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The value of the key (identifying the device or system) that caused the creation of this
    /// detector (instance).</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The version of the detector model that created this detector (instance).</p>
    pub fn detector_model_version(&self) -> std::option::Option<&str> {
        self.detector_model_version.as_deref()
    }
    /// <p>The current state of the detector (instance).</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DetectorStateSummary> {
        self.state.as_ref()
    }
    /// <p>The time the detector (instance) was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the detector (instance) was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for DetectorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorSummary");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("detector_model_version", &self.detector_model_version);
        formatter.field("state", &self.state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`DetectorSummary`](crate::model::DetectorSummary)
pub mod detector_summary {
    /// A builder for [`DetectorSummary`](crate::model::DetectorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) detector_model_version: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DetectorStateSummary>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the detector model that created this detector (instance).</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model that created this detector (instance).</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The value of the key (identifying the device or system) that caused the creation of this
        /// detector (instance).</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key (identifying the device or system) that caused the creation of this
        /// detector (instance).</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The version of the detector model that created this detector (instance).</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_version = Some(input.into());
            self
        }
        /// <p>The version of the detector model that created this detector (instance).</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_version = input;
            self
        }
        /// <p>The current state of the detector (instance).</p>
        pub fn state(mut self, input: crate::model::DetectorStateSummary) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the detector (instance).</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DetectorStateSummary>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The time the detector (instance) was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the detector (instance) was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the detector (instance) was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the detector (instance) was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorSummary`](crate::model::DetectorSummary)
        pub fn build(self) -> crate::model::DetectorSummary {
            crate::model::DetectorSummary {
                detector_model_name: self.detector_model_name,
                key_value: self.key_value,
                detector_model_version: self.detector_model_version,
                state: self.state,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl DetectorSummary {
    /// Creates a new builder-style object to manufacture [`DetectorSummary`](crate::model::DetectorSummary)
    pub fn builder() -> crate::model::detector_summary::Builder {
        crate::model::detector_summary::Builder::default()
    }
}

/// <p>Information about the detector state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorStateSummary {
    /// <p>The name of the state.</p>
    pub state_name: std::option::Option<std::string::String>,
}
impl DetectorStateSummary {
    /// <p>The name of the state.</p>
    pub fn state_name(&self) -> std::option::Option<&str> {
        self.state_name.as_deref()
    }
}
impl std::fmt::Debug for DetectorStateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorStateSummary");
        formatter.field("state_name", &self.state_name);
        formatter.finish()
    }
}
/// See [`DetectorStateSummary`](crate::model::DetectorStateSummary)
pub mod detector_state_summary {
    /// A builder for [`DetectorStateSummary`](crate::model::DetectorStateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the state.</p>
        pub fn state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_name = Some(input.into());
            self
        }
        /// <p>The name of the state.</p>
        pub fn set_state_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorStateSummary`](crate::model::DetectorStateSummary)
        pub fn build(self) -> crate::model::DetectorStateSummary {
            crate::model::DetectorStateSummary {
                state_name: self.state_name,
            }
        }
    }
}
impl DetectorStateSummary {
    /// Creates a new builder-style object to manufacture [`DetectorStateSummary`](crate::model::DetectorStateSummary)
    pub fn builder() -> crate::model::detector_state_summary::Builder {
        crate::model::detector_state_summary::Builder::default()
    }
}

/// <p>Contains a summary of an alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmSummary {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The name of the alarm state. The state name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
    /// it isn't ready to evaluate data. To enable the alarm,
    /// you must change the alarm to the <code>NORMAL</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
    /// it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
    /// the alarm is invoked.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
    /// the alarm was invoked and you acknowledged the alarm.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
    /// the alarm is disabled for a specified period of time. After the snooze time,
    /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
    /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
    /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
    /// </li>
    /// </ul>
    pub state_name: std::option::Option<crate::model::AlarmStateName>,
    /// <p>The time the alarm was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl AlarmSummary {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The version of the alarm model.</p>
    pub fn alarm_model_version(&self) -> std::option::Option<&str> {
        self.alarm_model_version.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The name of the alarm state. The state name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
    /// it isn't ready to evaluate data. To enable the alarm,
    /// you must change the alarm to the <code>NORMAL</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
    /// it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
    /// the alarm is invoked.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
    /// the alarm was invoked and you acknowledged the alarm.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
    /// the alarm is disabled for a specified period of time. After the snooze time,
    /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
    /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
    /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
    /// </li>
    /// </ul>
    pub fn state_name(&self) -> std::option::Option<&crate::model::AlarmStateName> {
        self.state_name.as_ref()
    }
    /// <p>The time the alarm was created, in the Unix epoch format.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for AlarmSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmSummary");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("key_value", &self.key_value);
        formatter.field("state_name", &self.state_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`AlarmSummary`](crate::model::AlarmSummary)
pub mod alarm_summary {
    /// A builder for [`AlarmSummary`](crate::model::AlarmSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) state_name: std::option::Option<crate::model::AlarmStateName>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The name of the alarm state. The state name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
        /// it isn't ready to evaluate data. To enable the alarm,
        /// you must change the alarm to the <code>NORMAL</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
        /// it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
        /// the alarm is invoked.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
        /// the alarm was invoked and you acknowledged the alarm.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
        /// the alarm is disabled for a specified period of time. After the snooze time,
        /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
        /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
        /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
        /// </li>
        /// </ul>
        pub fn state_name(mut self, input: crate::model::AlarmStateName) -> Self {
            self.state_name = Some(input);
            self
        }
        /// <p>The name of the alarm state. The state name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
        /// it isn't ready to evaluate data. To enable the alarm,
        /// you must change the alarm to the <code>NORMAL</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
        /// it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
        /// the alarm is invoked.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
        /// the alarm was invoked and you acknowledged the alarm.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
        /// the alarm is disabled for a specified period of time. After the snooze time,
        /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
        /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
        /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
        /// </li>
        /// </ul>
        pub fn set_state_name(
            mut self,
            input: std::option::Option<crate::model::AlarmStateName>,
        ) -> Self {
            self.state_name = input;
            self
        }
        /// <p>The time the alarm was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmSummary`](crate::model::AlarmSummary)
        pub fn build(self) -> crate::model::AlarmSummary {
            crate::model::AlarmSummary {
                alarm_model_name: self.alarm_model_name,
                alarm_model_version: self.alarm_model_version,
                key_value: self.key_value,
                state_name: self.state_name,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl AlarmSummary {
    /// Creates a new builder-style object to manufacture [`AlarmSummary`](crate::model::AlarmSummary)
    pub fn builder() -> crate::model::alarm_summary::Builder {
        crate::model::alarm_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlarmStateName {
    #[allow(missing_docs)] // documentation missing in model
    Acknowledged,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Latched,
    #[allow(missing_docs)] // documentation missing in model
    Normal,
    #[allow(missing_docs)] // documentation missing in model
    SnoozeDisabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlarmStateName {
    fn from(s: &str) -> Self {
        match s {
            "ACKNOWLEDGED" => AlarmStateName::Acknowledged,
            "ACTIVE" => AlarmStateName::Active,
            "DISABLED" => AlarmStateName::Disabled,
            "LATCHED" => AlarmStateName::Latched,
            "NORMAL" => AlarmStateName::Normal,
            "SNOOZE_DISABLED" => AlarmStateName::SnoozeDisabled,
            other => AlarmStateName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlarmStateName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlarmStateName::from(s))
    }
}
impl AlarmStateName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlarmStateName::Acknowledged => "ACKNOWLEDGED",
            AlarmStateName::Active => "ACTIVE",
            AlarmStateName::Disabled => "DISABLED",
            AlarmStateName::Latched => "LATCHED",
            AlarmStateName::Normal => "NORMAL",
            AlarmStateName::SnoozeDisabled => "SNOOZE_DISABLED",
            AlarmStateName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACKNOWLEDGED",
            "ACTIVE",
            "DISABLED",
            "LATCHED",
            "NORMAL",
            "SNOOZE_DISABLED",
        ]
    }
}
impl AsRef<str> for AlarmStateName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the detector (instance).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Detector {
    /// <p>The name of the detector model that created this detector (instance).</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key (identifying the device or system) that caused the creation of this
    /// detector (instance).</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The version of the detector model that created this detector (instance).</p>
    pub detector_model_version: std::option::Option<std::string::String>,
    /// <p>The current state of the detector (instance).</p>
    pub state: std::option::Option<crate::model::DetectorState>,
    /// <p>The time the detector (instance) was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the detector (instance) was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Detector {
    /// <p>The name of the detector model that created this detector (instance).</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The value of the key (identifying the device or system) that caused the creation of this
    /// detector (instance).</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The version of the detector model that created this detector (instance).</p>
    pub fn detector_model_version(&self) -> std::option::Option<&str> {
        self.detector_model_version.as_deref()
    }
    /// <p>The current state of the detector (instance).</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DetectorState> {
        self.state.as_ref()
    }
    /// <p>The time the detector (instance) was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the detector (instance) was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for Detector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Detector");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("detector_model_version", &self.detector_model_version);
        formatter.field("state", &self.state);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`Detector`](crate::model::Detector)
pub mod detector {
    /// A builder for [`Detector`](crate::model::Detector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) detector_model_version: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DetectorState>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the detector model that created this detector (instance).</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model that created this detector (instance).</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The value of the key (identifying the device or system) that caused the creation of this
        /// detector (instance).</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key (identifying the device or system) that caused the creation of this
        /// detector (instance).</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The version of the detector model that created this detector (instance).</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_version = Some(input.into());
            self
        }
        /// <p>The version of the detector model that created this detector (instance).</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_version = input;
            self
        }
        /// <p>The current state of the detector (instance).</p>
        pub fn state(mut self, input: crate::model::DetectorState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the detector (instance).</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DetectorState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The time the detector (instance) was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the detector (instance) was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the detector (instance) was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the detector (instance) was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Detector`](crate::model::Detector)
        pub fn build(self) -> crate::model::Detector {
            crate::model::Detector {
                detector_model_name: self.detector_model_name,
                key_value: self.key_value,
                detector_model_version: self.detector_model_version,
                state: self.state,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl Detector {
    /// Creates a new builder-style object to manufacture [`Detector`](crate::model::Detector)
    pub fn builder() -> crate::model::detector::Builder {
        crate::model::detector::Builder::default()
    }
}

/// <p>Information about the current state of the detector instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorState {
    /// <p>The name of the state.</p>
    pub state_name: std::option::Option<std::string::String>,
    /// <p>The current values of the detector's variables.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
    /// <p>The current state of the detector's timers.</p>
    pub timers: std::option::Option<std::vec::Vec<crate::model::Timer>>,
}
impl DetectorState {
    /// <p>The name of the state.</p>
    pub fn state_name(&self) -> std::option::Option<&str> {
        self.state_name.as_deref()
    }
    /// <p>The current values of the detector's variables.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::Variable]> {
        self.variables.as_deref()
    }
    /// <p>The current state of the detector's timers.</p>
    pub fn timers(&self) -> std::option::Option<&[crate::model::Timer]> {
        self.timers.as_deref()
    }
}
impl std::fmt::Debug for DetectorState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorState");
        formatter.field("state_name", &self.state_name);
        formatter.field("variables", &self.variables);
        formatter.field("timers", &self.timers);
        formatter.finish()
    }
}
/// See [`DetectorState`](crate::model::DetectorState)
pub mod detector_state {
    /// A builder for [`DetectorState`](crate::model::DetectorState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_name: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        pub(crate) timers: std::option::Option<std::vec::Vec<crate::model::Timer>>,
    }
    impl Builder {
        /// <p>The name of the state.</p>
        pub fn state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_name = Some(input.into());
            self
        }
        /// <p>The name of the state.</p>
        pub fn set_state_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_name = input;
            self
        }
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The current values of the detector's variables.</p>
        pub fn variables(mut self, input: impl Into<crate::model::Variable>) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input.into());
            self.variables = Some(v);
            self
        }
        /// <p>The current values of the detector's variables.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Appends an item to `timers`.
        ///
        /// To override the contents of this collection use [`set_timers`](Self::set_timers).
        ///
        /// <p>The current state of the detector's timers.</p>
        pub fn timers(mut self, input: impl Into<crate::model::Timer>) -> Self {
            let mut v = self.timers.unwrap_or_default();
            v.push(input.into());
            self.timers = Some(v);
            self
        }
        /// <p>The current state of the detector's timers.</p>
        pub fn set_timers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Timer>>,
        ) -> Self {
            self.timers = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorState`](crate::model::DetectorState)
        pub fn build(self) -> crate::model::DetectorState {
            crate::model::DetectorState {
                state_name: self.state_name,
                variables: self.variables,
                timers: self.timers,
            }
        }
    }
}
impl DetectorState {
    /// Creates a new builder-style object to manufacture [`DetectorState`](crate::model::DetectorState)
    pub fn builder() -> crate::model::detector_state::Builder {
        crate::model::detector_state::Builder::default()
    }
}

/// <p>The current state of a timer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Timer {
    /// <p>The name of the timer.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of seconds which have elapsed on the timer.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl Timer {
    /// <p>The name of the timer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The number of seconds which have elapsed on the timer.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for Timer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Timer");
        formatter.field("name", &self.name);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`Timer`](crate::model::Timer)
pub mod timer {
    /// A builder for [`Timer`](crate::model::Timer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the timer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the timer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of seconds which have elapsed on the timer.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The number of seconds which have elapsed on the timer.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Timer`](crate::model::Timer)
        pub fn build(self) -> crate::model::Timer {
            crate::model::Timer {
                name: self.name,
                timestamp: self.timestamp,
            }
        }
    }
}
impl Timer {
    /// Creates a new builder-style object to manufacture [`Timer`](crate::model::Timer)
    pub fn builder() -> crate::model::timer::Builder {
        crate::model::timer::Builder::default()
    }
}

/// <p>The current state of the variable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Variable {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current value of the variable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Variable {
    /// <p>The name of the variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current value of the variable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Variable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Variable");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Variable`](crate::model::Variable)
pub mod variable {
    /// A builder for [`Variable`](crate::model::Variable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current value of the variable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The current value of the variable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Variable`](crate::model::Variable)
        pub fn build(self) -> crate::model::Variable {
            crate::model::Variable {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Variable {
    /// Creates a new builder-style object to manufacture [`Variable`](crate::model::Variable)
    pub fn builder() -> crate::model::variable::Builder {
        crate::model::variable::Builder::default()
    }
}

/// <p>Contains information about an alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>Contains information about the current state of the alarm.</p>
    pub alarm_state: std::option::Option<crate::model::AlarmState>,
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub severity: std::option::Option<i32>,
    /// <p>The time the alarm was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Alarm {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The version of the alarm model.</p>
    pub fn alarm_model_version(&self) -> std::option::Option<&str> {
        self.alarm_model_version.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>Contains information about the current state of the alarm.</p>
    pub fn alarm_state(&self) -> std::option::Option<&crate::model::AlarmState> {
        self.alarm_state.as_ref()
    }
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub fn severity(&self) -> std::option::Option<i32> {
        self.severity
    }
    /// <p>The time the alarm was created, in the Unix epoch format.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("key_value", &self.key_value);
        formatter.field("alarm_state", &self.alarm_state);
        formatter.field("severity", &self.severity);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`Alarm`](crate::model::Alarm)
pub mod alarm {
    /// A builder for [`Alarm`](crate::model::Alarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) alarm_state: std::option::Option<crate::model::AlarmState>,
        pub(crate) severity: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>Contains information about the current state of the alarm.</p>
        pub fn alarm_state(mut self, input: crate::model::AlarmState) -> Self {
            self.alarm_state = Some(input);
            self
        }
        /// <p>Contains information about the current state of the alarm.</p>
        pub fn set_alarm_state(
            mut self,
            input: std::option::Option<crate::model::AlarmState>,
        ) -> Self {
            self.alarm_state = input;
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The time the alarm was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarm`](crate::model::Alarm)
        pub fn build(self) -> crate::model::Alarm {
            crate::model::Alarm {
                alarm_model_name: self.alarm_model_name,
                alarm_model_version: self.alarm_model_version,
                key_value: self.key_value,
                alarm_state: self.alarm_state,
                severity: self.severity,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl Alarm {
    /// Creates a new builder-style object to manufacture [`Alarm`](crate::model::Alarm)
    pub fn builder() -> crate::model::alarm::Builder {
        crate::model::alarm::Builder::default()
    }
}

/// <p>Contains information about the current state of the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmState {
    /// <p>The name of the alarm state. The state name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
    /// it isn't ready to evaluate data. To enable the alarm,
    /// you must change the alarm to the <code>NORMAL</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
    /// it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
    /// the alarm is invoked.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
    /// the alarm was invoked and you acknowledged the alarm.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
    /// the alarm is disabled for a specified period of time. After the snooze time,
    /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
    /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
    /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
    /// </li>
    /// </ul>
    pub state_name: std::option::Option<crate::model::AlarmStateName>,
    /// <p>Information needed to evaluate data.</p>
    pub rule_evaluation: std::option::Option<crate::model::RuleEvaluation>,
    /// <p>Contains information about the action that you can take to respond to the alarm.</p>
    pub customer_action: std::option::Option<crate::model::CustomerAction>,
    /// <p>Contains information about alarm state changes.</p>
    pub system_event: std::option::Option<crate::model::SystemEvent>,
}
impl AlarmState {
    /// <p>The name of the alarm state. The state name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
    /// it isn't ready to evaluate data. To enable the alarm,
    /// you must change the alarm to the <code>NORMAL</code> state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
    /// it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
    /// the alarm is invoked.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
    /// the alarm was invoked and you acknowledged the alarm.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
    /// the alarm is disabled for a specified period of time. After the snooze time,
    /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
    /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
    /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
    /// </li>
    /// </ul>
    pub fn state_name(&self) -> std::option::Option<&crate::model::AlarmStateName> {
        self.state_name.as_ref()
    }
    /// <p>Information needed to evaluate data.</p>
    pub fn rule_evaluation(&self) -> std::option::Option<&crate::model::RuleEvaluation> {
        self.rule_evaluation.as_ref()
    }
    /// <p>Contains information about the action that you can take to respond to the alarm.</p>
    pub fn customer_action(&self) -> std::option::Option<&crate::model::CustomerAction> {
        self.customer_action.as_ref()
    }
    /// <p>Contains information about alarm state changes.</p>
    pub fn system_event(&self) -> std::option::Option<&crate::model::SystemEvent> {
        self.system_event.as_ref()
    }
}
impl std::fmt::Debug for AlarmState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmState");
        formatter.field("state_name", &self.state_name);
        formatter.field("rule_evaluation", &self.rule_evaluation);
        formatter.field("customer_action", &self.customer_action);
        formatter.field("system_event", &self.system_event);
        formatter.finish()
    }
}
/// See [`AlarmState`](crate::model::AlarmState)
pub mod alarm_state {
    /// A builder for [`AlarmState`](crate::model::AlarmState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_name: std::option::Option<crate::model::AlarmStateName>,
        pub(crate) rule_evaluation: std::option::Option<crate::model::RuleEvaluation>,
        pub(crate) customer_action: std::option::Option<crate::model::CustomerAction>,
        pub(crate) system_event: std::option::Option<crate::model::SystemEvent>,
    }
    impl Builder {
        /// <p>The name of the alarm state. The state name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
        /// it isn't ready to evaluate data. To enable the alarm,
        /// you must change the alarm to the <code>NORMAL</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
        /// it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
        /// the alarm is invoked.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
        /// the alarm was invoked and you acknowledged the alarm.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
        /// the alarm is disabled for a specified period of time. After the snooze time,
        /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
        /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
        /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
        /// </li>
        /// </ul>
        pub fn state_name(mut self, input: crate::model::AlarmStateName) -> Self {
            self.state_name = Some(input);
            self
        }
        /// <p>The name of the alarm state. The state name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state,
        /// it isn't ready to evaluate data. To enable the alarm,
        /// you must change the alarm to the <code>NORMAL</code> state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state,
        /// it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state,
        /// the alarm is invoked.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state,
        /// the alarm was invoked and you acknowledged the alarm.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state,
        /// the alarm is disabled for a specified period of time. After the snooze time,
        /// the alarm automatically changes to the <code>NORMAL</code> state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state,
        /// the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range.
        /// To change the alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.</p>
        /// </li>
        /// </ul>
        pub fn set_state_name(
            mut self,
            input: std::option::Option<crate::model::AlarmStateName>,
        ) -> Self {
            self.state_name = input;
            self
        }
        /// <p>Information needed to evaluate data.</p>
        pub fn rule_evaluation(mut self, input: crate::model::RuleEvaluation) -> Self {
            self.rule_evaluation = Some(input);
            self
        }
        /// <p>Information needed to evaluate data.</p>
        pub fn set_rule_evaluation(
            mut self,
            input: std::option::Option<crate::model::RuleEvaluation>,
        ) -> Self {
            self.rule_evaluation = input;
            self
        }
        /// <p>Contains information about the action that you can take to respond to the alarm.</p>
        pub fn customer_action(mut self, input: crate::model::CustomerAction) -> Self {
            self.customer_action = Some(input);
            self
        }
        /// <p>Contains information about the action that you can take to respond to the alarm.</p>
        pub fn set_customer_action(
            mut self,
            input: std::option::Option<crate::model::CustomerAction>,
        ) -> Self {
            self.customer_action = input;
            self
        }
        /// <p>Contains information about alarm state changes.</p>
        pub fn system_event(mut self, input: crate::model::SystemEvent) -> Self {
            self.system_event = Some(input);
            self
        }
        /// <p>Contains information about alarm state changes.</p>
        pub fn set_system_event(
            mut self,
            input: std::option::Option<crate::model::SystemEvent>,
        ) -> Self {
            self.system_event = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmState`](crate::model::AlarmState)
        pub fn build(self) -> crate::model::AlarmState {
            crate::model::AlarmState {
                state_name: self.state_name,
                rule_evaluation: self.rule_evaluation,
                customer_action: self.customer_action,
                system_event: self.system_event,
            }
        }
    }
}
impl AlarmState {
    /// Creates a new builder-style object to manufacture [`AlarmState`](crate::model::AlarmState)
    pub fn builder() -> crate::model::alarm_state::Builder {
        crate::model::alarm_state::Builder::default()
    }
}

/// <p>Contains information about alarm state changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemEvent {
    /// <p>The event type. If the value is <code>STATE_CHANGE</code>, the event contains information
    /// about alarm state changes.</p>
    pub event_type: std::option::Option<crate::model::EventType>,
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub state_change_configuration: std::option::Option<crate::model::StateChangeConfiguration>,
}
impl SystemEvent {
    /// <p>The event type. If the value is <code>STATE_CHANGE</code>, the event contains information
    /// about alarm state changes.</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub fn state_change_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StateChangeConfiguration> {
        self.state_change_configuration.as_ref()
    }
}
impl std::fmt::Debug for SystemEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemEvent");
        formatter.field("event_type", &self.event_type);
        formatter.field(
            "state_change_configuration",
            &self.state_change_configuration,
        );
        formatter.finish()
    }
}
/// See [`SystemEvent`](crate::model::SystemEvent)
pub mod system_event {
    /// A builder for [`SystemEvent`](crate::model::SystemEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
        pub(crate) state_change_configuration:
            std::option::Option<crate::model::StateChangeConfiguration>,
    }
    impl Builder {
        /// <p>The event type. If the value is <code>STATE_CHANGE</code>, the event contains information
        /// about alarm state changes.</p>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The event type. If the value is <code>STATE_CHANGE</code>, the event contains information
        /// about alarm state changes.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn state_change_configuration(
            mut self,
            input: crate::model::StateChangeConfiguration,
        ) -> Self {
            self.state_change_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_state_change_configuration(
            mut self,
            input: std::option::Option<crate::model::StateChangeConfiguration>,
        ) -> Self {
            self.state_change_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemEvent`](crate::model::SystemEvent)
        pub fn build(self) -> crate::model::SystemEvent {
            crate::model::SystemEvent {
                event_type: self.event_type,
                state_change_configuration: self.state_change_configuration,
            }
        }
    }
}
impl SystemEvent {
    /// Creates a new builder-style object to manufacture [`SystemEvent`](crate::model::SystemEvent)
    pub fn builder() -> crate::model::system_event::Builder {
        crate::model::system_event::Builder::default()
    }
}

/// <p>Contains the configuration information of alarm state changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateChangeConfiguration {
    /// <p>The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends
    /// and the alarm automatically changes to the <code>NORMAL</code> state.</p>
    pub trigger_type: std::option::Option<crate::model::TriggerType>,
}
impl StateChangeConfiguration {
    /// <p>The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends
    /// and the alarm automatically changes to the <code>NORMAL</code> state.</p>
    pub fn trigger_type(&self) -> std::option::Option<&crate::model::TriggerType> {
        self.trigger_type.as_ref()
    }
}
impl std::fmt::Debug for StateChangeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateChangeConfiguration");
        formatter.field("trigger_type", &self.trigger_type);
        formatter.finish()
    }
}
/// See [`StateChangeConfiguration`](crate::model::StateChangeConfiguration)
pub mod state_change_configuration {
    /// A builder for [`StateChangeConfiguration`](crate::model::StateChangeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_type: std::option::Option<crate::model::TriggerType>,
    }
    impl Builder {
        /// <p>The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends
        /// and the alarm automatically changes to the <code>NORMAL</code> state.</p>
        pub fn trigger_type(mut self, input: crate::model::TriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p>The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends
        /// and the alarm automatically changes to the <code>NORMAL</code> state.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::TriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StateChangeConfiguration`](crate::model::StateChangeConfiguration)
        pub fn build(self) -> crate::model::StateChangeConfiguration {
            crate::model::StateChangeConfiguration {
                trigger_type: self.trigger_type,
            }
        }
    }
}
impl StateChangeConfiguration {
    /// Creates a new builder-style object to manufacture [`StateChangeConfiguration`](crate::model::StateChangeConfiguration)
    pub fn builder() -> crate::model::state_change_configuration::Builder {
        crate::model::state_change_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerType {
    #[allow(missing_docs)] // documentation missing in model
    SnoozeTimeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerType {
    fn from(s: &str) -> Self {
        match s {
            "SNOOZE_TIMEOUT" => TriggerType::SnoozeTimeout,
            other => TriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerType::from(s))
    }
}
impl TriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerType::SnoozeTimeout => "SNOOZE_TIMEOUT",
            TriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SNOOZE_TIMEOUT"]
    }
}
impl AsRef<str> for TriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    StateChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "STATE_CHANGE" => EventType::StateChange,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::StateChange => "STATE_CHANGE",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STATE_CHANGE"]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the action that you can take to respond to the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerAction {
    /// <p>The name of the action. The action name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html">AlarmState</a> API.</p>
    pub action_name: std::option::Option<crate::model::CustomerActionName>,
    /// <p>Contains the configuration information of a snooze action.</p>
    pub snooze_action_configuration: std::option::Option<crate::model::SnoozeActionConfiguration>,
    /// <p>Contains the configuration information of an enable action.</p>
    pub enable_action_configuration: std::option::Option<crate::model::EnableActionConfiguration>,
    /// <p>Contains the configuration information of a disable action.</p>
    pub disable_action_configuration: std::option::Option<crate::model::DisableActionConfiguration>,
    /// <p>Contains the configuration information of an acknowledge action.</p>
    pub acknowledge_action_configuration:
        std::option::Option<crate::model::AcknowledgeActionConfiguration>,
    /// <p>Contains the configuration information of a reset action.</p>
    pub reset_action_configuration: std::option::Option<crate::model::ResetActionConfiguration>,
}
impl CustomerAction {
    /// <p>The name of the action. The action name can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html">AlarmState</a> API.</p>
    pub fn action_name(&self) -> std::option::Option<&crate::model::CustomerActionName> {
        self.action_name.as_ref()
    }
    /// <p>Contains the configuration information of a snooze action.</p>
    pub fn snooze_action_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SnoozeActionConfiguration> {
        self.snooze_action_configuration.as_ref()
    }
    /// <p>Contains the configuration information of an enable action.</p>
    pub fn enable_action_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EnableActionConfiguration> {
        self.enable_action_configuration.as_ref()
    }
    /// <p>Contains the configuration information of a disable action.</p>
    pub fn disable_action_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DisableActionConfiguration> {
        self.disable_action_configuration.as_ref()
    }
    /// <p>Contains the configuration information of an acknowledge action.</p>
    pub fn acknowledge_action_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AcknowledgeActionConfiguration> {
        self.acknowledge_action_configuration.as_ref()
    }
    /// <p>Contains the configuration information of a reset action.</p>
    pub fn reset_action_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ResetActionConfiguration> {
        self.reset_action_configuration.as_ref()
    }
}
impl std::fmt::Debug for CustomerAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerAction");
        formatter.field("action_name", &self.action_name);
        formatter.field(
            "snooze_action_configuration",
            &self.snooze_action_configuration,
        );
        formatter.field(
            "enable_action_configuration",
            &self.enable_action_configuration,
        );
        formatter.field(
            "disable_action_configuration",
            &self.disable_action_configuration,
        );
        formatter.field(
            "acknowledge_action_configuration",
            &self.acknowledge_action_configuration,
        );
        formatter.field(
            "reset_action_configuration",
            &self.reset_action_configuration,
        );
        formatter.finish()
    }
}
/// See [`CustomerAction`](crate::model::CustomerAction)
pub mod customer_action {
    /// A builder for [`CustomerAction`](crate::model::CustomerAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<crate::model::CustomerActionName>,
        pub(crate) snooze_action_configuration:
            std::option::Option<crate::model::SnoozeActionConfiguration>,
        pub(crate) enable_action_configuration:
            std::option::Option<crate::model::EnableActionConfiguration>,
        pub(crate) disable_action_configuration:
            std::option::Option<crate::model::DisableActionConfiguration>,
        pub(crate) acknowledge_action_configuration:
            std::option::Option<crate::model::AcknowledgeActionConfiguration>,
        pub(crate) reset_action_configuration:
            std::option::Option<crate::model::ResetActionConfiguration>,
    }
    impl Builder {
        /// <p>The name of the action. The action name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html">AlarmState</a> API.</p>
        pub fn action_name(mut self, input: crate::model::CustomerActionName) -> Self {
            self.action_name = Some(input);
            self
        }
        /// <p>The name of the action. The action name can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SNOOZE</code> - When you snooze the alarm, the alarm state changes to <code>SNOOZE_DISABLED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENABLE</code> - When you enable the alarm, the alarm state changes to <code>NORMAL</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLE</code> - When you disable the alarm, the alarm state changes to <code>DISABLED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACKNOWLEDGE</code> - When you acknowledge the alarm, the alarm state changes to <code>ACKNOWLEDGED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESET</code> - When you reset the alarm, the alarm state changes to <code>NORMAL</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html">AlarmState</a> API.</p>
        pub fn set_action_name(
            mut self,
            input: std::option::Option<crate::model::CustomerActionName>,
        ) -> Self {
            self.action_name = input;
            self
        }
        /// <p>Contains the configuration information of a snooze action.</p>
        pub fn snooze_action_configuration(
            mut self,
            input: crate::model::SnoozeActionConfiguration,
        ) -> Self {
            self.snooze_action_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of a snooze action.</p>
        pub fn set_snooze_action_configuration(
            mut self,
            input: std::option::Option<crate::model::SnoozeActionConfiguration>,
        ) -> Self {
            self.snooze_action_configuration = input;
            self
        }
        /// <p>Contains the configuration information of an enable action.</p>
        pub fn enable_action_configuration(
            mut self,
            input: crate::model::EnableActionConfiguration,
        ) -> Self {
            self.enable_action_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of an enable action.</p>
        pub fn set_enable_action_configuration(
            mut self,
            input: std::option::Option<crate::model::EnableActionConfiguration>,
        ) -> Self {
            self.enable_action_configuration = input;
            self
        }
        /// <p>Contains the configuration information of a disable action.</p>
        pub fn disable_action_configuration(
            mut self,
            input: crate::model::DisableActionConfiguration,
        ) -> Self {
            self.disable_action_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of a disable action.</p>
        pub fn set_disable_action_configuration(
            mut self,
            input: std::option::Option<crate::model::DisableActionConfiguration>,
        ) -> Self {
            self.disable_action_configuration = input;
            self
        }
        /// <p>Contains the configuration information of an acknowledge action.</p>
        pub fn acknowledge_action_configuration(
            mut self,
            input: crate::model::AcknowledgeActionConfiguration,
        ) -> Self {
            self.acknowledge_action_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of an acknowledge action.</p>
        pub fn set_acknowledge_action_configuration(
            mut self,
            input: std::option::Option<crate::model::AcknowledgeActionConfiguration>,
        ) -> Self {
            self.acknowledge_action_configuration = input;
            self
        }
        /// <p>Contains the configuration information of a reset action.</p>
        pub fn reset_action_configuration(
            mut self,
            input: crate::model::ResetActionConfiguration,
        ) -> Self {
            self.reset_action_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of a reset action.</p>
        pub fn set_reset_action_configuration(
            mut self,
            input: std::option::Option<crate::model::ResetActionConfiguration>,
        ) -> Self {
            self.reset_action_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerAction`](crate::model::CustomerAction)
        pub fn build(self) -> crate::model::CustomerAction {
            crate::model::CustomerAction {
                action_name: self.action_name,
                snooze_action_configuration: self.snooze_action_configuration,
                enable_action_configuration: self.enable_action_configuration,
                disable_action_configuration: self.disable_action_configuration,
                acknowledge_action_configuration: self.acknowledge_action_configuration,
                reset_action_configuration: self.reset_action_configuration,
            }
        }
    }
}
impl CustomerAction {
    /// Creates a new builder-style object to manufacture [`CustomerAction`](crate::model::CustomerAction)
    pub fn builder() -> crate::model::customer_action::Builder {
        crate::model::customer_action::Builder::default()
    }
}

/// <p>Contains the configuration information of a reset action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetActionConfiguration {
    /// <p>The note that you can leave when you reset the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl ResetActionConfiguration {
    /// <p>The note that you can leave when you reset the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for ResetActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetActionConfiguration");
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`ResetActionConfiguration`](crate::model::ResetActionConfiguration)
pub mod reset_action_configuration {
    /// A builder for [`ResetActionConfiguration`](crate::model::ResetActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The note that you can leave when you reset the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you reset the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetActionConfiguration`](crate::model::ResetActionConfiguration)
        pub fn build(self) -> crate::model::ResetActionConfiguration {
            crate::model::ResetActionConfiguration { note: self.note }
        }
    }
}
impl ResetActionConfiguration {
    /// Creates a new builder-style object to manufacture [`ResetActionConfiguration`](crate::model::ResetActionConfiguration)
    pub fn builder() -> crate::model::reset_action_configuration::Builder {
        crate::model::reset_action_configuration::Builder::default()
    }
}

/// <p>Contains the configuration information of an acknowledge action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeActionConfiguration {
    /// <p>The note that you can leave when you acknowledge the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl AcknowledgeActionConfiguration {
    /// <p>The note that you can leave when you acknowledge the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for AcknowledgeActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeActionConfiguration");
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`AcknowledgeActionConfiguration`](crate::model::AcknowledgeActionConfiguration)
pub mod acknowledge_action_configuration {
    /// A builder for [`AcknowledgeActionConfiguration`](crate::model::AcknowledgeActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The note that you can leave when you acknowledge the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you acknowledge the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeActionConfiguration`](crate::model::AcknowledgeActionConfiguration)
        pub fn build(self) -> crate::model::AcknowledgeActionConfiguration {
            crate::model::AcknowledgeActionConfiguration { note: self.note }
        }
    }
}
impl AcknowledgeActionConfiguration {
    /// Creates a new builder-style object to manufacture [`AcknowledgeActionConfiguration`](crate::model::AcknowledgeActionConfiguration)
    pub fn builder() -> crate::model::acknowledge_action_configuration::Builder {
        crate::model::acknowledge_action_configuration::Builder::default()
    }
}

/// <p>Contains the configuration information of a disable action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableActionConfiguration {
    /// <p>The note that you can leave when you disable the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl DisableActionConfiguration {
    /// <p>The note that you can leave when you disable the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for DisableActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableActionConfiguration");
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`DisableActionConfiguration`](crate::model::DisableActionConfiguration)
pub mod disable_action_configuration {
    /// A builder for [`DisableActionConfiguration`](crate::model::DisableActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The note that you can leave when you disable the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you disable the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableActionConfiguration`](crate::model::DisableActionConfiguration)
        pub fn build(self) -> crate::model::DisableActionConfiguration {
            crate::model::DisableActionConfiguration { note: self.note }
        }
    }
}
impl DisableActionConfiguration {
    /// Creates a new builder-style object to manufacture [`DisableActionConfiguration`](crate::model::DisableActionConfiguration)
    pub fn builder() -> crate::model::disable_action_configuration::Builder {
        crate::model::disable_action_configuration::Builder::default()
    }
}

/// <p>Contains the configuration information of an enable action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableActionConfiguration {
    /// <p>The note that you can leave when you enable the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl EnableActionConfiguration {
    /// <p>The note that you can leave when you enable the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for EnableActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableActionConfiguration");
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`EnableActionConfiguration`](crate::model::EnableActionConfiguration)
pub mod enable_action_configuration {
    /// A builder for [`EnableActionConfiguration`](crate::model::EnableActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The note that you can leave when you enable the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you enable the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableActionConfiguration`](crate::model::EnableActionConfiguration)
        pub fn build(self) -> crate::model::EnableActionConfiguration {
            crate::model::EnableActionConfiguration { note: self.note }
        }
    }
}
impl EnableActionConfiguration {
    /// Creates a new builder-style object to manufacture [`EnableActionConfiguration`](crate::model::EnableActionConfiguration)
    pub fn builder() -> crate::model::enable_action_configuration::Builder {
        crate::model::enable_action_configuration::Builder::default()
    }
}

/// <p>Contains the configuration information of a snooze action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnoozeActionConfiguration {
    /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
    pub snooze_duration: std::option::Option<i32>,
    /// <p>The note that you can leave when you snooze the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl SnoozeActionConfiguration {
    /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
    pub fn snooze_duration(&self) -> std::option::Option<i32> {
        self.snooze_duration
    }
    /// <p>The note that you can leave when you snooze the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for SnoozeActionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnoozeActionConfiguration");
        formatter.field("snooze_duration", &self.snooze_duration);
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`SnoozeActionConfiguration`](crate::model::SnoozeActionConfiguration)
pub mod snooze_action_configuration {
    /// A builder for [`SnoozeActionConfiguration`](crate::model::SnoozeActionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snooze_duration: std::option::Option<i32>,
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
        pub fn snooze_duration(mut self, input: i32) -> Self {
            self.snooze_duration = Some(input);
            self
        }
        /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
        pub fn set_snooze_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.snooze_duration = input;
            self
        }
        /// <p>The note that you can leave when you snooze the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you snooze the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`SnoozeActionConfiguration`](crate::model::SnoozeActionConfiguration)
        pub fn build(self) -> crate::model::SnoozeActionConfiguration {
            crate::model::SnoozeActionConfiguration {
                snooze_duration: self.snooze_duration,
                note: self.note,
            }
        }
    }
}
impl SnoozeActionConfiguration {
    /// Creates a new builder-style object to manufacture [`SnoozeActionConfiguration`](crate::model::SnoozeActionConfiguration)
    pub fn builder() -> crate::model::snooze_action_configuration::Builder {
        crate::model::snooze_action_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomerActionName {
    #[allow(missing_docs)] // documentation missing in model
    Acknowledge,
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    #[allow(missing_docs)] // documentation missing in model
    Reset,
    #[allow(missing_docs)] // documentation missing in model
    Snooze,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomerActionName {
    fn from(s: &str) -> Self {
        match s {
            "ACKNOWLEDGE" => CustomerActionName::Acknowledge,
            "DISABLE" => CustomerActionName::Disable,
            "ENABLE" => CustomerActionName::Enable,
            "RESET" => CustomerActionName::Reset,
            "SNOOZE" => CustomerActionName::Snooze,
            other => CustomerActionName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomerActionName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomerActionName::from(s))
    }
}
impl CustomerActionName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomerActionName::Acknowledge => "ACKNOWLEDGE",
            CustomerActionName::Disable => "DISABLE",
            CustomerActionName::Enable => "ENABLE",
            CustomerActionName::Reset => "RESET",
            CustomerActionName::Snooze => "SNOOZE",
            CustomerActionName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACKNOWLEDGE", "DISABLE", "ENABLE", "RESET", "SNOOZE"]
    }
}
impl AsRef<str> for CustomerActionName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information needed to evaluate data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleEvaluation {
    /// <p>Information needed to compare two values with a comparison operator.</p>
    pub simple_rule_evaluation: std::option::Option<crate::model::SimpleRuleEvaluation>,
}
impl RuleEvaluation {
    /// <p>Information needed to compare two values with a comparison operator.</p>
    pub fn simple_rule_evaluation(
        &self,
    ) -> std::option::Option<&crate::model::SimpleRuleEvaluation> {
        self.simple_rule_evaluation.as_ref()
    }
}
impl std::fmt::Debug for RuleEvaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleEvaluation");
        formatter.field("simple_rule_evaluation", &self.simple_rule_evaluation);
        formatter.finish()
    }
}
/// See [`RuleEvaluation`](crate::model::RuleEvaluation)
pub mod rule_evaluation {
    /// A builder for [`RuleEvaluation`](crate::model::RuleEvaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_rule_evaluation: std::option::Option<crate::model::SimpleRuleEvaluation>,
    }
    impl Builder {
        /// <p>Information needed to compare two values with a comparison operator.</p>
        pub fn simple_rule_evaluation(mut self, input: crate::model::SimpleRuleEvaluation) -> Self {
            self.simple_rule_evaluation = Some(input);
            self
        }
        /// <p>Information needed to compare two values with a comparison operator.</p>
        pub fn set_simple_rule_evaluation(
            mut self,
            input: std::option::Option<crate::model::SimpleRuleEvaluation>,
        ) -> Self {
            self.simple_rule_evaluation = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleEvaluation`](crate::model::RuleEvaluation)
        pub fn build(self) -> crate::model::RuleEvaluation {
            crate::model::RuleEvaluation {
                simple_rule_evaluation: self.simple_rule_evaluation,
            }
        }
    }
}
impl RuleEvaluation {
    /// Creates a new builder-style object to manufacture [`RuleEvaluation`](crate::model::RuleEvaluation)
    pub fn builder() -> crate::model::rule_evaluation::Builder {
        crate::model::rule_evaluation::Builder::default()
    }
}

/// <p>Information needed to compare two values with a comparison operator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleRuleEvaluation {
    /// <p>The value of the input property, on the left side of the comparison operator.</p>
    pub input_property_value: std::option::Option<std::string::String>,
    /// <p>The comparison operator.</p>
    pub operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The threshold value, on the right side of the comparison operator.</p>
    pub threshold_value: std::option::Option<std::string::String>,
}
impl SimpleRuleEvaluation {
    /// <p>The value of the input property, on the left side of the comparison operator.</p>
    pub fn input_property_value(&self) -> std::option::Option<&str> {
        self.input_property_value.as_deref()
    }
    /// <p>The comparison operator.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.operator.as_ref()
    }
    /// <p>The threshold value, on the right side of the comparison operator.</p>
    pub fn threshold_value(&self) -> std::option::Option<&str> {
        self.threshold_value.as_deref()
    }
}
impl std::fmt::Debug for SimpleRuleEvaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleRuleEvaluation");
        formatter.field("input_property_value", &self.input_property_value);
        formatter.field("operator", &self.operator);
        formatter.field("threshold_value", &self.threshold_value);
        formatter.finish()
    }
}
/// See [`SimpleRuleEvaluation`](crate::model::SimpleRuleEvaluation)
pub mod simple_rule_evaluation {
    /// A builder for [`SimpleRuleEvaluation`](crate::model::SimpleRuleEvaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_property_value: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) threshold_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the input property, on the left side of the comparison operator.</p>
        pub fn input_property_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_property_value = Some(input.into());
            self
        }
        /// <p>The value of the input property, on the left side of the comparison operator.</p>
        pub fn set_input_property_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_property_value = input;
            self
        }
        /// <p>The comparison operator.</p>
        pub fn operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The comparison operator.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The threshold value, on the right side of the comparison operator.</p>
        pub fn threshold_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.threshold_value = Some(input.into());
            self
        }
        /// <p>The threshold value, on the right side of the comparison operator.</p>
        pub fn set_threshold_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threshold_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleRuleEvaluation`](crate::model::SimpleRuleEvaluation)
        pub fn build(self) -> crate::model::SimpleRuleEvaluation {
            crate::model::SimpleRuleEvaluation {
                input_property_value: self.input_property_value,
                operator: self.operator,
                threshold_value: self.threshold_value,
            }
        }
    }
}
impl SimpleRuleEvaluation {
    /// Creates a new builder-style object to manufacture [`SimpleRuleEvaluation`](crate::model::SimpleRuleEvaluation)
    pub fn builder() -> crate::model::simple_rule_evaluation::Builder {
        crate::model::simple_rule_evaluation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    Greater,
    #[allow(missing_docs)] // documentation missing in model
    GreaterOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    Less,
    #[allow(missing_docs)] // documentation missing in model
    LessOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQUAL" => ComparisonOperator::Equal,
            "GREATER" => ComparisonOperator::Greater,
            "GREATER_OR_EQUAL" => ComparisonOperator::GreaterOrEqual,
            "LESS" => ComparisonOperator::Less,
            "LESS_OR_EQUAL" => ComparisonOperator::LessOrEqual,
            "NOT_EQUAL" => ComparisonOperator::NotEqual,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::Equal => "EQUAL",
            ComparisonOperator::Greater => "GREATER",
            ComparisonOperator::GreaterOrEqual => "GREATER_OR_EQUAL",
            ComparisonOperator::Less => "LESS",
            ComparisonOperator::LessOrEqual => "LESS_OR_EQUAL",
            ComparisonOperator::NotEqual => "NOT_EQUAL",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EQUAL",
            "GREATER",
            "GREATER_OR_EQUAL",
            "LESS",
            "LESS_OR_EQUAL",
            "NOT_EQUAL",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the error that occurred when attempting to update a detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateDetectorErrorEntry {
    /// <p>The <code>"messageId"</code> of the update request that caused the error. (The value of
    /// the <code>"messageId"</code> in the update request <code>"Detector"</code> object.)</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>A message that describes the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchUpdateDetectorErrorEntry {
    /// <p>The <code>"messageId"</code> of the update request that caused the error. (The value of
    /// the <code>"messageId"</code> in the update request <code>"Detector"</code> object.)</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A message that describes the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateDetectorErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateDetectorErrorEntry");
        formatter.field("message_id", &self.message_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchUpdateDetectorErrorEntry`](crate::model::BatchUpdateDetectorErrorEntry)
pub mod batch_update_detector_error_entry {
    /// A builder for [`BatchUpdateDetectorErrorEntry`](crate::model::BatchUpdateDetectorErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>"messageId"</code> of the update request that caused the error. (The value of
        /// the <code>"messageId"</code> in the update request <code>"Detector"</code> object.)</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The <code>"messageId"</code> of the update request that caused the error. (The value of
        /// the <code>"messageId"</code> in the update request <code>"Detector"</code> object.)</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateDetectorErrorEntry`](crate::model::BatchUpdateDetectorErrorEntry)
        pub fn build(self) -> crate::model::BatchUpdateDetectorErrorEntry {
            crate::model::BatchUpdateDetectorErrorEntry {
                message_id: self.message_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchUpdateDetectorErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchUpdateDetectorErrorEntry`](crate::model::BatchUpdateDetectorErrorEntry)
    pub fn builder() -> crate::model::batch_update_detector_error_entry::Builder {
        crate::model::batch_update_detector_error_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException,
    #[allow(missing_docs)] // documentation missing in model
    ServiceUnavailableException,
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingException,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "InternalFailureException" => ErrorCode::InternalFailureException,
            "InvalidRequestException" => ErrorCode::InvalidRequestException,
            "ResourceNotFoundException" => ErrorCode::ResourceNotFoundException,
            "ServiceUnavailableException" => ErrorCode::ServiceUnavailableException,
            "ThrottlingException" => ErrorCode::ThrottlingException,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::InternalFailureException => "InternalFailureException",
            ErrorCode::InvalidRequestException => "InvalidRequestException",
            ErrorCode::ResourceNotFoundException => "ResourceNotFoundException",
            ErrorCode::ServiceUnavailableException => "ServiceUnavailableException",
            ErrorCode::ThrottlingException => "ThrottlingException",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "InternalFailureException",
            "InvalidRequestException",
            "ResourceNotFoundException",
            "ServiceUnavailableException",
            "ThrottlingException",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information used to update the detector (instance).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorRequest {
    /// <p>The ID to assign to the detector update <code>"message"</code>. Each
    /// <code>"messageId"</code> must be unique within each batch sent.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The name of the detector model that created the detectors (instances).</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the input key attribute (identifying the device or system) that caused the
    /// creation of this detector (instance).</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The new state, variable values, and timer settings of the detector (instance).</p>
    pub state: std::option::Option<crate::model::DetectorStateDefinition>,
}
impl UpdateDetectorRequest {
    /// <p>The ID to assign to the detector update <code>"message"</code>. Each
    /// <code>"messageId"</code> must be unique within each batch sent.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The name of the detector model that created the detectors (instances).</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The value of the input key attribute (identifying the device or system) that caused the
    /// creation of this detector (instance).</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The new state, variable values, and timer settings of the detector (instance).</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DetectorStateDefinition> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for UpdateDetectorRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorRequest");
        formatter.field("message_id", &self.message_id);
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`UpdateDetectorRequest`](crate::model::UpdateDetectorRequest)
pub mod update_detector_request {
    /// A builder for [`UpdateDetectorRequest`](crate::model::UpdateDetectorRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DetectorStateDefinition>,
    }
    impl Builder {
        /// <p>The ID to assign to the detector update <code>"message"</code>. Each
        /// <code>"messageId"</code> must be unique within each batch sent.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID to assign to the detector update <code>"message"</code>. Each
        /// <code>"messageId"</code> must be unique within each batch sent.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The name of the detector model that created the detectors (instances).</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model that created the detectors (instances).</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The value of the input key attribute (identifying the device or system) that caused the
        /// creation of this detector (instance).</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the input key attribute (identifying the device or system) that caused the
        /// creation of this detector (instance).</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The new state, variable values, and timer settings of the detector (instance).</p>
        pub fn state(mut self, input: crate::model::DetectorStateDefinition) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The new state, variable values, and timer settings of the detector (instance).</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DetectorStateDefinition>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorRequest`](crate::model::UpdateDetectorRequest)
        pub fn build(self) -> crate::model::UpdateDetectorRequest {
            crate::model::UpdateDetectorRequest {
                message_id: self.message_id,
                detector_model_name: self.detector_model_name,
                key_value: self.key_value,
                state: self.state,
            }
        }
    }
}
impl UpdateDetectorRequest {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorRequest`](crate::model::UpdateDetectorRequest)
    pub fn builder() -> crate::model::update_detector_request::Builder {
        crate::model::update_detector_request::Builder::default()
    }
}

/// <p>The new state, variable values, and timer settings of the detector (instance).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorStateDefinition {
    /// <p>The name of the new state of the detector (instance).</p>
    pub state_name: std::option::Option<std::string::String>,
    /// <p>The new values of the detector's variables. Any variable whose value isn't specified is
    /// cleared.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::VariableDefinition>>,
    /// <p>The new values of the detector's timers. Any timer whose value isn't specified is cleared,
    /// and its timeout event won't occur.</p>
    pub timers: std::option::Option<std::vec::Vec<crate::model::TimerDefinition>>,
}
impl DetectorStateDefinition {
    /// <p>The name of the new state of the detector (instance).</p>
    pub fn state_name(&self) -> std::option::Option<&str> {
        self.state_name.as_deref()
    }
    /// <p>The new values of the detector's variables. Any variable whose value isn't specified is
    /// cleared.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::VariableDefinition]> {
        self.variables.as_deref()
    }
    /// <p>The new values of the detector's timers. Any timer whose value isn't specified is cleared,
    /// and its timeout event won't occur.</p>
    pub fn timers(&self) -> std::option::Option<&[crate::model::TimerDefinition]> {
        self.timers.as_deref()
    }
}
impl std::fmt::Debug for DetectorStateDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorStateDefinition");
        formatter.field("state_name", &self.state_name);
        formatter.field("variables", &self.variables);
        formatter.field("timers", &self.timers);
        formatter.finish()
    }
}
/// See [`DetectorStateDefinition`](crate::model::DetectorStateDefinition)
pub mod detector_state_definition {
    /// A builder for [`DetectorStateDefinition`](crate::model::DetectorStateDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_name: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::VariableDefinition>>,
        pub(crate) timers: std::option::Option<std::vec::Vec<crate::model::TimerDefinition>>,
    }
    impl Builder {
        /// <p>The name of the new state of the detector (instance).</p>
        pub fn state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_name = Some(input.into());
            self
        }
        /// <p>The name of the new state of the detector (instance).</p>
        pub fn set_state_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_name = input;
            self
        }
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The new values of the detector's variables. Any variable whose value isn't specified is
        /// cleared.</p>
        pub fn variables(mut self, input: impl Into<crate::model::VariableDefinition>) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input.into());
            self.variables = Some(v);
            self
        }
        /// <p>The new values of the detector's variables. Any variable whose value isn't specified is
        /// cleared.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VariableDefinition>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Appends an item to `timers`.
        ///
        /// To override the contents of this collection use [`set_timers`](Self::set_timers).
        ///
        /// <p>The new values of the detector's timers. Any timer whose value isn't specified is cleared,
        /// and its timeout event won't occur.</p>
        pub fn timers(mut self, input: impl Into<crate::model::TimerDefinition>) -> Self {
            let mut v = self.timers.unwrap_or_default();
            v.push(input.into());
            self.timers = Some(v);
            self
        }
        /// <p>The new values of the detector's timers. Any timer whose value isn't specified is cleared,
        /// and its timeout event won't occur.</p>
        pub fn set_timers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimerDefinition>>,
        ) -> Self {
            self.timers = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorStateDefinition`](crate::model::DetectorStateDefinition)
        pub fn build(self) -> crate::model::DetectorStateDefinition {
            crate::model::DetectorStateDefinition {
                state_name: self.state_name,
                variables: self.variables,
                timers: self.timers,
            }
        }
    }
}
impl DetectorStateDefinition {
    /// Creates a new builder-style object to manufacture [`DetectorStateDefinition`](crate::model::DetectorStateDefinition)
    pub fn builder() -> crate::model::detector_state_definition::Builder {
        crate::model::detector_state_definition::Builder::default()
    }
}

/// <p>The new setting of a timer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimerDefinition {
    /// <p>The name of the timer.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new setting of the timer (the number of seconds before the timer elapses).</p>
    pub seconds: std::option::Option<i32>,
}
impl TimerDefinition {
    /// <p>The name of the timer.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The new setting of the timer (the number of seconds before the timer elapses).</p>
    pub fn seconds(&self) -> std::option::Option<i32> {
        self.seconds
    }
}
impl std::fmt::Debug for TimerDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimerDefinition");
        formatter.field("name", &self.name);
        formatter.field("seconds", &self.seconds);
        formatter.finish()
    }
}
/// See [`TimerDefinition`](crate::model::TimerDefinition)
pub mod timer_definition {
    /// A builder for [`TimerDefinition`](crate::model::TimerDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the timer.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the timer.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new setting of the timer (the number of seconds before the timer elapses).</p>
        pub fn seconds(mut self, input: i32) -> Self {
            self.seconds = Some(input);
            self
        }
        /// <p>The new setting of the timer (the number of seconds before the timer elapses).</p>
        pub fn set_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`TimerDefinition`](crate::model::TimerDefinition)
        pub fn build(self) -> crate::model::TimerDefinition {
            crate::model::TimerDefinition {
                name: self.name,
                seconds: self.seconds,
            }
        }
    }
}
impl TimerDefinition {
    /// Creates a new builder-style object to manufacture [`TimerDefinition`](crate::model::TimerDefinition)
    pub fn builder() -> crate::model::timer_definition::Builder {
        crate::model::timer_definition::Builder::default()
    }
}

/// <p>The new value of the variable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableDefinition {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new value of the variable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl VariableDefinition {
    /// <p>The name of the variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The new value of the variable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for VariableDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableDefinition");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`VariableDefinition`](crate::model::VariableDefinition)
pub mod variable_definition {
    /// A builder for [`VariableDefinition`](crate::model::VariableDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new value of the variable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The new value of the variable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableDefinition`](crate::model::VariableDefinition)
        pub fn build(self) -> crate::model::VariableDefinition {
            crate::model::VariableDefinition {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl VariableDefinition {
    /// Creates a new builder-style object to manufacture [`VariableDefinition`](crate::model::VariableDefinition)
    pub fn builder() -> crate::model::variable_definition::Builder {
        crate::model::variable_definition::Builder::default()
    }
}

/// <p>Contains error messages associated with one of the following requests:</p>
/// <ul>
/// <li>
/// <p>
/// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchAcknowledgeAlarm.html">BatchAcknowledgeAlarm</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchDisableAlarm.html">BatchDisableAlarm</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchEnableAlarm.html">BatchEnableAlarm</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchResetAlarm.html">BatchResetAlarm</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchSnoozeAlarm.html">BatchSnoozeAlarm</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAlarmActionErrorEntry {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>A message that describes the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchAlarmActionErrorEntry {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A message that describes the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchAlarmActionErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAlarmActionErrorEntry");
        formatter.field("request_id", &self.request_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchAlarmActionErrorEntry`](crate::model::BatchAlarmActionErrorEntry)
pub mod batch_alarm_action_error_entry {
    /// A builder for [`BatchAlarmActionErrorEntry`](crate::model::BatchAlarmActionErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAlarmActionErrorEntry`](crate::model::BatchAlarmActionErrorEntry)
        pub fn build(self) -> crate::model::BatchAlarmActionErrorEntry {
            crate::model::BatchAlarmActionErrorEntry {
                request_id: self.request_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchAlarmActionErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchAlarmActionErrorEntry`](crate::model::BatchAlarmActionErrorEntry)
    pub fn builder() -> crate::model::batch_alarm_action_error_entry::Builder {
        crate::model::batch_alarm_action_error_entry::Builder::default()
    }
}

/// <p>Information needed to snooze the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnoozeAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The note that you can leave when you snooze the alarm.</p>
    pub note: std::option::Option<std::string::String>,
    /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
    pub snooze_duration: std::option::Option<i32>,
}
impl SnoozeAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The note that you can leave when you snooze the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
    /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
    pub fn snooze_duration(&self) -> std::option::Option<i32> {
        self.snooze_duration
    }
}
impl std::fmt::Debug for SnoozeAlarmActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnoozeAlarmActionRequest");
        formatter.field("request_id", &self.request_id);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("note", &self.note);
        formatter.field("snooze_duration", &self.snooze_duration);
        formatter.finish()
    }
}
/// See [`SnoozeAlarmActionRequest`](crate::model::SnoozeAlarmActionRequest)
pub mod snooze_alarm_action_request {
    /// A builder for [`SnoozeAlarmActionRequest`](crate::model::SnoozeAlarmActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) note: std::option::Option<std::string::String>,
        pub(crate) snooze_duration: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The note that you can leave when you snooze the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you snooze the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
        pub fn snooze_duration(mut self, input: i32) -> Self {
            self.snooze_duration = Some(input);
            self
        }
        /// <p>The snooze time in seconds. The alarm automatically changes to the <code>NORMAL</code> state after this duration.</p>
        pub fn set_snooze_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.snooze_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`SnoozeAlarmActionRequest`](crate::model::SnoozeAlarmActionRequest)
        pub fn build(self) -> crate::model::SnoozeAlarmActionRequest {
            crate::model::SnoozeAlarmActionRequest {
                request_id: self.request_id,
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
                note: self.note,
                snooze_duration: self.snooze_duration,
            }
        }
    }
}
impl SnoozeAlarmActionRequest {
    /// Creates a new builder-style object to manufacture [`SnoozeAlarmActionRequest`](crate::model::SnoozeAlarmActionRequest)
    pub fn builder() -> crate::model::snooze_alarm_action_request::Builder {
        crate::model::snooze_alarm_action_request::Builder::default()
    }
}

/// <p>Information needed to reset the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The note that you can leave when you reset the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl ResetAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The note that you can leave when you reset the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for ResetAlarmActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetAlarmActionRequest");
        formatter.field("request_id", &self.request_id);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`ResetAlarmActionRequest`](crate::model::ResetAlarmActionRequest)
pub mod reset_alarm_action_request {
    /// A builder for [`ResetAlarmActionRequest`](crate::model::ResetAlarmActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The note that you can leave when you reset the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you reset the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetAlarmActionRequest`](crate::model::ResetAlarmActionRequest)
        pub fn build(self) -> crate::model::ResetAlarmActionRequest {
            crate::model::ResetAlarmActionRequest {
                request_id: self.request_id,
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
                note: self.note,
            }
        }
    }
}
impl ResetAlarmActionRequest {
    /// Creates a new builder-style object to manufacture [`ResetAlarmActionRequest`](crate::model::ResetAlarmActionRequest)
    pub fn builder() -> crate::model::reset_alarm_action_request::Builder {
        crate::model::reset_alarm_action_request::Builder::default()
    }
}

/// <p>Contains information about the errors encountered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutMessageErrorEntry {
    /// <p>The ID of the message that caused the error. (See the value corresponding to the
    /// <code>"messageId"</code> key in the <code>"message"</code> object.)</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>A message that describes the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchPutMessageErrorEntry {
    /// <p>The ID of the message that caused the error. (See the value corresponding to the
    /// <code>"messageId"</code> key in the <code>"message"</code> object.)</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A message that describes the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchPutMessageErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutMessageErrorEntry");
        formatter.field("message_id", &self.message_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
pub mod batch_put_message_error_entry {
    /// A builder for [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the message that caused the error. (See the value corresponding to the
        /// <code>"messageId"</code> key in the <code>"message"</code> object.)</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message that caused the error. (See the value corresponding to the
        /// <code>"messageId"</code> key in the <code>"message"</code> object.)</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
        pub fn build(self) -> crate::model::BatchPutMessageErrorEntry {
            crate::model::BatchPutMessageErrorEntry {
                message_id: self.message_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchPutMessageErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
    pub fn builder() -> crate::model::batch_put_message_error_entry::Builder {
        crate::model::batch_put_message_error_entry::Builder::default()
    }
}

/// <p>Information about a message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The ID to assign to the message. Within each batch sent, each <code>"messageId"</code>
    /// must be unique.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The name of the input into which the message payload is transformed.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>The payload of the message. This can be a JSON string or a Base-64-encoded string
    /// representing binary data (in which case you must decode it).</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The timestamp associated with the message.</p>
    pub timestamp: std::option::Option<crate::model::TimestampValue>,
}
impl Message {
    /// <p>The ID to assign to the message. Within each batch sent, each <code>"messageId"</code>
    /// must be unique.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The name of the input into which the message payload is transformed.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>The payload of the message. This can be a JSON string or a Base-64-encoded string
    /// representing binary data (in which case you must decode it).</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
    /// <p>The timestamp associated with the message.</p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::TimestampValue> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("message_id", &self.message_id);
        formatter.field("input_name", &self.input_name);
        formatter.field("payload", &self.payload);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) timestamp: std::option::Option<crate::model::TimestampValue>,
    }
    impl Builder {
        /// <p>The ID to assign to the message. Within each batch sent, each <code>"messageId"</code>
        /// must be unique.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID to assign to the message. Within each batch sent, each <code>"messageId"</code>
        /// must be unique.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The name of the input into which the message payload is transformed.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input into which the message payload is transformed.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>The payload of the message. This can be a JSON string or a Base-64-encoded string
        /// representing binary data (in which case you must decode it).</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The payload of the message. This can be a JSON string or a Base-64-encoded string
        /// representing binary data (in which case you must decode it).</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// <p>The timestamp associated with the message.</p>
        pub fn timestamp(mut self, input: crate::model::TimestampValue) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp associated with the message.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::TimestampValue>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                message_id: self.message_id,
                input_name: self.input_name,
                payload: self.payload,
                timestamp: self.timestamp,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>Contains information about a timestamp.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampValue {
    /// <p>The value of the timestamp, in the Unix epoch format.</p>
    pub time_in_millis: std::option::Option<i64>,
}
impl TimestampValue {
    /// <p>The value of the timestamp, in the Unix epoch format.</p>
    pub fn time_in_millis(&self) -> std::option::Option<i64> {
        self.time_in_millis
    }
}
impl std::fmt::Debug for TimestampValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampValue");
        formatter.field("time_in_millis", &self.time_in_millis);
        formatter.finish()
    }
}
/// See [`TimestampValue`](crate::model::TimestampValue)
pub mod timestamp_value {
    /// A builder for [`TimestampValue`](crate::model::TimestampValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_in_millis: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The value of the timestamp, in the Unix epoch format.</p>
        pub fn time_in_millis(mut self, input: i64) -> Self {
            self.time_in_millis = Some(input);
            self
        }
        /// <p>The value of the timestamp, in the Unix epoch format.</p>
        pub fn set_time_in_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.time_in_millis = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampValue`](crate::model::TimestampValue)
        pub fn build(self) -> crate::model::TimestampValue {
            crate::model::TimestampValue {
                time_in_millis: self.time_in_millis,
            }
        }
    }
}
impl TimestampValue {
    /// Creates a new builder-style object to manufacture [`TimestampValue`](crate::model::TimestampValue)
    pub fn builder() -> crate::model::timestamp_value::Builder {
        crate::model::timestamp_value::Builder::default()
    }
}

/// <p>Information needed to enable the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The note that you can leave when you enable the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl EnableAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The note that you can leave when you enable the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for EnableAlarmActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableAlarmActionRequest");
        formatter.field("request_id", &self.request_id);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`EnableAlarmActionRequest`](crate::model::EnableAlarmActionRequest)
pub mod enable_alarm_action_request {
    /// A builder for [`EnableAlarmActionRequest`](crate::model::EnableAlarmActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The note that you can leave when you enable the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you enable the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableAlarmActionRequest`](crate::model::EnableAlarmActionRequest)
        pub fn build(self) -> crate::model::EnableAlarmActionRequest {
            crate::model::EnableAlarmActionRequest {
                request_id: self.request_id,
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
                note: self.note,
            }
        }
    }
}
impl EnableAlarmActionRequest {
    /// Creates a new builder-style object to manufacture [`EnableAlarmActionRequest`](crate::model::EnableAlarmActionRequest)
    pub fn builder() -> crate::model::enable_alarm_action_request::Builder {
        crate::model::enable_alarm_action_request::Builder::default()
    }
}

/// <p>Information used to disable the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The note that you can leave when you disable the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl DisableAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The note that you can leave when you disable the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for DisableAlarmActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableAlarmActionRequest");
        formatter.field("request_id", &self.request_id);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`DisableAlarmActionRequest`](crate::model::DisableAlarmActionRequest)
pub mod disable_alarm_action_request {
    /// A builder for [`DisableAlarmActionRequest`](crate::model::DisableAlarmActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The note that you can leave when you disable the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you disable the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableAlarmActionRequest`](crate::model::DisableAlarmActionRequest)
        pub fn build(self) -> crate::model::DisableAlarmActionRequest {
            crate::model::DisableAlarmActionRequest {
                request_id: self.request_id,
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
                note: self.note,
            }
        }
    }
}
impl DisableAlarmActionRequest {
    /// Creates a new builder-style object to manufacture [`DisableAlarmActionRequest`](crate::model::DisableAlarmActionRequest)
    pub fn builder() -> crate::model::disable_alarm_action_request::Builder {
        crate::model::disable_alarm_action_request::Builder::default()
    }
}

/// <p>Information needed to acknowledge the alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The note that you can leave when you acknowledge the alarm.</p>
    pub note: std::option::Option<std::string::String>,
}
impl AcknowledgeAlarmActionRequest {
    /// <p>The request ID. Each ID must be unique within each batch.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The note that you can leave when you acknowledge the alarm.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
}
impl std::fmt::Debug for AcknowledgeAlarmActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeAlarmActionRequest");
        formatter.field("request_id", &self.request_id);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.field("note", &self.note);
        formatter.finish()
    }
}
/// See [`AcknowledgeAlarmActionRequest`](crate::model::AcknowledgeAlarmActionRequest)
pub mod acknowledge_alarm_action_request {
    /// A builder for [`AcknowledgeAlarmActionRequest`](crate::model::AcknowledgeAlarmActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) note: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID. Each ID must be unique within each batch.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The note that you can leave when you acknowledge the alarm.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>The note that you can leave when you acknowledge the alarm.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeAlarmActionRequest`](crate::model::AcknowledgeAlarmActionRequest)
        pub fn build(self) -> crate::model::AcknowledgeAlarmActionRequest {
            crate::model::AcknowledgeAlarmActionRequest {
                request_id: self.request_id,
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
                note: self.note,
            }
        }
    }
}
impl AcknowledgeAlarmActionRequest {
    /// Creates a new builder-style object to manufacture [`AcknowledgeAlarmActionRequest`](crate::model::AcknowledgeAlarmActionRequest)
    pub fn builder() -> crate::model::acknowledge_alarm_action_request::Builder {
        crate::model::acknowledge_alarm_action_request::Builder::default()
    }
}
