// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchAcknowledgeAlarmInput`](crate::input::BatchAcknowledgeAlarmInput)
pub mod batch_acknowledge_alarm_input {
    /// A builder for [`BatchAcknowledgeAlarmInput`](crate::input::BatchAcknowledgeAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acknowledge_action_requests:
            std::option::Option<std::vec::Vec<crate::model::AcknowledgeAlarmActionRequest>>,
    }
    impl Builder {
        /// Appends an item to `acknowledge_action_requests`.
        ///
        /// To override the contents of this collection use [`set_acknowledge_action_requests`](Self::set_acknowledge_action_requests).
        ///
        /// <p>The list of acknowledge action requests. You can specify up to 10 requests per operation.</p>
        pub fn acknowledge_action_requests(
            mut self,
            input: impl Into<crate::model::AcknowledgeAlarmActionRequest>,
        ) -> Self {
            let mut v = self.acknowledge_action_requests.unwrap_or_default();
            v.push(input.into());
            self.acknowledge_action_requests = Some(v);
            self
        }
        /// <p>The list of acknowledge action requests. You can specify up to 10 requests per operation.</p>
        pub fn set_acknowledge_action_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AcknowledgeAlarmActionRequest>>,
        ) -> Self {
            self.acknowledge_action_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAcknowledgeAlarmInput`](crate::input::BatchAcknowledgeAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAcknowledgeAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchAcknowledgeAlarmInput {
                acknowledge_action_requests: self.acknowledge_action_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchAcknowledgeAlarmInputOperationOutputAlias = crate::operation::BatchAcknowledgeAlarm;
#[doc(hidden)]
pub type BatchAcknowledgeAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchAcknowledgeAlarmInput {
    /// Consumes the builder and constructs an Operation<[`BatchAcknowledgeAlarm`](crate::operation::BatchAcknowledgeAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAcknowledgeAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAcknowledgeAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarms/acknowledge").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAcknowledgeAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAcknowledgeAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_acknowledge_alarm(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAcknowledgeAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAcknowledgeAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAcknowledgeAlarmInput`](crate::input::BatchAcknowledgeAlarmInput)
    pub fn builder() -> crate::input::batch_acknowledge_alarm_input::Builder {
        crate::input::batch_acknowledge_alarm_input::Builder::default()
    }
}

/// See [`BatchDisableAlarmInput`](crate::input::BatchDisableAlarmInput)
pub mod batch_disable_alarm_input {
    /// A builder for [`BatchDisableAlarmInput`](crate::input::BatchDisableAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_action_requests:
            std::option::Option<std::vec::Vec<crate::model::DisableAlarmActionRequest>>,
    }
    impl Builder {
        /// Appends an item to `disable_action_requests`.
        ///
        /// To override the contents of this collection use [`set_disable_action_requests`](Self::set_disable_action_requests).
        ///
        /// <p>The list of disable action requests. You can specify up to 10 requests per operation.</p>
        pub fn disable_action_requests(
            mut self,
            input: impl Into<crate::model::DisableAlarmActionRequest>,
        ) -> Self {
            let mut v = self.disable_action_requests.unwrap_or_default();
            v.push(input.into());
            self.disable_action_requests = Some(v);
            self
        }
        /// <p>The list of disable action requests. You can specify up to 10 requests per operation.</p>
        pub fn set_disable_action_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DisableAlarmActionRequest>>,
        ) -> Self {
            self.disable_action_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisableAlarmInput`](crate::input::BatchDisableAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisableAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDisableAlarmInput {
                disable_action_requests: self.disable_action_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDisableAlarmInputOperationOutputAlias = crate::operation::BatchDisableAlarm;
#[doc(hidden)]
pub type BatchDisableAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDisableAlarmInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisableAlarm`](crate::operation::BatchDisableAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisableAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisableAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarms/disable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisableAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisableAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disable_alarm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisableAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisableAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisableAlarmInput`](crate::input::BatchDisableAlarmInput)
    pub fn builder() -> crate::input::batch_disable_alarm_input::Builder {
        crate::input::batch_disable_alarm_input::Builder::default()
    }
}

/// See [`BatchEnableAlarmInput`](crate::input::BatchEnableAlarmInput)
pub mod batch_enable_alarm_input {
    /// A builder for [`BatchEnableAlarmInput`](crate::input::BatchEnableAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_action_requests:
            std::option::Option<std::vec::Vec<crate::model::EnableAlarmActionRequest>>,
    }
    impl Builder {
        /// Appends an item to `enable_action_requests`.
        ///
        /// To override the contents of this collection use [`set_enable_action_requests`](Self::set_enable_action_requests).
        ///
        /// <p>The list of enable action requests. You can specify up to 10 requests per operation.</p>
        pub fn enable_action_requests(
            mut self,
            input: impl Into<crate::model::EnableAlarmActionRequest>,
        ) -> Self {
            let mut v = self.enable_action_requests.unwrap_or_default();
            v.push(input.into());
            self.enable_action_requests = Some(v);
            self
        }
        /// <p>The list of enable action requests. You can specify up to 10 requests per operation.</p>
        pub fn set_enable_action_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnableAlarmActionRequest>>,
        ) -> Self {
            self.enable_action_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEnableAlarmInput`](crate::input::BatchEnableAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchEnableAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchEnableAlarmInput {
                enable_action_requests: self.enable_action_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchEnableAlarmInputOperationOutputAlias = crate::operation::BatchEnableAlarm;
#[doc(hidden)]
pub type BatchEnableAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchEnableAlarmInput {
    /// Consumes the builder and constructs an Operation<[`BatchEnableAlarm`](crate::operation::BatchEnableAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchEnableAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchEnableAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarms/enable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchEnableAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchEnableAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_enable_alarm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchEnableAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchEnableAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchEnableAlarmInput`](crate::input::BatchEnableAlarmInput)
    pub fn builder() -> crate::input::batch_enable_alarm_input::Builder {
        crate::input::batch_enable_alarm_input::Builder::default()
    }
}

/// See [`BatchPutMessageInput`](crate::input::BatchPutMessageInput)
pub mod batch_put_message_input {
    /// A builder for [`BatchPutMessageInput`](crate::input::BatchPutMessageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>The list of messages to send. Each message has the following format: <code>'{ "messageId":
        /// "string", "inputName": "string", "payload": "string"}'</code>
        /// </p>
        pub fn messages(mut self, input: impl Into<crate::model::Message>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>The list of messages to send. Each message has the following format: <code>'{ "messageId":
        /// "string", "inputName": "string", "payload": "string"}'</code>
        /// </p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutMessageInput`](crate::input::BatchPutMessageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutMessageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutMessageInput {
                messages: self.messages,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutMessageInputOperationOutputAlias = crate::operation::BatchPutMessage;
#[doc(hidden)]
pub type BatchPutMessageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchPutMessageInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutMessage`](crate::operation::BatchPutMessage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutMessage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchPutMessageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/inputs/messages").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchPutMessageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchPutMessageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_put_message(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutMessage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutMessage",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchPutMessageInput`](crate::input::BatchPutMessageInput)
    pub fn builder() -> crate::input::batch_put_message_input::Builder {
        crate::input::batch_put_message_input::Builder::default()
    }
}

/// See [`BatchResetAlarmInput`](crate::input::BatchResetAlarmInput)
pub mod batch_reset_alarm_input {
    /// A builder for [`BatchResetAlarmInput`](crate::input::BatchResetAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reset_action_requests:
            std::option::Option<std::vec::Vec<crate::model::ResetAlarmActionRequest>>,
    }
    impl Builder {
        /// Appends an item to `reset_action_requests`.
        ///
        /// To override the contents of this collection use [`set_reset_action_requests`](Self::set_reset_action_requests).
        ///
        /// <p>The list of reset action requests. You can specify up to 10 requests per operation.</p>
        pub fn reset_action_requests(
            mut self,
            input: impl Into<crate::model::ResetAlarmActionRequest>,
        ) -> Self {
            let mut v = self.reset_action_requests.unwrap_or_default();
            v.push(input.into());
            self.reset_action_requests = Some(v);
            self
        }
        /// <p>The list of reset action requests. You can specify up to 10 requests per operation.</p>
        pub fn set_reset_action_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResetAlarmActionRequest>>,
        ) -> Self {
            self.reset_action_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchResetAlarmInput`](crate::input::BatchResetAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchResetAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchResetAlarmInput {
                reset_action_requests: self.reset_action_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchResetAlarmInputOperationOutputAlias = crate::operation::BatchResetAlarm;
#[doc(hidden)]
pub type BatchResetAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchResetAlarmInput {
    /// Consumes the builder and constructs an Operation<[`BatchResetAlarm`](crate::operation::BatchResetAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchResetAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchResetAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarms/reset").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchResetAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchResetAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_reset_alarm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchResetAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchResetAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchResetAlarmInput`](crate::input::BatchResetAlarmInput)
    pub fn builder() -> crate::input::batch_reset_alarm_input::Builder {
        crate::input::batch_reset_alarm_input::Builder::default()
    }
}

/// See [`BatchSnoozeAlarmInput`](crate::input::BatchSnoozeAlarmInput)
pub mod batch_snooze_alarm_input {
    /// A builder for [`BatchSnoozeAlarmInput`](crate::input::BatchSnoozeAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snooze_action_requests:
            std::option::Option<std::vec::Vec<crate::model::SnoozeAlarmActionRequest>>,
    }
    impl Builder {
        /// Appends an item to `snooze_action_requests`.
        ///
        /// To override the contents of this collection use [`set_snooze_action_requests`](Self::set_snooze_action_requests).
        ///
        /// <p>The list of snooze action requests. You can specify up to 10 requests per operation.</p>
        pub fn snooze_action_requests(
            mut self,
            input: impl Into<crate::model::SnoozeAlarmActionRequest>,
        ) -> Self {
            let mut v = self.snooze_action_requests.unwrap_or_default();
            v.push(input.into());
            self.snooze_action_requests = Some(v);
            self
        }
        /// <p>The list of snooze action requests. You can specify up to 10 requests per operation.</p>
        pub fn set_snooze_action_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnoozeAlarmActionRequest>>,
        ) -> Self {
            self.snooze_action_requests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchSnoozeAlarmInput`](crate::input::BatchSnoozeAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchSnoozeAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchSnoozeAlarmInput {
                snooze_action_requests: self.snooze_action_requests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchSnoozeAlarmInputOperationOutputAlias = crate::operation::BatchSnoozeAlarm;
#[doc(hidden)]
pub type BatchSnoozeAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchSnoozeAlarmInput {
    /// Consumes the builder and constructs an Operation<[`BatchSnoozeAlarm`](crate::operation::BatchSnoozeAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchSnoozeAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchSnoozeAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarms/snooze").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchSnoozeAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchSnoozeAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_snooze_alarm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchSnoozeAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchSnoozeAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchSnoozeAlarmInput`](crate::input::BatchSnoozeAlarmInput)
    pub fn builder() -> crate::input::batch_snooze_alarm_input::Builder {
        crate::input::batch_snooze_alarm_input::Builder::default()
    }
}

/// See [`BatchUpdateDetectorInput`](crate::input::BatchUpdateDetectorInput)
pub mod batch_update_detector_input {
    /// A builder for [`BatchUpdateDetectorInput`](crate::input::BatchUpdateDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detectors:
            std::option::Option<std::vec::Vec<crate::model::UpdateDetectorRequest>>,
    }
    impl Builder {
        /// Appends an item to `detectors`.
        ///
        /// To override the contents of this collection use [`set_detectors`](Self::set_detectors).
        ///
        /// <p>The list of detectors (instances) to update, along with the values to update.</p>
        pub fn detectors(mut self, input: impl Into<crate::model::UpdateDetectorRequest>) -> Self {
            let mut v = self.detectors.unwrap_or_default();
            v.push(input.into());
            self.detectors = Some(v);
            self
        }
        /// <p>The list of detectors (instances) to update, along with the values to update.</p>
        pub fn set_detectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateDetectorRequest>>,
        ) -> Self {
            self.detectors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateDetectorInput`](crate::input::BatchUpdateDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateDetectorInput {
                detectors: self.detectors,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateDetectorInputOperationOutputAlias = crate::operation::BatchUpdateDetector;
#[doc(hidden)]
pub type BatchUpdateDetectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchUpdateDetectorInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateDetector`](crate::operation::BatchUpdateDetector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateDetector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/detectors").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_detector(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateDetector",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateDetectorInput`](crate::input::BatchUpdateDetectorInput)
    pub fn builder() -> crate::input::batch_update_detector_input::Builder {
        crate::input::batch_update_detector_input::Builder::default()
    }
}

/// See [`DescribeAlarmInput`](crate::input::DescribeAlarmInput)
pub mod describe_alarm_input {
    /// A builder for [`DescribeAlarmInput`](crate::input::DescribeAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the key used as a filter to select only the alarms associated with the
        /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlarmInput`](crate::input::DescribeAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAlarmInput {
                alarm_model_name: self.alarm_model_name,
                key_value: self.key_value,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAlarmInputOperationOutputAlias = crate::operation::DescribeAlarm;
#[doc(hidden)]
pub type DescribeAlarmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAlarmInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlarm`](crate::operation::DescribeAlarm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlarm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAlarmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.alarm_model_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_1, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarms/{alarmModelName}/keyValues",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeAlarmInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.key_value {
                query.push_kv("keyValue", &aws_smithy_http::query::fmt_string(&inner_2));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAlarmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAlarmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlarm",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAlarmInput`](crate::input::DescribeAlarmInput)
    pub fn builder() -> crate::input::describe_alarm_input::Builder {
        crate::input::describe_alarm_input::Builder::default()
    }
}

/// See [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
pub mod describe_detector_input {
    /// A builder for [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the detector model whose detectors (instances) you want information
        /// about.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model whose detectors (instances) you want information
        /// about.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>A filter used to limit results to detectors (instances) created because of the given key
        /// ID.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>A filter used to limit results to detectors (instances) created because of the given key
        /// ID.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDetectorInput {
                detector_model_name: self.detector_model_name,
                key_value: self.key_value,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDetectorInputOperationOutputAlias = crate::operation::DescribeDetector;
#[doc(hidden)]
pub type DescribeDetectorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDetector`](crate::operation::DescribeDetector)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDetector,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.detector_model_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_3, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detectors/{detectorModelName}/keyValues",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeDetectorInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.key_value {
                query.push_kv("keyValue", &aws_smithy_http::query::fmt_string(&inner_4));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDetector",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDetectorInput`](crate::input::DescribeDetectorInput)
    pub fn builder() -> crate::input::describe_detector_input::Builder {
        crate::input::describe_detector_input::Builder::default()
    }
}

/// See [`ListAlarmsInput`](crate::input::ListAlarmsInput)
pub mod list_alarms_input {
    /// A builder for [`ListAlarmsInput`](crate::input::ListAlarmsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmsInput`](crate::input::ListAlarmsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAlarmsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAlarmsInput {
                alarm_model_name: self.alarm_model_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAlarmsInputOperationOutputAlias = crate::operation::ListAlarms;
#[doc(hidden)]
pub type ListAlarmsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAlarmsInput {
    /// Consumes the builder and constructs an Operation<[`ListAlarms`](crate::operation::ListAlarms)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAlarms,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAlarmsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.alarm_model_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_5, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarms/{alarmModelName}",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAlarmsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if let Some(inner_7) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_7).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAlarmsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAlarmsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAlarms::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAlarms",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAlarmsInput`](crate::input::ListAlarmsInput)
    pub fn builder() -> crate::input::list_alarms_input::Builder {
        crate::input::list_alarms_input::Builder::default()
    }
}

/// See [`ListDetectorsInput`](crate::input::ListDetectorsInput)
pub mod list_detectors_input {
    /// A builder for [`ListDetectorsInput`](crate::input::ListDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) state_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the detector model whose detectors (instances) are listed.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model whose detectors (instances) are listed.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>A filter that limits results to those detectors (instances) in the given state.</p>
        pub fn state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_name = Some(input.into());
            self
        }
        /// <p>A filter that limits results to those detectors (instances) in the given state.</p>
        pub fn set_state_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_name = input;
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorsInput`](crate::input::ListDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDetectorsInput {
                detector_model_name: self.detector_model_name,
                state_name: self.state_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDetectorsInputOperationOutputAlias = crate::operation::ListDetectors;
#[doc(hidden)]
pub type ListDetectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`ListDetectors`](crate::operation::ListDetectors)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDetectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDetectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.detector_model_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_8, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detectors/{detectorModelName}",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDetectorsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.state_name {
                query.push_kv("stateName", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if let Some(inner_10) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            if let Some(inner_11) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_11).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDetectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDetectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDetectors",
            "ioteventsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDetectorsInput`](crate::input::ListDetectorsInput)
    pub fn builder() -> crate::input::list_detectors_input::Builder {
        crate::input::list_detectors_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorsInput {
    /// <p>The name of the detector model whose detectors (instances) are listed.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>A filter that limits results to those detectors (instances) in the given state.</p>
    pub state_name: std::option::Option<std::string::String>,
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDetectorsInput {
    /// <p>The name of the detector model whose detectors (instances) are listed.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>A filter that limits results to those detectors (instances) in the given state.</p>
    pub fn state_name(&self) -> std::option::Option<&str> {
        self.state_name.as_deref()
    }
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorsInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("state_name", &self.state_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmsInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAlarmsInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAlarmsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmsInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorInput {
    /// <p>The name of the detector model whose detectors (instances) you want information
    /// about.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>A filter used to limit results to detectors (instances) created because of the given key
    /// ID.</p>
    pub key_value: std::option::Option<std::string::String>,
}
impl DescribeDetectorInput {
    /// <p>The name of the detector model whose detectors (instances) you want information
    /// about.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>A filter used to limit results to detectors (instances) created because of the given key
    /// ID.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
}
impl std::fmt::Debug for DescribeDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlarmInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub key_value: std::option::Option<std::string::String>,
}
impl DescribeAlarmInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The value of the key used as a filter to select only the alarms associated with the
    /// <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
}
impl std::fmt::Debug for DescribeAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlarmInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateDetectorInput {
    /// <p>The list of detectors (instances) to update, along with the values to update.</p>
    pub detectors: std::option::Option<std::vec::Vec<crate::model::UpdateDetectorRequest>>,
}
impl BatchUpdateDetectorInput {
    /// <p>The list of detectors (instances) to update, along with the values to update.</p>
    pub fn detectors(&self) -> std::option::Option<&[crate::model::UpdateDetectorRequest]> {
        self.detectors.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateDetectorInput");
        formatter.field("detectors", &self.detectors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchSnoozeAlarmInput {
    /// <p>The list of snooze action requests. You can specify up to 10 requests per operation.</p>
    pub snooze_action_requests:
        std::option::Option<std::vec::Vec<crate::model::SnoozeAlarmActionRequest>>,
}
impl BatchSnoozeAlarmInput {
    /// <p>The list of snooze action requests. You can specify up to 10 requests per operation.</p>
    pub fn snooze_action_requests(
        &self,
    ) -> std::option::Option<&[crate::model::SnoozeAlarmActionRequest]> {
        self.snooze_action_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchSnoozeAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchSnoozeAlarmInput");
        formatter.field("snooze_action_requests", &self.snooze_action_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchResetAlarmInput {
    /// <p>The list of reset action requests. You can specify up to 10 requests per operation.</p>
    pub reset_action_requests:
        std::option::Option<std::vec::Vec<crate::model::ResetAlarmActionRequest>>,
}
impl BatchResetAlarmInput {
    /// <p>The list of reset action requests. You can specify up to 10 requests per operation.</p>
    pub fn reset_action_requests(
        &self,
    ) -> std::option::Option<&[crate::model::ResetAlarmActionRequest]> {
        self.reset_action_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchResetAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchResetAlarmInput");
        formatter.field("reset_action_requests", &self.reset_action_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutMessageInput {
    /// <p>The list of messages to send. Each message has the following format: <code>'{ "messageId":
    /// "string", "inputName": "string", "payload": "string"}'</code>
    /// </p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
}
impl BatchPutMessageInput {
    /// <p>The list of messages to send. Each message has the following format: <code>'{ "messageId":
    /// "string", "inputName": "string", "payload": "string"}'</code>
    /// </p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for BatchPutMessageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutMessageInput");
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEnableAlarmInput {
    /// <p>The list of enable action requests. You can specify up to 10 requests per operation.</p>
    pub enable_action_requests:
        std::option::Option<std::vec::Vec<crate::model::EnableAlarmActionRequest>>,
}
impl BatchEnableAlarmInput {
    /// <p>The list of enable action requests. You can specify up to 10 requests per operation.</p>
    pub fn enable_action_requests(
        &self,
    ) -> std::option::Option<&[crate::model::EnableAlarmActionRequest]> {
        self.enable_action_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchEnableAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEnableAlarmInput");
        formatter.field("enable_action_requests", &self.enable_action_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisableAlarmInput {
    /// <p>The list of disable action requests. You can specify up to 10 requests per operation.</p>
    pub disable_action_requests:
        std::option::Option<std::vec::Vec<crate::model::DisableAlarmActionRequest>>,
}
impl BatchDisableAlarmInput {
    /// <p>The list of disable action requests. You can specify up to 10 requests per operation.</p>
    pub fn disable_action_requests(
        &self,
    ) -> std::option::Option<&[crate::model::DisableAlarmActionRequest]> {
        self.disable_action_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchDisableAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisableAlarmInput");
        formatter.field("disable_action_requests", &self.disable_action_requests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAcknowledgeAlarmInput {
    /// <p>The list of acknowledge action requests. You can specify up to 10 requests per operation.</p>
    pub acknowledge_action_requests:
        std::option::Option<std::vec::Vec<crate::model::AcknowledgeAlarmActionRequest>>,
}
impl BatchAcknowledgeAlarmInput {
    /// <p>The list of acknowledge action requests. You can specify up to 10 requests per operation.</p>
    pub fn acknowledge_action_requests(
        &self,
    ) -> std::option::Option<&[crate::model::AcknowledgeAlarmActionRequest]> {
        self.acknowledge_action_requests.as_deref()
    }
}
impl std::fmt::Debug for BatchAcknowledgeAlarmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAcknowledgeAlarmInput");
        formatter.field(
            "acknowledge_action_requests",
            &self.acknowledge_action_requests,
        );
        formatter.finish()
    }
}
