// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about the configuration of an input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputConfiguration {
    /// <p>The name of the input.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>A brief description of the input.</p>
    pub input_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the input.</p>
    pub input_arn: std::option::Option<std::string::String>,
    /// <p>The time the input was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the input was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the input.</p>
    pub status: std::option::Option<crate::model::InputStatus>,
}
impl InputConfiguration {
    /// <p>The name of the input.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>A brief description of the input.</p>
    pub fn input_description(&self) -> std::option::Option<&str> {
        self.input_description.as_deref()
    }
    /// <p>The ARN of the input.</p>
    pub fn input_arn(&self) -> std::option::Option<&str> {
        self.input_arn.as_deref()
    }
    /// <p>The time the input was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the input was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The status of the input.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::InputStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for InputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputConfiguration");
        formatter.field("input_name", &self.input_name);
        formatter.field("input_description", &self.input_description);
        formatter.field("input_arn", &self.input_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`InputConfiguration`](crate::model::InputConfiguration)
pub mod input_configuration {
    /// A builder for [`InputConfiguration`](crate::model::InputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) input_description: std::option::Option<std::string::String>,
        pub(crate) input_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::InputStatus>,
    }
    impl Builder {
        /// <p>The name of the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_description = Some(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_description = input;
            self
        }
        /// <p>The ARN of the input.</p>
        pub fn input_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the input.</p>
        pub fn set_input_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_arn = input;
            self
        }
        /// <p>The time the input was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the input was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the input was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the input was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the input.</p>
        pub fn status(mut self, input: crate::model::InputStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the input.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::InputStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`InputConfiguration`](crate::model::InputConfiguration)
        pub fn build(self) -> crate::model::InputConfiguration {
            crate::model::InputConfiguration {
                input_name: self.input_name,
                input_description: self.input_description,
                input_arn: self.input_arn,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                status: self.status,
            }
        }
    }
}
impl InputConfiguration {
    /// Creates a new builder-style object to manufacture [`InputConfiguration`](crate::model::InputConfiguration)
    pub fn builder() -> crate::model::input_configuration::Builder {
        crate::model::input_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => InputStatus::Active,
            "CREATING" => InputStatus::Creating,
            "DELETING" => InputStatus::Deleting,
            "UPDATING" => InputStatus::Updating,
            other => InputStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputStatus::from(s))
    }
}
impl InputStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputStatus::Active => "ACTIVE",
            InputStatus::Creating => "CREATING",
            InputStatus::Deleting => "DELETING",
            InputStatus::Updating => "UPDATING",
            InputStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for InputStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The definition of the input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDefinition {
    /// <p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input. </p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl InputDefinition {
    /// <p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input. </p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for InputDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDefinition");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`InputDefinition`](crate::model::InputDefinition)
pub mod input_definition {
    /// A builder for [`InputDefinition`](crate::model::InputDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input. </p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input. </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDefinition`](crate::model::InputDefinition)
        pub fn build(self) -> crate::model::InputDefinition {
            crate::model::InputDefinition {
                attributes: self.attributes,
            }
        }
    }
}
impl InputDefinition {
    /// Creates a new builder-style object to manufacture [`InputDefinition`](crate::model::InputDefinition)
    pub fn builder() -> crate::model::input_definition::Builder {
        crate::model::input_definition::Builder::default()
    }
}

/// <p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>
    /// <p>Syntax: <code>
    /// <field-name>
    /// .
    /// <field-name>
    /// ...
    /// </field-name>
    /// </field-name></code> </p>
    pub json_path: std::option::Option<std::string::String>,
}
impl Attribute {
    /// <p>An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>
    /// <p>Syntax: <code>
    /// <field-name>
    /// .
    /// <field-name>
    /// ...
    /// </field-name>
    /// </field-name></code> </p>
    pub fn json_path(&self) -> std::option::Option<&str> {
        self.json_path.as_deref()
    }
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("json_path", &self.json_path);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>
        /// <p>Syntax: <code>
        /// <field-name>
        /// .
        /// <field-name>
        /// ...
        /// </field-name>
        /// </field-name></code> </p>
        pub fn json_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_path = Some(input.into());
            self
        }
        /// <p>An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>
        /// <p>Syntax: <code>
        /// <field-name>
        /// .
        /// <field-name>
        /// ...
        /// </field-name>
        /// </field-name></code> </p>
        pub fn set_json_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_path = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                json_path: self.json_path,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

/// <p>Information about how the detector model is configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorModelConfiguration {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The version of the detector model.</p>
    pub detector_model_version: std::option::Option<std::string::String>,
    /// <p>A brief description of the detector model.</p>
    pub detector_model_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector model.</p>
    pub detector_model_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The time the detector model was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the detector model was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the detector model.</p>
    pub status: std::option::Option<crate::model::DetectorModelVersionStatus>,
    /// <p>The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information. </p>
    /// <p>This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
    pub evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
}
impl DetectorModelConfiguration {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The version of the detector model.</p>
    pub fn detector_model_version(&self) -> std::option::Option<&str> {
        self.detector_model_version.as_deref()
    }
    /// <p>A brief description of the detector model.</p>
    pub fn detector_model_description(&self) -> std::option::Option<&str> {
        self.detector_model_description.as_deref()
    }
    /// <p>The ARN of the detector model.</p>
    pub fn detector_model_arn(&self) -> std::option::Option<&str> {
        self.detector_model_arn.as_deref()
    }
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The time the detector model was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time the detector model was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The status of the detector model.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetectorModelVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information. </p>
    /// <p>This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
    pub fn evaluation_method(&self) -> std::option::Option<&crate::model::EvaluationMethod> {
        self.evaluation_method.as_ref()
    }
}
impl std::fmt::Debug for DetectorModelConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorModelConfiguration");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("detector_model_version", &self.detector_model_version);
        formatter.field(
            "detector_model_description",
            &self.detector_model_description,
        );
        formatter.field("detector_model_arn", &self.detector_model_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.field("key", &self.key);
        formatter.field("evaluation_method", &self.evaluation_method);
        formatter.finish()
    }
}
/// See [`DetectorModelConfiguration`](crate::model::DetectorModelConfiguration)
pub mod detector_model_configuration {
    /// A builder for [`DetectorModelConfiguration`](crate::model::DetectorModelConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_version: std::option::Option<std::string::String>,
        pub(crate) detector_model_description: std::option::Option<std::string::String>,
        pub(crate) detector_model_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::DetectorModelVersionStatus>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_version = Some(input.into());
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_version = input;
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_description = Some(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_description = input;
            self
        }
        /// <p>The ARN of the detector model.</p>
        pub fn detector_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector model.</p>
        pub fn set_detector_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_arn = input;
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The time the detector model was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the detector model was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the detector model was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the detector model was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the detector model.</p>
        pub fn status(mut self, input: crate::model::DetectorModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the detector model.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information. </p>
        /// <p>This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information. </p>
        /// <p>This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.evaluation_method = Some(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.evaluation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorModelConfiguration`](crate::model::DetectorModelConfiguration)
        pub fn build(self) -> crate::model::DetectorModelConfiguration {
            crate::model::DetectorModelConfiguration {
                detector_model_name: self.detector_model_name,
                detector_model_version: self.detector_model_version,
                detector_model_description: self.detector_model_description,
                detector_model_arn: self.detector_model_arn,
                role_arn: self.role_arn,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                status: self.status,
                key: self.key,
                evaluation_method: self.evaluation_method,
            }
        }
    }
}
impl DetectorModelConfiguration {
    /// Creates a new builder-style object to manufacture [`DetectorModelConfiguration`](crate::model::DetectorModelConfiguration)
    pub fn builder() -> crate::model::detector_model_configuration::Builder {
        crate::model::detector_model_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EvaluationMethod {
    #[allow(missing_docs)] // documentation missing in model
    Batch,
    #[allow(missing_docs)] // documentation missing in model
    Serial,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EvaluationMethod {
    fn from(s: &str) -> Self {
        match s {
            "BATCH" => EvaluationMethod::Batch,
            "SERIAL" => EvaluationMethod::Serial,
            other => EvaluationMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EvaluationMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EvaluationMethod::from(s))
    }
}
impl EvaluationMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EvaluationMethod::Batch => "BATCH",
            EvaluationMethod::Serial => "SERIAL",
            EvaluationMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BATCH", "SERIAL"]
    }
}
impl AsRef<str> for EvaluationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetectorModelVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetectorModelVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => DetectorModelVersionStatus::Activating,
            "ACTIVE" => DetectorModelVersionStatus::Active,
            "DEPRECATED" => DetectorModelVersionStatus::Deprecated,
            "DRAFT" => DetectorModelVersionStatus::Draft,
            "FAILED" => DetectorModelVersionStatus::Failed,
            "INACTIVE" => DetectorModelVersionStatus::Inactive,
            "PAUSED" => DetectorModelVersionStatus::Paused,
            other => DetectorModelVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetectorModelVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetectorModelVersionStatus::from(s))
    }
}
impl DetectorModelVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetectorModelVersionStatus::Activating => "ACTIVATING",
            DetectorModelVersionStatus::Active => "ACTIVE",
            DetectorModelVersionStatus::Deprecated => "DEPRECATED",
            DetectorModelVersionStatus::Draft => "DRAFT",
            DetectorModelVersionStatus::Failed => "FAILED",
            DetectorModelVersionStatus::Inactive => "INACTIVE",
            DetectorModelVersionStatus::Paused => "PAUSED",
            DetectorModelVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "DEPRECATED",
            "DRAFT",
            "FAILED",
            "INACTIVE",
            "PAUSED",
        ]
    }
}
impl AsRef<str> for DetectorModelVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information that defines how a detector operates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorModelDefinition {
    /// <p>Information about the states of the detector.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::State>>,
    /// <p>The state that is entered at the creation of each detector (instance).</p>
    pub initial_state_name: std::option::Option<std::string::String>,
}
impl DetectorModelDefinition {
    /// <p>Information about the states of the detector.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::State]> {
        self.states.as_deref()
    }
    /// <p>The state that is entered at the creation of each detector (instance).</p>
    pub fn initial_state_name(&self) -> std::option::Option<&str> {
        self.initial_state_name.as_deref()
    }
}
impl std::fmt::Debug for DetectorModelDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorModelDefinition");
        formatter.field("states", &self.states);
        formatter.field("initial_state_name", &self.initial_state_name);
        formatter.finish()
    }
}
/// See [`DetectorModelDefinition`](crate::model::DetectorModelDefinition)
pub mod detector_model_definition {
    /// A builder for [`DetectorModelDefinition`](crate::model::DetectorModelDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::State>>,
        pub(crate) initial_state_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>Information about the states of the detector.</p>
        pub fn states(mut self, input: crate::model::State) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input);
            self.states = Some(v);
            self
        }
        /// <p>Information about the states of the detector.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::State>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>The state that is entered at the creation of each detector (instance).</p>
        pub fn initial_state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_state_name = Some(input.into());
            self
        }
        /// <p>The state that is entered at the creation of each detector (instance).</p>
        pub fn set_initial_state_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_state_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorModelDefinition`](crate::model::DetectorModelDefinition)
        pub fn build(self) -> crate::model::DetectorModelDefinition {
            crate::model::DetectorModelDefinition {
                states: self.states,
                initial_state_name: self.initial_state_name,
            }
        }
    }
}
impl DetectorModelDefinition {
    /// Creates a new builder-style object to manufacture [`DetectorModelDefinition`](crate::model::DetectorModelDefinition)
    pub fn builder() -> crate::model::detector_model_definition::Builder {
        crate::model::detector_model_definition::Builder::default()
    }
}

/// <p>Information that defines a state of a detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct State {
    /// <p>The name of the state.</p>
    pub state_name: std::option::Option<std::string::String>,
    /// <p>When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.</p>
    pub on_input: std::option::Option<crate::model::OnInputLifecycle>,
    /// <p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>
    pub on_enter: std::option::Option<crate::model::OnEnterLifecycle>,
    /// <p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>
    pub on_exit: std::option::Option<crate::model::OnExitLifecycle>,
}
impl State {
    /// <p>The name of the state.</p>
    pub fn state_name(&self) -> std::option::Option<&str> {
        self.state_name.as_deref()
    }
    /// <p>When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.</p>
    pub fn on_input(&self) -> std::option::Option<&crate::model::OnInputLifecycle> {
        self.on_input.as_ref()
    }
    /// <p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>
    pub fn on_enter(&self) -> std::option::Option<&crate::model::OnEnterLifecycle> {
        self.on_enter.as_ref()
    }
    /// <p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>
    pub fn on_exit(&self) -> std::option::Option<&crate::model::OnExitLifecycle> {
        self.on_exit.as_ref()
    }
}
impl std::fmt::Debug for State {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("State");
        formatter.field("state_name", &self.state_name);
        formatter.field("on_input", &self.on_input);
        formatter.field("on_enter", &self.on_enter);
        formatter.field("on_exit", &self.on_exit);
        formatter.finish()
    }
}
/// See [`State`](crate::model::State)
pub mod state {
    /// A builder for [`State`](crate::model::State)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_name: std::option::Option<std::string::String>,
        pub(crate) on_input: std::option::Option<crate::model::OnInputLifecycle>,
        pub(crate) on_enter: std::option::Option<crate::model::OnEnterLifecycle>,
        pub(crate) on_exit: std::option::Option<crate::model::OnExitLifecycle>,
    }
    impl Builder {
        /// <p>The name of the state.</p>
        pub fn state_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_name = Some(input.into());
            self
        }
        /// <p>The name of the state.</p>
        pub fn set_state_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_name = input;
            self
        }
        /// <p>When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.</p>
        pub fn on_input(mut self, input: crate::model::OnInputLifecycle) -> Self {
            self.on_input = Some(input);
            self
        }
        /// <p>When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.</p>
        pub fn set_on_input(
            mut self,
            input: std::option::Option<crate::model::OnInputLifecycle>,
        ) -> Self {
            self.on_input = input;
            self
        }
        /// <p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>
        pub fn on_enter(mut self, input: crate::model::OnEnterLifecycle) -> Self {
            self.on_enter = Some(input);
            self
        }
        /// <p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>
        pub fn set_on_enter(
            mut self,
            input: std::option::Option<crate::model::OnEnterLifecycle>,
        ) -> Self {
            self.on_enter = input;
            self
        }
        /// <p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>
        pub fn on_exit(mut self, input: crate::model::OnExitLifecycle) -> Self {
            self.on_exit = Some(input);
            self
        }
        /// <p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>
        pub fn set_on_exit(
            mut self,
            input: std::option::Option<crate::model::OnExitLifecycle>,
        ) -> Self {
            self.on_exit = input;
            self
        }
        /// Consumes the builder and constructs a [`State`](crate::model::State)
        pub fn build(self) -> crate::model::State {
            crate::model::State {
                state_name: self.state_name,
                on_input: self.on_input,
                on_enter: self.on_enter,
                on_exit: self.on_exit,
            }
        }
    }
}
impl State {
    /// Creates a new builder-style object to manufacture [`State`](crate::model::State)
    pub fn builder() -> crate::model::state::Builder {
        crate::model::state::Builder::default()
    }
}

/// <p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnExitLifecycle {
    /// <p>Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code>.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl OnExitLifecycle {
    /// <p>Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code>.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for OnExitLifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnExitLifecycle");
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`OnExitLifecycle`](crate::model::OnExitLifecycle)
pub mod on_exit_lifecycle {
    /// A builder for [`OnExitLifecycle`](crate::model::OnExitLifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code>.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code>.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`OnExitLifecycle`](crate::model::OnExitLifecycle)
        pub fn build(self) -> crate::model::OnExitLifecycle {
            crate::model::OnExitLifecycle {
                events: self.events,
            }
        }
    }
}
impl OnExitLifecycle {
    /// Creates a new builder-style object to manufacture [`OnExitLifecycle`](crate::model::OnExitLifecycle)
    pub fn builder() -> crate::model::on_exit_lifecycle::Builder {
        crate::model::on_exit_lifecycle::Builder::default()
    }
}

/// <p>Specifies the <code>actions</code> to be performed when the <code>condition</code> evaluates to TRUE.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The name of the event.</p>
    pub event_name: std::option::Option<std::string::String>,
    /// <p>Optional. The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).</p>
    pub condition: std::option::Option<std::string::String>,
    /// <p>The actions to be performed.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
}
impl Event {
    /// <p>The name of the event.</p>
    pub fn event_name(&self) -> std::option::Option<&str> {
        self.event_name.as_deref()
    }
    /// <p>Optional. The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).</p>
    pub fn condition(&self) -> std::option::Option<&str> {
        self.condition.as_deref()
    }
    /// <p>The actions to be performed.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("event_name", &self.event_name);
        formatter.field("condition", &self.condition);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_name: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    }
    impl Builder {
        /// <p>The name of the event.</p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_name = Some(input.into());
            self
        }
        /// <p>The name of the event.</p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_name = input;
            self
        }
        /// <p>Optional. The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).</p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p>Optional. The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).</p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions to be performed.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>The actions to be performed.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                event_name: self.event_name,
                condition: self.condition,
                actions: self.actions,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>An action to be performed when the <code>condition</code> is TRUE.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>Sets a variable to a specified value.</p>
    pub set_variable: std::option::Option<crate::model::SetVariableAction>,
    /// <p>Sends an Amazon SNS message.</p>
    pub sns: std::option::Option<crate::model::SnsTopicPublishAction>,
    /// <p>Publishes an MQTT message with the given topic to the AWS IoT message broker.</p>
    pub iot_topic_publish: std::option::Option<crate::model::IotTopicPublishAction>,
    /// <p>Information needed to set the timer.</p>
    pub set_timer: std::option::Option<crate::model::SetTimerAction>,
    /// <p>Information needed to clear the timer.</p>
    pub clear_timer: std::option::Option<crate::model::ClearTimerAction>,
    /// <p>Information needed to reset the timer.</p>
    pub reset_timer: std::option::Option<crate::model::ResetTimerAction>,
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub lambda: std::option::Option<crate::model::LambdaAction>,
    /// <p>Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.</p>
    pub iot_events: std::option::Option<crate::model::IotEventsAction>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
    pub sqs: std::option::Option<crate::model::SqsAction>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub firehose: std::option::Option<crate::model::FirehoseAction>,
    /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
    pub dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
    /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
    pub dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .</p>
    pub iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
}
impl Action {
    /// <p>Sets a variable to a specified value.</p>
    pub fn set_variable(&self) -> std::option::Option<&crate::model::SetVariableAction> {
        self.set_variable.as_ref()
    }
    /// <p>Sends an Amazon SNS message.</p>
    pub fn sns(&self) -> std::option::Option<&crate::model::SnsTopicPublishAction> {
        self.sns.as_ref()
    }
    /// <p>Publishes an MQTT message with the given topic to the AWS IoT message broker.</p>
    pub fn iot_topic_publish(&self) -> std::option::Option<&crate::model::IotTopicPublishAction> {
        self.iot_topic_publish.as_ref()
    }
    /// <p>Information needed to set the timer.</p>
    pub fn set_timer(&self) -> std::option::Option<&crate::model::SetTimerAction> {
        self.set_timer.as_ref()
    }
    /// <p>Information needed to clear the timer.</p>
    pub fn clear_timer(&self) -> std::option::Option<&crate::model::ClearTimerAction> {
        self.clear_timer.as_ref()
    }
    /// <p>Information needed to reset the timer.</p>
    pub fn reset_timer(&self) -> std::option::Option<&crate::model::ResetTimerAction> {
        self.reset_timer.as_ref()
    }
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaAction> {
        self.lambda.as_ref()
    }
    /// <p>Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.</p>
    pub fn iot_events(&self) -> std::option::Option<&crate::model::IotEventsAction> {
        self.iot_events.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
    pub fn sqs(&self) -> std::option::Option<&crate::model::SqsAction> {
        self.sqs.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub fn firehose(&self) -> std::option::Option<&crate::model::FirehoseAction> {
        self.firehose.as_ref()
    }
    /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
    pub fn dynamo_db(&self) -> std::option::Option<&crate::model::DynamoDbAction> {
        self.dynamo_db.as_ref()
    }
    /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
    pub fn dynamo_d_bv2(&self) -> std::option::Option<&crate::model::DynamoDBv2Action> {
        self.dynamo_d_bv2.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .</p>
    pub fn iot_site_wise(&self) -> std::option::Option<&crate::model::IotSiteWiseAction> {
        self.iot_site_wise.as_ref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("set_variable", &self.set_variable);
        formatter.field("sns", &self.sns);
        formatter.field("iot_topic_publish", &self.iot_topic_publish);
        formatter.field("set_timer", &self.set_timer);
        formatter.field("clear_timer", &self.clear_timer);
        formatter.field("reset_timer", &self.reset_timer);
        formatter.field("lambda", &self.lambda);
        formatter.field("iot_events", &self.iot_events);
        formatter.field("sqs", &self.sqs);
        formatter.field("firehose", &self.firehose);
        formatter.field("dynamo_db", &self.dynamo_db);
        formatter.field("dynamo_d_bv2", &self.dynamo_d_bv2);
        formatter.field("iot_site_wise", &self.iot_site_wise);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) set_variable: std::option::Option<crate::model::SetVariableAction>,
        pub(crate) sns: std::option::Option<crate::model::SnsTopicPublishAction>,
        pub(crate) iot_topic_publish: std::option::Option<crate::model::IotTopicPublishAction>,
        pub(crate) set_timer: std::option::Option<crate::model::SetTimerAction>,
        pub(crate) clear_timer: std::option::Option<crate::model::ClearTimerAction>,
        pub(crate) reset_timer: std::option::Option<crate::model::ResetTimerAction>,
        pub(crate) lambda: std::option::Option<crate::model::LambdaAction>,
        pub(crate) iot_events: std::option::Option<crate::model::IotEventsAction>,
        pub(crate) sqs: std::option::Option<crate::model::SqsAction>,
        pub(crate) firehose: std::option::Option<crate::model::FirehoseAction>,
        pub(crate) dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
        pub(crate) dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
        pub(crate) iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
    }
    impl Builder {
        /// <p>Sets a variable to a specified value.</p>
        pub fn set_variable(mut self, input: crate::model::SetVariableAction) -> Self {
            self.set_variable = Some(input);
            self
        }
        /// <p>Sets a variable to a specified value.</p>
        pub fn set_set_variable(
            mut self,
            input: std::option::Option<crate::model::SetVariableAction>,
        ) -> Self {
            self.set_variable = input;
            self
        }
        /// <p>Sends an Amazon SNS message.</p>
        pub fn sns(mut self, input: crate::model::SnsTopicPublishAction) -> Self {
            self.sns = Some(input);
            self
        }
        /// <p>Sends an Amazon SNS message.</p>
        pub fn set_sns(
            mut self,
            input: std::option::Option<crate::model::SnsTopicPublishAction>,
        ) -> Self {
            self.sns = input;
            self
        }
        /// <p>Publishes an MQTT message with the given topic to the AWS IoT message broker.</p>
        pub fn iot_topic_publish(mut self, input: crate::model::IotTopicPublishAction) -> Self {
            self.iot_topic_publish = Some(input);
            self
        }
        /// <p>Publishes an MQTT message with the given topic to the AWS IoT message broker.</p>
        pub fn set_iot_topic_publish(
            mut self,
            input: std::option::Option<crate::model::IotTopicPublishAction>,
        ) -> Self {
            self.iot_topic_publish = input;
            self
        }
        /// <p>Information needed to set the timer.</p>
        pub fn set_timer(mut self, input: crate::model::SetTimerAction) -> Self {
            self.set_timer = Some(input);
            self
        }
        /// <p>Information needed to set the timer.</p>
        pub fn set_set_timer(
            mut self,
            input: std::option::Option<crate::model::SetTimerAction>,
        ) -> Self {
            self.set_timer = input;
            self
        }
        /// <p>Information needed to clear the timer.</p>
        pub fn clear_timer(mut self, input: crate::model::ClearTimerAction) -> Self {
            self.clear_timer = Some(input);
            self
        }
        /// <p>Information needed to clear the timer.</p>
        pub fn set_clear_timer(
            mut self,
            input: std::option::Option<crate::model::ClearTimerAction>,
        ) -> Self {
            self.clear_timer = input;
            self
        }
        /// <p>Information needed to reset the timer.</p>
        pub fn reset_timer(mut self, input: crate::model::ResetTimerAction) -> Self {
            self.reset_timer = Some(input);
            self
        }
        /// <p>Information needed to reset the timer.</p>
        pub fn set_reset_timer(
            mut self,
            input: std::option::Option<crate::model::ResetTimerAction>,
        ) -> Self {
            self.reset_timer = input;
            self
        }
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn lambda(mut self, input: crate::model::LambdaAction) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaAction>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// <p>Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.</p>
        pub fn iot_events(mut self, input: crate::model::IotEventsAction) -> Self {
            self.iot_events = Some(input);
            self
        }
        /// <p>Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.</p>
        pub fn set_iot_events(
            mut self,
            input: std::option::Option<crate::model::IotEventsAction>,
        ) -> Self {
            self.iot_events = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
        pub fn sqs(mut self, input: crate::model::SqsAction) -> Self {
            self.sqs = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
        pub fn set_sqs(mut self, input: std::option::Option<crate::model::SqsAction>) -> Self {
            self.sqs = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn firehose(mut self, input: crate::model::FirehoseAction) -> Self {
            self.firehose = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn set_firehose(
            mut self,
            input: std::option::Option<crate::model::FirehoseAction>,
        ) -> Self {
            self.firehose = input;
            self
        }
        /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn dynamo_db(mut self, input: crate::model::DynamoDbAction) -> Self {
            self.dynamo_db = Some(input);
            self
        }
        /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn set_dynamo_db(
            mut self,
            input: std::option::Option<crate::model::DynamoDbAction>,
        ) -> Self {
            self.dynamo_db = input;
            self
        }
        /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn dynamo_d_bv2(mut self, input: crate::model::DynamoDBv2Action) -> Self {
            self.dynamo_d_bv2 = Some(input);
            self
        }
        /// <p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn set_dynamo_d_bv2(
            mut self,
            input: std::option::Option<crate::model::DynamoDBv2Action>,
        ) -> Self {
            self.dynamo_d_bv2 = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .</p>
        pub fn iot_site_wise(mut self, input: crate::model::IotSiteWiseAction) -> Self {
            self.iot_site_wise = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .</p>
        pub fn set_iot_site_wise(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseAction>,
        ) -> Self {
            self.iot_site_wise = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                set_variable: self.set_variable,
                sns: self.sns,
                iot_topic_publish: self.iot_topic_publish,
                set_timer: self.set_timer,
                clear_timer: self.clear_timer,
                reset_timer: self.reset_timer,
                lambda: self.lambda,
                iot_events: self.iot_events,
                sqs: self.sqs,
                firehose: self.firehose,
                dynamo_db: self.dynamo_db,
                dynamo_d_bv2: self.dynamo_d_bv2,
                iot_site_wise: self.iot_site_wise,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p>
/// <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li>
/// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code> </p> </li>
/// </ul>
/// <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseAction {
    /// <p>A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.</p>
    pub entry_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset that has the specified property.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset property.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The alias of the asset property.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. </p>
    pub property_value: std::option::Option<crate::model::AssetPropertyValue>,
}
impl IotSiteWiseAction {
    /// <p>A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.</p>
    pub fn entry_id(&self) -> std::option::Option<&str> {
        self.entry_id.as_deref()
    }
    /// <p>The ID of the asset that has the specified property.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset property.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The alias of the asset property.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. </p>
    pub fn property_value(&self) -> std::option::Option<&crate::model::AssetPropertyValue> {
        self.property_value.as_ref()
    }
}
impl std::fmt::Debug for IotSiteWiseAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseAction");
        formatter.field("entry_id", &self.entry_id);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("property_value", &self.property_value);
        formatter.finish()
    }
}
/// See [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
pub mod iot_site_wise_action {
    /// A builder for [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_id: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) property_value: std::option::Option<crate::model::AssetPropertyValue>,
    }
    impl Builder {
        /// <p>A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.</p>
        pub fn entry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.</p>
        pub fn set_entry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_id = input;
            self
        }
        /// <p>The ID of the asset that has the specified property.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset that has the specified property.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset property.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The alias of the asset property.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The alias of the asset property.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// <p>The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. </p>
        pub fn property_value(mut self, input: crate::model::AssetPropertyValue) -> Self {
            self.property_value = Some(input);
            self
        }
        /// <p>The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. </p>
        pub fn set_property_value(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyValue>,
        ) -> Self {
            self.property_value = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
        pub fn build(self) -> crate::model::IotSiteWiseAction {
            crate::model::IotSiteWiseAction {
                entry_id: self.entry_id,
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                property_value: self.property_value,
            }
        }
    }
}
impl IotSiteWiseAction {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
    pub fn builder() -> crate::model::iot_site_wise_action::Builder {
        crate::model::iot_site_wise_action::Builder::default()
    }
}

/// <p>A structure that contains value information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html">AssetPropertyValue</a> in the <i>AWS IoT SiteWise API Reference</i>.</p>
/// <p>You must use expressions for all parameters in <code>AssetPropertyValue</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>quality</code> parameter can be <code>'GOOD'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>quality</code> parameter can be <code>$input.TemperatureInput.sensorData.quality</code>.</p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyValue {
    /// <p>The value to send to an asset property.</p>
    pub value: std::option::Option<crate::model::AssetPropertyVariant>,
    /// <p>The timestamp associated with the asset property value. The default is the current event time.</p>
    pub timestamp: std::option::Option<crate::model::AssetPropertyTimestamp>,
    /// <p>The quality of the asset property value. The value must be <code>'GOOD'</code>, <code>'BAD'</code>, or <code>'UNCERTAIN'</code>.</p>
    pub quality: std::option::Option<std::string::String>,
}
impl AssetPropertyValue {
    /// <p>The value to send to an asset property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::AssetPropertyVariant> {
        self.value.as_ref()
    }
    /// <p>The timestamp associated with the asset property value. The default is the current event time.</p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::AssetPropertyTimestamp> {
        self.timestamp.as_ref()
    }
    /// <p>The quality of the asset property value. The value must be <code>'GOOD'</code>, <code>'BAD'</code>, or <code>'UNCERTAIN'</code>.</p>
    pub fn quality(&self) -> std::option::Option<&str> {
        self.quality.as_deref()
    }
}
impl std::fmt::Debug for AssetPropertyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyValue");
        formatter.field("value", &self.value);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("quality", &self.quality);
        formatter.finish()
    }
}
/// See [`AssetPropertyValue`](crate::model::AssetPropertyValue)
pub mod asset_property_value {
    /// A builder for [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::AssetPropertyVariant>,
        pub(crate) timestamp: std::option::Option<crate::model::AssetPropertyTimestamp>,
        pub(crate) quality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value to send to an asset property.</p>
        pub fn value(mut self, input: crate::model::AssetPropertyVariant) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value to send to an asset property.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyVariant>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>The timestamp associated with the asset property value. The default is the current event time.</p>
        pub fn timestamp(mut self, input: crate::model::AssetPropertyTimestamp) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp associated with the asset property value. The default is the current event time.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyTimestamp>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The quality of the asset property value. The value must be <code>'GOOD'</code>, <code>'BAD'</code>, or <code>'UNCERTAIN'</code>.</p>
        pub fn quality(mut self, input: impl Into<std::string::String>) -> Self {
            self.quality = Some(input.into());
            self
        }
        /// <p>The quality of the asset property value. The value must be <code>'GOOD'</code>, <code>'BAD'</code>, or <code>'UNCERTAIN'</code>.</p>
        pub fn set_quality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quality = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyValue`](crate::model::AssetPropertyValue)
        pub fn build(self) -> crate::model::AssetPropertyValue {
            crate::model::AssetPropertyValue {
                value: self.value,
                timestamp: self.timestamp,
                quality: self.quality,
            }
        }
    }
}
impl AssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    pub fn builder() -> crate::model::asset_property_value::Builder {
        crate::model::asset_property_value::Builder::default()
    }
}

/// <p>A structure that contains timestamp information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html">TimeInNanos</a> in the <i>AWS IoT SiteWise API Reference</i>.</p>
/// <p>You must use expressions for all parameters in <code>AssetPropertyTimestamp</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>timeInSeconds</code> parameter can be <code>'1586400675'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>offsetInNanos</code> parameter can be <code>$variable.time</code>.</p> </li>
/// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>timeInSeconds</code> parameter uses a substitution template.</p> <p> <code>'${$input.TemperatureInput.sensorData.timestamp / 1000}'</code> </p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyTimestamp {
    /// <p>The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.</p>
    pub time_in_seconds: std::option::Option<std::string::String>,
    /// <p>The nanosecond offset converted from <code>timeInSeconds</code>. The valid range is between 0-999999999.</p>
    pub offset_in_nanos: std::option::Option<std::string::String>,
}
impl AssetPropertyTimestamp {
    /// <p>The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.</p>
    pub fn time_in_seconds(&self) -> std::option::Option<&str> {
        self.time_in_seconds.as_deref()
    }
    /// <p>The nanosecond offset converted from <code>timeInSeconds</code>. The valid range is between 0-999999999.</p>
    pub fn offset_in_nanos(&self) -> std::option::Option<&str> {
        self.offset_in_nanos.as_deref()
    }
}
impl std::fmt::Debug for AssetPropertyTimestamp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyTimestamp");
        formatter.field("time_in_seconds", &self.time_in_seconds);
        formatter.field("offset_in_nanos", &self.offset_in_nanos);
        formatter.finish()
    }
}
/// See [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
pub mod asset_property_timestamp {
    /// A builder for [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_in_seconds: std::option::Option<std::string::String>,
        pub(crate) offset_in_nanos: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.</p>
        pub fn time_in_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_in_seconds = Some(input.into());
            self
        }
        /// <p>The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.</p>
        pub fn set_time_in_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_in_seconds = input;
            self
        }
        /// <p>The nanosecond offset converted from <code>timeInSeconds</code>. The valid range is between 0-999999999.</p>
        pub fn offset_in_nanos(mut self, input: impl Into<std::string::String>) -> Self {
            self.offset_in_nanos = Some(input.into());
            self
        }
        /// <p>The nanosecond offset converted from <code>timeInSeconds</code>. The valid range is between 0-999999999.</p>
        pub fn set_offset_in_nanos(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offset_in_nanos = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
        pub fn build(self) -> crate::model::AssetPropertyTimestamp {
            crate::model::AssetPropertyTimestamp {
                time_in_seconds: self.time_in_seconds,
                offset_in_nanos: self.offset_in_nanos,
            }
        }
    }
}
impl AssetPropertyTimestamp {
    /// Creates a new builder-style object to manufacture [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
    pub fn builder() -> crate::model::asset_property_timestamp::Builder {
        crate::model::asset_property_timestamp::Builder::default()
    }
}

/// <p>A structure that contains an asset property value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html">Variant</a> in the <i>AWS IoT SiteWise API Reference</i>.</p>
/// <p>You must use expressions for all parameters in <code>AssetPropertyVariant</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>integerValue</code> parameter can be <code>'100'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or parameters. For example, the value for the <code>booleanValue</code> parameter can be <code>$variable.offline</code>.</p> </li>
/// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. </p> <p>In the following example, the value for the <code>doubleValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'</code> </p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
/// <p>You must specify one of the following value types, depending on the <code>dataType</code> of the specified asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html">AssetProperty</a> in the <i>AWS IoT SiteWise API Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyVariant {
    /// <p>The asset property value is a string. You must use an expression, and the evaluated result should be a string.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.</p>
    pub integer_value: std::option::Option<std::string::String>,
    /// <p>The asset property value is a double. You must use an expression, and the evaluated result should be a double.</p>
    pub double_value: std::option::Option<std::string::String>,
    /// <p>The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You must use an expression, and the evaluated result should be a Boolean value.</p>
    pub boolean_value: std::option::Option<std::string::String>,
}
impl AssetPropertyVariant {
    /// <p>The asset property value is a string. You must use an expression, and the evaluated result should be a string.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.</p>
    pub fn integer_value(&self) -> std::option::Option<&str> {
        self.integer_value.as_deref()
    }
    /// <p>The asset property value is a double. You must use an expression, and the evaluated result should be a double.</p>
    pub fn double_value(&self) -> std::option::Option<&str> {
        self.double_value.as_deref()
    }
    /// <p>The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You must use an expression, and the evaluated result should be a Boolean value.</p>
    pub fn boolean_value(&self) -> std::option::Option<&str> {
        self.boolean_value.as_deref()
    }
}
impl std::fmt::Debug for AssetPropertyVariant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyVariant");
        formatter.field("string_value", &self.string_value);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("double_value", &self.double_value);
        formatter.field("boolean_value", &self.boolean_value);
        formatter.finish()
    }
}
/// See [`AssetPropertyVariant`](crate::model::AssetPropertyVariant)
pub mod asset_property_variant {
    /// A builder for [`AssetPropertyVariant`](crate::model::AssetPropertyVariant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) integer_value: std::option::Option<std::string::String>,
        pub(crate) double_value: std::option::Option<std::string::String>,
        pub(crate) boolean_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The asset property value is a string. You must use an expression, and the evaluated result should be a string.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>The asset property value is a string. You must use an expression, and the evaluated result should be a string.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.</p>
        pub fn integer_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.integer_value = Some(input.into());
            self
        }
        /// <p>The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.</p>
        pub fn set_integer_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integer_value = input;
            self
        }
        /// <p>The asset property value is a double. You must use an expression, and the evaluated result should be a double.</p>
        pub fn double_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.double_value = Some(input.into());
            self
        }
        /// <p>The asset property value is a double. You must use an expression, and the evaluated result should be a double.</p>
        pub fn set_double_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.double_value = input;
            self
        }
        /// <p>The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You must use an expression, and the evaluated result should be a Boolean value.</p>
        pub fn boolean_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.boolean_value = Some(input.into());
            self
        }
        /// <p>The asset property value is a Boolean value that must be <code>'TRUE'</code> or <code>'FALSE'</code>. You must use an expression, and the evaluated result should be a Boolean value.</p>
        pub fn set_boolean_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.boolean_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyVariant`](crate::model::AssetPropertyVariant)
        pub fn build(self) -> crate::model::AssetPropertyVariant {
            crate::model::AssetPropertyVariant {
                string_value: self.string_value,
                integer_value: self.integer_value,
                double_value: self.double_value,
                boolean_value: self.boolean_value,
            }
        }
    }
}
impl AssetPropertyVariant {
    /// Creates a new builder-style object to manufacture [`AssetPropertyVariant`](crate::model::AssetPropertyVariant)
    pub fn builder() -> crate::model::asset_property_variant::Builder {
        crate::model::asset_property_variant::Builder::default()
    }
}

/// <p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p>
/// <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li>
/// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code> </p> </li>
/// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
/// <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDBv2Action {
    /// <p>The name of the DynamoDB table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Information needed to configure the payload.</p>
    /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl DynamoDBv2Action {
    /// <p>The name of the DynamoDB table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Information needed to configure the payload.</p>
    /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for DynamoDBv2Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDBv2Action");
        formatter.field("table_name", &self.table_name);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
pub mod dynamo_d_bv2_action {
    /// A builder for [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Information needed to configure the payload.</p>
        /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>Information needed to configure the payload.</p>
        /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
        pub fn build(self) -> crate::model::DynamoDBv2Action {
            crate::model::DynamoDBv2Action {
                table_name: self.table_name,
                payload: self.payload,
            }
        }
    }
}
impl DynamoDBv2Action {
    /// Creates a new builder-style object to manufacture [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
    pub fn builder() -> crate::model::dynamo_d_bv2_action::Builder {
        crate::model::dynamo_d_bv2_action::Builder::default()
    }
}

/// <p>Information needed to configure the payload.</p>
/// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Payload {
    /// <p>The content of the payload. You can use a string expression that includes quoted strings (<code>'
    /// <string>
    /// '
    /// </string></code>), variables (<code>$variable.
    /// <variable-name></variable-name></code>), input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.</p>
    pub content_expression: std::option::Option<std::string::String>,
    /// <p>The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.</p>
    pub r#type: std::option::Option<crate::model::PayloadType>,
}
impl Payload {
    /// <p>The content of the payload. You can use a string expression that includes quoted strings (<code>'
    /// <string>
    /// '
    /// </string></code>), variables (<code>$variable.
    /// <variable-name></variable-name></code>), input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.</p>
    pub fn content_expression(&self) -> std::option::Option<&str> {
        self.content_expression.as_deref()
    }
    /// <p>The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PayloadType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Payload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Payload");
        formatter.field("content_expression", &self.content_expression);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Payload`](crate::model::Payload)
pub mod payload {
    /// A builder for [`Payload`](crate::model::Payload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_expression: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PayloadType>,
    }
    impl Builder {
        /// <p>The content of the payload. You can use a string expression that includes quoted strings (<code>'
        /// <string>
        /// '
        /// </string></code>), variables (<code>$variable.
        /// <variable-name></variable-name></code>), input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.</p>
        pub fn content_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_expression = Some(input.into());
            self
        }
        /// <p>The content of the payload. You can use a string expression that includes quoted strings (<code>'
        /// <string>
        /// '
        /// </string></code>), variables (<code>$variable.
        /// <variable-name></variable-name></code>), input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.</p>
        pub fn set_content_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_expression = input;
            self
        }
        /// <p>The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.</p>
        pub fn r#type(mut self, input: crate::model::PayloadType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PayloadType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Payload`](crate::model::Payload)
        pub fn build(self) -> crate::model::Payload {
            crate::model::Payload {
                content_expression: self.content_expression,
                r#type: self.r#type,
            }
        }
    }
}
impl Payload {
    /// Creates a new builder-style object to manufacture [`Payload`](crate::model::Payload)
    pub fn builder() -> crate::model::payload::Builder {
        crate::model::payload::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PayloadType {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PayloadType {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => PayloadType::Json,
            "STRING" => PayloadType::String,
            other => PayloadType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PayloadType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PayloadType::from(s))
    }
}
impl PayloadType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PayloadType::Json => "JSON",
            PayloadType::String => "STRING",
            PayloadType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "STRING"]
    }
}
impl AsRef<str> for PayloadType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p>
/// <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
/// <p class="title"> <b>Examples</b> </p>
/// <ul>
/// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code>.</p> </li>
/// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li>
/// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code> </p> </li>
/// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
/// <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>
/// <payload-field>
/// _raw
/// </payload-field></code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDbAction {
    /// <p>The data type for the hash key (also called the partition key). You can specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>'STRING'</code> - The hash key is a string.</p> </li>
    /// <li> <p> <code>'NUMBER'</code> - The hash key is a number.</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>hashKeyType</code>, the default value is <code>'STRING'</code>.</p>
    pub hash_key_type: std::option::Option<std::string::String>,
    /// <p>The name of the hash key (also called the partition key). The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.</p>
    pub hash_key_field: std::option::Option<std::string::String>,
    /// <p>The value of the hash key (also called the partition key).</p>
    pub hash_key_value: std::option::Option<std::string::String>,
    /// <p>The data type for the range key (also called the sort key), You can specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>'STRING'</code> - The range key is a string.</p> </li>
    /// <li> <p> <code>'NUMBER'</code> - The range key is number.</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>rangeKeyField</code>, the default value is <code>'STRING'</code>.</p>
    pub range_key_type: std::option::Option<std::string::String>,
    /// <p>The name of the range key (also called the sort key). The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table. </p>
    pub range_key_field: std::option::Option<std::string::String>,
    /// <p>The value of the range key (also called the sort key).</p>
    pub range_key_value: std::option::Option<std::string::String>,
    /// <p>The type of operation to perform. You can specify the following values: </p>
    /// <ul>
    /// <li> <p> <code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</p> </li>
    /// <li> <p> <code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
    /// <li> <p> <code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
    /// </ul>
    /// <p>If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The name of the DynamoDB column that receives the action payload.</p>
    /// <p>If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code>.</p>
    pub payload_field: std::option::Option<std::string::String>,
    /// <p>The name of the DynamoDB table. The <code>tableName</code> value must match the table name of the target DynamoDB table. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Information needed to configure the payload.</p>
    /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl DynamoDbAction {
    /// <p>The data type for the hash key (also called the partition key). You can specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>'STRING'</code> - The hash key is a string.</p> </li>
    /// <li> <p> <code>'NUMBER'</code> - The hash key is a number.</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>hashKeyType</code>, the default value is <code>'STRING'</code>.</p>
    pub fn hash_key_type(&self) -> std::option::Option<&str> {
        self.hash_key_type.as_deref()
    }
    /// <p>The name of the hash key (also called the partition key). The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.</p>
    pub fn hash_key_field(&self) -> std::option::Option<&str> {
        self.hash_key_field.as_deref()
    }
    /// <p>The value of the hash key (also called the partition key).</p>
    pub fn hash_key_value(&self) -> std::option::Option<&str> {
        self.hash_key_value.as_deref()
    }
    /// <p>The data type for the range key (also called the sort key), You can specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>'STRING'</code> - The range key is a string.</p> </li>
    /// <li> <p> <code>'NUMBER'</code> - The range key is number.</p> </li>
    /// </ul>
    /// <p>If you don't specify <code>rangeKeyField</code>, the default value is <code>'STRING'</code>.</p>
    pub fn range_key_type(&self) -> std::option::Option<&str> {
        self.range_key_type.as_deref()
    }
    /// <p>The name of the range key (also called the sort key). The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table. </p>
    pub fn range_key_field(&self) -> std::option::Option<&str> {
        self.range_key_field.as_deref()
    }
    /// <p>The value of the range key (also called the sort key).</p>
    pub fn range_key_value(&self) -> std::option::Option<&str> {
        self.range_key_value.as_deref()
    }
    /// <p>The type of operation to perform. You can specify the following values: </p>
    /// <ul>
    /// <li> <p> <code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</p> </li>
    /// <li> <p> <code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
    /// <li> <p> <code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
    /// </ul>
    /// <p>If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.</p>
    pub fn operation(&self) -> std::option::Option<&str> {
        self.operation.as_deref()
    }
    /// <p>The name of the DynamoDB column that receives the action payload.</p>
    /// <p>If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code>.</p>
    pub fn payload_field(&self) -> std::option::Option<&str> {
        self.payload_field.as_deref()
    }
    /// <p>The name of the DynamoDB table. The <code>tableName</code> value must match the table name of the target DynamoDB table. </p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Information needed to configure the payload.</p>
    /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for DynamoDbAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDbAction");
        formatter.field("hash_key_type", &self.hash_key_type);
        formatter.field("hash_key_field", &self.hash_key_field);
        formatter.field("hash_key_value", &self.hash_key_value);
        formatter.field("range_key_type", &self.range_key_type);
        formatter.field("range_key_field", &self.range_key_field);
        formatter.field("range_key_value", &self.range_key_value);
        formatter.field("operation", &self.operation);
        formatter.field("payload_field", &self.payload_field);
        formatter.field("table_name", &self.table_name);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`DynamoDbAction`](crate::model::DynamoDbAction)
pub mod dynamo_db_action {
    /// A builder for [`DynamoDbAction`](crate::model::DynamoDbAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hash_key_type: std::option::Option<std::string::String>,
        pub(crate) hash_key_field: std::option::Option<std::string::String>,
        pub(crate) hash_key_value: std::option::Option<std::string::String>,
        pub(crate) range_key_type: std::option::Option<std::string::String>,
        pub(crate) range_key_field: std::option::Option<std::string::String>,
        pub(crate) range_key_value: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) payload_field: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The data type for the hash key (also called the partition key). You can specify the following values:</p>
        /// <ul>
        /// <li> <p> <code>'STRING'</code> - The hash key is a string.</p> </li>
        /// <li> <p> <code>'NUMBER'</code> - The hash key is a number.</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>hashKeyType</code>, the default value is <code>'STRING'</code>.</p>
        pub fn hash_key_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_key_type = Some(input.into());
            self
        }
        /// <p>The data type for the hash key (also called the partition key). You can specify the following values:</p>
        /// <ul>
        /// <li> <p> <code>'STRING'</code> - The hash key is a string.</p> </li>
        /// <li> <p> <code>'NUMBER'</code> - The hash key is a number.</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>hashKeyType</code>, the default value is <code>'STRING'</code>.</p>
        pub fn set_hash_key_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_key_type = input;
            self
        }
        /// <p>The name of the hash key (also called the partition key). The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.</p>
        pub fn hash_key_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_key_field = Some(input.into());
            self
        }
        /// <p>The name of the hash key (also called the partition key). The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.</p>
        pub fn set_hash_key_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_key_field = input;
            self
        }
        /// <p>The value of the hash key (also called the partition key).</p>
        pub fn hash_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_key_value = Some(input.into());
            self
        }
        /// <p>The value of the hash key (also called the partition key).</p>
        pub fn set_hash_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_key_value = input;
            self
        }
        /// <p>The data type for the range key (also called the sort key), You can specify the following values:</p>
        /// <ul>
        /// <li> <p> <code>'STRING'</code> - The range key is a string.</p> </li>
        /// <li> <p> <code>'NUMBER'</code> - The range key is number.</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>rangeKeyField</code>, the default value is <code>'STRING'</code>.</p>
        pub fn range_key_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_key_type = Some(input.into());
            self
        }
        /// <p>The data type for the range key (also called the sort key), You can specify the following values:</p>
        /// <ul>
        /// <li> <p> <code>'STRING'</code> - The range key is a string.</p> </li>
        /// <li> <p> <code>'NUMBER'</code> - The range key is number.</p> </li>
        /// </ul>
        /// <p>If you don't specify <code>rangeKeyField</code>, the default value is <code>'STRING'</code>.</p>
        pub fn set_range_key_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_key_type = input;
            self
        }
        /// <p>The name of the range key (also called the sort key). The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table. </p>
        pub fn range_key_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_key_field = Some(input.into());
            self
        }
        /// <p>The name of the range key (also called the sort key). The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table. </p>
        pub fn set_range_key_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_key_field = input;
            self
        }
        /// <p>The value of the range key (also called the sort key).</p>
        pub fn range_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_key_value = Some(input.into());
            self
        }
        /// <p>The value of the range key (also called the sort key).</p>
        pub fn set_range_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_key_value = input;
            self
        }
        /// <p>The type of operation to perform. You can specify the following values: </p>
        /// <ul>
        /// <li> <p> <code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</p> </li>
        /// <li> <p> <code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
        /// <li> <p> <code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
        /// </ul>
        /// <p>If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The type of operation to perform. You can specify the following values: </p>
        /// <ul>
        /// <li> <p> <code>'INSERT'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</p> </li>
        /// <li> <p> <code>'UPDATE'</code> - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
        /// <li> <p> <code>'DELETE'</code> - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.</p> </li>
        /// </ul>
        /// <p>If you don't specify this parameter, AWS IoT Events triggers the <code>'INSERT'</code> operation.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The name of the DynamoDB column that receives the action payload.</p>
        /// <p>If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code>.</p>
        pub fn payload_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_field = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB column that receives the action payload.</p>
        /// <p>If you don't specify this parameter, the name of the DynamoDB column is <code>payload</code>.</p>
        pub fn set_payload_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_field = input;
            self
        }
        /// <p>The name of the DynamoDB table. The <code>tableName</code> value must match the table name of the target DynamoDB table. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table. The <code>tableName</code> value must match the table name of the target DynamoDB table. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Information needed to configure the payload.</p>
        /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>Information needed to configure the payload.</p>
        /// <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDbAction`](crate::model::DynamoDbAction)
        pub fn build(self) -> crate::model::DynamoDbAction {
            crate::model::DynamoDbAction {
                hash_key_type: self.hash_key_type,
                hash_key_field: self.hash_key_field,
                hash_key_value: self.hash_key_value,
                range_key_type: self.range_key_type,
                range_key_field: self.range_key_field,
                range_key_value: self.range_key_value,
                operation: self.operation,
                payload_field: self.payload_field,
                table_name: self.table_name,
                payload: self.payload,
            }
        }
    }
}
impl DynamoDbAction {
    /// Creates a new builder-style object to manufacture [`DynamoDbAction`](crate::model::DynamoDbAction)
    pub fn builder() -> crate::model::dynamo_db_action::Builder {
        crate::model::dynamo_db_action::Builder::default()
    }
}

/// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirehoseAction {
    /// <p>The name of the Kinesis Data Firehose delivery stream where the data is written.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).</p>
    pub separator: std::option::Option<std::string::String>,
    /// <p>You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl FirehoseAction {
    /// <p>The name of the Kinesis Data Firehose delivery stream where the data is written.</p>
    pub fn delivery_stream_name(&self) -> std::option::Option<&str> {
        self.delivery_stream_name.as_deref()
    }
    /// <p>A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).</p>
    pub fn separator(&self) -> std::option::Option<&str> {
        self.separator.as_deref()
    }
    /// <p>You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for FirehoseAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirehoseAction");
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("separator", &self.separator);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`FirehoseAction`](crate::model::FirehoseAction)
pub mod firehose_action {
    /// A builder for [`FirehoseAction`](crate::model::FirehoseAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) separator: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The name of the Kinesis Data Firehose delivery stream where the data is written.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Kinesis Data Firehose delivery stream where the data is written.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).</p>
        pub fn separator(mut self, input: impl Into<std::string::String>) -> Self {
            self.separator = Some(input.into());
            self
        }
        /// <p>A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).</p>
        pub fn set_separator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.separator = input;
            self
        }
        /// <p>You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`FirehoseAction`](crate::model::FirehoseAction)
        pub fn build(self) -> crate::model::FirehoseAction {
            crate::model::FirehoseAction {
                delivery_stream_name: self.delivery_stream_name,
                separator: self.separator,
                payload: self.payload,
            }
        }
    }
}
impl FirehoseAction {
    /// Creates a new builder-style object to manufacture [`FirehoseAction`](crate::model::FirehoseAction)
    pub fn builder() -> crate::model::firehose_action::Builder {
        crate::model::firehose_action::Builder::default()
    }
}

/// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqsAction {
    /// <p>The URL of the SQS queue where the data is written.</p>
    pub queue_url: std::option::Option<std::string::String>,
    /// <p>Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.</p>
    pub use_base64: std::option::Option<bool>,
    /// <p>You can configure the action payload when you send a message to an Amazon SQS queue.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl SqsAction {
    /// <p>The URL of the SQS queue where the data is written.</p>
    pub fn queue_url(&self) -> std::option::Option<&str> {
        self.queue_url.as_deref()
    }
    /// <p>Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.</p>
    pub fn use_base64(&self) -> std::option::Option<bool> {
        self.use_base64
    }
    /// <p>You can configure the action payload when you send a message to an Amazon SQS queue.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for SqsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqsAction");
        formatter.field("queue_url", &self.queue_url);
        formatter.field("use_base64", &self.use_base64);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`SqsAction`](crate::model::SqsAction)
pub mod sqs_action {
    /// A builder for [`SqsAction`](crate::model::SqsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_url: std::option::Option<std::string::String>,
        pub(crate) use_base64: std::option::Option<bool>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The URL of the SQS queue where the data is written.</p>
        pub fn queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS queue where the data is written.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_url = input;
            self
        }
        /// <p>Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.</p>
        pub fn use_base64(mut self, input: bool) -> Self {
            self.use_base64 = Some(input);
            self
        }
        /// <p>Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.</p>
        pub fn set_use_base64(mut self, input: std::option::Option<bool>) -> Self {
            self.use_base64 = input;
            self
        }
        /// <p>You can configure the action payload when you send a message to an Amazon SQS queue.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you send a message to an Amazon SQS queue.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`SqsAction`](crate::model::SqsAction)
        pub fn build(self) -> crate::model::SqsAction {
            crate::model::SqsAction {
                queue_url: self.queue_url,
                use_base64: self.use_base64,
                payload: self.payload,
            }
        }
    }
}
impl SqsAction {
    /// Creates a new builder-style object to manufacture [`SqsAction`](crate::model::SqsAction)
    pub fn builder() -> crate::model::sqs_action::Builder {
        crate::model::sqs_action::Builder::default()
    }
}

/// <p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotEventsAction {
    /// <p>The name of the AWS IoT Events input where the data is sent.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>You can configure the action payload when you send a message to an AWS IoT Events input.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl IotEventsAction {
    /// <p>The name of the AWS IoT Events input where the data is sent.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>You can configure the action payload when you send a message to an AWS IoT Events input.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for IotEventsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotEventsAction");
        formatter.field("input_name", &self.input_name);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`IotEventsAction`](crate::model::IotEventsAction)
pub mod iot_events_action {
    /// A builder for [`IotEventsAction`](crate::model::IotEventsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The name of the AWS IoT Events input where the data is sent.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the AWS IoT Events input where the data is sent.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>You can configure the action payload when you send a message to an AWS IoT Events input.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you send a message to an AWS IoT Events input.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`IotEventsAction`](crate::model::IotEventsAction)
        pub fn build(self) -> crate::model::IotEventsAction {
            crate::model::IotEventsAction {
                input_name: self.input_name,
                payload: self.payload,
            }
        }
    }
}
impl IotEventsAction {
    /// Creates a new builder-style object to manufacture [`IotEventsAction`](crate::model::IotEventsAction)
    pub fn builder() -> crate::model::iot_events_action::Builder {
        crate::model::iot_events_action::Builder::default()
    }
}

/// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaAction {
    /// <p>The ARN of the Lambda function that is executed.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>You can configure the action payload when you send a message to a Lambda function.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl LambdaAction {
    /// <p>The ARN of the Lambda function that is executed.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>You can configure the action payload when you send a message to a Lambda function.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for LambdaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaAction");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`LambdaAction`](crate::model::LambdaAction)
pub mod lambda_action {
    /// A builder for [`LambdaAction`](crate::model::LambdaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda function that is executed.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function that is executed.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>You can configure the action payload when you send a message to a Lambda function.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you send a message to a Lambda function.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaAction`](crate::model::LambdaAction)
        pub fn build(self) -> crate::model::LambdaAction {
            crate::model::LambdaAction {
                function_arn: self.function_arn,
                payload: self.payload,
            }
        }
    }
}
impl LambdaAction {
    /// Creates a new builder-style object to manufacture [`LambdaAction`](crate::model::LambdaAction)
    pub fn builder() -> crate::model::lambda_action::Builder {
        crate::model::lambda_action::Builder::default()
    }
}

/// <p>Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetTimerAction {
    /// <p>The name of the timer to reset.</p>
    pub timer_name: std::option::Option<std::string::String>,
}
impl ResetTimerAction {
    /// <p>The name of the timer to reset.</p>
    pub fn timer_name(&self) -> std::option::Option<&str> {
        self.timer_name.as_deref()
    }
}
impl std::fmt::Debug for ResetTimerAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetTimerAction");
        formatter.field("timer_name", &self.timer_name);
        formatter.finish()
    }
}
/// See [`ResetTimerAction`](crate::model::ResetTimerAction)
pub mod reset_timer_action {
    /// A builder for [`ResetTimerAction`](crate::model::ResetTimerAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the timer to reset.</p>
        pub fn timer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_name = Some(input.into());
            self
        }
        /// <p>The name of the timer to reset.</p>
        pub fn set_timer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetTimerAction`](crate::model::ResetTimerAction)
        pub fn build(self) -> crate::model::ResetTimerAction {
            crate::model::ResetTimerAction {
                timer_name: self.timer_name,
            }
        }
    }
}
impl ResetTimerAction {
    /// Creates a new builder-style object to manufacture [`ResetTimerAction`](crate::model::ResetTimerAction)
    pub fn builder() -> crate::model::reset_timer_action::Builder {
        crate::model::reset_timer_action::Builder::default()
    }
}

/// <p>Information needed to clear the timer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClearTimerAction {
    /// <p>The name of the timer to clear.</p>
    pub timer_name: std::option::Option<std::string::String>,
}
impl ClearTimerAction {
    /// <p>The name of the timer to clear.</p>
    pub fn timer_name(&self) -> std::option::Option<&str> {
        self.timer_name.as_deref()
    }
}
impl std::fmt::Debug for ClearTimerAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClearTimerAction");
        formatter.field("timer_name", &self.timer_name);
        formatter.finish()
    }
}
/// See [`ClearTimerAction`](crate::model::ClearTimerAction)
pub mod clear_timer_action {
    /// A builder for [`ClearTimerAction`](crate::model::ClearTimerAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the timer to clear.</p>
        pub fn timer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_name = Some(input.into());
            self
        }
        /// <p>The name of the timer to clear.</p>
        pub fn set_timer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ClearTimerAction`](crate::model::ClearTimerAction)
        pub fn build(self) -> crate::model::ClearTimerAction {
            crate::model::ClearTimerAction {
                timer_name: self.timer_name,
            }
        }
    }
}
impl ClearTimerAction {
    /// Creates a new builder-style object to manufacture [`ClearTimerAction`](crate::model::ClearTimerAction)
    pub fn builder() -> crate::model::clear_timer_action::Builder {
        crate::model::clear_timer_action::Builder::default()
    }
}

/// <p>Information needed to set the timer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTimerAction {
    /// <p>The name of the timer.</p>
    pub timer_name: std::option::Option<std::string::String>,
    /// <p>The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. </p>
    pub seconds: std::option::Option<i32>,
    /// <p>The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (<code>$variable.
    /// <variable-name></variable-name></code>), and input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. </p>
    pub duration_expression: std::option::Option<std::string::String>,
}
impl SetTimerAction {
    /// <p>The name of the timer.</p>
    pub fn timer_name(&self) -> std::option::Option<&str> {
        self.timer_name.as_deref()
    }
    /// <p>The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. </p>
    pub fn seconds(&self) -> std::option::Option<i32> {
        self.seconds
    }
    /// <p>The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (<code>$variable.
    /// <variable-name></variable-name></code>), and input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. </p>
    pub fn duration_expression(&self) -> std::option::Option<&str> {
        self.duration_expression.as_deref()
    }
}
impl std::fmt::Debug for SetTimerAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTimerAction");
        formatter.field("timer_name", &self.timer_name);
        formatter.field("seconds", &self.seconds);
        formatter.field("duration_expression", &self.duration_expression);
        formatter.finish()
    }
}
/// See [`SetTimerAction`](crate::model::SetTimerAction)
pub mod set_timer_action {
    /// A builder for [`SetTimerAction`](crate::model::SetTimerAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timer_name: std::option::Option<std::string::String>,
        pub(crate) seconds: std::option::Option<i32>,
        pub(crate) duration_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the timer.</p>
        pub fn timer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timer_name = Some(input.into());
            self
        }
        /// <p>The name of the timer.</p>
        pub fn set_timer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timer_name = input;
            self
        }
        /// <p>The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. </p>
        pub fn seconds(mut self, input: i32) -> Self {
            self.seconds = Some(input);
            self
        }
        /// <p>The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. </p>
        pub fn set_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds = input;
            self
        }
        /// <p>The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (<code>$variable.
        /// <variable-name></variable-name></code>), and input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. </p>
        pub fn duration_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration_expression = Some(input.into());
            self
        }
        /// <p>The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (<code>$variable.
        /// <variable-name></variable-name></code>), and input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. </p>
        pub fn set_duration_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.duration_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTimerAction`](crate::model::SetTimerAction)
        pub fn build(self) -> crate::model::SetTimerAction {
            crate::model::SetTimerAction {
                timer_name: self.timer_name,
                seconds: self.seconds,
                duration_expression: self.duration_expression,
            }
        }
    }
}
impl SetTimerAction {
    /// Creates a new builder-style object to manufacture [`SetTimerAction`](crate::model::SetTimerAction)
    pub fn builder() -> crate::model::set_timer_action::Builder {
        crate::model::set_timer_action::Builder::default()
    }
}

/// <p>Information required to publish the MQTT message through the AWS IoT message broker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotTopicPublishAction {
    /// <p>The MQTT topic of the message. You can use a string expression that includes variables (<code>$variable.
    /// <variable-name></variable-name></code>) and input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>) as the topic string.</p>
    pub mqtt_topic: std::option::Option<std::string::String>,
    /// <p>You can configure the action payload when you publish a message to an AWS IoT Core topic.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl IotTopicPublishAction {
    /// <p>The MQTT topic of the message. You can use a string expression that includes variables (<code>$variable.
    /// <variable-name></variable-name></code>) and input values (<code>$input.
    /// <input-name>
    /// .
    /// <path-to-datum></path-to-datum>
    /// </input-name></code>) as the topic string.</p>
    pub fn mqtt_topic(&self) -> std::option::Option<&str> {
        self.mqtt_topic.as_deref()
    }
    /// <p>You can configure the action payload when you publish a message to an AWS IoT Core topic.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for IotTopicPublishAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotTopicPublishAction");
        formatter.field("mqtt_topic", &self.mqtt_topic);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`IotTopicPublishAction`](crate::model::IotTopicPublishAction)
pub mod iot_topic_publish_action {
    /// A builder for [`IotTopicPublishAction`](crate::model::IotTopicPublishAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mqtt_topic: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The MQTT topic of the message. You can use a string expression that includes variables (<code>$variable.
        /// <variable-name></variable-name></code>) and input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>) as the topic string.</p>
        pub fn mqtt_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.mqtt_topic = Some(input.into());
            self
        }
        /// <p>The MQTT topic of the message. You can use a string expression that includes variables (<code>$variable.
        /// <variable-name></variable-name></code>) and input values (<code>$input.
        /// <input-name>
        /// .
        /// <path-to-datum></path-to-datum>
        /// </input-name></code>) as the topic string.</p>
        pub fn set_mqtt_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mqtt_topic = input;
            self
        }
        /// <p>You can configure the action payload when you publish a message to an AWS IoT Core topic.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you publish a message to an AWS IoT Core topic.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`IotTopicPublishAction`](crate::model::IotTopicPublishAction)
        pub fn build(self) -> crate::model::IotTopicPublishAction {
            crate::model::IotTopicPublishAction {
                mqtt_topic: self.mqtt_topic,
                payload: self.payload,
            }
        }
    }
}
impl IotTopicPublishAction {
    /// Creates a new builder-style object to manufacture [`IotTopicPublishAction`](crate::model::IotTopicPublishAction)
    pub fn builder() -> crate::model::iot_topic_publish_action::Builder {
        crate::model::iot_topic_publish_action::Builder::default()
    }
}

/// <p>Information required to publish the Amazon SNS message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsTopicPublishAction {
    /// <p>The ARN of the Amazon SNS target where the message is sent.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>You can configure the action payload when you send a message as an Amazon SNS push notification.</p>
    pub payload: std::option::Option<crate::model::Payload>,
}
impl SnsTopicPublishAction {
    /// <p>The ARN of the Amazon SNS target where the message is sent.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>You can configure the action payload when you send a message as an Amazon SNS push notification.</p>
    pub fn payload(&self) -> std::option::Option<&crate::model::Payload> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for SnsTopicPublishAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsTopicPublishAction");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`SnsTopicPublishAction`](crate::model::SnsTopicPublishAction)
pub mod sns_topic_publish_action {
    /// A builder for [`SnsTopicPublishAction`](crate::model::SnsTopicPublishAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<crate::model::Payload>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon SNS target where the message is sent.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon SNS target where the message is sent.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>You can configure the action payload when you send a message as an Amazon SNS push notification.</p>
        pub fn payload(mut self, input: crate::model::Payload) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>You can configure the action payload when you send a message as an Amazon SNS push notification.</p>
        pub fn set_payload(mut self, input: std::option::Option<crate::model::Payload>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsTopicPublishAction`](crate::model::SnsTopicPublishAction)
        pub fn build(self) -> crate::model::SnsTopicPublishAction {
            crate::model::SnsTopicPublishAction {
                target_arn: self.target_arn,
                payload: self.payload,
            }
        }
    }
}
impl SnsTopicPublishAction {
    /// Creates a new builder-style object to manufacture [`SnsTopicPublishAction`](crate::model::SnsTopicPublishAction)
    pub fn builder() -> crate::model::sns_topic_publish_action::Builder {
        crate::model::sns_topic_publish_action::Builder::default()
    }
}

/// <p>Information about the variable and its new value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetVariableAction {
    /// <p>The name of the variable.</p>
    pub variable_name: std::option::Option<std::string::String>,
    /// <p>The new value of the variable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl SetVariableAction {
    /// <p>The name of the variable.</p>
    pub fn variable_name(&self) -> std::option::Option<&str> {
        self.variable_name.as_deref()
    }
    /// <p>The new value of the variable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SetVariableAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetVariableAction");
        formatter.field("variable_name", &self.variable_name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SetVariableAction`](crate::model::SetVariableAction)
pub mod set_variable_action {
    /// A builder for [`SetVariableAction`](crate::model::SetVariableAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variable_name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn variable_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.variable_name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_variable_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.variable_name = input;
            self
        }
        /// <p>The new value of the variable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The new value of the variable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SetVariableAction`](crate::model::SetVariableAction)
        pub fn build(self) -> crate::model::SetVariableAction {
            crate::model::SetVariableAction {
                variable_name: self.variable_name,
                value: self.value,
            }
        }
    }
}
impl SetVariableAction {
    /// Creates a new builder-style object to manufacture [`SetVariableAction`](crate::model::SetVariableAction)
    pub fn builder() -> crate::model::set_variable_action::Builder {
        crate::model::set_variable_action::Builder::default()
    }
}

/// <p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnEnterLifecycle {
    /// <p>Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code>.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl OnEnterLifecycle {
    /// <p>Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code>.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for OnEnterLifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnEnterLifecycle");
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`OnEnterLifecycle`](crate::model::OnEnterLifecycle)
pub mod on_enter_lifecycle {
    /// A builder for [`OnEnterLifecycle`](crate::model::OnEnterLifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code>.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code>.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`OnEnterLifecycle`](crate::model::OnEnterLifecycle)
        pub fn build(self) -> crate::model::OnEnterLifecycle {
            crate::model::OnEnterLifecycle {
                events: self.events,
            }
        }
    }
}
impl OnEnterLifecycle {
    /// Creates a new builder-style object to manufacture [`OnEnterLifecycle`](crate::model::OnEnterLifecycle)
    pub fn builder() -> crate::model::on_enter_lifecycle::Builder {
        crate::model::on_enter_lifecycle::Builder::default()
    }
}

/// <p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnInputLifecycle {
    /// <p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.</p>
    pub transition_events: std::option::Option<std::vec::Vec<crate::model::TransitionEvent>>,
}
impl OnInputLifecycle {
    /// <p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.</p>
    pub fn transition_events(&self) -> std::option::Option<&[crate::model::TransitionEvent]> {
        self.transition_events.as_deref()
    }
}
impl std::fmt::Debug for OnInputLifecycle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnInputLifecycle");
        formatter.field("events", &self.events);
        formatter.field("transition_events", &self.transition_events);
        formatter.finish()
    }
}
/// See [`OnInputLifecycle`](crate::model::OnInputLifecycle)
pub mod on_input_lifecycle {
    /// A builder for [`OnInputLifecycle`](crate::model::OnInputLifecycle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) transition_events:
            std::option::Option<std::vec::Vec<crate::model::TransitionEvent>>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Appends an item to `transition_events`.
        ///
        /// To override the contents of this collection use [`set_transition_events`](Self::set_transition_events).
        ///
        /// <p>Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.</p>
        pub fn transition_events(mut self, input: crate::model::TransitionEvent) -> Self {
            let mut v = self.transition_events.unwrap_or_default();
            v.push(input);
            self.transition_events = Some(v);
            self
        }
        /// <p>Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.</p>
        pub fn set_transition_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransitionEvent>>,
        ) -> Self {
            self.transition_events = input;
            self
        }
        /// Consumes the builder and constructs a [`OnInputLifecycle`](crate::model::OnInputLifecycle)
        pub fn build(self) -> crate::model::OnInputLifecycle {
            crate::model::OnInputLifecycle {
                events: self.events,
                transition_events: self.transition_events,
            }
        }
    }
}
impl OnInputLifecycle {
    /// Creates a new builder-style object to manufacture [`OnInputLifecycle`](crate::model::OnInputLifecycle)
    pub fn builder() -> crate::model::on_input_lifecycle::Builder {
        crate::model::on_input_lifecycle::Builder::default()
    }
}

/// <p>Specifies the actions performed and the next state entered when a <code>condition</code> evaluates to TRUE.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitionEvent {
    /// <p>The name of the transition event.</p>
    pub event_name: std::option::Option<std::string::String>,
    /// <p>Required. A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.</p>
    pub condition: std::option::Option<std::string::String>,
    /// <p>The actions to be performed.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>The next state to enter.</p>
    pub next_state: std::option::Option<std::string::String>,
}
impl TransitionEvent {
    /// <p>The name of the transition event.</p>
    pub fn event_name(&self) -> std::option::Option<&str> {
        self.event_name.as_deref()
    }
    /// <p>Required. A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.</p>
    pub fn condition(&self) -> std::option::Option<&str> {
        self.condition.as_deref()
    }
    /// <p>The actions to be performed.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
    /// <p>The next state to enter.</p>
    pub fn next_state(&self) -> std::option::Option<&str> {
        self.next_state.as_deref()
    }
}
impl std::fmt::Debug for TransitionEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitionEvent");
        formatter.field("event_name", &self.event_name);
        formatter.field("condition", &self.condition);
        formatter.field("actions", &self.actions);
        formatter.field("next_state", &self.next_state);
        formatter.finish()
    }
}
/// See [`TransitionEvent`](crate::model::TransitionEvent)
pub mod transition_event {
    /// A builder for [`TransitionEvent`](crate::model::TransitionEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_name: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) next_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the transition event.</p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_name = Some(input.into());
            self
        }
        /// <p>The name of the transition event.</p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_name = input;
            self
        }
        /// <p>Required. A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.</p>
        pub fn condition(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition = Some(input.into());
            self
        }
        /// <p>Required. A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.</p>
        pub fn set_condition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.condition = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions to be performed.</p>
        pub fn actions(mut self, input: crate::model::Action) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>The actions to be performed.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The next state to enter.</p>
        pub fn next_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_state = Some(input.into());
            self
        }
        /// <p>The next state to enter.</p>
        pub fn set_next_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitionEvent`](crate::model::TransitionEvent)
        pub fn build(self) -> crate::model::TransitionEvent {
            crate::model::TransitionEvent {
                event_name: self.event_name,
                condition: self.condition,
                actions: self.actions,
                next_state: self.next_state,
            }
        }
    }
}
impl TransitionEvent {
    /// Creates a new builder-style object to manufacture [`TransitionEvent`](crate::model::TransitionEvent)
    pub fn builder() -> crate::model::transition_event::Builder {
        crate::model::transition_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlarmModelVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlarmModelVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => AlarmModelVersionStatus::Activating,
            "ACTIVE" => AlarmModelVersionStatus::Active,
            "FAILED" => AlarmModelVersionStatus::Failed,
            "INACTIVE" => AlarmModelVersionStatus::Inactive,
            other => AlarmModelVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlarmModelVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlarmModelVersionStatus::from(s))
    }
}
impl AlarmModelVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlarmModelVersionStatus::Activating => "ACTIVATING",
            AlarmModelVersionStatus::Active => "ACTIVE",
            AlarmModelVersionStatus::Failed => "FAILED",
            AlarmModelVersionStatus::Inactive => "INACTIVE",
            AlarmModelVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVATING", "ACTIVE", "FAILED", "INACTIVE"]
    }
}
impl AsRef<str> for AlarmModelVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration information of alarm state changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmCapabilities {
    /// <p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>
    pub initialization_configuration:
        std::option::Option<crate::model::InitializationConfiguration>,
    /// <p>Specifies whether to get notified for alarm state changes.</p>
    pub acknowledge_flow: std::option::Option<crate::model::AcknowledgeFlow>,
}
impl AlarmCapabilities {
    /// <p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>
    pub fn initialization_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InitializationConfiguration> {
        self.initialization_configuration.as_ref()
    }
    /// <p>Specifies whether to get notified for alarm state changes.</p>
    pub fn acknowledge_flow(&self) -> std::option::Option<&crate::model::AcknowledgeFlow> {
        self.acknowledge_flow.as_ref()
    }
}
impl std::fmt::Debug for AlarmCapabilities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmCapabilities");
        formatter.field(
            "initialization_configuration",
            &self.initialization_configuration,
        );
        formatter.field("acknowledge_flow", &self.acknowledge_flow);
        formatter.finish()
    }
}
/// See [`AlarmCapabilities`](crate::model::AlarmCapabilities)
pub mod alarm_capabilities {
    /// A builder for [`AlarmCapabilities`](crate::model::AlarmCapabilities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initialization_configuration:
            std::option::Option<crate::model::InitializationConfiguration>,
        pub(crate) acknowledge_flow: std::option::Option<crate::model::AcknowledgeFlow>,
    }
    impl Builder {
        /// <p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>
        pub fn initialization_configuration(
            mut self,
            input: crate::model::InitializationConfiguration,
        ) -> Self {
            self.initialization_configuration = Some(input);
            self
        }
        /// <p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>
        pub fn set_initialization_configuration(
            mut self,
            input: std::option::Option<crate::model::InitializationConfiguration>,
        ) -> Self {
            self.initialization_configuration = input;
            self
        }
        /// <p>Specifies whether to get notified for alarm state changes.</p>
        pub fn acknowledge_flow(mut self, input: crate::model::AcknowledgeFlow) -> Self {
            self.acknowledge_flow = Some(input);
            self
        }
        /// <p>Specifies whether to get notified for alarm state changes.</p>
        pub fn set_acknowledge_flow(
            mut self,
            input: std::option::Option<crate::model::AcknowledgeFlow>,
        ) -> Self {
            self.acknowledge_flow = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmCapabilities`](crate::model::AlarmCapabilities)
        pub fn build(self) -> crate::model::AlarmCapabilities {
            crate::model::AlarmCapabilities {
                initialization_configuration: self.initialization_configuration,
                acknowledge_flow: self.acknowledge_flow,
            }
        }
    }
}
impl AlarmCapabilities {
    /// Creates a new builder-style object to manufacture [`AlarmCapabilities`](crate::model::AlarmCapabilities)
    pub fn builder() -> crate::model::alarm_capabilities::Builder {
        crate::model::alarm_capabilities::Builder::default()
    }
}

/// <p>Specifies whether to get notified for alarm state changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcknowledgeFlow {
    /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>TRUE</code>, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code>. If <code>FALSE</code>, you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.</p>
    pub enabled: std::option::Option<bool>,
}
impl AcknowledgeFlow {
    /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>TRUE</code>, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code>. If <code>FALSE</code>, you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for AcknowledgeFlow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcknowledgeFlow");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AcknowledgeFlow`](crate::model::AcknowledgeFlow)
pub mod acknowledge_flow {
    /// A builder for [`AcknowledgeFlow`](crate::model::AcknowledgeFlow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>TRUE</code>, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code>. If <code>FALSE</code>, you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>TRUE</code>, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code>. If <code>FALSE</code>, you won't receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AcknowledgeFlow`](crate::model::AcknowledgeFlow)
        pub fn build(self) -> crate::model::AcknowledgeFlow {
            crate::model::AcknowledgeFlow {
                enabled: self.enabled,
            }
        }
    }
}
impl AcknowledgeFlow {
    /// Creates a new builder-style object to manufacture [`AcknowledgeFlow`](crate::model::AcknowledgeFlow)
    pub fn builder() -> crate::model::acknowledge_flow::Builder {
        crate::model::acknowledge_flow::Builder::default()
    }
}

/// <p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitializationConfiguration {
    /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code>.</p>
    pub disabled_on_initialization: std::option::Option<bool>,
}
impl InitializationConfiguration {
    /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code>.</p>
    pub fn disabled_on_initialization(&self) -> std::option::Option<bool> {
        self.disabled_on_initialization
    }
}
impl std::fmt::Debug for InitializationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitializationConfiguration");
        formatter.field(
            "disabled_on_initialization",
            &self.disabled_on_initialization,
        );
        formatter.finish()
    }
}
/// See [`InitializationConfiguration`](crate::model::InitializationConfiguration)
pub mod initialization_configuration {
    /// A builder for [`InitializationConfiguration`](crate::model::InitializationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disabled_on_initialization: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code>.</p>
        pub fn disabled_on_initialization(mut self, input: bool) -> Self {
            self.disabled_on_initialization = Some(input);
            self
        }
        /// <p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code>.</p>
        pub fn set_disabled_on_initialization(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled_on_initialization = input;
            self
        }
        /// Consumes the builder and constructs a [`InitializationConfiguration`](crate::model::InitializationConfiguration)
        pub fn build(self) -> crate::model::InitializationConfiguration {
            crate::model::InitializationConfiguration {
                disabled_on_initialization: self.disabled_on_initialization,
            }
        }
    }
}
impl InitializationConfiguration {
    /// Creates a new builder-style object to manufacture [`InitializationConfiguration`](crate::model::InitializationConfiguration)
    pub fn builder() -> crate::model::initialization_configuration::Builder {
        crate::model::initialization_configuration::Builder::default()
    }
}

/// <p>Contains information about one or more alarm actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmEventActions {
    /// <p>Specifies one or more supported actions to receive notifications when the alarm state changes.</p>
    pub alarm_actions: std::option::Option<std::vec::Vec<crate::model::AlarmAction>>,
}
impl AlarmEventActions {
    /// <p>Specifies one or more supported actions to receive notifications when the alarm state changes.</p>
    pub fn alarm_actions(&self) -> std::option::Option<&[crate::model::AlarmAction]> {
        self.alarm_actions.as_deref()
    }
}
impl std::fmt::Debug for AlarmEventActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmEventActions");
        formatter.field("alarm_actions", &self.alarm_actions);
        formatter.finish()
    }
}
/// See [`AlarmEventActions`](crate::model::AlarmEventActions)
pub mod alarm_event_actions {
    /// A builder for [`AlarmEventActions`](crate::model::AlarmEventActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_actions: std::option::Option<std::vec::Vec<crate::model::AlarmAction>>,
    }
    impl Builder {
        /// Appends an item to `alarm_actions`.
        ///
        /// To override the contents of this collection use [`set_alarm_actions`](Self::set_alarm_actions).
        ///
        /// <p>Specifies one or more supported actions to receive notifications when the alarm state changes.</p>
        pub fn alarm_actions(mut self, input: crate::model::AlarmAction) -> Self {
            let mut v = self.alarm_actions.unwrap_or_default();
            v.push(input);
            self.alarm_actions = Some(v);
            self
        }
        /// <p>Specifies one or more supported actions to receive notifications when the alarm state changes.</p>
        pub fn set_alarm_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlarmAction>>,
        ) -> Self {
            self.alarm_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmEventActions`](crate::model::AlarmEventActions)
        pub fn build(self) -> crate::model::AlarmEventActions {
            crate::model::AlarmEventActions {
                alarm_actions: self.alarm_actions,
            }
        }
    }
}
impl AlarmEventActions {
    /// Creates a new builder-style object to manufacture [`AlarmEventActions`](crate::model::AlarmEventActions)
    pub fn builder() -> crate::model::alarm_event_actions::Builder {
        crate::model::alarm_event_actions::Builder::default()
    }
}

/// <p>Specifies one of the following actions to receive notifications when the alarm state changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmAction {
    /// <p>Information required to publish the Amazon SNS message.</p>
    pub sns: std::option::Option<crate::model::SnsTopicPublishAction>,
    /// <p>Information required to publish the MQTT message through the AWS IoT message broker.</p>
    pub iot_topic_publish: std::option::Option<crate::model::IotTopicPublishAction>,
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub lambda: std::option::Option<crate::model::LambdaAction>,
    /// <p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>
    pub iot_events: std::option::Option<crate::model::IotEventsAction>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
    pub sqs: std::option::Option<crate::model::SqsAction>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub firehose: std::option::Option<crate::model::FirehoseAction>,
    /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p>
    /// <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code> </p> </li>
    /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>
    /// <payload-field>
    /// _raw
    /// </payload-field></code>.</p>
    pub dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
    /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p>
    /// <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code> </p> </li>
    /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>
    pub dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
    /// <p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p>
    /// <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code> </p> </li>
    /// </ul>
    /// <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    pub iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
}
impl AlarmAction {
    /// <p>Information required to publish the Amazon SNS message.</p>
    pub fn sns(&self) -> std::option::Option<&crate::model::SnsTopicPublishAction> {
        self.sns.as_ref()
    }
    /// <p>Information required to publish the MQTT message through the AWS IoT message broker.</p>
    pub fn iot_topic_publish(&self) -> std::option::Option<&crate::model::IotTopicPublishAction> {
        self.iot_topic_publish.as_ref()
    }
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaAction> {
        self.lambda.as_ref()
    }
    /// <p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>
    pub fn iot_events(&self) -> std::option::Option<&crate::model::IotEventsAction> {
        self.iot_events.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
    pub fn sqs(&self) -> std::option::Option<&crate::model::SqsAction> {
        self.sqs.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
    pub fn firehose(&self) -> std::option::Option<&crate::model::FirehoseAction> {
        self.firehose.as_ref()
    }
    /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p>
    /// <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code> </p> </li>
    /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>
    /// <payload-field>
    /// _raw
    /// </payload-field></code>.</p>
    pub fn dynamo_db(&self) -> std::option::Option<&crate::model::DynamoDbAction> {
        self.dynamo_db.as_ref()
    }
    /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p>
    /// <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code> </p> </li>
    /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>
    pub fn dynamo_d_bv2(&self) -> std::option::Option<&crate::model::DynamoDBv2Action> {
        self.dynamo_d_bv2.as_ref()
    }
    /// <p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p>
    /// <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p>
    /// <p class="title"> <b>Examples</b> </p>
    /// <ul>
    /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.</p> </li>
    /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li>
    /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code> </p> </li>
    /// </ul>
    /// <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    pub fn iot_site_wise(&self) -> std::option::Option<&crate::model::IotSiteWiseAction> {
        self.iot_site_wise.as_ref()
    }
}
impl std::fmt::Debug for AlarmAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmAction");
        formatter.field("sns", &self.sns);
        formatter.field("iot_topic_publish", &self.iot_topic_publish);
        formatter.field("lambda", &self.lambda);
        formatter.field("iot_events", &self.iot_events);
        formatter.field("sqs", &self.sqs);
        formatter.field("firehose", &self.firehose);
        formatter.field("dynamo_db", &self.dynamo_db);
        formatter.field("dynamo_d_bv2", &self.dynamo_d_bv2);
        formatter.field("iot_site_wise", &self.iot_site_wise);
        formatter.finish()
    }
}
/// See [`AlarmAction`](crate::model::AlarmAction)
pub mod alarm_action {
    /// A builder for [`AlarmAction`](crate::model::AlarmAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns: std::option::Option<crate::model::SnsTopicPublishAction>,
        pub(crate) iot_topic_publish: std::option::Option<crate::model::IotTopicPublishAction>,
        pub(crate) lambda: std::option::Option<crate::model::LambdaAction>,
        pub(crate) iot_events: std::option::Option<crate::model::IotEventsAction>,
        pub(crate) sqs: std::option::Option<crate::model::SqsAction>,
        pub(crate) firehose: std::option::Option<crate::model::FirehoseAction>,
        pub(crate) dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
        pub(crate) dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
        pub(crate) iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
    }
    impl Builder {
        /// <p>Information required to publish the Amazon SNS message.</p>
        pub fn sns(mut self, input: crate::model::SnsTopicPublishAction) -> Self {
            self.sns = Some(input);
            self
        }
        /// <p>Information required to publish the Amazon SNS message.</p>
        pub fn set_sns(
            mut self,
            input: std::option::Option<crate::model::SnsTopicPublishAction>,
        ) -> Self {
            self.sns = input;
            self
        }
        /// <p>Information required to publish the MQTT message through the AWS IoT message broker.</p>
        pub fn iot_topic_publish(mut self, input: crate::model::IotTopicPublishAction) -> Self {
            self.iot_topic_publish = Some(input);
            self
        }
        /// <p>Information required to publish the MQTT message through the AWS IoT message broker.</p>
        pub fn set_iot_topic_publish(
            mut self,
            input: std::option::Option<crate::model::IotTopicPublishAction>,
        ) -> Self {
            self.iot_topic_publish = input;
            self
        }
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn lambda(mut self, input: crate::model::LambdaAction) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaAction>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// <p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn iot_events(mut self, input: crate::model::IotEventsAction) -> Self {
            self.iot_events = Some(input);
            self
        }
        /// <p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn set_iot_events(
            mut self,
            input: std::option::Option<crate::model::IotEventsAction>,
        ) -> Self {
            self.iot_events = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
        pub fn sqs(mut self, input: crate::model::SqsAction) -> Self {
            self.sqs = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>
        pub fn set_sqs(mut self, input: std::option::Option<crate::model::SqsAction>) -> Self {
            self.sqs = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn firehose(mut self, input: crate::model::FirehoseAction) -> Self {
            self.firehose = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>
        pub fn set_firehose(
            mut self,
            input: std::option::Option<crate::model::FirehoseAction>,
        ) -> Self {
            self.firehose = input;
            self
        }
        /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p>
        /// <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code> </p> </li>
        /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>
        /// <payload-field>
        /// _raw
        /// </payload-field></code>.</p>
        pub fn dynamo_db(mut self, input: crate::model::DynamoDbAction) -> Self {
            self.dynamo_db = Some(input);
            self
        }
        /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p>
        /// <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>'STRING'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'</code> </p> </li>
        /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>
        /// <payload-field>
        /// _raw
        /// </payload-field></code>.</p>
        pub fn set_dynamo_db(
            mut self,
            input: std::option::Option<crate::model::DynamoDbAction>,
        ) -> Self {
            self.dynamo_db = input;
            self
        }
        /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p>
        /// <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code> </p> </li>
        /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>
        pub fn dynamo_d_bv2(mut self, input: crate::model::DynamoDBv2Action) -> Self {
            self.dynamo_d_bv2 = Some(input);
            self
        }
        /// <p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p>
        /// <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>'GreenhouseTemperatureTable'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'</code> </p> </li>
        /// <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>
        pub fn set_dynamo_d_bv2(
            mut self,
            input: std::option::Option<crate::model::DynamoDBv2Action>,
        ) -> Self {
            self.dynamo_d_bv2 = input;
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p>
        /// <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code> </p> </li>
        /// </ul>
        /// <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn iot_site_wise(mut self, input: crate::model::IotSiteWiseAction) -> Self {
            self.iot_site_wise = Some(input);
            self
        }
        /// <p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p>
        /// <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p>
        /// <p class="title"> <b>Examples</b> </p>
        /// <ul>
        /// <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.</p> </li>
        /// <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li>
        /// <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code> </p> </li>
        /// </ul>
        /// <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn set_iot_site_wise(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseAction>,
        ) -> Self {
            self.iot_site_wise = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmAction`](crate::model::AlarmAction)
        pub fn build(self) -> crate::model::AlarmAction {
            crate::model::AlarmAction {
                sns: self.sns,
                iot_topic_publish: self.iot_topic_publish,
                lambda: self.lambda,
                iot_events: self.iot_events,
                sqs: self.sqs,
                firehose: self.firehose,
                dynamo_db: self.dynamo_db,
                dynamo_d_bv2: self.dynamo_d_bv2,
                iot_site_wise: self.iot_site_wise,
            }
        }
    }
}
impl AlarmAction {
    /// Creates a new builder-style object to manufacture [`AlarmAction`](crate::model::AlarmAction)
    pub fn builder() -> crate::model::alarm_action::Builder {
        crate::model::alarm_action::Builder::default()
    }
}

/// <p>Contains information about one or more notification actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmNotification {
    /// <p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>
    pub notification_actions: std::option::Option<std::vec::Vec<crate::model::NotificationAction>>,
}
impl AlarmNotification {
    /// <p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>
    pub fn notification_actions(&self) -> std::option::Option<&[crate::model::NotificationAction]> {
        self.notification_actions.as_deref()
    }
}
impl std::fmt::Debug for AlarmNotification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmNotification");
        formatter.field("notification_actions", &self.notification_actions);
        formatter.finish()
    }
}
/// See [`AlarmNotification`](crate::model::AlarmNotification)
pub mod alarm_notification {
    /// A builder for [`AlarmNotification`](crate::model::AlarmNotification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_actions:
            std::option::Option<std::vec::Vec<crate::model::NotificationAction>>,
    }
    impl Builder {
        /// Appends an item to `notification_actions`.
        ///
        /// To override the contents of this collection use [`set_notification_actions`](Self::set_notification_actions).
        ///
        /// <p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>
        pub fn notification_actions(mut self, input: crate::model::NotificationAction) -> Self {
            let mut v = self.notification_actions.unwrap_or_default();
            v.push(input);
            self.notification_actions = Some(v);
            self
        }
        /// <p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>
        pub fn set_notification_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationAction>>,
        ) -> Self {
            self.notification_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmNotification`](crate::model::AlarmNotification)
        pub fn build(self) -> crate::model::AlarmNotification {
            crate::model::AlarmNotification {
                notification_actions: self.notification_actions,
            }
        }
    }
}
impl AlarmNotification {
    /// Creates a new builder-style object to manufacture [`AlarmNotification`](crate::model::AlarmNotification)
    pub fn builder() -> crate::model::alarm_notification::Builder {
        crate::model::alarm_notification::Builder::default()
    }
}

/// <p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationAction {
    /// <p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>
    pub action: std::option::Option<crate::model::NotificationTargetActions>,
    /// <p>Contains the configuration information of SMS notifications.</p>
    pub sms_configurations: std::option::Option<std::vec::Vec<crate::model::SmsConfiguration>>,
    /// <p>Contains the configuration information of email notifications.</p>
    pub email_configurations: std::option::Option<std::vec::Vec<crate::model::EmailConfiguration>>,
}
impl NotificationAction {
    /// <p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::NotificationTargetActions> {
        self.action.as_ref()
    }
    /// <p>Contains the configuration information of SMS notifications.</p>
    pub fn sms_configurations(&self) -> std::option::Option<&[crate::model::SmsConfiguration]> {
        self.sms_configurations.as_deref()
    }
    /// <p>Contains the configuration information of email notifications.</p>
    pub fn email_configurations(&self) -> std::option::Option<&[crate::model::EmailConfiguration]> {
        self.email_configurations.as_deref()
    }
}
impl std::fmt::Debug for NotificationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationAction");
        formatter.field("action", &self.action);
        formatter.field("sms_configurations", &self.sms_configurations);
        formatter.field("email_configurations", &self.email_configurations);
        formatter.finish()
    }
}
/// See [`NotificationAction`](crate::model::NotificationAction)
pub mod notification_action {
    /// A builder for [`NotificationAction`](crate::model::NotificationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::NotificationTargetActions>,
        pub(crate) sms_configurations:
            std::option::Option<std::vec::Vec<crate::model::SmsConfiguration>>,
        pub(crate) email_configurations:
            std::option::Option<std::vec::Vec<crate::model::EmailConfiguration>>,
    }
    impl Builder {
        /// <p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>
        pub fn action(mut self, input: crate::model::NotificationTargetActions) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::NotificationTargetActions>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Appends an item to `sms_configurations`.
        ///
        /// To override the contents of this collection use [`set_sms_configurations`](Self::set_sms_configurations).
        ///
        /// <p>Contains the configuration information of SMS notifications.</p>
        pub fn sms_configurations(mut self, input: crate::model::SmsConfiguration) -> Self {
            let mut v = self.sms_configurations.unwrap_or_default();
            v.push(input);
            self.sms_configurations = Some(v);
            self
        }
        /// <p>Contains the configuration information of SMS notifications.</p>
        pub fn set_sms_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SmsConfiguration>>,
        ) -> Self {
            self.sms_configurations = input;
            self
        }
        /// Appends an item to `email_configurations`.
        ///
        /// To override the contents of this collection use [`set_email_configurations`](Self::set_email_configurations).
        ///
        /// <p>Contains the configuration information of email notifications.</p>
        pub fn email_configurations(mut self, input: crate::model::EmailConfiguration) -> Self {
            let mut v = self.email_configurations.unwrap_or_default();
            v.push(input);
            self.email_configurations = Some(v);
            self
        }
        /// <p>Contains the configuration information of email notifications.</p>
        pub fn set_email_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EmailConfiguration>>,
        ) -> Self {
            self.email_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationAction`](crate::model::NotificationAction)
        pub fn build(self) -> crate::model::NotificationAction {
            crate::model::NotificationAction {
                action: self.action,
                sms_configurations: self.sms_configurations,
                email_configurations: self.email_configurations,
            }
        }
    }
}
impl NotificationAction {
    /// Creates a new builder-style object to manufacture [`NotificationAction`](crate::model::NotificationAction)
    pub fn builder() -> crate::model::notification_action::Builder {
        crate::model::notification_action::Builder::default()
    }
}

/// <p>Contains the configuration information of email notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailConfiguration {
    /// <p>The email address that sends emails.</p> <important>
    /// <p>If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address that sends emails in Amazon SES</a>.</p>
    /// </important>
    pub from: std::option::Option<std::string::String>,
    /// <p>Contains the subject and message of an email.</p>
    pub content: std::option::Option<crate::model::EmailContent>,
    /// <p>Contains the information of one or more recipients who receive the emails.</p> <important>
    /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p>
    /// </important>
    pub recipients: std::option::Option<crate::model::EmailRecipients>,
}
impl EmailConfiguration {
    /// <p>The email address that sends emails.</p> <important>
    /// <p>If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address that sends emails in Amazon SES</a>.</p>
    /// </important>
    pub fn from(&self) -> std::option::Option<&str> {
        self.from.as_deref()
    }
    /// <p>Contains the subject and message of an email.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::EmailContent> {
        self.content.as_ref()
    }
    /// <p>Contains the information of one or more recipients who receive the emails.</p> <important>
    /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p>
    /// </important>
    pub fn recipients(&self) -> std::option::Option<&crate::model::EmailRecipients> {
        self.recipients.as_ref()
    }
}
impl std::fmt::Debug for EmailConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailConfiguration");
        formatter.field("from", &self.from);
        formatter.field("content", &self.content);
        formatter.field("recipients", &self.recipients);
        formatter.finish()
    }
}
/// See [`EmailConfiguration`](crate::model::EmailConfiguration)
pub mod email_configuration {
    /// A builder for [`EmailConfiguration`](crate::model::EmailConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::EmailContent>,
        pub(crate) recipients: std::option::Option<crate::model::EmailRecipients>,
    }
    impl Builder {
        /// <p>The email address that sends emails.</p> <important>
        /// <p>If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address that sends emails in Amazon SES</a>.</p>
        /// </important>
        pub fn from(mut self, input: impl Into<std::string::String>) -> Self {
            self.from = Some(input.into());
            self
        }
        /// <p>The email address that sends emails.</p> <important>
        /// <p>If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address that sends emails in Amazon SES</a>.</p>
        /// </important>
        pub fn set_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from = input;
            self
        }
        /// <p>Contains the subject and message of an email.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Contains the subject and message of an email.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.content = input;
            self
        }
        /// <p>Contains the information of one or more recipients who receive the emails.</p> <important>
        /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p>
        /// </important>
        pub fn recipients(mut self, input: crate::model::EmailRecipients) -> Self {
            self.recipients = Some(input);
            self
        }
        /// <p>Contains the information of one or more recipients who receive the emails.</p> <important>
        /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p>
        /// </important>
        pub fn set_recipients(
            mut self,
            input: std::option::Option<crate::model::EmailRecipients>,
        ) -> Self {
            self.recipients = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailConfiguration`](crate::model::EmailConfiguration)
        pub fn build(self) -> crate::model::EmailConfiguration {
            crate::model::EmailConfiguration {
                from: self.from,
                content: self.content,
                recipients: self.recipients,
            }
        }
    }
}
impl EmailConfiguration {
    /// Creates a new builder-style object to manufacture [`EmailConfiguration`](crate::model::EmailConfiguration)
    pub fn builder() -> crate::model::email_configuration::Builder {
        crate::model::email_configuration::Builder::default()
    }
}

/// <p>Contains the information of one or more recipients who receive the emails.</p> <important>
/// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailRecipients {
    /// <p>Specifies one or more recipients who receive the email.</p>
    pub to: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
}
impl EmailRecipients {
    /// <p>Specifies one or more recipients who receive the email.</p>
    pub fn to(&self) -> std::option::Option<&[crate::model::RecipientDetail]> {
        self.to.as_deref()
    }
}
impl std::fmt::Debug for EmailRecipients {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailRecipients");
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`EmailRecipients`](crate::model::EmailRecipients)
pub mod email_recipients {
    /// A builder for [`EmailRecipients`](crate::model::EmailRecipients)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) to: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
    }
    impl Builder {
        /// Appends an item to `to`.
        ///
        /// To override the contents of this collection use [`set_to`](Self::set_to).
        ///
        /// <p>Specifies one or more recipients who receive the email.</p>
        pub fn to(mut self, input: crate::model::RecipientDetail) -> Self {
            let mut v = self.to.unwrap_or_default();
            v.push(input);
            self.to = Some(v);
            self
        }
        /// <p>Specifies one or more recipients who receive the email.</p>
        pub fn set_to(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
        ) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailRecipients`](crate::model::EmailRecipients)
        pub fn build(self) -> crate::model::EmailRecipients {
            crate::model::EmailRecipients { to: self.to }
        }
    }
}
impl EmailRecipients {
    /// Creates a new builder-style object to manufacture [`EmailRecipients`](crate::model::EmailRecipients)
    pub fn builder() -> crate::model::email_recipients::Builder {
        crate::model::email_recipients::Builder::default()
    }
}

/// <p>The information that identifies the recipient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipientDetail {
    /// <p>The AWS Single Sign-On (AWS SSO) authentication information.</p>
    pub sso_identity: std::option::Option<crate::model::SsoIdentity>,
}
impl RecipientDetail {
    /// <p>The AWS Single Sign-On (AWS SSO) authentication information.</p>
    pub fn sso_identity(&self) -> std::option::Option<&crate::model::SsoIdentity> {
        self.sso_identity.as_ref()
    }
}
impl std::fmt::Debug for RecipientDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipientDetail");
        formatter.field("sso_identity", &self.sso_identity);
        formatter.finish()
    }
}
/// See [`RecipientDetail`](crate::model::RecipientDetail)
pub mod recipient_detail {
    /// A builder for [`RecipientDetail`](crate::model::RecipientDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sso_identity: std::option::Option<crate::model::SsoIdentity>,
    }
    impl Builder {
        /// <p>The AWS Single Sign-On (AWS SSO) authentication information.</p>
        pub fn sso_identity(mut self, input: crate::model::SsoIdentity) -> Self {
            self.sso_identity = Some(input);
            self
        }
        /// <p>The AWS Single Sign-On (AWS SSO) authentication information.</p>
        pub fn set_sso_identity(
            mut self,
            input: std::option::Option<crate::model::SsoIdentity>,
        ) -> Self {
            self.sso_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipientDetail`](crate::model::RecipientDetail)
        pub fn build(self) -> crate::model::RecipientDetail {
            crate::model::RecipientDetail {
                sso_identity: self.sso_identity,
            }
        }
    }
}
impl RecipientDetail {
    /// Creates a new builder-style object to manufacture [`RecipientDetail`](crate::model::RecipientDetail)
    pub fn builder() -> crate::model::recipient_detail::Builder {
        crate::model::recipient_detail::Builder::default()
    }
}

/// <p>Contains information about your identity source in AWS Single Sign-On. For more information, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">AWS Single Sign-On User Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsoIdentity {
    /// <p>The ID of the AWS SSO identity store.</p>
    pub identity_store_id: std::option::Option<std::string::String>,
    /// <p>The user ID.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl SsoIdentity {
    /// <p>The ID of the AWS SSO identity store.</p>
    pub fn identity_store_id(&self) -> std::option::Option<&str> {
        self.identity_store_id.as_deref()
    }
    /// <p>The user ID.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for SsoIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsoIdentity");
        formatter.field("identity_store_id", &self.identity_store_id);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`SsoIdentity`](crate::model::SsoIdentity)
pub mod sso_identity {
    /// A builder for [`SsoIdentity`](crate::model::SsoIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_store_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the AWS SSO identity store.</p>
        pub fn identity_store_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_store_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS SSO identity store.</p>
        pub fn set_identity_store_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_store_id = input;
            self
        }
        /// <p>The user ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SsoIdentity`](crate::model::SsoIdentity)
        pub fn build(self) -> crate::model::SsoIdentity {
            crate::model::SsoIdentity {
                identity_store_id: self.identity_store_id,
                user_id: self.user_id,
            }
        }
    }
}
impl SsoIdentity {
    /// Creates a new builder-style object to manufacture [`SsoIdentity`](crate::model::SsoIdentity)
    pub fn builder() -> crate::model::sso_identity::Builder {
        crate::model::sso_identity::Builder::default()
    }
}

/// <p>Contains the subject and message of an email.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailContent {
    /// <p>The subject of the email.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The message that you want to send. The message can be up to 200 characters.</p>
    pub additional_message: std::option::Option<std::string::String>,
}
impl EmailContent {
    /// <p>The subject of the email.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The message that you want to send. The message can be up to 200 characters.</p>
    pub fn additional_message(&self) -> std::option::Option<&str> {
        self.additional_message.as_deref()
    }
}
impl std::fmt::Debug for EmailContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailContent");
        formatter.field("subject", &self.subject);
        formatter.field("additional_message", &self.additional_message);
        formatter.finish()
    }
}
/// See [`EmailContent`](crate::model::EmailContent)
pub mod email_content {
    /// A builder for [`EmailContent`](crate::model::EmailContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) additional_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subject of the email.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject of the email.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The message that you want to send. The message can be up to 200 characters.</p>
        pub fn additional_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_message = Some(input.into());
            self
        }
        /// <p>The message that you want to send. The message can be up to 200 characters.</p>
        pub fn set_additional_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_message = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailContent`](crate::model::EmailContent)
        pub fn build(self) -> crate::model::EmailContent {
            crate::model::EmailContent {
                subject: self.subject,
                additional_message: self.additional_message,
            }
        }
    }
}
impl EmailContent {
    /// Creates a new builder-style object to manufacture [`EmailContent`](crate::model::EmailContent)
    pub fn builder() -> crate::model::email_content::Builder {
        crate::model::email_content::Builder::default()
    }
}

/// <p>Contains the configuration information of SMS notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsConfiguration {
    /// <p>The sender ID.</p>
    pub sender_id: std::option::Option<std::string::String>,
    /// <p>The message that you want to send. The message can be up to 200 characters.</p>
    pub additional_message: std::option::Option<std::string::String>,
    /// <p>Specifies one or more recipients who receive the message.</p> <important>
    /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive SMS messages to your AWS SSO store</a>.</p>
    /// </important>
    pub recipients: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
}
impl SmsConfiguration {
    /// <p>The sender ID.</p>
    pub fn sender_id(&self) -> std::option::Option<&str> {
        self.sender_id.as_deref()
    }
    /// <p>The message that you want to send. The message can be up to 200 characters.</p>
    pub fn additional_message(&self) -> std::option::Option<&str> {
        self.additional_message.as_deref()
    }
    /// <p>Specifies one or more recipients who receive the message.</p> <important>
    /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive SMS messages to your AWS SSO store</a>.</p>
    /// </important>
    pub fn recipients(&self) -> std::option::Option<&[crate::model::RecipientDetail]> {
        self.recipients.as_deref()
    }
}
impl std::fmt::Debug for SmsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsConfiguration");
        formatter.field("sender_id", &self.sender_id);
        formatter.field("additional_message", &self.additional_message);
        formatter.field("recipients", &self.recipients);
        formatter.finish()
    }
}
/// See [`SmsConfiguration`](crate::model::SmsConfiguration)
pub mod sms_configuration {
    /// A builder for [`SmsConfiguration`](crate::model::SmsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sender_id: std::option::Option<std::string::String>,
        pub(crate) additional_message: std::option::Option<std::string::String>,
        pub(crate) recipients: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
    }
    impl Builder {
        /// <p>The sender ID.</p>
        pub fn sender_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_id = Some(input.into());
            self
        }
        /// <p>The sender ID.</p>
        pub fn set_sender_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender_id = input;
            self
        }
        /// <p>The message that you want to send. The message can be up to 200 characters.</p>
        pub fn additional_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_message = Some(input.into());
            self
        }
        /// <p>The message that you want to send. The message can be up to 200 characters.</p>
        pub fn set_additional_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_message = input;
            self
        }
        /// Appends an item to `recipients`.
        ///
        /// To override the contents of this collection use [`set_recipients`](Self::set_recipients).
        ///
        /// <p>Specifies one or more recipients who receive the message.</p> <important>
        /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive SMS messages to your AWS SSO store</a>.</p>
        /// </important>
        pub fn recipients(mut self, input: crate::model::RecipientDetail) -> Self {
            let mut v = self.recipients.unwrap_or_default();
            v.push(input);
            self.recipients = Some(v);
            self
        }
        /// <p>Specifies one or more recipients who receive the message.</p> <important>
        /// <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive SMS messages to your AWS SSO store</a>.</p>
        /// </important>
        pub fn set_recipients(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecipientDetail>>,
        ) -> Self {
            self.recipients = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsConfiguration`](crate::model::SmsConfiguration)
        pub fn build(self) -> crate::model::SmsConfiguration {
            crate::model::SmsConfiguration {
                sender_id: self.sender_id,
                additional_message: self.additional_message,
                recipients: self.recipients,
            }
        }
    }
}
impl SmsConfiguration {
    /// Creates a new builder-style object to manufacture [`SmsConfiguration`](crate::model::SmsConfiguration)
    pub fn builder() -> crate::model::sms_configuration::Builder {
        crate::model::sms_configuration::Builder::default()
    }
}

/// <p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationTargetActions {
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub lambda_action: std::option::Option<crate::model::LambdaAction>,
}
impl NotificationTargetActions {
    /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
    pub fn lambda_action(&self) -> std::option::Option<&crate::model::LambdaAction> {
        self.lambda_action.as_ref()
    }
}
impl std::fmt::Debug for NotificationTargetActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationTargetActions");
        formatter.field("lambda_action", &self.lambda_action);
        formatter.finish()
    }
}
/// See [`NotificationTargetActions`](crate::model::NotificationTargetActions)
pub mod notification_target_actions {
    /// A builder for [`NotificationTargetActions`](crate::model::NotificationTargetActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_action: std::option::Option<crate::model::LambdaAction>,
    }
    impl Builder {
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn lambda_action(mut self, input: crate::model::LambdaAction) -> Self {
            self.lambda_action = Some(input);
            self
        }
        /// <p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>
        pub fn set_lambda_action(
            mut self,
            input: std::option::Option<crate::model::LambdaAction>,
        ) -> Self {
            self.lambda_action = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationTargetActions`](crate::model::NotificationTargetActions)
        pub fn build(self) -> crate::model::NotificationTargetActions {
            crate::model::NotificationTargetActions {
                lambda_action: self.lambda_action,
            }
        }
    }
}
impl NotificationTargetActions {
    /// Creates a new builder-style object to manufacture [`NotificationTargetActions`](crate::model::NotificationTargetActions)
    pub fn builder() -> crate::model::notification_target_actions::Builder {
        crate::model::notification_target_actions::Builder::default()
    }
}

/// <p>Defines when your alarm is invoked.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmRule {
    /// <p>A rule that compares an input property value to a threshold value with a comparison operator.</p>
    pub simple_rule: std::option::Option<crate::model::SimpleRule>,
}
impl AlarmRule {
    /// <p>A rule that compares an input property value to a threshold value with a comparison operator.</p>
    pub fn simple_rule(&self) -> std::option::Option<&crate::model::SimpleRule> {
        self.simple_rule.as_ref()
    }
}
impl std::fmt::Debug for AlarmRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmRule");
        formatter.field("simple_rule", &self.simple_rule);
        formatter.finish()
    }
}
/// See [`AlarmRule`](crate::model::AlarmRule)
pub mod alarm_rule {
    /// A builder for [`AlarmRule`](crate::model::AlarmRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_rule: std::option::Option<crate::model::SimpleRule>,
    }
    impl Builder {
        /// <p>A rule that compares an input property value to a threshold value with a comparison operator.</p>
        pub fn simple_rule(mut self, input: crate::model::SimpleRule) -> Self {
            self.simple_rule = Some(input);
            self
        }
        /// <p>A rule that compares an input property value to a threshold value with a comparison operator.</p>
        pub fn set_simple_rule(
            mut self,
            input: std::option::Option<crate::model::SimpleRule>,
        ) -> Self {
            self.simple_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmRule`](crate::model::AlarmRule)
        pub fn build(self) -> crate::model::AlarmRule {
            crate::model::AlarmRule {
                simple_rule: self.simple_rule,
            }
        }
    }
}
impl AlarmRule {
    /// Creates a new builder-style object to manufacture [`AlarmRule`](crate::model::AlarmRule)
    pub fn builder() -> crate::model::alarm_rule::Builder {
        crate::model::alarm_rule::Builder::default()
    }
}

/// <p>A rule that compares an input property value to a threshold value with a comparison operator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleRule {
    /// <p>The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an input property.</p>
    pub input_property: std::option::Option<std::string::String>,
    /// <p>The comparison operator.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input attribute.</p>
    pub threshold: std::option::Option<std::string::String>,
}
impl SimpleRule {
    /// <p>The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an input property.</p>
    pub fn input_property(&self) -> std::option::Option<&str> {
        self.input_property.as_deref()
    }
    /// <p>The comparison operator.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input attribute.</p>
    pub fn threshold(&self) -> std::option::Option<&str> {
        self.threshold.as_deref()
    }
}
impl std::fmt::Debug for SimpleRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleRule");
        formatter.field("input_property", &self.input_property);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("threshold", &self.threshold);
        formatter.finish()
    }
}
/// See [`SimpleRule`](crate::model::SimpleRule)
pub mod simple_rule {
    /// A builder for [`SimpleRule`](crate::model::SimpleRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_property: std::option::Option<std::string::String>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) threshold: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an input property.</p>
        pub fn input_property(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_property = Some(input.into());
            self
        }
        /// <p>The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an input property.</p>
        pub fn set_input_property(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_property = input;
            self
        }
        /// <p>The comparison operator.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The comparison operator.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input attribute.</p>
        pub fn threshold(mut self, input: impl Into<std::string::String>) -> Self {
            self.threshold = Some(input.into());
            self
        }
        /// <p>The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input attribute.</p>
        pub fn set_threshold(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleRule`](crate::model::SimpleRule)
        pub fn build(self) -> crate::model::SimpleRule {
            crate::model::SimpleRule {
                input_property: self.input_property,
                comparison_operator: self.comparison_operator,
                threshold: self.threshold,
            }
        }
    }
}
impl SimpleRule {
    /// Creates a new builder-style object to manufacture [`SimpleRule`](crate::model::SimpleRule)
    pub fn builder() -> crate::model::simple_rule::Builder {
        crate::model::simple_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    Greater,
    #[allow(missing_docs)] // documentation missing in model
    GreaterOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    Less,
    #[allow(missing_docs)] // documentation missing in model
    LessOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQUAL" => ComparisonOperator::Equal,
            "GREATER" => ComparisonOperator::Greater,
            "GREATER_OR_EQUAL" => ComparisonOperator::GreaterOrEqual,
            "LESS" => ComparisonOperator::Less,
            "LESS_OR_EQUAL" => ComparisonOperator::LessOrEqual,
            "NOT_EQUAL" => ComparisonOperator::NotEqual,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::Equal => "EQUAL",
            ComparisonOperator::Greater => "GREATER",
            ComparisonOperator::GreaterOrEqual => "GREATER_OR_EQUAL",
            ComparisonOperator::Less => "LESS",
            ComparisonOperator::LessOrEqual => "LESS_OR_EQUAL",
            ComparisonOperator::NotEqual => "NOT_EQUAL",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EQUAL",
            "GREATER",
            "GREATER_OR_EQUAL",
            "LESS",
            "LESS_OR_EQUAL",
            "NOT_EQUAL",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata that can be used to manage the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The values of the AWS IoT Events logging options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingOptions {
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform logging.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The logging level.</p>
    pub level: std::option::Option<crate::model::LoggingLevel>,
    /// <p>If TRUE, logging is enabled for AWS IoT Events.</p>
    pub enabled: bool,
    /// <p>Information that identifies those detector models and their detectors (instances) for which the logging level is given.</p>
    pub detector_debug_options:
        std::option::Option<std::vec::Vec<crate::model::DetectorDebugOption>>,
}
impl LoggingOptions {
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform logging.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The logging level.</p>
    pub fn level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.level.as_ref()
    }
    /// <p>If TRUE, logging is enabled for AWS IoT Events.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Information that identifies those detector models and their detectors (instances) for which the logging level is given.</p>
    pub fn detector_debug_options(
        &self,
    ) -> std::option::Option<&[crate::model::DetectorDebugOption]> {
        self.detector_debug_options.as_deref()
    }
}
impl std::fmt::Debug for LoggingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingOptions");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("level", &self.level);
        formatter.field("enabled", &self.enabled);
        formatter.field("detector_debug_options", &self.detector_debug_options);
        formatter.finish()
    }
}
/// See [`LoggingOptions`](crate::model::LoggingOptions)
pub mod logging_options {
    /// A builder for [`LoggingOptions`](crate::model::LoggingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) level: std::option::Option<crate::model::LoggingLevel>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) detector_debug_options:
            std::option::Option<std::vec::Vec<crate::model::DetectorDebugOption>>,
    }
    impl Builder {
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform logging.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform logging.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The logging level.</p>
        pub fn level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// <p>The logging level.</p>
        pub fn set_level(mut self, input: std::option::Option<crate::model::LoggingLevel>) -> Self {
            self.level = input;
            self
        }
        /// <p>If TRUE, logging is enabled for AWS IoT Events.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If TRUE, logging is enabled for AWS IoT Events.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `detector_debug_options`.
        ///
        /// To override the contents of this collection use [`set_detector_debug_options`](Self::set_detector_debug_options).
        ///
        /// <p>Information that identifies those detector models and their detectors (instances) for which the logging level is given.</p>
        pub fn detector_debug_options(mut self, input: crate::model::DetectorDebugOption) -> Self {
            let mut v = self.detector_debug_options.unwrap_or_default();
            v.push(input);
            self.detector_debug_options = Some(v);
            self
        }
        /// <p>Information that identifies those detector models and their detectors (instances) for which the logging level is given.</p>
        pub fn set_detector_debug_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DetectorDebugOption>>,
        ) -> Self {
            self.detector_debug_options = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingOptions`](crate::model::LoggingOptions)
        pub fn build(self) -> crate::model::LoggingOptions {
            crate::model::LoggingOptions {
                role_arn: self.role_arn,
                level: self.level,
                enabled: self.enabled.unwrap_or_default(),
                detector_debug_options: self.detector_debug_options,
            }
        }
    }
}
impl LoggingOptions {
    /// Creates a new builder-style object to manufacture [`LoggingOptions`](crate::model::LoggingOptions)
    pub fn builder() -> crate::model::logging_options::Builder {
        crate::model::logging_options::Builder::default()
    }
}

/// <p>The detector model and the specific detectors (instances) for which the logging level is given.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorDebugOption {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The value of the input attribute key used to create the detector (the instance of the detector model).</p>
    pub key_value: std::option::Option<std::string::String>,
}
impl DetectorDebugOption {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The value of the input attribute key used to create the detector (the instance of the detector model).</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
}
impl std::fmt::Debug for DetectorDebugOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorDebugOption");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("key_value", &self.key_value);
        formatter.finish()
    }
}
/// See [`DetectorDebugOption`](crate::model::DetectorDebugOption)
pub mod detector_debug_option {
    /// A builder for [`DetectorDebugOption`](crate::model::DetectorDebugOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) key_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The value of the input attribute key used to create the detector (the instance of the detector model).</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value of the input attribute key used to create the detector (the instance of the detector model).</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorDebugOption`](crate::model::DetectorDebugOption)
        pub fn build(self) -> crate::model::DetectorDebugOption {
            crate::model::DetectorDebugOption {
                detector_model_name: self.detector_model_name,
                key_value: self.key_value,
            }
        }
    }
}
impl DetectorDebugOption {
    /// Creates a new builder-style object to manufacture [`DetectorDebugOption`](crate::model::DetectorDebugOption)
    pub fn builder() -> crate::model::detector_debug_option::Builder {
        crate::model::detector_debug_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggingLevel {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggingLevel {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => LoggingLevel::Debug,
            "ERROR" => LoggingLevel::Error,
            "INFO" => LoggingLevel::Info,
            other => LoggingLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggingLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggingLevel::from(s))
    }
}
impl LoggingLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggingLevel::Debug => "DEBUG",
            LoggingLevel::Error => "ERROR",
            LoggingLevel::Info => "INFO",
            LoggingLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEBUG", "ERROR", "INFO"]
    }
}
impl AsRef<str> for LoggingLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSummary {
    /// <p>The name of the input.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>A brief description of the input.</p>
    pub input_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the input.</p>
    pub input_arn: std::option::Option<std::string::String>,
    /// <p>The time the input was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the input was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the input.</p>
    pub status: std::option::Option<crate::model::InputStatus>,
}
impl InputSummary {
    /// <p>The name of the input.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>A brief description of the input.</p>
    pub fn input_description(&self) -> std::option::Option<&str> {
        self.input_description.as_deref()
    }
    /// <p>The ARN of the input.</p>
    pub fn input_arn(&self) -> std::option::Option<&str> {
        self.input_arn.as_deref()
    }
    /// <p>The time the input was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the input was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The status of the input.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::InputStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for InputSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSummary");
        formatter.field("input_name", &self.input_name);
        formatter.field("input_description", &self.input_description);
        formatter.field("input_arn", &self.input_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`InputSummary`](crate::model::InputSummary)
pub mod input_summary {
    /// A builder for [`InputSummary`](crate::model::InputSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) input_description: std::option::Option<std::string::String>,
        pub(crate) input_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::InputStatus>,
    }
    impl Builder {
        /// <p>The name of the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_description = Some(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_description = input;
            self
        }
        /// <p>The ARN of the input.</p>
        pub fn input_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the input.</p>
        pub fn set_input_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_arn = input;
            self
        }
        /// <p>The time the input was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the input was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the input was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the input was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the input.</p>
        pub fn status(mut self, input: crate::model::InputStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the input.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::InputStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSummary`](crate::model::InputSummary)
        pub fn build(self) -> crate::model::InputSummary {
            crate::model::InputSummary {
                input_name: self.input_name,
                input_description: self.input_description,
                input_arn: self.input_arn,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                status: self.status,
            }
        }
    }
}
impl InputSummary {
    /// Creates a new builder-style object to manufacture [`InputSummary`](crate::model::InputSummary)
    pub fn builder() -> crate::model::input_summary::Builder {
        crate::model::input_summary::Builder::default()
    }
}

/// <p> Contains information about the routed resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutedResource {
    /// <p> The name of the routed resource. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The ARN of the routed resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl RoutedResource {
    /// <p> The name of the routed resource. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The ARN of the routed resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for RoutedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutedResource");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`RoutedResource`](crate::model::RoutedResource)
pub mod routed_resource {
    /// A builder for [`RoutedResource`](crate::model::RoutedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the routed resource. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the routed resource. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The ARN of the routed resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the routed resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutedResource`](crate::model::RoutedResource)
        pub fn build(self) -> crate::model::RoutedResource {
            crate::model::RoutedResource {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl RoutedResource {
    /// Creates a new builder-style object to manufacture [`RoutedResource`](crate::model::RoutedResource)
    pub fn builder() -> crate::model::routed_resource::Builder {
        crate::model::routed_resource::Builder::default()
    }
}

/// <p> The identifer of the input. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputIdentifier {
    /// <p> The identifier of the input routed to AWS IoT Events. </p>
    pub iot_events_input_identifier: std::option::Option<crate::model::IotEventsInputIdentifier>,
    /// <p> The identifer of the input routed from AWS IoT SiteWise. </p>
    pub iot_site_wise_input_identifier:
        std::option::Option<crate::model::IotSiteWiseInputIdentifier>,
}
impl InputIdentifier {
    /// <p> The identifier of the input routed to AWS IoT Events. </p>
    pub fn iot_events_input_identifier(
        &self,
    ) -> std::option::Option<&crate::model::IotEventsInputIdentifier> {
        self.iot_events_input_identifier.as_ref()
    }
    /// <p> The identifer of the input routed from AWS IoT SiteWise. </p>
    pub fn iot_site_wise_input_identifier(
        &self,
    ) -> std::option::Option<&crate::model::IotSiteWiseInputIdentifier> {
        self.iot_site_wise_input_identifier.as_ref()
    }
}
impl std::fmt::Debug for InputIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputIdentifier");
        formatter.field(
            "iot_events_input_identifier",
            &self.iot_events_input_identifier,
        );
        formatter.field(
            "iot_site_wise_input_identifier",
            &self.iot_site_wise_input_identifier,
        );
        formatter.finish()
    }
}
/// See [`InputIdentifier`](crate::model::InputIdentifier)
pub mod input_identifier {
    /// A builder for [`InputIdentifier`](crate::model::InputIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iot_events_input_identifier:
            std::option::Option<crate::model::IotEventsInputIdentifier>,
        pub(crate) iot_site_wise_input_identifier:
            std::option::Option<crate::model::IotSiteWiseInputIdentifier>,
    }
    impl Builder {
        /// <p> The identifier of the input routed to AWS IoT Events. </p>
        pub fn iot_events_input_identifier(
            mut self,
            input: crate::model::IotEventsInputIdentifier,
        ) -> Self {
            self.iot_events_input_identifier = Some(input);
            self
        }
        /// <p> The identifier of the input routed to AWS IoT Events. </p>
        pub fn set_iot_events_input_identifier(
            mut self,
            input: std::option::Option<crate::model::IotEventsInputIdentifier>,
        ) -> Self {
            self.iot_events_input_identifier = input;
            self
        }
        /// <p> The identifer of the input routed from AWS IoT SiteWise. </p>
        pub fn iot_site_wise_input_identifier(
            mut self,
            input: crate::model::IotSiteWiseInputIdentifier,
        ) -> Self {
            self.iot_site_wise_input_identifier = Some(input);
            self
        }
        /// <p> The identifer of the input routed from AWS IoT SiteWise. </p>
        pub fn set_iot_site_wise_input_identifier(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseInputIdentifier>,
        ) -> Self {
            self.iot_site_wise_input_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`InputIdentifier`](crate::model::InputIdentifier)
        pub fn build(self) -> crate::model::InputIdentifier {
            crate::model::InputIdentifier {
                iot_events_input_identifier: self.iot_events_input_identifier,
                iot_site_wise_input_identifier: self.iot_site_wise_input_identifier,
            }
        }
    }
}
impl InputIdentifier {
    /// Creates a new builder-style object to manufacture [`InputIdentifier`](crate::model::InputIdentifier)
    pub fn builder() -> crate::model::input_identifier::Builder {
        crate::model::input_identifier::Builder::default()
    }
}

/// <p> The identifer of the input routed from AWS IoT SiteWise. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseInputIdentifier {
    /// <p> The identifier of the AWS IoT SiteWise asset model property. </p>
    pub iot_site_wise_asset_model_property_identifier:
        std::option::Option<crate::model::IotSiteWiseAssetModelPropertyIdentifier>,
}
impl IotSiteWiseInputIdentifier {
    /// <p> The identifier of the AWS IoT SiteWise asset model property. </p>
    pub fn iot_site_wise_asset_model_property_identifier(
        &self,
    ) -> std::option::Option<&crate::model::IotSiteWiseAssetModelPropertyIdentifier> {
        self.iot_site_wise_asset_model_property_identifier.as_ref()
    }
}
impl std::fmt::Debug for IotSiteWiseInputIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseInputIdentifier");
        formatter.field(
            "iot_site_wise_asset_model_property_identifier",
            &self.iot_site_wise_asset_model_property_identifier,
        );
        formatter.finish()
    }
}
/// See [`IotSiteWiseInputIdentifier`](crate::model::IotSiteWiseInputIdentifier)
pub mod iot_site_wise_input_identifier {
    /// A builder for [`IotSiteWiseInputIdentifier`](crate::model::IotSiteWiseInputIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iot_site_wise_asset_model_property_identifier:
            std::option::Option<crate::model::IotSiteWiseAssetModelPropertyIdentifier>,
    }
    impl Builder {
        /// <p> The identifier of the AWS IoT SiteWise asset model property. </p>
        pub fn iot_site_wise_asset_model_property_identifier(
            mut self,
            input: crate::model::IotSiteWiseAssetModelPropertyIdentifier,
        ) -> Self {
            self.iot_site_wise_asset_model_property_identifier = Some(input);
            self
        }
        /// <p> The identifier of the AWS IoT SiteWise asset model property. </p>
        pub fn set_iot_site_wise_asset_model_property_identifier(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseAssetModelPropertyIdentifier>,
        ) -> Self {
            self.iot_site_wise_asset_model_property_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseInputIdentifier`](crate::model::IotSiteWiseInputIdentifier)
        pub fn build(self) -> crate::model::IotSiteWiseInputIdentifier {
            crate::model::IotSiteWiseInputIdentifier {
                iot_site_wise_asset_model_property_identifier: self
                    .iot_site_wise_asset_model_property_identifier,
            }
        }
    }
}
impl IotSiteWiseInputIdentifier {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseInputIdentifier`](crate::model::IotSiteWiseInputIdentifier)
    pub fn builder() -> crate::model::iot_site_wise_input_identifier::Builder {
        crate::model::iot_site_wise_input_identifier::Builder::default()
    }
}

/// <p> The asset model property identifer of the input routed from AWS IoT SiteWise. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseAssetModelPropertyIdentifier {
    /// <p> The ID of the AWS IoT SiteWise asset model. </p>
    pub asset_model_id: std::option::Option<std::string::String>,
    /// <p> The ID of the AWS IoT SiteWise asset property. </p>
    pub property_id: std::option::Option<std::string::String>,
}
impl IotSiteWiseAssetModelPropertyIdentifier {
    /// <p> The ID of the AWS IoT SiteWise asset model. </p>
    pub fn asset_model_id(&self) -> std::option::Option<&str> {
        self.asset_model_id.as_deref()
    }
    /// <p> The ID of the AWS IoT SiteWise asset property. </p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
}
impl std::fmt::Debug for IotSiteWiseAssetModelPropertyIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseAssetModelPropertyIdentifier");
        formatter.field("asset_model_id", &self.asset_model_id);
        formatter.field("property_id", &self.property_id);
        formatter.finish()
    }
}
/// See [`IotSiteWiseAssetModelPropertyIdentifier`](crate::model::IotSiteWiseAssetModelPropertyIdentifier)
pub mod iot_site_wise_asset_model_property_identifier {
    /// A builder for [`IotSiteWiseAssetModelPropertyIdentifier`](crate::model::IotSiteWiseAssetModelPropertyIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset_model_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ID of the AWS IoT SiteWise asset model. </p>
        pub fn asset_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_model_id = Some(input.into());
            self
        }
        /// <p> The ID of the AWS IoT SiteWise asset model. </p>
        pub fn set_asset_model_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.asset_model_id = input;
            self
        }
        /// <p> The ID of the AWS IoT SiteWise asset property. </p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p> The ID of the AWS IoT SiteWise asset property. </p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseAssetModelPropertyIdentifier`](crate::model::IotSiteWiseAssetModelPropertyIdentifier)
        pub fn build(self) -> crate::model::IotSiteWiseAssetModelPropertyIdentifier {
            crate::model::IotSiteWiseAssetModelPropertyIdentifier {
                asset_model_id: self.asset_model_id,
                property_id: self.property_id,
            }
        }
    }
}
impl IotSiteWiseAssetModelPropertyIdentifier {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseAssetModelPropertyIdentifier`](crate::model::IotSiteWiseAssetModelPropertyIdentifier)
    pub fn builder() -> crate::model::iot_site_wise_asset_model_property_identifier::Builder {
        crate::model::iot_site_wise_asset_model_property_identifier::Builder::default()
    }
}

/// <p> The identifier of the input routed to AWS IoT Events. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotEventsInputIdentifier {
    /// <p> The name of the input routed to AWS IoT Events. </p>
    pub input_name: std::option::Option<std::string::String>,
}
impl IotEventsInputIdentifier {
    /// <p> The name of the input routed to AWS IoT Events. </p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
}
impl std::fmt::Debug for IotEventsInputIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotEventsInputIdentifier");
        formatter.field("input_name", &self.input_name);
        formatter.finish()
    }
}
/// See [`IotEventsInputIdentifier`](crate::model::IotEventsInputIdentifier)
pub mod iot_events_input_identifier {
    /// A builder for [`IotEventsInputIdentifier`](crate::model::IotEventsInputIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the input routed to AWS IoT Events. </p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p> The name of the input routed to AWS IoT Events. </p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IotEventsInputIdentifier`](crate::model::IotEventsInputIdentifier)
        pub fn build(self) -> crate::model::IotEventsInputIdentifier {
            crate::model::IotEventsInputIdentifier {
                input_name: self.input_name,
            }
        }
    }
}
impl IotEventsInputIdentifier {
    /// Creates a new builder-style object to manufacture [`IotEventsInputIdentifier`](crate::model::IotEventsInputIdentifier)
    pub fn builder() -> crate::model::iot_events_input_identifier::Builder {
        crate::model::iot_events_input_identifier::Builder::default()
    }
}

/// <p>Information about the detector model version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorModelVersionSummary {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The ID of the detector model version.</p>
    pub detector_model_version: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector model version.</p>
    pub detector_model_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants the detector model permission to perform its tasks.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The time the detector model version was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the detector model version was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the detector model version.</p>
    pub status: std::option::Option<crate::model::DetectorModelVersionStatus>,
    /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
    pub evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
}
impl DetectorModelVersionSummary {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The ID of the detector model version.</p>
    pub fn detector_model_version(&self) -> std::option::Option<&str> {
        self.detector_model_version.as_deref()
    }
    /// <p>The ARN of the detector model version.</p>
    pub fn detector_model_arn(&self) -> std::option::Option<&str> {
        self.detector_model_arn.as_deref()
    }
    /// <p>The ARN of the role that grants the detector model permission to perform its tasks.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The time the detector model version was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the detector model version was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The status of the detector model version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetectorModelVersionStatus> {
        self.status.as_ref()
    }
    /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
    pub fn evaluation_method(&self) -> std::option::Option<&crate::model::EvaluationMethod> {
        self.evaluation_method.as_ref()
    }
}
impl std::fmt::Debug for DetectorModelVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorModelVersionSummary");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("detector_model_version", &self.detector_model_version);
        formatter.field("detector_model_arn", &self.detector_model_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.field("evaluation_method", &self.evaluation_method);
        formatter.finish()
    }
}
/// See [`DetectorModelVersionSummary`](crate::model::DetectorModelVersionSummary)
pub mod detector_model_version_summary {
    /// A builder for [`DetectorModelVersionSummary`](crate::model::DetectorModelVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_version: std::option::Option<std::string::String>,
        pub(crate) detector_model_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::DetectorModelVersionStatus>,
        pub(crate) evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The ID of the detector model version.</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_version = Some(input.into());
            self
        }
        /// <p>The ID of the detector model version.</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_version = input;
            self
        }
        /// <p>The ARN of the detector model version.</p>
        pub fn detector_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector model version.</p>
        pub fn set_detector_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_arn = input;
            self
        }
        /// <p>The ARN of the role that grants the detector model permission to perform its tasks.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants the detector model permission to perform its tasks.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The time the detector model version was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the detector model version was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the detector model version was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the detector model version was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the detector model version.</p>
        pub fn status(mut self, input: crate::model::DetectorModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the detector model version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectorModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.evaluation_method = Some(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.evaluation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorModelVersionSummary`](crate::model::DetectorModelVersionSummary)
        pub fn build(self) -> crate::model::DetectorModelVersionSummary {
            crate::model::DetectorModelVersionSummary {
                detector_model_name: self.detector_model_name,
                detector_model_version: self.detector_model_version,
                detector_model_arn: self.detector_model_arn,
                role_arn: self.role_arn,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                status: self.status,
                evaluation_method: self.evaluation_method,
            }
        }
    }
}
impl DetectorModelVersionSummary {
    /// Creates a new builder-style object to manufacture [`DetectorModelVersionSummary`](crate::model::DetectorModelVersionSummary)
    pub fn builder() -> crate::model::detector_model_version_summary::Builder {
        crate::model::detector_model_version_summary::Builder::default()
    }
}

/// <p>Information about the detector model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorModelSummary {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>A brief description of the detector model.</p>
    pub detector_model_description: std::option::Option<std::string::String>,
    /// <p>The time the detector model was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DetectorModelSummary {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>A brief description of the detector model.</p>
    pub fn detector_model_description(&self) -> std::option::Option<&str> {
        self.detector_model_description.as_deref()
    }
    /// <p>The time the detector model was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DetectorModelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorModelSummary");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field(
            "detector_model_description",
            &self.detector_model_description,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DetectorModelSummary`](crate::model::DetectorModelSummary)
pub mod detector_model_summary {
    /// A builder for [`DetectorModelSummary`](crate::model::DetectorModelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_description = Some(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_description = input;
            self
        }
        /// <p>The time the detector model was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the detector model was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorModelSummary`](crate::model::DetectorModelSummary)
        pub fn build(self) -> crate::model::DetectorModelSummary {
            crate::model::DetectorModelSummary {
                detector_model_name: self.detector_model_name,
                detector_model_description: self.detector_model_description,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DetectorModelSummary {
    /// Creates a new builder-style object to manufacture [`DetectorModelSummary`](crate::model::DetectorModelSummary)
    pub fn builder() -> crate::model::detector_model_summary::Builder {
        crate::model::detector_model_summary::Builder::default()
    }
}

/// <p>Contains a summary of an alarm model version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmModelVersionSummary {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub alarm_model_arn: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the alarm model. The status can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>
    /// <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>
    /// <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>
    /// <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AlarmModelVersionStatus>,
    /// <p> Contains information about the status of the alarm model version. </p>
    pub status_message: std::option::Option<std::string::String>,
}
impl AlarmModelVersionSummary {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn alarm_model_arn(&self) -> std::option::Option<&str> {
        self.alarm_model_arn.as_deref()
    }
    /// <p>The version of the alarm model.</p>
    pub fn alarm_model_version(&self) -> std::option::Option<&str> {
        self.alarm_model_version.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The status of the alarm model. The status can be one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>
    /// <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>
    /// <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>
    /// <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::AlarmModelVersionStatus> {
        self.status.as_ref()
    }
    /// <p> Contains information about the status of the alarm model version. </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
}
impl std::fmt::Debug for AlarmModelVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmModelVersionSummary");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_arn", &self.alarm_model_arn);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`AlarmModelVersionSummary`](crate::model::AlarmModelVersionSummary)
pub mod alarm_model_version_summary {
    /// A builder for [`AlarmModelVersionSummary`](crate::model::AlarmModelVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AlarmModelVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn alarm_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_alarm_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_arn = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>
        /// <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>
        /// <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>
        /// <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AlarmModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>
        /// <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>
        /// <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>
        /// <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlarmModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Contains information about the status of the alarm model version. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p> Contains information about the status of the alarm model version. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmModelVersionSummary`](crate::model::AlarmModelVersionSummary)
        pub fn build(self) -> crate::model::AlarmModelVersionSummary {
            crate::model::AlarmModelVersionSummary {
                alarm_model_name: self.alarm_model_name,
                alarm_model_arn: self.alarm_model_arn,
                alarm_model_version: self.alarm_model_version,
                role_arn: self.role_arn,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl AlarmModelVersionSummary {
    /// Creates a new builder-style object to manufacture [`AlarmModelVersionSummary`](crate::model::AlarmModelVersionSummary)
    pub fn builder() -> crate::model::alarm_model_version_summary::Builder {
        crate::model::alarm_model_version_summary::Builder::default()
    }
}

/// <p>Contains a summary of an alarm model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmModelSummary {
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the alarm model.</p>
    pub alarm_model_description: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
}
impl AlarmModelSummary {
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of the alarm model.</p>
    pub fn alarm_model_description(&self) -> std::option::Option<&str> {
        self.alarm_model_description.as_deref()
    }
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
}
impl std::fmt::Debug for AlarmModelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmModelSummary");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("alarm_model_description", &self.alarm_model_description);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.finish()
    }
}
/// See [`AlarmModelSummary`](crate::model::AlarmModelSummary)
pub mod alarm_model_summary {
    /// A builder for [`AlarmModelSummary`](crate::model::AlarmModelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) alarm_model_description: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_description = Some(input.into());
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_description = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmModelSummary`](crate::model::AlarmModelSummary)
        pub fn build(self) -> crate::model::AlarmModelSummary {
            crate::model::AlarmModelSummary {
                creation_time: self.creation_time,
                alarm_model_description: self.alarm_model_description,
                alarm_model_name: self.alarm_model_name,
            }
        }
    }
}
impl AlarmModelSummary {
    /// Creates a new builder-style object to manufacture [`AlarmModelSummary`](crate::model::AlarmModelSummary)
    pub fn builder() -> crate::model::alarm_model_summary::Builder {
        crate::model::alarm_model_summary::Builder::default()
    }
}

/// <p>Contains the result of the analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisResult {
    /// <p>The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:</p>
    /// <ul>
    /// <li> <p> <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.</p> </li>
    /// <li> <p> <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.</p> </li>
    /// <li> <p> <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports. </p> </li>
    /// <li> <p> <code>expression-syntax</code> - Your expression must follow the required syntax.</p> </li>
    /// <li> <p> <code>data-type</code> - Data types referenced in the detector model must be compatible.</p> </li>
    /// <li> <p> <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the data.</p> </li>
    /// <li> <p> <code>referenced-resource</code> - Resources that the detector model uses must be available.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:</p>
    /// <ul>
    /// <li> <p> <code>INFO</code> - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.</p> </li>
    /// <li> <p> <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.</p> </li>
    /// <li> <p> <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.</p> </li>
    /// </ul>
    pub level: std::option::Option<crate::model::AnalysisResultLevel>,
    /// <p>Contains additional information about the analysis result.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.</p>
    pub locations: std::option::Option<std::vec::Vec<crate::model::AnalysisResultLocation>>,
}
impl AnalysisResult {
    /// <p>The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:</p>
    /// <ul>
    /// <li> <p> <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.</p> </li>
    /// <li> <p> <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.</p> </li>
    /// <li> <p> <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports. </p> </li>
    /// <li> <p> <code>expression-syntax</code> - Your expression must follow the required syntax.</p> </li>
    /// <li> <p> <code>data-type</code> - Data types referenced in the detector model must be compatible.</p> </li>
    /// <li> <p> <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the data.</p> </li>
    /// <li> <p> <code>referenced-resource</code> - Resources that the detector model uses must be available.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:</p>
    /// <ul>
    /// <li> <p> <code>INFO</code> - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.</p> </li>
    /// <li> <p> <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.</p> </li>
    /// <li> <p> <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.</p> </li>
    /// </ul>
    pub fn level(&self) -> std::option::Option<&crate::model::AnalysisResultLevel> {
        self.level.as_ref()
    }
    /// <p>Contains additional information about the analysis result.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.</p>
    pub fn locations(&self) -> std::option::Option<&[crate::model::AnalysisResultLocation]> {
        self.locations.as_deref()
    }
}
impl std::fmt::Debug for AnalysisResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisResult");
        formatter.field("r#type", &self.r#type);
        formatter.field("level", &self.level);
        formatter.field("message", &self.message);
        formatter.field("locations", &self.locations);
        formatter.finish()
    }
}
/// See [`AnalysisResult`](crate::model::AnalysisResult)
pub mod analysis_result {
    /// A builder for [`AnalysisResult`](crate::model::AnalysisResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) level: std::option::Option<crate::model::AnalysisResultLevel>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) locations:
            std::option::Option<std::vec::Vec<crate::model::AnalysisResultLocation>>,
    }
    impl Builder {
        /// <p>The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:</p>
        /// <ul>
        /// <li> <p> <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.</p> </li>
        /// <li> <p> <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.</p> </li>
        /// <li> <p> <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports. </p> </li>
        /// <li> <p> <code>expression-syntax</code> - Your expression must follow the required syntax.</p> </li>
        /// <li> <p> <code>data-type</code> - Data types referenced in the detector model must be compatible.</p> </li>
        /// <li> <p> <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the data.</p> </li>
        /// <li> <p> <code>referenced-resource</code> - Resources that the detector model uses must be available.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:</p>
        /// <ul>
        /// <li> <p> <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.</p> </li>
        /// <li> <p> <code>service-limits</code> - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.</p> </li>
        /// <li> <p> <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports. </p> </li>
        /// <li> <p> <code>expression-syntax</code> - Your expression must follow the required syntax.</p> </li>
        /// <li> <p> <code>data-type</code> - Data types referenced in the detector model must be compatible.</p> </li>
        /// <li> <p> <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the data.</p> </li>
        /// <li> <p> <code>referenced-resource</code> - Resources that the detector model uses must be available.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:</p>
        /// <ul>
        /// <li> <p> <code>INFO</code> - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.</p> </li>
        /// <li> <p> <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.</p> </li>
        /// <li> <p> <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.</p> </li>
        /// </ul>
        pub fn level(mut self, input: crate::model::AnalysisResultLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// <p>The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:</p>
        /// <ul>
        /// <li> <p> <code>INFO</code> - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.</p> </li>
        /// <li> <p> <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.</p> </li>
        /// <li> <p> <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.</p> </li>
        /// </ul>
        pub fn set_level(
            mut self,
            input: std::option::Option<crate::model::AnalysisResultLevel>,
        ) -> Self {
            self.level = input;
            self
        }
        /// <p>Contains additional information about the analysis result.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Contains additional information about the analysis result.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `locations`.
        ///
        /// To override the contents of this collection use [`set_locations`](Self::set_locations).
        ///
        /// <p>Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.</p>
        pub fn locations(mut self, input: crate::model::AnalysisResultLocation) -> Self {
            let mut v = self.locations.unwrap_or_default();
            v.push(input);
            self.locations = Some(v);
            self
        }
        /// <p>Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.</p>
        pub fn set_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisResultLocation>>,
        ) -> Self {
            self.locations = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisResult`](crate::model::AnalysisResult)
        pub fn build(self) -> crate::model::AnalysisResult {
            crate::model::AnalysisResult {
                r#type: self.r#type,
                level: self.level,
                message: self.message,
                locations: self.locations,
            }
        }
    }
}
impl AnalysisResult {
    /// Creates a new builder-style object to manufacture [`AnalysisResult`](crate::model::AnalysisResult)
    pub fn builder() -> crate::model::analysis_result::Builder {
        crate::model::analysis_result::Builder::default()
    }
}

/// <p>Contains information that you can use to locate the field in your detector model that the analysis result references.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisResultLocation {
    /// <p>A <a href="https://github.com/json-path/JsonPath">JsonPath</a> expression that identifies the error field in your detector model.</p>
    pub path: std::option::Option<std::string::String>,
}
impl AnalysisResultLocation {
    /// <p>A <a href="https://github.com/json-path/JsonPath">JsonPath</a> expression that identifies the error field in your detector model.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for AnalysisResultLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisResultLocation");
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`AnalysisResultLocation`](crate::model::AnalysisResultLocation)
pub mod analysis_result_location {
    /// A builder for [`AnalysisResultLocation`](crate::model::AnalysisResultLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <a href="https://github.com/json-path/JsonPath">JsonPath</a> expression that identifies the error field in your detector model.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>A <a href="https://github.com/json-path/JsonPath">JsonPath</a> expression that identifies the error field in your detector model.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisResultLocation`](crate::model::AnalysisResultLocation)
        pub fn build(self) -> crate::model::AnalysisResultLocation {
            crate::model::AnalysisResultLocation { path: self.path }
        }
    }
}
impl AnalysisResultLocation {
    /// Creates a new builder-style object to manufacture [`AnalysisResultLocation`](crate::model::AnalysisResultLocation)
    pub fn builder() -> crate::model::analysis_result_location::Builder {
        crate::model::analysis_result_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisResultLevel {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisResultLevel {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => AnalysisResultLevel::Error,
            "INFO" => AnalysisResultLevel::Info,
            "WARNING" => AnalysisResultLevel::Warning,
            other => AnalysisResultLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisResultLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisResultLevel::from(s))
    }
}
impl AnalysisResultLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisResultLevel::Error => "ERROR",
            AnalysisResultLevel::Info => "INFO",
            AnalysisResultLevel::Warning => "WARNING",
            AnalysisResultLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "INFO", "WARNING"]
    }
}
impl AsRef<str> for AnalysisResultLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Input {
    /// <p>Information about the configuration of an input.</p>
    pub input_configuration: std::option::Option<crate::model::InputConfiguration>,
    /// <p>The definition of the input.</p>
    pub input_definition: std::option::Option<crate::model::InputDefinition>,
}
impl Input {
    /// <p>Information about the configuration of an input.</p>
    pub fn input_configuration(&self) -> std::option::Option<&crate::model::InputConfiguration> {
        self.input_configuration.as_ref()
    }
    /// <p>The definition of the input.</p>
    pub fn input_definition(&self) -> std::option::Option<&crate::model::InputDefinition> {
        self.input_definition.as_ref()
    }
}
impl std::fmt::Debug for Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Input");
        formatter.field("input_configuration", &self.input_configuration);
        formatter.field("input_definition", &self.input_definition);
        formatter.finish()
    }
}
/// See [`Input`](crate::model::Input)
pub mod input {
    /// A builder for [`Input`](crate::model::Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_configuration: std::option::Option<crate::model::InputConfiguration>,
        pub(crate) input_definition: std::option::Option<crate::model::InputDefinition>,
    }
    impl Builder {
        /// <p>Information about the configuration of an input.</p>
        pub fn input_configuration(mut self, input: crate::model::InputConfiguration) -> Self {
            self.input_configuration = Some(input);
            self
        }
        /// <p>Information about the configuration of an input.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::InputConfiguration>,
        ) -> Self {
            self.input_configuration = input;
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, input: crate::model::InputDefinition) -> Self {
            self.input_definition = Some(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.input_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`Input`](crate::model::Input)
        pub fn build(self) -> crate::model::Input {
            crate::model::Input {
                input_configuration: self.input_configuration,
                input_definition: self.input_definition,
            }
        }
    }
}
impl Input {
    /// Creates a new builder-style object to manufacture [`Input`](crate::model::Input)
    pub fn builder() -> crate::model::input::Builder {
        crate::model::input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => AnalysisStatus::Complete,
            "FAILED" => AnalysisStatus::Failed,
            "RUNNING" => AnalysisStatus::Running,
            other => AnalysisStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisStatus::from(s))
    }
}
impl AnalysisStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisStatus::Complete => "COMPLETE",
            AnalysisStatus::Failed => "FAILED",
            AnalysisStatus::Running => "RUNNING",
            AnalysisStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "RUNNING"]
    }
}
impl AsRef<str> for AnalysisStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the detector model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectorModel {
    /// <p>Information that defines how a detector operates.</p>
    pub detector_model_definition: std::option::Option<crate::model::DetectorModelDefinition>,
    /// <p>Information about how the detector is configured.</p>
    pub detector_model_configuration: std::option::Option<crate::model::DetectorModelConfiguration>,
}
impl DetectorModel {
    /// <p>Information that defines how a detector operates.</p>
    pub fn detector_model_definition(
        &self,
    ) -> std::option::Option<&crate::model::DetectorModelDefinition> {
        self.detector_model_definition.as_ref()
    }
    /// <p>Information about how the detector is configured.</p>
    pub fn detector_model_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DetectorModelConfiguration> {
        self.detector_model_configuration.as_ref()
    }
}
impl std::fmt::Debug for DetectorModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectorModel");
        formatter.field("detector_model_definition", &self.detector_model_definition);
        formatter.field(
            "detector_model_configuration",
            &self.detector_model_configuration,
        );
        formatter.finish()
    }
}
/// See [`DetectorModel`](crate::model::DetectorModel)
pub mod detector_model {
    /// A builder for [`DetectorModel`](crate::model::DetectorModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_definition:
            std::option::Option<crate::model::DetectorModelDefinition>,
        pub(crate) detector_model_configuration:
            std::option::Option<crate::model::DetectorModelConfiguration>,
    }
    impl Builder {
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.detector_model_definition = Some(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.detector_model_definition = input;
            self
        }
        /// <p>Information about how the detector is configured.</p>
        pub fn detector_model_configuration(
            mut self,
            input: crate::model::DetectorModelConfiguration,
        ) -> Self {
            self.detector_model_configuration = Some(input);
            self
        }
        /// <p>Information about how the detector is configured.</p>
        pub fn set_detector_model_configuration(
            mut self,
            input: std::option::Option<crate::model::DetectorModelConfiguration>,
        ) -> Self {
            self.detector_model_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectorModel`](crate::model::DetectorModel)
        pub fn build(self) -> crate::model::DetectorModel {
            crate::model::DetectorModel {
                detector_model_definition: self.detector_model_definition,
                detector_model_configuration: self.detector_model_configuration,
            }
        }
    }
}
impl DetectorModel {
    /// Creates a new builder-style object to manufacture [`DetectorModel`](crate::model::DetectorModel)
    pub fn builder() -> crate::model::detector_model::Builder {
        crate::model::detector_model::Builder::default()
    }
}
