// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS IoT Events
///
/// Client for invoking operations on AWS IoT Events. Each operation on AWS IoT Events is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotevents::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotevents::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotevents::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateAlarmModel` operation.
    ///
    /// See [`CreateAlarmModel`](crate::client::fluent_builders::CreateAlarmModel) for more information about the
    /// operation and its arguments.
    pub fn create_alarm_model(&self) -> fluent_builders::CreateAlarmModel<C, M, R> {
        fluent_builders::CreateAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDetectorModel` operation.
    ///
    /// See [`CreateDetectorModel`](crate::client::fluent_builders::CreateDetectorModel) for more information about the
    /// operation and its arguments.
    pub fn create_detector_model(&self) -> fluent_builders::CreateDetectorModel<C, M, R> {
        fluent_builders::CreateDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInput` operation.
    ///
    /// See [`CreateInput`](crate::client::fluent_builders::CreateInput) for more information about the
    /// operation and its arguments.
    pub fn create_input(&self) -> fluent_builders::CreateInput<C, M, R> {
        fluent_builders::CreateInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlarmModel` operation.
    ///
    /// See [`DeleteAlarmModel`](crate::client::fluent_builders::DeleteAlarmModel) for more information about the
    /// operation and its arguments.
    pub fn delete_alarm_model(&self) -> fluent_builders::DeleteAlarmModel<C, M, R> {
        fluent_builders::DeleteAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDetectorModel` operation.
    ///
    /// See [`DeleteDetectorModel`](crate::client::fluent_builders::DeleteDetectorModel) for more information about the
    /// operation and its arguments.
    pub fn delete_detector_model(&self) -> fluent_builders::DeleteDetectorModel<C, M, R> {
        fluent_builders::DeleteDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInput` operation.
    ///
    /// See [`DeleteInput`](crate::client::fluent_builders::DeleteInput) for more information about the
    /// operation and its arguments.
    pub fn delete_input(&self) -> fluent_builders::DeleteInput<C, M, R> {
        fluent_builders::DeleteInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAlarmModel` operation.
    ///
    /// See [`DescribeAlarmModel`](crate::client::fluent_builders::DescribeAlarmModel) for more information about the
    /// operation and its arguments.
    pub fn describe_alarm_model(&self) -> fluent_builders::DescribeAlarmModel<C, M, R> {
        fluent_builders::DescribeAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDetectorModel` operation.
    ///
    /// See [`DescribeDetectorModel`](crate::client::fluent_builders::DescribeDetectorModel) for more information about the
    /// operation and its arguments.
    pub fn describe_detector_model(&self) -> fluent_builders::DescribeDetectorModel<C, M, R> {
        fluent_builders::DescribeDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDetectorModelAnalysis` operation.
    ///
    /// See [`DescribeDetectorModelAnalysis`](crate::client::fluent_builders::DescribeDetectorModelAnalysis) for more information about the
    /// operation and its arguments.
    pub fn describe_detector_model_analysis(
        &self,
    ) -> fluent_builders::DescribeDetectorModelAnalysis<C, M, R> {
        fluent_builders::DescribeDetectorModelAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInput` operation.
    ///
    /// See [`DescribeInput`](crate::client::fluent_builders::DescribeInput) for more information about the
    /// operation and its arguments.
    pub fn describe_input(&self) -> fluent_builders::DescribeInput<C, M, R> {
        fluent_builders::DescribeInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoggingOptions` operation.
    ///
    /// See [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions<C, M, R> {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDetectorModelAnalysisResults` operation.
    ///
    /// See [`GetDetectorModelAnalysisResults`](crate::client::fluent_builders::GetDetectorModelAnalysisResults) for more information about the
    /// operation and its arguments.
    pub fn get_detector_model_analysis_results(
        &self,
    ) -> fluent_builders::GetDetectorModelAnalysisResults<C, M, R> {
        fluent_builders::GetDetectorModelAnalysisResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAlarmModels` operation.
    ///
    /// See [`ListAlarmModels`](crate::client::fluent_builders::ListAlarmModels) for more information about the
    /// operation and its arguments.
    pub fn list_alarm_models(&self) -> fluent_builders::ListAlarmModels<C, M, R> {
        fluent_builders::ListAlarmModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAlarmModelVersions` operation.
    ///
    /// See [`ListAlarmModelVersions`](crate::client::fluent_builders::ListAlarmModelVersions) for more information about the
    /// operation and its arguments.
    pub fn list_alarm_model_versions(&self) -> fluent_builders::ListAlarmModelVersions<C, M, R> {
        fluent_builders::ListAlarmModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDetectorModels` operation.
    ///
    /// See [`ListDetectorModels`](crate::client::fluent_builders::ListDetectorModels) for more information about the
    /// operation and its arguments.
    pub fn list_detector_models(&self) -> fluent_builders::ListDetectorModels<C, M, R> {
        fluent_builders::ListDetectorModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDetectorModelVersions` operation.
    ///
    /// See [`ListDetectorModelVersions`](crate::client::fluent_builders::ListDetectorModelVersions) for more information about the
    /// operation and its arguments.
    pub fn list_detector_model_versions(
        &self,
    ) -> fluent_builders::ListDetectorModelVersions<C, M, R> {
        fluent_builders::ListDetectorModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputRoutings` operation.
    ///
    /// See [`ListInputRoutings`](crate::client::fluent_builders::ListInputRoutings) for more information about the
    /// operation and its arguments.
    pub fn list_input_routings(&self) -> fluent_builders::ListInputRoutings<C, M, R> {
        fluent_builders::ListInputRoutings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInputs` operation.
    ///
    /// See [`ListInputs`](crate::client::fluent_builders::ListInputs) for more information about the
    /// operation and its arguments.
    pub fn list_inputs(&self) -> fluent_builders::ListInputs<C, M, R> {
        fluent_builders::ListInputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLoggingOptions` operation.
    ///
    /// See [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions<C, M, R> {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDetectorModelAnalysis` operation.
    ///
    /// See [`StartDetectorModelAnalysis`](crate::client::fluent_builders::StartDetectorModelAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_detector_model_analysis(
        &self,
    ) -> fluent_builders::StartDetectorModelAnalysis<C, M, R> {
        fluent_builders::StartDetectorModelAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAlarmModel` operation.
    ///
    /// See [`UpdateAlarmModel`](crate::client::fluent_builders::UpdateAlarmModel) for more information about the
    /// operation and its arguments.
    pub fn update_alarm_model(&self) -> fluent_builders::UpdateAlarmModel<C, M, R> {
        fluent_builders::UpdateAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDetectorModel` operation.
    ///
    /// See [`UpdateDetectorModel`](crate::client::fluent_builders::UpdateDetectorModel) for more information about the
    /// operation and its arguments.
    pub fn update_detector_model(&self) -> fluent_builders::UpdateDetectorModel<C, M, R> {
        fluent_builders::UpdateDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInput` operation.
    ///
    /// See [`UpdateInput`](crate::client::fluent_builders::UpdateInput) for more information about the
    /// operation and its arguments.
    pub fn update_input(&self) -> fluent_builders::UpdateInput<C, M, R> {
        fluent_builders::UpdateInput::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAlarmModel`.
    ///
    /// <p>Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get
    /// notified when the value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an
    /// alarm model</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAlarmModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alarm_model_input::Builder,
    }
    impl<C, M, R> CreateAlarmModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlarmModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAlarmModelInputOperationOutputAlias,
                crate::output::CreateAlarmModelOutput,
                crate::error::CreateAlarmModelError,
                crate::input::CreateAlarmModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after
        /// you create the alarm model.</p>
        pub fn alarm_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(inp);
            self
        }
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after
        /// you create the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn alarm_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_description(inp);
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_description(input);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
        /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
        /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
        /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
        /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(inp);
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, inp: i32) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, inp: crate::model::AlarmRule) -> Self {
            self.inner = self.inner.alarm_rule(inp);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.inner = self.inner.set_alarm_rule(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, inp: crate::model::AlarmNotification) -> Self {
            self.inner = self.inner.alarm_notification(inp);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.inner = self.inner.set_alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, inp: crate::model::AlarmEventActions) -> Self {
            self.inner = self.inner.alarm_event_actions(inp);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.inner = self.inner.set_alarm_event_actions(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, inp: crate::model::AlarmCapabilities) -> Self {
            self.inner = self.inner.alarm_capabilities(inp);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.inner = self.inner.set_alarm_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDetectorModel`.
    ///
    /// <p>Creates a detector model.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDetectorModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_detector_model_input::Builder,
    }
    impl<C, M, R> CreateDetectorModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDetectorModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDetectorModelInputOperationOutputAlias,
                crate::output::CreateDetectorModelOutput,
                crate::error::CreateDetectorModelError,
                crate::input::CreateDetectorModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(inp);
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn detector_model_definition(
            mut self,
            inp: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(inp);
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_description(inp);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_description(input);
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an
        /// instance of the detector model) and then to route each input received to the appropriate
        /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
        /// input to specify the attribute-value pair that is used to identify the device associated with
        /// the input.</p>
        pub fn key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(inp);
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an
        /// instance of the detector model) and then to route each input received to the appropriate
        /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
        /// input to specify the attribute-value pair that is used to identify the device associated with
        /// the input.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn evaluation_method(mut self, inp: crate::model::EvaluationMethod) -> Self {
            self.inner = self.inner.evaluation_method(inp);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInput`.
    ///
    /// <p>Creates an input.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_input_input::Builder,
    }
    impl<C, M, R> CreateInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInputInputOperationOutputAlias,
                crate::output::CreateInputOutput,
                crate::error::CreateInputError,
                crate::input::CreateInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you want to give to the input.</p>
        pub fn input_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(inp);
            self
        }
        /// <p>The name you want to give to the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_description(inp);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_description(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, inp: crate::model::InputDefinition) -> Self {
            self.inner = self.inner.input_definition(inp);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.inner = self.inner.set_input_definition(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlarmModel`.
    ///
    /// <p>Deletes an alarm model. Any alarm instances that were created based on this alarm model
    /// are also deleted. This action can't be undone.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlarmModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alarm_model_input::Builder,
    }
    impl<C, M, R> DeleteAlarmModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlarmModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlarmModelInputOperationOutputAlias,
                crate::output::DeleteAlarmModelOutput,
                crate::error::DeleteAlarmModelError,
                crate::input::DeleteAlarmModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(inp);
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetectorModel`.
    ///
    /// <p>Deletes a detector model. Any active instances of the detector model are also
    /// deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDetectorModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_detector_model_input::Builder,
    }
    impl<C, M, R> DeleteDetectorModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDetectorModelInputOperationOutputAlias,
                crate::output::DeleteDetectorModelOutput,
                crate::error::DeleteDetectorModelError,
                crate::input::DeleteDetectorModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model to be deleted.</p>
        pub fn detector_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(inp);
            self
        }
        /// <p>The name of the detector model to be deleted.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInput`.
    ///
    /// <p>Deletes an input.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_input_input::Builder,
    }
    impl<C, M, R> DeleteInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInputInputOperationOutputAlias,
                crate::output::DeleteInputOutput,
                crate::error::DeleteInputError,
                crate::input::DeleteInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input to delete.</p>
        pub fn input_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(inp);
            self
        }
        /// <p>The name of the input to delete.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlarmModel`.
    ///
    /// <p>Retrieves information about an alarm model. If you don't specify a value for the
    /// <code>alarmModelVersion</code> parameter, the latest version is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAlarmModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_alarm_model_input::Builder,
    }
    impl<C, M, R> DescribeAlarmModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlarmModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlarmModelInputOperationOutputAlias,
                crate::output::DescribeAlarmModelOutput,
                crate::error::DescribeAlarmModelError,
                crate::input::DescribeAlarmModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(inp);
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_version(inp);
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectorModel`.
    ///
    /// <p>Describes a detector model. If the <code>version</code> parameter is not specified,
    /// information about the latest version is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDetectorModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_detector_model_input::Builder,
    }
    impl<C, M, R> DescribeDetectorModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDetectorModelInputOperationOutputAlias,
                crate::output::DescribeDetectorModelOutput,
                crate::error::DescribeDetectorModelError,
                crate::input::DescribeDetectorModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(inp);
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn detector_model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_version(inp);
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectorModelAnalysis`.
    ///
    /// <p>Retrieves runtime information about a detector model analysis.</p>
    /// <note>
    /// <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDetectorModelAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_detector_model_analysis_input::Builder,
    }
    impl<C, M, R> DescribeDetectorModelAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDetectorModelAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorModelAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorModelAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDetectorModelAnalysisInputOperationOutputAlias,
                crate::output::DescribeDetectorModelAnalysisOutput,
                crate::error::DescribeDetectorModelAnalysisError,
                crate::input::DescribeDetectorModelAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInput`.
    ///
    /// <p>Describes an input.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_input_input::Builder,
    }
    impl<C, M, R> DescribeInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInputInputOperationOutputAlias,
                crate::output::DescribeInputOutput,
                crate::error::DescribeInputError,
                crate::input::DescribeInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input.</p>
        pub fn input_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(inp);
            self
        }
        /// <p>The name of the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current settings of the AWS IoT Events logging options.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl<C, M, R> DescribeLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoggingOptionsInputOperationOutputAlias,
                crate::output::DescribeLoggingOptionsOutput,
                crate::error::DescribeLoggingOptionsError,
                crate::input::DescribeLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDetectorModelAnalysisResults`.
    ///
    /// <p>Retrieves one or more analysis results of the detector model.</p>
    /// <note>
    /// <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDetectorModelAnalysisResults<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_detector_model_analysis_results_input::Builder,
    }
    impl<C, M, R> GetDetectorModelAnalysisResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDetectorModelAnalysisResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorModelAnalysisResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorModelAnalysisResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDetectorModelAnalysisResultsInputOperationOutputAlias,
                crate::output::GetDetectorModelAnalysisResultsOutput,
                crate::error::GetDetectorModelAnalysisResultsError,
                crate::input::GetDetectorModelAnalysisResultsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmModels`.
    ///
    /// <p>Lists the alarm models that you created. The operation returns only the metadata
    /// associated with each alarm model.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAlarmModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_alarm_models_input::Builder,
    }
    impl<C, M, R> ListAlarmModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAlarmModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAlarmModelsInputOperationOutputAlias,
                crate::output::ListAlarmModelsOutput,
                crate::error::ListAlarmModelsError,
                crate::input::ListAlarmModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmModelVersions`.
    ///
    /// <p>Lists all the versions of an alarm model. The operation returns only the metadata
    /// associated with each alarm model version.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAlarmModelVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_alarm_model_versions_input::Builder,
    }
    impl<C, M, R> ListAlarmModelVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAlarmModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmModelVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAlarmModelVersionsInputOperationOutputAlias,
                crate::output::ListAlarmModelVersionsOutput,
                crate::error::ListAlarmModelVersionsError,
                crate::input::ListAlarmModelVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(inp);
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectorModels`.
    ///
    /// <p>Lists the detector models you have created. Only the metadata associated with each
    /// detector model is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDetectorModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_detector_models_input::Builder,
    }
    impl<C, M, R> ListDetectorModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDetectorModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectorModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectorModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDetectorModelsInputOperationOutputAlias,
                crate::output::ListDetectorModelsOutput,
                crate::error::ListDetectorModelsError,
                crate::input::ListDetectorModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectorModelVersions`.
    ///
    /// <p>Lists all the versions of a detector model. Only the metadata associated with each
    /// detector model version is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDetectorModelVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_detector_model_versions_input::Builder,
    }
    impl<C, M, R> ListDetectorModelVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDetectorModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectorModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectorModelVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDetectorModelVersionsInputOperationOutputAlias,
                crate::output::ListDetectorModelVersionsOutput,
                crate::error::ListDetectorModelVersionsError,
                crate::input::ListDetectorModelVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn detector_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(inp);
            self
        }
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputRoutings`.
    ///
    /// <p>
    /// Lists one or more input routings.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListInputRoutings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_input_routings_input::Builder,
    }
    impl<C, M, R> ListInputRoutings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputRoutings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputRoutingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputRoutingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputRoutingsInputOperationOutputAlias,
                crate::output::ListInputRoutingsOutput,
                crate::error::ListInputRoutingsError,
                crate::input::ListInputRoutingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifer of the routed input.
        /// </p>
        pub fn input_identifier(mut self, inp: crate::model::InputIdentifier) -> Self {
            self.inner = self.inner.input_identifier(inp);
            self
        }
        /// <p>
        /// The identifer of the routed input.
        /// </p>
        pub fn set_input_identifier(
            mut self,
            input: std::option::Option<crate::model::InputIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_input_identifier(input);
            self
        }
        /// <p>
        /// The maximum number of results to be returned per request.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to be returned per request.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputs`.
    ///
    /// <p>Lists the inputs you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInputs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_inputs_input::Builder,
    }
    impl<C, M, R> ListInputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInputsInputOperationOutputAlias,
                crate::output::ListInputsOutput,
                crate::error::ListInputsError,
                crate::input::ListInputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) you have assigned to the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets or updates the AWS IoT Events logging options.</p>
    /// <p>If you update the value of any <code>loggingOptions</code> field, it takes up to one
    /// minute for the change to take effect. If you change the policy attached to the role you
    /// specified in the <code>roleArn</code> field (for example, to correct an invalid policy), it
    /// takes up to five minutes for that change to take effect.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl<C, M, R> PutLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLoggingOptionsInputOperationOutputAlias,
                crate::output::PutLoggingOptionsOutput,
                crate::error::PutLoggingOptionsError,
                crate::input::PutLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn logging_options(mut self, inp: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(inp);
            self
        }
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDetectorModelAnalysis`.
    ///
    /// <p>Performs an analysis of your detector model. For more information,
    /// see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Troubleshooting a detector model</a>
    /// in the <i>AWS IoT Events Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDetectorModelAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_detector_model_analysis_input::Builder,
    }
    impl<C, M, R> StartDetectorModelAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDetectorModelAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDetectorModelAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDetectorModelAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDetectorModelAnalysisInputOperationOutputAlias,
                crate::output::StartDetectorModelAnalysisOutput,
                crate::error::StartDetectorModelAnalysisError,
                crate::input::StartDetectorModelAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            inp: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(inp);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to
    /// manage a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the given tags (metadata) from the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAlarmModel`.
    ///
    /// <p>Updates an alarm model. Any alarms that were created based on the previous version are
    /// deleted and then created again as new data arrives.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAlarmModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_alarm_model_input::Builder,
    }
    impl<C, M, R> UpdateAlarmModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAlarmModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAlarmModelInputOperationOutputAlias,
                crate::output::UpdateAlarmModelOutput,
                crate::error::UpdateAlarmModelError,
                crate::input::UpdateAlarmModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(inp);
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn alarm_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_description(inp);
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_description(input);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, inp: i32) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, inp: crate::model::AlarmRule) -> Self {
            self.inner = self.inner.alarm_rule(inp);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.inner = self.inner.set_alarm_rule(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, inp: crate::model::AlarmNotification) -> Self {
            self.inner = self.inner.alarm_notification(inp);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.inner = self.inner.set_alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, inp: crate::model::AlarmEventActions) -> Self {
            self.inner = self.inner.alarm_event_actions(inp);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.inner = self.inner.set_alarm_event_actions(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, inp: crate::model::AlarmCapabilities) -> Self {
            self.inner = self.inner.alarm_capabilities(inp);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.inner = self.inner.set_alarm_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorModel`.
    ///
    /// <p>Updates a detector model. Detectors (instances) spawned by the previous version are
    /// deleted and then re-created as new inputs arrive.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDetectorModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_detector_model_input::Builder,
    }
    impl<C, M, R> UpdateDetectorModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDetectorModelInputOperationOutputAlias,
                crate::output::UpdateDetectorModelOutput,
                crate::error::UpdateDetectorModelError,
                crate::input::UpdateDetectorModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model that is updated.</p>
        pub fn detector_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(inp);
            self
        }
        /// <p>The name of the detector model that is updated.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            inp: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(inp);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_description(inp);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_description(input);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn evaluation_method(mut self, inp: crate::model::EvaluationMethod) -> Self {
            self.inner = self.inner.evaluation_method(inp);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInput`.
    ///
    /// <p>Updates an input.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_input_input::Builder,
    }
    impl<C, M, R> UpdateInput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInputInputOperationOutputAlias,
                crate::output::UpdateInputOutput,
                crate::error::UpdateInputError,
                crate::input::UpdateInputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input you want to update.</p>
        pub fn input_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(inp);
            self
        }
        /// <p>The name of the input you want to update.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_description(inp);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_description(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, inp: crate::model::InputDefinition) -> Self {
            self.inner = self.inner.input_definition(inp);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.inner = self.inner.set_input_definition(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
