// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Events
///
/// Client for invoking operations on AWS IoT Events. Each operation on AWS IoT Events is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotevents::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_iotevents::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_iotevents::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAlarmModel`](crate::client::fluent_builders::CreateAlarmModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alarm_model_name(impl Into<String>)`](crate::client::fluent_builders::CreateAlarmModel::alarm_model_name) / [`set_alarm_model_name(Option<String>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_model_name): <p>A unique name that helps you identify the alarm model. You can't change this name after you create the alarm model.</p>
    ///   - [`alarm_model_description(impl Into<String>)`](crate::client::fluent_builders::CreateAlarmModel::alarm_model_description) / [`set_alarm_model_description(Option<String>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_model_description): <p>A description that tells you what the alarm model detects.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAlarmModel::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateAlarmModel::set_role_arn): <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAlarmModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAlarmModel::set_tags): <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>  <p>You can create up to 50 tags for one alarm model.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CreateAlarmModel::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CreateAlarmModel::set_key): <p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>
    ///   - [`severity(i32)`](crate::client::fluent_builders::CreateAlarmModel::severity) / [`set_severity(Option<i32>)`](crate::client::fluent_builders::CreateAlarmModel::set_severity): <p>A non-negative integer that reflects the severity level of the alarm.</p>
    ///   - [`alarm_rule(AlarmRule)`](crate::client::fluent_builders::CreateAlarmModel::alarm_rule) / [`set_alarm_rule(Option<AlarmRule>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_rule): <p>Defines when your alarm is invoked.</p>
    ///   - [`alarm_notification(AlarmNotification)`](crate::client::fluent_builders::CreateAlarmModel::alarm_notification) / [`set_alarm_notification(Option<AlarmNotification>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_notification): <p>Contains information about one or more notification actions.</p>
    ///   - [`alarm_event_actions(AlarmEventActions)`](crate::client::fluent_builders::CreateAlarmModel::alarm_event_actions) / [`set_alarm_event_actions(Option<AlarmEventActions>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_event_actions): <p>Contains information about one or more alarm actions.</p>
    ///   - [`alarm_capabilities(AlarmCapabilities)`](crate::client::fluent_builders::CreateAlarmModel::alarm_capabilities) / [`set_alarm_capabilities(Option<AlarmCapabilities>)`](crate::client::fluent_builders::CreateAlarmModel::set_alarm_capabilities): <p>Contains the configuration information of alarm state changes.</p>
    /// - On success, responds with [`CreateAlarmModelOutput`](crate::output::CreateAlarmModelOutput) with field(s):
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateAlarmModelOutput::creation_time): <p>The time the alarm model was created, in the Unix epoch format.</p>
    ///   - [`alarm_model_arn(Option<String>)`](crate::output::CreateAlarmModelOutput::alarm_model_arn): <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`alarm_model_version(Option<String>)`](crate::output::CreateAlarmModelOutput::alarm_model_version): <p>The version of the alarm model.</p>
    ///   - [`last_update_time(Option<DateTime>)`](crate::output::CreateAlarmModelOutput::last_update_time): <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    ///   - [`status(Option<AlarmModelVersionStatus>)`](crate::output::CreateAlarmModelOutput::status): <p>The status of the alarm model. The status can be one of the following values:</p>  <ul>   <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>   <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>   <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>   <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateAlarmModelError>`](crate::error::CreateAlarmModelError)
    pub fn create_alarm_model(&self) -> fluent_builders::CreateAlarmModel {
        fluent_builders::CreateAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDetectorModel`](crate::client::fluent_builders::CreateDetectorModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_name(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorModel::detector_model_name) / [`set_detector_model_name(Option<String>)`](crate::client::fluent_builders::CreateDetectorModel::set_detector_model_name): <p>The name of the detector model.</p>
    ///   - [`detector_model_definition(DetectorModelDefinition)`](crate::client::fluent_builders::CreateDetectorModel::detector_model_definition) / [`set_detector_model_definition(Option<DetectorModelDefinition>)`](crate::client::fluent_builders::CreateDetectorModel::set_detector_model_definition): <p>Information that defines how the detectors operate.</p>
    ///   - [`detector_model_description(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorModel::detector_model_description) / [`set_detector_model_description(Option<String>)`](crate::client::fluent_builders::CreateDetectorModel::set_detector_model_description): <p>A brief description of the detector model.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorModel::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CreateDetectorModel::set_key): <p>The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDetectorModel::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDetectorModel::set_role_arn): <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDetectorModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDetectorModel::set_tags): <p>Metadata that can be used to manage the detector model.</p>
    ///   - [`evaluation_method(EvaluationMethod)`](crate::client::fluent_builders::CreateDetectorModel::evaluation_method) / [`set_evaluation_method(Option<EvaluationMethod>)`](crate::client::fluent_builders::CreateDetectorModel::set_evaluation_method): <p>Information about the order in which events are evaluated and how actions are executed. </p>
    /// - On success, responds with [`CreateDetectorModelOutput`](crate::output::CreateDetectorModelOutput) with field(s):
    ///   - [`detector_model_configuration(Option<DetectorModelConfiguration>)`](crate::output::CreateDetectorModelOutput::detector_model_configuration): <p>Information about how the detector model is configured.</p>
    /// - On failure, responds with [`SdkError<CreateDetectorModelError>`](crate::error::CreateDetectorModelError)
    pub fn create_detector_model(&self) -> fluent_builders::CreateDetectorModel {
        fluent_builders::CreateDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInput`](crate::client::fluent_builders::CreateInput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_name(impl Into<String>)`](crate::client::fluent_builders::CreateInput::input_name) / [`set_input_name(Option<String>)`](crate::client::fluent_builders::CreateInput::set_input_name): <p>The name you want to give to the input.</p>
    ///   - [`input_description(impl Into<String>)`](crate::client::fluent_builders::CreateInput::input_description) / [`set_input_description(Option<String>)`](crate::client::fluent_builders::CreateInput::set_input_description): <p>A brief description of the input.</p>
    ///   - [`input_definition(InputDefinition)`](crate::client::fluent_builders::CreateInput::input_definition) / [`set_input_definition(Option<InputDefinition>)`](crate::client::fluent_builders::CreateInput::set_input_definition): <p>The definition of the input.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateInput::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateInput::set_tags): <p>Metadata that can be used to manage the input.</p>
    /// - On success, responds with [`CreateInputOutput`](crate::output::CreateInputOutput) with field(s):
    ///   - [`input_configuration(Option<InputConfiguration>)`](crate::output::CreateInputOutput::input_configuration): <p>Information about the configuration of the input.</p>
    /// - On failure, responds with [`SdkError<CreateInputError>`](crate::error::CreateInputError)
    pub fn create_input(&self) -> fluent_builders::CreateInput {
        fluent_builders::CreateInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAlarmModel`](crate::client::fluent_builders::DeleteAlarmModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alarm_model_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAlarmModel::alarm_model_name) / [`set_alarm_model_name(Option<String>)`](crate::client::fluent_builders::DeleteAlarmModel::set_alarm_model_name): <p>The name of the alarm model.</p>
    /// - On success, responds with [`DeleteAlarmModelOutput`](crate::output::DeleteAlarmModelOutput)

    /// - On failure, responds with [`SdkError<DeleteAlarmModelError>`](crate::error::DeleteAlarmModelError)
    pub fn delete_alarm_model(&self) -> fluent_builders::DeleteAlarmModel {
        fluent_builders::DeleteAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDetectorModel`](crate::client::fluent_builders::DeleteDetectorModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDetectorModel::detector_model_name) / [`set_detector_model_name(Option<String>)`](crate::client::fluent_builders::DeleteDetectorModel::set_detector_model_name): <p>The name of the detector model to be deleted.</p>
    /// - On success, responds with [`DeleteDetectorModelOutput`](crate::output::DeleteDetectorModelOutput)

    /// - On failure, responds with [`SdkError<DeleteDetectorModelError>`](crate::error::DeleteDetectorModelError)
    pub fn delete_detector_model(&self) -> fluent_builders::DeleteDetectorModel {
        fluent_builders::DeleteDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInput`](crate::client::fluent_builders::DeleteInput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_name(impl Into<String>)`](crate::client::fluent_builders::DeleteInput::input_name) / [`set_input_name(Option<String>)`](crate::client::fluent_builders::DeleteInput::set_input_name): <p>The name of the input to delete.</p>
    /// - On success, responds with [`DeleteInputOutput`](crate::output::DeleteInputOutput)

    /// - On failure, responds with [`SdkError<DeleteInputError>`](crate::error::DeleteInputError)
    pub fn delete_input(&self) -> fluent_builders::DeleteInput {
        fluent_builders::DeleteInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAlarmModel`](crate::client::fluent_builders::DescribeAlarmModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alarm_model_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAlarmModel::alarm_model_name) / [`set_alarm_model_name(Option<String>)`](crate::client::fluent_builders::DescribeAlarmModel::set_alarm_model_name): <p>The name of the alarm model.</p>
    ///   - [`alarm_model_version(impl Into<String>)`](crate::client::fluent_builders::DescribeAlarmModel::alarm_model_version) / [`set_alarm_model_version(Option<String>)`](crate::client::fluent_builders::DescribeAlarmModel::set_alarm_model_version): <p>The version of the alarm model.</p>
    /// - On success, responds with [`DescribeAlarmModelOutput`](crate::output::DescribeAlarmModelOutput) with field(s):
    ///   - [`creation_time(Option<DateTime>)`](crate::output::DescribeAlarmModelOutput::creation_time): <p>The time the alarm model was created, in the Unix epoch format.</p>
    ///   - [`alarm_model_arn(Option<String>)`](crate::output::DescribeAlarmModelOutput::alarm_model_arn): <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`alarm_model_version(Option<String>)`](crate::output::DescribeAlarmModelOutput::alarm_model_version): <p>The version of the alarm model.</p>
    ///   - [`last_update_time(Option<DateTime>)`](crate::output::DescribeAlarmModelOutput::last_update_time): <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    ///   - [`status(Option<AlarmModelVersionStatus>)`](crate::output::DescribeAlarmModelOutput::status): <p>The status of the alarm model. The status can be one of the following values:</p>  <ul>   <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>   <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>   <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>   <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>  </ul>
    ///   - [`status_message(Option<String>)`](crate::output::DescribeAlarmModelOutput::status_message): <p> Contains information about the status of the alarm model. </p>
    ///   - [`alarm_model_name(Option<String>)`](crate::output::DescribeAlarmModelOutput::alarm_model_name): <p>The name of the alarm model.</p>
    ///   - [`alarm_model_description(Option<String>)`](crate::output::DescribeAlarmModelOutput::alarm_model_description): <p>The description of the alarm model.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeAlarmModelOutput::role_arn): <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`key(Option<String>)`](crate::output::DescribeAlarmModelOutput::key): <p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>
    ///   - [`severity(Option<i32>)`](crate::output::DescribeAlarmModelOutput::severity): <p>A non-negative integer that reflects the severity level of the alarm.</p>
    ///   - [`alarm_rule(Option<AlarmRule>)`](crate::output::DescribeAlarmModelOutput::alarm_rule): <p>Defines when your alarm is invoked.</p>
    ///   - [`alarm_notification(Option<AlarmNotification>)`](crate::output::DescribeAlarmModelOutput::alarm_notification): <p>Contains information about one or more notification actions.</p>
    ///   - [`alarm_event_actions(Option<AlarmEventActions>)`](crate::output::DescribeAlarmModelOutput::alarm_event_actions): <p>Contains information about one or more alarm actions.</p>
    ///   - [`alarm_capabilities(Option<AlarmCapabilities>)`](crate::output::DescribeAlarmModelOutput::alarm_capabilities): <p>Contains the configuration information of alarm state changes.</p>
    /// - On failure, responds with [`SdkError<DescribeAlarmModelError>`](crate::error::DescribeAlarmModelError)
    pub fn describe_alarm_model(&self) -> fluent_builders::DescribeAlarmModel {
        fluent_builders::DescribeAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDetectorModel`](crate::client::fluent_builders::DescribeDetectorModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDetectorModel::detector_model_name) / [`set_detector_model_name(Option<String>)`](crate::client::fluent_builders::DescribeDetectorModel::set_detector_model_name): <p>The name of the detector model.</p>
    ///   - [`detector_model_version(impl Into<String>)`](crate::client::fluent_builders::DescribeDetectorModel::detector_model_version) / [`set_detector_model_version(Option<String>)`](crate::client::fluent_builders::DescribeDetectorModel::set_detector_model_version): <p>The version of the detector model.</p>
    /// - On success, responds with [`DescribeDetectorModelOutput`](crate::output::DescribeDetectorModelOutput) with field(s):
    ///   - [`detector_model(Option<DetectorModel>)`](crate::output::DescribeDetectorModelOutput::detector_model): <p>Information about the detector model.</p>
    /// - On failure, responds with [`SdkError<DescribeDetectorModelError>`](crate::error::DescribeDetectorModelError)
    pub fn describe_detector_model(&self) -> fluent_builders::DescribeDetectorModel {
        fluent_builders::DescribeDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDetectorModelAnalysis`](crate::client::fluent_builders::DescribeDetectorModelAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDetectorModelAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::DescribeDetectorModelAnalysis::set_analysis_id): <p>The ID of the analysis result that you want to retrieve.</p>
    /// - On success, responds with [`DescribeDetectorModelAnalysisOutput`](crate::output::DescribeDetectorModelAnalysisOutput) with field(s):
    ///   - [`status(Option<AnalysisStatus>)`](crate::output::DescribeDetectorModelAnalysisOutput::status): <p>The status of the analysis activity. The status can be one of the following values:</p>  <ul>   <li> <p> <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes to complete.</p> </li>   <li> <p> <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.</p> </li>   <li> <p> <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again later.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeDetectorModelAnalysisError>`](crate::error::DescribeDetectorModelAnalysisError)
    pub fn describe_detector_model_analysis(
        &self,
    ) -> fluent_builders::DescribeDetectorModelAnalysis {
        fluent_builders::DescribeDetectorModelAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInput`](crate::client::fluent_builders::DescribeInput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_name(impl Into<String>)`](crate::client::fluent_builders::DescribeInput::input_name) / [`set_input_name(Option<String>)`](crate::client::fluent_builders::DescribeInput::set_input_name): <p>The name of the input.</p>
    /// - On success, responds with [`DescribeInputOutput`](crate::output::DescribeInputOutput) with field(s):
    ///   - [`input(Option<Input>)`](crate::output::DescribeInputOutput::input): <p>Information about the input.</p>
    /// - On failure, responds with [`SdkError<DescribeInputError>`](crate::error::DescribeInputError)
    pub fn describe_input(&self) -> fluent_builders::DescribeInput {
        fluent_builders::DescribeInput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeLoggingOptions::send) it.

    /// - On success, responds with [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput) with field(s):
    ///   - [`logging_options(Option<LoggingOptions>)`](crate::output::DescribeLoggingOptionsOutput::logging_options): <p>The current settings of the AWS IoT Events logging options.</p>
    /// - On failure, responds with [`SdkError<DescribeLoggingOptionsError>`](crate::error::DescribeLoggingOptionsError)
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDetectorModelAnalysisResults`](crate::client::fluent_builders::GetDetectorModelAnalysisResults) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::set_analysis_id): <p>The ID of the analysis result that you want to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDetectorModelAnalysisResults::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`GetDetectorModelAnalysisResultsOutput`](crate::output::GetDetectorModelAnalysisResultsOutput) with field(s):
    ///   - [`analysis_results(Option<Vec<AnalysisResult>>)`](crate::output::GetDetectorModelAnalysisResultsOutput::analysis_results): <p>Contains information about one or more analysis results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDetectorModelAnalysisResultsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<GetDetectorModelAnalysisResultsError>`](crate::error::GetDetectorModelAnalysisResultsError)
    pub fn get_detector_model_analysis_results(
        &self,
    ) -> fluent_builders::GetDetectorModelAnalysisResults {
        fluent_builders::GetDetectorModelAnalysisResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAlarmModels`](crate::client::fluent_builders::ListAlarmModels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAlarmModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAlarmModels::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAlarmModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAlarmModels::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListAlarmModelsOutput`](crate::output::ListAlarmModelsOutput) with field(s):
    ///   - [`alarm_model_summaries(Option<Vec<AlarmModelSummary>>)`](crate::output::ListAlarmModelsOutput::alarm_model_summaries): <p>A list that summarizes each alarm model.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAlarmModelsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAlarmModelsError>`](crate::error::ListAlarmModelsError)
    pub fn list_alarm_models(&self) -> fluent_builders::ListAlarmModels {
        fluent_builders::ListAlarmModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAlarmModelVersions`](crate::client::fluent_builders::ListAlarmModelVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alarm_model_name(impl Into<String>)`](crate::client::fluent_builders::ListAlarmModelVersions::alarm_model_name) / [`set_alarm_model_name(Option<String>)`](crate::client::fluent_builders::ListAlarmModelVersions::set_alarm_model_name): <p>The name of the alarm model.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAlarmModelVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAlarmModelVersions::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAlarmModelVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAlarmModelVersions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListAlarmModelVersionsOutput`](crate::output::ListAlarmModelVersionsOutput) with field(s):
    ///   - [`alarm_model_version_summaries(Option<Vec<AlarmModelVersionSummary>>)`](crate::output::ListAlarmModelVersionsOutput::alarm_model_version_summaries): <p>A list that summarizes each alarm model version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAlarmModelVersionsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAlarmModelVersionsError>`](crate::error::ListAlarmModelVersionsError)
    pub fn list_alarm_model_versions(&self) -> fluent_builders::ListAlarmModelVersions {
        fluent_builders::ListAlarmModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDetectorModels`](crate::client::fluent_builders::ListDetectorModels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDetectorModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDetectorModels::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDetectorModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDetectorModels::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDetectorModelsOutput`](crate::output::ListDetectorModelsOutput) with field(s):
    ///   - [`detector_model_summaries(Option<Vec<DetectorModelSummary>>)`](crate::output::ListDetectorModelsOutput::detector_model_summaries): <p>Summary information about the detector models.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDetectorModelsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListDetectorModelsError>`](crate::error::ListDetectorModelsError)
    pub fn list_detector_models(&self) -> fluent_builders::ListDetectorModels {
        fluent_builders::ListDetectorModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDetectorModelVersions`](crate::client::fluent_builders::ListDetectorModelVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_name(impl Into<String>)`](crate::client::fluent_builders::ListDetectorModelVersions::detector_model_name) / [`set_detector_model_name(Option<String>)`](crate::client::fluent_builders::ListDetectorModelVersions::set_detector_model_name): <p>The name of the detector model whose versions are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDetectorModelVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDetectorModelVersions::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDetectorModelVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDetectorModelVersions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDetectorModelVersionsOutput`](crate::output::ListDetectorModelVersionsOutput) with field(s):
    ///   - [`detector_model_version_summaries(Option<Vec<DetectorModelVersionSummary>>)`](crate::output::ListDetectorModelVersionsOutput::detector_model_version_summaries): <p>Summary information about the detector model versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDetectorModelVersionsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListDetectorModelVersionsError>`](crate::error::ListDetectorModelVersionsError)
    pub fn list_detector_model_versions(&self) -> fluent_builders::ListDetectorModelVersions {
        fluent_builders::ListDetectorModelVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInputRoutings`](crate::client::fluent_builders::ListInputRoutings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_identifier(InputIdentifier)`](crate::client::fluent_builders::ListInputRoutings::input_identifier) / [`set_input_identifier(Option<InputIdentifier>)`](crate::client::fluent_builders::ListInputRoutings::set_input_identifier): <p> The identifer of the routed input. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInputRoutings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInputRoutings::set_max_results): <p> The maximum number of results to be returned per request. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInputRoutings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInputRoutings::set_next_token): <p> The token that you can use to return the next set of results. </p>
    /// - On success, responds with [`ListInputRoutingsOutput`](crate::output::ListInputRoutingsOutput) with field(s):
    ///   - [`routed_resources(Option<Vec<RoutedResource>>)`](crate::output::ListInputRoutingsOutput::routed_resources): <p> Summary information about the routed resources. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInputRoutingsOutput::next_token): <p> The token that you can use to return the next set of results, or <code>null</code> if there are no more results. </p>
    /// - On failure, responds with [`SdkError<ListInputRoutingsError>`](crate::error::ListInputRoutingsError)
    pub fn list_input_routings(&self) -> fluent_builders::ListInputRoutings {
        fluent_builders::ListInputRoutings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInputs`](crate::client::fluent_builders::ListInputs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInputs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInputs::set_next_token): <p>The token that you can use to return the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInputs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInputs::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListInputsOutput`](crate::output::ListInputsOutput) with field(s):
    ///   - [`input_summaries(Option<Vec<InputSummary>>)`](crate::output::ListInputsOutput::input_summaries): <p>Summary information about the inputs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInputsOutput::next_token): <p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListInputsError>`](crate::error::ListInputsError)
    pub fn list_inputs(&self) -> fluent_builders::ListInputs {
        fluent_builders::ListInputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags assigned to the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_options(LoggingOptions)`](crate::client::fluent_builders::PutLoggingOptions::logging_options) / [`set_logging_options(Option<LoggingOptions>)`](crate::client::fluent_builders::PutLoggingOptions::set_logging_options): <p>The new values of the AWS IoT Events logging options.</p>
    /// - On success, responds with [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutLoggingOptionsError>`](crate::error::PutLoggingOptionsError)
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDetectorModelAnalysis`](crate::client::fluent_builders::StartDetectorModelAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_definition(DetectorModelDefinition)`](crate::client::fluent_builders::StartDetectorModelAnalysis::detector_model_definition) / [`set_detector_model_definition(Option<DetectorModelDefinition>)`](crate::client::fluent_builders::StartDetectorModelAnalysis::set_detector_model_definition): <p>Information that defines how a detector operates.</p>
    /// - On success, responds with [`StartDetectorModelAnalysisOutput`](crate::output::StartDetectorModelAnalysisOutput) with field(s):
    ///   - [`analysis_id(Option<String>)`](crate::output::StartDetectorModelAnalysisOutput::analysis_id): <p>The ID that you can use to retrieve the analysis result.</p>
    /// - On failure, responds with [`SdkError<StartDetectorModelAnalysisError>`](crate::error::StartDetectorModelAnalysisError)
    pub fn start_detector_model_analysis(&self) -> fluent_builders::StartDetectorModelAnalysis {
        fluent_builders::StartDetectorModelAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The new or modified tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of the keys of the tags to be removed from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAlarmModel`](crate::client::fluent_builders::UpdateAlarmModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alarm_model_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_model_name) / [`set_alarm_model_name(Option<String>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_model_name): <p>The name of the alarm model.</p>
    ///   - [`alarm_model_description(impl Into<String>)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_model_description) / [`set_alarm_model_description(Option<String>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_model_description): <p>The description of the alarm model.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAlarmModel::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateAlarmModel::set_role_arn): <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`severity(i32)`](crate::client::fluent_builders::UpdateAlarmModel::severity) / [`set_severity(Option<i32>)`](crate::client::fluent_builders::UpdateAlarmModel::set_severity): <p>A non-negative integer that reflects the severity level of the alarm.</p>
    ///   - [`alarm_rule(AlarmRule)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_rule) / [`set_alarm_rule(Option<AlarmRule>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_rule): <p>Defines when your alarm is invoked.</p>
    ///   - [`alarm_notification(AlarmNotification)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_notification) / [`set_alarm_notification(Option<AlarmNotification>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_notification): <p>Contains information about one or more notification actions.</p>
    ///   - [`alarm_event_actions(AlarmEventActions)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_event_actions) / [`set_alarm_event_actions(Option<AlarmEventActions>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_event_actions): <p>Contains information about one or more alarm actions.</p>
    ///   - [`alarm_capabilities(AlarmCapabilities)`](crate::client::fluent_builders::UpdateAlarmModel::alarm_capabilities) / [`set_alarm_capabilities(Option<AlarmCapabilities>)`](crate::client::fluent_builders::UpdateAlarmModel::set_alarm_capabilities): <p>Contains the configuration information of alarm state changes.</p>
    /// - On success, responds with [`UpdateAlarmModelOutput`](crate::output::UpdateAlarmModelOutput) with field(s):
    ///   - [`creation_time(Option<DateTime>)`](crate::output::UpdateAlarmModelOutput::creation_time): <p>The time the alarm model was created, in the Unix epoch format.</p>
    ///   - [`alarm_model_arn(Option<String>)`](crate::output::UpdateAlarmModelOutput::alarm_model_arn): <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`alarm_model_version(Option<String>)`](crate::output::UpdateAlarmModelOutput::alarm_model_version): <p>The version of the alarm model.</p>
    ///   - [`last_update_time(Option<DateTime>)`](crate::output::UpdateAlarmModelOutput::last_update_time): <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    ///   - [`status(Option<AlarmModelVersionStatus>)`](crate::output::UpdateAlarmModelOutput::status): <p>The status of the alarm model. The status can be one of the following values:</p>  <ul>   <li> <p> <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p> </li>   <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li>   <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li>   <li> <p> <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try again.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<UpdateAlarmModelError>`](crate::error::UpdateAlarmModelError)
    pub fn update_alarm_model(&self) -> fluent_builders::UpdateAlarmModel {
        fluent_builders::UpdateAlarmModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDetectorModel`](crate::client::fluent_builders::UpdateDetectorModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`detector_model_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorModel::detector_model_name) / [`set_detector_model_name(Option<String>)`](crate::client::fluent_builders::UpdateDetectorModel::set_detector_model_name): <p>The name of the detector model that is updated.</p>
    ///   - [`detector_model_definition(DetectorModelDefinition)`](crate::client::fluent_builders::UpdateDetectorModel::detector_model_definition) / [`set_detector_model_definition(Option<DetectorModelDefinition>)`](crate::client::fluent_builders::UpdateDetectorModel::set_detector_model_definition): <p>Information that defines how a detector operates.</p>
    ///   - [`detector_model_description(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorModel::detector_model_description) / [`set_detector_model_description(Option<String>)`](crate::client::fluent_builders::UpdateDetectorModel::set_detector_model_description): <p>A brief description of the detector model.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDetectorModel::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateDetectorModel::set_role_arn): <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    ///   - [`evaluation_method(EvaluationMethod)`](crate::client::fluent_builders::UpdateDetectorModel::evaluation_method) / [`set_evaluation_method(Option<EvaluationMethod>)`](crate::client::fluent_builders::UpdateDetectorModel::set_evaluation_method): <p>Information about the order in which events are evaluated and how actions are executed. </p>
    /// - On success, responds with [`UpdateDetectorModelOutput`](crate::output::UpdateDetectorModelOutput) with field(s):
    ///   - [`detector_model_configuration(Option<DetectorModelConfiguration>)`](crate::output::UpdateDetectorModelOutput::detector_model_configuration): <p>Information about how the detector model is configured.</p>
    /// - On failure, responds with [`SdkError<UpdateDetectorModelError>`](crate::error::UpdateDetectorModelError)
    pub fn update_detector_model(&self) -> fluent_builders::UpdateDetectorModel {
        fluent_builders::UpdateDetectorModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInput`](crate::client::fluent_builders::UpdateInput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input_name(impl Into<String>)`](crate::client::fluent_builders::UpdateInput::input_name) / [`set_input_name(Option<String>)`](crate::client::fluent_builders::UpdateInput::set_input_name): <p>The name of the input you want to update.</p>
    ///   - [`input_description(impl Into<String>)`](crate::client::fluent_builders::UpdateInput::input_description) / [`set_input_description(Option<String>)`](crate::client::fluent_builders::UpdateInput::set_input_description): <p>A brief description of the input.</p>
    ///   - [`input_definition(InputDefinition)`](crate::client::fluent_builders::UpdateInput::input_definition) / [`set_input_definition(Option<InputDefinition>)`](crate::client::fluent_builders::UpdateInput::set_input_definition): <p>The definition of the input.</p>
    /// - On success, responds with [`UpdateInputOutput`](crate::output::UpdateInputOutput) with field(s):
    ///   - [`input_configuration(Option<InputConfiguration>)`](crate::output::UpdateInputOutput::input_configuration): <p>Information about the configuration of the input.</p>
    /// - On failure, responds with [`SdkError<UpdateInputError>`](crate::error::UpdateInputError)
    pub fn update_input(&self) -> fluent_builders::UpdateInput {
        fluent_builders::UpdateInput::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAlarmModel`.
    ///
    /// <p>Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an alarm model</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlarmModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_alarm_model_input::Builder,
    }
    impl CreateAlarmModel {
        /// Creates a new `CreateAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlarmModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after you create the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(input.into());
            self
        }
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after you create the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_description(input.into());
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_description(input);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.inner = self.inner.severity(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, input: crate::model::AlarmRule) -> Self {
            self.inner = self.inner.alarm_rule(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.inner = self.inner.set_alarm_rule(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, input: crate::model::AlarmNotification) -> Self {
            self.inner = self.inner.alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.inner = self.inner.set_alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, input: crate::model::AlarmEventActions) -> Self {
            self.inner = self.inner.alarm_event_actions(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.inner = self.inner.set_alarm_event_actions(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, input: crate::model::AlarmCapabilities) -> Self {
            self.inner = self.inner.alarm_capabilities(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.inner = self.inner.set_alarm_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDetectorModel`.
    ///
    /// <p>Creates a detector model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDetectorModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_detector_model_input::Builder,
    }
    impl CreateDetectorModel {
        /// Creates a new `CreateDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDetectorModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(input);
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_description(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_description(input);
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.inner = self.inner.evaluation_method(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInput`.
    ///
    /// <p>Creates an input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_input_input::Builder,
    }
    impl CreateInput {
        /// Creates a new `CreateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you want to give to the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(input.into());
            self
        }
        /// <p>The name you want to give to the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_description(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_description(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, input: crate::model::InputDefinition) -> Self {
            self.inner = self.inner.input_definition(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.inner = self.inner.set_input_definition(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlarmModel`.
    ///
    /// <p>Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlarmModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_alarm_model_input::Builder,
    }
    impl DeleteAlarmModel {
        /// Creates a new `DeleteAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlarmModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetectorModel`.
    ///
    /// <p>Deletes a detector model. Any active instances of the detector model are also deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDetectorModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_detector_model_input::Builder,
    }
    impl DeleteDetectorModel {
        /// Creates a new `DeleteDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model to be deleted.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(input.into());
            self
        }
        /// <p>The name of the detector model to be deleted.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInput`.
    ///
    /// <p>Deletes an input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_input_input::Builder,
    }
    impl DeleteInput {
        /// Creates a new `DeleteInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input to delete.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(input.into());
            self
        }
        /// <p>The name of the input to delete.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlarmModel`.
    ///
    /// <p>Retrieves information about an alarm model. If you don't specify a value for the <code>alarmModelVersion</code> parameter, the latest version is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAlarmModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_alarm_model_input::Builder,
    }
    impl DescribeAlarmModel {
        /// Creates a new `DescribeAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlarmModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_version(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectorModel`.
    ///
    /// <p>Describes a detector model. If the <code>version</code> parameter is not specified, information about the latest version is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDetectorModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_detector_model_input::Builder,
    }
    impl DescribeDetectorModel {
        /// Creates a new `DescribeDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_version(input.into());
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectorModelAnalysis`.
    ///
    /// <p>Retrieves runtime information about a detector model analysis.</p> <note>
    /// <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDetectorModelAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_detector_model_analysis_input::Builder,
    }
    impl DescribeDetectorModelAnalysis {
        /// Creates a new `DescribeDetectorModelAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectorModelAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDetectorModelAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInput`.
    ///
    /// <p>Describes an input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_input_input::Builder,
    }
    impl DescribeInput {
        /// Creates a new `DescribeInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInputOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(input.into());
            self
        }
        /// <p>The name of the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current settings of the AWS IoT Events logging options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl DescribeLoggingOptions {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDetectorModelAnalysisResults`.
    ///
    /// <p>Retrieves one or more analysis results of the detector model.</p> <note>
    /// <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDetectorModelAnalysisResults {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_detector_model_analysis_results_input::Builder,
    }
    impl GetDetectorModelAnalysisResults {
        /// Creates a new `GetDetectorModelAnalysisResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorModelAnalysisResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorModelAnalysisResultsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmModels`.
    ///
    /// <p>Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAlarmModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_alarm_models_input::Builder,
    }
    impl ListAlarmModels {
        /// Creates a new `ListAlarmModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmModelVersions`.
    ///
    /// <p>Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAlarmModelVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_alarm_model_versions_input::Builder,
    }
    impl ListAlarmModelVersions {
        /// Creates a new `ListAlarmModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmModelVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectorModels`.
    ///
    /// <p>Lists the detector models you have created. Only the metadata associated with each detector model is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDetectorModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_detector_models_input::Builder,
    }
    impl ListDetectorModels {
        /// Creates a new `ListDetectorModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectorModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectorModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectorModelVersions`.
    ///
    /// <p>Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDetectorModelVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_detector_model_versions_input::Builder,
    }
    impl ListDetectorModelVersions {
        /// Creates a new `ListDetectorModelVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectorModelVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectorModelVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(input.into());
            self
        }
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputRoutings`.
    ///
    /// <p> Lists one or more input routings. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInputRoutings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_input_routings_input::Builder,
    }
    impl ListInputRoutings {
        /// Creates a new `ListInputRoutings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputRoutingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputRoutingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifer of the routed input. </p>
        pub fn input_identifier(mut self, input: crate::model::InputIdentifier) -> Self {
            self.inner = self.inner.input_identifier(input);
            self
        }
        /// <p> The identifer of the routed input. </p>
        pub fn set_input_identifier(
            mut self,
            input: std::option::Option<crate::model::InputIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_input_identifier(input);
            self
        }
        /// <p> The maximum number of results to be returned per request. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to be returned per request. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token that you can use to return the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token that you can use to return the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInputs`.
    ///
    /// <p>Lists the inputs you have created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInputs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_inputs_input::Builder,
    }
    impl ListInputs {
        /// Creates a new `ListInputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInputsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) you have assigned to the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets or updates the AWS IoT Events logging options.</p>
    /// <p>If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the <code>roleArn</code> field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl PutLoggingOptions {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(input);
            self
        }
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDetectorModelAnalysis`.
    ///
    /// <p>Performs an analysis of your detector model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Troubleshooting a detector model</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDetectorModelAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_detector_model_analysis_input::Builder,
    }
    impl StartDetectorModelAnalysis {
        /// Creates a new `StartDetectorModelAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDetectorModelAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDetectorModelAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the given tags (metadata) from the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAlarmModel`.
    ///
    /// <p>Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAlarmModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_alarm_model_input::Builder,
    }
    impl UpdateAlarmModel {
        /// Creates a new `UpdateAlarmModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAlarmModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAlarmModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_name(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_name(input);
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_model_description(input.into());
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alarm_model_description(input);
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.inner = self.inner.severity(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, input: crate::model::AlarmRule) -> Self {
            self.inner = self.inner.alarm_rule(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.inner = self.inner.set_alarm_rule(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, input: crate::model::AlarmNotification) -> Self {
            self.inner = self.inner.alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.inner = self.inner.set_alarm_notification(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, input: crate::model::AlarmEventActions) -> Self {
            self.inner = self.inner.alarm_event_actions(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.inner = self.inner.set_alarm_event_actions(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, input: crate::model::AlarmCapabilities) -> Self {
            self.inner = self.inner.alarm_capabilities(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.inner = self.inner.set_alarm_capabilities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetectorModel`.
    ///
    /// <p>Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDetectorModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_detector_model_input::Builder,
    }
    impl UpdateDetectorModel {
        /// Creates a new `UpdateDetectorModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector model that is updated.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_name(input.into());
            self
        }
        /// <p>The name of the detector model that is updated.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_name(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.inner = self.inner.detector_model_definition(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_definition(input);
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_model_description(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_detector_model_description(input);
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.inner = self.inner.evaluation_method(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed. </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_method(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInput`.
    ///
    /// <p>Updates an input.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_input_input::Builder,
    }
    impl UpdateInput {
        /// Creates a new `UpdateInput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInputOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the input you want to update.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_name(input.into());
            self
        }
        /// <p>The name of the input you want to update.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_name(input);
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_description(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_description(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, input: crate::model::InputDefinition) -> Self {
            self.inner = self.inner.input_definition(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.inner = self.inner.set_input_definition(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
