// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAlarmModelInput`](crate::input::CreateAlarmModelInput)
pub mod create_alarm_model_input {
    /// A builder for [`CreateAlarmModelInput`](crate::input::CreateAlarmModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<i32>,
        pub(crate) alarm_rule: std::option::Option<crate::model::AlarmRule>,
        pub(crate) alarm_notification: std::option::Option<crate::model::AlarmNotification>,
        pub(crate) alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
        pub(crate) alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
    }
    impl Builder {
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after
        /// you create the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>A unique name that helps you identify the alarm model. You can't change this name after
        /// you create the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_description = Some(input.into());
            self
        }
        /// <p>A description that tells you what the alarm model detects.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_description = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
        /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
        /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
        /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
        /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
        /// <p>You can create up to 50 tags for one alarm model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.severity = input;
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, input: crate::model::AlarmRule) -> Self {
            self.alarm_rule = Some(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.alarm_rule = input;
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, input: crate::model::AlarmNotification) -> Self {
            self.alarm_notification = Some(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.alarm_notification = input;
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, input: crate::model::AlarmEventActions) -> Self {
            self.alarm_event_actions = Some(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.alarm_event_actions = input;
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, input: crate::model::AlarmCapabilities) -> Self {
            self.alarm_capabilities = Some(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.alarm_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlarmModelInput`](crate::input::CreateAlarmModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAlarmModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAlarmModelInput {
                alarm_model_name: self.alarm_model_name,
                alarm_model_description: self.alarm_model_description,
                role_arn: self.role_arn,
                tags: self.tags,
                key: self.key,
                severity: self.severity,
                alarm_rule: self.alarm_rule,
                alarm_notification: self.alarm_notification,
                alarm_event_actions: self.alarm_event_actions,
                alarm_capabilities: self.alarm_capabilities,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAlarmModelInputOperationOutputAlias = crate::operation::CreateAlarmModel;
#[doc(hidden)]
pub type CreateAlarmModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAlarmModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlarmModel`](crate::operation::CreateAlarmModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlarmModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAlarmModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarm-models").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAlarmModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAlarmModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_alarm_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlarmModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlarmModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAlarmModelInput`](crate::input::CreateAlarmModelInput)
    pub fn builder() -> crate::input::create_alarm_model_input::Builder {
        crate::input::create_alarm_model_input::Builder::default()
    }
}

/// See [`CreateDetectorModelInput`](crate::input::CreateDetectorModelInput)
pub mod create_detector_model_input {
    /// A builder for [`CreateDetectorModelInput`](crate::input::CreateDetectorModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_definition:
            std::option::Option<crate::model::DetectorModelDefinition>,
        pub(crate) detector_model_description: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.detector_model_definition = Some(input);
            self
        }
        /// <p>Information that defines how the detectors operate.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.detector_model_definition = input;
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_description = Some(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_description = input;
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an
        /// instance of the detector model) and then to route each input received to the appropriate
        /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
        /// input to specify the attribute-value pair that is used to identify the device associated with
        /// the input.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The input attribute key used to identify a device or system to create a detector (an
        /// instance of the detector model) and then to route each input received to the appropriate
        /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
        /// input to specify the attribute-value pair that is used to identify the device associated with
        /// the input.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the detector model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.evaluation_method = Some(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.evaluation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDetectorModelInput`](crate::input::CreateDetectorModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDetectorModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDetectorModelInput {
                detector_model_name: self.detector_model_name,
                detector_model_definition: self.detector_model_definition,
                detector_model_description: self.detector_model_description,
                key: self.key,
                role_arn: self.role_arn,
                tags: self.tags,
                evaluation_method: self.evaluation_method,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDetectorModelInputOperationOutputAlias = crate::operation::CreateDetectorModel;
#[doc(hidden)]
pub type CreateDetectorModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDetectorModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateDetectorModel`](crate::operation::CreateDetectorModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDetectorModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDetectorModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/detector-models").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDetectorModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDetectorModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_detector_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDetectorModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDetectorModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDetectorModelInput`](crate::input::CreateDetectorModelInput)
    pub fn builder() -> crate::input::create_detector_model_input::Builder {
        crate::input::create_detector_model_input::Builder::default()
    }
}

/// See [`CreateInputInput`](crate::input::CreateInputInput)
pub mod create_input_input {
    /// A builder for [`CreateInputInput`](crate::input::CreateInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) input_description: std::option::Option<std::string::String>,
        pub(crate) input_definition: std::option::Option<crate::model::InputDefinition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name you want to give to the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name you want to give to the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_description = Some(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_description = input;
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, input: crate::model::InputDefinition) -> Self {
            self.input_definition = Some(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.input_definition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the input.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputInput`](crate::input::CreateInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInputInput {
                input_name: self.input_name,
                input_description: self.input_description,
                input_definition: self.input_definition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInputInputOperationOutputAlias = crate::operation::CreateInput;
#[doc(hidden)]
pub type CreateInputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateInputInput {
    /// Consumes the builder and constructs an Operation<[`CreateInput`](crate::operation::CreateInput)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/inputs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInput",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInputInput`](crate::input::CreateInputInput)
    pub fn builder() -> crate::input::create_input_input::Builder {
        crate::input::create_input_input::Builder::default()
    }
}

/// See [`DeleteAlarmModelInput`](crate::input::DeleteAlarmModelInput)
pub mod delete_alarm_model_input {
    /// A builder for [`DeleteAlarmModelInput`](crate::input::DeleteAlarmModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAlarmModelInput`](crate::input::DeleteAlarmModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAlarmModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAlarmModelInput {
                alarm_model_name: self.alarm_model_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAlarmModelInputOperationOutputAlias = crate::operation::DeleteAlarmModel;
#[doc(hidden)]
pub type DeleteAlarmModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAlarmModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlarmModel`](crate::operation::DeleteAlarmModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlarmModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAlarmModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.alarm_model_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_1, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarm-models/{alarmModelName}",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAlarmModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAlarmModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlarmModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlarmModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAlarmModelInput`](crate::input::DeleteAlarmModelInput)
    pub fn builder() -> crate::input::delete_alarm_model_input::Builder {
        crate::input::delete_alarm_model_input::Builder::default()
    }
}

/// See [`DeleteDetectorModelInput`](crate::input::DeleteDetectorModelInput)
pub mod delete_detector_model_input {
    /// A builder for [`DeleteDetectorModelInput`](crate::input::DeleteDetectorModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the detector model to be deleted.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model to be deleted.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDetectorModelInput`](crate::input::DeleteDetectorModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDetectorModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDetectorModelInput {
                detector_model_name: self.detector_model_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDetectorModelInputOperationOutputAlias = crate::operation::DeleteDetectorModel;
#[doc(hidden)]
pub type DeleteDetectorModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDetectorModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDetectorModel`](crate::operation::DeleteDetectorModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDetectorModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDetectorModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.detector_model_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_2, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector-models/{detectorModelName}",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDetectorModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDetectorModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDetectorModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDetectorModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDetectorModelInput`](crate::input::DeleteDetectorModelInput)
    pub fn builder() -> crate::input::delete_detector_model_input::Builder {
        crate::input::delete_detector_model_input::Builder::default()
    }
}

/// See [`DeleteInputInput`](crate::input::DeleteInputInput)
pub mod delete_input_input {
    /// A builder for [`DeleteInputInput`](crate::input::DeleteInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the input to delete.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input to delete.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInputInput`](crate::input::DeleteInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInputInput {
                input_name: self.input_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInputInputOperationOutputAlias = crate::operation::DeleteInput;
#[doc(hidden)]
pub type DeleteInputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInputInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInput`](crate::operation::DeleteInput)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.input_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_name",
                        details: "cannot be empty or unset",
                    })?;
            let input_name = aws_smithy_http::label::fmt_string(input_3, false);
            if input_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/inputs/{inputName}", inputName = input_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInput",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInputInput`](crate::input::DeleteInputInput)
    pub fn builder() -> crate::input::delete_input_input::Builder {
        crate::input::delete_input_input::Builder::default()
    }
}

/// See [`DescribeAlarmModelInput`](crate::input::DescribeAlarmModelInput)
pub mod describe_alarm_model_input {
    /// A builder for [`DescribeAlarmModelInput`](crate::input::DescribeAlarmModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlarmModelInput`](crate::input::DescribeAlarmModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAlarmModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAlarmModelInput {
                alarm_model_name: self.alarm_model_name,
                alarm_model_version: self.alarm_model_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAlarmModelInputOperationOutputAlias = crate::operation::DescribeAlarmModel;
#[doc(hidden)]
pub type DescribeAlarmModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAlarmModelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlarmModel`](crate::operation::DescribeAlarmModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlarmModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAlarmModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.alarm_model_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_4, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarm-models/{alarmModelName}",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeAlarmModelInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.alarm_model_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_5));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAlarmModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAlarmModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlarmModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlarmModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAlarmModelInput`](crate::input::DescribeAlarmModelInput)
    pub fn builder() -> crate::input::describe_alarm_model_input::Builder {
        crate::input::describe_alarm_model_input::Builder::default()
    }
}

/// See [`DescribeDetectorModelInput`](crate::input::DescribeDetectorModelInput)
pub mod describe_detector_model_input {
    /// A builder for [`DescribeDetectorModelInput`](crate::input::DescribeDetectorModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the detector model.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn detector_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_version = Some(input.into());
            self
        }
        /// <p>The version of the detector model.</p>
        pub fn set_detector_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorModelInput`](crate::input::DescribeDetectorModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDetectorModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDetectorModelInput {
                detector_model_name: self.detector_model_name,
                detector_model_version: self.detector_model_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDetectorModelInputOperationOutputAlias = crate::operation::DescribeDetectorModel;
#[doc(hidden)]
pub type DescribeDetectorModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDetectorModelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDetectorModel`](crate::operation::DescribeDetectorModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDetectorModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDetectorModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.detector_model_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_6, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector-models/{detectorModelName}",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeDetectorModelInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.detector_model_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDetectorModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDetectorModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDetectorModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDetectorModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDetectorModelInput`](crate::input::DescribeDetectorModelInput)
    pub fn builder() -> crate::input::describe_detector_model_input::Builder {
        crate::input::describe_detector_model_input::Builder::default()
    }
}

/// See [`DescribeDetectorModelAnalysisInput`](crate::input::DescribeDetectorModelAnalysisInput)
pub mod describe_detector_model_analysis_input {
    /// A builder for [`DescribeDetectorModelAnalysisInput`](crate::input::DescribeDetectorModelAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorModelAnalysisInput`](crate::input::DescribeDetectorModelAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDetectorModelAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDetectorModelAnalysisInput {
                analysis_id: self.analysis_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDetectorModelAnalysisInputOperationOutputAlias =
    crate::operation::DescribeDetectorModelAnalysis;
#[doc(hidden)]
pub type DescribeDetectorModelAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDetectorModelAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDetectorModelAnalysis`](crate::operation::DescribeDetectorModelAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDetectorModelAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDetectorModelAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.analysis_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_8, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analysis/detector-models/{analysisId}",
                analysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDetectorModelAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDetectorModelAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDetectorModelAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDetectorModelAnalysis",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDetectorModelAnalysisInput`](crate::input::DescribeDetectorModelAnalysisInput)
    pub fn builder() -> crate::input::describe_detector_model_analysis_input::Builder {
        crate::input::describe_detector_model_analysis_input::Builder::default()
    }
}

/// See [`DescribeInputInput`](crate::input::DescribeInputInput)
pub mod describe_input_input {
    /// A builder for [`DescribeInputInput`](crate::input::DescribeInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputInput`](crate::input::DescribeInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInputInput {
                input_name: self.input_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInputInputOperationOutputAlias = crate::operation::DescribeInput;
#[doc(hidden)]
pub type DescribeInputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInputInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInput`](crate::operation::DescribeInput)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.input_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_name",
                        details: "cannot be empty or unset",
                    })?;
            let input_name = aws_smithy_http::label::fmt_string(input_9, false);
            if input_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/inputs/{inputName}", inputName = input_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInput",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInputInput`](crate::input::DescribeInputInput)
    pub fn builder() -> crate::input::describe_input_input::Builder {
        crate::input::describe_input_input::Builder::default()
    }
}

/// See [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
pub mod describe_logging_options_input {
    /// A builder for [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoggingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoggingOptionsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeLoggingOptionsInputOperationOutputAlias = crate::operation::DescribeLoggingOptions;
#[doc(hidden)]
pub type DescribeLoggingOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoggingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoggingOptions`](crate::operation::DescribeLoggingOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoggingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoggingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/logging").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoggingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoggingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoggingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoggingOptions",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    pub fn builder() -> crate::input::describe_logging_options_input::Builder {
        crate::input::describe_logging_options_input::Builder::default()
    }
}

/// See [`GetDetectorModelAnalysisResultsInput`](crate::input::GetDetectorModelAnalysisResultsInput)
pub mod get_detector_model_analysis_results_input {
    /// A builder for [`GetDetectorModelAnalysisResultsInput`](crate::input::GetDetectorModelAnalysisResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis result that you want to retrieve.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorModelAnalysisResultsInput`](crate::input::GetDetectorModelAnalysisResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDetectorModelAnalysisResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDetectorModelAnalysisResultsInput {
                analysis_id: self.analysis_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDetectorModelAnalysisResultsInputOperationOutputAlias =
    crate::operation::GetDetectorModelAnalysisResults;
#[doc(hidden)]
pub type GetDetectorModelAnalysisResultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDetectorModelAnalysisResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetDetectorModelAnalysisResults`](crate::operation::GetDetectorModelAnalysisResults)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDetectorModelAnalysisResults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDetectorModelAnalysisResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.analysis_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_10, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/analysis/detector-models/{analysisId}/results",
                analysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetDetectorModelAnalysisResultsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if let Some(inner_12) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_12).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDetectorModelAnalysisResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDetectorModelAnalysisResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDetectorModelAnalysisResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDetectorModelAnalysisResults",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDetectorModelAnalysisResultsInput`](crate::input::GetDetectorModelAnalysisResultsInput)
    pub fn builder() -> crate::input::get_detector_model_analysis_results_input::Builder {
        crate::input::get_detector_model_analysis_results_input::Builder::default()
    }
}

/// See [`ListAlarmModelsInput`](crate::input::ListAlarmModelsInput)
pub mod list_alarm_models_input {
    /// A builder for [`ListAlarmModelsInput`](crate::input::ListAlarmModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmModelsInput`](crate::input::ListAlarmModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAlarmModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAlarmModelsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAlarmModelsInputOperationOutputAlias = crate::operation::ListAlarmModels;
#[doc(hidden)]
pub type ListAlarmModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAlarmModelsInput {
    /// Consumes the builder and constructs an Operation<[`ListAlarmModels`](crate::operation::ListAlarmModels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAlarmModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAlarmModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/alarm-models").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAlarmModelsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAlarmModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAlarmModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAlarmModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAlarmModels",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAlarmModelsInput`](crate::input::ListAlarmModelsInput)
    pub fn builder() -> crate::input::list_alarm_models_input::Builder {
        crate::input::list_alarm_models_input::Builder::default()
    }
}

/// See [`ListAlarmModelVersionsInput`](crate::input::ListAlarmModelVersionsInput)
pub mod list_alarm_model_versions_input {
    /// A builder for [`ListAlarmModelVersionsInput`](crate::input::ListAlarmModelVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmModelVersionsInput`](crate::input::ListAlarmModelVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAlarmModelVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAlarmModelVersionsInput {
                alarm_model_name: self.alarm_model_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAlarmModelVersionsInputOperationOutputAlias = crate::operation::ListAlarmModelVersions;
#[doc(hidden)]
pub type ListAlarmModelVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAlarmModelVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListAlarmModelVersions`](crate::operation::ListAlarmModelVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAlarmModelVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAlarmModelVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.alarm_model_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_15, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarm-models/{alarmModelName}/versions",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAlarmModelVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_16));
            }
            if let Some(inner_17) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_17).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAlarmModelVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAlarmModelVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAlarmModelVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAlarmModelVersions",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAlarmModelVersionsInput`](crate::input::ListAlarmModelVersionsInput)
    pub fn builder() -> crate::input::list_alarm_model_versions_input::Builder {
        crate::input::list_alarm_model_versions_input::Builder::default()
    }
}

/// See [`ListDetectorModelsInput`](crate::input::ListDetectorModelsInput)
pub mod list_detector_models_input {
    /// A builder for [`ListDetectorModelsInput`](crate::input::ListDetectorModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorModelsInput`](crate::input::ListDetectorModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDetectorModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDetectorModelsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDetectorModelsInputOperationOutputAlias = crate::operation::ListDetectorModels;
#[doc(hidden)]
pub type ListDetectorModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDetectorModelsInput {
    /// Consumes the builder and constructs an Operation<[`ListDetectorModels`](crate::operation::ListDetectorModels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDetectorModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDetectorModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/detector-models").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDetectorModelsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
            }
            if let Some(inner_19) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDetectorModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDetectorModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDetectorModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDetectorModels",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDetectorModelsInput`](crate::input::ListDetectorModelsInput)
    pub fn builder() -> crate::input::list_detector_models_input::Builder {
        crate::input::list_detector_models_input::Builder::default()
    }
}

/// See [`ListDetectorModelVersionsInput`](crate::input::ListDetectorModelVersionsInput)
pub mod list_detector_model_versions_input {
    /// A builder for [`ListDetectorModelVersionsInput`](crate::input::ListDetectorModelVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model whose versions are returned.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorModelVersionsInput`](crate::input::ListDetectorModelVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDetectorModelVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDetectorModelVersionsInput {
                detector_model_name: self.detector_model_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDetectorModelVersionsInputOperationOutputAlias =
    crate::operation::ListDetectorModelVersions;
#[doc(hidden)]
pub type ListDetectorModelVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDetectorModelVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDetectorModelVersions`](crate::operation::ListDetectorModelVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDetectorModelVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDetectorModelVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.detector_model_name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_20, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector-models/{detectorModelName}/versions",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDetectorModelVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_21));
            }
            if let Some(inner_22) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_22).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDetectorModelVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDetectorModelVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDetectorModelVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDetectorModelVersions",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDetectorModelVersionsInput`](crate::input::ListDetectorModelVersionsInput)
    pub fn builder() -> crate::input::list_detector_model_versions_input::Builder {
        crate::input::list_detector_model_versions_input::Builder::default()
    }
}

/// See [`ListInputRoutingsInput`](crate::input::ListInputRoutingsInput)
pub mod list_input_routings_input {
    /// A builder for [`ListInputRoutingsInput`](crate::input::ListInputRoutingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_identifier: std::option::Option<crate::model::InputIdentifier>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The identifer of the routed input.
        /// </p>
        pub fn input_identifier(mut self, input: crate::model::InputIdentifier) -> Self {
            self.input_identifier = Some(input);
            self
        }
        /// <p>
        /// The identifer of the routed input.
        /// </p>
        pub fn set_input_identifier(
            mut self,
            input: std::option::Option<crate::model::InputIdentifier>,
        ) -> Self {
            self.input_identifier = input;
            self
        }
        /// <p>
        /// The maximum number of results to be returned per request.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to be returned per request.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputRoutingsInput`](crate::input::ListInputRoutingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputRoutingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputRoutingsInput {
                input_identifier: self.input_identifier,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputRoutingsInputOperationOutputAlias = crate::operation::ListInputRoutings;
#[doc(hidden)]
pub type ListInputRoutingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInputRoutingsInput {
    /// Consumes the builder and constructs an Operation<[`ListInputRoutings`](crate::operation::ListInputRoutings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputRoutings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputRoutingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/input-routings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputRoutingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputRoutingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_input_routings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputRoutings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputRoutings",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputRoutingsInput`](crate::input::ListInputRoutingsInput)
    pub fn builder() -> crate::input::list_input_routings_input::Builder {
        crate::input::list_input_routings_input::Builder::default()
    }
}

/// See [`ListInputsInput`](crate::input::ListInputsInput)
pub mod list_inputs_input {
    /// A builder for [`ListInputsInput`](crate::input::ListInputsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputsInput`](crate::input::ListInputsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInputsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInputsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInputsInputOperationOutputAlias = crate::operation::ListInputs;
#[doc(hidden)]
pub type ListInputsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInputsInput {
    /// Consumes the builder and constructs an Operation<[`ListInputs`](crate::operation::ListInputs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInputs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInputsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/inputs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListInputsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            if let Some(inner_24) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInputsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInputsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInputs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInputs",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInputsInput`](crate::input::ListInputsInput)
    pub fn builder() -> crate::input::list_inputs_input::Builder {
        crate::input::list_inputs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListTagsForResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_25) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_25),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
pub mod put_logging_options_input {
    /// A builder for [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_options: std::option::Option<crate::model::LoggingOptions>,
    }
    impl Builder {
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.logging_options = Some(input);
            self
        }
        /// <p>The new values of the AWS IoT Events logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLoggingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLoggingOptionsInput {
                logging_options: self.logging_options,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLoggingOptionsInputOperationOutputAlias = crate::operation::PutLoggingOptions;
#[doc(hidden)]
pub type PutLoggingOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLoggingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutLoggingOptions`](crate::operation::PutLoggingOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLoggingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLoggingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/logging").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLoggingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLoggingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_logging_options(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLoggingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLoggingOptions",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    pub fn builder() -> crate::input::put_logging_options_input::Builder {
        crate::input::put_logging_options_input::Builder::default()
    }
}

/// See [`StartDetectorModelAnalysisInput`](crate::input::StartDetectorModelAnalysisInput)
pub mod start_detector_model_analysis_input {
    /// A builder for [`StartDetectorModelAnalysisInput`](crate::input::StartDetectorModelAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_definition:
            std::option::Option<crate::model::DetectorModelDefinition>,
    }
    impl Builder {
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.detector_model_definition = Some(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.detector_model_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDetectorModelAnalysisInput`](crate::input::StartDetectorModelAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartDetectorModelAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartDetectorModelAnalysisInput {
                detector_model_definition: self.detector_model_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type StartDetectorModelAnalysisInputOperationOutputAlias =
    crate::operation::StartDetectorModelAnalysis;
#[doc(hidden)]
pub type StartDetectorModelAnalysisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartDetectorModelAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`StartDetectorModelAnalysis`](crate::operation::StartDetectorModelAnalysis)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartDetectorModelAnalysis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartDetectorModelAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/analysis/detector-models").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartDetectorModelAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartDetectorModelAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_detector_model_analysis(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartDetectorModelAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartDetectorModelAnalysis",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartDetectorModelAnalysisInput`](crate::input::StartDetectorModelAnalysisInput)
    pub fn builder() -> crate::input::start_detector_model_analysis_input::Builder {
        crate::input::start_detector_model_analysis_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::TagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_26),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of the keys of the tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
            if let Some(inner_28) = &_input.tag_keys {
                for inner_29 in inner_28 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_29));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAlarmModelInput`](crate::input::UpdateAlarmModelInput)
pub mod update_alarm_model_input {
    /// A builder for [`UpdateAlarmModelInput`](crate::input::UpdateAlarmModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<i32>,
        pub(crate) alarm_rule: std::option::Option<crate::model::AlarmRule>,
        pub(crate) alarm_notification: std::option::Option<crate::model::AlarmNotification>,
        pub(crate) alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
        pub(crate) alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
    }
    impl Builder {
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_description = Some(input.into());
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_description = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.severity = input;
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, input: crate::model::AlarmRule) -> Self {
            self.alarm_rule = Some(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.alarm_rule = input;
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, input: crate::model::AlarmNotification) -> Self {
            self.alarm_notification = Some(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.alarm_notification = input;
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, input: crate::model::AlarmEventActions) -> Self {
            self.alarm_event_actions = Some(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.alarm_event_actions = input;
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, input: crate::model::AlarmCapabilities) -> Self {
            self.alarm_capabilities = Some(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.alarm_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAlarmModelInput`](crate::input::UpdateAlarmModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAlarmModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAlarmModelInput {
                alarm_model_name: self.alarm_model_name,
                alarm_model_description: self.alarm_model_description,
                role_arn: self.role_arn,
                severity: self.severity,
                alarm_rule: self.alarm_rule,
                alarm_notification: self.alarm_notification,
                alarm_event_actions: self.alarm_event_actions,
                alarm_capabilities: self.alarm_capabilities,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAlarmModelInputOperationOutputAlias = crate::operation::UpdateAlarmModel;
#[doc(hidden)]
pub type UpdateAlarmModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAlarmModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAlarmModel`](crate::operation::UpdateAlarmModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAlarmModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAlarmModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.alarm_model_name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alarm_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let alarm_model_name = aws_smithy_http::label::fmt_string(input_30, false);
            if alarm_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alarm_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/alarm-models/{alarmModelName}",
                alarmModelName = alarm_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAlarmModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAlarmModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_alarm_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAlarmModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAlarmModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAlarmModelInput`](crate::input::UpdateAlarmModelInput)
    pub fn builder() -> crate::input::update_alarm_model_input::Builder {
        crate::input::update_alarm_model_input::Builder::default()
    }
}

/// See [`UpdateDetectorModelInput`](crate::input::UpdateDetectorModelInput)
pub mod update_detector_model_input {
    /// A builder for [`UpdateDetectorModelInput`](crate::input::UpdateDetectorModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_name: std::option::Option<std::string::String>,
        pub(crate) detector_model_definition:
            std::option::Option<crate::model::DetectorModelDefinition>,
        pub(crate) detector_model_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
    }
    impl Builder {
        /// <p>The name of the detector model that is updated.</p>
        pub fn detector_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_name = Some(input.into());
            self
        }
        /// <p>The name of the detector model that is updated.</p>
        pub fn set_detector_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_name = input;
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn detector_model_definition(
            mut self,
            input: crate::model::DetectorModelDefinition,
        ) -> Self {
            self.detector_model_definition = Some(input);
            self
        }
        /// <p>Information that defines how a detector operates.</p>
        pub fn set_detector_model_definition(
            mut self,
            input: std::option::Option<crate::model::DetectorModelDefinition>,
        ) -> Self {
            self.detector_model_definition = input;
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn detector_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_model_description = Some(input.into());
            self
        }
        /// <p>A brief description of the detector model.</p>
        pub fn set_detector_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detector_model_description = input;
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn evaluation_method(mut self, input: crate::model::EvaluationMethod) -> Self {
            self.evaluation_method = Some(input);
            self
        }
        /// <p>Information about the order in which events are evaluated and how actions are executed.
        /// </p>
        pub fn set_evaluation_method(
            mut self,
            input: std::option::Option<crate::model::EvaluationMethod>,
        ) -> Self {
            self.evaluation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorModelInput`](crate::input::UpdateDetectorModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDetectorModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDetectorModelInput {
                detector_model_name: self.detector_model_name,
                detector_model_definition: self.detector_model_definition,
                detector_model_description: self.detector_model_description,
                role_arn: self.role_arn,
                evaluation_method: self.evaluation_method,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDetectorModelInputOperationOutputAlias = crate::operation::UpdateDetectorModel;
#[doc(hidden)]
pub type UpdateDetectorModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDetectorModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDetectorModel`](crate::operation::UpdateDetectorModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDetectorModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDetectorModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.detector_model_name;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_model_name",
                        details: "cannot be empty or unset",
                    })?;
            let detector_model_name = aws_smithy_http::label::fmt_string(input_31, false);
            if detector_model_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_model_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector-models/{detectorModelName}",
                detectorModelName = detector_model_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDetectorModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDetectorModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_detector_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDetectorModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDetectorModel",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDetectorModelInput`](crate::input::UpdateDetectorModelInput)
    pub fn builder() -> crate::input::update_detector_model_input::Builder {
        crate::input::update_detector_model_input::Builder::default()
    }
}

/// See [`UpdateInputInput`](crate::input::UpdateInputInput)
pub mod update_input_input {
    /// A builder for [`UpdateInputInput`](crate::input::UpdateInputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) input_description: std::option::Option<std::string::String>,
        pub(crate) input_definition: std::option::Option<crate::model::InputDefinition>,
    }
    impl Builder {
        /// <p>The name of the input you want to update.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the input you want to update.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn input_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_description = Some(input.into());
            self
        }
        /// <p>A brief description of the input.</p>
        pub fn set_input_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_description = input;
            self
        }
        /// <p>The definition of the input.</p>
        pub fn input_definition(mut self, input: crate::model::InputDefinition) -> Self {
            self.input_definition = Some(input);
            self
        }
        /// <p>The definition of the input.</p>
        pub fn set_input_definition(
            mut self,
            input: std::option::Option<crate::model::InputDefinition>,
        ) -> Self {
            self.input_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputInput`](crate::input::UpdateInputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInputInput {
                input_name: self.input_name,
                input_description: self.input_description,
                input_definition: self.input_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInputInputOperationOutputAlias = crate::operation::UpdateInput;
#[doc(hidden)]
pub type UpdateInputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateInputInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInput`](crate::operation::UpdateInput)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateInputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.input_name;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "input_name",
                        details: "cannot be empty or unset",
                    })?;
            let input_name = aws_smithy_http::label::fmt_string(input_32, false);
            if input_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "input_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/inputs/{inputName}", inputName = input_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateInputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateInputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_input(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInput",
            "iotevents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateInputInput`](crate::input::UpdateInputInput)
    pub fn builder() -> crate::input::update_input_input::Builder {
        crate::input::update_input_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputInput {
    /// <p>The name of the input you want to update.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>A brief description of the input.</p>
    pub input_description: std::option::Option<std::string::String>,
    /// <p>The definition of the input.</p>
    pub input_definition: std::option::Option<crate::model::InputDefinition>,
}
impl UpdateInputInput {
    /// <p>The name of the input you want to update.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>A brief description of the input.</p>
    pub fn input_description(&self) -> std::option::Option<&str> {
        self.input_description.as_deref()
    }
    /// <p>The definition of the input.</p>
    pub fn input_definition(&self) -> std::option::Option<&crate::model::InputDefinition> {
        self.input_definition.as_ref()
    }
}
impl std::fmt::Debug for UpdateInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputInput");
        formatter.field("input_name", &self.input_name);
        formatter.field("input_description", &self.input_description);
        formatter.field("input_definition", &self.input_definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorModelInput {
    /// <p>The name of the detector model that is updated.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>Information that defines how a detector operates.</p>
    pub detector_model_definition: std::option::Option<crate::model::DetectorModelDefinition>,
    /// <p>A brief description of the detector model.</p>
    pub detector_model_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Information about the order in which events are evaluated and how actions are executed.
    /// </p>
    pub evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
}
impl UpdateDetectorModelInput {
    /// <p>The name of the detector model that is updated.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>Information that defines how a detector operates.</p>
    pub fn detector_model_definition(
        &self,
    ) -> std::option::Option<&crate::model::DetectorModelDefinition> {
        self.detector_model_definition.as_ref()
    }
    /// <p>A brief description of the detector model.</p>
    pub fn detector_model_description(&self) -> std::option::Option<&str> {
        self.detector_model_description.as_deref()
    }
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Information about the order in which events are evaluated and how actions are executed.
    /// </p>
    pub fn evaluation_method(&self) -> std::option::Option<&crate::model::EvaluationMethod> {
        self.evaluation_method.as_ref()
    }
}
impl std::fmt::Debug for UpdateDetectorModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorModelInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("detector_model_definition", &self.detector_model_definition);
        formatter.field(
            "detector_model_description",
            &self.detector_model_description,
        );
        formatter.field("role_arn", &self.role_arn);
        formatter.field("evaluation_method", &self.evaluation_method);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The description of the alarm model.</p>
    pub alarm_model_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub severity: std::option::Option<i32>,
    /// <p>Defines when your alarm is invoked.</p>
    pub alarm_rule: std::option::Option<crate::model::AlarmRule>,
    /// <p>Contains information about one or more notification actions.</p>
    pub alarm_notification: std::option::Option<crate::model::AlarmNotification>,
    /// <p>Contains information about one or more alarm actions.</p>
    pub alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
}
impl UpdateAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The description of the alarm model.</p>
    pub fn alarm_model_description(&self) -> std::option::Option<&str> {
        self.alarm_model_description.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub fn severity(&self) -> std::option::Option<i32> {
        self.severity
    }
    /// <p>Defines when your alarm is invoked.</p>
    pub fn alarm_rule(&self) -> std::option::Option<&crate::model::AlarmRule> {
        self.alarm_rule.as_ref()
    }
    /// <p>Contains information about one or more notification actions.</p>
    pub fn alarm_notification(&self) -> std::option::Option<&crate::model::AlarmNotification> {
        self.alarm_notification.as_ref()
    }
    /// <p>Contains information about one or more alarm actions.</p>
    pub fn alarm_event_actions(&self) -> std::option::Option<&crate::model::AlarmEventActions> {
        self.alarm_event_actions.as_ref()
    }
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub fn alarm_capabilities(&self) -> std::option::Option<&crate::model::AlarmCapabilities> {
        self.alarm_capabilities.as_ref()
    }
}
impl std::fmt::Debug for UpdateAlarmModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAlarmModelInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_description", &self.alarm_model_description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("severity", &self.severity);
        formatter.field("alarm_rule", &self.alarm_rule);
        formatter.field("alarm_notification", &self.alarm_notification);
        formatter.field("alarm_event_actions", &self.alarm_event_actions);
        formatter.field("alarm_capabilities", &self.alarm_capabilities);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys of the tags to be removed from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys of the tags to be removed from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The new or modified tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The new or modified tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDetectorModelAnalysisInput {
    /// <p>Information that defines how a detector operates.</p>
    pub detector_model_definition: std::option::Option<crate::model::DetectorModelDefinition>,
}
impl StartDetectorModelAnalysisInput {
    /// <p>Information that defines how a detector operates.</p>
    pub fn detector_model_definition(
        &self,
    ) -> std::option::Option<&crate::model::DetectorModelDefinition> {
        self.detector_model_definition.as_ref()
    }
}
impl std::fmt::Debug for StartDetectorModelAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDetectorModelAnalysisInput");
        formatter.field("detector_model_definition", &self.detector_model_definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLoggingOptionsInput {
    /// <p>The new values of the AWS IoT Events logging options.</p>
    pub logging_options: std::option::Option<crate::model::LoggingOptions>,
}
impl PutLoggingOptionsInput {
    /// <p>The new values of the AWS IoT Events logging options.</p>
    pub fn logging_options(&self) -> std::option::Option<&crate::model::LoggingOptions> {
        self.logging_options.as_ref()
    }
}
impl std::fmt::Debug for PutLoggingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLoggingOptionsInput");
        formatter.field("logging_options", &self.logging_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListInputsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListInputsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputRoutingsInput {
    /// <p>
    /// The identifer of the routed input.
    /// </p>
    pub input_identifier: std::option::Option<crate::model::InputIdentifier>,
    /// <p>
    /// The maximum number of results to be returned per request.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token that you can use to return the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInputRoutingsInput {
    /// <p>
    /// The identifer of the routed input.
    /// </p>
    pub fn input_identifier(&self) -> std::option::Option<&crate::model::InputIdentifier> {
        self.input_identifier.as_ref()
    }
    /// <p>
    /// The maximum number of results to be returned per request.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token that you can use to return the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInputRoutingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputRoutingsInput");
        formatter.field("input_identifier", &self.input_identifier);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorModelVersionsInput {
    /// <p>The name of the detector model whose versions are returned.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDetectorModelVersionsInput {
    /// <p>The name of the detector model whose versions are returned.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDetectorModelVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorModelVersionsInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorModelsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDetectorModelsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDetectorModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorModelsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmModelVersionsInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAlarmModelVersionsInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAlarmModelVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmModelVersionsInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmModelsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAlarmModelsInput {
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAlarmModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmModelsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorModelAnalysisResultsInput {
    /// <p>The ID of the analysis result that you want to retrieve.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The token that you can use to return the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetDetectorModelAnalysisResultsInput {
    /// <p>The ID of the analysis result that you want to retrieve.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The token that you can use to return the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetDetectorModelAnalysisResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorModelAnalysisResultsInput");
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingOptionsInput {}
impl std::fmt::Debug for DescribeLoggingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingOptionsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputInput {
    /// <p>The name of the input.</p>
    pub input_name: std::option::Option<std::string::String>,
}
impl DescribeInputInput {
    /// <p>The name of the input.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputInput");
        formatter.field("input_name", &self.input_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorModelAnalysisInput {
    /// <p>The ID of the analysis result that you want to retrieve.</p>
    pub analysis_id: std::option::Option<std::string::String>,
}
impl DescribeDetectorModelAnalysisInput {
    /// <p>The ID of the analysis result that you want to retrieve.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDetectorModelAnalysisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorModelAnalysisInput");
        formatter.field("analysis_id", &self.analysis_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorModelInput {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>The version of the detector model.</p>
    pub detector_model_version: std::option::Option<std::string::String>,
}
impl DescribeDetectorModelInput {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>The version of the detector model.</p>
    pub fn detector_model_version(&self) -> std::option::Option<&str> {
        self.detector_model_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeDetectorModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorModelInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("detector_model_version", &self.detector_model_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
}
impl DescribeAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>The version of the alarm model.</p>
    pub fn alarm_model_version(&self) -> std::option::Option<&str> {
        self.alarm_model_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeAlarmModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlarmModelInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputInput {
    /// <p>The name of the input to delete.</p>
    pub input_name: std::option::Option<std::string::String>,
}
impl DeleteInputInput {
    /// <p>The name of the input to delete.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputInput");
        formatter.field("input_name", &self.input_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorModelInput {
    /// <p>The name of the detector model to be deleted.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
}
impl DeleteDetectorModelInput {
    /// <p>The name of the detector model to be deleted.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDetectorModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorModelInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
}
impl DeleteAlarmModelInput {
    /// <p>The name of the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAlarmModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlarmModelInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputInput {
    /// <p>The name you want to give to the input.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>A brief description of the input.</p>
    pub input_description: std::option::Option<std::string::String>,
    /// <p>The definition of the input.</p>
    pub input_definition: std::option::Option<crate::model::InputDefinition>,
    /// <p>Metadata that can be used to manage the input.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateInputInput {
    /// <p>The name you want to give to the input.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>A brief description of the input.</p>
    pub fn input_description(&self) -> std::option::Option<&str> {
        self.input_description.as_deref()
    }
    /// <p>The definition of the input.</p>
    pub fn input_definition(&self) -> std::option::Option<&crate::model::InputDefinition> {
        self.input_definition.as_ref()
    }
    /// <p>Metadata that can be used to manage the input.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateInputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputInput");
        formatter.field("input_name", &self.input_name);
        formatter.field("input_description", &self.input_description);
        formatter.field("input_definition", &self.input_definition);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDetectorModelInput {
    /// <p>The name of the detector model.</p>
    pub detector_model_name: std::option::Option<std::string::String>,
    /// <p>Information that defines how the detectors operate.</p>
    pub detector_model_definition: std::option::Option<crate::model::DetectorModelDefinition>,
    /// <p>A brief description of the detector model.</p>
    pub detector_model_description: std::option::Option<std::string::String>,
    /// <p>The input attribute key used to identify a device or system to create a detector (an
    /// instance of the detector model) and then to route each input received to the appropriate
    /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
    /// input to specify the attribute-value pair that is used to identify the device associated with
    /// the input.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Metadata that can be used to manage the detector model.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Information about the order in which events are evaluated and how actions are executed.
    /// </p>
    pub evaluation_method: std::option::Option<crate::model::EvaluationMethod>,
}
impl CreateDetectorModelInput {
    /// <p>The name of the detector model.</p>
    pub fn detector_model_name(&self) -> std::option::Option<&str> {
        self.detector_model_name.as_deref()
    }
    /// <p>Information that defines how the detectors operate.</p>
    pub fn detector_model_definition(
        &self,
    ) -> std::option::Option<&crate::model::DetectorModelDefinition> {
        self.detector_model_definition.as_ref()
    }
    /// <p>A brief description of the detector model.</p>
    pub fn detector_model_description(&self) -> std::option::Option<&str> {
        self.detector_model_description.as_deref()
    }
    /// <p>The input attribute key used to identify a device or system to create a detector (an
    /// instance of the detector model) and then to route each input received to the appropriate
    /// detector (instance). This parameter uses a JSON-path expression in the message payload of each
    /// input to specify the attribute-value pair that is used to identify the device associated with
    /// the input.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Metadata that can be used to manage the detector model.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Information about the order in which events are evaluated and how actions are executed.
    /// </p>
    pub fn evaluation_method(&self) -> std::option::Option<&crate::model::EvaluationMethod> {
        self.evaluation_method.as_ref()
    }
}
impl std::fmt::Debug for CreateDetectorModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDetectorModelInput");
        formatter.field("detector_model_name", &self.detector_model_name);
        formatter.field("detector_model_definition", &self.detector_model_definition);
        formatter.field(
            "detector_model_description",
            &self.detector_model_description,
        );
        formatter.field("key", &self.key);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("evaluation_method", &self.evaluation_method);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAlarmModelInput {
    /// <p>A unique name that helps you identify the alarm model. You can't change this name after
    /// you create the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>A description that tells you what the alarm model detects.</p>
    pub alarm_model_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
    /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
    /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>You can create up to 50 tags for one alarm model.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An input attribute used as a key to create an alarm.
    /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
    /// associated with this key to the alarm.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub severity: std::option::Option<i32>,
    /// <p>Defines when your alarm is invoked.</p>
    pub alarm_rule: std::option::Option<crate::model::AlarmRule>,
    /// <p>Contains information about one or more notification actions.</p>
    pub alarm_notification: std::option::Option<crate::model::AlarmNotification>,
    /// <p>Contains information about one or more alarm actions.</p>
    pub alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
}
impl CreateAlarmModelInput {
    /// <p>A unique name that helps you identify the alarm model. You can't change this name after
    /// you create the alarm model.</p>
    pub fn alarm_model_name(&self) -> std::option::Option<&str> {
        self.alarm_model_name.as_deref()
    }
    /// <p>A description that tells you what the alarm model detects.</p>
    pub fn alarm_model_description(&self) -> std::option::Option<&str> {
        self.alarm_model_description.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the alarm model. The tags help you
    /// manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events
    /// resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
    /// <p>You can create up to 50 tags for one alarm model.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>An input attribute used as a key to create an alarm.
    /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
    /// associated with this key to the alarm.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub fn severity(&self) -> std::option::Option<i32> {
        self.severity
    }
    /// <p>Defines when your alarm is invoked.</p>
    pub fn alarm_rule(&self) -> std::option::Option<&crate::model::AlarmRule> {
        self.alarm_rule.as_ref()
    }
    /// <p>Contains information about one or more notification actions.</p>
    pub fn alarm_notification(&self) -> std::option::Option<&crate::model::AlarmNotification> {
        self.alarm_notification.as_ref()
    }
    /// <p>Contains information about one or more alarm actions.</p>
    pub fn alarm_event_actions(&self) -> std::option::Option<&crate::model::AlarmEventActions> {
        self.alarm_event_actions.as_ref()
    }
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub fn alarm_capabilities(&self) -> std::option::Option<&crate::model::AlarmCapabilities> {
        self.alarm_capabilities.as_ref()
    }
}
impl std::fmt::Debug for CreateAlarmModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAlarmModelInput");
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_description", &self.alarm_model_description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("key", &self.key);
        formatter.field("severity", &self.severity);
        formatter.field("alarm_rule", &self.alarm_rule);
        formatter.field("alarm_notification", &self.alarm_notification);
        formatter.field("alarm_event_actions", &self.alarm_event_actions);
        formatter.field("alarm_capabilities", &self.alarm_capabilities);
        formatter.finish()
    }
}
