// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInputOutput {
    /// <p>Information about the configuration of the input.</p>
    pub input_configuration: std::option::Option<crate::model::InputConfiguration>,
}
impl std::fmt::Debug for UpdateInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInputOutput");
        formatter.field("input_configuration", &self.input_configuration);
        formatter.finish()
    }
}
/// See [`UpdateInputOutput`](crate::output::UpdateInputOutput)
pub mod update_input_output {
    /// A builder for [`UpdateInputOutput`](crate::output::UpdateInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_configuration: std::option::Option<crate::model::InputConfiguration>,
    }
    impl Builder {
        /// <p>Information about the configuration of the input.</p>
        pub fn input_configuration(mut self, input: crate::model::InputConfiguration) -> Self {
            self.input_configuration = Some(input);
            self
        }
        /// <p>Information about the configuration of the input.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::InputConfiguration>,
        ) -> Self {
            self.input_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInputOutput`](crate::output::UpdateInputOutput)
        pub fn build(self) -> crate::output::UpdateInputOutput {
            crate::output::UpdateInputOutput {
                input_configuration: self.input_configuration,
            }
        }
    }
}
impl UpdateInputOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInputOutput`](crate::output::UpdateInputOutput)
    pub fn builder() -> crate::output::update_input_output::Builder {
        crate::output::update_input_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorModelOutput {
    /// <p>Information about how the detector model is configured.</p>
    pub detector_model_configuration: std::option::Option<crate::model::DetectorModelConfiguration>,
}
impl std::fmt::Debug for UpdateDetectorModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorModelOutput");
        formatter.field(
            "detector_model_configuration",
            &self.detector_model_configuration,
        );
        formatter.finish()
    }
}
/// See [`UpdateDetectorModelOutput`](crate::output::UpdateDetectorModelOutput)
pub mod update_detector_model_output {
    /// A builder for [`UpdateDetectorModelOutput`](crate::output::UpdateDetectorModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_configuration:
            std::option::Option<crate::model::DetectorModelConfiguration>,
    }
    impl Builder {
        /// <p>Information about how the detector model is configured.</p>
        pub fn detector_model_configuration(
            mut self,
            input: crate::model::DetectorModelConfiguration,
        ) -> Self {
            self.detector_model_configuration = Some(input);
            self
        }
        /// <p>Information about how the detector model is configured.</p>
        pub fn set_detector_model_configuration(
            mut self,
            input: std::option::Option<crate::model::DetectorModelConfiguration>,
        ) -> Self {
            self.detector_model_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorModelOutput`](crate::output::UpdateDetectorModelOutput)
        pub fn build(self) -> crate::output::UpdateDetectorModelOutput {
            crate::output::UpdateDetectorModelOutput {
                detector_model_configuration: self.detector_model_configuration,
            }
        }
    }
}
impl UpdateDetectorModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorModelOutput`](crate::output::UpdateDetectorModelOutput)
    pub fn builder() -> crate::output::update_detector_model_output::Builder {
        crate::output::update_detector_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAlarmModelOutput {
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub alarm_model_arn: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the alarm model. The status can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
    /// Activating an alarm model can take up to a few minutes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
    /// Check your alarm model information and update the alarm model.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
    /// and try again.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AlarmModelVersionStatus>,
}
impl std::fmt::Debug for UpdateAlarmModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAlarmModelOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("alarm_model_arn", &self.alarm_model_arn);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateAlarmModelOutput`](crate::output::UpdateAlarmModelOutput)
pub mod update_alarm_model_output {
    /// A builder for [`UpdateAlarmModelOutput`](crate::output::UpdateAlarmModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alarm_model_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AlarmModelVersionStatus>,
    }
    impl Builder {
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn alarm_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_alarm_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_arn = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AlarmModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlarmModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAlarmModelOutput`](crate::output::UpdateAlarmModelOutput)
        pub fn build(self) -> crate::output::UpdateAlarmModelOutput {
            crate::output::UpdateAlarmModelOutput {
                creation_time: self.creation_time,
                alarm_model_arn: self.alarm_model_arn,
                alarm_model_version: self.alarm_model_version,
                last_update_time: self.last_update_time,
                status: self.status,
            }
        }
    }
}
impl UpdateAlarmModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAlarmModelOutput`](crate::output::UpdateAlarmModelOutput)
    pub fn builder() -> crate::output::update_alarm_model_output::Builder {
        crate::output::update_alarm_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDetectorModelAnalysisOutput {
    /// <p>The ID that you can use to retrieve the analysis result.</p>
    pub analysis_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartDetectorModelAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDetectorModelAnalysisOutput");
        formatter.field("analysis_id", &self.analysis_id);
        formatter.finish()
    }
}
/// See [`StartDetectorModelAnalysisOutput`](crate::output::StartDetectorModelAnalysisOutput)
pub mod start_detector_model_analysis_output {
    /// A builder for [`StartDetectorModelAnalysisOutput`](crate::output::StartDetectorModelAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that you can use to retrieve the analysis result.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID that you can use to retrieve the analysis result.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDetectorModelAnalysisOutput`](crate::output::StartDetectorModelAnalysisOutput)
        pub fn build(self) -> crate::output::StartDetectorModelAnalysisOutput {
            crate::output::StartDetectorModelAnalysisOutput {
                analysis_id: self.analysis_id,
            }
        }
    }
}
impl StartDetectorModelAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`StartDetectorModelAnalysisOutput`](crate::output::StartDetectorModelAnalysisOutput)
    pub fn builder() -> crate::output::start_detector_model_analysis_output::Builder {
        crate::output::start_detector_model_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLoggingOptionsOutput {}
impl std::fmt::Debug for PutLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLoggingOptionsOutput");
        formatter.finish()
    }
}
/// See [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
pub mod put_logging_options_output {
    /// A builder for [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
        pub fn build(self) -> crate::output::PutLoggingOptionsOutput {
            crate::output::PutLoggingOptionsOutput {}
        }
    }
}
impl PutLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)
    pub fn builder() -> crate::output::put_logging_options_output::Builder {
        crate::output::put_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags assigned to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputsOutput {
    /// <p>Summary information about the inputs.</p>
    pub input_summaries: std::option::Option<std::vec::Vec<crate::model::InputSummary>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListInputsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputsOutput");
        formatter.field("input_summaries", &self.input_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputsOutput`](crate::output::ListInputsOutput)
pub mod list_inputs_output {
    /// A builder for [`ListInputsOutput`](crate::output::ListInputsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_summaries: std::option::Option<std::vec::Vec<crate::model::InputSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `input_summaries`.
        ///
        /// To override the contents of this collection use [`set_input_summaries`](Self::set_input_summaries).
        ///
        /// <p>Summary information about the inputs.</p>
        pub fn input_summaries(mut self, input: impl Into<crate::model::InputSummary>) -> Self {
            let mut v = self.input_summaries.unwrap_or_default();
            v.push(input.into());
            self.input_summaries = Some(v);
            self
        }
        /// <p>Summary information about the inputs.</p>
        pub fn set_input_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSummary>>,
        ) -> Self {
            self.input_summaries = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputsOutput`](crate::output::ListInputsOutput)
        pub fn build(self) -> crate::output::ListInputsOutput {
            crate::output::ListInputsOutput {
                input_summaries: self.input_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputsOutput {
    /// Creates a new builder-style object to manufacture [`ListInputsOutput`](crate::output::ListInputsOutput)
    pub fn builder() -> crate::output::list_inputs_output::Builder {
        crate::output::list_inputs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInputRoutingsOutput {
    /// <p>
    /// Summary information about the routed resources.
    /// </p>
    pub routed_resources: std::option::Option<std::vec::Vec<crate::model::RoutedResource>>,
    /// <p>
    /// The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListInputRoutingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInputRoutingsOutput");
        formatter.field("routed_resources", &self.routed_resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInputRoutingsOutput`](crate::output::ListInputRoutingsOutput)
pub mod list_input_routings_output {
    /// A builder for [`ListInputRoutingsOutput`](crate::output::ListInputRoutingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routed_resources:
            std::option::Option<std::vec::Vec<crate::model::RoutedResource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `routed_resources`.
        ///
        /// To override the contents of this collection use [`set_routed_resources`](Self::set_routed_resources).
        ///
        /// <p>
        /// Summary information about the routed resources.
        /// </p>
        pub fn routed_resources(mut self, input: impl Into<crate::model::RoutedResource>) -> Self {
            let mut v = self.routed_resources.unwrap_or_default();
            v.push(input.into());
            self.routed_resources = Some(v);
            self
        }
        /// <p>
        /// Summary information about the routed resources.
        /// </p>
        pub fn set_routed_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutedResource>>,
        ) -> Self {
            self.routed_resources = input;
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInputRoutingsOutput`](crate::output::ListInputRoutingsOutput)
        pub fn build(self) -> crate::output::ListInputRoutingsOutput {
            crate::output::ListInputRoutingsOutput {
                routed_resources: self.routed_resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInputRoutingsOutput {
    /// Creates a new builder-style object to manufacture [`ListInputRoutingsOutput`](crate::output::ListInputRoutingsOutput)
    pub fn builder() -> crate::output::list_input_routings_output::Builder {
        crate::output::list_input_routings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorModelVersionsOutput {
    /// <p>Summary information about the detector model versions.</p>
    pub detector_model_version_summaries:
        std::option::Option<std::vec::Vec<crate::model::DetectorModelVersionSummary>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDetectorModelVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorModelVersionsOutput");
        formatter.field(
            "detector_model_version_summaries",
            &self.detector_model_version_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDetectorModelVersionsOutput`](crate::output::ListDetectorModelVersionsOutput)
pub mod list_detector_model_versions_output {
    /// A builder for [`ListDetectorModelVersionsOutput`](crate::output::ListDetectorModelVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_version_summaries:
            std::option::Option<std::vec::Vec<crate::model::DetectorModelVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `detector_model_version_summaries`.
        ///
        /// To override the contents of this collection use [`set_detector_model_version_summaries`](Self::set_detector_model_version_summaries).
        ///
        /// <p>Summary information about the detector model versions.</p>
        pub fn detector_model_version_summaries(
            mut self,
            input: impl Into<crate::model::DetectorModelVersionSummary>,
        ) -> Self {
            let mut v = self.detector_model_version_summaries.unwrap_or_default();
            v.push(input.into());
            self.detector_model_version_summaries = Some(v);
            self
        }
        /// <p>Summary information about the detector model versions.</p>
        pub fn set_detector_model_version_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DetectorModelVersionSummary>>,
        ) -> Self {
            self.detector_model_version_summaries = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorModelVersionsOutput`](crate::output::ListDetectorModelVersionsOutput)
        pub fn build(self) -> crate::output::ListDetectorModelVersionsOutput {
            crate::output::ListDetectorModelVersionsOutput {
                detector_model_version_summaries: self.detector_model_version_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDetectorModelVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDetectorModelVersionsOutput`](crate::output::ListDetectorModelVersionsOutput)
    pub fn builder() -> crate::output::list_detector_model_versions_output::Builder {
        crate::output::list_detector_model_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorModelsOutput {
    /// <p>Summary information about the detector models.</p>
    pub detector_model_summaries:
        std::option::Option<std::vec::Vec<crate::model::DetectorModelSummary>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDetectorModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorModelsOutput");
        formatter.field("detector_model_summaries", &self.detector_model_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDetectorModelsOutput`](crate::output::ListDetectorModelsOutput)
pub mod list_detector_models_output {
    /// A builder for [`ListDetectorModelsOutput`](crate::output::ListDetectorModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_summaries:
            std::option::Option<std::vec::Vec<crate::model::DetectorModelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `detector_model_summaries`.
        ///
        /// To override the contents of this collection use [`set_detector_model_summaries`](Self::set_detector_model_summaries).
        ///
        /// <p>Summary information about the detector models.</p>
        pub fn detector_model_summaries(
            mut self,
            input: impl Into<crate::model::DetectorModelSummary>,
        ) -> Self {
            let mut v = self.detector_model_summaries.unwrap_or_default();
            v.push(input.into());
            self.detector_model_summaries = Some(v);
            self
        }
        /// <p>Summary information about the detector models.</p>
        pub fn set_detector_model_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DetectorModelSummary>>,
        ) -> Self {
            self.detector_model_summaries = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorModelsOutput`](crate::output::ListDetectorModelsOutput)
        pub fn build(self) -> crate::output::ListDetectorModelsOutput {
            crate::output::ListDetectorModelsOutput {
                detector_model_summaries: self.detector_model_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDetectorModelsOutput {
    /// Creates a new builder-style object to manufacture [`ListDetectorModelsOutput`](crate::output::ListDetectorModelsOutput)
    pub fn builder() -> crate::output::list_detector_models_output::Builder {
        crate::output::list_detector_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmModelVersionsOutput {
    /// <p>A list that summarizes each alarm model version.</p>
    pub alarm_model_version_summaries:
        std::option::Option<std::vec::Vec<crate::model::AlarmModelVersionSummary>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAlarmModelVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmModelVersionsOutput");
        formatter.field(
            "alarm_model_version_summaries",
            &self.alarm_model_version_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAlarmModelVersionsOutput`](crate::output::ListAlarmModelVersionsOutput)
pub mod list_alarm_model_versions_output {
    /// A builder for [`ListAlarmModelVersionsOutput`](crate::output::ListAlarmModelVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_version_summaries:
            std::option::Option<std::vec::Vec<crate::model::AlarmModelVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `alarm_model_version_summaries`.
        ///
        /// To override the contents of this collection use [`set_alarm_model_version_summaries`](Self::set_alarm_model_version_summaries).
        ///
        /// <p>A list that summarizes each alarm model version.</p>
        pub fn alarm_model_version_summaries(
            mut self,
            input: impl Into<crate::model::AlarmModelVersionSummary>,
        ) -> Self {
            let mut v = self.alarm_model_version_summaries.unwrap_or_default();
            v.push(input.into());
            self.alarm_model_version_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each alarm model version.</p>
        pub fn set_alarm_model_version_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlarmModelVersionSummary>>,
        ) -> Self {
            self.alarm_model_version_summaries = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmModelVersionsOutput`](crate::output::ListAlarmModelVersionsOutput)
        pub fn build(self) -> crate::output::ListAlarmModelVersionsOutput {
            crate::output::ListAlarmModelVersionsOutput {
                alarm_model_version_summaries: self.alarm_model_version_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAlarmModelVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAlarmModelVersionsOutput`](crate::output::ListAlarmModelVersionsOutput)
    pub fn builder() -> crate::output::list_alarm_model_versions_output::Builder {
        crate::output::list_alarm_model_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmModelsOutput {
    /// <p>A list that summarizes each alarm model.</p>
    pub alarm_model_summaries: std::option::Option<std::vec::Vec<crate::model::AlarmModelSummary>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAlarmModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmModelsOutput");
        formatter.field("alarm_model_summaries", &self.alarm_model_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAlarmModelsOutput`](crate::output::ListAlarmModelsOutput)
pub mod list_alarm_models_output {
    /// A builder for [`ListAlarmModelsOutput`](crate::output::ListAlarmModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_model_summaries:
            std::option::Option<std::vec::Vec<crate::model::AlarmModelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `alarm_model_summaries`.
        ///
        /// To override the contents of this collection use [`set_alarm_model_summaries`](Self::set_alarm_model_summaries).
        ///
        /// <p>A list that summarizes each alarm model.</p>
        pub fn alarm_model_summaries(
            mut self,
            input: impl Into<crate::model::AlarmModelSummary>,
        ) -> Self {
            let mut v = self.alarm_model_summaries.unwrap_or_default();
            v.push(input.into());
            self.alarm_model_summaries = Some(v);
            self
        }
        /// <p>A list that summarizes each alarm model.</p>
        pub fn set_alarm_model_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlarmModelSummary>>,
        ) -> Self {
            self.alarm_model_summaries = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmModelsOutput`](crate::output::ListAlarmModelsOutput)
        pub fn build(self) -> crate::output::ListAlarmModelsOutput {
            crate::output::ListAlarmModelsOutput {
                alarm_model_summaries: self.alarm_model_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAlarmModelsOutput {
    /// Creates a new builder-style object to manufacture [`ListAlarmModelsOutput`](crate::output::ListAlarmModelsOutput)
    pub fn builder() -> crate::output::list_alarm_models_output::Builder {
        crate::output::list_alarm_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorModelAnalysisResultsOutput {
    /// <p>Contains information about one or more analysis results.</p>
    pub analysis_results: std::option::Option<std::vec::Vec<crate::model::AnalysisResult>>,
    /// <p>The token that you can use to return the next set of results,
    /// or <code>null</code> if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDetectorModelAnalysisResultsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorModelAnalysisResultsOutput");
        formatter.field("analysis_results", &self.analysis_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDetectorModelAnalysisResultsOutput`](crate::output::GetDetectorModelAnalysisResultsOutput)
pub mod get_detector_model_analysis_results_output {
    /// A builder for [`GetDetectorModelAnalysisResultsOutput`](crate::output::GetDetectorModelAnalysisResultsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_results:
            std::option::Option<std::vec::Vec<crate::model::AnalysisResult>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `analysis_results`.
        ///
        /// To override the contents of this collection use [`set_analysis_results`](Self::set_analysis_results).
        ///
        /// <p>Contains information about one or more analysis results.</p>
        pub fn analysis_results(mut self, input: impl Into<crate::model::AnalysisResult>) -> Self {
            let mut v = self.analysis_results.unwrap_or_default();
            v.push(input.into());
            self.analysis_results = Some(v);
            self
        }
        /// <p>Contains information about one or more analysis results.</p>
        pub fn set_analysis_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisResult>>,
        ) -> Self {
            self.analysis_results = input;
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can use to return the next set of results,
        /// or <code>null</code> if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorModelAnalysisResultsOutput`](crate::output::GetDetectorModelAnalysisResultsOutput)
        pub fn build(self) -> crate::output::GetDetectorModelAnalysisResultsOutput {
            crate::output::GetDetectorModelAnalysisResultsOutput {
                analysis_results: self.analysis_results,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDetectorModelAnalysisResultsOutput {
    /// Creates a new builder-style object to manufacture [`GetDetectorModelAnalysisResultsOutput`](crate::output::GetDetectorModelAnalysisResultsOutput)
    pub fn builder() -> crate::output::get_detector_model_analysis_results_output::Builder {
        crate::output::get_detector_model_analysis_results_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingOptionsOutput {
    /// <p>The current settings of the AWS IoT Events logging options.</p>
    pub logging_options: std::option::Option<crate::model::LoggingOptions>,
}
impl std::fmt::Debug for DescribeLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingOptionsOutput");
        formatter.field("logging_options", &self.logging_options);
        formatter.finish()
    }
}
/// See [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
pub mod describe_logging_options_output {
    /// A builder for [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_options: std::option::Option<crate::model::LoggingOptions>,
    }
    impl Builder {
        /// <p>The current settings of the AWS IoT Events logging options.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.logging_options = Some(input);
            self
        }
        /// <p>The current settings of the AWS IoT Events logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.logging_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
        pub fn build(self) -> crate::output::DescribeLoggingOptionsOutput {
            crate::output::DescribeLoggingOptionsOutput {
                logging_options: self.logging_options,
            }
        }
    }
}
impl DescribeLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput)
    pub fn builder() -> crate::output::describe_logging_options_output::Builder {
        crate::output::describe_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInputOutput {
    /// <p>Information about the input.</p>
    pub input: std::option::Option<crate::model::Input>,
}
impl std::fmt::Debug for DescribeInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInputOutput");
        formatter.field("input", &self.input);
        formatter.finish()
    }
}
/// See [`DescribeInputOutput`](crate::output::DescribeInputOutput)
pub mod describe_input_output {
    /// A builder for [`DescribeInputOutput`](crate::output::DescribeInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::Input>,
    }
    impl Builder {
        /// <p>Information about the input.</p>
        pub fn input(mut self, input: crate::model::Input) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>Information about the input.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::Input>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInputOutput`](crate::output::DescribeInputOutput)
        pub fn build(self) -> crate::output::DescribeInputOutput {
            crate::output::DescribeInputOutput { input: self.input }
        }
    }
}
impl DescribeInputOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInputOutput`](crate::output::DescribeInputOutput)
    pub fn builder() -> crate::output::describe_input_output::Builder {
        crate::output::describe_input_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorModelAnalysisOutput {
    /// <p>The status of the analysis activity. The status can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take
    /// several minutes to complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again
    /// later.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AnalysisStatus>,
}
impl std::fmt::Debug for DescribeDetectorModelAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorModelAnalysisOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeDetectorModelAnalysisOutput`](crate::output::DescribeDetectorModelAnalysisOutput)
pub mod describe_detector_model_analysis_output {
    /// A builder for [`DescribeDetectorModelAnalysisOutput`](crate::output::DescribeDetectorModelAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AnalysisStatus>,
    }
    impl Builder {
        /// <p>The status of the analysis activity. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take
        /// several minutes to complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again
        /// later.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AnalysisStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the analysis activity. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take
        /// several minutes to complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - AWS IoT Events couldn't analyze your detector model. Try again
        /// later.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnalysisStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorModelAnalysisOutput`](crate::output::DescribeDetectorModelAnalysisOutput)
        pub fn build(self) -> crate::output::DescribeDetectorModelAnalysisOutput {
            crate::output::DescribeDetectorModelAnalysisOutput {
                status: self.status,
            }
        }
    }
}
impl DescribeDetectorModelAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDetectorModelAnalysisOutput`](crate::output::DescribeDetectorModelAnalysisOutput)
    pub fn builder() -> crate::output::describe_detector_model_analysis_output::Builder {
        crate::output::describe_detector_model_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectorModelOutput {
    /// <p>Information about the detector model.</p>
    pub detector_model: std::option::Option<crate::model::DetectorModel>,
}
impl std::fmt::Debug for DescribeDetectorModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectorModelOutput");
        formatter.field("detector_model", &self.detector_model);
        formatter.finish()
    }
}
/// See [`DescribeDetectorModelOutput`](crate::output::DescribeDetectorModelOutput)
pub mod describe_detector_model_output {
    /// A builder for [`DescribeDetectorModelOutput`](crate::output::DescribeDetectorModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model: std::option::Option<crate::model::DetectorModel>,
    }
    impl Builder {
        /// <p>Information about the detector model.</p>
        pub fn detector_model(mut self, input: crate::model::DetectorModel) -> Self {
            self.detector_model = Some(input);
            self
        }
        /// <p>Information about the detector model.</p>
        pub fn set_detector_model(
            mut self,
            input: std::option::Option<crate::model::DetectorModel>,
        ) -> Self {
            self.detector_model = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectorModelOutput`](crate::output::DescribeDetectorModelOutput)
        pub fn build(self) -> crate::output::DescribeDetectorModelOutput {
            crate::output::DescribeDetectorModelOutput {
                detector_model: self.detector_model,
            }
        }
    }
}
impl DescribeDetectorModelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDetectorModelOutput`](crate::output::DescribeDetectorModelOutput)
    pub fn builder() -> crate::output::describe_detector_model_output::Builder {
        crate::output::describe_detector_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlarmModelOutput {
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub alarm_model_arn: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the alarm model. The status can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
    /// Activating an alarm model can take up to a few minutes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
    /// Check your alarm model information and update the alarm model.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
    /// and try again.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AlarmModelVersionStatus>,
    /// <p>
    /// Contains information about the status of the alarm model.
    /// </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The name of the alarm model.</p>
    pub alarm_model_name: std::option::Option<std::string::String>,
    /// <p>The description of the alarm model.</p>
    pub alarm_model_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An input attribute used as a key to create an alarm.
    /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
    /// associated with this key to the alarm.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
    pub severity: std::option::Option<i32>,
    /// <p>Defines when your alarm is invoked.</p>
    pub alarm_rule: std::option::Option<crate::model::AlarmRule>,
    /// <p>Contains information about one or more notification actions.</p>
    pub alarm_notification: std::option::Option<crate::model::AlarmNotification>,
    /// <p>Contains information about one or more alarm actions.</p>
    pub alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
    /// <p>Contains the configuration information of alarm state changes.</p>
    pub alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
}
impl std::fmt::Debug for DescribeAlarmModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlarmModelOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("alarm_model_arn", &self.alarm_model_arn);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("alarm_model_name", &self.alarm_model_name);
        formatter.field("alarm_model_description", &self.alarm_model_description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("key", &self.key);
        formatter.field("severity", &self.severity);
        formatter.field("alarm_rule", &self.alarm_rule);
        formatter.field("alarm_notification", &self.alarm_notification);
        formatter.field("alarm_event_actions", &self.alarm_event_actions);
        formatter.field("alarm_capabilities", &self.alarm_capabilities);
        formatter.finish()
    }
}
/// See [`DescribeAlarmModelOutput`](crate::output::DescribeAlarmModelOutput)
pub mod describe_alarm_model_output {
    /// A builder for [`DescribeAlarmModelOutput`](crate::output::DescribeAlarmModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alarm_model_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AlarmModelVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) alarm_model_name: std::option::Option<std::string::String>,
        pub(crate) alarm_model_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<i32>,
        pub(crate) alarm_rule: std::option::Option<crate::model::AlarmRule>,
        pub(crate) alarm_notification: std::option::Option<crate::model::AlarmNotification>,
        pub(crate) alarm_event_actions: std::option::Option<crate::model::AlarmEventActions>,
        pub(crate) alarm_capabilities: std::option::Option<crate::model::AlarmCapabilities>,
    }
    impl Builder {
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn alarm_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_alarm_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_arn = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AlarmModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlarmModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// Contains information about the status of the alarm model.
        /// </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>
        /// Contains information about the status of the alarm model.
        /// </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn alarm_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm model.</p>
        pub fn set_alarm_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_name = input;
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn alarm_model_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_description = Some(input.into());
            self
        }
        /// <p>The description of the alarm model.</p>
        pub fn set_alarm_model_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_description = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>An input attribute used as a key to create an alarm.
        /// AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a>
        /// associated with this key to the alarm.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn severity(mut self, input: i32) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>A non-negative integer that reflects the severity level of the alarm.</p>
        pub fn set_severity(mut self, input: std::option::Option<i32>) -> Self {
            self.severity = input;
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn alarm_rule(mut self, input: crate::model::AlarmRule) -> Self {
            self.alarm_rule = Some(input);
            self
        }
        /// <p>Defines when your alarm is invoked.</p>
        pub fn set_alarm_rule(
            mut self,
            input: std::option::Option<crate::model::AlarmRule>,
        ) -> Self {
            self.alarm_rule = input;
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn alarm_notification(mut self, input: crate::model::AlarmNotification) -> Self {
            self.alarm_notification = Some(input);
            self
        }
        /// <p>Contains information about one or more notification actions.</p>
        pub fn set_alarm_notification(
            mut self,
            input: std::option::Option<crate::model::AlarmNotification>,
        ) -> Self {
            self.alarm_notification = input;
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn alarm_event_actions(mut self, input: crate::model::AlarmEventActions) -> Self {
            self.alarm_event_actions = Some(input);
            self
        }
        /// <p>Contains information about one or more alarm actions.</p>
        pub fn set_alarm_event_actions(
            mut self,
            input: std::option::Option<crate::model::AlarmEventActions>,
        ) -> Self {
            self.alarm_event_actions = input;
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn alarm_capabilities(mut self, input: crate::model::AlarmCapabilities) -> Self {
            self.alarm_capabilities = Some(input);
            self
        }
        /// <p>Contains the configuration information of alarm state changes.</p>
        pub fn set_alarm_capabilities(
            mut self,
            input: std::option::Option<crate::model::AlarmCapabilities>,
        ) -> Self {
            self.alarm_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlarmModelOutput`](crate::output::DescribeAlarmModelOutput)
        pub fn build(self) -> crate::output::DescribeAlarmModelOutput {
            crate::output::DescribeAlarmModelOutput {
                creation_time: self.creation_time,
                alarm_model_arn: self.alarm_model_arn,
                alarm_model_version: self.alarm_model_version,
                last_update_time: self.last_update_time,
                status: self.status,
                status_message: self.status_message,
                alarm_model_name: self.alarm_model_name,
                alarm_model_description: self.alarm_model_description,
                role_arn: self.role_arn,
                key: self.key,
                severity: self.severity,
                alarm_rule: self.alarm_rule,
                alarm_notification: self.alarm_notification,
                alarm_event_actions: self.alarm_event_actions,
                alarm_capabilities: self.alarm_capabilities,
            }
        }
    }
}
impl DescribeAlarmModelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAlarmModelOutput`](crate::output::DescribeAlarmModelOutput)
    pub fn builder() -> crate::output::describe_alarm_model_output::Builder {
        crate::output::describe_alarm_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInputOutput {}
impl std::fmt::Debug for DeleteInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInputOutput");
        formatter.finish()
    }
}
/// See [`DeleteInputOutput`](crate::output::DeleteInputOutput)
pub mod delete_input_output {
    /// A builder for [`DeleteInputOutput`](crate::output::DeleteInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteInputOutput`](crate::output::DeleteInputOutput)
        pub fn build(self) -> crate::output::DeleteInputOutput {
            crate::output::DeleteInputOutput {}
        }
    }
}
impl DeleteInputOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInputOutput`](crate::output::DeleteInputOutput)
    pub fn builder() -> crate::output::delete_input_output::Builder {
        crate::output::delete_input_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorModelOutput {}
impl std::fmt::Debug for DeleteDetectorModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorModelOutput");
        formatter.finish()
    }
}
/// See [`DeleteDetectorModelOutput`](crate::output::DeleteDetectorModelOutput)
pub mod delete_detector_model_output {
    /// A builder for [`DeleteDetectorModelOutput`](crate::output::DeleteDetectorModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDetectorModelOutput`](crate::output::DeleteDetectorModelOutput)
        pub fn build(self) -> crate::output::DeleteDetectorModelOutput {
            crate::output::DeleteDetectorModelOutput {}
        }
    }
}
impl DeleteDetectorModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorModelOutput`](crate::output::DeleteDetectorModelOutput)
    pub fn builder() -> crate::output::delete_detector_model_output::Builder {
        crate::output::delete_detector_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlarmModelOutput {}
impl std::fmt::Debug for DeleteAlarmModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlarmModelOutput");
        formatter.finish()
    }
}
/// See [`DeleteAlarmModelOutput`](crate::output::DeleteAlarmModelOutput)
pub mod delete_alarm_model_output {
    /// A builder for [`DeleteAlarmModelOutput`](crate::output::DeleteAlarmModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAlarmModelOutput`](crate::output::DeleteAlarmModelOutput)
        pub fn build(self) -> crate::output::DeleteAlarmModelOutput {
            crate::output::DeleteAlarmModelOutput {}
        }
    }
}
impl DeleteAlarmModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAlarmModelOutput`](crate::output::DeleteAlarmModelOutput)
    pub fn builder() -> crate::output::delete_alarm_model_output::Builder {
        crate::output::delete_alarm_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInputOutput {
    /// <p>Information about the configuration of the input.</p>
    pub input_configuration: std::option::Option<crate::model::InputConfiguration>,
}
impl std::fmt::Debug for CreateInputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInputOutput");
        formatter.field("input_configuration", &self.input_configuration);
        formatter.finish()
    }
}
/// See [`CreateInputOutput`](crate::output::CreateInputOutput)
pub mod create_input_output {
    /// A builder for [`CreateInputOutput`](crate::output::CreateInputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_configuration: std::option::Option<crate::model::InputConfiguration>,
    }
    impl Builder {
        /// <p>Information about the configuration of the input.</p>
        pub fn input_configuration(mut self, input: crate::model::InputConfiguration) -> Self {
            self.input_configuration = Some(input);
            self
        }
        /// <p>Information about the configuration of the input.</p>
        pub fn set_input_configuration(
            mut self,
            input: std::option::Option<crate::model::InputConfiguration>,
        ) -> Self {
            self.input_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInputOutput`](crate::output::CreateInputOutput)
        pub fn build(self) -> crate::output::CreateInputOutput {
            crate::output::CreateInputOutput {
                input_configuration: self.input_configuration,
            }
        }
    }
}
impl CreateInputOutput {
    /// Creates a new builder-style object to manufacture [`CreateInputOutput`](crate::output::CreateInputOutput)
    pub fn builder() -> crate::output::create_input_output::Builder {
        crate::output::create_input_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDetectorModelOutput {
    /// <p>Information about how the detector model is configured.</p>
    pub detector_model_configuration: std::option::Option<crate::model::DetectorModelConfiguration>,
}
impl std::fmt::Debug for CreateDetectorModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDetectorModelOutput");
        formatter.field(
            "detector_model_configuration",
            &self.detector_model_configuration,
        );
        formatter.finish()
    }
}
/// See [`CreateDetectorModelOutput`](crate::output::CreateDetectorModelOutput)
pub mod create_detector_model_output {
    /// A builder for [`CreateDetectorModelOutput`](crate::output::CreateDetectorModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_model_configuration:
            std::option::Option<crate::model::DetectorModelConfiguration>,
    }
    impl Builder {
        /// <p>Information about how the detector model is configured.</p>
        pub fn detector_model_configuration(
            mut self,
            input: crate::model::DetectorModelConfiguration,
        ) -> Self {
            self.detector_model_configuration = Some(input);
            self
        }
        /// <p>Information about how the detector model is configured.</p>
        pub fn set_detector_model_configuration(
            mut self,
            input: std::option::Option<crate::model::DetectorModelConfiguration>,
        ) -> Self {
            self.detector_model_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDetectorModelOutput`](crate::output::CreateDetectorModelOutput)
        pub fn build(self) -> crate::output::CreateDetectorModelOutput {
            crate::output::CreateDetectorModelOutput {
                detector_model_configuration: self.detector_model_configuration,
            }
        }
    }
}
impl CreateDetectorModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateDetectorModelOutput`](crate::output::CreateDetectorModelOutput)
    pub fn builder() -> crate::output::create_detector_model_output::Builder {
        crate::output::create_detector_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAlarmModelOutput {
    /// <p>The time the alarm model was created, in the Unix epoch format.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub alarm_model_arn: std::option::Option<std::string::String>,
    /// <p>The version of the alarm model.</p>
    pub alarm_model_version: std::option::Option<std::string::String>,
    /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the alarm model. The status can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
    /// Activating an alarm model can take up to a few minutes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
    /// Check your alarm model information and update the alarm model.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
    /// and try again.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AlarmModelVersionStatus>,
}
impl std::fmt::Debug for CreateAlarmModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAlarmModelOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("alarm_model_arn", &self.alarm_model_arn);
        formatter.field("alarm_model_version", &self.alarm_model_version);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateAlarmModelOutput`](crate::output::CreateAlarmModelOutput)
pub mod create_alarm_model_output {
    /// A builder for [`CreateAlarmModelOutput`](crate::output::CreateAlarmModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alarm_model_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_model_version: std::option::Option<std::string::String>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AlarmModelVersionStatus>,
    }
    impl Builder {
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the alarm model was created, in the Unix epoch format.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn alarm_model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_alarm_model_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_arn = input;
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn alarm_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_model_version = Some(input.into());
            self
        }
        /// <p>The version of the alarm model.</p>
        pub fn set_alarm_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_model_version = input;
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The time the alarm model was last updated, in the Unix epoch format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AlarmModelVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the alarm model. The status can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model.
        /// Activating an alarm model can take up to a few minutes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data.
        /// Check your alarm model information and update the alarm model.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
        /// and try again.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AlarmModelVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlarmModelOutput`](crate::output::CreateAlarmModelOutput)
        pub fn build(self) -> crate::output::CreateAlarmModelOutput {
            crate::output::CreateAlarmModelOutput {
                creation_time: self.creation_time,
                alarm_model_arn: self.alarm_model_arn,
                alarm_model_version: self.alarm_model_version,
                last_update_time: self.last_update_time,
                status: self.status,
            }
        }
    }
}
impl CreateAlarmModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateAlarmModelOutput`](crate::output::CreateAlarmModelOutput)
    pub fn builder() -> crate::output::create_alarm_model_output::Builder {
        crate::output::create_alarm_model_output::Builder::default()
    }
}
