// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Core Device Advisor
///
/// Client for invoking operations on AWS IoT Core Device Advisor. Each operation on AWS IoT Core Device Advisor is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotdeviceadvisor::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotdeviceadvisor::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotdeviceadvisor::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateSuiteDefinition`](crate::client::fluent_builders::CreateSuiteDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_configuration(SuiteDefinitionConfiguration)`](crate::client::fluent_builders::CreateSuiteDefinition::suite_definition_configuration) / [`set_suite_definition_configuration(Option<SuiteDefinitionConfiguration>)`](crate::client::fluent_builders::CreateSuiteDefinition::set_suite_definition_configuration): <p>Creates a Device Advisor test suite with suite definition configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSuiteDefinition::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSuiteDefinition::set_tags): <p>The tags to be attached to the suite definition.</p>
    /// - On success, responds with [`CreateSuiteDefinitionOutput`](crate::output::CreateSuiteDefinitionOutput) with field(s):
    ///   - [`suite_definition_id(Option<String>)`](crate::output::CreateSuiteDefinitionOutput::suite_definition_id): <p>Creates a Device Advisor test suite with suite UUID.</p>
    ///   - [`suite_definition_arn(Option<String>)`](crate::output::CreateSuiteDefinitionOutput::suite_definition_arn): <p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>
    ///   - [`suite_definition_name(Option<String>)`](crate::output::CreateSuiteDefinitionOutput::suite_definition_name): <p>Creates a Device Advisor test suite with suite definition name.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateSuiteDefinitionOutput::created_at): <p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>
    /// - On failure, responds with [`SdkError<CreateSuiteDefinitionError>`](crate::error::CreateSuiteDefinitionError)
    pub fn create_suite_definition(&self) -> fluent_builders::CreateSuiteDefinition<C, M, R> {
        fluent_builders::CreateSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSuiteDefinition`](crate::client::fluent_builders::DeleteSuiteDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSuiteDefinition::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::DeleteSuiteDefinition::set_suite_definition_id): <p>Suite definition ID of the test suite to be deleted.</p>
    /// - On success, responds with [`DeleteSuiteDefinitionOutput`](crate::output::DeleteSuiteDefinitionOutput)

    /// - On failure, responds with [`SdkError<DeleteSuiteDefinitionError>`](crate::error::DeleteSuiteDefinitionError)
    pub fn delete_suite_definition(&self) -> fluent_builders::DeleteSuiteDefinition<C, M, R> {
        fluent_builders::DeleteSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEndpoint`](crate::client::fluent_builders::GetEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::GetEndpoint::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::GetEndpoint::set_thing_arn): <p>The thing ARN of the device. This is an optional parameter.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::GetEndpoint::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::GetEndpoint::set_certificate_arn): <p>The certificate ARN of the device. This is an optional parameter.</p>
    /// - On success, responds with [`GetEndpointOutput`](crate::output::GetEndpointOutput) with field(s):
    ///   - [`endpoint(Option<String>)`](crate::output::GetEndpointOutput::endpoint): <p>The response of an Device Advisor endpoint.</p>
    /// - On failure, responds with [`SdkError<GetEndpointError>`](crate::error::GetEndpointError)
    pub fn get_endpoint(&self) -> fluent_builders::GetEndpoint<C, M, R> {
        fluent_builders::GetEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSuiteDefinition`](crate::client::fluent_builders::GetSuiteDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::GetSuiteDefinition::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::GetSuiteDefinition::set_suite_definition_id): <p>Suite definition ID of the test suite to get.</p>
    ///   - [`suite_definition_version(impl Into<String>)`](crate::client::fluent_builders::GetSuiteDefinition::suite_definition_version) / [`set_suite_definition_version(Option<String>)`](crate::client::fluent_builders::GetSuiteDefinition::set_suite_definition_version): <p>Suite definition version of the test suite to get.</p>
    /// - On success, responds with [`GetSuiteDefinitionOutput`](crate::output::GetSuiteDefinitionOutput) with field(s):
    ///   - [`suite_definition_id(Option<String>)`](crate::output::GetSuiteDefinitionOutput::suite_definition_id): <p>Suite definition ID of the suite definition.</p>
    ///   - [`suite_definition_arn(Option<String>)`](crate::output::GetSuiteDefinitionOutput::suite_definition_arn): <p>The ARN of the suite definition.</p>
    ///   - [`suite_definition_version(Option<String>)`](crate::output::GetSuiteDefinitionOutput::suite_definition_version): <p>Suite definition version of the suite definition.</p>
    ///   - [`latest_version(Option<String>)`](crate::output::GetSuiteDefinitionOutput::latest_version): <p>Latest suite definition version of the suite definition.</p>
    ///   - [`suite_definition_configuration(Option<SuiteDefinitionConfiguration>)`](crate::output::GetSuiteDefinitionOutput::suite_definition_configuration): <p>Suite configuration of the suite definition.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetSuiteDefinitionOutput::created_at): <p>Date (in Unix epoch time) when the suite definition was created.</p>
    ///   - [`last_modified_at(Option<DateTime>)`](crate::output::GetSuiteDefinitionOutput::last_modified_at): <p>Date (in Unix epoch time) when the suite definition was last modified.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetSuiteDefinitionOutput::tags): <p>Tags attached to the suite definition.</p>
    /// - On failure, responds with [`SdkError<GetSuiteDefinitionError>`](crate::error::GetSuiteDefinitionError)
    pub fn get_suite_definition(&self) -> fluent_builders::GetSuiteDefinition<C, M, R> {
        fluent_builders::GetSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSuiteRun`](crate::client::fluent_builders::GetSuiteRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::GetSuiteRun::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::GetSuiteRun::set_suite_definition_id): <p>Suite definition ID for the test suite run.</p>
    ///   - [`suite_run_id(impl Into<String>)`](crate::client::fluent_builders::GetSuiteRun::suite_run_id) / [`set_suite_run_id(Option<String>)`](crate::client::fluent_builders::GetSuiteRun::set_suite_run_id): <p>Suite run ID for the test suite run.</p>
    /// - On success, responds with [`GetSuiteRunOutput`](crate::output::GetSuiteRunOutput) with field(s):
    ///   - [`suite_definition_id(Option<String>)`](crate::output::GetSuiteRunOutput::suite_definition_id): <p>Suite definition ID for the test suite run.</p>
    ///   - [`suite_definition_version(Option<String>)`](crate::output::GetSuiteRunOutput::suite_definition_version): <p>Suite definition version for the test suite run.</p>
    ///   - [`suite_run_id(Option<String>)`](crate::output::GetSuiteRunOutput::suite_run_id): <p>Suite run ID for the test suite run.</p>
    ///   - [`suite_run_arn(Option<String>)`](crate::output::GetSuiteRunOutput::suite_run_arn): <p>The ARN of the suite run.</p>
    ///   - [`suite_run_configuration(Option<SuiteRunConfiguration>)`](crate::output::GetSuiteRunOutput::suite_run_configuration): <p>Suite run configuration for the test suite run.</p>
    ///   - [`test_result(Option<TestResult>)`](crate::output::GetSuiteRunOutput::test_result): <p>Test results for the test suite run.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetSuiteRunOutput::start_time): <p>Date (in Unix epoch time) when the test suite run started.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetSuiteRunOutput::end_time): <p>Date (in Unix epoch time) when the test suite run ended.</p>
    ///   - [`status(Option<SuiteRunStatus>)`](crate::output::GetSuiteRunOutput::status): <p>Status for the test suite run.</p>
    ///   - [`error_reason(Option<String>)`](crate::output::GetSuiteRunOutput::error_reason): <p>Error reason for any test suite run failure.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetSuiteRunOutput::tags): <p>The tags attached to the suite run.</p>
    /// - On failure, responds with [`SdkError<GetSuiteRunError>`](crate::error::GetSuiteRunError)
    pub fn get_suite_run(&self) -> fluent_builders::GetSuiteRun<C, M, R> {
        fluent_builders::GetSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSuiteRunReport`](crate::client::fluent_builders::GetSuiteRunReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::GetSuiteRunReport::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::GetSuiteRunReport::set_suite_definition_id): <p>Suite definition ID of the test suite.</p>
    ///   - [`suite_run_id(impl Into<String>)`](crate::client::fluent_builders::GetSuiteRunReport::suite_run_id) / [`set_suite_run_id(Option<String>)`](crate::client::fluent_builders::GetSuiteRunReport::set_suite_run_id): <p>Suite run ID of the test suite run.</p>
    /// - On success, responds with [`GetSuiteRunReportOutput`](crate::output::GetSuiteRunReportOutput) with field(s):
    ///   - [`qualification_report_download_url(Option<String>)`](crate::output::GetSuiteRunReportOutput::qualification_report_download_url): <p>Download URL of the qualification report.</p>
    /// - On failure, responds with [`SdkError<GetSuiteRunReportError>`](crate::error::GetSuiteRunReportError)
    pub fn get_suite_run_report(&self) -> fluent_builders::GetSuiteRunReport<C, M, R> {
        fluent_builders::GetSuiteRunReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSuiteDefinitions`](crate::client::fluent_builders::ListSuiteDefinitions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSuiteDefinitions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSuiteDefinitions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListSuiteDefinitions::set_max_results): <p>The maximum number of results to return at once.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSuiteDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSuiteDefinitions::set_next_token): <p>A token used to get the next set of results.</p>
    /// - On success, responds with [`ListSuiteDefinitionsOutput`](crate::output::ListSuiteDefinitionsOutput) with field(s):
    ///   - [`suite_definition_information_list(Option<Vec<SuiteDefinitionInformation>>)`](crate::output::ListSuiteDefinitionsOutput::suite_definition_information_list): <p>An array of objects that provide summaries of information about the suite definitions in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSuiteDefinitionsOutput::next_token): <p>A token used to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSuiteDefinitionsError>`](crate::error::ListSuiteDefinitionsError)
    pub fn list_suite_definitions(&self) -> fluent_builders::ListSuiteDefinitions<C, M, R> {
        fluent_builders::ListSuiteDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSuiteRuns`](crate::client::fluent_builders::ListSuiteRuns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSuiteRuns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::ListSuiteRuns::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::ListSuiteRuns::set_suite_definition_id): <p>Lists the test suite runs of the specified test suite based on suite definition ID.</p>
    ///   - [`suite_definition_version(impl Into<String>)`](crate::client::fluent_builders::ListSuiteRuns::suite_definition_version) / [`set_suite_definition_version(Option<String>)`](crate::client::fluent_builders::ListSuiteRuns::set_suite_definition_version): <p>Must be passed along with <code>suiteDefinitionId</code>. Lists the test suite runs of the specified test suite based on suite definition version.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSuiteRuns::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListSuiteRuns::set_max_results): <p>The maximum number of results to return at once.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSuiteRuns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSuiteRuns::set_next_token): <p>A token to retrieve the next set of results.</p>
    /// - On success, responds with [`ListSuiteRunsOutput`](crate::output::ListSuiteRunsOutput) with field(s):
    ///   - [`suite_runs_list(Option<Vec<SuiteRunInformation>>)`](crate::output::ListSuiteRunsOutput::suite_runs_list): <p>An array of objects that provide summaries of information about the suite runs in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSuiteRunsOutput::next_token): <p>A token to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSuiteRunsError>`](crate::error::ListSuiteRunsError)
    pub fn list_suite_runs(&self) -> fluent_builders::ListSuiteRuns<C, M, R> {
        fluent_builders::ListSuiteRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the IoT Device Advisor resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags attached to the IoT Device Advisor resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSuiteRun`](crate::client::fluent_builders::StartSuiteRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::StartSuiteRun::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::StartSuiteRun::set_suite_definition_id): <p>Suite definition ID of the test suite.</p>
    ///   - [`suite_definition_version(impl Into<String>)`](crate::client::fluent_builders::StartSuiteRun::suite_definition_version) / [`set_suite_definition_version(Option<String>)`](crate::client::fluent_builders::StartSuiteRun::set_suite_definition_version): <p>Suite definition version of the test suite.</p>
    ///   - [`suite_run_configuration(SuiteRunConfiguration)`](crate::client::fluent_builders::StartSuiteRun::suite_run_configuration) / [`set_suite_run_configuration(Option<SuiteRunConfiguration>)`](crate::client::fluent_builders::StartSuiteRun::set_suite_run_configuration): <p>Suite run configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartSuiteRun::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartSuiteRun::set_tags): <p>The tags to be attached to the suite run.</p>
    /// - On success, responds with [`StartSuiteRunOutput`](crate::output::StartSuiteRunOutput) with field(s):
    ///   - [`suite_run_id(Option<String>)`](crate::output::StartSuiteRunOutput::suite_run_id): <p>Suite Run ID of the started suite run.</p>
    ///   - [`suite_run_arn(Option<String>)`](crate::output::StartSuiteRunOutput::suite_run_arn): <p>Amazon Resource Name (ARN) of the started suite run.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::StartSuiteRunOutput::created_at): <p>Starts a Device Advisor test suite run based on suite create time.</p>
    /// - On failure, responds with [`SdkError<StartSuiteRunError>`](crate::error::StartSuiteRunError)
    pub fn start_suite_run(&self) -> fluent_builders::StartSuiteRun<C, M, R> {
        fluent_builders::StartSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopSuiteRun`](crate::client::fluent_builders::StopSuiteRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::StopSuiteRun::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::StopSuiteRun::set_suite_definition_id): <p>Suite definition ID of the test suite run to be stopped.</p>
    ///   - [`suite_run_id(impl Into<String>)`](crate::client::fluent_builders::StopSuiteRun::suite_run_id) / [`set_suite_run_id(Option<String>)`](crate::client::fluent_builders::StopSuiteRun::set_suite_run_id): <p>Suite run ID of the test suite run to be stopped.</p>
    /// - On success, responds with [`StopSuiteRunOutput`](crate::output::StopSuiteRunOutput)

    /// - On failure, responds with [`SdkError<StopSuiteRunError>`](crate::error::StopSuiteRunError)
    pub fn stop_suite_run(&self) -> fluent_builders::StopSuiteRun<C, M, R> {
        fluent_builders::StopSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The resource ARN of an IoT Device Advisor resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to be attached to the IoT Device Advisor resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The resource ARN of an IoT Device Advisor resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSuiteDefinition`](crate::client::fluent_builders::UpdateSuiteDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suite_definition_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSuiteDefinition::suite_definition_id) / [`set_suite_definition_id(Option<String>)`](crate::client::fluent_builders::UpdateSuiteDefinition::set_suite_definition_id): <p>Suite definition ID of the test suite to be updated.</p>
    ///   - [`suite_definition_configuration(SuiteDefinitionConfiguration)`](crate::client::fluent_builders::UpdateSuiteDefinition::suite_definition_configuration) / [`set_suite_definition_configuration(Option<SuiteDefinitionConfiguration>)`](crate::client::fluent_builders::UpdateSuiteDefinition::set_suite_definition_configuration): <p>Updates a Device Advisor test suite with suite definition configuration.</p>
    /// - On success, responds with [`UpdateSuiteDefinitionOutput`](crate::output::UpdateSuiteDefinitionOutput) with field(s):
    ///   - [`suite_definition_id(Option<String>)`](crate::output::UpdateSuiteDefinitionOutput::suite_definition_id): <p>Suite definition ID of the updated test suite.</p>
    ///   - [`suite_definition_arn(Option<String>)`](crate::output::UpdateSuiteDefinitionOutput::suite_definition_arn): <p>Amazon Resource Name (ARN) of the updated test suite.</p>
    ///   - [`suite_definition_name(Option<String>)`](crate::output::UpdateSuiteDefinitionOutput::suite_definition_name): <p>Suite definition name of the updated test suite.</p>
    ///   - [`suite_definition_version(Option<String>)`](crate::output::UpdateSuiteDefinitionOutput::suite_definition_version): <p>Suite definition version of the updated test suite.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateSuiteDefinitionOutput::created_at): <p>Timestamp of when the test suite was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::UpdateSuiteDefinitionOutput::last_updated_at): <p>Timestamp of when the test suite was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateSuiteDefinitionError>`](crate::error::UpdateSuiteDefinitionError)
    pub fn update_suite_definition(&self) -> fluent_builders::UpdateSuiteDefinition<C, M, R> {
        fluent_builders::UpdateSuiteDefinition::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateSuiteDefinition`.
    ///
    /// <p>Creates a Device Advisor test suite.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSuiteDefinition</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_suite_definition_input::Builder,
    }
    impl<C, M, R> CreateSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSuiteDefinitionInputOperationOutputAlias,
                crate::output::CreateSuiteDefinitionOutput,
                crate::error::CreateSuiteDefinitionError,
                crate::input::CreateSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            input: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.inner = self.inner.suite_definition_configuration(input);
            self
        }
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSuiteDefinition`.
    ///
    /// <p>Deletes a Device Advisor test suite.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSuiteDefinition</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_suite_definition_input::Builder,
    }
    impl<C, M, R> DeleteSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSuiteDefinitionInputOperationOutputAlias,
                crate::output::DeleteSuiteDefinitionOutput,
                crate::error::DeleteSuiteDefinitionError,
                crate::input::DeleteSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite to be deleted.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite to be deleted.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEndpoint`.
    ///
    /// <p>Gets information about an Device Advisor endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_endpoint_input::Builder,
    }
    impl<C, M, R> GetEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEndpointInputOperationOutputAlias,
                crate::output::GetEndpointOutput,
                crate::error::GetEndpointError,
                crate::input::GetEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The thing ARN of the device. This is an optional parameter.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The thing ARN of the device. This is an optional parameter.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
        /// <p>The certificate ARN of the device. This is an optional parameter.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The certificate ARN of the device. This is an optional parameter.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteDefinition`.
    ///
    /// <p>Gets information about a Device Advisor test suite.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteDefinition</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_definition_input::Builder,
    }
    impl<C, M, R> GetSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteDefinitionInputOperationOutputAlias,
                crate::output::GetSuiteDefinitionOutput,
                crate::error::GetSuiteDefinitionError,
                crate::input::GetSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite to get.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite to get.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(input.into());
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteRun`.
    ///
    /// <p>Gets information about a Device Advisor test suite run.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteRun</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_run_input::Builder,
    }
    impl<C, M, R> GetSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteRunInputOperationOutputAlias,
                crate::output::GetSuiteRunOutput,
                crate::error::GetSuiteRunError,
                crate::input::GetSuiteRunInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID for the test suite run.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID for the test suite run.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run ID for the test suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(input.into());
            self
        }
        /// <p>Suite run ID for the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteRunReport`.
    ///
    /// <p>Gets a report download link for a successful Device Advisor qualifying test suite run.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteRunReport</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSuiteRunReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_run_report_input::Builder,
    }
    impl<C, M, R> GetSuiteRunReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteRunReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteRunReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteRunReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteRunReportInputOperationOutputAlias,
                crate::output::GetSuiteRunReportOutput,
                crate::error::GetSuiteRunReportError,
                crate::input::GetSuiteRunReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run ID of the test suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(input.into());
            self
        }
        /// <p>Suite run ID of the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuiteDefinitions`.
    ///
    /// <p>Lists the Device Advisor test suites you have created.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSuiteDefinitions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSuiteDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suite_definitions_input::Builder,
    }
    impl<C, M, R> ListSuiteDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuiteDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuiteDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuiteDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuiteDefinitionsInputOperationOutputAlias,
                crate::output::ListSuiteDefinitionsOutput,
                crate::error::ListSuiteDefinitionsError,
                crate::input::ListSuiteDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSuiteDefinitionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSuiteDefinitionsPaginator<C, M, R> {
            crate::paginator::ListSuiteDefinitionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuiteRuns`.
    ///
    /// <p>Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSuiteRuns</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSuiteRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suite_runs_input::Builder,
    }
    impl<C, M, R> ListSuiteRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuiteRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuiteRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuiteRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuiteRunsInputOperationOutputAlias,
                crate::output::ListSuiteRunsOutput,
                crate::error::ListSuiteRunsError,
                crate::input::ListSuiteRunsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSuiteRunsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSuiteRunsPaginator<C, M, R> {
            crate::paginator::ListSuiteRunsPaginator::new(self.handle, self.inner)
        }
        /// <p>Lists the test suite runs of the specified test suite based on suite definition ID.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Lists the test suite runs of the specified test suite based on suite definition ID.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Must be passed along with <code>suiteDefinitionId</code>. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(input.into());
            self
        }
        /// <p>Must be passed along with <code>suiteDefinitionId</code>. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags attached to an IoT Device Advisor resource.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSuiteRun`.
    ///
    /// <p>Starts a Device Advisor test suite run.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartSuiteRun</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_suite_run_input::Builder,
    }
    impl<C, M, R> StartSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSuiteRunInputOperationOutputAlias,
                crate::output::StartSuiteRunOutput,
                crate::error::StartSuiteRunError,
                crate::input::StartSuiteRunInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(input.into());
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn suite_run_configuration(
            mut self,
            input: crate::model::SuiteRunConfiguration,
        ) -> Self {
            self.inner = self.inner.suite_run_configuration(input);
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn set_suite_run_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteRunConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_run_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite run.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be attached to the suite run.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopSuiteRun`.
    ///
    /// <p>Stops a Device Advisor test suite run that is currently running.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StopSuiteRun</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_suite_run_input::Builder,
    }
    impl<C, M, R> StopSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopSuiteRunInputOperationOutputAlias,
                crate::output::StopSuiteRunOutput,
                crate::error::StopSuiteRunError,
                crate::input::StopSuiteRunInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite run to be stopped.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite run to be stopped.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run ID of the test suite run to be stopped.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(input.into());
            self
        }
        /// <p>Suite run ID of the test suite run to be stopped.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to and modifies existing tags of an IoT Device Advisor resource.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TagResource</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an IoT Device Advisor resource.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UntagResource</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSuiteDefinition`.
    ///
    /// <p>Updates a Device Advisor test suite.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateSuiteDefinition</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_suite_definition_input::Builder,
    }
    impl<C, M, R> UpdateSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSuiteDefinitionInputOperationOutputAlias,
                crate::output::UpdateSuiteDefinitionOutput,
                crate::error::UpdateSuiteDefinitionError,
                crate::input::UpdateSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition ID of the test suite to be updated.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(input.into());
            self
        }
        /// <p>Suite definition ID of the test suite to be updated.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            input: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.inner = self.inner.suite_definition_configuration(input);
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_configuration(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
