// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSuiteDefinitionOutput {
    /// <p>Suite definition ID of the updated test suite.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the updated test suite.</p>
    pub suite_definition_arn: std::option::Option<std::string::String>,
    /// <p>Suite definition name of the updated test suite.</p>
    pub suite_definition_name: std::option::Option<std::string::String>,
    /// <p>Suite definition version of the updated test suite.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the test suite was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Timestamp of when the test suite was updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateSuiteDefinitionOutput {
    /// <p>Suite definition ID of the updated test suite.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the updated test suite.</p>
    pub fn suite_definition_arn(&self) -> std::option::Option<&str> {
        self.suite_definition_arn.as_deref()
    }
    /// <p>Suite definition name of the updated test suite.</p>
    pub fn suite_definition_name(&self) -> std::option::Option<&str> {
        self.suite_definition_name.as_deref()
    }
    /// <p>Suite definition version of the updated test suite.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>Timestamp of when the test suite was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Timestamp of when the test suite was updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateSuiteDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSuiteDefinitionOutput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_arn", &self.suite_definition_arn);
        formatter.field("suite_definition_name", &self.suite_definition_name);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`UpdateSuiteDefinitionOutput`](crate::output::UpdateSuiteDefinitionOutput)
pub mod update_suite_definition_output {
    /// A builder for [`UpdateSuiteDefinitionOutput`](crate::output::UpdateSuiteDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_arn: std::option::Option<std::string::String>,
        pub(crate) suite_definition_name: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Suite definition ID of the updated test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition ID of the updated test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the updated test suite.</p>
        pub fn suite_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the updated test suite.</p>
        pub fn set_suite_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_arn = input;
            self
        }
        /// <p>Suite definition name of the updated test suite.</p>
        pub fn suite_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_name = Some(input.into());
            self
        }
        /// <p>Suite definition name of the updated test suite.</p>
        pub fn set_suite_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_name = input;
            self
        }
        /// <p>Suite definition version of the updated test suite.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version of the updated test suite.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>Timestamp of when the test suite was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Timestamp of when the test suite was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Timestamp of when the test suite was updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>Timestamp of when the test suite was updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSuiteDefinitionOutput`](crate::output::UpdateSuiteDefinitionOutput)
        pub fn build(self) -> crate::output::UpdateSuiteDefinitionOutput {
            crate::output::UpdateSuiteDefinitionOutput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_arn: self.suite_definition_arn,
                suite_definition_name: self.suite_definition_name,
                suite_definition_version: self.suite_definition_version,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl UpdateSuiteDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSuiteDefinitionOutput`](crate::output::UpdateSuiteDefinitionOutput)
    pub fn builder() -> crate::output::update_suite_definition_output::Builder {
        crate::output::update_suite_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopSuiteRunOutput {}
impl std::fmt::Debug for StopSuiteRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopSuiteRunOutput");
        formatter.finish()
    }
}
/// See [`StopSuiteRunOutput`](crate::output::StopSuiteRunOutput)
pub mod stop_suite_run_output {
    /// A builder for [`StopSuiteRunOutput`](crate::output::StopSuiteRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopSuiteRunOutput`](crate::output::StopSuiteRunOutput)
        pub fn build(self) -> crate::output::StopSuiteRunOutput {
            crate::output::StopSuiteRunOutput {}
        }
    }
}
impl StopSuiteRunOutput {
    /// Creates a new builder-style object to manufacture [`StopSuiteRunOutput`](crate::output::StopSuiteRunOutput)
    pub fn builder() -> crate::output::stop_suite_run_output::Builder {
        crate::output::stop_suite_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSuiteRunOutput {
    /// <p>Suite Run ID of the started suite run.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the started suite run.</p>
    pub suite_run_arn: std::option::Option<std::string::String>,
    /// <p>Starts a Device Advisor test suite run based on suite create time.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartSuiteRunOutput {
    /// <p>Suite Run ID of the started suite run.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the started suite run.</p>
    pub fn suite_run_arn(&self) -> std::option::Option<&str> {
        self.suite_run_arn.as_deref()
    }
    /// <p>Starts a Device Advisor test suite run based on suite create time.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for StartSuiteRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSuiteRunOutput");
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.field("suite_run_arn", &self.suite_run_arn);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`StartSuiteRunOutput`](crate::output::StartSuiteRunOutput)
pub mod start_suite_run_output {
    /// A builder for [`StartSuiteRunOutput`](crate::output::StartSuiteRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
        pub(crate) suite_run_arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Suite Run ID of the started suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite Run ID of the started suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the started suite run.</p>
        pub fn suite_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the started suite run.</p>
        pub fn set_suite_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_run_arn = input;
            self
        }
        /// <p>Starts a Device Advisor test suite run based on suite create time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Starts a Device Advisor test suite run based on suite create time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSuiteRunOutput`](crate::output::StartSuiteRunOutput)
        pub fn build(self) -> crate::output::StartSuiteRunOutput {
            crate::output::StartSuiteRunOutput {
                suite_run_id: self.suite_run_id,
                suite_run_arn: self.suite_run_arn,
                created_at: self.created_at,
            }
        }
    }
}
impl StartSuiteRunOutput {
    /// Creates a new builder-style object to manufacture [`StartSuiteRunOutput`](crate::output::StartSuiteRunOutput)
    pub fn builder() -> crate::output::start_suite_run_output::Builder {
        crate::output::start_suite_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags attached to the IoT Device Advisor resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags attached to the IoT Device Advisor resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the IoT Device Advisor resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the IoT Device Advisor resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuiteRunsOutput {
    /// <p>An array of objects that provide summaries of information about the suite runs in the list.</p>
    pub suite_runs_list: std::option::Option<std::vec::Vec<crate::model::SuiteRunInformation>>,
    /// <p>A token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuiteRunsOutput {
    /// <p>An array of objects that provide summaries of information about the suite runs in the list.</p>
    pub fn suite_runs_list(&self) -> std::option::Option<&[crate::model::SuiteRunInformation]> {
        self.suite_runs_list.as_deref()
    }
    /// <p>A token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuiteRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuiteRunsOutput");
        formatter.field("suite_runs_list", &self.suite_runs_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSuiteRunsOutput`](crate::output::ListSuiteRunsOutput)
pub mod list_suite_runs_output {
    /// A builder for [`ListSuiteRunsOutput`](crate::output::ListSuiteRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_runs_list:
            std::option::Option<std::vec::Vec<crate::model::SuiteRunInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `suite_runs_list`.
        ///
        /// To override the contents of this collection use [`set_suite_runs_list`](Self::set_suite_runs_list).
        ///
        /// <p>An array of objects that provide summaries of information about the suite runs in the list.</p>
        pub fn suite_runs_list(mut self, input: crate::model::SuiteRunInformation) -> Self {
            let mut v = self.suite_runs_list.unwrap_or_default();
            v.push(input);
            self.suite_runs_list = Some(v);
            self
        }
        /// <p>An array of objects that provide summaries of information about the suite runs in the list.</p>
        pub fn set_suite_runs_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuiteRunInformation>>,
        ) -> Self {
            self.suite_runs_list = input;
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuiteRunsOutput`](crate::output::ListSuiteRunsOutput)
        pub fn build(self) -> crate::output::ListSuiteRunsOutput {
            crate::output::ListSuiteRunsOutput {
                suite_runs_list: self.suite_runs_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSuiteRunsOutput {
    /// Creates a new builder-style object to manufacture [`ListSuiteRunsOutput`](crate::output::ListSuiteRunsOutput)
    pub fn builder() -> crate::output::list_suite_runs_output::Builder {
        crate::output::list_suite_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuiteDefinitionsOutput {
    /// <p>An array of objects that provide summaries of information about the suite definitions in the list.</p>
    pub suite_definition_information_list:
        std::option::Option<std::vec::Vec<crate::model::SuiteDefinitionInformation>>,
    /// <p>A token used to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuiteDefinitionsOutput {
    /// <p>An array of objects that provide summaries of information about the suite definitions in the list.</p>
    pub fn suite_definition_information_list(
        &self,
    ) -> std::option::Option<&[crate::model::SuiteDefinitionInformation]> {
        self.suite_definition_information_list.as_deref()
    }
    /// <p>A token used to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuiteDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuiteDefinitionsOutput");
        formatter.field(
            "suite_definition_information_list",
            &self.suite_definition_information_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSuiteDefinitionsOutput`](crate::output::ListSuiteDefinitionsOutput)
pub mod list_suite_definitions_output {
    /// A builder for [`ListSuiteDefinitionsOutput`](crate::output::ListSuiteDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_information_list:
            std::option::Option<std::vec::Vec<crate::model::SuiteDefinitionInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `suite_definition_information_list`.
        ///
        /// To override the contents of this collection use [`set_suite_definition_information_list`](Self::set_suite_definition_information_list).
        ///
        /// <p>An array of objects that provide summaries of information about the suite definitions in the list.</p>
        pub fn suite_definition_information_list(
            mut self,
            input: crate::model::SuiteDefinitionInformation,
        ) -> Self {
            let mut v = self.suite_definition_information_list.unwrap_or_default();
            v.push(input);
            self.suite_definition_information_list = Some(v);
            self
        }
        /// <p>An array of objects that provide summaries of information about the suite definitions in the list.</p>
        pub fn set_suite_definition_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuiteDefinitionInformation>>,
        ) -> Self {
            self.suite_definition_information_list = input;
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuiteDefinitionsOutput`](crate::output::ListSuiteDefinitionsOutput)
        pub fn build(self) -> crate::output::ListSuiteDefinitionsOutput {
            crate::output::ListSuiteDefinitionsOutput {
                suite_definition_information_list: self.suite_definition_information_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSuiteDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSuiteDefinitionsOutput`](crate::output::ListSuiteDefinitionsOutput)
    pub fn builder() -> crate::output::list_suite_definitions_output::Builder {
        crate::output::list_suite_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteRunReportOutput {
    /// <p>Download URL of the qualification report.</p>
    pub qualification_report_download_url: std::option::Option<std::string::String>,
}
impl GetSuiteRunReportOutput {
    /// <p>Download URL of the qualification report.</p>
    pub fn qualification_report_download_url(&self) -> std::option::Option<&str> {
        self.qualification_report_download_url.as_deref()
    }
}
impl std::fmt::Debug for GetSuiteRunReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteRunReportOutput");
        formatter.field(
            "qualification_report_download_url",
            &self.qualification_report_download_url,
        );
        formatter.finish()
    }
}
/// See [`GetSuiteRunReportOutput`](crate::output::GetSuiteRunReportOutput)
pub mod get_suite_run_report_output {
    /// A builder for [`GetSuiteRunReportOutput`](crate::output::GetSuiteRunReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) qualification_report_download_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Download URL of the qualification report.</p>
        pub fn qualification_report_download_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.qualification_report_download_url = Some(input.into());
            self
        }
        /// <p>Download URL of the qualification report.</p>
        pub fn set_qualification_report_download_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.qualification_report_download_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteRunReportOutput`](crate::output::GetSuiteRunReportOutput)
        pub fn build(self) -> crate::output::GetSuiteRunReportOutput {
            crate::output::GetSuiteRunReportOutput {
                qualification_report_download_url: self.qualification_report_download_url,
            }
        }
    }
}
impl GetSuiteRunReportOutput {
    /// Creates a new builder-style object to manufacture [`GetSuiteRunReportOutput`](crate::output::GetSuiteRunReportOutput)
    pub fn builder() -> crate::output::get_suite_run_report_output::Builder {
        crate::output::get_suite_run_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteRunOutput {
    /// <p>Suite definition ID for the test suite run.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite definition version for the test suite run.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>Suite run ID for the test suite run.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the suite run.</p>
    pub suite_run_arn: std::option::Option<std::string::String>,
    /// <p>Suite run configuration for the test suite run.</p>
    pub suite_run_configuration: std::option::Option<crate::model::SuiteRunConfiguration>,
    /// <p>Test results for the test suite run.</p>
    pub test_result: std::option::Option<crate::model::TestResult>,
    /// <p>Date (in Unix epoch time) when the test suite run started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date (in Unix epoch time) when the test suite run ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Status for the test suite run.</p>
    pub status: std::option::Option<crate::model::SuiteRunStatus>,
    /// <p>Error reason for any test suite run failure.</p>
    pub error_reason: std::option::Option<std::string::String>,
    /// <p>The tags attached to the suite run.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetSuiteRunOutput {
    /// <p>Suite definition ID for the test suite run.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite definition version for the test suite run.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>Suite run ID for the test suite run.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
    /// <p>The ARN of the suite run.</p>
    pub fn suite_run_arn(&self) -> std::option::Option<&str> {
        self.suite_run_arn.as_deref()
    }
    /// <p>Suite run configuration for the test suite run.</p>
    pub fn suite_run_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SuiteRunConfiguration> {
        self.suite_run_configuration.as_ref()
    }
    /// <p>Test results for the test suite run.</p>
    pub fn test_result(&self) -> std::option::Option<&crate::model::TestResult> {
        self.test_result.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the test suite run started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the test suite run ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Status for the test suite run.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SuiteRunStatus> {
        self.status.as_ref()
    }
    /// <p>Error reason for any test suite run failure.</p>
    pub fn error_reason(&self) -> std::option::Option<&str> {
        self.error_reason.as_deref()
    }
    /// <p>The tags attached to the suite run.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetSuiteRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteRunOutput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.field("suite_run_arn", &self.suite_run_arn);
        formatter.field("suite_run_configuration", &self.suite_run_configuration);
        formatter.field("test_result", &self.test_result);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status", &self.status);
        formatter.field("error_reason", &self.error_reason);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetSuiteRunOutput`](crate::output::GetSuiteRunOutput)
pub mod get_suite_run_output {
    /// A builder for [`GetSuiteRunOutput`](crate::output::GetSuiteRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
        pub(crate) suite_run_arn: std::option::Option<std::string::String>,
        pub(crate) suite_run_configuration:
            std::option::Option<crate::model::SuiteRunConfiguration>,
        pub(crate) test_result: std::option::Option<crate::model::TestResult>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::SuiteRunStatus>,
        pub(crate) error_reason: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Suite definition ID for the test suite run.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition ID for the test suite run.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite definition version for the test suite run.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version for the test suite run.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>Suite run ID for the test suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite run ID for the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// <p>The ARN of the suite run.</p>
        pub fn suite_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the suite run.</p>
        pub fn set_suite_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_run_arn = input;
            self
        }
        /// <p>Suite run configuration for the test suite run.</p>
        pub fn suite_run_configuration(
            mut self,
            input: crate::model::SuiteRunConfiguration,
        ) -> Self {
            self.suite_run_configuration = Some(input);
            self
        }
        /// <p>Suite run configuration for the test suite run.</p>
        pub fn set_suite_run_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteRunConfiguration>,
        ) -> Self {
            self.suite_run_configuration = input;
            self
        }
        /// <p>Test results for the test suite run.</p>
        pub fn test_result(mut self, input: crate::model::TestResult) -> Self {
            self.test_result = Some(input);
            self
        }
        /// <p>Test results for the test suite run.</p>
        pub fn set_test_result(
            mut self,
            input: std::option::Option<crate::model::TestResult>,
        ) -> Self {
            self.test_result = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite run started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite run started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite run ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite run ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Status for the test suite run.</p>
        pub fn status(mut self, input: crate::model::SuiteRunStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status for the test suite run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SuiteRunStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Error reason for any test suite run failure.</p>
        pub fn error_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_reason = Some(input.into());
            self
        }
        /// <p>Error reason for any test suite run failure.</p>
        pub fn set_error_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_reason = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the suite run.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the suite run.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteRunOutput`](crate::output::GetSuiteRunOutput)
        pub fn build(self) -> crate::output::GetSuiteRunOutput {
            crate::output::GetSuiteRunOutput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_version: self.suite_definition_version,
                suite_run_id: self.suite_run_id,
                suite_run_arn: self.suite_run_arn,
                suite_run_configuration: self.suite_run_configuration,
                test_result: self.test_result,
                start_time: self.start_time,
                end_time: self.end_time,
                status: self.status,
                error_reason: self.error_reason,
                tags: self.tags,
            }
        }
    }
}
impl GetSuiteRunOutput {
    /// Creates a new builder-style object to manufacture [`GetSuiteRunOutput`](crate::output::GetSuiteRunOutput)
    pub fn builder() -> crate::output::get_suite_run_output::Builder {
        crate::output::get_suite_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteDefinitionOutput {
    /// <p>Suite definition ID of the suite definition.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the suite definition.</p>
    pub suite_definition_arn: std::option::Option<std::string::String>,
    /// <p>Suite definition version of the suite definition.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>Latest suite definition version of the suite definition.</p>
    pub latest_version: std::option::Option<std::string::String>,
    /// <p>Suite configuration of the suite definition.</p>
    pub suite_definition_configuration:
        std::option::Option<crate::model::SuiteDefinitionConfiguration>,
    /// <p>Date (in Unix epoch time) when the suite definition was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date (in Unix epoch time) when the suite definition was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Tags attached to the suite definition.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetSuiteDefinitionOutput {
    /// <p>Suite definition ID of the suite definition.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>The ARN of the suite definition.</p>
    pub fn suite_definition_arn(&self) -> std::option::Option<&str> {
        self.suite_definition_arn.as_deref()
    }
    /// <p>Suite definition version of the suite definition.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>Latest suite definition version of the suite definition.</p>
    pub fn latest_version(&self) -> std::option::Option<&str> {
        self.latest_version.as_deref()
    }
    /// <p>Suite configuration of the suite definition.</p>
    pub fn suite_definition_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SuiteDefinitionConfiguration> {
        self.suite_definition_configuration.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the suite definition was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the suite definition was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>Tags attached to the suite definition.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetSuiteDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteDefinitionOutput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_arn", &self.suite_definition_arn);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("latest_version", &self.latest_version);
        formatter.field(
            "suite_definition_configuration",
            &self.suite_definition_configuration,
        );
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetSuiteDefinitionOutput`](crate::output::GetSuiteDefinitionOutput)
pub mod get_suite_definition_output {
    /// A builder for [`GetSuiteDefinitionOutput`](crate::output::GetSuiteDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_arn: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<std::string::String>,
        pub(crate) suite_definition_configuration:
            std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Suite definition ID of the suite definition.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition ID of the suite definition.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>The ARN of the suite definition.</p>
        pub fn suite_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the suite definition.</p>
        pub fn set_suite_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_arn = input;
            self
        }
        /// <p>Suite definition version of the suite definition.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version of the suite definition.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>Latest suite definition version of the suite definition.</p>
        pub fn latest_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version = Some(input.into());
            self
        }
        /// <p>Latest suite definition version of the suite definition.</p>
        pub fn set_latest_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version = input;
            self
        }
        /// <p>Suite configuration of the suite definition.</p>
        pub fn suite_definition_configuration(
            mut self,
            input: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.suite_definition_configuration = Some(input);
            self
        }
        /// <p>Suite configuration of the suite definition.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.suite_definition_configuration = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the suite definition was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the suite definition was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the suite definition was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the suite definition was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags attached to the suite definition.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags attached to the suite definition.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteDefinitionOutput`](crate::output::GetSuiteDefinitionOutput)
        pub fn build(self) -> crate::output::GetSuiteDefinitionOutput {
            crate::output::GetSuiteDefinitionOutput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_arn: self.suite_definition_arn,
                suite_definition_version: self.suite_definition_version,
                latest_version: self.latest_version,
                suite_definition_configuration: self.suite_definition_configuration,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                tags: self.tags,
            }
        }
    }
}
impl GetSuiteDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`GetSuiteDefinitionOutput`](crate::output::GetSuiteDefinitionOutput)
    pub fn builder() -> crate::output::get_suite_definition_output::Builder {
        crate::output::get_suite_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEndpointOutput {
    /// <p>The response of an Device Advisor endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
}
impl GetEndpointOutput {
    /// <p>The response of an Device Advisor endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
}
impl std::fmt::Debug for GetEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEndpointOutput");
        formatter.field("endpoint", &self.endpoint);
        formatter.finish()
    }
}
/// See [`GetEndpointOutput`](crate::output::GetEndpointOutput)
pub mod get_endpoint_output {
    /// A builder for [`GetEndpointOutput`](crate::output::GetEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The response of an Device Advisor endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The response of an Device Advisor endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEndpointOutput`](crate::output::GetEndpointOutput)
        pub fn build(self) -> crate::output::GetEndpointOutput {
            crate::output::GetEndpointOutput {
                endpoint: self.endpoint,
            }
        }
    }
}
impl GetEndpointOutput {
    /// Creates a new builder-style object to manufacture [`GetEndpointOutput`](crate::output::GetEndpointOutput)
    pub fn builder() -> crate::output::get_endpoint_output::Builder {
        crate::output::get_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSuiteDefinitionOutput {}
impl std::fmt::Debug for DeleteSuiteDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSuiteDefinitionOutput");
        formatter.finish()
    }
}
/// See [`DeleteSuiteDefinitionOutput`](crate::output::DeleteSuiteDefinitionOutput)
pub mod delete_suite_definition_output {
    /// A builder for [`DeleteSuiteDefinitionOutput`](crate::output::DeleteSuiteDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSuiteDefinitionOutput`](crate::output::DeleteSuiteDefinitionOutput)
        pub fn build(self) -> crate::output::DeleteSuiteDefinitionOutput {
            crate::output::DeleteSuiteDefinitionOutput {}
        }
    }
}
impl DeleteSuiteDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSuiteDefinitionOutput`](crate::output::DeleteSuiteDefinitionOutput)
    pub fn builder() -> crate::output::delete_suite_definition_output::Builder {
        crate::output::delete_suite_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSuiteDefinitionOutput {
    /// <p>Creates a Device Advisor test suite with suite UUID.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>
    pub suite_definition_arn: std::option::Option<std::string::String>,
    /// <p>Creates a Device Advisor test suite with suite definition name.</p>
    pub suite_definition_name: std::option::Option<std::string::String>,
    /// <p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateSuiteDefinitionOutput {
    /// <p>Creates a Device Advisor test suite with suite UUID.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>
    pub fn suite_definition_arn(&self) -> std::option::Option<&str> {
        self.suite_definition_arn.as_deref()
    }
    /// <p>Creates a Device Advisor test suite with suite definition name.</p>
    pub fn suite_definition_name(&self) -> std::option::Option<&str> {
        self.suite_definition_name.as_deref()
    }
    /// <p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for CreateSuiteDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSuiteDefinitionOutput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_arn", &self.suite_definition_arn);
        formatter.field("suite_definition_name", &self.suite_definition_name);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`CreateSuiteDefinitionOutput`](crate::output::CreateSuiteDefinitionOutput)
pub mod create_suite_definition_output {
    /// A builder for [`CreateSuiteDefinitionOutput`](crate::output::CreateSuiteDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_arn: std::option::Option<std::string::String>,
        pub(crate) suite_definition_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Creates a Device Advisor test suite with suite UUID.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Creates a Device Advisor test suite with suite UUID.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>
        pub fn suite_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_arn = Some(input.into());
            self
        }
        /// <p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>
        pub fn set_suite_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_arn = input;
            self
        }
        /// <p>Creates a Device Advisor test suite with suite definition name.</p>
        pub fn suite_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_name = Some(input.into());
            self
        }
        /// <p>Creates a Device Advisor test suite with suite definition name.</p>
        pub fn set_suite_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_name = input;
            self
        }
        /// <p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSuiteDefinitionOutput`](crate::output::CreateSuiteDefinitionOutput)
        pub fn build(self) -> crate::output::CreateSuiteDefinitionOutput {
            crate::output::CreateSuiteDefinitionOutput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_arn: self.suite_definition_arn,
                suite_definition_name: self.suite_definition_name,
                created_at: self.created_at,
            }
        }
    }
}
impl CreateSuiteDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSuiteDefinitionOutput`](crate::output::CreateSuiteDefinitionOutput)
    pub fn builder() -> crate::output::create_suite_definition_output::Builder {
        crate::output::create_suite_definition_output::Builder::default()
    }
}
