// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS IoT Core Device Advisor
///
/// Client for invoking operations on AWS IoT Core Device Advisor. Each operation on AWS IoT Core Device Advisor is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotdeviceadvisor::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotdeviceadvisor::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotdeviceadvisor::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateSuiteDefinition` operation.
    ///
    /// See [`CreateSuiteDefinition`](crate::client::fluent_builders::CreateSuiteDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_suite_definition(&self) -> fluent_builders::CreateSuiteDefinition<C, M, R> {
        fluent_builders::CreateSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSuiteDefinition` operation.
    ///
    /// See [`DeleteSuiteDefinition`](crate::client::fluent_builders::DeleteSuiteDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_suite_definition(&self) -> fluent_builders::DeleteSuiteDefinition<C, M, R> {
        fluent_builders::DeleteSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSuiteDefinition` operation.
    ///
    /// See [`GetSuiteDefinition`](crate::client::fluent_builders::GetSuiteDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_suite_definition(&self) -> fluent_builders::GetSuiteDefinition<C, M, R> {
        fluent_builders::GetSuiteDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSuiteRun` operation.
    ///
    /// See [`GetSuiteRun`](crate::client::fluent_builders::GetSuiteRun) for more information about the
    /// operation and its arguments.
    pub fn get_suite_run(&self) -> fluent_builders::GetSuiteRun<C, M, R> {
        fluent_builders::GetSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSuiteRunReport` operation.
    ///
    /// See [`GetSuiteRunReport`](crate::client::fluent_builders::GetSuiteRunReport) for more information about the
    /// operation and its arguments.
    pub fn get_suite_run_report(&self) -> fluent_builders::GetSuiteRunReport<C, M, R> {
        fluent_builders::GetSuiteRunReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSuiteDefinitions` operation.
    ///
    /// See [`ListSuiteDefinitions`](crate::client::fluent_builders::ListSuiteDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_suite_definitions(&self) -> fluent_builders::ListSuiteDefinitions<C, M, R> {
        fluent_builders::ListSuiteDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSuiteRuns` operation.
    ///
    /// See [`ListSuiteRuns`](crate::client::fluent_builders::ListSuiteRuns) for more information about the
    /// operation and its arguments.
    pub fn list_suite_runs(&self) -> fluent_builders::ListSuiteRuns<C, M, R> {
        fluent_builders::ListSuiteRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSuiteRun` operation.
    ///
    /// See [`StartSuiteRun`](crate::client::fluent_builders::StartSuiteRun) for more information about the
    /// operation and its arguments.
    pub fn start_suite_run(&self) -> fluent_builders::StartSuiteRun<C, M, R> {
        fluent_builders::StartSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopSuiteRun` operation.
    ///
    /// See [`StopSuiteRun`](crate::client::fluent_builders::StopSuiteRun) for more information about the
    /// operation and its arguments.
    pub fn stop_suite_run(&self) -> fluent_builders::StopSuiteRun<C, M, R> {
        fluent_builders::StopSuiteRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSuiteDefinition` operation.
    ///
    /// See [`UpdateSuiteDefinition`](crate::client::fluent_builders::UpdateSuiteDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_suite_definition(&self) -> fluent_builders::UpdateSuiteDefinition<C, M, R> {
        fluent_builders::UpdateSuiteDefinition::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateSuiteDefinition`.
    ///
    /// <p>Creates a Device Advisor test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_suite_definition_input::Builder,
    }
    impl<C, M, R> CreateSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSuiteDefinitionInputOperationOutputAlias,
                crate::output::CreateSuiteDefinitionOutput,
                crate::error::CreateSuiteDefinitionError,
                crate::input::CreateSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            inp: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.inner = self.inner.suite_definition_configuration(inp);
            self
        }
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSuiteDefinition`.
    ///
    /// <p>Deletes a Device Advisor test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_suite_definition_input::Builder,
    }
    impl<C, M, R> DeleteSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSuiteDefinitionInputOperationOutputAlias,
                crate::output::DeleteSuiteDefinitionOutput,
                crate::error::DeleteSuiteDefinitionError,
                crate::input::DeleteSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite to be deleted.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite to be deleted.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteDefinition`.
    ///
    /// <p>Gets information about a Device Advisor test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_definition_input::Builder,
    }
    impl<C, M, R> GetSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteDefinitionInputOperationOutputAlias,
                crate::output::GetSuiteDefinitionOutput,
                crate::error::GetSuiteDefinitionError,
                crate::input::GetSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite to get.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite to get.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn suite_definition_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(inp);
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteRun`.
    ///
    /// <p>Gets information about a Device Advisor test suite run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_run_input::Builder,
    }
    impl<C, M, R> GetSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteRunInputOperationOutputAlias,
                crate::output::GetSuiteRunOutput,
                crate::error::GetSuiteRunError,
                crate::input::GetSuiteRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id for the test suite run.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id for the test suite run.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run Id for the test suite run.</p>
        pub fn suite_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(inp);
            self
        }
        /// <p>Suite run Id for the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuiteRunReport`.
    ///
    /// <p>Gets a report download link for a successful Device Advisor qualifying test suite run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSuiteRunReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suite_run_report_input::Builder,
    }
    impl<C, M, R> GetSuiteRunReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuiteRunReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuiteRunReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuiteRunReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuiteRunReportInputOperationOutputAlias,
                crate::output::GetSuiteRunReportOutput,
                crate::error::GetSuiteRunReportError,
                crate::input::GetSuiteRunReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run Id of the test suite run.</p>
        pub fn suite_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(inp);
            self
        }
        /// <p>Suite run Id of the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuiteDefinitions`.
    ///
    /// <p>Lists the Device Advisor test suites you have created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSuiteDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suite_definitions_input::Builder,
    }
    impl<C, M, R> ListSuiteDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuiteDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuiteDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuiteDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuiteDefinitionsInputOperationOutputAlias,
                crate::output::ListSuiteDefinitionsOutput,
                crate::error::ListSuiteDefinitionsError,
                crate::input::ListSuiteDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuiteRuns`.
    ///
    /// <p>Lists the runs of the specified Device Advisor test suite.
    /// You can list all runs of the test suite, or the runs of a specific version of the test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSuiteRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suite_runs_input::Builder,
    }
    impl<C, M, R> ListSuiteRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuiteRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuiteRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuiteRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuiteRunsInputOperationOutputAlias,
                crate::output::ListSuiteRunsOutput,
                crate::error::ListSuiteRunsError,
                crate::input::ListSuiteRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn suite_definition_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(inp);
            self
        }
        /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags attached to an IoT Device Advisor resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSuiteRun`.
    ///
    /// <p>Starts a Device Advisor test suite run.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_suite_run_input::Builder,
    }
    impl<C, M, R> StartSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSuiteRunInputOperationOutputAlias,
                crate::output::StartSuiteRunOutput,
                crate::error::StartSuiteRunError,
                crate::input::StartSuiteRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn suite_definition_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_version(inp);
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_version(input);
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn suite_run_configuration(mut self, inp: crate::model::SuiteRunConfiguration) -> Self {
            self.inner = self.inner.suite_run_configuration(inp);
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn set_suite_run_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteRunConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_run_configuration(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite run.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be attached to the suite run.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopSuiteRun`.
    ///
    /// <p>Stops a Device Advisor test suite run that is currently running.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopSuiteRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_suite_run_input::Builder,
    }
    impl<C, M, R> StopSuiteRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopSuiteRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopSuiteRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopSuiteRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopSuiteRunInputOperationOutputAlias,
                crate::output::StopSuiteRunOutput,
                crate::error::StopSuiteRunError,
                crate::input::StopSuiteRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite run to be stopped.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite run to be stopped.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Suite run Id of the test suite run to be stopped.</p>
        pub fn suite_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_run_id(inp);
            self
        }
        /// <p>Suite run Id of the test suite run to be stopped.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_suite_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to and modifies existing tags of an IoT Device Advisor resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an IoT Device Advisor resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSuiteDefinition`.
    ///
    /// <p>Updates a Device Advisor test suite.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSuiteDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_suite_definition_input::Builder,
    }
    impl<C, M, R> UpdateSuiteDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSuiteDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSuiteDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSuiteDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSuiteDefinitionInputOperationOutputAlias,
                crate::output::UpdateSuiteDefinitionOutput,
                crate::error::UpdateSuiteDefinitionError,
                crate::input::UpdateSuiteDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Suite definition Id of the test suite to be updated.</p>
        pub fn suite_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.suite_definition_id(inp);
            self
        }
        /// <p>Suite definition Id of the test suite to be updated.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_id(input);
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            inp: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.inner = self.inner.suite_definition_configuration(inp);
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_suite_definition_configuration(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
