// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Gets Suite Definition Configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuiteDefinitionConfiguration {
    /// <p>Gets Suite Definition Configuration name.</p>
    pub suite_definition_name: std::option::Option<std::string::String>,
    /// <p>Gets the devices configured.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
    /// <p>Gets the tests intended for qualification in a suite.</p>
    pub intended_for_qualification: bool,
    /// <p>Gets test suite root group.</p>
    pub root_group: std::option::Option<std::string::String>,
    /// <p>Gets device permission arn.</p>
    pub device_permission_role_arn: std::option::Option<std::string::String>,
}
impl SuiteDefinitionConfiguration {
    /// <p>Gets Suite Definition Configuration name.</p>
    pub fn suite_definition_name(&self) -> std::option::Option<&str> {
        self.suite_definition_name.as_deref()
    }
    /// <p>Gets the devices configured.</p>
    pub fn devices(&self) -> std::option::Option<&[crate::model::DeviceUnderTest]> {
        self.devices.as_deref()
    }
    /// <p>Gets the tests intended for qualification in a suite.</p>
    pub fn intended_for_qualification(&self) -> bool {
        self.intended_for_qualification
    }
    /// <p>Gets test suite root group.</p>
    pub fn root_group(&self) -> std::option::Option<&str> {
        self.root_group.as_deref()
    }
    /// <p>Gets device permission arn.</p>
    pub fn device_permission_role_arn(&self) -> std::option::Option<&str> {
        self.device_permission_role_arn.as_deref()
    }
}
impl std::fmt::Debug for SuiteDefinitionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuiteDefinitionConfiguration");
        formatter.field("suite_definition_name", &self.suite_definition_name);
        formatter.field("devices", &self.devices);
        formatter.field(
            "intended_for_qualification",
            &self.intended_for_qualification,
        );
        formatter.field("root_group", &self.root_group);
        formatter.field(
            "device_permission_role_arn",
            &self.device_permission_role_arn,
        );
        formatter.finish()
    }
}
/// See [`SuiteDefinitionConfiguration`](crate::model::SuiteDefinitionConfiguration)
pub mod suite_definition_configuration {
    /// A builder for [`SuiteDefinitionConfiguration`](crate::model::SuiteDefinitionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_name: std::option::Option<std::string::String>,
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
        pub(crate) intended_for_qualification: std::option::Option<bool>,
        pub(crate) root_group: std::option::Option<std::string::String>,
        pub(crate) device_permission_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Gets Suite Definition Configuration name.</p>
        pub fn suite_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_name = Some(input.into());
            self
        }
        /// <p>Gets Suite Definition Configuration name.</p>
        pub fn set_suite_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_name = input;
            self
        }
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>Gets the devices configured.</p>
        pub fn devices(mut self, input: impl Into<crate::model::DeviceUnderTest>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>Gets the devices configured.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>Gets the tests intended for qualification in a suite.</p>
        pub fn intended_for_qualification(mut self, input: bool) -> Self {
            self.intended_for_qualification = Some(input);
            self
        }
        /// <p>Gets the tests intended for qualification in a suite.</p>
        pub fn set_intended_for_qualification(mut self, input: std::option::Option<bool>) -> Self {
            self.intended_for_qualification = input;
            self
        }
        /// <p>Gets test suite root group.</p>
        pub fn root_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_group = Some(input.into());
            self
        }
        /// <p>Gets test suite root group.</p>
        pub fn set_root_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.root_group = input;
            self
        }
        /// <p>Gets device permission arn.</p>
        pub fn device_permission_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_permission_role_arn = Some(input.into());
            self
        }
        /// <p>Gets device permission arn.</p>
        pub fn set_device_permission_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_permission_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SuiteDefinitionConfiguration`](crate::model::SuiteDefinitionConfiguration)
        pub fn build(self) -> crate::model::SuiteDefinitionConfiguration {
            crate::model::SuiteDefinitionConfiguration {
                suite_definition_name: self.suite_definition_name,
                devices: self.devices,
                intended_for_qualification: self.intended_for_qualification.unwrap_or_default(),
                root_group: self.root_group,
                device_permission_role_arn: self.device_permission_role_arn,
            }
        }
    }
}
impl SuiteDefinitionConfiguration {
    /// Creates a new builder-style object to manufacture [`SuiteDefinitionConfiguration`](crate::model::SuiteDefinitionConfiguration)
    pub fn builder() -> crate::model::suite_definition_configuration::Builder {
        crate::model::suite_definition_configuration::Builder::default()
    }
}

/// <p>Lists all the devices under test</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceUnderTest {
    /// <p>Lists devices thing arn</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>Lists devices certificate arn</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl DeviceUnderTest {
    /// <p>Lists devices thing arn</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>Lists devices certificate arn</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for DeviceUnderTest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceUnderTest");
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`DeviceUnderTest`](crate::model::DeviceUnderTest)
pub mod device_under_test {
    /// A builder for [`DeviceUnderTest`](crate::model::DeviceUnderTest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lists devices thing arn</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>Lists devices thing arn</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>Lists devices certificate arn</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>Lists devices certificate arn</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceUnderTest`](crate::model::DeviceUnderTest)
        pub fn build(self) -> crate::model::DeviceUnderTest {
            crate::model::DeviceUnderTest {
                thing_arn: self.thing_arn,
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl DeviceUnderTest {
    /// Creates a new builder-style object to manufacture [`DeviceUnderTest`](crate::model::DeviceUnderTest)
    pub fn builder() -> crate::model::device_under_test::Builder {
        crate::model::device_under_test::Builder::default()
    }
}

/// <p>Gets suite run configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuiteRunConfiguration {
    /// <p>Gets the primary device for suite run.</p>
    pub primary_device: std::option::Option<crate::model::DeviceUnderTest>,
    /// <p>Gets test case list.</p>
    pub selected_test_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SuiteRunConfiguration {
    /// <p>Gets the primary device for suite run.</p>
    pub fn primary_device(&self) -> std::option::Option<&crate::model::DeviceUnderTest> {
        self.primary_device.as_ref()
    }
    /// <p>Gets test case list.</p>
    pub fn selected_test_list(&self) -> std::option::Option<&[std::string::String]> {
        self.selected_test_list.as_deref()
    }
}
impl std::fmt::Debug for SuiteRunConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuiteRunConfiguration");
        formatter.field("primary_device", &self.primary_device);
        formatter.field("selected_test_list", &self.selected_test_list);
        formatter.finish()
    }
}
/// See [`SuiteRunConfiguration`](crate::model::SuiteRunConfiguration)
pub mod suite_run_configuration {
    /// A builder for [`SuiteRunConfiguration`](crate::model::SuiteRunConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_device: std::option::Option<crate::model::DeviceUnderTest>,
        pub(crate) selected_test_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Gets the primary device for suite run.</p>
        pub fn primary_device(mut self, input: crate::model::DeviceUnderTest) -> Self {
            self.primary_device = Some(input);
            self
        }
        /// <p>Gets the primary device for suite run.</p>
        pub fn set_primary_device(
            mut self,
            input: std::option::Option<crate::model::DeviceUnderTest>,
        ) -> Self {
            self.primary_device = input;
            self
        }
        /// Appends an item to `selected_test_list`.
        ///
        /// To override the contents of this collection use [`set_selected_test_list`](Self::set_selected_test_list).
        ///
        /// <p>Gets test case list.</p>
        pub fn selected_test_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_test_list.unwrap_or_default();
            v.push(input.into());
            self.selected_test_list = Some(v);
            self
        }
        /// <p>Gets test case list.</p>
        pub fn set_selected_test_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_test_list = input;
            self
        }
        /// Consumes the builder and constructs a [`SuiteRunConfiguration`](crate::model::SuiteRunConfiguration)
        pub fn build(self) -> crate::model::SuiteRunConfiguration {
            crate::model::SuiteRunConfiguration {
                primary_device: self.primary_device,
                selected_test_list: self.selected_test_list,
            }
        }
    }
}
impl SuiteRunConfiguration {
    /// Creates a new builder-style object to manufacture [`SuiteRunConfiguration`](crate::model::SuiteRunConfiguration)
    pub fn builder() -> crate::model::suite_run_configuration::Builder {
        crate::model::suite_run_configuration::Builder::default()
    }
}

/// <p>Information about the suite run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuiteRunInformation {
    /// <p>Suite definition Id of the suite run.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite definition version of the suite run.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>Suite definition name of the suite run.</p>
    pub suite_definition_name: std::option::Option<std::string::String>,
    /// <p>Suite run Id of the suite run.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
    /// <p>Date (in Unix epoch time) when the suite run was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date (in Unix epoch time) when the suite run was started.</p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Date (in Unix epoch time) when the suite run ended.</p>
    pub end_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Status of the suite run.</p>
    pub status: std::option::Option<crate::model::SuiteRunStatus>,
    /// <p>Number of test cases that passed in the suite run.</p>
    pub passed: i32,
    /// <p>Number of test cases that failed in the suite run.</p>
    pub failed: i32,
}
impl SuiteRunInformation {
    /// <p>Suite definition Id of the suite run.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite definition version of the suite run.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>Suite definition name of the suite run.</p>
    pub fn suite_definition_name(&self) -> std::option::Option<&str> {
        self.suite_definition_name.as_deref()
    }
    /// <p>Suite run Id of the suite run.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
    /// <p>Date (in Unix epoch time) when the suite run was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the suite run was started.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>Date (in Unix epoch time) when the suite run ended.</p>
    pub fn end_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_at.as_ref()
    }
    /// <p>Status of the suite run.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SuiteRunStatus> {
        self.status.as_ref()
    }
    /// <p>Number of test cases that passed in the suite run.</p>
    pub fn passed(&self) -> i32 {
        self.passed
    }
    /// <p>Number of test cases that failed in the suite run.</p>
    pub fn failed(&self) -> i32 {
        self.failed
    }
}
impl std::fmt::Debug for SuiteRunInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuiteRunInformation");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("suite_definition_name", &self.suite_definition_name);
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("end_at", &self.end_at);
        formatter.field("status", &self.status);
        formatter.field("passed", &self.passed);
        formatter.field("failed", &self.failed);
        formatter.finish()
    }
}
/// See [`SuiteRunInformation`](crate::model::SuiteRunInformation)
pub mod suite_run_information {
    /// A builder for [`SuiteRunInformation`](crate::model::SuiteRunInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) suite_definition_name: std::option::Option<std::string::String>,
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::SuiteRunStatus>,
        pub(crate) passed: std::option::Option<i32>,
        pub(crate) failed: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Suite definition Id of the suite run.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the suite run.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite definition version of the suite run.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version of the suite run.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>Suite definition name of the suite run.</p>
        pub fn suite_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_name = Some(input.into());
            self
        }
        /// <p>Suite definition name of the suite run.</p>
        pub fn set_suite_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_name = input;
            self
        }
        /// <p>Suite run Id of the suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite run Id of the suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run was started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run was started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run ended.</p>
        pub fn end_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the suite run ended.</p>
        pub fn set_end_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_at = input;
            self
        }
        /// <p>Status of the suite run.</p>
        pub fn status(mut self, input: crate::model::SuiteRunStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the suite run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SuiteRunStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Number of test cases that passed in the suite run.</p>
        pub fn passed(mut self, input: i32) -> Self {
            self.passed = Some(input);
            self
        }
        /// <p>Number of test cases that passed in the suite run.</p>
        pub fn set_passed(mut self, input: std::option::Option<i32>) -> Self {
            self.passed = input;
            self
        }
        /// <p>Number of test cases that failed in the suite run.</p>
        pub fn failed(mut self, input: i32) -> Self {
            self.failed = Some(input);
            self
        }
        /// <p>Number of test cases that failed in the suite run.</p>
        pub fn set_failed(mut self, input: std::option::Option<i32>) -> Self {
            self.failed = input;
            self
        }
        /// Consumes the builder and constructs a [`SuiteRunInformation`](crate::model::SuiteRunInformation)
        pub fn build(self) -> crate::model::SuiteRunInformation {
            crate::model::SuiteRunInformation {
                suite_definition_id: self.suite_definition_id,
                suite_definition_version: self.suite_definition_version,
                suite_definition_name: self.suite_definition_name,
                suite_run_id: self.suite_run_id,
                created_at: self.created_at,
                started_at: self.started_at,
                end_at: self.end_at,
                status: self.status,
                passed: self.passed.unwrap_or_default(),
                failed: self.failed.unwrap_or_default(),
            }
        }
    }
}
impl SuiteRunInformation {
    /// Creates a new builder-style object to manufacture [`SuiteRunInformation`](crate::model::SuiteRunInformation)
    pub fn builder() -> crate::model::suite_run_information::Builder {
        crate::model::suite_run_information::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SuiteRunStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    #[allow(missing_docs)] // documentation missing in model
    Pass,
    #[allow(missing_docs)] // documentation missing in model
    PassWithWarnings,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SuiteRunStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => SuiteRunStatus::Canceled,
            "ERROR" => SuiteRunStatus::Error,
            "FAIL" => SuiteRunStatus::Fail,
            "PASS" => SuiteRunStatus::Pass,
            "PASS_WITH_WARNINGS" => SuiteRunStatus::PassWithWarnings,
            "PENDING" => SuiteRunStatus::Pending,
            "RUNNING" => SuiteRunStatus::Running,
            "STOPPED" => SuiteRunStatus::Stopped,
            "STOPPING" => SuiteRunStatus::Stopping,
            other => SuiteRunStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SuiteRunStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SuiteRunStatus::from(s))
    }
}
impl SuiteRunStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SuiteRunStatus::Canceled => "CANCELED",
            SuiteRunStatus::Error => "ERROR",
            SuiteRunStatus::Fail => "FAIL",
            SuiteRunStatus::Pass => "PASS",
            SuiteRunStatus::PassWithWarnings => "PASS_WITH_WARNINGS",
            SuiteRunStatus::Pending => "PENDING",
            SuiteRunStatus::Running => "RUNNING",
            SuiteRunStatus::Stopped => "STOPPED",
            SuiteRunStatus::Stopping => "STOPPING",
            SuiteRunStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "ERROR",
            "FAIL",
            "PASS",
            "PASS_WITH_WARNINGS",
            "PENDING",
            "RUNNING",
            "STOPPED",
            "STOPPING",
        ]
    }
}
impl AsRef<str> for SuiteRunStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the suite definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuiteDefinitionInformation {
    /// <p>Suite definition Id of the test suite.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite name of the test suite.</p>
    pub suite_definition_name: std::option::Option<std::string::String>,
    /// <p>Specifies the devices under test for the test suite.</p>
    pub default_devices: std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
    /// <p>Specifies if the test suite is intended for qualification.</p>
    pub intended_for_qualification: bool,
    /// <p>Date (in Unix epoch time) when the test suite was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl SuiteDefinitionInformation {
    /// <p>Suite definition Id of the test suite.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite name of the test suite.</p>
    pub fn suite_definition_name(&self) -> std::option::Option<&str> {
        self.suite_definition_name.as_deref()
    }
    /// <p>Specifies the devices under test for the test suite.</p>
    pub fn default_devices(&self) -> std::option::Option<&[crate::model::DeviceUnderTest]> {
        self.default_devices.as_deref()
    }
    /// <p>Specifies if the test suite is intended for qualification.</p>
    pub fn intended_for_qualification(&self) -> bool {
        self.intended_for_qualification
    }
    /// <p>Date (in Unix epoch time) when the test suite was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for SuiteDefinitionInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuiteDefinitionInformation");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_name", &self.suite_definition_name);
        formatter.field("default_devices", &self.default_devices);
        formatter.field(
            "intended_for_qualification",
            &self.intended_for_qualification,
        );
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`SuiteDefinitionInformation`](crate::model::SuiteDefinitionInformation)
pub mod suite_definition_information {
    /// A builder for [`SuiteDefinitionInformation`](crate::model::SuiteDefinitionInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_name: std::option::Option<std::string::String>,
        pub(crate) default_devices:
            std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
        pub(crate) intended_for_qualification: std::option::Option<bool>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite name of the test suite.</p>
        pub fn suite_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_name = Some(input.into());
            self
        }
        /// <p>Suite name of the test suite.</p>
        pub fn set_suite_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_name = input;
            self
        }
        /// Appends an item to `default_devices`.
        ///
        /// To override the contents of this collection use [`set_default_devices`](Self::set_default_devices).
        ///
        /// <p>Specifies the devices under test for the test suite.</p>
        pub fn default_devices(mut self, input: impl Into<crate::model::DeviceUnderTest>) -> Self {
            let mut v = self.default_devices.unwrap_or_default();
            v.push(input.into());
            self.default_devices = Some(v);
            self
        }
        /// <p>Specifies the devices under test for the test suite.</p>
        pub fn set_default_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceUnderTest>>,
        ) -> Self {
            self.default_devices = input;
            self
        }
        /// <p>Specifies if the test suite is intended for qualification.</p>
        pub fn intended_for_qualification(mut self, input: bool) -> Self {
            self.intended_for_qualification = Some(input);
            self
        }
        /// <p>Specifies if the test suite is intended for qualification.</p>
        pub fn set_intended_for_qualification(mut self, input: std::option::Option<bool>) -> Self {
            self.intended_for_qualification = input;
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Date (in Unix epoch time) when the test suite was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SuiteDefinitionInformation`](crate::model::SuiteDefinitionInformation)
        pub fn build(self) -> crate::model::SuiteDefinitionInformation {
            crate::model::SuiteDefinitionInformation {
                suite_definition_id: self.suite_definition_id,
                suite_definition_name: self.suite_definition_name,
                default_devices: self.default_devices,
                intended_for_qualification: self.intended_for_qualification.unwrap_or_default(),
                created_at: self.created_at,
            }
        }
    }
}
impl SuiteDefinitionInformation {
    /// Creates a new builder-style object to manufacture [`SuiteDefinitionInformation`](crate::model::SuiteDefinitionInformation)
    pub fn builder() -> crate::model::suite_definition_information::Builder {
        crate::model::suite_definition_information::Builder::default()
    }
}

/// <p>Show each group result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestResult {
    /// <p>Show each group of test results.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupResult>>,
}
impl TestResult {
    /// <p>Show each group of test results.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::GroupResult]> {
        self.groups.as_deref()
    }
}
impl std::fmt::Debug for TestResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestResult");
        formatter.field("groups", &self.groups);
        formatter.finish()
    }
}
/// See [`TestResult`](crate::model::TestResult)
pub mod test_result {
    /// A builder for [`TestResult`](crate::model::TestResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupResult>>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>Show each group of test results.</p>
        pub fn groups(mut self, input: impl Into<crate::model::GroupResult>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>Show each group of test results.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupResult>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Consumes the builder and constructs a [`TestResult`](crate::model::TestResult)
        pub fn build(self) -> crate::model::TestResult {
            crate::model::TestResult {
                groups: self.groups,
            }
        }
    }
}
impl TestResult {
    /// Creates a new builder-style object to manufacture [`TestResult`](crate::model::TestResult)
    pub fn builder() -> crate::model::test_result::Builder {
        crate::model::test_result::Builder::default()
    }
}

/// <p>Show Group Result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupResult {
    /// <p>Group result Id.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>Group Result Name.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>Tests under Group Result.</p>
    pub tests: std::option::Option<std::vec::Vec<crate::model::TestCaseRun>>,
}
impl GroupResult {
    /// <p>Group result Id.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>Group Result Name.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>Tests under Group Result.</p>
    pub fn tests(&self) -> std::option::Option<&[crate::model::TestCaseRun]> {
        self.tests.as_deref()
    }
}
impl std::fmt::Debug for GroupResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupResult");
        formatter.field("group_id", &self.group_id);
        formatter.field("group_name", &self.group_name);
        formatter.field("tests", &self.tests);
        formatter.finish()
    }
}
/// See [`GroupResult`](crate::model::GroupResult)
pub mod group_result {
    /// A builder for [`GroupResult`](crate::model::GroupResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) tests: std::option::Option<std::vec::Vec<crate::model::TestCaseRun>>,
    }
    impl Builder {
        /// <p>Group result Id.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>Group result Id.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>Group Result Name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Group Result Name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Appends an item to `tests`.
        ///
        /// To override the contents of this collection use [`set_tests`](Self::set_tests).
        ///
        /// <p>Tests under Group Result.</p>
        pub fn tests(mut self, input: impl Into<crate::model::TestCaseRun>) -> Self {
            let mut v = self.tests.unwrap_or_default();
            v.push(input.into());
            self.tests = Some(v);
            self
        }
        /// <p>Tests under Group Result.</p>
        pub fn set_tests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestCaseRun>>,
        ) -> Self {
            self.tests = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupResult`](crate::model::GroupResult)
        pub fn build(self) -> crate::model::GroupResult {
            crate::model::GroupResult {
                group_id: self.group_id,
                group_name: self.group_name,
                tests: self.tests,
            }
        }
    }
}
impl GroupResult {
    /// Creates a new builder-style object to manufacture [`GroupResult`](crate::model::GroupResult)
    pub fn builder() -> crate::model::group_result::Builder {
        crate::model::group_result::Builder::default()
    }
}

/// <p>Provides test case run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestCaseRun {
    /// <p>Provides test case run Id.</p>
    pub test_case_run_id: std::option::Option<std::string::String>,
    /// <p>Provides test case run definition Id.</p>
    pub test_case_definition_id: std::option::Option<std::string::String>,
    /// <p>Provides test case run definition Name.</p>
    pub test_case_definition_name: std::option::Option<std::string::String>,
    /// <p>Provides test case run status.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Provides test case run start time.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides test case run end time.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides test case run log Url.</p>
    pub log_url: std::option::Option<std::string::String>,
    /// <p>Provides test case run warnings.</p>
    pub warnings: std::option::Option<std::string::String>,
    /// <p>Provides test case run failure result.</p>
    pub failure: std::option::Option<std::string::String>,
}
impl TestCaseRun {
    /// <p>Provides test case run Id.</p>
    pub fn test_case_run_id(&self) -> std::option::Option<&str> {
        self.test_case_run_id.as_deref()
    }
    /// <p>Provides test case run definition Id.</p>
    pub fn test_case_definition_id(&self) -> std::option::Option<&str> {
        self.test_case_definition_id.as_deref()
    }
    /// <p>Provides test case run definition Name.</p>
    pub fn test_case_definition_name(&self) -> std::option::Option<&str> {
        self.test_case_definition_name.as_deref()
    }
    /// <p>Provides test case run status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>Provides test case run start time.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Provides test case run end time.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Provides test case run log Url.</p>
    pub fn log_url(&self) -> std::option::Option<&str> {
        self.log_url.as_deref()
    }
    /// <p>Provides test case run warnings.</p>
    pub fn warnings(&self) -> std::option::Option<&str> {
        self.warnings.as_deref()
    }
    /// <p>Provides test case run failure result.</p>
    pub fn failure(&self) -> std::option::Option<&str> {
        self.failure.as_deref()
    }
}
impl std::fmt::Debug for TestCaseRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestCaseRun");
        formatter.field("test_case_run_id", &self.test_case_run_id);
        formatter.field("test_case_definition_id", &self.test_case_definition_id);
        formatter.field("test_case_definition_name", &self.test_case_definition_name);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("log_url", &self.log_url);
        formatter.field("warnings", &self.warnings);
        formatter.field("failure", &self.failure);
        formatter.finish()
    }
}
/// See [`TestCaseRun`](crate::model::TestCaseRun)
pub mod test_case_run {
    /// A builder for [`TestCaseRun`](crate::model::TestCaseRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_case_run_id: std::option::Option<std::string::String>,
        pub(crate) test_case_definition_id: std::option::Option<std::string::String>,
        pub(crate) test_case_definition_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) log_url: std::option::Option<std::string::String>,
        pub(crate) warnings: std::option::Option<std::string::String>,
        pub(crate) failure: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides test case run Id.</p>
        pub fn test_case_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_case_run_id = Some(input.into());
            self
        }
        /// <p>Provides test case run Id.</p>
        pub fn set_test_case_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_case_run_id = input;
            self
        }
        /// <p>Provides test case run definition Id.</p>
        pub fn test_case_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_case_definition_id = Some(input.into());
            self
        }
        /// <p>Provides test case run definition Id.</p>
        pub fn set_test_case_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_case_definition_id = input;
            self
        }
        /// <p>Provides test case run definition Name.</p>
        pub fn test_case_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_case_definition_name = Some(input.into());
            self
        }
        /// <p>Provides test case run definition Name.</p>
        pub fn set_test_case_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_case_definition_name = input;
            self
        }
        /// <p>Provides test case run status.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Provides test case run status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides test case run start time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Provides test case run start time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Provides test case run end time.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Provides test case run end time.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Provides test case run log Url.</p>
        pub fn log_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_url = Some(input.into());
            self
        }
        /// <p>Provides test case run log Url.</p>
        pub fn set_log_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_url = input;
            self
        }
        /// <p>Provides test case run warnings.</p>
        pub fn warnings(mut self, input: impl Into<std::string::String>) -> Self {
            self.warnings = Some(input.into());
            self
        }
        /// <p>Provides test case run warnings.</p>
        pub fn set_warnings(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warnings = input;
            self
        }
        /// <p>Provides test case run failure result.</p>
        pub fn failure(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure = Some(input.into());
            self
        }
        /// <p>Provides test case run failure result.</p>
        pub fn set_failure(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure = input;
            self
        }
        /// Consumes the builder and constructs a [`TestCaseRun`](crate::model::TestCaseRun)
        pub fn build(self) -> crate::model::TestCaseRun {
            crate::model::TestCaseRun {
                test_case_run_id: self.test_case_run_id,
                test_case_definition_id: self.test_case_definition_id,
                test_case_definition_name: self.test_case_definition_name,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                log_url: self.log_url,
                warnings: self.warnings,
                failure: self.failure,
            }
        }
    }
}
impl TestCaseRun {
    /// Creates a new builder-style object to manufacture [`TestCaseRun`](crate::model::TestCaseRun)
    pub fn builder() -> crate::model::test_case_run::Builder {
        crate::model::test_case_run::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    #[allow(missing_docs)] // documentation missing in model
    Pass,
    #[allow(missing_docs)] // documentation missing in model
    PassWithWarnings,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => Status::Canceled,
            "ERROR" => Status::Error,
            "FAIL" => Status::Fail,
            "PASS" => Status::Pass,
            "PASS_WITH_WARNINGS" => Status::PassWithWarnings,
            "PENDING" => Status::Pending,
            "RUNNING" => Status::Running,
            "STOPPED" => Status::Stopped,
            "STOPPING" => Status::Stopping,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Canceled => "CANCELED",
            Status::Error => "ERROR",
            Status::Fail => "FAIL",
            Status::Pass => "PASS",
            Status::PassWithWarnings => "PASS_WITH_WARNINGS",
            Status::Pending => "PENDING",
            Status::Running => "RUNNING",
            Status::Stopped => "STOPPED",
            Status::Stopping => "STOPPING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "ERROR",
            "FAIL",
            "PASS",
            "PASS_WITH_WARNINGS",
            "PENDING",
            "RUNNING",
            "STOPPED",
            "STOPPING",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
