// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateSuiteDefinitionInput`](crate::input::CreateSuiteDefinitionInput)
pub mod create_suite_definition_input {
    /// A builder for [`CreateSuiteDefinitionInput`](crate::input::CreateSuiteDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_configuration:
            std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            input: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.suite_definition_configuration = Some(input);
            self
        }
        /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.suite_definition_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be attached to the suite definition.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSuiteDefinitionInput`](crate::input::CreateSuiteDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSuiteDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSuiteDefinitionInput {
                suite_definition_configuration: self.suite_definition_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSuiteDefinitionInputOperationOutputAlias = crate::operation::CreateSuiteDefinition;
#[doc(hidden)]
pub type CreateSuiteDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSuiteDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSuiteDefinition`](crate::operation::CreateSuiteDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSuiteDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSuiteDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/suiteDefinitions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSuiteDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSuiteDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_suite_definition(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSuiteDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSuiteDefinition",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSuiteDefinitionInput`](crate::input::CreateSuiteDefinitionInput)
    pub fn builder() -> crate::input::create_suite_definition_input::Builder {
        crate::input::create_suite_definition_input::Builder::default()
    }
}

/// See [`DeleteSuiteDefinitionInput`](crate::input::DeleteSuiteDefinitionInput)
pub mod delete_suite_definition_input {
    /// A builder for [`DeleteSuiteDefinitionInput`](crate::input::DeleteSuiteDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite to be deleted.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite to be deleted.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSuiteDefinitionInput`](crate::input::DeleteSuiteDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSuiteDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSuiteDefinitionInput {
                suite_definition_id: self.suite_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSuiteDefinitionInputOperationOutputAlias = crate::operation::DeleteSuiteDefinition;
#[doc(hidden)]
pub type DeleteSuiteDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSuiteDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSuiteDefinition`](crate::operation::DeleteSuiteDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSuiteDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSuiteDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.suite_definition_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_1, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}",
                suiteDefinitionId = suite_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSuiteDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSuiteDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSuiteDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSuiteDefinition",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSuiteDefinitionInput`](crate::input::DeleteSuiteDefinitionInput)
    pub fn builder() -> crate::input::delete_suite_definition_input::Builder {
        crate::input::delete_suite_definition_input::Builder::default()
    }
}

/// See [`GetSuiteDefinitionInput`](crate::input::GetSuiteDefinitionInput)
pub mod get_suite_definition_input {
    /// A builder for [`GetSuiteDefinitionInput`](crate::input::GetSuiteDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite to get.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite to get.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version of the test suite to get.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteDefinitionInput`](crate::input::GetSuiteDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSuiteDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSuiteDefinitionInput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_version: self.suite_definition_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSuiteDefinitionInputOperationOutputAlias = crate::operation::GetSuiteDefinition;
#[doc(hidden)]
pub type GetSuiteDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSuiteDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetSuiteDefinition`](crate::operation::GetSuiteDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSuiteDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSuiteDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.suite_definition_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_2, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}",
                suiteDefinitionId = suite_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetSuiteDefinitionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.suite_definition_version {
                query.push_kv(
                    "suiteDefinitionVersion",
                    &aws_smithy_http::query::fmt_string(&inner_3),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSuiteDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSuiteDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSuiteDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSuiteDefinition",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSuiteDefinitionInput`](crate::input::GetSuiteDefinitionInput)
    pub fn builder() -> crate::input::get_suite_definition_input::Builder {
        crate::input::get_suite_definition_input::Builder::default()
    }
}

/// See [`GetSuiteRunInput`](crate::input::GetSuiteRunInput)
pub mod get_suite_run_input {
    /// A builder for [`GetSuiteRunInput`](crate::input::GetSuiteRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Suite definition Id for the test suite run.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id for the test suite run.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite run Id for the test suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite run Id for the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteRunInput`](crate::input::GetSuiteRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSuiteRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSuiteRunInput {
                suite_definition_id: self.suite_definition_id,
                suite_run_id: self.suite_run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSuiteRunInputOperationOutputAlias = crate::operation::GetSuiteRun;
#[doc(hidden)]
pub type GetSuiteRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSuiteRunInput {
    /// Consumes the builder and constructs an Operation<[`GetSuiteRun`](crate::operation::GetSuiteRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSuiteRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSuiteRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.suite_definition_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_4, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.suite_run_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_run_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_run_id = aws_smithy_http::label::fmt_string(input_5, false);
            if suite_run_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_run_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}",
                suiteDefinitionId = suite_definition_id,
                suiteRunId = suite_run_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSuiteRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSuiteRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSuiteRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSuiteRun",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSuiteRunInput`](crate::input::GetSuiteRunInput)
    pub fn builder() -> crate::input::get_suite_run_input::Builder {
        crate::input::get_suite_run_input::Builder::default()
    }
}

/// See [`GetSuiteRunReportInput`](crate::input::GetSuiteRunReportInput)
pub mod get_suite_run_report_input {
    /// A builder for [`GetSuiteRunReportInput`](crate::input::GetSuiteRunReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite run Id of the test suite run.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite run Id of the test suite run.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuiteRunReportInput`](crate::input::GetSuiteRunReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSuiteRunReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSuiteRunReportInput {
                suite_definition_id: self.suite_definition_id,
                suite_run_id: self.suite_run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSuiteRunReportInputOperationOutputAlias = crate::operation::GetSuiteRunReport;
#[doc(hidden)]
pub type GetSuiteRunReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSuiteRunReportInput {
    /// Consumes the builder and constructs an Operation<[`GetSuiteRunReport`](crate::operation::GetSuiteRunReport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSuiteRunReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSuiteRunReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.suite_definition_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_6, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.suite_run_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_run_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_run_id = aws_smithy_http::label::fmt_string(input_7, false);
            if suite_run_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_run_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}/report",
                suiteDefinitionId = suite_definition_id,
                suiteRunId = suite_run_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSuiteRunReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSuiteRunReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSuiteRunReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSuiteRunReport",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSuiteRunReportInput`](crate::input::GetSuiteRunReportInput)
    pub fn builder() -> crate::input::get_suite_run_report_input::Builder {
        crate::input::get_suite_run_report_input::Builder::default()
    }
}

/// See [`ListSuiteDefinitionsInput`](crate::input::ListSuiteDefinitionsInput)
pub mod list_suite_definitions_input {
    /// A builder for [`ListSuiteDefinitionsInput`](crate::input::ListSuiteDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuiteDefinitionsInput`](crate::input::ListSuiteDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSuiteDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSuiteDefinitionsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSuiteDefinitionsInputOperationOutputAlias = crate::operation::ListSuiteDefinitions;
#[doc(hidden)]
pub type ListSuiteDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSuiteDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSuiteDefinitions`](crate::operation::ListSuiteDefinitions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSuiteDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSuiteDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/suiteDefinitions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSuiteDefinitionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSuiteDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSuiteDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSuiteDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSuiteDefinitions",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSuiteDefinitionsInput`](crate::input::ListSuiteDefinitionsInput)
    pub fn builder() -> crate::input::list_suite_definitions_input::Builder {
        crate::input::list_suite_definitions_input::Builder::default()
    }
}

/// See [`ListSuiteRunsInput`](crate::input::ListSuiteRunsInput)
pub mod list_suite_runs_input {
    /// A builder for [`ListSuiteRunsInput`](crate::input::ListSuiteRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return at once.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuiteRunsInput`](crate::input::ListSuiteRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSuiteRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSuiteRunsInput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_version: self.suite_definition_version,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSuiteRunsInputOperationOutputAlias = crate::operation::ListSuiteRuns;
#[doc(hidden)]
pub type ListSuiteRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSuiteRunsInput {
    /// Consumes the builder and constructs an Operation<[`ListSuiteRuns`](crate::operation::ListSuiteRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSuiteRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSuiteRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/suiteRuns").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSuiteRunsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.suite_definition_id {
                query.push_kv(
                    "suiteDefinitionId",
                    &aws_smithy_http::query::fmt_string(&inner_9),
                );
            }
            if let Some(inner_10) = &_input.suite_definition_version {
                query.push_kv(
                    "suiteDefinitionVersion",
                    &aws_smithy_http::query::fmt_string(&inner_10),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSuiteRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSuiteRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSuiteRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSuiteRuns",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSuiteRunsInput`](crate::input::ListSuiteRunsInput)
    pub fn builder() -> crate::input::list_suite_runs_input::Builder {
        crate::input::list_suite_runs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.resource_arn;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_12, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartSuiteRunInput`](crate::input::StartSuiteRunInput)
pub mod start_suite_run_input {
    /// A builder for [`StartSuiteRunInput`](crate::input::StartSuiteRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_version: std::option::Option<std::string::String>,
        pub(crate) suite_run_configuration:
            std::option::Option<crate::model::SuiteRunConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn suite_definition_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_version = Some(input.into());
            self
        }
        /// <p>Suite definition version of the test suite.</p>
        pub fn set_suite_definition_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_version = input;
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn suite_run_configuration(
            mut self,
            input: crate::model::SuiteRunConfiguration,
        ) -> Self {
            self.suite_run_configuration = Some(input);
            self
        }
        /// <p>Suite run configuration.</p>
        pub fn set_suite_run_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteRunConfiguration>,
        ) -> Self {
            self.suite_run_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the suite run.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be attached to the suite run.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSuiteRunInput`](crate::input::StartSuiteRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSuiteRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSuiteRunInput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_version: self.suite_definition_version,
                suite_run_configuration: self.suite_run_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSuiteRunInputOperationOutputAlias = crate::operation::StartSuiteRun;
#[doc(hidden)]
pub type StartSuiteRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSuiteRunInput {
    /// Consumes the builder and constructs an Operation<[`StartSuiteRun`](crate::operation::StartSuiteRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSuiteRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSuiteRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.suite_definition_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_13, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}/suiteRuns",
                suiteDefinitionId = suite_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSuiteRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSuiteRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_suite_run(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSuiteRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSuiteRun",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSuiteRunInput`](crate::input::StartSuiteRunInput)
    pub fn builder() -> crate::input::start_suite_run_input::Builder {
        crate::input::start_suite_run_input::Builder::default()
    }
}

/// See [`StopSuiteRunInput`](crate::input::StopSuiteRunInput)
pub mod stop_suite_run_input {
    /// A builder for [`StopSuiteRunInput`](crate::input::StopSuiteRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite run to be stopped.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite run to be stopped.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Suite run Id of the test suite run to be stopped.</p>
        pub fn suite_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_run_id = Some(input.into());
            self
        }
        /// <p>Suite run Id of the test suite run to be stopped.</p>
        pub fn set_suite_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suite_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopSuiteRunInput`](crate::input::StopSuiteRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopSuiteRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopSuiteRunInput {
                suite_definition_id: self.suite_definition_id,
                suite_run_id: self.suite_run_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopSuiteRunInputOperationOutputAlias = crate::operation::StopSuiteRun;
#[doc(hidden)]
pub type StopSuiteRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopSuiteRunInput {
    /// Consumes the builder and constructs an Operation<[`StopSuiteRun`](crate::operation::StopSuiteRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopSuiteRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopSuiteRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.suite_definition_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_14, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.suite_run_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_run_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_run_id = aws_smithy_http::label::fmt_string(input_15, false);
            if suite_run_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_run_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}/stop",
                suiteDefinitionId = suite_definition_id,
                suiteRunId = suite_run_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopSuiteRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopSuiteRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopSuiteRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopSuiteRun",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopSuiteRunInput`](crate::input::StopSuiteRunInput)
    pub fn builder() -> crate::input::stop_suite_run_input::Builder {
        crate::input::stop_suite_run_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.resource_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource ARN of an IoT Device Advisor resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.resource_arn;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_17, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.tag_keys {
                for inner_19 in inner_18 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_19));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateSuiteDefinitionInput`](crate::input::UpdateSuiteDefinitionInput)
pub mod update_suite_definition_input {
    /// A builder for [`UpdateSuiteDefinitionInput`](crate::input::UpdateSuiteDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suite_definition_id: std::option::Option<std::string::String>,
        pub(crate) suite_definition_configuration:
            std::option::Option<crate::model::SuiteDefinitionConfiguration>,
    }
    impl Builder {
        /// <p>Suite definition Id of the test suite to be updated.</p>
        pub fn suite_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.suite_definition_id = Some(input.into());
            self
        }
        /// <p>Suite definition Id of the test suite to be updated.</p>
        pub fn set_suite_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suite_definition_id = input;
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn suite_definition_configuration(
            mut self,
            input: crate::model::SuiteDefinitionConfiguration,
        ) -> Self {
            self.suite_definition_configuration = Some(input);
            self
        }
        /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
        pub fn set_suite_definition_configuration(
            mut self,
            input: std::option::Option<crate::model::SuiteDefinitionConfiguration>,
        ) -> Self {
            self.suite_definition_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSuiteDefinitionInput`](crate::input::UpdateSuiteDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSuiteDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSuiteDefinitionInput {
                suite_definition_id: self.suite_definition_id,
                suite_definition_configuration: self.suite_definition_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSuiteDefinitionInputOperationOutputAlias = crate::operation::UpdateSuiteDefinition;
#[doc(hidden)]
pub type UpdateSuiteDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSuiteDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSuiteDefinition`](crate::operation::UpdateSuiteDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSuiteDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSuiteDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.suite_definition_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "suite_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let suite_definition_id = aws_smithy_http::label::fmt_string(input_20, false);
            if suite_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "suite_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/suiteDefinitions/{suiteDefinitionId}",
                suiteDefinitionId = suite_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSuiteDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSuiteDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_suite_definition(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSuiteDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSuiteDefinition",
            "iotdeviceadvisor",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSuiteDefinitionInput`](crate::input::UpdateSuiteDefinitionInput)
    pub fn builder() -> crate::input::update_suite_definition_input::Builder {
        crate::input::update_suite_definition_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to be updated.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
    pub suite_definition_configuration:
        std::option::Option<crate::model::SuiteDefinitionConfiguration>,
}
impl UpdateSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to be updated.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Updates a Device Advisor test suite with suite definition configuration.</p>
    pub fn suite_definition_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SuiteDefinitionConfiguration> {
        self.suite_definition_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateSuiteDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSuiteDefinitionInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field(
            "suite_definition_configuration",
            &self.suite_definition_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource ARN of an IoT Device Advisor resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource ARN of an IoT Device Advisor resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>List of tag keys to remove from the IoT Device Advisor resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource ARN of an IoT Device Advisor resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The resource ARN of an IoT Device Advisor resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to be attached to the IoT Device Advisor resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopSuiteRunInput {
    /// <p>Suite definition Id of the test suite run to be stopped.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite run Id of the test suite run to be stopped.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
}
impl StopSuiteRunInput {
    /// <p>Suite definition Id of the test suite run to be stopped.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite run Id of the test suite run to be stopped.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
}
impl std::fmt::Debug for StopSuiteRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopSuiteRunInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSuiteRunInput {
    /// <p>Suite definition Id of the test suite.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite definition version of the test suite.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>Suite run configuration.</p>
    pub suite_run_configuration: std::option::Option<crate::model::SuiteRunConfiguration>,
    /// <p>The tags to be attached to the suite run.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartSuiteRunInput {
    /// <p>Suite definition Id of the test suite.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite definition version of the test suite.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>Suite run configuration.</p>
    pub fn suite_run_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SuiteRunConfiguration> {
        self.suite_run_configuration.as_ref()
    }
    /// <p>The tags to be attached to the suite run.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartSuiteRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSuiteRunInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("suite_run_configuration", &self.suite_run_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the IoT Device Advisor resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the IoT Device Advisor resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuiteRunsInput {
    /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return at once.</p>
    pub max_results: i32,
    /// <p>A token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuiteRunsInput {
    /// <p>Lists the test suite runs of the specified test suite based on suite definition Id.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Must be passed along with suiteDefinitionId. Lists the test suite runs of the specified test suite based on suite definition version.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
    /// <p>The maximum number of results to return at once.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>A token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuiteRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuiteRunsInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuiteDefinitionsInput {
    /// <p>The maximum number of results to return at once.</p>
    pub max_results: i32,
    /// <p>A token used to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuiteDefinitionsInput {
    /// <p>The maximum number of results to return at once.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>A token used to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuiteDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuiteDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteRunReportInput {
    /// <p>Suite definition Id of the test suite.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite run Id of the test suite run.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
}
impl GetSuiteRunReportInput {
    /// <p>Suite definition Id of the test suite.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite run Id of the test suite run.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
}
impl std::fmt::Debug for GetSuiteRunReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteRunReportInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteRunInput {
    /// <p>Suite definition Id for the test suite run.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite run Id for the test suite run.</p>
    pub suite_run_id: std::option::Option<std::string::String>,
}
impl GetSuiteRunInput {
    /// <p>Suite definition Id for the test suite run.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite run Id for the test suite run.</p>
    pub fn suite_run_id(&self) -> std::option::Option<&str> {
        self.suite_run_id.as_deref()
    }
}
impl std::fmt::Debug for GetSuiteRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteRunInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_run_id", &self.suite_run_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to get.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
    /// <p>Suite definition version of the test suite to get.</p>
    pub suite_definition_version: std::option::Option<std::string::String>,
}
impl GetSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to get.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
    /// <p>Suite definition version of the test suite to get.</p>
    pub fn suite_definition_version(&self) -> std::option::Option<&str> {
        self.suite_definition_version.as_deref()
    }
}
impl std::fmt::Debug for GetSuiteDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuiteDefinitionInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.field("suite_definition_version", &self.suite_definition_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to be deleted.</p>
    pub suite_definition_id: std::option::Option<std::string::String>,
}
impl DeleteSuiteDefinitionInput {
    /// <p>Suite definition Id of the test suite to be deleted.</p>
    pub fn suite_definition_id(&self) -> std::option::Option<&str> {
        self.suite_definition_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSuiteDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSuiteDefinitionInput");
        formatter.field("suite_definition_id", &self.suite_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSuiteDefinitionInput {
    /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
    pub suite_definition_configuration:
        std::option::Option<crate::model::SuiteDefinitionConfiguration>,
    /// <p>The tags to be attached to the suite definition.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateSuiteDefinitionInput {
    /// <p>Creates a Device Advisor test suite with suite definition configuration.</p>
    pub fn suite_definition_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SuiteDefinitionConfiguration> {
        self.suite_definition_configuration.as_ref()
    }
    /// <p>The tags to be attached to the suite definition.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateSuiteDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSuiteDefinitionInput");
        formatter.field(
            "suite_definition_configuration",
            &self.suite_definition_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
