// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThingShadowError {
    /// Kind of error that occurred.
    pub kind: DeleteThingShadowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThingShadowErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The document encoding is not supported.</p>
    UnsupportedDocumentEncodingException(crate::error::UnsupportedDocumentEncodingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThingShadowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThingShadowErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteThingShadowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThingShadowError {
    fn code(&self) -> Option<&str> {
        DeleteThingShadowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThingShadowError {
    /// Creates a new `DeleteThingShadowError`.
    pub fn new(kind: DeleteThingShadowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThingShadowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThingShadowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThingShadowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThingShadowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingShadowErrorKind::UnsupportedDocumentEncodingException`.
    pub fn is_unsupported_document_encoding_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingShadowErrorKind::UnsupportedDocumentEncodingException(_)
        )
    }
}
impl std::error::Error for DeleteThingShadowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThingShadowErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => {
                Some(_inner)
            }
            DeleteThingShadowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRetainedMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRetainedMessageError {
    /// Kind of error that occurred.
    pub kind: GetRetainedMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRetainedMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRetainedMessageErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRetainedMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRetainedMessageErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRetainedMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRetainedMessageError {
    fn code(&self) -> Option<&str> {
        GetRetainedMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRetainedMessageError {
    /// Creates a new `GetRetainedMessageError`.
    pub fn new(kind: GetRetainedMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRetainedMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRetainedMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRetainedMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRetainedMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRetainedMessageErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRetainedMessageErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetRetainedMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRetainedMessageErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRetainedMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetThingShadowError {
    /// Kind of error that occurred.
    pub kind: GetThingShadowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetThingShadowErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The document encoding is not supported.</p>
    UnsupportedDocumentEncodingException(crate::error::UnsupportedDocumentEncodingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetThingShadowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetThingShadowErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => _inner.fmt(f),
            GetThingShadowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetThingShadowError {
    fn code(&self) -> Option<&str> {
        GetThingShadowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetThingShadowError {
    /// Creates a new `GetThingShadowError`.
    pub fn new(kind: GetThingShadowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetThingShadowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetThingShadowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetThingShadowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetThingShadowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetThingShadowErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThingShadowErrorKind::UnsupportedDocumentEncodingException`.
    pub fn is_unsupported_document_encoding_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThingShadowErrorKind::UnsupportedDocumentEncodingException(_)
        )
    }
}
impl std::error::Error for GetThingShadowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetThingShadowErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetThingShadowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetThingShadowErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetThingShadowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetThingShadowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetThingShadowErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetThingShadowErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => Some(_inner),
            GetThingShadowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNamedShadowsForThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNamedShadowsForThingError {
    /// Kind of error that occurred.
    pub kind: ListNamedShadowsForThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNamedShadowsForThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNamedShadowsForThingErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNamedShadowsForThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNamedShadowsForThingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListNamedShadowsForThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNamedShadowsForThingError {
    fn code(&self) -> Option<&str> {
        ListNamedShadowsForThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNamedShadowsForThingError {
    /// Creates a new `ListNamedShadowsForThingError`.
    pub fn new(kind: ListNamedShadowsForThingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNamedShadowsForThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNamedShadowsForThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNamedShadowsForThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNamedShadowsForThingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamedShadowsForThingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedShadowsForThingErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListNamedShadowsForThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNamedShadowsForThingErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListNamedShadowsForThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRetainedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRetainedMessagesError {
    /// Kind of error that occurred.
    pub kind: ListRetainedMessagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRetainedMessages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRetainedMessagesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRetainedMessagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRetainedMessagesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListRetainedMessagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRetainedMessagesError {
    fn code(&self) -> Option<&str> {
        ListRetainedMessagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRetainedMessagesError {
    /// Creates a new `ListRetainedMessagesError`.
    pub fn new(kind: ListRetainedMessagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRetainedMessagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRetainedMessagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRetainedMessagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRetainedMessagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRetainedMessagesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRetainedMessagesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListRetainedMessagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRetainedMessagesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListRetainedMessagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Publish` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishError {
    /// Kind of error that occurred.
    pub kind: PublishErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Publish` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PublishErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PublishErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            PublishErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            PublishErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishError {
    fn code(&self) -> Option<&str> {
        PublishError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishError {
    /// Creates a new `PublishError`.
    pub fn new(kind: PublishErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PublishErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `PublishErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `PublishErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::MethodNotAllowedException(_))
    }
    /// Returns `true` if the error kind is `PublishErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for PublishError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishErrorKind::InternalFailureException(_inner) => Some(_inner),
            PublishErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PublishErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            PublishErrorKind::UnauthorizedException(_inner) => Some(_inner),
            PublishErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThingShadowError {
    /// Kind of error that occurred.
    pub kind: UpdateThingShadowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateThingShadow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThingShadowErrorKind {
    /// <p>The specified version does not match the version of the document.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified combination of HTTP verb and URI is not supported.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>The payload exceeds the maximum size allowed.</p>
    RequestEntityTooLargeException(crate::error::RequestEntityTooLargeException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The document encoding is not supported.</p>
    UnsupportedDocumentEncodingException(crate::error::UnsupportedDocumentEncodingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThingShadowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThingShadowErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::RequestEntityTooLargeException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateThingShadowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThingShadowError {
    fn code(&self) -> Option<&str> {
        UpdateThingShadowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThingShadowError {
    /// Creates a new `UpdateThingShadowError`.
    pub fn new(kind: UpdateThingShadowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThingShadowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThingShadowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThingShadowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThingShadowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateThingShadowErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::RequestEntityTooLargeException`.
    pub fn is_request_entity_too_large_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::RequestEntityTooLargeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThingShadowErrorKind::UnsupportedDocumentEncodingException`.
    pub fn is_unsupported_document_encoding_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThingShadowErrorKind::UnsupportedDocumentEncodingException(_)
        )
    }
}
impl std::error::Error for UpdateThingShadowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThingShadowErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::RequestEntityTooLargeException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateThingShadowErrorKind::UnsupportedDocumentEncodingException(_inner) => {
                Some(_inner)
            }
            UpdateThingShadowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The document encoding is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedDocumentEncodingException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedDocumentEncodingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedDocumentEncodingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedDocumentEncodingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedDocumentEncodingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedDocumentEncodingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedDocumentEncodingException {}
/// See [`UnsupportedDocumentEncodingException`](crate::error::UnsupportedDocumentEncodingException)
pub mod unsupported_document_encoding_exception {
    /// A builder for [`UnsupportedDocumentEncodingException`](crate::error::UnsupportedDocumentEncodingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedDocumentEncodingException`](crate::error::UnsupportedDocumentEncodingException)
        pub fn build(self) -> crate::error::UnsupportedDocumentEncodingException {
            crate::error::UnsupportedDocumentEncodingException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedDocumentEncodingException {
    /// Creates a new builder-style object to manufacture [`UnsupportedDocumentEncodingException`](crate::error::UnsupportedDocumentEncodingException)
    pub fn builder() -> crate::error::unsupported_document_encoding_exception::Builder {
        crate::error::unsupported_document_encoding_exception::Builder::default()
    }
}

/// <p>You are not authorized to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The rate exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The payload exceeds the maximum size allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestEntityTooLargeException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestEntityTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestEntityTooLargeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestEntityTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestEntityTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestEntityTooLargeException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestEntityTooLargeException {}
/// See [`RequestEntityTooLargeException`](crate::error::RequestEntityTooLargeException)
pub mod request_entity_too_large_exception {
    /// A builder for [`RequestEntityTooLargeException`](crate::error::RequestEntityTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestEntityTooLargeException`](crate::error::RequestEntityTooLargeException)
        pub fn build(self) -> crate::error::RequestEntityTooLargeException {
            crate::error::RequestEntityTooLargeException {
                message: self.message,
            }
        }
    }
}
impl RequestEntityTooLargeException {
    /// Creates a new builder-style object to manufacture [`RequestEntityTooLargeException`](crate::error::RequestEntityTooLargeException)
    pub fn builder() -> crate::error::request_entity_too_large_exception::Builder {
        crate::error::request_entity_too_large_exception::Builder::default()
    }
}

/// <p>The specified combination of HTTP verb and URI is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodNotAllowedException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodNotAllowedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MethodNotAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MethodNotAllowedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MethodNotAllowedException {}
/// See [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
pub mod method_not_allowed_exception {
    /// A builder for [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
        pub fn build(self) -> crate::error::MethodNotAllowedException {
            crate::error::MethodNotAllowedException {
                message: self.message,
            }
        }
    }
}
impl MethodNotAllowedException {
    /// Creates a new builder-style object to manufacture [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    pub fn builder() -> crate::error::method_not_allowed_exception::Builder {
        crate::error::method_not_allowed_exception::Builder::default()
    }
}

/// <p>The request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>An unexpected error has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>The specified version does not match the version of the document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The specified resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message for the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message for the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}
